/* valaarraycreationexpression.c generated by valac, the Vala compiler
 * generated from valaarraycreationexpression.vala, do not modify */

/* valaarraycreationexpression.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValaArrayCreationExpressionPrivate {
	gint _rank;
	ValaList* sizes;
	ValaDataType* _element_type;
	ValaInitializerList* _initializer_list;
};


static gpointer vala_array_creation_expression_parent_class = NULL;

#define VALA_ARRAY_CREATION_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpressionPrivate))
static void vala_array_creation_expression_real_accept_children (ValaCodeNode* base,
                                                          ValaCodeVisitor* visitor);
static void vala_array_creation_expression_real_accept (ValaCodeNode* base,
                                                 ValaCodeVisitor* visitor);
static gboolean vala_array_creation_expression_real_is_pure (ValaExpression* base);
static gboolean vala_array_creation_expression_real_is_accessible (ValaExpression* base,
                                                            ValaSymbol* sym);
static gchar* vala_array_creation_expression_real_to_string (ValaCodeNode* base);
static void vala_array_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                             ValaExpression* old_node,
                                                             ValaExpression* new_node);
static void vala_array_creation_expression_real_replace_type (ValaCodeNode* base,
                                                       ValaDataType* old_type,
                                                       ValaDataType* new_type);
static gint vala_array_creation_expression_create_sizes_from_initializer_list (ValaArrayCreationExpression* self,
                                                                        ValaCodeContext* context,
                                                                        ValaInitializerList* il,
                                                                        gint rank,
                                                                        ValaList* sl);
static gboolean vala_array_creation_expression_real_check (ValaCodeNode* base,
                                                    ValaCodeContext* context);
static void vala_array_creation_expression_real_emit (ValaCodeNode* base,
                                               ValaCodeGenerator* codegen);
static void vala_array_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                             ValaCollection* collection);
static void vala_array_creation_expression_finalize (ValaCodeNode * obj);


/**
 * Add a size expression.
 */
void
vala_array_creation_expression_append_size (ValaArrayCreationExpression* self,
                                            ValaExpression* size)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (size != NULL);
	_tmp0_ = self->priv->sizes;
	vala_collection_add ((ValaCollection*) _tmp0_, size);
	if (size != NULL) {
		vala_code_node_set_parent_node ((ValaCodeNode*) size, (ValaCodeNode*) self);
	}
}


/**
 * Get the sizes for all dimensions ascending from left to right.
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_array_creation_expression_get_sizes (ValaArrayCreationExpression* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sizes;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


ValaArrayCreationExpression*
vala_array_creation_expression_construct (GType object_type,
                                          ValaDataType* element_type,
                                          gint rank,
                                          ValaInitializerList* initializer_list,
                                          ValaSourceReference* source_reference)
{
	ValaArrayCreationExpression* self = NULL;
	g_return_val_if_fail (element_type != NULL, NULL);
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaArrayCreationExpression*) vala_expression_construct (object_type);
	vala_array_creation_expression_set_element_type (self, element_type);
	vala_array_creation_expression_set_rank (self, rank);
	vala_array_creation_expression_set_initializer_list (self, initializer_list);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaArrayCreationExpression*
vala_array_creation_expression_new (ValaDataType* element_type,
                                    gint rank,
                                    ValaInitializerList* initializer_list,
                                    ValaSourceReference* source_reference)
{
	return vala_array_creation_expression_construct (VALA_TYPE_ARRAY_CREATION_EXPRESSION, element_type, rank, initializer_list, source_reference);
}


static void
vala_array_creation_expression_real_accept_children (ValaCodeNode* base,
                                                     ValaCodeVisitor* visitor)
{
	ValaArrayCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaInitializerList* _tmp16_;
	ValaInitializerList* _tmp17_;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_array_creation_expression_get_element_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		_tmp2_ = vala_array_creation_expression_get_element_type (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _e_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _e_index = 0;
		_tmp4_ = self->priv->sizes;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_e_list = _tmp5_;
		_tmp6_ = _e_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_e_size = _tmp8_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			ValaExpression* e = NULL;
			ValaList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_;
			ValaExpression* _tmp15_;
			_tmp9_ = _e_index;
			_e_index = _tmp9_ + 1;
			_tmp10_ = _e_index;
			_tmp11_ = _e_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _e_list;
			_tmp13_ = _e_index;
			_tmp14_ = vala_list_get (_tmp12_, _tmp13_);
			e = (ValaExpression*) _tmp14_;
			_tmp15_ = e;
			vala_code_node_accept ((ValaCodeNode*) _tmp15_, visitor);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp16_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp17_ = _tmp16_;
	if (_tmp17_ != NULL) {
		ValaInitializerList* _tmp18_;
		ValaInitializerList* _tmp19_;
		_tmp18_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp19_ = _tmp18_;
		vala_code_node_accept ((ValaCodeNode*) _tmp19_, visitor);
	}
}


static void
vala_array_creation_expression_real_accept (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor)
{
	ValaArrayCreationExpression * self;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_array_creation_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static gboolean
vala_array_creation_expression_real_is_pure (ValaExpression* base)
{
	ValaArrayCreationExpression * self;
	gboolean result = FALSE;
	self = (ValaArrayCreationExpression*) base;
	result = FALSE;
	return result;
}


static gboolean
vala_array_creation_expression_real_is_accessible (ValaExpression* base,
                                                   ValaSymbol* sym)
{
	ValaArrayCreationExpression * self;
	gboolean result = FALSE;
	ValaInitializerList* _tmp12_;
	ValaInitializerList* _tmp13_;
	self = (ValaArrayCreationExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _e_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _e_index = 0;
		_tmp0_ = self->priv->sizes;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_e_list = _tmp1_;
		_tmp2_ = _e_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_e_size = _tmp4_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* e = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _e_index;
			_e_index = _tmp5_ + 1;
			_tmp6_ = _e_index;
			_tmp7_ = _e_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _e_list;
			_tmp9_ = _e_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			e = (ValaExpression*) _tmp10_;
			_tmp11_ = e;
			if (!vala_expression_is_accessible (_tmp11_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (e);
				_vala_iterable_unref0 (_e_list);
				return result;
			}
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp12_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaInitializerList* _tmp14_;
		ValaInitializerList* _tmp15_;
		_tmp14_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp15_ = _tmp14_;
		result = vala_expression_is_accessible ((ValaExpression*) _tmp15_, sym);
		return result;
	}
	result = TRUE;
	return result;
}


static gchar*
vala_array_creation_expression_real_to_string (ValaCodeNode* base)
{
	ValaArrayCreationExpression * self;
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean first = FALSE;
	GString* _tmp26_;
	ValaInitializerList* _tmp27_;
	ValaInitializerList* _tmp28_;
	GString* _tmp34_;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	self = (ValaArrayCreationExpression*) base;
	_tmp0_ = g_string_new ("new ");
	builder = _tmp0_;
	_tmp1_ = builder;
	_tmp2_ = vala_array_creation_expression_get_element_type (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_code_node_to_string ((ValaCodeNode*) _tmp3_);
	_tmp5_ = _tmp4_;
	g_string_append_printf (_tmp1_, "%s[", _tmp5_);
	_g_free0 (_tmp5_);
	first = TRUE;
	{
		ValaList* _size_list = NULL;
		ValaList* _tmp6_;
		ValaList* _tmp7_;
		gint _size_size = 0;
		ValaList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _size_index = 0;
		_tmp6_ = self->priv->sizes;
		_tmp7_ = _vala_iterable_ref0 (_tmp6_);
		_size_list = _tmp7_;
		_tmp8_ = _size_list;
		_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_size_size = _tmp10_;
		_size_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			ValaExpression* size = NULL;
			ValaList* _tmp14_;
			gint _tmp15_;
			gpointer _tmp16_;
			gboolean _tmp17_;
			_tmp11_ = _size_index;
			_size_index = _tmp11_ + 1;
			_tmp12_ = _size_index;
			_tmp13_ = _size_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _size_list;
			_tmp15_ = _size_index;
			_tmp16_ = vala_list_get (_tmp14_, _tmp15_);
			size = (ValaExpression*) _tmp16_;
			_tmp17_ = first;
			if (_tmp17_) {
				GString* _tmp18_;
				ValaExpression* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				_tmp18_ = builder;
				_tmp19_ = size;
				_tmp20_ = vala_code_node_to_string ((ValaCodeNode*) _tmp19_);
				_tmp21_ = _tmp20_;
				g_string_append (_tmp18_, _tmp21_);
				_g_free0 (_tmp21_);
				first = FALSE;
			} else {
				GString* _tmp22_;
				ValaExpression* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				_tmp22_ = builder;
				_tmp23_ = size;
				_tmp24_ = vala_code_node_to_string ((ValaCodeNode*) _tmp23_);
				_tmp25_ = _tmp24_;
				g_string_append_printf (_tmp22_, ", %s", _tmp25_);
				_g_free0 (_tmp25_);
			}
			_vala_code_node_unref0 (size);
		}
		_vala_iterable_unref0 (_size_list);
	}
	_tmp26_ = builder;
	g_string_append_c (_tmp26_, ']');
	_tmp27_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp28_ = _tmp27_;
	if (_tmp28_ != NULL) {
		GString* _tmp29_;
		ValaInitializerList* _tmp30_;
		ValaInitializerList* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		_tmp29_ = builder;
		_tmp30_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_code_node_to_string ((ValaCodeNode*) _tmp31_);
		_tmp33_ = _tmp32_;
		g_string_append (_tmp29_, _tmp33_);
		_g_free0 (_tmp33_);
	}
	_tmp34_ = builder;
	_tmp35_ = _tmp34_->str;
	_tmp36_ = g_strdup (_tmp35_);
	result = _tmp36_;
	_g_string_free0 (builder);
	return result;
}


static void
vala_array_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                        ValaExpression* old_node,
                                                        ValaExpression* new_node)
{
	ValaArrayCreationExpression * self;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ValaList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				ValaList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				ValaExpression* _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->sizes;
				_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->sizes;
				_tmp7_ = i;
				_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
				_tmp9_ = (ValaExpression*) _tmp8_;
				_tmp10_ = _tmp9_ == old_node;
				_vala_code_node_unref0 (_tmp9_);
				if (_tmp10_) {
					ValaList* _tmp11_;
					gint _tmp12_;
					_tmp11_ = self->priv->sizes;
					_tmp12_ = i;
					vala_list_set (_tmp11_, _tmp12_, new_node);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}


static void
vala_array_creation_expression_real_replace_type (ValaCodeNode* base,
                                                  ValaDataType* old_type,
                                                  ValaDataType* new_type)
{
	ValaArrayCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_array_creation_expression_get_element_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_array_creation_expression_set_element_type (self, new_type);
	}
}


static gint
vala_array_creation_expression_create_sizes_from_initializer_list (ValaArrayCreationExpression* self,
                                                                   ValaCodeContext* context,
                                                                   ValaInitializerList* il,
                                                                   gint rank,
                                                                   ValaList* sl)
{
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint subsize = 0;
	gint _tmp45_;
	gint _tmp46_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (context != NULL, 0);
	g_return_val_if_fail (il != NULL, 0);
	g_return_val_if_fail (sl != NULL, 0);
	_tmp0_ = vala_collection_get_size ((ValaCollection*) sl);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_rank;
	if (_tmp1_ == (_tmp2_ - rank)) {
		ValaIntegerLiteral* init = NULL;
		gint _tmp3_;
		gint _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaSourceReference* _tmp8_;
		ValaIntegerLiteral* _tmp9_;
		ValaIntegerLiteral* _tmp10_;
		ValaIntegerLiteral* _tmp11_;
		ValaIntegerLiteral* _tmp12_;
		_tmp3_ = vala_initializer_list_get_size (il);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("%i", _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_code_node_get_source_reference ((ValaCodeNode*) il);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_integer_literal_new (_tmp6_, _tmp8_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp6_);
		init = _tmp10_;
		_tmp11_ = init;
		vala_code_node_check ((ValaCodeNode*) _tmp11_, context);
		_tmp12_ = init;
		vala_collection_add ((ValaCollection*) sl, (ValaLiteral*) _tmp12_);
		_vala_code_node_unref0 (init);
	}
	subsize = -1;
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp13_;
		gint _e_size = 0;
		ValaList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _e_index = 0;
		_tmp13_ = vala_initializer_list_get_initializers (il);
		_e_list = _tmp13_;
		_tmp14_ = _e_list;
		_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_e_size = _tmp16_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			ValaExpression* e = NULL;
			ValaList* _tmp20_;
			gint _tmp21_;
			gpointer _tmp22_;
			ValaExpression* _tmp23_;
			_tmp17_ = _e_index;
			_e_index = _tmp17_ + 1;
			_tmp18_ = _e_index;
			_tmp19_ = _e_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _e_list;
			_tmp21_ = _e_index;
			_tmp22_ = vala_list_get (_tmp20_, _tmp21_);
			e = (ValaExpression*) _tmp22_;
			_tmp23_ = e;
			if (VALA_IS_INITIALIZER_LIST (_tmp23_)) {
				gint size = 0;
				ValaExpression* _tmp28_;
				gint _tmp29_;
				gboolean _tmp30_ = FALSE;
				gint _tmp31_;
				if (rank == 1) {
					ValaExpression* _tmp24_;
					ValaExpression* _tmp25_;
					ValaSourceReference* _tmp26_;
					ValaSourceReference* _tmp27_;
					vala_code_node_set_error ((ValaCodeNode*) il, TRUE);
					_tmp24_ = e;
					vala_code_node_set_error ((ValaCodeNode*) _tmp24_, TRUE);
					_tmp25_ = e;
					_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp25_);
					_tmp27_ = _tmp26_;
					vala_report_error (_tmp27_, "Expected array element, got array initializer list");
					result = -1;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					return result;
				}
				_tmp28_ = e;
				size = vala_array_creation_expression_create_sizes_from_initializer_list (self, context, G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList), rank - 1, sl);
				_tmp29_ = size;
				if (_tmp29_ == -1) {
					result = -1;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					return result;
				}
				_tmp31_ = subsize;
				if (_tmp31_ >= 0) {
					gint _tmp32_;
					gint _tmp33_;
					_tmp32_ = subsize;
					_tmp33_ = size;
					_tmp30_ = _tmp32_ != _tmp33_;
				} else {
					_tmp30_ = FALSE;
				}
				if (_tmp30_) {
					ValaSourceReference* _tmp34_;
					ValaSourceReference* _tmp35_;
					gint _tmp36_;
					gint _tmp37_;
					gchar* _tmp38_;
					gchar* _tmp39_;
					vala_code_node_set_error ((ValaCodeNode*) il, TRUE);
					_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) il);
					_tmp35_ = _tmp34_;
					_tmp36_ = subsize;
					_tmp37_ = size;
					_tmp38_ = g_strdup_printf ("Expected initializer list of size %d, got size %d", _tmp36_, _tmp37_);
					_tmp39_ = _tmp38_;
					vala_report_error (_tmp35_, _tmp39_);
					_g_free0 (_tmp39_);
					result = -1;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					return result;
				} else {
					gint _tmp40_;
					_tmp40_ = size;
					subsize = _tmp40_;
				}
			} else {
				if (rank != 1) {
					ValaExpression* _tmp41_;
					ValaExpression* _tmp42_;
					ValaSourceReference* _tmp43_;
					ValaSourceReference* _tmp44_;
					vala_code_node_set_error ((ValaCodeNode*) il, TRUE);
					_tmp41_ = e;
					vala_code_node_set_error ((ValaCodeNode*) _tmp41_, TRUE);
					_tmp42_ = e;
					_tmp43_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp42_);
					_tmp44_ = _tmp43_;
					vala_report_error (_tmp44_, "Expected array initializer list, got array element");
					result = -1;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					return result;
				}
			}
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp45_ = vala_initializer_list_get_size (il);
	_tmp46_ = _tmp45_;
	result = _tmp46_;
	return result;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_array_creation_expression_real_check (ValaCodeNode* base,
                                           ValaCodeContext* context)
{
	ValaArrayCreationExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaList* sizes = NULL;
	ValaList* _tmp4_;
	ValaInitializerList* initlist = NULL;
	ValaInitializerList* _tmp5_;
	ValaInitializerList* _tmp6_;
	ValaInitializerList* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaArrayList* calc_sizes = NULL;
	GEqualFunc _tmp24_;
	ValaArrayList* _tmp25_;
	ValaInitializerList* _tmp26_;
	ValaList* _tmp64_;
	gint _tmp65_;
	gint _tmp66_;
	gboolean _tmp106_;
	gboolean _tmp107_;
	gboolean _tmp108_ = FALSE;
	ValaInitializerList* _tmp109_;
	ValaInitializerList* _tmp110_;
	ValaDataType* _tmp115_;
	ValaDataType* _tmp116_;
	ValaDataType* _tmp119_;
	ValaDataType* _tmp120_;
	gint _tmp121_;
	ValaSourceReference* _tmp122_;
	ValaSourceReference* _tmp123_;
	ValaArrayType* _tmp124_;
	ValaArrayType* _tmp125_;
	ValaDataType* _tmp126_;
	ValaDataType* _tmp127_;
	ValaDataType* _tmp128_;
	ValaDataType* _tmp129_;
	gboolean _tmp130_;
	gboolean _tmp131_;
	self = (ValaArrayCreationExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_array_creation_expression_get_sizes (self);
	sizes = _tmp4_;
	_tmp5_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = _vala_code_node_ref0 (_tmp6_);
	initlist = _tmp7_;
	_tmp8_ = vala_array_creation_expression_get_element_type (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != NULL) {
		ValaDataType* _tmp10_;
		ValaDataType* _tmp11_;
		_tmp10_ = vala_array_creation_expression_get_element_type (self);
		_tmp11_ = _tmp10_;
		vala_code_node_check ((ValaCodeNode*) _tmp11_, context);
	}
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp12_;
		ValaList* _tmp13_;
		gint _e_size = 0;
		ValaList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _e_index = 0;
		_tmp12_ = sizes;
		_tmp13_ = _vala_iterable_ref0 (_tmp12_);
		_e_list = _tmp13_;
		_tmp14_ = _e_list;
		_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_e_size = _tmp16_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			ValaExpression* e = NULL;
			ValaList* _tmp20_;
			gint _tmp21_;
			gpointer _tmp22_;
			ValaExpression* _tmp23_;
			_tmp17_ = _e_index;
			_e_index = _tmp17_ + 1;
			_tmp18_ = _e_index;
			_tmp19_ = _e_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _e_list;
			_tmp21_ = _e_index;
			_tmp22_ = vala_list_get (_tmp20_, _tmp21_);
			e = (ValaExpression*) _tmp22_;
			_tmp23_ = e;
			vala_code_node_check ((ValaCodeNode*) _tmp23_, context);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp24_ = g_direct_equal;
	_tmp25_ = vala_array_list_new (VALA_TYPE_LITERAL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp24_);
	calc_sizes = _tmp25_;
	_tmp26_ = initlist;
	if (_tmp26_ != NULL) {
		ValaInitializerList* _tmp27_;
		ValaDataType* _tmp28_;
		ValaDataType* _tmp29_;
		gint _tmp30_;
		ValaSourceReference* _tmp31_;
		ValaSourceReference* _tmp32_;
		ValaArrayType* _tmp33_;
		ValaArrayType* _tmp34_;
		ValaInitializerList* _tmp35_;
		gint ret = 0;
		ValaInitializerList* _tmp36_;
		gint _tmp37_;
		ValaArrayList* _tmp38_;
		gint _tmp39_;
		ValaArrayList* _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		gint _tmp43_;
		_tmp27_ = initlist;
		_tmp28_ = vala_array_creation_expression_get_element_type (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = self->priv->_rank;
		_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp32_ = _tmp31_;
		_tmp33_ = vala_array_type_new (_tmp29_, _tmp30_, _tmp32_);
		_tmp34_ = _tmp33_;
		vala_expression_set_target_type ((ValaExpression*) _tmp27_, (ValaDataType*) _tmp34_);
		_vala_code_node_unref0 (_tmp34_);
		_tmp35_ = initlist;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp35_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		}
		_tmp36_ = initlist;
		_tmp37_ = self->priv->_rank;
		_tmp38_ = calc_sizes;
		ret = vala_array_creation_expression_create_sizes_from_initializer_list (self, context, _tmp36_, _tmp37_, (ValaList*) _tmp38_);
		_tmp39_ = ret;
		if (_tmp39_ == -1) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		}
		_tmp40_ = calc_sizes;
		_tmp41_ = vala_collection_get_size ((ValaCollection*) _tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = self->priv->_rank;
		if (_tmp42_ != _tmp43_) {
			ValaArrayType* actual_type = NULL;
			ValaDataType* _tmp44_;
			ValaDataType* _tmp45_;
			ValaArrayList* _tmp46_;
			gint _tmp47_;
			gint _tmp48_;
			ValaSourceReference* _tmp49_;
			ValaSourceReference* _tmp50_;
			ValaArrayType* _tmp51_;
			ValaInitializerList* _tmp52_;
			ValaSourceReference* _tmp53_;
			ValaSourceReference* _tmp54_;
			ValaDataType* _tmp55_;
			ValaDataType* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			ValaArrayType* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp44_ = vala_array_creation_expression_get_element_type (self);
			_tmp45_ = _tmp44_;
			_tmp46_ = calc_sizes;
			_tmp47_ = vala_collection_get_size ((ValaCollection*) _tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp50_ = _tmp49_;
			_tmp51_ = vala_array_type_new (_tmp45_, _tmp48_, _tmp50_);
			actual_type = _tmp51_;
			_tmp52_ = initlist;
			_tmp53_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp52_);
			_tmp54_ = _tmp53_;
			_tmp55_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp56_ = _tmp55_;
			_tmp57_ = vala_code_node_to_string ((ValaCodeNode*) _tmp56_);
			_tmp58_ = _tmp57_;
			_tmp59_ = actual_type;
			_tmp60_ = vala_code_node_to_string ((ValaCodeNode*) _tmp59_);
			_tmp61_ = _tmp60_;
			_tmp62_ = g_strdup_printf ("Expected initializer for `%s' but got `%s'", _tmp58_, _tmp61_);
			_tmp63_ = _tmp62_;
			vala_report_error (_tmp54_, _tmp63_);
			_g_free0 (_tmp63_);
			_g_free0 (_tmp61_);
			_g_free0 (_tmp58_);
			_vala_code_node_unref0 (actual_type);
		}
	}
	_tmp64_ = sizes;
	_tmp65_ = vala_collection_get_size ((ValaCollection*) _tmp64_);
	_tmp66_ = _tmp65_;
	if (_tmp66_ > 0) {
		{
			ValaList* _e_list = NULL;
			ValaList* _tmp67_;
			ValaList* _tmp68_;
			gint _e_size = 0;
			ValaList* _tmp69_;
			gint _tmp70_;
			gint _tmp71_;
			gint _e_index = 0;
			_tmp67_ = sizes;
			_tmp68_ = _vala_iterable_ref0 (_tmp67_);
			_e_list = _tmp68_;
			_tmp69_ = _e_list;
			_tmp70_ = vala_collection_get_size ((ValaCollection*) _tmp69_);
			_tmp71_ = _tmp70_;
			_e_size = _tmp71_;
			_e_index = -1;
			while (TRUE) {
				gint _tmp72_;
				gint _tmp73_;
				gint _tmp74_;
				ValaExpression* e = NULL;
				ValaList* _tmp75_;
				gint _tmp76_;
				gpointer _tmp77_;
				ValaExpression* _tmp78_;
				ValaDataType* _tmp79_;
				ValaDataType* _tmp80_;
				_tmp72_ = _e_index;
				_e_index = _tmp72_ + 1;
				_tmp73_ = _e_index;
				_tmp74_ = _e_size;
				if (!(_tmp73_ < _tmp74_)) {
					break;
				}
				_tmp75_ = _e_list;
				_tmp76_ = _e_index;
				_tmp77_ = vala_list_get (_tmp75_, _tmp76_);
				e = (ValaExpression*) _tmp77_;
				_tmp78_ = e;
				_tmp79_ = vala_expression_get_value_type (_tmp78_);
				_tmp80_ = _tmp79_;
				if (_tmp80_ == NULL) {
					result = FALSE;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					_vala_iterable_unref0 (calc_sizes);
					_vala_code_node_unref0 (initlist);
					_vala_iterable_unref0 (sizes);
					return result;
				} else {
					gboolean _tmp81_ = FALSE;
					ValaExpression* _tmp82_;
					ValaDataType* _tmp83_;
					ValaDataType* _tmp84_;
					_tmp82_ = e;
					_tmp83_ = vala_expression_get_value_type (_tmp82_);
					_tmp84_ = _tmp83_;
					if (VALA_IS_INTEGER_TYPE (_tmp84_)) {
						_tmp81_ = TRUE;
					} else {
						ValaExpression* _tmp85_;
						ValaDataType* _tmp86_;
						ValaDataType* _tmp87_;
						_tmp85_ = e;
						_tmp86_ = vala_expression_get_value_type (_tmp85_);
						_tmp87_ = _tmp86_;
						_tmp81_ = VALA_IS_ENUM_VALUE_TYPE (_tmp87_);
					}
					if (!_tmp81_) {
						ValaExpression* _tmp88_;
						ValaSourceReference* _tmp89_;
						ValaSourceReference* _tmp90_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp88_ = e;
						_tmp89_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp88_);
						_tmp90_ = _tmp89_;
						vala_report_error (_tmp90_, "Expression of integer type expected");
					}
				}
				_vala_code_node_unref0 (e);
			}
			_vala_iterable_unref0 (_e_list);
		}
	} else {
		ValaInitializerList* _tmp91_;
		_tmp91_ = initlist;
		if (_tmp91_ == NULL) {
			ValaSourceReference* _tmp92_;
			ValaSourceReference* _tmp93_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp92_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp93_ = _tmp92_;
			vala_report_error (_tmp93_, "internal error: initializer list expected");
		} else {
			{
				ValaArrayList* _size_list = NULL;
				ValaArrayList* _tmp94_;
				ValaArrayList* _tmp95_;
				gint _size_size = 0;
				ValaArrayList* _tmp96_;
				gint _tmp97_;
				gint _tmp98_;
				gint _size_index = 0;
				_tmp94_ = calc_sizes;
				_tmp95_ = _vala_iterable_ref0 (_tmp94_);
				_size_list = _tmp95_;
				_tmp96_ = _size_list;
				_tmp97_ = vala_collection_get_size ((ValaCollection*) _tmp96_);
				_tmp98_ = _tmp97_;
				_size_size = _tmp98_;
				_size_index = -1;
				while (TRUE) {
					gint _tmp99_;
					gint _tmp100_;
					gint _tmp101_;
					ValaExpression* size = NULL;
					ValaArrayList* _tmp102_;
					gint _tmp103_;
					gpointer _tmp104_;
					ValaExpression* _tmp105_;
					_tmp99_ = _size_index;
					_size_index = _tmp99_ + 1;
					_tmp100_ = _size_index;
					_tmp101_ = _size_size;
					if (!(_tmp100_ < _tmp101_)) {
						break;
					}
					_tmp102_ = _size_list;
					_tmp103_ = _size_index;
					_tmp104_ = vala_list_get ((ValaList*) _tmp102_, _tmp103_);
					size = (ValaExpression*) ((ValaLiteral*) _tmp104_);
					_tmp105_ = size;
					vala_array_creation_expression_append_size (self, _tmp105_);
					_vala_code_node_unref0 (size);
				}
				_vala_iterable_unref0 (_size_list);
			}
		}
	}
	_tmp106_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp107_ = _tmp106_;
	if (_tmp107_) {
		result = FALSE;
		_vala_iterable_unref0 (calc_sizes);
		_vala_code_node_unref0 (initlist);
		_vala_iterable_unref0 (sizes);
		return result;
	}
	_tmp109_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp110_ = _tmp109_;
	if (_tmp110_ != NULL) {
		ValaInitializerList* _tmp111_;
		ValaInitializerList* _tmp112_;
		ValaDataType* _tmp113_;
		ValaDataType* _tmp114_;
		_tmp111_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp112_ = _tmp111_;
		_tmp113_ = vala_expression_get_value_type ((ValaExpression*) _tmp112_);
		_tmp114_ = _tmp113_;
		_tmp108_ = _tmp114_ == NULL;
	} else {
		_tmp108_ = FALSE;
	}
	if (_tmp108_) {
		result = FALSE;
		_vala_iterable_unref0 (calc_sizes);
		_vala_code_node_unref0 (initlist);
		_vala_iterable_unref0 (sizes);
		return result;
	}
	_tmp115_ = vala_array_creation_expression_get_element_type (self);
	_tmp116_ = _tmp115_;
	if (_tmp116_ == NULL) {
		ValaSourceReference* _tmp117_;
		ValaSourceReference* _tmp118_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp117_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp118_ = _tmp117_;
		vala_report_error (_tmp118_, "Cannot determine the element type of the created array");
		result = FALSE;
		_vala_iterable_unref0 (calc_sizes);
		_vala_code_node_unref0 (initlist);
		_vala_iterable_unref0 (sizes);
		return result;
	}
	_tmp119_ = vala_array_creation_expression_get_element_type (self);
	_tmp120_ = _tmp119_;
	_tmp121_ = self->priv->_rank;
	_tmp122_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp123_ = _tmp122_;
	_tmp124_ = vala_array_type_new (_tmp120_, _tmp121_, _tmp123_);
	_tmp125_ = _tmp124_;
	vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp125_);
	_vala_code_node_unref0 (_tmp125_);
	_tmp126_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp127_ = _tmp126_;
	vala_data_type_set_value_owned (_tmp127_, TRUE);
	_tmp128_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp129_ = _tmp128_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp129_, context)) {
		result = FALSE;
		_vala_iterable_unref0 (calc_sizes);
		_vala_code_node_unref0 (initlist);
		_vala_iterable_unref0 (sizes);
		return result;
	}
	_tmp130_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp131_ = _tmp130_;
	result = !_tmp131_;
	_vala_iterable_unref0 (calc_sizes);
	_vala_code_node_unref0 (initlist);
	_vala_iterable_unref0 (sizes);
	return result;
}


static void
vala_array_creation_expression_real_emit (ValaCodeNode* base,
                                          ValaCodeGenerator* codegen)
{
	ValaArrayCreationExpression * self;
	ValaInitializerList* _tmp12_;
	ValaInitializerList* _tmp13_;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _e_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _e_index = 0;
		_tmp0_ = self->priv->sizes;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_e_list = _tmp1_;
		_tmp2_ = _e_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_e_size = _tmp4_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* e = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _e_index;
			_e_index = _tmp5_ + 1;
			_tmp6_ = _e_index;
			_tmp7_ = _e_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _e_list;
			_tmp9_ = _e_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			e = (ValaExpression*) _tmp10_;
			_tmp11_ = e;
			vala_code_node_emit ((ValaCodeNode*) _tmp11_, codegen);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp12_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaInitializerList* _tmp14_;
		ValaInitializerList* _tmp15_;
		_tmp14_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp15_ = _tmp14_;
		vala_code_node_emit ((ValaCodeNode*) _tmp15_, codegen);
	}
	vala_code_visitor_visit_array_creation_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}


static void
vala_array_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                        ValaCollection* collection)
{
	ValaArrayCreationExpression * self;
	ValaInitializerList* _tmp12_;
	ValaInitializerList* _tmp13_;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _e_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _e_index = 0;
		_tmp0_ = self->priv->sizes;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_e_list = _tmp1_;
		_tmp2_ = _e_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_e_size = _tmp4_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* e = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _e_index;
			_e_index = _tmp5_ + 1;
			_tmp6_ = _e_index;
			_tmp7_ = _e_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _e_list;
			_tmp9_ = _e_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			e = (ValaExpression*) _tmp10_;
			_tmp11_ = e;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp11_, collection);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp12_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaInitializerList* _tmp14_;
		ValaInitializerList* _tmp15_;
		_tmp14_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp15_ = _tmp14_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp15_, collection);
	}
}


ValaDataType*
vala_array_creation_expression_get_element_type (ValaArrayCreationExpression* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_element_type;
	result = _tmp0_;
	return result;
}


void
vala_array_creation_expression_set_element_type (ValaArrayCreationExpression* self,
                                                 ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_element_type);
	self->priv->_element_type = _tmp0_;
	_tmp1_ = self->priv->_element_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


gint
vala_array_creation_expression_get_rank (ValaArrayCreationExpression* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_rank;
	result = _tmp0_;
	return result;
}


void
vala_array_creation_expression_set_rank (ValaArrayCreationExpression* self,
                                         gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_rank = value;
}


ValaInitializerList*
vala_array_creation_expression_get_initializer_list (ValaArrayCreationExpression* self)
{
	ValaInitializerList* result;
	ValaInitializerList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_initializer_list;
	result = _tmp0_;
	return result;
}


void
vala_array_creation_expression_set_initializer_list (ValaArrayCreationExpression* self,
                                                     ValaInitializerList* value)
{
	ValaInitializerList* _tmp0_;
	ValaInitializerList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_initializer_list);
	self->priv->_initializer_list = _tmp0_;
	_tmp1_ = self->priv->_initializer_list;
	if (_tmp1_ != NULL) {
		ValaInitializerList* _tmp2_;
		_tmp2_ = self->priv->_initializer_list;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}


static void
vala_array_creation_expression_class_init (ValaArrayCreationExpressionClass * klass)
{
	vala_array_creation_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_array_creation_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaArrayCreationExpressionPrivate));
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_array_creation_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_array_creation_expression_real_accept;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_array_creation_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_array_creation_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_array_creation_expression_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_array_creation_expression_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_array_creation_expression_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_array_creation_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_array_creation_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_array_creation_expression_real_get_used_variables;
}


static void
vala_array_creation_expression_instance_init (ValaArrayCreationExpression * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_ARRAY_CREATION_EXPRESSION_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->sizes = (ValaList*) _tmp1_;
}


static void
vala_array_creation_expression_finalize (ValaCodeNode * obj)
{
	ValaArrayCreationExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression);
	_vala_iterable_unref0 (self->priv->sizes);
	_vala_code_node_unref0 (self->priv->_element_type);
	_vala_code_node_unref0 (self->priv->_initializer_list);
	VALA_CODE_NODE_CLASS (vala_array_creation_expression_parent_class)->finalize (obj);
}


/**
 * Represents an array creation expression e.g. {{{ new int[] {1,2,3} }}}.
 */
GType
vala_array_creation_expression_get_type (void)
{
	static volatile gsize vala_array_creation_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_array_creation_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaArrayCreationExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_array_creation_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaArrayCreationExpression), 0, (GInstanceInitFunc) vala_array_creation_expression_instance_init, NULL };
		GType vala_array_creation_expression_type_id;
		vala_array_creation_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaArrayCreationExpression", &g_define_type_info, 0);
		g_once_init_leave (&vala_array_creation_expression_type_id__volatile, vala_array_creation_expression_type_id);
	}
	return vala_array_creation_expression_type_id__volatile;
}



