/* gtkdocrenderer.c generated by valac, the Vala compiler
 * generated from gtkdocrenderer.vala, do not modify */

/* gtkdocrenderer.vala
 *
 * Copyright (C) 2011 Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */


#include <glib.h>
#include <glib-object.h>
#include "valadoc.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

enum  {
	VALADOC_GTKDOC_RENDERER_0_PROPERTY,
	VALADOC_GTKDOC_RENDERER_CONTENT_PROPERTY,
	VALADOC_GTKDOC_RENDERER_NUM_PROPERTIES
};
static GParamSpec* valadoc_gtkdoc_renderer_properties[VALADOC_GTKDOC_RENDERER_NUM_PROPERTIES];
#define _valadoc_markup_writer_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_markup_writer_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValadocGtkdocRendererPrivate {
	ValadocGtkDocMarkupWriter* writer;
	gboolean separated;
};


static gpointer valadoc_gtkdoc_renderer_parent_class = NULL;

#define VALADOC_GTKDOC_RENDERER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALADOC_TYPE_GTKDOC_RENDERER, ValadocGtkdocRendererPrivate))
static gchar* valadoc_gtkdoc_renderer_get_cname (ValadocGtkdocRenderer* self,
                                          ValadocApiItem* item);
static void valadoc_gtkdoc_renderer_real_render (ValadocContentContentRenderer* base,
                                          ValadocContentContentElement* element);
static void valadoc_gtkdoc_renderer_reset (ValadocGtkdocRenderer* self);
static void valadoc_gtkdoc_renderer_real_render_children (ValadocContentContentRenderer* base,
                                                   ValadocContentContentElement* element);
static void valadoc_gtkdoc_renderer_real_visit_comment (ValadocContentContentVisitor* base,
                                                 ValadocContentComment* element);
static void valadoc_gtkdoc_renderer_real_visit_embedded (ValadocContentContentVisitor* base,
                                                  ValadocContentEmbedded* element);
static void valadoc_gtkdoc_renderer_real_visit_headline (ValadocContentContentVisitor* base,
                                                  ValadocContentHeadline* element);
static void valadoc_gtkdoc_renderer_real_visit_wiki_link (ValadocContentContentVisitor* base,
                                                   ValadocContentWikiLink* element);
static void valadoc_gtkdoc_renderer_write_string (ValadocGtkdocRenderer* self,
                                           const gchar* content);
static void valadoc_gtkdoc_renderer_real_visit_link (ValadocContentContentVisitor* base,
                                              ValadocContentLink* element);
static void valadoc_gtkdoc_renderer_real_visit_symbol_link (ValadocContentContentVisitor* base,
                                                     ValadocContentSymbolLink* element);
static void valadoc_gtkdoc_renderer_real_visit_list (ValadocContentContentVisitor* base,
                                              ValadocContentList* element);
static void valadoc_gtkdoc_renderer_real_visit_list_item (ValadocContentContentVisitor* base,
                                                   ValadocContentListItem* element);
static void valadoc_gtkdoc_renderer_real_visit_page (ValadocContentContentVisitor* base,
                                              ValadocContentPage* element);
static void valadoc_gtkdoc_renderer_real_visit_paragraph (ValadocContentContentVisitor* base,
                                                   ValadocContentParagraph* element);
static void valadoc_gtkdoc_renderer_real_visit_warning (ValadocContentContentVisitor* base,
                                                 ValadocContentWarning* element);
static void valadoc_gtkdoc_renderer_real_visit_note (ValadocContentContentVisitor* base,
                                              ValadocContentNote* element);
static void valadoc_gtkdoc_renderer_real_visit_run (ValadocContentContentVisitor* base,
                                             ValadocContentRun* element);
static void valadoc_gtkdoc_renderer_real_visit_source_code (ValadocContentContentVisitor* base,
                                                     ValadocContentSourceCode* element);
static void valadoc_gtkdoc_renderer_real_visit_table (ValadocContentContentVisitor* base,
                                               ValadocContentTable* element);
static void valadoc_gtkdoc_renderer_real_visit_table_cell (ValadocContentContentVisitor* base,
                                                    ValadocContentTableCell* element);
static void valadoc_gtkdoc_renderer_real_visit_table_row (ValadocContentContentVisitor* base,
                                                   ValadocContentTableRow* element);
static void valadoc_gtkdoc_renderer_real_visit_text (ValadocContentContentVisitor* base,
                                              ValadocContentText* element);
static void valadoc_gtkdoc_renderer_finalize (GObject * obj);
static void _vala_valadoc_gtkdoc_renderer_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}


static gchar*
valadoc_gtkdoc_renderer_get_cname (ValadocGtkdocRenderer* self,
                                   ValadocApiItem* item)
{
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	if (VALADOC_API_IS_METHOD (item)) {
		gchar* _tmp0_;
		_tmp0_ = valadoc_api_method_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_METHOD, ValadocApiMethod));
		result = _tmp0_;
		return result;
	} else {
		if (VALADOC_API_IS_FORMAL_PARAMETER (item)) {
			const gchar* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp1_ = valadoc_api_node_get_name ((ValadocApiNode*) G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_FORMAL_PARAMETER, ValadocApiFormalParameter));
			_tmp2_ = _tmp1_;
			_tmp3_ = g_strdup (_tmp2_);
			result = _tmp3_;
			return result;
		} else {
			if (VALADOC_API_IS_CONSTANT (item)) {
				gchar* _tmp4_;
				_tmp4_ = valadoc_api_constant_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_CONSTANT, ValadocApiConstant));
				result = _tmp4_;
				return result;
			} else {
				if (VALADOC_API_IS_PROPERTY (item)) {
					gchar* _tmp5_;
					_tmp5_ = valadoc_api_property_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_PROPERTY, ValadocApiProperty));
					result = _tmp5_;
					return result;
				} else {
					if (VALADOC_API_IS_SIGNAL (item)) {
						gchar* name = NULL;
						gchar* _tmp6_;
						const gchar* _tmp7_;
						gchar* _tmp8_;
						_tmp6_ = valadoc_api_signal_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_SIGNAL, ValadocApiSignal));
						name = _tmp6_;
						_tmp7_ = name;
						_tmp8_ = string_replace (_tmp7_, "_", "-");
						result = _tmp8_;
						_g_free0 (name);
						return result;
					} else {
						if (VALADOC_API_IS_CLASS (item)) {
							gchar* _tmp9_;
							_tmp9_ = valadoc_api_class_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_CLASS, ValadocApiClass));
							result = _tmp9_;
							return result;
						} else {
							if (VALADOC_API_IS_STRUCT (item)) {
								gchar* _tmp10_;
								_tmp10_ = valadoc_api_struct_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_STRUCT, ValadocApiStruct));
								result = _tmp10_;
								return result;
							} else {
								if (VALADOC_API_IS_INTERFACE (item)) {
									gchar* _tmp11_;
									_tmp11_ = valadoc_api_interface_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_INTERFACE, ValadocApiInterface));
									result = _tmp11_;
									return result;
								} else {
									if (VALADOC_API_IS_ERROR_DOMAIN (item)) {
										gchar* _tmp12_;
										_tmp12_ = valadoc_api_error_domain_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_ERROR_DOMAIN, ValadocApiErrorDomain));
										result = _tmp12_;
										return result;
									} else {
										if (VALADOC_API_IS_ERROR_CODE (item)) {
											gchar* _tmp13_;
											_tmp13_ = valadoc_api_error_code_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_ERROR_CODE, ValadocApiErrorCode));
											result = _tmp13_;
											return result;
										} else {
											if (VALADOC_API_IS_DELEGATE (item)) {
												gchar* _tmp14_;
												_tmp14_ = valadoc_api_delegate_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_DELEGATE, ValadocApiDelegate));
												result = _tmp14_;
												return result;
											} else {
												if (VALADOC_API_IS_ENUM (item)) {
													gchar* _tmp15_;
													_tmp15_ = valadoc_api_enum_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_ENUM, ValadocApiEnum));
													result = _tmp15_;
													return result;
												} else {
													if (VALADOC_API_IS_ENUM_VALUE (item)) {
														gchar* _tmp16_;
														_tmp16_ = valadoc_api_enum_value_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_ENUM_VALUE, ValadocApiEnumValue));
														result = _tmp16_;
														return result;
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}


void
valadoc_gtkdoc_renderer_write_docbook_link (ValadocGtkdocRenderer* self,
                                            ValadocApiItem* item)
{
	ValadocGtkDocMarkupWriter* _tmp0_;
	ValadocGtkDocMarkupWriter* _tmp77_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = self->priv->writer;
	valadoc_markup_writer_set_wrap ((ValadocMarkupWriter*) _tmp0_, FALSE);
	if (VALADOC_API_IS_METHOD (item)) {
		ValadocGtkDocMarkupWriter* _tmp1_;
		ValadocMarkupWriter* _tmp2_;
		ValadocMarkupWriter* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		ValadocMarkupWriter* _tmp6_;
		ValadocMarkupWriter* _tmp7_;
		ValadocMarkupWriter* _tmp8_;
		ValadocMarkupWriter* _tmp9_;
		_tmp1_ = self->priv->writer;
		_tmp2_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp1_, "function", NULL, 0);
		_tmp3_ = _tmp2_;
		_tmp4_ = valadoc_api_method_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_METHOD, ValadocApiMethod));
		_tmp5_ = _tmp4_;
		_tmp6_ = valadoc_markup_writer_text (_tmp3_, _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = valadoc_markup_writer_end_tag (_tmp7_, "function");
		_tmp9_ = _tmp8_;
		_valadoc_markup_writer_unref0 (_tmp9_);
		_valadoc_markup_writer_unref0 (_tmp7_);
		_g_free0 (_tmp5_);
		_valadoc_markup_writer_unref0 (_tmp3_);
	} else {
		if (VALADOC_API_IS_FORMAL_PARAMETER (item)) {
			const gchar* _tmp10_ = NULL;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			ValadocGtkDocMarkupWriter* _tmp13_;
			ValadocMarkupWriter* _tmp14_;
			ValadocMarkupWriter* _tmp15_;
			ValadocMarkupWriter* _tmp16_;
			ValadocMarkupWriter* _tmp17_;
			ValadocMarkupWriter* _tmp18_;
			ValadocMarkupWriter* _tmp19_;
			_tmp11_ = valadoc_api_node_get_name ((ValadocApiNode*) G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_FORMAL_PARAMETER, ValadocApiFormalParameter));
			_tmp12_ = _tmp11_;
			_tmp10_ = _tmp12_;
			if (_tmp10_ == NULL) {
				_tmp10_ = "...";
			}
			_tmp13_ = self->priv->writer;
			_tmp14_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp13_, "parameter", NULL, 0);
			_tmp15_ = _tmp14_;
			_tmp16_ = valadoc_markup_writer_text (_tmp15_, _tmp10_);
			_tmp17_ = _tmp16_;
			_tmp18_ = valadoc_markup_writer_end_tag (_tmp17_, "parameter");
			_tmp19_ = _tmp18_;
			_valadoc_markup_writer_unref0 (_tmp19_);
			_valadoc_markup_writer_unref0 (_tmp17_);
			_valadoc_markup_writer_unref0 (_tmp15_);
		} else {
			if (VALADOC_API_IS_CONSTANT (item)) {
				ValadocGtkDocMarkupWriter* _tmp20_;
				ValadocMarkupWriter* _tmp21_;
				ValadocMarkupWriter* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				ValadocMarkupWriter* _tmp25_;
				ValadocMarkupWriter* _tmp26_;
				ValadocMarkupWriter* _tmp27_;
				ValadocMarkupWriter* _tmp28_;
				_tmp20_ = self->priv->writer;
				_tmp21_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp20_, "constant", NULL, 0);
				_tmp22_ = _tmp21_;
				_tmp23_ = valadoc_api_constant_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_CONSTANT, ValadocApiConstant));
				_tmp24_ = _tmp23_;
				_tmp25_ = valadoc_markup_writer_text (_tmp22_, _tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = valadoc_markup_writer_end_tag (_tmp26_, "constant");
				_tmp28_ = _tmp27_;
				_valadoc_markup_writer_unref0 (_tmp28_);
				_valadoc_markup_writer_unref0 (_tmp26_);
				_g_free0 (_tmp24_);
				_valadoc_markup_writer_unref0 (_tmp22_);
			} else {
				if (VALADOC_API_IS_PROPERTY (item)) {
					ValadocGtkDocMarkupWriter* _tmp29_;
					ValadocMarkupWriter* _tmp30_;
					ValadocMarkupWriter* _tmp31_;
					ValadocApiItem* _tmp32_;
					ValadocApiItem* _tmp33_;
					gchar* _tmp34_;
					gchar* _tmp35_;
					ValadocMarkupWriter* _tmp36_;
					ValadocMarkupWriter* _tmp37_;
					ValadocMarkupWriter* _tmp38_;
					ValadocMarkupWriter* _tmp39_;
					gchar* _tmp40_;
					gchar* _tmp41_;
					gchar* _tmp42_;
					gchar* _tmp43_;
					ValadocMarkupWriter* _tmp44_;
					ValadocMarkupWriter* _tmp45_;
					_tmp29_ = self->priv->writer;
					_tmp30_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp29_, "#");
					_tmp31_ = _tmp30_;
					_tmp32_ = valadoc_api_item_get_parent (item);
					_tmp33_ = _tmp32_;
					_tmp34_ = valadoc_gtkdoc_renderer_get_cname (self, _tmp33_);
					_tmp35_ = _tmp34_;
					_tmp36_ = valadoc_markup_writer_text (_tmp31_, _tmp35_);
					_tmp37_ = _tmp36_;
					_tmp38_ = valadoc_markup_writer_text (_tmp37_, ":");
					_tmp39_ = _tmp38_;
					_tmp40_ = valadoc_api_property_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_PROPERTY, ValadocApiProperty));
					_tmp41_ = _tmp40_;
					_tmp42_ = string_replace (_tmp41_, "_", "-");
					_tmp43_ = _tmp42_;
					_tmp44_ = valadoc_markup_writer_text (_tmp39_, _tmp43_);
					_tmp45_ = _tmp44_;
					_valadoc_markup_writer_unref0 (_tmp45_);
					_g_free0 (_tmp43_);
					_g_free0 (_tmp41_);
					_valadoc_markup_writer_unref0 (_tmp39_);
					_valadoc_markup_writer_unref0 (_tmp37_);
					_g_free0 (_tmp35_);
					_valadoc_markup_writer_unref0 (_tmp31_);
				} else {
					if (VALADOC_API_IS_SIGNAL (item)) {
						ValadocGtkDocMarkupWriter* _tmp46_;
						ValadocMarkupWriter* _tmp47_;
						ValadocMarkupWriter* _tmp48_;
						ValadocApiItem* _tmp49_;
						ValadocApiItem* _tmp50_;
						gchar* _tmp51_;
						gchar* _tmp52_;
						ValadocMarkupWriter* _tmp53_;
						ValadocMarkupWriter* _tmp54_;
						ValadocMarkupWriter* _tmp55_;
						ValadocMarkupWriter* _tmp56_;
						gchar* _tmp57_;
						gchar* _tmp58_;
						gchar* _tmp59_;
						gchar* _tmp60_;
						ValadocMarkupWriter* _tmp61_;
						ValadocMarkupWriter* _tmp62_;
						_tmp46_ = self->priv->writer;
						_tmp47_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp46_, "#");
						_tmp48_ = _tmp47_;
						_tmp49_ = valadoc_api_item_get_parent (item);
						_tmp50_ = _tmp49_;
						_tmp51_ = valadoc_gtkdoc_renderer_get_cname (self, _tmp50_);
						_tmp52_ = _tmp51_;
						_tmp53_ = valadoc_markup_writer_text (_tmp48_, _tmp52_);
						_tmp54_ = _tmp53_;
						_tmp55_ = valadoc_markup_writer_text (_tmp54_, "::");
						_tmp56_ = _tmp55_;
						_tmp57_ = valadoc_api_signal_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_SIGNAL, ValadocApiSignal));
						_tmp58_ = _tmp57_;
						_tmp59_ = string_replace (_tmp58_, "_", "-");
						_tmp60_ = _tmp59_;
						_tmp61_ = valadoc_markup_writer_text (_tmp56_, _tmp60_);
						_tmp62_ = _tmp61_;
						_valadoc_markup_writer_unref0 (_tmp62_);
						_g_free0 (_tmp60_);
						_g_free0 (_tmp58_);
						_valadoc_markup_writer_unref0 (_tmp56_);
						_valadoc_markup_writer_unref0 (_tmp54_);
						_g_free0 (_tmp52_);
						_valadoc_markup_writer_unref0 (_tmp48_);
					} else {
						if (VALADOC_API_IS_NAMESPACE (item)) {
							ValadocGtkDocMarkupWriter* _tmp63_;
							gchar* _tmp64_;
							gchar* _tmp65_;
							ValadocMarkupWriter* _tmp66_;
							ValadocMarkupWriter* _tmp67_;
							_tmp63_ = self->priv->writer;
							_tmp64_ = valadoc_api_node_get_full_name ((ValadocApiNode*) G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_NAMESPACE, ValadocApiNamespace));
							_tmp65_ = _tmp64_;
							_tmp66_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp63_, _tmp65_);
							_tmp67_ = _tmp66_;
							_valadoc_markup_writer_unref0 (_tmp67_);
							_g_free0 (_tmp65_);
						} else {
							ValadocGtkDocMarkupWriter* _tmp68_;
							ValadocMarkupWriter* _tmp69_;
							ValadocMarkupWriter* _tmp70_;
							gchar* _tmp71_;
							gchar* _tmp72_;
							ValadocMarkupWriter* _tmp73_;
							ValadocMarkupWriter* _tmp74_;
							ValadocMarkupWriter* _tmp75_;
							ValadocMarkupWriter* _tmp76_;
							_tmp68_ = self->priv->writer;
							_tmp69_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp68_, "type", NULL, 0);
							_tmp70_ = _tmp69_;
							_tmp71_ = valadoc_gtkdoc_renderer_get_cname (self, item);
							_tmp72_ = _tmp71_;
							_tmp73_ = valadoc_markup_writer_text (_tmp70_, _tmp72_);
							_tmp74_ = _tmp73_;
							_tmp75_ = valadoc_markup_writer_end_tag (_tmp74_, "type");
							_tmp76_ = _tmp75_;
							_valadoc_markup_writer_unref0 (_tmp76_);
							_valadoc_markup_writer_unref0 (_tmp74_);
							_g_free0 (_tmp72_);
							_valadoc_markup_writer_unref0 (_tmp70_);
						}
					}
				}
			}
		}
	}
	_tmp77_ = self->priv->writer;
	valadoc_markup_writer_set_wrap ((ValadocMarkupWriter*) _tmp77_, TRUE);
}


ValadocGtkdocRenderer*
valadoc_gtkdoc_renderer_construct (GType object_type)
{
	ValadocGtkdocRenderer * self = NULL;
	self = (ValadocGtkdocRenderer*) valadoc_content_content_renderer_construct (object_type);
	return self;
}


ValadocGtkdocRenderer*
valadoc_gtkdoc_renderer_new (void)
{
	return valadoc_gtkdoc_renderer_construct (VALADOC_TYPE_GTKDOC_RENDERER);
}


static void
valadoc_gtkdoc_renderer_real_render (ValadocContentContentRenderer* base,
                                     ValadocContentContentElement* element)
{
	ValadocGtkdocRenderer * self;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	valadoc_gtkdoc_renderer_reset (self);
	valadoc_content_content_element_accept (element, (ValadocContentContentVisitor*) self);
}


void
valadoc_gtkdoc_renderer_render_symbol (ValadocGtkdocRenderer* self,
                                       ValadocContentComment* documentation)
{
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaList* _tmp2_;
	ValaList* _tmp3_;
	ValaList* _tmp4_;
	ValaList* _tmp5_;
	g_return_if_fail (self != NULL);
	valadoc_content_content_renderer_render ((ValadocContentContentRenderer*) self, (ValadocContentContentElement*) documentation);
	_tmp0_ = valadoc_content_comment_find_taglets (documentation, NULL, VALADOC_TAGLETS_TYPE_THROWS);
	_tmp1_ = _tmp0_;
	valadoc_gtkdoc_renderer_append_exceptions (self, _tmp1_);
	_vala_iterable_unref0 (_tmp1_);
	_tmp2_ = valadoc_content_comment_find_taglets (documentation, NULL, VALADOC_TAGLETS_TYPE_SEE);
	_tmp3_ = _tmp2_;
	valadoc_gtkdoc_renderer_append_see (self, _tmp3_);
	_vala_iterable_unref0 (_tmp3_);
	_tmp4_ = valadoc_content_comment_find_taglets (documentation, NULL, VALADOC_TAGLETS_TYPE_SINCE);
	_tmp5_ = _tmp4_;
	valadoc_gtkdoc_renderer_append_since (self, _tmp5_);
	_vala_iterable_unref0 (_tmp5_);
}


static void
valadoc_gtkdoc_renderer_real_render_children (ValadocContentContentRenderer* base,
                                              ValadocContentContentElement* element)
{
	ValadocGtkdocRenderer * self;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	valadoc_gtkdoc_renderer_reset (self);
	valadoc_content_content_element_accept_children (element, (ValadocContentContentVisitor*) self);
}


static void
valadoc_gtkdoc_renderer_reset (ValadocGtkdocRenderer* self)
{
	ValadocGtkDocMarkupWriter* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->separated = FALSE;
	_tmp0_ = self->priv->writer;
	valadoc_gtk_doc_markup_writer_reset (_tmp0_);
}


static void
valadoc_gtkdoc_renderer_real_visit_comment (ValadocContentContentVisitor* base,
                                            ValadocContentComment* element)
{
	ValadocGtkdocRenderer * self;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) element, (ValadocContentContentVisitor*) self);
}


static void
valadoc_gtkdoc_renderer_real_visit_embedded (ValadocContentContentVisitor* base,
                                             ValadocContentEmbedded* element)
{
	ValadocGtkdocRenderer * self;
	ValadocGtkDocMarkupWriter* _tmp0_;
	ValadocMarkupWriter* _tmp1_;
	ValadocMarkupWriter* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	ValadocGtkDocMarkupWriter* _tmp14_;
	ValadocMarkupWriter* _tmp15_;
	ValadocMarkupWriter* _tmp16_;
	ValadocGtkDocMarkupWriter* _tmp17_;
	ValadocMarkupWriter* _tmp18_;
	ValadocMarkupWriter* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar** _tmp24_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	ValadocMarkupWriter* _tmp26_;
	ValadocMarkupWriter* _tmp27_;
	ValadocMarkupWriter* _tmp28_;
	ValadocMarkupWriter* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	ValadocGtkDocMarkupWriter* _tmp45_;
	ValadocMarkupWriter* _tmp46_;
	ValadocMarkupWriter* _tmp47_;
	ValadocGtkDocMarkupWriter* _tmp48_;
	ValadocMarkupWriter* _tmp49_;
	ValadocMarkupWriter* _tmp50_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->writer;
	_tmp1_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "figure", NULL, 0);
	_tmp2_ = _tmp1_;
	_valadoc_markup_writer_unref0 (_tmp2_);
	_tmp3_ = valadoc_content_embedded_get_caption (element);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		ValadocGtkDocMarkupWriter* _tmp5_;
		ValadocMarkupWriter* _tmp6_;
		ValadocMarkupWriter* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		ValadocMarkupWriter* _tmp10_;
		ValadocMarkupWriter* _tmp11_;
		ValadocMarkupWriter* _tmp12_;
		ValadocMarkupWriter* _tmp13_;
		_tmp5_ = self->priv->writer;
		_tmp6_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp5_, "title", NULL, 0);
		_tmp7_ = _tmp6_;
		_tmp8_ = valadoc_content_embedded_get_caption (element);
		_tmp9_ = _tmp8_;
		_tmp10_ = valadoc_markup_writer_text (_tmp7_, _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = valadoc_markup_writer_end_tag (_tmp11_, "title");
		_tmp13_ = _tmp12_;
		_valadoc_markup_writer_unref0 (_tmp13_);
		_valadoc_markup_writer_unref0 (_tmp11_);
		_valadoc_markup_writer_unref0 (_tmp7_);
	}
	_tmp14_ = self->priv->writer;
	_tmp15_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp14_, "mediaobject", NULL, 0);
	_tmp16_ = _tmp15_;
	_valadoc_markup_writer_unref0 (_tmp16_);
	_tmp17_ = self->priv->writer;
	_tmp18_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp17_, "imageobject", NULL, 0);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strdup ("fileref");
	_tmp21_ = valadoc_content_embedded_get_url (element);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_strdup (_tmp22_);
	_tmp24_ = g_new0 (gchar*, 2 + 1);
	_tmp24_[0] = _tmp20_;
	_tmp24_[1] = _tmp23_;
	_tmp25_ = _tmp24_;
	_tmp25__length1 = 2;
	_tmp26_ = valadoc_markup_writer_simple_tag (_tmp19_, "imagedata", _tmp25_, 2);
	_tmp27_ = _tmp26_;
	_tmp28_ = valadoc_markup_writer_end_tag (_tmp27_, "imageobject");
	_tmp29_ = _tmp28_;
	_valadoc_markup_writer_unref0 (_tmp29_);
	_valadoc_markup_writer_unref0 (_tmp27_);
	_tmp25_ = (_vala_array_free (_tmp25_, _tmp25__length1, (GDestroyNotify) g_free), NULL);
	_valadoc_markup_writer_unref0 (_tmp19_);
	_tmp30_ = valadoc_content_embedded_get_caption (element);
	_tmp31_ = _tmp30_;
	if (_tmp31_ != NULL) {
		ValadocGtkDocMarkupWriter* _tmp32_;
		ValadocMarkupWriter* _tmp33_;
		ValadocMarkupWriter* _tmp34_;
		ValadocMarkupWriter* _tmp35_;
		ValadocMarkupWriter* _tmp36_;
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		ValadocMarkupWriter* _tmp39_;
		ValadocMarkupWriter* _tmp40_;
		ValadocMarkupWriter* _tmp41_;
		ValadocMarkupWriter* _tmp42_;
		ValadocMarkupWriter* _tmp43_;
		ValadocMarkupWriter* _tmp44_;
		_tmp32_ = self->priv->writer;
		_tmp33_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp32_, "textobject", NULL, 0);
		_tmp34_ = _tmp33_;
		_tmp35_ = valadoc_markup_writer_start_tag (_tmp34_, "phrase", NULL, 0);
		_tmp36_ = _tmp35_;
		_tmp37_ = valadoc_content_embedded_get_caption (element);
		_tmp38_ = _tmp37_;
		_tmp39_ = valadoc_markup_writer_text (_tmp36_, _tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = valadoc_markup_writer_end_tag (_tmp40_, "phrase");
		_tmp42_ = _tmp41_;
		_tmp43_ = valadoc_markup_writer_end_tag (_tmp42_, "textobject");
		_tmp44_ = _tmp43_;
		_valadoc_markup_writer_unref0 (_tmp44_);
		_valadoc_markup_writer_unref0 (_tmp42_);
		_valadoc_markup_writer_unref0 (_tmp40_);
		_valadoc_markup_writer_unref0 (_tmp36_);
		_valadoc_markup_writer_unref0 (_tmp34_);
	}
	_tmp45_ = self->priv->writer;
	_tmp46_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp45_, "mediaobject");
	_tmp47_ = _tmp46_;
	_valadoc_markup_writer_unref0 (_tmp47_);
	_tmp48_ = self->priv->writer;
	_tmp49_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp48_, "figure");
	_tmp50_ = _tmp49_;
	_valadoc_markup_writer_unref0 (_tmp50_);
}


static void
valadoc_gtkdoc_renderer_real_visit_headline (ValadocContentContentVisitor* base,
                                             ValadocContentHeadline* element)
{
	ValadocGtkdocRenderer * self;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	g_assert_not_reached ();
}


static void
valadoc_gtkdoc_renderer_real_visit_wiki_link (ValadocContentContentVisitor* base,
                                              ValadocContentWikiLink* element)
{
	ValadocGtkdocRenderer * self;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) element);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		valadoc_content_content_element_accept_children ((ValadocContentContentElement*) element, (ValadocContentContentVisitor*) self);
	} else {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = valadoc_content_wiki_link_get_name (element);
		_tmp5_ = _tmp4_;
		valadoc_gtkdoc_renderer_write_string (self, _tmp5_);
	}
}


static void
valadoc_gtkdoc_renderer_real_visit_link (ValadocContentContentVisitor* base,
                                         ValadocContentLink* element)
{
	ValadocGtkdocRenderer * self;
	ValadocGtkDocMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	ValadocMarkupWriter* _tmp7_;
	ValadocMarkupWriter* _tmp8_;
	ValadocGtkDocMarkupWriter* _tmp9_;
	ValadocMarkupWriter* _tmp10_;
	ValadocMarkupWriter* _tmp11_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->writer;
	_tmp1_ = g_strdup ("url");
	_tmp2_ = valadoc_content_link_get_url (element);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = g_new0 (gchar*, 2 + 1);
	_tmp5_[0] = _tmp1_;
	_tmp5_[1] = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = 2;
	_tmp7_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "ulink", _tmp6_, 2);
	_tmp8_ = _tmp7_;
	_valadoc_markup_writer_unref0 (_tmp8_);
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) element, (ValadocContentContentVisitor*) self);
	_tmp9_ = self->priv->writer;
	_tmp10_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp9_, "ulink");
	_tmp11_ = _tmp10_;
	_valadoc_markup_writer_unref0 (_tmp11_);
}


static void
valadoc_gtkdoc_renderer_real_visit_symbol_link (ValadocContentContentVisitor* base,
                                                ValadocContentSymbolLink* element)
{
	ValadocGtkdocRenderer * self;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) element);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		ValadocGtkDocMarkupWriter* _tmp4_;
		ValadocMarkupWriter* _tmp5_;
		ValadocMarkupWriter* _tmp6_;
		ValadocGtkDocMarkupWriter* _tmp7_;
		ValadocMarkupWriter* _tmp8_;
		ValadocMarkupWriter* _tmp9_;
		ValadocGtkDocMarkupWriter* _tmp10_;
		ValadocMarkupWriter* _tmp11_;
		ValadocMarkupWriter* _tmp12_;
		_tmp4_ = self->priv->writer;
		_tmp5_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp4_, "\"");
		_tmp6_ = _tmp5_;
		_valadoc_markup_writer_unref0 (_tmp6_);
		valadoc_content_content_element_accept_children ((ValadocContentContentElement*) element, (ValadocContentContentVisitor*) self);
		_tmp7_ = self->priv->writer;
		_tmp8_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp7_, "\" (");
		_tmp9_ = _tmp8_;
		_valadoc_markup_writer_unref0 (_tmp9_);
		valadoc_gtkdoc_renderer_write_symbol_link (self, element);
		_tmp10_ = self->priv->writer;
		_tmp11_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp10_, ")");
		_tmp12_ = _tmp11_;
		_valadoc_markup_writer_unref0 (_tmp12_);
	} else {
		valadoc_gtkdoc_renderer_write_symbol_link (self, element);
	}
}


void
valadoc_gtkdoc_renderer_write_symbol_link (ValadocGtkdocRenderer* self,
                                           ValadocContentSymbolLink* element)
{
	ValadocApiNode* _tmp0_;
	ValadocApiNode* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	_tmp0_ = valadoc_content_symbol_link_get_symbol (element);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		ValadocGtkDocMarkupWriter* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		ValadocMarkupWriter* _tmp5_;
		ValadocMarkupWriter* _tmp6_;
		_tmp2_ = self->priv->writer;
		_tmp3_ = valadoc_content_symbol_link_get_given_symbol_name (element);
		_tmp4_ = _tmp3_;
		_tmp5_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp2_, _tmp4_);
		_tmp6_ = _tmp5_;
		_valadoc_markup_writer_unref0 (_tmp6_);
	} else {
		ValadocApiNode* _tmp7_;
		ValadocApiNode* _tmp8_;
		_tmp7_ = valadoc_content_symbol_link_get_symbol (element);
		_tmp8_ = _tmp7_;
		valadoc_gtkdoc_renderer_write_docbook_link (self, (ValadocApiItem*) _tmp8_);
	}
}


static void
valadoc_gtkdoc_renderer_real_visit_list (ValadocContentContentVisitor* base,
                                         ValadocContentList* element)
{
	ValadocGtkdocRenderer * self;
	gchar* tag = NULL;
	gchar* _tmp0_;
	ValadocContentListBullet _tmp1_;
	ValadocContentListBullet _tmp2_;
	ValadocGtkDocMarkupWriter* _tmp53_;
	const gchar* _tmp54_;
	ValadocMarkupWriter* _tmp55_;
	ValadocMarkupWriter* _tmp56_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = g_strdup ("orderedlist");
	tag = _tmp0_;
	_tmp1_ = valadoc_content_list_get_bullet (element);
	_tmp2_ = _tmp1_;
	switch (_tmp2_) {
		case VALADOC_CONTENT_LIST_BULLET_NONE:
		{
			ValadocGtkDocMarkupWriter* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar** _tmp6_;
			gchar** _tmp7_;
			gint _tmp7__length1;
			ValadocMarkupWriter* _tmp8_;
			ValadocMarkupWriter* _tmp9_;
			gchar* _tmp10_;
			_tmp3_ = self->priv->writer;
			_tmp4_ = g_strdup ("mark");
			_tmp5_ = g_strdup ("none");
			_tmp6_ = g_new0 (gchar*, 2 + 1);
			_tmp6_[0] = _tmp4_;
			_tmp6_[1] = _tmp5_;
			_tmp7_ = _tmp6_;
			_tmp7__length1 = 2;
			_tmp8_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp3_, "itemizedlist", _tmp7_, 2);
			_tmp9_ = _tmp8_;
			_valadoc_markup_writer_unref0 (_tmp9_);
			_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
			_tmp10_ = g_strdup ("itemizedlist");
			_g_free0 (tag);
			tag = _tmp10_;
			break;
		}
		case VALADOC_CONTENT_LIST_BULLET_UNORDERED:
		{
			ValadocGtkDocMarkupWriter* _tmp11_;
			ValadocMarkupWriter* _tmp12_;
			ValadocMarkupWriter* _tmp13_;
			gchar* _tmp14_;
			_tmp11_ = self->priv->writer;
			_tmp12_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp11_, "itemizedlist", NULL, 0);
			_tmp13_ = _tmp12_;
			_valadoc_markup_writer_unref0 (_tmp13_);
			_tmp14_ = g_strdup ("itemizedlist");
			_g_free0 (tag);
			tag = _tmp14_;
			break;
		}
		case VALADOC_CONTENT_LIST_BULLET_ORDERED:
		{
			ValadocGtkDocMarkupWriter* _tmp15_;
			ValadocMarkupWriter* _tmp16_;
			ValadocMarkupWriter* _tmp17_;
			_tmp15_ = self->priv->writer;
			_tmp16_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp15_, "orderedlist", NULL, 0);
			_tmp17_ = _tmp16_;
			_valadoc_markup_writer_unref0 (_tmp17_);
			break;
		}
		case VALADOC_CONTENT_LIST_BULLET_ORDERED_NUMBER:
		{
			ValadocGtkDocMarkupWriter* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar** _tmp21_;
			gchar** _tmp22_;
			gint _tmp22__length1;
			ValadocMarkupWriter* _tmp23_;
			ValadocMarkupWriter* _tmp24_;
			_tmp18_ = self->priv->writer;
			_tmp19_ = g_strdup ("numeration");
			_tmp20_ = g_strdup ("arabic");
			_tmp21_ = g_new0 (gchar*, 2 + 1);
			_tmp21_[0] = _tmp19_;
			_tmp21_[1] = _tmp20_;
			_tmp22_ = _tmp21_;
			_tmp22__length1 = 2;
			_tmp23_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp18_, "orderedlist", _tmp22_, 2);
			_tmp24_ = _tmp23_;
			_valadoc_markup_writer_unref0 (_tmp24_);
			_tmp22_ = (_vala_array_free (_tmp22_, _tmp22__length1, (GDestroyNotify) g_free), NULL);
			break;
		}
		case VALADOC_CONTENT_LIST_BULLET_ORDERED_LOWER_CASE_ALPHA:
		{
			ValadocGtkDocMarkupWriter* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar** _tmp28_;
			gchar** _tmp29_;
			gint _tmp29__length1;
			ValadocMarkupWriter* _tmp30_;
			ValadocMarkupWriter* _tmp31_;
			_tmp25_ = self->priv->writer;
			_tmp26_ = g_strdup ("numeration");
			_tmp27_ = g_strdup ("loweralpha");
			_tmp28_ = g_new0 (gchar*, 2 + 1);
			_tmp28_[0] = _tmp26_;
			_tmp28_[1] = _tmp27_;
			_tmp29_ = _tmp28_;
			_tmp29__length1 = 2;
			_tmp30_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp25_, "orderedlist", _tmp29_, 2);
			_tmp31_ = _tmp30_;
			_valadoc_markup_writer_unref0 (_tmp31_);
			_tmp29_ = (_vala_array_free (_tmp29_, _tmp29__length1, (GDestroyNotify) g_free), NULL);
			break;
		}
		case VALADOC_CONTENT_LIST_BULLET_ORDERED_UPPER_CASE_ALPHA:
		{
			ValadocGtkDocMarkupWriter* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			gchar** _tmp35_;
			gchar** _tmp36_;
			gint _tmp36__length1;
			ValadocMarkupWriter* _tmp37_;
			ValadocMarkupWriter* _tmp38_;
			_tmp32_ = self->priv->writer;
			_tmp33_ = g_strdup ("numeration");
			_tmp34_ = g_strdup ("upperalpha");
			_tmp35_ = g_new0 (gchar*, 2 + 1);
			_tmp35_[0] = _tmp33_;
			_tmp35_[1] = _tmp34_;
			_tmp36_ = _tmp35_;
			_tmp36__length1 = 2;
			_tmp37_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp32_, "orderedlist", _tmp36_, 2);
			_tmp38_ = _tmp37_;
			_valadoc_markup_writer_unref0 (_tmp38_);
			_tmp36_ = (_vala_array_free (_tmp36_, _tmp36__length1, (GDestroyNotify) g_free), NULL);
			break;
		}
		case VALADOC_CONTENT_LIST_BULLET_ORDERED_LOWER_CASE_ROMAN:
		{
			ValadocGtkDocMarkupWriter* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar** _tmp42_;
			gchar** _tmp43_;
			gint _tmp43__length1;
			ValadocMarkupWriter* _tmp44_;
			ValadocMarkupWriter* _tmp45_;
			_tmp39_ = self->priv->writer;
			_tmp40_ = g_strdup ("numeration");
			_tmp41_ = g_strdup ("lowerroman");
			_tmp42_ = g_new0 (gchar*, 2 + 1);
			_tmp42_[0] = _tmp40_;
			_tmp42_[1] = _tmp41_;
			_tmp43_ = _tmp42_;
			_tmp43__length1 = 2;
			_tmp44_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp39_, "orderedlist", _tmp43_, 2);
			_tmp45_ = _tmp44_;
			_valadoc_markup_writer_unref0 (_tmp45_);
			_tmp43_ = (_vala_array_free (_tmp43_, _tmp43__length1, (GDestroyNotify) g_free), NULL);
			break;
		}
		case VALADOC_CONTENT_LIST_BULLET_ORDERED_UPPER_CASE_ROMAN:
		{
			ValadocGtkDocMarkupWriter* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			gchar** _tmp49_;
			gchar** _tmp50_;
			gint _tmp50__length1;
			ValadocMarkupWriter* _tmp51_;
			ValadocMarkupWriter* _tmp52_;
			_tmp46_ = self->priv->writer;
			_tmp47_ = g_strdup ("numeration");
			_tmp48_ = g_strdup ("upperroman");
			_tmp49_ = g_new0 (gchar*, 2 + 1);
			_tmp49_[0] = _tmp47_;
			_tmp49_[1] = _tmp48_;
			_tmp50_ = _tmp49_;
			_tmp50__length1 = 2;
			_tmp51_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp46_, "orderedlist", _tmp50_, 2);
			_tmp52_ = _tmp51_;
			_valadoc_markup_writer_unref0 (_tmp52_);
			_tmp50_ = (_vala_array_free (_tmp50_, _tmp50__length1, (GDestroyNotify) g_free), NULL);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) element, (ValadocContentContentVisitor*) self);
	_tmp53_ = self->priv->writer;
	_tmp54_ = tag;
	_tmp55_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp53_, _tmp54_);
	_tmp56_ = _tmp55_;
	_valadoc_markup_writer_unref0 (_tmp56_);
	_g_free0 (tag);
}


static void
valadoc_gtkdoc_renderer_real_visit_list_item (ValadocContentContentVisitor* base,
                                              ValadocContentListItem* element)
{
	ValadocGtkdocRenderer * self;
	ValadocGtkDocMarkupWriter* _tmp0_;
	ValadocMarkupWriter* _tmp1_;
	ValadocMarkupWriter* _tmp2_;
	ValadocGtkDocMarkupWriter* _tmp3_;
	ValadocMarkupWriter* _tmp4_;
	ValadocMarkupWriter* _tmp5_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->writer;
	_tmp1_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "listitem", NULL, 0);
	_tmp2_ = _tmp1_;
	_valadoc_markup_writer_unref0 (_tmp2_);
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) element, (ValadocContentContentVisitor*) self);
	_tmp3_ = self->priv->writer;
	_tmp4_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp3_, "listitem");
	_tmp5_ = _tmp4_;
	_valadoc_markup_writer_unref0 (_tmp5_);
}


static void
valadoc_gtkdoc_renderer_real_visit_page (ValadocContentContentVisitor* base,
                                         ValadocContentPage* element)
{
	ValadocGtkdocRenderer * self;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) element, (ValadocContentContentVisitor*) self);
}


static void
valadoc_gtkdoc_renderer_real_visit_paragraph (ValadocContentContentVisitor* base,
                                              ValadocContentParagraph* element)
{
	ValadocGtkdocRenderer * self;
	ValadocGtkDocMarkupWriter* _tmp0_;
	ValadocMarkupWriter* _tmp1_;
	ValadocMarkupWriter* _tmp2_;
	ValadocGtkDocMarkupWriter* _tmp3_;
	ValadocMarkupWriter* _tmp4_;
	ValadocMarkupWriter* _tmp5_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->writer;
	_tmp1_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "para", NULL, 0);
	_tmp2_ = _tmp1_;
	_valadoc_markup_writer_unref0 (_tmp2_);
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) element, (ValadocContentContentVisitor*) self);
	_tmp3_ = self->priv->writer;
	_tmp4_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp3_, "para");
	_tmp5_ = _tmp4_;
	_valadoc_markup_writer_unref0 (_tmp5_);
}


static void
valadoc_gtkdoc_renderer_real_visit_warning (ValadocContentContentVisitor* base,
                                            ValadocContentWarning* element)
{
	ValadocGtkdocRenderer * self;
	ValadocGtkDocMarkupWriter* _tmp0_;
	ValadocMarkupWriter* _tmp1_;
	ValadocMarkupWriter* _tmp2_;
	ValadocGtkDocMarkupWriter* _tmp3_;
	ValadocMarkupWriter* _tmp4_;
	ValadocMarkupWriter* _tmp5_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->writer;
	_tmp1_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "warning", NULL, 0);
	_tmp2_ = _tmp1_;
	_valadoc_markup_writer_unref0 (_tmp2_);
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) element, (ValadocContentContentVisitor*) self);
	_tmp3_ = self->priv->writer;
	_tmp4_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp3_, "warning");
	_tmp5_ = _tmp4_;
	_valadoc_markup_writer_unref0 (_tmp5_);
}


static void
valadoc_gtkdoc_renderer_real_visit_note (ValadocContentContentVisitor* base,
                                         ValadocContentNote* element)
{
	ValadocGtkdocRenderer * self;
	ValadocGtkDocMarkupWriter* _tmp0_;
	ValadocMarkupWriter* _tmp1_;
	ValadocMarkupWriter* _tmp2_;
	ValadocGtkDocMarkupWriter* _tmp3_;
	ValadocMarkupWriter* _tmp4_;
	ValadocMarkupWriter* _tmp5_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->writer;
	_tmp1_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "note", NULL, 0);
	_tmp2_ = _tmp1_;
	_valadoc_markup_writer_unref0 (_tmp2_);
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) element, (ValadocContentContentVisitor*) self);
	_tmp3_ = self->priv->writer;
	_tmp4_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp3_, "note");
	_tmp5_ = _tmp4_;
	_valadoc_markup_writer_unref0 (_tmp5_);
}


static void
valadoc_gtkdoc_renderer_real_visit_run (ValadocContentContentVisitor* base,
                                        ValadocContentRun* element)
{
	ValadocGtkdocRenderer * self;
	gchar* tag = NULL;
	ValadocContentRunStyle _tmp0_;
	ValadocContentRunStyle _tmp1_;
	const gchar* _tmp26_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	tag = NULL;
	_tmp0_ = valadoc_content_run_get_style (element);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case VALADOC_CONTENT_RUN_STYLE_BOLD:
		{
			ValadocGtkDocMarkupWriter* _tmp2_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			gchar** _tmp5_;
			gchar** _tmp6_;
			gint _tmp6__length1;
			ValadocMarkupWriter* _tmp7_;
			ValadocMarkupWriter* _tmp8_;
			gchar* _tmp9_;
			_tmp2_ = self->priv->writer;
			_tmp3_ = g_strdup ("role");
			_tmp4_ = g_strdup ("bold");
			_tmp5_ = g_new0 (gchar*, 2 + 1);
			_tmp5_[0] = _tmp3_;
			_tmp5_[1] = _tmp4_;
			_tmp6_ = _tmp5_;
			_tmp6__length1 = 2;
			_tmp7_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp2_, "emphasis", _tmp6_, 2);
			_tmp8_ = _tmp7_;
			_valadoc_markup_writer_unref0 (_tmp8_);
			_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
			_tmp9_ = g_strdup ("emphasis");
			_g_free0 (tag);
			tag = _tmp9_;
			break;
		}
		case VALADOC_CONTENT_RUN_STYLE_ITALIC:
		{
			ValadocGtkDocMarkupWriter* _tmp10_;
			ValadocMarkupWriter* _tmp11_;
			ValadocMarkupWriter* _tmp12_;
			gchar* _tmp13_;
			_tmp10_ = self->priv->writer;
			_tmp11_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp10_, "emphasis", NULL, 0);
			_tmp12_ = _tmp11_;
			_valadoc_markup_writer_unref0 (_tmp12_);
			_tmp13_ = g_strdup ("emphasis");
			_g_free0 (tag);
			tag = _tmp13_;
			break;
		}
		case VALADOC_CONTENT_RUN_STYLE_UNDERLINED:
		{
			ValadocGtkDocMarkupWriter* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar** _tmp17_;
			gchar** _tmp18_;
			gint _tmp18__length1;
			ValadocMarkupWriter* _tmp19_;
			ValadocMarkupWriter* _tmp20_;
			gchar* _tmp21_;
			_tmp14_ = self->priv->writer;
			_tmp15_ = g_strdup ("role");
			_tmp16_ = g_strdup ("underline");
			_tmp17_ = g_new0 (gchar*, 2 + 1);
			_tmp17_[0] = _tmp15_;
			_tmp17_[1] = _tmp16_;
			_tmp18_ = _tmp17_;
			_tmp18__length1 = 2;
			_tmp19_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp14_, "emphasis", _tmp18_, 2);
			_tmp20_ = _tmp19_;
			_valadoc_markup_writer_unref0 (_tmp20_);
			_tmp18_ = (_vala_array_free (_tmp18_, _tmp18__length1, (GDestroyNotify) g_free), NULL);
			_tmp21_ = g_strdup ("emphasis");
			_g_free0 (tag);
			tag = _tmp21_;
			break;
		}
		case VALADOC_CONTENT_RUN_STYLE_MONOSPACED:
		{
			ValadocGtkDocMarkupWriter* _tmp22_;
			ValadocMarkupWriter* _tmp23_;
			ValadocMarkupWriter* _tmp24_;
			gchar* _tmp25_;
			_tmp22_ = self->priv->writer;
			_tmp23_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp22_, "blockquote", NULL, 0);
			_tmp24_ = _tmp23_;
			_valadoc_markup_writer_unref0 (_tmp24_);
			_tmp25_ = g_strdup ("blockquote");
			_g_free0 (tag);
			tag = _tmp25_;
			break;
		}
		default:
		{
			break;
		}
	}
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) element, (ValadocContentContentVisitor*) self);
	_tmp26_ = tag;
	if (_tmp26_ != NULL) {
		ValadocGtkDocMarkupWriter* _tmp27_;
		const gchar* _tmp28_;
		ValadocMarkupWriter* _tmp29_;
		ValadocMarkupWriter* _tmp30_;
		_tmp27_ = self->priv->writer;
		_tmp28_ = tag;
		_tmp29_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp27_, _tmp28_);
		_tmp30_ = _tmp29_;
		_valadoc_markup_writer_unref0 (_tmp30_);
	}
	_g_free0 (tag);
}


static void
valadoc_gtkdoc_renderer_real_visit_source_code (ValadocContentContentVisitor* base,
                                                ValadocContentSourceCode* element)
{
	ValadocGtkdocRenderer * self;
	ValadocGtkDocMarkupWriter* _tmp0_;
	ValadocMarkupWriter* _tmp1_;
	ValadocMarkupWriter* _tmp2_;
	ValadocMarkupWriter* _tmp3_;
	ValadocMarkupWriter* _tmp4_;
	ValadocGtkDocMarkupWriter* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	ValadocMarkupWriter* _tmp8_;
	ValadocMarkupWriter* _tmp9_;
	ValadocGtkDocMarkupWriter* _tmp10_;
	ValadocMarkupWriter* _tmp11_;
	ValadocMarkupWriter* _tmp12_;
	ValadocMarkupWriter* _tmp13_;
	ValadocMarkupWriter* _tmp14_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->writer;
	_tmp1_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "example", NULL, 0);
	_tmp2_ = _tmp1_;
	_tmp3_ = valadoc_markup_writer_start_tag (_tmp2_, "programlisting", NULL, 0);
	_tmp4_ = _tmp3_;
	_valadoc_markup_writer_unref0 (_tmp4_);
	_valadoc_markup_writer_unref0 (_tmp2_);
	_tmp5_ = self->priv->writer;
	_tmp6_ = valadoc_content_source_code_get_code (element);
	_tmp7_ = _tmp6_;
	_tmp8_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp5_, _tmp7_);
	_tmp9_ = _tmp8_;
	_valadoc_markup_writer_unref0 (_tmp9_);
	_tmp10_ = self->priv->writer;
	_tmp11_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp10_, "programlisting");
	_tmp12_ = _tmp11_;
	_tmp13_ = valadoc_markup_writer_end_tag (_tmp12_, "example");
	_tmp14_ = _tmp13_;
	_valadoc_markup_writer_unref0 (_tmp14_);
	_valadoc_markup_writer_unref0 (_tmp12_);
}


static void
valadoc_gtkdoc_renderer_real_visit_table (ValadocContentContentVisitor* base,
                                          ValadocContentTable* element)
{
	ValadocGtkdocRenderer * self;
	ValadocGtkDocMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocMarkupWriter* _tmp5_;
	ValadocMarkupWriter* _tmp6_;
	ValadocGtkDocMarkupWriter* _tmp7_;
	ValadocMarkupWriter* _tmp8_;
	ValadocMarkupWriter* _tmp9_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->writer;
	_tmp1_ = g_strdup ("align");
	_tmp2_ = g_strdup ("center");
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	_tmp5_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "table", _tmp4_, 2);
	_tmp6_ = _tmp5_;
	_valadoc_markup_writer_unref0 (_tmp6_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) element, (ValadocContentContentVisitor*) self);
	_tmp7_ = self->priv->writer;
	_tmp8_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp7_, "table");
	_tmp9_ = _tmp8_;
	_valadoc_markup_writer_unref0 (_tmp9_);
}


static void
valadoc_gtkdoc_renderer_real_visit_table_cell (ValadocContentContentVisitor* base,
                                               ValadocContentTableCell* element)
{
	ValadocGtkdocRenderer * self;
	ValadocGtkDocMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	ValadocMarkupWriter* _tmp11_;
	ValadocMarkupWriter* _tmp12_;
	ValadocGtkDocMarkupWriter* _tmp13_;
	ValadocMarkupWriter* _tmp14_;
	ValadocMarkupWriter* _tmp15_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->writer;
	_tmp1_ = g_strdup ("colspan");
	_tmp2_ = valadoc_content_table_cell_get_colspan (element);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%i", _tmp3_);
	_tmp5_ = g_strdup ("rowspan");
	_tmp6_ = valadoc_content_table_cell_get_rowspan (element);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("%i", _tmp7_);
	_tmp9_ = g_new0 (gchar*, 4 + 1);
	_tmp9_[0] = _tmp1_;
	_tmp9_[1] = _tmp4_;
	_tmp9_[2] = _tmp5_;
	_tmp9_[3] = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 4;
	_tmp11_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "td", _tmp10_, 4);
	_tmp12_ = _tmp11_;
	_valadoc_markup_writer_unref0 (_tmp12_);
	_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) element, (ValadocContentContentVisitor*) self);
	_tmp13_ = self->priv->writer;
	_tmp14_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp13_, "td");
	_tmp15_ = _tmp14_;
	_valadoc_markup_writer_unref0 (_tmp15_);
}


static void
valadoc_gtkdoc_renderer_real_visit_table_row (ValadocContentContentVisitor* base,
                                              ValadocContentTableRow* element)
{
	ValadocGtkdocRenderer * self;
	ValadocGtkDocMarkupWriter* _tmp0_;
	ValadocMarkupWriter* _tmp1_;
	ValadocMarkupWriter* _tmp2_;
	ValadocGtkDocMarkupWriter* _tmp3_;
	ValadocMarkupWriter* _tmp4_;
	ValadocMarkupWriter* _tmp5_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->writer;
	_tmp1_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "tr", NULL, 0);
	_tmp2_ = _tmp1_;
	_valadoc_markup_writer_unref0 (_tmp2_);
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) element, (ValadocContentContentVisitor*) self);
	_tmp3_ = self->priv->writer;
	_tmp4_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp3_, "tr");
	_tmp5_ = _tmp4_;
	_valadoc_markup_writer_unref0 (_tmp5_);
}


static void
valadoc_gtkdoc_renderer_real_visit_text (ValadocContentContentVisitor* base,
                                         ValadocContentText* element)
{
	ValadocGtkdocRenderer * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = valadoc_content_text_get_content (element);
	_tmp1_ = _tmp0_;
	valadoc_gtkdoc_renderer_write_string (self, _tmp1_);
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static void
valadoc_gtkdoc_renderer_write_string (ValadocGtkdocRenderer* self,
                                      const gchar* content)
{
	gunichar chr = 0U;
	glong lpos = 0L;
	gint i = 0;
	ValadocGtkDocMarkupWriter* _tmp137_;
	glong _tmp138_;
	gint _tmp139_;
	glong _tmp140_;
	gchar* _tmp141_;
	gchar* _tmp142_;
	ValadocMarkupWriter* _tmp143_;
	ValadocMarkupWriter* _tmp144_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content != NULL);
	chr = (gunichar) string_get (content, (glong) 0);
	lpos = (glong) 0;
	i = 0;
	{
		gboolean _tmp0_ = FALSE;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gunichar _tmp3_;
			gunichar _tmp4_;
			if (!_tmp0_) {
				gint _tmp1_;
				gint _tmp2_;
				_tmp1_ = i;
				i = _tmp1_ + 1;
				_tmp2_ = i;
				chr = (gunichar) string_get (content, (glong) _tmp2_);
			}
			_tmp0_ = FALSE;
			_tmp3_ = chr;
			if (!(_tmp3_ != ((gunichar) '\0'))) {
				break;
			}
			_tmp4_ = chr;
			switch (_tmp4_) {
				case '<':
				{
					ValadocGtkDocMarkupWriter* _tmp5_;
					glong _tmp6_;
					gint _tmp7_;
					glong _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					ValadocMarkupWriter* _tmp11_;
					ValadocMarkupWriter* _tmp12_;
					ValadocGtkDocMarkupWriter* _tmp13_;
					ValadocMarkupWriter* _tmp14_;
					ValadocMarkupWriter* _tmp15_;
					gint _tmp16_;
					_tmp5_ = self->priv->writer;
					_tmp6_ = lpos;
					_tmp7_ = i;
					_tmp8_ = lpos;
					_tmp9_ = string_substring (content, _tmp6_, _tmp7_ - _tmp8_);
					_tmp10_ = _tmp9_;
					_tmp11_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp5_, _tmp10_);
					_tmp12_ = _tmp11_;
					_valadoc_markup_writer_unref0 (_tmp12_);
					_g_free0 (_tmp10_);
					_tmp13_ = self->priv->writer;
					_tmp14_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp13_, "&lt;");
					_tmp15_ = _tmp14_;
					_valadoc_markup_writer_unref0 (_tmp15_);
					_tmp16_ = i;
					lpos = (glong) (_tmp16_ + 1);
					break;
				}
				case '>':
				{
					ValadocGtkDocMarkupWriter* _tmp17_;
					glong _tmp18_;
					gint _tmp19_;
					glong _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					ValadocMarkupWriter* _tmp23_;
					ValadocMarkupWriter* _tmp24_;
					ValadocGtkDocMarkupWriter* _tmp25_;
					ValadocMarkupWriter* _tmp26_;
					ValadocMarkupWriter* _tmp27_;
					gint _tmp28_;
					_tmp17_ = self->priv->writer;
					_tmp18_ = lpos;
					_tmp19_ = i;
					_tmp20_ = lpos;
					_tmp21_ = string_substring (content, _tmp18_, _tmp19_ - _tmp20_);
					_tmp22_ = _tmp21_;
					_tmp23_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp17_, _tmp22_);
					_tmp24_ = _tmp23_;
					_valadoc_markup_writer_unref0 (_tmp24_);
					_g_free0 (_tmp22_);
					_tmp25_ = self->priv->writer;
					_tmp26_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp25_, "&gt;");
					_tmp27_ = _tmp26_;
					_valadoc_markup_writer_unref0 (_tmp27_);
					_tmp28_ = i;
					lpos = (glong) (_tmp28_ + 1);
					break;
				}
				case '"':
				{
					ValadocGtkDocMarkupWriter* _tmp29_;
					glong _tmp30_;
					gint _tmp31_;
					glong _tmp32_;
					gchar* _tmp33_;
					gchar* _tmp34_;
					ValadocMarkupWriter* _tmp35_;
					ValadocMarkupWriter* _tmp36_;
					ValadocGtkDocMarkupWriter* _tmp37_;
					ValadocMarkupWriter* _tmp38_;
					ValadocMarkupWriter* _tmp39_;
					gint _tmp40_;
					_tmp29_ = self->priv->writer;
					_tmp30_ = lpos;
					_tmp31_ = i;
					_tmp32_ = lpos;
					_tmp33_ = string_substring (content, _tmp30_, _tmp31_ - _tmp32_);
					_tmp34_ = _tmp33_;
					_tmp35_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp29_, _tmp34_);
					_tmp36_ = _tmp35_;
					_valadoc_markup_writer_unref0 (_tmp36_);
					_g_free0 (_tmp34_);
					_tmp37_ = self->priv->writer;
					_tmp38_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp37_, "&quot;");
					_tmp39_ = _tmp38_;
					_valadoc_markup_writer_unref0 (_tmp39_);
					_tmp40_ = i;
					lpos = (glong) (_tmp40_ + 1);
					break;
				}
				case '\'':
				{
					ValadocGtkDocMarkupWriter* _tmp41_;
					glong _tmp42_;
					gint _tmp43_;
					glong _tmp44_;
					gchar* _tmp45_;
					gchar* _tmp46_;
					ValadocMarkupWriter* _tmp47_;
					ValadocMarkupWriter* _tmp48_;
					ValadocGtkDocMarkupWriter* _tmp49_;
					ValadocMarkupWriter* _tmp50_;
					ValadocMarkupWriter* _tmp51_;
					gint _tmp52_;
					_tmp41_ = self->priv->writer;
					_tmp42_ = lpos;
					_tmp43_ = i;
					_tmp44_ = lpos;
					_tmp45_ = string_substring (content, _tmp42_, _tmp43_ - _tmp44_);
					_tmp46_ = _tmp45_;
					_tmp47_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp41_, _tmp46_);
					_tmp48_ = _tmp47_;
					_valadoc_markup_writer_unref0 (_tmp48_);
					_g_free0 (_tmp46_);
					_tmp49_ = self->priv->writer;
					_tmp50_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp49_, "&apos;");
					_tmp51_ = _tmp50_;
					_valadoc_markup_writer_unref0 (_tmp51_);
					_tmp52_ = i;
					lpos = (glong) (_tmp52_ + 1);
					break;
				}
				case '&':
				{
					ValadocGtkDocMarkupWriter* _tmp53_;
					glong _tmp54_;
					gint _tmp55_;
					glong _tmp56_;
					gchar* _tmp57_;
					gchar* _tmp58_;
					ValadocMarkupWriter* _tmp59_;
					ValadocMarkupWriter* _tmp60_;
					ValadocGtkDocMarkupWriter* _tmp61_;
					ValadocMarkupWriter* _tmp62_;
					ValadocMarkupWriter* _tmp63_;
					gint _tmp64_;
					_tmp53_ = self->priv->writer;
					_tmp54_ = lpos;
					_tmp55_ = i;
					_tmp56_ = lpos;
					_tmp57_ = string_substring (content, _tmp54_, _tmp55_ - _tmp56_);
					_tmp58_ = _tmp57_;
					_tmp59_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp53_, _tmp58_);
					_tmp60_ = _tmp59_;
					_valadoc_markup_writer_unref0 (_tmp60_);
					_g_free0 (_tmp58_);
					_tmp61_ = self->priv->writer;
					_tmp62_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp61_, "&amp;");
					_tmp63_ = _tmp62_;
					_valadoc_markup_writer_unref0 (_tmp63_);
					_tmp64_ = i;
					lpos = (glong) (_tmp64_ + 1);
					break;
				}
				case '#':
				{
					ValadocGtkDocMarkupWriter* _tmp65_;
					glong _tmp66_;
					gint _tmp67_;
					glong _tmp68_;
					gchar* _tmp69_;
					gchar* _tmp70_;
					ValadocMarkupWriter* _tmp71_;
					ValadocMarkupWriter* _tmp72_;
					ValadocGtkDocMarkupWriter* _tmp73_;
					ValadocMarkupWriter* _tmp74_;
					ValadocMarkupWriter* _tmp75_;
					gint _tmp76_;
					_tmp65_ = self->priv->writer;
					_tmp66_ = lpos;
					_tmp67_ = i;
					_tmp68_ = lpos;
					_tmp69_ = string_substring (content, _tmp66_, _tmp67_ - _tmp68_);
					_tmp70_ = _tmp69_;
					_tmp71_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp65_, _tmp70_);
					_tmp72_ = _tmp71_;
					_valadoc_markup_writer_unref0 (_tmp72_);
					_g_free0 (_tmp70_);
					_tmp73_ = self->priv->writer;
					_tmp74_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp73_, "&num;");
					_tmp75_ = _tmp74_;
					_valadoc_markup_writer_unref0 (_tmp75_);
					_tmp76_ = i;
					lpos = (glong) (_tmp76_ + 1);
					break;
				}
				case '%':
				{
					ValadocGtkDocMarkupWriter* _tmp77_;
					glong _tmp78_;
					gint _tmp79_;
					glong _tmp80_;
					gchar* _tmp81_;
					gchar* _tmp82_;
					ValadocMarkupWriter* _tmp83_;
					ValadocMarkupWriter* _tmp84_;
					ValadocGtkDocMarkupWriter* _tmp85_;
					ValadocMarkupWriter* _tmp86_;
					ValadocMarkupWriter* _tmp87_;
					gint _tmp88_;
					_tmp77_ = self->priv->writer;
					_tmp78_ = lpos;
					_tmp79_ = i;
					_tmp80_ = lpos;
					_tmp81_ = string_substring (content, _tmp78_, _tmp79_ - _tmp80_);
					_tmp82_ = _tmp81_;
					_tmp83_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp77_, _tmp82_);
					_tmp84_ = _tmp83_;
					_valadoc_markup_writer_unref0 (_tmp84_);
					_g_free0 (_tmp82_);
					_tmp85_ = self->priv->writer;
					_tmp86_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp85_, "&percnt;");
					_tmp87_ = _tmp86_;
					_valadoc_markup_writer_unref0 (_tmp87_);
					_tmp88_ = i;
					lpos = (glong) (_tmp88_ + 1);
					break;
				}
				case '@':
				{
					ValadocGtkDocMarkupWriter* _tmp89_;
					glong _tmp90_;
					gint _tmp91_;
					glong _tmp92_;
					gchar* _tmp93_;
					gchar* _tmp94_;
					ValadocMarkupWriter* _tmp95_;
					ValadocMarkupWriter* _tmp96_;
					ValadocGtkDocMarkupWriter* _tmp97_;
					ValadocMarkupWriter* _tmp98_;
					ValadocMarkupWriter* _tmp99_;
					gint _tmp100_;
					_tmp89_ = self->priv->writer;
					_tmp90_ = lpos;
					_tmp91_ = i;
					_tmp92_ = lpos;
					_tmp93_ = string_substring (content, _tmp90_, _tmp91_ - _tmp92_);
					_tmp94_ = _tmp93_;
					_tmp95_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp89_, _tmp94_);
					_tmp96_ = _tmp95_;
					_valadoc_markup_writer_unref0 (_tmp96_);
					_g_free0 (_tmp94_);
					_tmp97_ = self->priv->writer;
					_tmp98_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp97_, "&commat;");
					_tmp99_ = _tmp98_;
					_valadoc_markup_writer_unref0 (_tmp99_);
					_tmp100_ = i;
					lpos = (glong) (_tmp100_ + 1);
					break;
				}
				case '(':
				{
					ValadocGtkDocMarkupWriter* _tmp101_;
					glong _tmp102_;
					gint _tmp103_;
					glong _tmp104_;
					gchar* _tmp105_;
					gchar* _tmp106_;
					ValadocMarkupWriter* _tmp107_;
					ValadocMarkupWriter* _tmp108_;
					ValadocGtkDocMarkupWriter* _tmp109_;
					ValadocMarkupWriter* _tmp110_;
					ValadocMarkupWriter* _tmp111_;
					gint _tmp112_;
					_tmp101_ = self->priv->writer;
					_tmp102_ = lpos;
					_tmp103_ = i;
					_tmp104_ = lpos;
					_tmp105_ = string_substring (content, _tmp102_, _tmp103_ - _tmp104_);
					_tmp106_ = _tmp105_;
					_tmp107_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp101_, _tmp106_);
					_tmp108_ = _tmp107_;
					_valadoc_markup_writer_unref0 (_tmp108_);
					_g_free0 (_tmp106_);
					_tmp109_ = self->priv->writer;
					_tmp110_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp109_, "&lpar;");
					_tmp111_ = _tmp110_;
					_valadoc_markup_writer_unref0 (_tmp111_);
					_tmp112_ = i;
					lpos = (glong) (_tmp112_ + 1);
					break;
				}
				case ')':
				{
					ValadocGtkDocMarkupWriter* _tmp113_;
					glong _tmp114_;
					gint _tmp115_;
					glong _tmp116_;
					gchar* _tmp117_;
					gchar* _tmp118_;
					ValadocMarkupWriter* _tmp119_;
					ValadocMarkupWriter* _tmp120_;
					ValadocGtkDocMarkupWriter* _tmp121_;
					ValadocMarkupWriter* _tmp122_;
					ValadocMarkupWriter* _tmp123_;
					gint _tmp124_;
					_tmp113_ = self->priv->writer;
					_tmp114_ = lpos;
					_tmp115_ = i;
					_tmp116_ = lpos;
					_tmp117_ = string_substring (content, _tmp114_, _tmp115_ - _tmp116_);
					_tmp118_ = _tmp117_;
					_tmp119_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp113_, _tmp118_);
					_tmp120_ = _tmp119_;
					_valadoc_markup_writer_unref0 (_tmp120_);
					_g_free0 (_tmp118_);
					_tmp121_ = self->priv->writer;
					_tmp122_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp121_, "&rpar;");
					_tmp123_ = _tmp122_;
					_valadoc_markup_writer_unref0 (_tmp123_);
					_tmp124_ = i;
					lpos = (glong) (_tmp124_ + 1);
					break;
				}
				case '\n':
				{
					ValadocGtkDocMarkupWriter* _tmp125_;
					glong _tmp126_;
					gint _tmp127_;
					glong _tmp128_;
					gchar* _tmp129_;
					gchar* _tmp130_;
					ValadocMarkupWriter* _tmp131_;
					ValadocMarkupWriter* _tmp132_;
					ValadocGtkDocMarkupWriter* _tmp133_;
					ValadocMarkupWriter* _tmp134_;
					ValadocMarkupWriter* _tmp135_;
					gint _tmp136_;
					_tmp125_ = self->priv->writer;
					_tmp126_ = lpos;
					_tmp127_ = i;
					_tmp128_ = lpos;
					_tmp129_ = string_substring (content, _tmp126_, _tmp127_ - _tmp128_);
					_tmp130_ = _tmp129_;
					_tmp131_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp125_, _tmp130_);
					_tmp132_ = _tmp131_;
					_valadoc_markup_writer_unref0 (_tmp132_);
					_g_free0 (_tmp130_);
					_tmp133_ = self->priv->writer;
					_tmp134_ = valadoc_markup_writer_simple_tag ((ValadocMarkupWriter*) _tmp133_, "br", NULL, 0);
					_tmp135_ = _tmp134_;
					_valadoc_markup_writer_unref0 (_tmp135_);
					_tmp136_ = i;
					lpos = (glong) (_tmp136_ + 1);
					break;
				}
				default:
				break;
			}
		}
	}
	_tmp137_ = self->priv->writer;
	_tmp138_ = lpos;
	_tmp139_ = i;
	_tmp140_ = lpos;
	_tmp141_ = string_substring (content, _tmp138_, _tmp139_ - _tmp140_);
	_tmp142_ = _tmp141_;
	_tmp143_ = valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp137_, _tmp142_);
	_tmp144_ = _tmp143_;
	_valadoc_markup_writer_unref0 (_tmp144_);
	_g_free0 (_tmp142_);
}


static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


void
valadoc_gtkdoc_renderer_append_since (ValadocGtkdocRenderer* self,
                                      ValaList* taglets)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (taglets != NULL);
	{
		ValaList* __taglet_list = NULL;
		ValaList* _tmp0_;
		gint __taglet_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint __taglet_index = 0;
		_tmp0_ = _vala_iterable_ref0 (taglets);
		__taglet_list = _tmp0_;
		_tmp1_ = __taglet_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		__taglet_size = _tmp3_;
		__taglet_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValadocContentTaglet* _taglet = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValadocTagletsSince* taglet = NULL;
			ValadocContentTaglet* _tmp10_;
			ValadocTagletsSince* _tmp11_;
			gboolean _tmp12_ = FALSE;
			ValadocTagletsSince* _tmp13_;
			gboolean _tmp17_;
			ValadocGtkDocMarkupWriter* _tmp21_;
			ValadocGtkDocMarkupWriter* _tmp22_;
			ValadocMarkupWriter* _tmp23_;
			ValadocMarkupWriter* _tmp24_;
			ValadocTagletsSince* _tmp25_;
			const gchar* _tmp26_;
			const gchar* _tmp27_;
			ValadocMarkupWriter* _tmp28_;
			ValadocMarkupWriter* _tmp29_;
			ValadocGtkDocMarkupWriter* _tmp30_;
			_tmp4_ = __taglet_index;
			__taglet_index = _tmp4_ + 1;
			_tmp5_ = __taglet_index;
			_tmp6_ = __taglet_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = __taglet_list;
			_tmp8_ = __taglet_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			_taglet = (ValadocContentTaglet*) _tmp9_;
			_tmp10_ = _taglet;
			_tmp11_ = _g_object_ref0 (VALADOC_TAGLETS_IS_SINCE (_tmp10_) ? ((ValadocTagletsSince*) _tmp10_) : NULL);
			taglet = _tmp11_;
			_tmp13_ = taglet;
			if (_tmp13_ == NULL) {
				_tmp12_ = TRUE;
			} else {
				ValadocTagletsSince* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				_tmp14_ = taglet;
				_tmp15_ = valadoc_taglets_since_get_version (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp12_ = _tmp16_ == NULL;
			}
			if (_tmp12_) {
				_g_object_unref0 (taglet);
				_g_object_unref0 (_taglet);
				continue;
			}
			_tmp17_ = self->priv->separated;
			if (_tmp17_ == FALSE) {
				ValadocGtkDocMarkupWriter* _tmp18_;
				ValadocMarkupWriter* _tmp19_;
				ValadocMarkupWriter* _tmp20_;
				_tmp18_ = self->priv->writer;
				_tmp19_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp18_, "\n");
				_tmp20_ = _tmp19_;
				_valadoc_markup_writer_unref0 (_tmp20_);
			}
			_tmp21_ = self->priv->writer;
			valadoc_markup_writer_set_wrap ((ValadocMarkupWriter*) _tmp21_, FALSE);
			_tmp22_ = self->priv->writer;
			_tmp23_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp22_, "\nSince: ");
			_tmp24_ = _tmp23_;
			_tmp25_ = taglet;
			_tmp26_ = valadoc_taglets_since_get_version (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = valadoc_markup_writer_text (_tmp24_, _tmp27_);
			_tmp29_ = _tmp28_;
			_valadoc_markup_writer_unref0 (_tmp29_);
			_valadoc_markup_writer_unref0 (_tmp24_);
			_tmp30_ = self->priv->writer;
			valadoc_markup_writer_set_wrap ((ValadocMarkupWriter*) _tmp30_, TRUE);
			self->priv->separated = TRUE;
			_g_object_unref0 (taglet);
			_g_object_unref0 (_taglet);
			_vala_iterable_unref0 (__taglet_list);
			return;
		}
		_vala_iterable_unref0 (__taglet_list);
	}
}


void
valadoc_gtkdoc_renderer_append_see (ValadocGtkdocRenderer* self,
                                    ValaList* taglets)
{
	gboolean first = FALSE;
	gboolean _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (taglets != NULL);
	first = TRUE;
	{
		ValaList* __taglet_list = NULL;
		ValaList* _tmp0_;
		gint __taglet_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint __taglet_index = 0;
		_tmp0_ = _vala_iterable_ref0 (taglets);
		__taglet_list = _tmp0_;
		_tmp1_ = __taglet_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		__taglet_size = _tmp3_;
		__taglet_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValadocContentTaglet* _taglet = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValadocTagletsSee* taglet = NULL;
			ValadocContentTaglet* _tmp10_;
			ValadocTagletsSee* _tmp11_;
			gboolean _tmp12_ = FALSE;
			ValadocTagletsSee* _tmp13_;
			gboolean _tmp17_;
			ValadocTagletsSee* _tmp26_;
			ValadocApiNode* _tmp27_;
			ValadocApiNode* _tmp28_;
			_tmp4_ = __taglet_index;
			__taglet_index = _tmp4_ + 1;
			_tmp5_ = __taglet_index;
			_tmp6_ = __taglet_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = __taglet_list;
			_tmp8_ = __taglet_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			_taglet = (ValadocContentTaglet*) _tmp9_;
			_tmp10_ = _taglet;
			_tmp11_ = _g_object_ref0 (VALADOC_TAGLETS_IS_SEE (_tmp10_) ? ((ValadocTagletsSee*) _tmp10_) : NULL);
			taglet = _tmp11_;
			_tmp13_ = taglet;
			if (_tmp13_ == NULL) {
				_tmp12_ = TRUE;
			} else {
				ValadocTagletsSee* _tmp14_;
				ValadocApiNode* _tmp15_;
				ValadocApiNode* _tmp16_;
				_tmp14_ = taglet;
				_tmp15_ = valadoc_taglets_see_get_symbol (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp12_ = _tmp16_ == NULL;
			}
			if (_tmp12_) {
				_g_object_unref0 (taglet);
				_g_object_unref0 (_taglet);
				continue;
			}
			_tmp17_ = first;
			if (_tmp17_) {
				ValadocGtkDocMarkupWriter* _tmp18_;
				ValadocMarkupWriter* _tmp19_;
				ValadocMarkupWriter* _tmp20_;
				ValadocMarkupWriter* _tmp21_;
				ValadocMarkupWriter* _tmp22_;
				_tmp18_ = self->priv->writer;
				_tmp19_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp18_, "para", NULL, 0);
				_tmp20_ = _tmp19_;
				_tmp21_ = valadoc_markup_writer_text (_tmp20_, "See also: ");
				_tmp22_ = _tmp21_;
				_valadoc_markup_writer_unref0 (_tmp22_);
				_valadoc_markup_writer_unref0 (_tmp20_);
			} else {
				ValadocGtkDocMarkupWriter* _tmp23_;
				ValadocMarkupWriter* _tmp24_;
				ValadocMarkupWriter* _tmp25_;
				_tmp23_ = self->priv->writer;
				_tmp24_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp23_, ", ");
				_tmp25_ = _tmp24_;
				_valadoc_markup_writer_unref0 (_tmp25_);
			}
			_tmp26_ = taglet;
			_tmp27_ = valadoc_taglets_see_get_symbol (_tmp26_);
			_tmp28_ = _tmp27_;
			valadoc_gtkdoc_renderer_write_docbook_link (self, (ValadocApiItem*) _tmp28_);
			first = FALSE;
			_g_object_unref0 (taglet);
			_g_object_unref0 (_taglet);
		}
		_vala_iterable_unref0 (__taglet_list);
	}
	_tmp29_ = first;
	if (_tmp29_ == FALSE) {
		ValadocGtkDocMarkupWriter* _tmp30_;
		ValadocMarkupWriter* _tmp31_;
		ValadocMarkupWriter* _tmp32_;
		_tmp30_ = self->priv->writer;
		_tmp31_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp30_, "para");
		_tmp32_ = _tmp31_;
		_valadoc_markup_writer_unref0 (_tmp32_);
	}
}


void
valadoc_gtkdoc_renderer_append_exceptions (ValadocGtkdocRenderer* self,
                                           ValaList* taglets)
{
	gboolean first = FALSE;
	gboolean _tmp50_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (taglets != NULL);
	first = TRUE;
	{
		ValaList* __taglet_list = NULL;
		ValaList* _tmp0_;
		gint __taglet_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint __taglet_index = 0;
		_tmp0_ = _vala_iterable_ref0 (taglets);
		__taglet_list = _tmp0_;
		_tmp1_ = __taglet_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		__taglet_size = _tmp3_;
		__taglet_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValadocContentTaglet* _taglet = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValadocTagletsThrows* taglet = NULL;
			ValadocContentTaglet* _tmp10_;
			ValadocTagletsThrows* _tmp11_;
			gboolean _tmp12_ = FALSE;
			ValadocTagletsThrows* _tmp13_;
			gboolean _tmp17_;
			ValadocGtkDocMarkupWriter* _tmp28_;
			ValadocMarkupWriter* _tmp29_;
			ValadocMarkupWriter* _tmp30_;
			ValadocGtkDocMarkupWriter* _tmp31_;
			ValadocMarkupWriter* _tmp32_;
			ValadocMarkupWriter* _tmp33_;
			ValadocTagletsThrows* _tmp34_;
			ValadocApiNode* _tmp35_;
			ValadocApiNode* _tmp36_;
			ValadocGtkDocMarkupWriter* _tmp37_;
			ValadocMarkupWriter* _tmp38_;
			ValadocMarkupWriter* _tmp39_;
			ValadocGtkDocMarkupWriter* _tmp40_;
			ValadocMarkupWriter* _tmp41_;
			ValadocMarkupWriter* _tmp42_;
			ValadocTagletsThrows* _tmp43_;
			ValadocGtkDocMarkupWriter* _tmp44_;
			ValadocMarkupWriter* _tmp45_;
			ValadocMarkupWriter* _tmp46_;
			ValadocGtkDocMarkupWriter* _tmp47_;
			ValadocMarkupWriter* _tmp48_;
			ValadocMarkupWriter* _tmp49_;
			_tmp4_ = __taglet_index;
			__taglet_index = _tmp4_ + 1;
			_tmp5_ = __taglet_index;
			_tmp6_ = __taglet_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = __taglet_list;
			_tmp8_ = __taglet_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			_taglet = (ValadocContentTaglet*) _tmp9_;
			_tmp10_ = _taglet;
			_tmp11_ = _g_object_ref0 (VALADOC_TAGLETS_IS_THROWS (_tmp10_) ? ((ValadocTagletsThrows*) _tmp10_) : NULL);
			taglet = _tmp11_;
			_tmp13_ = taglet;
			if (_tmp13_ == NULL) {
				_tmp12_ = TRUE;
			} else {
				ValadocTagletsThrows* _tmp14_;
				ValadocApiNode* _tmp15_;
				ValadocApiNode* _tmp16_;
				_tmp14_ = taglet;
				_tmp15_ = valadoc_taglets_throws_get_error_domain (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp12_ = _tmp16_ == NULL;
			}
			if (_tmp12_) {
				_g_object_unref0 (taglet);
				_g_object_unref0 (_taglet);
				continue;
			}
			_tmp17_ = first;
			if (_tmp17_) {
				ValadocGtkDocMarkupWriter* _tmp18_;
				ValadocMarkupWriter* _tmp19_;
				ValadocMarkupWriter* _tmp20_;
				ValadocMarkupWriter* _tmp21_;
				ValadocMarkupWriter* _tmp22_;
				ValadocMarkupWriter* _tmp23_;
				ValadocMarkupWriter* _tmp24_;
				ValadocGtkDocMarkupWriter* _tmp25_;
				ValadocMarkupWriter* _tmp26_;
				ValadocMarkupWriter* _tmp27_;
				_tmp18_ = self->priv->writer;
				_tmp19_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp18_, "para", NULL, 0);
				_tmp20_ = _tmp19_;
				_tmp21_ = valadoc_markup_writer_text (_tmp20_, "This function may throw:");
				_tmp22_ = _tmp21_;
				_tmp23_ = valadoc_markup_writer_end_tag (_tmp22_, "para");
				_tmp24_ = _tmp23_;
				_valadoc_markup_writer_unref0 (_tmp24_);
				_valadoc_markup_writer_unref0 (_tmp22_);
				_valadoc_markup_writer_unref0 (_tmp20_);
				_tmp25_ = self->priv->writer;
				_tmp26_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp25_, "table", NULL, 0);
				_tmp27_ = _tmp26_;
				_valadoc_markup_writer_unref0 (_tmp27_);
			}
			_tmp28_ = self->priv->writer;
			_tmp29_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp28_, "tr", NULL, 0);
			_tmp30_ = _tmp29_;
			_valadoc_markup_writer_unref0 (_tmp30_);
			_tmp31_ = self->priv->writer;
			_tmp32_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp31_, "td", NULL, 0);
			_tmp33_ = _tmp32_;
			_valadoc_markup_writer_unref0 (_tmp33_);
			_tmp34_ = taglet;
			_tmp35_ = valadoc_taglets_throws_get_error_domain (_tmp34_);
			_tmp36_ = _tmp35_;
			valadoc_gtkdoc_renderer_write_docbook_link (self, (ValadocApiItem*) _tmp36_);
			_tmp37_ = self->priv->writer;
			_tmp38_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp37_, "td");
			_tmp39_ = _tmp38_;
			_valadoc_markup_writer_unref0 (_tmp39_);
			_tmp40_ = self->priv->writer;
			_tmp41_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp40_, "td", NULL, 0);
			_tmp42_ = _tmp41_;
			_valadoc_markup_writer_unref0 (_tmp42_);
			_tmp43_ = taglet;
			valadoc_content_content_element_accept_children ((ValadocContentContentElement*) _tmp43_, (ValadocContentContentVisitor*) self);
			_tmp44_ = self->priv->writer;
			_tmp45_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp44_, "td");
			_tmp46_ = _tmp45_;
			_valadoc_markup_writer_unref0 (_tmp46_);
			_tmp47_ = self->priv->writer;
			_tmp48_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp47_, "tr");
			_tmp49_ = _tmp48_;
			_valadoc_markup_writer_unref0 (_tmp49_);
			first = FALSE;
			_g_object_unref0 (taglet);
			_g_object_unref0 (_taglet);
		}
		_vala_iterable_unref0 (__taglet_list);
	}
	_tmp50_ = first;
	if (_tmp50_ == FALSE) {
		ValadocGtkDocMarkupWriter* _tmp51_;
		ValadocMarkupWriter* _tmp52_;
		ValadocMarkupWriter* _tmp53_;
		_tmp51_ = self->priv->writer;
		_tmp52_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp51_, "table");
		_tmp53_ = _tmp52_;
		_valadoc_markup_writer_unref0 (_tmp53_);
	}
}


const gchar*
valadoc_gtkdoc_renderer_get_content (ValadocGtkdocRenderer* self)
{
	const gchar* result;
	ValadocGtkDocMarkupWriter* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	ValadocGtkDocMarkupWriter* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->writer;
	_tmp1_ = valadoc_gtk_doc_markup_writer_get_content (_tmp0_);
	_tmp2_ = _tmp1_;
	if (g_str_has_prefix (_tmp2_, "\n")) {
		ValadocGtkDocMarkupWriter* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp3_ = self->priv->writer;
		_tmp4_ = valadoc_gtk_doc_markup_writer_get_content (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_utf8_next_char (_tmp5_);
		result = _tmp6_;
		return result;
	}
	_tmp7_ = self->priv->writer;
	_tmp8_ = valadoc_gtk_doc_markup_writer_get_content (_tmp7_);
	_tmp9_ = _tmp8_;
	result = _tmp9_;
	return result;
}


static void
valadoc_gtkdoc_renderer_class_init (ValadocGtkdocRendererClass * klass)
{
	valadoc_gtkdoc_renderer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValadocGtkdocRendererPrivate));
	((ValadocContentContentRendererClass *) klass)->render = (void (*) (ValadocContentContentRenderer*, ValadocContentContentElement*)) valadoc_gtkdoc_renderer_real_render;
	((ValadocContentContentRendererClass *) klass)->render_children = (void (*) (ValadocContentContentRenderer*, ValadocContentContentElement*)) valadoc_gtkdoc_renderer_real_render_children;
	((ValadocContentContentVisitorClass *) klass)->visit_comment = (void (*) (ValadocContentContentVisitor*, ValadocContentComment*)) valadoc_gtkdoc_renderer_real_visit_comment;
	((ValadocContentContentVisitorClass *) klass)->visit_embedded = (void (*) (ValadocContentContentVisitor*, ValadocContentEmbedded*)) valadoc_gtkdoc_renderer_real_visit_embedded;
	((ValadocContentContentVisitorClass *) klass)->visit_headline = (void (*) (ValadocContentContentVisitor*, ValadocContentHeadline*)) valadoc_gtkdoc_renderer_real_visit_headline;
	((ValadocContentContentVisitorClass *) klass)->visit_wiki_link = (void (*) (ValadocContentContentVisitor*, ValadocContentWikiLink*)) valadoc_gtkdoc_renderer_real_visit_wiki_link;
	((ValadocContentContentVisitorClass *) klass)->visit_link = (void (*) (ValadocContentContentVisitor*, ValadocContentLink*)) valadoc_gtkdoc_renderer_real_visit_link;
	((ValadocContentContentVisitorClass *) klass)->visit_symbol_link = (void (*) (ValadocContentContentVisitor*, ValadocContentSymbolLink*)) valadoc_gtkdoc_renderer_real_visit_symbol_link;
	((ValadocContentContentVisitorClass *) klass)->visit_list = (void (*) (ValadocContentContentVisitor*, ValadocContentList*)) valadoc_gtkdoc_renderer_real_visit_list;
	((ValadocContentContentVisitorClass *) klass)->visit_list_item = (void (*) (ValadocContentContentVisitor*, ValadocContentListItem*)) valadoc_gtkdoc_renderer_real_visit_list_item;
	((ValadocContentContentVisitorClass *) klass)->visit_page = (void (*) (ValadocContentContentVisitor*, ValadocContentPage*)) valadoc_gtkdoc_renderer_real_visit_page;
	((ValadocContentContentVisitorClass *) klass)->visit_paragraph = (void (*) (ValadocContentContentVisitor*, ValadocContentParagraph*)) valadoc_gtkdoc_renderer_real_visit_paragraph;
	((ValadocContentContentVisitorClass *) klass)->visit_warning = (void (*) (ValadocContentContentVisitor*, ValadocContentWarning*)) valadoc_gtkdoc_renderer_real_visit_warning;
	((ValadocContentContentVisitorClass *) klass)->visit_note = (void (*) (ValadocContentContentVisitor*, ValadocContentNote*)) valadoc_gtkdoc_renderer_real_visit_note;
	((ValadocContentContentVisitorClass *) klass)->visit_run = (void (*) (ValadocContentContentVisitor*, ValadocContentRun*)) valadoc_gtkdoc_renderer_real_visit_run;
	((ValadocContentContentVisitorClass *) klass)->visit_source_code = (void (*) (ValadocContentContentVisitor*, ValadocContentSourceCode*)) valadoc_gtkdoc_renderer_real_visit_source_code;
	((ValadocContentContentVisitorClass *) klass)->visit_table = (void (*) (ValadocContentContentVisitor*, ValadocContentTable*)) valadoc_gtkdoc_renderer_real_visit_table;
	((ValadocContentContentVisitorClass *) klass)->visit_table_cell = (void (*) (ValadocContentContentVisitor*, ValadocContentTableCell*)) valadoc_gtkdoc_renderer_real_visit_table_cell;
	((ValadocContentContentVisitorClass *) klass)->visit_table_row = (void (*) (ValadocContentContentVisitor*, ValadocContentTableRow*)) valadoc_gtkdoc_renderer_real_visit_table_row;
	((ValadocContentContentVisitorClass *) klass)->visit_text = (void (*) (ValadocContentContentVisitor*, ValadocContentText*)) valadoc_gtkdoc_renderer_real_visit_text;
	G_OBJECT_CLASS (klass)->get_property = _vala_valadoc_gtkdoc_renderer_get_property;
	G_OBJECT_CLASS (klass)->finalize = valadoc_gtkdoc_renderer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_GTKDOC_RENDERER_CONTENT_PROPERTY, valadoc_gtkdoc_renderer_properties[VALADOC_GTKDOC_RENDERER_CONTENT_PROPERTY] = g_param_spec_string ("content", "content", "content", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}


static void
valadoc_gtkdoc_renderer_instance_init (ValadocGtkdocRenderer * self)
{
	ValadocGtkDocMarkupWriter* _tmp0_;
	self->priv = VALADOC_GTKDOC_RENDERER_GET_PRIVATE (self);
	_tmp0_ = valadoc_gtk_doc_markup_writer_new ();
	self->priv->writer = _tmp0_;
}


static void
valadoc_gtkdoc_renderer_finalize (GObject * obj)
{
	ValadocGtkdocRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_TYPE_GTKDOC_RENDERER, ValadocGtkdocRenderer);
	_valadoc_markup_writer_unref0 (self->priv->writer);
	_g_object_unref0 (self->settings);
	G_OBJECT_CLASS (valadoc_gtkdoc_renderer_parent_class)->finalize (obj);
}


GType
valadoc_gtkdoc_renderer_get_type (void)
{
	static volatile gsize valadoc_gtkdoc_renderer_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_gtkdoc_renderer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValadocGtkdocRendererClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_gtkdoc_renderer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocGtkdocRenderer), 0, (GInstanceInitFunc) valadoc_gtkdoc_renderer_instance_init, NULL };
		GType valadoc_gtkdoc_renderer_type_id;
		valadoc_gtkdoc_renderer_type_id = g_type_register_static (VALADOC_CONTENT_TYPE_CONTENT_RENDERER, "ValadocGtkdocRenderer", &g_define_type_info, 0);
		g_once_init_leave (&valadoc_gtkdoc_renderer_type_id__volatile, valadoc_gtkdoc_renderer_type_id);
	}
	return valadoc_gtkdoc_renderer_type_id__volatile;
}


static void
_vala_valadoc_gtkdoc_renderer_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	ValadocGtkdocRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_TYPE_GTKDOC_RENDERER, ValadocGtkdocRenderer);
	switch (property_id) {
		case VALADOC_GTKDOC_RENDERER_CONTENT_PROPERTY:
		g_value_set_string (value, valadoc_gtkdoc_renderer_get_content (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



