/* valalocalvariable.c generated by valac, the Vala compiler
 * generated from valalocalvariable.vala, do not modify */

/* valalocalvariable.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

struct _ValaLocalVariablePrivate {
	gboolean _is_result;
	gboolean _captured;
	gboolean _init;
};


static gpointer vala_local_variable_parent_class = NULL;

#define VALA_LOCAL_VARIABLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariablePrivate))
static void vala_local_variable_real_accept (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static void vala_local_variable_real_accept_children (ValaCodeNode* base,
                                               ValaCodeVisitor* visitor);
static void vala_local_variable_real_replace_expression (ValaCodeNode* base,
                                                  ValaExpression* old_node,
                                                  ValaExpression* new_node);
static void vala_local_variable_real_replace_type (ValaCodeNode* base,
                                            ValaDataType* old_type,
                                            ValaDataType* new_type);
static gboolean vala_local_variable_real_check (ValaCodeNode* base,
                                         ValaCodeContext* context);
static void vala_local_variable_finalize (ValaCodeNode * obj);


/**
 * Creates a new local variable.
 *
 * @param name              name of the variable
 * @param initializer       optional initializer expression
 * @param source_reference  reference to source code
 * @return                  newly created variable declarator
 */
ValaLocalVariable*
vala_local_variable_construct (GType object_type,
                               ValaDataType* variable_type,
                               const gchar* name,
                               ValaExpression* initializer,
                               ValaSourceReference* source_reference)
{
	ValaLocalVariable* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaLocalVariable*) vala_variable_construct (object_type, variable_type, name, initializer, source_reference, NULL);
	return self;
}


ValaLocalVariable*
vala_local_variable_new (ValaDataType* variable_type,
                         const gchar* name,
                         ValaExpression* initializer,
                         ValaSourceReference* source_reference)
{
	return vala_local_variable_construct (VALA_TYPE_LOCAL_VARIABLE, variable_type, name, initializer, source_reference);
}


static void
vala_local_variable_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaLocalVariable * self;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_local_variable (visitor, self);
}


static void
vala_local_variable_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor)
{
	ValaLocalVariable * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp2_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
		_tmp4_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp5_ = _tmp4_;
		vala_code_visitor_visit_end_full_expression (visitor, _tmp5_);
	}
	_tmp6_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp8_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp9_ = _tmp8_;
		vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
	}
}


static void
vala_local_variable_real_replace_expression (ValaCodeNode* base,
                                             ValaExpression* old_node,
                                             ValaExpression* new_node)
{
	ValaLocalVariable * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_variable_set_initializer ((ValaVariable*) self, new_node);
	}
}


static void
vala_local_variable_real_replace_type (ValaCodeNode* base,
                                       ValaDataType* old_type,
                                       ValaDataType* new_type)
{
	ValaLocalVariable * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_variable_set_variable_type ((ValaVariable*) self, new_type);
	}
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_local_variable_real_check (ValaCodeNode* base,
                                ValaCodeContext* context)
{
	ValaLocalVariable * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	gboolean is_initializer_list = FALSE;
	gint initializer_size = 0;
	ValaExpression* _tmp12_;
	ValaExpression* _tmp13_;
	ValaDataType* _tmp26_;
	ValaDataType* _tmp27_;
	gboolean _tmp73_ = FALSE;
	ValaExpression* _tmp74_;
	ValaExpression* _tmp75_;
	ValaSemanticAnalyzer* _tmp196_;
	ValaSemanticAnalyzer* _tmp197_;
	ValaSymbol* _tmp198_;
	ValaSymbol* _tmp199_;
	ValaScope* _tmp200_;
	ValaScope* _tmp201_;
	const gchar* _tmp202_;
	const gchar* _tmp203_;
	ValaBlock* block = NULL;
	ValaSemanticAnalyzer* _tmp204_;
	ValaSemanticAnalyzer* _tmp205_;
	ValaSymbol* _tmp206_;
	ValaSymbol* _tmp207_;
	ValaBlock* _tmp208_;
	ValaBlock* _tmp209_;
	gboolean _tmp211_;
	gboolean _tmp212_;
	self = (ValaLocalVariable*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		ValaDataType* _tmp10_;
		ValaDataType* _tmp11_;
		_tmp6_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp7_ = _tmp6_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_VOID_TYPE)) {
			ValaSourceReference* _tmp8_;
			ValaSourceReference* _tmp9_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp9_ = _tmp8_;
			vala_report_error (_tmp9_, "'void' not supported as variable type");
			result = FALSE;
			return result;
		}
		_tmp10_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp11_ = _tmp10_;
		vala_code_node_check ((ValaCodeNode*) _tmp11_, context);
	}
	is_initializer_list = FALSE;
	initializer_size = -1;
	_tmp12_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaExpression* _tmp14_;
		ValaExpression* _tmp15_;
		ValaDataType* _tmp16_;
		ValaDataType* _tmp17_;
		ValaExpression* _tmp18_;
		ValaExpression* _tmp19_;
		ValaExpression* _tmp24_;
		ValaExpression* _tmp25_;
		_tmp14_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp17_ = _tmp16_;
		vala_expression_set_target_type (_tmp15_, _tmp17_);
		_tmp18_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp19_ = _tmp18_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, VALA_TYPE_INITIALIZER_LIST)) {
			ValaExpression* _tmp20_;
			ValaExpression* _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			_tmp20_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_initializer_list_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
			_tmp23_ = _tmp22_;
			initializer_size = _tmp23_;
			is_initializer_list = TRUE;
		}
		_tmp24_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp25_ = _tmp24_;
		vala_code_node_check ((ValaCodeNode*) _tmp25_, context);
	}
	_tmp26_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp27_ = _tmp26_;
	if (_tmp27_ == NULL) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaExpression* _tmp32_;
		ValaExpression* _tmp33_;
		ValaDataType* _tmp34_;
		ValaDataType* _tmp35_;
		gboolean _tmp38_ = FALSE;
		ValaExpression* _tmp39_;
		ValaExpression* _tmp40_;
		ValaDataType* _tmp41_;
		ValaDataType* _tmp42_;
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		ValaDataType* _tmp61_;
		ValaDataType* _tmp62_;
		ValaDataType* _tmp63_;
		ValaDataType* _tmp64_;
		ValaDataType* _tmp65_;
		ValaDataType* _tmp66_;
		ValaDataType* _tmp67_;
		ValaDataType* _tmp68_;
		ValaExpression* _tmp69_;
		ValaExpression* _tmp70_;
		ValaDataType* _tmp71_;
		ValaDataType* _tmp72_;
		_tmp28_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp29_ = _tmp28_;
		if (_tmp29_ == NULL) {
			ValaSourceReference* _tmp30_;
			ValaSourceReference* _tmp31_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp31_ = _tmp30_;
			vala_report_error (_tmp31_, "var declaration not allowed without initializer");
			result = FALSE;
			return result;
		}
		_tmp32_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_expression_get_value_type (_tmp33_);
		_tmp35_ = _tmp34_;
		if (_tmp35_ == NULL) {
			ValaSourceReference* _tmp36_;
			ValaSourceReference* _tmp37_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp37_ = _tmp36_;
			vala_report_error (_tmp37_, "var declaration not allowed with non-typed initializer");
			result = FALSE;
			return result;
		}
		_tmp39_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_expression_get_value_type (_tmp40_);
		_tmp42_ = _tmp41_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp42_, VALA_TYPE_FIELD_PROTOTYPE)) {
			_tmp38_ = TRUE;
		} else {
			ValaExpression* _tmp43_;
			ValaExpression* _tmp44_;
			ValaDataType* _tmp45_;
			ValaDataType* _tmp46_;
			_tmp43_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_expression_get_value_type (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp38_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp46_, VALA_TYPE_PROPERTY_PROTOTYPE);
		}
		if (_tmp38_) {
			ValaExpression* _tmp47_;
			ValaExpression* _tmp48_;
			ValaSourceReference* _tmp49_;
			ValaSourceReference* _tmp50_;
			ValaExpression* _tmp51_;
			ValaExpression* _tmp52_;
			ValaSymbol* _tmp53_;
			ValaSymbol* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp47_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp48_);
			_tmp50_ = _tmp49_;
			_tmp51_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp52_ = _tmp51_;
			_tmp53_ = vala_expression_get_symbol_reference (_tmp52_);
			_tmp54_ = _tmp53_;
			_tmp55_ = vala_symbol_get_full_name (_tmp54_);
			_tmp56_ = _tmp55_;
			_tmp57_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp56_);
			_tmp58_ = _tmp57_;
			vala_report_error (_tmp50_, _tmp58_);
			_g_free0 (_tmp58_);
			_g_free0 (_tmp56_);
			result = FALSE;
			return result;
		}
		_tmp59_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp60_ = _tmp59_;
		_tmp61_ = vala_expression_get_value_type (_tmp60_);
		_tmp62_ = _tmp61_;
		_tmp63_ = vala_data_type_copy (_tmp62_);
		_tmp64_ = _tmp63_;
		vala_variable_set_variable_type ((ValaVariable*) self, _tmp64_);
		_vala_code_node_unref0 (_tmp64_);
		_tmp65_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp66_ = _tmp65_;
		vala_data_type_set_value_owned (_tmp66_, TRUE);
		_tmp67_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp68_ = _tmp67_;
		vala_data_type_set_floating_reference (_tmp68_, FALSE);
		_tmp69_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp70_ = _tmp69_;
		_tmp71_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp72_ = _tmp71_;
		vala_expression_set_target_type (_tmp70_, _tmp72_);
	}
	_tmp74_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp75_ = _tmp74_;
	if (_tmp75_ != NULL) {
		ValaExpression* _tmp76_;
		ValaExpression* _tmp77_;
		gboolean _tmp78_;
		gboolean _tmp79_;
		_tmp76_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp77_ = _tmp76_;
		_tmp78_ = vala_code_node_get_error ((ValaCodeNode*) _tmp77_);
		_tmp79_ = _tmp78_;
		_tmp73_ = !_tmp79_;
	} else {
		_tmp73_ = FALSE;
	}
	if (_tmp73_) {
		ValaExpression* _tmp80_;
		ValaExpression* _tmp81_;
		ValaDataType* _tmp82_;
		ValaDataType* _tmp83_;
		ValaExpression* _tmp129_;
		ValaExpression* _tmp130_;
		ValaDataType* _tmp131_;
		ValaDataType* _tmp132_;
		ValaDataType* _tmp133_;
		ValaDataType* _tmp134_;
		ValaArrayType* variable_array_type = NULL;
		ValaDataType* _tmp149_;
		ValaDataType* _tmp150_;
		ValaArrayType* _tmp151_;
		gboolean _tmp152_ = FALSE;
		gboolean _tmp153_ = FALSE;
		gboolean _tmp154_ = FALSE;
		ValaArrayType* _tmp155_;
		gboolean _tmp171_ = FALSE;
		gboolean _tmp172_ = FALSE;
		ValaArrayType* _tmp173_;
		ValaExpression* _tmp183_;
		ValaExpression* _tmp184_;
		ValaDataType* _tmp185_;
		ValaDataType* _tmp186_;
		_tmp80_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp81_ = _tmp80_;
		_tmp82_ = vala_expression_get_value_type (_tmp81_);
		_tmp83_ = _tmp82_;
		if (_tmp83_ == NULL) {
			gboolean _tmp84_ = FALSE;
			ValaExpression* _tmp85_;
			ValaExpression* _tmp86_;
			gboolean _tmp91_ = FALSE;
			ValaExpression* _tmp92_;
			ValaExpression* _tmp93_;
			ValaSymbol* _tmp94_;
			ValaSymbol* _tmp95_;
			_tmp85_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp86_ = _tmp85_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp86_, VALA_TYPE_MEMBER_ACCESS)) {
				ValaExpression* _tmp87_;
				ValaExpression* _tmp88_;
				_tmp87_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp88_ = _tmp87_;
				_tmp84_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp88_, VALA_TYPE_LAMBDA_EXPRESSION);
			} else {
				_tmp84_ = FALSE;
			}
			if (_tmp84_) {
				ValaSourceReference* _tmp89_;
				ValaSourceReference* _tmp90_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp89_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp90_ = _tmp89_;
				vala_report_error (_tmp90_, "expression type not allowed as initializer");
				result = FALSE;
				return result;
			}
			_tmp92_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp93_ = _tmp92_;
			_tmp94_ = vala_expression_get_symbol_reference (_tmp93_);
			_tmp95_ = _tmp94_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp95_, VALA_TYPE_METHOD)) {
				ValaDataType* _tmp96_;
				ValaDataType* _tmp97_;
				_tmp96_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp97_ = _tmp96_;
				_tmp91_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp97_, VALA_TYPE_DELEGATE_TYPE);
			} else {
				_tmp91_ = FALSE;
			}
			if (_tmp91_) {
				ValaMethod* m = NULL;
				ValaExpression* _tmp98_;
				ValaExpression* _tmp99_;
				ValaSymbol* _tmp100_;
				ValaSymbol* _tmp101_;
				ValaMethod* _tmp102_;
				ValaDelegateType* dt = NULL;
				ValaDataType* _tmp103_;
				ValaDataType* _tmp104_;
				ValaDelegateType* _tmp105_;
				ValaDelegate* cb = NULL;
				ValaDelegateType* _tmp106_;
				ValaDelegate* _tmp107_;
				ValaDelegate* _tmp108_;
				ValaDelegate* _tmp109_;
				ValaDelegate* _tmp110_;
				ValaMethod* _tmp111_;
				ValaDelegateType* _tmp112_;
				ValaExpression* _tmp123_;
				ValaExpression* _tmp124_;
				ValaDataType* _tmp125_;
				ValaDataType* _tmp126_;
				_tmp98_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp99_ = _tmp98_;
				_tmp100_ = vala_expression_get_symbol_reference (_tmp99_);
				_tmp101_ = _tmp100_;
				_tmp102_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp101_, VALA_TYPE_METHOD, ValaMethod));
				m = _tmp102_;
				_tmp103_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp104_ = _tmp103_;
				_tmp105_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp104_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				dt = _tmp105_;
				_tmp106_ = dt;
				_tmp107_ = vala_delegate_type_get_delegate_symbol (_tmp106_);
				_tmp108_ = _tmp107_;
				_tmp109_ = _vala_code_node_ref0 (_tmp108_);
				cb = _tmp109_;
				_tmp110_ = cb;
				_tmp111_ = m;
				_tmp112_ = dt;
				if (!vala_delegate_matches_method (_tmp110_, _tmp111_, (ValaDataType*) _tmp112_)) {
					ValaSourceReference* _tmp113_;
					ValaSourceReference* _tmp114_;
					ValaMethod* _tmp115_;
					gchar* _tmp116_;
					gchar* _tmp117_;
					ValaDelegate* _tmp118_;
					gchar* _tmp119_;
					gchar* _tmp120_;
					gchar* _tmp121_;
					gchar* _tmp122_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp113_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp114_ = _tmp113_;
					_tmp115_ = m;
					_tmp116_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp115_);
					_tmp117_ = _tmp116_;
					_tmp118_ = cb;
					_tmp119_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp118_);
					_tmp120_ = _tmp119_;
					_tmp121_ = g_strdup_printf ("declaration of method `%s' doesn't match declaration of callback `%s'", _tmp117_, _tmp120_);
					_tmp122_ = _tmp121_;
					vala_report_error (_tmp114_, _tmp122_);
					_g_free0 (_tmp122_);
					_g_free0 (_tmp120_);
					_g_free0 (_tmp117_);
					result = FALSE;
					_vala_code_node_unref0 (cb);
					_vala_code_node_unref0 (dt);
					_vala_code_node_unref0 (m);
					return result;
				}
				_tmp123_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp124_ = _tmp123_;
				_tmp125_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp126_ = _tmp125_;
				vala_expression_set_value_type (_tmp124_, _tmp126_);
				_vala_code_node_unref0 (cb);
				_vala_code_node_unref0 (dt);
				_vala_code_node_unref0 (m);
			} else {
				ValaSourceReference* _tmp127_;
				ValaSourceReference* _tmp128_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp127_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp128_ = _tmp127_;
				vala_report_error (_tmp128_, "expression type not allowed as initializer");
				result = FALSE;
				return result;
			}
		}
		_tmp129_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp130_ = _tmp129_;
		_tmp131_ = vala_expression_get_value_type (_tmp130_);
		_tmp132_ = _tmp131_;
		_tmp133_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp134_ = _tmp133_;
		if (!vala_data_type_compatible (_tmp132_, _tmp134_)) {
			ValaSourceReference* _tmp135_;
			ValaSourceReference* _tmp136_;
			ValaExpression* _tmp137_;
			ValaExpression* _tmp138_;
			ValaDataType* _tmp139_;
			ValaDataType* _tmp140_;
			gchar* _tmp141_;
			gchar* _tmp142_;
			ValaDataType* _tmp143_;
			ValaDataType* _tmp144_;
			gchar* _tmp145_;
			gchar* _tmp146_;
			gchar* _tmp147_;
			gchar* _tmp148_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp135_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp136_ = _tmp135_;
			_tmp137_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp138_ = _tmp137_;
			_tmp139_ = vala_expression_get_value_type (_tmp138_);
			_tmp140_ = _tmp139_;
			_tmp141_ = vala_code_node_to_string ((ValaCodeNode*) _tmp140_);
			_tmp142_ = _tmp141_;
			_tmp143_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp144_ = _tmp143_;
			_tmp145_ = vala_code_node_to_string ((ValaCodeNode*) _tmp144_);
			_tmp146_ = _tmp145_;
			_tmp147_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp142_, _tmp146_);
			_tmp148_ = _tmp147_;
			vala_report_error (_tmp136_, _tmp148_);
			_g_free0 (_tmp148_);
			_g_free0 (_tmp146_);
			_g_free0 (_tmp142_);
			result = FALSE;
			return result;
		}
		_tmp149_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp150_ = _tmp149_;
		_tmp151_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp150_, VALA_TYPE_ARRAY_TYPE) ? ((ValaArrayType*) _tmp150_) : NULL);
		variable_array_type = _tmp151_;
		_tmp155_ = variable_array_type;
		if (_tmp155_ != NULL) {
			ValaArrayType* _tmp156_;
			gboolean _tmp157_;
			gboolean _tmp158_;
			_tmp156_ = variable_array_type;
			_tmp157_ = vala_array_type_get_inline_allocated (_tmp156_);
			_tmp158_ = _tmp157_;
			_tmp154_ = _tmp158_;
		} else {
			_tmp154_ = FALSE;
		}
		if (_tmp154_) {
			ValaArrayType* _tmp159_;
			gboolean _tmp160_;
			gboolean _tmp161_;
			_tmp159_ = variable_array_type;
			_tmp160_ = vala_array_type_get_fixed_length (_tmp159_);
			_tmp161_ = _tmp160_;
			_tmp153_ = !_tmp161_;
		} else {
			_tmp153_ = FALSE;
		}
		if (_tmp153_) {
			gboolean _tmp162_;
			_tmp162_ = is_initializer_list;
			_tmp152_ = _tmp162_;
		} else {
			_tmp152_ = FALSE;
		}
		if (_tmp152_) {
			ValaArrayType* _tmp163_;
			gint _tmp164_;
			gchar* _tmp165_;
			gchar* _tmp166_;
			ValaIntegerLiteral* _tmp167_;
			ValaIntegerLiteral* _tmp168_;
			ValaArrayType* _tmp169_;
			ValaArrayType* _tmp170_;
			_tmp163_ = variable_array_type;
			_tmp164_ = initializer_size;
			_tmp165_ = g_strdup_printf ("%i", _tmp164_);
			_tmp166_ = _tmp165_;
			_tmp167_ = vala_integer_literal_new (_tmp166_, NULL);
			_tmp168_ = _tmp167_;
			vala_array_type_set_length (_tmp163_, (ValaExpression*) _tmp168_);
			_vala_code_node_unref0 (_tmp168_);
			_g_free0 (_tmp166_);
			_tmp169_ = variable_array_type;
			vala_array_type_set_fixed_length (_tmp169_, TRUE);
			_tmp170_ = variable_array_type;
			vala_data_type_set_nullable ((ValaDataType*) _tmp170_, FALSE);
		}
		_tmp173_ = variable_array_type;
		if (_tmp173_ != NULL) {
			ValaArrayType* _tmp174_;
			gboolean _tmp175_;
			gboolean _tmp176_;
			_tmp174_ = variable_array_type;
			_tmp175_ = vala_array_type_get_inline_allocated (_tmp174_);
			_tmp176_ = _tmp175_;
			_tmp172_ = _tmp176_;
		} else {
			_tmp172_ = FALSE;
		}
		if (_tmp172_) {
			ValaExpression* _tmp177_;
			ValaExpression* _tmp178_;
			ValaDataType* _tmp179_;
			ValaDataType* _tmp180_;
			_tmp177_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp178_ = _tmp177_;
			_tmp179_ = vala_expression_get_value_type (_tmp178_);
			_tmp180_ = _tmp179_;
			_tmp171_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp180_, VALA_TYPE_ARRAY_TYPE) == FALSE;
		} else {
			_tmp171_ = FALSE;
		}
		if (_tmp171_) {
			ValaSourceReference* _tmp181_;
			ValaSourceReference* _tmp182_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp181_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp182_ = _tmp181_;
			vala_report_error (_tmp182_, "only arrays are allowed as initializer for arrays with fixed length");
			result = FALSE;
			_vala_code_node_unref0 (variable_array_type);
			return result;
		}
		_tmp183_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp184_ = _tmp183_;
		_tmp185_ = vala_expression_get_value_type (_tmp184_);
		_tmp186_ = _tmp185_;
		if (vala_data_type_is_disposable (_tmp186_)) {
			gboolean _tmp187_ = FALSE;
			ValaDataType* _tmp188_;
			ValaDataType* _tmp189_;
			_tmp188_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp189_ = _tmp188_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp189_, VALA_TYPE_POINTER_TYPE)) {
				ValaDataType* _tmp190_;
				ValaDataType* _tmp191_;
				gboolean _tmp192_;
				gboolean _tmp193_;
				_tmp190_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp191_ = _tmp190_;
				_tmp192_ = vala_data_type_get_value_owned (_tmp191_);
				_tmp193_ = _tmp192_;
				_tmp187_ = !_tmp193_;
			} else {
				_tmp187_ = FALSE;
			}
			if (_tmp187_) {
				ValaSourceReference* _tmp194_;
				ValaSourceReference* _tmp195_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp194_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp195_ = _tmp194_;
				vala_report_error (_tmp195_, "Invalid assignment from owned expression to unowned variable");
				result = FALSE;
				_vala_code_node_unref0 (variable_array_type);
				return result;
			}
		}
		_vala_code_node_unref0 (variable_array_type);
	}
	_tmp196_ = vala_code_context_get_analyzer (context);
	_tmp197_ = _tmp196_;
	_tmp198_ = vala_semantic_analyzer_get_current_symbol (_tmp197_);
	_tmp199_ = _tmp198_;
	_tmp200_ = vala_symbol_get_scope (_tmp199_);
	_tmp201_ = _tmp200_;
	_tmp202_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp203_ = _tmp202_;
	vala_scope_add (_tmp201_, _tmp203_, (ValaSymbol*) self);
	_tmp204_ = vala_code_context_get_analyzer (context);
	_tmp205_ = _tmp204_;
	_tmp206_ = vala_semantic_analyzer_get_current_symbol (_tmp205_);
	_tmp207_ = _tmp206_;
	_tmp208_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp207_, VALA_TYPE_BLOCK) ? ((ValaBlock*) _tmp207_) : NULL);
	block = _tmp208_;
	_tmp209_ = block;
	if (_tmp209_ != NULL) {
		ValaBlock* _tmp210_;
		_tmp210_ = block;
		vala_block_add_local_variable (_tmp210_, self);
	}
	vala_symbol_set_active ((ValaSymbol*) self, TRUE);
	_tmp211_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp212_ = _tmp211_;
	result = !_tmp212_;
	_vala_code_node_unref0 (block);
	return result;
}


gboolean
vala_local_variable_get_is_result (ValaLocalVariable* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_result;
	result = _tmp0_;
	return result;
}


void
vala_local_variable_set_is_result (ValaLocalVariable* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_result = value;
}


gboolean
vala_local_variable_get_captured (ValaLocalVariable* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_captured;
	result = _tmp0_;
	return result;
}


void
vala_local_variable_set_captured (ValaLocalVariable* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_captured = value;
}


gboolean
vala_local_variable_get_init (ValaLocalVariable* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_init;
	result = _tmp0_;
	return result;
}


void
vala_local_variable_set_init (ValaLocalVariable* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_init = value;
}


static void
vala_local_variable_class_init (ValaLocalVariableClass * klass)
{
	vala_local_variable_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_local_variable_finalize;
	g_type_class_add_private (klass, sizeof (ValaLocalVariablePrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_local_variable_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_local_variable_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_local_variable_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_local_variable_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_local_variable_real_check;
}


static void
vala_local_variable_instance_init (ValaLocalVariable * self)
{
	self->priv = VALA_LOCAL_VARIABLE_GET_PRIVATE (self);
}


static void
vala_local_variable_finalize (ValaCodeNode * obj)
{
	ValaLocalVariable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
	VALA_CODE_NODE_CLASS (vala_local_variable_parent_class)->finalize (obj);
}


/**
 * Represents a local variable declaration in the source code.
 */
GType
vala_local_variable_get_type (void)
{
	static volatile gsize vala_local_variable_type_id__volatile = 0;
	if (g_once_init_enter (&vala_local_variable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaLocalVariableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_local_variable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaLocalVariable), 0, (GInstanceInitFunc) vala_local_variable_instance_init, NULL };
		GType vala_local_variable_type_id;
		vala_local_variable_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaLocalVariable", &g_define_type_info, 0);
		g_once_init_leave (&vala_local_variable_type_id__volatile, vala_local_variable_type_id);
	}
	return vala_local_variable_type_id__volatile;
}



