/* valabinaryexpression.c generated by valac, the Vala compiler
 * generated from valabinaryexpression.vala, do not modify */

/* valabinaryexpression.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaBinaryExpressionPrivate {
	ValaBinaryOperator _operator;
	gboolean _is_chained;
	ValaExpression* _left;
	ValaExpression* _right;
};


static gpointer vala_binary_expression_parent_class = NULL;

#define VALA_BINARY_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpressionPrivate))
static void vala_binary_expression_set_is_chained (ValaBinaryExpression* self,
                                            gboolean value);
static void vala_binary_expression_real_accept (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor);
static void vala_binary_expression_real_accept_children (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor);
static void vala_binary_expression_real_replace_expression (ValaCodeNode* base,
                                                     ValaExpression* old_node,
                                                     ValaExpression* new_node);
static const gchar* vala_binary_expression_get_operator_string (ValaBinaryExpression* self);
static gchar* vala_binary_expression_real_to_string (ValaCodeNode* base);
static gboolean vala_binary_expression_real_is_constant (ValaExpression* base);
static gboolean vala_binary_expression_real_is_pure (ValaExpression* base);
static gboolean vala_binary_expression_real_is_non_null (ValaExpression* base);
static gboolean vala_binary_expression_real_is_accessible (ValaExpression* base,
                                                    ValaSymbol* sym);
static gboolean vala_binary_expression_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context);
static void vala_binary_expression_real_emit (ValaCodeNode* base,
                                       ValaCodeGenerator* codegen);
static void vala_binary_expression_real_get_defined_variables (ValaCodeNode* base,
                                                        ValaCollection* collection);
static void vala_binary_expression_real_get_used_variables (ValaCodeNode* base,
                                                     ValaCollection* collection);
static void vala_binary_expression_finalize (ValaCodeNode * obj);


/**
 * Creates a new binary expression.
 *
 * @param op      binary operator
 * @param _left   left operand
 * @param _right  right operand
 * @param source  reference to source code
 * @return        newly created binary expression
 */
ValaBinaryExpression*
vala_binary_expression_construct (GType object_type,
                                  ValaBinaryOperator op,
                                  ValaExpression* _left,
                                  ValaExpression* _right,
                                  ValaSourceReference* source)
{
	ValaBinaryExpression* self = NULL;
	g_return_val_if_fail (_left != NULL, NULL);
	g_return_val_if_fail (_right != NULL, NULL);
	self = (ValaBinaryExpression*) vala_expression_construct (object_type);
	vala_binary_expression_set_operator (self, op);
	vala_binary_expression_set_left (self, _left);
	vala_binary_expression_set_right (self, _right);
	vala_binary_expression_set_is_chained (self, FALSE);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source);
	return self;
}


ValaBinaryExpression*
vala_binary_expression_new (ValaBinaryOperator op,
                            ValaExpression* _left,
                            ValaExpression* _right,
                            ValaSourceReference* source)
{
	return vala_binary_expression_construct (VALA_TYPE_BINARY_EXPRESSION, op, _left, _right, source);
}


ValaBinaryExpression*
vala_binary_expression_construct_chained (GType object_type,
                                          ValaBinaryOperator op,
                                          ValaExpression* _left,
                                          ValaExpression* _right,
                                          ValaSourceReference* source)
{
	ValaBinaryExpression* self = NULL;
	g_return_val_if_fail (_left != NULL, NULL);
	g_return_val_if_fail (_right != NULL, NULL);
	self = (ValaBinaryExpression*) vala_expression_construct (object_type);
	vala_binary_expression_set_operator (self, op);
	vala_binary_expression_set_left (self, _left);
	vala_binary_expression_set_right (self, _right);
	vala_binary_expression_set_is_chained (self, TRUE);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source);
	return self;
}


ValaBinaryExpression*
vala_binary_expression_new_chained (ValaBinaryOperator op,
                                    ValaExpression* _left,
                                    ValaExpression* _right,
                                    ValaSourceReference* source)
{
	return vala_binary_expression_construct_chained (VALA_TYPE_BINARY_EXPRESSION, op, _left, _right, source);
}


static void
vala_binary_expression_real_accept (ValaCodeNode* base,
                                    ValaCodeVisitor* visitor)
{
	ValaBinaryExpression * self;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_binary_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void
vala_binary_expression_real_accept_children (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
}


static void
vala_binary_expression_real_replace_expression (ValaCodeNode* base,
                                                ValaExpression* old_node,
                                                ValaExpression* new_node)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_binary_expression_set_left (self, new_node);
	}
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_node) {
		vala_binary_expression_set_right (self, new_node);
	}
}


static const gchar*
vala_binary_expression_get_operator_string (ValaBinaryExpression* self)
{
	const gchar* result = NULL;
	ValaBinaryOperator _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_operator;
	switch (_tmp0_) {
		case VALA_BINARY_OPERATOR_PLUS:
		{
			result = "+";
			return result;
		}
		case VALA_BINARY_OPERATOR_MINUS:
		{
			result = "-";
			return result;
		}
		case VALA_BINARY_OPERATOR_MUL:
		{
			result = "*";
			return result;
		}
		case VALA_BINARY_OPERATOR_DIV:
		{
			result = "/";
			return result;
		}
		case VALA_BINARY_OPERATOR_MOD:
		{
			result = "%";
			return result;
		}
		case VALA_BINARY_OPERATOR_SHIFT_LEFT:
		{
			result = "<<";
			return result;
		}
		case VALA_BINARY_OPERATOR_SHIFT_RIGHT:
		{
			result = ">>";
			return result;
		}
		case VALA_BINARY_OPERATOR_LESS_THAN:
		{
			result = "<";
			return result;
		}
		case VALA_BINARY_OPERATOR_GREATER_THAN:
		{
			result = ">";
			return result;
		}
		case VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL:
		{
			result = "<=";
			return result;
		}
		case VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL:
		{
			result = ">=";
			return result;
		}
		case VALA_BINARY_OPERATOR_EQUALITY:
		{
			result = "==";
			return result;
		}
		case VALA_BINARY_OPERATOR_INEQUALITY:
		{
			result = "!=";
			return result;
		}
		case VALA_BINARY_OPERATOR_BITWISE_AND:
		{
			result = "&";
			return result;
		}
		case VALA_BINARY_OPERATOR_BITWISE_OR:
		{
			result = "|";
			return result;
		}
		case VALA_BINARY_OPERATOR_BITWISE_XOR:
		{
			result = "^";
			return result;
		}
		case VALA_BINARY_OPERATOR_AND:
		{
			result = "&&";
			return result;
		}
		case VALA_BINARY_OPERATOR_OR:
		{
			result = "||";
			return result;
		}
		case VALA_BINARY_OPERATOR_IN:
		{
			result = "in";
			return result;
		}
		case VALA_BINARY_OPERATOR_COALESCE:
		{
			result = "??";
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static gchar*
vala_binary_expression_real_to_string (ValaCodeNode* base)
{
	ValaBinaryExpression * self;
	gchar* result = NULL;
	ValaExpression* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaExpression* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	self = (ValaBinaryExpression*) base;
	_tmp0_ = self->priv->_left;
	_tmp1_ = vala_code_node_to_string ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_binary_expression_get_operator_string (self);
	_tmp4_ = self->priv->_right;
	_tmp5_ = vala_code_node_to_string ((ValaCodeNode*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("(%s %s %s)", _tmp2_, _tmp3_, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp2_);
	result = _tmp8_;
	return result;
}


static gboolean
vala_binary_expression_real_is_constant (ValaExpression* base)
{
	ValaBinaryExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaBinaryExpression*) base;
	_tmp1_ = vala_binary_expression_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_constant (_tmp2_)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_binary_expression_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_constant (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean
vala_binary_expression_real_is_pure (ValaExpression* base)
{
	ValaBinaryExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaBinaryExpression*) base;
	_tmp1_ = vala_binary_expression_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_pure (_tmp2_)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_binary_expression_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_pure (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean
vala_binary_expression_real_is_non_null (ValaExpression* base)
{
	ValaBinaryExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaBinaryExpression*) base;
	_tmp1_ = vala_binary_expression_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_non_null (_tmp2_)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_binary_expression_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_non_null (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean
vala_binary_expression_real_is_accessible (ValaExpression* base,
                                           ValaSymbol* sym)
{
	ValaBinaryExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaBinaryExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_binary_expression_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_accessible (_tmp2_, sym)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_binary_expression_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_accessible (_tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_binary_expression_real_check (ValaCodeNode* base,
                                   ValaCodeContext* context)
{
	ValaBinaryExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSemanticAnalyzer* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaBinaryOperator _tmp126_;
	gboolean _tmp319_ = FALSE;
	gboolean _tmp320_ = FALSE;
	ValaDataType* _tmp321_;
	ValaDataType* _tmp322_;
	ValaExpression* _tmp342_;
	ValaExpression* _tmp343_;
	gboolean _tmp344_ = FALSE;
	gboolean _tmp345_ = FALSE;
	ValaExpression* _tmp346_;
	ValaExpression* _tmp347_;
	ValaDataType* _tmp348_;
	ValaDataType* _tmp349_;
	ValaExpression* _tmp367_;
	ValaExpression* _tmp368_;
	gboolean _tmp369_ = FALSE;
	gboolean _tmp370_ = FALSE;
	ValaExpression* _tmp371_;
	ValaExpression* _tmp372_;
	ValaDataType* _tmp373_;
	ValaDataType* _tmp374_;
	gboolean _tmp392_ = FALSE;
	ValaExpression* _tmp393_;
	ValaExpression* _tmp394_;
	ValaExpression* _tmp397_;
	ValaExpression* _tmp398_;
	ValaDataType* _tmp399_;
	ValaDataType* _tmp400_;
	gboolean _tmp405_ = FALSE;
	ValaBinaryOperator _tmp406_;
	ValaExpression* _tmp415_;
	ValaExpression* _tmp416_;
	ValaDataType* _tmp417_;
	ValaDataType* _tmp418_;
	ValaExpression* _tmp431_;
	ValaExpression* _tmp432_;
	ValaDataType* _tmp433_;
	ValaDataType* _tmp434_;
	ValaExpression* _tmp447_;
	ValaExpression* _tmp448_;
	ValaExpression* _tmp449_;
	ValaExpression* _tmp450_;
	ValaDataType* _tmp451_;
	ValaDataType* _tmp452_;
	ValaDataType* _tmp453_;
	ValaDataType* _tmp454_;
	ValaExpression* _tmp455_;
	ValaExpression* _tmp456_;
	ValaDataType* _tmp457_;
	ValaDataType* _tmp458_;
	ValaExpression* _tmp459_;
	ValaExpression* _tmp460_;
	ValaExpression* _tmp461_;
	ValaExpression* _tmp462_;
	ValaDataType* _tmp463_;
	ValaDataType* _tmp464_;
	ValaDataType* _tmp465_;
	ValaDataType* _tmp466_;
	ValaExpression* _tmp467_;
	ValaExpression* _tmp468_;
	ValaDataType* _tmp469_;
	ValaDataType* _tmp470_;
	gboolean _tmp471_ = FALSE;
	ValaExpression* _tmp472_;
	ValaExpression* _tmp473_;
	ValaDataType* _tmp474_;
	ValaDataType* _tmp475_;
	ValaTypeSymbol* _tmp476_;
	ValaTypeSymbol* _tmp477_;
	ValaSemanticAnalyzer* _tmp478_;
	ValaSemanticAnalyzer* _tmp479_;
	ValaDataType* _tmp480_;
	ValaTypeSymbol* _tmp481_;
	ValaTypeSymbol* _tmp482_;
	gboolean _tmp1036_;
	gboolean _tmp1037_;
	self = (ValaBinaryExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = vala_code_context_get_analyzer (context);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_semantic_analyzer_get_current_symbol (_tmp6_);
	_tmp8_ = _tmp7_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_BLOCK)) {
		gboolean _tmp9_ = FALSE;
		ValaBinaryOperator _tmp10_;
		_tmp10_ = self->priv->_operator;
		if (_tmp10_ == VALA_BINARY_OPERATOR_AND) {
			_tmp9_ = TRUE;
		} else {
			ValaBinaryOperator _tmp11_;
			_tmp11_ = self->priv->_operator;
			_tmp9_ = _tmp11_ == VALA_BINARY_OPERATOR_OR;
		}
		_tmp4_ = _tmp9_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaLocalVariable* local = NULL;
		ValaSemanticAnalyzer* _tmp12_;
		ValaSemanticAnalyzer* _tmp13_;
		ValaDataType* _tmp14_;
		ValaDataType* _tmp15_;
		ValaDataType* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceReference* _tmp20_;
		ValaLocalVariable* _tmp21_;
		ValaLocalVariable* _tmp22_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp23_;
		ValaSourceReference* _tmp24_;
		ValaSourceReference* _tmp25_;
		ValaDeclarationStatement* _tmp26_;
		ValaExpressionStatement* right_stmt = NULL;
		ValaLocalVariable* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		ValaExpression* _tmp30_;
		ValaExpression* _tmp31_;
		ValaSourceReference* _tmp32_;
		ValaSourceReference* _tmp33_;
		ValaMemberAccess* _tmp34_;
		ValaMemberAccess* _tmp35_;
		ValaExpression* _tmp36_;
		ValaExpression* _tmp37_;
		ValaExpression* _tmp38_;
		ValaExpression* _tmp39_;
		ValaSourceReference* _tmp40_;
		ValaSourceReference* _tmp41_;
		ValaAssignment* _tmp42_;
		ValaAssignment* _tmp43_;
		ValaExpression* _tmp44_;
		ValaExpression* _tmp45_;
		ValaSourceReference* _tmp46_;
		ValaSourceReference* _tmp47_;
		ValaExpressionStatement* _tmp48_;
		ValaExpressionStatement* _tmp49_;
		ValaExpressionStatement* stmt = NULL;
		ValaLocalVariable* _tmp50_;
		const gchar* _tmp51_;
		const gchar* _tmp52_;
		ValaExpression* _tmp53_;
		ValaExpression* _tmp54_;
		ValaSourceReference* _tmp55_;
		ValaSourceReference* _tmp56_;
		ValaMemberAccess* _tmp57_;
		ValaMemberAccess* _tmp58_;
		ValaBinaryOperator _tmp59_;
		ValaExpression* _tmp60_;
		ValaExpression* _tmp61_;
		ValaSourceReference* _tmp62_;
		ValaSourceReference* _tmp63_;
		ValaBooleanLiteral* _tmp64_;
		ValaBooleanLiteral* _tmp65_;
		ValaExpression* _tmp66_;
		ValaExpression* _tmp67_;
		ValaSourceReference* _tmp68_;
		ValaSourceReference* _tmp69_;
		ValaAssignment* _tmp70_;
		ValaAssignment* _tmp71_;
		ValaExpression* _tmp72_;
		ValaExpression* _tmp73_;
		ValaSourceReference* _tmp74_;
		ValaSourceReference* _tmp75_;
		ValaExpressionStatement* _tmp76_;
		ValaExpressionStatement* _tmp77_;
		ValaBlock* true_block = NULL;
		ValaSourceReference* _tmp78_;
		ValaSourceReference* _tmp79_;
		ValaBlock* _tmp80_;
		ValaBlock* false_block = NULL;
		ValaSourceReference* _tmp81_;
		ValaSourceReference* _tmp82_;
		ValaBlock* _tmp83_;
		ValaBinaryOperator _tmp84_;
		ValaIfStatement* if_stmt = NULL;
		ValaExpression* _tmp93_;
		ValaExpression* _tmp94_;
		ValaBlock* _tmp95_;
		ValaBlock* _tmp96_;
		ValaSourceReference* _tmp97_;
		ValaSourceReference* _tmp98_;
		ValaIfStatement* _tmp99_;
		ValaSemanticAnalyzer* _tmp100_;
		ValaSemanticAnalyzer* _tmp101_;
		ValaBlock* _tmp102_;
		ValaDeclarationStatement* _tmp103_;
		ValaSemanticAnalyzer* _tmp104_;
		ValaSemanticAnalyzer* _tmp105_;
		ValaBlock* _tmp106_;
		ValaIfStatement* _tmp107_;
		ValaDeclarationStatement* _tmp108_;
		ValaIfStatement* _tmp109_;
		ValaMemberAccess* ma = NULL;
		ValaLocalVariable* _tmp110_;
		const gchar* _tmp111_;
		const gchar* _tmp112_;
		ValaSourceReference* _tmp113_;
		ValaSourceReference* _tmp114_;
		ValaMemberAccess* _tmp115_;
		ValaMemberAccess* _tmp116_;
		ValaDataType* _tmp117_;
		ValaDataType* _tmp118_;
		ValaMemberAccess* _tmp119_;
		ValaDataType* _tmp120_;
		ValaDataType* _tmp121_;
		ValaCodeNode* _tmp122_;
		ValaCodeNode* _tmp123_;
		ValaMemberAccess* _tmp124_;
		ValaMemberAccess* _tmp125_;
		_tmp12_ = vala_code_context_get_analyzer (context);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_->bool_type;
		_tmp15_ = vala_data_type_copy (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_code_node_get_temp_name ();
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_local_variable_new (_tmp16_, _tmp18_, NULL, _tmp20_);
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp18_);
		_vala_code_node_unref0 (_tmp16_);
		local = _tmp22_;
		_tmp23_ = local;
		_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_declaration_statement_new ((ValaSymbol*) _tmp23_, _tmp25_);
		decl = _tmp26_;
		_tmp27_ = local;
		_tmp28_ = vala_symbol_get_name ((ValaSymbol*) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_binary_expression_get_right (self);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_member_access_new_simple (_tmp29_, _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_binary_expression_get_right (self);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_binary_expression_get_right (self);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_assignment_new ((ValaExpression*) _tmp35_, _tmp37_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_binary_expression_get_right (self);
		_tmp45_ = _tmp44_;
		_tmp46_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_statement_new ((ValaExpression*) _tmp43_, _tmp47_);
		_tmp49_ = _tmp48_;
		_vala_code_node_unref0 (_tmp43_);
		_vala_code_node_unref0 (_tmp35_);
		right_stmt = _tmp49_;
		_tmp50_ = local;
		_tmp51_ = vala_symbol_get_name ((ValaSymbol*) _tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = vala_binary_expression_get_left (self);
		_tmp54_ = _tmp53_;
		_tmp55_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = vala_member_access_new_simple (_tmp52_, _tmp56_);
		_tmp58_ = _tmp57_;
		_tmp59_ = self->priv->_operator;
		_tmp60_ = vala_binary_expression_get_left (self);
		_tmp61_ = _tmp60_;
		_tmp62_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp61_);
		_tmp63_ = _tmp62_;
		_tmp64_ = vala_boolean_literal_new (_tmp59_ == VALA_BINARY_OPERATOR_OR, _tmp63_);
		_tmp65_ = _tmp64_;
		_tmp66_ = vala_binary_expression_get_left (self);
		_tmp67_ = _tmp66_;
		_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp67_);
		_tmp69_ = _tmp68_;
		_tmp70_ = vala_assignment_new ((ValaExpression*) _tmp58_, (ValaExpression*) _tmp65_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp69_);
		_tmp71_ = _tmp70_;
		_tmp72_ = vala_binary_expression_get_left (self);
		_tmp73_ = _tmp72_;
		_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = vala_expression_statement_new ((ValaExpression*) _tmp71_, _tmp75_);
		_tmp77_ = _tmp76_;
		_vala_code_node_unref0 (_tmp71_);
		_vala_code_node_unref0 (_tmp65_);
		_vala_code_node_unref0 (_tmp58_);
		stmt = _tmp77_;
		_tmp78_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp79_ = _tmp78_;
		_tmp80_ = vala_block_new (_tmp79_);
		true_block = _tmp80_;
		_tmp81_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp82_ = _tmp81_;
		_tmp83_ = vala_block_new (_tmp82_);
		false_block = _tmp83_;
		_tmp84_ = self->priv->_operator;
		if (_tmp84_ == VALA_BINARY_OPERATOR_AND) {
			ValaBlock* _tmp85_;
			ValaExpressionStatement* _tmp86_;
			ValaBlock* _tmp87_;
			ValaExpressionStatement* _tmp88_;
			_tmp85_ = true_block;
			_tmp86_ = right_stmt;
			vala_block_add_statement (_tmp85_, (ValaStatement*) _tmp86_);
			_tmp87_ = false_block;
			_tmp88_ = stmt;
			vala_block_add_statement (_tmp87_, (ValaStatement*) _tmp88_);
		} else {
			ValaBlock* _tmp89_;
			ValaExpressionStatement* _tmp90_;
			ValaBlock* _tmp91_;
			ValaExpressionStatement* _tmp92_;
			_tmp89_ = true_block;
			_tmp90_ = stmt;
			vala_block_add_statement (_tmp89_, (ValaStatement*) _tmp90_);
			_tmp91_ = false_block;
			_tmp92_ = right_stmt;
			vala_block_add_statement (_tmp91_, (ValaStatement*) _tmp92_);
		}
		_tmp93_ = vala_binary_expression_get_left (self);
		_tmp94_ = _tmp93_;
		_tmp95_ = true_block;
		_tmp96_ = false_block;
		_tmp97_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp98_ = _tmp97_;
		_tmp99_ = vala_if_statement_new (_tmp94_, _tmp95_, _tmp96_, _tmp98_);
		if_stmt = _tmp99_;
		_tmp100_ = vala_code_context_get_analyzer (context);
		_tmp101_ = _tmp100_;
		_tmp102_ = _tmp101_->insert_block;
		_tmp103_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp102_, (ValaStatement*) _tmp103_);
		_tmp104_ = vala_code_context_get_analyzer (context);
		_tmp105_ = _tmp104_;
		_tmp106_ = _tmp105_->insert_block;
		_tmp107_ = if_stmt;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp106_, (ValaStatement*) _tmp107_);
		_tmp108_ = decl;
		vala_code_node_check ((ValaCodeNode*) _tmp108_, context);
		_tmp109_ = if_stmt;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp109_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (if_stmt);
			_vala_code_node_unref0 (false_block);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (stmt);
			_vala_code_node_unref0 (right_stmt);
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			return result;
		}
		_tmp110_ = local;
		_tmp111_ = vala_symbol_get_name ((ValaSymbol*) _tmp110_);
		_tmp112_ = _tmp111_;
		_tmp113_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp114_ = _tmp113_;
		_tmp115_ = vala_member_access_new_simple (_tmp112_, _tmp114_);
		ma = _tmp115_;
		_tmp116_ = ma;
		_tmp117_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp118_ = _tmp117_;
		vala_expression_set_target_type ((ValaExpression*) _tmp116_, _tmp118_);
		_tmp119_ = ma;
		_tmp120_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
		_tmp121_ = _tmp120_;
		vala_expression_set_formal_target_type ((ValaExpression*) _tmp119_, _tmp121_);
		_tmp122_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp123_ = _tmp122_;
		_tmp124_ = ma;
		vala_code_node_replace_expression (_tmp123_, (ValaExpression*) self, (ValaExpression*) _tmp124_);
		_tmp125_ = ma;
		vala_code_node_check ((ValaCodeNode*) _tmp125_, context);
		result = TRUE;
		_vala_code_node_unref0 (ma);
		_vala_code_node_unref0 (if_stmt);
		_vala_code_node_unref0 (false_block);
		_vala_code_node_unref0 (true_block);
		_vala_code_node_unref0 (stmt);
		_vala_code_node_unref0 (right_stmt);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		return result;
	}
	_tmp126_ = self->priv->_operator;
	if (_tmp126_ == VALA_BINARY_OPERATOR_COALESCE) {
		ValaExpression* _tmp127_;
		ValaExpression* _tmp128_;
		ValaExpression* _tmp129_;
		ValaExpression* _tmp130_;
		ValaDataType* local_type = NULL;
		gboolean cast_non_null = FALSE;
		gboolean _tmp131_ = FALSE;
		ValaExpression* _tmp132_;
		ValaExpression* _tmp133_;
		ValaDataType* _tmp134_;
		ValaDataType* _tmp135_;
		ValaLocalVariable* local = NULL;
		ValaDataType* _tmp218_;
		gchar* _tmp219_;
		gchar* _tmp220_;
		ValaExpression* _tmp221_;
		ValaExpression* _tmp222_;
		ValaSourceReference* _tmp223_;
		ValaSourceReference* _tmp224_;
		ValaLocalVariable* _tmp225_;
		ValaLocalVariable* _tmp226_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp227_;
		ValaSourceReference* _tmp228_;
		ValaSourceReference* _tmp229_;
		ValaDeclarationStatement* _tmp230_;
		ValaExpressionStatement* right_stmt = NULL;
		ValaLocalVariable* _tmp231_;
		const gchar* _tmp232_;
		const gchar* _tmp233_;
		ValaExpression* _tmp234_;
		ValaExpression* _tmp235_;
		ValaSourceReference* _tmp236_;
		ValaSourceReference* _tmp237_;
		ValaMemberAccess* _tmp238_;
		ValaMemberAccess* _tmp239_;
		ValaExpression* _tmp240_;
		ValaExpression* _tmp241_;
		ValaExpression* _tmp242_;
		ValaExpression* _tmp243_;
		ValaSourceReference* _tmp244_;
		ValaSourceReference* _tmp245_;
		ValaAssignment* _tmp246_;
		ValaAssignment* _tmp247_;
		ValaExpression* _tmp248_;
		ValaExpression* _tmp249_;
		ValaSourceReference* _tmp250_;
		ValaSourceReference* _tmp251_;
		ValaExpressionStatement* _tmp252_;
		ValaExpressionStatement* _tmp253_;
		ValaBlock* true_block = NULL;
		ValaSourceReference* _tmp254_;
		ValaSourceReference* _tmp255_;
		ValaBlock* _tmp256_;
		ValaBlock* _tmp257_;
		ValaExpressionStatement* _tmp258_;
		ValaBinaryExpression* cond = NULL;
		ValaLocalVariable* _tmp259_;
		const gchar* _tmp260_;
		const gchar* _tmp261_;
		ValaExpression* _tmp262_;
		ValaExpression* _tmp263_;
		ValaSourceReference* _tmp264_;
		ValaSourceReference* _tmp265_;
		ValaMemberAccess* _tmp266_;
		ValaMemberAccess* _tmp267_;
		ValaSourceReference* _tmp268_;
		ValaSourceReference* _tmp269_;
		ValaNullLiteral* _tmp270_;
		ValaNullLiteral* _tmp271_;
		ValaSourceReference* _tmp272_;
		ValaSourceReference* _tmp273_;
		ValaBinaryExpression* _tmp274_;
		ValaBinaryExpression* _tmp275_;
		ValaIfStatement* if_stmt = NULL;
		ValaBinaryExpression* _tmp276_;
		ValaBlock* _tmp277_;
		ValaSourceReference* _tmp278_;
		ValaSourceReference* _tmp279_;
		ValaIfStatement* _tmp280_;
		ValaSemanticAnalyzer* _tmp281_;
		ValaSemanticAnalyzer* _tmp282_;
		ValaBlock* _tmp283_;
		ValaDeclarationStatement* _tmp284_;
		ValaSemanticAnalyzer* _tmp285_;
		ValaSemanticAnalyzer* _tmp286_;
		ValaBlock* _tmp287_;
		ValaIfStatement* _tmp288_;
		ValaDeclarationStatement* _tmp289_;
		ValaIfStatement* _tmp290_;
		ValaExpression* replace_expr = NULL;
		ValaLocalVariable* _tmp291_;
		ValaDataType* _tmp292_;
		ValaDataType* _tmp293_;
		ValaExpression* _tmp294_;
		gboolean _tmp295_ = FALSE;
		gboolean _tmp296_;
		ValaCodeNode* _tmp315_;
		ValaCodeNode* _tmp316_;
		ValaExpression* _tmp317_;
		ValaExpression* _tmp318_;
		_tmp127_ = vala_binary_expression_get_left (self);
		_tmp128_ = _tmp127_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp128_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
		_tmp129_ = vala_binary_expression_get_right (self);
		_tmp130_ = _tmp129_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp130_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
		local_type = NULL;
		cast_non_null = FALSE;
		_tmp132_ = vala_binary_expression_get_left (self);
		_tmp133_ = _tmp132_;
		_tmp134_ = vala_expression_get_value_type (_tmp133_);
		_tmp135_ = _tmp134_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp135_, VALA_TYPE_NULL_TYPE)) {
			ValaExpression* _tmp136_;
			ValaExpression* _tmp137_;
			ValaDataType* _tmp138_;
			ValaDataType* _tmp139_;
			_tmp136_ = vala_binary_expression_get_right (self);
			_tmp137_ = _tmp136_;
			_tmp138_ = vala_expression_get_value_type (_tmp137_);
			_tmp139_ = _tmp138_;
			_tmp131_ = _tmp139_ != NULL;
		} else {
			_tmp131_ = FALSE;
		}
		if (_tmp131_) {
			ValaExpression* _tmp140_;
			ValaExpression* _tmp141_;
			ValaSourceReference* _tmp142_;
			ValaSourceReference* _tmp143_;
			ValaExpression* _tmp144_;
			ValaExpression* _tmp145_;
			ValaDataType* _tmp146_;
			ValaDataType* _tmp147_;
			ValaDataType* _tmp148_;
			ValaDataType* _tmp149_;
			ValaExpression* _tmp150_;
			ValaExpression* _tmp151_;
			ValaDataType* _tmp152_;
			ValaDataType* _tmp153_;
			gboolean _tmp154_;
			gboolean _tmp155_;
			_tmp140_ = vala_binary_expression_get_left (self);
			_tmp141_ = _tmp140_;
			_tmp142_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp141_);
			_tmp143_ = _tmp142_;
			vala_report_warning (_tmp143_, "left operand is always null");
			_tmp144_ = vala_binary_expression_get_right (self);
			_tmp145_ = _tmp144_;
			_tmp146_ = vala_expression_get_value_type (_tmp145_);
			_tmp147_ = _tmp146_;
			_tmp148_ = vala_data_type_copy (_tmp147_);
			_vala_code_node_unref0 (local_type);
			local_type = _tmp148_;
			_tmp149_ = local_type;
			vala_data_type_set_nullable (_tmp149_, TRUE);
			_tmp150_ = vala_binary_expression_get_right (self);
			_tmp151_ = _tmp150_;
			_tmp152_ = vala_expression_get_value_type (_tmp151_);
			_tmp153_ = _tmp152_;
			_tmp154_ = vala_data_type_get_nullable (_tmp153_);
			_tmp155_ = _tmp154_;
			if (!_tmp155_) {
				cast_non_null = TRUE;
			}
		} else {
			ValaExpression* _tmp156_;
			ValaExpression* _tmp157_;
			ValaDataType* _tmp158_;
			ValaDataType* _tmp159_;
			_tmp156_ = vala_binary_expression_get_left (self);
			_tmp157_ = _tmp156_;
			_tmp158_ = vala_expression_get_value_type (_tmp157_);
			_tmp159_ = _tmp158_;
			if (_tmp159_ != NULL) {
				ValaExpression* _tmp160_;
				ValaExpression* _tmp161_;
				ValaDataType* _tmp162_;
				ValaDataType* _tmp163_;
				ValaDataType* _tmp164_;
				gboolean _tmp165_ = FALSE;
				ValaExpression* _tmp166_;
				ValaExpression* _tmp167_;
				ValaDataType* _tmp168_;
				ValaDataType* _tmp169_;
				gboolean _tmp177_;
				gboolean _tmp178_;
				_tmp160_ = vala_binary_expression_get_left (self);
				_tmp161_ = _tmp160_;
				_tmp162_ = vala_expression_get_value_type (_tmp161_);
				_tmp163_ = _tmp162_;
				_tmp164_ = vala_data_type_copy (_tmp163_);
				_vala_code_node_unref0 (local_type);
				local_type = _tmp164_;
				_tmp166_ = vala_binary_expression_get_right (self);
				_tmp167_ = _tmp166_;
				_tmp168_ = vala_expression_get_value_type (_tmp167_);
				_tmp169_ = _tmp168_;
				if (_tmp169_ != NULL) {
					ValaExpression* _tmp170_;
					ValaExpression* _tmp171_;
					ValaDataType* _tmp172_;
					ValaDataType* _tmp173_;
					gboolean _tmp174_;
					gboolean _tmp175_;
					_tmp170_ = vala_binary_expression_get_right (self);
					_tmp171_ = _tmp170_;
					_tmp172_ = vala_expression_get_value_type (_tmp171_);
					_tmp173_ = _tmp172_;
					_tmp174_ = vala_data_type_get_value_owned (_tmp173_);
					_tmp175_ = _tmp174_;
					_tmp165_ = _tmp175_;
				} else {
					_tmp165_ = FALSE;
				}
				if (_tmp165_) {
					ValaDataType* _tmp176_;
					_tmp176_ = local_type;
					vala_data_type_set_value_owned (_tmp176_, TRUE);
				}
				_tmp177_ = vala_code_context_get_experimental_non_null (context);
				_tmp178_ = _tmp177_;
				if (_tmp178_) {
					ValaDataType* _tmp179_;
					gboolean _tmp180_;
					gboolean _tmp181_;
					_tmp179_ = local_type;
					_tmp180_ = vala_data_type_get_nullable (_tmp179_);
					_tmp181_ = _tmp180_;
					if (!_tmp181_) {
						ValaExpression* _tmp182_;
						ValaExpression* _tmp183_;
						ValaSourceReference* _tmp184_;
						ValaSourceReference* _tmp185_;
						gboolean _tmp186_ = FALSE;
						ValaExpression* _tmp187_;
						ValaExpression* _tmp188_;
						ValaDataType* _tmp189_;
						ValaDataType* _tmp190_;
						_tmp182_ = vala_binary_expression_get_left (self);
						_tmp183_ = _tmp182_;
						_tmp184_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp183_);
						_tmp185_ = _tmp184_;
						vala_report_warning (_tmp185_, "left operand is never null");
						_tmp187_ = vala_binary_expression_get_right (self);
						_tmp188_ = _tmp187_;
						_tmp189_ = vala_expression_get_value_type (_tmp188_);
						_tmp190_ = _tmp189_;
						if (_tmp190_ != NULL) {
							ValaExpression* _tmp191_;
							ValaExpression* _tmp192_;
							ValaDataType* _tmp193_;
							ValaDataType* _tmp194_;
							gboolean _tmp195_;
							gboolean _tmp196_;
							_tmp191_ = vala_binary_expression_get_right (self);
							_tmp192_ = _tmp191_;
							_tmp193_ = vala_expression_get_value_type (_tmp192_);
							_tmp194_ = _tmp193_;
							_tmp195_ = vala_data_type_get_nullable (_tmp194_);
							_tmp196_ = _tmp195_;
							_tmp186_ = _tmp196_;
						} else {
							_tmp186_ = FALSE;
						}
						if (_tmp186_) {
							ValaDataType* _tmp197_;
							_tmp197_ = local_type;
							vala_data_type_set_nullable (_tmp197_, TRUE);
							cast_non_null = TRUE;
						}
					} else {
						gboolean _tmp198_ = FALSE;
						ValaExpression* _tmp199_;
						ValaExpression* _tmp200_;
						ValaDataType* _tmp201_;
						ValaDataType* _tmp202_;
						_tmp199_ = vala_binary_expression_get_right (self);
						_tmp200_ = _tmp199_;
						_tmp201_ = vala_expression_get_value_type (_tmp200_);
						_tmp202_ = _tmp201_;
						if (_tmp202_ != NULL) {
							ValaExpression* _tmp203_;
							ValaExpression* _tmp204_;
							ValaDataType* _tmp205_;
							ValaDataType* _tmp206_;
							gboolean _tmp207_;
							gboolean _tmp208_;
							_tmp203_ = vala_binary_expression_get_right (self);
							_tmp204_ = _tmp203_;
							_tmp205_ = vala_expression_get_value_type (_tmp204_);
							_tmp206_ = _tmp205_;
							_tmp207_ = vala_data_type_get_nullable (_tmp206_);
							_tmp208_ = _tmp207_;
							_tmp198_ = !_tmp208_;
						} else {
							_tmp198_ = FALSE;
						}
						if (_tmp198_) {
							cast_non_null = TRUE;
						}
					}
				}
			} else {
				ValaExpression* _tmp209_;
				ValaExpression* _tmp210_;
				ValaDataType* _tmp211_;
				ValaDataType* _tmp212_;
				_tmp209_ = vala_binary_expression_get_right (self);
				_tmp210_ = _tmp209_;
				_tmp211_ = vala_expression_get_value_type (_tmp210_);
				_tmp212_ = _tmp211_;
				if (_tmp212_ != NULL) {
					ValaExpression* _tmp213_;
					ValaExpression* _tmp214_;
					ValaDataType* _tmp215_;
					ValaDataType* _tmp216_;
					ValaDataType* _tmp217_;
					_tmp213_ = vala_binary_expression_get_right (self);
					_tmp214_ = _tmp213_;
					_tmp215_ = vala_expression_get_value_type (_tmp214_);
					_tmp216_ = _tmp215_;
					_tmp217_ = vala_data_type_copy (_tmp216_);
					_vala_code_node_unref0 (local_type);
					local_type = _tmp217_;
				}
			}
		}
		_tmp218_ = local_type;
		_tmp219_ = vala_code_node_get_temp_name ();
		_tmp220_ = _tmp219_;
		_tmp221_ = vala_binary_expression_get_left (self);
		_tmp222_ = _tmp221_;
		_tmp223_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp224_ = _tmp223_;
		_tmp225_ = vala_local_variable_new (_tmp218_, _tmp220_, _tmp222_, _tmp224_);
		_tmp226_ = _tmp225_;
		_g_free0 (_tmp220_);
		local = _tmp226_;
		_tmp227_ = local;
		_tmp228_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp229_ = _tmp228_;
		_tmp230_ = vala_declaration_statement_new ((ValaSymbol*) _tmp227_, _tmp229_);
		decl = _tmp230_;
		_tmp231_ = local;
		_tmp232_ = vala_symbol_get_name ((ValaSymbol*) _tmp231_);
		_tmp233_ = _tmp232_;
		_tmp234_ = vala_binary_expression_get_right (self);
		_tmp235_ = _tmp234_;
		_tmp236_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp235_);
		_tmp237_ = _tmp236_;
		_tmp238_ = vala_member_access_new_simple (_tmp233_, _tmp237_);
		_tmp239_ = _tmp238_;
		_tmp240_ = vala_binary_expression_get_right (self);
		_tmp241_ = _tmp240_;
		_tmp242_ = vala_binary_expression_get_right (self);
		_tmp243_ = _tmp242_;
		_tmp244_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp243_);
		_tmp245_ = _tmp244_;
		_tmp246_ = vala_assignment_new ((ValaExpression*) _tmp239_, _tmp241_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp245_);
		_tmp247_ = _tmp246_;
		_tmp248_ = vala_binary_expression_get_right (self);
		_tmp249_ = _tmp248_;
		_tmp250_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp249_);
		_tmp251_ = _tmp250_;
		_tmp252_ = vala_expression_statement_new ((ValaExpression*) _tmp247_, _tmp251_);
		_tmp253_ = _tmp252_;
		_vala_code_node_unref0 (_tmp247_);
		_vala_code_node_unref0 (_tmp239_);
		right_stmt = _tmp253_;
		_tmp254_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp255_ = _tmp254_;
		_tmp256_ = vala_block_new (_tmp255_);
		true_block = _tmp256_;
		_tmp257_ = true_block;
		_tmp258_ = right_stmt;
		vala_block_add_statement (_tmp257_, (ValaStatement*) _tmp258_);
		_tmp259_ = local;
		_tmp260_ = vala_symbol_get_name ((ValaSymbol*) _tmp259_);
		_tmp261_ = _tmp260_;
		_tmp262_ = vala_binary_expression_get_left (self);
		_tmp263_ = _tmp262_;
		_tmp264_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp263_);
		_tmp265_ = _tmp264_;
		_tmp266_ = vala_member_access_new_simple (_tmp261_, _tmp265_);
		_tmp267_ = _tmp266_;
		_tmp268_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp269_ = _tmp268_;
		_tmp270_ = vala_null_literal_new (_tmp269_);
		_tmp271_ = _tmp270_;
		_tmp272_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp273_ = _tmp272_;
		_tmp274_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_EQUALITY, (ValaExpression*) _tmp267_, (ValaExpression*) _tmp271_, _tmp273_);
		_tmp275_ = _tmp274_;
		_vala_code_node_unref0 (_tmp271_);
		_vala_code_node_unref0 (_tmp267_);
		cond = _tmp275_;
		_tmp276_ = cond;
		_tmp277_ = true_block;
		_tmp278_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp279_ = _tmp278_;
		_tmp280_ = vala_if_statement_new ((ValaExpression*) _tmp276_, _tmp277_, NULL, _tmp279_);
		if_stmt = _tmp280_;
		_tmp281_ = vala_code_context_get_analyzer (context);
		_tmp282_ = _tmp281_;
		_tmp283_ = _tmp282_->insert_block;
		_tmp284_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp283_, (ValaStatement*) _tmp284_);
		_tmp285_ = vala_code_context_get_analyzer (context);
		_tmp286_ = _tmp285_;
		_tmp287_ = _tmp286_->insert_block;
		_tmp288_ = if_stmt;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp287_, (ValaStatement*) _tmp288_);
		_tmp289_ = decl;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp289_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (if_stmt);
			_vala_code_node_unref0 (cond);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (right_stmt);
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (local_type);
			return result;
		}
		_tmp290_ = if_stmt;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp290_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (if_stmt);
			_vala_code_node_unref0 (cond);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (right_stmt);
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (local_type);
			return result;
		}
		_tmp291_ = local;
		_tmp292_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp293_ = _tmp292_;
		_tmp294_ = vala_semantic_analyzer_create_temp_access (_tmp291_, _tmp293_);
		replace_expr = _tmp294_;
		_tmp296_ = cast_non_null;
		if (_tmp296_) {
			ValaExpression* _tmp297_;
			ValaDataType* _tmp298_;
			ValaDataType* _tmp299_;
			_tmp297_ = replace_expr;
			_tmp298_ = vala_expression_get_target_type (_tmp297_);
			_tmp299_ = _tmp298_;
			_tmp295_ = _tmp299_ != NULL;
		} else {
			_tmp295_ = FALSE;
		}
		if (_tmp295_) {
			ValaCastExpression* cast = NULL;
			ValaExpression* _tmp300_;
			ValaSourceReference* _tmp301_;
			ValaSourceReference* _tmp302_;
			ValaCastExpression* _tmp303_;
			ValaCastExpression* _tmp304_;
			ValaExpression* _tmp305_;
			ValaDataType* _tmp306_;
			ValaDataType* _tmp307_;
			ValaDataType* _tmp308_;
			ValaDataType* _tmp309_;
			ValaCastExpression* _tmp310_;
			ValaDataType* _tmp311_;
			ValaDataType* _tmp312_;
			ValaCastExpression* _tmp313_;
			ValaExpression* _tmp314_;
			_tmp300_ = replace_expr;
			_tmp301_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp302_ = _tmp301_;
			_tmp303_ = vala_cast_expression_new_non_null (_tmp300_, _tmp302_);
			cast = _tmp303_;
			_tmp304_ = cast;
			_tmp305_ = replace_expr;
			_tmp306_ = vala_expression_get_target_type (_tmp305_);
			_tmp307_ = _tmp306_;
			_tmp308_ = vala_data_type_copy (_tmp307_);
			_tmp309_ = _tmp308_;
			vala_expression_set_target_type ((ValaExpression*) _tmp304_, _tmp309_);
			_vala_code_node_unref0 (_tmp309_);
			_tmp310_ = cast;
			_tmp311_ = vala_expression_get_target_type ((ValaExpression*) _tmp310_);
			_tmp312_ = _tmp311_;
			vala_data_type_set_nullable (_tmp312_, FALSE);
			_tmp313_ = cast;
			_tmp314_ = _vala_code_node_ref0 ((ValaExpression*) _tmp313_);
			_vala_code_node_unref0 (replace_expr);
			replace_expr = _tmp314_;
			_vala_code_node_unref0 (cast);
		}
		_tmp315_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp316_ = _tmp315_;
		_tmp317_ = replace_expr;
		vala_code_node_replace_expression (_tmp316_, (ValaExpression*) self, _tmp317_);
		_tmp318_ = replace_expr;
		vala_code_node_check ((ValaCodeNode*) _tmp318_, context);
		result = TRUE;
		_vala_code_node_unref0 (replace_expr);
		_vala_code_node_unref0 (if_stmt);
		_vala_code_node_unref0 (cond);
		_vala_code_node_unref0 (true_block);
		_vala_code_node_unref0 (right_stmt);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		_vala_code_node_unref0 (local_type);
		return result;
	}
	_tmp321_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp322_ = _tmp321_;
	if (_tmp322_ != NULL) {
		ValaDataType* _tmp323_;
		ValaDataType* _tmp324_;
		ValaTypeSymbol* _tmp325_;
		ValaTypeSymbol* _tmp326_;
		_tmp323_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp324_ = _tmp323_;
		_tmp325_ = vala_data_type_get_data_type (_tmp324_);
		_tmp326_ = _tmp325_;
		_tmp320_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp326_, VALA_TYPE_ENUM);
	} else {
		_tmp320_ = FALSE;
	}
	if (_tmp320_) {
		gboolean _tmp327_ = FALSE;
		ValaBinaryOperator _tmp328_;
		_tmp328_ = self->priv->_operator;
		if (_tmp328_ == VALA_BINARY_OPERATOR_BITWISE_AND) {
			_tmp327_ = TRUE;
		} else {
			ValaBinaryOperator _tmp329_;
			_tmp329_ = self->priv->_operator;
			_tmp327_ = _tmp329_ == VALA_BINARY_OPERATOR_BITWISE_OR;
		}
		_tmp319_ = _tmp327_;
	} else {
		_tmp319_ = FALSE;
	}
	if (_tmp319_) {
		ValaExpression* _tmp330_;
		ValaExpression* _tmp331_;
		ValaDataType* _tmp332_;
		ValaDataType* _tmp333_;
		ValaDataType* _tmp334_;
		ValaDataType* _tmp335_;
		ValaExpression* _tmp336_;
		ValaExpression* _tmp337_;
		ValaDataType* _tmp338_;
		ValaDataType* _tmp339_;
		ValaDataType* _tmp340_;
		ValaDataType* _tmp341_;
		_tmp330_ = vala_binary_expression_get_left (self);
		_tmp331_ = _tmp330_;
		_tmp332_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp333_ = _tmp332_;
		_tmp334_ = vala_data_type_copy (_tmp333_);
		_tmp335_ = _tmp334_;
		vala_expression_set_target_type (_tmp331_, _tmp335_);
		_vala_code_node_unref0 (_tmp335_);
		_tmp336_ = vala_binary_expression_get_right (self);
		_tmp337_ = _tmp336_;
		_tmp338_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp339_ = _tmp338_;
		_tmp340_ = vala_data_type_copy (_tmp339_);
		_tmp341_ = _tmp340_;
		vala_expression_set_target_type (_tmp337_, _tmp341_);
		_vala_code_node_unref0 (_tmp341_);
	}
	_tmp342_ = vala_binary_expression_get_left (self);
	_tmp343_ = _tmp342_;
	vala_code_node_check ((ValaCodeNode*) _tmp343_, context);
	_tmp346_ = vala_binary_expression_get_left (self);
	_tmp347_ = _tmp346_;
	_tmp348_ = vala_expression_get_value_type (_tmp347_);
	_tmp349_ = _tmp348_;
	if (_tmp349_ != NULL) {
		ValaExpression* _tmp350_;
		ValaExpression* _tmp351_;
		ValaDataType* _tmp352_;
		ValaDataType* _tmp353_;
		ValaTypeSymbol* _tmp354_;
		ValaTypeSymbol* _tmp355_;
		_tmp350_ = vala_binary_expression_get_left (self);
		_tmp351_ = _tmp350_;
		_tmp352_ = vala_expression_get_value_type (_tmp351_);
		_tmp353_ = _tmp352_;
		_tmp354_ = vala_data_type_get_data_type (_tmp353_);
		_tmp355_ = _tmp354_;
		_tmp345_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp355_, VALA_TYPE_ENUM);
	} else {
		_tmp345_ = FALSE;
	}
	if (_tmp345_) {
		gboolean _tmp356_ = FALSE;
		ValaBinaryOperator _tmp357_;
		_tmp357_ = self->priv->_operator;
		if (_tmp357_ == VALA_BINARY_OPERATOR_EQUALITY) {
			_tmp356_ = TRUE;
		} else {
			ValaBinaryOperator _tmp358_;
			_tmp358_ = self->priv->_operator;
			_tmp356_ = _tmp358_ == VALA_BINARY_OPERATOR_INEQUALITY;
		}
		_tmp344_ = _tmp356_;
	} else {
		_tmp344_ = FALSE;
	}
	if (_tmp344_) {
		ValaExpression* _tmp359_;
		ValaExpression* _tmp360_;
		ValaExpression* _tmp361_;
		ValaExpression* _tmp362_;
		ValaDataType* _tmp363_;
		ValaDataType* _tmp364_;
		ValaDataType* _tmp365_;
		ValaDataType* _tmp366_;
		_tmp359_ = vala_binary_expression_get_right (self);
		_tmp360_ = _tmp359_;
		_tmp361_ = vala_binary_expression_get_left (self);
		_tmp362_ = _tmp361_;
		_tmp363_ = vala_expression_get_value_type (_tmp362_);
		_tmp364_ = _tmp363_;
		_tmp365_ = vala_data_type_copy (_tmp364_);
		_tmp366_ = _tmp365_;
		vala_expression_set_target_type (_tmp360_, _tmp366_);
		_vala_code_node_unref0 (_tmp366_);
	}
	_tmp367_ = vala_binary_expression_get_right (self);
	_tmp368_ = _tmp367_;
	vala_code_node_check ((ValaCodeNode*) _tmp368_, context);
	_tmp371_ = vala_binary_expression_get_right (self);
	_tmp372_ = _tmp371_;
	_tmp373_ = vala_expression_get_value_type (_tmp372_);
	_tmp374_ = _tmp373_;
	if (_tmp374_ != NULL) {
		ValaExpression* _tmp375_;
		ValaExpression* _tmp376_;
		ValaDataType* _tmp377_;
		ValaDataType* _tmp378_;
		ValaTypeSymbol* _tmp379_;
		ValaTypeSymbol* _tmp380_;
		_tmp375_ = vala_binary_expression_get_right (self);
		_tmp376_ = _tmp375_;
		_tmp377_ = vala_expression_get_value_type (_tmp376_);
		_tmp378_ = _tmp377_;
		_tmp379_ = vala_data_type_get_data_type (_tmp378_);
		_tmp380_ = _tmp379_;
		_tmp370_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp380_, VALA_TYPE_ENUM);
	} else {
		_tmp370_ = FALSE;
	}
	if (_tmp370_) {
		gboolean _tmp381_ = FALSE;
		ValaBinaryOperator _tmp382_;
		_tmp382_ = self->priv->_operator;
		if (_tmp382_ == VALA_BINARY_OPERATOR_EQUALITY) {
			_tmp381_ = TRUE;
		} else {
			ValaBinaryOperator _tmp383_;
			_tmp383_ = self->priv->_operator;
			_tmp381_ = _tmp383_ == VALA_BINARY_OPERATOR_INEQUALITY;
		}
		_tmp369_ = _tmp381_;
	} else {
		_tmp369_ = FALSE;
	}
	if (_tmp369_) {
		ValaExpression* _tmp384_;
		ValaExpression* _tmp385_;
		ValaExpression* _tmp386_;
		ValaExpression* _tmp387_;
		ValaDataType* _tmp388_;
		ValaDataType* _tmp389_;
		ValaDataType* _tmp390_;
		ValaDataType* _tmp391_;
		_tmp384_ = vala_binary_expression_get_left (self);
		_tmp385_ = _tmp384_;
		_tmp386_ = vala_binary_expression_get_right (self);
		_tmp387_ = _tmp386_;
		_tmp388_ = vala_expression_get_value_type (_tmp387_);
		_tmp389_ = _tmp388_;
		_tmp390_ = vala_data_type_copy (_tmp389_);
		_tmp391_ = _tmp390_;
		vala_expression_set_target_type (_tmp385_, _tmp391_);
		_vala_code_node_unref0 (_tmp391_);
	}
	_tmp393_ = vala_binary_expression_get_left (self);
	_tmp394_ = _tmp393_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp394_, context)) {
		_tmp392_ = TRUE;
	} else {
		ValaExpression* _tmp395_;
		ValaExpression* _tmp396_;
		_tmp395_ = vala_binary_expression_get_right (self);
		_tmp396_ = _tmp395_;
		_tmp392_ = !vala_code_node_check ((ValaCodeNode*) _tmp396_, context);
	}
	if (_tmp392_) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp397_ = vala_binary_expression_get_left (self);
	_tmp398_ = _tmp397_;
	_tmp399_ = vala_expression_get_value_type (_tmp398_);
	_tmp400_ = _tmp399_;
	if (_tmp400_ == NULL) {
		ValaExpression* _tmp401_;
		ValaExpression* _tmp402_;
		ValaSourceReference* _tmp403_;
		ValaSourceReference* _tmp404_;
		_tmp401_ = vala_binary_expression_get_left (self);
		_tmp402_ = _tmp401_;
		_tmp403_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp402_);
		_tmp404_ = _tmp403_;
		vala_report_error (_tmp404_, "invalid left operand");
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp406_ = self->priv->_operator;
	if (_tmp406_ != VALA_BINARY_OPERATOR_IN) {
		ValaExpression* _tmp407_;
		ValaExpression* _tmp408_;
		ValaDataType* _tmp409_;
		ValaDataType* _tmp410_;
		_tmp407_ = vala_binary_expression_get_right (self);
		_tmp408_ = _tmp407_;
		_tmp409_ = vala_expression_get_value_type (_tmp408_);
		_tmp410_ = _tmp409_;
		_tmp405_ = _tmp410_ == NULL;
	} else {
		_tmp405_ = FALSE;
	}
	if (_tmp405_) {
		ValaExpression* _tmp411_;
		ValaExpression* _tmp412_;
		ValaSourceReference* _tmp413_;
		ValaSourceReference* _tmp414_;
		_tmp411_ = vala_binary_expression_get_right (self);
		_tmp412_ = _tmp411_;
		_tmp413_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp412_);
		_tmp414_ = _tmp413_;
		vala_report_error (_tmp414_, "invalid right operand");
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp415_ = vala_binary_expression_get_left (self);
	_tmp416_ = _tmp415_;
	_tmp417_ = vala_expression_get_value_type (_tmp416_);
	_tmp418_ = _tmp417_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp418_, VALA_TYPE_FIELD_PROTOTYPE)) {
		ValaExpression* _tmp419_;
		ValaExpression* _tmp420_;
		ValaSourceReference* _tmp421_;
		ValaSourceReference* _tmp422_;
		ValaExpression* _tmp423_;
		ValaExpression* _tmp424_;
		ValaSymbol* _tmp425_;
		ValaSymbol* _tmp426_;
		gchar* _tmp427_;
		gchar* _tmp428_;
		gchar* _tmp429_;
		gchar* _tmp430_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp419_ = vala_binary_expression_get_left (self);
		_tmp420_ = _tmp419_;
		_tmp421_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp420_);
		_tmp422_ = _tmp421_;
		_tmp423_ = vala_binary_expression_get_left (self);
		_tmp424_ = _tmp423_;
		_tmp425_ = vala_expression_get_symbol_reference (_tmp424_);
		_tmp426_ = _tmp425_;
		_tmp427_ = vala_symbol_get_full_name (_tmp426_);
		_tmp428_ = _tmp427_;
		_tmp429_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp428_);
		_tmp430_ = _tmp429_;
		vala_report_error (_tmp422_, _tmp430_);
		_g_free0 (_tmp430_);
		_g_free0 (_tmp428_);
		result = FALSE;
		return result;
	}
	_tmp431_ = vala_binary_expression_get_right (self);
	_tmp432_ = _tmp431_;
	_tmp433_ = vala_expression_get_value_type (_tmp432_);
	_tmp434_ = _tmp433_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp434_, VALA_TYPE_FIELD_PROTOTYPE)) {
		ValaExpression* _tmp435_;
		ValaExpression* _tmp436_;
		ValaSourceReference* _tmp437_;
		ValaSourceReference* _tmp438_;
		ValaExpression* _tmp439_;
		ValaExpression* _tmp440_;
		ValaSymbol* _tmp441_;
		ValaSymbol* _tmp442_;
		gchar* _tmp443_;
		gchar* _tmp444_;
		gchar* _tmp445_;
		gchar* _tmp446_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp435_ = vala_binary_expression_get_right (self);
		_tmp436_ = _tmp435_;
		_tmp437_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp436_);
		_tmp438_ = _tmp437_;
		_tmp439_ = vala_binary_expression_get_right (self);
		_tmp440_ = _tmp439_;
		_tmp441_ = vala_expression_get_symbol_reference (_tmp440_);
		_tmp442_ = _tmp441_;
		_tmp443_ = vala_symbol_get_full_name (_tmp442_);
		_tmp444_ = _tmp443_;
		_tmp445_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp444_);
		_tmp446_ = _tmp445_;
		vala_report_error (_tmp438_, _tmp446_);
		_g_free0 (_tmp446_);
		_g_free0 (_tmp444_);
		result = FALSE;
		return result;
	}
	_tmp447_ = vala_binary_expression_get_left (self);
	_tmp448_ = _tmp447_;
	_tmp449_ = vala_binary_expression_get_left (self);
	_tmp450_ = _tmp449_;
	_tmp451_ = vala_expression_get_value_type (_tmp450_);
	_tmp452_ = _tmp451_;
	_tmp453_ = vala_data_type_copy (_tmp452_);
	_tmp454_ = _tmp453_;
	vala_expression_set_target_type (_tmp448_, _tmp454_);
	_vala_code_node_unref0 (_tmp454_);
	_tmp455_ = vala_binary_expression_get_left (self);
	_tmp456_ = _tmp455_;
	_tmp457_ = vala_expression_get_target_type (_tmp456_);
	_tmp458_ = _tmp457_;
	vala_data_type_set_value_owned (_tmp458_, FALSE);
	_tmp459_ = vala_binary_expression_get_right (self);
	_tmp460_ = _tmp459_;
	_tmp461_ = vala_binary_expression_get_right (self);
	_tmp462_ = _tmp461_;
	_tmp463_ = vala_expression_get_value_type (_tmp462_);
	_tmp464_ = _tmp463_;
	_tmp465_ = vala_data_type_copy (_tmp464_);
	_tmp466_ = _tmp465_;
	vala_expression_set_target_type (_tmp460_, _tmp466_);
	_vala_code_node_unref0 (_tmp466_);
	_tmp467_ = vala_binary_expression_get_right (self);
	_tmp468_ = _tmp467_;
	_tmp469_ = vala_expression_get_target_type (_tmp468_);
	_tmp470_ = _tmp469_;
	vala_data_type_set_value_owned (_tmp470_, FALSE);
	_tmp472_ = vala_binary_expression_get_left (self);
	_tmp473_ = _tmp472_;
	_tmp474_ = vala_expression_get_value_type (_tmp473_);
	_tmp475_ = _tmp474_;
	_tmp476_ = vala_data_type_get_data_type (_tmp475_);
	_tmp477_ = _tmp476_;
	_tmp478_ = vala_code_context_get_analyzer (context);
	_tmp479_ = _tmp478_;
	_tmp480_ = _tmp479_->string_type;
	_tmp481_ = vala_data_type_get_data_type (_tmp480_);
	_tmp482_ = _tmp481_;
	if (_tmp477_ == _tmp482_) {
		ValaBinaryOperator _tmp483_;
		_tmp483_ = self->priv->_operator;
		_tmp471_ = _tmp483_ == VALA_BINARY_OPERATOR_PLUS;
	} else {
		_tmp471_ = FALSE;
	}
	if (_tmp471_) {
		gboolean _tmp484_ = FALSE;
		ValaExpression* _tmp485_;
		ValaExpression* _tmp486_;
		ValaDataType* _tmp487_;
		ValaDataType* _tmp488_;
		ValaSemanticAnalyzer* _tmp502_;
		ValaSemanticAnalyzer* _tmp503_;
		ValaDataType* _tmp504_;
		ValaDataType* _tmp505_;
		ValaDataType* _tmp506_;
		gboolean _tmp507_ = FALSE;
		ValaExpression* _tmp508_;
		ValaExpression* _tmp509_;
		_tmp485_ = vala_binary_expression_get_right (self);
		_tmp486_ = _tmp485_;
		_tmp487_ = vala_expression_get_value_type (_tmp486_);
		_tmp488_ = _tmp487_;
		if (_tmp488_ == NULL) {
			_tmp484_ = TRUE;
		} else {
			ValaExpression* _tmp489_;
			ValaExpression* _tmp490_;
			ValaDataType* _tmp491_;
			ValaDataType* _tmp492_;
			ValaTypeSymbol* _tmp493_;
			ValaTypeSymbol* _tmp494_;
			ValaSemanticAnalyzer* _tmp495_;
			ValaSemanticAnalyzer* _tmp496_;
			ValaDataType* _tmp497_;
			ValaTypeSymbol* _tmp498_;
			ValaTypeSymbol* _tmp499_;
			_tmp489_ = vala_binary_expression_get_right (self);
			_tmp490_ = _tmp489_;
			_tmp491_ = vala_expression_get_value_type (_tmp490_);
			_tmp492_ = _tmp491_;
			_tmp493_ = vala_data_type_get_data_type (_tmp492_);
			_tmp494_ = _tmp493_;
			_tmp495_ = vala_code_context_get_analyzer (context);
			_tmp496_ = _tmp495_;
			_tmp497_ = _tmp496_->string_type;
			_tmp498_ = vala_data_type_get_data_type (_tmp497_);
			_tmp499_ = _tmp498_;
			_tmp484_ = _tmp494_ != _tmp499_;
		}
		if (_tmp484_) {
			ValaSourceReference* _tmp500_;
			ValaSourceReference* _tmp501_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp500_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp501_ = _tmp500_;
			vala_report_error (_tmp501_, "Operands must be strings");
			result = FALSE;
			return result;
		}
		_tmp502_ = vala_code_context_get_analyzer (context);
		_tmp503_ = _tmp502_;
		_tmp504_ = _tmp503_->string_type;
		_tmp505_ = vala_data_type_copy (_tmp504_);
		_tmp506_ = _tmp505_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp506_);
		_vala_code_node_unref0 (_tmp506_);
		_tmp508_ = vala_binary_expression_get_left (self);
		_tmp509_ = _tmp508_;
		if (vala_expression_is_constant (_tmp509_)) {
			ValaExpression* _tmp510_;
			ValaExpression* _tmp511_;
			_tmp510_ = vala_binary_expression_get_right (self);
			_tmp511_ = _tmp510_;
			_tmp507_ = vala_expression_is_constant (_tmp511_);
		} else {
			_tmp507_ = FALSE;
		}
		if (_tmp507_) {
			ValaDataType* _tmp512_;
			ValaDataType* _tmp513_;
			_tmp512_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp513_ = _tmp512_;
			vala_data_type_set_value_owned (_tmp513_, FALSE);
		} else {
			ValaDataType* _tmp514_;
			ValaDataType* _tmp515_;
			_tmp514_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp515_ = _tmp514_;
			vala_data_type_set_value_owned (_tmp515_, TRUE);
		}
	} else {
		gboolean _tmp516_ = FALSE;
		ValaExpression* _tmp517_;
		ValaExpression* _tmp518_;
		ValaDataType* _tmp519_;
		ValaDataType* _tmp520_;
		_tmp517_ = vala_binary_expression_get_left (self);
		_tmp518_ = _tmp517_;
		_tmp519_ = vala_expression_get_value_type (_tmp518_);
		_tmp520_ = _tmp519_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp520_, VALA_TYPE_ARRAY_TYPE)) {
			ValaBinaryOperator _tmp521_;
			_tmp521_ = self->priv->_operator;
			_tmp516_ = _tmp521_ == VALA_BINARY_OPERATOR_PLUS;
		} else {
			_tmp516_ = FALSE;
		}
		if (_tmp516_) {
			ValaArrayType* array_type = NULL;
			ValaExpression* _tmp522_;
			ValaExpression* _tmp523_;
			ValaDataType* _tmp524_;
			ValaDataType* _tmp525_;
			ValaArrayType* _tmp526_;
			gboolean _tmp527_ = FALSE;
			ValaExpression* _tmp528_;
			ValaExpression* _tmp529_;
			ValaDataType* _tmp530_;
			ValaDataType* _tmp531_;
			ValaExpression* _tmp541_;
			ValaExpression* _tmp542_;
			ValaArrayType* _tmp543_;
			ValaDataType* _tmp544_;
			ValaDataType* _tmp545_;
			ValaDataType* _tmp546_;
			ValaDataType* _tmp547_;
			ValaArrayType* _tmp548_;
			ValaDataType* _tmp549_;
			ValaDataType* _tmp550_;
			ValaDataType* _tmp551_;
			ValaDataType* _tmp552_;
			_tmp522_ = vala_binary_expression_get_left (self);
			_tmp523_ = _tmp522_;
			_tmp524_ = vala_expression_get_value_type (_tmp523_);
			_tmp525_ = _tmp524_;
			_tmp526_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp525_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
			array_type = _tmp526_;
			_tmp528_ = vala_binary_expression_get_right (self);
			_tmp529_ = _tmp528_;
			_tmp530_ = vala_expression_get_value_type (_tmp529_);
			_tmp531_ = _tmp530_;
			if (_tmp531_ == NULL) {
				_tmp527_ = TRUE;
			} else {
				ValaExpression* _tmp532_;
				ValaExpression* _tmp533_;
				ValaDataType* _tmp534_;
				ValaDataType* _tmp535_;
				ValaArrayType* _tmp536_;
				ValaDataType* _tmp537_;
				ValaDataType* _tmp538_;
				_tmp532_ = vala_binary_expression_get_right (self);
				_tmp533_ = _tmp532_;
				_tmp534_ = vala_expression_get_value_type (_tmp533_);
				_tmp535_ = _tmp534_;
				_tmp536_ = array_type;
				_tmp537_ = vala_array_type_get_element_type (_tmp536_);
				_tmp538_ = _tmp537_;
				_tmp527_ = !vala_data_type_compatible (_tmp535_, _tmp538_);
			}
			if (_tmp527_) {
				ValaSourceReference* _tmp539_;
				ValaSourceReference* _tmp540_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp539_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp540_ = _tmp539_;
				vala_report_error (_tmp540_, "Incompatible operand");
				result = FALSE;
				_vala_code_node_unref0 (array_type);
				return result;
			}
			_tmp541_ = vala_binary_expression_get_right (self);
			_tmp542_ = _tmp541_;
			_tmp543_ = array_type;
			_tmp544_ = vala_array_type_get_element_type (_tmp543_);
			_tmp545_ = _tmp544_;
			_tmp546_ = vala_data_type_copy (_tmp545_);
			_tmp547_ = _tmp546_;
			vala_expression_set_target_type (_tmp542_, _tmp547_);
			_vala_code_node_unref0 (_tmp547_);
			_tmp548_ = array_type;
			_tmp549_ = vala_data_type_copy ((ValaDataType*) _tmp548_);
			_tmp550_ = _tmp549_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp550_);
			_vala_code_node_unref0 (_tmp550_);
			_tmp551_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp552_ = _tmp551_;
			vala_data_type_set_value_owned (_tmp552_, TRUE);
			_vala_code_node_unref0 (array_type);
		} else {
			gboolean _tmp553_ = FALSE;
			gboolean _tmp554_ = FALSE;
			gboolean _tmp555_ = FALSE;
			ValaBinaryOperator _tmp556_;
			_tmp556_ = self->priv->_operator;
			if (_tmp556_ == VALA_BINARY_OPERATOR_PLUS) {
				_tmp555_ = TRUE;
			} else {
				ValaBinaryOperator _tmp557_;
				_tmp557_ = self->priv->_operator;
				_tmp555_ = _tmp557_ == VALA_BINARY_OPERATOR_MINUS;
			}
			if (_tmp555_) {
				_tmp554_ = TRUE;
			} else {
				ValaBinaryOperator _tmp558_;
				_tmp558_ = self->priv->_operator;
				_tmp554_ = _tmp558_ == VALA_BINARY_OPERATOR_MUL;
			}
			if (_tmp554_) {
				_tmp553_ = TRUE;
			} else {
				ValaBinaryOperator _tmp559_;
				_tmp559_ = self->priv->_operator;
				_tmp553_ = _tmp559_ == VALA_BINARY_OPERATOR_DIV;
			}
			if (_tmp553_) {
				ValaExpression* _tmp560_;
				ValaExpression* _tmp561_;
				ValaDataType* _tmp562_;
				ValaDataType* _tmp563_;
				ValaDataType* _tmp608_;
				ValaDataType* _tmp609_;
				ValaDataType* _tmp622_;
				ValaDataType* _tmp623_;
				_tmp560_ = vala_binary_expression_get_left (self);
				_tmp561_ = _tmp560_;
				_tmp562_ = vala_expression_get_value_type (_tmp561_);
				_tmp563_ = _tmp562_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp563_, VALA_TYPE_POINTER_TYPE)) {
					ValaPointerType* pointer_type = NULL;
					ValaExpression* _tmp564_;
					ValaExpression* _tmp565_;
					ValaDataType* _tmp566_;
					ValaDataType* _tmp567_;
					ValaPointerType* _tmp568_;
					ValaPointerType* _tmp569_;
					ValaDataType* _tmp570_;
					ValaDataType* _tmp571_;
					ValaStruct* offset_type = NULL;
					ValaExpression* _tmp574_;
					ValaExpression* _tmp575_;
					ValaDataType* _tmp576_;
					ValaDataType* _tmp577_;
					ValaTypeSymbol* _tmp578_;
					ValaTypeSymbol* _tmp579_;
					ValaStruct* _tmp580_;
					gboolean _tmp581_ = FALSE;
					ValaStruct* _tmp582_;
					_tmp564_ = vala_binary_expression_get_left (self);
					_tmp565_ = _tmp564_;
					_tmp566_ = vala_expression_get_value_type (_tmp565_);
					_tmp567_ = _tmp566_;
					_tmp568_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp567_, VALA_TYPE_POINTER_TYPE, ValaPointerType));
					pointer_type = _tmp568_;
					_tmp569_ = pointer_type;
					_tmp570_ = vala_pointer_type_get_base_type (_tmp569_);
					_tmp571_ = _tmp570_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp571_, VALA_TYPE_VOID_TYPE)) {
						ValaSourceReference* _tmp572_;
						ValaSourceReference* _tmp573_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp572_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp573_ = _tmp572_;
						vala_report_error (_tmp573_, "Pointer arithmetic not supported for `void*'");
						result = FALSE;
						_vala_code_node_unref0 (pointer_type);
						return result;
					}
					_tmp574_ = vala_binary_expression_get_right (self);
					_tmp575_ = _tmp574_;
					_tmp576_ = vala_expression_get_value_type (_tmp575_);
					_tmp577_ = _tmp576_;
					_tmp578_ = vala_data_type_get_data_type (_tmp577_);
					_tmp579_ = _tmp578_;
					_tmp580_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp579_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp579_) : NULL);
					offset_type = _tmp580_;
					_tmp582_ = offset_type;
					if (_tmp582_ != NULL) {
						ValaStruct* _tmp583_;
						_tmp583_ = offset_type;
						_tmp581_ = vala_struct_is_integer_type (_tmp583_);
					} else {
						_tmp581_ = FALSE;
					}
					if (_tmp581_) {
						gboolean _tmp584_ = FALSE;
						ValaBinaryOperator _tmp585_;
						_tmp585_ = self->priv->_operator;
						if (_tmp585_ == VALA_BINARY_OPERATOR_PLUS) {
							_tmp584_ = TRUE;
						} else {
							ValaBinaryOperator _tmp586_;
							_tmp586_ = self->priv->_operator;
							_tmp584_ = _tmp586_ == VALA_BINARY_OPERATOR_MINUS;
						}
						if (_tmp584_) {
							ValaExpression* _tmp587_;
							ValaExpression* _tmp588_;
							ValaDataType* _tmp589_;
							ValaDataType* _tmp590_;
							ValaDataType* _tmp591_;
							ValaDataType* _tmp592_;
							_tmp587_ = vala_binary_expression_get_left (self);
							_tmp588_ = _tmp587_;
							_tmp589_ = vala_expression_get_value_type (_tmp588_);
							_tmp590_ = _tmp589_;
							_tmp591_ = vala_data_type_copy (_tmp590_);
							_tmp592_ = _tmp591_;
							vala_expression_set_value_type ((ValaExpression*) self, _tmp592_);
							_vala_code_node_unref0 (_tmp592_);
						}
					} else {
						ValaExpression* _tmp593_;
						ValaExpression* _tmp594_;
						ValaDataType* _tmp595_;
						ValaDataType* _tmp596_;
						_tmp593_ = vala_binary_expression_get_right (self);
						_tmp594_ = _tmp593_;
						_tmp595_ = vala_expression_get_value_type (_tmp594_);
						_tmp596_ = _tmp595_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp596_, VALA_TYPE_POINTER_TYPE)) {
							ValaSemanticAnalyzer* _tmp597_;
							ValaSemanticAnalyzer* _tmp598_;
							ValaDataType* _tmp599_;
							_tmp597_ = vala_code_context_get_analyzer (context);
							_tmp598_ = _tmp597_;
							_tmp599_ = _tmp598_->size_t_type;
							vala_expression_set_value_type ((ValaExpression*) self, _tmp599_);
						}
					}
					_vala_code_node_unref0 (offset_type);
					_vala_code_node_unref0 (pointer_type);
				} else {
					ValaExpression* _tmp600_;
					ValaExpression* _tmp601_;
					ValaDataType* _tmp602_;
					ValaDataType* _tmp603_;
					ValaExpression* _tmp604_;
					ValaExpression* _tmp605_;
					ValaDataType* _tmp606_;
					ValaDataType* _tmp607_;
					_tmp600_ = vala_binary_expression_get_left (self);
					_tmp601_ = _tmp600_;
					_tmp602_ = vala_expression_get_target_type (_tmp601_);
					_tmp603_ = _tmp602_;
					vala_data_type_set_nullable (_tmp603_, FALSE);
					_tmp604_ = vala_binary_expression_get_right (self);
					_tmp605_ = _tmp604_;
					_tmp606_ = vala_expression_get_target_type (_tmp605_);
					_tmp607_ = _tmp606_;
					vala_data_type_set_nullable (_tmp607_, FALSE);
				}
				_tmp608_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp609_ = _tmp608_;
				if (_tmp609_ == NULL) {
					ValaSemanticAnalyzer* _tmp610_;
					ValaSemanticAnalyzer* _tmp611_;
					ValaExpression* _tmp612_;
					ValaExpression* _tmp613_;
					ValaDataType* _tmp614_;
					ValaDataType* _tmp615_;
					ValaExpression* _tmp616_;
					ValaExpression* _tmp617_;
					ValaDataType* _tmp618_;
					ValaDataType* _tmp619_;
					ValaDataType* _tmp620_;
					ValaDataType* _tmp621_;
					_tmp610_ = vala_code_context_get_analyzer (context);
					_tmp611_ = _tmp610_;
					_tmp612_ = vala_binary_expression_get_left (self);
					_tmp613_ = _tmp612_;
					_tmp614_ = vala_expression_get_target_type (_tmp613_);
					_tmp615_ = _tmp614_;
					_tmp616_ = vala_binary_expression_get_right (self);
					_tmp617_ = _tmp616_;
					_tmp618_ = vala_expression_get_target_type (_tmp617_);
					_tmp619_ = _tmp618_;
					_tmp620_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp611_, _tmp615_, _tmp619_);
					_tmp621_ = _tmp620_;
					vala_expression_set_value_type ((ValaExpression*) self, _tmp621_);
					_vala_code_node_unref0 (_tmp621_);
				}
				_tmp622_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp623_ = _tmp622_;
				if (_tmp623_ == NULL) {
					ValaSourceReference* _tmp624_;
					ValaSourceReference* _tmp625_;
					ValaExpression* _tmp626_;
					ValaExpression* _tmp627_;
					ValaDataType* _tmp628_;
					ValaDataType* _tmp629_;
					gchar* _tmp630_;
					gchar* _tmp631_;
					ValaExpression* _tmp632_;
					ValaExpression* _tmp633_;
					ValaDataType* _tmp634_;
					ValaDataType* _tmp635_;
					gchar* _tmp636_;
					gchar* _tmp637_;
					gchar* _tmp638_;
					gchar* _tmp639_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp624_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp625_ = _tmp624_;
					_tmp626_ = vala_binary_expression_get_left (self);
					_tmp627_ = _tmp626_;
					_tmp628_ = vala_expression_get_value_type (_tmp627_);
					_tmp629_ = _tmp628_;
					_tmp630_ = vala_code_node_to_string ((ValaCodeNode*) _tmp629_);
					_tmp631_ = _tmp630_;
					_tmp632_ = vala_binary_expression_get_right (self);
					_tmp633_ = _tmp632_;
					_tmp634_ = vala_expression_get_value_type (_tmp633_);
					_tmp635_ = _tmp634_;
					_tmp636_ = vala_code_node_to_string ((ValaCodeNode*) _tmp635_);
					_tmp637_ = _tmp636_;
					_tmp638_ = g_strdup_printf ("Arithmetic operation not supported for types `%s' and `%s'", _tmp631_, _tmp637_);
					_tmp639_ = _tmp638_;
					vala_report_error (_tmp625_, _tmp639_);
					_g_free0 (_tmp639_);
					_g_free0 (_tmp637_);
					_g_free0 (_tmp631_);
					result = FALSE;
					return result;
				}
			} else {
				gboolean _tmp640_ = FALSE;
				gboolean _tmp641_ = FALSE;
				ValaBinaryOperator _tmp642_;
				_tmp642_ = self->priv->_operator;
				if (_tmp642_ == VALA_BINARY_OPERATOR_MOD) {
					_tmp641_ = TRUE;
				} else {
					ValaBinaryOperator _tmp643_;
					_tmp643_ = self->priv->_operator;
					_tmp641_ = _tmp643_ == VALA_BINARY_OPERATOR_SHIFT_LEFT;
				}
				if (_tmp641_) {
					_tmp640_ = TRUE;
				} else {
					ValaBinaryOperator _tmp644_;
					_tmp644_ = self->priv->_operator;
					_tmp640_ = _tmp644_ == VALA_BINARY_OPERATOR_SHIFT_RIGHT;
				}
				if (_tmp640_) {
					ValaExpression* _tmp645_;
					ValaExpression* _tmp646_;
					ValaDataType* _tmp647_;
					ValaDataType* _tmp648_;
					ValaExpression* _tmp649_;
					ValaExpression* _tmp650_;
					ValaDataType* _tmp651_;
					ValaDataType* _tmp652_;
					ValaSemanticAnalyzer* _tmp653_;
					ValaSemanticAnalyzer* _tmp654_;
					ValaExpression* _tmp655_;
					ValaExpression* _tmp656_;
					ValaDataType* _tmp657_;
					ValaDataType* _tmp658_;
					ValaExpression* _tmp659_;
					ValaExpression* _tmp660_;
					ValaDataType* _tmp661_;
					ValaDataType* _tmp662_;
					ValaDataType* _tmp663_;
					ValaDataType* _tmp664_;
					ValaDataType* _tmp665_;
					ValaDataType* _tmp666_;
					_tmp645_ = vala_binary_expression_get_left (self);
					_tmp646_ = _tmp645_;
					_tmp647_ = vala_expression_get_target_type (_tmp646_);
					_tmp648_ = _tmp647_;
					vala_data_type_set_nullable (_tmp648_, FALSE);
					_tmp649_ = vala_binary_expression_get_right (self);
					_tmp650_ = _tmp649_;
					_tmp651_ = vala_expression_get_target_type (_tmp650_);
					_tmp652_ = _tmp651_;
					vala_data_type_set_nullable (_tmp652_, FALSE);
					_tmp653_ = vala_code_context_get_analyzer (context);
					_tmp654_ = _tmp653_;
					_tmp655_ = vala_binary_expression_get_left (self);
					_tmp656_ = _tmp655_;
					_tmp657_ = vala_expression_get_target_type (_tmp656_);
					_tmp658_ = _tmp657_;
					_tmp659_ = vala_binary_expression_get_right (self);
					_tmp660_ = _tmp659_;
					_tmp661_ = vala_expression_get_target_type (_tmp660_);
					_tmp662_ = _tmp661_;
					_tmp663_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp654_, _tmp658_, _tmp662_);
					_tmp664_ = _tmp663_;
					vala_expression_set_value_type ((ValaExpression*) self, _tmp664_);
					_vala_code_node_unref0 (_tmp664_);
					_tmp665_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp666_ = _tmp665_;
					if (_tmp666_ == NULL) {
						ValaSourceReference* _tmp667_;
						ValaSourceReference* _tmp668_;
						ValaExpression* _tmp669_;
						ValaExpression* _tmp670_;
						ValaDataType* _tmp671_;
						ValaDataType* _tmp672_;
						gchar* _tmp673_;
						gchar* _tmp674_;
						ValaExpression* _tmp675_;
						ValaExpression* _tmp676_;
						ValaDataType* _tmp677_;
						ValaDataType* _tmp678_;
						gchar* _tmp679_;
						gchar* _tmp680_;
						gchar* _tmp681_;
						gchar* _tmp682_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp667_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp668_ = _tmp667_;
						_tmp669_ = vala_binary_expression_get_left (self);
						_tmp670_ = _tmp669_;
						_tmp671_ = vala_expression_get_value_type (_tmp670_);
						_tmp672_ = _tmp671_;
						_tmp673_ = vala_code_node_to_string ((ValaCodeNode*) _tmp672_);
						_tmp674_ = _tmp673_;
						_tmp675_ = vala_binary_expression_get_right (self);
						_tmp676_ = _tmp675_;
						_tmp677_ = vala_expression_get_value_type (_tmp676_);
						_tmp678_ = _tmp677_;
						_tmp679_ = vala_code_node_to_string ((ValaCodeNode*) _tmp678_);
						_tmp680_ = _tmp679_;
						_tmp681_ = g_strdup_printf ("Arithmetic operation not supported for types `%s' and `%s'", _tmp674_, _tmp680_);
						_tmp682_ = _tmp681_;
						vala_report_error (_tmp668_, _tmp682_);
						_g_free0 (_tmp682_);
						_g_free0 (_tmp680_);
						_g_free0 (_tmp674_);
						result = FALSE;
						return result;
					}
				} else {
					gboolean _tmp683_ = FALSE;
					gboolean _tmp684_ = FALSE;
					gboolean _tmp685_ = FALSE;
					ValaBinaryOperator _tmp686_;
					_tmp686_ = self->priv->_operator;
					if (_tmp686_ == VALA_BINARY_OPERATOR_LESS_THAN) {
						_tmp685_ = TRUE;
					} else {
						ValaBinaryOperator _tmp687_;
						_tmp687_ = self->priv->_operator;
						_tmp685_ = _tmp687_ == VALA_BINARY_OPERATOR_GREATER_THAN;
					}
					if (_tmp685_) {
						_tmp684_ = TRUE;
					} else {
						ValaBinaryOperator _tmp688_;
						_tmp688_ = self->priv->_operator;
						_tmp684_ = _tmp688_ == VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL;
					}
					if (_tmp684_) {
						_tmp683_ = TRUE;
					} else {
						ValaBinaryOperator _tmp689_;
						_tmp689_ = self->priv->_operator;
						_tmp683_ = _tmp689_ == VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL;
					}
					if (_tmp683_) {
						gboolean _tmp690_ = FALSE;
						ValaExpression* _tmp691_;
						ValaExpression* _tmp692_;
						ValaDataType* _tmp693_;
						ValaDataType* _tmp694_;
						ValaSemanticAnalyzer* _tmp695_;
						ValaSemanticAnalyzer* _tmp696_;
						ValaDataType* _tmp697_;
						ValaSemanticAnalyzer* _tmp777_;
						ValaSemanticAnalyzer* _tmp778_;
						ValaDataType* _tmp779_;
						_tmp691_ = vala_binary_expression_get_left (self);
						_tmp692_ = _tmp691_;
						_tmp693_ = vala_expression_get_value_type (_tmp692_);
						_tmp694_ = _tmp693_;
						_tmp695_ = vala_code_context_get_analyzer (context);
						_tmp696_ = _tmp695_;
						_tmp697_ = _tmp696_->string_type;
						if (vala_data_type_compatible (_tmp694_, _tmp697_)) {
							ValaExpression* _tmp698_;
							ValaExpression* _tmp699_;
							ValaDataType* _tmp700_;
							ValaDataType* _tmp701_;
							ValaSemanticAnalyzer* _tmp702_;
							ValaSemanticAnalyzer* _tmp703_;
							ValaDataType* _tmp704_;
							_tmp698_ = vala_binary_expression_get_right (self);
							_tmp699_ = _tmp698_;
							_tmp700_ = vala_expression_get_value_type (_tmp699_);
							_tmp701_ = _tmp700_;
							_tmp702_ = vala_code_context_get_analyzer (context);
							_tmp703_ = _tmp702_;
							_tmp704_ = _tmp703_->string_type;
							_tmp690_ = vala_data_type_compatible (_tmp701_, _tmp704_);
						} else {
							_tmp690_ = FALSE;
						}
						if (_tmp690_) {
						} else {
							gboolean _tmp705_ = FALSE;
							ValaExpression* _tmp706_;
							ValaExpression* _tmp707_;
							ValaDataType* _tmp708_;
							ValaDataType* _tmp709_;
							_tmp706_ = vala_binary_expression_get_left (self);
							_tmp707_ = _tmp706_;
							_tmp708_ = vala_expression_get_value_type (_tmp707_);
							_tmp709_ = _tmp708_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp709_, VALA_TYPE_POINTER_TYPE)) {
								ValaExpression* _tmp710_;
								ValaExpression* _tmp711_;
								ValaDataType* _tmp712_;
								ValaDataType* _tmp713_;
								_tmp710_ = vala_binary_expression_get_right (self);
								_tmp711_ = _tmp710_;
								_tmp712_ = vala_expression_get_value_type (_tmp711_);
								_tmp713_ = _tmp712_;
								_tmp705_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp713_, VALA_TYPE_POINTER_TYPE);
							} else {
								_tmp705_ = FALSE;
							}
							if (_tmp705_) {
							} else {
								ValaDataType* resulting_type = NULL;
								gboolean _tmp714_;
								ValaDataType* _tmp741_;
								gboolean _tmp758_;
								ValaExpression* _tmp764_;
								ValaExpression* _tmp765_;
								ValaDataType* _tmp766_;
								ValaDataType* _tmp767_;
								ValaDataType* _tmp768_;
								ValaExpression* _tmp769_;
								ValaExpression* _tmp770_;
								ValaDataType* _tmp771_;
								ValaDataType* _tmp772_;
								ValaExpression* _tmp773_;
								ValaExpression* _tmp774_;
								ValaDataType* _tmp775_;
								ValaDataType* _tmp776_;
								_tmp714_ = self->priv->_is_chained;
								if (_tmp714_) {
									ValaBinaryExpression* lbe = NULL;
									ValaExpression* _tmp715_;
									ValaExpression* _tmp716_;
									ValaBinaryExpression* _tmp717_;
									ValaSemanticAnalyzer* _tmp718_;
									ValaSemanticAnalyzer* _tmp719_;
									ValaBinaryExpression* _tmp720_;
									ValaExpression* _tmp721_;
									ValaExpression* _tmp722_;
									ValaDataType* _tmp723_;
									ValaDataType* _tmp724_;
									ValaExpression* _tmp725_;
									ValaExpression* _tmp726_;
									ValaDataType* _tmp727_;
									ValaDataType* _tmp728_;
									ValaDataType* _tmp729_;
									_tmp715_ = vala_binary_expression_get_left (self);
									_tmp716_ = _tmp715_;
									_tmp717_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp716_, VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpression));
									lbe = _tmp717_;
									_tmp718_ = vala_code_context_get_analyzer (context);
									_tmp719_ = _tmp718_;
									_tmp720_ = lbe;
									_tmp721_ = vala_binary_expression_get_right (_tmp720_);
									_tmp722_ = _tmp721_;
									_tmp723_ = vala_expression_get_target_type (_tmp722_);
									_tmp724_ = _tmp723_;
									_tmp725_ = vala_binary_expression_get_right (self);
									_tmp726_ = _tmp725_;
									_tmp727_ = vala_expression_get_target_type (_tmp726_);
									_tmp728_ = _tmp727_;
									_tmp729_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp719_, _tmp724_, _tmp728_);
									_vala_code_node_unref0 (resulting_type);
									resulting_type = _tmp729_;
									_vala_code_node_unref0 (lbe);
								} else {
									ValaSemanticAnalyzer* _tmp730_;
									ValaSemanticAnalyzer* _tmp731_;
									ValaExpression* _tmp732_;
									ValaExpression* _tmp733_;
									ValaDataType* _tmp734_;
									ValaDataType* _tmp735_;
									ValaExpression* _tmp736_;
									ValaExpression* _tmp737_;
									ValaDataType* _tmp738_;
									ValaDataType* _tmp739_;
									ValaDataType* _tmp740_;
									_tmp730_ = vala_code_context_get_analyzer (context);
									_tmp731_ = _tmp730_;
									_tmp732_ = vala_binary_expression_get_left (self);
									_tmp733_ = _tmp732_;
									_tmp734_ = vala_expression_get_target_type (_tmp733_);
									_tmp735_ = _tmp734_;
									_tmp736_ = vala_binary_expression_get_right (self);
									_tmp737_ = _tmp736_;
									_tmp738_ = vala_expression_get_target_type (_tmp737_);
									_tmp739_ = _tmp738_;
									_tmp740_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp731_, _tmp735_, _tmp739_);
									_vala_code_node_unref0 (resulting_type);
									resulting_type = _tmp740_;
								}
								_tmp741_ = resulting_type;
								if (_tmp741_ == NULL) {
									ValaSourceReference* _tmp742_;
									ValaSourceReference* _tmp743_;
									ValaExpression* _tmp744_;
									ValaExpression* _tmp745_;
									ValaDataType* _tmp746_;
									ValaDataType* _tmp747_;
									gchar* _tmp748_;
									gchar* _tmp749_;
									ValaExpression* _tmp750_;
									ValaExpression* _tmp751_;
									ValaDataType* _tmp752_;
									ValaDataType* _tmp753_;
									gchar* _tmp754_;
									gchar* _tmp755_;
									gchar* _tmp756_;
									gchar* _tmp757_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp742_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp743_ = _tmp742_;
									_tmp744_ = vala_binary_expression_get_left (self);
									_tmp745_ = _tmp744_;
									_tmp746_ = vala_expression_get_value_type (_tmp745_);
									_tmp747_ = _tmp746_;
									_tmp748_ = vala_code_node_to_string ((ValaCodeNode*) _tmp747_);
									_tmp749_ = _tmp748_;
									_tmp750_ = vala_binary_expression_get_right (self);
									_tmp751_ = _tmp750_;
									_tmp752_ = vala_expression_get_value_type (_tmp751_);
									_tmp753_ = _tmp752_;
									_tmp754_ = vala_code_node_to_string ((ValaCodeNode*) _tmp753_);
									_tmp755_ = _tmp754_;
									_tmp756_ = g_strdup_printf ("Relational operation not supported for types `%s' and `%s'", _tmp749_, _tmp755_);
									_tmp757_ = _tmp756_;
									vala_report_error (_tmp743_, _tmp757_);
									_g_free0 (_tmp757_);
									_g_free0 (_tmp755_);
									_g_free0 (_tmp749_);
									result = FALSE;
									_vala_code_node_unref0 (resulting_type);
									return result;
								}
								_tmp758_ = self->priv->_is_chained;
								if (!_tmp758_) {
									ValaExpression* _tmp759_;
									ValaExpression* _tmp760_;
									ValaDataType* _tmp761_;
									ValaDataType* _tmp762_;
									ValaDataType* _tmp763_;
									_tmp759_ = vala_binary_expression_get_left (self);
									_tmp760_ = _tmp759_;
									_tmp761_ = resulting_type;
									_tmp762_ = vala_data_type_copy (_tmp761_);
									_tmp763_ = _tmp762_;
									vala_expression_set_target_type (_tmp760_, _tmp763_);
									_vala_code_node_unref0 (_tmp763_);
								}
								_tmp764_ = vala_binary_expression_get_right (self);
								_tmp765_ = _tmp764_;
								_tmp766_ = resulting_type;
								_tmp767_ = vala_data_type_copy (_tmp766_);
								_tmp768_ = _tmp767_;
								vala_expression_set_target_type (_tmp765_, _tmp768_);
								_vala_code_node_unref0 (_tmp768_);
								_tmp769_ = vala_binary_expression_get_left (self);
								_tmp770_ = _tmp769_;
								_tmp771_ = vala_expression_get_target_type (_tmp770_);
								_tmp772_ = _tmp771_;
								vala_data_type_set_nullable (_tmp772_, FALSE);
								_tmp773_ = vala_binary_expression_get_right (self);
								_tmp774_ = _tmp773_;
								_tmp775_ = vala_expression_get_target_type (_tmp774_);
								_tmp776_ = _tmp775_;
								vala_data_type_set_nullable (_tmp776_, FALSE);
								_vala_code_node_unref0 (resulting_type);
							}
						}
						_tmp777_ = vala_code_context_get_analyzer (context);
						_tmp778_ = _tmp777_;
						_tmp779_ = _tmp778_->bool_type;
						vala_expression_set_value_type ((ValaExpression*) self, _tmp779_);
					} else {
						gboolean _tmp780_ = FALSE;
						ValaBinaryOperator _tmp781_;
						_tmp781_ = self->priv->_operator;
						if (_tmp781_ == VALA_BINARY_OPERATOR_EQUALITY) {
							_tmp780_ = TRUE;
						} else {
							ValaBinaryOperator _tmp782_;
							_tmp782_ = self->priv->_operator;
							_tmp780_ = _tmp782_ == VALA_BINARY_OPERATOR_INEQUALITY;
						}
						if (_tmp780_) {
							gboolean _tmp783_ = FALSE;
							ValaExpression* _tmp784_;
							ValaExpression* _tmp785_;
							ValaDataType* _tmp786_;
							ValaDataType* _tmp787_;
							ValaExpression* _tmp788_;
							ValaExpression* _tmp789_;
							ValaDataType* _tmp790_;
							ValaDataType* _tmp791_;
							ValaDataType* resulting_type = NULL;
							ValaSemanticAnalyzer* _tmp816_;
							ValaSemanticAnalyzer* _tmp817_;
							ValaExpression* _tmp818_;
							ValaExpression* _tmp819_;
							ValaDataType* _tmp820_;
							ValaDataType* _tmp821_;
							ValaExpression* _tmp822_;
							ValaExpression* _tmp823_;
							ValaDataType* _tmp824_;
							ValaDataType* _tmp825_;
							ValaDataType* _tmp826_;
							ValaDataType* _tmp827_;
							ValaExpression* _tmp838_;
							ValaExpression* _tmp839_;
							ValaDataType* _tmp840_;
							ValaDataType* _tmp841_;
							ValaExpression* _tmp842_;
							ValaExpression* _tmp843_;
							ValaDataType* _tmp844_;
							ValaDataType* _tmp845_;
							ValaExpression* _tmp846_;
							ValaExpression* _tmp847_;
							ValaDataType* _tmp848_;
							ValaDataType* _tmp849_;
							gboolean _tmp850_;
							gboolean _tmp851_;
							ValaExpression* _tmp852_;
							ValaExpression* _tmp853_;
							ValaDataType* _tmp854_;
							ValaDataType* _tmp855_;
							gboolean _tmp856_;
							gboolean _tmp857_;
							ValaSemanticAnalyzer* _tmp866_;
							ValaSemanticAnalyzer* _tmp867_;
							ValaDataType* _tmp868_;
							_tmp784_ = vala_binary_expression_get_right (self);
							_tmp785_ = _tmp784_;
							_tmp786_ = vala_expression_get_value_type (_tmp785_);
							_tmp787_ = _tmp786_;
							_tmp788_ = vala_binary_expression_get_left (self);
							_tmp789_ = _tmp788_;
							_tmp790_ = vala_expression_get_value_type (_tmp789_);
							_tmp791_ = _tmp790_;
							if (!vala_data_type_compatible (_tmp787_, _tmp791_)) {
								ValaExpression* _tmp792_;
								ValaExpression* _tmp793_;
								ValaDataType* _tmp794_;
								ValaDataType* _tmp795_;
								ValaExpression* _tmp796_;
								ValaExpression* _tmp797_;
								ValaDataType* _tmp798_;
								ValaDataType* _tmp799_;
								_tmp792_ = vala_binary_expression_get_left (self);
								_tmp793_ = _tmp792_;
								_tmp794_ = vala_expression_get_value_type (_tmp793_);
								_tmp795_ = _tmp794_;
								_tmp796_ = vala_binary_expression_get_right (self);
								_tmp797_ = _tmp796_;
								_tmp798_ = vala_expression_get_value_type (_tmp797_);
								_tmp799_ = _tmp798_;
								_tmp783_ = !vala_data_type_compatible (_tmp795_, _tmp799_);
							} else {
								_tmp783_ = FALSE;
							}
							if (_tmp783_) {
								ValaSourceReference* _tmp800_;
								ValaSourceReference* _tmp801_;
								ValaExpression* _tmp802_;
								ValaExpression* _tmp803_;
								ValaDataType* _tmp804_;
								ValaDataType* _tmp805_;
								gchar* _tmp806_;
								gchar* _tmp807_;
								ValaExpression* _tmp808_;
								ValaExpression* _tmp809_;
								ValaDataType* _tmp810_;
								ValaDataType* _tmp811_;
								gchar* _tmp812_;
								gchar* _tmp813_;
								gchar* _tmp814_;
								gchar* _tmp815_;
								_tmp800_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp801_ = _tmp800_;
								_tmp802_ = vala_binary_expression_get_right (self);
								_tmp803_ = _tmp802_;
								_tmp804_ = vala_expression_get_value_type (_tmp803_);
								_tmp805_ = _tmp804_;
								_tmp806_ = vala_code_node_to_string ((ValaCodeNode*) _tmp805_);
								_tmp807_ = _tmp806_;
								_tmp808_ = vala_binary_expression_get_left (self);
								_tmp809_ = _tmp808_;
								_tmp810_ = vala_expression_get_value_type (_tmp809_);
								_tmp811_ = _tmp810_;
								_tmp812_ = vala_code_node_to_string ((ValaCodeNode*) _tmp811_);
								_tmp813_ = _tmp812_;
								_tmp814_ = g_strdup_printf ("Equality operation: `%s' and `%s' are incompatible", _tmp807_, _tmp813_);
								_tmp815_ = _tmp814_;
								vala_report_error (_tmp801_, _tmp815_);
								_g_free0 (_tmp815_);
								_g_free0 (_tmp813_);
								_g_free0 (_tmp807_);
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								return result;
							}
							_tmp816_ = vala_code_context_get_analyzer (context);
							_tmp817_ = _tmp816_;
							_tmp818_ = vala_binary_expression_get_left (self);
							_tmp819_ = _tmp818_;
							_tmp820_ = vala_expression_get_target_type (_tmp819_);
							_tmp821_ = _tmp820_;
							_tmp822_ = vala_binary_expression_get_right (self);
							_tmp823_ = _tmp822_;
							_tmp824_ = vala_expression_get_target_type (_tmp823_);
							_tmp825_ = _tmp824_;
							_tmp826_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp817_, _tmp821_, _tmp825_);
							resulting_type = _tmp826_;
							_tmp827_ = resulting_type;
							if (_tmp827_ != NULL) {
								ValaExpression* _tmp828_;
								ValaExpression* _tmp829_;
								ValaDataType* _tmp830_;
								ValaDataType* _tmp831_;
								ValaDataType* _tmp832_;
								ValaExpression* _tmp833_;
								ValaExpression* _tmp834_;
								ValaDataType* _tmp835_;
								ValaDataType* _tmp836_;
								ValaDataType* _tmp837_;
								_tmp828_ = vala_binary_expression_get_left (self);
								_tmp829_ = _tmp828_;
								_tmp830_ = resulting_type;
								_tmp831_ = vala_data_type_copy (_tmp830_);
								_tmp832_ = _tmp831_;
								vala_expression_set_target_type (_tmp829_, _tmp832_);
								_vala_code_node_unref0 (_tmp832_);
								_tmp833_ = vala_binary_expression_get_right (self);
								_tmp834_ = _tmp833_;
								_tmp835_ = resulting_type;
								_tmp836_ = vala_data_type_copy (_tmp835_);
								_tmp837_ = _tmp836_;
								vala_expression_set_target_type (_tmp834_, _tmp837_);
								_vala_code_node_unref0 (_tmp837_);
							}
							_tmp838_ = vala_binary_expression_get_left (self);
							_tmp839_ = _tmp838_;
							_tmp840_ = vala_expression_get_target_type (_tmp839_);
							_tmp841_ = _tmp840_;
							vala_data_type_set_value_owned (_tmp841_, FALSE);
							_tmp842_ = vala_binary_expression_get_right (self);
							_tmp843_ = _tmp842_;
							_tmp844_ = vala_expression_get_target_type (_tmp843_);
							_tmp845_ = _tmp844_;
							vala_data_type_set_value_owned (_tmp845_, FALSE);
							_tmp846_ = vala_binary_expression_get_left (self);
							_tmp847_ = _tmp846_;
							_tmp848_ = vala_expression_get_value_type (_tmp847_);
							_tmp849_ = _tmp848_;
							_tmp850_ = vala_data_type_get_nullable (_tmp849_);
							_tmp851_ = _tmp850_;
							_tmp852_ = vala_binary_expression_get_right (self);
							_tmp853_ = _tmp852_;
							_tmp854_ = vala_expression_get_value_type (_tmp853_);
							_tmp855_ = _tmp854_;
							_tmp856_ = vala_data_type_get_nullable (_tmp855_);
							_tmp857_ = _tmp856_;
							if (_tmp851_ != _tmp857_) {
								ValaExpression* _tmp858_;
								ValaExpression* _tmp859_;
								ValaDataType* _tmp860_;
								ValaDataType* _tmp861_;
								ValaExpression* _tmp862_;
								ValaExpression* _tmp863_;
								ValaDataType* _tmp864_;
								ValaDataType* _tmp865_;
								_tmp858_ = vala_binary_expression_get_left (self);
								_tmp859_ = _tmp858_;
								_tmp860_ = vala_expression_get_target_type (_tmp859_);
								_tmp861_ = _tmp860_;
								vala_data_type_set_nullable (_tmp861_, TRUE);
								_tmp862_ = vala_binary_expression_get_right (self);
								_tmp863_ = _tmp862_;
								_tmp864_ = vala_expression_get_target_type (_tmp863_);
								_tmp865_ = _tmp864_;
								vala_data_type_set_nullable (_tmp865_, TRUE);
							}
							_tmp866_ = vala_code_context_get_analyzer (context);
							_tmp867_ = _tmp866_;
							_tmp868_ = _tmp867_->bool_type;
							vala_expression_set_value_type ((ValaExpression*) self, _tmp868_);
							_vala_code_node_unref0 (resulting_type);
						} else {
							gboolean _tmp869_ = FALSE;
							gboolean _tmp870_ = FALSE;
							ValaBinaryOperator _tmp871_;
							_tmp871_ = self->priv->_operator;
							if (_tmp871_ == VALA_BINARY_OPERATOR_BITWISE_AND) {
								_tmp870_ = TRUE;
							} else {
								ValaBinaryOperator _tmp872_;
								_tmp872_ = self->priv->_operator;
								_tmp870_ = _tmp872_ == VALA_BINARY_OPERATOR_BITWISE_OR;
							}
							if (_tmp870_) {
								_tmp869_ = TRUE;
							} else {
								ValaBinaryOperator _tmp873_;
								_tmp873_ = self->priv->_operator;
								_tmp869_ = _tmp873_ == VALA_BINARY_OPERATOR_BITWISE_XOR;
							}
							if (_tmp869_) {
								ValaExpression* _tmp874_;
								ValaExpression* _tmp875_;
								ValaDataType* _tmp876_;
								ValaDataType* _tmp877_;
								ValaExpression* _tmp878_;
								ValaExpression* _tmp879_;
								ValaDataType* _tmp880_;
								ValaDataType* _tmp881_;
								ValaExpression* _tmp882_;
								ValaExpression* _tmp883_;
								ValaDataType* _tmp884_;
								ValaDataType* _tmp885_;
								ValaDataType* _tmp886_;
								ValaDataType* _tmp887_;
								_tmp874_ = vala_binary_expression_get_left (self);
								_tmp875_ = _tmp874_;
								_tmp876_ = vala_expression_get_target_type (_tmp875_);
								_tmp877_ = _tmp876_;
								vala_data_type_set_nullable (_tmp877_, FALSE);
								_tmp878_ = vala_binary_expression_get_right (self);
								_tmp879_ = _tmp878_;
								_tmp880_ = vala_expression_get_target_type (_tmp879_);
								_tmp881_ = _tmp880_;
								vala_data_type_set_nullable (_tmp881_, FALSE);
								_tmp882_ = vala_binary_expression_get_left (self);
								_tmp883_ = _tmp882_;
								_tmp884_ = vala_expression_get_target_type (_tmp883_);
								_tmp885_ = _tmp884_;
								_tmp886_ = vala_data_type_copy (_tmp885_);
								_tmp887_ = _tmp886_;
								vala_expression_set_value_type ((ValaExpression*) self, _tmp887_);
								_vala_code_node_unref0 (_tmp887_);
							} else {
								gboolean _tmp888_ = FALSE;
								ValaBinaryOperator _tmp889_;
								_tmp889_ = self->priv->_operator;
								if (_tmp889_ == VALA_BINARY_OPERATOR_AND) {
									_tmp888_ = TRUE;
								} else {
									ValaBinaryOperator _tmp890_;
									_tmp890_ = self->priv->_operator;
									_tmp888_ = _tmp890_ == VALA_BINARY_OPERATOR_OR;
								}
								if (_tmp888_) {
									gboolean _tmp891_ = FALSE;
									ValaExpression* _tmp892_;
									ValaExpression* _tmp893_;
									ValaDataType* _tmp894_;
									ValaDataType* _tmp895_;
									ValaSemanticAnalyzer* _tmp896_;
									ValaSemanticAnalyzer* _tmp897_;
									ValaDataType* _tmp898_;
									ValaExpression* _tmp908_;
									ValaExpression* _tmp909_;
									ValaDataType* _tmp910_;
									ValaDataType* _tmp911_;
									ValaExpression* _tmp912_;
									ValaExpression* _tmp913_;
									ValaDataType* _tmp914_;
									ValaDataType* _tmp915_;
									ValaSemanticAnalyzer* _tmp916_;
									ValaSemanticAnalyzer* _tmp917_;
									ValaDataType* _tmp918_;
									_tmp892_ = vala_binary_expression_get_left (self);
									_tmp893_ = _tmp892_;
									_tmp894_ = vala_expression_get_value_type (_tmp893_);
									_tmp895_ = _tmp894_;
									_tmp896_ = vala_code_context_get_analyzer (context);
									_tmp897_ = _tmp896_;
									_tmp898_ = _tmp897_->bool_type;
									if (!vala_data_type_compatible (_tmp895_, _tmp898_)) {
										_tmp891_ = TRUE;
									} else {
										ValaExpression* _tmp899_;
										ValaExpression* _tmp900_;
										ValaDataType* _tmp901_;
										ValaDataType* _tmp902_;
										ValaSemanticAnalyzer* _tmp903_;
										ValaSemanticAnalyzer* _tmp904_;
										ValaDataType* _tmp905_;
										_tmp899_ = vala_binary_expression_get_right (self);
										_tmp900_ = _tmp899_;
										_tmp901_ = vala_expression_get_value_type (_tmp900_);
										_tmp902_ = _tmp901_;
										_tmp903_ = vala_code_context_get_analyzer (context);
										_tmp904_ = _tmp903_;
										_tmp905_ = _tmp904_->bool_type;
										_tmp891_ = !vala_data_type_compatible (_tmp902_, _tmp905_);
									}
									if (_tmp891_) {
										ValaSourceReference* _tmp906_;
										ValaSourceReference* _tmp907_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp906_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
										_tmp907_ = _tmp906_;
										vala_report_error (_tmp907_, "Operands must be boolean");
									}
									_tmp908_ = vala_binary_expression_get_left (self);
									_tmp909_ = _tmp908_;
									_tmp910_ = vala_expression_get_target_type (_tmp909_);
									_tmp911_ = _tmp910_;
									vala_data_type_set_nullable (_tmp911_, FALSE);
									_tmp912_ = vala_binary_expression_get_right (self);
									_tmp913_ = _tmp912_;
									_tmp914_ = vala_expression_get_target_type (_tmp913_);
									_tmp915_ = _tmp914_;
									vala_data_type_set_nullable (_tmp915_, FALSE);
									_tmp916_ = vala_code_context_get_analyzer (context);
									_tmp917_ = _tmp916_;
									_tmp918_ = _tmp917_->bool_type;
									vala_expression_set_value_type ((ValaExpression*) self, _tmp918_);
								} else {
									ValaBinaryOperator _tmp919_;
									_tmp919_ = self->priv->_operator;
									if (_tmp919_ == VALA_BINARY_OPERATOR_IN) {
										gboolean _tmp920_ = FALSE;
										ValaExpression* _tmp921_;
										ValaExpression* _tmp922_;
										ValaDataType* _tmp923_;
										ValaDataType* _tmp924_;
										ValaSemanticAnalyzer* _tmp925_;
										ValaSemanticAnalyzer* _tmp926_;
										ValaDataType* _tmp927_;
										ValaSemanticAnalyzer* _tmp1033_;
										ValaSemanticAnalyzer* _tmp1034_;
										ValaDataType* _tmp1035_;
										_tmp921_ = vala_binary_expression_get_left (self);
										_tmp922_ = _tmp921_;
										_tmp923_ = vala_expression_get_value_type (_tmp922_);
										_tmp924_ = _tmp923_;
										_tmp925_ = vala_code_context_get_analyzer (context);
										_tmp926_ = _tmp925_;
										_tmp927_ = _tmp926_->int_type;
										if (vala_data_type_compatible (_tmp924_, _tmp927_)) {
											ValaExpression* _tmp928_;
											ValaExpression* _tmp929_;
											ValaDataType* _tmp930_;
											ValaDataType* _tmp931_;
											ValaSemanticAnalyzer* _tmp932_;
											ValaSemanticAnalyzer* _tmp933_;
											ValaDataType* _tmp934_;
											_tmp928_ = vala_binary_expression_get_right (self);
											_tmp929_ = _tmp928_;
											_tmp930_ = vala_expression_get_value_type (_tmp929_);
											_tmp931_ = _tmp930_;
											_tmp932_ = vala_code_context_get_analyzer (context);
											_tmp933_ = _tmp932_;
											_tmp934_ = _tmp933_->int_type;
											_tmp920_ = vala_data_type_compatible (_tmp931_, _tmp934_);
										} else {
											_tmp920_ = FALSE;
										}
										if (_tmp920_) {
											ValaExpression* _tmp935_;
											ValaExpression* _tmp936_;
											ValaDataType* _tmp937_;
											ValaDataType* _tmp938_;
											ValaExpression* _tmp939_;
											ValaExpression* _tmp940_;
											ValaDataType* _tmp941_;
											ValaDataType* _tmp942_;
											_tmp935_ = vala_binary_expression_get_left (self);
											_tmp936_ = _tmp935_;
											_tmp937_ = vala_expression_get_target_type (_tmp936_);
											_tmp938_ = _tmp937_;
											vala_data_type_set_nullable (_tmp938_, FALSE);
											_tmp939_ = vala_binary_expression_get_right (self);
											_tmp940_ = _tmp939_;
											_tmp941_ = vala_expression_get_target_type (_tmp940_);
											_tmp942_ = _tmp941_;
											vala_data_type_set_nullable (_tmp942_, FALSE);
										} else {
											ValaExpression* _tmp943_;
											ValaExpression* _tmp944_;
											ValaDataType* _tmp945_;
											ValaDataType* _tmp946_;
											_tmp943_ = vala_binary_expression_get_right (self);
											_tmp944_ = _tmp943_;
											_tmp945_ = vala_expression_get_value_type (_tmp944_);
											_tmp946_ = _tmp945_;
											if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp946_, VALA_TYPE_ARRAY_TYPE)) {
												ValaExpression* _tmp947_;
												ValaExpression* _tmp948_;
												ValaDataType* _tmp949_;
												ValaDataType* _tmp950_;
												ValaExpression* _tmp951_;
												ValaExpression* _tmp952_;
												ValaDataType* _tmp953_;
												ValaDataType* _tmp954_;
												ValaDataType* _tmp955_;
												ValaDataType* _tmp956_;
												_tmp947_ = vala_binary_expression_get_left (self);
												_tmp948_ = _tmp947_;
												_tmp949_ = vala_expression_get_value_type (_tmp948_);
												_tmp950_ = _tmp949_;
												_tmp951_ = vala_binary_expression_get_right (self);
												_tmp952_ = _tmp951_;
												_tmp953_ = vala_expression_get_value_type (_tmp952_);
												_tmp954_ = _tmp953_;
												_tmp955_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp954_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
												_tmp956_ = _tmp955_;
												if (!vala_data_type_compatible (_tmp950_, _tmp956_)) {
													ValaSourceReference* _tmp957_;
													ValaSourceReference* _tmp958_;
													ValaExpression* _tmp959_;
													ValaExpression* _tmp960_;
													ValaDataType* _tmp961_;
													ValaDataType* _tmp962_;
													gchar* _tmp963_;
													gchar* _tmp964_;
													ValaExpression* _tmp965_;
													ValaExpression* _tmp966_;
													ValaDataType* _tmp967_;
													ValaDataType* _tmp968_;
													gchar* _tmp969_;
													gchar* _tmp970_;
													gchar* _tmp971_;
													gchar* _tmp972_;
													_tmp957_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
													_tmp958_ = _tmp957_;
													_tmp959_ = vala_binary_expression_get_left (self);
													_tmp960_ = _tmp959_;
													_tmp961_ = vala_expression_get_value_type (_tmp960_);
													_tmp962_ = _tmp961_;
													_tmp963_ = vala_code_node_to_string ((ValaCodeNode*) _tmp962_);
													_tmp964_ = _tmp963_;
													_tmp965_ = vala_binary_expression_get_right (self);
													_tmp966_ = _tmp965_;
													_tmp967_ = vala_expression_get_value_type (_tmp966_);
													_tmp968_ = _tmp967_;
													_tmp969_ = vala_code_node_to_string ((ValaCodeNode*) _tmp968_);
													_tmp970_ = _tmp969_;
													_tmp971_ = g_strdup_printf ("Cannot look for `%s' in `%s'", _tmp964_, _tmp970_);
													_tmp972_ = _tmp971_;
													vala_report_error (_tmp958_, _tmp972_);
													_g_free0 (_tmp972_);
													_g_free0 (_tmp970_);
													_g_free0 (_tmp964_);
												}
											} else {
												ValaMethod* contains_method = NULL;
												ValaExpression* _tmp973_;
												ValaExpression* _tmp974_;
												ValaDataType* _tmp975_;
												ValaDataType* _tmp976_;
												ValaSymbol* _tmp977_;
												ValaMethod* _tmp978_;
												ValaMethod* _tmp979_;
												ValaMethod* _tmp990_;
												ValaList* _tmp991_;
												ValaList* _tmp992_;
												gint _tmp993_;
												gint _tmp994_;
												gboolean _tmp995_;
												ValaMethod* _tmp1003_;
												ValaDataType* _tmp1004_;
												ValaDataType* _tmp1005_;
												ValaSemanticAnalyzer* _tmp1006_;
												ValaSemanticAnalyzer* _tmp1007_;
												ValaDataType* _tmp1008_;
												ValaMethodCall* contains_call = NULL;
												ValaExpression* _tmp1016_;
												ValaExpression* _tmp1017_;
												ValaSourceReference* _tmp1018_;
												ValaSourceReference* _tmp1019_;
												ValaMemberAccess* _tmp1020_;
												ValaMemberAccess* _tmp1021_;
												ValaSourceReference* _tmp1022_;
												ValaSourceReference* _tmp1023_;
												ValaMethodCall* _tmp1024_;
												ValaMethodCall* _tmp1025_;
												ValaMethodCall* _tmp1026_;
												ValaExpression* _tmp1027_;
												ValaExpression* _tmp1028_;
												ValaCodeNode* _tmp1029_;
												ValaCodeNode* _tmp1030_;
												ValaMethodCall* _tmp1031_;
												ValaMethodCall* _tmp1032_;
												_tmp973_ = vala_binary_expression_get_right (self);
												_tmp974_ = _tmp973_;
												_tmp975_ = vala_expression_get_value_type (_tmp974_);
												_tmp976_ = _tmp975_;
												_tmp977_ = vala_data_type_get_member (_tmp976_, "contains");
												_tmp978_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp977_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp977_) : NULL;
												if (_tmp978_ == NULL) {
													_vala_code_node_unref0 (_tmp977_);
												}
												contains_method = _tmp978_;
												_tmp979_ = contains_method;
												if (_tmp979_ == NULL) {
													ValaSourceReference* _tmp980_;
													ValaSourceReference* _tmp981_;
													ValaExpression* _tmp982_;
													ValaExpression* _tmp983_;
													ValaDataType* _tmp984_;
													ValaDataType* _tmp985_;
													gchar* _tmp986_;
													gchar* _tmp987_;
													gchar* _tmp988_;
													gchar* _tmp989_;
													_tmp980_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
													_tmp981_ = _tmp980_;
													_tmp982_ = vala_binary_expression_get_right (self);
													_tmp983_ = _tmp982_;
													_tmp984_ = vala_expression_get_value_type (_tmp983_);
													_tmp985_ = _tmp984_;
													_tmp986_ = vala_code_node_to_string ((ValaCodeNode*) _tmp985_);
													_tmp987_ = _tmp986_;
													_tmp988_ = g_strdup_printf ("`%s' does not have a `contains' method", _tmp987_);
													_tmp989_ = _tmp988_;
													vala_report_error (_tmp981_, _tmp989_);
													_g_free0 (_tmp989_);
													_g_free0 (_tmp987_);
													vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
													result = FALSE;
													_vala_code_node_unref0 (contains_method);
													return result;
												}
												_tmp990_ = contains_method;
												_tmp991_ = vala_callable_get_parameters ((ValaCallable*) _tmp990_);
												_tmp992_ = _tmp991_;
												_tmp993_ = vala_collection_get_size ((ValaCollection*) _tmp992_);
												_tmp994_ = _tmp993_;
												_tmp995_ = _tmp994_ != 1;
												_vala_iterable_unref0 (_tmp992_);
												if (_tmp995_) {
													ValaSourceReference* _tmp996_;
													ValaSourceReference* _tmp997_;
													ValaMethod* _tmp998_;
													gchar* _tmp999_;
													gchar* _tmp1000_;
													gchar* _tmp1001_;
													gchar* _tmp1002_;
													_tmp996_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
													_tmp997_ = _tmp996_;
													_tmp998_ = contains_method;
													_tmp999_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp998_);
													_tmp1000_ = _tmp999_;
													_tmp1001_ = g_strdup_printf ("`%s' must have one parameter", _tmp1000_);
													_tmp1002_ = _tmp1001_;
													vala_report_error (_tmp997_, _tmp1002_);
													_g_free0 (_tmp1002_);
													_g_free0 (_tmp1000_);
													vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
													result = FALSE;
													_vala_code_node_unref0 (contains_method);
													return result;
												}
												_tmp1003_ = contains_method;
												_tmp1004_ = vala_callable_get_return_type ((ValaCallable*) _tmp1003_);
												_tmp1005_ = _tmp1004_;
												_tmp1006_ = vala_code_context_get_analyzer (context);
												_tmp1007_ = _tmp1006_;
												_tmp1008_ = _tmp1007_->bool_type;
												if (!vala_data_type_compatible (_tmp1005_, _tmp1008_)) {
													ValaSourceReference* _tmp1009_;
													ValaSourceReference* _tmp1010_;
													ValaMethod* _tmp1011_;
													gchar* _tmp1012_;
													gchar* _tmp1013_;
													gchar* _tmp1014_;
													gchar* _tmp1015_;
													_tmp1009_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
													_tmp1010_ = _tmp1009_;
													_tmp1011_ = contains_method;
													_tmp1012_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1011_);
													_tmp1013_ = _tmp1012_;
													_tmp1014_ = g_strdup_printf ("`%s' must return a boolean value", _tmp1013_);
													_tmp1015_ = _tmp1014_;
													vala_report_error (_tmp1010_, _tmp1015_);
													_g_free0 (_tmp1015_);
													_g_free0 (_tmp1013_);
													vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
													result = FALSE;
													_vala_code_node_unref0 (contains_method);
													return result;
												}
												_tmp1016_ = vala_binary_expression_get_right (self);
												_tmp1017_ = _tmp1016_;
												_tmp1018_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp1019_ = _tmp1018_;
												_tmp1020_ = vala_member_access_new (_tmp1017_, "contains", _tmp1019_);
												_tmp1021_ = _tmp1020_;
												_tmp1022_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp1023_ = _tmp1022_;
												_tmp1024_ = vala_method_call_new ((ValaExpression*) _tmp1021_, _tmp1023_);
												_tmp1025_ = _tmp1024_;
												_vala_code_node_unref0 (_tmp1021_);
												contains_call = _tmp1025_;
												_tmp1026_ = contains_call;
												_tmp1027_ = vala_binary_expression_get_left (self);
												_tmp1028_ = _tmp1027_;
												vala_method_call_add_argument (_tmp1026_, _tmp1028_);
												_tmp1029_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
												_tmp1030_ = _tmp1029_;
												_tmp1031_ = contains_call;
												vala_code_node_replace_expression (_tmp1030_, (ValaExpression*) self, (ValaExpression*) _tmp1031_);
												_tmp1032_ = contains_call;
												result = vala_code_node_check ((ValaCodeNode*) _tmp1032_, context);
												_vala_code_node_unref0 (contains_call);
												_vala_code_node_unref0 (contains_method);
												return result;
											}
										}
										_tmp1033_ = vala_code_context_get_analyzer (context);
										_tmp1034_ = _tmp1033_;
										_tmp1035_ = _tmp1034_->bool_type;
										vala_expression_set_value_type ((ValaExpression*) self, _tmp1035_);
									} else {
										g_assert_not_reached ();
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp1036_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1037_ = _tmp1036_;
	result = !_tmp1037_;
	return result;
}


static void
vala_binary_expression_real_emit (ValaCodeNode* base,
                                  ValaCodeGenerator* codegen)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_emit ((ValaCodeNode*) _tmp1_, codegen);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	vala_code_visitor_visit_binary_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}


static void
vala_binary_expression_real_get_defined_variables (ValaCodeNode* base,
                                                   ValaCollection* collection)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
}


static void
vala_binary_expression_real_get_used_variables (ValaCodeNode* base,
                                                ValaCollection* collection)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
}


ValaBinaryOperator
vala_binary_expression_get_operator (ValaBinaryExpression* self)
{
	ValaBinaryOperator result;
	ValaBinaryOperator _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_operator;
	result = _tmp0_;
	return result;
}


void
vala_binary_expression_set_operator (ValaBinaryExpression* self,
                                     ValaBinaryOperator value)
{
	g_return_if_fail (self != NULL);
	self->priv->_operator = value;
}


ValaExpression*
vala_binary_expression_get_left (ValaBinaryExpression* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_left;
	result = _tmp0_;
	return result;
}


void
vala_binary_expression_set_left (ValaBinaryExpression* self,
                                 ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_left);
	self->priv->_left = _tmp0_;
	_tmp1_ = self->priv->_left;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


ValaExpression*
vala_binary_expression_get_right (ValaBinaryExpression* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_right;
	result = _tmp0_;
	return result;
}


void
vala_binary_expression_set_right (ValaBinaryExpression* self,
                                  ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_right);
	self->priv->_right = _tmp0_;
	_tmp1_ = self->priv->_right;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


gboolean
vala_binary_expression_get_is_chained (ValaBinaryExpression* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_chained;
	result = _tmp0_;
	return result;
}


static void
vala_binary_expression_set_is_chained (ValaBinaryExpression* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_chained = value;
}


static void
vala_binary_expression_class_init (ValaBinaryExpressionClass * klass)
{
	vala_binary_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_binary_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaBinaryExpressionPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_binary_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_binary_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_binary_expression_real_replace_expression;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_binary_expression_real_to_string;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_binary_expression_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_binary_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_binary_expression_real_is_non_null;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_binary_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_binary_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_binary_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_binary_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_binary_expression_real_get_used_variables;
}


static void
vala_binary_expression_instance_init (ValaBinaryExpression * self)
{
	self->priv = VALA_BINARY_EXPRESSION_GET_PRIVATE (self);
}


static void
vala_binary_expression_finalize (ValaCodeNode * obj)
{
	ValaBinaryExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpression);
	_vala_code_node_unref0 (self->priv->_left);
	_vala_code_node_unref0 (self->priv->_right);
	VALA_CODE_NODE_CLASS (vala_binary_expression_parent_class)->finalize (obj);
}


/**
 * Represents an expression with two operands in the source code.
 *
 * Supports +, -, *, /, %, <<, >>, <, >, <=, >=, ==, !=, &, |, ^, &&, ||, ??.
 */
GType
vala_binary_expression_get_type (void)
{
	static volatile gsize vala_binary_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_binary_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaBinaryExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_binary_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaBinaryExpression), 0, (GInstanceInitFunc) vala_binary_expression_instance_init, NULL };
		GType vala_binary_expression_type_id;
		vala_binary_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaBinaryExpression", &g_define_type_info, 0);
		g_once_init_leave (&vala_binary_expression_type_id__volatile, vala_binary_expression_type_id);
	}
	return vala_binary_expression_type_id__volatile;
}


GType
vala_binary_operator_get_type (void)
{
	static volatile gsize vala_binary_operator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_binary_operator_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_BINARY_OPERATOR_NONE, "VALA_BINARY_OPERATOR_NONE", "none"}, {VALA_BINARY_OPERATOR_PLUS, "VALA_BINARY_OPERATOR_PLUS", "plus"}, {VALA_BINARY_OPERATOR_MINUS, "VALA_BINARY_OPERATOR_MINUS", "minus"}, {VALA_BINARY_OPERATOR_MUL, "VALA_BINARY_OPERATOR_MUL", "mul"}, {VALA_BINARY_OPERATOR_DIV, "VALA_BINARY_OPERATOR_DIV", "div"}, {VALA_BINARY_OPERATOR_MOD, "VALA_BINARY_OPERATOR_MOD", "mod"}, {VALA_BINARY_OPERATOR_SHIFT_LEFT, "VALA_BINARY_OPERATOR_SHIFT_LEFT", "shift-left"}, {VALA_BINARY_OPERATOR_SHIFT_RIGHT, "VALA_BINARY_OPERATOR_SHIFT_RIGHT", "shift-right"}, {VALA_BINARY_OPERATOR_LESS_THAN, "VALA_BINARY_OPERATOR_LESS_THAN", "less-than"}, {VALA_BINARY_OPERATOR_GREATER_THAN, "VALA_BINARY_OPERATOR_GREATER_THAN", "greater-than"}, {VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL, "VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL", "less-than-or-equal"}, {VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL, "VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL", "greater-than-or-equal"}, {VALA_BINARY_OPERATOR_EQUALITY, "VALA_BINARY_OPERATOR_EQUALITY", "equality"}, {VALA_BINARY_OPERATOR_INEQUALITY, "VALA_BINARY_OPERATOR_INEQUALITY", "inequality"}, {VALA_BINARY_OPERATOR_BITWISE_AND, "VALA_BINARY_OPERATOR_BITWISE_AND", "bitwise-and"}, {VALA_BINARY_OPERATOR_BITWISE_OR, "VALA_BINARY_OPERATOR_BITWISE_OR", "bitwise-or"}, {VALA_BINARY_OPERATOR_BITWISE_XOR, "VALA_BINARY_OPERATOR_BITWISE_XOR", "bitwise-xor"}, {VALA_BINARY_OPERATOR_AND, "VALA_BINARY_OPERATOR_AND", "and"}, {VALA_BINARY_OPERATOR_OR, "VALA_BINARY_OPERATOR_OR", "or"}, {VALA_BINARY_OPERATOR_IN, "VALA_BINARY_OPERATOR_IN", "in"}, {VALA_BINARY_OPERATOR_COALESCE, "VALA_BINARY_OPERATOR_COALESCE", "coalesce"}, {0, NULL, NULL}};
		GType vala_binary_operator_type_id;
		vala_binary_operator_type_id = g_enum_register_static ("ValaBinaryOperator", values);
		g_once_init_leave (&vala_binary_operator_type_id__volatile, vala_binary_operator_type_id);
	}
	return vala_binary_operator_type_id__volatile;
}



