/* valadostatement.c generated by valac, the Vala compiler
 * generated from valadostatement.vala, do not modify */

/* valadostatement.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaDoStatementPrivate {
	ValaExpression* _condition;
	ValaBlock* _body;
};


static gpointer vala_do_statement_parent_class = NULL;
static ValaStatementIface * vala_do_statement_vala_statement_parent_iface = NULL;

#define VALA_DO_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_DO_STATEMENT, ValaDoStatementPrivate))
static void vala_do_statement_real_accept (ValaCodeNode* base,
                                    ValaCodeVisitor* visitor);
static void vala_do_statement_real_accept_children (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor);
static gboolean vala_do_statement_always_true (ValaDoStatement* self,
                                        ValaExpression* condition);
static void vala_do_statement_real_replace_expression (ValaCodeNode* base,
                                                ValaExpression* old_node,
                                                ValaExpression* new_node);
static gboolean vala_do_statement_real_check (ValaCodeNode* base,
                                       ValaCodeContext* context);
static void vala_do_statement_finalize (ValaCodeNode * obj);


/**
 * Creates a new do statement.
 *
 * @param body              loop body
 * @param condition         loop condition
 * @param source_reference  reference to source code
 * @return                  newly created do statement
 */
ValaDoStatement*
vala_do_statement_construct (GType object_type,
                             ValaBlock* body,
                             ValaExpression* condition,
                             ValaSourceReference* source_reference)
{
	ValaDoStatement* self = NULL;
	g_return_val_if_fail (body != NULL, NULL);
	g_return_val_if_fail (condition != NULL, NULL);
	self = (ValaDoStatement*) vala_code_node_construct (object_type);
	vala_do_statement_set_condition (self, condition);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_do_statement_set_body (self, body);
	return self;
}


ValaDoStatement*
vala_do_statement_new (ValaBlock* body,
                       ValaExpression* condition,
                       ValaSourceReference* source_reference)
{
	return vala_do_statement_construct (VALA_TYPE_DO_STATEMENT, body, condition, source_reference);
}


static void
vala_do_statement_real_accept (ValaCodeNode* base,
                               ValaCodeVisitor* visitor)
{
	ValaDoStatement * self;
	self = (ValaDoStatement*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_do_statement (visitor, self);
}


static void
vala_do_statement_real_accept_children (ValaCodeNode* base,
                                        ValaCodeVisitor* visitor)
{
	ValaDoStatement * self;
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	self = (ValaDoStatement*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_do_statement_get_body (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_do_statement_get_condition (self);
	_tmp3_ = _tmp2_;
	vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	_tmp4_ = vala_do_statement_get_condition (self);
	_tmp5_ = _tmp4_;
	vala_code_visitor_visit_end_full_expression (visitor, _tmp5_);
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_do_statement_always_true (ValaDoStatement* self,
                               ValaExpression* condition)
{
	gboolean result = FALSE;
	ValaBooleanLiteral* literal = NULL;
	ValaBooleanLiteral* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaBooleanLiteral* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (condition != NULL, FALSE);
	_tmp0_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (condition, VALA_TYPE_BOOLEAN_LITERAL) ? ((ValaBooleanLiteral*) condition) : NULL);
	literal = _tmp0_;
	_tmp2_ = literal;
	if (_tmp2_ != NULL) {
		ValaBooleanLiteral* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = literal;
		_tmp4_ = vala_boolean_literal_get_value (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	_vala_code_node_unref0 (literal);
	return result;
}


static void
vala_do_statement_real_replace_expression (ValaCodeNode* base,
                                           ValaExpression* old_node,
                                           ValaExpression* new_node)
{
	ValaDoStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaDoStatement*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_do_statement_get_condition (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_do_statement_set_condition (self, new_node);
	}
}


static gboolean
vala_do_statement_real_check (ValaCodeNode* base,
                              ValaCodeContext* context)
{
	ValaDoStatement * self;
	gboolean result = FALSE;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaBlock* block = NULL;
	ValaSourceReference* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaBlock* _tmp15_;
	ValaLocalVariable* first_local = NULL;
	ValaSemanticAnalyzer* _tmp16_;
	ValaSemanticAnalyzer* _tmp17_;
	ValaDataType* _tmp18_;
	ValaDataType* _tmp19_;
	ValaDataType* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	ValaSourceReference* _tmp23_;
	ValaSourceReference* _tmp24_;
	ValaBooleanLiteral* _tmp25_;
	ValaBooleanLiteral* _tmp26_;
	ValaSourceReference* _tmp27_;
	ValaSourceReference* _tmp28_;
	ValaLocalVariable* _tmp29_;
	ValaLocalVariable* _tmp30_;
	ValaBlock* _tmp31_;
	ValaLocalVariable* _tmp32_;
	ValaSourceReference* _tmp33_;
	ValaSourceReference* _tmp34_;
	ValaDeclarationStatement* _tmp35_;
	ValaDeclarationStatement* _tmp36_;
	ValaUnaryExpression* if_condition = NULL;
	ValaExpression* _tmp37_;
	ValaExpression* _tmp38_;
	ValaExpression* _tmp39_;
	ValaExpression* _tmp40_;
	ValaSourceReference* _tmp41_;
	ValaSourceReference* _tmp42_;
	ValaUnaryExpression* _tmp43_;
	ValaBlock* true_block = NULL;
	ValaExpression* _tmp44_;
	ValaExpression* _tmp45_;
	ValaSourceReference* _tmp46_;
	ValaSourceReference* _tmp47_;
	ValaBlock* _tmp48_;
	ValaBlock* _tmp49_;
	ValaExpression* _tmp50_;
	ValaExpression* _tmp51_;
	ValaSourceReference* _tmp52_;
	ValaSourceReference* _tmp53_;
	ValaBreakStatement* _tmp54_;
	ValaBreakStatement* _tmp55_;
	ValaIfStatement* if_stmt = NULL;
	ValaUnaryExpression* _tmp56_;
	ValaBlock* _tmp57_;
	ValaExpression* _tmp58_;
	ValaExpression* _tmp59_;
	ValaSourceReference* _tmp60_;
	ValaSourceReference* _tmp61_;
	ValaIfStatement* _tmp62_;
	ValaBlock* condition_block = NULL;
	ValaExpression* _tmp63_;
	ValaExpression* _tmp64_;
	ValaSourceReference* _tmp65_;
	ValaSourceReference* _tmp66_;
	ValaBlock* _tmp67_;
	ValaBlock* _tmp68_;
	ValaIfStatement* _tmp69_;
	ValaIfStatement* first_if = NULL;
	ValaLocalVariable* _tmp70_;
	const gchar* _tmp71_;
	const gchar* _tmp72_;
	ValaSourceReference* _tmp73_;
	ValaSourceReference* _tmp74_;
	ValaMemberAccess* _tmp75_;
	ValaMemberAccess* _tmp76_;
	ValaSourceReference* _tmp77_;
	ValaSourceReference* _tmp78_;
	ValaUnaryExpression* _tmp79_;
	ValaUnaryExpression* _tmp80_;
	ValaBlock* _tmp81_;
	ValaSourceReference* _tmp82_;
	ValaSourceReference* _tmp83_;
	ValaIfStatement* _tmp84_;
	ValaIfStatement* _tmp85_;
	ValaBlock* _tmp86_;
	ValaBlock* _tmp87_;
	ValaIfStatement* _tmp88_;
	ValaBlock* _tmp89_;
	ValaBlock* _tmp90_;
	ValaLocalVariable* _tmp91_;
	const gchar* _tmp92_;
	const gchar* _tmp93_;
	ValaSourceReference* _tmp94_;
	ValaSourceReference* _tmp95_;
	ValaMemberAccess* _tmp96_;
	ValaMemberAccess* _tmp97_;
	ValaSourceReference* _tmp98_;
	ValaSourceReference* _tmp99_;
	ValaBooleanLiteral* _tmp100_;
	ValaBooleanLiteral* _tmp101_;
	ValaSourceReference* _tmp102_;
	ValaSourceReference* _tmp103_;
	ValaAssignment* _tmp104_;
	ValaAssignment* _tmp105_;
	ValaSourceReference* _tmp106_;
	ValaSourceReference* _tmp107_;
	ValaExpressionStatement* _tmp108_;
	ValaExpressionStatement* _tmp109_;
	ValaBlock* _tmp110_;
	ValaBlock* _tmp111_;
	ValaBlock* _tmp112_;
	ValaSourceReference* _tmp113_;
	ValaSourceReference* _tmp114_;
	ValaLoop* _tmp115_;
	ValaLoop* _tmp116_;
	ValaBlock* parent_block = NULL;
	ValaCodeNode* _tmp117_;
	ValaCodeNode* _tmp118_;
	ValaBlock* _tmp119_;
	ValaBlock* _tmp120_;
	ValaBlock* _tmp121_;
	ValaBlock* _tmp122_;
	self = (ValaDoStatement*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_do_statement_get_condition (self);
	_tmp1_ = _tmp0_;
	if (vala_do_statement_always_true (self, _tmp1_)) {
		ValaLoop* loop = NULL;
		ValaBlock* _tmp2_;
		ValaBlock* _tmp3_;
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaLoop* _tmp6_;
		ValaBlock* parent_block = NULL;
		ValaCodeNode* _tmp7_;
		ValaCodeNode* _tmp8_;
		ValaBlock* _tmp9_;
		ValaBlock* _tmp10_;
		ValaLoop* _tmp11_;
		ValaLoop* _tmp12_;
		_tmp2_ = vala_do_statement_get_body (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_loop_new (_tmp3_, _tmp5_);
		loop = _tmp6_;
		_tmp7_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_BLOCK, ValaBlock));
		parent_block = _tmp9_;
		_tmp10_ = parent_block;
		_tmp11_ = loop;
		vala_block_replace_statement (_tmp10_, (ValaStatement*) self, (ValaStatement*) _tmp11_);
		_tmp12_ = loop;
		result = vala_code_node_check ((ValaCodeNode*) _tmp12_, context);
		_vala_code_node_unref0 (parent_block);
		_vala_code_node_unref0 (loop);
		return result;
	}
	_tmp13_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_block_new (_tmp14_);
	block = _tmp15_;
	_tmp16_ = vala_code_context_get_analyzer (context);
	_tmp17_ = _tmp16_;
	_tmp18_ = _tmp17_->bool_type;
	_tmp19_ = vala_data_type_copy (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = vala_code_node_get_temp_name ();
	_tmp22_ = _tmp21_;
	_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp24_ = _tmp23_;
	_tmp25_ = vala_boolean_literal_new (TRUE, _tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp28_ = _tmp27_;
	_tmp29_ = vala_local_variable_new (_tmp20_, _tmp22_, (ValaExpression*) _tmp26_, _tmp28_);
	_tmp30_ = _tmp29_;
	_vala_code_node_unref0 (_tmp26_);
	_g_free0 (_tmp22_);
	_vala_code_node_unref0 (_tmp20_);
	first_local = _tmp30_;
	_tmp31_ = block;
	_tmp32_ = first_local;
	_tmp33_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp34_ = _tmp33_;
	_tmp35_ = vala_declaration_statement_new ((ValaSymbol*) _tmp32_, _tmp34_);
	_tmp36_ = _tmp35_;
	vala_block_add_statement (_tmp31_, (ValaStatement*) _tmp36_);
	_vala_code_node_unref0 (_tmp36_);
	_tmp37_ = vala_do_statement_get_condition (self);
	_tmp38_ = _tmp37_;
	_tmp39_ = vala_do_statement_get_condition (self);
	_tmp40_ = _tmp39_;
	_tmp41_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp40_);
	_tmp42_ = _tmp41_;
	_tmp43_ = vala_unary_expression_new (VALA_UNARY_OPERATOR_LOGICAL_NEGATION, _tmp38_, _tmp42_);
	if_condition = _tmp43_;
	_tmp44_ = vala_do_statement_get_condition (self);
	_tmp45_ = _tmp44_;
	_tmp46_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = vala_block_new (_tmp47_);
	true_block = _tmp48_;
	_tmp49_ = true_block;
	_tmp50_ = vala_do_statement_get_condition (self);
	_tmp51_ = _tmp50_;
	_tmp52_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp51_);
	_tmp53_ = _tmp52_;
	_tmp54_ = vala_break_statement_new (_tmp53_);
	_tmp55_ = _tmp54_;
	vala_block_add_statement (_tmp49_, (ValaStatement*) _tmp55_);
	_vala_code_node_unref0 (_tmp55_);
	_tmp56_ = if_condition;
	_tmp57_ = true_block;
	_tmp58_ = vala_do_statement_get_condition (self);
	_tmp59_ = _tmp58_;
	_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp59_);
	_tmp61_ = _tmp60_;
	_tmp62_ = vala_if_statement_new ((ValaExpression*) _tmp56_, _tmp57_, NULL, _tmp61_);
	if_stmt = _tmp62_;
	_tmp63_ = vala_do_statement_get_condition (self);
	_tmp64_ = _tmp63_;
	_tmp65_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp64_);
	_tmp66_ = _tmp65_;
	_tmp67_ = vala_block_new (_tmp66_);
	condition_block = _tmp67_;
	_tmp68_ = condition_block;
	_tmp69_ = if_stmt;
	vala_block_add_statement (_tmp68_, (ValaStatement*) _tmp69_);
	_tmp70_ = first_local;
	_tmp71_ = vala_symbol_get_name ((ValaSymbol*) _tmp70_);
	_tmp72_ = _tmp71_;
	_tmp73_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp74_ = _tmp73_;
	_tmp75_ = vala_member_access_new_simple (_tmp72_, _tmp74_);
	_tmp76_ = _tmp75_;
	_tmp77_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp78_ = _tmp77_;
	_tmp79_ = vala_unary_expression_new (VALA_UNARY_OPERATOR_LOGICAL_NEGATION, (ValaExpression*) _tmp76_, _tmp78_);
	_tmp80_ = _tmp79_;
	_tmp81_ = condition_block;
	_tmp82_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp83_ = _tmp82_;
	_tmp84_ = vala_if_statement_new ((ValaExpression*) _tmp80_, _tmp81_, NULL, _tmp83_);
	_tmp85_ = _tmp84_;
	_vala_code_node_unref0 (_tmp80_);
	_vala_code_node_unref0 (_tmp76_);
	first_if = _tmp85_;
	_tmp86_ = vala_do_statement_get_body (self);
	_tmp87_ = _tmp86_;
	_tmp88_ = first_if;
	vala_block_insert_statement (_tmp87_, 0, (ValaStatement*) _tmp88_);
	_tmp89_ = vala_do_statement_get_body (self);
	_tmp90_ = _tmp89_;
	_tmp91_ = first_local;
	_tmp92_ = vala_symbol_get_name ((ValaSymbol*) _tmp91_);
	_tmp93_ = _tmp92_;
	_tmp94_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp95_ = _tmp94_;
	_tmp96_ = vala_member_access_new_simple (_tmp93_, _tmp95_);
	_tmp97_ = _tmp96_;
	_tmp98_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp99_ = _tmp98_;
	_tmp100_ = vala_boolean_literal_new (FALSE, _tmp99_);
	_tmp101_ = _tmp100_;
	_tmp102_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp103_ = _tmp102_;
	_tmp104_ = vala_assignment_new ((ValaExpression*) _tmp97_, (ValaExpression*) _tmp101_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp103_);
	_tmp105_ = _tmp104_;
	_tmp106_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp107_ = _tmp106_;
	_tmp108_ = vala_expression_statement_new ((ValaExpression*) _tmp105_, _tmp107_);
	_tmp109_ = _tmp108_;
	vala_block_insert_statement (_tmp90_, 1, (ValaStatement*) _tmp109_);
	_vala_code_node_unref0 (_tmp109_);
	_vala_code_node_unref0 (_tmp105_);
	_vala_code_node_unref0 (_tmp101_);
	_vala_code_node_unref0 (_tmp97_);
	_tmp110_ = block;
	_tmp111_ = vala_do_statement_get_body (self);
	_tmp112_ = _tmp111_;
	_tmp113_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp114_ = _tmp113_;
	_tmp115_ = vala_loop_new (_tmp112_, _tmp114_);
	_tmp116_ = _tmp115_;
	vala_block_add_statement (_tmp110_, (ValaStatement*) _tmp116_);
	_vala_code_node_unref0 (_tmp116_);
	_tmp117_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp118_ = _tmp117_;
	_tmp119_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp118_, VALA_TYPE_BLOCK, ValaBlock));
	parent_block = _tmp119_;
	_tmp120_ = parent_block;
	_tmp121_ = block;
	vala_block_replace_statement (_tmp120_, (ValaStatement*) self, (ValaStatement*) _tmp121_);
	_tmp122_ = block;
	result = vala_code_node_check ((ValaCodeNode*) _tmp122_, context);
	_vala_code_node_unref0 (parent_block);
	_vala_code_node_unref0 (first_if);
	_vala_code_node_unref0 (condition_block);
	_vala_code_node_unref0 (if_stmt);
	_vala_code_node_unref0 (true_block);
	_vala_code_node_unref0 (if_condition);
	_vala_code_node_unref0 (first_local);
	_vala_code_node_unref0 (block);
	return result;
}


ValaBlock*
vala_do_statement_get_body (ValaDoStatement* self)
{
	ValaBlock* result;
	ValaBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_body;
	result = _tmp0_;
	return result;
}


void
vala_do_statement_set_body (ValaDoStatement* self,
                            ValaBlock* value)
{
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_body);
	self->priv->_body = _tmp0_;
	_tmp1_ = self->priv->_body;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


ValaExpression*
vala_do_statement_get_condition (ValaDoStatement* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_condition;
	result = _tmp0_;
	return result;
}


void
vala_do_statement_set_condition (ValaDoStatement* self,
                                 ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_condition);
	self->priv->_condition = _tmp0_;
	_tmp1_ = self->priv->_condition;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


static void
vala_do_statement_class_init (ValaDoStatementClass * klass)
{
	vala_do_statement_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_do_statement_finalize;
	g_type_class_add_private (klass, sizeof (ValaDoStatementPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_do_statement_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_do_statement_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_do_statement_real_replace_expression;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_do_statement_real_check;
}


static void
vala_do_statement_vala_statement_interface_init (ValaStatementIface * iface)
{
	vala_do_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void
vala_do_statement_instance_init (ValaDoStatement * self)
{
	self->priv = VALA_DO_STATEMENT_GET_PRIVATE (self);
}


static void
vala_do_statement_finalize (ValaCodeNode * obj)
{
	ValaDoStatement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_DO_STATEMENT, ValaDoStatement);
	_vala_code_node_unref0 (self->priv->_condition);
	_vala_code_node_unref0 (self->priv->_body);
	VALA_CODE_NODE_CLASS (vala_do_statement_parent_class)->finalize (obj);
}


/**
 * Represents a do iteration statement in the source code.
 */
GType
vala_do_statement_get_type (void)
{
	static volatile gsize vala_do_statement_type_id__volatile = 0;
	if (g_once_init_enter (&vala_do_statement_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDoStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_do_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDoStatement), 0, (GInstanceInitFunc) vala_do_statement_instance_init, NULL };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_do_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_do_statement_type_id;
		vala_do_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaDoStatement", &g_define_type_info, 0);
		g_type_add_interface_static (vala_do_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
		g_once_init_leave (&vala_do_statement_type_id__volatile, vala_do_statement_type_id);
	}
	return vala_do_statement_type_id__volatile;
}



