/* valaclass.c generated by valac, the Vala compiler
 * generated from valaclass.vala, do not modify */

/* valaclass.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaClassPrivate {
	ValaClass* _base_class;
	gboolean _is_abstract;
	gboolean _has_private_fields;
	gboolean _has_class_private_fields;
	gboolean* _is_compact;
	gboolean* _is_immutable;
	ValaList* base_types;
	ValaCreationMethod* _default_construction_method;
	ValaConstructor* _constructor;
	ValaConstructor* _class_constructor;
	ValaConstructor* _static_constructor;
	ValaDestructor* _destructor;
	ValaDestructor* _class_destructor;
	ValaDestructor* _static_destructor;
};


static gpointer vala_class_parent_class = NULL;

#define VALA_CLASS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CLASS, ValaClassPrivate))
static void vala_class_real_add_field (ValaSymbol* base,
                                ValaField* f);
static void vala_class_set_has_class_private_fields (ValaClass* self,
                                              gboolean value);
static void vala_class_real_add_method (ValaSymbol* base,
                                 ValaMethod* m);
static void vala_class_real_add_property (ValaSymbol* base,
                                   ValaProperty* prop);
static void vala_class_real_add_constructor (ValaSymbol* base,
                                      ValaConstructor* c);
static void vala_class_real_add_destructor (ValaSymbol* base,
                                     ValaDestructor* d);
static void vala_class_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor);
static void vala_class_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static gboolean vala_class_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                                        ValaTypeSymbol* t);
static void vala_class_real_replace_type (ValaCodeNode* base,
                                   ValaDataType* old_type,
                                   ValaDataType* new_type);
static void vala_class_get_all_prerequisites (ValaClass* self,
                                       ValaInterface* iface,
                                       ValaList* list);
static gboolean vala_class_class_is_a (ValaClass* self,
                                ValaClass* cl,
                                ValaTypeSymbol* t);
static gboolean vala_class_real_check (ValaCodeNode* base,
                                ValaCodeContext* context);
static gboolean* _bool_dup (gboolean* self);
static void vala_class_finalize (ValaCodeNode * obj);


/**
 * Creates a new class.
 *
 * @param name             type name
 * @param source_reference reference to source code
 * @param comment          class documentation
 * @return                 newly created class
 */
ValaClass*
vala_class_construct (GType object_type,
                      const gchar* name,
                      ValaSourceReference* source_reference,
                      ValaComment* comment)
{
	ValaClass* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaClass*) vala_object_type_symbol_construct (object_type, name, source_reference, comment);
	return self;
}


ValaClass*
vala_class_new (const gchar* name,
                ValaSourceReference* source_reference,
                ValaComment* comment)
{
	return vala_class_construct (VALA_TYPE_CLASS, name, source_reference, comment);
}


/**
 * Adds the specified class or interface to the list of base types of
 * this class.
 *
 * @param type a class or interface reference
 */
void
vala_class_add_base_type (ValaClass* self,
                          ValaDataType* type)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->base_types;
	vala_collection_add ((ValaCollection*) _tmp0_, type);
	vala_code_node_set_parent_node ((ValaCodeNode*) type, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the base type list.
 *
 * @return list of base types
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_class_get_base_types (ValaClass* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->base_types;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified field as a member to this class.
 *
 * @param f a field
 */
static void
vala_class_real_add_field (ValaSymbol* base,
                           ValaField* f)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbolAccessibility _tmp1_;
	ValaSymbolAccessibility _tmp2_;
	self = (ValaClass*) base;
	g_return_if_fail (f != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_field ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), f);
	_tmp1_ = vala_symbol_get_access ((ValaSymbol*) f);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaMemberBinding _tmp3_;
		ValaMemberBinding _tmp4_;
		_tmp3_ = vala_field_get_binding (f);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		vala_class_set_has_private_fields (self, TRUE);
	} else {
		gboolean _tmp5_ = FALSE;
		ValaSymbolAccessibility _tmp6_;
		ValaSymbolAccessibility _tmp7_;
		_tmp6_ = vala_symbol_get_access ((ValaSymbol*) f);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaMemberBinding _tmp8_;
			ValaMemberBinding _tmp9_;
			_tmp8_ = vala_field_get_binding (f);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ == VALA_MEMBER_BINDING_CLASS;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			vala_class_set_has_class_private_fields (self, TRUE);
		}
	}
}


/**
 * Adds the specified method as a member to this class.
 *
 * @param m a method
 */
static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static void
vala_class_real_add_method (ValaSymbol* base,
                            ValaMethod* m)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp2_;
	gboolean _tmp23_ = FALSE;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	ValaDataType* _tmp69_;
	ValaDataType* _tmp70_;
	self = (ValaClass*) base;
	g_return_if_fail (m != NULL);
	_tmp1_ = vala_method_get_binding (m);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_MEMBER_BINDING_INSTANCE) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (m, VALA_TYPE_CREATION_METHOD);
	}
	if (_tmp0_) {
		ValaParameter* _tmp3_;
		ValaParameter* _tmp4_;
		ValaObjectType* _tmp11_;
		ValaObjectType* _tmp12_;
		ValaParameter* _tmp13_;
		ValaParameter* _tmp14_;
		ValaScope* _tmp15_;
		ValaScope* _tmp16_;
		ValaParameter* _tmp17_;
		ValaParameter* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		ValaParameter* _tmp21_;
		ValaParameter* _tmp22_;
		_tmp3_ = vala_method_get_this_parameter (m);
		_tmp4_ = _tmp3_;
		if (_tmp4_ != NULL) {
			ValaScope* _tmp5_;
			ValaScope* _tmp6_;
			ValaParameter* _tmp7_;
			ValaParameter* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp5_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_method_get_this_parameter (m);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_symbol_get_name ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			vala_scope_remove (_tmp6_, _tmp10_);
		}
		_tmp11_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_parameter_new ("this", (ValaDataType*) _tmp12_, NULL);
		_tmp14_ = _tmp13_;
		vala_method_set_this_parameter (m, _tmp14_);
		_vala_code_node_unref0 (_tmp14_);
		_vala_code_node_unref0 (_tmp12_);
		_tmp15_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_method_get_this_parameter (m);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_symbol_get_name ((ValaSymbol*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_method_get_this_parameter (m);
		_tmp22_ = _tmp21_;
		vala_scope_add (_tmp16_, _tmp20_, (ValaSymbol*) _tmp22_);
	}
	_tmp24_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp25_ = _tmp24_;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, VALA_TYPE_VOID_TYPE)) {
		ValaList* _tmp26_;
		ValaList* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		_tmp26_ = vala_method_get_postconditions (m);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp23_ = _tmp29_ > 0;
		_vala_iterable_unref0 (_tmp27_);
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		ValaLocalVariable* _tmp30_;
		ValaLocalVariable* _tmp31_;
		ValaDataType* _tmp38_;
		ValaDataType* _tmp39_;
		ValaDataType* _tmp40_;
		ValaDataType* _tmp41_;
		ValaSourceReference* _tmp42_;
		ValaSourceReference* _tmp43_;
		ValaLocalVariable* _tmp44_;
		ValaLocalVariable* _tmp45_;
		ValaLocalVariable* _tmp46_;
		ValaLocalVariable* _tmp47_;
		_tmp30_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp31_ = _tmp30_;
		if (_tmp31_ != NULL) {
			ValaScope* _tmp32_;
			ValaScope* _tmp33_;
			ValaLocalVariable* _tmp34_;
			ValaLocalVariable* _tmp35_;
			const gchar* _tmp36_;
			const gchar* _tmp37_;
			_tmp32_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp33_ = _tmp32_;
			_tmp34_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
			_tmp35_ = _tmp34_;
			_tmp36_ = vala_symbol_get_name ((ValaSymbol*) _tmp35_);
			_tmp37_ = _tmp36_;
			vala_scope_remove (_tmp33_, _tmp37_);
		}
		_tmp38_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_data_type_copy (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_local_variable_new (_tmp41_, "result", NULL, _tmp43_);
		_tmp45_ = _tmp44_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp45_);
		_vala_code_node_unref0 (_tmp45_);
		_vala_code_node_unref0 (_tmp41_);
		_tmp46_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp47_ = _tmp46_;
		vala_local_variable_set_is_result (_tmp47_, TRUE);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (m, VALA_TYPE_CREATION_METHOD)) {
		const gchar* _tmp48_;
		const gchar* _tmp49_;
		ValaCreationMethod* cm = NULL;
		ValaCreationMethod* _tmp50_;
		gboolean _tmp51_ = FALSE;
		ValaCreationMethod* _tmp52_;
		const gchar* _tmp53_;
		const gchar* _tmp54_;
		_tmp48_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp49_ = _tmp48_;
		if (_tmp49_ == NULL) {
			vala_class_set_default_construction_method (self, G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
			vala_symbol_set_name ((ValaSymbol*) m, ".new");
		}
		_tmp50_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
		cm = _tmp50_;
		_tmp52_ = cm;
		_tmp53_ = vala_creation_method_get_class_name (_tmp52_);
		_tmp54_ = _tmp53_;
		if (_tmp54_ != NULL) {
			ValaCreationMethod* _tmp55_;
			const gchar* _tmp56_;
			const gchar* _tmp57_;
			const gchar* _tmp58_;
			const gchar* _tmp59_;
			_tmp55_ = cm;
			_tmp56_ = vala_creation_method_get_class_name (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp59_ = _tmp58_;
			_tmp51_ = g_strcmp0 (_tmp57_, _tmp59_) != 0;
		} else {
			_tmp51_ = FALSE;
		}
		if (_tmp51_) {
			ValaSourceReference* _tmp60_;
			ValaSourceReference* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			ValaCreationMethod* _tmp64_;
			const gchar* _tmp65_;
			const gchar* _tmp66_;
			gchar* _tmp67_;
			gchar* _tmp68_;
			_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
			_tmp61_ = _tmp60_;
			_tmp62_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp63_ = _tmp62_;
			_tmp64_ = cm;
			_tmp65_ = vala_creation_method_get_class_name (_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = g_strdup_printf ("missing return type in method `%s.%s´", _tmp63_, _tmp66_);
			_tmp68_ = _tmp67_;
			vala_report_error (_tmp61_, _tmp68_);
			_g_free0 (_tmp68_);
			_g_free0 (_tmp63_);
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
			_vala_code_node_unref0 (cm);
			return;
		}
		_vala_code_node_unref0 (cm);
	}
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_method ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), m);
	_tmp69_ = vala_method_get_base_interface_type (m);
	_tmp70_ = _tmp69_;
	if (_tmp70_ != NULL) {
		ValaScope* _tmp71_;
		ValaScope* _tmp72_;
		const gchar* _tmp73_;
		const gchar* _tmp74_;
		ValaScope* _tmp75_;
		ValaScope* _tmp76_;
		_tmp71_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp72_ = _tmp71_;
		_tmp73_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp74_ = _tmp73_;
		vala_scope_remove (_tmp72_, _tmp74_);
		_tmp75_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp76_ = _tmp75_;
		vala_scope_add (_tmp76_, NULL, (ValaSymbol*) m);
	}
}


/**
 * Adds the specified property as a member to this class.
 *
 * @param prop a property
 */
static void
vala_class_real_add_property (ValaSymbol* base,
                              ValaProperty* prop)
{
	ValaClass * self;
	ValaObjectType* _tmp0_;
	ValaObjectType* _tmp1_;
	ValaParameter* _tmp2_;
	ValaParameter* _tmp3_;
	ValaScope* _tmp4_;
	ValaScope* _tmp5_;
	ValaParameter* _tmp6_;
	ValaParameter* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	ValaParameter* _tmp10_;
	ValaParameter* _tmp11_;
	ValaField* _tmp12_;
	ValaField* _tmp13_;
	self = (ValaClass*) base;
	g_return_if_fail (prop != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_property ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), prop);
	_tmp0_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_parameter_new ("this", (ValaDataType*) _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	vala_property_set_this_parameter (prop, _tmp3_);
	_vala_code_node_unref0 (_tmp3_);
	_vala_code_node_unref0 (_tmp1_);
	_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) prop);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_property_get_this_parameter (prop);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_symbol_get_name ((ValaSymbol*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_property_get_this_parameter (prop);
	_tmp11_ = _tmp10_;
	vala_scope_add (_tmp5_, _tmp9_, (ValaSymbol*) _tmp11_);
	_tmp12_ = vala_property_get_field (prop);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaField* _tmp14_;
		ValaField* _tmp15_;
		_tmp14_ = vala_property_get_field (prop);
		_tmp15_ = _tmp14_;
		vala_symbol_add_field ((ValaSymbol*) self, _tmp15_);
	}
}


static void
vala_class_real_add_constructor (ValaSymbol* base,
                                 ValaConstructor* c)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	self = (ValaClass*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = vala_constructor_get_binding (c);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaConstructor* _tmp2_;
		ValaConstructor* _tmp3_;
		_tmp2_ = vala_class_get_constructor (self);
		_tmp3_ = _tmp2_;
		if (_tmp3_ != NULL) {
			ValaSourceReference* _tmp4_;
			ValaSourceReference* _tmp5_;
			_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
			_tmp5_ = _tmp4_;
			vala_report_error (_tmp5_, "class already contains a constructor");
		}
		vala_class_set_constructor (self, c);
	} else {
		ValaMemberBinding _tmp6_;
		ValaMemberBinding _tmp7_;
		_tmp6_ = vala_constructor_get_binding (c);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == VALA_MEMBER_BINDING_CLASS) {
			ValaConstructor* _tmp8_;
			ValaConstructor* _tmp9_;
			_tmp8_ = vala_class_get_class_constructor (self);
			_tmp9_ = _tmp8_;
			if (_tmp9_ != NULL) {
				ValaSourceReference* _tmp10_;
				ValaSourceReference* _tmp11_;
				_tmp10_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp11_ = _tmp10_;
				vala_report_error (_tmp11_, "class already contains a class constructor");
			}
			vala_class_set_class_constructor (self, c);
		} else {
			ValaConstructor* _tmp12_;
			ValaConstructor* _tmp13_;
			_tmp12_ = vala_class_get_static_constructor (self);
			_tmp13_ = _tmp12_;
			if (_tmp13_ != NULL) {
				ValaSourceReference* _tmp14_;
				ValaSourceReference* _tmp15_;
				_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp15_ = _tmp14_;
				vala_report_error (_tmp15_, "class already contains a static constructor");
			}
			vala_class_set_static_constructor (self, c);
		}
	}
}


static void
vala_class_real_add_destructor (ValaSymbol* base,
                                ValaDestructor* d)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	self = (ValaClass*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = vala_destructor_get_binding (d);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaDestructor* _tmp2_;
		ValaDestructor* _tmp3_;
		_tmp2_ = vala_class_get_destructor (self);
		_tmp3_ = _tmp2_;
		if (_tmp3_ != NULL) {
			ValaSourceReference* _tmp4_;
			ValaSourceReference* _tmp5_;
			_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
			_tmp5_ = _tmp4_;
			vala_report_error (_tmp5_, "class already contains a destructor");
		}
		vala_class_set_destructor (self, d);
	} else {
		ValaMemberBinding _tmp6_;
		ValaMemberBinding _tmp7_;
		_tmp6_ = vala_destructor_get_binding (d);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == VALA_MEMBER_BINDING_CLASS) {
			ValaDestructor* _tmp8_;
			ValaDestructor* _tmp9_;
			_tmp8_ = vala_class_get_class_destructor (self);
			_tmp9_ = _tmp8_;
			if (_tmp9_ != NULL) {
				ValaSourceReference* _tmp10_;
				ValaSourceReference* _tmp11_;
				_tmp10_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp11_ = _tmp10_;
				vala_report_error (_tmp11_, "class already contains a class destructor");
			}
			vala_class_set_class_destructor (self, d);
		} else {
			ValaDestructor* _tmp12_;
			ValaDestructor* _tmp13_;
			_tmp12_ = vala_class_get_static_destructor (self);
			_tmp13_ = _tmp12_;
			if (_tmp13_ != NULL) {
				ValaSourceReference* _tmp14_;
				ValaSourceReference* _tmp15_;
				_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp15_ = _tmp14_;
				vala_report_error (_tmp15_, "class already contains a static destructor");
			}
			vala_class_set_static_destructor (self, d);
		}
	}
}


static void
vala_class_real_accept (ValaCodeNode* base,
                        ValaCodeVisitor* visitor)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_class (visitor, self);
}


static void
vala_class_real_accept_children (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaClass * self;
	ValaConstructor* _tmp89_;
	ValaConstructor* _tmp90_;
	ValaConstructor* _tmp93_;
	ValaConstructor* _tmp94_;
	ValaConstructor* _tmp97_;
	ValaConstructor* _tmp98_;
	ValaDestructor* _tmp101_;
	ValaDestructor* _tmp102_;
	ValaDestructor* _tmp105_;
	ValaDestructor* _tmp106_;
	ValaDestructor* _tmp109_;
	ValaDestructor* _tmp110_;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _type_index = 0;
		_tmp0_ = self->priv->base_types;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_type_list = _tmp1_;
		_tmp2_ = _type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_type_size = _tmp4_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaDataType* type = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaDataType* _tmp11_;
			_tmp5_ = _type_index;
			_type_index = _tmp5_ + 1;
			_tmp6_ = _type_index;
			_tmp7_ = _type_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _type_list;
			_tmp9_ = _type_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			type = (ValaDataType*) _tmp10_;
			_tmp11_ = type;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp12_;
		gint _p_size = 0;
		ValaList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _p_index = 0;
		_tmp12_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp12_;
		_tmp13_ = _p_list;
		_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_p_size = _tmp15_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp19_;
			gint _tmp20_;
			gpointer _tmp21_;
			ValaTypeParameter* _tmp22_;
			_tmp16_ = _p_index;
			_p_index = _tmp16_ + 1;
			_tmp17_ = _p_index;
			_tmp18_ = _p_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _p_list;
			_tmp20_ = _p_index;
			_tmp21_ = vala_list_get (_tmp19_, _tmp20_);
			p = (ValaTypeParameter*) _tmp21_;
			_tmp22_ = p;
			vala_code_node_accept ((ValaCodeNode*) _tmp22_, visitor);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp23_;
		gint _en_size = 0;
		ValaList* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _en_index = 0;
		_tmp23_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_en_list = _tmp23_;
		_tmp24_ = _en_list;
		_tmp25_ = vala_collection_get_size ((ValaCollection*) _tmp24_);
		_tmp26_ = _tmp25_;
		_en_size = _tmp26_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			ValaEnum* en = NULL;
			ValaList* _tmp30_;
			gint _tmp31_;
			gpointer _tmp32_;
			ValaEnum* _tmp33_;
			_tmp27_ = _en_index;
			_en_index = _tmp27_ + 1;
			_tmp28_ = _en_index;
			_tmp29_ = _en_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _en_list;
			_tmp31_ = _en_index;
			_tmp32_ = vala_list_get (_tmp30_, _tmp31_);
			en = (ValaEnum*) _tmp32_;
			_tmp33_ = en;
			vala_code_node_accept ((ValaCodeNode*) _tmp33_, visitor);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp34_;
		gint _f_size = 0;
		ValaList* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		gint _f_index = 0;
		_tmp34_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_f_list = _tmp34_;
		_tmp35_ = _f_list;
		_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
		_tmp37_ = _tmp36_;
		_f_size = _tmp37_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp38_;
			gint _tmp39_;
			gint _tmp40_;
			ValaField* f = NULL;
			ValaList* _tmp41_;
			gint _tmp42_;
			gpointer _tmp43_;
			ValaField* _tmp44_;
			_tmp38_ = _f_index;
			_f_index = _tmp38_ + 1;
			_tmp39_ = _f_index;
			_tmp40_ = _f_size;
			if (!(_tmp39_ < _tmp40_)) {
				break;
			}
			_tmp41_ = _f_list;
			_tmp42_ = _f_index;
			_tmp43_ = vala_list_get (_tmp41_, _tmp42_);
			f = (ValaField*) _tmp43_;
			_tmp44_ = f;
			vala_code_node_accept ((ValaCodeNode*) _tmp44_, visitor);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp45_;
		gint _c_size = 0;
		ValaList* _tmp46_;
		gint _tmp47_;
		gint _tmp48_;
		gint _c_index = 0;
		_tmp45_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_c_list = _tmp45_;
		_tmp46_ = _c_list;
		_tmp47_ = vala_collection_get_size ((ValaCollection*) _tmp46_);
		_tmp48_ = _tmp47_;
		_c_size = _tmp48_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp49_;
			gint _tmp50_;
			gint _tmp51_;
			ValaConstant* c = NULL;
			ValaList* _tmp52_;
			gint _tmp53_;
			gpointer _tmp54_;
			ValaConstant* _tmp55_;
			_tmp49_ = _c_index;
			_c_index = _tmp49_ + 1;
			_tmp50_ = _c_index;
			_tmp51_ = _c_size;
			if (!(_tmp50_ < _tmp51_)) {
				break;
			}
			_tmp52_ = _c_list;
			_tmp53_ = _c_index;
			_tmp54_ = vala_list_get (_tmp52_, _tmp53_);
			c = (ValaConstant*) _tmp54_;
			_tmp55_ = c;
			vala_code_node_accept ((ValaCodeNode*) _tmp55_, visitor);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp56_;
		gint _m_size = 0;
		ValaList* _tmp57_;
		gint _tmp58_;
		gint _tmp59_;
		gint _m_index = 0;
		_tmp56_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
		_m_list = _tmp56_;
		_tmp57_ = _m_list;
		_tmp58_ = vala_collection_get_size ((ValaCollection*) _tmp57_);
		_tmp59_ = _tmp58_;
		_m_size = _tmp59_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp60_;
			gint _tmp61_;
			gint _tmp62_;
			ValaMethod* m = NULL;
			ValaList* _tmp63_;
			gint _tmp64_;
			gpointer _tmp65_;
			ValaMethod* _tmp66_;
			_tmp60_ = _m_index;
			_m_index = _tmp60_ + 1;
			_tmp61_ = _m_index;
			_tmp62_ = _m_size;
			if (!(_tmp61_ < _tmp62_)) {
				break;
			}
			_tmp63_ = _m_list;
			_tmp64_ = _m_index;
			_tmp65_ = vala_list_get (_tmp63_, _tmp64_);
			m = (ValaMethod*) _tmp65_;
			_tmp66_ = m;
			vala_code_node_accept ((ValaCodeNode*) _tmp66_, visitor);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp67_;
		gint _prop_size = 0;
		ValaList* _tmp68_;
		gint _tmp69_;
		gint _tmp70_;
		gint _prop_index = 0;
		_tmp67_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
		_prop_list = _tmp67_;
		_tmp68_ = _prop_list;
		_tmp69_ = vala_collection_get_size ((ValaCollection*) _tmp68_);
		_tmp70_ = _tmp69_;
		_prop_size = _tmp70_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp71_;
			gint _tmp72_;
			gint _tmp73_;
			ValaProperty* prop = NULL;
			ValaList* _tmp74_;
			gint _tmp75_;
			gpointer _tmp76_;
			ValaProperty* _tmp77_;
			_tmp71_ = _prop_index;
			_prop_index = _tmp71_ + 1;
			_tmp72_ = _prop_index;
			_tmp73_ = _prop_size;
			if (!(_tmp72_ < _tmp73_)) {
				break;
			}
			_tmp74_ = _prop_list;
			_tmp75_ = _prop_index;
			_tmp76_ = vala_list_get (_tmp74_, _tmp75_);
			prop = (ValaProperty*) _tmp76_;
			_tmp77_ = prop;
			vala_code_node_accept ((ValaCodeNode*) _tmp77_, visitor);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp78_;
		gint _sig_size = 0;
		ValaList* _tmp79_;
		gint _tmp80_;
		gint _tmp81_;
		gint _sig_index = 0;
		_tmp78_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
		_sig_list = _tmp78_;
		_tmp79_ = _sig_list;
		_tmp80_ = vala_collection_get_size ((ValaCollection*) _tmp79_);
		_tmp81_ = _tmp80_;
		_sig_size = _tmp81_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp82_;
			gint _tmp83_;
			gint _tmp84_;
			ValaSignal* sig = NULL;
			ValaList* _tmp85_;
			gint _tmp86_;
			gpointer _tmp87_;
			ValaSignal* _tmp88_;
			_tmp82_ = _sig_index;
			_sig_index = _tmp82_ + 1;
			_tmp83_ = _sig_index;
			_tmp84_ = _sig_size;
			if (!(_tmp83_ < _tmp84_)) {
				break;
			}
			_tmp85_ = _sig_list;
			_tmp86_ = _sig_index;
			_tmp87_ = vala_list_get (_tmp85_, _tmp86_);
			sig = (ValaSignal*) _tmp87_;
			_tmp88_ = sig;
			vala_code_node_accept ((ValaCodeNode*) _tmp88_, visitor);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	_tmp89_ = vala_class_get_constructor (self);
	_tmp90_ = _tmp89_;
	if (_tmp90_ != NULL) {
		ValaConstructor* _tmp91_;
		ValaConstructor* _tmp92_;
		_tmp91_ = vala_class_get_constructor (self);
		_tmp92_ = _tmp91_;
		vala_code_node_accept ((ValaCodeNode*) _tmp92_, visitor);
	}
	_tmp93_ = vala_class_get_class_constructor (self);
	_tmp94_ = _tmp93_;
	if (_tmp94_ != NULL) {
		ValaConstructor* _tmp95_;
		ValaConstructor* _tmp96_;
		_tmp95_ = vala_class_get_class_constructor (self);
		_tmp96_ = _tmp95_;
		vala_code_node_accept ((ValaCodeNode*) _tmp96_, visitor);
	}
	_tmp97_ = vala_class_get_static_constructor (self);
	_tmp98_ = _tmp97_;
	if (_tmp98_ != NULL) {
		ValaConstructor* _tmp99_;
		ValaConstructor* _tmp100_;
		_tmp99_ = vala_class_get_static_constructor (self);
		_tmp100_ = _tmp99_;
		vala_code_node_accept ((ValaCodeNode*) _tmp100_, visitor);
	}
	_tmp101_ = vala_class_get_destructor (self);
	_tmp102_ = _tmp101_;
	if (_tmp102_ != NULL) {
		ValaDestructor* _tmp103_;
		ValaDestructor* _tmp104_;
		_tmp103_ = vala_class_get_destructor (self);
		_tmp104_ = _tmp103_;
		vala_code_node_accept ((ValaCodeNode*) _tmp104_, visitor);
	}
	_tmp105_ = vala_class_get_static_destructor (self);
	_tmp106_ = _tmp105_;
	if (_tmp106_ != NULL) {
		ValaDestructor* _tmp107_;
		ValaDestructor* _tmp108_;
		_tmp107_ = vala_class_get_static_destructor (self);
		_tmp108_ = _tmp107_;
		vala_code_node_accept ((ValaCodeNode*) _tmp108_, visitor);
	}
	_tmp109_ = vala_class_get_class_destructor (self);
	_tmp110_ = _tmp109_;
	if (_tmp110_ != NULL) {
		ValaDestructor* _tmp111_;
		ValaDestructor* _tmp112_;
		_tmp111_ = vala_class_get_class_destructor (self);
		_tmp112_ = _tmp111_;
		vala_code_node_accept ((ValaCodeNode*) _tmp112_, visitor);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp113_;
		gint _cl_size = 0;
		ValaList* _tmp114_;
		gint _tmp115_;
		gint _tmp116_;
		gint _cl_index = 0;
		_tmp113_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_cl_list = _tmp113_;
		_tmp114_ = _cl_list;
		_tmp115_ = vala_collection_get_size ((ValaCollection*) _tmp114_);
		_tmp116_ = _tmp115_;
		_cl_size = _tmp116_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp117_;
			gint _tmp118_;
			gint _tmp119_;
			ValaClass* cl = NULL;
			ValaList* _tmp120_;
			gint _tmp121_;
			gpointer _tmp122_;
			ValaClass* _tmp123_;
			_tmp117_ = _cl_index;
			_cl_index = _tmp117_ + 1;
			_tmp118_ = _cl_index;
			_tmp119_ = _cl_size;
			if (!(_tmp118_ < _tmp119_)) {
				break;
			}
			_tmp120_ = _cl_list;
			_tmp121_ = _cl_index;
			_tmp122_ = vala_list_get (_tmp120_, _tmp121_);
			cl = (ValaClass*) _tmp122_;
			_tmp123_ = cl;
			vala_code_node_accept ((ValaCodeNode*) _tmp123_, visitor);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp124_;
		gint _st_size = 0;
		ValaList* _tmp125_;
		gint _tmp126_;
		gint _tmp127_;
		gint _st_index = 0;
		_tmp124_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_st_list = _tmp124_;
		_tmp125_ = _st_list;
		_tmp126_ = vala_collection_get_size ((ValaCollection*) _tmp125_);
		_tmp127_ = _tmp126_;
		_st_size = _tmp127_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp128_;
			gint _tmp129_;
			gint _tmp130_;
			ValaStruct* st = NULL;
			ValaList* _tmp131_;
			gint _tmp132_;
			gpointer _tmp133_;
			ValaStruct* _tmp134_;
			_tmp128_ = _st_index;
			_st_index = _tmp128_ + 1;
			_tmp129_ = _st_index;
			_tmp130_ = _st_size;
			if (!(_tmp129_ < _tmp130_)) {
				break;
			}
			_tmp131_ = _st_list;
			_tmp132_ = _st_index;
			_tmp133_ = vala_list_get (_tmp131_, _tmp132_);
			st = (ValaStruct*) _tmp133_;
			_tmp134_ = st;
			vala_code_node_accept ((ValaCodeNode*) _tmp134_, visitor);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp135_;
		gint _d_size = 0;
		ValaList* _tmp136_;
		gint _tmp137_;
		gint _tmp138_;
		gint _d_index = 0;
		_tmp135_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_d_list = _tmp135_;
		_tmp136_ = _d_list;
		_tmp137_ = vala_collection_get_size ((ValaCollection*) _tmp136_);
		_tmp138_ = _tmp137_;
		_d_size = _tmp138_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp139_;
			gint _tmp140_;
			gint _tmp141_;
			ValaDelegate* d = NULL;
			ValaList* _tmp142_;
			gint _tmp143_;
			gpointer _tmp144_;
			ValaDelegate* _tmp145_;
			_tmp139_ = _d_index;
			_d_index = _tmp139_ + 1;
			_tmp140_ = _d_index;
			_tmp141_ = _d_size;
			if (!(_tmp140_ < _tmp141_)) {
				break;
			}
			_tmp142_ = _d_list;
			_tmp143_ = _d_index;
			_tmp144_ = vala_list_get (_tmp142_, _tmp143_);
			d = (ValaDelegate*) _tmp144_;
			_tmp145_ = d;
			vala_code_node_accept ((ValaCodeNode*) _tmp145_, visitor);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
}


static gboolean
vala_class_real_is_reference_type (ValaTypeSymbol* base)
{
	ValaClass * self;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	result = TRUE;
	return result;
}


gboolean
vala_class_is_fundamental (ValaClass* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = vala_class_get_is_compact (self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		ValaClass* _tmp3_;
		_tmp3_ = self->priv->_base_class;
		_tmp0_ = _tmp3_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean
vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                               ValaTypeSymbol* t)
{
	ValaClass * self;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _base_type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _base_type_index = 0;
		_tmp0_ = self->priv->base_types;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_base_type_list = _tmp1_;
		_tmp2_ = _base_type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_base_type_size = _tmp4_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			gboolean _tmp11_ = FALSE;
			ValaDataType* _tmp12_;
			ValaTypeSymbol* _tmp13_;
			ValaTypeSymbol* _tmp14_;
			_tmp5_ = _base_type_index;
			_base_type_index = _tmp5_ + 1;
			_tmp6_ = _base_type_index;
			_tmp7_ = _base_type_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _base_type_list;
			_tmp9_ = _base_type_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			base_type = (ValaDataType*) _tmp10_;
			_tmp12_ = base_type;
			_tmp13_ = vala_data_type_get_data_type (_tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_ != NULL) {
				ValaDataType* _tmp15_;
				ValaTypeSymbol* _tmp16_;
				ValaTypeSymbol* _tmp17_;
				_tmp15_ = base_type;
				_tmp16_ = vala_data_type_get_data_type (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp11_ = vala_typesymbol_is_subtype_of (_tmp17_, t);
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				_vala_iterable_unref0 (_base_type_list);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}


static void
vala_class_real_replace_type (ValaCodeNode* base,
                              ValaDataType* old_type,
                              ValaDataType* new_type)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ValaList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				ValaList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				ValaDataType* _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->base_types;
				_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->base_types;
				_tmp7_ = i;
				_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
				_tmp9_ = (ValaDataType*) _tmp8_;
				_tmp10_ = _tmp9_ == old_type;
				_vala_code_node_unref0 (_tmp9_);
				if (_tmp10_) {
					ValaList* _tmp11_;
					gint _tmp12_;
					_tmp11_ = self->priv->base_types;
					_tmp12_ = i;
					vala_list_set (_tmp11_, _tmp12_, new_type);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_type, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}


static void
vala_class_get_all_prerequisites (ValaClass* self,
                                  ValaInterface* iface,
                                  ValaList* list)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	g_return_if_fail (list != NULL);
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp0_;
		gint _prereq_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _prereq_index = 0;
		_tmp0_ = vala_interface_get_prerequisites (iface);
		_prereq_list = _tmp0_;
		_tmp1_ = _prereq_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_prereq_size = _tmp3_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* prereq = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaTypeSymbol* type = NULL;
			ValaDataType* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			ValaTypeSymbol* _tmp13_;
			ValaTypeSymbol* _tmp14_;
			ValaTypeSymbol* _tmp15_;
			ValaTypeSymbol* _tmp16_;
			_tmp4_ = _prereq_index;
			_prereq_index = _tmp4_ + 1;
			_tmp5_ = _prereq_index;
			_tmp6_ = _prereq_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _prereq_list;
			_tmp8_ = _prereq_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			prereq = (ValaDataType*) _tmp9_;
			_tmp10_ = prereq;
			_tmp11_ = vala_data_type_get_data_type (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = _vala_code_node_ref0 (_tmp12_);
			type = _tmp13_;
			_tmp14_ = type;
			if (_tmp14_ == NULL) {
				_vala_code_node_unref0 (type);
				_vala_code_node_unref0 (prereq);
				continue;
			}
			_tmp15_ = type;
			vala_collection_add ((ValaCollection*) list, _tmp15_);
			_tmp16_ = type;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_INTERFACE)) {
				ValaTypeSymbol* _tmp17_;
				_tmp17_ = type;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_INTERFACE, ValaInterface), list);
			}
			_vala_code_node_unref0 (type);
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
}


static gboolean
vala_class_class_is_a (ValaClass* self,
                       ValaClass* cl,
                       ValaTypeSymbol* t)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cl != NULL, FALSE);
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (cl, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		gint _base_type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _base_type_index = 0;
		_tmp0_ = vala_class_get_base_types (cl);
		_base_type_list = _tmp0_;
		_tmp1_ = _base_type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_base_type_size = _tmp3_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaDataType* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			_tmp4_ = _base_type_index;
			_base_type_index = _tmp4_ + 1;
			_tmp5_ = _base_type_index;
			_tmp6_ = _base_type_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _base_type_list;
			_tmp8_ = _base_type_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			base_type = (ValaDataType*) _tmp9_;
			_tmp10_ = base_type;
			_tmp11_ = vala_data_type_get_data_type (_tmp10_);
			_tmp12_ = _tmp11_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_CLASS)) {
				ValaDataType* _tmp13_;
				ValaTypeSymbol* _tmp14_;
				ValaTypeSymbol* _tmp15_;
				_tmp13_ = base_type;
				_tmp14_ = vala_data_type_get_data_type (_tmp13_);
				_tmp15_ = _tmp14_;
				if (vala_class_class_is_a (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, VALA_TYPE_CLASS, ValaClass), t)) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					return result;
				}
			} else {
				ValaDataType* _tmp16_;
				ValaTypeSymbol* _tmp17_;
				ValaTypeSymbol* _tmp18_;
				_tmp16_ = base_type;
				_tmp17_ = vala_data_type_get_data_type (_tmp16_);
				_tmp18_ = _tmp17_;
				if (_tmp18_ == t) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}


static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}


static gboolean
vala_class_real_check (ValaCodeNode* base,
                       ValaCodeContext* context)
{
	ValaClass * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaConstructor* _tmp181_;
	ValaConstructor* _tmp182_;
	ValaConstructor* _tmp185_;
	ValaConstructor* _tmp186_;
	ValaConstructor* _tmp189_;
	ValaConstructor* _tmp190_;
	ValaDestructor* _tmp193_;
	ValaDestructor* _tmp194_;
	ValaDestructor* _tmp197_;
	ValaDestructor* _tmp198_;
	ValaDestructor* _tmp201_;
	ValaDestructor* _tmp202_;
	gboolean _tmp238_;
	gboolean _tmp239_;
	ValaList* prerequisites = NULL;
	GEqualFunc _tmp286_;
	ValaArrayList* _tmp287_;
	ValaList* missing_prereqs = NULL;
	GEqualFunc _tmp305_;
	ValaArrayList* _tmp306_;
	ValaList* _tmp323_;
	gint _tmp324_;
	gint _tmp325_;
	ValaSourceFileType _tmp353_;
	ValaSourceFileType _tmp354_;
	ValaSemanticAnalyzer* _tmp580_;
	ValaSemanticAnalyzer* _tmp581_;
	ValaSourceFile* _tmp582_;
	ValaSemanticAnalyzer* _tmp583_;
	ValaSemanticAnalyzer* _tmp584_;
	ValaSymbol* _tmp585_;
	gboolean _tmp586_;
	gboolean _tmp587_;
	self = (ValaClass*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	{
		ValaList* _base_type_reference_list = NULL;
		ValaList* _tmp24_;
		gint _base_type_reference_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _base_type_reference_index = 0;
		_tmp24_ = vala_class_get_base_types (self);
		_base_type_reference_list = _tmp24_;
		_tmp25_ = _base_type_reference_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_base_type_reference_size = _tmp27_;
		_base_type_reference_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			ValaDataType* base_type_reference = NULL;
			ValaList* _tmp31_;
			gint _tmp32_;
			gpointer _tmp33_;
			ValaDataType* _tmp34_;
			ValaDataType* _tmp35_;
			ValaSemanticAnalyzer* _tmp45_;
			ValaSemanticAnalyzer* _tmp46_;
			ValaDataType* _tmp47_;
			gint n_type_args = 0;
			ValaDataType* _tmp57_;
			ValaList* _tmp58_;
			ValaList* _tmp59_;
			gint _tmp60_;
			gint _tmp61_;
			gint _tmp62_;
			gint n_type_params = 0;
			ValaDataType* _tmp63_;
			ValaTypeSymbol* _tmp64_;
			ValaTypeSymbol* _tmp65_;
			ValaList* _tmp66_;
			ValaList* _tmp67_;
			gint _tmp68_;
			gint _tmp69_;
			gint _tmp70_;
			gint _tmp71_;
			gint _tmp72_;
			_tmp28_ = _base_type_reference_index;
			_base_type_reference_index = _tmp28_ + 1;
			_tmp29_ = _base_type_reference_index;
			_tmp30_ = _base_type_reference_size;
			if (!(_tmp29_ < _tmp30_)) {
				break;
			}
			_tmp31_ = _base_type_reference_list;
			_tmp32_ = _base_type_reference_index;
			_tmp33_ = vala_list_get (_tmp31_, _tmp32_);
			base_type_reference = (ValaDataType*) _tmp33_;
			_tmp34_ = base_type_reference;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp34_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp35_ = base_type_reference;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp35_, VALA_TYPE_OBJECT_TYPE)) {
				ValaSourceReference* _tmp36_;
				ValaSourceReference* _tmp37_;
				ValaDataType* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp37_ = _tmp36_;
				_tmp38_ = base_type_reference;
				_tmp39_ = vala_code_node_to_string ((ValaCodeNode*) _tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp42_ = _tmp41_;
				_tmp43_ = g_strdup_printf ("base type `%s` of class `%s` is not an object type", _tmp40_, _tmp42_);
				_tmp44_ = _tmp43_;
				vala_report_error (_tmp37_, _tmp44_);
				_g_free0 (_tmp44_);
				_g_free0 (_tmp42_);
				_g_free0 (_tmp40_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp45_ = vala_code_context_get_analyzer (context);
			_tmp46_ = _tmp45_;
			_tmp47_ = base_type_reference;
			if (!vala_semantic_analyzer_is_type_accessible (_tmp46_, (ValaSymbol*) self, _tmp47_)) {
				ValaSourceReference* _tmp48_;
				ValaSourceReference* _tmp49_;
				ValaDataType* _tmp50_;
				gchar* _tmp51_;
				gchar* _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp55_;
				gchar* _tmp56_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp48_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp49_ = _tmp48_;
				_tmp50_ = base_type_reference;
				_tmp51_ = vala_code_node_to_string ((ValaCodeNode*) _tmp50_);
				_tmp52_ = _tmp51_;
				_tmp53_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp54_ = _tmp53_;
				_tmp55_ = g_strdup_printf ("base type `%s` is less accessible than class `%s`", _tmp52_, _tmp54_);
				_tmp56_ = _tmp55_;
				vala_report_error (_tmp49_, _tmp56_);
				_g_free0 (_tmp56_);
				_g_free0 (_tmp54_);
				_g_free0 (_tmp52_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp57_ = base_type_reference;
			_tmp58_ = vala_data_type_get_type_arguments (_tmp57_);
			_tmp59_ = _tmp58_;
			_tmp60_ = vala_collection_get_size ((ValaCollection*) _tmp59_);
			_tmp61_ = _tmp60_;
			_tmp62_ = _tmp61_;
			_vala_iterable_unref0 (_tmp59_);
			n_type_args = _tmp62_;
			_tmp63_ = base_type_reference;
			_tmp64_ = vala_data_type_get_data_type (_tmp63_);
			_tmp65_ = _tmp64_;
			_tmp66_ = vala_object_type_symbol_get_type_parameters (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp67_ = _tmp66_;
			_tmp68_ = vala_collection_get_size ((ValaCollection*) _tmp67_);
			_tmp69_ = _tmp68_;
			_tmp70_ = _tmp69_;
			_vala_iterable_unref0 (_tmp67_);
			n_type_params = _tmp70_;
			_tmp71_ = n_type_args;
			_tmp72_ = n_type_params;
			if (_tmp71_ < _tmp72_) {
				ValaDataType* _tmp73_;
				ValaSourceReference* _tmp74_;
				ValaSourceReference* _tmp75_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp73_ = base_type_reference;
				_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp73_);
				_tmp75_ = _tmp74_;
				vala_report_error (_tmp75_, "too few type arguments");
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			} else {
				gint _tmp76_;
				gint _tmp77_;
				_tmp76_ = n_type_args;
				_tmp77_ = n_type_params;
				if (_tmp76_ > _tmp77_) {
					ValaDataType* _tmp78_;
					ValaSourceReference* _tmp79_;
					ValaSourceReference* _tmp80_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp78_ = base_type_reference;
					_tmp79_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp78_);
					_tmp80_ = _tmp79_;
					vala_report_error (_tmp80_, "too many type arguments");
					result = FALSE;
					_vala_code_node_unref0 (base_type_reference);
					_vala_iterable_unref0 (_base_type_reference_list);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type_reference);
		}
		_vala_iterable_unref0 (_base_type_reference_list);
	}
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp81_;
		ValaList* _tmp82_;
		gint _type_size = 0;
		ValaList* _tmp83_;
		gint _tmp84_;
		gint _tmp85_;
		gint _type_index = 0;
		_tmp81_ = self->priv->base_types;
		_tmp82_ = _vala_iterable_ref0 (_tmp81_);
		_type_list = _tmp82_;
		_tmp83_ = _type_list;
		_tmp84_ = vala_collection_get_size ((ValaCollection*) _tmp83_);
		_tmp85_ = _tmp84_;
		_type_size = _tmp85_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp86_;
			gint _tmp87_;
			gint _tmp88_;
			ValaDataType* type = NULL;
			ValaList* _tmp89_;
			gint _tmp90_;
			gpointer _tmp91_;
			ValaDataType* _tmp92_;
			_tmp86_ = _type_index;
			_type_index = _tmp86_ + 1;
			_tmp87_ = _type_index;
			_tmp88_ = _type_size;
			if (!(_tmp87_ < _tmp88_)) {
				break;
			}
			_tmp89_ = _type_list;
			_tmp90_ = _type_index;
			_tmp91_ = vala_list_get (_tmp89_, _tmp90_);
			type = (ValaDataType*) _tmp91_;
			_tmp92_ = type;
			vala_code_node_check ((ValaCodeNode*) _tmp92_, context);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp93_;
		gint _p_size = 0;
		ValaList* _tmp94_;
		gint _tmp95_;
		gint _tmp96_;
		gint _p_index = 0;
		_tmp93_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp93_;
		_tmp94_ = _p_list;
		_tmp95_ = vala_collection_get_size ((ValaCollection*) _tmp94_);
		_tmp96_ = _tmp95_;
		_p_size = _tmp96_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp97_;
			gint _tmp98_;
			gint _tmp99_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp100_;
			gint _tmp101_;
			gpointer _tmp102_;
			ValaTypeParameter* _tmp103_;
			_tmp97_ = _p_index;
			_p_index = _tmp97_ + 1;
			_tmp98_ = _p_index;
			_tmp99_ = _p_size;
			if (!(_tmp98_ < _tmp99_)) {
				break;
			}
			_tmp100_ = _p_list;
			_tmp101_ = _p_index;
			_tmp102_ = vala_list_get (_tmp100_, _tmp101_);
			p = (ValaTypeParameter*) _tmp102_;
			_tmp103_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp103_, context);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp104_;
		gint _en_size = 0;
		ValaList* _tmp105_;
		gint _tmp106_;
		gint _tmp107_;
		gint _en_index = 0;
		_tmp104_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_en_list = _tmp104_;
		_tmp105_ = _en_list;
		_tmp106_ = vala_collection_get_size ((ValaCollection*) _tmp105_);
		_tmp107_ = _tmp106_;
		_en_size = _tmp107_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp108_;
			gint _tmp109_;
			gint _tmp110_;
			ValaEnum* en = NULL;
			ValaList* _tmp111_;
			gint _tmp112_;
			gpointer _tmp113_;
			ValaEnum* _tmp114_;
			_tmp108_ = _en_index;
			_en_index = _tmp108_ + 1;
			_tmp109_ = _en_index;
			_tmp110_ = _en_size;
			if (!(_tmp109_ < _tmp110_)) {
				break;
			}
			_tmp111_ = _en_list;
			_tmp112_ = _en_index;
			_tmp113_ = vala_list_get (_tmp111_, _tmp112_);
			en = (ValaEnum*) _tmp113_;
			_tmp114_ = en;
			vala_code_node_check ((ValaCodeNode*) _tmp114_, context);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp115_;
		gint _f_size = 0;
		ValaList* _tmp116_;
		gint _tmp117_;
		gint _tmp118_;
		gint _f_index = 0;
		_tmp115_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_f_list = _tmp115_;
		_tmp116_ = _f_list;
		_tmp117_ = vala_collection_get_size ((ValaCollection*) _tmp116_);
		_tmp118_ = _tmp117_;
		_f_size = _tmp118_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp119_;
			gint _tmp120_;
			gint _tmp121_;
			ValaField* f = NULL;
			ValaList* _tmp122_;
			gint _tmp123_;
			gpointer _tmp124_;
			ValaField* _tmp125_;
			_tmp119_ = _f_index;
			_f_index = _tmp119_ + 1;
			_tmp120_ = _f_index;
			_tmp121_ = _f_size;
			if (!(_tmp120_ < _tmp121_)) {
				break;
			}
			_tmp122_ = _f_list;
			_tmp123_ = _f_index;
			_tmp124_ = vala_list_get (_tmp122_, _tmp123_);
			f = (ValaField*) _tmp124_;
			_tmp125_ = f;
			vala_code_node_check ((ValaCodeNode*) _tmp125_, context);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp126_;
		gint _c_size = 0;
		ValaList* _tmp127_;
		gint _tmp128_;
		gint _tmp129_;
		gint _c_index = 0;
		_tmp126_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_c_list = _tmp126_;
		_tmp127_ = _c_list;
		_tmp128_ = vala_collection_get_size ((ValaCollection*) _tmp127_);
		_tmp129_ = _tmp128_;
		_c_size = _tmp129_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp130_;
			gint _tmp131_;
			gint _tmp132_;
			ValaConstant* c = NULL;
			ValaList* _tmp133_;
			gint _tmp134_;
			gpointer _tmp135_;
			ValaConstant* _tmp136_;
			_tmp130_ = _c_index;
			_c_index = _tmp130_ + 1;
			_tmp131_ = _c_index;
			_tmp132_ = _c_size;
			if (!(_tmp131_ < _tmp132_)) {
				break;
			}
			_tmp133_ = _c_list;
			_tmp134_ = _c_index;
			_tmp135_ = vala_list_get (_tmp133_, _tmp134_);
			c = (ValaConstant*) _tmp135_;
			_tmp136_ = c;
			vala_code_node_check ((ValaCodeNode*) _tmp136_, context);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp137_;
		gint _m_size = 0;
		ValaList* _tmp138_;
		gint _tmp139_;
		gint _tmp140_;
		gint _m_index = 0;
		_tmp137_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
		_m_list = _tmp137_;
		_tmp138_ = _m_list;
		_tmp139_ = vala_collection_get_size ((ValaCollection*) _tmp138_);
		_tmp140_ = _tmp139_;
		_m_size = _tmp140_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp141_;
			gint _tmp142_;
			gint _tmp143_;
			ValaMethod* m = NULL;
			ValaList* _tmp144_;
			gint _tmp145_;
			gpointer _tmp146_;
			ValaMethod* _tmp147_;
			_tmp141_ = _m_index;
			_m_index = _tmp141_ + 1;
			_tmp142_ = _m_index;
			_tmp143_ = _m_size;
			if (!(_tmp142_ < _tmp143_)) {
				break;
			}
			_tmp144_ = _m_list;
			_tmp145_ = _m_index;
			_tmp146_ = vala_list_get (_tmp144_, _tmp145_);
			m = (ValaMethod*) _tmp146_;
			_tmp147_ = m;
			vala_code_node_check ((ValaCodeNode*) _tmp147_, context);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp148_;
		gint _prop_size = 0;
		ValaList* _tmp149_;
		gint _tmp150_;
		gint _tmp151_;
		gint _prop_index = 0;
		_tmp148_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
		_prop_list = _tmp148_;
		_tmp149_ = _prop_list;
		_tmp150_ = vala_collection_get_size ((ValaCollection*) _tmp149_);
		_tmp151_ = _tmp150_;
		_prop_size = _tmp151_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp152_;
			gint _tmp153_;
			gint _tmp154_;
			ValaProperty* prop = NULL;
			ValaList* _tmp155_;
			gint _tmp156_;
			gpointer _tmp157_;
			gboolean _tmp158_ = FALSE;
			ValaProperty* _tmp159_;
			ValaAttribute* _tmp160_;
			ValaAttribute* _tmp161_;
			gboolean _tmp162_;
			ValaProperty* _tmp169_;
			_tmp152_ = _prop_index;
			_prop_index = _tmp152_ + 1;
			_tmp153_ = _prop_index;
			_tmp154_ = _prop_size;
			if (!(_tmp153_ < _tmp154_)) {
				break;
			}
			_tmp155_ = _prop_list;
			_tmp156_ = _prop_index;
			_tmp157_ = vala_list_get (_tmp155_, _tmp156_);
			prop = (ValaProperty*) _tmp157_;
			_tmp159_ = prop;
			_tmp160_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp159_, "NoAccessorMethod");
			_tmp161_ = _tmp160_;
			_tmp162_ = _tmp161_ != NULL;
			_vala_code_node_unref0 (_tmp161_);
			if (_tmp162_) {
				ValaSemanticAnalyzer* _tmp163_;
				ValaSemanticAnalyzer* _tmp164_;
				ValaClass* _tmp165_;
				_tmp163_ = vala_code_context_get_analyzer (context);
				_tmp164_ = _tmp163_;
				_tmp165_ = _tmp164_->object_type;
				_tmp158_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self, (ValaTypeSymbol*) _tmp165_);
			} else {
				_tmp158_ = FALSE;
			}
			if (_tmp158_) {
				ValaProperty* _tmp166_;
				ValaSourceReference* _tmp167_;
				ValaSourceReference* _tmp168_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp166_ = prop;
				_tmp167_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp166_);
				_tmp168_ = _tmp167_;
				vala_report_error (_tmp168_, "NoAccessorMethod is only allowed for properties in classes derived fro" \
"m GLib.Object");
				result = FALSE;
				_vala_code_node_unref0 (prop);
				_vala_iterable_unref0 (_prop_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp169_ = prop;
			vala_code_node_check ((ValaCodeNode*) _tmp169_, context);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp170_;
		gint _sig_size = 0;
		ValaList* _tmp171_;
		gint _tmp172_;
		gint _tmp173_;
		gint _sig_index = 0;
		_tmp170_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
		_sig_list = _tmp170_;
		_tmp171_ = _sig_list;
		_tmp172_ = vala_collection_get_size ((ValaCollection*) _tmp171_);
		_tmp173_ = _tmp172_;
		_sig_size = _tmp173_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp174_;
			gint _tmp175_;
			gint _tmp176_;
			ValaSignal* sig = NULL;
			ValaList* _tmp177_;
			gint _tmp178_;
			gpointer _tmp179_;
			ValaSignal* _tmp180_;
			_tmp174_ = _sig_index;
			_sig_index = _tmp174_ + 1;
			_tmp175_ = _sig_index;
			_tmp176_ = _sig_size;
			if (!(_tmp175_ < _tmp176_)) {
				break;
			}
			_tmp177_ = _sig_list;
			_tmp178_ = _sig_index;
			_tmp179_ = vala_list_get (_tmp177_, _tmp178_);
			sig = (ValaSignal*) _tmp179_;
			_tmp180_ = sig;
			vala_code_node_check ((ValaCodeNode*) _tmp180_, context);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	_tmp181_ = vala_class_get_constructor (self);
	_tmp182_ = _tmp181_;
	if (_tmp182_ != NULL) {
		ValaConstructor* _tmp183_;
		ValaConstructor* _tmp184_;
		_tmp183_ = vala_class_get_constructor (self);
		_tmp184_ = _tmp183_;
		vala_code_node_check ((ValaCodeNode*) _tmp184_, context);
	}
	_tmp185_ = vala_class_get_class_constructor (self);
	_tmp186_ = _tmp185_;
	if (_tmp186_ != NULL) {
		ValaConstructor* _tmp187_;
		ValaConstructor* _tmp188_;
		_tmp187_ = vala_class_get_class_constructor (self);
		_tmp188_ = _tmp187_;
		vala_code_node_check ((ValaCodeNode*) _tmp188_, context);
	}
	_tmp189_ = vala_class_get_static_constructor (self);
	_tmp190_ = _tmp189_;
	if (_tmp190_ != NULL) {
		ValaConstructor* _tmp191_;
		ValaConstructor* _tmp192_;
		_tmp191_ = vala_class_get_static_constructor (self);
		_tmp192_ = _tmp191_;
		vala_code_node_check ((ValaCodeNode*) _tmp192_, context);
	}
	_tmp193_ = vala_class_get_destructor (self);
	_tmp194_ = _tmp193_;
	if (_tmp194_ != NULL) {
		ValaDestructor* _tmp195_;
		ValaDestructor* _tmp196_;
		_tmp195_ = vala_class_get_destructor (self);
		_tmp196_ = _tmp195_;
		vala_code_node_check ((ValaCodeNode*) _tmp196_, context);
	}
	_tmp197_ = vala_class_get_static_destructor (self);
	_tmp198_ = _tmp197_;
	if (_tmp198_ != NULL) {
		ValaDestructor* _tmp199_;
		ValaDestructor* _tmp200_;
		_tmp199_ = vala_class_get_static_destructor (self);
		_tmp200_ = _tmp199_;
		vala_code_node_check ((ValaCodeNode*) _tmp200_, context);
	}
	_tmp201_ = vala_class_get_class_destructor (self);
	_tmp202_ = _tmp201_;
	if (_tmp202_ != NULL) {
		ValaDestructor* _tmp203_;
		ValaDestructor* _tmp204_;
		_tmp203_ = vala_class_get_class_destructor (self);
		_tmp204_ = _tmp203_;
		vala_code_node_check ((ValaCodeNode*) _tmp204_, context);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp205_;
		gint _cl_size = 0;
		ValaList* _tmp206_;
		gint _tmp207_;
		gint _tmp208_;
		gint _cl_index = 0;
		_tmp205_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_cl_list = _tmp205_;
		_tmp206_ = _cl_list;
		_tmp207_ = vala_collection_get_size ((ValaCollection*) _tmp206_);
		_tmp208_ = _tmp207_;
		_cl_size = _tmp208_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp209_;
			gint _tmp210_;
			gint _tmp211_;
			ValaClass* cl = NULL;
			ValaList* _tmp212_;
			gint _tmp213_;
			gpointer _tmp214_;
			ValaClass* _tmp215_;
			_tmp209_ = _cl_index;
			_cl_index = _tmp209_ + 1;
			_tmp210_ = _cl_index;
			_tmp211_ = _cl_size;
			if (!(_tmp210_ < _tmp211_)) {
				break;
			}
			_tmp212_ = _cl_list;
			_tmp213_ = _cl_index;
			_tmp214_ = vala_list_get (_tmp212_, _tmp213_);
			cl = (ValaClass*) _tmp214_;
			_tmp215_ = cl;
			vala_code_node_check ((ValaCodeNode*) _tmp215_, context);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp216_;
		gint _st_size = 0;
		ValaList* _tmp217_;
		gint _tmp218_;
		gint _tmp219_;
		gint _st_index = 0;
		_tmp216_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_st_list = _tmp216_;
		_tmp217_ = _st_list;
		_tmp218_ = vala_collection_get_size ((ValaCollection*) _tmp217_);
		_tmp219_ = _tmp218_;
		_st_size = _tmp219_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp220_;
			gint _tmp221_;
			gint _tmp222_;
			ValaStruct* st = NULL;
			ValaList* _tmp223_;
			gint _tmp224_;
			gpointer _tmp225_;
			ValaStruct* _tmp226_;
			_tmp220_ = _st_index;
			_st_index = _tmp220_ + 1;
			_tmp221_ = _st_index;
			_tmp222_ = _st_size;
			if (!(_tmp221_ < _tmp222_)) {
				break;
			}
			_tmp223_ = _st_list;
			_tmp224_ = _st_index;
			_tmp225_ = vala_list_get (_tmp223_, _tmp224_);
			st = (ValaStruct*) _tmp225_;
			_tmp226_ = st;
			vala_code_node_check ((ValaCodeNode*) _tmp226_, context);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp227_;
		gint _d_size = 0;
		ValaList* _tmp228_;
		gint _tmp229_;
		gint _tmp230_;
		gint _d_index = 0;
		_tmp227_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_d_list = _tmp227_;
		_tmp228_ = _d_list;
		_tmp229_ = vala_collection_get_size ((ValaCollection*) _tmp228_);
		_tmp230_ = _tmp229_;
		_d_size = _tmp230_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp231_;
			gint _tmp232_;
			gint _tmp233_;
			ValaDelegate* d = NULL;
			ValaList* _tmp234_;
			gint _tmp235_;
			gpointer _tmp236_;
			ValaDelegate* _tmp237_;
			_tmp231_ = _d_index;
			_d_index = _tmp231_ + 1;
			_tmp232_ = _d_index;
			_tmp233_ = _d_size;
			if (!(_tmp232_ < _tmp233_)) {
				break;
			}
			_tmp234_ = _d_list;
			_tmp235_ = _d_index;
			_tmp236_ = vala_list_get (_tmp234_, _tmp235_);
			d = (ValaDelegate*) _tmp236_;
			_tmp237_ = d;
			vala_code_node_check ((ValaCodeNode*) _tmp237_, context);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
	_tmp238_ = vala_class_get_is_compact (self);
	_tmp239_ = _tmp238_;
	if (_tmp239_) {
		gboolean _tmp259_ = FALSE;
		gboolean _tmp260_ = FALSE;
		gboolean _tmp261_ = FALSE;
		gboolean _tmp262_;
		gboolean _tmp263_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp240_;
			gint _base_type_size = 0;
			ValaList* _tmp241_;
			gint _tmp242_;
			gint _tmp243_;
			gint _base_type_index = 0;
			_tmp240_ = vala_class_get_base_types (self);
			_base_type_list = _tmp240_;
			_tmp241_ = _base_type_list;
			_tmp242_ = vala_collection_get_size ((ValaCollection*) _tmp241_);
			_tmp243_ = _tmp242_;
			_base_type_size = _tmp243_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp244_;
				gint _tmp245_;
				gint _tmp246_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp247_;
				gint _tmp248_;
				gpointer _tmp249_;
				ValaDataType* _tmp250_;
				ValaTypeSymbol* _tmp251_;
				ValaTypeSymbol* _tmp252_;
				_tmp244_ = _base_type_index;
				_base_type_index = _tmp244_ + 1;
				_tmp245_ = _base_type_index;
				_tmp246_ = _base_type_size;
				if (!(_tmp245_ < _tmp246_)) {
					break;
				}
				_tmp247_ = _base_type_list;
				_tmp248_ = _base_type_index;
				_tmp249_ = vala_list_get (_tmp247_, _tmp248_);
				base_type = (ValaDataType*) _tmp249_;
				_tmp250_ = base_type;
				_tmp251_ = vala_data_type_get_data_type (_tmp250_);
				_tmp252_ = _tmp251_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp252_, VALA_TYPE_INTERFACE)) {
					ValaSourceReference* _tmp253_;
					ValaSourceReference* _tmp254_;
					gchar* _tmp255_;
					gchar* _tmp256_;
					gchar* _tmp257_;
					gchar* _tmp258_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp253_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp254_ = _tmp253_;
					_tmp255_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp256_ = _tmp255_;
					_tmp257_ = g_strdup_printf ("compact classes `%s` may not implement interfaces", _tmp256_);
					_tmp258_ = _tmp257_;
					vala_report_error (_tmp254_, _tmp258_);
					_g_free0 (_tmp258_);
					_g_free0 (_tmp256_);
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		_tmp262_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp263_ = _tmp262_;
		if (!_tmp263_) {
			gboolean _tmp264_;
			gboolean _tmp265_;
			_tmp264_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp265_ = _tmp264_;
			_tmp261_ = !_tmp265_;
		} else {
			_tmp261_ = FALSE;
		}
		if (_tmp261_) {
			ValaClass* _tmp266_;
			_tmp266_ = self->priv->_base_class;
			_tmp260_ = _tmp266_ != NULL;
		} else {
			_tmp260_ = FALSE;
		}
		if (_tmp260_) {
			ValaClass* _tmp267_;
			ValaSemanticAnalyzer* _tmp268_;
			ValaSemanticAnalyzer* _tmp269_;
			ValaClass* _tmp270_;
			_tmp267_ = self->priv->_base_class;
			_tmp268_ = vala_code_context_get_analyzer (context);
			_tmp269_ = _tmp268_;
			_tmp270_ = _tmp269_->gsource_type;
			_tmp259_ = _tmp267_ != _tmp270_;
		} else {
			_tmp259_ = FALSE;
		}
		if (_tmp259_) {
			{
				ValaList* _f_list = NULL;
				ValaList* _tmp271_;
				gint _f_size = 0;
				ValaList* _tmp272_;
				gint _tmp273_;
				gint _tmp274_;
				gint _f_index = 0;
				_tmp271_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
				_f_list = _tmp271_;
				_tmp272_ = _f_list;
				_tmp273_ = vala_collection_get_size ((ValaCollection*) _tmp272_);
				_tmp274_ = _tmp273_;
				_f_size = _tmp274_;
				_f_index = -1;
				while (TRUE) {
					gint _tmp275_;
					gint _tmp276_;
					gint _tmp277_;
					ValaField* f = NULL;
					ValaList* _tmp278_;
					gint _tmp279_;
					gpointer _tmp280_;
					ValaField* _tmp281_;
					ValaMemberBinding _tmp282_;
					ValaMemberBinding _tmp283_;
					_tmp275_ = _f_index;
					_f_index = _tmp275_ + 1;
					_tmp276_ = _f_index;
					_tmp277_ = _f_size;
					if (!(_tmp276_ < _tmp277_)) {
						break;
					}
					_tmp278_ = _f_list;
					_tmp279_ = _f_index;
					_tmp280_ = vala_list_get (_tmp278_, _tmp279_);
					f = (ValaField*) _tmp280_;
					_tmp281_ = f;
					_tmp282_ = vala_field_get_binding (_tmp281_);
					_tmp283_ = _tmp282_;
					if (_tmp283_ == VALA_MEMBER_BINDING_INSTANCE) {
						ValaSourceReference* _tmp284_;
						ValaSourceReference* _tmp285_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp284_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp285_ = _tmp284_;
						vala_report_error (_tmp285_, "derived compact classes may not have instance fields");
						_vala_code_node_unref0 (f);
						break;
					}
					_vala_code_node_unref0 (f);
				}
				_vala_iterable_unref0 (_f_list);
			}
		}
	}
	_tmp286_ = g_direct_equal;
	_tmp287_ = vala_array_list_new (VALA_TYPE_TYPESYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp286_);
	prerequisites = (ValaList*) _tmp287_;
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp288_;
		gint _base_type_size = 0;
		ValaList* _tmp289_;
		gint _tmp290_;
		gint _tmp291_;
		gint _base_type_index = 0;
		_tmp288_ = vala_class_get_base_types (self);
		_base_type_list = _tmp288_;
		_tmp289_ = _base_type_list;
		_tmp290_ = vala_collection_get_size ((ValaCollection*) _tmp289_);
		_tmp291_ = _tmp290_;
		_base_type_size = _tmp291_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp292_;
			gint _tmp293_;
			gint _tmp294_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp295_;
			gint _tmp296_;
			gpointer _tmp297_;
			ValaDataType* _tmp298_;
			ValaTypeSymbol* _tmp299_;
			ValaTypeSymbol* _tmp300_;
			_tmp292_ = _base_type_index;
			_base_type_index = _tmp292_ + 1;
			_tmp293_ = _base_type_index;
			_tmp294_ = _base_type_size;
			if (!(_tmp293_ < _tmp294_)) {
				break;
			}
			_tmp295_ = _base_type_list;
			_tmp296_ = _base_type_index;
			_tmp297_ = vala_list_get (_tmp295_, _tmp296_);
			base_type = (ValaDataType*) _tmp297_;
			_tmp298_ = base_type;
			_tmp299_ = vala_data_type_get_data_type (_tmp298_);
			_tmp300_ = _tmp299_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp300_, VALA_TYPE_INTERFACE)) {
				ValaDataType* _tmp301_;
				ValaTypeSymbol* _tmp302_;
				ValaTypeSymbol* _tmp303_;
				ValaList* _tmp304_;
				_tmp301_ = base_type;
				_tmp302_ = vala_data_type_get_data_type (_tmp301_);
				_tmp303_ = _tmp302_;
				_tmp304_ = prerequisites;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp303_, VALA_TYPE_INTERFACE, ValaInterface), _tmp304_);
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	_tmp305_ = g_direct_equal;
	_tmp306_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp305_);
	missing_prereqs = (ValaList*) _tmp306_;
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp307_;
		ValaList* _tmp308_;
		gint _prereq_size = 0;
		ValaList* _tmp309_;
		gint _tmp310_;
		gint _tmp311_;
		gint _prereq_index = 0;
		_tmp307_ = prerequisites;
		_tmp308_ = _vala_iterable_ref0 (_tmp307_);
		_prereq_list = _tmp308_;
		_tmp309_ = _prereq_list;
		_tmp310_ = vala_collection_get_size ((ValaCollection*) _tmp309_);
		_tmp311_ = _tmp310_;
		_prereq_size = _tmp311_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp312_;
			gint _tmp313_;
			gint _tmp314_;
			ValaTypeSymbol* prereq = NULL;
			ValaList* _tmp315_;
			gint _tmp316_;
			gpointer _tmp317_;
			ValaTypeSymbol* _tmp318_;
			_tmp312_ = _prereq_index;
			_prereq_index = _tmp312_ + 1;
			_tmp313_ = _prereq_index;
			_tmp314_ = _prereq_size;
			if (!(_tmp313_ < _tmp314_)) {
				break;
			}
			_tmp315_ = _prereq_list;
			_tmp316_ = _prereq_index;
			_tmp317_ = vala_list_get (_tmp315_, _tmp316_);
			prereq = (ValaTypeSymbol*) _tmp317_;
			_tmp318_ = prereq;
			if (!vala_class_class_is_a (self, self, _tmp318_)) {
				ValaList* _tmp319_;
				ValaTypeSymbol* _tmp320_;
				gchar* _tmp321_;
				gchar* _tmp322_;
				_tmp319_ = missing_prereqs;
				_tmp320_ = prereq;
				_tmp321_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp320_);
				_tmp322_ = _tmp321_;
				vala_list_insert (_tmp319_, 0, _tmp322_);
				_g_free0 (_tmp322_);
			}
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
	_tmp323_ = missing_prereqs;
	_tmp324_ = vala_collection_get_size ((ValaCollection*) _tmp323_);
	_tmp325_ = _tmp324_;
	if (_tmp325_ > 0) {
		gchar* error_string = NULL;
		gchar* _tmp326_;
		gchar* _tmp327_;
		gchar* _tmp328_;
		gchar* _tmp329_;
		gboolean first = FALSE;
		const gchar* _tmp348_;
		gchar* _tmp349_;
		ValaSourceReference* _tmp350_;
		ValaSourceReference* _tmp351_;
		const gchar* _tmp352_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp326_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp327_ = _tmp326_;
		_tmp328_ = g_strdup_printf ("%s: some prerequisites (", _tmp327_);
		_tmp329_ = _tmp328_;
		_g_free0 (_tmp327_);
		error_string = _tmp329_;
		first = TRUE;
		{
			ValaList* _s_list = NULL;
			ValaList* _tmp330_;
			ValaList* _tmp331_;
			gint _s_size = 0;
			ValaList* _tmp332_;
			gint _tmp333_;
			gint _tmp334_;
			gint _s_index = 0;
			_tmp330_ = missing_prereqs;
			_tmp331_ = _vala_iterable_ref0 (_tmp330_);
			_s_list = _tmp331_;
			_tmp332_ = _s_list;
			_tmp333_ = vala_collection_get_size ((ValaCollection*) _tmp332_);
			_tmp334_ = _tmp333_;
			_s_size = _tmp334_;
			_s_index = -1;
			while (TRUE) {
				gint _tmp335_;
				gint _tmp336_;
				gint _tmp337_;
				gchar* s = NULL;
				ValaList* _tmp338_;
				gint _tmp339_;
				gpointer _tmp340_;
				gboolean _tmp341_;
				_tmp335_ = _s_index;
				_s_index = _tmp335_ + 1;
				_tmp336_ = _s_index;
				_tmp337_ = _s_size;
				if (!(_tmp336_ < _tmp337_)) {
					break;
				}
				_tmp338_ = _s_list;
				_tmp339_ = _s_index;
				_tmp340_ = vala_list_get (_tmp338_, _tmp339_);
				s = (gchar*) _tmp340_;
				_tmp341_ = first;
				if (_tmp341_) {
					const gchar* _tmp342_;
					const gchar* _tmp343_;
					gchar* _tmp344_;
					_tmp342_ = error_string;
					_tmp343_ = s;
					_tmp344_ = g_strdup_printf ("%s`%s'", _tmp342_, _tmp343_);
					_g_free0 (error_string);
					error_string = _tmp344_;
					first = FALSE;
				} else {
					const gchar* _tmp345_;
					const gchar* _tmp346_;
					gchar* _tmp347_;
					_tmp345_ = error_string;
					_tmp346_ = s;
					_tmp347_ = g_strdup_printf ("%s, `%s'", _tmp345_, _tmp346_);
					_g_free0 (error_string);
					error_string = _tmp347_;
				}
				_g_free0 (s);
			}
			_vala_iterable_unref0 (_s_list);
		}
		_tmp348_ = error_string;
		_tmp349_ = g_strconcat (_tmp348_, ") are not met", NULL);
		_g_free0 (error_string);
		error_string = _tmp349_;
		_tmp350_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp351_ = _tmp350_;
		_tmp352_ = error_string;
		vala_report_error (_tmp351_, _tmp352_);
		_g_free0 (error_string);
	}
	_tmp353_ = vala_symbol_get_source_type ((ValaSymbol*) self);
	_tmp354_ = _tmp353_;
	if (_tmp354_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
		gboolean _tmp504_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp355_;
			gint _base_type_size = 0;
			ValaList* _tmp356_;
			gint _tmp357_;
			gint _tmp358_;
			gint _base_type_index = 0;
			_tmp355_ = vala_class_get_base_types (self);
			_base_type_list = _tmp355_;
			_tmp356_ = _base_type_list;
			_tmp357_ = vala_collection_get_size ((ValaCollection*) _tmp356_);
			_tmp358_ = _tmp357_;
			_base_type_size = _tmp358_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp359_;
				gint _tmp360_;
				gint _tmp361_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp362_;
				gint _tmp363_;
				gpointer _tmp364_;
				ValaDataType* _tmp365_;
				ValaTypeSymbol* _tmp366_;
				ValaTypeSymbol* _tmp367_;
				_tmp359_ = _base_type_index;
				_base_type_index = _tmp359_ + 1;
				_tmp360_ = _base_type_index;
				_tmp361_ = _base_type_size;
				if (!(_tmp360_ < _tmp361_)) {
					break;
				}
				_tmp362_ = _base_type_list;
				_tmp363_ = _base_type_index;
				_tmp364_ = vala_list_get (_tmp362_, _tmp363_);
				base_type = (ValaDataType*) _tmp364_;
				_tmp365_ = base_type;
				_tmp366_ = vala_data_type_get_data_type (_tmp365_);
				_tmp367_ = _tmp366_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp367_, VALA_TYPE_INTERFACE)) {
					ValaInterface* iface = NULL;
					ValaDataType* _tmp368_;
					ValaTypeSymbol* _tmp369_;
					ValaTypeSymbol* _tmp370_;
					ValaInterface* _tmp371_;
					gboolean _tmp372_ = FALSE;
					ValaClass* _tmp373_;
					_tmp368_ = base_type;
					_tmp369_ = vala_data_type_get_data_type (_tmp368_);
					_tmp370_ = _tmp369_;
					_tmp371_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp370_, VALA_TYPE_INTERFACE, ValaInterface));
					iface = _tmp371_;
					_tmp373_ = self->priv->_base_class;
					if (_tmp373_ != NULL) {
						ValaClass* _tmp374_;
						ValaInterface* _tmp375_;
						_tmp374_ = self->priv->_base_class;
						_tmp375_ = iface;
						_tmp372_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp374_, (ValaTypeSymbol*) _tmp375_);
					} else {
						_tmp372_ = FALSE;
					}
					if (_tmp372_) {
						_vala_code_node_unref0 (iface);
						_vala_code_node_unref0 (base_type);
						break;
					}
					{
						ValaList* _m_list = NULL;
						ValaInterface* _tmp376_;
						ValaList* _tmp377_;
						gint _m_size = 0;
						ValaList* _tmp378_;
						gint _tmp379_;
						gint _tmp380_;
						gint _m_index = 0;
						_tmp376_ = iface;
						_tmp377_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp376_);
						_m_list = _tmp377_;
						_tmp378_ = _m_list;
						_tmp379_ = vala_collection_get_size ((ValaCollection*) _tmp378_);
						_tmp380_ = _tmp379_;
						_m_size = _tmp380_;
						_m_index = -1;
						while (TRUE) {
							gint _tmp381_;
							gint _tmp382_;
							gint _tmp383_;
							ValaMethod* m = NULL;
							ValaList* _tmp384_;
							gint _tmp385_;
							gpointer _tmp386_;
							ValaMethod* _tmp387_;
							gboolean _tmp388_;
							gboolean _tmp389_;
							_tmp381_ = _m_index;
							_m_index = _tmp381_ + 1;
							_tmp382_ = _m_index;
							_tmp383_ = _m_size;
							if (!(_tmp382_ < _tmp383_)) {
								break;
							}
							_tmp384_ = _m_list;
							_tmp385_ = _m_index;
							_tmp386_ = vala_list_get (_tmp384_, _tmp385_);
							m = (ValaMethod*) _tmp386_;
							_tmp387_ = m;
							_tmp388_ = vala_method_get_is_abstract (_tmp387_);
							_tmp389_ = _tmp388_;
							if (_tmp389_) {
								gboolean implemented = FALSE;
								ValaClass* base_class = NULL;
								ValaClass* _tmp390_;
								gboolean _tmp429_;
								implemented = FALSE;
								_tmp390_ = _vala_code_node_ref0 (self);
								base_class = _tmp390_;
								while (TRUE) {
									ValaClass* _tmp391_;
									ValaClass* _tmp426_;
									ValaClass* _tmp427_;
									ValaClass* _tmp428_;
									_tmp391_ = base_class;
									if (!(_tmp391_ != NULL)) {
										break;
									}
									{
										ValaList* _impl_list = NULL;
										ValaClass* _tmp392_;
										ValaList* _tmp393_;
										gint _impl_size = 0;
										ValaList* _tmp394_;
										gint _tmp395_;
										gint _tmp396_;
										gint _impl_index = 0;
										_tmp392_ = base_class;
										_tmp393_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp392_);
										_impl_list = _tmp393_;
										_tmp394_ = _impl_list;
										_tmp395_ = vala_collection_get_size ((ValaCollection*) _tmp394_);
										_tmp396_ = _tmp395_;
										_impl_size = _tmp396_;
										_impl_index = -1;
										while (TRUE) {
											gint _tmp397_;
											gint _tmp398_;
											gint _tmp399_;
											ValaMethod* impl = NULL;
											ValaList* _tmp400_;
											gint _tmp401_;
											gpointer _tmp402_;
											gboolean _tmp403_ = FALSE;
											ValaMethod* _tmp404_;
											const gchar* _tmp405_;
											const gchar* _tmp406_;
											ValaMethod* _tmp407_;
											const gchar* _tmp408_;
											const gchar* _tmp409_;
											_tmp397_ = _impl_index;
											_impl_index = _tmp397_ + 1;
											_tmp398_ = _impl_index;
											_tmp399_ = _impl_size;
											if (!(_tmp398_ < _tmp399_)) {
												break;
											}
											_tmp400_ = _impl_list;
											_tmp401_ = _impl_index;
											_tmp402_ = vala_list_get (_tmp400_, _tmp401_);
											impl = (ValaMethod*) _tmp402_;
											_tmp404_ = impl;
											_tmp405_ = vala_symbol_get_name ((ValaSymbol*) _tmp404_);
											_tmp406_ = _tmp405_;
											_tmp407_ = m;
											_tmp408_ = vala_symbol_get_name ((ValaSymbol*) _tmp407_);
											_tmp409_ = _tmp408_;
											if (g_strcmp0 (_tmp406_, _tmp409_) == 0) {
												gboolean _tmp410_ = FALSE;
												ValaMethod* _tmp411_;
												ValaDataType* _tmp412_;
												ValaDataType* _tmp413_;
												_tmp411_ = impl;
												_tmp412_ = vala_method_get_base_interface_type (_tmp411_);
												_tmp413_ = _tmp412_;
												if (_tmp413_ == NULL) {
													_tmp410_ = TRUE;
												} else {
													ValaMethod* _tmp414_;
													ValaDataType* _tmp415_;
													ValaDataType* _tmp416_;
													ValaTypeSymbol* _tmp417_;
													ValaTypeSymbol* _tmp418_;
													ValaInterface* _tmp419_;
													_tmp414_ = impl;
													_tmp415_ = vala_method_get_base_interface_type (_tmp414_);
													_tmp416_ = _tmp415_;
													_tmp417_ = vala_data_type_get_data_type (_tmp416_);
													_tmp418_ = _tmp417_;
													_tmp419_ = iface;
													_tmp410_ = _tmp418_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp419_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
												}
												_tmp403_ = _tmp410_;
											} else {
												_tmp403_ = FALSE;
											}
											if (_tmp403_) {
												ValaMethod* _tmp420_;
												ValaVersionAttribute* _tmp421_;
												ValaVersionAttribute* _tmp422_;
												ValaSourceReference* _tmp423_;
												ValaSourceReference* _tmp424_;
												ValaMethod* _tmp425_;
												_tmp420_ = impl;
												_tmp421_ = vala_symbol_get_version ((ValaSymbol*) _tmp420_);
												_tmp422_ = _tmp421_;
												_tmp423_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp424_ = _tmp423_;
												vala_version_attribute_check (_tmp422_, _tmp424_);
												_tmp425_ = impl;
												vala_symbol_set_used ((ValaSymbol*) _tmp425_, TRUE);
												implemented = TRUE;
												_vala_code_node_unref0 (impl);
												break;
											}
											_vala_code_node_unref0 (impl);
										}
										_vala_iterable_unref0 (_impl_list);
									}
									_tmp426_ = base_class;
									_tmp427_ = _tmp426_->priv->_base_class;
									_tmp428_ = _vala_code_node_ref0 (_tmp427_);
									_vala_code_node_unref0 (base_class);
									base_class = _tmp428_;
								}
								_tmp429_ = implemented;
								if (!_tmp429_) {
									ValaSourceReference* _tmp430_;
									ValaSourceReference* _tmp431_;
									gchar* _tmp432_;
									gchar* _tmp433_;
									ValaMethod* _tmp434_;
									gchar* _tmp435_;
									gchar* _tmp436_;
									gchar* _tmp437_;
									gchar* _tmp438_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp430_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp431_ = _tmp430_;
									_tmp432_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp433_ = _tmp432_;
									_tmp434_ = m;
									_tmp435_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp434_);
									_tmp436_ = _tmp435_;
									_tmp437_ = g_strdup_printf ("`%s' does not implement interface method `%s'", _tmp433_, _tmp436_);
									_tmp438_ = _tmp437_;
									vala_report_error (_tmp431_, _tmp438_);
									_g_free0 (_tmp438_);
									_g_free0 (_tmp436_);
									_g_free0 (_tmp433_);
								}
								_vala_code_node_unref0 (base_class);
							}
							_vala_code_node_unref0 (m);
						}
						_vala_iterable_unref0 (_m_list);
					}
					{
						ValaList* _prop_list = NULL;
						ValaInterface* _tmp439_;
						ValaList* _tmp440_;
						gint _prop_size = 0;
						ValaList* _tmp441_;
						gint _tmp442_;
						gint _tmp443_;
						gint _prop_index = 0;
						_tmp439_ = iface;
						_tmp440_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp439_);
						_prop_list = _tmp440_;
						_tmp441_ = _prop_list;
						_tmp442_ = vala_collection_get_size ((ValaCollection*) _tmp441_);
						_tmp443_ = _tmp442_;
						_prop_size = _tmp443_;
						_prop_index = -1;
						while (TRUE) {
							gint _tmp444_;
							gint _tmp445_;
							gint _tmp446_;
							ValaProperty* prop = NULL;
							ValaList* _tmp447_;
							gint _tmp448_;
							gpointer _tmp449_;
							ValaProperty* _tmp450_;
							gboolean _tmp451_;
							gboolean _tmp452_;
							_tmp444_ = _prop_index;
							_prop_index = _tmp444_ + 1;
							_tmp445_ = _prop_index;
							_tmp446_ = _prop_size;
							if (!(_tmp445_ < _tmp446_)) {
								break;
							}
							_tmp447_ = _prop_list;
							_tmp448_ = _prop_index;
							_tmp449_ = vala_list_get (_tmp447_, _tmp448_);
							prop = (ValaProperty*) _tmp449_;
							_tmp450_ = prop;
							_tmp451_ = vala_property_get_is_abstract (_tmp450_);
							_tmp452_ = _tmp451_;
							if (_tmp452_) {
								ValaSymbol* sym = NULL;
								ValaClass* base_class = NULL;
								ValaClass* _tmp453_;
								ValaSymbol* _tmp467_;
								sym = NULL;
								_tmp453_ = _vala_code_node_ref0 (self);
								base_class = _tmp453_;
								while (TRUE) {
									gboolean _tmp454_ = FALSE;
									ValaClass* _tmp455_;
									ValaClass* _tmp457_;
									ValaScope* _tmp458_;
									ValaScope* _tmp459_;
									ValaProperty* _tmp460_;
									const gchar* _tmp461_;
									const gchar* _tmp462_;
									ValaSymbol* _tmp463_;
									ValaClass* _tmp464_;
									ValaClass* _tmp465_;
									ValaClass* _tmp466_;
									_tmp455_ = base_class;
									if (_tmp455_ != NULL) {
										ValaSymbol* _tmp456_;
										_tmp456_ = sym;
										_tmp454_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp456_, VALA_TYPE_PROPERTY);
									} else {
										_tmp454_ = FALSE;
									}
									if (!_tmp454_) {
										break;
									}
									_tmp457_ = base_class;
									_tmp458_ = vala_symbol_get_scope ((ValaSymbol*) _tmp457_);
									_tmp459_ = _tmp458_;
									_tmp460_ = prop;
									_tmp461_ = vala_symbol_get_name ((ValaSymbol*) _tmp460_);
									_tmp462_ = _tmp461_;
									_tmp463_ = vala_scope_lookup (_tmp459_, _tmp462_);
									_vala_code_node_unref0 (sym);
									sym = _tmp463_;
									_tmp464_ = base_class;
									_tmp465_ = _tmp464_->priv->_base_class;
									_tmp466_ = _vala_code_node_ref0 (_tmp465_);
									_vala_code_node_unref0 (base_class);
									base_class = _tmp466_;
								}
								_tmp467_ = sym;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp467_, VALA_TYPE_PROPERTY)) {
									ValaProperty* base_prop = NULL;
									ValaSymbol* _tmp468_;
									ValaProperty* _tmp469_;
									gchar* invalid_match = NULL;
									gboolean _tmp470_ = FALSE;
									ValaProperty* _tmp471_;
									gboolean _tmp472_;
									gboolean _tmp473_;
									ValaSymbol* _tmp489_;
									ValaVersionAttribute* _tmp490_;
									ValaVersionAttribute* _tmp491_;
									ValaSourceReference* _tmp492_;
									ValaSourceReference* _tmp493_;
									ValaSymbol* _tmp494_;
									_tmp468_ = sym;
									_tmp469_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp468_, VALA_TYPE_PROPERTY, ValaProperty));
									base_prop = _tmp469_;
									invalid_match = NULL;
									_tmp471_ = base_prop;
									_tmp472_ = vala_symbol_get_hides ((ValaSymbol*) _tmp471_);
									_tmp473_ = _tmp472_;
									if (!_tmp473_) {
										ValaProperty* _tmp474_;
										ValaProperty* _tmp475_;
										gchar* _tmp476_ = NULL;
										gboolean _tmp477_;
										_tmp474_ = base_prop;
										_tmp475_ = prop;
										_tmp477_ = vala_property_compatible (_tmp474_, _tmp475_, &_tmp476_);
										_g_free0 (invalid_match);
										invalid_match = _tmp476_;
										_tmp470_ = !_tmp477_;
									} else {
										_tmp470_ = FALSE;
									}
									if (_tmp470_) {
										ValaSourceReference* _tmp478_;
										ValaSourceReference* _tmp479_;
										ValaProperty* _tmp480_;
										gchar* _tmp481_;
										gchar* _tmp482_;
										ValaProperty* _tmp483_;
										gchar* _tmp484_;
										gchar* _tmp485_;
										const gchar* _tmp486_;
										gchar* _tmp487_;
										gchar* _tmp488_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp478_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
										_tmp479_ = _tmp478_;
										_tmp480_ = prop;
										_tmp481_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp480_);
										_tmp482_ = _tmp481_;
										_tmp483_ = base_prop;
										_tmp484_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp483_);
										_tmp485_ = _tmp484_;
										_tmp486_ = invalid_match;
										_tmp487_ = g_strdup_printf ("Type and/or accessors of inherited properties `%s' and `%s' do not mat" \
"ch: %s.", _tmp482_, _tmp485_, _tmp486_);
										_tmp488_ = _tmp487_;
										vala_report_error (_tmp479_, _tmp488_);
										_g_free0 (_tmp488_);
										_g_free0 (_tmp485_);
										_g_free0 (_tmp482_);
									}
									_tmp489_ = sym;
									_tmp490_ = vala_symbol_get_version (_tmp489_);
									_tmp491_ = _tmp490_;
									_tmp492_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp493_ = _tmp492_;
									vala_version_attribute_check (_tmp491_, _tmp493_);
									_tmp494_ = sym;
									vala_symbol_set_used (_tmp494_, TRUE);
									_g_free0 (invalid_match);
									_vala_code_node_unref0 (base_prop);
								} else {
									ValaSourceReference* _tmp495_;
									ValaSourceReference* _tmp496_;
									gchar* _tmp497_;
									gchar* _tmp498_;
									ValaProperty* _tmp499_;
									gchar* _tmp500_;
									gchar* _tmp501_;
									gchar* _tmp502_;
									gchar* _tmp503_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp495_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp496_ = _tmp495_;
									_tmp497_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp498_ = _tmp497_;
									_tmp499_ = prop;
									_tmp500_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp499_);
									_tmp501_ = _tmp500_;
									_tmp502_ = g_strdup_printf ("`%s' does not implement interface property `%s'", _tmp498_, _tmp501_);
									_tmp503_ = _tmp502_;
									vala_report_error (_tmp496_, _tmp503_);
									_g_free0 (_tmp503_);
									_g_free0 (_tmp501_);
									_g_free0 (_tmp498_);
								}
								_vala_code_node_unref0 (base_class);
								_vala_code_node_unref0 (sym);
							}
							_vala_code_node_unref0 (prop);
						}
						_vala_iterable_unref0 (_prop_list);
					}
					_vala_code_node_unref0 (iface);
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		_tmp504_ = self->priv->_is_abstract;
		if (!_tmp504_) {
			ValaClass* base_class = NULL;
			ValaClass* _tmp505_;
			ValaClass* _tmp506_;
			_tmp505_ = self->priv->_base_class;
			_tmp506_ = _vala_code_node_ref0 (_tmp505_);
			base_class = _tmp506_;
			while (TRUE) {
				gboolean _tmp507_ = FALSE;
				ValaClass* _tmp508_;
				ValaClass* _tmp577_;
				ValaClass* _tmp578_;
				ValaClass* _tmp579_;
				_tmp508_ = base_class;
				if (_tmp508_ != NULL) {
					ValaClass* _tmp509_;
					gboolean _tmp510_;
					_tmp509_ = base_class;
					_tmp510_ = _tmp509_->priv->_is_abstract;
					_tmp507_ = _tmp510_;
				} else {
					_tmp507_ = FALSE;
				}
				if (!_tmp507_) {
					break;
				}
				{
					ValaList* _base_method_list = NULL;
					ValaClass* _tmp511_;
					ValaList* _tmp512_;
					gint _base_method_size = 0;
					ValaList* _tmp513_;
					gint _tmp514_;
					gint _tmp515_;
					gint _base_method_index = 0;
					_tmp511_ = base_class;
					_tmp512_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp511_);
					_base_method_list = _tmp512_;
					_tmp513_ = _base_method_list;
					_tmp514_ = vala_collection_get_size ((ValaCollection*) _tmp513_);
					_tmp515_ = _tmp514_;
					_base_method_size = _tmp515_;
					_base_method_index = -1;
					while (TRUE) {
						gint _tmp516_;
						gint _tmp517_;
						gint _tmp518_;
						ValaMethod* base_method = NULL;
						ValaList* _tmp519_;
						gint _tmp520_;
						gpointer _tmp521_;
						ValaMethod* _tmp522_;
						gboolean _tmp523_;
						gboolean _tmp524_;
						_tmp516_ = _base_method_index;
						_base_method_index = _tmp516_ + 1;
						_tmp517_ = _base_method_index;
						_tmp518_ = _base_method_size;
						if (!(_tmp517_ < _tmp518_)) {
							break;
						}
						_tmp519_ = _base_method_list;
						_tmp520_ = _base_method_index;
						_tmp521_ = vala_list_get (_tmp519_, _tmp520_);
						base_method = (ValaMethod*) _tmp521_;
						_tmp522_ = base_method;
						_tmp523_ = vala_method_get_is_abstract (_tmp522_);
						_tmp524_ = _tmp523_;
						if (_tmp524_) {
							ValaMethod* override_method = NULL;
							ValaMethod* _tmp525_;
							const gchar* _tmp526_;
							const gchar* _tmp527_;
							ValaSymbol* _tmp528_;
							ValaMethod* _tmp529_;
							gboolean _tmp530_ = FALSE;
							ValaMethod* _tmp531_;
							_tmp525_ = base_method;
							_tmp526_ = vala_symbol_get_name ((ValaSymbol*) _tmp525_);
							_tmp527_ = _tmp526_;
							_tmp528_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp527_);
							_tmp529_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp528_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp528_) : NULL;
							if (_tmp529_ == NULL) {
								_vala_code_node_unref0 (_tmp528_);
							}
							override_method = _tmp529_;
							_tmp531_ = override_method;
							if (_tmp531_ == NULL) {
								_tmp530_ = TRUE;
							} else {
								ValaMethod* _tmp532_;
								gboolean _tmp533_;
								gboolean _tmp534_;
								_tmp532_ = override_method;
								_tmp533_ = vala_method_get_overrides (_tmp532_);
								_tmp534_ = _tmp533_;
								_tmp530_ = !_tmp534_;
							}
							if (_tmp530_) {
								ValaSourceReference* _tmp535_;
								ValaSourceReference* _tmp536_;
								gchar* _tmp537_;
								gchar* _tmp538_;
								ValaMethod* _tmp539_;
								gchar* _tmp540_;
								gchar* _tmp541_;
								gchar* _tmp542_;
								gchar* _tmp543_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp535_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp536_ = _tmp535_;
								_tmp537_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp538_ = _tmp537_;
								_tmp539_ = base_method;
								_tmp540_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp539_);
								_tmp541_ = _tmp540_;
								_tmp542_ = g_strdup_printf ("`%s' does not implement abstract method `%s'", _tmp538_, _tmp541_);
								_tmp543_ = _tmp542_;
								vala_report_error (_tmp536_, _tmp543_);
								_g_free0 (_tmp543_);
								_g_free0 (_tmp541_);
								_g_free0 (_tmp538_);
							}
							_vala_code_node_unref0 (override_method);
						}
						_vala_code_node_unref0 (base_method);
					}
					_vala_iterable_unref0 (_base_method_list);
				}
				{
					ValaList* _base_property_list = NULL;
					ValaClass* _tmp544_;
					ValaList* _tmp545_;
					gint _base_property_size = 0;
					ValaList* _tmp546_;
					gint _tmp547_;
					gint _tmp548_;
					gint _base_property_index = 0;
					_tmp544_ = base_class;
					_tmp545_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp544_);
					_base_property_list = _tmp545_;
					_tmp546_ = _base_property_list;
					_tmp547_ = vala_collection_get_size ((ValaCollection*) _tmp546_);
					_tmp548_ = _tmp547_;
					_base_property_size = _tmp548_;
					_base_property_index = -1;
					while (TRUE) {
						gint _tmp549_;
						gint _tmp550_;
						gint _tmp551_;
						ValaProperty* base_property = NULL;
						ValaList* _tmp552_;
						gint _tmp553_;
						gpointer _tmp554_;
						ValaProperty* _tmp555_;
						gboolean _tmp556_;
						gboolean _tmp557_;
						_tmp549_ = _base_property_index;
						_base_property_index = _tmp549_ + 1;
						_tmp550_ = _base_property_index;
						_tmp551_ = _base_property_size;
						if (!(_tmp550_ < _tmp551_)) {
							break;
						}
						_tmp552_ = _base_property_list;
						_tmp553_ = _base_property_index;
						_tmp554_ = vala_list_get (_tmp552_, _tmp553_);
						base_property = (ValaProperty*) _tmp554_;
						_tmp555_ = base_property;
						_tmp556_ = vala_property_get_is_abstract (_tmp555_);
						_tmp557_ = _tmp556_;
						if (_tmp557_) {
							ValaProperty* override_property = NULL;
							ValaProperty* _tmp558_;
							const gchar* _tmp559_;
							const gchar* _tmp560_;
							ValaSymbol* _tmp561_;
							ValaProperty* _tmp562_;
							gboolean _tmp563_ = FALSE;
							ValaProperty* _tmp564_;
							_tmp558_ = base_property;
							_tmp559_ = vala_symbol_get_name ((ValaSymbol*) _tmp558_);
							_tmp560_ = _tmp559_;
							_tmp561_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp560_);
							_tmp562_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp561_, VALA_TYPE_PROPERTY) ? ((ValaProperty*) _tmp561_) : NULL;
							if (_tmp562_ == NULL) {
								_vala_code_node_unref0 (_tmp561_);
							}
							override_property = _tmp562_;
							_tmp564_ = override_property;
							if (_tmp564_ == NULL) {
								_tmp563_ = TRUE;
							} else {
								ValaProperty* _tmp565_;
								gboolean _tmp566_;
								gboolean _tmp567_;
								_tmp565_ = override_property;
								_tmp566_ = vala_property_get_overrides (_tmp565_);
								_tmp567_ = _tmp566_;
								_tmp563_ = !_tmp567_;
							}
							if (_tmp563_) {
								ValaSourceReference* _tmp568_;
								ValaSourceReference* _tmp569_;
								gchar* _tmp570_;
								gchar* _tmp571_;
								ValaProperty* _tmp572_;
								gchar* _tmp573_;
								gchar* _tmp574_;
								gchar* _tmp575_;
								gchar* _tmp576_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp568_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp569_ = _tmp568_;
								_tmp570_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp571_ = _tmp570_;
								_tmp572_ = base_property;
								_tmp573_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp572_);
								_tmp574_ = _tmp573_;
								_tmp575_ = g_strdup_printf ("`%s' does not implement abstract property `%s'", _tmp571_, _tmp574_);
								_tmp576_ = _tmp575_;
								vala_report_error (_tmp569_, _tmp576_);
								_g_free0 (_tmp576_);
								_g_free0 (_tmp574_);
								_g_free0 (_tmp571_);
							}
							_vala_code_node_unref0 (override_property);
						}
						_vala_code_node_unref0 (base_property);
					}
					_vala_iterable_unref0 (_base_property_list);
				}
				_tmp577_ = base_class;
				_tmp578_ = _tmp577_->priv->_base_class;
				_tmp579_ = _vala_code_node_ref0 (_tmp578_);
				_vala_code_node_unref0 (base_class);
				base_class = _tmp579_;
			}
			_vala_code_node_unref0 (base_class);
		}
	}
	_tmp580_ = vala_code_context_get_analyzer (context);
	_tmp581_ = _tmp580_;
	_tmp582_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp581_, _tmp582_);
	_tmp583_ = vala_code_context_get_analyzer (context);
	_tmp584_ = _tmp583_;
	_tmp585_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp584_, _tmp585_);
	_tmp586_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp587_ = _tmp586_;
	result = !_tmp587_;
	_vala_iterable_unref0 (missing_prereqs);
	_vala_iterable_unref0 (prerequisites);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


ValaClass*
vala_class_get_base_class (ValaClass* self)
{
	ValaClass* result;
	ValaClass* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_class;
	result = _tmp0_;
	return result;
}


void
vala_class_set_base_class (ValaClass* self,
                           ValaClass* value)
{
	ValaClass* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_class);
	self->priv->_base_class = _tmp0_;
}


gboolean
vala_class_get_is_abstract (ValaClass* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_abstract;
	result = _tmp0_;
	return result;
}


void
vala_class_set_is_abstract (ValaClass* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}


static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}


static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}


gboolean
vala_class_get_is_compact (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp10_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_compact;
	if (_tmp0_ == NULL) {
		ValaClass* _tmp1_;
		_tmp1_ = self->priv->_base_class;
		if (_tmp1_ != NULL) {
			ValaClass* _tmp2_;
			gboolean _tmp3_;
			gboolean _tmp4_;
			gboolean* _tmp5_;
			_tmp2_ = self->priv->_base_class;
			_tmp3_ = vala_class_get_is_compact (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = __bool_dup0 (&_tmp4_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp5_;
		} else {
			ValaAttribute* _tmp6_;
			ValaAttribute* _tmp7_;
			gboolean _tmp8_;
			gboolean* _tmp9_;
			_tmp6_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Compact");
			_tmp7_ = _tmp6_;
			_tmp8_ = _tmp7_ != NULL;
			_tmp9_ = __bool_dup0 (&_tmp8_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp9_;
			_vala_code_node_unref0 (_tmp7_);
		}
	}
	_tmp10_ = self->priv->_is_compact;
	result = *_tmp10_;
	return result;
}


void
vala_class_set_is_compact (ValaClass* self,
                           gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_is_compact);
	self->priv->_is_compact = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "Compact", value, NULL);
}


gboolean
vala_class_get_is_immutable (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp10_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_immutable;
	if (_tmp0_ == NULL) {
		ValaClass* _tmp1_;
		_tmp1_ = self->priv->_base_class;
		if (_tmp1_ != NULL) {
			ValaClass* _tmp2_;
			gboolean _tmp3_;
			gboolean _tmp4_;
			gboolean* _tmp5_;
			_tmp2_ = self->priv->_base_class;
			_tmp3_ = vala_class_get_is_immutable (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = __bool_dup0 (&_tmp4_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp5_;
		} else {
			ValaAttribute* _tmp6_;
			ValaAttribute* _tmp7_;
			gboolean _tmp8_;
			gboolean* _tmp9_;
			_tmp6_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Immutable");
			_tmp7_ = _tmp6_;
			_tmp8_ = _tmp7_ != NULL;
			_tmp9_ = __bool_dup0 (&_tmp8_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp9_;
			_vala_code_node_unref0 (_tmp7_);
		}
	}
	_tmp10_ = self->priv->_is_immutable;
	result = *_tmp10_;
	return result;
}


void
vala_class_set_is_immutable (ValaClass* self,
                             gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_is_immutable);
	self->priv->_is_immutable = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "Immutable", value, NULL);
}


gboolean
vala_class_get_has_private_fields (ValaClass* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_has_private_fields;
	result = _tmp0_;
	return result;
}


void
vala_class_set_has_private_fields (ValaClass* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_private_fields = value;
}


gboolean
vala_class_get_has_class_private_fields (ValaClass* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_has_class_private_fields;
	result = _tmp0_;
	return result;
}


static void
vala_class_set_has_class_private_fields (ValaClass* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_class_private_fields = value;
}


ValaCreationMethod*
vala_class_get_default_construction_method (ValaClass* self)
{
	ValaCreationMethod* result;
	ValaCreationMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_construction_method;
	result = _tmp0_;
	return result;
}


void
vala_class_set_default_construction_method (ValaClass* self,
                                            ValaCreationMethod* value)
{
	ValaCreationMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	self->priv->_default_construction_method = _tmp0_;
}


ValaConstructor*
vala_class_get_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_constructor;
	result = _tmp0_;
	return result;
}


void
vala_class_set_constructor (ValaClass* self,
                            ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_constructor);
	self->priv->_constructor = _tmp0_;
	_tmp1_ = self->priv->_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}


ValaConstructor*
vala_class_get_class_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_constructor;
	result = _tmp0_;
	return result;
}


void
vala_class_set_class_constructor (ValaClass* self,
                                  ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	self->priv->_class_constructor = _tmp0_;
	_tmp1_ = self->priv->_class_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_class_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}


ValaConstructor*
vala_class_get_static_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_constructor;
	result = _tmp0_;
	return result;
}


void
vala_class_set_static_constructor (ValaClass* self,
                                   ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	self->priv->_static_constructor = _tmp0_;
	_tmp1_ = self->priv->_static_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_static_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}


ValaDestructor*
vala_class_get_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_destructor;
	result = _tmp0_;
	return result;
}


void
vala_class_set_destructor (ValaClass* self,
                           ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_destructor);
	self->priv->_destructor = _tmp0_;
	_tmp1_ = self->priv->_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		ValaDestructor* _tmp5_;
		ValaParameter* _tmp6_;
		ValaParameter* _tmp7_;
		ValaDestructor* _tmp16_;
		ValaObjectType* _tmp17_;
		ValaObjectType* _tmp18_;
		ValaParameter* _tmp19_;
		ValaParameter* _tmp20_;
		ValaDestructor* _tmp21_;
		ValaScope* _tmp22_;
		ValaScope* _tmp23_;
		ValaDestructor* _tmp24_;
		ValaParameter* _tmp25_;
		ValaParameter* _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		ValaDestructor* _tmp29_;
		ValaParameter* _tmp30_;
		ValaParameter* _tmp31_;
		_tmp2_ = self->priv->_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
		_tmp5_ = self->priv->_destructor;
		_tmp6_ = vala_destructor_get_this_parameter (_tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp7_ != NULL) {
			ValaDestructor* _tmp8_;
			ValaScope* _tmp9_;
			ValaScope* _tmp10_;
			ValaDestructor* _tmp11_;
			ValaParameter* _tmp12_;
			ValaParameter* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			_tmp8_ = self->priv->_destructor;
			_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = self->priv->_destructor;
			_tmp12_ = vala_destructor_get_this_parameter (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_symbol_get_name ((ValaSymbol*) _tmp13_);
			_tmp15_ = _tmp14_;
			vala_scope_remove (_tmp10_, _tmp15_);
		}
		_tmp16_ = self->priv->_destructor;
		_tmp17_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_parameter_new ("this", (ValaDataType*) _tmp18_, NULL);
		_tmp20_ = _tmp19_;
		vala_destructor_set_this_parameter (_tmp16_, _tmp20_);
		_vala_code_node_unref0 (_tmp20_);
		_vala_code_node_unref0 (_tmp18_);
		_tmp21_ = self->priv->_destructor;
		_tmp22_ = vala_symbol_get_scope ((ValaSymbol*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = self->priv->_destructor;
		_tmp25_ = vala_destructor_get_this_parameter (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_symbol_get_name ((ValaSymbol*) _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = self->priv->_destructor;
		_tmp30_ = vala_destructor_get_this_parameter (_tmp29_);
		_tmp31_ = _tmp30_;
		vala_scope_add (_tmp23_, _tmp28_, (ValaSymbol*) _tmp31_);
	}
}


ValaDestructor*
vala_class_get_static_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_destructor;
	result = _tmp0_;
	return result;
}


void
vala_class_set_static_destructor (ValaClass* self,
                                  ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	self->priv->_static_destructor = _tmp0_;
	_tmp1_ = self->priv->_static_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_static_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}


ValaDestructor*
vala_class_get_class_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_destructor;
	result = _tmp0_;
	return result;
}


void
vala_class_set_class_destructor (ValaClass* self,
                                 ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	self->priv->_class_destructor = _tmp0_;
	_tmp1_ = self->priv->_class_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_class_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}


gboolean
vala_class_get_is_error_base (ValaClass* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ErrorBase");
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_vala_code_node_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}


static void
vala_class_class_init (ValaClassClass * klass)
{
	vala_class_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_class_finalize;
	g_type_class_add_private (klass, sizeof (ValaClassPrivate));
	((ValaSymbolClass *) klass)->add_field = (void (*) (ValaSymbol *, ValaField*)) vala_class_real_add_field;
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol *, ValaMethod*)) vala_class_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol *, ValaProperty*)) vala_class_real_add_property;
	((ValaSymbolClass *) klass)->add_constructor = (void (*) (ValaSymbol *, ValaConstructor*)) vala_class_real_add_constructor;
	((ValaSymbolClass *) klass)->add_destructor = (void (*) (ValaSymbol *, ValaDestructor*)) vala_class_real_add_destructor;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_class_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_class_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol *)) vala_class_real_is_reference_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol *, ValaTypeSymbol*)) vala_class_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode *, ValaDataType*, ValaDataType*)) vala_class_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_class_real_check;
}


static void
vala_class_instance_init (ValaClass * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_CLASS_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->base_types = (ValaList*) _tmp1_;
}


static void
vala_class_finalize (ValaCodeNode * obj)
{
	ValaClass * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CLASS, ValaClass);
	_vala_code_node_unref0 (self->priv->_base_class);
	_g_free0 (self->priv->_is_compact);
	_g_free0 (self->priv->_is_immutable);
	_vala_iterable_unref0 (self->priv->base_types);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	_vala_code_node_unref0 (self->priv->_constructor);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	_vala_code_node_unref0 (self->priv->_destructor);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	VALA_CODE_NODE_CLASS (vala_class_parent_class)->finalize (obj);
}


/**
 * Represents a class declaration in the source code.
 */
GType
vala_class_get_type (void)
{
	static volatile gsize vala_class_type_id__volatile = 0;
	if (g_once_init_enter (&vala_class_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaClassClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_class_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaClass), 0, (GInstanceInitFunc) vala_class_instance_init, NULL };
		GType vala_class_type_id;
		vala_class_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaClass", &g_define_type_info, 0);
		g_once_init_leave (&vala_class_type_id__volatile, vala_class_type_id);
	}
	return vala_class_type_id__volatile;
}



