/* valamarkupreader.c generated by valac, the Vala compiler
 * generated from valamarkupreader.vala, do not modify */

/* valamarkupreader.vala
 *
 * Copyright (C) 2008-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <gobject/gvaluecollector.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_mapped_file_unref0(var) ((var == NULL) ? NULL : (var = (g_mapped_file_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _ValaParamSpecMarkupReader ValaParamSpecMarkupReader;

struct _ValaMarkupReaderPrivate {
	gchar* _filename;
	gchar* _name;
	gchar* _content;
	GMappedFile* mapped_file;
	gchar* begin;
	gchar* current;
	gchar* end;
	gint line;
	gint column;
	ValaMap* attributes;
	gboolean empty_element;
};

struct _ValaParamSpecMarkupReader {
	GParamSpec parent_instance;
};


static gpointer vala_markup_reader_parent_class = NULL;

#define VALA_MARKUP_READER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_MARKUP_READER, ValaMarkupReaderPrivate))
static void vala_markup_reader_set_filename (ValaMarkupReader* self,
                                      const gchar* value);
static gchar* vala_markup_reader_read_name (ValaMarkupReader* self);
static void vala_markup_reader_set_content (ValaMarkupReader* self,
                                     const gchar* value);
static void vala_markup_reader_set_name (ValaMarkupReader* self,
                                  const gchar* value);
static void vala_markup_reader_space (ValaMarkupReader* self);
static gchar* vala_markup_reader_text (ValaMarkupReader* self,
                                gchar end_char,
                                gboolean rm_trailing_whitespace);
static void vala_markup_reader_finalize (ValaMarkupReader * obj);


ValaMarkupReader*
vala_markup_reader_construct (GType object_type,
                              const gchar* filename)
{
	ValaMarkupReader* self = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (filename != NULL, NULL);
	self = (ValaMarkupReader*) g_type_create_instance (object_type);
	vala_markup_reader_set_filename (self, filename);
	{
		GMappedFile* _tmp0_ = NULL;
		GMappedFile* _tmp1_;
		GMappedFile* _tmp2_;
		GMappedFile* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GMappedFile* _tmp6_;
		gchar* _tmp7_;
		_tmp1_ = g_mapped_file_new (filename, FALSE, &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch10_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_mapped_file_unref0 (self->priv->mapped_file);
		self->priv->mapped_file = _tmp2_;
		_tmp3_ = self->priv->mapped_file;
		_tmp4_ = g_mapped_file_get_contents (_tmp3_);
		self->priv->begin = _tmp4_;
		_tmp5_ = self->priv->begin;
		_tmp6_ = self->priv->mapped_file;
		self->priv->end = _tmp5_ + g_mapped_file_get_length (_tmp6_);
		_tmp7_ = self->priv->begin;
		self->priv->current = _tmp7_;
		self->priv->line = 1;
		self->priv->column = 1;
		_g_mapped_file_unref0 (_tmp0_);
	}
	goto __finally10;
	__catch10_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		_tmp10_ = g_strdup_printf ("Unable to map file `%s': %s", filename, _tmp9_);
		_tmp11_ = _tmp10_;
		vala_report_error (NULL, _tmp11_);
		_g_free0 (_tmp11_);
		_g_error_free0 (e);
	}
	__finally10:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


ValaMarkupReader*
vala_markup_reader_new (const gchar* filename)
{
	return vala_markup_reader_construct (VALA_TYPE_MARKUP_READER, filename);
}


ValaMarkupReader*
vala_markup_reader_construct_from_string (GType object_type,
                                          const gchar* filename,
                                          const gchar* content)
{
	ValaMarkupReader* self = NULL;
	gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (filename != NULL, NULL);
	g_return_val_if_fail (content != NULL, NULL);
	self = (ValaMarkupReader*) g_type_create_instance (object_type);
	vala_markup_reader_set_filename (self, filename);
	self->priv->begin = content;
	_tmp0_ = self->priv->begin;
	_tmp1_ = strlen (content);
	_tmp2_ = _tmp1_;
	self->priv->end = _tmp0_ + _tmp2_;
	_tmp3_ = self->priv->begin;
	self->priv->current = _tmp3_;
	self->priv->line = 1;
	self->priv->column = 1;
	return self;
}


ValaMarkupReader*
vala_markup_reader_new_from_string (const gchar* filename,
                                    const gchar* content)
{
	return vala_markup_reader_construct_from_string (VALA_TYPE_MARKUP_READER, filename, content);
}


gchar*
vala_markup_reader_get_attribute (ValaMarkupReader* self,
                                  const gchar* attr)
{
	gchar* result = NULL;
	ValaMap* _tmp0_;
	gpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (attr != NULL, NULL);
	_tmp0_ = self->priv->attributes;
	_tmp1_ = vala_map_get (_tmp0_, attr);
	result = (gchar*) _tmp1_;
	return result;
}


ValaMap*
vala_markup_reader_get_attributes (ValaMarkupReader* self)
{
	ValaMap* result = NULL;
	ValaHashMap* _result_ = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp0_, _tmp1_, _tmp2_);
	_result_ = _tmp3_;
	{
		ValaIterator* _key_it = NULL;
		ValaMap* _tmp4_;
		ValaSet* _tmp5_;
		ValaSet* _tmp6_;
		ValaIterator* _tmp7_;
		ValaIterator* _tmp8_;
		_tmp4_ = self->priv->attributes;
		_tmp5_ = vala_map_get_keys (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_iterable_iterator ((ValaIterable*) _tmp6_);
		_tmp8_ = _tmp7_;
		_vala_iterable_unref0 (_tmp6_);
		_key_it = _tmp8_;
		while (TRUE) {
			ValaIterator* _tmp9_;
			gchar* key = NULL;
			ValaIterator* _tmp10_;
			gpointer _tmp11_;
			ValaHashMap* _tmp12_;
			const gchar* _tmp13_;
			ValaMap* _tmp14_;
			const gchar* _tmp15_;
			gpointer _tmp16_;
			gchar* _tmp17_;
			_tmp9_ = _key_it;
			if (!vala_iterator_next (_tmp9_)) {
				break;
			}
			_tmp10_ = _key_it;
			_tmp11_ = vala_iterator_get (_tmp10_);
			key = (gchar*) _tmp11_;
			_tmp12_ = _result_;
			_tmp13_ = key;
			_tmp14_ = self->priv->attributes;
			_tmp15_ = key;
			_tmp16_ = vala_map_get (_tmp14_, _tmp15_);
			_tmp17_ = (gchar*) _tmp16_;
			vala_map_set ((ValaMap*) _tmp12_, _tmp13_, _tmp17_);
			_g_free0 (_tmp17_);
			_g_free0 (key);
		}
		_vala_iterator_unref0 (_key_it);
	}
	result = (ValaMap*) _result_;
	return result;
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static gchar*
vala_markup_reader_read_name (ValaMarkupReader* self)
{
	gchar* result = NULL;
	gchar* begin = NULL;
	gchar* _tmp0_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->current;
	begin = _tmp0_;
	while (TRUE) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		gchar* _tmp8_;
		gchar _tmp9_;
		gunichar u = 0U;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gunichar _tmp23_;
		_tmp1_ = self->priv->current;
		_tmp2_ = self->priv->end;
		if (!(_tmp1_ < _tmp2_)) {
			break;
		}
		_tmp8_ = self->priv->current;
		_tmp9_ = _tmp8_[0];
		if (_tmp9_ == ' ') {
			_tmp7_ = TRUE;
		} else {
			gchar* _tmp10_;
			gchar _tmp11_;
			_tmp10_ = self->priv->current;
			_tmp11_ = _tmp10_[0];
			_tmp7_ = _tmp11_ == '\t';
		}
		if (_tmp7_) {
			_tmp6_ = TRUE;
		} else {
			gchar* _tmp12_;
			gchar _tmp13_;
			_tmp12_ = self->priv->current;
			_tmp13_ = _tmp12_[0];
			_tmp6_ = _tmp13_ == '>';
		}
		if (_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			gchar* _tmp14_;
			gchar _tmp15_;
			_tmp14_ = self->priv->current;
			_tmp15_ = _tmp14_[0];
			_tmp5_ = _tmp15_ == '/';
		}
		if (_tmp5_) {
			_tmp4_ = TRUE;
		} else {
			gchar* _tmp16_;
			gchar _tmp17_;
			_tmp16_ = self->priv->current;
			_tmp17_ = _tmp16_[0];
			_tmp4_ = _tmp17_ == '=';
		}
		if (_tmp4_) {
			_tmp3_ = TRUE;
		} else {
			gchar* _tmp18_;
			gchar _tmp19_;
			_tmp18_ = self->priv->current;
			_tmp19_ = _tmp18_[0];
			_tmp3_ = _tmp19_ == '\n';
		}
		if (_tmp3_) {
			break;
		}
		_tmp20_ = self->priv->current;
		_tmp21_ = self->priv->end;
		_tmp22_ = self->priv->current;
		u = g_utf8_get_char_validated ((const gchar*) _tmp20_, (gssize) ((glong) (_tmp21_ - _tmp22_)));
		_tmp23_ = u;
		if (_tmp23_ != ((gunichar) -1)) {
			gchar* _tmp24_;
			gunichar _tmp25_;
			_tmp24_ = self->priv->current;
			_tmp25_ = u;
			self->priv->current = _tmp24_ + g_unichar_to_utf8 (_tmp25_, NULL);
		} else {
			vala_report_error (NULL, "invalid UTF-8 character");
		}
	}
	_tmp26_ = self->priv->current;
	_tmp27_ = begin;
	if (_tmp26_ == _tmp27_) {
	}
	_tmp28_ = begin;
	_tmp29_ = self->priv->current;
	_tmp30_ = begin;
	_tmp31_ = string_substring ((const gchar*) _tmp28_, (glong) 0, (glong) ((gint) (_tmp29_ - _tmp30_)));
	result = _tmp31_;
	return result;
}


ValaMarkupTokenType
vala_markup_reader_read_token (ValaMarkupReader* self,
                               ValaSourceLocation* token_begin,
                               ValaSourceLocation* token_end)
{
	ValaSourceLocation _vala_token_begin = {0};
	ValaSourceLocation _vala_token_end = {0};
	ValaMarkupTokenType result = 0;
	ValaMap* _tmp0_;
	gboolean _tmp1_;
	ValaMarkupTokenType type = 0;
	gchar* begin = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp118_;
	gint _tmp119_;
	gint _tmp120_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->attributes;
	vala_map_clear (_tmp0_);
	_tmp1_ = self->priv->empty_element;
	if (_tmp1_) {
		gchar* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gchar* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		self->priv->empty_element = FALSE;
		_tmp2_ = self->priv->begin;
		_tmp3_ = self->priv->line;
		_tmp4_ = self->priv->column;
		vala_source_location_init (&_vala_token_begin, _tmp2_, _tmp3_, _tmp4_);
		_tmp5_ = self->priv->begin;
		_tmp6_ = self->priv->line;
		_tmp7_ = self->priv->column;
		vala_source_location_init (&_vala_token_end, _tmp5_, _tmp6_, _tmp7_);
		result = VALA_MARKUP_TOKEN_TYPE_END_ELEMENT;
		if (token_begin) {
			*token_begin = _vala_token_begin;
		}
		if (token_end) {
			*token_end = _vala_token_end;
		}
		return result;
	}
	vala_markup_reader_set_content (self, NULL);
	vala_markup_reader_set_name (self, NULL);
	vala_markup_reader_space (self);
	type = VALA_MARKUP_TOKEN_TYPE_NONE;
	_tmp8_ = self->priv->current;
	begin = _tmp8_;
	_tmp9_ = begin;
	_tmp10_ = self->priv->line;
	_tmp11_ = self->priv->column;
	vala_source_location_init (&_vala_token_begin, _tmp9_, _tmp10_, _tmp11_);
	_tmp12_ = self->priv->current;
	_tmp13_ = self->priv->end;
	if (_tmp12_ >= _tmp13_) {
		type = VALA_MARKUP_TOKEN_TYPE_EOF;
	} else {
		gchar* _tmp14_;
		gchar _tmp15_;
		_tmp14_ = self->priv->current;
		_tmp15_ = _tmp14_[0];
		if (_tmp15_ == '<') {
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp16_ = self->priv->current;
			self->priv->current = _tmp16_ + 1;
			_tmp17_ = self->priv->current;
			_tmp18_ = self->priv->end;
			if (_tmp17_ >= _tmp18_) {
			} else {
				gchar* _tmp19_;
				gchar _tmp20_;
				_tmp19_ = self->priv->current;
				_tmp20_ = _tmp19_[0];
				if (_tmp20_ == '?') {
				} else {
					gchar* _tmp21_;
					gchar _tmp22_;
					_tmp21_ = self->priv->current;
					_tmp22_ = _tmp21_[0];
					if (_tmp22_ == '!') {
						gchar* _tmp23_;
						gboolean _tmp24_ = FALSE;
						gboolean _tmp25_ = FALSE;
						gchar* _tmp26_;
						gchar* _tmp27_;
						_tmp23_ = self->priv->current;
						self->priv->current = _tmp23_ + 1;
						_tmp26_ = self->priv->current;
						_tmp27_ = self->priv->end;
						if (_tmp26_ < (_tmp27_ - 1)) {
							gchar* _tmp28_;
							gchar _tmp29_;
							_tmp28_ = self->priv->current;
							_tmp29_ = _tmp28_[0];
							_tmp25_ = _tmp29_ == '-';
						} else {
							_tmp25_ = FALSE;
						}
						if (_tmp25_) {
							gchar* _tmp30_;
							gchar _tmp31_;
							_tmp30_ = self->priv->current;
							_tmp31_ = _tmp30_[1];
							_tmp24_ = _tmp31_ == '-';
						} else {
							_tmp24_ = FALSE;
						}
						if (_tmp24_) {
							gchar* _tmp32_;
							ValaSourceLocation _tmp48_ = {0};
							ValaSourceLocation _tmp49_ = {0};
							ValaMarkupTokenType _tmp50_;
							_tmp32_ = self->priv->current;
							self->priv->current = _tmp32_ + 2;
							while (TRUE) {
								gchar* _tmp33_;
								gchar* _tmp34_;
								gboolean _tmp35_ = FALSE;
								gboolean _tmp36_ = FALSE;
								gchar* _tmp37_;
								gchar _tmp38_;
								gchar* _tmp47_;
								_tmp33_ = self->priv->current;
								_tmp34_ = self->priv->end;
								if (!(_tmp33_ < (_tmp34_ - 2))) {
									break;
								}
								_tmp37_ = self->priv->current;
								_tmp38_ = _tmp37_[0];
								if (_tmp38_ == '-') {
									gchar* _tmp39_;
									gchar _tmp40_;
									_tmp39_ = self->priv->current;
									_tmp40_ = _tmp39_[1];
									_tmp36_ = _tmp40_ == '-';
								} else {
									_tmp36_ = FALSE;
								}
								if (_tmp36_) {
									gchar* _tmp41_;
									gchar _tmp42_;
									_tmp41_ = self->priv->current;
									_tmp42_ = _tmp41_[2];
									_tmp35_ = _tmp42_ == '>';
								} else {
									_tmp35_ = FALSE;
								}
								if (_tmp35_) {
									gchar* _tmp43_;
									_tmp43_ = self->priv->current;
									self->priv->current = _tmp43_ + 3;
									break;
								} else {
									gchar* _tmp44_;
									gchar _tmp45_;
									_tmp44_ = self->priv->current;
									_tmp45_ = _tmp44_[0];
									if (_tmp45_ == '\n') {
										gint _tmp46_;
										_tmp46_ = self->priv->line;
										self->priv->line = _tmp46_ + 1;
										self->priv->column = 0;
									}
								}
								_tmp47_ = self->priv->current;
								self->priv->current = _tmp47_ + 1;
							}
							_tmp50_ = vala_markup_reader_read_token (self, &_tmp48_, &_tmp49_);
							_vala_token_begin = _tmp48_;
							_vala_token_end = _tmp49_;
							result = _tmp50_;
							if (token_begin) {
								*token_begin = _vala_token_begin;
							}
							if (token_end) {
								*token_end = _vala_token_end;
							}
							return result;
						}
					} else {
						gchar* _tmp51_;
						gchar _tmp52_;
						_tmp51_ = self->priv->current;
						_tmp52_ = _tmp51_[0];
						if (_tmp52_ == '/') {
							gchar* _tmp53_;
							gchar* _tmp54_;
							gchar* _tmp55_;
							gboolean _tmp56_ = FALSE;
							gchar* _tmp57_;
							gchar* _tmp58_;
							gchar* _tmp61_;
							type = VALA_MARKUP_TOKEN_TYPE_END_ELEMENT;
							_tmp53_ = self->priv->current;
							self->priv->current = _tmp53_ + 1;
							_tmp54_ = vala_markup_reader_read_name (self);
							_tmp55_ = _tmp54_;
							vala_markup_reader_set_name (self, _tmp55_);
							_g_free0 (_tmp55_);
							_tmp57_ = self->priv->current;
							_tmp58_ = self->priv->end;
							if (_tmp57_ >= _tmp58_) {
								_tmp56_ = TRUE;
							} else {
								gchar* _tmp59_;
								gchar _tmp60_;
								_tmp59_ = self->priv->current;
								_tmp60_ = _tmp59_[0];
								_tmp56_ = _tmp60_ != '>';
							}
							if (_tmp56_) {
							}
							_tmp61_ = self->priv->current;
							self->priv->current = _tmp61_ + 1;
						} else {
							gchar* _tmp62_;
							gchar* _tmp63_;
							gchar* _tmp102_;
							gchar _tmp103_;
							gboolean _tmp105_ = FALSE;
							gchar* _tmp106_;
							gchar* _tmp107_;
							gchar* _tmp110_;
							type = VALA_MARKUP_TOKEN_TYPE_START_ELEMENT;
							_tmp62_ = vala_markup_reader_read_name (self);
							_tmp63_ = _tmp62_;
							vala_markup_reader_set_name (self, _tmp63_);
							_g_free0 (_tmp63_);
							vala_markup_reader_space (self);
							while (TRUE) {
								gboolean _tmp64_ = FALSE;
								gboolean _tmp65_ = FALSE;
								gchar* _tmp66_;
								gchar* _tmp67_;
								gchar* attr_name = NULL;
								gchar* _tmp72_;
								gboolean _tmp73_ = FALSE;
								gchar* _tmp74_;
								gchar* _tmp75_;
								gchar* _tmp78_;
								gboolean _tmp79_ = FALSE;
								gboolean _tmp80_ = FALSE;
								gchar* _tmp81_;
								gchar* _tmp82_;
								gchar quote = '\0';
								gchar* _tmp87_;
								gchar _tmp88_;
								gchar* _tmp89_;
								gchar* attr_value = NULL;
								gchar _tmp90_;
								gchar* _tmp91_;
								gboolean _tmp92_ = FALSE;
								gchar* _tmp93_;
								gchar* _tmp94_;
								gchar* _tmp98_;
								ValaMap* _tmp99_;
								const gchar* _tmp100_;
								const gchar* _tmp101_;
								_tmp66_ = self->priv->current;
								_tmp67_ = self->priv->end;
								if (_tmp66_ < _tmp67_) {
									gchar* _tmp68_;
									gchar _tmp69_;
									_tmp68_ = self->priv->current;
									_tmp69_ = _tmp68_[0];
									_tmp65_ = _tmp69_ != '>';
								} else {
									_tmp65_ = FALSE;
								}
								if (_tmp65_) {
									gchar* _tmp70_;
									gchar _tmp71_;
									_tmp70_ = self->priv->current;
									_tmp71_ = _tmp70_[0];
									_tmp64_ = _tmp71_ != '/';
								} else {
									_tmp64_ = FALSE;
								}
								if (!_tmp64_) {
									break;
								}
								_tmp72_ = vala_markup_reader_read_name (self);
								attr_name = _tmp72_;
								_tmp74_ = self->priv->current;
								_tmp75_ = self->priv->end;
								if (_tmp74_ >= _tmp75_) {
									_tmp73_ = TRUE;
								} else {
									gchar* _tmp76_;
									gchar _tmp77_;
									_tmp76_ = self->priv->current;
									_tmp77_ = _tmp76_[0];
									_tmp73_ = _tmp77_ != '=';
								}
								if (_tmp73_) {
								}
								_tmp78_ = self->priv->current;
								self->priv->current = _tmp78_ + 1;
								_tmp81_ = self->priv->current;
								_tmp82_ = self->priv->end;
								if (_tmp81_ >= _tmp82_) {
									_tmp80_ = TRUE;
								} else {
									gchar* _tmp83_;
									gchar _tmp84_;
									_tmp83_ = self->priv->current;
									_tmp84_ = _tmp83_[0];
									_tmp80_ = _tmp84_ != '"';
								}
								if (_tmp80_) {
									_tmp79_ = TRUE;
								} else {
									gchar* _tmp85_;
									gchar _tmp86_;
									_tmp85_ = self->priv->current;
									_tmp86_ = _tmp85_[0];
									_tmp79_ = _tmp86_ != '\'';
								}
								if (_tmp79_) {
								}
								_tmp87_ = self->priv->current;
								_tmp88_ = _tmp87_[0];
								quote = _tmp88_;
								_tmp89_ = self->priv->current;
								self->priv->current = _tmp89_ + 1;
								_tmp90_ = quote;
								_tmp91_ = vala_markup_reader_text (self, _tmp90_, FALSE);
								attr_value = _tmp91_;
								_tmp93_ = self->priv->current;
								_tmp94_ = self->priv->end;
								if (_tmp93_ >= _tmp94_) {
									_tmp92_ = TRUE;
								} else {
									gchar* _tmp95_;
									gchar _tmp96_;
									gchar _tmp97_;
									_tmp95_ = self->priv->current;
									_tmp96_ = _tmp95_[0];
									_tmp97_ = quote;
									_tmp92_ = _tmp96_ != _tmp97_;
								}
								if (_tmp92_) {
								}
								_tmp98_ = self->priv->current;
								self->priv->current = _tmp98_ + 1;
								_tmp99_ = self->priv->attributes;
								_tmp100_ = attr_name;
								_tmp101_ = attr_value;
								vala_map_set (_tmp99_, _tmp100_, _tmp101_);
								vala_markup_reader_space (self);
								_g_free0 (attr_value);
								_g_free0 (attr_name);
							}
							_tmp102_ = self->priv->current;
							_tmp103_ = _tmp102_[0];
							if (_tmp103_ == '/') {
								gchar* _tmp104_;
								self->priv->empty_element = TRUE;
								_tmp104_ = self->priv->current;
								self->priv->current = _tmp104_ + 1;
								vala_markup_reader_space (self);
							} else {
								self->priv->empty_element = FALSE;
							}
							_tmp106_ = self->priv->current;
							_tmp107_ = self->priv->end;
							if (_tmp106_ >= _tmp107_) {
								_tmp105_ = TRUE;
							} else {
								gchar* _tmp108_;
								gchar _tmp109_;
								_tmp108_ = self->priv->current;
								_tmp109_ = _tmp108_[0];
								_tmp105_ = _tmp109_ != '>';
							}
							if (_tmp105_) {
							}
							_tmp110_ = self->priv->current;
							self->priv->current = _tmp110_ + 1;
						}
					}
				}
			}
		} else {
			gchar* _tmp111_;
			gchar _tmp112_;
			vala_markup_reader_space (self);
			_tmp111_ = self->priv->current;
			_tmp112_ = _tmp111_[0];
			if (_tmp112_ != '<') {
				gchar* _tmp113_;
				gchar* _tmp114_;
				_tmp113_ = vala_markup_reader_text (self, '<', TRUE);
				_tmp114_ = _tmp113_;
				vala_markup_reader_set_content (self, _tmp114_);
				_g_free0 (_tmp114_);
			} else {
				ValaSourceLocation _tmp115_ = {0};
				ValaSourceLocation _tmp116_ = {0};
				ValaMarkupTokenType _tmp117_;
				_tmp117_ = vala_markup_reader_read_token (self, &_tmp115_, &_tmp116_);
				_vala_token_begin = _tmp115_;
				_vala_token_end = _tmp116_;
				result = _tmp117_;
				if (token_begin) {
					*token_begin = _vala_token_begin;
				}
				if (token_end) {
					*token_end = _vala_token_end;
				}
				return result;
			}
			type = VALA_MARKUP_TOKEN_TYPE_TEXT;
		}
	}
	_tmp118_ = self->priv->current;
	_tmp119_ = self->priv->line;
	_tmp120_ = self->priv->column;
	vala_source_location_init (&_vala_token_end, _tmp118_, _tmp119_, _tmp120_ - 1);
	result = type;
	if (token_begin) {
		*token_begin = _vala_token_begin;
	}
	if (token_end) {
		*token_end = _vala_token_end;
	}
	return result;
}


static gchar*
vala_markup_reader_text (ValaMarkupReader* self,
                         gchar end_char,
                         gboolean rm_trailing_whitespace)
{
	gchar* result = NULL;
	GString* content = NULL;
	GString* _tmp0_;
	gchar* text_begin = NULL;
	gchar* _tmp1_;
	gchar* last_linebreak = NULL;
	gchar* _tmp2_;
	gchar* _tmp83_;
	gchar* _tmp84_;
	gint _tmp91_;
	gchar* _tmp92_;
	gchar* _tmp93_;
	GString* _tmp111_;
	const gchar* _tmp112_;
	gchar* _tmp113_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	content = _tmp0_;
	_tmp1_ = self->priv->current;
	text_begin = _tmp1_;
	_tmp2_ = self->priv->current;
	last_linebreak = _tmp2_;
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gunichar u = 0U;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gunichar _tmp11_;
		_tmp4_ = self->priv->current;
		_tmp5_ = self->priv->end;
		if (_tmp4_ < _tmp5_) {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[0];
			_tmp3_ = _tmp7_ != end_char;
		} else {
			_tmp3_ = FALSE;
		}
		if (!_tmp3_) {
			break;
		}
		_tmp8_ = self->priv->current;
		_tmp9_ = self->priv->end;
		_tmp10_ = self->priv->current;
		u = g_utf8_get_char_validated ((const gchar*) _tmp8_, (gssize) ((glong) (_tmp9_ - _tmp10_)));
		_tmp11_ = u;
		if (_tmp11_ == ((gunichar) -1)) {
			vala_report_error (NULL, "invalid UTF-8 character");
		} else {
			gunichar _tmp12_;
			_tmp12_ = u;
			if (_tmp12_ == ((gunichar) '&')) {
				gchar* next_pos = NULL;
				gchar* _tmp13_;
				gunichar _tmp14_;
				gchar* _tmp15_;
				_tmp13_ = self->priv->current;
				_tmp14_ = u;
				next_pos = _tmp13_ + g_unichar_to_utf8 (_tmp14_, NULL);
				_tmp15_ = next_pos;
				if (g_str_has_prefix ((const gchar*) _tmp15_, "amp;")) {
					GString* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					gchar* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					GString* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					_tmp16_ = content;
					_tmp17_ = text_begin;
					_tmp18_ = self->priv->current;
					_tmp19_ = text_begin;
					_tmp20_ = string_substring ((const gchar*) _tmp17_, (glong) 0, (glong) ((gint) (_tmp18_ - _tmp19_)));
					_tmp21_ = _tmp20_;
					g_string_append (_tmp16_, _tmp21_);
					_g_free0 (_tmp21_);
					_tmp22_ = content;
					g_string_append_c (_tmp22_, '&');
					_tmp23_ = self->priv->current;
					self->priv->current = _tmp23_ + 5;
					_tmp24_ = self->priv->current;
					text_begin = _tmp24_;
				} else {
					gchar* _tmp25_;
					_tmp25_ = next_pos;
					if (g_str_has_prefix ((const gchar*) _tmp25_, "quot;")) {
						GString* _tmp26_;
						gchar* _tmp27_;
						gchar* _tmp28_;
						gchar* _tmp29_;
						gchar* _tmp30_;
						gchar* _tmp31_;
						GString* _tmp32_;
						gchar* _tmp33_;
						gchar* _tmp34_;
						_tmp26_ = content;
						_tmp27_ = text_begin;
						_tmp28_ = self->priv->current;
						_tmp29_ = text_begin;
						_tmp30_ = string_substring ((const gchar*) _tmp27_, (glong) 0, (glong) ((gint) (_tmp28_ - _tmp29_)));
						_tmp31_ = _tmp30_;
						g_string_append (_tmp26_, _tmp31_);
						_g_free0 (_tmp31_);
						_tmp32_ = content;
						g_string_append_c (_tmp32_, '"');
						_tmp33_ = self->priv->current;
						self->priv->current = _tmp33_ + 6;
						_tmp34_ = self->priv->current;
						text_begin = _tmp34_;
					} else {
						gchar* _tmp35_;
						_tmp35_ = next_pos;
						if (g_str_has_prefix ((const gchar*) _tmp35_, "apos;")) {
							GString* _tmp36_;
							gchar* _tmp37_;
							gchar* _tmp38_;
							gchar* _tmp39_;
							gchar* _tmp40_;
							gchar* _tmp41_;
							GString* _tmp42_;
							gchar* _tmp43_;
							gchar* _tmp44_;
							_tmp36_ = content;
							_tmp37_ = text_begin;
							_tmp38_ = self->priv->current;
							_tmp39_ = text_begin;
							_tmp40_ = string_substring ((const gchar*) _tmp37_, (glong) 0, (glong) ((gint) (_tmp38_ - _tmp39_)));
							_tmp41_ = _tmp40_;
							g_string_append (_tmp36_, _tmp41_);
							_g_free0 (_tmp41_);
							_tmp42_ = content;
							g_string_append_c (_tmp42_, '\'');
							_tmp43_ = self->priv->current;
							self->priv->current = _tmp43_ + 6;
							_tmp44_ = self->priv->current;
							text_begin = _tmp44_;
						} else {
							gchar* _tmp45_;
							_tmp45_ = next_pos;
							if (g_str_has_prefix ((const gchar*) _tmp45_, "lt;")) {
								GString* _tmp46_;
								gchar* _tmp47_;
								gchar* _tmp48_;
								gchar* _tmp49_;
								gchar* _tmp50_;
								gchar* _tmp51_;
								GString* _tmp52_;
								gchar* _tmp53_;
								gchar* _tmp54_;
								_tmp46_ = content;
								_tmp47_ = text_begin;
								_tmp48_ = self->priv->current;
								_tmp49_ = text_begin;
								_tmp50_ = string_substring ((const gchar*) _tmp47_, (glong) 0, (glong) ((gint) (_tmp48_ - _tmp49_)));
								_tmp51_ = _tmp50_;
								g_string_append (_tmp46_, _tmp51_);
								_g_free0 (_tmp51_);
								_tmp52_ = content;
								g_string_append_c (_tmp52_, '<');
								_tmp53_ = self->priv->current;
								self->priv->current = _tmp53_ + 4;
								_tmp54_ = self->priv->current;
								text_begin = _tmp54_;
							} else {
								gchar* _tmp55_;
								_tmp55_ = next_pos;
								if (g_str_has_prefix ((const gchar*) _tmp55_, "gt;")) {
									GString* _tmp56_;
									gchar* _tmp57_;
									gchar* _tmp58_;
									gchar* _tmp59_;
									gchar* _tmp60_;
									gchar* _tmp61_;
									GString* _tmp62_;
									gchar* _tmp63_;
									gchar* _tmp64_;
									_tmp56_ = content;
									_tmp57_ = text_begin;
									_tmp58_ = self->priv->current;
									_tmp59_ = text_begin;
									_tmp60_ = string_substring ((const gchar*) _tmp57_, (glong) 0, (glong) ((gint) (_tmp58_ - _tmp59_)));
									_tmp61_ = _tmp60_;
									g_string_append (_tmp56_, _tmp61_);
									_g_free0 (_tmp61_);
									_tmp62_ = content;
									g_string_append_c (_tmp62_, '>');
									_tmp63_ = self->priv->current;
									self->priv->current = _tmp63_ + 4;
									_tmp64_ = self->priv->current;
									text_begin = _tmp64_;
								} else {
									gchar* _tmp65_;
									_tmp65_ = next_pos;
									if (g_str_has_prefix ((const gchar*) _tmp65_, "percnt;")) {
										GString* _tmp66_;
										gchar* _tmp67_;
										gchar* _tmp68_;
										gchar* _tmp69_;
										gchar* _tmp70_;
										gchar* _tmp71_;
										GString* _tmp72_;
										gchar* _tmp73_;
										gchar* _tmp74_;
										_tmp66_ = content;
										_tmp67_ = text_begin;
										_tmp68_ = self->priv->current;
										_tmp69_ = text_begin;
										_tmp70_ = string_substring ((const gchar*) _tmp67_, (glong) 0, (glong) ((gint) (_tmp68_ - _tmp69_)));
										_tmp71_ = _tmp70_;
										g_string_append (_tmp66_, _tmp71_);
										_g_free0 (_tmp71_);
										_tmp72_ = content;
										g_string_append_c (_tmp72_, '%');
										_tmp73_ = self->priv->current;
										self->priv->current = _tmp73_ + 8;
										_tmp74_ = self->priv->current;
										text_begin = _tmp74_;
									} else {
										gchar* _tmp75_;
										gunichar _tmp76_;
										_tmp75_ = self->priv->current;
										_tmp76_ = u;
										self->priv->current = _tmp75_ + g_unichar_to_utf8 (_tmp76_, NULL);
									}
								}
							}
						}
					}
				}
			} else {
				gunichar _tmp77_;
				gchar* _tmp80_;
				gunichar _tmp81_;
				gint _tmp82_;
				_tmp77_ = u;
				if (_tmp77_ == ((gunichar) '\n')) {
					gint _tmp78_;
					gchar* _tmp79_;
					_tmp78_ = self->priv->line;
					self->priv->line = _tmp78_ + 1;
					self->priv->column = 0;
					_tmp79_ = self->priv->current;
					last_linebreak = _tmp79_;
				}
				_tmp80_ = self->priv->current;
				_tmp81_ = u;
				self->priv->current = _tmp80_ + g_unichar_to_utf8 (_tmp81_, NULL);
				_tmp82_ = self->priv->column;
				self->priv->column = _tmp82_ + 1;
			}
		}
	}
	_tmp83_ = text_begin;
	_tmp84_ = self->priv->current;
	if (_tmp83_ != _tmp84_) {
		GString* _tmp85_;
		gchar* _tmp86_;
		gchar* _tmp87_;
		gchar* _tmp88_;
		gchar* _tmp89_;
		gchar* _tmp90_;
		_tmp85_ = content;
		_tmp86_ = text_begin;
		_tmp87_ = self->priv->current;
		_tmp88_ = text_begin;
		_tmp89_ = string_substring ((const gchar*) _tmp86_, (glong) 0, (glong) ((gint) (_tmp87_ - _tmp88_)));
		_tmp90_ = _tmp89_;
		g_string_append (_tmp85_, _tmp90_);
		_g_free0 (_tmp90_);
	}
	_tmp91_ = self->priv->column;
	_tmp92_ = self->priv->current;
	_tmp93_ = last_linebreak;
	self->priv->column = _tmp91_ + ((gint) (_tmp92_ - _tmp93_));
	if (rm_trailing_whitespace) {
		gchar* str_pos = NULL;
		GString* _tmp94_;
		const gchar* _tmp95_;
		GString* _tmp96_;
		gssize _tmp97_;
		GString* _tmp107_;
		gchar* _tmp108_;
		GString* _tmp109_;
		const gchar* _tmp110_;
		_tmp94_ = content;
		_tmp95_ = _tmp94_->str;
		_tmp96_ = content;
		_tmp97_ = _tmp96_->len;
		str_pos = ((gchar*) _tmp95_) + _tmp97_;
		{
			gchar* _tmp98_;
			gboolean _tmp99_ = FALSE;
			_tmp98_ = str_pos;
			str_pos = _tmp98_ - 1;
			_tmp99_ = TRUE;
			while (TRUE) {
				gboolean _tmp101_ = FALSE;
				gchar* _tmp102_;
				GString* _tmp103_;
				const gchar* _tmp104_;
				if (!_tmp99_) {
					gchar* _tmp100_;
					_tmp100_ = str_pos;
					str_pos = _tmp100_ - 1;
				}
				_tmp99_ = FALSE;
				_tmp102_ = str_pos;
				_tmp103_ = content;
				_tmp104_ = _tmp103_->str;
				if (_tmp102_ > ((gchar*) _tmp104_)) {
					gchar* _tmp105_;
					gchar _tmp106_;
					_tmp105_ = str_pos;
					_tmp106_ = _tmp105_[0];
					_tmp101_ = g_ascii_isspace (_tmp106_);
				} else {
					_tmp101_ = FALSE;
				}
				if (!_tmp101_) {
					break;
				}
			}
		}
		_tmp107_ = content;
		_tmp108_ = str_pos;
		_tmp109_ = content;
		_tmp110_ = _tmp109_->str;
		g_string_erase (_tmp107_, (gssize) ((_tmp108_ - ((gchar*) _tmp110_)) + 1), (gssize) -1);
	}
	_tmp111_ = content;
	_tmp112_ = _tmp111_->str;
	_tmp113_ = g_strdup (_tmp112_);
	result = _tmp113_;
	_g_string_free0 (content);
	return result;
}


static void
vala_markup_reader_space (ValaMarkupReader* self)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp5_;
		gchar _tmp6_;
		gchar* _tmp8_;
		gint _tmp9_;
		_tmp1_ = self->priv->current;
		_tmp2_ = self->priv->end;
		if (_tmp1_ < _tmp2_) {
			gchar* _tmp3_;
			gchar _tmp4_;
			_tmp3_ = self->priv->current;
			_tmp4_ = _tmp3_[0];
			_tmp0_ = g_ascii_isspace (_tmp4_);
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp5_ = self->priv->current;
		_tmp6_ = _tmp5_[0];
		if (_tmp6_ == '\n') {
			gint _tmp7_;
			_tmp7_ = self->priv->line;
			self->priv->line = _tmp7_ + 1;
			self->priv->column = 0;
		}
		_tmp8_ = self->priv->current;
		self->priv->current = _tmp8_ + 1;
		_tmp9_ = self->priv->column;
		self->priv->column = _tmp9_ + 1;
	}
}


const gchar*
vala_markup_reader_get_filename (ValaMarkupReader* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_filename;
	result = _tmp0_;
	return result;
}


static void
vala_markup_reader_set_filename (ValaMarkupReader* self,
                                 const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_filename);
	self->priv->_filename = _tmp0_;
}


const gchar*
vala_markup_reader_get_name (ValaMarkupReader* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


static void
vala_markup_reader_set_name (ValaMarkupReader* self,
                             const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp0_;
}


const gchar*
vala_markup_reader_get_content (ValaMarkupReader* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_content;
	result = _tmp0_;
	return result;
}


static void
vala_markup_reader_set_content (ValaMarkupReader* self,
                                const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_content);
	self->priv->_content = _tmp0_;
}


static void
vala_value_markup_reader_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
vala_value_markup_reader_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_markup_reader_unref (value->data[0].v_pointer);
	}
}


static void
vala_value_markup_reader_copy_value (const GValue* src_value,
                                     GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_markup_reader_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
vala_value_markup_reader_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
vala_value_markup_reader_collect_value (GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaMarkupReader * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_markup_reader_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
vala_value_markup_reader_lcopy_value (const GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	ValaMarkupReader ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_markup_reader_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec*
vala_param_spec_markup_reader (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags)
{
	ValaParamSpecMarkupReader* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_MARKUP_READER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer
vala_value_get_markup_reader (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_MARKUP_READER), NULL);
	return value->data[0].v_pointer;
}


void
vala_value_set_markup_reader (GValue* value,
                              gpointer v_object)
{
	ValaMarkupReader * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_MARKUP_READER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_MARKUP_READER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_markup_reader_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_markup_reader_unref (old);
	}
}


void
vala_value_take_markup_reader (GValue* value,
                               gpointer v_object)
{
	ValaMarkupReader * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_MARKUP_READER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_MARKUP_READER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_markup_reader_unref (old);
	}
}


static void
vala_markup_reader_class_init (ValaMarkupReaderClass * klass)
{
	vala_markup_reader_parent_class = g_type_class_peek_parent (klass);
	((ValaMarkupReaderClass *) klass)->finalize = vala_markup_reader_finalize;
	g_type_class_add_private (klass, sizeof (ValaMarkupReaderPrivate));
}


static void
vala_markup_reader_instance_init (ValaMarkupReader * self)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	self->priv = VALA_MARKUP_READER_GET_PRIVATE (self);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp0_, _tmp1_, _tmp2_);
	self->priv->attributes = (ValaMap*) _tmp3_;
	self->ref_count = 1;
}


static void
vala_markup_reader_finalize (ValaMarkupReader * obj)
{
	ValaMarkupReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MARKUP_READER, ValaMarkupReader);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->_filename);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_content);
	_g_mapped_file_unref0 (self->priv->mapped_file);
	_vala_map_unref0 (self->priv->attributes);
}


/**
 * Simple reader for a subset of XML.
 */
GType
vala_markup_reader_get_type (void)
{
	static volatile gsize vala_markup_reader_type_id__volatile = 0;
	if (g_once_init_enter (&vala_markup_reader_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_markup_reader_init, vala_value_markup_reader_free_value, vala_value_markup_reader_copy_value, vala_value_markup_reader_peek_pointer, "p", vala_value_markup_reader_collect_value, "p", vala_value_markup_reader_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaMarkupReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_markup_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMarkupReader), 0, (GInstanceInitFunc) vala_markup_reader_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_markup_reader_type_id;
		vala_markup_reader_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaMarkupReader", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_markup_reader_type_id__volatile, vala_markup_reader_type_id);
	}
	return vala_markup_reader_type_id__volatile;
}


gpointer
vala_markup_reader_ref (gpointer instance)
{
	ValaMarkupReader * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void
vala_markup_reader_unref (gpointer instance)
{
	ValaMarkupReader * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_MARKUP_READER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


const gchar*
vala_markup_token_type_to_string (ValaMarkupTokenType self)
{
	const gchar* result = NULL;
	switch (self) {
		case VALA_MARKUP_TOKEN_TYPE_START_ELEMENT:
		{
			result = "start element";
			return result;
		}
		case VALA_MARKUP_TOKEN_TYPE_END_ELEMENT:
		{
			result = "end element";
			return result;
		}
		case VALA_MARKUP_TOKEN_TYPE_TEXT:
		{
			result = "text";
			return result;
		}
		case VALA_MARKUP_TOKEN_TYPE_EOF:
		{
			result = "end of file";
			return result;
		}
		default:
		{
			result = "unknown token type";
			return result;
		}
	}
}


GType
vala_markup_token_type_get_type (void)
{
	static volatile gsize vala_markup_token_type_type_id__volatile = 0;
	if (g_once_init_enter (&vala_markup_token_type_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_MARKUP_TOKEN_TYPE_NONE, "VALA_MARKUP_TOKEN_TYPE_NONE", "none"}, {VALA_MARKUP_TOKEN_TYPE_START_ELEMENT, "VALA_MARKUP_TOKEN_TYPE_START_ELEMENT", "start-element"}, {VALA_MARKUP_TOKEN_TYPE_END_ELEMENT, "VALA_MARKUP_TOKEN_TYPE_END_ELEMENT", "end-element"}, {VALA_MARKUP_TOKEN_TYPE_TEXT, "VALA_MARKUP_TOKEN_TYPE_TEXT", "text"}, {VALA_MARKUP_TOKEN_TYPE_EOF, "VALA_MARKUP_TOKEN_TYPE_EOF", "eof"}, {0, NULL, NULL}};
		GType vala_markup_token_type_type_id;
		vala_markup_token_type_type_id = g_enum_register_static ("ValaMarkupTokenType", values);
		g_once_init_leave (&vala_markup_token_type_type_id__volatile, vala_markup_token_type_type_id);
	}
	return vala_markup_token_type_type_id__volatile;
}



