/* valainterface.c generated by valac, the Vala compiler
 * generated from valainterface.vala, do not modify */

/* valainterface.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))

struct _ValaInterfacePrivate {
	ValaList* prerequisites;
	ValaList* virtuals;
};


static gpointer vala_interface_parent_class = NULL;

#define VALA_INTERFACE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_INTERFACE, ValaInterfacePrivate))
static void vala_interface_real_add_method (ValaSymbol* base,
                                     ValaMethod* m);
static void vala_interface_real_add_property (ValaSymbol* base,
                                       ValaProperty* prop);
static ValaList* vala_interface_real_get_virtuals (ValaInterface* self);
static void vala_interface_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor);
static void vala_interface_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor);
static gboolean vala_interface_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_interface_real_is_subtype_of (ValaTypeSymbol* base,
                                            ValaTypeSymbol* t);
static void vala_interface_real_replace_type (ValaCodeNode* base,
                                       ValaDataType* old_type,
                                       ValaDataType* new_type);
static gboolean vala_interface_real_check (ValaCodeNode* base,
                                    ValaCodeContext* context);
static void vala_interface_finalize (ValaCodeNode * obj);


/**
 * Creates a new interface.
 *
 * @param name              type name
 * @param source_reference  reference to source code
 * @return                  newly created interface
 */
ValaInterface*
vala_interface_construct (GType object_type,
                          const gchar* name,
                          ValaSourceReference* source_reference,
                          ValaComment* comment)
{
	ValaInterface* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaInterface*) vala_object_type_symbol_construct (object_type, name, source_reference, comment);
	return self;
}


ValaInterface*
vala_interface_new (const gchar* name,
                    ValaSourceReference* source_reference,
                    ValaComment* comment)
{
	return vala_interface_construct (VALA_TYPE_INTERFACE, name, source_reference, comment);
}


/**
 * Adds the specified interface or class to the list of prerequisites of
 * this interface.
 *
 * @param type an interface or class reference
 */
void
vala_interface_add_prerequisite (ValaInterface* self,
                                 ValaDataType* type)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->prerequisites;
	vala_collection_add ((ValaCollection*) _tmp0_, type);
	vala_code_node_set_parent_node ((ValaCodeNode*) type, (ValaCodeNode*) self);
}


/**
 * Prepends the specified interface or class to the list of
 * prerequisites of this interface.
 *
 * @param type an interface or class reference
 */
void
vala_interface_prepend_prerequisite (ValaInterface* self,
                                     ValaDataType* type)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->prerequisites;
	vala_list_insert (_tmp0_, 0, type);
}


/**
 * Returns a copy of the base type list.
 *
 * @return list of base types
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_interface_get_prerequisites (ValaInterface* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prerequisites;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified method as a member to this interface.
 *
 * @param m a method
 */
static void
vala_interface_real_add_method (ValaSymbol* base,
                                ValaMethod* m)
{
	ValaInterface * self;
	ValaMemberBinding _tmp2_;
	ValaMemberBinding _tmp3_;
	gboolean _tmp16_ = FALSE;
	ValaDataType* _tmp17_;
	ValaDataType* _tmp18_;
	self = (ValaInterface*) base;
	g_return_if_fail (m != NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (m, VALA_TYPE_CREATION_METHOD)) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp1_ = _tmp0_;
		vala_report_error (_tmp1_, "construction methods may only be declared within classes and structs");
		vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
		return;
	}
	_tmp2_ = vala_method_get_binding (m);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaObjectType* _tmp4_;
		ValaObjectType* _tmp5_;
		ValaParameter* _tmp6_;
		ValaParameter* _tmp7_;
		ValaScope* _tmp8_;
		ValaScope* _tmp9_;
		ValaParameter* _tmp10_;
		ValaParameter* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		ValaParameter* _tmp14_;
		ValaParameter* _tmp15_;
		_tmp4_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_parameter_new ("this", (ValaDataType*) _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		vala_method_set_this_parameter (m, _tmp7_);
		_vala_code_node_unref0 (_tmp7_);
		_vala_code_node_unref0 (_tmp5_);
		_tmp8_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_method_get_this_parameter (m);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_method_get_this_parameter (m);
		_tmp15_ = _tmp14_;
		vala_scope_add (_tmp9_, _tmp13_, (ValaSymbol*) _tmp15_);
	}
	_tmp17_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp18_ = _tmp17_;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, VALA_TYPE_VOID_TYPE)) {
		ValaList* _tmp19_;
		ValaList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		_tmp19_ = vala_method_get_postconditions (m);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp16_ = _tmp22_ > 0;
		_vala_iterable_unref0 (_tmp20_);
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		ValaDataType* _tmp23_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaDataType* _tmp26_;
		ValaSourceReference* _tmp27_;
		ValaSourceReference* _tmp28_;
		ValaLocalVariable* _tmp29_;
		ValaLocalVariable* _tmp30_;
		ValaLocalVariable* _tmp31_;
		ValaLocalVariable* _tmp32_;
		_tmp23_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp24_ = _tmp23_;
		_tmp25_ = vala_data_type_copy (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp28_ = _tmp27_;
		_tmp29_ = vala_local_variable_new (_tmp26_, "result", NULL, _tmp28_);
		_tmp30_ = _tmp29_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp30_);
		_vala_code_node_unref0 (_tmp30_);
		_vala_code_node_unref0 (_tmp26_);
		_tmp31_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp32_ = _tmp31_;
		vala_local_variable_set_is_result (_tmp32_, TRUE);
	}
	VALA_SYMBOL_CLASS (vala_interface_parent_class)->add_method ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), m);
}


/**
 * Adds the specified property as a member to this interface.
 *
 * @param prop a property
 */
static void
vala_interface_real_add_property (ValaSymbol* base,
                                  ValaProperty* prop)
{
	ValaInterface * self;
	ValaField* _tmp0_;
	ValaField* _tmp1_;
	ValaObjectType* _tmp4_;
	ValaObjectType* _tmp5_;
	ValaParameter* _tmp6_;
	ValaParameter* _tmp7_;
	ValaScope* _tmp8_;
	ValaScope* _tmp9_;
	ValaParameter* _tmp10_;
	ValaParameter* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	ValaParameter* _tmp14_;
	ValaParameter* _tmp15_;
	self = (ValaInterface*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = vala_property_get_field (prop);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) prop);
		_tmp3_ = _tmp2_;
		vala_report_error (_tmp3_, "automatic properties are not allowed in interfaces");
		vala_code_node_set_error ((ValaCodeNode*) prop, TRUE);
		return;
	}
	VALA_SYMBOL_CLASS (vala_interface_parent_class)->add_property ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), prop);
	_tmp4_ = vala_object_type_new ((ValaObjectTypeSymbol*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_parameter_new ("this", (ValaDataType*) _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	vala_property_set_this_parameter (prop, _tmp7_);
	_vala_code_node_unref0 (_tmp7_);
	_vala_code_node_unref0 (_tmp5_);
	_tmp8_ = vala_symbol_get_scope ((ValaSymbol*) prop);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_property_get_this_parameter (prop);
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_property_get_this_parameter (prop);
	_tmp15_ = _tmp14_;
	vala_scope_add (_tmp9_, _tmp13_, (ValaSymbol*) _tmp15_);
}


static ValaList*
vala_interface_real_get_virtuals (ValaInterface* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	_tmp0_ = self->priv->virtuals;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


ValaList*
vala_interface_get_virtuals (ValaInterface* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_INTERFACE_GET_CLASS (self)->get_virtuals (self);
}


static void
vala_interface_real_accept (ValaCodeNode* base,
                            ValaCodeVisitor* visitor)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_interface (visitor, self);
}


static void
vala_interface_real_accept_children (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _type_index = 0;
		_tmp0_ = self->priv->prerequisites;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_type_list = _tmp1_;
		_tmp2_ = _type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_type_size = _tmp4_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaDataType* type = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaDataType* _tmp11_;
			_tmp5_ = _type_index;
			_type_index = _tmp5_ + 1;
			_tmp6_ = _type_index;
			_tmp7_ = _type_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _type_list;
			_tmp9_ = _type_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			type = (ValaDataType*) _tmp10_;
			_tmp11_ = type;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp12_;
		gint _p_size = 0;
		ValaList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _p_index = 0;
		_tmp12_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp12_;
		_tmp13_ = _p_list;
		_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_p_size = _tmp15_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp19_;
			gint _tmp20_;
			gpointer _tmp21_;
			ValaTypeParameter* _tmp22_;
			_tmp16_ = _p_index;
			_p_index = _tmp16_ + 1;
			_tmp17_ = _p_index;
			_tmp18_ = _p_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _p_list;
			_tmp20_ = _p_index;
			_tmp21_ = vala_list_get (_tmp19_, _tmp20_);
			p = (ValaTypeParameter*) _tmp21_;
			_tmp22_ = p;
			vala_code_node_accept ((ValaCodeNode*) _tmp22_, visitor);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp23_;
		gint _en_size = 0;
		ValaList* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _en_index = 0;
		_tmp23_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_en_list = _tmp23_;
		_tmp24_ = _en_list;
		_tmp25_ = vala_collection_get_size ((ValaCollection*) _tmp24_);
		_tmp26_ = _tmp25_;
		_en_size = _tmp26_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			ValaEnum* en = NULL;
			ValaList* _tmp30_;
			gint _tmp31_;
			gpointer _tmp32_;
			ValaEnum* _tmp33_;
			_tmp27_ = _en_index;
			_en_index = _tmp27_ + 1;
			_tmp28_ = _en_index;
			_tmp29_ = _en_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _en_list;
			_tmp31_ = _en_index;
			_tmp32_ = vala_list_get (_tmp30_, _tmp31_);
			en = (ValaEnum*) _tmp32_;
			_tmp33_ = en;
			vala_code_node_accept ((ValaCodeNode*) _tmp33_, visitor);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp34_;
		gint _m_size = 0;
		ValaList* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		gint _m_index = 0;
		_tmp34_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
		_m_list = _tmp34_;
		_tmp35_ = _m_list;
		_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
		_tmp37_ = _tmp36_;
		_m_size = _tmp37_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp38_;
			gint _tmp39_;
			gint _tmp40_;
			ValaMethod* m = NULL;
			ValaList* _tmp41_;
			gint _tmp42_;
			gpointer _tmp43_;
			ValaMethod* _tmp44_;
			_tmp38_ = _m_index;
			_m_index = _tmp38_ + 1;
			_tmp39_ = _m_index;
			_tmp40_ = _m_size;
			if (!(_tmp39_ < _tmp40_)) {
				break;
			}
			_tmp41_ = _m_list;
			_tmp42_ = _m_index;
			_tmp43_ = vala_list_get (_tmp41_, _tmp42_);
			m = (ValaMethod*) _tmp43_;
			_tmp44_ = m;
			vala_code_node_accept ((ValaCodeNode*) _tmp44_, visitor);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp45_;
		gint _f_size = 0;
		ValaList* _tmp46_;
		gint _tmp47_;
		gint _tmp48_;
		gint _f_index = 0;
		_tmp45_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_f_list = _tmp45_;
		_tmp46_ = _f_list;
		_tmp47_ = vala_collection_get_size ((ValaCollection*) _tmp46_);
		_tmp48_ = _tmp47_;
		_f_size = _tmp48_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp49_;
			gint _tmp50_;
			gint _tmp51_;
			ValaField* f = NULL;
			ValaList* _tmp52_;
			gint _tmp53_;
			gpointer _tmp54_;
			ValaField* _tmp55_;
			_tmp49_ = _f_index;
			_f_index = _tmp49_ + 1;
			_tmp50_ = _f_index;
			_tmp51_ = _f_size;
			if (!(_tmp50_ < _tmp51_)) {
				break;
			}
			_tmp52_ = _f_list;
			_tmp53_ = _f_index;
			_tmp54_ = vala_list_get (_tmp52_, _tmp53_);
			f = (ValaField*) _tmp54_;
			_tmp55_ = f;
			vala_code_node_accept ((ValaCodeNode*) _tmp55_, visitor);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp56_;
		gint _c_size = 0;
		ValaList* _tmp57_;
		gint _tmp58_;
		gint _tmp59_;
		gint _c_index = 0;
		_tmp56_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_c_list = _tmp56_;
		_tmp57_ = _c_list;
		_tmp58_ = vala_collection_get_size ((ValaCollection*) _tmp57_);
		_tmp59_ = _tmp58_;
		_c_size = _tmp59_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp60_;
			gint _tmp61_;
			gint _tmp62_;
			ValaConstant* c = NULL;
			ValaList* _tmp63_;
			gint _tmp64_;
			gpointer _tmp65_;
			ValaConstant* _tmp66_;
			_tmp60_ = _c_index;
			_c_index = _tmp60_ + 1;
			_tmp61_ = _c_index;
			_tmp62_ = _c_size;
			if (!(_tmp61_ < _tmp62_)) {
				break;
			}
			_tmp63_ = _c_list;
			_tmp64_ = _c_index;
			_tmp65_ = vala_list_get (_tmp63_, _tmp64_);
			c = (ValaConstant*) _tmp65_;
			_tmp66_ = c;
			vala_code_node_accept ((ValaCodeNode*) _tmp66_, visitor);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp67_;
		gint _prop_size = 0;
		ValaList* _tmp68_;
		gint _tmp69_;
		gint _tmp70_;
		gint _prop_index = 0;
		_tmp67_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
		_prop_list = _tmp67_;
		_tmp68_ = _prop_list;
		_tmp69_ = vala_collection_get_size ((ValaCollection*) _tmp68_);
		_tmp70_ = _tmp69_;
		_prop_size = _tmp70_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp71_;
			gint _tmp72_;
			gint _tmp73_;
			ValaProperty* prop = NULL;
			ValaList* _tmp74_;
			gint _tmp75_;
			gpointer _tmp76_;
			ValaProperty* _tmp77_;
			_tmp71_ = _prop_index;
			_prop_index = _tmp71_ + 1;
			_tmp72_ = _prop_index;
			_tmp73_ = _prop_size;
			if (!(_tmp72_ < _tmp73_)) {
				break;
			}
			_tmp74_ = _prop_list;
			_tmp75_ = _prop_index;
			_tmp76_ = vala_list_get (_tmp74_, _tmp75_);
			prop = (ValaProperty*) _tmp76_;
			_tmp77_ = prop;
			vala_code_node_accept ((ValaCodeNode*) _tmp77_, visitor);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp78_;
		gint _sig_size = 0;
		ValaList* _tmp79_;
		gint _tmp80_;
		gint _tmp81_;
		gint _sig_index = 0;
		_tmp78_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
		_sig_list = _tmp78_;
		_tmp79_ = _sig_list;
		_tmp80_ = vala_collection_get_size ((ValaCollection*) _tmp79_);
		_tmp81_ = _tmp80_;
		_sig_size = _tmp81_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp82_;
			gint _tmp83_;
			gint _tmp84_;
			ValaSignal* sig = NULL;
			ValaList* _tmp85_;
			gint _tmp86_;
			gpointer _tmp87_;
			ValaSignal* _tmp88_;
			_tmp82_ = _sig_index;
			_sig_index = _tmp82_ + 1;
			_tmp83_ = _sig_index;
			_tmp84_ = _sig_size;
			if (!(_tmp83_ < _tmp84_)) {
				break;
			}
			_tmp85_ = _sig_list;
			_tmp86_ = _sig_index;
			_tmp87_ = vala_list_get (_tmp85_, _tmp86_);
			sig = (ValaSignal*) _tmp87_;
			_tmp88_ = sig;
			vala_code_node_accept ((ValaCodeNode*) _tmp88_, visitor);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp89_;
		gint _cl_size = 0;
		ValaList* _tmp90_;
		gint _tmp91_;
		gint _tmp92_;
		gint _cl_index = 0;
		_tmp89_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_cl_list = _tmp89_;
		_tmp90_ = _cl_list;
		_tmp91_ = vala_collection_get_size ((ValaCollection*) _tmp90_);
		_tmp92_ = _tmp91_;
		_cl_size = _tmp92_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp93_;
			gint _tmp94_;
			gint _tmp95_;
			ValaClass* cl = NULL;
			ValaList* _tmp96_;
			gint _tmp97_;
			gpointer _tmp98_;
			ValaClass* _tmp99_;
			_tmp93_ = _cl_index;
			_cl_index = _tmp93_ + 1;
			_tmp94_ = _cl_index;
			_tmp95_ = _cl_size;
			if (!(_tmp94_ < _tmp95_)) {
				break;
			}
			_tmp96_ = _cl_list;
			_tmp97_ = _cl_index;
			_tmp98_ = vala_list_get (_tmp96_, _tmp97_);
			cl = (ValaClass*) _tmp98_;
			_tmp99_ = cl;
			vala_code_node_accept ((ValaCodeNode*) _tmp99_, visitor);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp100_;
		gint _st_size = 0;
		ValaList* _tmp101_;
		gint _tmp102_;
		gint _tmp103_;
		gint _st_index = 0;
		_tmp100_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_st_list = _tmp100_;
		_tmp101_ = _st_list;
		_tmp102_ = vala_collection_get_size ((ValaCollection*) _tmp101_);
		_tmp103_ = _tmp102_;
		_st_size = _tmp103_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp104_;
			gint _tmp105_;
			gint _tmp106_;
			ValaStruct* st = NULL;
			ValaList* _tmp107_;
			gint _tmp108_;
			gpointer _tmp109_;
			ValaStruct* _tmp110_;
			_tmp104_ = _st_index;
			_st_index = _tmp104_ + 1;
			_tmp105_ = _st_index;
			_tmp106_ = _st_size;
			if (!(_tmp105_ < _tmp106_)) {
				break;
			}
			_tmp107_ = _st_list;
			_tmp108_ = _st_index;
			_tmp109_ = vala_list_get (_tmp107_, _tmp108_);
			st = (ValaStruct*) _tmp109_;
			_tmp110_ = st;
			vala_code_node_accept ((ValaCodeNode*) _tmp110_, visitor);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp111_;
		gint _d_size = 0;
		ValaList* _tmp112_;
		gint _tmp113_;
		gint _tmp114_;
		gint _d_index = 0;
		_tmp111_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_d_list = _tmp111_;
		_tmp112_ = _d_list;
		_tmp113_ = vala_collection_get_size ((ValaCollection*) _tmp112_);
		_tmp114_ = _tmp113_;
		_d_size = _tmp114_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp115_;
			gint _tmp116_;
			gint _tmp117_;
			ValaDelegate* d = NULL;
			ValaList* _tmp118_;
			gint _tmp119_;
			gpointer _tmp120_;
			ValaDelegate* _tmp121_;
			_tmp115_ = _d_index;
			_d_index = _tmp115_ + 1;
			_tmp116_ = _d_index;
			_tmp117_ = _d_size;
			if (!(_tmp116_ < _tmp117_)) {
				break;
			}
			_tmp118_ = _d_list;
			_tmp119_ = _d_index;
			_tmp120_ = vala_list_get (_tmp118_, _tmp119_);
			d = (ValaDelegate*) _tmp120_;
			_tmp121_ = d;
			vala_code_node_accept ((ValaCodeNode*) _tmp121_, visitor);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
}


static gboolean
vala_interface_real_is_reference_type (ValaTypeSymbol* base)
{
	ValaInterface * self;
	gboolean result = FALSE;
	self = (ValaInterface*) base;
	result = TRUE;
	return result;
}


static gboolean
vala_interface_real_is_subtype_of (ValaTypeSymbol* base,
                                   ValaTypeSymbol* t)
{
	ValaInterface * self;
	gboolean result = FALSE;
	self = (ValaInterface*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _prerequisite_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _prerequisite_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _prerequisite_index = 0;
		_tmp0_ = self->priv->prerequisites;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_prerequisite_list = _tmp1_;
		_tmp2_ = _prerequisite_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_prerequisite_size = _tmp4_;
		_prerequisite_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaDataType* prerequisite = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			gboolean _tmp11_ = FALSE;
			ValaDataType* _tmp12_;
			ValaTypeSymbol* _tmp13_;
			ValaTypeSymbol* _tmp14_;
			_tmp5_ = _prerequisite_index;
			_prerequisite_index = _tmp5_ + 1;
			_tmp6_ = _prerequisite_index;
			_tmp7_ = _prerequisite_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _prerequisite_list;
			_tmp9_ = _prerequisite_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			prerequisite = (ValaDataType*) _tmp10_;
			_tmp12_ = prerequisite;
			_tmp13_ = vala_data_type_get_data_type (_tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_ != NULL) {
				ValaDataType* _tmp15_;
				ValaTypeSymbol* _tmp16_;
				ValaTypeSymbol* _tmp17_;
				_tmp15_ = prerequisite;
				_tmp16_ = vala_data_type_get_data_type (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp11_ = vala_typesymbol_is_subtype_of (_tmp17_, t);
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				result = TRUE;
				_vala_code_node_unref0 (prerequisite);
				_vala_iterable_unref0 (_prerequisite_list);
				return result;
			}
			_vala_code_node_unref0 (prerequisite);
		}
		_vala_iterable_unref0 (_prerequisite_list);
	}
	result = FALSE;
	return result;
}


static void
vala_interface_real_replace_type (ValaCodeNode* base,
                                  ValaDataType* old_type,
                                  ValaDataType* new_type)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ValaList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				ValaList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				ValaDataType* _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->prerequisites;
				_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->prerequisites;
				_tmp7_ = i;
				_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
				_tmp9_ = (ValaDataType*) _tmp8_;
				_tmp10_ = _tmp9_ == old_type;
				_vala_code_node_unref0 (_tmp9_);
				if (_tmp10_) {
					ValaList* _tmp11_;
					gint _tmp12_;
					_tmp11_ = self->priv->prerequisites;
					_tmp12_ = i;
					vala_list_set (_tmp11_, _tmp12_, new_type);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_type, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}


static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_interface_real_check (ValaCodeNode* base,
                           ValaCodeContext* context)
{
	ValaInterface * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaClass* prereq_class = NULL;
	gboolean _tmp143_;
	gboolean _tmp144_;
	ValaMap* positions = NULL;
	GHashFunc _tmp279_;
	GEqualFunc _tmp280_;
	GEqualFunc _tmp281_;
	ValaHashMap* _tmp282_;
	gboolean ordered_seen = FALSE;
	gboolean unordered_seen = FALSE;
	gboolean _tmp359_;
	ValaSemanticAnalyzer* _tmp382_;
	ValaSemanticAnalyzer* _tmp383_;
	ValaSourceFile* _tmp384_;
	ValaSemanticAnalyzer* _tmp385_;
	ValaSemanticAnalyzer* _tmp386_;
	ValaSymbol* _tmp387_;
	gboolean _tmp388_;
	gboolean _tmp389_;
	self = (ValaInterface*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	{
		ValaList* _prerequisite_reference_list = NULL;
		ValaList* _tmp24_;
		gint _prerequisite_reference_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _prerequisite_reference_index = 0;
		_tmp24_ = vala_interface_get_prerequisites (self);
		_prerequisite_reference_list = _tmp24_;
		_tmp25_ = _prerequisite_reference_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_prerequisite_reference_size = _tmp27_;
		_prerequisite_reference_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			ValaDataType* prerequisite_reference = NULL;
			ValaList* _tmp31_;
			gint _tmp32_;
			gpointer _tmp33_;
			ValaSemanticAnalyzer* _tmp34_;
			ValaSemanticAnalyzer* _tmp35_;
			ValaDataType* _tmp36_;
			_tmp28_ = _prerequisite_reference_index;
			_prerequisite_reference_index = _tmp28_ + 1;
			_tmp29_ = _prerequisite_reference_index;
			_tmp30_ = _prerequisite_reference_size;
			if (!(_tmp29_ < _tmp30_)) {
				break;
			}
			_tmp31_ = _prerequisite_reference_list;
			_tmp32_ = _prerequisite_reference_index;
			_tmp33_ = vala_list_get (_tmp31_, _tmp32_);
			prerequisite_reference = (ValaDataType*) _tmp33_;
			_tmp34_ = vala_code_context_get_analyzer (context);
			_tmp35_ = _tmp34_;
			_tmp36_ = prerequisite_reference;
			if (!vala_semantic_analyzer_is_type_accessible (_tmp35_, (ValaSymbol*) self, _tmp36_)) {
				ValaSourceReference* _tmp37_;
				ValaSourceReference* _tmp38_;
				ValaDataType* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp37_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp38_ = _tmp37_;
				_tmp39_ = prerequisite_reference;
				_tmp40_ = vala_code_node_to_string ((ValaCodeNode*) _tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp43_ = _tmp42_;
				_tmp44_ = g_strdup_printf ("prerequisite `%s` is less accessible than interface `%s`", _tmp41_, _tmp43_);
				_tmp45_ = _tmp44_;
				vala_report_error (_tmp38_, _tmp45_);
				_g_free0 (_tmp45_);
				_g_free0 (_tmp43_);
				_g_free0 (_tmp41_);
				result = FALSE;
				_vala_code_node_unref0 (prerequisite_reference);
				_vala_iterable_unref0 (_prerequisite_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (prerequisite_reference);
		}
		_vala_iterable_unref0 (_prerequisite_reference_list);
	}
	prereq_class = NULL;
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp46_;
		gint _prereq_size = 0;
		ValaList* _tmp47_;
		gint _tmp48_;
		gint _tmp49_;
		gint _prereq_index = 0;
		_tmp46_ = vala_interface_get_prerequisites (self);
		_prereq_list = _tmp46_;
		_tmp47_ = _prereq_list;
		_tmp48_ = vala_collection_get_size ((ValaCollection*) _tmp47_);
		_tmp49_ = _tmp48_;
		_prereq_size = _tmp49_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp50_;
			gint _tmp51_;
			gint _tmp52_;
			ValaDataType* prereq = NULL;
			ValaList* _tmp53_;
			gint _tmp54_;
			gpointer _tmp55_;
			ValaTypeSymbol* class_or_interface = NULL;
			ValaDataType* _tmp56_;
			ValaTypeSymbol* _tmp57_;
			ValaTypeSymbol* _tmp58_;
			ValaTypeSymbol* _tmp59_;
			ValaTypeSymbol* _tmp60_;
			ValaTypeSymbol* _tmp61_;
			ValaTypeSymbol* _tmp71_;
			_tmp50_ = _prereq_index;
			_prereq_index = _tmp50_ + 1;
			_tmp51_ = _prereq_index;
			_tmp52_ = _prereq_size;
			if (!(_tmp51_ < _tmp52_)) {
				break;
			}
			_tmp53_ = _prereq_list;
			_tmp54_ = _prereq_index;
			_tmp55_ = vala_list_get (_tmp53_, _tmp54_);
			prereq = (ValaDataType*) _tmp55_;
			_tmp56_ = prereq;
			_tmp57_ = vala_data_type_get_data_type (_tmp56_);
			_tmp58_ = _tmp57_;
			_tmp59_ = _vala_code_node_ref0 (_tmp58_);
			class_or_interface = _tmp59_;
			_tmp60_ = class_or_interface;
			if (_tmp60_ == NULL) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_vala_code_node_unref0 (class_or_interface);
				_vala_code_node_unref0 (prereq);
				continue;
			}
			_tmp61_ = class_or_interface;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp61_, VALA_TYPE_OBJECT_TYPE_SYMBOL)) {
				ValaSourceReference* _tmp62_;
				ValaSourceReference* _tmp63_;
				gchar* _tmp64_;
				gchar* _tmp65_;
				ValaTypeSymbol* _tmp66_;
				gchar* _tmp67_;
				gchar* _tmp68_;
				gchar* _tmp69_;
				gchar* _tmp70_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp62_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp63_ = _tmp62_;
				_tmp64_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp65_ = _tmp64_;
				_tmp66_ = class_or_interface;
				_tmp67_ = vala_code_node_to_string ((ValaCodeNode*) _tmp66_);
				_tmp68_ = _tmp67_;
				_tmp69_ = g_strdup_printf ("Prerequisite `%s` of interface `%s` is not a class or interface", _tmp65_, _tmp68_);
				_tmp70_ = _tmp69_;
				vala_report_error (_tmp63_, _tmp70_);
				_g_free0 (_tmp70_);
				_g_free0 (_tmp68_);
				_g_free0 (_tmp65_);
				result = FALSE;
				_vala_code_node_unref0 (class_or_interface);
				_vala_code_node_unref0 (prereq);
				_vala_iterable_unref0 (_prereq_list);
				_vala_code_node_unref0 (prereq_class);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp71_ = class_or_interface;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp71_, VALA_TYPE_CLASS)) {
				ValaClass* _tmp72_;
				ValaTypeSymbol* _tmp85_;
				ValaClass* _tmp86_;
				_tmp72_ = prereq_class;
				if (_tmp72_ != NULL) {
					ValaSourceReference* _tmp73_;
					ValaSourceReference* _tmp74_;
					gchar* _tmp75_;
					gchar* _tmp76_;
					ValaTypeSymbol* _tmp77_;
					gchar* _tmp78_;
					gchar* _tmp79_;
					ValaClass* _tmp80_;
					gchar* _tmp81_;
					gchar* _tmp82_;
					gchar* _tmp83_;
					gchar* _tmp84_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp73_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp74_ = _tmp73_;
					_tmp75_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp76_ = _tmp75_;
					_tmp77_ = class_or_interface;
					_tmp78_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp77_);
					_tmp79_ = _tmp78_;
					_tmp80_ = prereq_class;
					_tmp81_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp80_);
					_tmp82_ = _tmp81_;
					_tmp83_ = g_strdup_printf ("%s: Interfaces cannot have multiple instantiable prerequisites (`%s' a" \
"nd `%s')", _tmp76_, _tmp79_, _tmp82_);
					_tmp84_ = _tmp83_;
					vala_report_error (_tmp74_, _tmp84_);
					_g_free0 (_tmp84_);
					_g_free0 (_tmp82_);
					_g_free0 (_tmp79_);
					_g_free0 (_tmp76_);
					result = FALSE;
					_vala_code_node_unref0 (class_or_interface);
					_vala_code_node_unref0 (prereq);
					_vala_iterable_unref0 (_prereq_list);
					_vala_code_node_unref0 (prereq_class);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_tmp85_ = class_or_interface;
				_tmp86_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp85_, VALA_TYPE_CLASS, ValaClass));
				_vala_code_node_unref0 (prereq_class);
				prereq_class = _tmp86_;
			}
			_vala_code_node_unref0 (class_or_interface);
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp87_;
		ValaList* _tmp88_;
		gint _type_size = 0;
		ValaList* _tmp89_;
		gint _tmp90_;
		gint _tmp91_;
		gint _type_index = 0;
		_tmp87_ = self->priv->prerequisites;
		_tmp88_ = _vala_iterable_ref0 (_tmp87_);
		_type_list = _tmp88_;
		_tmp89_ = _type_list;
		_tmp90_ = vala_collection_get_size ((ValaCollection*) _tmp89_);
		_tmp91_ = _tmp90_;
		_type_size = _tmp91_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp92_;
			gint _tmp93_;
			gint _tmp94_;
			ValaDataType* type = NULL;
			ValaList* _tmp95_;
			gint _tmp96_;
			gpointer _tmp97_;
			ValaDataType* _tmp98_;
			_tmp92_ = _type_index;
			_type_index = _tmp92_ + 1;
			_tmp93_ = _type_index;
			_tmp94_ = _type_size;
			if (!(_tmp93_ < _tmp94_)) {
				break;
			}
			_tmp95_ = _type_list;
			_tmp96_ = _type_index;
			_tmp97_ = vala_list_get (_tmp95_, _tmp96_);
			type = (ValaDataType*) _tmp97_;
			_tmp98_ = type;
			vala_code_node_check ((ValaCodeNode*) _tmp98_, context);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp99_;
		gint _p_size = 0;
		ValaList* _tmp100_;
		gint _tmp101_;
		gint _tmp102_;
		gint _p_index = 0;
		_tmp99_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp99_;
		_tmp100_ = _p_list;
		_tmp101_ = vala_collection_get_size ((ValaCollection*) _tmp100_);
		_tmp102_ = _tmp101_;
		_p_size = _tmp102_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp103_;
			gint _tmp104_;
			gint _tmp105_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp106_;
			gint _tmp107_;
			gpointer _tmp108_;
			ValaTypeParameter* _tmp109_;
			_tmp103_ = _p_index;
			_p_index = _tmp103_ + 1;
			_tmp104_ = _p_index;
			_tmp105_ = _p_size;
			if (!(_tmp104_ < _tmp105_)) {
				break;
			}
			_tmp106_ = _p_list;
			_tmp107_ = _p_index;
			_tmp108_ = vala_list_get (_tmp106_, _tmp107_);
			p = (ValaTypeParameter*) _tmp108_;
			_tmp109_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp109_, context);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp110_;
		gint _en_size = 0;
		ValaList* _tmp111_;
		gint _tmp112_;
		gint _tmp113_;
		gint _en_index = 0;
		_tmp110_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_en_list = _tmp110_;
		_tmp111_ = _en_list;
		_tmp112_ = vala_collection_get_size ((ValaCollection*) _tmp111_);
		_tmp113_ = _tmp112_;
		_en_size = _tmp113_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp114_;
			gint _tmp115_;
			gint _tmp116_;
			ValaEnum* en = NULL;
			ValaList* _tmp117_;
			gint _tmp118_;
			gpointer _tmp119_;
			ValaEnum* _tmp120_;
			_tmp114_ = _en_index;
			_en_index = _tmp114_ + 1;
			_tmp115_ = _en_index;
			_tmp116_ = _en_size;
			if (!(_tmp115_ < _tmp116_)) {
				break;
			}
			_tmp117_ = _en_list;
			_tmp118_ = _en_index;
			_tmp119_ = vala_list_get (_tmp117_, _tmp118_);
			en = (ValaEnum*) _tmp119_;
			_tmp120_ = en;
			vala_code_node_check ((ValaCodeNode*) _tmp120_, context);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp121_;
		gint _f_size = 0;
		ValaList* _tmp122_;
		gint _tmp123_;
		gint _tmp124_;
		gint _f_index = 0;
		_tmp121_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_f_list = _tmp121_;
		_tmp122_ = _f_list;
		_tmp123_ = vala_collection_get_size ((ValaCollection*) _tmp122_);
		_tmp124_ = _tmp123_;
		_f_size = _tmp124_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp125_;
			gint _tmp126_;
			gint _tmp127_;
			ValaField* f = NULL;
			ValaList* _tmp128_;
			gint _tmp129_;
			gpointer _tmp130_;
			ValaField* _tmp131_;
			_tmp125_ = _f_index;
			_f_index = _tmp125_ + 1;
			_tmp126_ = _f_index;
			_tmp127_ = _f_size;
			if (!(_tmp126_ < _tmp127_)) {
				break;
			}
			_tmp128_ = _f_list;
			_tmp129_ = _f_index;
			_tmp130_ = vala_list_get (_tmp128_, _tmp129_);
			f = (ValaField*) _tmp130_;
			_tmp131_ = f;
			vala_code_node_check ((ValaCodeNode*) _tmp131_, context);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp132_;
		gint _c_size = 0;
		ValaList* _tmp133_;
		gint _tmp134_;
		gint _tmp135_;
		gint _c_index = 0;
		_tmp132_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_c_list = _tmp132_;
		_tmp133_ = _c_list;
		_tmp134_ = vala_collection_get_size ((ValaCollection*) _tmp133_);
		_tmp135_ = _tmp134_;
		_c_size = _tmp135_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp136_;
			gint _tmp137_;
			gint _tmp138_;
			ValaConstant* c = NULL;
			ValaList* _tmp139_;
			gint _tmp140_;
			gpointer _tmp141_;
			ValaConstant* _tmp142_;
			_tmp136_ = _c_index;
			_c_index = _tmp136_ + 1;
			_tmp137_ = _c_index;
			_tmp138_ = _c_size;
			if (!(_tmp137_ < _tmp138_)) {
				break;
			}
			_tmp139_ = _c_list;
			_tmp140_ = _c_index;
			_tmp141_ = vala_list_get (_tmp139_, _tmp140_);
			c = (ValaConstant*) _tmp141_;
			_tmp142_ = c;
			vala_code_node_check ((ValaCodeNode*) _tmp142_, context);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	_tmp143_ = vala_code_context_get_abi_stability (context);
	_tmp144_ = _tmp143_;
	if (_tmp144_) {
		{
			ValaList* _s_list = NULL;
			ValaList* _tmp145_;
			gint _s_size = 0;
			ValaList* _tmp146_;
			gint _tmp147_;
			gint _tmp148_;
			gint _s_index = 0;
			_tmp145_ = vala_object_type_symbol_get_members ((ValaObjectTypeSymbol*) self);
			_s_list = _tmp145_;
			_tmp146_ = _s_list;
			_tmp147_ = vala_collection_get_size ((ValaCollection*) _tmp146_);
			_tmp148_ = _tmp147_;
			_s_size = _tmp148_;
			_s_index = -1;
			while (TRUE) {
				gint _tmp149_;
				gint _tmp150_;
				gint _tmp151_;
				ValaSymbol* s = NULL;
				ValaList* _tmp152_;
				gint _tmp153_;
				gpointer _tmp154_;
				ValaSymbol* _tmp155_;
				_tmp149_ = _s_index;
				_s_index = _tmp149_ + 1;
				_tmp150_ = _s_index;
				_tmp151_ = _s_size;
				if (!(_tmp150_ < _tmp151_)) {
					break;
				}
				_tmp152_ = _s_list;
				_tmp153_ = _s_index;
				_tmp154_ = vala_list_get (_tmp152_, _tmp153_);
				s = (ValaSymbol*) _tmp154_;
				_tmp155_ = s;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp155_, VALA_TYPE_METHOD)) {
					ValaMethod* m = NULL;
					ValaSymbol* _tmp156_;
					ValaMethod* _tmp157_;
					ValaMethod* _tmp158_;
					gboolean _tmp159_ = FALSE;
					ValaMethod* _tmp160_;
					gboolean _tmp161_;
					gboolean _tmp162_;
					_tmp156_ = s;
					_tmp157_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp156_, VALA_TYPE_METHOD, ValaMethod));
					m = _tmp157_;
					_tmp158_ = m;
					vala_code_node_check ((ValaCodeNode*) _tmp158_, context);
					_tmp160_ = m;
					_tmp161_ = vala_method_get_is_virtual (_tmp160_);
					_tmp162_ = _tmp161_;
					if (_tmp162_) {
						_tmp159_ = TRUE;
					} else {
						ValaMethod* _tmp163_;
						gboolean _tmp164_;
						gboolean _tmp165_;
						_tmp163_ = m;
						_tmp164_ = vala_method_get_is_abstract (_tmp163_);
						_tmp165_ = _tmp164_;
						_tmp159_ = _tmp165_;
					}
					if (_tmp159_) {
						ValaList* _tmp166_;
						ValaMethod* _tmp167_;
						_tmp166_ = self->priv->virtuals;
						_tmp167_ = m;
						vala_collection_add ((ValaCollection*) _tmp166_, (ValaSymbol*) _tmp167_);
					}
					_vala_code_node_unref0 (m);
				} else {
					ValaSymbol* _tmp168_;
					_tmp168_ = s;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp168_, VALA_TYPE_SIGNAL)) {
						ValaSignal* sig = NULL;
						ValaSymbol* _tmp169_;
						ValaSignal* _tmp170_;
						ValaSignal* _tmp171_;
						ValaSignal* _tmp172_;
						gboolean _tmp173_;
						gboolean _tmp174_;
						_tmp169_ = s;
						_tmp170_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp169_, VALA_TYPE_SIGNAL, ValaSignal));
						sig = _tmp170_;
						_tmp171_ = sig;
						vala_code_node_check ((ValaCodeNode*) _tmp171_, context);
						_tmp172_ = sig;
						_tmp173_ = vala_signal_get_is_virtual (_tmp172_);
						_tmp174_ = _tmp173_;
						if (_tmp174_) {
							ValaList* _tmp175_;
							ValaSignal* _tmp176_;
							_tmp175_ = self->priv->virtuals;
							_tmp176_ = sig;
							vala_collection_add ((ValaCollection*) _tmp175_, (ValaSymbol*) _tmp176_);
						}
						_vala_code_node_unref0 (sig);
					} else {
						ValaSymbol* _tmp177_;
						_tmp177_ = s;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp177_, VALA_TYPE_PROPERTY)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp178_;
							ValaProperty* _tmp179_;
							ValaProperty* _tmp180_;
							gboolean _tmp181_ = FALSE;
							ValaProperty* _tmp182_;
							gboolean _tmp183_;
							gboolean _tmp184_;
							_tmp178_ = s;
							_tmp179_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp178_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp179_;
							_tmp180_ = prop;
							vala_code_node_check ((ValaCodeNode*) _tmp180_, context);
							_tmp182_ = prop;
							_tmp183_ = vala_property_get_is_virtual (_tmp182_);
							_tmp184_ = _tmp183_;
							if (_tmp184_) {
								_tmp181_ = TRUE;
							} else {
								ValaProperty* _tmp185_;
								gboolean _tmp186_;
								gboolean _tmp187_;
								_tmp185_ = prop;
								_tmp186_ = vala_property_get_is_abstract (_tmp185_);
								_tmp187_ = _tmp186_;
								_tmp181_ = _tmp187_;
							}
							if (_tmp181_) {
								ValaList* _tmp188_;
								ValaProperty* _tmp189_;
								_tmp188_ = self->priv->virtuals;
								_tmp189_ = prop;
								vala_collection_add ((ValaCollection*) _tmp188_, (ValaSymbol*) _tmp189_);
							}
							_vala_code_node_unref0 (prop);
						}
					}
				}
				_vala_code_node_unref0 (s);
			}
			_vala_iterable_unref0 (_s_list);
		}
	} else {
		{
			ValaList* _m_list = NULL;
			ValaList* _tmp190_;
			gint _m_size = 0;
			ValaList* _tmp191_;
			gint _tmp192_;
			gint _tmp193_;
			gint _m_index = 0;
			_tmp190_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
			_m_list = _tmp190_;
			_tmp191_ = _m_list;
			_tmp192_ = vala_collection_get_size ((ValaCollection*) _tmp191_);
			_tmp193_ = _tmp192_;
			_m_size = _tmp193_;
			_m_index = -1;
			while (TRUE) {
				gint _tmp194_;
				gint _tmp195_;
				gint _tmp196_;
				ValaMethod* m = NULL;
				ValaList* _tmp197_;
				gint _tmp198_;
				gpointer _tmp199_;
				ValaMethod* _tmp200_;
				gboolean _tmp201_ = FALSE;
				ValaMethod* _tmp202_;
				gboolean _tmp203_;
				gboolean _tmp204_;
				_tmp194_ = _m_index;
				_m_index = _tmp194_ + 1;
				_tmp195_ = _m_index;
				_tmp196_ = _m_size;
				if (!(_tmp195_ < _tmp196_)) {
					break;
				}
				_tmp197_ = _m_list;
				_tmp198_ = _m_index;
				_tmp199_ = vala_list_get (_tmp197_, _tmp198_);
				m = (ValaMethod*) _tmp199_;
				_tmp200_ = m;
				vala_code_node_check ((ValaCodeNode*) _tmp200_, context);
				_tmp202_ = m;
				_tmp203_ = vala_method_get_is_virtual (_tmp202_);
				_tmp204_ = _tmp203_;
				if (_tmp204_) {
					_tmp201_ = TRUE;
				} else {
					ValaMethod* _tmp205_;
					gboolean _tmp206_;
					gboolean _tmp207_;
					_tmp205_ = m;
					_tmp206_ = vala_method_get_is_abstract (_tmp205_);
					_tmp207_ = _tmp206_;
					_tmp201_ = _tmp207_;
				}
				if (_tmp201_) {
					ValaList* _tmp208_;
					ValaMethod* _tmp209_;
					_tmp208_ = self->priv->virtuals;
					_tmp209_ = m;
					vala_collection_add ((ValaCollection*) _tmp208_, (ValaSymbol*) _tmp209_);
				}
				_vala_code_node_unref0 (m);
			}
			_vala_iterable_unref0 (_m_list);
		}
		{
			ValaList* _sig_list = NULL;
			ValaList* _tmp210_;
			gint _sig_size = 0;
			ValaList* _tmp211_;
			gint _tmp212_;
			gint _tmp213_;
			gint _sig_index = 0;
			_tmp210_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
			_sig_list = _tmp210_;
			_tmp211_ = _sig_list;
			_tmp212_ = vala_collection_get_size ((ValaCollection*) _tmp211_);
			_tmp213_ = _tmp212_;
			_sig_size = _tmp213_;
			_sig_index = -1;
			while (TRUE) {
				gint _tmp214_;
				gint _tmp215_;
				gint _tmp216_;
				ValaSignal* sig = NULL;
				ValaList* _tmp217_;
				gint _tmp218_;
				gpointer _tmp219_;
				ValaSignal* _tmp220_;
				ValaSignal* _tmp221_;
				gboolean _tmp222_;
				gboolean _tmp223_;
				_tmp214_ = _sig_index;
				_sig_index = _tmp214_ + 1;
				_tmp215_ = _sig_index;
				_tmp216_ = _sig_size;
				if (!(_tmp215_ < _tmp216_)) {
					break;
				}
				_tmp217_ = _sig_list;
				_tmp218_ = _sig_index;
				_tmp219_ = vala_list_get (_tmp217_, _tmp218_);
				sig = (ValaSignal*) _tmp219_;
				_tmp220_ = sig;
				vala_code_node_check ((ValaCodeNode*) _tmp220_, context);
				_tmp221_ = sig;
				_tmp222_ = vala_signal_get_is_virtual (_tmp221_);
				_tmp223_ = _tmp222_;
				if (_tmp223_) {
					ValaList* _tmp224_;
					ValaSignal* _tmp225_;
					_tmp224_ = self->priv->virtuals;
					_tmp225_ = sig;
					vala_collection_add ((ValaCollection*) _tmp224_, (ValaSymbol*) _tmp225_);
				}
				_vala_code_node_unref0 (sig);
			}
			_vala_iterable_unref0 (_sig_list);
		}
		{
			ValaList* _prop_list = NULL;
			ValaList* _tmp226_;
			gint _prop_size = 0;
			ValaList* _tmp227_;
			gint _tmp228_;
			gint _tmp229_;
			gint _prop_index = 0;
			_tmp226_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
			_prop_list = _tmp226_;
			_tmp227_ = _prop_list;
			_tmp228_ = vala_collection_get_size ((ValaCollection*) _tmp227_);
			_tmp229_ = _tmp228_;
			_prop_size = _tmp229_;
			_prop_index = -1;
			while (TRUE) {
				gint _tmp230_;
				gint _tmp231_;
				gint _tmp232_;
				ValaProperty* prop = NULL;
				ValaList* _tmp233_;
				gint _tmp234_;
				gpointer _tmp235_;
				ValaProperty* _tmp236_;
				gboolean _tmp237_ = FALSE;
				ValaProperty* _tmp238_;
				gboolean _tmp239_;
				gboolean _tmp240_;
				_tmp230_ = _prop_index;
				_prop_index = _tmp230_ + 1;
				_tmp231_ = _prop_index;
				_tmp232_ = _prop_size;
				if (!(_tmp231_ < _tmp232_)) {
					break;
				}
				_tmp233_ = _prop_list;
				_tmp234_ = _prop_index;
				_tmp235_ = vala_list_get (_tmp233_, _tmp234_);
				prop = (ValaProperty*) _tmp235_;
				_tmp236_ = prop;
				vala_code_node_check ((ValaCodeNode*) _tmp236_, context);
				_tmp238_ = prop;
				_tmp239_ = vala_property_get_is_virtual (_tmp238_);
				_tmp240_ = _tmp239_;
				if (_tmp240_) {
					_tmp237_ = TRUE;
				} else {
					ValaProperty* _tmp241_;
					gboolean _tmp242_;
					gboolean _tmp243_;
					_tmp241_ = prop;
					_tmp242_ = vala_property_get_is_abstract (_tmp241_);
					_tmp243_ = _tmp242_;
					_tmp237_ = _tmp243_;
				}
				if (_tmp237_) {
					ValaList* _tmp244_;
					ValaProperty* _tmp245_;
					_tmp244_ = self->priv->virtuals;
					_tmp245_ = prop;
					vala_collection_add ((ValaCollection*) _tmp244_, (ValaSymbol*) _tmp245_);
				}
				_vala_code_node_unref0 (prop);
			}
			_vala_iterable_unref0 (_prop_list);
		}
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp246_;
		gint _cl_size = 0;
		ValaList* _tmp247_;
		gint _tmp248_;
		gint _tmp249_;
		gint _cl_index = 0;
		_tmp246_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_cl_list = _tmp246_;
		_tmp247_ = _cl_list;
		_tmp248_ = vala_collection_get_size ((ValaCollection*) _tmp247_);
		_tmp249_ = _tmp248_;
		_cl_size = _tmp249_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp250_;
			gint _tmp251_;
			gint _tmp252_;
			ValaClass* cl = NULL;
			ValaList* _tmp253_;
			gint _tmp254_;
			gpointer _tmp255_;
			ValaClass* _tmp256_;
			_tmp250_ = _cl_index;
			_cl_index = _tmp250_ + 1;
			_tmp251_ = _cl_index;
			_tmp252_ = _cl_size;
			if (!(_tmp251_ < _tmp252_)) {
				break;
			}
			_tmp253_ = _cl_list;
			_tmp254_ = _cl_index;
			_tmp255_ = vala_list_get (_tmp253_, _tmp254_);
			cl = (ValaClass*) _tmp255_;
			_tmp256_ = cl;
			vala_code_node_check ((ValaCodeNode*) _tmp256_, context);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp257_;
		gint _st_size = 0;
		ValaList* _tmp258_;
		gint _tmp259_;
		gint _tmp260_;
		gint _st_index = 0;
		_tmp257_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_st_list = _tmp257_;
		_tmp258_ = _st_list;
		_tmp259_ = vala_collection_get_size ((ValaCollection*) _tmp258_);
		_tmp260_ = _tmp259_;
		_st_size = _tmp260_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp261_;
			gint _tmp262_;
			gint _tmp263_;
			ValaStruct* st = NULL;
			ValaList* _tmp264_;
			gint _tmp265_;
			gpointer _tmp266_;
			ValaStruct* _tmp267_;
			_tmp261_ = _st_index;
			_st_index = _tmp261_ + 1;
			_tmp262_ = _st_index;
			_tmp263_ = _st_size;
			if (!(_tmp262_ < _tmp263_)) {
				break;
			}
			_tmp264_ = _st_list;
			_tmp265_ = _st_index;
			_tmp266_ = vala_list_get (_tmp264_, _tmp265_);
			st = (ValaStruct*) _tmp266_;
			_tmp267_ = st;
			vala_code_node_check ((ValaCodeNode*) _tmp267_, context);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp268_;
		gint _d_size = 0;
		ValaList* _tmp269_;
		gint _tmp270_;
		gint _tmp271_;
		gint _d_index = 0;
		_tmp268_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_d_list = _tmp268_;
		_tmp269_ = _d_list;
		_tmp270_ = vala_collection_get_size ((ValaCollection*) _tmp269_);
		_tmp271_ = _tmp270_;
		_d_size = _tmp271_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp272_;
			gint _tmp273_;
			gint _tmp274_;
			ValaDelegate* d = NULL;
			ValaList* _tmp275_;
			gint _tmp276_;
			gpointer _tmp277_;
			ValaDelegate* _tmp278_;
			_tmp272_ = _d_index;
			_d_index = _tmp272_ + 1;
			_tmp273_ = _d_index;
			_tmp274_ = _d_size;
			if (!(_tmp273_ < _tmp274_)) {
				break;
			}
			_tmp275_ = _d_list;
			_tmp276_ = _d_index;
			_tmp277_ = vala_list_get (_tmp275_, _tmp276_);
			d = (ValaDelegate*) _tmp277_;
			_tmp278_ = d;
			vala_code_node_check ((ValaCodeNode*) _tmp278_, context);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
	_tmp279_ = g_direct_hash;
	_tmp280_ = g_direct_equal;
	_tmp281_ = g_direct_equal;
	_tmp282_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp279_, _tmp280_, _tmp281_);
	positions = (ValaMap*) _tmp282_;
	ordered_seen = FALSE;
	unordered_seen = FALSE;
	{
		ValaList* _sym_list = NULL;
		ValaList* _tmp283_;
		ValaList* _tmp284_;
		gint _sym_size = 0;
		ValaList* _tmp285_;
		gint _tmp286_;
		gint _tmp287_;
		gint _sym_index = 0;
		_tmp283_ = self->priv->virtuals;
		_tmp284_ = _vala_iterable_ref0 (_tmp283_);
		_sym_list = _tmp284_;
		_tmp285_ = _sym_list;
		_tmp286_ = vala_collection_get_size ((ValaCollection*) _tmp285_);
		_tmp287_ = _tmp286_;
		_sym_size = _tmp287_;
		_sym_index = -1;
		while (TRUE) {
			gint _tmp288_;
			gint _tmp289_;
			gint _tmp290_;
			ValaSymbol* sym = NULL;
			ValaList* _tmp291_;
			gint _tmp292_;
			gpointer _tmp293_;
			gint ordering = 0;
			ValaSymbol* _tmp294_;
			gint _tmp295_;
			gboolean ordered = FALSE;
			gint _tmp304_;
			gboolean _tmp305_ = FALSE;
			gboolean _tmp306_ = FALSE;
			gboolean _tmp307_;
			gboolean _tmp318_ = FALSE;
			gboolean _tmp319_;
			gboolean _tmp321_ = FALSE;
			gboolean _tmp322_ = FALSE;
			gboolean _tmp323_;
			gboolean _tmp334_ = FALSE;
			gboolean _tmp335_;
			gboolean _tmp337_ = FALSE;
			gboolean _tmp338_;
			_tmp288_ = _sym_index;
			_sym_index = _tmp288_ + 1;
			_tmp289_ = _sym_index;
			_tmp290_ = _sym_size;
			if (!(_tmp289_ < _tmp290_)) {
				break;
			}
			_tmp291_ = _sym_list;
			_tmp292_ = _sym_index;
			_tmp293_ = vala_list_get (_tmp291_, _tmp292_);
			sym = (ValaSymbol*) _tmp293_;
			_tmp294_ = sym;
			ordering = vala_code_node_get_attribute_integer ((ValaCodeNode*) _tmp294_, "CCode", "ordering", -1);
			_tmp295_ = ordering;
			if (_tmp295_ < -1) {
				ValaSymbol* _tmp296_;
				ValaSourceReference* _tmp297_;
				ValaSourceReference* _tmp298_;
				ValaSymbol* _tmp299_;
				gchar* _tmp300_;
				gchar* _tmp301_;
				gchar* _tmp302_;
				gchar* _tmp303_;
				_tmp296_ = sym;
				_tmp297_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp296_);
				_tmp298_ = _tmp297_;
				_tmp299_ = sym;
				_tmp300_ = vala_symbol_get_full_name (_tmp299_);
				_tmp301_ = _tmp300_;
				_tmp302_ = g_strdup_printf ("%s: Invalid ordering", _tmp301_);
				_tmp303_ = _tmp302_;
				vala_report_error (_tmp298_, _tmp303_);
				_g_free0 (_tmp303_);
				_g_free0 (_tmp301_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				ordered_seen = TRUE;
				unordered_seen = TRUE;
				_vala_code_node_unref0 (sym);
				continue;
			}
			_tmp304_ = ordering;
			ordered = _tmp304_ != -1;
			_tmp307_ = ordered;
			if (_tmp307_) {
				gboolean _tmp308_;
				_tmp308_ = unordered_seen;
				_tmp306_ = _tmp308_;
			} else {
				_tmp306_ = FALSE;
			}
			if (_tmp306_) {
				gboolean _tmp309_;
				_tmp309_ = ordered_seen;
				_tmp305_ = !_tmp309_;
			} else {
				_tmp305_ = FALSE;
			}
			if (_tmp305_) {
				ValaSymbol* _tmp310_;
				ValaSourceReference* _tmp311_;
				ValaSourceReference* _tmp312_;
				ValaSymbol* _tmp313_;
				gchar* _tmp314_;
				gchar* _tmp315_;
				gchar* _tmp316_;
				gchar* _tmp317_;
				_tmp310_ = sym;
				_tmp311_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp310_);
				_tmp312_ = _tmp311_;
				_tmp313_ = sym;
				_tmp314_ = vala_symbol_get_full_name (_tmp313_);
				_tmp315_ = _tmp314_;
				_tmp316_ = g_strdup_printf ("%s: Cannot mix ordered and unordered virtuals", _tmp315_);
				_tmp317_ = _tmp316_;
				vala_report_error (_tmp312_, _tmp317_);
				_g_free0 (_tmp317_);
				_g_free0 (_tmp315_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_tmp319_ = ordered_seen;
			if (_tmp319_) {
				_tmp318_ = TRUE;
			} else {
				gboolean _tmp320_;
				_tmp320_ = ordered;
				_tmp318_ = _tmp320_;
			}
			ordered_seen = _tmp318_;
			_tmp323_ = ordered;
			if (!_tmp323_) {
				gboolean _tmp324_;
				_tmp324_ = unordered_seen;
				_tmp322_ = !_tmp324_;
			} else {
				_tmp322_ = FALSE;
			}
			if (_tmp322_) {
				gboolean _tmp325_;
				_tmp325_ = ordered_seen;
				_tmp321_ = _tmp325_;
			} else {
				_tmp321_ = FALSE;
			}
			if (_tmp321_) {
				ValaSymbol* _tmp326_;
				ValaSourceReference* _tmp327_;
				ValaSourceReference* _tmp328_;
				ValaSymbol* _tmp329_;
				gchar* _tmp330_;
				gchar* _tmp331_;
				gchar* _tmp332_;
				gchar* _tmp333_;
				_tmp326_ = sym;
				_tmp327_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp326_);
				_tmp328_ = _tmp327_;
				_tmp329_ = sym;
				_tmp330_ = vala_symbol_get_full_name (_tmp329_);
				_tmp331_ = _tmp330_;
				_tmp332_ = g_strdup_printf ("%s: Cannot mix ordered and unordered virtuals", _tmp331_);
				_tmp333_ = _tmp332_;
				vala_report_error (_tmp328_, _tmp333_);
				_g_free0 (_tmp333_);
				_g_free0 (_tmp331_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_tmp335_ = unordered_seen;
			if (_tmp335_) {
				_tmp334_ = TRUE;
			} else {
				gboolean _tmp336_;
				_tmp336_ = ordered;
				_tmp334_ = !_tmp336_;
			}
			unordered_seen = _tmp334_;
			_tmp338_ = ordered_seen;
			if (!_tmp338_) {
				_tmp337_ = TRUE;
			} else {
				gboolean _tmp339_;
				_tmp339_ = unordered_seen;
				_tmp337_ = !_tmp339_;
			}
			if (_tmp337_) {
				gboolean _tmp340_;
				_tmp340_ = ordered;
				if (_tmp340_) {
					ValaSymbol* prev = NULL;
					ValaMap* _tmp341_;
					gint _tmp342_;
					gpointer _tmp343_;
					ValaSymbol* _tmp344_;
					ValaMap* _tmp356_;
					gint _tmp357_;
					ValaSymbol* _tmp358_;
					_tmp341_ = positions;
					_tmp342_ = ordering;
					_tmp343_ = vala_map_get (_tmp341_, (gpointer) ((gintptr) _tmp342_));
					prev = (ValaSymbol*) _tmp343_;
					_tmp344_ = prev;
					if (_tmp344_ != NULL) {
						ValaSymbol* _tmp345_;
						ValaSourceReference* _tmp346_;
						ValaSourceReference* _tmp347_;
						ValaSymbol* _tmp348_;
						gchar* _tmp349_;
						gchar* _tmp350_;
						ValaSymbol* _tmp351_;
						const gchar* _tmp352_;
						const gchar* _tmp353_;
						gchar* _tmp354_;
						gchar* _tmp355_;
						_tmp345_ = sym;
						_tmp346_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp345_);
						_tmp347_ = _tmp346_;
						_tmp348_ = sym;
						_tmp349_ = vala_symbol_get_full_name (_tmp348_);
						_tmp350_ = _tmp349_;
						_tmp351_ = prev;
						_tmp352_ = vala_symbol_get_name (_tmp351_);
						_tmp353_ = _tmp352_;
						_tmp354_ = g_strdup_printf ("%s: Duplicate ordering (previous virtual with the same position is %s)", _tmp350_, _tmp353_);
						_tmp355_ = _tmp354_;
						vala_report_error (_tmp347_, _tmp355_);
						_g_free0 (_tmp355_);
						_g_free0 (_tmp350_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
					_tmp356_ = positions;
					_tmp357_ = ordering;
					_tmp358_ = sym;
					vala_map_set (_tmp356_, (gpointer) ((gintptr) _tmp357_), _tmp358_);
					_vala_code_node_unref0 (prev);
				}
			}
			_vala_code_node_unref0 (sym);
		}
		_vala_iterable_unref0 (_sym_list);
	}
	_tmp359_ = ordered_seen;
	if (_tmp359_) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp360_ = FALSE;
				_tmp360_ = TRUE;
				while (TRUE) {
					gint _tmp362_;
					ValaList* _tmp363_;
					gint _tmp364_;
					gint _tmp365_;
					ValaSymbol* sym = NULL;
					ValaMap* _tmp366_;
					gint _tmp367_;
					gpointer _tmp368_;
					ValaSymbol* _tmp369_;
					gboolean _tmp377_;
					gboolean _tmp378_;
					if (!_tmp360_) {
						gint _tmp361_;
						_tmp361_ = i;
						i = _tmp361_ + 1;
					}
					_tmp360_ = FALSE;
					_tmp362_ = i;
					_tmp363_ = self->priv->virtuals;
					_tmp364_ = vala_collection_get_size ((ValaCollection*) _tmp363_);
					_tmp365_ = _tmp364_;
					if (!(_tmp362_ < _tmp365_)) {
						break;
					}
					_tmp366_ = positions;
					_tmp367_ = i;
					_tmp368_ = vala_map_get (_tmp366_, (gpointer) ((gintptr) _tmp367_));
					sym = (ValaSymbol*) _tmp368_;
					_tmp369_ = sym;
					if (_tmp369_ == NULL) {
						ValaSourceReference* _tmp370_;
						ValaSourceReference* _tmp371_;
						gchar* _tmp372_;
						gchar* _tmp373_;
						gint _tmp374_;
						gchar* _tmp375_;
						gchar* _tmp376_;
						_tmp370_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp371_ = _tmp370_;
						_tmp372_ = vala_symbol_get_full_name ((ValaSymbol*) self);
						_tmp373_ = _tmp372_;
						_tmp374_ = i;
						_tmp375_ = g_strdup_printf ("%s: Gap in ordering in position %d", _tmp373_, _tmp374_);
						_tmp376_ = _tmp375_;
						vala_report_error (_tmp371_, _tmp376_);
						_g_free0 (_tmp376_);
						_g_free0 (_tmp373_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
					_tmp377_ = vala_code_node_get_error ((ValaCodeNode*) self);
					_tmp378_ = _tmp377_;
					if (!_tmp378_) {
						ValaList* _tmp379_;
						gint _tmp380_;
						ValaSymbol* _tmp381_;
						_tmp379_ = self->priv->virtuals;
						_tmp380_ = i;
						_tmp381_ = sym;
						vala_list_set (_tmp379_, _tmp380_, _tmp381_);
					}
					_vala_code_node_unref0 (sym);
				}
			}
		}
	}
	_tmp382_ = vala_code_context_get_analyzer (context);
	_tmp383_ = _tmp382_;
	_tmp384_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp383_, _tmp384_);
	_tmp385_ = vala_code_context_get_analyzer (context);
	_tmp386_ = _tmp385_;
	_tmp387_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp386_, _tmp387_);
	_tmp388_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp389_ = _tmp388_;
	result = !_tmp389_;
	_vala_map_unref0 (positions);
	_vala_code_node_unref0 (prereq_class);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


static void
vala_interface_class_init (ValaInterfaceClass * klass)
{
	vala_interface_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_interface_finalize;
	g_type_class_add_private (klass, sizeof (ValaInterfacePrivate));
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol *, ValaMethod*)) vala_interface_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol *, ValaProperty*)) vala_interface_real_add_property;
	((ValaInterfaceClass *) klass)->get_virtuals = (ValaList* (*) (ValaInterface *)) vala_interface_real_get_virtuals;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_interface_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_interface_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol *)) vala_interface_real_is_reference_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol *, ValaTypeSymbol*)) vala_interface_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode *, ValaDataType*, ValaDataType*)) vala_interface_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_interface_real_check;
}


static void
vala_interface_instance_init (ValaInterface * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = VALA_INTERFACE_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->prerequisites = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->virtuals = (ValaList*) _tmp3_;
}


static void
vala_interface_finalize (ValaCodeNode * obj)
{
	ValaInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_INTERFACE, ValaInterface);
	_vala_iterable_unref0 (self->priv->prerequisites);
	_vala_iterable_unref0 (self->priv->virtuals);
	VALA_CODE_NODE_CLASS (vala_interface_parent_class)->finalize (obj);
}


/**
 * Represents a class declaration in the source code.
 */
GType
vala_interface_get_type (void)
{
	static volatile gsize vala_interface_type_id__volatile = 0;
	if (g_once_init_enter (&vala_interface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInterface), 0, (GInstanceInitFunc) vala_interface_instance_init, NULL };
		GType vala_interface_type_id;
		vala_interface_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaInterface", &g_define_type_info, 0);
		g_once_init_leave (&vala_interface_type_id__volatile, vala_interface_type_id);
	}
	return vala_interface_type_id__volatile;
}



