/* valainterface.c generated by valac, the Vala compiler
 * generated from valainterface.vala, do not modify */

/* valainterface.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))

struct _ValaInterfacePrivate {
	ValaList* prerequisites;
	ValaList* virtuals;
};


static gpointer vala_interface_parent_class = NULL;

#define VALA_INTERFACE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_INTERFACE, ValaInterfacePrivate))
static void vala_interface_real_add_method (ValaSymbol* base,
                                     ValaMethod* m);
static void vala_interface_real_add_property (ValaSymbol* base,
                                       ValaProperty* prop);
static ValaList* vala_interface_real_get_virtuals (ValaInterface* self);
static void vala_interface_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor);
static void vala_interface_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor);
static gboolean vala_interface_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_interface_real_is_subtype_of (ValaTypeSymbol* base,
                                            ValaTypeSymbol* t);
static void vala_interface_real_replace_type (ValaCodeNode* base,
                                       ValaDataType* old_type,
                                       ValaDataType* new_type);
static gboolean vala_interface_real_check (ValaCodeNode* base,
                                    ValaCodeContext* context);
static void vala_interface_finalize (ValaCodeNode * obj);


/**
 * Creates a new interface.
 *
 * @param name              type name
 * @param source_reference  reference to source code
 * @return                  newly created interface
 */
ValaInterface*
vala_interface_construct (GType object_type,
                          const gchar* name,
                          ValaSourceReference* source_reference,
                          ValaComment* comment)
{
	ValaInterface* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaInterface*) vala_object_type_symbol_construct (object_type, name, source_reference, comment);
	return self;
}


ValaInterface*
vala_interface_new (const gchar* name,
                    ValaSourceReference* source_reference,
                    ValaComment* comment)
{
	return vala_interface_construct (VALA_TYPE_INTERFACE, name, source_reference, comment);
}


/**
 * Adds the specified interface or class to the list of prerequisites of
 * this interface.
 *
 * @param type an interface or class reference
 */
void
vala_interface_add_prerequisite (ValaInterface* self,
                                 ValaDataType* type)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->prerequisites;
	vala_collection_add ((ValaCollection*) _tmp0_, type);
	vala_code_node_set_parent_node ((ValaCodeNode*) type, (ValaCodeNode*) self);
}


/**
 * Prepends the specified interface or class to the list of
 * prerequisites of this interface.
 *
 * @param type an interface or class reference
 */
void
vala_interface_prepend_prerequisite (ValaInterface* self,
                                     ValaDataType* type)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->prerequisites;
	vala_list_insert (_tmp0_, 0, type);
}


/**
 * Returns a copy of the base type list.
 *
 * @return list of base types
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_interface_get_prerequisites (ValaInterface* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prerequisites;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified method as a member to this interface.
 *
 * @param m a method
 */
static void
vala_interface_real_add_method (ValaSymbol* base,
                                ValaMethod* m)
{
	ValaInterface * self;
	ValaMemberBinding _tmp2_;
	ValaMemberBinding _tmp3_;
	gboolean _tmp16_ = FALSE;
	ValaDataType* _tmp17_;
	ValaDataType* _tmp18_;
	self = (ValaInterface*) base;
	g_return_if_fail (m != NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (m, VALA_TYPE_CREATION_METHOD)) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp1_ = _tmp0_;
		vala_report_error (_tmp1_, "construction methods may only be declared within classes and structs");
		vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
		return;
	}
	_tmp2_ = vala_method_get_binding (m);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaObjectType* _tmp4_;
		ValaObjectType* _tmp5_;
		ValaParameter* _tmp6_;
		ValaParameter* _tmp7_;
		ValaScope* _tmp8_;
		ValaScope* _tmp9_;
		ValaParameter* _tmp10_;
		ValaParameter* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		ValaParameter* _tmp14_;
		ValaParameter* _tmp15_;
		_tmp4_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_parameter_new ("this", (ValaDataType*) _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		vala_method_set_this_parameter (m, _tmp7_);
		_vala_code_node_unref0 (_tmp7_);
		_vala_code_node_unref0 (_tmp5_);
		_tmp8_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_method_get_this_parameter (m);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_method_get_this_parameter (m);
		_tmp15_ = _tmp14_;
		vala_scope_add (_tmp9_, _tmp13_, (ValaSymbol*) _tmp15_);
	}
	_tmp17_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp18_ = _tmp17_;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, VALA_TYPE_VOID_TYPE)) {
		ValaList* _tmp19_;
		ValaList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		_tmp19_ = vala_method_get_postconditions (m);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp16_ = _tmp22_ > 0;
		_vala_iterable_unref0 (_tmp20_);
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		ValaDataType* _tmp23_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaDataType* _tmp26_;
		ValaSourceReference* _tmp27_;
		ValaSourceReference* _tmp28_;
		ValaLocalVariable* _tmp29_;
		ValaLocalVariable* _tmp30_;
		ValaLocalVariable* _tmp31_;
		ValaLocalVariable* _tmp32_;
		_tmp23_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp24_ = _tmp23_;
		_tmp25_ = vala_data_type_copy (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp28_ = _tmp27_;
		_tmp29_ = vala_local_variable_new (_tmp26_, "result", NULL, _tmp28_);
		_tmp30_ = _tmp29_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp30_);
		_vala_code_node_unref0 (_tmp30_);
		_vala_code_node_unref0 (_tmp26_);
		_tmp31_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp32_ = _tmp31_;
		vala_local_variable_set_is_result (_tmp32_, TRUE);
	}
	VALA_SYMBOL_CLASS (vala_interface_parent_class)->add_method ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), m);
}


/**
 * Adds the specified property as a member to this interface.
 *
 * @param prop a property
 */
static void
vala_interface_real_add_property (ValaSymbol* base,
                                  ValaProperty* prop)
{
	ValaInterface * self;
	ValaField* _tmp0_;
	ValaField* _tmp1_;
	ValaObjectType* _tmp4_;
	ValaObjectType* _tmp5_;
	ValaParameter* _tmp6_;
	ValaParameter* _tmp7_;
	ValaScope* _tmp8_;
	ValaScope* _tmp9_;
	ValaParameter* _tmp10_;
	ValaParameter* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	ValaParameter* _tmp14_;
	ValaParameter* _tmp15_;
	self = (ValaInterface*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = vala_property_get_field (prop);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) prop);
		_tmp3_ = _tmp2_;
		vala_report_error (_tmp3_, "automatic properties are not allowed in interfaces");
		vala_code_node_set_error ((ValaCodeNode*) prop, TRUE);
		return;
	}
	VALA_SYMBOL_CLASS (vala_interface_parent_class)->add_property ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), prop);
	_tmp4_ = vala_object_type_new ((ValaObjectTypeSymbol*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_parameter_new ("this", (ValaDataType*) _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	vala_property_set_this_parameter (prop, _tmp7_);
	_vala_code_node_unref0 (_tmp7_);
	_vala_code_node_unref0 (_tmp5_);
	_tmp8_ = vala_symbol_get_scope ((ValaSymbol*) prop);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_property_get_this_parameter (prop);
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_property_get_this_parameter (prop);
	_tmp15_ = _tmp14_;
	vala_scope_add (_tmp9_, _tmp13_, (ValaSymbol*) _tmp15_);
}


static ValaList*
vala_interface_real_get_virtuals (ValaInterface* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	_tmp0_ = self->priv->virtuals;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


ValaList*
vala_interface_get_virtuals (ValaInterface* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_INTERFACE_GET_CLASS (self)->get_virtuals (self);
}


static void
vala_interface_real_accept (ValaCodeNode* base,
                            ValaCodeVisitor* visitor)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_interface (visitor, self);
}


static void
vala_interface_real_accept_children (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _type_index = 0;
		_tmp0_ = self->priv->prerequisites;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_type_list = _tmp1_;
		_tmp2_ = _type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_type_size = _tmp4_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaDataType* type = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaDataType* _tmp11_;
			_tmp5_ = _type_index;
			_type_index = _tmp5_ + 1;
			_tmp6_ = _type_index;
			_tmp7_ = _type_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _type_list;
			_tmp9_ = _type_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			type = (ValaDataType*) _tmp10_;
			_tmp11_ = type;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp12_;
		gint _p_size = 0;
		ValaList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _p_index = 0;
		_tmp12_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp12_;
		_tmp13_ = _p_list;
		_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_p_size = _tmp15_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp19_;
			gint _tmp20_;
			gpointer _tmp21_;
			ValaTypeParameter* _tmp22_;
			_tmp16_ = _p_index;
			_p_index = _tmp16_ + 1;
			_tmp17_ = _p_index;
			_tmp18_ = _p_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _p_list;
			_tmp20_ = _p_index;
			_tmp21_ = vala_list_get (_tmp19_, _tmp20_);
			p = (ValaTypeParameter*) _tmp21_;
			_tmp22_ = p;
			vala_code_node_accept ((ValaCodeNode*) _tmp22_, visitor);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp23_;
		gint _en_size = 0;
		ValaList* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _en_index = 0;
		_tmp23_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_en_list = _tmp23_;
		_tmp24_ = _en_list;
		_tmp25_ = vala_collection_get_size ((ValaCollection*) _tmp24_);
		_tmp26_ = _tmp25_;
		_en_size = _tmp26_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			ValaEnum* en = NULL;
			ValaList* _tmp30_;
			gint _tmp31_;
			gpointer _tmp32_;
			ValaEnum* _tmp33_;
			_tmp27_ = _en_index;
			_en_index = _tmp27_ + 1;
			_tmp28_ = _en_index;
			_tmp29_ = _en_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _en_list;
			_tmp31_ = _en_index;
			_tmp32_ = vala_list_get (_tmp30_, _tmp31_);
			en = (ValaEnum*) _tmp32_;
			_tmp33_ = en;
			vala_code_node_accept ((ValaCodeNode*) _tmp33_, visitor);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp34_;
		gint _m_size = 0;
		ValaList* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		gint _m_index = 0;
		_tmp34_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
		_m_list = _tmp34_;
		_tmp35_ = _m_list;
		_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
		_tmp37_ = _tmp36_;
		_m_size = _tmp37_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp38_;
			gint _tmp39_;
			gint _tmp40_;
			ValaMethod* m = NULL;
			ValaList* _tmp41_;
			gint _tmp42_;
			gpointer _tmp43_;
			ValaMethod* _tmp44_;
			_tmp38_ = _m_index;
			_m_index = _tmp38_ + 1;
			_tmp39_ = _m_index;
			_tmp40_ = _m_size;
			if (!(_tmp39_ < _tmp40_)) {
				break;
			}
			_tmp41_ = _m_list;
			_tmp42_ = _m_index;
			_tmp43_ = vala_list_get (_tmp41_, _tmp42_);
			m = (ValaMethod*) _tmp43_;
			_tmp44_ = m;
			vala_code_node_accept ((ValaCodeNode*) _tmp44_, visitor);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp45_;
		gint _f_size = 0;
		ValaList* _tmp46_;
		gint _tmp47_;
		gint _tmp48_;
		gint _f_index = 0;
		_tmp45_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_f_list = _tmp45_;
		_tmp46_ = _f_list;
		_tmp47_ = vala_collection_get_size ((ValaCollection*) _tmp46_);
		_tmp48_ = _tmp47_;
		_f_size = _tmp48_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp49_;
			gint _tmp50_;
			gint _tmp51_;
			ValaField* f = NULL;
			ValaList* _tmp52_;
			gint _tmp53_;
			gpointer _tmp54_;
			ValaField* _tmp55_;
			_tmp49_ = _f_index;
			_f_index = _tmp49_ + 1;
			_tmp50_ = _f_index;
			_tmp51_ = _f_size;
			if (!(_tmp50_ < _tmp51_)) {
				break;
			}
			_tmp52_ = _f_list;
			_tmp53_ = _f_index;
			_tmp54_ = vala_list_get (_tmp52_, _tmp53_);
			f = (ValaField*) _tmp54_;
			_tmp55_ = f;
			vala_code_node_accept ((ValaCodeNode*) _tmp55_, visitor);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp56_;
		gint _c_size = 0;
		ValaList* _tmp57_;
		gint _tmp58_;
		gint _tmp59_;
		gint _c_index = 0;
		_tmp56_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_c_list = _tmp56_;
		_tmp57_ = _c_list;
		_tmp58_ = vala_collection_get_size ((ValaCollection*) _tmp57_);
		_tmp59_ = _tmp58_;
		_c_size = _tmp59_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp60_;
			gint _tmp61_;
			gint _tmp62_;
			ValaConstant* c = NULL;
			ValaList* _tmp63_;
			gint _tmp64_;
			gpointer _tmp65_;
			ValaConstant* _tmp66_;
			_tmp60_ = _c_index;
			_c_index = _tmp60_ + 1;
			_tmp61_ = _c_index;
			_tmp62_ = _c_size;
			if (!(_tmp61_ < _tmp62_)) {
				break;
			}
			_tmp63_ = _c_list;
			_tmp64_ = _c_index;
			_tmp65_ = vala_list_get (_tmp63_, _tmp64_);
			c = (ValaConstant*) _tmp65_;
			_tmp66_ = c;
			vala_code_node_accept ((ValaCodeNode*) _tmp66_, visitor);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp67_;
		gint _prop_size = 0;
		ValaList* _tmp68_;
		gint _tmp69_;
		gint _tmp70_;
		gint _prop_index = 0;
		_tmp67_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
		_prop_list = _tmp67_;
		_tmp68_ = _prop_list;
		_tmp69_ = vala_collection_get_size ((ValaCollection*) _tmp68_);
		_tmp70_ = _tmp69_;
		_prop_size = _tmp70_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp71_;
			gint _tmp72_;
			gint _tmp73_;
			ValaProperty* prop = NULL;
			ValaList* _tmp74_;
			gint _tmp75_;
			gpointer _tmp76_;
			ValaProperty* _tmp77_;
			_tmp71_ = _prop_index;
			_prop_index = _tmp71_ + 1;
			_tmp72_ = _prop_index;
			_tmp73_ = _prop_size;
			if (!(_tmp72_ < _tmp73_)) {
				break;
			}
			_tmp74_ = _prop_list;
			_tmp75_ = _prop_index;
			_tmp76_ = vala_list_get (_tmp74_, _tmp75_);
			prop = (ValaProperty*) _tmp76_;
			_tmp77_ = prop;
			vala_code_node_accept ((ValaCodeNode*) _tmp77_, visitor);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp78_;
		gint _sig_size = 0;
		ValaList* _tmp79_;
		gint _tmp80_;
		gint _tmp81_;
		gint _sig_index = 0;
		_tmp78_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
		_sig_list = _tmp78_;
		_tmp79_ = _sig_list;
		_tmp80_ = vala_collection_get_size ((ValaCollection*) _tmp79_);
		_tmp81_ = _tmp80_;
		_sig_size = _tmp81_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp82_;
			gint _tmp83_;
			gint _tmp84_;
			ValaSignal* sig = NULL;
			ValaList* _tmp85_;
			gint _tmp86_;
			gpointer _tmp87_;
			ValaSignal* _tmp88_;
			_tmp82_ = _sig_index;
			_sig_index = _tmp82_ + 1;
			_tmp83_ = _sig_index;
			_tmp84_ = _sig_size;
			if (!(_tmp83_ < _tmp84_)) {
				break;
			}
			_tmp85_ = _sig_list;
			_tmp86_ = _sig_index;
			_tmp87_ = vala_list_get (_tmp85_, _tmp86_);
			sig = (ValaSignal*) _tmp87_;
			_tmp88_ = sig;
			vala_code_node_accept ((ValaCodeNode*) _tmp88_, visitor);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp89_;
		gint _cl_size = 0;
		ValaList* _tmp90_;
		gint _tmp91_;
		gint _tmp92_;
		gint _cl_index = 0;
		_tmp89_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_cl_list = _tmp89_;
		_tmp90_ = _cl_list;
		_tmp91_ = vala_collection_get_size ((ValaCollection*) _tmp90_);
		_tmp92_ = _tmp91_;
		_cl_size = _tmp92_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp93_;
			gint _tmp94_;
			gint _tmp95_;
			ValaClass* cl = NULL;
			ValaList* _tmp96_;
			gint _tmp97_;
			gpointer _tmp98_;
			ValaClass* _tmp99_;
			_tmp93_ = _cl_index;
			_cl_index = _tmp93_ + 1;
			_tmp94_ = _cl_index;
			_tmp95_ = _cl_size;
			if (!(_tmp94_ < _tmp95_)) {
				break;
			}
			_tmp96_ = _cl_list;
			_tmp97_ = _cl_index;
			_tmp98_ = vala_list_get (_tmp96_, _tmp97_);
			cl = (ValaClass*) _tmp98_;
			_tmp99_ = cl;
			vala_code_node_accept ((ValaCodeNode*) _tmp99_, visitor);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp100_;
		gint _st_size = 0;
		ValaList* _tmp101_;
		gint _tmp102_;
		gint _tmp103_;
		gint _st_index = 0;
		_tmp100_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_st_list = _tmp100_;
		_tmp101_ = _st_list;
		_tmp102_ = vala_collection_get_size ((ValaCollection*) _tmp101_);
		_tmp103_ = _tmp102_;
		_st_size = _tmp103_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp104_;
			gint _tmp105_;
			gint _tmp106_;
			ValaStruct* st = NULL;
			ValaList* _tmp107_;
			gint _tmp108_;
			gpointer _tmp109_;
			ValaStruct* _tmp110_;
			_tmp104_ = _st_index;
			_st_index = _tmp104_ + 1;
			_tmp105_ = _st_index;
			_tmp106_ = _st_size;
			if (!(_tmp105_ < _tmp106_)) {
				break;
			}
			_tmp107_ = _st_list;
			_tmp108_ = _st_index;
			_tmp109_ = vala_list_get (_tmp107_, _tmp108_);
			st = (ValaStruct*) _tmp109_;
			_tmp110_ = st;
			vala_code_node_accept ((ValaCodeNode*) _tmp110_, visitor);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp111_;
		gint _d_size = 0;
		ValaList* _tmp112_;
		gint _tmp113_;
		gint _tmp114_;
		gint _d_index = 0;
		_tmp111_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_d_list = _tmp111_;
		_tmp112_ = _d_list;
		_tmp113_ = vala_collection_get_size ((ValaCollection*) _tmp112_);
		_tmp114_ = _tmp113_;
		_d_size = _tmp114_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp115_;
			gint _tmp116_;
			gint _tmp117_;
			ValaDelegate* d = NULL;
			ValaList* _tmp118_;
			gint _tmp119_;
			gpointer _tmp120_;
			ValaDelegate* _tmp121_;
			_tmp115_ = _d_index;
			_d_index = _tmp115_ + 1;
			_tmp116_ = _d_index;
			_tmp117_ = _d_size;
			if (!(_tmp116_ < _tmp117_)) {
				break;
			}
			_tmp118_ = _d_list;
			_tmp119_ = _d_index;
			_tmp120_ = vala_list_get (_tmp118_, _tmp119_);
			d = (ValaDelegate*) _tmp120_;
			_tmp121_ = d;
			vala_code_node_accept ((ValaCodeNode*) _tmp121_, visitor);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
}


static gboolean
vala_interface_real_is_reference_type (ValaTypeSymbol* base)
{
	ValaInterface * self;
	gboolean result = FALSE;
	self = (ValaInterface*) base;
	result = TRUE;
	return result;
}


static gboolean
vala_interface_real_is_subtype_of (ValaTypeSymbol* base,
                                   ValaTypeSymbol* t)
{
	ValaInterface * self;
	gboolean result = FALSE;
	self = (ValaInterface*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _prerequisite_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _prerequisite_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _prerequisite_index = 0;
		_tmp0_ = self->priv->prerequisites;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_prerequisite_list = _tmp1_;
		_tmp2_ = _prerequisite_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_prerequisite_size = _tmp4_;
		_prerequisite_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaDataType* prerequisite = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			gboolean _tmp11_ = FALSE;
			ValaDataType* _tmp12_;
			ValaTypeSymbol* _tmp13_;
			ValaTypeSymbol* _tmp14_;
			_tmp5_ = _prerequisite_index;
			_prerequisite_index = _tmp5_ + 1;
			_tmp6_ = _prerequisite_index;
			_tmp7_ = _prerequisite_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _prerequisite_list;
			_tmp9_ = _prerequisite_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			prerequisite = (ValaDataType*) _tmp10_;
			_tmp12_ = prerequisite;
			_tmp13_ = vala_data_type_get_data_type (_tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_ != NULL) {
				ValaDataType* _tmp15_;
				ValaTypeSymbol* _tmp16_;
				ValaTypeSymbol* _tmp17_;
				_tmp15_ = prerequisite;
				_tmp16_ = vala_data_type_get_data_type (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp11_ = vala_typesymbol_is_subtype_of (_tmp17_, t);
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				result = TRUE;
				_vala_code_node_unref0 (prerequisite);
				_vala_iterable_unref0 (_prerequisite_list);
				return result;
			}
			_vala_code_node_unref0 (prerequisite);
		}
		_vala_iterable_unref0 (_prerequisite_list);
	}
	result = FALSE;
	return result;
}


static void
vala_interface_real_replace_type (ValaCodeNode* base,
                                  ValaDataType* old_type,
                                  ValaDataType* new_type)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ValaList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				ValaList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				ValaDataType* _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->prerequisites;
				_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->prerequisites;
				_tmp7_ = i;
				_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
				_tmp9_ = (ValaDataType*) _tmp8_;
				_tmp10_ = _tmp9_ == old_type;
				_vala_code_node_unref0 (_tmp9_);
				if (_tmp10_) {
					ValaList* _tmp11_;
					gint _tmp12_;
					_tmp11_ = self->priv->prerequisites;
					_tmp12_ = i;
					vala_list_set (_tmp11_, _tmp12_, new_type);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_type, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}


static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_interface_real_check (ValaCodeNode* base,
                           ValaCodeContext* context)
{
	ValaInterface * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaClass* prereq_class = NULL;
	ValaMap* positions = NULL;
	GHashFunc _tmp232_;
	GEqualFunc _tmp233_;
	GEqualFunc _tmp234_;
	ValaHashMap* _tmp235_;
	gboolean ordered_seen = FALSE;
	gboolean unordered_seen = FALSE;
	gboolean _tmp312_;
	ValaSemanticAnalyzer* _tmp335_;
	ValaSemanticAnalyzer* _tmp336_;
	ValaSourceFile* _tmp337_;
	ValaSemanticAnalyzer* _tmp338_;
	ValaSemanticAnalyzer* _tmp339_;
	ValaSymbol* _tmp340_;
	gboolean _tmp341_;
	gboolean _tmp342_;
	self = (ValaInterface*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	{
		ValaList* _prerequisite_reference_list = NULL;
		ValaList* _tmp24_;
		gint _prerequisite_reference_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _prerequisite_reference_index = 0;
		_tmp24_ = vala_interface_get_prerequisites (self);
		_prerequisite_reference_list = _tmp24_;
		_tmp25_ = _prerequisite_reference_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_prerequisite_reference_size = _tmp27_;
		_prerequisite_reference_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			ValaDataType* prerequisite_reference = NULL;
			ValaList* _tmp31_;
			gint _tmp32_;
			gpointer _tmp33_;
			ValaSemanticAnalyzer* _tmp34_;
			ValaSemanticAnalyzer* _tmp35_;
			ValaDataType* _tmp36_;
			_tmp28_ = _prerequisite_reference_index;
			_prerequisite_reference_index = _tmp28_ + 1;
			_tmp29_ = _prerequisite_reference_index;
			_tmp30_ = _prerequisite_reference_size;
			if (!(_tmp29_ < _tmp30_)) {
				break;
			}
			_tmp31_ = _prerequisite_reference_list;
			_tmp32_ = _prerequisite_reference_index;
			_tmp33_ = vala_list_get (_tmp31_, _tmp32_);
			prerequisite_reference = (ValaDataType*) _tmp33_;
			_tmp34_ = vala_code_context_get_analyzer (context);
			_tmp35_ = _tmp34_;
			_tmp36_ = prerequisite_reference;
			if (!vala_semantic_analyzer_is_type_accessible (_tmp35_, (ValaSymbol*) self, _tmp36_)) {
				ValaSourceReference* _tmp37_;
				ValaSourceReference* _tmp38_;
				ValaDataType* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp37_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp38_ = _tmp37_;
				_tmp39_ = prerequisite_reference;
				_tmp40_ = vala_code_node_to_string ((ValaCodeNode*) _tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp43_ = _tmp42_;
				_tmp44_ = g_strdup_printf ("prerequisite `%s` is less accessible than interface `%s`", _tmp41_, _tmp43_);
				_tmp45_ = _tmp44_;
				vala_report_error (_tmp38_, _tmp45_);
				_g_free0 (_tmp45_);
				_g_free0 (_tmp43_);
				_g_free0 (_tmp41_);
				result = FALSE;
				_vala_code_node_unref0 (prerequisite_reference);
				_vala_iterable_unref0 (_prerequisite_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (prerequisite_reference);
		}
		_vala_iterable_unref0 (_prerequisite_reference_list);
	}
	prereq_class = NULL;
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp46_;
		gint _prereq_size = 0;
		ValaList* _tmp47_;
		gint _tmp48_;
		gint _tmp49_;
		gint _prereq_index = 0;
		_tmp46_ = vala_interface_get_prerequisites (self);
		_prereq_list = _tmp46_;
		_tmp47_ = _prereq_list;
		_tmp48_ = vala_collection_get_size ((ValaCollection*) _tmp47_);
		_tmp49_ = _tmp48_;
		_prereq_size = _tmp49_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp50_;
			gint _tmp51_;
			gint _tmp52_;
			ValaDataType* prereq = NULL;
			ValaList* _tmp53_;
			gint _tmp54_;
			gpointer _tmp55_;
			ValaTypeSymbol* class_or_interface = NULL;
			ValaDataType* _tmp56_;
			ValaTypeSymbol* _tmp57_;
			ValaTypeSymbol* _tmp58_;
			ValaTypeSymbol* _tmp59_;
			ValaTypeSymbol* _tmp60_;
			ValaTypeSymbol* _tmp61_;
			ValaTypeSymbol* _tmp71_;
			_tmp50_ = _prereq_index;
			_prereq_index = _tmp50_ + 1;
			_tmp51_ = _prereq_index;
			_tmp52_ = _prereq_size;
			if (!(_tmp51_ < _tmp52_)) {
				break;
			}
			_tmp53_ = _prereq_list;
			_tmp54_ = _prereq_index;
			_tmp55_ = vala_list_get (_tmp53_, _tmp54_);
			prereq = (ValaDataType*) _tmp55_;
			_tmp56_ = prereq;
			_tmp57_ = vala_data_type_get_data_type (_tmp56_);
			_tmp58_ = _tmp57_;
			_tmp59_ = _vala_code_node_ref0 (_tmp58_);
			class_or_interface = _tmp59_;
			_tmp60_ = class_or_interface;
			if (_tmp60_ == NULL) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_vala_code_node_unref0 (class_or_interface);
				_vala_code_node_unref0 (prereq);
				continue;
			}
			_tmp61_ = class_or_interface;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp61_, VALA_TYPE_OBJECT_TYPE_SYMBOL)) {
				ValaSourceReference* _tmp62_;
				ValaSourceReference* _tmp63_;
				gchar* _tmp64_;
				gchar* _tmp65_;
				ValaTypeSymbol* _tmp66_;
				gchar* _tmp67_;
				gchar* _tmp68_;
				gchar* _tmp69_;
				gchar* _tmp70_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp62_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp63_ = _tmp62_;
				_tmp64_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp65_ = _tmp64_;
				_tmp66_ = class_or_interface;
				_tmp67_ = vala_code_node_to_string ((ValaCodeNode*) _tmp66_);
				_tmp68_ = _tmp67_;
				_tmp69_ = g_strdup_printf ("Prerequisite `%s` of interface `%s` is not a class or interface", _tmp65_, _tmp68_);
				_tmp70_ = _tmp69_;
				vala_report_error (_tmp63_, _tmp70_);
				_g_free0 (_tmp70_);
				_g_free0 (_tmp68_);
				_g_free0 (_tmp65_);
				result = FALSE;
				_vala_code_node_unref0 (class_or_interface);
				_vala_code_node_unref0 (prereq);
				_vala_iterable_unref0 (_prereq_list);
				_vala_code_node_unref0 (prereq_class);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp71_ = class_or_interface;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp71_, VALA_TYPE_CLASS)) {
				ValaClass* _tmp72_;
				ValaTypeSymbol* _tmp85_;
				ValaClass* _tmp86_;
				_tmp72_ = prereq_class;
				if (_tmp72_ != NULL) {
					ValaSourceReference* _tmp73_;
					ValaSourceReference* _tmp74_;
					gchar* _tmp75_;
					gchar* _tmp76_;
					ValaTypeSymbol* _tmp77_;
					gchar* _tmp78_;
					gchar* _tmp79_;
					ValaClass* _tmp80_;
					gchar* _tmp81_;
					gchar* _tmp82_;
					gchar* _tmp83_;
					gchar* _tmp84_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp73_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp74_ = _tmp73_;
					_tmp75_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp76_ = _tmp75_;
					_tmp77_ = class_or_interface;
					_tmp78_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp77_);
					_tmp79_ = _tmp78_;
					_tmp80_ = prereq_class;
					_tmp81_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp80_);
					_tmp82_ = _tmp81_;
					_tmp83_ = g_strdup_printf ("%s: Interfaces cannot have multiple instantiable prerequisites (`%s' a" \
"nd `%s')", _tmp76_, _tmp79_, _tmp82_);
					_tmp84_ = _tmp83_;
					vala_report_error (_tmp74_, _tmp84_);
					_g_free0 (_tmp84_);
					_g_free0 (_tmp82_);
					_g_free0 (_tmp79_);
					_g_free0 (_tmp76_);
					result = FALSE;
					_vala_code_node_unref0 (class_or_interface);
					_vala_code_node_unref0 (prereq);
					_vala_iterable_unref0 (_prereq_list);
					_vala_code_node_unref0 (prereq_class);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_tmp85_ = class_or_interface;
				_tmp86_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp85_, VALA_TYPE_CLASS, ValaClass));
				_vala_code_node_unref0 (prereq_class);
				prereq_class = _tmp86_;
			}
			_vala_code_node_unref0 (class_or_interface);
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp87_;
		ValaList* _tmp88_;
		gint _type_size = 0;
		ValaList* _tmp89_;
		gint _tmp90_;
		gint _tmp91_;
		gint _type_index = 0;
		_tmp87_ = self->priv->prerequisites;
		_tmp88_ = _vala_iterable_ref0 (_tmp87_);
		_type_list = _tmp88_;
		_tmp89_ = _type_list;
		_tmp90_ = vala_collection_get_size ((ValaCollection*) _tmp89_);
		_tmp91_ = _tmp90_;
		_type_size = _tmp91_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp92_;
			gint _tmp93_;
			gint _tmp94_;
			ValaDataType* type = NULL;
			ValaList* _tmp95_;
			gint _tmp96_;
			gpointer _tmp97_;
			ValaDataType* _tmp98_;
			_tmp92_ = _type_index;
			_type_index = _tmp92_ + 1;
			_tmp93_ = _type_index;
			_tmp94_ = _type_size;
			if (!(_tmp93_ < _tmp94_)) {
				break;
			}
			_tmp95_ = _type_list;
			_tmp96_ = _type_index;
			_tmp97_ = vala_list_get (_tmp95_, _tmp96_);
			type = (ValaDataType*) _tmp97_;
			_tmp98_ = type;
			vala_code_node_check ((ValaCodeNode*) _tmp98_, context);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp99_;
		gint _p_size = 0;
		ValaList* _tmp100_;
		gint _tmp101_;
		gint _tmp102_;
		gint _p_index = 0;
		_tmp99_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp99_;
		_tmp100_ = _p_list;
		_tmp101_ = vala_collection_get_size ((ValaCollection*) _tmp100_);
		_tmp102_ = _tmp101_;
		_p_size = _tmp102_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp103_;
			gint _tmp104_;
			gint _tmp105_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp106_;
			gint _tmp107_;
			gpointer _tmp108_;
			ValaTypeParameter* _tmp109_;
			_tmp103_ = _p_index;
			_p_index = _tmp103_ + 1;
			_tmp104_ = _p_index;
			_tmp105_ = _p_size;
			if (!(_tmp104_ < _tmp105_)) {
				break;
			}
			_tmp106_ = _p_list;
			_tmp107_ = _p_index;
			_tmp108_ = vala_list_get (_tmp106_, _tmp107_);
			p = (ValaTypeParameter*) _tmp108_;
			_tmp109_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp109_, context);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp110_;
		gint _en_size = 0;
		ValaList* _tmp111_;
		gint _tmp112_;
		gint _tmp113_;
		gint _en_index = 0;
		_tmp110_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_en_list = _tmp110_;
		_tmp111_ = _en_list;
		_tmp112_ = vala_collection_get_size ((ValaCollection*) _tmp111_);
		_tmp113_ = _tmp112_;
		_en_size = _tmp113_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp114_;
			gint _tmp115_;
			gint _tmp116_;
			ValaEnum* en = NULL;
			ValaList* _tmp117_;
			gint _tmp118_;
			gpointer _tmp119_;
			ValaEnum* _tmp120_;
			_tmp114_ = _en_index;
			_en_index = _tmp114_ + 1;
			_tmp115_ = _en_index;
			_tmp116_ = _en_size;
			if (!(_tmp115_ < _tmp116_)) {
				break;
			}
			_tmp117_ = _en_list;
			_tmp118_ = _en_index;
			_tmp119_ = vala_list_get (_tmp117_, _tmp118_);
			en = (ValaEnum*) _tmp119_;
			_tmp120_ = en;
			vala_code_node_check ((ValaCodeNode*) _tmp120_, context);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp121_;
		gint _m_size = 0;
		ValaList* _tmp122_;
		gint _tmp123_;
		gint _tmp124_;
		gint _m_index = 0;
		_tmp121_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
		_m_list = _tmp121_;
		_tmp122_ = _m_list;
		_tmp123_ = vala_collection_get_size ((ValaCollection*) _tmp122_);
		_tmp124_ = _tmp123_;
		_m_size = _tmp124_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp125_;
			gint _tmp126_;
			gint _tmp127_;
			ValaMethod* m = NULL;
			ValaList* _tmp128_;
			gint _tmp129_;
			gpointer _tmp130_;
			ValaMethod* _tmp131_;
			gboolean _tmp132_ = FALSE;
			ValaMethod* _tmp133_;
			gboolean _tmp134_;
			gboolean _tmp135_;
			_tmp125_ = _m_index;
			_m_index = _tmp125_ + 1;
			_tmp126_ = _m_index;
			_tmp127_ = _m_size;
			if (!(_tmp126_ < _tmp127_)) {
				break;
			}
			_tmp128_ = _m_list;
			_tmp129_ = _m_index;
			_tmp130_ = vala_list_get (_tmp128_, _tmp129_);
			m = (ValaMethod*) _tmp130_;
			_tmp131_ = m;
			vala_code_node_check ((ValaCodeNode*) _tmp131_, context);
			_tmp133_ = m;
			_tmp134_ = vala_method_get_is_virtual (_tmp133_);
			_tmp135_ = _tmp134_;
			if (_tmp135_) {
				_tmp132_ = TRUE;
			} else {
				ValaMethod* _tmp136_;
				gboolean _tmp137_;
				gboolean _tmp138_;
				_tmp136_ = m;
				_tmp137_ = vala_method_get_is_abstract (_tmp136_);
				_tmp138_ = _tmp137_;
				_tmp132_ = _tmp138_;
			}
			if (_tmp132_) {
				ValaList* _tmp139_;
				ValaMethod* _tmp140_;
				_tmp139_ = self->priv->virtuals;
				_tmp140_ = m;
				vala_collection_add ((ValaCollection*) _tmp139_, (ValaSymbol*) _tmp140_);
			}
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp141_;
		gint _f_size = 0;
		ValaList* _tmp142_;
		gint _tmp143_;
		gint _tmp144_;
		gint _f_index = 0;
		_tmp141_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_f_list = _tmp141_;
		_tmp142_ = _f_list;
		_tmp143_ = vala_collection_get_size ((ValaCollection*) _tmp142_);
		_tmp144_ = _tmp143_;
		_f_size = _tmp144_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp145_;
			gint _tmp146_;
			gint _tmp147_;
			ValaField* f = NULL;
			ValaList* _tmp148_;
			gint _tmp149_;
			gpointer _tmp150_;
			ValaField* _tmp151_;
			_tmp145_ = _f_index;
			_f_index = _tmp145_ + 1;
			_tmp146_ = _f_index;
			_tmp147_ = _f_size;
			if (!(_tmp146_ < _tmp147_)) {
				break;
			}
			_tmp148_ = _f_list;
			_tmp149_ = _f_index;
			_tmp150_ = vala_list_get (_tmp148_, _tmp149_);
			f = (ValaField*) _tmp150_;
			_tmp151_ = f;
			vala_code_node_check ((ValaCodeNode*) _tmp151_, context);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp152_;
		gint _c_size = 0;
		ValaList* _tmp153_;
		gint _tmp154_;
		gint _tmp155_;
		gint _c_index = 0;
		_tmp152_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_c_list = _tmp152_;
		_tmp153_ = _c_list;
		_tmp154_ = vala_collection_get_size ((ValaCollection*) _tmp153_);
		_tmp155_ = _tmp154_;
		_c_size = _tmp155_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp156_;
			gint _tmp157_;
			gint _tmp158_;
			ValaConstant* c = NULL;
			ValaList* _tmp159_;
			gint _tmp160_;
			gpointer _tmp161_;
			ValaConstant* _tmp162_;
			_tmp156_ = _c_index;
			_c_index = _tmp156_ + 1;
			_tmp157_ = _c_index;
			_tmp158_ = _c_size;
			if (!(_tmp157_ < _tmp158_)) {
				break;
			}
			_tmp159_ = _c_list;
			_tmp160_ = _c_index;
			_tmp161_ = vala_list_get (_tmp159_, _tmp160_);
			c = (ValaConstant*) _tmp161_;
			_tmp162_ = c;
			vala_code_node_check ((ValaCodeNode*) _tmp162_, context);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp163_;
		gint _sig_size = 0;
		ValaList* _tmp164_;
		gint _tmp165_;
		gint _tmp166_;
		gint _sig_index = 0;
		_tmp163_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
		_sig_list = _tmp163_;
		_tmp164_ = _sig_list;
		_tmp165_ = vala_collection_get_size ((ValaCollection*) _tmp164_);
		_tmp166_ = _tmp165_;
		_sig_size = _tmp166_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp167_;
			gint _tmp168_;
			gint _tmp169_;
			ValaSignal* sig = NULL;
			ValaList* _tmp170_;
			gint _tmp171_;
			gpointer _tmp172_;
			ValaSignal* _tmp173_;
			ValaSignal* _tmp174_;
			gboolean _tmp175_;
			gboolean _tmp176_;
			_tmp167_ = _sig_index;
			_sig_index = _tmp167_ + 1;
			_tmp168_ = _sig_index;
			_tmp169_ = _sig_size;
			if (!(_tmp168_ < _tmp169_)) {
				break;
			}
			_tmp170_ = _sig_list;
			_tmp171_ = _sig_index;
			_tmp172_ = vala_list_get (_tmp170_, _tmp171_);
			sig = (ValaSignal*) _tmp172_;
			_tmp173_ = sig;
			vala_code_node_check ((ValaCodeNode*) _tmp173_, context);
			_tmp174_ = sig;
			_tmp175_ = vala_signal_get_is_virtual (_tmp174_);
			_tmp176_ = _tmp175_;
			if (_tmp176_) {
				ValaList* _tmp177_;
				ValaSignal* _tmp178_;
				_tmp177_ = self->priv->virtuals;
				_tmp178_ = sig;
				vala_collection_add ((ValaCollection*) _tmp177_, (ValaSymbol*) _tmp178_);
			}
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp179_;
		gint _prop_size = 0;
		ValaList* _tmp180_;
		gint _tmp181_;
		gint _tmp182_;
		gint _prop_index = 0;
		_tmp179_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
		_prop_list = _tmp179_;
		_tmp180_ = _prop_list;
		_tmp181_ = vala_collection_get_size ((ValaCollection*) _tmp180_);
		_tmp182_ = _tmp181_;
		_prop_size = _tmp182_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp183_;
			gint _tmp184_;
			gint _tmp185_;
			ValaProperty* prop = NULL;
			ValaList* _tmp186_;
			gint _tmp187_;
			gpointer _tmp188_;
			ValaProperty* _tmp189_;
			gboolean _tmp190_ = FALSE;
			ValaProperty* _tmp191_;
			gboolean _tmp192_;
			gboolean _tmp193_;
			_tmp183_ = _prop_index;
			_prop_index = _tmp183_ + 1;
			_tmp184_ = _prop_index;
			_tmp185_ = _prop_size;
			if (!(_tmp184_ < _tmp185_)) {
				break;
			}
			_tmp186_ = _prop_list;
			_tmp187_ = _prop_index;
			_tmp188_ = vala_list_get (_tmp186_, _tmp187_);
			prop = (ValaProperty*) _tmp188_;
			_tmp189_ = prop;
			vala_code_node_check ((ValaCodeNode*) _tmp189_, context);
			_tmp191_ = prop;
			_tmp192_ = vala_property_get_is_virtual (_tmp191_);
			_tmp193_ = _tmp192_;
			if (_tmp193_) {
				_tmp190_ = TRUE;
			} else {
				ValaProperty* _tmp194_;
				gboolean _tmp195_;
				gboolean _tmp196_;
				_tmp194_ = prop;
				_tmp195_ = vala_property_get_is_abstract (_tmp194_);
				_tmp196_ = _tmp195_;
				_tmp190_ = _tmp196_;
			}
			if (_tmp190_) {
				ValaList* _tmp197_;
				ValaProperty* _tmp198_;
				_tmp197_ = self->priv->virtuals;
				_tmp198_ = prop;
				vala_collection_add ((ValaCollection*) _tmp197_, (ValaSymbol*) _tmp198_);
			}
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp199_;
		gint _cl_size = 0;
		ValaList* _tmp200_;
		gint _tmp201_;
		gint _tmp202_;
		gint _cl_index = 0;
		_tmp199_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_cl_list = _tmp199_;
		_tmp200_ = _cl_list;
		_tmp201_ = vala_collection_get_size ((ValaCollection*) _tmp200_);
		_tmp202_ = _tmp201_;
		_cl_size = _tmp202_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp203_;
			gint _tmp204_;
			gint _tmp205_;
			ValaClass* cl = NULL;
			ValaList* _tmp206_;
			gint _tmp207_;
			gpointer _tmp208_;
			ValaClass* _tmp209_;
			_tmp203_ = _cl_index;
			_cl_index = _tmp203_ + 1;
			_tmp204_ = _cl_index;
			_tmp205_ = _cl_size;
			if (!(_tmp204_ < _tmp205_)) {
				break;
			}
			_tmp206_ = _cl_list;
			_tmp207_ = _cl_index;
			_tmp208_ = vala_list_get (_tmp206_, _tmp207_);
			cl = (ValaClass*) _tmp208_;
			_tmp209_ = cl;
			vala_code_node_check ((ValaCodeNode*) _tmp209_, context);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp210_;
		gint _st_size = 0;
		ValaList* _tmp211_;
		gint _tmp212_;
		gint _tmp213_;
		gint _st_index = 0;
		_tmp210_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_st_list = _tmp210_;
		_tmp211_ = _st_list;
		_tmp212_ = vala_collection_get_size ((ValaCollection*) _tmp211_);
		_tmp213_ = _tmp212_;
		_st_size = _tmp213_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp214_;
			gint _tmp215_;
			gint _tmp216_;
			ValaStruct* st = NULL;
			ValaList* _tmp217_;
			gint _tmp218_;
			gpointer _tmp219_;
			ValaStruct* _tmp220_;
			_tmp214_ = _st_index;
			_st_index = _tmp214_ + 1;
			_tmp215_ = _st_index;
			_tmp216_ = _st_size;
			if (!(_tmp215_ < _tmp216_)) {
				break;
			}
			_tmp217_ = _st_list;
			_tmp218_ = _st_index;
			_tmp219_ = vala_list_get (_tmp217_, _tmp218_);
			st = (ValaStruct*) _tmp219_;
			_tmp220_ = st;
			vala_code_node_check ((ValaCodeNode*) _tmp220_, context);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp221_;
		gint _d_size = 0;
		ValaList* _tmp222_;
		gint _tmp223_;
		gint _tmp224_;
		gint _d_index = 0;
		_tmp221_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_d_list = _tmp221_;
		_tmp222_ = _d_list;
		_tmp223_ = vala_collection_get_size ((ValaCollection*) _tmp222_);
		_tmp224_ = _tmp223_;
		_d_size = _tmp224_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp225_;
			gint _tmp226_;
			gint _tmp227_;
			ValaDelegate* d = NULL;
			ValaList* _tmp228_;
			gint _tmp229_;
			gpointer _tmp230_;
			ValaDelegate* _tmp231_;
			_tmp225_ = _d_index;
			_d_index = _tmp225_ + 1;
			_tmp226_ = _d_index;
			_tmp227_ = _d_size;
			if (!(_tmp226_ < _tmp227_)) {
				break;
			}
			_tmp228_ = _d_list;
			_tmp229_ = _d_index;
			_tmp230_ = vala_list_get (_tmp228_, _tmp229_);
			d = (ValaDelegate*) _tmp230_;
			_tmp231_ = d;
			vala_code_node_check ((ValaCodeNode*) _tmp231_, context);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
	_tmp232_ = g_direct_hash;
	_tmp233_ = g_direct_equal;
	_tmp234_ = g_direct_equal;
	_tmp235_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp232_, _tmp233_, _tmp234_);
	positions = (ValaMap*) _tmp235_;
	ordered_seen = FALSE;
	unordered_seen = FALSE;
	{
		ValaList* _sym_list = NULL;
		ValaList* _tmp236_;
		ValaList* _tmp237_;
		gint _sym_size = 0;
		ValaList* _tmp238_;
		gint _tmp239_;
		gint _tmp240_;
		gint _sym_index = 0;
		_tmp236_ = self->priv->virtuals;
		_tmp237_ = _vala_iterable_ref0 (_tmp236_);
		_sym_list = _tmp237_;
		_tmp238_ = _sym_list;
		_tmp239_ = vala_collection_get_size ((ValaCollection*) _tmp238_);
		_tmp240_ = _tmp239_;
		_sym_size = _tmp240_;
		_sym_index = -1;
		while (TRUE) {
			gint _tmp241_;
			gint _tmp242_;
			gint _tmp243_;
			ValaSymbol* sym = NULL;
			ValaList* _tmp244_;
			gint _tmp245_;
			gpointer _tmp246_;
			gint ordering = 0;
			ValaSymbol* _tmp247_;
			gint _tmp248_;
			gboolean ordered = FALSE;
			gint _tmp257_;
			gboolean _tmp258_ = FALSE;
			gboolean _tmp259_ = FALSE;
			gboolean _tmp260_;
			gboolean _tmp271_ = FALSE;
			gboolean _tmp272_;
			gboolean _tmp274_ = FALSE;
			gboolean _tmp275_ = FALSE;
			gboolean _tmp276_;
			gboolean _tmp287_ = FALSE;
			gboolean _tmp288_;
			gboolean _tmp290_ = FALSE;
			gboolean _tmp291_;
			_tmp241_ = _sym_index;
			_sym_index = _tmp241_ + 1;
			_tmp242_ = _sym_index;
			_tmp243_ = _sym_size;
			if (!(_tmp242_ < _tmp243_)) {
				break;
			}
			_tmp244_ = _sym_list;
			_tmp245_ = _sym_index;
			_tmp246_ = vala_list_get (_tmp244_, _tmp245_);
			sym = (ValaSymbol*) _tmp246_;
			_tmp247_ = sym;
			ordering = vala_code_node_get_attribute_integer ((ValaCodeNode*) _tmp247_, "CCode", "ordering", -1);
			_tmp248_ = ordering;
			if (_tmp248_ < -1) {
				ValaSymbol* _tmp249_;
				ValaSourceReference* _tmp250_;
				ValaSourceReference* _tmp251_;
				ValaSymbol* _tmp252_;
				gchar* _tmp253_;
				gchar* _tmp254_;
				gchar* _tmp255_;
				gchar* _tmp256_;
				_tmp249_ = sym;
				_tmp250_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp249_);
				_tmp251_ = _tmp250_;
				_tmp252_ = sym;
				_tmp253_ = vala_symbol_get_full_name (_tmp252_);
				_tmp254_ = _tmp253_;
				_tmp255_ = g_strdup_printf ("%s: Invalid ordering", _tmp254_);
				_tmp256_ = _tmp255_;
				vala_report_error (_tmp251_, _tmp256_);
				_g_free0 (_tmp256_);
				_g_free0 (_tmp254_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				ordered_seen = TRUE;
				unordered_seen = TRUE;
				_vala_code_node_unref0 (sym);
				continue;
			}
			_tmp257_ = ordering;
			ordered = _tmp257_ != -1;
			_tmp260_ = ordered;
			if (_tmp260_) {
				gboolean _tmp261_;
				_tmp261_ = unordered_seen;
				_tmp259_ = _tmp261_;
			} else {
				_tmp259_ = FALSE;
			}
			if (_tmp259_) {
				gboolean _tmp262_;
				_tmp262_ = ordered_seen;
				_tmp258_ = !_tmp262_;
			} else {
				_tmp258_ = FALSE;
			}
			if (_tmp258_) {
				ValaSymbol* _tmp263_;
				ValaSourceReference* _tmp264_;
				ValaSourceReference* _tmp265_;
				ValaSymbol* _tmp266_;
				gchar* _tmp267_;
				gchar* _tmp268_;
				gchar* _tmp269_;
				gchar* _tmp270_;
				_tmp263_ = sym;
				_tmp264_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp263_);
				_tmp265_ = _tmp264_;
				_tmp266_ = sym;
				_tmp267_ = vala_symbol_get_full_name (_tmp266_);
				_tmp268_ = _tmp267_;
				_tmp269_ = g_strdup_printf ("%s: Cannot mix ordered and unordered virtuals", _tmp268_);
				_tmp270_ = _tmp269_;
				vala_report_error (_tmp265_, _tmp270_);
				_g_free0 (_tmp270_);
				_g_free0 (_tmp268_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_tmp272_ = ordered_seen;
			if (_tmp272_) {
				_tmp271_ = TRUE;
			} else {
				gboolean _tmp273_;
				_tmp273_ = ordered;
				_tmp271_ = _tmp273_;
			}
			ordered_seen = _tmp271_;
			_tmp276_ = ordered;
			if (!_tmp276_) {
				gboolean _tmp277_;
				_tmp277_ = unordered_seen;
				_tmp275_ = !_tmp277_;
			} else {
				_tmp275_ = FALSE;
			}
			if (_tmp275_) {
				gboolean _tmp278_;
				_tmp278_ = ordered_seen;
				_tmp274_ = _tmp278_;
			} else {
				_tmp274_ = FALSE;
			}
			if (_tmp274_) {
				ValaSymbol* _tmp279_;
				ValaSourceReference* _tmp280_;
				ValaSourceReference* _tmp281_;
				ValaSymbol* _tmp282_;
				gchar* _tmp283_;
				gchar* _tmp284_;
				gchar* _tmp285_;
				gchar* _tmp286_;
				_tmp279_ = sym;
				_tmp280_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp279_);
				_tmp281_ = _tmp280_;
				_tmp282_ = sym;
				_tmp283_ = vala_symbol_get_full_name (_tmp282_);
				_tmp284_ = _tmp283_;
				_tmp285_ = g_strdup_printf ("%s: Cannot mix ordered and unordered virtuals", _tmp284_);
				_tmp286_ = _tmp285_;
				vala_report_error (_tmp281_, _tmp286_);
				_g_free0 (_tmp286_);
				_g_free0 (_tmp284_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_tmp288_ = unordered_seen;
			if (_tmp288_) {
				_tmp287_ = TRUE;
			} else {
				gboolean _tmp289_;
				_tmp289_ = ordered;
				_tmp287_ = !_tmp289_;
			}
			unordered_seen = _tmp287_;
			_tmp291_ = ordered_seen;
			if (!_tmp291_) {
				_tmp290_ = TRUE;
			} else {
				gboolean _tmp292_;
				_tmp292_ = unordered_seen;
				_tmp290_ = !_tmp292_;
			}
			if (_tmp290_) {
				gboolean _tmp293_;
				_tmp293_ = ordered;
				if (_tmp293_) {
					ValaSymbol* prev = NULL;
					ValaMap* _tmp294_;
					gint _tmp295_;
					gpointer _tmp296_;
					ValaSymbol* _tmp297_;
					ValaMap* _tmp309_;
					gint _tmp310_;
					ValaSymbol* _tmp311_;
					_tmp294_ = positions;
					_tmp295_ = ordering;
					_tmp296_ = vala_map_get (_tmp294_, (gpointer) ((gintptr) _tmp295_));
					prev = (ValaSymbol*) _tmp296_;
					_tmp297_ = prev;
					if (_tmp297_ != NULL) {
						ValaSymbol* _tmp298_;
						ValaSourceReference* _tmp299_;
						ValaSourceReference* _tmp300_;
						ValaSymbol* _tmp301_;
						gchar* _tmp302_;
						gchar* _tmp303_;
						ValaSymbol* _tmp304_;
						const gchar* _tmp305_;
						const gchar* _tmp306_;
						gchar* _tmp307_;
						gchar* _tmp308_;
						_tmp298_ = sym;
						_tmp299_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp298_);
						_tmp300_ = _tmp299_;
						_tmp301_ = sym;
						_tmp302_ = vala_symbol_get_full_name (_tmp301_);
						_tmp303_ = _tmp302_;
						_tmp304_ = prev;
						_tmp305_ = vala_symbol_get_name (_tmp304_);
						_tmp306_ = _tmp305_;
						_tmp307_ = g_strdup_printf ("%s: Duplicate ordering (previous virtual with the same position is %s)", _tmp303_, _tmp306_);
						_tmp308_ = _tmp307_;
						vala_report_error (_tmp300_, _tmp308_);
						_g_free0 (_tmp308_);
						_g_free0 (_tmp303_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
					_tmp309_ = positions;
					_tmp310_ = ordering;
					_tmp311_ = sym;
					vala_map_set (_tmp309_, (gpointer) ((gintptr) _tmp310_), _tmp311_);
					_vala_code_node_unref0 (prev);
				}
			}
			_vala_code_node_unref0 (sym);
		}
		_vala_iterable_unref0 (_sym_list);
	}
	_tmp312_ = ordered_seen;
	if (_tmp312_) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp313_ = FALSE;
				_tmp313_ = TRUE;
				while (TRUE) {
					gint _tmp315_;
					ValaList* _tmp316_;
					gint _tmp317_;
					gint _tmp318_;
					ValaSymbol* sym = NULL;
					ValaMap* _tmp319_;
					gint _tmp320_;
					gpointer _tmp321_;
					ValaSymbol* _tmp322_;
					gboolean _tmp330_;
					gboolean _tmp331_;
					if (!_tmp313_) {
						gint _tmp314_;
						_tmp314_ = i;
						i = _tmp314_ + 1;
					}
					_tmp313_ = FALSE;
					_tmp315_ = i;
					_tmp316_ = self->priv->virtuals;
					_tmp317_ = vala_collection_get_size ((ValaCollection*) _tmp316_);
					_tmp318_ = _tmp317_;
					if (!(_tmp315_ < _tmp318_)) {
						break;
					}
					_tmp319_ = positions;
					_tmp320_ = i;
					_tmp321_ = vala_map_get (_tmp319_, (gpointer) ((gintptr) _tmp320_));
					sym = (ValaSymbol*) _tmp321_;
					_tmp322_ = sym;
					if (_tmp322_ == NULL) {
						ValaSourceReference* _tmp323_;
						ValaSourceReference* _tmp324_;
						gchar* _tmp325_;
						gchar* _tmp326_;
						gint _tmp327_;
						gchar* _tmp328_;
						gchar* _tmp329_;
						_tmp323_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp324_ = _tmp323_;
						_tmp325_ = vala_symbol_get_full_name ((ValaSymbol*) self);
						_tmp326_ = _tmp325_;
						_tmp327_ = i;
						_tmp328_ = g_strdup_printf ("%s: Gap in ordering in position %d", _tmp326_, _tmp327_);
						_tmp329_ = _tmp328_;
						vala_report_error (_tmp324_, _tmp329_);
						_g_free0 (_tmp329_);
						_g_free0 (_tmp326_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
					_tmp330_ = vala_code_node_get_error ((ValaCodeNode*) self);
					_tmp331_ = _tmp330_;
					if (!_tmp331_) {
						ValaList* _tmp332_;
						gint _tmp333_;
						ValaSymbol* _tmp334_;
						_tmp332_ = self->priv->virtuals;
						_tmp333_ = i;
						_tmp334_ = sym;
						vala_list_set (_tmp332_, _tmp333_, _tmp334_);
					}
					_vala_code_node_unref0 (sym);
				}
			}
		}
	}
	_tmp335_ = vala_code_context_get_analyzer (context);
	_tmp336_ = _tmp335_;
	_tmp337_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp336_, _tmp337_);
	_tmp338_ = vala_code_context_get_analyzer (context);
	_tmp339_ = _tmp338_;
	_tmp340_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp339_, _tmp340_);
	_tmp341_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp342_ = _tmp341_;
	result = !_tmp342_;
	_vala_map_unref0 (positions);
	_vala_code_node_unref0 (prereq_class);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


static void
vala_interface_class_init (ValaInterfaceClass * klass)
{
	vala_interface_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_interface_finalize;
	g_type_class_add_private (klass, sizeof (ValaInterfacePrivate));
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol *, ValaMethod*)) vala_interface_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol *, ValaProperty*)) vala_interface_real_add_property;
	((ValaInterfaceClass *) klass)->get_virtuals = (ValaList* (*) (ValaInterface *)) vala_interface_real_get_virtuals;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_interface_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_interface_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol *)) vala_interface_real_is_reference_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol *, ValaTypeSymbol*)) vala_interface_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode *, ValaDataType*, ValaDataType*)) vala_interface_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_interface_real_check;
}


static void
vala_interface_instance_init (ValaInterface * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = VALA_INTERFACE_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->prerequisites = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->virtuals = (ValaList*) _tmp3_;
}


static void
vala_interface_finalize (ValaCodeNode * obj)
{
	ValaInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_INTERFACE, ValaInterface);
	_vala_iterable_unref0 (self->priv->prerequisites);
	_vala_iterable_unref0 (self->priv->virtuals);
	VALA_CODE_NODE_CLASS (vala_interface_parent_class)->finalize (obj);
}


/**
 * Represents a class declaration in the source code.
 */
GType
vala_interface_get_type (void)
{
	static volatile gsize vala_interface_type_id__volatile = 0;
	if (g_once_init_enter (&vala_interface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInterface), 0, (GInstanceInitFunc) vala_interface_instance_init, NULL };
		GType vala_interface_type_id;
		vala_interface_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaInterface", &g_define_type_info, 0);
		g_once_init_leave (&vala_interface_type_id__volatile, vala_interface_type_id);
	}
	return vala_interface_type_id__volatile;
}



