/* dbus.c generated by valac, the Vala compiler
 * generated from dbus.vala, do not modify */

/* doclet.vala
 *
 * Copyright (C) 2010 Luca Bruno
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Luca Bruno <lethalman88@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <valadoc.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>


#define GTKDOC_DBUS_TYPE_PARAMETER (gtkdoc_dbus_parameter_get_type ())
#define GTKDOC_DBUS_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_DBUS_TYPE_PARAMETER, GtkdocDBusParameter))
#define GTKDOC_DBUS_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_DBUS_TYPE_PARAMETER, GtkdocDBusParameterClass))
#define GTKDOC_DBUS_IS_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_DBUS_TYPE_PARAMETER))
#define GTKDOC_DBUS_IS_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_DBUS_TYPE_PARAMETER))
#define GTKDOC_DBUS_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_DBUS_TYPE_PARAMETER, GtkdocDBusParameterClass))

typedef struct _GtkdocDBusParameter GtkdocDBusParameter;
typedef struct _GtkdocDBusParameterClass GtkdocDBusParameterClass;
typedef struct _GtkdocDBusParameterPrivate GtkdocDBusParameterPrivate;

#define GTKDOC_DBUS_PARAMETER_TYPE_DIRECTION (gtkdoc_dbus_parameter_direction_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GtkdocDBusParamSpecParameter GtkdocDBusParamSpecParameter;

#define GTKDOC_DBUS_TYPE_MEMBER (gtkdoc_dbus_member_get_type ())
#define GTKDOC_DBUS_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_DBUS_TYPE_MEMBER, GtkdocDBusMember))
#define GTKDOC_DBUS_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_DBUS_TYPE_MEMBER, GtkdocDBusMemberClass))
#define GTKDOC_DBUS_IS_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_DBUS_TYPE_MEMBER))
#define GTKDOC_DBUS_IS_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_DBUS_TYPE_MEMBER))
#define GTKDOC_DBUS_MEMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_DBUS_TYPE_MEMBER, GtkdocDBusMemberClass))

typedef struct _GtkdocDBusMember GtkdocDBusMember;
typedef struct _GtkdocDBusMemberClass GtkdocDBusMemberClass;
typedef struct _GtkdocDBusMemberPrivate GtkdocDBusMemberPrivate;

#define GTKDOC_TYPE_GCOMMENT (gtkdoc_gcomment_get_type ())
#define GTKDOC_GCOMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_TYPE_GCOMMENT, GtkdocGComment))
#define GTKDOC_GCOMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_TYPE_GCOMMENT, GtkdocGCommentClass))
#define GTKDOC_IS_GCOMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_TYPE_GCOMMENT))
#define GTKDOC_IS_GCOMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_TYPE_GCOMMENT))
#define GTKDOC_GCOMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_TYPE_GCOMMENT, GtkdocGCommentClass))

typedef struct _GtkdocGComment GtkdocGComment;
typedef struct _GtkdocGCommentClass GtkdocGCommentClass;

#define GTKDOC_DBUS_TYPE_INTERFACE (gtkdoc_dbus_interface_get_type ())
#define GTKDOC_DBUS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_DBUS_TYPE_INTERFACE, GtkdocDBusInterface))
#define GTKDOC_DBUS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_DBUS_TYPE_INTERFACE, GtkdocDBusInterfaceClass))
#define GTKDOC_DBUS_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_DBUS_TYPE_INTERFACE))
#define GTKDOC_DBUS_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_DBUS_TYPE_INTERFACE))
#define GTKDOC_DBUS_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_DBUS_TYPE_INTERFACE, GtkdocDBusInterfaceClass))

typedef struct _GtkdocDBusInterface GtkdocDBusInterface;
typedef struct _GtkdocDBusInterfaceClass GtkdocDBusInterfaceClass;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _gtkdoc_gcomment_unref0(var) ((var == NULL) ? NULL : (var = (gtkdoc_gcomment_unref (var), NULL)))
#define _gtkdoc_dbus_interface_unref0(var) ((var == NULL) ? NULL : (var = (gtkdoc_dbus_interface_unref (var), NULL)))
#define _gtkdoc_dbus_parameter_unref0(var) ((var == NULL) ? NULL : (var = (gtkdoc_dbus_parameter_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _GtkdocDBusParamSpecMember GtkdocDBusParamSpecMember;
typedef struct _GtkdocDBusInterfacePrivate GtkdocDBusInterfacePrivate;

#define GTKDOC_TYPE_TEXT_WRITER (gtkdoc_text_writer_get_type ())
#define GTKDOC_TEXT_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_TYPE_TEXT_WRITER, GtkdocTextWriter))
#define GTKDOC_TEXT_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_TYPE_TEXT_WRITER, GtkdocTextWriterClass))
#define GTKDOC_IS_TEXT_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_TYPE_TEXT_WRITER))
#define GTKDOC_IS_TEXT_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_TYPE_TEXT_WRITER))
#define GTKDOC_TEXT_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_TYPE_TEXT_WRITER, GtkdocTextWriterClass))

typedef struct _GtkdocTextWriter GtkdocTextWriter;
typedef struct _GtkdocTextWriterClass GtkdocTextWriterClass;
typedef struct _GtkdocTextWriterPrivate GtkdocTextWriterPrivate;
#define _gtkdoc_text_writer_unref0(var) ((var == NULL) ? NULL : (var = (gtkdoc_text_writer_unref (var), NULL)))
#define _gtkdoc_dbus_member_unref0(var) ((var == NULL) ? NULL : (var = (gtkdoc_dbus_member_unref (var), NULL)))
typedef struct _GtkdocDBusParamSpecInterface GtkdocDBusParamSpecInterface;

typedef enum  {
	GTKDOC_DBUS_PARAMETER_DIRECTION_NONE,
	GTKDOC_DBUS_PARAMETER_DIRECTION_IN,
	GTKDOC_DBUS_PARAMETER_DIRECTION_OUT
} GtkdocDBusParameterDirection;

struct _GtkdocDBusParameter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GtkdocDBusParameterPrivate * priv;
	gchar* name;
	gchar* signature;
	GtkdocDBusParameterDirection direction;
};

struct _GtkdocDBusParameterClass {
	GTypeClass parent_class;
	void (*finalize) (GtkdocDBusParameter *self);
};

struct _GtkdocDBusParamSpecParameter {
	GParamSpec parent_instance;
};

struct _GtkdocDBusMember {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GtkdocDBusMemberPrivate * priv;
	gchar* name;
	ValaList* parameters;
	GtkdocGComment* comment;
	GtkdocDBusInterface* iface;
};

struct _GtkdocDBusMemberClass {
	GTypeClass parent_class;
	void (*finalize) (GtkdocDBusMember *self);
};

struct _GtkdocDBusParamSpecMember {
	GParamSpec parent_instance;
};

struct _GtkdocDBusInterface {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GtkdocDBusInterfacePrivate * priv;
	gchar* package_name;
	gchar* name;
	gchar* purpose;
	gchar* description;
	ValaList* methods;
	ValaList* signals;
};

struct _GtkdocDBusInterfaceClass {
	GTypeClass parent_class;
	void (*finalize) (GtkdocDBusInterface *self);
};

struct _GtkdocTextWriter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GtkdocTextWriterPrivate * priv;
	gchar* filename;
	gchar* mode;
};

struct _GtkdocTextWriterClass {
	GTypeClass parent_class;
	void (*finalize) (GtkdocTextWriter *self);
};

struct _GtkdocDBusParamSpecInterface {
	GParamSpec parent_instance;
};


static gpointer gtkdoc_dbus_parameter_parent_class = NULL;
static gpointer gtkdoc_dbus_member_parent_class = NULL;
static gpointer gtkdoc_dbus_interface_parent_class = NULL;

gpointer gtkdoc_dbus_parameter_ref (gpointer instance);
void gtkdoc_dbus_parameter_unref (gpointer instance);
GParamSpec* gtkdoc_dbus_param_spec_parameter (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
void gtkdoc_dbus_value_set_parameter (GValue* value,
                                      gpointer v_object);
void gtkdoc_dbus_value_take_parameter (GValue* value,
                                       gpointer v_object);
gpointer gtkdoc_dbus_value_get_parameter (const GValue* value);
GType gtkdoc_dbus_parameter_get_type (void) G_GNUC_CONST;
GType gtkdoc_dbus_parameter_direction_get_type (void) G_GNUC_CONST;
gchar* gtkdoc_dbus_parameter_direction_to_string (GtkdocDBusParameterDirection self);
GtkdocDBusParameter* gtkdoc_dbus_parameter_new (const gchar* name,
                                                const gchar* signature,
                                                GtkdocDBusParameterDirection direction);
GtkdocDBusParameter* gtkdoc_dbus_parameter_construct (GType object_type,
                                                      const gchar* name,
                                                      const gchar* signature,
                                                      GtkdocDBusParameterDirection direction);
gchar* gtkdoc_dbus_parameter_to_string (GtkdocDBusParameter* self);
static void gtkdoc_dbus_parameter_finalize (GtkdocDBusParameter * obj);
gpointer gtkdoc_dbus_member_ref (gpointer instance);
void gtkdoc_dbus_member_unref (gpointer instance);
GParamSpec* gtkdoc_dbus_param_spec_member (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
void gtkdoc_dbus_value_set_member (GValue* value,
                                   gpointer v_object);
void gtkdoc_dbus_value_take_member (GValue* value,
                                    gpointer v_object);
gpointer gtkdoc_dbus_value_get_member (const GValue* value);
GType gtkdoc_dbus_member_get_type (void) G_GNUC_CONST;
gpointer gtkdoc_gcomment_ref (gpointer instance);
void gtkdoc_gcomment_unref (gpointer instance);
GParamSpec* gtkdoc_param_spec_gcomment (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void gtkdoc_value_set_gcomment (GValue* value,
                                gpointer v_object);
void gtkdoc_value_take_gcomment (GValue* value,
                                 gpointer v_object);
gpointer gtkdoc_value_get_gcomment (const GValue* value);
GType gtkdoc_gcomment_get_type (void) G_GNUC_CONST;
gpointer gtkdoc_dbus_interface_ref (gpointer instance);
void gtkdoc_dbus_interface_unref (gpointer instance);
GParamSpec* gtkdoc_dbus_param_spec_interface (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
void gtkdoc_dbus_value_set_interface (GValue* value,
                                      gpointer v_object);
void gtkdoc_dbus_value_take_interface (GValue* value,
                                       gpointer v_object);
gpointer gtkdoc_dbus_value_get_interface (const GValue* value);
GType gtkdoc_dbus_interface_get_type (void) G_GNUC_CONST;
GtkdocDBusMember* gtkdoc_dbus_member_new (const gchar* name);
GtkdocDBusMember* gtkdoc_dbus_member_construct (GType object_type,
                                                const gchar* name);
void gtkdoc_dbus_member_add_parameter (GtkdocDBusMember* self,
                                       GtkdocDBusParameter* parameter);
gchar* gtkdoc_dbus_member_get_docbook_id (GtkdocDBusMember* self);
gchar* gtkdoc_to_docbook_id (const gchar* name);
gchar* gtkdoc_dbus_member_to_string (GtkdocDBusMember* self,
                                     gint indent,
                                     gboolean link);
gchar* gtkdoc_dbus_interface_get_docbook_id (GtkdocDBusInterface* self);
static void gtkdoc_dbus_member_finalize (GtkdocDBusMember * obj);
GtkdocDBusInterface* gtkdoc_dbus_interface_new (const gchar* package_name,
                                                const gchar* name,
                                                const gchar* purpose,
                                                const gchar* description);
GtkdocDBusInterface* gtkdoc_dbus_interface_construct (GType object_type,
                                                      const gchar* package_name,
                                                      const gchar* name,
                                                      const gchar* purpose,
                                                      const gchar* description);
void gtkdoc_dbus_interface_add_method (GtkdocDBusInterface* self,
                                       GtkdocDBusMember* member);
void gtkdoc_dbus_interface_add_signal (GtkdocDBusInterface* self,
                                       GtkdocDBusMember* member);
gboolean gtkdoc_dbus_interface_write (GtkdocDBusInterface* self,
                                      ValadocSettings* settings,
                                      ValadocErrorReporter* reporter);
gpointer gtkdoc_text_writer_ref (gpointer instance);
void gtkdoc_text_writer_unref (gpointer instance);
GParamSpec* gtkdoc_param_spec_text_writer (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
void gtkdoc_value_set_text_writer (GValue* value,
                                   gpointer v_object);
void gtkdoc_value_take_text_writer (GValue* value,
                                    gpointer v_object);
gpointer gtkdoc_value_get_text_writer (const GValue* value);
GType gtkdoc_text_writer_get_type (void) G_GNUC_CONST;
GtkdocTextWriter* gtkdoc_text_writer_new (const gchar* filename,
                                          const gchar* mode);
GtkdocTextWriter* gtkdoc_text_writer_construct (GType object_type,
                                                const gchar* filename,
                                                const gchar* mode);
gboolean gtkdoc_text_writer_open (GtkdocTextWriter* self);
void gtkdoc_text_writer_write_line (GtkdocTextWriter* self,
                                    const gchar* line);
gchar* gtkdoc_dbus_interface_to_string (GtkdocDBusInterface* self,
                                        ValadocErrorReporter* reporter);
void gtkdoc_text_writer_close (GtkdocTextWriter* self);
gchar* gtkdoc_gcomment_to_docbook (GtkdocGComment* self,
                                   ValadocErrorReporter* reporter);
static void gtkdoc_dbus_interface_finalize (GtkdocDBusInterface * obj);


gchar*
gtkdoc_dbus_parameter_direction_to_string (GtkdocDBusParameterDirection self)
{
	gchar* result = NULL;
	switch (self) {
		case GTKDOC_DBUS_PARAMETER_DIRECTION_NONE:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("");
			result = _tmp0_;
			return result;
		}
		case GTKDOC_DBUS_PARAMETER_DIRECTION_IN:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("in");
			result = _tmp1_;
			return result;
		}
		case GTKDOC_DBUS_PARAMETER_DIRECTION_OUT:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("out");
			result = _tmp2_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


GType
gtkdoc_dbus_parameter_direction_get_type (void)
{
	static volatile gsize gtkdoc_dbus_parameter_direction_type_id__volatile = 0;
	if (g_once_init_enter (&gtkdoc_dbus_parameter_direction_type_id__volatile)) {
		static const GEnumValue values[] = {{GTKDOC_DBUS_PARAMETER_DIRECTION_NONE, "GTKDOC_DBUS_PARAMETER_DIRECTION_NONE", "none"}, {GTKDOC_DBUS_PARAMETER_DIRECTION_IN, "GTKDOC_DBUS_PARAMETER_DIRECTION_IN", "in"}, {GTKDOC_DBUS_PARAMETER_DIRECTION_OUT, "GTKDOC_DBUS_PARAMETER_DIRECTION_OUT", "out"}, {0, NULL, NULL}};
		GType gtkdoc_dbus_parameter_direction_type_id;
		gtkdoc_dbus_parameter_direction_type_id = g_enum_register_static ("GtkdocDBusParameterDirection", values);
		g_once_init_leave (&gtkdoc_dbus_parameter_direction_type_id__volatile, gtkdoc_dbus_parameter_direction_type_id);
	}
	return gtkdoc_dbus_parameter_direction_type_id__volatile;
}


GtkdocDBusParameter*
gtkdoc_dbus_parameter_construct (GType object_type,
                                 const gchar* name,
                                 const gchar* signature,
                                 GtkdocDBusParameterDirection direction)
{
	GtkdocDBusParameter* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (signature != NULL, NULL);
	self = (GtkdocDBusParameter*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->name);
	self->name = _tmp0_;
	_tmp1_ = g_strdup (signature);
	_g_free0 (self->signature);
	self->signature = _tmp1_;
	self->direction = direction;
	return self;
}


GtkdocDBusParameter*
gtkdoc_dbus_parameter_new (const gchar* name,
                           const gchar* signature,
                           GtkdocDBusParameterDirection direction)
{
	return gtkdoc_dbus_parameter_construct (GTKDOC_DBUS_TYPE_PARAMETER, name, signature, direction);
}


gchar*
gtkdoc_dbus_parameter_to_string (GtkdocDBusParameter* self)
{
	gchar* result = NULL;
	GtkdocDBusParameterDirection _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->direction;
	if (_tmp0_ == GTKDOC_DBUS_PARAMETER_DIRECTION_NONE) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = self->signature;
		_tmp2_ = self->name;
		_tmp3_ = g_strdup_printf ("<parameter><type>'%s'</type> %s</parameter>", _tmp1_, _tmp2_);
		result = _tmp3_;
		return result;
	} else {
		GtkdocDBusParameterDirection _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp4_ = self->direction;
		_tmp5_ = gtkdoc_dbus_parameter_direction_to_string (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->signature;
		_tmp8_ = self->name;
		_tmp9_ = g_strdup_printf ("<parameter>%s <type>'%s'</type> %s</parameter>", _tmp6_, _tmp7_, _tmp8_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp6_);
		result = _tmp10_;
		return result;
	}
}


static void
gtkdoc_dbus_value_parameter_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
gtkdoc_dbus_value_parameter_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gtkdoc_dbus_parameter_unref (value->data[0].v_pointer);
	}
}


static void
gtkdoc_dbus_value_parameter_copy_value (const GValue* src_value,
                                        GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gtkdoc_dbus_parameter_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
gtkdoc_dbus_value_parameter_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
gtkdoc_dbus_value_parameter_collect_value (GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GtkdocDBusParameter * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gtkdoc_dbus_parameter_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
gtkdoc_dbus_value_parameter_lcopy_value (const GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	GtkdocDBusParameter ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gtkdoc_dbus_parameter_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec*
gtkdoc_dbus_param_spec_parameter (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags)
{
	GtkdocDBusParamSpecParameter* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GTKDOC_DBUS_TYPE_PARAMETER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer
gtkdoc_dbus_value_get_parameter (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_DBUS_TYPE_PARAMETER), NULL);
	return value->data[0].v_pointer;
}


void
gtkdoc_dbus_value_set_parameter (GValue* value,
                                 gpointer v_object)
{
	GtkdocDBusParameter * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_DBUS_TYPE_PARAMETER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_DBUS_TYPE_PARAMETER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gtkdoc_dbus_parameter_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_dbus_parameter_unref (old);
	}
}


void
gtkdoc_dbus_value_take_parameter (GValue* value,
                                  gpointer v_object)
{
	GtkdocDBusParameter * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_DBUS_TYPE_PARAMETER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_DBUS_TYPE_PARAMETER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_dbus_parameter_unref (old);
	}
}


static void
gtkdoc_dbus_parameter_class_init (GtkdocDBusParameterClass * klass)
{
	gtkdoc_dbus_parameter_parent_class = g_type_class_peek_parent (klass);
	((GtkdocDBusParameterClass *) klass)->finalize = gtkdoc_dbus_parameter_finalize;
}


static void
gtkdoc_dbus_parameter_instance_init (GtkdocDBusParameter * self)
{
	self->ref_count = 1;
}


static void
gtkdoc_dbus_parameter_finalize (GtkdocDBusParameter * obj)
{
	GtkdocDBusParameter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GTKDOC_DBUS_TYPE_PARAMETER, GtkdocDBusParameter);
	g_signal_handlers_destroy (self);
	_g_free0 (self->name);
	_g_free0 (self->signature);
}


GType
gtkdoc_dbus_parameter_get_type (void)
{
	static volatile gsize gtkdoc_dbus_parameter_type_id__volatile = 0;
	if (g_once_init_enter (&gtkdoc_dbus_parameter_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gtkdoc_dbus_value_parameter_init, gtkdoc_dbus_value_parameter_free_value, gtkdoc_dbus_value_parameter_copy_value, gtkdoc_dbus_value_parameter_peek_pointer, "p", gtkdoc_dbus_value_parameter_collect_value, "p", gtkdoc_dbus_value_parameter_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GtkdocDBusParameterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkdoc_dbus_parameter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkdocDBusParameter), 0, (GInstanceInitFunc) gtkdoc_dbus_parameter_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gtkdoc_dbus_parameter_type_id;
		gtkdoc_dbus_parameter_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GtkdocDBusParameter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gtkdoc_dbus_parameter_type_id__volatile, gtkdoc_dbus_parameter_type_id);
	}
	return gtkdoc_dbus_parameter_type_id__volatile;
}


gpointer
gtkdoc_dbus_parameter_ref (gpointer instance)
{
	GtkdocDBusParameter * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void
gtkdoc_dbus_parameter_unref (gpointer instance)
{
	GtkdocDBusParameter * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GTKDOC_DBUS_PARAMETER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


GtkdocDBusMember*
gtkdoc_dbus_member_construct (GType object_type,
                              const gchar* name)
{
	GtkdocDBusMember* self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (GtkdocDBusMember*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->name);
	self->name = _tmp0_;
	return self;
}


GtkdocDBusMember*
gtkdoc_dbus_member_new (const gchar* name)
{
	return gtkdoc_dbus_member_construct (GTKDOC_DBUS_TYPE_MEMBER, name);
}


void
gtkdoc_dbus_member_add_parameter (GtkdocDBusMember* self,
                                  GtkdocDBusParameter* parameter)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parameter != NULL);
	_tmp0_ = self->parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, parameter);
}


gchar*
gtkdoc_dbus_member_get_docbook_id (GtkdocDBusMember* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	_tmp1_ = gtkdoc_to_docbook_id (_tmp0_);
	result = _tmp1_;
	return result;
}


gchar*
gtkdoc_dbus_member_to_string (GtkdocDBusMember* self,
                              gint indent,
                              gboolean link)
{
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_;
	ValaList* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	GString* _tmp46_;
	GString* _tmp47_;
	const gchar* _tmp48_;
	gchar* _tmp49_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	if (link) {
		GString* _tmp1_;
		GtkdocDBusInterface* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp1_ = builder;
		_tmp2_ = self->iface;
		_tmp3_ = gtkdoc_dbus_interface_get_docbook_id (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = gtkdoc_dbus_member_get_docbook_id (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->name;
		_tmp8_ = self->name;
		_tmp9_ = strlen (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strnfill ((gsize) (indent - _tmp10_), ' ');
		_tmp12_ = _tmp11_;
		g_string_append_printf (_tmp1_, "\n<link linkend=\"%s-%s\">%s</link>%s(", _tmp4_, _tmp6_, _tmp7_, _tmp12_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
	} else {
		GString* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp13_ = builder;
		_tmp14_ = self->name;
		_tmp15_ = self->name;
		_tmp16_ = strlen (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strnfill ((gsize) (indent - _tmp17_), ' ');
		_tmp19_ = _tmp18_;
		g_string_append_printf (_tmp13_, "\n%s%s(", _tmp14_, _tmp19_);
		_g_free0 (_tmp19_);
	}
	_tmp20_ = self->parameters;
	_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
	_tmp22_ = _tmp21_;
	if (_tmp22_ > 0) {
		GString* _tmp23_;
		ValaList* _tmp24_;
		gpointer _tmp25_;
		GtkdocDBusParameter* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp23_ = builder;
		_tmp24_ = self->parameters;
		_tmp25_ = vala_list_get (_tmp24_, 0);
		_tmp26_ = (GtkdocDBusParameter*) _tmp25_;
		_tmp27_ = gtkdoc_dbus_parameter_to_string (_tmp26_);
		_tmp28_ = _tmp27_;
		g_string_append (_tmp23_, _tmp28_);
		_g_free0 (_tmp28_);
		_gtkdoc_dbus_parameter_unref0 (_tmp26_);
	}
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp29_ = FALSE;
			_tmp29_ = TRUE;
			while (TRUE) {
				gint _tmp31_;
				ValaList* _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
				GString* _tmp35_;
				GString* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				GString* _tmp39_;
				ValaList* _tmp40_;
				gint _tmp41_;
				gpointer _tmp42_;
				GtkdocDBusParameter* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				if (!_tmp29_) {
					gint _tmp30_;
					_tmp30_ = i;
					i = _tmp30_ + 1;
				}
				_tmp29_ = FALSE;
				_tmp31_ = i;
				_tmp32_ = self->parameters;
				_tmp33_ = vala_collection_get_size ((ValaCollection*) _tmp32_);
				_tmp34_ = _tmp33_;
				if (!(_tmp31_ < _tmp34_)) {
					break;
				}
				_tmp35_ = builder;
				g_string_append (_tmp35_, ",\n");
				_tmp36_ = builder;
				_tmp37_ = g_strnfill ((gsize) (indent + 1), ' ');
				_tmp38_ = _tmp37_;
				g_string_append (_tmp36_, _tmp38_);
				_g_free0 (_tmp38_);
				_tmp39_ = builder;
				_tmp40_ = self->parameters;
				_tmp41_ = i;
				_tmp42_ = vala_list_get (_tmp40_, _tmp41_);
				_tmp43_ = (GtkdocDBusParameter*) _tmp42_;
				_tmp44_ = gtkdoc_dbus_parameter_to_string (_tmp43_);
				_tmp45_ = _tmp44_;
				g_string_append (_tmp39_, _tmp45_);
				_g_free0 (_tmp45_);
				_gtkdoc_dbus_parameter_unref0 (_tmp43_);
			}
		}
	}
	_tmp46_ = builder;
	g_string_append_c (_tmp46_, ')');
	_tmp47_ = builder;
	_tmp48_ = _tmp47_->str;
	_tmp49_ = g_strdup (_tmp48_);
	result = _tmp49_;
	_g_string_free0 (builder);
	return result;
}


static void
gtkdoc_dbus_value_member_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
gtkdoc_dbus_value_member_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gtkdoc_dbus_member_unref (value->data[0].v_pointer);
	}
}


static void
gtkdoc_dbus_value_member_copy_value (const GValue* src_value,
                                     GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gtkdoc_dbus_member_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
gtkdoc_dbus_value_member_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
gtkdoc_dbus_value_member_collect_value (GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GtkdocDBusMember * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gtkdoc_dbus_member_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
gtkdoc_dbus_value_member_lcopy_value (const GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	GtkdocDBusMember ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gtkdoc_dbus_member_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec*
gtkdoc_dbus_param_spec_member (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags)
{
	GtkdocDBusParamSpecMember* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GTKDOC_DBUS_TYPE_MEMBER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer
gtkdoc_dbus_value_get_member (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_DBUS_TYPE_MEMBER), NULL);
	return value->data[0].v_pointer;
}


void
gtkdoc_dbus_value_set_member (GValue* value,
                              gpointer v_object)
{
	GtkdocDBusMember * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_DBUS_TYPE_MEMBER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_DBUS_TYPE_MEMBER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gtkdoc_dbus_member_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_dbus_member_unref (old);
	}
}


void
gtkdoc_dbus_value_take_member (GValue* value,
                               gpointer v_object)
{
	GtkdocDBusMember * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_DBUS_TYPE_MEMBER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_DBUS_TYPE_MEMBER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_dbus_member_unref (old);
	}
}


static void
gtkdoc_dbus_member_class_init (GtkdocDBusMemberClass * klass)
{
	gtkdoc_dbus_member_parent_class = g_type_class_peek_parent (klass);
	((GtkdocDBusMemberClass *) klass)->finalize = gtkdoc_dbus_member_finalize;
}


static void
gtkdoc_dbus_member_instance_init (GtkdocDBusMember * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (GTKDOC_DBUS_TYPE_PARAMETER, (GBoxedCopyFunc) gtkdoc_dbus_parameter_ref, (GDestroyNotify) gtkdoc_dbus_parameter_unref, _tmp0_);
	self->parameters = (ValaList*) _tmp1_;
	self->ref_count = 1;
}


static void
gtkdoc_dbus_member_finalize (GtkdocDBusMember * obj)
{
	GtkdocDBusMember * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GTKDOC_DBUS_TYPE_MEMBER, GtkdocDBusMember);
	g_signal_handlers_destroy (self);
	_g_free0 (self->name);
	_vala_iterable_unref0 (self->parameters);
	_gtkdoc_gcomment_unref0 (self->comment);
	_gtkdoc_dbus_interface_unref0 (self->iface);
}


GType
gtkdoc_dbus_member_get_type (void)
{
	static volatile gsize gtkdoc_dbus_member_type_id__volatile = 0;
	if (g_once_init_enter (&gtkdoc_dbus_member_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gtkdoc_dbus_value_member_init, gtkdoc_dbus_value_member_free_value, gtkdoc_dbus_value_member_copy_value, gtkdoc_dbus_value_member_peek_pointer, "p", gtkdoc_dbus_value_member_collect_value, "p", gtkdoc_dbus_value_member_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GtkdocDBusMemberClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkdoc_dbus_member_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkdocDBusMember), 0, (GInstanceInitFunc) gtkdoc_dbus_member_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gtkdoc_dbus_member_type_id;
		gtkdoc_dbus_member_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GtkdocDBusMember", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gtkdoc_dbus_member_type_id__volatile, gtkdoc_dbus_member_type_id);
	}
	return gtkdoc_dbus_member_type_id__volatile;
}


gpointer
gtkdoc_dbus_member_ref (gpointer instance)
{
	GtkdocDBusMember * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void
gtkdoc_dbus_member_unref (gpointer instance)
{
	GtkdocDBusMember * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GTKDOC_DBUS_MEMBER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


GtkdocDBusInterface*
gtkdoc_dbus_interface_construct (GType object_type,
                                 const gchar* package_name,
                                 const gchar* name,
                                 const gchar* purpose,
                                 const gchar* description)
{
	GtkdocDBusInterface* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (package_name != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (purpose != NULL, NULL);
	g_return_val_if_fail (description != NULL, NULL);
	self = (GtkdocDBusInterface*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (package_name);
	_g_free0 (self->package_name);
	self->package_name = _tmp0_;
	_tmp1_ = g_strdup (name);
	_g_free0 (self->name);
	self->name = _tmp1_;
	_tmp2_ = g_strdup (purpose);
	_g_free0 (self->purpose);
	self->purpose = _tmp2_;
	_tmp3_ = g_strdup (description);
	_g_free0 (self->description);
	self->description = _tmp3_;
	return self;
}


GtkdocDBusInterface*
gtkdoc_dbus_interface_new (const gchar* package_name,
                           const gchar* name,
                           const gchar* purpose,
                           const gchar* description)
{
	return gtkdoc_dbus_interface_construct (GTKDOC_DBUS_TYPE_INTERFACE, package_name, name, purpose, description);
}


static gpointer
_gtkdoc_dbus_interface_ref0 (gpointer self)
{
	return self ? gtkdoc_dbus_interface_ref (self) : NULL;
}


void
gtkdoc_dbus_interface_add_method (GtkdocDBusInterface* self,
                                  GtkdocDBusMember* member)
{
	GtkdocDBusInterface* _tmp0_;
	ValaList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (member != NULL);
	_tmp0_ = _gtkdoc_dbus_interface_ref0 (self);
	_gtkdoc_dbus_interface_unref0 (member->iface);
	member->iface = _tmp0_;
	_tmp1_ = self->methods;
	vala_collection_add ((ValaCollection*) _tmp1_, member);
}


void
gtkdoc_dbus_interface_add_signal (GtkdocDBusInterface* self,
                                  GtkdocDBusMember* member)
{
	GtkdocDBusInterface* _tmp0_;
	ValaList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (member != NULL);
	_tmp0_ = _gtkdoc_dbus_interface_ref0 (self);
	_gtkdoc_dbus_interface_unref0 (member->iface);
	member->iface = _tmp0_;
	_tmp1_ = self->signals;
	vala_collection_add ((ValaCollection*) _tmp1_, member);
}


gchar*
gtkdoc_dbus_interface_get_docbook_id (GtkdocDBusInterface* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	_tmp1_ = gtkdoc_to_docbook_id (_tmp0_);
	result = _tmp1_;
	return result;
}


gboolean
gtkdoc_dbus_interface_write (GtkdocDBusInterface* self,
                             ValadocSettings* settings,
                             ValadocErrorReporter* reporter)
{
	gboolean result = FALSE;
	gchar* xml_dir = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* xml_file = NULL;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GtkdocTextWriter* writer = NULL;
	const gchar* _tmp11_;
	GtkdocTextWriter* _tmp12_;
	GtkdocTextWriter* _tmp13_;
	GtkdocTextWriter* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GtkdocTextWriter* _tmp19_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (settings != NULL, FALSE);
	g_return_val_if_fail (reporter != NULL, FALSE);
	_tmp0_ = settings->path;
	_tmp1_ = g_build_filename (_tmp0_, "xml", NULL);
	xml_dir = _tmp1_;
	_tmp2_ = xml_dir;
	g_mkdir_with_parents (_tmp2_, 0777);
	_tmp3_ = xml_dir;
	_tmp4_ = self->name;
	_tmp5_ = gtkdoc_to_docbook_id (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("%s.xml", _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_build_filename (_tmp3_, _tmp8_, NULL);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	xml_file = _tmp10_;
	_tmp11_ = xml_file;
	_tmp12_ = gtkdoc_text_writer_new (_tmp11_, "w");
	writer = _tmp12_;
	_tmp13_ = writer;
	if (!gtkdoc_text_writer_open (_tmp13_)) {
		GtkdocTextWriter* _tmp14_;
		const gchar* _tmp15_;
		_tmp14_ = writer;
		_tmp15_ = _tmp14_->filename;
		valadoc_error_reporter_simple_error (reporter, "GtkDoc", "unable to open '%s' for writing", _tmp15_);
		result = FALSE;
		_gtkdoc_text_writer_unref0 (writer);
		_g_free0 (xml_file);
		_g_free0 (xml_dir);
		return result;
	}
	_tmp16_ = writer;
	_tmp17_ = gtkdoc_dbus_interface_to_string (self, reporter);
	_tmp18_ = _tmp17_;
	gtkdoc_text_writer_write_line (_tmp16_, _tmp18_);
	_g_free0 (_tmp18_);
	_tmp19_ = writer;
	gtkdoc_text_writer_close (_tmp19_);
	result = TRUE;
	_gtkdoc_text_writer_unref0 (writer);
	_g_free0 (xml_file);
	_g_free0 (xml_dir);
	return result;
}


static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


gchar*
gtkdoc_dbus_interface_to_string (GtkdocDBusInterface* self,
                                 ValadocErrorReporter* reporter)
{
	gchar* result = NULL;
	gint method_indent = 0;
	gint _tmp16_;
	gint signal_indent = 0;
	gint _tmp33_;
	GString* builder = NULL;
	GString* _tmp34_;
	gchar* docbook_id = NULL;
	gchar* _tmp35_;
	GString* _tmp36_;
	const gchar* _tmp37_ = NULL;
	const gchar* _tmp38_;
	GString* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	const gchar* _tmp46_;
	ValaList* _tmp47_;
	gint _tmp48_;
	gint _tmp49_;
	ValaList* _tmp69_;
	gint _tmp70_;
	gint _tmp71_;
	GString* _tmp91_;
	const gchar* _tmp92_;
	const gchar* _tmp93_;
	ValaList* _tmp94_;
	gint _tmp95_;
	gint _tmp96_;
	ValaList* _tmp129_;
	gint _tmp130_;
	gint _tmp131_;
	GString* _tmp164_;
	GString* _tmp165_;
	const gchar* _tmp166_;
	gchar* _tmp167_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (reporter != NULL, NULL);
	method_indent = 0;
	{
		ValaList* _method_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _method_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _method_index = 0;
		_tmp0_ = self->methods;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_method_list = _tmp1_;
		_tmp2_ = _method_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_method_size = _tmp4_;
		_method_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GtkdocDBusMember* method = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			gint _tmp11_;
			GtkdocDBusMember* _tmp12_;
			const gchar* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			_tmp5_ = _method_index;
			_method_index = _tmp5_ + 1;
			_tmp6_ = _method_index;
			_tmp7_ = _method_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _method_list;
			_tmp9_ = _method_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			method = (GtkdocDBusMember*) _tmp10_;
			_tmp11_ = method_indent;
			_tmp12_ = method;
			_tmp13_ = _tmp12_->name;
			_tmp14_ = strlen (_tmp13_);
			_tmp15_ = _tmp14_;
			method_indent = MAX (_tmp11_, (gint) _tmp15_);
			_gtkdoc_dbus_member_unref0 (method);
		}
		_vala_iterable_unref0 (_method_list);
	}
	_tmp16_ = method_indent;
	method_indent = _tmp16_ + 5;
	signal_indent = 0;
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp17_;
		ValaList* _tmp18_;
		gint _sig_size = 0;
		ValaList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _sig_index = 0;
		_tmp17_ = self->signals;
		_tmp18_ = _vala_iterable_ref0 (_tmp17_);
		_sig_list = _tmp18_;
		_tmp19_ = _sig_list;
		_tmp20_ = vala_collection_get_size ((ValaCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_sig_size = _tmp21_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			GtkdocDBusMember* sig = NULL;
			ValaList* _tmp25_;
			gint _tmp26_;
			gpointer _tmp27_;
			gint _tmp28_;
			GtkdocDBusMember* _tmp29_;
			const gchar* _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			_tmp22_ = _sig_index;
			_sig_index = _tmp22_ + 1;
			_tmp23_ = _sig_index;
			_tmp24_ = _sig_size;
			if (!(_tmp23_ < _tmp24_)) {
				break;
			}
			_tmp25_ = _sig_list;
			_tmp26_ = _sig_index;
			_tmp27_ = vala_list_get (_tmp25_, _tmp26_);
			sig = (GtkdocDBusMember*) _tmp27_;
			_tmp28_ = signal_indent;
			_tmp29_ = sig;
			_tmp30_ = _tmp29_->name;
			_tmp31_ = strlen (_tmp30_);
			_tmp32_ = _tmp31_;
			signal_indent = MAX (_tmp28_, (gint) _tmp32_);
			_gtkdoc_dbus_member_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	_tmp33_ = signal_indent;
	signal_indent = _tmp33_ + 5;
	_tmp34_ = g_string_new ("");
	builder = _tmp34_;
	_tmp35_ = gtkdoc_dbus_interface_get_docbook_id (self);
	docbook_id = _tmp35_;
	_tmp36_ = builder;
	g_string_append (_tmp36_, "<?xml version=\"1.0\"?><!DOCTYPE refentry PUBLIC \"-//OASIS//DTD DocBo" \
"ok XML V4.3//EN\" \"http://www.oasis-open.org/docbook/xml/4.3/docbookx" \
".dtd\"");
	_tmp38_ = self->purpose;
	_tmp37_ = _tmp38_;
	if (_tmp37_ == NULL) {
		_tmp37_ = "";
	}
	_tmp39_ = builder;
	_tmp40_ = docbook_id;
	_tmp41_ = docbook_id;
	_tmp42_ = self->name;
	_tmp43_ = self->package_name;
	_tmp44_ = g_utf8_strup (_tmp43_, (gssize) -1);
	_tmp45_ = _tmp44_;
	_tmp46_ = self->name;
	g_string_append_printf (_tmp39_, "\n" \
"[<!ENTITY %% local.common.attrib \"xmlns:xi  CDATA  #FIXED 'http://www" \
".w3.org/2003/XInclude'\">]>\n" \
"<refentry id=\"docs-%s\">\n" \
"<refmeta>\n" \
"<refentrytitle role=\"top_of_page\" id=\"docs-%s.top_of_page\">%s</ref" \
"entrytitle>\n" \
"<manvolnum>3</manvolnum>\n" \
"<refmiscinfo>\n" \
"%s D-Bus API\n" \
"</refmiscinfo>\n" \
"</refmeta>\n" \
"<refnamediv>\n" \
"<refname>%s</refname>\n" \
"<refpurpose>%s</refpurpose>\n" \
"</refnamediv>", _tmp40_, _tmp41_, _tmp42_, _tmp45_, _tmp46_, _tmp37_);
	_g_free0 (_tmp45_);
	_tmp47_ = self->methods;
	_tmp48_ = vala_collection_get_size ((ValaCollection*) _tmp47_);
	_tmp49_ = _tmp48_;
	if (_tmp49_ > 0) {
		GString* _tmp50_;
		const gchar* _tmp51_;
		GString* _tmp68_;
		_tmp50_ = builder;
		_tmp51_ = docbook_id;
		g_string_append_printf (_tmp50_, "\n" \
"<refsynopsisdiv id=\"docs-%s.synopsis\" role=\"synopsis\">\n" \
"<title role=\"synopsis.title\">Methods</title>\n" \
"<synopsis>", _tmp51_);
		{
			ValaList* _method_list = NULL;
			ValaList* _tmp52_;
			ValaList* _tmp53_;
			gint _method_size = 0;
			ValaList* _tmp54_;
			gint _tmp55_;
			gint _tmp56_;
			gint _method_index = 0;
			_tmp52_ = self->methods;
			_tmp53_ = _vala_iterable_ref0 (_tmp52_);
			_method_list = _tmp53_;
			_tmp54_ = _method_list;
			_tmp55_ = vala_collection_get_size ((ValaCollection*) _tmp54_);
			_tmp56_ = _tmp55_;
			_method_size = _tmp56_;
			_method_index = -1;
			while (TRUE) {
				gint _tmp57_;
				gint _tmp58_;
				gint _tmp59_;
				GtkdocDBusMember* method = NULL;
				ValaList* _tmp60_;
				gint _tmp61_;
				gpointer _tmp62_;
				GString* _tmp63_;
				GtkdocDBusMember* _tmp64_;
				gint _tmp65_;
				gchar* _tmp66_;
				gchar* _tmp67_;
				_tmp57_ = _method_index;
				_method_index = _tmp57_ + 1;
				_tmp58_ = _method_index;
				_tmp59_ = _method_size;
				if (!(_tmp58_ < _tmp59_)) {
					break;
				}
				_tmp60_ = _method_list;
				_tmp61_ = _method_index;
				_tmp62_ = vala_list_get (_tmp60_, _tmp61_);
				method = (GtkdocDBusMember*) _tmp62_;
				_tmp63_ = builder;
				_tmp64_ = method;
				_tmp65_ = method_indent;
				_tmp66_ = gtkdoc_dbus_member_to_string (_tmp64_, _tmp65_, TRUE);
				_tmp67_ = _tmp66_;
				g_string_append (_tmp63_, _tmp67_);
				_g_free0 (_tmp67_);
				_gtkdoc_dbus_member_unref0 (method);
			}
			_vala_iterable_unref0 (_method_list);
		}
		_tmp68_ = builder;
		g_string_append (_tmp68_, "</synopsis></refsynopsisdiv>");
	}
	_tmp69_ = self->signals;
	_tmp70_ = vala_collection_get_size ((ValaCollection*) _tmp69_);
	_tmp71_ = _tmp70_;
	if (_tmp71_ > 0) {
		GString* _tmp72_;
		const gchar* _tmp73_;
		GString* _tmp90_;
		_tmp72_ = builder;
		_tmp73_ = docbook_id;
		g_string_append_printf (_tmp72_, "\n" \
"<refsynopsisdiv id=\"docs-%s.signals\" role=\"signal_proto\">\n" \
"<title role=\"signal_proto.title\">Signals</title>\n" \
"<synopsis>", _tmp73_);
		{
			ValaList* _sig_list = NULL;
			ValaList* _tmp74_;
			ValaList* _tmp75_;
			gint _sig_size = 0;
			ValaList* _tmp76_;
			gint _tmp77_;
			gint _tmp78_;
			gint _sig_index = 0;
			_tmp74_ = self->signals;
			_tmp75_ = _vala_iterable_ref0 (_tmp74_);
			_sig_list = _tmp75_;
			_tmp76_ = _sig_list;
			_tmp77_ = vala_collection_get_size ((ValaCollection*) _tmp76_);
			_tmp78_ = _tmp77_;
			_sig_size = _tmp78_;
			_sig_index = -1;
			while (TRUE) {
				gint _tmp79_;
				gint _tmp80_;
				gint _tmp81_;
				GtkdocDBusMember* sig = NULL;
				ValaList* _tmp82_;
				gint _tmp83_;
				gpointer _tmp84_;
				GString* _tmp85_;
				GtkdocDBusMember* _tmp86_;
				gint _tmp87_;
				gchar* _tmp88_;
				gchar* _tmp89_;
				_tmp79_ = _sig_index;
				_sig_index = _tmp79_ + 1;
				_tmp80_ = _sig_index;
				_tmp81_ = _sig_size;
				if (!(_tmp80_ < _tmp81_)) {
					break;
				}
				_tmp82_ = _sig_list;
				_tmp83_ = _sig_index;
				_tmp84_ = vala_list_get (_tmp82_, _tmp83_);
				sig = (GtkdocDBusMember*) _tmp84_;
				_tmp85_ = builder;
				_tmp86_ = sig;
				_tmp87_ = signal_indent;
				_tmp88_ = gtkdoc_dbus_member_to_string (_tmp86_, _tmp87_, TRUE);
				_tmp89_ = _tmp88_;
				g_string_append (_tmp85_, _tmp89_);
				_g_free0 (_tmp89_);
				_gtkdoc_dbus_member_unref0 (sig);
			}
			_vala_iterable_unref0 (_sig_list);
		}
		_tmp90_ = builder;
		g_string_append (_tmp90_, "</synopsis></refsynopsisdiv>");
	}
	_tmp91_ = builder;
	_tmp92_ = docbook_id;
	_tmp93_ = self->description;
	g_string_append_printf (_tmp91_, "\n" \
"<refsect1 id=\"docs-%s.description\" role=\"desc\">\n" \
"<title role=\"desc.title\">Description</title>\n" \
"%s\n" \
"</refsect1>", _tmp92_, _tmp93_);
	_tmp94_ = self->methods;
	_tmp95_ = vala_collection_get_size ((ValaCollection*) _tmp94_);
	_tmp96_ = _tmp95_;
	if (_tmp96_ > 0) {
		GString* _tmp97_;
		const gchar* _tmp98_;
		GString* _tmp128_;
		_tmp97_ = builder;
		_tmp98_ = docbook_id;
		g_string_append_printf (_tmp97_, "\n" \
"<refsect1 id=\"docs-%s.details\" role=\"details\">\n" \
"<title role=\"details.title\">Details</title>", _tmp98_);
		{
			ValaList* _method_list = NULL;
			ValaList* _tmp99_;
			ValaList* _tmp100_;
			gint _method_size = 0;
			ValaList* _tmp101_;
			gint _tmp102_;
			gint _tmp103_;
			gint _method_index = 0;
			_tmp99_ = self->methods;
			_tmp100_ = _vala_iterable_ref0 (_tmp99_);
			_method_list = _tmp100_;
			_tmp101_ = _method_list;
			_tmp102_ = vala_collection_get_size ((ValaCollection*) _tmp101_);
			_tmp103_ = _tmp102_;
			_method_size = _tmp103_;
			_method_index = -1;
			while (TRUE) {
				gint _tmp104_;
				gint _tmp105_;
				gint _tmp106_;
				GtkdocDBusMember* method = NULL;
				ValaList* _tmp107_;
				gint _tmp108_;
				gpointer _tmp109_;
				gchar* _tmp110_ = NULL;
				GtkdocDBusMember* _tmp111_;
				GtkdocGComment* _tmp112_;
				GString* _tmp117_;
				const gchar* _tmp118_;
				GtkdocDBusMember* _tmp119_;
				gchar* _tmp120_;
				gchar* _tmp121_;
				GtkdocDBusMember* _tmp122_;
				const gchar* _tmp123_;
				GtkdocDBusMember* _tmp124_;
				gint _tmp125_;
				gchar* _tmp126_;
				gchar* _tmp127_;
				_tmp104_ = _method_index;
				_method_index = _tmp104_ + 1;
				_tmp105_ = _method_index;
				_tmp106_ = _method_size;
				if (!(_tmp105_ < _tmp106_)) {
					break;
				}
				_tmp107_ = _method_list;
				_tmp108_ = _method_index;
				_tmp109_ = vala_list_get (_tmp107_, _tmp108_);
				method = (GtkdocDBusMember*) _tmp109_;
				_tmp111_ = method;
				_tmp112_ = _tmp111_->comment;
				if (_tmp112_ != NULL) {
					GtkdocDBusMember* _tmp113_;
					GtkdocGComment* _tmp114_;
					gchar* _tmp115_;
					_tmp113_ = method;
					_tmp114_ = _tmp113_->comment;
					_tmp115_ = gtkdoc_gcomment_to_docbook (_tmp114_, reporter);
					_g_free0 (_tmp110_);
					_tmp110_ = _tmp115_;
				} else {
					gchar* _tmp116_;
					_tmp116_ = g_strdup ("");
					_g_free0 (_tmp110_);
					_tmp110_ = _tmp116_;
				}
				_tmp117_ = builder;
				_tmp118_ = docbook_id;
				_tmp119_ = method;
				_tmp120_ = gtkdoc_dbus_member_get_docbook_id (_tmp119_);
				_tmp121_ = _tmp120_;
				_tmp122_ = method;
				_tmp123_ = _tmp122_->name;
				_tmp124_ = method;
				_tmp125_ = method_indent;
				_tmp126_ = gtkdoc_dbus_member_to_string (_tmp124_, _tmp125_, FALSE);
				_tmp127_ = _tmp126_;
				g_string_append_printf (_tmp117_, "\n" \
"<refsect2 id=\"%s-%s\" role=\"function\">\n" \
"<title>%s ()</title>\n" \
"<programlisting>%s\n" \
"</programlisting>\n" \
"%s\n" \
"</refsect2>", _tmp118_, _tmp121_, _tmp123_, _tmp127_, _tmp110_);
				_g_free0 (_tmp127_);
				_g_free0 (_tmp121_);
				_g_free0 (_tmp110_);
				_gtkdoc_dbus_member_unref0 (method);
			}
			_vala_iterable_unref0 (_method_list);
		}
		_tmp128_ = builder;
		g_string_append (_tmp128_, "</refsect1>");
	}
	_tmp129_ = self->signals;
	_tmp130_ = vala_collection_get_size ((ValaCollection*) _tmp129_);
	_tmp131_ = _tmp130_;
	if (_tmp131_ > 0) {
		GString* _tmp132_;
		const gchar* _tmp133_;
		GString* _tmp163_;
		_tmp132_ = builder;
		_tmp133_ = docbook_id;
		g_string_append_printf (_tmp132_, "\n" \
"<refsect1 id=\"docs-%s.signal-details\" role=\"signals\">\n" \
"<title role=\"signals.title\">Signal Details</title>", _tmp133_);
		{
			ValaList* _sig_list = NULL;
			ValaList* _tmp134_;
			ValaList* _tmp135_;
			gint _sig_size = 0;
			ValaList* _tmp136_;
			gint _tmp137_;
			gint _tmp138_;
			gint _sig_index = 0;
			_tmp134_ = self->signals;
			_tmp135_ = _vala_iterable_ref0 (_tmp134_);
			_sig_list = _tmp135_;
			_tmp136_ = _sig_list;
			_tmp137_ = vala_collection_get_size ((ValaCollection*) _tmp136_);
			_tmp138_ = _tmp137_;
			_sig_size = _tmp138_;
			_sig_index = -1;
			while (TRUE) {
				gint _tmp139_;
				gint _tmp140_;
				gint _tmp141_;
				GtkdocDBusMember* sig = NULL;
				ValaList* _tmp142_;
				gint _tmp143_;
				gpointer _tmp144_;
				gchar* _tmp145_ = NULL;
				GtkdocDBusMember* _tmp146_;
				GtkdocGComment* _tmp147_;
				GString* _tmp152_;
				const gchar* _tmp153_;
				GtkdocDBusMember* _tmp154_;
				gchar* _tmp155_;
				gchar* _tmp156_;
				GtkdocDBusMember* _tmp157_;
				const gchar* _tmp158_;
				GtkdocDBusMember* _tmp159_;
				gint _tmp160_;
				gchar* _tmp161_;
				gchar* _tmp162_;
				_tmp139_ = _sig_index;
				_sig_index = _tmp139_ + 1;
				_tmp140_ = _sig_index;
				_tmp141_ = _sig_size;
				if (!(_tmp140_ < _tmp141_)) {
					break;
				}
				_tmp142_ = _sig_list;
				_tmp143_ = _sig_index;
				_tmp144_ = vala_list_get (_tmp142_, _tmp143_);
				sig = (GtkdocDBusMember*) _tmp144_;
				_tmp146_ = sig;
				_tmp147_ = _tmp146_->comment;
				if (_tmp147_ != NULL) {
					GtkdocDBusMember* _tmp148_;
					GtkdocGComment* _tmp149_;
					gchar* _tmp150_;
					_tmp148_ = sig;
					_tmp149_ = _tmp148_->comment;
					_tmp150_ = gtkdoc_gcomment_to_docbook (_tmp149_, reporter);
					_g_free0 (_tmp145_);
					_tmp145_ = _tmp150_;
				} else {
					gchar* _tmp151_;
					_tmp151_ = g_strdup ("");
					_g_free0 (_tmp145_);
					_tmp145_ = _tmp151_;
				}
				_tmp152_ = builder;
				_tmp153_ = docbook_id;
				_tmp154_ = sig;
				_tmp155_ = gtkdoc_dbus_member_get_docbook_id (_tmp154_);
				_tmp156_ = _tmp155_;
				_tmp157_ = sig;
				_tmp158_ = _tmp157_->name;
				_tmp159_ = sig;
				_tmp160_ = signal_indent;
				_tmp161_ = gtkdoc_dbus_member_to_string (_tmp159_, _tmp160_, FALSE);
				_tmp162_ = _tmp161_;
				g_string_append_printf (_tmp152_, "\n" \
"<refsect2 id=\"%s-%s\" role=\"signal\">\n" \
"<title>The <literal>%s</literal> signal</title>\n" \
"<programlisting>%s\n" \
"</programlisting>\n" \
"%s\n" \
"</refsect2>", _tmp153_, _tmp156_, _tmp158_, _tmp162_, _tmp145_);
				_g_free0 (_tmp162_);
				_g_free0 (_tmp156_);
				_g_free0 (_tmp145_);
				_gtkdoc_dbus_member_unref0 (sig);
			}
			_vala_iterable_unref0 (_sig_list);
		}
		_tmp163_ = builder;
		g_string_append (_tmp163_, "</refsect1>");
	}
	_tmp164_ = builder;
	g_string_append (_tmp164_, "</refentry>");
	_tmp165_ = builder;
	_tmp166_ = _tmp165_->str;
	_tmp167_ = g_strdup (_tmp166_);
	result = _tmp167_;
	_g_free0 (docbook_id);
	_g_string_free0 (builder);
	return result;
}


static void
gtkdoc_dbus_value_interface_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
gtkdoc_dbus_value_interface_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gtkdoc_dbus_interface_unref (value->data[0].v_pointer);
	}
}


static void
gtkdoc_dbus_value_interface_copy_value (const GValue* src_value,
                                        GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gtkdoc_dbus_interface_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
gtkdoc_dbus_value_interface_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
gtkdoc_dbus_value_interface_collect_value (GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GtkdocDBusInterface * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gtkdoc_dbus_interface_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
gtkdoc_dbus_value_interface_lcopy_value (const GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	GtkdocDBusInterface ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gtkdoc_dbus_interface_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec*
gtkdoc_dbus_param_spec_interface (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags)
{
	GtkdocDBusParamSpecInterface* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GTKDOC_DBUS_TYPE_INTERFACE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer
gtkdoc_dbus_value_get_interface (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_DBUS_TYPE_INTERFACE), NULL);
	return value->data[0].v_pointer;
}


void
gtkdoc_dbus_value_set_interface (GValue* value,
                                 gpointer v_object)
{
	GtkdocDBusInterface * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_DBUS_TYPE_INTERFACE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_DBUS_TYPE_INTERFACE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gtkdoc_dbus_interface_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_dbus_interface_unref (old);
	}
}


void
gtkdoc_dbus_value_take_interface (GValue* value,
                                  gpointer v_object)
{
	GtkdocDBusInterface * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_DBUS_TYPE_INTERFACE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_DBUS_TYPE_INTERFACE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_dbus_interface_unref (old);
	}
}


static void
gtkdoc_dbus_interface_class_init (GtkdocDBusInterfaceClass * klass)
{
	gtkdoc_dbus_interface_parent_class = g_type_class_peek_parent (klass);
	((GtkdocDBusInterfaceClass *) klass)->finalize = gtkdoc_dbus_interface_finalize;
}


static void
gtkdoc_dbus_interface_instance_init (GtkdocDBusInterface * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (GTKDOC_DBUS_TYPE_MEMBER, (GBoxedCopyFunc) gtkdoc_dbus_member_ref, (GDestroyNotify) gtkdoc_dbus_member_unref, _tmp0_);
	self->methods = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (GTKDOC_DBUS_TYPE_MEMBER, (GBoxedCopyFunc) gtkdoc_dbus_member_ref, (GDestroyNotify) gtkdoc_dbus_member_unref, _tmp2_);
	self->signals = (ValaList*) _tmp3_;
	self->ref_count = 1;
}


static void
gtkdoc_dbus_interface_finalize (GtkdocDBusInterface * obj)
{
	GtkdocDBusInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GTKDOC_DBUS_TYPE_INTERFACE, GtkdocDBusInterface);
	g_signal_handlers_destroy (self);
	_g_free0 (self->package_name);
	_g_free0 (self->name);
	_g_free0 (self->purpose);
	_g_free0 (self->description);
	_vala_iterable_unref0 (self->methods);
	_vala_iterable_unref0 (self->signals);
}


GType
gtkdoc_dbus_interface_get_type (void)
{
	static volatile gsize gtkdoc_dbus_interface_type_id__volatile = 0;
	if (g_once_init_enter (&gtkdoc_dbus_interface_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gtkdoc_dbus_value_interface_init, gtkdoc_dbus_value_interface_free_value, gtkdoc_dbus_value_interface_copy_value, gtkdoc_dbus_value_interface_peek_pointer, "p", gtkdoc_dbus_value_interface_collect_value, "p", gtkdoc_dbus_value_interface_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GtkdocDBusInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkdoc_dbus_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkdocDBusInterface), 0, (GInstanceInitFunc) gtkdoc_dbus_interface_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gtkdoc_dbus_interface_type_id;
		gtkdoc_dbus_interface_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GtkdocDBusInterface", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gtkdoc_dbus_interface_type_id__volatile, gtkdoc_dbus_interface_type_id);
	}
	return gtkdoc_dbus_interface_type_id__volatile;
}


gpointer
gtkdoc_dbus_interface_ref (gpointer instance)
{
	GtkdocDBusInterface * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void
gtkdoc_dbus_interface_unref (gpointer instance)
{
	GtkdocDBusInterface * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GTKDOC_DBUS_INTERFACE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



