/* valainterface.c generated by valac, the Vala compiler
 * generated from valainterface.vala, do not modify */

/* valainterface.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))

struct _ValaInterfacePrivate {
	ValaList* prerequisites;
	ValaList* methods;
	ValaList* fields;
	ValaList* constants;
	ValaList* properties;
	ValaList* signals;
	ValaList* virtuals;
	ValaList* classes;
	ValaList* structs;
	ValaList* enums;
	ValaList* delegates;
};


static gpointer vala_interface_parent_class = NULL;

#define VALA_INTERFACE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_INTERFACE, ValaInterfacePrivate))
static void vala_interface_real_add_method (ValaSymbol* base,
                                     ValaMethod* m);
static ValaList* vala_interface_real_get_methods (ValaObjectTypeSymbol* base);
static void vala_interface_real_add_field (ValaSymbol* base,
                                    ValaField* f);
static void vala_interface_real_add_constant (ValaSymbol* base,
                                       ValaConstant* c);
static void vala_interface_real_add_property (ValaSymbol* base,
                                       ValaProperty* prop);
static ValaList* vala_interface_real_get_properties (ValaObjectTypeSymbol* base);
static void vala_interface_real_add_signal (ValaSymbol* base,
                                     ValaSignal* sig);
static ValaList* vala_interface_real_get_signals (ValaObjectTypeSymbol* base);
static ValaList* vala_interface_real_get_virtuals (ValaInterface* self);
static void vala_interface_real_add_class (ValaSymbol* base,
                                    ValaClass* cl);
static void vala_interface_real_add_struct (ValaSymbol* base,
                                     ValaStruct* st);
static void vala_interface_real_add_enum (ValaSymbol* base,
                                   ValaEnum* en);
static void vala_interface_real_add_delegate (ValaSymbol* base,
                                       ValaDelegate* d);
static void vala_interface_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor);
static void vala_interface_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor);
static gboolean vala_interface_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_interface_real_is_subtype_of (ValaTypeSymbol* base,
                                            ValaTypeSymbol* t);
static void vala_interface_real_replace_type (ValaCodeNode* base,
                                       ValaDataType* old_type,
                                       ValaDataType* new_type);
static gboolean vala_interface_real_check (ValaCodeNode* base,
                                    ValaCodeContext* context);
static void vala_interface_finalize (ValaCodeNode * obj);


/**
 * Returns a copy of the list of classes.
 *
 * @return list of classes
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_interface_get_classes (ValaInterface* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->classes;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns a copy of the list of structs.
 *
 * @return list of structs
 */
ValaList*
vala_interface_get_structs (ValaInterface* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->structs;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns a copy of the list of enums.
 *
 * @return list of enums
 */
ValaList*
vala_interface_get_enums (ValaInterface* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->enums;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns a copy of the list of delegates.
 *
 * @return list of delegates
 */
ValaList*
vala_interface_get_delegates (ValaInterface* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->delegates;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Creates a new interface.
 *
 * @param name              type name
 * @param source_reference  reference to source code
 * @return                  newly created interface
 */
ValaInterface*
vala_interface_construct (GType object_type,
                          const gchar* name,
                          ValaSourceReference* source_reference,
                          ValaComment* comment)
{
	ValaInterface* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaInterface*) vala_object_type_symbol_construct (object_type, name, source_reference, comment);
	return self;
}


ValaInterface*
vala_interface_new (const gchar* name,
                    ValaSourceReference* source_reference,
                    ValaComment* comment)
{
	return vala_interface_construct (VALA_TYPE_INTERFACE, name, source_reference, comment);
}


/**
 * Adds the specified interface or class to the list of prerequisites of
 * this interface.
 *
 * @param type an interface or class reference
 */
void
vala_interface_add_prerequisite (ValaInterface* self,
                                 ValaDataType* type)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->prerequisites;
	vala_collection_add ((ValaCollection*) _tmp0_, type);
	vala_code_node_set_parent_node ((ValaCodeNode*) type, (ValaCodeNode*) self);
}


/**
 * Prepends the specified interface or class to the list of
 * prerequisites of this interface.
 *
 * @param type an interface or class reference
 */
void
vala_interface_prepend_prerequisite (ValaInterface* self,
                                     ValaDataType* type)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->prerequisites;
	vala_list_insert (_tmp0_, 0, type);
}


/**
 * Returns a copy of the base type list.
 *
 * @return list of base types
 */
ValaList*
vala_interface_get_prerequisites (ValaInterface* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prerequisites;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified method as a member to this interface.
 *
 * @param m a method
 */
static void
vala_interface_real_add_method (ValaSymbol* base,
                                ValaMethod* m)
{
	ValaInterface * self;
	ValaMemberBinding _tmp2_;
	ValaMemberBinding _tmp3_;
	gboolean _tmp16_ = FALSE;
	ValaDataType* _tmp17_;
	ValaDataType* _tmp18_;
	ValaList* _tmp33_;
	ValaScope* _tmp34_;
	ValaScope* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	self = (ValaInterface*) base;
	g_return_if_fail (m != NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (m, VALA_TYPE_CREATION_METHOD)) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp1_ = _tmp0_;
		vala_report_error (_tmp1_, "construction methods may only be declared within classes and structs");
		vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
		return;
	}
	_tmp2_ = vala_method_get_binding (m);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaObjectType* _tmp4_;
		ValaObjectType* _tmp5_;
		ValaParameter* _tmp6_;
		ValaParameter* _tmp7_;
		ValaScope* _tmp8_;
		ValaScope* _tmp9_;
		ValaParameter* _tmp10_;
		ValaParameter* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		ValaParameter* _tmp14_;
		ValaParameter* _tmp15_;
		_tmp4_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_parameter_new ("this", (ValaDataType*) _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		vala_method_set_this_parameter (m, _tmp7_);
		_vala_code_node_unref0 (_tmp7_);
		_vala_code_node_unref0 (_tmp5_);
		_tmp8_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_method_get_this_parameter (m);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_method_get_this_parameter (m);
		_tmp15_ = _tmp14_;
		vala_scope_add (_tmp9_, _tmp13_, (ValaSymbol*) _tmp15_);
	}
	_tmp17_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp18_ = _tmp17_;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, VALA_TYPE_VOID_TYPE)) {
		ValaList* _tmp19_;
		ValaList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		_tmp19_ = vala_method_get_postconditions (m);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp16_ = _tmp22_ > 0;
		_vala_iterable_unref0 (_tmp20_);
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		ValaDataType* _tmp23_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaDataType* _tmp26_;
		ValaSourceReference* _tmp27_;
		ValaSourceReference* _tmp28_;
		ValaLocalVariable* _tmp29_;
		ValaLocalVariable* _tmp30_;
		ValaLocalVariable* _tmp31_;
		ValaLocalVariable* _tmp32_;
		_tmp23_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp24_ = _tmp23_;
		_tmp25_ = vala_data_type_copy (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp28_ = _tmp27_;
		_tmp29_ = vala_local_variable_new (_tmp26_, "result", NULL, _tmp28_);
		_tmp30_ = _tmp29_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp30_);
		_vala_code_node_unref0 (_tmp30_);
		_vala_code_node_unref0 (_tmp26_);
		_tmp31_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp32_ = _tmp31_;
		vala_local_variable_set_is_result (_tmp32_, TRUE);
	}
	_tmp33_ = self->priv->methods;
	vala_collection_add ((ValaCollection*) _tmp33_, m);
	_tmp34_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = vala_symbol_get_name ((ValaSymbol*) m);
	_tmp37_ = _tmp36_;
	vala_scope_add (_tmp35_, _tmp37_, (ValaSymbol*) m);
}


/**
 * Returns a copy of the list of methods.
 *
 * @return list of methods
 */
static ValaList*
vala_interface_real_get_methods (ValaObjectTypeSymbol* base)
{
	ValaInterface * self;
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	self = (ValaInterface*) base;
	_tmp0_ = self->priv->methods;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified field as a member to this interface. The field
 * must be private and static.
 *
 * @param f a field
 */
static void
vala_interface_real_add_field (ValaSymbol* base,
                               ValaField* f)
{
	ValaInterface * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaInterface*) base;
	g_return_if_fail (f != NULL);
	_tmp0_ = self->priv->fields;
	vala_collection_add ((ValaCollection*) _tmp0_, f);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) f);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) f);
}


/**
 * Returns a copy of the list of fields.
 *
 * @return list of fields
 */
ValaList*
vala_interface_get_fields (ValaInterface* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->fields;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified constant as a member to this interface.
 *
 * @param c a constant
 */
static void
vala_interface_real_add_constant (ValaSymbol* base,
                                  ValaConstant* c)
{
	ValaInterface * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaInterface*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = self->priv->constants;
	vala_collection_add ((ValaCollection*) _tmp0_, c);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) c);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) c);
}


/**
 * Returns a copy of the list of constants.
 *
 * @return list of constants
 */
ValaList*
vala_interface_get_constants (ValaInterface* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->constants;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified property as a member to this interface.
 *
 * @param prop a property
 */
static void
vala_interface_real_add_property (ValaSymbol* base,
                                  ValaProperty* prop)
{
	ValaInterface * self;
	ValaField* _tmp0_;
	ValaField* _tmp1_;
	ValaList* _tmp4_;
	ValaScope* _tmp5_;
	ValaScope* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	ValaObjectType* _tmp9_;
	ValaObjectType* _tmp10_;
	ValaParameter* _tmp11_;
	ValaParameter* _tmp12_;
	ValaScope* _tmp13_;
	ValaScope* _tmp14_;
	ValaParameter* _tmp15_;
	ValaParameter* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	ValaParameter* _tmp19_;
	ValaParameter* _tmp20_;
	self = (ValaInterface*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = vala_property_get_field (prop);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) prop);
		_tmp3_ = _tmp2_;
		vala_report_error (_tmp3_, "automatic properties are not allowed in interfaces");
		vala_code_node_set_error ((ValaCodeNode*) prop, TRUE);
		return;
	}
	_tmp4_ = self->priv->properties;
	vala_collection_add ((ValaCollection*) _tmp4_, prop);
	_tmp5_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_symbol_get_name ((ValaSymbol*) prop);
	_tmp8_ = _tmp7_;
	vala_scope_add (_tmp6_, _tmp8_, (ValaSymbol*) prop);
	_tmp9_ = vala_object_type_new ((ValaObjectTypeSymbol*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_parameter_new ("this", (ValaDataType*) _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	vala_property_set_this_parameter (prop, _tmp12_);
	_vala_code_node_unref0 (_tmp12_);
	_vala_code_node_unref0 (_tmp10_);
	_tmp13_ = vala_symbol_get_scope ((ValaSymbol*) prop);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_property_get_this_parameter (prop);
	_tmp16_ = _tmp15_;
	_tmp17_ = vala_symbol_get_name ((ValaSymbol*) _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = vala_property_get_this_parameter (prop);
	_tmp20_ = _tmp19_;
	vala_scope_add (_tmp14_, _tmp18_, (ValaSymbol*) _tmp20_);
}


/**
 * Returns a copy of the list of properties.
 *
 * @return list of properties
 */
static ValaList*
vala_interface_real_get_properties (ValaObjectTypeSymbol* base)
{
	ValaInterface * self;
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	self = (ValaInterface*) base;
	_tmp0_ = self->priv->properties;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified signal as a member to this interface.
 *
 * @param sig a signal
 */
static void
vala_interface_real_add_signal (ValaSymbol* base,
                                ValaSignal* sig)
{
	ValaInterface * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaInterface*) base;
	g_return_if_fail (sig != NULL);
	_tmp0_ = self->priv->signals;
	vala_collection_add ((ValaCollection*) _tmp0_, sig);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) sig);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) sig);
}


/**
 * Returns a copy of the list of signals.
 *
 * @return list of signals
 */
static ValaList*
vala_interface_real_get_signals (ValaObjectTypeSymbol* base)
{
	ValaInterface * self;
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	self = (ValaInterface*) base;
	_tmp0_ = self->priv->signals;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static ValaList*
vala_interface_real_get_virtuals (ValaInterface* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	_tmp0_ = self->priv->virtuals;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


ValaList*
vala_interface_get_virtuals (ValaInterface* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_INTERFACE_GET_CLASS (self)->get_virtuals (self);
}


/**
 * Adds the specified class as an inner class.
 *
 * @param cl a class
 */
static void
vala_interface_real_add_class (ValaSymbol* base,
                               ValaClass* cl)
{
	ValaInterface * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaInterface*) base;
	g_return_if_fail (cl != NULL);
	_tmp0_ = self->priv->classes;
	vala_collection_add ((ValaCollection*) _tmp0_, cl);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) cl);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) cl);
}


/**
 * Adds the specified struct as an inner struct.
 *
 * @param st a struct
 */
static void
vala_interface_real_add_struct (ValaSymbol* base,
                                ValaStruct* st)
{
	ValaInterface * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaInterface*) base;
	g_return_if_fail (st != NULL);
	_tmp0_ = self->priv->structs;
	vala_collection_add ((ValaCollection*) _tmp0_, st);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) st);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) st);
}


/**
 * Adds the specified enum as an inner enum.
 *
 * @param en an enum
 */
static void
vala_interface_real_add_enum (ValaSymbol* base,
                              ValaEnum* en)
{
	ValaInterface * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaInterface*) base;
	g_return_if_fail (en != NULL);
	_tmp0_ = self->priv->enums;
	vala_collection_add ((ValaCollection*) _tmp0_, en);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) en);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) en);
}


/**
 * Adds the specified delegate as an inner delegate.
 *
 * @param d a delegate
 */
static void
vala_interface_real_add_delegate (ValaSymbol* base,
                                  ValaDelegate* d)
{
	ValaInterface * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaInterface*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = self->priv->delegates;
	vala_collection_add ((ValaCollection*) _tmp0_, d);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) d);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) d);
}


static void
vala_interface_real_accept (ValaCodeNode* base,
                            ValaCodeVisitor* visitor)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_interface (visitor, self);
}


static void
vala_interface_real_accept_children (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _type_index = 0;
		_tmp0_ = self->priv->prerequisites;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_type_list = _tmp1_;
		_tmp2_ = _type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_type_size = _tmp4_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaDataType* type = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaDataType* _tmp11_;
			_tmp5_ = _type_index;
			_type_index = _tmp5_ + 1;
			_tmp6_ = _type_index;
			_tmp7_ = _type_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _type_list;
			_tmp9_ = _type_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			type = (ValaDataType*) _tmp10_;
			_tmp11_ = type;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp12_;
		gint _p_size = 0;
		ValaList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _p_index = 0;
		_tmp12_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp12_;
		_tmp13_ = _p_list;
		_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_p_size = _tmp15_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp19_;
			gint _tmp20_;
			gpointer _tmp21_;
			ValaTypeParameter* _tmp22_;
			_tmp16_ = _p_index;
			_p_index = _tmp16_ + 1;
			_tmp17_ = _p_index;
			_tmp18_ = _p_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _p_list;
			_tmp20_ = _p_index;
			_tmp21_ = vala_list_get (_tmp19_, _tmp20_);
			p = (ValaTypeParameter*) _tmp21_;
			_tmp22_ = p;
			vala_code_node_accept ((ValaCodeNode*) _tmp22_, visitor);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp23_;
		ValaList* _tmp24_;
		gint _en_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _en_index = 0;
		_tmp23_ = self->priv->enums;
		_tmp24_ = _vala_iterable_ref0 (_tmp23_);
		_en_list = _tmp24_;
		_tmp25_ = _en_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_en_size = _tmp27_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			ValaEnum* en = NULL;
			ValaList* _tmp31_;
			gint _tmp32_;
			gpointer _tmp33_;
			ValaEnum* _tmp34_;
			_tmp28_ = _en_index;
			_en_index = _tmp28_ + 1;
			_tmp29_ = _en_index;
			_tmp30_ = _en_size;
			if (!(_tmp29_ < _tmp30_)) {
				break;
			}
			_tmp31_ = _en_list;
			_tmp32_ = _en_index;
			_tmp33_ = vala_list_get (_tmp31_, _tmp32_);
			en = (ValaEnum*) _tmp33_;
			_tmp34_ = en;
			vala_code_node_accept ((ValaCodeNode*) _tmp34_, visitor);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp35_;
		ValaList* _tmp36_;
		gint _m_size = 0;
		ValaList* _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		gint _m_index = 0;
		_tmp35_ = self->priv->methods;
		_tmp36_ = _vala_iterable_ref0 (_tmp35_);
		_m_list = _tmp36_;
		_tmp37_ = _m_list;
		_tmp38_ = vala_collection_get_size ((ValaCollection*) _tmp37_);
		_tmp39_ = _tmp38_;
		_m_size = _tmp39_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp40_;
			gint _tmp41_;
			gint _tmp42_;
			ValaMethod* m = NULL;
			ValaList* _tmp43_;
			gint _tmp44_;
			gpointer _tmp45_;
			ValaMethod* _tmp46_;
			_tmp40_ = _m_index;
			_m_index = _tmp40_ + 1;
			_tmp41_ = _m_index;
			_tmp42_ = _m_size;
			if (!(_tmp41_ < _tmp42_)) {
				break;
			}
			_tmp43_ = _m_list;
			_tmp44_ = _m_index;
			_tmp45_ = vala_list_get (_tmp43_, _tmp44_);
			m = (ValaMethod*) _tmp45_;
			_tmp46_ = m;
			vala_code_node_accept ((ValaCodeNode*) _tmp46_, visitor);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp47_;
		ValaList* _tmp48_;
		gint _f_size = 0;
		ValaList* _tmp49_;
		gint _tmp50_;
		gint _tmp51_;
		gint _f_index = 0;
		_tmp47_ = self->priv->fields;
		_tmp48_ = _vala_iterable_ref0 (_tmp47_);
		_f_list = _tmp48_;
		_tmp49_ = _f_list;
		_tmp50_ = vala_collection_get_size ((ValaCollection*) _tmp49_);
		_tmp51_ = _tmp50_;
		_f_size = _tmp51_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp52_;
			gint _tmp53_;
			gint _tmp54_;
			ValaField* f = NULL;
			ValaList* _tmp55_;
			gint _tmp56_;
			gpointer _tmp57_;
			ValaField* _tmp58_;
			_tmp52_ = _f_index;
			_f_index = _tmp52_ + 1;
			_tmp53_ = _f_index;
			_tmp54_ = _f_size;
			if (!(_tmp53_ < _tmp54_)) {
				break;
			}
			_tmp55_ = _f_list;
			_tmp56_ = _f_index;
			_tmp57_ = vala_list_get (_tmp55_, _tmp56_);
			f = (ValaField*) _tmp57_;
			_tmp58_ = f;
			vala_code_node_accept ((ValaCodeNode*) _tmp58_, visitor);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp59_;
		ValaList* _tmp60_;
		gint _c_size = 0;
		ValaList* _tmp61_;
		gint _tmp62_;
		gint _tmp63_;
		gint _c_index = 0;
		_tmp59_ = self->priv->constants;
		_tmp60_ = _vala_iterable_ref0 (_tmp59_);
		_c_list = _tmp60_;
		_tmp61_ = _c_list;
		_tmp62_ = vala_collection_get_size ((ValaCollection*) _tmp61_);
		_tmp63_ = _tmp62_;
		_c_size = _tmp63_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp64_;
			gint _tmp65_;
			gint _tmp66_;
			ValaConstant* c = NULL;
			ValaList* _tmp67_;
			gint _tmp68_;
			gpointer _tmp69_;
			ValaConstant* _tmp70_;
			_tmp64_ = _c_index;
			_c_index = _tmp64_ + 1;
			_tmp65_ = _c_index;
			_tmp66_ = _c_size;
			if (!(_tmp65_ < _tmp66_)) {
				break;
			}
			_tmp67_ = _c_list;
			_tmp68_ = _c_index;
			_tmp69_ = vala_list_get (_tmp67_, _tmp68_);
			c = (ValaConstant*) _tmp69_;
			_tmp70_ = c;
			vala_code_node_accept ((ValaCodeNode*) _tmp70_, visitor);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp71_;
		ValaList* _tmp72_;
		gint _prop_size = 0;
		ValaList* _tmp73_;
		gint _tmp74_;
		gint _tmp75_;
		gint _prop_index = 0;
		_tmp71_ = self->priv->properties;
		_tmp72_ = _vala_iterable_ref0 (_tmp71_);
		_prop_list = _tmp72_;
		_tmp73_ = _prop_list;
		_tmp74_ = vala_collection_get_size ((ValaCollection*) _tmp73_);
		_tmp75_ = _tmp74_;
		_prop_size = _tmp75_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp76_;
			gint _tmp77_;
			gint _tmp78_;
			ValaProperty* prop = NULL;
			ValaList* _tmp79_;
			gint _tmp80_;
			gpointer _tmp81_;
			ValaProperty* _tmp82_;
			_tmp76_ = _prop_index;
			_prop_index = _tmp76_ + 1;
			_tmp77_ = _prop_index;
			_tmp78_ = _prop_size;
			if (!(_tmp77_ < _tmp78_)) {
				break;
			}
			_tmp79_ = _prop_list;
			_tmp80_ = _prop_index;
			_tmp81_ = vala_list_get (_tmp79_, _tmp80_);
			prop = (ValaProperty*) _tmp81_;
			_tmp82_ = prop;
			vala_code_node_accept ((ValaCodeNode*) _tmp82_, visitor);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp83_;
		ValaList* _tmp84_;
		gint _sig_size = 0;
		ValaList* _tmp85_;
		gint _tmp86_;
		gint _tmp87_;
		gint _sig_index = 0;
		_tmp83_ = self->priv->signals;
		_tmp84_ = _vala_iterable_ref0 (_tmp83_);
		_sig_list = _tmp84_;
		_tmp85_ = _sig_list;
		_tmp86_ = vala_collection_get_size ((ValaCollection*) _tmp85_);
		_tmp87_ = _tmp86_;
		_sig_size = _tmp87_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp88_;
			gint _tmp89_;
			gint _tmp90_;
			ValaSignal* sig = NULL;
			ValaList* _tmp91_;
			gint _tmp92_;
			gpointer _tmp93_;
			ValaSignal* _tmp94_;
			_tmp88_ = _sig_index;
			_sig_index = _tmp88_ + 1;
			_tmp89_ = _sig_index;
			_tmp90_ = _sig_size;
			if (!(_tmp89_ < _tmp90_)) {
				break;
			}
			_tmp91_ = _sig_list;
			_tmp92_ = _sig_index;
			_tmp93_ = vala_list_get (_tmp91_, _tmp92_);
			sig = (ValaSignal*) _tmp93_;
			_tmp94_ = sig;
			vala_code_node_accept ((ValaCodeNode*) _tmp94_, visitor);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp95_;
		ValaList* _tmp96_;
		gint _cl_size = 0;
		ValaList* _tmp97_;
		gint _tmp98_;
		gint _tmp99_;
		gint _cl_index = 0;
		_tmp95_ = self->priv->classes;
		_tmp96_ = _vala_iterable_ref0 (_tmp95_);
		_cl_list = _tmp96_;
		_tmp97_ = _cl_list;
		_tmp98_ = vala_collection_get_size ((ValaCollection*) _tmp97_);
		_tmp99_ = _tmp98_;
		_cl_size = _tmp99_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp100_;
			gint _tmp101_;
			gint _tmp102_;
			ValaClass* cl = NULL;
			ValaList* _tmp103_;
			gint _tmp104_;
			gpointer _tmp105_;
			ValaClass* _tmp106_;
			_tmp100_ = _cl_index;
			_cl_index = _tmp100_ + 1;
			_tmp101_ = _cl_index;
			_tmp102_ = _cl_size;
			if (!(_tmp101_ < _tmp102_)) {
				break;
			}
			_tmp103_ = _cl_list;
			_tmp104_ = _cl_index;
			_tmp105_ = vala_list_get (_tmp103_, _tmp104_);
			cl = (ValaClass*) _tmp105_;
			_tmp106_ = cl;
			vala_code_node_accept ((ValaCodeNode*) _tmp106_, visitor);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp107_;
		ValaList* _tmp108_;
		gint _st_size = 0;
		ValaList* _tmp109_;
		gint _tmp110_;
		gint _tmp111_;
		gint _st_index = 0;
		_tmp107_ = self->priv->structs;
		_tmp108_ = _vala_iterable_ref0 (_tmp107_);
		_st_list = _tmp108_;
		_tmp109_ = _st_list;
		_tmp110_ = vala_collection_get_size ((ValaCollection*) _tmp109_);
		_tmp111_ = _tmp110_;
		_st_size = _tmp111_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp112_;
			gint _tmp113_;
			gint _tmp114_;
			ValaStruct* st = NULL;
			ValaList* _tmp115_;
			gint _tmp116_;
			gpointer _tmp117_;
			ValaStruct* _tmp118_;
			_tmp112_ = _st_index;
			_st_index = _tmp112_ + 1;
			_tmp113_ = _st_index;
			_tmp114_ = _st_size;
			if (!(_tmp113_ < _tmp114_)) {
				break;
			}
			_tmp115_ = _st_list;
			_tmp116_ = _st_index;
			_tmp117_ = vala_list_get (_tmp115_, _tmp116_);
			st = (ValaStruct*) _tmp117_;
			_tmp118_ = st;
			vala_code_node_accept ((ValaCodeNode*) _tmp118_, visitor);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp119_;
		ValaList* _tmp120_;
		gint _d_size = 0;
		ValaList* _tmp121_;
		gint _tmp122_;
		gint _tmp123_;
		gint _d_index = 0;
		_tmp119_ = self->priv->delegates;
		_tmp120_ = _vala_iterable_ref0 (_tmp119_);
		_d_list = _tmp120_;
		_tmp121_ = _d_list;
		_tmp122_ = vala_collection_get_size ((ValaCollection*) _tmp121_);
		_tmp123_ = _tmp122_;
		_d_size = _tmp123_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp124_;
			gint _tmp125_;
			gint _tmp126_;
			ValaDelegate* d = NULL;
			ValaList* _tmp127_;
			gint _tmp128_;
			gpointer _tmp129_;
			ValaDelegate* _tmp130_;
			_tmp124_ = _d_index;
			_d_index = _tmp124_ + 1;
			_tmp125_ = _d_index;
			_tmp126_ = _d_size;
			if (!(_tmp125_ < _tmp126_)) {
				break;
			}
			_tmp127_ = _d_list;
			_tmp128_ = _d_index;
			_tmp129_ = vala_list_get (_tmp127_, _tmp128_);
			d = (ValaDelegate*) _tmp129_;
			_tmp130_ = d;
			vala_code_node_accept ((ValaCodeNode*) _tmp130_, visitor);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
}


static gboolean
vala_interface_real_is_reference_type (ValaTypeSymbol* base)
{
	ValaInterface * self;
	gboolean result = FALSE;
	self = (ValaInterface*) base;
	result = TRUE;
	return result;
}


static gboolean
vala_interface_real_is_subtype_of (ValaTypeSymbol* base,
                                   ValaTypeSymbol* t)
{
	ValaInterface * self;
	gboolean result = FALSE;
	self = (ValaInterface*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _prerequisite_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _prerequisite_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _prerequisite_index = 0;
		_tmp0_ = self->priv->prerequisites;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_prerequisite_list = _tmp1_;
		_tmp2_ = _prerequisite_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_prerequisite_size = _tmp4_;
		_prerequisite_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaDataType* prerequisite = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			gboolean _tmp11_ = FALSE;
			ValaDataType* _tmp12_;
			ValaTypeSymbol* _tmp13_;
			ValaTypeSymbol* _tmp14_;
			_tmp5_ = _prerequisite_index;
			_prerequisite_index = _tmp5_ + 1;
			_tmp6_ = _prerequisite_index;
			_tmp7_ = _prerequisite_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _prerequisite_list;
			_tmp9_ = _prerequisite_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			prerequisite = (ValaDataType*) _tmp10_;
			_tmp12_ = prerequisite;
			_tmp13_ = vala_data_type_get_data_type (_tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_ != NULL) {
				ValaDataType* _tmp15_;
				ValaTypeSymbol* _tmp16_;
				ValaTypeSymbol* _tmp17_;
				_tmp15_ = prerequisite;
				_tmp16_ = vala_data_type_get_data_type (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp11_ = vala_typesymbol_is_subtype_of (_tmp17_, t);
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				result = TRUE;
				_vala_code_node_unref0 (prerequisite);
				_vala_iterable_unref0 (_prerequisite_list);
				return result;
			}
			_vala_code_node_unref0 (prerequisite);
		}
		_vala_iterable_unref0 (_prerequisite_list);
	}
	result = FALSE;
	return result;
}


static void
vala_interface_real_replace_type (ValaCodeNode* base,
                                  ValaDataType* old_type,
                                  ValaDataType* new_type)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ValaList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				ValaList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				ValaDataType* _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->prerequisites;
				_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->prerequisites;
				_tmp7_ = i;
				_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
				_tmp9_ = (ValaDataType*) _tmp8_;
				_tmp10_ = _tmp9_ == old_type;
				_vala_code_node_unref0 (_tmp9_);
				if (_tmp10_) {
					ValaList* _tmp11_;
					gint _tmp12_;
					_tmp11_ = self->priv->prerequisites;
					_tmp12_ = i;
					vala_list_set (_tmp11_, _tmp12_, new_type);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_type, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}


static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_interface_real_check (ValaCodeNode* base,
                           ValaCodeContext* context)
{
	ValaInterface * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaClass* prereq_class = NULL;
	ValaMap* positions = NULL;
	GHashFunc _tmp241_;
	GEqualFunc _tmp242_;
	GEqualFunc _tmp243_;
	ValaHashMap* _tmp244_;
	gboolean ordered_seen = FALSE;
	gboolean unordered_seen = FALSE;
	gboolean _tmp321_;
	ValaSemanticAnalyzer* _tmp344_;
	ValaSemanticAnalyzer* _tmp345_;
	ValaSourceFile* _tmp346_;
	ValaSemanticAnalyzer* _tmp347_;
	ValaSemanticAnalyzer* _tmp348_;
	ValaSymbol* _tmp349_;
	gboolean _tmp350_;
	gboolean _tmp351_;
	self = (ValaInterface*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	{
		ValaList* _prerequisite_reference_list = NULL;
		ValaList* _tmp24_;
		gint _prerequisite_reference_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _prerequisite_reference_index = 0;
		_tmp24_ = vala_interface_get_prerequisites (self);
		_prerequisite_reference_list = _tmp24_;
		_tmp25_ = _prerequisite_reference_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_prerequisite_reference_size = _tmp27_;
		_prerequisite_reference_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			ValaDataType* prerequisite_reference = NULL;
			ValaList* _tmp31_;
			gint _tmp32_;
			gpointer _tmp33_;
			ValaSemanticAnalyzer* _tmp34_;
			ValaSemanticAnalyzer* _tmp35_;
			ValaDataType* _tmp36_;
			_tmp28_ = _prerequisite_reference_index;
			_prerequisite_reference_index = _tmp28_ + 1;
			_tmp29_ = _prerequisite_reference_index;
			_tmp30_ = _prerequisite_reference_size;
			if (!(_tmp29_ < _tmp30_)) {
				break;
			}
			_tmp31_ = _prerequisite_reference_list;
			_tmp32_ = _prerequisite_reference_index;
			_tmp33_ = vala_list_get (_tmp31_, _tmp32_);
			prerequisite_reference = (ValaDataType*) _tmp33_;
			_tmp34_ = vala_code_context_get_analyzer (context);
			_tmp35_ = _tmp34_;
			_tmp36_ = prerequisite_reference;
			if (!vala_semantic_analyzer_is_type_accessible (_tmp35_, (ValaSymbol*) self, _tmp36_)) {
				ValaSourceReference* _tmp37_;
				ValaSourceReference* _tmp38_;
				ValaDataType* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp37_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp38_ = _tmp37_;
				_tmp39_ = prerequisite_reference;
				_tmp40_ = vala_code_node_to_string ((ValaCodeNode*) _tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp43_ = _tmp42_;
				_tmp44_ = g_strdup_printf ("prerequisite `%s` is less accessible than interface `%s`", _tmp41_, _tmp43_);
				_tmp45_ = _tmp44_;
				vala_report_error (_tmp38_, _tmp45_);
				_g_free0 (_tmp45_);
				_g_free0 (_tmp43_);
				_g_free0 (_tmp41_);
				result = FALSE;
				_vala_code_node_unref0 (prerequisite_reference);
				_vala_iterable_unref0 (_prerequisite_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (prerequisite_reference);
		}
		_vala_iterable_unref0 (_prerequisite_reference_list);
	}
	prereq_class = NULL;
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp46_;
		gint _prereq_size = 0;
		ValaList* _tmp47_;
		gint _tmp48_;
		gint _tmp49_;
		gint _prereq_index = 0;
		_tmp46_ = vala_interface_get_prerequisites (self);
		_prereq_list = _tmp46_;
		_tmp47_ = _prereq_list;
		_tmp48_ = vala_collection_get_size ((ValaCollection*) _tmp47_);
		_tmp49_ = _tmp48_;
		_prereq_size = _tmp49_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp50_;
			gint _tmp51_;
			gint _tmp52_;
			ValaDataType* prereq = NULL;
			ValaList* _tmp53_;
			gint _tmp54_;
			gpointer _tmp55_;
			ValaTypeSymbol* class_or_interface = NULL;
			ValaDataType* _tmp56_;
			ValaTypeSymbol* _tmp57_;
			ValaTypeSymbol* _tmp58_;
			ValaTypeSymbol* _tmp59_;
			ValaTypeSymbol* _tmp60_;
			ValaTypeSymbol* _tmp61_;
			ValaTypeSymbol* _tmp71_;
			_tmp50_ = _prereq_index;
			_prereq_index = _tmp50_ + 1;
			_tmp51_ = _prereq_index;
			_tmp52_ = _prereq_size;
			if (!(_tmp51_ < _tmp52_)) {
				break;
			}
			_tmp53_ = _prereq_list;
			_tmp54_ = _prereq_index;
			_tmp55_ = vala_list_get (_tmp53_, _tmp54_);
			prereq = (ValaDataType*) _tmp55_;
			_tmp56_ = prereq;
			_tmp57_ = vala_data_type_get_data_type (_tmp56_);
			_tmp58_ = _tmp57_;
			_tmp59_ = _vala_code_node_ref0 (_tmp58_);
			class_or_interface = _tmp59_;
			_tmp60_ = class_or_interface;
			if (_tmp60_ == NULL) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_vala_code_node_unref0 (class_or_interface);
				_vala_code_node_unref0 (prereq);
				continue;
			}
			_tmp61_ = class_or_interface;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp61_, VALA_TYPE_OBJECT_TYPE_SYMBOL)) {
				ValaSourceReference* _tmp62_;
				ValaSourceReference* _tmp63_;
				gchar* _tmp64_;
				gchar* _tmp65_;
				ValaTypeSymbol* _tmp66_;
				gchar* _tmp67_;
				gchar* _tmp68_;
				gchar* _tmp69_;
				gchar* _tmp70_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp62_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp63_ = _tmp62_;
				_tmp64_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp65_ = _tmp64_;
				_tmp66_ = class_or_interface;
				_tmp67_ = vala_code_node_to_string ((ValaCodeNode*) _tmp66_);
				_tmp68_ = _tmp67_;
				_tmp69_ = g_strdup_printf ("Prerequisite `%s` of interface `%s` is not a class or interface", _tmp65_, _tmp68_);
				_tmp70_ = _tmp69_;
				vala_report_error (_tmp63_, _tmp70_);
				_g_free0 (_tmp70_);
				_g_free0 (_tmp68_);
				_g_free0 (_tmp65_);
				result = FALSE;
				_vala_code_node_unref0 (class_or_interface);
				_vala_code_node_unref0 (prereq);
				_vala_iterable_unref0 (_prereq_list);
				_vala_code_node_unref0 (prereq_class);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp71_ = class_or_interface;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp71_, VALA_TYPE_CLASS)) {
				ValaClass* _tmp72_;
				ValaTypeSymbol* _tmp85_;
				ValaClass* _tmp86_;
				_tmp72_ = prereq_class;
				if (_tmp72_ != NULL) {
					ValaSourceReference* _tmp73_;
					ValaSourceReference* _tmp74_;
					gchar* _tmp75_;
					gchar* _tmp76_;
					ValaTypeSymbol* _tmp77_;
					gchar* _tmp78_;
					gchar* _tmp79_;
					ValaClass* _tmp80_;
					gchar* _tmp81_;
					gchar* _tmp82_;
					gchar* _tmp83_;
					gchar* _tmp84_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp73_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp74_ = _tmp73_;
					_tmp75_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp76_ = _tmp75_;
					_tmp77_ = class_or_interface;
					_tmp78_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp77_);
					_tmp79_ = _tmp78_;
					_tmp80_ = prereq_class;
					_tmp81_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp80_);
					_tmp82_ = _tmp81_;
					_tmp83_ = g_strdup_printf ("%s: Interfaces cannot have multiple instantiable prerequisites (`%s' a" \
"nd `%s')", _tmp76_, _tmp79_, _tmp82_);
					_tmp84_ = _tmp83_;
					vala_report_error (_tmp74_, _tmp84_);
					_g_free0 (_tmp84_);
					_g_free0 (_tmp82_);
					_g_free0 (_tmp79_);
					_g_free0 (_tmp76_);
					result = FALSE;
					_vala_code_node_unref0 (class_or_interface);
					_vala_code_node_unref0 (prereq);
					_vala_iterable_unref0 (_prereq_list);
					_vala_code_node_unref0 (prereq_class);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_tmp85_ = class_or_interface;
				_tmp86_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp85_, VALA_TYPE_CLASS, ValaClass));
				_vala_code_node_unref0 (prereq_class);
				prereq_class = _tmp86_;
			}
			_vala_code_node_unref0 (class_or_interface);
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp87_;
		ValaList* _tmp88_;
		gint _type_size = 0;
		ValaList* _tmp89_;
		gint _tmp90_;
		gint _tmp91_;
		gint _type_index = 0;
		_tmp87_ = self->priv->prerequisites;
		_tmp88_ = _vala_iterable_ref0 (_tmp87_);
		_type_list = _tmp88_;
		_tmp89_ = _type_list;
		_tmp90_ = vala_collection_get_size ((ValaCollection*) _tmp89_);
		_tmp91_ = _tmp90_;
		_type_size = _tmp91_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp92_;
			gint _tmp93_;
			gint _tmp94_;
			ValaDataType* type = NULL;
			ValaList* _tmp95_;
			gint _tmp96_;
			gpointer _tmp97_;
			ValaDataType* _tmp98_;
			_tmp92_ = _type_index;
			_type_index = _tmp92_ + 1;
			_tmp93_ = _type_index;
			_tmp94_ = _type_size;
			if (!(_tmp93_ < _tmp94_)) {
				break;
			}
			_tmp95_ = _type_list;
			_tmp96_ = _type_index;
			_tmp97_ = vala_list_get (_tmp95_, _tmp96_);
			type = (ValaDataType*) _tmp97_;
			_tmp98_ = type;
			vala_code_node_check ((ValaCodeNode*) _tmp98_, context);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp99_;
		gint _p_size = 0;
		ValaList* _tmp100_;
		gint _tmp101_;
		gint _tmp102_;
		gint _p_index = 0;
		_tmp99_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp99_;
		_tmp100_ = _p_list;
		_tmp101_ = vala_collection_get_size ((ValaCollection*) _tmp100_);
		_tmp102_ = _tmp101_;
		_p_size = _tmp102_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp103_;
			gint _tmp104_;
			gint _tmp105_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp106_;
			gint _tmp107_;
			gpointer _tmp108_;
			ValaTypeParameter* _tmp109_;
			_tmp103_ = _p_index;
			_p_index = _tmp103_ + 1;
			_tmp104_ = _p_index;
			_tmp105_ = _p_size;
			if (!(_tmp104_ < _tmp105_)) {
				break;
			}
			_tmp106_ = _p_list;
			_tmp107_ = _p_index;
			_tmp108_ = vala_list_get (_tmp106_, _tmp107_);
			p = (ValaTypeParameter*) _tmp108_;
			_tmp109_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp109_, context);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp110_;
		ValaList* _tmp111_;
		gint _en_size = 0;
		ValaList* _tmp112_;
		gint _tmp113_;
		gint _tmp114_;
		gint _en_index = 0;
		_tmp110_ = self->priv->enums;
		_tmp111_ = _vala_iterable_ref0 (_tmp110_);
		_en_list = _tmp111_;
		_tmp112_ = _en_list;
		_tmp113_ = vala_collection_get_size ((ValaCollection*) _tmp112_);
		_tmp114_ = _tmp113_;
		_en_size = _tmp114_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp115_;
			gint _tmp116_;
			gint _tmp117_;
			ValaEnum* en = NULL;
			ValaList* _tmp118_;
			gint _tmp119_;
			gpointer _tmp120_;
			ValaEnum* _tmp121_;
			_tmp115_ = _en_index;
			_en_index = _tmp115_ + 1;
			_tmp116_ = _en_index;
			_tmp117_ = _en_size;
			if (!(_tmp116_ < _tmp117_)) {
				break;
			}
			_tmp118_ = _en_list;
			_tmp119_ = _en_index;
			_tmp120_ = vala_list_get (_tmp118_, _tmp119_);
			en = (ValaEnum*) _tmp120_;
			_tmp121_ = en;
			vala_code_node_check ((ValaCodeNode*) _tmp121_, context);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp122_;
		ValaList* _tmp123_;
		gint _m_size = 0;
		ValaList* _tmp124_;
		gint _tmp125_;
		gint _tmp126_;
		gint _m_index = 0;
		_tmp122_ = self->priv->methods;
		_tmp123_ = _vala_iterable_ref0 (_tmp122_);
		_m_list = _tmp123_;
		_tmp124_ = _m_list;
		_tmp125_ = vala_collection_get_size ((ValaCollection*) _tmp124_);
		_tmp126_ = _tmp125_;
		_m_size = _tmp126_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp127_;
			gint _tmp128_;
			gint _tmp129_;
			ValaMethod* m = NULL;
			ValaList* _tmp130_;
			gint _tmp131_;
			gpointer _tmp132_;
			ValaMethod* _tmp133_;
			gboolean _tmp134_ = FALSE;
			ValaMethod* _tmp135_;
			gboolean _tmp136_;
			gboolean _tmp137_;
			_tmp127_ = _m_index;
			_m_index = _tmp127_ + 1;
			_tmp128_ = _m_index;
			_tmp129_ = _m_size;
			if (!(_tmp128_ < _tmp129_)) {
				break;
			}
			_tmp130_ = _m_list;
			_tmp131_ = _m_index;
			_tmp132_ = vala_list_get (_tmp130_, _tmp131_);
			m = (ValaMethod*) _tmp132_;
			_tmp133_ = m;
			vala_code_node_check ((ValaCodeNode*) _tmp133_, context);
			_tmp135_ = m;
			_tmp136_ = vala_method_get_is_virtual (_tmp135_);
			_tmp137_ = _tmp136_;
			if (_tmp137_) {
				_tmp134_ = TRUE;
			} else {
				ValaMethod* _tmp138_;
				gboolean _tmp139_;
				gboolean _tmp140_;
				_tmp138_ = m;
				_tmp139_ = vala_method_get_is_abstract (_tmp138_);
				_tmp140_ = _tmp139_;
				_tmp134_ = _tmp140_;
			}
			if (_tmp134_) {
				ValaList* _tmp141_;
				ValaMethod* _tmp142_;
				_tmp141_ = self->priv->virtuals;
				_tmp142_ = m;
				vala_collection_add ((ValaCollection*) _tmp141_, (ValaSymbol*) _tmp142_);
			}
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp143_;
		ValaList* _tmp144_;
		gint _f_size = 0;
		ValaList* _tmp145_;
		gint _tmp146_;
		gint _tmp147_;
		gint _f_index = 0;
		_tmp143_ = self->priv->fields;
		_tmp144_ = _vala_iterable_ref0 (_tmp143_);
		_f_list = _tmp144_;
		_tmp145_ = _f_list;
		_tmp146_ = vala_collection_get_size ((ValaCollection*) _tmp145_);
		_tmp147_ = _tmp146_;
		_f_size = _tmp147_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp148_;
			gint _tmp149_;
			gint _tmp150_;
			ValaField* f = NULL;
			ValaList* _tmp151_;
			gint _tmp152_;
			gpointer _tmp153_;
			ValaField* _tmp154_;
			_tmp148_ = _f_index;
			_f_index = _tmp148_ + 1;
			_tmp149_ = _f_index;
			_tmp150_ = _f_size;
			if (!(_tmp149_ < _tmp150_)) {
				break;
			}
			_tmp151_ = _f_list;
			_tmp152_ = _f_index;
			_tmp153_ = vala_list_get (_tmp151_, _tmp152_);
			f = (ValaField*) _tmp153_;
			_tmp154_ = f;
			vala_code_node_check ((ValaCodeNode*) _tmp154_, context);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp155_;
		ValaList* _tmp156_;
		gint _c_size = 0;
		ValaList* _tmp157_;
		gint _tmp158_;
		gint _tmp159_;
		gint _c_index = 0;
		_tmp155_ = self->priv->constants;
		_tmp156_ = _vala_iterable_ref0 (_tmp155_);
		_c_list = _tmp156_;
		_tmp157_ = _c_list;
		_tmp158_ = vala_collection_get_size ((ValaCollection*) _tmp157_);
		_tmp159_ = _tmp158_;
		_c_size = _tmp159_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp160_;
			gint _tmp161_;
			gint _tmp162_;
			ValaConstant* c = NULL;
			ValaList* _tmp163_;
			gint _tmp164_;
			gpointer _tmp165_;
			ValaConstant* _tmp166_;
			_tmp160_ = _c_index;
			_c_index = _tmp160_ + 1;
			_tmp161_ = _c_index;
			_tmp162_ = _c_size;
			if (!(_tmp161_ < _tmp162_)) {
				break;
			}
			_tmp163_ = _c_list;
			_tmp164_ = _c_index;
			_tmp165_ = vala_list_get (_tmp163_, _tmp164_);
			c = (ValaConstant*) _tmp165_;
			_tmp166_ = c;
			vala_code_node_check ((ValaCodeNode*) _tmp166_, context);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp167_;
		ValaList* _tmp168_;
		gint _sig_size = 0;
		ValaList* _tmp169_;
		gint _tmp170_;
		gint _tmp171_;
		gint _sig_index = 0;
		_tmp167_ = self->priv->signals;
		_tmp168_ = _vala_iterable_ref0 (_tmp167_);
		_sig_list = _tmp168_;
		_tmp169_ = _sig_list;
		_tmp170_ = vala_collection_get_size ((ValaCollection*) _tmp169_);
		_tmp171_ = _tmp170_;
		_sig_size = _tmp171_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp172_;
			gint _tmp173_;
			gint _tmp174_;
			ValaSignal* sig = NULL;
			ValaList* _tmp175_;
			gint _tmp176_;
			gpointer _tmp177_;
			ValaSignal* _tmp178_;
			ValaSignal* _tmp179_;
			gboolean _tmp180_;
			gboolean _tmp181_;
			_tmp172_ = _sig_index;
			_sig_index = _tmp172_ + 1;
			_tmp173_ = _sig_index;
			_tmp174_ = _sig_size;
			if (!(_tmp173_ < _tmp174_)) {
				break;
			}
			_tmp175_ = _sig_list;
			_tmp176_ = _sig_index;
			_tmp177_ = vala_list_get (_tmp175_, _tmp176_);
			sig = (ValaSignal*) _tmp177_;
			_tmp178_ = sig;
			vala_code_node_check ((ValaCodeNode*) _tmp178_, context);
			_tmp179_ = sig;
			_tmp180_ = vala_signal_get_is_virtual (_tmp179_);
			_tmp181_ = _tmp180_;
			if (_tmp181_) {
				ValaList* _tmp182_;
				ValaSignal* _tmp183_;
				_tmp182_ = self->priv->virtuals;
				_tmp183_ = sig;
				vala_collection_add ((ValaCollection*) _tmp182_, (ValaSymbol*) _tmp183_);
			}
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp184_;
		ValaList* _tmp185_;
		gint _prop_size = 0;
		ValaList* _tmp186_;
		gint _tmp187_;
		gint _tmp188_;
		gint _prop_index = 0;
		_tmp184_ = self->priv->properties;
		_tmp185_ = _vala_iterable_ref0 (_tmp184_);
		_prop_list = _tmp185_;
		_tmp186_ = _prop_list;
		_tmp187_ = vala_collection_get_size ((ValaCollection*) _tmp186_);
		_tmp188_ = _tmp187_;
		_prop_size = _tmp188_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp189_;
			gint _tmp190_;
			gint _tmp191_;
			ValaProperty* prop = NULL;
			ValaList* _tmp192_;
			gint _tmp193_;
			gpointer _tmp194_;
			ValaProperty* _tmp195_;
			gboolean _tmp196_ = FALSE;
			ValaProperty* _tmp197_;
			gboolean _tmp198_;
			gboolean _tmp199_;
			_tmp189_ = _prop_index;
			_prop_index = _tmp189_ + 1;
			_tmp190_ = _prop_index;
			_tmp191_ = _prop_size;
			if (!(_tmp190_ < _tmp191_)) {
				break;
			}
			_tmp192_ = _prop_list;
			_tmp193_ = _prop_index;
			_tmp194_ = vala_list_get (_tmp192_, _tmp193_);
			prop = (ValaProperty*) _tmp194_;
			_tmp195_ = prop;
			vala_code_node_check ((ValaCodeNode*) _tmp195_, context);
			_tmp197_ = prop;
			_tmp198_ = vala_property_get_is_virtual (_tmp197_);
			_tmp199_ = _tmp198_;
			if (_tmp199_) {
				_tmp196_ = TRUE;
			} else {
				ValaProperty* _tmp200_;
				gboolean _tmp201_;
				gboolean _tmp202_;
				_tmp200_ = prop;
				_tmp201_ = vala_property_get_is_abstract (_tmp200_);
				_tmp202_ = _tmp201_;
				_tmp196_ = _tmp202_;
			}
			if (_tmp196_) {
				ValaList* _tmp203_;
				ValaProperty* _tmp204_;
				_tmp203_ = self->priv->virtuals;
				_tmp204_ = prop;
				vala_collection_add ((ValaCollection*) _tmp203_, (ValaSymbol*) _tmp204_);
			}
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp205_;
		ValaList* _tmp206_;
		gint _cl_size = 0;
		ValaList* _tmp207_;
		gint _tmp208_;
		gint _tmp209_;
		gint _cl_index = 0;
		_tmp205_ = self->priv->classes;
		_tmp206_ = _vala_iterable_ref0 (_tmp205_);
		_cl_list = _tmp206_;
		_tmp207_ = _cl_list;
		_tmp208_ = vala_collection_get_size ((ValaCollection*) _tmp207_);
		_tmp209_ = _tmp208_;
		_cl_size = _tmp209_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp210_;
			gint _tmp211_;
			gint _tmp212_;
			ValaClass* cl = NULL;
			ValaList* _tmp213_;
			gint _tmp214_;
			gpointer _tmp215_;
			ValaClass* _tmp216_;
			_tmp210_ = _cl_index;
			_cl_index = _tmp210_ + 1;
			_tmp211_ = _cl_index;
			_tmp212_ = _cl_size;
			if (!(_tmp211_ < _tmp212_)) {
				break;
			}
			_tmp213_ = _cl_list;
			_tmp214_ = _cl_index;
			_tmp215_ = vala_list_get (_tmp213_, _tmp214_);
			cl = (ValaClass*) _tmp215_;
			_tmp216_ = cl;
			vala_code_node_check ((ValaCodeNode*) _tmp216_, context);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp217_;
		ValaList* _tmp218_;
		gint _st_size = 0;
		ValaList* _tmp219_;
		gint _tmp220_;
		gint _tmp221_;
		gint _st_index = 0;
		_tmp217_ = self->priv->structs;
		_tmp218_ = _vala_iterable_ref0 (_tmp217_);
		_st_list = _tmp218_;
		_tmp219_ = _st_list;
		_tmp220_ = vala_collection_get_size ((ValaCollection*) _tmp219_);
		_tmp221_ = _tmp220_;
		_st_size = _tmp221_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp222_;
			gint _tmp223_;
			gint _tmp224_;
			ValaStruct* st = NULL;
			ValaList* _tmp225_;
			gint _tmp226_;
			gpointer _tmp227_;
			ValaStruct* _tmp228_;
			_tmp222_ = _st_index;
			_st_index = _tmp222_ + 1;
			_tmp223_ = _st_index;
			_tmp224_ = _st_size;
			if (!(_tmp223_ < _tmp224_)) {
				break;
			}
			_tmp225_ = _st_list;
			_tmp226_ = _st_index;
			_tmp227_ = vala_list_get (_tmp225_, _tmp226_);
			st = (ValaStruct*) _tmp227_;
			_tmp228_ = st;
			vala_code_node_check ((ValaCodeNode*) _tmp228_, context);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp229_;
		ValaList* _tmp230_;
		gint _d_size = 0;
		ValaList* _tmp231_;
		gint _tmp232_;
		gint _tmp233_;
		gint _d_index = 0;
		_tmp229_ = self->priv->delegates;
		_tmp230_ = _vala_iterable_ref0 (_tmp229_);
		_d_list = _tmp230_;
		_tmp231_ = _d_list;
		_tmp232_ = vala_collection_get_size ((ValaCollection*) _tmp231_);
		_tmp233_ = _tmp232_;
		_d_size = _tmp233_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp234_;
			gint _tmp235_;
			gint _tmp236_;
			ValaDelegate* d = NULL;
			ValaList* _tmp237_;
			gint _tmp238_;
			gpointer _tmp239_;
			ValaDelegate* _tmp240_;
			_tmp234_ = _d_index;
			_d_index = _tmp234_ + 1;
			_tmp235_ = _d_index;
			_tmp236_ = _d_size;
			if (!(_tmp235_ < _tmp236_)) {
				break;
			}
			_tmp237_ = _d_list;
			_tmp238_ = _d_index;
			_tmp239_ = vala_list_get (_tmp237_, _tmp238_);
			d = (ValaDelegate*) _tmp239_;
			_tmp240_ = d;
			vala_code_node_check ((ValaCodeNode*) _tmp240_, context);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
	_tmp241_ = g_direct_hash;
	_tmp242_ = g_direct_equal;
	_tmp243_ = g_direct_equal;
	_tmp244_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp241_, _tmp242_, _tmp243_);
	positions = (ValaMap*) _tmp244_;
	ordered_seen = FALSE;
	unordered_seen = FALSE;
	{
		ValaList* _sym_list = NULL;
		ValaList* _tmp245_;
		ValaList* _tmp246_;
		gint _sym_size = 0;
		ValaList* _tmp247_;
		gint _tmp248_;
		gint _tmp249_;
		gint _sym_index = 0;
		_tmp245_ = self->priv->virtuals;
		_tmp246_ = _vala_iterable_ref0 (_tmp245_);
		_sym_list = _tmp246_;
		_tmp247_ = _sym_list;
		_tmp248_ = vala_collection_get_size ((ValaCollection*) _tmp247_);
		_tmp249_ = _tmp248_;
		_sym_size = _tmp249_;
		_sym_index = -1;
		while (TRUE) {
			gint _tmp250_;
			gint _tmp251_;
			gint _tmp252_;
			ValaSymbol* sym = NULL;
			ValaList* _tmp253_;
			gint _tmp254_;
			gpointer _tmp255_;
			gint ordering = 0;
			ValaSymbol* _tmp256_;
			gint _tmp257_;
			gboolean ordered = FALSE;
			gint _tmp266_;
			gboolean _tmp267_ = FALSE;
			gboolean _tmp268_ = FALSE;
			gboolean _tmp269_;
			gboolean _tmp280_ = FALSE;
			gboolean _tmp281_;
			gboolean _tmp283_ = FALSE;
			gboolean _tmp284_ = FALSE;
			gboolean _tmp285_;
			gboolean _tmp296_ = FALSE;
			gboolean _tmp297_;
			gboolean _tmp299_ = FALSE;
			gboolean _tmp300_;
			_tmp250_ = _sym_index;
			_sym_index = _tmp250_ + 1;
			_tmp251_ = _sym_index;
			_tmp252_ = _sym_size;
			if (!(_tmp251_ < _tmp252_)) {
				break;
			}
			_tmp253_ = _sym_list;
			_tmp254_ = _sym_index;
			_tmp255_ = vala_list_get (_tmp253_, _tmp254_);
			sym = (ValaSymbol*) _tmp255_;
			_tmp256_ = sym;
			ordering = vala_code_node_get_attribute_integer ((ValaCodeNode*) _tmp256_, "CCode", "ordering", -1);
			_tmp257_ = ordering;
			if (_tmp257_ < -1) {
				ValaSymbol* _tmp258_;
				ValaSourceReference* _tmp259_;
				ValaSourceReference* _tmp260_;
				ValaSymbol* _tmp261_;
				gchar* _tmp262_;
				gchar* _tmp263_;
				gchar* _tmp264_;
				gchar* _tmp265_;
				_tmp258_ = sym;
				_tmp259_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp258_);
				_tmp260_ = _tmp259_;
				_tmp261_ = sym;
				_tmp262_ = vala_symbol_get_full_name (_tmp261_);
				_tmp263_ = _tmp262_;
				_tmp264_ = g_strdup_printf ("%s: Invalid ordering", _tmp263_);
				_tmp265_ = _tmp264_;
				vala_report_error (_tmp260_, _tmp265_);
				_g_free0 (_tmp265_);
				_g_free0 (_tmp263_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				ordered_seen = TRUE;
				unordered_seen = TRUE;
				_vala_code_node_unref0 (sym);
				continue;
			}
			_tmp266_ = ordering;
			ordered = _tmp266_ != -1;
			_tmp269_ = ordered;
			if (_tmp269_) {
				gboolean _tmp270_;
				_tmp270_ = unordered_seen;
				_tmp268_ = _tmp270_;
			} else {
				_tmp268_ = FALSE;
			}
			if (_tmp268_) {
				gboolean _tmp271_;
				_tmp271_ = ordered_seen;
				_tmp267_ = !_tmp271_;
			} else {
				_tmp267_ = FALSE;
			}
			if (_tmp267_) {
				ValaSymbol* _tmp272_;
				ValaSourceReference* _tmp273_;
				ValaSourceReference* _tmp274_;
				ValaSymbol* _tmp275_;
				gchar* _tmp276_;
				gchar* _tmp277_;
				gchar* _tmp278_;
				gchar* _tmp279_;
				_tmp272_ = sym;
				_tmp273_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp272_);
				_tmp274_ = _tmp273_;
				_tmp275_ = sym;
				_tmp276_ = vala_symbol_get_full_name (_tmp275_);
				_tmp277_ = _tmp276_;
				_tmp278_ = g_strdup_printf ("%s: Cannot mix ordered and unordered virtuals", _tmp277_);
				_tmp279_ = _tmp278_;
				vala_report_error (_tmp274_, _tmp279_);
				_g_free0 (_tmp279_);
				_g_free0 (_tmp277_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_tmp281_ = ordered_seen;
			if (_tmp281_) {
				_tmp280_ = TRUE;
			} else {
				gboolean _tmp282_;
				_tmp282_ = ordered;
				_tmp280_ = _tmp282_;
			}
			ordered_seen = _tmp280_;
			_tmp285_ = ordered;
			if (!_tmp285_) {
				gboolean _tmp286_;
				_tmp286_ = unordered_seen;
				_tmp284_ = !_tmp286_;
			} else {
				_tmp284_ = FALSE;
			}
			if (_tmp284_) {
				gboolean _tmp287_;
				_tmp287_ = ordered_seen;
				_tmp283_ = _tmp287_;
			} else {
				_tmp283_ = FALSE;
			}
			if (_tmp283_) {
				ValaSymbol* _tmp288_;
				ValaSourceReference* _tmp289_;
				ValaSourceReference* _tmp290_;
				ValaSymbol* _tmp291_;
				gchar* _tmp292_;
				gchar* _tmp293_;
				gchar* _tmp294_;
				gchar* _tmp295_;
				_tmp288_ = sym;
				_tmp289_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp288_);
				_tmp290_ = _tmp289_;
				_tmp291_ = sym;
				_tmp292_ = vala_symbol_get_full_name (_tmp291_);
				_tmp293_ = _tmp292_;
				_tmp294_ = g_strdup_printf ("%s: Cannot mix ordered and unordered virtuals", _tmp293_);
				_tmp295_ = _tmp294_;
				vala_report_error (_tmp290_, _tmp295_);
				_g_free0 (_tmp295_);
				_g_free0 (_tmp293_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_tmp297_ = unordered_seen;
			if (_tmp297_) {
				_tmp296_ = TRUE;
			} else {
				gboolean _tmp298_;
				_tmp298_ = ordered;
				_tmp296_ = !_tmp298_;
			}
			unordered_seen = _tmp296_;
			_tmp300_ = ordered_seen;
			if (!_tmp300_) {
				_tmp299_ = TRUE;
			} else {
				gboolean _tmp301_;
				_tmp301_ = unordered_seen;
				_tmp299_ = !_tmp301_;
			}
			if (_tmp299_) {
				gboolean _tmp302_;
				_tmp302_ = ordered;
				if (_tmp302_) {
					ValaSymbol* prev = NULL;
					ValaMap* _tmp303_;
					gint _tmp304_;
					gpointer _tmp305_;
					ValaSymbol* _tmp306_;
					ValaMap* _tmp318_;
					gint _tmp319_;
					ValaSymbol* _tmp320_;
					_tmp303_ = positions;
					_tmp304_ = ordering;
					_tmp305_ = vala_map_get (_tmp303_, (gpointer) ((gintptr) _tmp304_));
					prev = (ValaSymbol*) _tmp305_;
					_tmp306_ = prev;
					if (_tmp306_ != NULL) {
						ValaSymbol* _tmp307_;
						ValaSourceReference* _tmp308_;
						ValaSourceReference* _tmp309_;
						ValaSymbol* _tmp310_;
						gchar* _tmp311_;
						gchar* _tmp312_;
						ValaSymbol* _tmp313_;
						const gchar* _tmp314_;
						const gchar* _tmp315_;
						gchar* _tmp316_;
						gchar* _tmp317_;
						_tmp307_ = sym;
						_tmp308_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp307_);
						_tmp309_ = _tmp308_;
						_tmp310_ = sym;
						_tmp311_ = vala_symbol_get_full_name (_tmp310_);
						_tmp312_ = _tmp311_;
						_tmp313_ = prev;
						_tmp314_ = vala_symbol_get_name (_tmp313_);
						_tmp315_ = _tmp314_;
						_tmp316_ = g_strdup_printf ("%s: Duplicate ordering (previous virtual with the same position is %s)", _tmp312_, _tmp315_);
						_tmp317_ = _tmp316_;
						vala_report_error (_tmp309_, _tmp317_);
						_g_free0 (_tmp317_);
						_g_free0 (_tmp312_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
					_tmp318_ = positions;
					_tmp319_ = ordering;
					_tmp320_ = sym;
					vala_map_set (_tmp318_, (gpointer) ((gintptr) _tmp319_), _tmp320_);
					_vala_code_node_unref0 (prev);
				}
			}
			_vala_code_node_unref0 (sym);
		}
		_vala_iterable_unref0 (_sym_list);
	}
	_tmp321_ = ordered_seen;
	if (_tmp321_) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp322_ = FALSE;
				_tmp322_ = TRUE;
				while (TRUE) {
					gint _tmp324_;
					ValaList* _tmp325_;
					gint _tmp326_;
					gint _tmp327_;
					ValaSymbol* sym = NULL;
					ValaMap* _tmp328_;
					gint _tmp329_;
					gpointer _tmp330_;
					ValaSymbol* _tmp331_;
					gboolean _tmp339_;
					gboolean _tmp340_;
					if (!_tmp322_) {
						gint _tmp323_;
						_tmp323_ = i;
						i = _tmp323_ + 1;
					}
					_tmp322_ = FALSE;
					_tmp324_ = i;
					_tmp325_ = self->priv->virtuals;
					_tmp326_ = vala_collection_get_size ((ValaCollection*) _tmp325_);
					_tmp327_ = _tmp326_;
					if (!(_tmp324_ < _tmp327_)) {
						break;
					}
					_tmp328_ = positions;
					_tmp329_ = i;
					_tmp330_ = vala_map_get (_tmp328_, (gpointer) ((gintptr) _tmp329_));
					sym = (ValaSymbol*) _tmp330_;
					_tmp331_ = sym;
					if (_tmp331_ == NULL) {
						ValaSourceReference* _tmp332_;
						ValaSourceReference* _tmp333_;
						gchar* _tmp334_;
						gchar* _tmp335_;
						gint _tmp336_;
						gchar* _tmp337_;
						gchar* _tmp338_;
						_tmp332_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp333_ = _tmp332_;
						_tmp334_ = vala_symbol_get_full_name ((ValaSymbol*) self);
						_tmp335_ = _tmp334_;
						_tmp336_ = i;
						_tmp337_ = g_strdup_printf ("%s: Gap in ordering in position %d", _tmp335_, _tmp336_);
						_tmp338_ = _tmp337_;
						vala_report_error (_tmp333_, _tmp338_);
						_g_free0 (_tmp338_);
						_g_free0 (_tmp335_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
					_tmp339_ = vala_code_node_get_error ((ValaCodeNode*) self);
					_tmp340_ = _tmp339_;
					if (!_tmp340_) {
						ValaList* _tmp341_;
						gint _tmp342_;
						ValaSymbol* _tmp343_;
						_tmp341_ = self->priv->virtuals;
						_tmp342_ = i;
						_tmp343_ = sym;
						vala_list_set (_tmp341_, _tmp342_, _tmp343_);
					}
					_vala_code_node_unref0 (sym);
				}
			}
		}
	}
	_tmp344_ = vala_code_context_get_analyzer (context);
	_tmp345_ = _tmp344_;
	_tmp346_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp345_, _tmp346_);
	_tmp347_ = vala_code_context_get_analyzer (context);
	_tmp348_ = _tmp347_;
	_tmp349_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp348_, _tmp349_);
	_tmp350_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp351_ = _tmp350_;
	result = !_tmp351_;
	_vala_map_unref0 (positions);
	_vala_code_node_unref0 (prereq_class);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


static void
vala_interface_class_init (ValaInterfaceClass * klass)
{
	vala_interface_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_interface_finalize;
	g_type_class_add_private (klass, sizeof (ValaInterfacePrivate));
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol *, ValaMethod*)) vala_interface_real_add_method;
	((ValaObjectTypeSymbolClass *) klass)->get_methods = (ValaList* (*) (ValaObjectTypeSymbol *)) vala_interface_real_get_methods;
	((ValaSymbolClass *) klass)->add_field = (void (*) (ValaSymbol *, ValaField*)) vala_interface_real_add_field;
	((ValaSymbolClass *) klass)->add_constant = (void (*) (ValaSymbol *, ValaConstant*)) vala_interface_real_add_constant;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol *, ValaProperty*)) vala_interface_real_add_property;
	((ValaObjectTypeSymbolClass *) klass)->get_properties = (ValaList* (*) (ValaObjectTypeSymbol *)) vala_interface_real_get_properties;
	((ValaSymbolClass *) klass)->add_signal = (void (*) (ValaSymbol *, ValaSignal*)) vala_interface_real_add_signal;
	((ValaObjectTypeSymbolClass *) klass)->get_signals = (ValaList* (*) (ValaObjectTypeSymbol *)) vala_interface_real_get_signals;
	((ValaInterfaceClass *) klass)->get_virtuals = (ValaList* (*) (ValaInterface *)) vala_interface_real_get_virtuals;
	((ValaSymbolClass *) klass)->add_class = (void (*) (ValaSymbol *, ValaClass*)) vala_interface_real_add_class;
	((ValaSymbolClass *) klass)->add_struct = (void (*) (ValaSymbol *, ValaStruct*)) vala_interface_real_add_struct;
	((ValaSymbolClass *) klass)->add_enum = (void (*) (ValaSymbol *, ValaEnum*)) vala_interface_real_add_enum;
	((ValaSymbolClass *) klass)->add_delegate = (void (*) (ValaSymbol *, ValaDelegate*)) vala_interface_real_add_delegate;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_interface_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_interface_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol *)) vala_interface_real_is_reference_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol *, ValaTypeSymbol*)) vala_interface_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode *, ValaDataType*, ValaDataType*)) vala_interface_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_interface_real_check;
}


static void
vala_interface_instance_init (ValaInterface * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	GEqualFunc _tmp4_;
	ValaArrayList* _tmp5_;
	GEqualFunc _tmp6_;
	ValaArrayList* _tmp7_;
	GEqualFunc _tmp8_;
	ValaArrayList* _tmp9_;
	GEqualFunc _tmp10_;
	ValaArrayList* _tmp11_;
	GEqualFunc _tmp12_;
	ValaArrayList* _tmp13_;
	GEqualFunc _tmp14_;
	ValaArrayList* _tmp15_;
	GEqualFunc _tmp16_;
	ValaArrayList* _tmp17_;
	GEqualFunc _tmp18_;
	ValaArrayList* _tmp19_;
	GEqualFunc _tmp20_;
	ValaArrayList* _tmp21_;
	self->priv = VALA_INTERFACE_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->prerequisites = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->methods = (ValaList*) _tmp3_;
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (VALA_TYPE_FIELD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
	self->priv->fields = (ValaList*) _tmp5_;
	_tmp6_ = g_direct_equal;
	_tmp7_ = vala_array_list_new (VALA_TYPE_CONSTANT, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp6_);
	self->priv->constants = (ValaList*) _tmp7_;
	_tmp8_ = g_direct_equal;
	_tmp9_ = vala_array_list_new (VALA_TYPE_PROPERTY, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp8_);
	self->priv->properties = (ValaList*) _tmp9_;
	_tmp10_ = g_direct_equal;
	_tmp11_ = vala_array_list_new (VALA_TYPE_SIGNAL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp10_);
	self->priv->signals = (ValaList*) _tmp11_;
	_tmp12_ = g_direct_equal;
	_tmp13_ = vala_array_list_new (VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp12_);
	self->priv->virtuals = (ValaList*) _tmp13_;
	_tmp14_ = g_direct_equal;
	_tmp15_ = vala_array_list_new (VALA_TYPE_CLASS, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp14_);
	self->priv->classes = (ValaList*) _tmp15_;
	_tmp16_ = g_direct_equal;
	_tmp17_ = vala_array_list_new (VALA_TYPE_STRUCT, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp16_);
	self->priv->structs = (ValaList*) _tmp17_;
	_tmp18_ = g_direct_equal;
	_tmp19_ = vala_array_list_new (VALA_TYPE_ENUM, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp18_);
	self->priv->enums = (ValaList*) _tmp19_;
	_tmp20_ = g_direct_equal;
	_tmp21_ = vala_array_list_new (VALA_TYPE_DELEGATE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp20_);
	self->priv->delegates = (ValaList*) _tmp21_;
}


static void
vala_interface_finalize (ValaCodeNode * obj)
{
	ValaInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_INTERFACE, ValaInterface);
	_vala_iterable_unref0 (self->priv->prerequisites);
	_vala_iterable_unref0 (self->priv->methods);
	_vala_iterable_unref0 (self->priv->fields);
	_vala_iterable_unref0 (self->priv->constants);
	_vala_iterable_unref0 (self->priv->properties);
	_vala_iterable_unref0 (self->priv->signals);
	_vala_iterable_unref0 (self->priv->virtuals);
	_vala_iterable_unref0 (self->priv->classes);
	_vala_iterable_unref0 (self->priv->structs);
	_vala_iterable_unref0 (self->priv->enums);
	_vala_iterable_unref0 (self->priv->delegates);
	VALA_CODE_NODE_CLASS (vala_interface_parent_class)->finalize (obj);
}


/**
 * Represents a class declaration in the source code.
 */
GType
vala_interface_get_type (void)
{
	static volatile gsize vala_interface_type_id__volatile = 0;
	if (g_once_init_enter (&vala_interface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInterface), 0, (GInstanceInitFunc) vala_interface_instance_init, NULL };
		GType vala_interface_type_id;
		vala_interface_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaInterface", &g_define_type_info, 0);
		g_once_init_leave (&vala_interface_type_id__volatile, vala_interface_type_id);
	}
	return vala_interface_type_id__volatile;
}



