/* valaassignment.c generated by valac, the Vala compiler
 * generated from valaassignment.vala, do not modify */

/* valaassignment.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaAssignmentPrivate {
	ValaAssignmentOperator _operator;
	ValaExpression* _left;
	ValaExpression* _right;
};


static gpointer vala_assignment_parent_class = NULL;

#define VALA_ASSIGNMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ASSIGNMENT, ValaAssignmentPrivate))
static void vala_assignment_real_accept (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor);
static void vala_assignment_real_accept_children (ValaCodeNode* base,
                                           ValaCodeVisitor* visitor);
static void vala_assignment_real_replace_expression (ValaCodeNode* base,
                                              ValaExpression* old_node,
                                              ValaExpression* new_node);
static gboolean vala_assignment_real_is_pure (ValaExpression* base);
static gboolean vala_assignment_real_is_accessible (ValaExpression* base,
                                             ValaSymbol* sym);
static gboolean vala_assignment_real_check (ValaCodeNode* base,
                                     ValaCodeContext* context);
static gboolean vala_assignment_is_array_add (ValaAssignment* self);
static void vala_assignment_real_emit (ValaCodeNode* base,
                                ValaCodeGenerator* codegen);
static void vala_assignment_real_get_defined_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static void vala_assignment_real_get_used_variables (ValaCodeNode* base,
                                              ValaCollection* collection);
static void vala_assignment_finalize (ValaCodeNode * obj);


/**
 * Creates a new assignment.
 *
 * @param left             left hand side
 * @param operator         assignment operator
 * @param right            right hand side
 * @param source_reference reference to source code
 * @return                 newly created assignment
 */
ValaAssignment*
vala_assignment_construct (GType object_type,
                           ValaExpression* left,
                           ValaExpression* right,
                           ValaAssignmentOperator operator,
                           ValaSourceReference* source_reference)
{
	ValaAssignment* self = NULL;
	g_return_val_if_fail (left != NULL, NULL);
	g_return_val_if_fail (right != NULL, NULL);
	self = (ValaAssignment*) vala_expression_construct (object_type);
	vala_assignment_set_right (self, right);
	vala_assignment_set_operator (self, operator);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_assignment_set_left (self, left);
	return self;
}


ValaAssignment*
vala_assignment_new (ValaExpression* left,
                     ValaExpression* right,
                     ValaAssignmentOperator operator,
                     ValaSourceReference* source_reference)
{
	return vala_assignment_construct (VALA_TYPE_ASSIGNMENT, left, right, operator, source_reference);
}


static void
vala_assignment_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor)
{
	ValaAssignment * self;
	self = (ValaAssignment*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_assignment (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void
vala_assignment_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
}


static void
vala_assignment_real_replace_expression (ValaCodeNode* base,
                                         ValaExpression* old_node,
                                         ValaExpression* new_node)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_assignment_set_left (self, new_node);
	}
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_node) {
		vala_assignment_set_right (self, new_node);
	}
}


static gboolean
vala_assignment_real_is_pure (ValaExpression* base)
{
	ValaAssignment * self;
	gboolean result = FALSE;
	self = (ValaAssignment*) base;
	result = FALSE;
	return result;
}


static gboolean
vala_assignment_real_is_accessible (ValaExpression* base,
                                    ValaSymbol* sym)
{
	ValaAssignment * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaAssignment*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_assignment_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_accessible (_tmp2_, sym)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_assignment_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_accessible (_tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_assignment_real_check (ValaCodeNode* base,
                            ValaCodeContext* context)
{
	ValaAssignment * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp95_;
	ValaExpression* _tmp96_;
	ValaExpression* _tmp97_;
	ValaExpression* _tmp98_;
	ValaExpression* _tmp99_;
	ValaExpression* _tmp100_;
	ValaExpression* _tmp305_;
	ValaExpression* _tmp306_;
	gboolean _tmp307_ = FALSE;
	ValaAssignmentOperator _tmp308_;
	ValaExpression* _tmp361_;
	ValaExpression* _tmp362_;
	ValaSymbol* _tmp363_;
	ValaSymbol* _tmp364_;
	ValaExpression* _tmp806_;
	ValaExpression* _tmp807_;
	ValaDataType* _tmp808_;
	ValaDataType* _tmp809_;
	ValaExpression* _tmp818_;
	ValaExpression* _tmp819_;
	ValaList* _tmp820_;
	ValaList* _tmp821_;
	ValaExpression* _tmp822_;
	ValaExpression* _tmp823_;
	ValaList* _tmp824_;
	ValaList* _tmp825_;
	gboolean _tmp826_;
	gboolean _tmp827_;
	self = (ValaAssignment*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp6_ = vala_assignment_get_left (self);
	_tmp7_ = _tmp6_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_TUPLE)) {
		ValaAssignmentOperator _tmp8_;
		_tmp8_ = self->priv->_operator;
		_tmp5_ = _tmp8_ == VALA_ASSIGNMENT_OPERATOR_SIMPLE;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaCodeNode* _tmp9_;
		ValaCodeNode* _tmp10_;
		_tmp9_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp10_ = _tmp9_;
		_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, VALA_TYPE_EXPRESSION_STATEMENT);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaTuple* tuple = NULL;
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		ValaTuple* _tmp13_;
		ValaLocalVariable* local = NULL;
		gchar* _tmp14_;
		gchar* _tmp15_;
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		ValaExpression* _tmp18_;
		ValaExpression* _tmp19_;
		ValaSourceReference* _tmp20_;
		ValaSourceReference* _tmp21_;
		ValaLocalVariable* _tmp22_;
		ValaLocalVariable* _tmp23_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp24_;
		ValaSourceReference* _tmp25_;
		ValaSourceReference* _tmp26_;
		ValaDeclarationStatement* _tmp27_;
		ValaDeclarationStatement* _tmp28_;
		ValaSemanticAnalyzer* _tmp29_;
		ValaSemanticAnalyzer* _tmp30_;
		ValaBlock* _tmp31_;
		ValaDeclarationStatement* _tmp32_;
		gint i = 0;
		ValaExpressionStatement* stmt = NULL;
		ValaSemanticAnalyzer* _tmp85_;
		ValaSemanticAnalyzer* _tmp86_;
		ValaCodeNode* _tmp87_;
		ValaCodeNode* _tmp88_;
		ValaExpressionStatement* _tmp89_;
		ValaExpression* _tmp90_;
		ValaExpression* _tmp91_;
		ValaExpressionStatement* _tmp92_;
		ValaExpression* _tmp93_;
		ValaExpression* _tmp94_;
		_tmp11_ = vala_assignment_get_left (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_TUPLE, ValaTuple));
		tuple = _tmp13_;
		_tmp14_ = vala_code_node_get_temp_name ();
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_assignment_get_right (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_assignment_get_right (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_local_variable_new (NULL, _tmp15_, _tmp17_, _tmp21_);
		_tmp23_ = _tmp22_;
		_g_free0 (_tmp15_);
		local = _tmp23_;
		_tmp24_ = local;
		_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_declaration_statement_new ((ValaSymbol*) _tmp24_, _tmp26_);
		decl = _tmp27_;
		_tmp28_ = decl;
		vala_code_node_check ((ValaCodeNode*) _tmp28_, context);
		_tmp29_ = vala_code_context_get_analyzer (context);
		_tmp30_ = _tmp29_;
		_tmp31_ = _tmp30_->insert_block;
		_tmp32_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp31_, (ValaStatement*) _tmp32_);
		i = 0;
		stmt = NULL;
		{
			ValaList* _expr_list = NULL;
			ValaTuple* _tmp33_;
			ValaList* _tmp34_;
			gint _expr_size = 0;
			ValaList* _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			gint _expr_index = 0;
			_tmp33_ = tuple;
			_tmp34_ = vala_tuple_get_expressions (_tmp33_);
			_expr_list = _tmp34_;
			_tmp35_ = _expr_list;
			_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
			_tmp37_ = _tmp36_;
			_expr_size = _tmp37_;
			_expr_index = -1;
			while (TRUE) {
				gint _tmp38_;
				gint _tmp39_;
				gint _tmp40_;
				ValaExpression* expr = NULL;
				ValaList* _tmp41_;
				gint _tmp42_;
				gpointer _tmp43_;
				ValaExpressionStatement* _tmp44_;
				ValaMemberAccess* temp_access = NULL;
				ValaLocalVariable* _tmp50_;
				const gchar* _tmp51_;
				const gchar* _tmp52_;
				ValaExpression* _tmp53_;
				ValaExpression* _tmp54_;
				ValaSourceReference* _tmp55_;
				ValaSourceReference* _tmp56_;
				ValaMemberAccess* _tmp57_;
				ValaElementAccess* ea = NULL;
				ValaMemberAccess* _tmp58_;
				ValaExpression* _tmp59_;
				ValaSourceReference* _tmp60_;
				ValaSourceReference* _tmp61_;
				ValaElementAccess* _tmp62_;
				ValaElementAccess* _tmp63_;
				gint _tmp64_;
				gchar* _tmp65_;
				gchar* _tmp66_;
				ValaExpression* _tmp67_;
				ValaSourceReference* _tmp68_;
				ValaSourceReference* _tmp69_;
				ValaIntegerLiteral* _tmp70_;
				ValaIntegerLiteral* _tmp71_;
				ValaAssignment* assign = NULL;
				ValaExpression* _tmp72_;
				ValaElementAccess* _tmp73_;
				ValaAssignmentOperator _tmp74_;
				ValaExpression* _tmp75_;
				ValaSourceReference* _tmp76_;
				ValaSourceReference* _tmp77_;
				ValaAssignment* _tmp78_;
				ValaAssignment* _tmp79_;
				ValaExpression* _tmp80_;
				ValaSourceReference* _tmp81_;
				ValaSourceReference* _tmp82_;
				ValaExpressionStatement* _tmp83_;
				gint _tmp84_;
				_tmp38_ = _expr_index;
				_expr_index = _tmp38_ + 1;
				_tmp39_ = _expr_index;
				_tmp40_ = _expr_size;
				if (!(_tmp39_ < _tmp40_)) {
					break;
				}
				_tmp41_ = _expr_list;
				_tmp42_ = _expr_index;
				_tmp43_ = vala_list_get (_tmp41_, _tmp42_);
				expr = (ValaExpression*) _tmp43_;
				_tmp44_ = stmt;
				if (_tmp44_ != NULL) {
					ValaExpressionStatement* _tmp45_;
					ValaSemanticAnalyzer* _tmp46_;
					ValaSemanticAnalyzer* _tmp47_;
					ValaBlock* _tmp48_;
					ValaExpressionStatement* _tmp49_;
					_tmp45_ = stmt;
					vala_code_node_check ((ValaCodeNode*) _tmp45_, context);
					_tmp46_ = vala_code_context_get_analyzer (context);
					_tmp47_ = _tmp46_;
					_tmp48_ = _tmp47_->insert_block;
					_tmp49_ = stmt;
					vala_expression_insert_statement ((ValaExpression*) self, _tmp48_, (ValaStatement*) _tmp49_);
				}
				_tmp50_ = local;
				_tmp51_ = vala_symbol_get_name ((ValaSymbol*) _tmp50_);
				_tmp52_ = _tmp51_;
				_tmp53_ = vala_assignment_get_right (self);
				_tmp54_ = _tmp53_;
				_tmp55_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp54_);
				_tmp56_ = _tmp55_;
				_tmp57_ = vala_member_access_new_simple (_tmp52_, _tmp56_);
				temp_access = _tmp57_;
				_tmp58_ = temp_access;
				_tmp59_ = expr;
				_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp59_);
				_tmp61_ = _tmp60_;
				_tmp62_ = vala_element_access_new ((ValaExpression*) _tmp58_, _tmp61_);
				ea = _tmp62_;
				_tmp63_ = ea;
				_tmp64_ = i;
				_tmp65_ = g_strdup_printf ("%i", _tmp64_);
				_tmp66_ = _tmp65_;
				_tmp67_ = expr;
				_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp67_);
				_tmp69_ = _tmp68_;
				_tmp70_ = vala_integer_literal_new (_tmp66_, _tmp69_);
				_tmp71_ = _tmp70_;
				vala_element_access_append_index (_tmp63_, (ValaExpression*) _tmp71_);
				_vala_code_node_unref0 (_tmp71_);
				_g_free0 (_tmp66_);
				_tmp72_ = expr;
				_tmp73_ = ea;
				_tmp74_ = self->priv->_operator;
				_tmp75_ = expr;
				_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = vala_assignment_new (_tmp72_, (ValaExpression*) _tmp73_, _tmp74_, _tmp77_);
				assign = _tmp78_;
				_tmp79_ = assign;
				_tmp80_ = expr;
				_tmp81_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp80_);
				_tmp82_ = _tmp81_;
				_tmp83_ = vala_expression_statement_new ((ValaExpression*) _tmp79_, _tmp82_);
				_vala_code_node_unref0 (stmt);
				stmt = _tmp83_;
				_tmp84_ = i;
				i = _tmp84_ + 1;
				_vala_code_node_unref0 (assign);
				_vala_code_node_unref0 (ea);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (expr);
			}
			_vala_iterable_unref0 (_expr_list);
		}
		_tmp85_ = vala_code_context_get_analyzer (context);
		_tmp86_ = _tmp85_;
		vala_semantic_analyzer_add_replaced_node (_tmp86_, (ValaCodeNode*) self);
		_tmp87_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp88_ = _tmp87_;
		_tmp89_ = stmt;
		_tmp90_ = vala_expression_statement_get_expression (_tmp89_);
		_tmp91_ = _tmp90_;
		vala_code_node_replace_expression (_tmp88_, (ValaExpression*) self, _tmp91_);
		_tmp92_ = stmt;
		_tmp93_ = vala_expression_statement_get_expression (_tmp92_);
		_tmp94_ = _tmp93_;
		result = vala_code_node_check ((ValaCodeNode*) _tmp94_, context);
		_vala_code_node_unref0 (stmt);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		_vala_code_node_unref0 (tuple);
		return result;
	}
	_tmp95_ = vala_assignment_get_left (self);
	_tmp96_ = _tmp95_;
	vala_expression_set_lvalue (_tmp96_, TRUE);
	_tmp97_ = vala_assignment_get_left (self);
	_tmp98_ = _tmp97_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp98_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp99_ = vala_assignment_get_left (self);
	_tmp100_ = _tmp99_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp100_, VALA_TYPE_MEMBER_ACCESS)) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp101_;
		ValaExpression* _tmp102_;
		ValaMemberAccess* _tmp103_;
		ValaMemberAccess* _tmp104_;
		ValaSymbol* _tmp105_;
		ValaSymbol* _tmp106_;
		gboolean _tmp109_ = FALSE;
		gboolean _tmp110_ = FALSE;
		gboolean _tmp111_ = FALSE;
		ValaMemberAccess* _tmp112_;
		ValaSymbol* _tmp113_;
		ValaSymbol* _tmp114_;
		ValaMemberAccess* _tmp133_;
		gboolean _tmp134_;
		gboolean _tmp135_;
		gboolean _tmp145_ = FALSE;
		ValaMemberAccess* _tmp146_;
		gboolean _tmp147_;
		gboolean _tmp148_;
		ValaMemberAccess* _tmp152_;
		ValaSymbol* _tmp153_;
		ValaSymbol* _tmp154_;
		_tmp101_ = vala_assignment_get_left (self);
		_tmp102_ = _tmp101_;
		_tmp103_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		ma = _tmp103_;
		_tmp104_ = ma;
		_tmp105_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp104_);
		_tmp106_ = _tmp105_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp106_, VALA_TYPE_CONSTANT)) {
			ValaSourceReference* _tmp107_;
			ValaSourceReference* _tmp108_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp107_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp108_ = _tmp107_;
			vala_report_error (_tmp108_, "Assignment to constant after initialization");
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp112_ = ma;
		_tmp113_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp112_);
		_tmp114_ = _tmp113_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp114_, VALA_TYPE_SIGNAL)) {
			_tmp111_ = TRUE;
		} else {
			ValaMemberAccess* _tmp115_;
			ValaSymbol* _tmp116_;
			ValaSymbol* _tmp117_;
			_tmp115_ = ma;
			_tmp116_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp115_);
			_tmp117_ = _tmp116_;
			_tmp111_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp117_, VALA_TYPE_DYNAMIC_PROPERTY);
		}
		if (!_tmp111_) {
			ValaMemberAccess* _tmp118_;
			ValaDataType* _tmp119_;
			ValaDataType* _tmp120_;
			_tmp118_ = ma;
			_tmp119_ = vala_expression_get_value_type ((ValaExpression*) _tmp118_);
			_tmp120_ = _tmp119_;
			_tmp110_ = _tmp120_ == NULL;
		} else {
			_tmp110_ = FALSE;
		}
		if (_tmp110_) {
			_tmp109_ = TRUE;
		} else {
			gboolean _tmp121_ = FALSE;
			gboolean _tmp122_ = FALSE;
			ValaMemberAccess* _tmp123_;
			ValaExpression* _tmp124_;
			ValaExpression* _tmp125_;
			_tmp123_ = ma;
			_tmp124_ = vala_member_access_get_inner (_tmp123_);
			_tmp125_ = _tmp124_;
			if (_tmp125_ == NULL) {
				ValaMemberAccess* _tmp126_;
				const gchar* _tmp127_;
				const gchar* _tmp128_;
				_tmp126_ = ma;
				_tmp127_ = vala_member_access_get_member_name (_tmp126_);
				_tmp128_ = _tmp127_;
				_tmp122_ = g_strcmp0 (_tmp128_, "this") == 0;
			} else {
				_tmp122_ = FALSE;
			}
			if (_tmp122_) {
				ValaSemanticAnalyzer* _tmp129_;
				ValaSemanticAnalyzer* _tmp130_;
				_tmp129_ = vala_code_context_get_analyzer (context);
				_tmp130_ = _tmp129_;
				_tmp121_ = vala_semantic_analyzer_is_in_instance_method (_tmp130_);
			} else {
				_tmp121_ = FALSE;
			}
			_tmp109_ = _tmp121_;
		}
		if (_tmp109_) {
			ValaSourceReference* _tmp131_;
			ValaSourceReference* _tmp132_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp131_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp132_ = _tmp131_;
			vala_report_error (_tmp132_, "unsupported lvalue in assignment");
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp133_ = ma;
		_tmp134_ = vala_member_access_get_prototype_access (_tmp133_);
		_tmp135_ = _tmp134_;
		if (_tmp135_) {
			ValaSourceReference* _tmp136_;
			ValaSourceReference* _tmp137_;
			ValaMemberAccess* _tmp138_;
			ValaSymbol* _tmp139_;
			ValaSymbol* _tmp140_;
			gchar* _tmp141_;
			gchar* _tmp142_;
			gchar* _tmp143_;
			gchar* _tmp144_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp136_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp137_ = _tmp136_;
			_tmp138_ = ma;
			_tmp139_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp138_);
			_tmp140_ = _tmp139_;
			_tmp141_ = vala_symbol_get_full_name (_tmp140_);
			_tmp142_ = _tmp141_;
			_tmp143_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp142_);
			_tmp144_ = _tmp143_;
			vala_report_error (_tmp137_, _tmp144_);
			_g_free0 (_tmp144_);
			_g_free0 (_tmp142_);
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp146_ = ma;
		_tmp147_ = vala_code_node_get_error ((ValaCodeNode*) _tmp146_);
		_tmp148_ = _tmp147_;
		if (_tmp148_) {
			_tmp145_ = TRUE;
		} else {
			ValaMemberAccess* _tmp149_;
			ValaSymbol* _tmp150_;
			ValaSymbol* _tmp151_;
			_tmp149_ = ma;
			_tmp150_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp149_);
			_tmp151_ = _tmp150_;
			_tmp145_ = _tmp151_ == NULL;
		}
		if (_tmp145_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp152_ = ma;
		_tmp153_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp152_);
		_tmp154_ = _tmp153_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp154_, VALA_TYPE_DYNAMIC_SIGNAL)) {
			gboolean _tmp155_;
			gboolean _tmp156_;
			_tmp155_ = vala_code_context_get_deprecated (context);
			_tmp156_ = _tmp155_;
			if (!_tmp156_) {
				ValaSourceReference* _tmp157_;
				ValaSourceReference* _tmp158_;
				_tmp157_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp158_ = _tmp157_;
				vala_report_warning (_tmp158_, "deprecated syntax, use `connect' method instead");
			}
		} else {
			ValaMemberAccess* _tmp159_;
			ValaSymbol* _tmp160_;
			ValaSymbol* _tmp161_;
			_tmp159_ = ma;
			_tmp160_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp159_);
			_tmp161_ = _tmp160_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp161_, VALA_TYPE_SIGNAL)) {
				gboolean _tmp162_;
				gboolean _tmp163_;
				ValaSignal* sig = NULL;
				ValaMemberAccess* _tmp166_;
				ValaSymbol* _tmp167_;
				ValaSymbol* _tmp168_;
				ValaSignal* _tmp169_;
				ValaExpression* _tmp170_;
				ValaExpression* _tmp171_;
				ValaSignal* _tmp172_;
				ValaMemberAccess* _tmp173_;
				ValaExpression* _tmp174_;
				ValaExpression* _tmp175_;
				ValaDataType* _tmp176_;
				ValaDataType* _tmp177_;
				ValaDelegate* _tmp178_;
				ValaDelegate* _tmp179_;
				ValaDelegateType* _tmp180_;
				ValaDelegateType* _tmp181_;
				_tmp162_ = vala_code_context_get_deprecated (context);
				_tmp163_ = _tmp162_;
				if (!_tmp163_) {
					ValaSourceReference* _tmp164_;
					ValaSourceReference* _tmp165_;
					_tmp164_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp165_ = _tmp164_;
					vala_report_warning (_tmp165_, "deprecated syntax, use `connect' method instead");
				}
				_tmp166_ = ma;
				_tmp167_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp166_);
				_tmp168_ = _tmp167_;
				_tmp169_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp168_, VALA_TYPE_SIGNAL, ValaSignal));
				sig = _tmp169_;
				_tmp170_ = vala_assignment_get_right (self);
				_tmp171_ = _tmp170_;
				_tmp172_ = sig;
				_tmp173_ = ma;
				_tmp174_ = vala_member_access_get_inner (_tmp173_);
				_tmp175_ = _tmp174_;
				_tmp176_ = vala_expression_get_value_type (_tmp175_);
				_tmp177_ = _tmp176_;
				_tmp178_ = vala_signal_get_delegate (_tmp172_, _tmp177_, (ValaCodeNode*) self);
				_tmp179_ = _tmp178_;
				_tmp180_ = vala_delegate_type_new (_tmp179_);
				_tmp181_ = _tmp180_;
				vala_expression_set_target_type (_tmp171_, (ValaDataType*) _tmp181_);
				_vala_code_node_unref0 (_tmp181_);
				_vala_code_node_unref0 (_tmp179_);
				_vala_code_node_unref0 (sig);
			} else {
				ValaMemberAccess* _tmp182_;
				ValaSymbol* _tmp183_;
				ValaSymbol* _tmp184_;
				_tmp182_ = ma;
				_tmp183_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp182_);
				_tmp184_ = _tmp183_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp184_, VALA_TYPE_DYNAMIC_PROPERTY)) {
				} else {
					ValaExpression* _tmp185_;
					ValaExpression* _tmp186_;
					ValaMemberAccess* _tmp187_;
					ValaDataType* _tmp188_;
					ValaDataType* _tmp189_;
					ValaDataType* _tmp190_;
					ValaDataType* _tmp191_;
					ValaExpression* _tmp192_;
					ValaExpression* _tmp193_;
					ValaMemberAccess* _tmp194_;
					ValaDataType* _tmp195_;
					ValaDataType* _tmp196_;
					ValaDataType* _tmp197_;
					ValaDataType* _tmp198_;
					_tmp185_ = vala_assignment_get_right (self);
					_tmp186_ = _tmp185_;
					_tmp187_ = ma;
					_tmp188_ = vala_expression_get_formal_value_type ((ValaExpression*) _tmp187_);
					_tmp189_ = _tmp188_;
					_tmp190_ = vala_data_type_copy (_tmp189_);
					_tmp191_ = _tmp190_;
					vala_expression_set_formal_target_type (_tmp186_, _tmp191_);
					_vala_code_node_unref0 (_tmp191_);
					_tmp192_ = vala_assignment_get_right (self);
					_tmp193_ = _tmp192_;
					_tmp194_ = ma;
					_tmp195_ = vala_expression_get_value_type ((ValaExpression*) _tmp194_);
					_tmp196_ = _tmp195_;
					_tmp197_ = vala_data_type_copy (_tmp196_);
					_tmp198_ = _tmp197_;
					vala_expression_set_target_type (_tmp193_, _tmp198_);
					_vala_code_node_unref0 (_tmp198_);
				}
			}
		}
		_vala_code_node_unref0 (ma);
	} else {
		ValaExpression* _tmp199_;
		ValaExpression* _tmp200_;
		_tmp199_ = vala_assignment_get_left (self);
		_tmp200_ = _tmp199_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp200_, VALA_TYPE_ELEMENT_ACCESS)) {
			ValaElementAccess* ea = NULL;
			ValaExpression* _tmp201_;
			ValaExpression* _tmp202_;
			ValaElementAccess* _tmp203_;
			ValaElementAccess* _tmp204_;
			ValaExpression* _tmp205_;
			ValaExpression* _tmp206_;
			ValaDataType* _tmp207_;
			ValaDataType* _tmp208_;
			ValaTypeSymbol* _tmp209_;
			ValaTypeSymbol* _tmp210_;
			ValaSemanticAnalyzer* _tmp211_;
			ValaSemanticAnalyzer* _tmp212_;
			ValaDataType* _tmp213_;
			ValaTypeSymbol* _tmp214_;
			ValaTypeSymbol* _tmp215_;
			_tmp201_ = vala_assignment_get_left (self);
			_tmp202_ = _tmp201_;
			_tmp203_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp202_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
			ea = _tmp203_;
			_tmp204_ = ea;
			_tmp205_ = vala_element_access_get_container (_tmp204_);
			_tmp206_ = _tmp205_;
			_tmp207_ = vala_expression_get_value_type (_tmp206_);
			_tmp208_ = _tmp207_;
			_tmp209_ = vala_data_type_get_data_type (_tmp208_);
			_tmp210_ = _tmp209_;
			_tmp211_ = vala_code_context_get_analyzer (context);
			_tmp212_ = _tmp211_;
			_tmp213_ = _tmp212_->string_type;
			_tmp214_ = vala_data_type_get_data_type (_tmp213_);
			_tmp215_ = _tmp214_;
			if (_tmp210_ == _tmp215_) {
				ValaElementAccess* _tmp216_;
				ValaSourceReference* _tmp217_;
				ValaSourceReference* _tmp218_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp216_ = ea;
				_tmp217_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp216_);
				_tmp218_ = _tmp217_;
				vala_report_error (_tmp218_, "strings are immutable");
				result = FALSE;
				_vala_code_node_unref0 (ea);
				return result;
			} else {
				gboolean _tmp219_ = FALSE;
				ValaElementAccess* _tmp220_;
				ValaExpression* _tmp221_;
				ValaExpression* _tmp222_;
				_tmp220_ = ea;
				_tmp221_ = vala_element_access_get_container (_tmp220_);
				_tmp222_ = _tmp221_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp222_, VALA_TYPE_MEMBER_ACCESS)) {
					ValaElementAccess* _tmp223_;
					ValaExpression* _tmp224_;
					ValaExpression* _tmp225_;
					ValaSymbol* _tmp226_;
					ValaSymbol* _tmp227_;
					_tmp223_ = ea;
					_tmp224_ = vala_element_access_get_container (_tmp223_);
					_tmp225_ = _tmp224_;
					_tmp226_ = vala_expression_get_symbol_reference (_tmp225_);
					_tmp227_ = _tmp226_;
					_tmp219_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp227_, VALA_TYPE_SIGNAL);
				} else {
					_tmp219_ = FALSE;
				}
				if (_tmp219_) {
					ValaMemberAccess* ma = NULL;
					ValaElementAccess* _tmp228_;
					ValaExpression* _tmp229_;
					ValaExpression* _tmp230_;
					ValaMemberAccess* _tmp231_;
					ValaSignal* sig = NULL;
					ValaElementAccess* _tmp232_;
					ValaExpression* _tmp233_;
					ValaExpression* _tmp234_;
					ValaSymbol* _tmp235_;
					ValaSymbol* _tmp236_;
					ValaSignal* _tmp237_;
					ValaExpression* _tmp238_;
					ValaExpression* _tmp239_;
					ValaSignal* _tmp240_;
					ValaMemberAccess* _tmp241_;
					ValaExpression* _tmp242_;
					ValaExpression* _tmp243_;
					ValaDataType* _tmp244_;
					ValaDataType* _tmp245_;
					ValaDelegate* _tmp246_;
					ValaDelegate* _tmp247_;
					ValaDelegateType* _tmp248_;
					ValaDelegateType* _tmp249_;
					_tmp228_ = ea;
					_tmp229_ = vala_element_access_get_container (_tmp228_);
					_tmp230_ = _tmp229_;
					_tmp231_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp230_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
					ma = _tmp231_;
					_tmp232_ = ea;
					_tmp233_ = vala_element_access_get_container (_tmp232_);
					_tmp234_ = _tmp233_;
					_tmp235_ = vala_expression_get_symbol_reference (_tmp234_);
					_tmp236_ = _tmp235_;
					_tmp237_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp236_, VALA_TYPE_SIGNAL, ValaSignal));
					sig = _tmp237_;
					_tmp238_ = vala_assignment_get_right (self);
					_tmp239_ = _tmp238_;
					_tmp240_ = sig;
					_tmp241_ = ma;
					_tmp242_ = vala_member_access_get_inner (_tmp241_);
					_tmp243_ = _tmp242_;
					_tmp244_ = vala_expression_get_value_type (_tmp243_);
					_tmp245_ = _tmp244_;
					_tmp246_ = vala_signal_get_delegate (_tmp240_, _tmp245_, (ValaCodeNode*) self);
					_tmp247_ = _tmp246_;
					_tmp248_ = vala_delegate_type_new (_tmp247_);
					_tmp249_ = _tmp248_;
					vala_expression_set_target_type (_tmp239_, (ValaDataType*) _tmp249_);
					_vala_code_node_unref0 (_tmp249_);
					_vala_code_node_unref0 (_tmp247_);
					_vala_code_node_unref0 (sig);
					_vala_code_node_unref0 (ma);
				} else {
					ValaElementAccess* _tmp250_;
					ValaExpression* _tmp251_;
					ValaExpression* _tmp252_;
					ValaDataType* _tmp253_;
					ValaDataType* _tmp254_;
					ValaSymbol* _tmp255_;
					ValaSymbol* _tmp256_;
					gboolean _tmp257_;
					_tmp250_ = ea;
					_tmp251_ = vala_element_access_get_container (_tmp250_);
					_tmp252_ = _tmp251_;
					_tmp253_ = vala_expression_get_value_type (_tmp252_);
					_tmp254_ = _tmp253_;
					_tmp255_ = vala_data_type_get_member (_tmp254_, "set");
					_tmp256_ = _tmp255_;
					_tmp257_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp256_, VALA_TYPE_METHOD);
					_vala_code_node_unref0 (_tmp256_);
					if (_tmp257_) {
						ValaMethodCall* set_call = NULL;
						ValaElementAccess* _tmp258_;
						ValaExpression* _tmp259_;
						ValaExpression* _tmp260_;
						ValaSourceReference* _tmp261_;
						ValaSourceReference* _tmp262_;
						ValaMemberAccess* _tmp263_;
						ValaMemberAccess* _tmp264_;
						ValaSourceReference* _tmp265_;
						ValaSourceReference* _tmp266_;
						ValaMethodCall* _tmp267_;
						ValaMethodCall* _tmp268_;
						ValaMethodCall* _tmp282_;
						ValaExpression* _tmp283_;
						ValaExpression* _tmp284_;
						ValaCodeNode* _tmp285_;
						ValaCodeNode* _tmp286_;
						ValaMethodCall* _tmp287_;
						ValaMethodCall* _tmp288_;
						_tmp258_ = ea;
						_tmp259_ = vala_element_access_get_container (_tmp258_);
						_tmp260_ = _tmp259_;
						_tmp261_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp262_ = _tmp261_;
						_tmp263_ = vala_member_access_new (_tmp260_, "set", _tmp262_);
						_tmp264_ = _tmp263_;
						_tmp265_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp266_ = _tmp265_;
						_tmp267_ = vala_method_call_new ((ValaExpression*) _tmp264_, _tmp266_);
						_tmp268_ = _tmp267_;
						_vala_code_node_unref0 (_tmp264_);
						set_call = _tmp268_;
						{
							ValaList* _e_list = NULL;
							ValaElementAccess* _tmp269_;
							ValaList* _tmp270_;
							gint _e_size = 0;
							ValaList* _tmp271_;
							gint _tmp272_;
							gint _tmp273_;
							gint _e_index = 0;
							_tmp269_ = ea;
							_tmp270_ = vala_element_access_get_indices (_tmp269_);
							_e_list = _tmp270_;
							_tmp271_ = _e_list;
							_tmp272_ = vala_collection_get_size ((ValaCollection*) _tmp271_);
							_tmp273_ = _tmp272_;
							_e_size = _tmp273_;
							_e_index = -1;
							while (TRUE) {
								gint _tmp274_;
								gint _tmp275_;
								gint _tmp276_;
								ValaExpression* e = NULL;
								ValaList* _tmp277_;
								gint _tmp278_;
								gpointer _tmp279_;
								ValaMethodCall* _tmp280_;
								ValaExpression* _tmp281_;
								_tmp274_ = _e_index;
								_e_index = _tmp274_ + 1;
								_tmp275_ = _e_index;
								_tmp276_ = _e_size;
								if (!(_tmp275_ < _tmp276_)) {
									break;
								}
								_tmp277_ = _e_list;
								_tmp278_ = _e_index;
								_tmp279_ = vala_list_get (_tmp277_, _tmp278_);
								e = (ValaExpression*) _tmp279_;
								_tmp280_ = set_call;
								_tmp281_ = e;
								vala_method_call_add_argument (_tmp280_, _tmp281_);
								_vala_code_node_unref0 (e);
							}
							_vala_iterable_unref0 (_e_list);
						}
						_tmp282_ = set_call;
						_tmp283_ = vala_assignment_get_right (self);
						_tmp284_ = _tmp283_;
						vala_method_call_add_argument (_tmp282_, _tmp284_);
						_tmp285_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp286_ = _tmp285_;
						_tmp287_ = set_call;
						vala_code_node_replace_expression (_tmp286_, (ValaExpression*) self, (ValaExpression*) _tmp287_);
						_tmp288_ = set_call;
						result = vala_code_node_check ((ValaCodeNode*) _tmp288_, context);
						_vala_code_node_unref0 (set_call);
						_vala_code_node_unref0 (ea);
						return result;
					} else {
						ValaExpression* _tmp289_;
						ValaExpression* _tmp290_;
						ValaExpression* _tmp291_;
						ValaExpression* _tmp292_;
						ValaDataType* _tmp293_;
						ValaDataType* _tmp294_;
						_tmp289_ = vala_assignment_get_right (self);
						_tmp290_ = _tmp289_;
						_tmp291_ = vala_assignment_get_left (self);
						_tmp292_ = _tmp291_;
						_tmp293_ = vala_expression_get_value_type (_tmp292_);
						_tmp294_ = _tmp293_;
						vala_expression_set_target_type (_tmp290_, _tmp294_);
					}
				}
			}
			_vala_code_node_unref0 (ea);
		} else {
			ValaExpression* _tmp295_;
			ValaExpression* _tmp296_;
			_tmp295_ = vala_assignment_get_left (self);
			_tmp296_ = _tmp295_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp296_, VALA_TYPE_POINTER_INDIRECTION)) {
				ValaExpression* _tmp297_;
				ValaExpression* _tmp298_;
				ValaExpression* _tmp299_;
				ValaExpression* _tmp300_;
				ValaDataType* _tmp301_;
				ValaDataType* _tmp302_;
				_tmp297_ = vala_assignment_get_right (self);
				_tmp298_ = _tmp297_;
				_tmp299_ = vala_assignment_get_left (self);
				_tmp300_ = _tmp299_;
				_tmp301_ = vala_expression_get_value_type (_tmp300_);
				_tmp302_ = _tmp301_;
				vala_expression_set_target_type (_tmp298_, _tmp302_);
			} else {
				ValaSourceReference* _tmp303_;
				ValaSourceReference* _tmp304_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp303_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp304_ = _tmp303_;
				vala_report_error (_tmp304_, "unsupported lvalue in assignment");
				result = FALSE;
				return result;
			}
		}
	}
	_tmp305_ = vala_assignment_get_right (self);
	_tmp306_ = _tmp305_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp306_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp308_ = self->priv->_operator;
	if (_tmp308_ != VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
		ValaExpression* _tmp309_;
		ValaExpression* _tmp310_;
		_tmp309_ = vala_assignment_get_left (self);
		_tmp310_ = _tmp309_;
		_tmp307_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp310_, VALA_TYPE_MEMBER_ACCESS);
	} else {
		_tmp307_ = FALSE;
	}
	if (_tmp307_) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp311_;
		ValaExpression* _tmp312_;
		ValaMemberAccess* _tmp313_;
		ValaMemberAccess* _tmp314_;
		ValaSymbol* _tmp315_;
		ValaSymbol* _tmp316_;
		_tmp311_ = vala_assignment_get_left (self);
		_tmp312_ = _tmp311_;
		_tmp313_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp312_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		ma = _tmp313_;
		_tmp314_ = ma;
		_tmp315_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp314_);
		_tmp316_ = _tmp315_;
		if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp316_, VALA_TYPE_SIGNAL)) {
			ValaMemberAccess* old_value = NULL;
			ValaMemberAccess* _tmp317_;
			ValaExpression* _tmp318_;
			ValaExpression* _tmp319_;
			ValaMemberAccess* _tmp320_;
			const gchar* _tmp321_;
			const gchar* _tmp322_;
			ValaMemberAccess* _tmp323_;
			ValaBinaryExpression* bin = NULL;
			ValaMemberAccess* _tmp324_;
			ValaExpression* _tmp325_;
			ValaExpression* _tmp326_;
			ValaSourceReference* _tmp327_;
			ValaSourceReference* _tmp328_;
			ValaBinaryExpression* _tmp329_;
			ValaBinaryExpression* _tmp330_;
			ValaExpression* _tmp331_;
			ValaExpression* _tmp332_;
			ValaDataType* _tmp333_;
			ValaDataType* _tmp334_;
			ValaExpression* _tmp335_;
			ValaExpression* _tmp336_;
			ValaExpression* _tmp337_;
			ValaExpression* _tmp338_;
			ValaDataType* _tmp339_;
			ValaDataType* _tmp340_;
			ValaDataType* _tmp341_;
			ValaDataType* _tmp342_;
			ValaExpression* _tmp343_;
			ValaExpression* _tmp344_;
			ValaDataType* _tmp345_;
			ValaDataType* _tmp346_;
			ValaAssignmentOperator _tmp347_;
			ValaBinaryExpression* _tmp358_;
			ValaExpression* _tmp359_;
			ValaExpression* _tmp360_;
			_tmp317_ = ma;
			_tmp318_ = vala_member_access_get_inner (_tmp317_);
			_tmp319_ = _tmp318_;
			_tmp320_ = ma;
			_tmp321_ = vala_member_access_get_member_name (_tmp320_);
			_tmp322_ = _tmp321_;
			_tmp323_ = vala_member_access_new (_tmp319_, _tmp322_, NULL);
			old_value = _tmp323_;
			_tmp324_ = old_value;
			_tmp325_ = vala_assignment_get_right (self);
			_tmp326_ = _tmp325_;
			_tmp327_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp328_ = _tmp327_;
			_tmp329_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_PLUS, (ValaExpression*) _tmp324_, _tmp326_, _tmp328_);
			bin = _tmp329_;
			_tmp330_ = bin;
			_tmp331_ = vala_assignment_get_right (self);
			_tmp332_ = _tmp331_;
			_tmp333_ = vala_expression_get_target_type (_tmp332_);
			_tmp334_ = _tmp333_;
			vala_expression_set_target_type ((ValaExpression*) _tmp330_, _tmp334_);
			_tmp335_ = vala_assignment_get_right (self);
			_tmp336_ = _tmp335_;
			_tmp337_ = vala_assignment_get_right (self);
			_tmp338_ = _tmp337_;
			_tmp339_ = vala_expression_get_target_type (_tmp338_);
			_tmp340_ = _tmp339_;
			_tmp341_ = vala_data_type_copy (_tmp340_);
			_tmp342_ = _tmp341_;
			vala_expression_set_target_type (_tmp336_, _tmp342_);
			_vala_code_node_unref0 (_tmp342_);
			_tmp343_ = vala_assignment_get_right (self);
			_tmp344_ = _tmp343_;
			_tmp345_ = vala_expression_get_target_type (_tmp344_);
			_tmp346_ = _tmp345_;
			vala_data_type_set_value_owned (_tmp346_, FALSE);
			_tmp347_ = self->priv->_operator;
			switch (_tmp347_) {
				case VALA_ASSIGNMENT_OPERATOR_BITWISE_OR:
				{
					ValaBinaryExpression* _tmp348_;
					_tmp348_ = bin;
					vala_binary_expression_set_operator (_tmp348_, VALA_BINARY_OPERATOR_BITWISE_OR);
					break;
				}
				case VALA_ASSIGNMENT_OPERATOR_BITWISE_AND:
				{
					ValaBinaryExpression* _tmp349_;
					_tmp349_ = bin;
					vala_binary_expression_set_operator (_tmp349_, VALA_BINARY_OPERATOR_BITWISE_AND);
					break;
				}
				case VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR:
				{
					ValaBinaryExpression* _tmp350_;
					_tmp350_ = bin;
					vala_binary_expression_set_operator (_tmp350_, VALA_BINARY_OPERATOR_BITWISE_XOR);
					break;
				}
				case VALA_ASSIGNMENT_OPERATOR_ADD:
				{
					ValaBinaryExpression* _tmp351_;
					_tmp351_ = bin;
					vala_binary_expression_set_operator (_tmp351_, VALA_BINARY_OPERATOR_PLUS);
					break;
				}
				case VALA_ASSIGNMENT_OPERATOR_SUB:
				{
					ValaBinaryExpression* _tmp352_;
					_tmp352_ = bin;
					vala_binary_expression_set_operator (_tmp352_, VALA_BINARY_OPERATOR_MINUS);
					break;
				}
				case VALA_ASSIGNMENT_OPERATOR_MUL:
				{
					ValaBinaryExpression* _tmp353_;
					_tmp353_ = bin;
					vala_binary_expression_set_operator (_tmp353_, VALA_BINARY_OPERATOR_MUL);
					break;
				}
				case VALA_ASSIGNMENT_OPERATOR_DIV:
				{
					ValaBinaryExpression* _tmp354_;
					_tmp354_ = bin;
					vala_binary_expression_set_operator (_tmp354_, VALA_BINARY_OPERATOR_DIV);
					break;
				}
				case VALA_ASSIGNMENT_OPERATOR_PERCENT:
				{
					ValaBinaryExpression* _tmp355_;
					_tmp355_ = bin;
					vala_binary_expression_set_operator (_tmp355_, VALA_BINARY_OPERATOR_MOD);
					break;
				}
				case VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT:
				{
					ValaBinaryExpression* _tmp356_;
					_tmp356_ = bin;
					vala_binary_expression_set_operator (_tmp356_, VALA_BINARY_OPERATOR_SHIFT_LEFT);
					break;
				}
				case VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT:
				{
					ValaBinaryExpression* _tmp357_;
					_tmp357_ = bin;
					vala_binary_expression_set_operator (_tmp357_, VALA_BINARY_OPERATOR_SHIFT_RIGHT);
					break;
				}
				default:
				break;
			}
			_tmp358_ = bin;
			vala_assignment_set_right (self, (ValaExpression*) _tmp358_);
			_tmp359_ = vala_assignment_get_right (self);
			_tmp360_ = _tmp359_;
			vala_code_node_check ((ValaCodeNode*) _tmp360_, context);
			vala_assignment_set_operator (self, VALA_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_code_node_unref0 (bin);
			_vala_code_node_unref0 (old_value);
		}
		_vala_code_node_unref0 (ma);
	}
	_tmp361_ = vala_assignment_get_left (self);
	_tmp362_ = _tmp361_;
	_tmp363_ = vala_expression_get_symbol_reference (_tmp362_);
	_tmp364_ = _tmp363_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp364_, VALA_TYPE_SIGNAL)) {
		ValaSignal* sig = NULL;
		ValaExpression* _tmp365_;
		ValaExpression* _tmp366_;
		ValaSymbol* _tmp367_;
		ValaSymbol* _tmp368_;
		ValaSignal* _tmp369_;
		ValaMethod* m = NULL;
		ValaExpression* _tmp370_;
		ValaExpression* _tmp371_;
		ValaSymbol* _tmp372_;
		ValaSymbol* _tmp373_;
		ValaMethod* _tmp374_;
		ValaMethod* _tmp375_;
		ValaDynamicSignal* dynamic_sig = NULL;
		ValaSignal* _tmp380_;
		ValaDynamicSignal* _tmp381_;
		ValaMemberAccess* right_ma = NULL;
		ValaExpression* _tmp382_;
		ValaExpression* _tmp383_;
		ValaMemberAccess* _tmp384_;
		ValaDynamicSignal* _tmp385_;
		_tmp365_ = vala_assignment_get_left (self);
		_tmp366_ = _tmp365_;
		_tmp367_ = vala_expression_get_symbol_reference (_tmp366_);
		_tmp368_ = _tmp367_;
		_tmp369_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp368_, VALA_TYPE_SIGNAL, ValaSignal));
		sig = _tmp369_;
		_tmp370_ = vala_assignment_get_right (self);
		_tmp371_ = _tmp370_;
		_tmp372_ = vala_expression_get_symbol_reference (_tmp371_);
		_tmp373_ = _tmp372_;
		_tmp374_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp373_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp373_) : NULL);
		m = _tmp374_;
		_tmp375_ = m;
		if (_tmp375_ == NULL) {
			ValaExpression* _tmp376_;
			ValaExpression* _tmp377_;
			ValaSourceReference* _tmp378_;
			ValaSourceReference* _tmp379_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp376_ = vala_assignment_get_right (self);
			_tmp377_ = _tmp376_;
			_tmp378_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp377_);
			_tmp379_ = _tmp378_;
			vala_report_error (_tmp379_, "unsupported expression for signal handler");
			result = FALSE;
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (sig);
			return result;
		}
		_tmp380_ = sig;
		_tmp381_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp380_, VALA_TYPE_DYNAMIC_SIGNAL) ? ((ValaDynamicSignal*) _tmp380_) : NULL);
		dynamic_sig = _tmp381_;
		_tmp382_ = vala_assignment_get_right (self);
		_tmp383_ = _tmp382_;
		_tmp384_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp383_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp383_) : NULL);
		right_ma = _tmp384_;
		_tmp385_ = dynamic_sig;
		if (_tmp385_ != NULL) {
			gboolean first = FALSE;
			ValaExpression* _tmp406_;
			ValaExpression* _tmp407_;
			ValaSignal* _tmp408_;
			ValaSignal* _tmp409_;
			ValaSymbol* _tmp410_;
			ValaSymbol* _tmp411_;
			ValaObjectType* _tmp412_;
			ValaObjectType* _tmp413_;
			ValaDelegate* _tmp414_;
			ValaDelegate* _tmp415_;
			ValaDelegateType* _tmp416_;
			ValaDelegateType* _tmp417_;
			first = TRUE;
			{
				ValaList* _param_list = NULL;
				ValaDynamicSignal* _tmp386_;
				ValaExpression* _tmp387_;
				ValaExpression* _tmp388_;
				ValaDataType* _tmp389_;
				ValaDataType* _tmp390_;
				ValaList* _tmp391_;
				gint _param_size = 0;
				ValaList* _tmp392_;
				gint _tmp393_;
				gint _tmp394_;
				gint _param_index = 0;
				_tmp386_ = dynamic_sig;
				_tmp387_ = vala_dynamic_signal_get_handler (_tmp386_);
				_tmp388_ = _tmp387_;
				_tmp389_ = vala_expression_get_value_type (_tmp388_);
				_tmp390_ = _tmp389_;
				_tmp391_ = vala_data_type_get_parameters (_tmp390_);
				_param_list = _tmp391_;
				_tmp392_ = _param_list;
				_tmp393_ = vala_collection_get_size ((ValaCollection*) _tmp392_);
				_tmp394_ = _tmp393_;
				_param_size = _tmp394_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp395_;
					gint _tmp396_;
					gint _tmp397_;
					ValaParameter* param = NULL;
					ValaList* _tmp398_;
					gint _tmp399_;
					gpointer _tmp400_;
					gboolean _tmp401_;
					_tmp395_ = _param_index;
					_param_index = _tmp395_ + 1;
					_tmp396_ = _param_index;
					_tmp397_ = _param_size;
					if (!(_tmp396_ < _tmp397_)) {
						break;
					}
					_tmp398_ = _param_list;
					_tmp399_ = _param_index;
					_tmp400_ = vala_list_get (_tmp398_, _tmp399_);
					param = (ValaParameter*) _tmp400_;
					_tmp401_ = first;
					if (_tmp401_) {
						first = FALSE;
					} else {
						ValaDynamicSignal* _tmp402_;
						ValaParameter* _tmp403_;
						ValaParameter* _tmp404_;
						ValaParameter* _tmp405_;
						_tmp402_ = dynamic_sig;
						_tmp403_ = param;
						_tmp404_ = vala_parameter_copy (_tmp403_);
						_tmp405_ = _tmp404_;
						vala_callable_add_parameter ((ValaCallable*) _tmp402_, _tmp405_);
						_vala_code_node_unref0 (_tmp405_);
					}
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp406_ = vala_assignment_get_right (self);
			_tmp407_ = _tmp406_;
			_tmp408_ = sig;
			_tmp409_ = sig;
			_tmp410_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp409_);
			_tmp411_ = _tmp410_;
			_tmp412_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp411_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp413_ = _tmp412_;
			_tmp414_ = vala_signal_get_delegate (_tmp408_, (ValaDataType*) _tmp413_, (ValaCodeNode*) self);
			_tmp415_ = _tmp414_;
			_tmp416_ = vala_delegate_type_new (_tmp415_);
			_tmp417_ = _tmp416_;
			vala_expression_set_target_type (_tmp407_, (ValaDataType*) _tmp417_);
			_vala_code_node_unref0 (_tmp417_);
			_vala_code_node_unref0 (_tmp415_);
			_vala_code_node_unref0 (_tmp413_);
		} else {
			ValaExpression* _tmp418_;
			ValaExpression* _tmp419_;
			ValaDataType* _tmp420_;
			ValaDataType* _tmp421_;
			ValaExpression* _tmp422_;
			ValaExpression* _tmp423_;
			ValaDataType* _tmp424_;
			ValaDataType* _tmp425_;
			_tmp418_ = vala_assignment_get_right (self);
			_tmp419_ = _tmp418_;
			_tmp420_ = vala_expression_get_value_type (_tmp419_);
			_tmp421_ = _tmp420_;
			_tmp422_ = vala_assignment_get_right (self);
			_tmp423_ = _tmp422_;
			_tmp424_ = vala_expression_get_target_type (_tmp423_);
			_tmp425_ = _tmp424_;
			if (!vala_data_type_compatible (_tmp421_, _tmp425_)) {
				ValaDelegateType* delegate_type = NULL;
				ValaExpression* _tmp426_;
				ValaExpression* _tmp427_;
				ValaDataType* _tmp428_;
				ValaDataType* _tmp429_;
				ValaDelegateType* _tmp430_;
				ValaExpression* _tmp431_;
				ValaExpression* _tmp432_;
				ValaSourceReference* _tmp433_;
				ValaSourceReference* _tmp434_;
				ValaExpression* _tmp435_;
				ValaExpression* _tmp436_;
				ValaDataType* _tmp437_;
				ValaDataType* _tmp438_;
				gchar* _tmp439_;
				gchar* _tmp440_;
				ValaExpression* _tmp441_;
				ValaExpression* _tmp442_;
				ValaDataType* _tmp443_;
				ValaDataType* _tmp444_;
				gchar* _tmp445_;
				gchar* _tmp446_;
				ValaDelegateType* _tmp447_;
				ValaMethod* _tmp448_;
				const gchar* _tmp449_;
				const gchar* _tmp450_;
				gchar* _tmp451_;
				gchar* _tmp452_;
				gchar* _tmp453_;
				gchar* _tmp454_;
				_tmp426_ = vala_assignment_get_right (self);
				_tmp427_ = _tmp426_;
				_tmp428_ = vala_expression_get_target_type (_tmp427_);
				_tmp429_ = _tmp428_;
				_tmp430_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp429_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				delegate_type = _tmp430_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp431_ = vala_assignment_get_right (self);
				_tmp432_ = _tmp431_;
				_tmp433_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp432_);
				_tmp434_ = _tmp433_;
				_tmp435_ = vala_assignment_get_right (self);
				_tmp436_ = _tmp435_;
				_tmp437_ = vala_expression_get_value_type (_tmp436_);
				_tmp438_ = _tmp437_;
				_tmp439_ = vala_code_node_to_string ((ValaCodeNode*) _tmp438_);
				_tmp440_ = _tmp439_;
				_tmp441_ = vala_assignment_get_right (self);
				_tmp442_ = _tmp441_;
				_tmp443_ = vala_expression_get_target_type (_tmp442_);
				_tmp444_ = _tmp443_;
				_tmp445_ = vala_code_node_to_string ((ValaCodeNode*) _tmp444_);
				_tmp446_ = _tmp445_;
				_tmp447_ = delegate_type;
				_tmp448_ = m;
				_tmp449_ = vala_symbol_get_name ((ValaSymbol*) _tmp448_);
				_tmp450_ = _tmp449_;
				_tmp451_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp447_, _tmp450_);
				_tmp452_ = _tmp451_;
				_tmp453_ = g_strdup_printf ("method `%s' is incompatible with signal `%s', expected `%s'", _tmp440_, _tmp446_, _tmp452_);
				_tmp454_ = _tmp453_;
				vala_report_error (_tmp434_, _tmp454_);
				_g_free0 (_tmp454_);
				_g_free0 (_tmp452_);
				_g_free0 (_tmp446_);
				_g_free0 (_tmp440_);
				result = FALSE;
				_vala_code_node_unref0 (delegate_type);
				_vala_code_node_unref0 (right_ma);
				_vala_code_node_unref0 (dynamic_sig);
				_vala_code_node_unref0 (m);
				_vala_code_node_unref0 (sig);
				return result;
			} else {
				gboolean _tmp455_ = FALSE;
				ValaMemberAccess* _tmp456_;
				_tmp456_ = right_ma;
				if (_tmp456_ != NULL) {
					ValaMemberAccess* _tmp457_;
					gboolean _tmp458_;
					gboolean _tmp459_;
					_tmp457_ = right_ma;
					_tmp458_ = vala_member_access_get_prototype_access (_tmp457_);
					_tmp459_ = _tmp458_;
					_tmp455_ = _tmp459_;
				} else {
					_tmp455_ = FALSE;
				}
				if (_tmp455_) {
					ValaExpression* _tmp460_;
					ValaExpression* _tmp461_;
					ValaSourceReference* _tmp462_;
					ValaSourceReference* _tmp463_;
					ValaMethod* _tmp464_;
					gchar* _tmp465_;
					gchar* _tmp466_;
					gchar* _tmp467_;
					gchar* _tmp468_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp460_ = vala_assignment_get_right (self);
					_tmp461_ = _tmp460_;
					_tmp462_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp461_);
					_tmp463_ = _tmp462_;
					_tmp464_ = m;
					_tmp465_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp464_);
					_tmp466_ = _tmp465_;
					_tmp467_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp466_);
					_tmp468_ = _tmp467_;
					vala_report_error (_tmp463_, _tmp468_);
					_g_free0 (_tmp468_);
					_g_free0 (_tmp466_);
					result = FALSE;
					_vala_code_node_unref0 (right_ma);
					_vala_code_node_unref0 (dynamic_sig);
					_vala_code_node_unref0 (m);
					_vala_code_node_unref0 (sig);
					return result;
				}
			}
		}
		_vala_code_node_unref0 (right_ma);
		_vala_code_node_unref0 (dynamic_sig);
		_vala_code_node_unref0 (m);
		_vala_code_node_unref0 (sig);
	} else {
		ValaExpression* _tmp469_;
		ValaExpression* _tmp470_;
		_tmp469_ = vala_assignment_get_left (self);
		_tmp470_ = _tmp469_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp470_, VALA_TYPE_MEMBER_ACCESS)) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp471_;
			ValaExpression* _tmp472_;
			ValaMemberAccess* _tmp473_;
			ValaMemberAccess* _tmp474_;
			ValaSymbol* _tmp475_;
			ValaSymbol* _tmp476_;
			gboolean _tmp614_ = FALSE;
			ValaExpression* _tmp615_;
			ValaExpression* _tmp616_;
			ValaDataType* _tmp617_;
			ValaDataType* _tmp618_;
			ValaMemberAccess* right_ma = NULL;
			ValaExpression* _tmp673_;
			ValaExpression* _tmp674_;
			ValaMemberAccess* _tmp675_;
			gboolean _tmp676_ = FALSE;
			ValaMemberAccess* _tmp677_;
			_tmp471_ = vala_assignment_get_left (self);
			_tmp472_ = _tmp471_;
			_tmp473_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp472_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp473_;
			_tmp474_ = ma;
			_tmp475_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp474_);
			_tmp476_ = _tmp475_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp476_, VALA_TYPE_PROPERTY)) {
				ValaProperty* prop = NULL;
				ValaMemberAccess* _tmp477_;
				ValaSymbol* _tmp478_;
				ValaSymbol* _tmp479_;
				ValaProperty* _tmp480_;
				ValaDynamicProperty* dynamic_prop = NULL;
				ValaProperty* _tmp481_;
				ValaDynamicProperty* _tmp482_;
				ValaDynamicProperty* _tmp483_;
				gboolean _tmp498_ = FALSE;
				ValaProperty* _tmp499_;
				ValaPropertyAccessor* _tmp500_;
				ValaPropertyAccessor* _tmp501_;
				_tmp477_ = ma;
				_tmp478_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp477_);
				_tmp479_ = _tmp478_;
				_tmp480_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp479_, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp480_;
				_tmp481_ = prop;
				_tmp482_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp481_, VALA_TYPE_DYNAMIC_PROPERTY) ? ((ValaDynamicProperty*) _tmp481_) : NULL);
				dynamic_prop = _tmp482_;
				_tmp483_ = dynamic_prop;
				if (_tmp483_ != NULL) {
					ValaDynamicProperty* _tmp484_;
					ValaExpression* _tmp485_;
					ValaExpression* _tmp486_;
					ValaDataType* _tmp487_;
					ValaDataType* _tmp488_;
					ValaDataType* _tmp489_;
					ValaDataType* _tmp490_;
					ValaExpression* _tmp491_;
					ValaExpression* _tmp492_;
					ValaDynamicProperty* _tmp493_;
					ValaDataType* _tmp494_;
					ValaDataType* _tmp495_;
					ValaDataType* _tmp496_;
					ValaDataType* _tmp497_;
					_tmp484_ = dynamic_prop;
					_tmp485_ = vala_assignment_get_right (self);
					_tmp486_ = _tmp485_;
					_tmp487_ = vala_expression_get_value_type (_tmp486_);
					_tmp488_ = _tmp487_;
					_tmp489_ = vala_data_type_copy (_tmp488_);
					_tmp490_ = _tmp489_;
					vala_property_set_property_type ((ValaProperty*) _tmp484_, _tmp490_);
					_vala_code_node_unref0 (_tmp490_);
					_tmp491_ = vala_assignment_get_left (self);
					_tmp492_ = _tmp491_;
					_tmp493_ = dynamic_prop;
					_tmp494_ = vala_property_get_property_type ((ValaProperty*) _tmp493_);
					_tmp495_ = _tmp494_;
					_tmp496_ = vala_data_type_copy (_tmp495_);
					_tmp497_ = _tmp496_;
					vala_expression_set_value_type (_tmp492_, _tmp497_);
					_vala_code_node_unref0 (_tmp497_);
				}
				_tmp499_ = prop;
				_tmp500_ = vala_property_get_set_accessor (_tmp499_);
				_tmp501_ = _tmp500_;
				if (_tmp501_ == NULL) {
					_tmp498_ = TRUE;
				} else {
					gboolean _tmp502_ = FALSE;
					ValaProperty* _tmp503_;
					ValaPropertyAccessor* _tmp504_;
					ValaPropertyAccessor* _tmp505_;
					gboolean _tmp506_;
					gboolean _tmp507_;
					_tmp503_ = prop;
					_tmp504_ = vala_property_get_set_accessor (_tmp503_);
					_tmp505_ = _tmp504_;
					_tmp506_ = vala_property_accessor_get_writable (_tmp505_);
					_tmp507_ = _tmp506_;
					if (!_tmp507_) {
						gboolean _tmp508_ = FALSE;
						ValaSemanticAnalyzer* _tmp509_;
						ValaSemanticAnalyzer* _tmp510_;
						ValaMethod* _tmp511_;
						ValaMethod* _tmp512_;
						gboolean _tmp513_;
						_tmp509_ = vala_code_context_get_analyzer (context);
						_tmp510_ = _tmp509_;
						_tmp511_ = vala_semantic_analyzer_find_current_method (_tmp510_);
						_tmp512_ = _tmp511_;
						_tmp513_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp512_, VALA_TYPE_CREATION_METHOD);
						_vala_code_node_unref0 (_tmp512_);
						if (_tmp513_) {
							_tmp508_ = TRUE;
						} else {
							ValaSemanticAnalyzer* _tmp514_;
							ValaSemanticAnalyzer* _tmp515_;
							_tmp514_ = vala_code_context_get_analyzer (context);
							_tmp515_ = _tmp514_;
							_tmp508_ = vala_semantic_analyzer_is_in_constructor (_tmp515_);
						}
						_tmp502_ = !_tmp508_;
					} else {
						_tmp502_ = FALSE;
					}
					_tmp498_ = _tmp502_;
				}
				if (_tmp498_) {
					ValaMemberAccess* _tmp516_;
					ValaMemberAccess* _tmp517_;
					ValaSourceReference* _tmp518_;
					ValaSourceReference* _tmp519_;
					ValaProperty* _tmp520_;
					gchar* _tmp521_;
					gchar* _tmp522_;
					gchar* _tmp523_;
					gchar* _tmp524_;
					_tmp516_ = ma;
					vala_code_node_set_error ((ValaCodeNode*) _tmp516_, TRUE);
					_tmp517_ = ma;
					_tmp518_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp517_);
					_tmp519_ = _tmp518_;
					_tmp520_ = prop;
					_tmp521_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp520_);
					_tmp522_ = _tmp521_;
					_tmp523_ = g_strdup_printf ("Property `%s' is read-only", _tmp522_);
					_tmp524_ = _tmp523_;
					vala_report_error (_tmp519_, _tmp524_);
					_g_free0 (_tmp524_);
					_g_free0 (_tmp522_);
					result = FALSE;
					_vala_code_node_unref0 (dynamic_prop);
					_vala_code_node_unref0 (prop);
					_vala_code_node_unref0 (ma);
					return result;
				} else {
					gboolean _tmp525_ = FALSE;
					gboolean _tmp526_ = FALSE;
					gboolean _tmp527_;
					gboolean _tmp528_;
					_tmp527_ = vala_code_context_get_deprecated (context);
					_tmp528_ = _tmp527_;
					if (!_tmp528_) {
						ValaProperty* _tmp529_;
						ValaPropertyAccessor* _tmp530_;
						ValaPropertyAccessor* _tmp531_;
						gboolean _tmp532_;
						gboolean _tmp533_;
						_tmp529_ = prop;
						_tmp530_ = vala_property_get_set_accessor (_tmp529_);
						_tmp531_ = _tmp530_;
						_tmp532_ = vala_property_accessor_get_writable (_tmp531_);
						_tmp533_ = _tmp532_;
						_tmp526_ = !_tmp533_;
					} else {
						_tmp526_ = FALSE;
					}
					if (_tmp526_) {
						ValaSemanticAnalyzer* _tmp534_;
						ValaSemanticAnalyzer* _tmp535_;
						ValaMethod* _tmp536_;
						ValaMethod* _tmp537_;
						_tmp534_ = vala_code_context_get_analyzer (context);
						_tmp535_ = _tmp534_;
						_tmp536_ = vala_semantic_analyzer_find_current_method (_tmp535_);
						_tmp537_ = _tmp536_;
						_tmp525_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp537_, VALA_TYPE_CREATION_METHOD);
						_vala_code_node_unref0 (_tmp537_);
					} else {
						_tmp525_ = FALSE;
					}
					if (_tmp525_) {
						ValaMemberAccess* _tmp538_;
						ValaExpression* _tmp539_;
						ValaExpression* _tmp540_;
						ValaSymbol* _tmp541_;
						ValaSymbol* _tmp542_;
						ValaSemanticAnalyzer* _tmp543_;
						ValaSemanticAnalyzer* _tmp544_;
						ValaMethod* _tmp545_;
						ValaMethod* _tmp546_;
						ValaParameter* _tmp547_;
						ValaParameter* _tmp548_;
						gboolean _tmp549_;
						_tmp538_ = ma;
						_tmp539_ = vala_member_access_get_inner (_tmp538_);
						_tmp540_ = _tmp539_;
						_tmp541_ = vala_expression_get_symbol_reference (_tmp540_);
						_tmp542_ = _tmp541_;
						_tmp543_ = vala_code_context_get_analyzer (context);
						_tmp544_ = _tmp543_;
						_tmp545_ = vala_semantic_analyzer_find_current_method (_tmp544_);
						_tmp546_ = _tmp545_;
						_tmp547_ = vala_method_get_this_parameter (_tmp546_);
						_tmp548_ = _tmp547_;
						_tmp549_ = _tmp542_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp548_, VALA_TYPE_SYMBOL, ValaSymbol);
						_vala_code_node_unref0 (_tmp546_);
						if (_tmp549_) {
							ValaMemberAccess* _tmp550_;
							ValaSourceReference* _tmp551_;
							ValaSourceReference* _tmp552_;
							ValaProperty* _tmp553_;
							gchar* _tmp554_;
							gchar* _tmp555_;
							gchar* _tmp556_;
							gchar* _tmp557_;
							_tmp550_ = ma;
							_tmp551_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp550_);
							_tmp552_ = _tmp551_;
							_tmp553_ = prop;
							_tmp554_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp553_);
							_tmp555_ = _tmp554_;
							_tmp556_ = g_strdup_printf ("Property `%s' is read-only", _tmp555_);
							_tmp557_ = _tmp556_;
							vala_report_error (_tmp552_, _tmp557_);
							_g_free0 (_tmp557_);
							_g_free0 (_tmp555_);
							result = FALSE;
							_vala_code_node_unref0 (dynamic_prop);
							_vala_code_node_unref0 (prop);
							_vala_code_node_unref0 (ma);
							return result;
						} else {
							ValaMemberAccess* _tmp558_;
							ValaSourceReference* _tmp559_;
							ValaSourceReference* _tmp560_;
							_tmp558_ = ma;
							_tmp559_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp558_);
							_tmp560_ = _tmp559_;
							vala_report_error (_tmp560_, "Cannot assign to construct-only properties, use Object (property: valu" \
"e) constructor chain up");
							result = FALSE;
							_vala_code_node_unref0 (dynamic_prop);
							_vala_code_node_unref0 (prop);
							_vala_code_node_unref0 (ma);
							return result;
						}
					}
				}
				_vala_code_node_unref0 (dynamic_prop);
				_vala_code_node_unref0 (prop);
			} else {
				gboolean _tmp561_ = FALSE;
				ValaMemberAccess* _tmp562_;
				ValaSymbol* _tmp563_;
				ValaSymbol* _tmp564_;
				_tmp562_ = ma;
				_tmp563_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp562_);
				_tmp564_ = _tmp563_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp564_, VALA_TYPE_VARIABLE)) {
					ValaExpression* _tmp565_;
					ValaExpression* _tmp566_;
					ValaDataType* _tmp567_;
					ValaDataType* _tmp568_;
					_tmp565_ = vala_assignment_get_right (self);
					_tmp566_ = _tmp565_;
					_tmp567_ = vala_expression_get_value_type (_tmp566_);
					_tmp568_ = _tmp567_;
					_tmp561_ = _tmp568_ == NULL;
				} else {
					_tmp561_ = FALSE;
				}
				if (_tmp561_) {
					ValaVariable* variable = NULL;
					ValaMemberAccess* _tmp569_;
					ValaSymbol* _tmp570_;
					ValaSymbol* _tmp571_;
					ValaVariable* _tmp572_;
					gboolean _tmp573_ = FALSE;
					ValaExpression* _tmp574_;
					ValaExpression* _tmp575_;
					ValaSymbol* _tmp576_;
					ValaSymbol* _tmp577_;
					_tmp569_ = ma;
					_tmp570_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp569_);
					_tmp571_ = _tmp570_;
					_tmp572_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp571_, VALA_TYPE_VARIABLE, ValaVariable));
					variable = _tmp572_;
					_tmp574_ = vala_assignment_get_right (self);
					_tmp575_ = _tmp574_;
					_tmp576_ = vala_expression_get_symbol_reference (_tmp575_);
					_tmp577_ = _tmp576_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp577_, VALA_TYPE_METHOD)) {
						ValaVariable* _tmp578_;
						ValaDataType* _tmp579_;
						ValaDataType* _tmp580_;
						_tmp578_ = variable;
						_tmp579_ = vala_variable_get_variable_type (_tmp578_);
						_tmp580_ = _tmp579_;
						_tmp573_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp580_, VALA_TYPE_DELEGATE_TYPE);
					} else {
						_tmp573_ = FALSE;
					}
					if (_tmp573_) {
						ValaMethod* m = NULL;
						ValaExpression* _tmp581_;
						ValaExpression* _tmp582_;
						ValaSymbol* _tmp583_;
						ValaSymbol* _tmp584_;
						ValaMethod* _tmp585_;
						ValaDelegateType* dt = NULL;
						ValaVariable* _tmp586_;
						ValaDataType* _tmp587_;
						ValaDataType* _tmp588_;
						ValaDelegateType* _tmp589_;
						ValaDelegate* cb = NULL;
						ValaDelegateType* _tmp590_;
						ValaDelegate* _tmp591_;
						ValaDelegate* _tmp592_;
						ValaDelegate* _tmp593_;
						ValaDelegate* _tmp594_;
						ValaMethod* _tmp595_;
						ValaDelegateType* _tmp596_;
						ValaExpression* _tmp607_;
						ValaExpression* _tmp608_;
						ValaVariable* _tmp609_;
						ValaDataType* _tmp610_;
						ValaDataType* _tmp611_;
						_tmp581_ = vala_assignment_get_right (self);
						_tmp582_ = _tmp581_;
						_tmp583_ = vala_expression_get_symbol_reference (_tmp582_);
						_tmp584_ = _tmp583_;
						_tmp585_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp584_, VALA_TYPE_METHOD, ValaMethod));
						m = _tmp585_;
						_tmp586_ = variable;
						_tmp587_ = vala_variable_get_variable_type (_tmp586_);
						_tmp588_ = _tmp587_;
						_tmp589_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp588_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						dt = _tmp589_;
						_tmp590_ = dt;
						_tmp591_ = vala_delegate_type_get_delegate_symbol (_tmp590_);
						_tmp592_ = _tmp591_;
						_tmp593_ = _vala_code_node_ref0 (_tmp592_);
						cb = _tmp593_;
						_tmp594_ = cb;
						_tmp595_ = m;
						_tmp596_ = dt;
						if (!vala_delegate_matches_method (_tmp594_, _tmp595_, (ValaDataType*) _tmp596_)) {
							ValaSourceReference* _tmp597_;
							ValaSourceReference* _tmp598_;
							ValaMethod* _tmp599_;
							gchar* _tmp600_;
							gchar* _tmp601_;
							ValaDelegate* _tmp602_;
							gchar* _tmp603_;
							gchar* _tmp604_;
							gchar* _tmp605_;
							gchar* _tmp606_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp597_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp598_ = _tmp597_;
							_tmp599_ = m;
							_tmp600_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp599_);
							_tmp601_ = _tmp600_;
							_tmp602_ = cb;
							_tmp603_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp602_);
							_tmp604_ = _tmp603_;
							_tmp605_ = g_strdup_printf ("declaration of method `%s' doesn't match declaration of callback `%s'", _tmp601_, _tmp604_);
							_tmp606_ = _tmp605_;
							vala_report_error (_tmp598_, _tmp606_);
							_g_free0 (_tmp606_);
							_g_free0 (_tmp604_);
							_g_free0 (_tmp601_);
							result = FALSE;
							_vala_code_node_unref0 (cb);
							_vala_code_node_unref0 (dt);
							_vala_code_node_unref0 (m);
							_vala_code_node_unref0 (variable);
							_vala_code_node_unref0 (ma);
							return result;
						}
						_tmp607_ = vala_assignment_get_right (self);
						_tmp608_ = _tmp607_;
						_tmp609_ = variable;
						_tmp610_ = vala_variable_get_variable_type (_tmp609_);
						_tmp611_ = _tmp610_;
						vala_expression_set_value_type (_tmp608_, _tmp611_);
						_vala_code_node_unref0 (cb);
						_vala_code_node_unref0 (dt);
						_vala_code_node_unref0 (m);
					} else {
						ValaSourceReference* _tmp612_;
						ValaSourceReference* _tmp613_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp612_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp613_ = _tmp612_;
						vala_report_error (_tmp613_, "Assignment: Invalid assignment attempt");
						result = FALSE;
						_vala_code_node_unref0 (variable);
						_vala_code_node_unref0 (ma);
						return result;
					}
					_vala_code_node_unref0 (variable);
				}
			}
			_tmp615_ = vala_assignment_get_left (self);
			_tmp616_ = _tmp615_;
			_tmp617_ = vala_expression_get_value_type (_tmp616_);
			_tmp618_ = _tmp617_;
			if (_tmp618_ != NULL) {
				ValaExpression* _tmp619_;
				ValaExpression* _tmp620_;
				ValaDataType* _tmp621_;
				ValaDataType* _tmp622_;
				_tmp619_ = vala_assignment_get_right (self);
				_tmp620_ = _tmp619_;
				_tmp621_ = vala_expression_get_value_type (_tmp620_);
				_tmp622_ = _tmp621_;
				_tmp614_ = _tmp622_ != NULL;
			} else {
				_tmp614_ = FALSE;
			}
			if (_tmp614_) {
				ValaExpression* _tmp623_;
				ValaExpression* _tmp624_;
				ValaDataType* _tmp625_;
				ValaDataType* _tmp626_;
				ValaExpression* _tmp627_;
				ValaExpression* _tmp628_;
				ValaDataType* _tmp629_;
				ValaDataType* _tmp630_;
				ValaMemberAccess* _tmp647_;
				ValaSymbol* _tmp648_;
				ValaSymbol* _tmp649_;
				_tmp623_ = vala_assignment_get_right (self);
				_tmp624_ = _tmp623_;
				_tmp625_ = vala_expression_get_value_type (_tmp624_);
				_tmp626_ = _tmp625_;
				_tmp627_ = vala_assignment_get_left (self);
				_tmp628_ = _tmp627_;
				_tmp629_ = vala_expression_get_value_type (_tmp628_);
				_tmp630_ = _tmp629_;
				if (!vala_data_type_compatible (_tmp626_, _tmp630_)) {
					ValaSourceReference* _tmp631_;
					ValaSourceReference* _tmp632_;
					ValaExpression* _tmp633_;
					ValaExpression* _tmp634_;
					ValaDataType* _tmp635_;
					ValaDataType* _tmp636_;
					gchar* _tmp637_;
					gchar* _tmp638_;
					ValaExpression* _tmp639_;
					ValaExpression* _tmp640_;
					ValaDataType* _tmp641_;
					ValaDataType* _tmp642_;
					gchar* _tmp643_;
					gchar* _tmp644_;
					gchar* _tmp645_;
					gchar* _tmp646_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp631_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp632_ = _tmp631_;
					_tmp633_ = vala_assignment_get_right (self);
					_tmp634_ = _tmp633_;
					_tmp635_ = vala_expression_get_value_type (_tmp634_);
					_tmp636_ = _tmp635_;
					_tmp637_ = vala_code_node_to_string ((ValaCodeNode*) _tmp636_);
					_tmp638_ = _tmp637_;
					_tmp639_ = vala_assignment_get_left (self);
					_tmp640_ = _tmp639_;
					_tmp641_ = vala_expression_get_value_type (_tmp640_);
					_tmp642_ = _tmp641_;
					_tmp643_ = vala_code_node_to_string ((ValaCodeNode*) _tmp642_);
					_tmp644_ = _tmp643_;
					_tmp645_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp638_, _tmp644_);
					_tmp646_ = _tmp645_;
					vala_report_error (_tmp632_, _tmp646_);
					_g_free0 (_tmp646_);
					_g_free0 (_tmp644_);
					_g_free0 (_tmp638_);
					result = FALSE;
					_vala_code_node_unref0 (ma);
					return result;
				}
				_tmp647_ = ma;
				_tmp648_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp647_);
				_tmp649_ = _tmp648_;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp649_, VALA_TYPE_PROPERTY)) {
					ValaExpression* _tmp650_;
					ValaExpression* _tmp651_;
					ValaDataType* _tmp652_;
					ValaDataType* _tmp653_;
					_tmp650_ = vala_assignment_get_right (self);
					_tmp651_ = _tmp650_;
					_tmp652_ = vala_expression_get_value_type (_tmp651_);
					_tmp653_ = _tmp652_;
					if (vala_data_type_is_disposable (_tmp653_)) {
						gboolean _tmp654_ = FALSE;
						ValaExpression* _tmp655_;
						ValaExpression* _tmp656_;
						ValaDataType* _tmp657_;
						ValaDataType* _tmp658_;
						_tmp655_ = vala_assignment_get_left (self);
						_tmp656_ = _tmp655_;
						_tmp657_ = vala_expression_get_value_type (_tmp656_);
						_tmp658_ = _tmp657_;
						if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp658_, VALA_TYPE_POINTER_TYPE)) {
							ValaExpression* _tmp659_;
							ValaExpression* _tmp660_;
							ValaDataType* _tmp661_;
							ValaDataType* _tmp662_;
							gboolean _tmp663_;
							gboolean _tmp664_;
							_tmp659_ = vala_assignment_get_left (self);
							_tmp660_ = _tmp659_;
							_tmp661_ = vala_expression_get_value_type (_tmp660_);
							_tmp662_ = _tmp661_;
							_tmp663_ = vala_data_type_get_value_owned (_tmp662_);
							_tmp664_ = _tmp663_;
							_tmp654_ = !_tmp664_;
						} else {
							_tmp654_ = FALSE;
						}
						if (_tmp654_) {
							ValaSourceReference* _tmp665_;
							ValaSourceReference* _tmp666_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp665_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp666_ = _tmp665_;
							vala_report_error (_tmp666_, "Invalid assignment from owned expression to unowned variable");
						}
					} else {
						ValaExpression* _tmp667_;
						ValaExpression* _tmp668_;
						ValaDataType* _tmp669_;
						ValaDataType* _tmp670_;
						gboolean _tmp671_;
						gboolean _tmp672_;
						_tmp667_ = vala_assignment_get_left (self);
						_tmp668_ = _tmp667_;
						_tmp669_ = vala_expression_get_value_type (_tmp668_);
						_tmp670_ = _tmp669_;
						_tmp671_ = vala_data_type_get_value_owned (_tmp670_);
						_tmp672_ = _tmp671_;
						if (_tmp672_) {
						}
					}
				}
			}
			_tmp673_ = vala_assignment_get_right (self);
			_tmp674_ = _tmp673_;
			_tmp675_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp674_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp674_) : NULL);
			right_ma = _tmp675_;
			_tmp677_ = right_ma;
			if (_tmp677_ != NULL) {
				ValaMemberAccess* _tmp678_;
				ValaSymbol* _tmp679_;
				ValaSymbol* _tmp680_;
				ValaMemberAccess* _tmp681_;
				ValaSymbol* _tmp682_;
				ValaSymbol* _tmp683_;
				_tmp678_ = ma;
				_tmp679_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp678_);
				_tmp680_ = _tmp679_;
				_tmp681_ = right_ma;
				_tmp682_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp681_);
				_tmp683_ = _tmp682_;
				_tmp676_ = _tmp680_ == _tmp683_;
			} else {
				_tmp676_ = FALSE;
			}
			if (_tmp676_) {
				gboolean _tmp684_ = FALSE;
				ValaMemberAccess* _tmp685_;
				ValaSymbol* _tmp686_;
				ValaSymbol* _tmp687_;
				_tmp685_ = ma;
				_tmp686_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp685_);
				_tmp687_ = _tmp686_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp687_, VALA_TYPE_LOCAL_VARIABLE)) {
					_tmp684_ = TRUE;
				} else {
					ValaMemberAccess* _tmp688_;
					ValaSymbol* _tmp689_;
					ValaSymbol* _tmp690_;
					_tmp688_ = ma;
					_tmp689_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp688_);
					_tmp690_ = _tmp689_;
					_tmp684_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp690_, VALA_TYPE_PARAMETER);
				}
				if (_tmp684_) {
					ValaSourceReference* _tmp691_;
					ValaSourceReference* _tmp692_;
					_tmp691_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp692_ = _tmp691_;
					vala_report_warning (_tmp692_, "Assignment to same variable");
				} else {
					ValaMemberAccess* _tmp693_;
					ValaSymbol* _tmp694_;
					ValaSymbol* _tmp695_;
					_tmp693_ = ma;
					_tmp694_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp693_);
					_tmp695_ = _tmp694_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp695_, VALA_TYPE_FIELD)) {
						ValaField* f = NULL;
						ValaMemberAccess* _tmp696_;
						ValaSymbol* _tmp697_;
						ValaSymbol* _tmp698_;
						ValaField* _tmp699_;
						ValaField* _tmp700_;
						ValaMemberBinding _tmp701_;
						ValaMemberBinding _tmp702_;
						_tmp696_ = ma;
						_tmp697_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp696_);
						_tmp698_ = _tmp697_;
						_tmp699_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp698_, VALA_TYPE_FIELD, ValaField));
						f = _tmp699_;
						_tmp700_ = f;
						_tmp701_ = vala_field_get_binding (_tmp700_);
						_tmp702_ = _tmp701_;
						if (_tmp702_ == VALA_MEMBER_BINDING_STATIC) {
							ValaSourceReference* _tmp703_;
							ValaSourceReference* _tmp704_;
							_tmp703_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp704_ = _tmp703_;
							vala_report_warning (_tmp704_, "Assignment to same variable");
						} else {
							ValaMemberAccess* ma_inner = NULL;
							ValaMemberAccess* _tmp705_;
							ValaExpression* _tmp706_;
							ValaExpression* _tmp707_;
							ValaMemberAccess* _tmp708_;
							ValaMemberAccess* right_ma_inner = NULL;
							ValaMemberAccess* _tmp709_;
							ValaExpression* _tmp710_;
							ValaExpression* _tmp711_;
							ValaMemberAccess* _tmp712_;
							gboolean _tmp713_ = FALSE;
							gboolean _tmp714_ = FALSE;
							gboolean _tmp715_ = FALSE;
							gboolean _tmp716_ = FALSE;
							gboolean _tmp717_ = FALSE;
							ValaMemberAccess* _tmp718_;
							_tmp705_ = ma;
							_tmp706_ = vala_member_access_get_inner (_tmp705_);
							_tmp707_ = _tmp706_;
							_tmp708_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp707_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp707_) : NULL);
							ma_inner = _tmp708_;
							_tmp709_ = right_ma;
							_tmp710_ = vala_member_access_get_inner (_tmp709_);
							_tmp711_ = _tmp710_;
							_tmp712_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp711_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp711_) : NULL);
							right_ma_inner = _tmp712_;
							_tmp718_ = ma_inner;
							if (_tmp718_ != NULL) {
								ValaMemberAccess* _tmp719_;
								const gchar* _tmp720_;
								const gchar* _tmp721_;
								_tmp719_ = ma_inner;
								_tmp720_ = vala_member_access_get_member_name (_tmp719_);
								_tmp721_ = _tmp720_;
								_tmp717_ = g_strcmp0 (_tmp721_, "this") == 0;
							} else {
								_tmp717_ = FALSE;
							}
							if (_tmp717_) {
								ValaMemberAccess* _tmp722_;
								ValaExpression* _tmp723_;
								ValaExpression* _tmp724_;
								_tmp722_ = ma_inner;
								_tmp723_ = vala_member_access_get_inner (_tmp722_);
								_tmp724_ = _tmp723_;
								_tmp716_ = _tmp724_ == NULL;
							} else {
								_tmp716_ = FALSE;
							}
							if (_tmp716_) {
								ValaMemberAccess* _tmp725_;
								_tmp725_ = right_ma_inner;
								_tmp715_ = _tmp725_ != NULL;
							} else {
								_tmp715_ = FALSE;
							}
							if (_tmp715_) {
								ValaMemberAccess* _tmp726_;
								const gchar* _tmp727_;
								const gchar* _tmp728_;
								_tmp726_ = right_ma_inner;
								_tmp727_ = vala_member_access_get_member_name (_tmp726_);
								_tmp728_ = _tmp727_;
								_tmp714_ = g_strcmp0 (_tmp728_, "this") == 0;
							} else {
								_tmp714_ = FALSE;
							}
							if (_tmp714_) {
								ValaMemberAccess* _tmp729_;
								ValaExpression* _tmp730_;
								ValaExpression* _tmp731_;
								_tmp729_ = right_ma_inner;
								_tmp730_ = vala_member_access_get_inner (_tmp729_);
								_tmp731_ = _tmp730_;
								_tmp713_ = _tmp731_ == NULL;
							} else {
								_tmp713_ = FALSE;
							}
							if (_tmp713_) {
								ValaSourceReference* _tmp732_;
								ValaSourceReference* _tmp733_;
								_tmp732_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp733_ = _tmp732_;
								vala_report_warning (_tmp733_, "Assignment to same variable");
							}
							_vala_code_node_unref0 (right_ma_inner);
							_vala_code_node_unref0 (ma_inner);
						}
						_vala_code_node_unref0 (f);
					}
				}
			}
			_vala_code_node_unref0 (right_ma);
			_vala_code_node_unref0 (ma);
		} else {
			ValaExpression* _tmp734_;
			ValaExpression* _tmp735_;
			_tmp734_ = vala_assignment_get_left (self);
			_tmp735_ = _tmp734_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp735_, VALA_TYPE_ELEMENT_ACCESS)) {
				ValaElementAccess* ea = NULL;
				ValaExpression* _tmp736_;
				ValaExpression* _tmp737_;
				ValaElementAccess* _tmp738_;
				ValaExpression* _tmp739_;
				ValaExpression* _tmp740_;
				ValaDataType* _tmp741_;
				ValaDataType* _tmp742_;
				ValaExpression* _tmp743_;
				ValaExpression* _tmp744_;
				ValaDataType* _tmp745_;
				ValaDataType* _tmp746_;
				ValaExpression* _tmp763_;
				ValaExpression* _tmp764_;
				ValaDataType* _tmp765_;
				ValaDataType* _tmp766_;
				_tmp736_ = vala_assignment_get_left (self);
				_tmp737_ = _tmp736_;
				_tmp738_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp737_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
				ea = _tmp738_;
				_tmp739_ = vala_assignment_get_right (self);
				_tmp740_ = _tmp739_;
				_tmp741_ = vala_expression_get_value_type (_tmp740_);
				_tmp742_ = _tmp741_;
				_tmp743_ = vala_assignment_get_left (self);
				_tmp744_ = _tmp743_;
				_tmp745_ = vala_expression_get_value_type (_tmp744_);
				_tmp746_ = _tmp745_;
				if (!vala_data_type_compatible (_tmp742_, _tmp746_)) {
					ValaSourceReference* _tmp747_;
					ValaSourceReference* _tmp748_;
					ValaExpression* _tmp749_;
					ValaExpression* _tmp750_;
					ValaDataType* _tmp751_;
					ValaDataType* _tmp752_;
					gchar* _tmp753_;
					gchar* _tmp754_;
					ValaExpression* _tmp755_;
					ValaExpression* _tmp756_;
					ValaDataType* _tmp757_;
					ValaDataType* _tmp758_;
					gchar* _tmp759_;
					gchar* _tmp760_;
					gchar* _tmp761_;
					gchar* _tmp762_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp747_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp748_ = _tmp747_;
					_tmp749_ = vala_assignment_get_right (self);
					_tmp750_ = _tmp749_;
					_tmp751_ = vala_expression_get_value_type (_tmp750_);
					_tmp752_ = _tmp751_;
					_tmp753_ = vala_code_node_to_string ((ValaCodeNode*) _tmp752_);
					_tmp754_ = _tmp753_;
					_tmp755_ = vala_assignment_get_left (self);
					_tmp756_ = _tmp755_;
					_tmp757_ = vala_expression_get_value_type (_tmp756_);
					_tmp758_ = _tmp757_;
					_tmp759_ = vala_code_node_to_string ((ValaCodeNode*) _tmp758_);
					_tmp760_ = _tmp759_;
					_tmp761_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp754_, _tmp760_);
					_tmp762_ = _tmp761_;
					vala_report_error (_tmp748_, _tmp762_);
					_g_free0 (_tmp762_);
					_g_free0 (_tmp760_);
					_g_free0 (_tmp754_);
					result = FALSE;
					_vala_code_node_unref0 (ea);
					return result;
				}
				_tmp763_ = vala_assignment_get_right (self);
				_tmp764_ = _tmp763_;
				_tmp765_ = vala_expression_get_value_type (_tmp764_);
				_tmp766_ = _tmp765_;
				if (vala_data_type_is_disposable (_tmp766_)) {
					ValaDataType* element_type = NULL;
					ValaElementAccess* _tmp767_;
					ValaExpression* _tmp768_;
					ValaExpression* _tmp769_;
					ValaDataType* _tmp770_;
					ValaDataType* _tmp771_;
					gboolean _tmp793_ = FALSE;
					ValaDataType* _tmp794_;
					_tmp767_ = ea;
					_tmp768_ = vala_element_access_get_container (_tmp767_);
					_tmp769_ = _tmp768_;
					_tmp770_ = vala_expression_get_value_type (_tmp769_);
					_tmp771_ = _tmp770_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp771_, VALA_TYPE_ARRAY_TYPE)) {
						ValaArrayType* array_type = NULL;
						ValaElementAccess* _tmp772_;
						ValaExpression* _tmp773_;
						ValaExpression* _tmp774_;
						ValaDataType* _tmp775_;
						ValaDataType* _tmp776_;
						ValaArrayType* _tmp777_;
						ValaArrayType* _tmp778_;
						ValaDataType* _tmp779_;
						ValaDataType* _tmp780_;
						ValaDataType* _tmp781_;
						_tmp772_ = ea;
						_tmp773_ = vala_element_access_get_container (_tmp772_);
						_tmp774_ = _tmp773_;
						_tmp775_ = vala_expression_get_value_type (_tmp774_);
						_tmp776_ = _tmp775_;
						_tmp777_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp776_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp777_;
						_tmp778_ = array_type;
						_tmp779_ = vala_array_type_get_element_type (_tmp778_);
						_tmp780_ = _tmp779_;
						_tmp781_ = _vala_code_node_ref0 (_tmp780_);
						_vala_code_node_unref0 (element_type);
						element_type = _tmp781_;
						_vala_code_node_unref0 (array_type);
					} else {
						ValaList* args = NULL;
						ValaElementAccess* _tmp782_;
						ValaExpression* _tmp783_;
						ValaExpression* _tmp784_;
						ValaDataType* _tmp785_;
						ValaDataType* _tmp786_;
						ValaList* _tmp787_;
						ValaList* _tmp788_;
						gint _tmp789_;
						gint _tmp790_;
						ValaList* _tmp791_;
						gpointer _tmp792_;
						_tmp782_ = ea;
						_tmp783_ = vala_element_access_get_container (_tmp782_);
						_tmp784_ = _tmp783_;
						_tmp785_ = vala_expression_get_value_type (_tmp784_);
						_tmp786_ = _tmp785_;
						_tmp787_ = vala_data_type_get_type_arguments (_tmp786_);
						args = _tmp787_;
						_tmp788_ = args;
						_tmp789_ = vala_collection_get_size ((ValaCollection*) _tmp788_);
						_tmp790_ = _tmp789_;
						_vala_assert (_tmp790_ == 1, "args.size == 1");
						_tmp791_ = args;
						_tmp792_ = vala_list_get (_tmp791_, 0);
						_vala_code_node_unref0 (element_type);
						element_type = (ValaDataType*) _tmp792_;
						_vala_iterable_unref0 (args);
					}
					_tmp794_ = element_type;
					if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp794_, VALA_TYPE_POINTER_TYPE)) {
						ValaDataType* _tmp795_;
						gboolean _tmp796_;
						gboolean _tmp797_;
						_tmp795_ = element_type;
						_tmp796_ = vala_data_type_get_value_owned (_tmp795_);
						_tmp797_ = _tmp796_;
						_tmp793_ = !_tmp797_;
					} else {
						_tmp793_ = FALSE;
					}
					if (_tmp793_) {
						ValaSourceReference* _tmp798_;
						ValaSourceReference* _tmp799_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp798_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp799_ = _tmp798_;
						vala_report_error (_tmp799_, "Invalid assignment from owned expression to unowned variable");
						result = FALSE;
						_vala_code_node_unref0 (element_type);
						_vala_code_node_unref0 (ea);
						return result;
					}
					_vala_code_node_unref0 (element_type);
				} else {
					ValaExpression* _tmp800_;
					ValaExpression* _tmp801_;
					ValaDataType* _tmp802_;
					ValaDataType* _tmp803_;
					gboolean _tmp804_;
					gboolean _tmp805_;
					_tmp800_ = vala_assignment_get_left (self);
					_tmp801_ = _tmp800_;
					_tmp802_ = vala_expression_get_value_type (_tmp801_);
					_tmp803_ = _tmp802_;
					_tmp804_ = vala_data_type_get_value_owned (_tmp803_);
					_tmp805_ = _tmp804_;
					if (_tmp805_) {
					}
				}
				_vala_code_node_unref0 (ea);
			} else {
				result = TRUE;
				return result;
			}
		}
	}
	_tmp806_ = vala_assignment_get_left (self);
	_tmp807_ = _tmp806_;
	_tmp808_ = vala_expression_get_value_type (_tmp807_);
	_tmp809_ = _tmp808_;
	if (_tmp809_ != NULL) {
		ValaExpression* _tmp810_;
		ValaExpression* _tmp811_;
		ValaDataType* _tmp812_;
		ValaDataType* _tmp813_;
		ValaDataType* _tmp814_;
		ValaDataType* _tmp815_;
		ValaDataType* _tmp816_;
		ValaDataType* _tmp817_;
		_tmp810_ = vala_assignment_get_left (self);
		_tmp811_ = _tmp810_;
		_tmp812_ = vala_expression_get_value_type (_tmp811_);
		_tmp813_ = _tmp812_;
		_tmp814_ = vala_data_type_copy (_tmp813_);
		_tmp815_ = _tmp814_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp815_);
		_vala_code_node_unref0 (_tmp815_);
		_tmp816_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp817_ = _tmp816_;
		vala_data_type_set_value_owned (_tmp817_, FALSE);
	} else {
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
	}
	_tmp818_ = vala_assignment_get_left (self);
	_tmp819_ = _tmp818_;
	_tmp820_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp819_);
	_tmp821_ = _tmp820_;
	vala_code_node_add_error_types ((ValaCodeNode*) self, _tmp821_);
	_vala_iterable_unref0 (_tmp821_);
	_tmp822_ = vala_assignment_get_right (self);
	_tmp823_ = _tmp822_;
	_tmp824_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp823_);
	_tmp825_ = _tmp824_;
	vala_code_node_add_error_types ((ValaCodeNode*) self, _tmp825_);
	_vala_iterable_unref0 (_tmp825_);
	_tmp826_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp827_ = _tmp826_;
	result = !_tmp827_;
	return result;
}


static gboolean
vala_assignment_is_array_add (ValaAssignment* self)
{
	gboolean result = FALSE;
	ValaBinaryExpression* binary = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaBinaryExpression* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaBinaryExpression* _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_assignment_get_right (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_BINARY_EXPRESSION) ? ((ValaBinaryExpression*) _tmp1_) : NULL);
	binary = _tmp2_;
	_tmp4_ = binary;
	if (_tmp4_ != NULL) {
		ValaBinaryExpression* _tmp5_;
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp5_ = binary;
		_tmp6_ = vala_binary_expression_get_left (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_expression_get_value_type (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaBinaryExpression* _tmp10_;
		ValaBinaryOperator _tmp11_;
		ValaBinaryOperator _tmp12_;
		_tmp10_ = binary;
		_tmp11_ = vala_binary_expression_get_operator (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ == VALA_BINARY_OPERATOR_PLUS) {
			ValaExpression* _tmp13_;
			ValaExpression* _tmp14_;
			ValaSymbol* _tmp15_;
			ValaSymbol* _tmp16_;
			ValaBinaryExpression* _tmp17_;
			ValaExpression* _tmp18_;
			ValaExpression* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaSymbol* _tmp21_;
			_tmp13_ = vala_assignment_get_left (self);
			_tmp14_ = _tmp13_;
			_tmp15_ = vala_expression_get_symbol_reference (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = binary;
			_tmp18_ = vala_binary_expression_get_left (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_expression_get_symbol_reference (_tmp19_);
			_tmp21_ = _tmp20_;
			if (_tmp16_ == _tmp21_) {
				result = TRUE;
				_vala_code_node_unref0 (binary);
				return result;
			}
		}
	}
	result = FALSE;
	_vala_code_node_unref0 (binary);
	return result;
}


static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}


static void
vala_assignment_real_emit (ValaCodeNode* base,
                           ValaCodeGenerator* codegen)
{
	ValaAssignment * self;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaMemberAccess* _tmp2_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaElementAccess* _tmp5_;
	ValaPointerIndirection* pi = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaPointerIndirection* _tmp8_;
	ValaMemberAccess* _tmp9_;
	ValaExpression* _tmp136_;
	ValaExpression* _tmp137_;
	self = (ValaAssignment*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp1_) : NULL);
	ma = _tmp2_;
	_tmp3_ = vala_assignment_get_left (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_ELEMENT_ACCESS) ? ((ValaElementAccess*) _tmp4_) : NULL);
	ea = _tmp5_;
	_tmp6_ = vala_assignment_get_left (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_POINTER_INDIRECTION) ? ((ValaPointerIndirection*) _tmp7_) : NULL);
	pi = _tmp8_;
	_tmp9_ = ma;
	if (_tmp9_ != NULL) {
		ValaLocalVariable* local = NULL;
		ValaMemberAccess* _tmp10_;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaLocalVariable* _tmp13_;
		ValaParameter* param = NULL;
		ValaMemberAccess* _tmp14_;
		ValaSymbol* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaParameter* _tmp17_;
		ValaField* field = NULL;
		ValaMemberAccess* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaField* _tmp21_;
		ValaProperty* property = NULL;
		ValaMemberAccess* _tmp22_;
		ValaSymbol* _tmp23_;
		ValaSymbol* _tmp24_;
		ValaProperty* _tmp25_;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
		ValaField* _tmp28_;
		gboolean instance = FALSE;
		gboolean _tmp37_ = FALSE;
		gboolean _tmp38_ = FALSE;
		gboolean _tmp39_ = FALSE;
		gboolean _tmp40_ = FALSE;
		ValaAssignmentOperator _tmp41_;
		gboolean _tmp121_ = FALSE;
		gboolean _tmp122_ = FALSE;
		gboolean _tmp123_;
		_tmp10_ = ma;
		_tmp11_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp12_) : NULL);
		local = _tmp13_;
		_tmp14_ = ma;
		_tmp15_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_PARAMETER) ? ((ValaParameter*) _tmp16_) : NULL);
		param = _tmp17_;
		_tmp18_ = ma;
		_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, VALA_TYPE_FIELD) ? ((ValaField*) _tmp20_) : NULL);
		field = _tmp21_;
		_tmp22_ = ma;
		_tmp23_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALA_TYPE_PROPERTY) ? ((ValaProperty*) _tmp24_) : NULL);
		property = _tmp25_;
		_tmp28_ = field;
		if (_tmp28_ != NULL) {
			ValaField* _tmp29_;
			ValaMemberBinding _tmp30_;
			ValaMemberBinding _tmp31_;
			_tmp29_ = field;
			_tmp30_ = vala_field_get_binding (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp27_ = _tmp31_ != VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			_tmp26_ = TRUE;
		} else {
			gboolean _tmp32_ = FALSE;
			ValaProperty* _tmp33_;
			_tmp33_ = property;
			if (_tmp33_ != NULL) {
				ValaProperty* _tmp34_;
				ValaMemberBinding _tmp35_;
				ValaMemberBinding _tmp36_;
				_tmp34_ = property;
				_tmp35_ = vala_property_get_binding (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp32_ = _tmp36_ != VALA_MEMBER_BINDING_STATIC;
			} else {
				_tmp32_ = FALSE;
			}
			_tmp26_ = _tmp32_;
		}
		instance = _tmp26_;
		_tmp41_ = self->priv->_operator;
		if (_tmp41_ == VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
			gboolean _tmp42_ = FALSE;
			gboolean _tmp43_ = FALSE;
			ValaLocalVariable* _tmp44_;
			_tmp44_ = local;
			if (_tmp44_ != NULL) {
				_tmp43_ = TRUE;
			} else {
				ValaParameter* _tmp45_;
				_tmp45_ = param;
				_tmp43_ = _tmp45_ != NULL;
			}
			if (_tmp43_) {
				_tmp42_ = TRUE;
			} else {
				ValaField* _tmp46_;
				_tmp46_ = field;
				_tmp42_ = _tmp46_ != NULL;
			}
			_tmp40_ = _tmp42_;
		} else {
			_tmp40_ = FALSE;
		}
		if (_tmp40_) {
			_tmp39_ = !vala_assignment_is_array_add (self);
		} else {
			_tmp39_ = FALSE;
		}
		if (_tmp39_) {
			ValaField* _tmp47_;
			_tmp47_ = field;
			_tmp38_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, VALA_TYPE_ARRAY_LENGTH_FIELD);
		} else {
			_tmp38_ = FALSE;
		}
		if (_tmp38_) {
			gboolean _tmp48_ = FALSE;
			ValaExpression* _tmp49_;
			ValaExpression* _tmp50_;
			ValaDataType* _tmp51_;
			ValaDataType* _tmp52_;
			_tmp49_ = vala_assignment_get_left (self);
			_tmp50_ = _tmp49_;
			_tmp51_ = vala_expression_get_value_type (_tmp50_);
			_tmp52_ = _tmp51_;
			if (vala_data_type_is_real_non_null_struct_type (_tmp52_)) {
				ValaExpression* _tmp53_;
				ValaExpression* _tmp54_;
				_tmp53_ = vala_assignment_get_right (self);
				_tmp54_ = _tmp53_;
				_tmp48_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp54_, VALA_TYPE_OBJECT_CREATION_EXPRESSION);
			} else {
				_tmp48_ = FALSE;
			}
			_tmp37_ = !_tmp48_;
		} else {
			_tmp37_ = FALSE;
		}
		if (_tmp37_) {
			gboolean _tmp55_ = FALSE;
			gboolean _tmp56_;
			ValaExpression* _tmp63_;
			ValaExpression* _tmp64_;
			ValaTargetValue* new_value = NULL;
			ValaExpression* _tmp65_;
			ValaExpression* _tmp66_;
			ValaTargetValue* _tmp67_;
			ValaTargetValue* _tmp68_;
			ValaTargetValue* _tmp69_;
			ValaLocalVariable* _tmp70_;
			ValaCodeNode* _tmp96_;
			ValaCodeNode* _tmp97_;
			_tmp56_ = instance;
			if (_tmp56_) {
				ValaMemberAccess* _tmp57_;
				ValaExpression* _tmp58_;
				ValaExpression* _tmp59_;
				_tmp57_ = ma;
				_tmp58_ = vala_member_access_get_inner (_tmp57_);
				_tmp59_ = _tmp58_;
				_tmp55_ = _tmp59_ != NULL;
			} else {
				_tmp55_ = FALSE;
			}
			if (_tmp55_) {
				ValaMemberAccess* _tmp60_;
				ValaExpression* _tmp61_;
				ValaExpression* _tmp62_;
				_tmp60_ = ma;
				_tmp61_ = vala_member_access_get_inner (_tmp60_);
				_tmp62_ = _tmp61_;
				vala_code_node_emit ((ValaCodeNode*) _tmp62_, codegen);
			}
			_tmp63_ = vala_assignment_get_right (self);
			_tmp64_ = _tmp63_;
			vala_code_node_emit ((ValaCodeNode*) _tmp64_, codegen);
			_tmp65_ = vala_assignment_get_right (self);
			_tmp66_ = _tmp65_;
			_tmp67_ = vala_expression_get_target_value (_tmp66_);
			_tmp68_ = _tmp67_;
			_tmp69_ = _vala_target_value_ref0 (_tmp68_);
			new_value = _tmp69_;
			_tmp70_ = local;
			if (_tmp70_ != NULL) {
				ValaLocalVariable* _tmp71_;
				ValaTargetValue* _tmp72_;
				ValaSourceReference* _tmp73_;
				ValaSourceReference* _tmp74_;
				_tmp71_ = local;
				_tmp72_ = new_value;
				_tmp73_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp74_ = _tmp73_;
				vala_code_generator_store_local (codegen, _tmp71_, _tmp72_, FALSE, _tmp74_);
			} else {
				ValaParameter* _tmp75_;
				_tmp75_ = param;
				if (_tmp75_ != NULL) {
					ValaParameter* _tmp76_;
					ValaTargetValue* _tmp77_;
					ValaSourceReference* _tmp78_;
					ValaSourceReference* _tmp79_;
					_tmp76_ = param;
					_tmp77_ = new_value;
					_tmp78_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp79_ = _tmp78_;
					vala_code_generator_store_parameter (codegen, _tmp76_, _tmp77_, FALSE, _tmp79_);
				} else {
					ValaField* _tmp80_;
					_tmp80_ = field;
					if (_tmp80_ != NULL) {
						ValaTargetValue* _tmp81_ = NULL;
						gboolean _tmp82_ = FALSE;
						gboolean _tmp83_;
						ValaField* _tmp92_;
						ValaTargetValue* _tmp93_;
						ValaSourceReference* _tmp94_;
						ValaSourceReference* _tmp95_;
						_tmp83_ = instance;
						if (_tmp83_) {
							ValaMemberAccess* _tmp84_;
							ValaExpression* _tmp85_;
							ValaExpression* _tmp86_;
							_tmp84_ = ma;
							_tmp85_ = vala_member_access_get_inner (_tmp84_);
							_tmp86_ = _tmp85_;
							_tmp82_ = _tmp86_ != NULL;
						} else {
							_tmp82_ = FALSE;
						}
						if (_tmp82_) {
							ValaMemberAccess* _tmp87_;
							ValaExpression* _tmp88_;
							ValaExpression* _tmp89_;
							ValaTargetValue* _tmp90_;
							ValaTargetValue* _tmp91_;
							_tmp87_ = ma;
							_tmp88_ = vala_member_access_get_inner (_tmp87_);
							_tmp89_ = _tmp88_;
							_tmp90_ = vala_expression_get_target_value (_tmp89_);
							_tmp91_ = _tmp90_;
							_tmp81_ = _tmp91_;
						} else {
							_tmp81_ = NULL;
						}
						_tmp92_ = field;
						_tmp93_ = new_value;
						_tmp94_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp95_ = _tmp94_;
						vala_code_generator_store_field (codegen, _tmp92_, _tmp81_, _tmp93_, _tmp95_);
					}
				}
			}
			_tmp96_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp97_ = _tmp96_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp97_, VALA_TYPE_EXPRESSION_STATEMENT)) {
				ValaLocalVariable* _tmp98_;
				_tmp98_ = local;
				if (_tmp98_ != NULL) {
					ValaLocalVariable* _tmp99_;
					ValaTargetValue* _tmp100_;
					ValaTargetValue* _tmp101_;
					_tmp99_ = local;
					_tmp100_ = vala_code_generator_load_local (codegen, _tmp99_);
					_tmp101_ = _tmp100_;
					vala_expression_set_target_value ((ValaExpression*) self, _tmp101_);
					_vala_target_value_unref0 (_tmp101_);
				} else {
					ValaParameter* _tmp102_;
					_tmp102_ = param;
					if (_tmp102_ != NULL) {
						ValaParameter* _tmp103_;
						ValaTargetValue* _tmp104_;
						ValaTargetValue* _tmp105_;
						_tmp103_ = param;
						_tmp104_ = vala_code_generator_load_parameter (codegen, _tmp103_);
						_tmp105_ = _tmp104_;
						vala_expression_set_target_value ((ValaExpression*) self, _tmp105_);
						_vala_target_value_unref0 (_tmp105_);
					} else {
						ValaField* _tmp106_;
						_tmp106_ = field;
						if (_tmp106_ != NULL) {
							ValaTargetValue* _tmp107_ = NULL;
							gboolean _tmp108_ = FALSE;
							gboolean _tmp109_;
							ValaField* _tmp118_;
							ValaTargetValue* _tmp119_;
							ValaTargetValue* _tmp120_;
							_tmp109_ = instance;
							if (_tmp109_) {
								ValaMemberAccess* _tmp110_;
								ValaExpression* _tmp111_;
								ValaExpression* _tmp112_;
								_tmp110_ = ma;
								_tmp111_ = vala_member_access_get_inner (_tmp110_);
								_tmp112_ = _tmp111_;
								_tmp108_ = _tmp112_ != NULL;
							} else {
								_tmp108_ = FALSE;
							}
							if (_tmp108_) {
								ValaMemberAccess* _tmp113_;
								ValaExpression* _tmp114_;
								ValaExpression* _tmp115_;
								ValaTargetValue* _tmp116_;
								ValaTargetValue* _tmp117_;
								_tmp113_ = ma;
								_tmp114_ = vala_member_access_get_inner (_tmp113_);
								_tmp115_ = _tmp114_;
								_tmp116_ = vala_expression_get_target_value (_tmp115_);
								_tmp117_ = _tmp116_;
								_tmp107_ = _tmp117_;
							} else {
								_tmp107_ = NULL;
							}
							_tmp118_ = field;
							_tmp119_ = vala_code_generator_load_field (codegen, _tmp118_, _tmp107_);
							_tmp120_ = _tmp119_;
							vala_expression_set_target_value ((ValaExpression*) self, _tmp120_);
							_vala_target_value_unref0 (_tmp120_);
						}
					}
				}
			}
			vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
			_vala_target_value_unref0 (new_value);
			_vala_code_node_unref0 (property);
			_vala_code_node_unref0 (field);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (pi);
			_vala_code_node_unref0 (ea);
			_vala_code_node_unref0 (ma);
			return;
		}
		_tmp123_ = instance;
		if (_tmp123_) {
			ValaMemberAccess* _tmp124_;
			ValaExpression* _tmp125_;
			ValaExpression* _tmp126_;
			_tmp124_ = ma;
			_tmp125_ = vala_member_access_get_inner (_tmp124_);
			_tmp126_ = _tmp125_;
			_tmp122_ = _tmp126_ != NULL;
		} else {
			_tmp122_ = FALSE;
		}
		if (_tmp122_) {
			ValaProperty* _tmp127_;
			_tmp127_ = property;
			_tmp121_ = _tmp127_ != NULL;
		} else {
			_tmp121_ = FALSE;
		}
		if (_tmp121_) {
			ValaMemberAccess* _tmp128_;
			ValaExpression* _tmp129_;
			ValaExpression* _tmp130_;
			_tmp128_ = ma;
			_tmp129_ = vala_member_access_get_inner (_tmp128_);
			_tmp130_ = _tmp129_;
			vala_code_node_emit ((ValaCodeNode*) _tmp130_, codegen);
		} else {
			ValaMemberAccess* _tmp131_;
			_tmp131_ = ma;
			vala_code_node_emit ((ValaCodeNode*) _tmp131_, codegen);
		}
		_vala_code_node_unref0 (property);
		_vala_code_node_unref0 (field);
		_vala_code_node_unref0 (param);
		_vala_code_node_unref0 (local);
	} else {
		ValaElementAccess* _tmp132_;
		_tmp132_ = ea;
		if (_tmp132_ != NULL) {
			ValaElementAccess* _tmp133_;
			_tmp133_ = ea;
			vala_code_node_emit ((ValaCodeNode*) _tmp133_, codegen);
		} else {
			ValaPointerIndirection* _tmp134_;
			_tmp134_ = pi;
			if (_tmp134_ != NULL) {
				ValaPointerIndirection* _tmp135_;
				_tmp135_ = pi;
				vala_code_node_emit ((ValaCodeNode*) _tmp135_, codegen);
			}
		}
	}
	_tmp136_ = vala_assignment_get_right (self);
	_tmp137_ = _tmp136_;
	vala_code_node_emit ((ValaCodeNode*) _tmp137_, codegen);
	vala_code_visitor_visit_assignment ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
	_vala_code_node_unref0 (pi);
	_vala_code_node_unref0 (ea);
	_vala_code_node_unref0 (ma);
}


static void
vala_assignment_real_get_defined_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaLocalVariable* local = NULL;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	ValaParameter* param = NULL;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaParameter* _tmp13_;
	ValaLocalVariable* _tmp14_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_right (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_assignment_get_left (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	_tmp4_ = vala_assignment_get_left (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_expression_get_symbol_reference (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp7_) : NULL);
	local = _tmp8_;
	_tmp9_ = vala_assignment_get_left (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_expression_get_symbol_reference (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_PARAMETER) ? ((ValaParameter*) _tmp12_) : NULL);
	param = _tmp13_;
	_tmp14_ = local;
	if (_tmp14_ != NULL) {
		ValaLocalVariable* _tmp15_;
		_tmp15_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp15_);
	} else {
		gboolean _tmp16_ = FALSE;
		ValaParameter* _tmp17_;
		_tmp17_ = param;
		if (_tmp17_ != NULL) {
			ValaParameter* _tmp18_;
			ValaParameterDirection _tmp19_;
			ValaParameterDirection _tmp20_;
			_tmp18_ = param;
			_tmp19_ = vala_parameter_get_direction (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp16_ = _tmp20_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			ValaParameter* _tmp21_;
			_tmp21_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp21_);
		}
	}
	_vala_code_node_unref0 (param);
	_vala_code_node_unref0 (local);
}


static void
vala_assignment_real_get_used_variables (ValaCodeNode* base,
                                         ValaCollection* collection)
{
	ValaAssignment * self;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaMemberAccess* _tmp2_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaElementAccess* _tmp5_;
	gboolean _tmp6_ = FALSE;
	ValaMemberAccess* _tmp7_;
	ValaExpression* _tmp16_;
	ValaExpression* _tmp17_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp1_) : NULL);
	ma = _tmp2_;
	_tmp3_ = vala_assignment_get_left (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_ELEMENT_ACCESS) ? ((ValaElementAccess*) _tmp4_) : NULL);
	ea = _tmp5_;
	_tmp7_ = ma;
	if (_tmp7_ != NULL) {
		ValaMemberAccess* _tmp8_;
		ValaExpression* _tmp9_;
		ValaExpression* _tmp10_;
		_tmp8_ = ma;
		_tmp9_ = vala_member_access_get_inner (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp6_ = _tmp10_ != NULL;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValaMemberAccess* _tmp11_;
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		_tmp11_ = ma;
		_tmp12_ = vala_member_access_get_inner (_tmp11_);
		_tmp13_ = _tmp12_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp13_, collection);
	} else {
		ValaElementAccess* _tmp14_;
		_tmp14_ = ea;
		if (_tmp14_ != NULL) {
			ValaElementAccess* _tmp15_;
			_tmp15_ = ea;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp15_, collection);
		}
	}
	_tmp16_ = vala_assignment_get_right (self);
	_tmp17_ = _tmp16_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp17_, collection);
	_vala_code_node_unref0 (ea);
	_vala_code_node_unref0 (ma);
}


ValaExpression*
vala_assignment_get_left (ValaAssignment* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_left;
	result = _tmp0_;
	return result;
}


void
vala_assignment_set_left (ValaAssignment* self,
                          ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_left);
	self->priv->_left = _tmp0_;
	_tmp1_ = self->priv->_left;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


ValaAssignmentOperator
vala_assignment_get_operator (ValaAssignment* self)
{
	ValaAssignmentOperator result;
	ValaAssignmentOperator _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_operator;
	result = _tmp0_;
	return result;
}


void
vala_assignment_set_operator (ValaAssignment* self,
                              ValaAssignmentOperator value)
{
	g_return_if_fail (self != NULL);
	self->priv->_operator = value;
}


ValaExpression*
vala_assignment_get_right (ValaAssignment* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_right;
	result = _tmp0_;
	return result;
}


void
vala_assignment_set_right (ValaAssignment* self,
                           ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_right);
	self->priv->_right = _tmp0_;
	_tmp1_ = self->priv->_right;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


static void
vala_assignment_class_init (ValaAssignmentClass * klass)
{
	vala_assignment_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_assignment_finalize;
	g_type_class_add_private (klass, sizeof (ValaAssignmentPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_assignment_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_assignment_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_assignment_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression *)) vala_assignment_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression *, ValaSymbol*)) vala_assignment_real_is_accessible;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_assignment_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_assignment_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_assignment_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_assignment_real_get_used_variables;
}


static void
vala_assignment_instance_init (ValaAssignment * self)
{
	self->priv = VALA_ASSIGNMENT_GET_PRIVATE (self);
}


static void
vala_assignment_finalize (ValaCodeNode * obj)
{
	ValaAssignment * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ASSIGNMENT, ValaAssignment);
	_vala_code_node_unref0 (self->priv->_left);
	_vala_code_node_unref0 (self->priv->_right);
	VALA_CODE_NODE_CLASS (vala_assignment_parent_class)->finalize (obj);
}


/**
 * Represents an assignment expression in the source code.
 *
 * Supports =, |=, &=, ^=, +=, -=, *=, /=, %=, <<=, >>=.
 */
GType
vala_assignment_get_type (void)
{
	static volatile gsize vala_assignment_type_id__volatile = 0;
	if (g_once_init_enter (&vala_assignment_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaAssignmentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_assignment_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaAssignment), 0, (GInstanceInitFunc) vala_assignment_instance_init, NULL };
		GType vala_assignment_type_id;
		vala_assignment_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaAssignment", &g_define_type_info, 0);
		g_once_init_leave (&vala_assignment_type_id__volatile, vala_assignment_type_id);
	}
	return vala_assignment_type_id__volatile;
}


GType
vala_assignment_operator_get_type (void)
{
	static volatile gsize vala_assignment_operator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_assignment_operator_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_ASSIGNMENT_OPERATOR_NONE, "VALA_ASSIGNMENT_OPERATOR_NONE", "none"}, {VALA_ASSIGNMENT_OPERATOR_SIMPLE, "VALA_ASSIGNMENT_OPERATOR_SIMPLE", "simple"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_OR, "VALA_ASSIGNMENT_OPERATOR_BITWISE_OR", "bitwise-or"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_AND, "VALA_ASSIGNMENT_OPERATOR_BITWISE_AND", "bitwise-and"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR, "VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR", "bitwise-xor"}, {VALA_ASSIGNMENT_OPERATOR_ADD, "VALA_ASSIGNMENT_OPERATOR_ADD", "add"}, {VALA_ASSIGNMENT_OPERATOR_SUB, "VALA_ASSIGNMENT_OPERATOR_SUB", "sub"}, {VALA_ASSIGNMENT_OPERATOR_MUL, "VALA_ASSIGNMENT_OPERATOR_MUL", "mul"}, {VALA_ASSIGNMENT_OPERATOR_DIV, "VALA_ASSIGNMENT_OPERATOR_DIV", "div"}, {VALA_ASSIGNMENT_OPERATOR_PERCENT, "VALA_ASSIGNMENT_OPERATOR_PERCENT", "percent"}, {VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT, "VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT", "shift-left"}, {VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT, "VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT", "shift-right"}, {0, NULL, NULL}};
		GType vala_assignment_operator_type_id;
		vala_assignment_operator_type_id = g_enum_register_static ("ValaAssignmentOperator", values);
		g_once_init_leave (&vala_assignment_operator_type_id__volatile, vala_assignment_operator_type_id);
	}
	return vala_assignment_operator_type_id__volatile;
}



