/* markupreader.c generated by valac, the Vala compiler
 * generated from markupreader.vala, do not modify */

/* markupreader.vala
 *
 * Copyright (C) 2008-2009  Jürg Billeter
 * Copyright (C) 2011       Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "valadoc.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

enum  {
	VALADOC_MARKUP_READER_0_PROPERTY,
	VALADOC_MARKUP_READER_FILENAME_PROPERTY,
	VALADOC_MARKUP_READER_NAME_PROPERTY,
	VALADOC_MARKUP_READER_CONTENT_PROPERTY,
	VALADOC_MARKUP_READER_NUM_PROPERTIES
};
static GParamSpec* valadoc_markup_reader_properties[VALADOC_MARKUP_READER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_mapped_file_unref0(var) ((var == NULL) ? NULL : (var = (g_mapped_file_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValadocMarkupReaderPrivate {
	gchar* _filename;
	gchar* _name;
	gchar* _content;
	GMappedFile* mapped_file;
	gchar** lines;
	gint lines_length1;
	gint _lines_size_;
	gchar* begin;
	gchar* current;
	gchar* end;
	gint line;
	gint column;
	ValaMap* attributes;
	gboolean empty_element;
	ValadocErrorReporter* reporter;
};


static gpointer valadoc_markup_reader_parent_class = NULL;

#define VALADOC_MARKUP_READER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALADOC_TYPE_MARKUP_READER, ValadocMarkupReaderPrivate))
static void valadoc_markup_reader_set_filename (ValadocMarkupReader* self,
                                         const gchar* value);
static gchar* valadoc_markup_reader_read_name (ValadocMarkupReader* self);
static void valadoc_markup_reader_set_content (ValadocMarkupReader* self,
                                        const gchar* value);
static void valadoc_markup_reader_set_name (ValadocMarkupReader* self,
                                     const gchar* value);
static void valadoc_markup_reader_space (ValadocMarkupReader* self);
static gchar* valadoc_markup_reader_text (ValadocMarkupReader* self,
                                   gchar end_char,
                                   gboolean rm_trailing_whitespace);
static void valadoc_markup_reader_finalize (GObject * obj);
static void _vala_valadoc_markup_reader_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_valadoc_markup_reader_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


ValadocMarkupReader*
valadoc_markup_reader_construct_from_string (GType object_type,
                                             const gchar* filename,
                                             const gchar* content,
                                             ValadocErrorReporter* reporter)
{
	ValadocMarkupReader * self = NULL;
	ValadocErrorReporter* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (filename != NULL, NULL);
	g_return_val_if_fail (content != NULL, NULL);
	g_return_val_if_fail (reporter != NULL, NULL);
	self = (ValadocMarkupReader*) g_object_new (object_type, NULL);
	valadoc_markup_reader_set_filename (self, filename);
	_tmp0_ = _g_object_ref0 (reporter);
	_g_object_unref0 (self->priv->reporter);
	self->priv->reporter = _tmp0_;
	_tmp2_ = _tmp1_ = g_strsplit (content, "\n", 0);
	self->priv->lines = (_vala_array_free (self->priv->lines, self->priv->lines_length1, (GDestroyNotify) g_free), NULL);
	self->priv->lines = _tmp2_;
	self->priv->lines_length1 = _vala_array_length (_tmp1_);
	self->priv->_lines_size_ = self->priv->lines_length1;
	self->priv->begin = content;
	_tmp3_ = self->priv->begin;
	_tmp4_ = strlen (content);
	_tmp5_ = _tmp4_;
	self->priv->end = _tmp3_ + _tmp5_;
	_tmp6_ = self->priv->begin;
	self->priv->current = _tmp6_;
	self->priv->column = 1;
	self->priv->line = 1;
	return self;
}


ValadocMarkupReader*
valadoc_markup_reader_new_from_string (const gchar* filename,
                                       const gchar* content,
                                       ValadocErrorReporter* reporter)
{
	return valadoc_markup_reader_construct_from_string (VALADOC_TYPE_MARKUP_READER, filename, content, reporter);
}


ValadocMarkupReader*
valadoc_markup_reader_construct (GType object_type,
                                 const gchar* filename,
                                 ValadocErrorReporter* reporter)
{
	ValadocMarkupReader * self = NULL;
	ValadocErrorReporter* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (filename != NULL, NULL);
	g_return_val_if_fail (reporter != NULL, NULL);
	self = (ValadocMarkupReader*) g_object_new (object_type, NULL);
	valadoc_markup_reader_set_filename (self, filename);
	_tmp0_ = _g_object_ref0 (reporter);
	_g_object_unref0 (self->priv->reporter);
	self->priv->reporter = _tmp0_;
	{
		GMappedFile* _tmp1_ = NULL;
		GMappedFile* _tmp2_;
		GMappedFile* _tmp3_;
		GMappedFile* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar** _tmp7_;
		gchar** _tmp8_;
		gchar* _tmp9_;
		GMappedFile* _tmp10_;
		gchar* _tmp11_;
		_tmp2_ = g_mapped_file_new (filename, FALSE, &_inner_error_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch4_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_mapped_file_unref0 (self->priv->mapped_file);
		self->priv->mapped_file = _tmp3_;
		_tmp4_ = self->priv->mapped_file;
		_tmp5_ = g_mapped_file_get_contents (_tmp4_);
		self->priv->begin = _tmp5_;
		_tmp6_ = self->priv->begin;
		_tmp8_ = _tmp7_ = g_strsplit ((const gchar*) _tmp6_, "\n", 0);
		self->priv->lines = (_vala_array_free (self->priv->lines, self->priv->lines_length1, (GDestroyNotify) g_free), NULL);
		self->priv->lines = _tmp8_;
		self->priv->lines_length1 = _vala_array_length (_tmp7_);
		self->priv->_lines_size_ = self->priv->lines_length1;
		_tmp9_ = self->priv->begin;
		_tmp10_ = self->priv->mapped_file;
		self->priv->end = _tmp9_ + g_mapped_file_get_length (_tmp10_);
		_tmp11_ = self->priv->begin;
		self->priv->current = _tmp11_;
		self->priv->line = 1;
		self->priv->column = 1;
		_g_mapped_file_unref0 (_tmp1_);
	}
	goto __finally4;
	__catch4_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		valadoc_error_reporter_simple_error (reporter, NULL, "Unable to map file '%s': %s", filename, _tmp13_);
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


ValadocMarkupReader*
valadoc_markup_reader_new (const gchar* filename,
                           ValadocErrorReporter* reporter)
{
	return valadoc_markup_reader_construct (VALADOC_TYPE_MARKUP_READER, filename, reporter);
}


gchar*
valadoc_markup_reader_get_line_content (ValadocMarkupReader* self,
                                        gint line_nr)
{
	gchar* result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->lines;
	_tmp0__length1 = self->priv->lines_length1;
	if (_tmp0__length1 > line_nr) {
		gchar** _tmp1_;
		gint _tmp1__length1;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = self->priv->lines;
		_tmp1__length1 = self->priv->lines_length1;
		_tmp2_ = _tmp1_[line_nr];
		_tmp3_ = g_strdup (_tmp2_);
		result = _tmp3_;
		return result;
	}
	result = NULL;
	return result;
}


gchar*
valadoc_markup_reader_get_attribute (ValadocMarkupReader* self,
                                     const gchar* attr)
{
	gchar* result = NULL;
	ValaMap* _tmp0_;
	gpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (attr != NULL, NULL);
	_tmp0_ = self->priv->attributes;
	_tmp1_ = vala_map_get (_tmp0_, attr);
	result = (gchar*) _tmp1_;
	return result;
}


ValaMap*
valadoc_markup_reader_get_attributes (ValadocMarkupReader* self)
{
	ValaMap* result = NULL;
	ValaHashMap* _result_ = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp0_, _tmp1_, _tmp2_);
	_result_ = _tmp3_;
	{
		ValaIterator* _key_it = NULL;
		ValaMap* _tmp4_;
		ValaSet* _tmp5_;
		ValaSet* _tmp6_;
		ValaIterator* _tmp7_;
		ValaIterator* _tmp8_;
		_tmp4_ = self->priv->attributes;
		_tmp5_ = vala_map_get_keys (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_iterable_iterator ((ValaIterable*) _tmp6_);
		_tmp8_ = _tmp7_;
		_vala_iterable_unref0 (_tmp6_);
		_key_it = _tmp8_;
		while (TRUE) {
			ValaIterator* _tmp9_;
			gchar* key = NULL;
			ValaIterator* _tmp10_;
			gpointer _tmp11_;
			ValaHashMap* _tmp12_;
			const gchar* _tmp13_;
			ValaMap* _tmp14_;
			const gchar* _tmp15_;
			gpointer _tmp16_;
			gchar* _tmp17_;
			_tmp9_ = _key_it;
			if (!vala_iterator_next (_tmp9_)) {
				break;
			}
			_tmp10_ = _key_it;
			_tmp11_ = vala_iterator_get (_tmp10_);
			key = (gchar*) _tmp11_;
			_tmp12_ = _result_;
			_tmp13_ = key;
			_tmp14_ = self->priv->attributes;
			_tmp15_ = key;
			_tmp16_ = vala_map_get (_tmp14_, _tmp15_);
			_tmp17_ = (gchar*) _tmp16_;
			vala_map_set ((ValaMap*) _tmp12_, _tmp13_, _tmp17_);
			_g_free0 (_tmp17_);
			_g_free0 (key);
		}
		_vala_iterator_unref0 (_key_it);
	}
	result = (ValaMap*) _result_;
	return result;
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static gchar*
valadoc_markup_reader_read_name (ValadocMarkupReader* self)
{
	gchar* result = NULL;
	gchar* begin = NULL;
	gchar* _tmp0_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->current;
	begin = _tmp0_;
	while (TRUE) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		gchar* _tmp8_;
		gchar _tmp9_;
		gunichar u = 0U;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gunichar _tmp23_;
		_tmp1_ = self->priv->current;
		_tmp2_ = self->priv->end;
		if (!(_tmp1_ < _tmp2_)) {
			break;
		}
		_tmp8_ = self->priv->current;
		_tmp9_ = _tmp8_[0];
		if (_tmp9_ == ' ') {
			_tmp7_ = TRUE;
		} else {
			gchar* _tmp10_;
			gchar _tmp11_;
			_tmp10_ = self->priv->current;
			_tmp11_ = _tmp10_[0];
			_tmp7_ = _tmp11_ == '\t';
		}
		if (_tmp7_) {
			_tmp6_ = TRUE;
		} else {
			gchar* _tmp12_;
			gchar _tmp13_;
			_tmp12_ = self->priv->current;
			_tmp13_ = _tmp12_[0];
			_tmp6_ = _tmp13_ == '>';
		}
		if (_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			gchar* _tmp14_;
			gchar _tmp15_;
			_tmp14_ = self->priv->current;
			_tmp15_ = _tmp14_[0];
			_tmp5_ = _tmp15_ == '/';
		}
		if (_tmp5_) {
			_tmp4_ = TRUE;
		} else {
			gchar* _tmp16_;
			gchar _tmp17_;
			_tmp16_ = self->priv->current;
			_tmp17_ = _tmp16_[0];
			_tmp4_ = _tmp17_ == '=';
		}
		if (_tmp4_) {
			_tmp3_ = TRUE;
		} else {
			gchar* _tmp18_;
			gchar _tmp19_;
			_tmp18_ = self->priv->current;
			_tmp19_ = _tmp18_[0];
			_tmp3_ = _tmp19_ == '\n';
		}
		if (_tmp3_) {
			break;
		}
		_tmp20_ = self->priv->current;
		_tmp21_ = self->priv->end;
		_tmp22_ = self->priv->current;
		u = g_utf8_get_char_validated ((const gchar*) _tmp20_, (gssize) ((glong) (_tmp21_ - _tmp22_)));
		_tmp23_ = u;
		if (_tmp23_ != ((gunichar) -1)) {
			gchar* _tmp24_;
			gunichar _tmp25_;
			_tmp24_ = self->priv->current;
			_tmp25_ = u;
			self->priv->current = _tmp24_ + g_unichar_to_utf8 (_tmp25_, NULL);
		} else {
			ValadocErrorReporter* _tmp26_;
			const gchar* _tmp27_;
			gint _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			_tmp26_ = self->priv->reporter;
			_tmp27_ = self->priv->_filename;
			_tmp28_ = self->priv->line;
			_tmp29_ = g_strdup_printf ("%s:%d", _tmp27_, _tmp28_);
			_tmp30_ = _tmp29_;
			valadoc_error_reporter_simple_error (_tmp26_, _tmp30_, "invalid UTF-8 character");
			_g_free0 (_tmp30_);
		}
	}
	_tmp31_ = self->priv->current;
	_tmp32_ = begin;
	if (_tmp31_ == _tmp32_) {
	}
	_tmp33_ = begin;
	_tmp34_ = self->priv->current;
	_tmp35_ = begin;
	_tmp36_ = string_substring ((const gchar*) _tmp33_, (glong) 0, (glong) ((gint) (_tmp34_ - _tmp35_)));
	result = _tmp36_;
	return result;
}


ValadocMarkupTokenType
valadoc_markup_reader_read_token (ValadocMarkupReader* self,
                                  ValadocMarkupSourceLocation* token_begin,
                                  ValadocMarkupSourceLocation* token_end)
{
	ValadocMarkupSourceLocation _vala_token_begin = {0};
	ValadocMarkupSourceLocation _vala_token_end = {0};
	ValadocMarkupTokenType result = 0;
	ValaMap* _tmp0_;
	gboolean _tmp1_;
	ValadocMarkupTokenType type = 0;
	gchar* begin = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp111_;
	gint _tmp112_;
	gint _tmp113_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->attributes;
	vala_map_clear (_tmp0_);
	_tmp1_ = self->priv->empty_element;
	if (_tmp1_) {
		gchar* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gchar* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		self->priv->empty_element = FALSE;
		_tmp2_ = self->priv->begin;
		_tmp3_ = self->priv->line;
		_tmp4_ = self->priv->column;
		valadoc_markup_source_location_init (&_vala_token_begin, _tmp2_, _tmp3_, _tmp4_);
		_tmp5_ = self->priv->begin;
		_tmp6_ = self->priv->line;
		_tmp7_ = self->priv->column;
		valadoc_markup_source_location_init (&_vala_token_end, _tmp5_, _tmp6_, _tmp7_);
		result = VALADOC_MARKUP_TOKEN_TYPE_END_ELEMENT;
		if (token_begin) {
			*token_begin = _vala_token_begin;
		}
		if (token_end) {
			*token_end = _vala_token_end;
		}
		return result;
	}
	valadoc_markup_reader_set_content (self, NULL);
	valadoc_markup_reader_set_name (self, NULL);
	valadoc_markup_reader_space (self);
	type = VALADOC_MARKUP_TOKEN_TYPE_NONE;
	_tmp8_ = self->priv->current;
	begin = _tmp8_;
	_tmp9_ = begin;
	_tmp10_ = self->priv->line;
	_tmp11_ = self->priv->column;
	valadoc_markup_source_location_init (&_vala_token_begin, _tmp9_, _tmp10_, _tmp11_);
	_tmp12_ = self->priv->current;
	_tmp13_ = self->priv->end;
	if (_tmp12_ >= _tmp13_) {
		type = VALADOC_MARKUP_TOKEN_TYPE_EOF;
	} else {
		gchar* _tmp14_;
		gchar _tmp15_;
		_tmp14_ = self->priv->current;
		_tmp15_ = _tmp14_[0];
		if (_tmp15_ == '<') {
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp16_ = self->priv->current;
			self->priv->current = _tmp16_ + 1;
			_tmp17_ = self->priv->current;
			_tmp18_ = self->priv->end;
			if (_tmp17_ >= _tmp18_) {
			} else {
				gchar* _tmp19_;
				gchar _tmp20_;
				_tmp19_ = self->priv->current;
				_tmp20_ = _tmp19_[0];
				if (_tmp20_ == '?') {
				} else {
					gchar* _tmp21_;
					gchar _tmp22_;
					_tmp21_ = self->priv->current;
					_tmp22_ = _tmp21_[0];
					if (_tmp22_ == '!') {
						gchar* _tmp23_;
						gboolean _tmp24_ = FALSE;
						gboolean _tmp25_ = FALSE;
						gchar* _tmp26_;
						gchar* _tmp27_;
						_tmp23_ = self->priv->current;
						self->priv->current = _tmp23_ + 1;
						_tmp26_ = self->priv->current;
						_tmp27_ = self->priv->end;
						if (_tmp26_ < (_tmp27_ - 1)) {
							gchar* _tmp28_;
							gchar _tmp29_;
							_tmp28_ = self->priv->current;
							_tmp29_ = _tmp28_[0];
							_tmp25_ = _tmp29_ == '-';
						} else {
							_tmp25_ = FALSE;
						}
						if (_tmp25_) {
							gchar* _tmp30_;
							gchar _tmp31_;
							_tmp30_ = self->priv->current;
							_tmp31_ = _tmp30_[1];
							_tmp24_ = _tmp31_ == '-';
						} else {
							_tmp24_ = FALSE;
						}
						if (_tmp24_) {
							gchar* _tmp32_;
							ValadocMarkupSourceLocation _tmp48_ = {0};
							ValadocMarkupSourceLocation _tmp49_ = {0};
							ValadocMarkupTokenType _tmp50_;
							_tmp32_ = self->priv->current;
							self->priv->current = _tmp32_ + 2;
							while (TRUE) {
								gchar* _tmp33_;
								gchar* _tmp34_;
								gboolean _tmp35_ = FALSE;
								gboolean _tmp36_ = FALSE;
								gchar* _tmp37_;
								gchar _tmp38_;
								gchar* _tmp47_;
								_tmp33_ = self->priv->current;
								_tmp34_ = self->priv->end;
								if (!(_tmp33_ < (_tmp34_ - 2))) {
									break;
								}
								_tmp37_ = self->priv->current;
								_tmp38_ = _tmp37_[0];
								if (_tmp38_ == '-') {
									gchar* _tmp39_;
									gchar _tmp40_;
									_tmp39_ = self->priv->current;
									_tmp40_ = _tmp39_[1];
									_tmp36_ = _tmp40_ == '-';
								} else {
									_tmp36_ = FALSE;
								}
								if (_tmp36_) {
									gchar* _tmp41_;
									gchar _tmp42_;
									_tmp41_ = self->priv->current;
									_tmp42_ = _tmp41_[2];
									_tmp35_ = _tmp42_ == '>';
								} else {
									_tmp35_ = FALSE;
								}
								if (_tmp35_) {
									gchar* _tmp43_;
									_tmp43_ = self->priv->current;
									self->priv->current = _tmp43_ + 3;
									break;
								} else {
									gchar* _tmp44_;
									gchar _tmp45_;
									_tmp44_ = self->priv->current;
									_tmp45_ = _tmp44_[0];
									if (_tmp45_ == '\n') {
										gint _tmp46_;
										_tmp46_ = self->priv->line;
										self->priv->line = _tmp46_ + 1;
										self->priv->column = 0;
									}
								}
								_tmp47_ = self->priv->current;
								self->priv->current = _tmp47_ + 1;
							}
							_tmp50_ = valadoc_markup_reader_read_token (self, &_tmp48_, &_tmp49_);
							_vala_token_begin = _tmp48_;
							_vala_token_end = _tmp49_;
							result = _tmp50_;
							if (token_begin) {
								*token_begin = _vala_token_begin;
							}
							if (token_end) {
								*token_end = _vala_token_end;
							}
							return result;
						}
					} else {
						gchar* _tmp51_;
						gchar _tmp52_;
						_tmp51_ = self->priv->current;
						_tmp52_ = _tmp51_[0];
						if (_tmp52_ == '/') {
							gchar* _tmp53_;
							gchar* _tmp54_;
							gchar* _tmp55_;
							gboolean _tmp56_ = FALSE;
							gchar* _tmp57_;
							gchar* _tmp58_;
							gchar* _tmp61_;
							type = VALADOC_MARKUP_TOKEN_TYPE_END_ELEMENT;
							_tmp53_ = self->priv->current;
							self->priv->current = _tmp53_ + 1;
							_tmp54_ = valadoc_markup_reader_read_name (self);
							_tmp55_ = _tmp54_;
							valadoc_markup_reader_set_name (self, _tmp55_);
							_g_free0 (_tmp55_);
							_tmp57_ = self->priv->current;
							_tmp58_ = self->priv->end;
							if (_tmp57_ >= _tmp58_) {
								_tmp56_ = TRUE;
							} else {
								gchar* _tmp59_;
								gchar _tmp60_;
								_tmp59_ = self->priv->current;
								_tmp60_ = _tmp59_[0];
								_tmp56_ = _tmp60_ != '>';
							}
							if (_tmp56_) {
							}
							_tmp61_ = self->priv->current;
							self->priv->current = _tmp61_ + 1;
						} else {
							gchar* _tmp62_;
							gchar* _tmp63_;
							gchar* _tmp95_;
							gchar _tmp96_;
							gboolean _tmp98_ = FALSE;
							gchar* _tmp99_;
							gchar* _tmp100_;
							gchar* _tmp103_;
							type = VALADOC_MARKUP_TOKEN_TYPE_START_ELEMENT;
							_tmp62_ = valadoc_markup_reader_read_name (self);
							_tmp63_ = _tmp62_;
							valadoc_markup_reader_set_name (self, _tmp63_);
							_g_free0 (_tmp63_);
							valadoc_markup_reader_space (self);
							while (TRUE) {
								gboolean _tmp64_ = FALSE;
								gboolean _tmp65_ = FALSE;
								gchar* _tmp66_;
								gchar* _tmp67_;
								gchar* attr_name = NULL;
								gchar* _tmp72_;
								gboolean _tmp73_ = FALSE;
								gchar* _tmp74_;
								gchar* _tmp75_;
								gchar* _tmp78_;
								gboolean _tmp79_ = FALSE;
								gchar* _tmp80_;
								gchar* _tmp81_;
								gchar* _tmp84_;
								gchar* attr_value = NULL;
								gchar* _tmp85_;
								gboolean _tmp86_ = FALSE;
								gchar* _tmp87_;
								gchar* _tmp88_;
								gchar* _tmp91_;
								ValaMap* _tmp92_;
								const gchar* _tmp93_;
								const gchar* _tmp94_;
								_tmp66_ = self->priv->current;
								_tmp67_ = self->priv->end;
								if (_tmp66_ < _tmp67_) {
									gchar* _tmp68_;
									gchar _tmp69_;
									_tmp68_ = self->priv->current;
									_tmp69_ = _tmp68_[0];
									_tmp65_ = _tmp69_ != '>';
								} else {
									_tmp65_ = FALSE;
								}
								if (_tmp65_) {
									gchar* _tmp70_;
									gchar _tmp71_;
									_tmp70_ = self->priv->current;
									_tmp71_ = _tmp70_[0];
									_tmp64_ = _tmp71_ != '/';
								} else {
									_tmp64_ = FALSE;
								}
								if (!_tmp64_) {
									break;
								}
								_tmp72_ = valadoc_markup_reader_read_name (self);
								attr_name = _tmp72_;
								_tmp74_ = self->priv->current;
								_tmp75_ = self->priv->end;
								if (_tmp74_ >= _tmp75_) {
									_tmp73_ = TRUE;
								} else {
									gchar* _tmp76_;
									gchar _tmp77_;
									_tmp76_ = self->priv->current;
									_tmp77_ = _tmp76_[0];
									_tmp73_ = _tmp77_ != '=';
								}
								if (_tmp73_) {
								}
								_tmp78_ = self->priv->current;
								self->priv->current = _tmp78_ + 1;
								_tmp80_ = self->priv->current;
								_tmp81_ = self->priv->end;
								if (_tmp80_ >= _tmp81_) {
									_tmp79_ = TRUE;
								} else {
									gchar* _tmp82_;
									gchar _tmp83_;
									_tmp82_ = self->priv->current;
									_tmp83_ = _tmp82_[0];
									_tmp79_ = _tmp83_ != '"';
								}
								if (_tmp79_) {
								}
								_tmp84_ = self->priv->current;
								self->priv->current = _tmp84_ + 1;
								_tmp85_ = valadoc_markup_reader_text (self, '"', FALSE);
								attr_value = _tmp85_;
								_tmp87_ = self->priv->current;
								_tmp88_ = self->priv->end;
								if (_tmp87_ >= _tmp88_) {
									_tmp86_ = TRUE;
								} else {
									gchar* _tmp89_;
									gchar _tmp90_;
									_tmp89_ = self->priv->current;
									_tmp90_ = _tmp89_[0];
									_tmp86_ = _tmp90_ != '"';
								}
								if (_tmp86_) {
								}
								_tmp91_ = self->priv->current;
								self->priv->current = _tmp91_ + 1;
								_tmp92_ = self->priv->attributes;
								_tmp93_ = attr_name;
								_tmp94_ = attr_value;
								vala_map_set (_tmp92_, _tmp93_, _tmp94_);
								valadoc_markup_reader_space (self);
								_g_free0 (attr_value);
								_g_free0 (attr_name);
							}
							_tmp95_ = self->priv->current;
							_tmp96_ = _tmp95_[0];
							if (_tmp96_ == '/') {
								gchar* _tmp97_;
								self->priv->empty_element = TRUE;
								_tmp97_ = self->priv->current;
								self->priv->current = _tmp97_ + 1;
								valadoc_markup_reader_space (self);
							} else {
								self->priv->empty_element = FALSE;
							}
							_tmp99_ = self->priv->current;
							_tmp100_ = self->priv->end;
							if (_tmp99_ >= _tmp100_) {
								_tmp98_ = TRUE;
							} else {
								gchar* _tmp101_;
								gchar _tmp102_;
								_tmp101_ = self->priv->current;
								_tmp102_ = _tmp101_[0];
								_tmp98_ = _tmp102_ != '>';
							}
							if (_tmp98_) {
							}
							_tmp103_ = self->priv->current;
							self->priv->current = _tmp103_ + 1;
						}
					}
				}
			}
		} else {
			gchar* _tmp104_;
			gchar _tmp105_;
			valadoc_markup_reader_space (self);
			_tmp104_ = self->priv->current;
			_tmp105_ = _tmp104_[0];
			if (_tmp105_ != '<') {
				gchar* _tmp106_;
				gchar* _tmp107_;
				_tmp106_ = valadoc_markup_reader_text (self, '<', TRUE);
				_tmp107_ = _tmp106_;
				valadoc_markup_reader_set_content (self, _tmp107_);
				_g_free0 (_tmp107_);
			} else {
				ValadocMarkupSourceLocation _tmp108_ = {0};
				ValadocMarkupSourceLocation _tmp109_ = {0};
				ValadocMarkupTokenType _tmp110_;
				_tmp110_ = valadoc_markup_reader_read_token (self, &_tmp108_, &_tmp109_);
				_vala_token_begin = _tmp108_;
				_vala_token_end = _tmp109_;
				result = _tmp110_;
				if (token_begin) {
					*token_begin = _vala_token_begin;
				}
				if (token_end) {
					*token_end = _vala_token_end;
				}
				return result;
			}
			type = VALADOC_MARKUP_TOKEN_TYPE_TEXT;
		}
	}
	_tmp111_ = self->priv->current;
	_tmp112_ = self->priv->line;
	_tmp113_ = self->priv->column;
	valadoc_markup_source_location_init (&_vala_token_end, _tmp111_, _tmp112_, _tmp113_ - 1);
	result = type;
	if (token_begin) {
		*token_begin = _vala_token_begin;
	}
	if (token_end) {
		*token_end = _vala_token_end;
	}
	return result;
}


static gchar*
valadoc_markup_reader_text (ValadocMarkupReader* self,
                            gchar end_char,
                            gboolean rm_trailing_whitespace)
{
	gchar* result = NULL;
	GString* content = NULL;
	GString* _tmp0_;
	gchar* text_begin = NULL;
	gchar* _tmp1_;
	gchar* last_linebreak = NULL;
	gchar* _tmp2_;
	gchar* _tmp88_;
	gchar* _tmp89_;
	gint _tmp96_;
	gchar* _tmp97_;
	gchar* _tmp98_;
	GString* _tmp116_;
	const gchar* _tmp117_;
	gchar* _tmp118_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	content = _tmp0_;
	_tmp1_ = self->priv->current;
	text_begin = _tmp1_;
	_tmp2_ = self->priv->current;
	last_linebreak = _tmp2_;
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gunichar u = 0U;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gunichar _tmp11_;
		_tmp4_ = self->priv->current;
		_tmp5_ = self->priv->end;
		if (_tmp4_ < _tmp5_) {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[0];
			_tmp3_ = _tmp7_ != end_char;
		} else {
			_tmp3_ = FALSE;
		}
		if (!_tmp3_) {
			break;
		}
		_tmp8_ = self->priv->current;
		_tmp9_ = self->priv->end;
		_tmp10_ = self->priv->current;
		u = g_utf8_get_char_validated ((const gchar*) _tmp8_, (gssize) ((glong) (_tmp9_ - _tmp10_)));
		_tmp11_ = u;
		if (_tmp11_ == ((gunichar) -1)) {
			ValadocErrorReporter* _tmp12_;
			const gchar* _tmp13_;
			gint _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp12_ = self->priv->reporter;
			_tmp13_ = self->priv->_filename;
			_tmp14_ = self->priv->line;
			_tmp15_ = g_strdup_printf ("%s:%d", _tmp13_, _tmp14_);
			_tmp16_ = _tmp15_;
			valadoc_error_reporter_simple_error (_tmp12_, _tmp16_, "invalid UTF-8 character");
			_g_free0 (_tmp16_);
		} else {
			gunichar _tmp17_;
			_tmp17_ = u;
			if (_tmp17_ == ((gunichar) '&')) {
				gchar* next_pos = NULL;
				gchar* _tmp18_;
				gunichar _tmp19_;
				gchar* _tmp20_;
				_tmp18_ = self->priv->current;
				_tmp19_ = u;
				next_pos = _tmp18_ + g_unichar_to_utf8 (_tmp19_, NULL);
				_tmp20_ = next_pos;
				if (g_str_has_prefix ((const gchar*) _tmp20_, "amp;")) {
					GString* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					GString* _tmp27_;
					gchar* _tmp28_;
					gchar* _tmp29_;
					_tmp21_ = content;
					_tmp22_ = text_begin;
					_tmp23_ = self->priv->current;
					_tmp24_ = text_begin;
					_tmp25_ = string_substring ((const gchar*) _tmp22_, (glong) 0, (glong) ((gint) (_tmp23_ - _tmp24_)));
					_tmp26_ = _tmp25_;
					g_string_append (_tmp21_, _tmp26_);
					_g_free0 (_tmp26_);
					_tmp27_ = content;
					g_string_append_c (_tmp27_, '&');
					_tmp28_ = self->priv->current;
					self->priv->current = _tmp28_ + 5;
					_tmp29_ = self->priv->current;
					text_begin = _tmp29_;
				} else {
					gchar* _tmp30_;
					_tmp30_ = next_pos;
					if (g_str_has_prefix ((const gchar*) _tmp30_, "quot;")) {
						GString* _tmp31_;
						gchar* _tmp32_;
						gchar* _tmp33_;
						gchar* _tmp34_;
						gchar* _tmp35_;
						gchar* _tmp36_;
						GString* _tmp37_;
						gchar* _tmp38_;
						gchar* _tmp39_;
						_tmp31_ = content;
						_tmp32_ = text_begin;
						_tmp33_ = self->priv->current;
						_tmp34_ = text_begin;
						_tmp35_ = string_substring ((const gchar*) _tmp32_, (glong) 0, (glong) ((gint) (_tmp33_ - _tmp34_)));
						_tmp36_ = _tmp35_;
						g_string_append (_tmp31_, _tmp36_);
						_g_free0 (_tmp36_);
						_tmp37_ = content;
						g_string_append_c (_tmp37_, '"');
						_tmp38_ = self->priv->current;
						self->priv->current = _tmp38_ + 6;
						_tmp39_ = self->priv->current;
						text_begin = _tmp39_;
					} else {
						gchar* _tmp40_;
						_tmp40_ = next_pos;
						if (g_str_has_prefix ((const gchar*) _tmp40_, "apos;")) {
							GString* _tmp41_;
							gchar* _tmp42_;
							gchar* _tmp43_;
							gchar* _tmp44_;
							gchar* _tmp45_;
							gchar* _tmp46_;
							GString* _tmp47_;
							gchar* _tmp48_;
							gchar* _tmp49_;
							_tmp41_ = content;
							_tmp42_ = text_begin;
							_tmp43_ = self->priv->current;
							_tmp44_ = text_begin;
							_tmp45_ = string_substring ((const gchar*) _tmp42_, (glong) 0, (glong) ((gint) (_tmp43_ - _tmp44_)));
							_tmp46_ = _tmp45_;
							g_string_append (_tmp41_, _tmp46_);
							_g_free0 (_tmp46_);
							_tmp47_ = content;
							g_string_append_c (_tmp47_, '\'');
							_tmp48_ = self->priv->current;
							self->priv->current = _tmp48_ + 6;
							_tmp49_ = self->priv->current;
							text_begin = _tmp49_;
						} else {
							gchar* _tmp50_;
							_tmp50_ = next_pos;
							if (g_str_has_prefix ((const gchar*) _tmp50_, "lt;")) {
								GString* _tmp51_;
								gchar* _tmp52_;
								gchar* _tmp53_;
								gchar* _tmp54_;
								gchar* _tmp55_;
								gchar* _tmp56_;
								GString* _tmp57_;
								gchar* _tmp58_;
								gchar* _tmp59_;
								_tmp51_ = content;
								_tmp52_ = text_begin;
								_tmp53_ = self->priv->current;
								_tmp54_ = text_begin;
								_tmp55_ = string_substring ((const gchar*) _tmp52_, (glong) 0, (glong) ((gint) (_tmp53_ - _tmp54_)));
								_tmp56_ = _tmp55_;
								g_string_append (_tmp51_, _tmp56_);
								_g_free0 (_tmp56_);
								_tmp57_ = content;
								g_string_append_c (_tmp57_, '<');
								_tmp58_ = self->priv->current;
								self->priv->current = _tmp58_ + 4;
								_tmp59_ = self->priv->current;
								text_begin = _tmp59_;
							} else {
								gchar* _tmp60_;
								_tmp60_ = next_pos;
								if (g_str_has_prefix ((const gchar*) _tmp60_, "gt;")) {
									GString* _tmp61_;
									gchar* _tmp62_;
									gchar* _tmp63_;
									gchar* _tmp64_;
									gchar* _tmp65_;
									gchar* _tmp66_;
									GString* _tmp67_;
									gchar* _tmp68_;
									gchar* _tmp69_;
									_tmp61_ = content;
									_tmp62_ = text_begin;
									_tmp63_ = self->priv->current;
									_tmp64_ = text_begin;
									_tmp65_ = string_substring ((const gchar*) _tmp62_, (glong) 0, (glong) ((gint) (_tmp63_ - _tmp64_)));
									_tmp66_ = _tmp65_;
									g_string_append (_tmp61_, _tmp66_);
									_g_free0 (_tmp66_);
									_tmp67_ = content;
									g_string_append_c (_tmp67_, '>');
									_tmp68_ = self->priv->current;
									self->priv->current = _tmp68_ + 4;
									_tmp69_ = self->priv->current;
									text_begin = _tmp69_;
								} else {
									gchar* _tmp70_;
									_tmp70_ = next_pos;
									if (g_str_has_prefix ((const gchar*) _tmp70_, "percnt;")) {
										GString* _tmp71_;
										gchar* _tmp72_;
										gchar* _tmp73_;
										gchar* _tmp74_;
										gchar* _tmp75_;
										gchar* _tmp76_;
										GString* _tmp77_;
										gchar* _tmp78_;
										gchar* _tmp79_;
										_tmp71_ = content;
										_tmp72_ = text_begin;
										_tmp73_ = self->priv->current;
										_tmp74_ = text_begin;
										_tmp75_ = string_substring ((const gchar*) _tmp72_, (glong) 0, (glong) ((gint) (_tmp73_ - _tmp74_)));
										_tmp76_ = _tmp75_;
										g_string_append (_tmp71_, _tmp76_);
										_g_free0 (_tmp76_);
										_tmp77_ = content;
										g_string_append_c (_tmp77_, '%');
										_tmp78_ = self->priv->current;
										self->priv->current = _tmp78_ + 8;
										_tmp79_ = self->priv->current;
										text_begin = _tmp79_;
									} else {
										gchar* _tmp80_;
										gunichar _tmp81_;
										_tmp80_ = self->priv->current;
										_tmp81_ = u;
										self->priv->current = _tmp80_ + g_unichar_to_utf8 (_tmp81_, NULL);
									}
								}
							}
						}
					}
				}
			} else {
				gunichar _tmp82_;
				gchar* _tmp85_;
				gunichar _tmp86_;
				gint _tmp87_;
				_tmp82_ = u;
				if (_tmp82_ == ((gunichar) '\n')) {
					gint _tmp83_;
					gchar* _tmp84_;
					_tmp83_ = self->priv->line;
					self->priv->line = _tmp83_ + 1;
					self->priv->column = 0;
					_tmp84_ = self->priv->current;
					last_linebreak = _tmp84_;
				}
				_tmp85_ = self->priv->current;
				_tmp86_ = u;
				self->priv->current = _tmp85_ + g_unichar_to_utf8 (_tmp86_, NULL);
				_tmp87_ = self->priv->column;
				self->priv->column = _tmp87_ + 1;
			}
		}
	}
	_tmp88_ = text_begin;
	_tmp89_ = self->priv->current;
	if (_tmp88_ != _tmp89_) {
		GString* _tmp90_;
		gchar* _tmp91_;
		gchar* _tmp92_;
		gchar* _tmp93_;
		gchar* _tmp94_;
		gchar* _tmp95_;
		_tmp90_ = content;
		_tmp91_ = text_begin;
		_tmp92_ = self->priv->current;
		_tmp93_ = text_begin;
		_tmp94_ = string_substring ((const gchar*) _tmp91_, (glong) 0, (glong) ((gint) (_tmp92_ - _tmp93_)));
		_tmp95_ = _tmp94_;
		g_string_append (_tmp90_, _tmp95_);
		_g_free0 (_tmp95_);
	}
	_tmp96_ = self->priv->column;
	_tmp97_ = self->priv->current;
	_tmp98_ = last_linebreak;
	self->priv->column = _tmp96_ + ((gint) (_tmp97_ - _tmp98_));
	if (rm_trailing_whitespace) {
		gchar* str_pos = NULL;
		GString* _tmp99_;
		const gchar* _tmp100_;
		GString* _tmp101_;
		gssize _tmp102_;
		GString* _tmp112_;
		gchar* _tmp113_;
		GString* _tmp114_;
		const gchar* _tmp115_;
		_tmp99_ = content;
		_tmp100_ = _tmp99_->str;
		_tmp101_ = content;
		_tmp102_ = _tmp101_->len;
		str_pos = ((gchar*) _tmp100_) + _tmp102_;
		{
			gchar* _tmp103_;
			gboolean _tmp104_ = FALSE;
			_tmp103_ = str_pos;
			str_pos = _tmp103_ - 1;
			_tmp104_ = TRUE;
			while (TRUE) {
				gboolean _tmp106_ = FALSE;
				gchar* _tmp107_;
				GString* _tmp108_;
				const gchar* _tmp109_;
				if (!_tmp104_) {
					gchar* _tmp105_;
					_tmp105_ = str_pos;
					str_pos = _tmp105_ - 1;
				}
				_tmp104_ = FALSE;
				_tmp107_ = str_pos;
				_tmp108_ = content;
				_tmp109_ = _tmp108_->str;
				if (_tmp107_ > ((gchar*) _tmp109_)) {
					gchar* _tmp110_;
					gchar _tmp111_;
					_tmp110_ = str_pos;
					_tmp111_ = _tmp110_[0];
					_tmp106_ = g_ascii_isspace (_tmp111_);
				} else {
					_tmp106_ = FALSE;
				}
				if (!_tmp106_) {
					break;
				}
			}
		}
		_tmp112_ = content;
		_tmp113_ = str_pos;
		_tmp114_ = content;
		_tmp115_ = _tmp114_->str;
		g_string_erase (_tmp112_, (gssize) ((_tmp113_ - ((gchar*) _tmp115_)) + 1), (gssize) -1);
	}
	_tmp116_ = content;
	_tmp117_ = _tmp116_->str;
	_tmp118_ = g_strdup (_tmp117_);
	result = _tmp118_;
	_g_string_free0 (content);
	return result;
}


static void
valadoc_markup_reader_space (ValadocMarkupReader* self)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp5_;
		gchar _tmp6_;
		gchar* _tmp8_;
		gint _tmp9_;
		_tmp1_ = self->priv->current;
		_tmp2_ = self->priv->end;
		if (_tmp1_ < _tmp2_) {
			gchar* _tmp3_;
			gchar _tmp4_;
			_tmp3_ = self->priv->current;
			_tmp4_ = _tmp3_[0];
			_tmp0_ = g_ascii_isspace (_tmp4_);
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp5_ = self->priv->current;
		_tmp6_ = _tmp5_[0];
		if (_tmp6_ == '\n') {
			gint _tmp7_;
			_tmp7_ = self->priv->line;
			self->priv->line = _tmp7_ + 1;
			self->priv->column = 0;
		}
		_tmp8_ = self->priv->current;
		self->priv->current = _tmp8_ + 1;
		_tmp9_ = self->priv->column;
		self->priv->column = _tmp9_ + 1;
	}
}


const gchar*
valadoc_markup_reader_get_filename (ValadocMarkupReader* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_filename;
	result = _tmp0_;
	return result;
}


static void
valadoc_markup_reader_set_filename (ValadocMarkupReader* self,
                                    const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, valadoc_markup_reader_get_filename (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_filename);
		self->priv->_filename = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_markup_reader_properties[VALADOC_MARKUP_READER_FILENAME_PROPERTY]);
	}
}


const gchar*
valadoc_markup_reader_get_name (ValadocMarkupReader* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


static void
valadoc_markup_reader_set_name (ValadocMarkupReader* self,
                                const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, valadoc_markup_reader_get_name (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_markup_reader_properties[VALADOC_MARKUP_READER_NAME_PROPERTY]);
	}
}


const gchar*
valadoc_markup_reader_get_content (ValadocMarkupReader* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_content;
	result = _tmp0_;
	return result;
}


static void
valadoc_markup_reader_set_content (ValadocMarkupReader* self,
                                   const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, valadoc_markup_reader_get_content (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_content);
		self->priv->_content = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_markup_reader_properties[VALADOC_MARKUP_READER_CONTENT_PROPERTY]);
	}
}


static void
valadoc_markup_reader_class_init (ValadocMarkupReaderClass * klass)
{
	valadoc_markup_reader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValadocMarkupReaderPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_valadoc_markup_reader_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_valadoc_markup_reader_set_property;
	G_OBJECT_CLASS (klass)->finalize = valadoc_markup_reader_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_MARKUP_READER_FILENAME_PROPERTY, valadoc_markup_reader_properties[VALADOC_MARKUP_READER_FILENAME_PROPERTY] = g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_MARKUP_READER_NAME_PROPERTY, valadoc_markup_reader_properties[VALADOC_MARKUP_READER_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_MARKUP_READER_CONTENT_PROPERTY, valadoc_markup_reader_properties[VALADOC_MARKUP_READER_CONTENT_PROPERTY] = g_param_spec_string ("content", "content", "content", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void
valadoc_markup_reader_instance_init (ValadocMarkupReader * self)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	self->priv = VALADOC_MARKUP_READER_GET_PRIVATE (self);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp0_, _tmp1_, _tmp2_);
	self->priv->attributes = (ValaMap*) _tmp3_;
}


static void
valadoc_markup_reader_finalize (GObject * obj)
{
	ValadocMarkupReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_TYPE_MARKUP_READER, ValadocMarkupReader);
	_g_free0 (self->priv->_filename);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_content);
	_g_mapped_file_unref0 (self->priv->mapped_file);
	self->priv->lines = (_vala_array_free (self->priv->lines, self->priv->lines_length1, (GDestroyNotify) g_free), NULL);
	_vala_map_unref0 (self->priv->attributes);
	_g_object_unref0 (self->priv->reporter);
	G_OBJECT_CLASS (valadoc_markup_reader_parent_class)->finalize (obj);
}


/**
 * Simple reader for a subset of XML.
 */
GType
valadoc_markup_reader_get_type (void)
{
	static volatile gsize valadoc_markup_reader_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_markup_reader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValadocMarkupReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_markup_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocMarkupReader), 0, (GInstanceInitFunc) valadoc_markup_reader_instance_init, NULL };
		GType valadoc_markup_reader_type_id;
		valadoc_markup_reader_type_id = g_type_register_static (G_TYPE_OBJECT, "ValadocMarkupReader", &g_define_type_info, 0);
		g_once_init_leave (&valadoc_markup_reader_type_id__volatile, valadoc_markup_reader_type_id);
	}
	return valadoc_markup_reader_type_id__volatile;
}


static void
_vala_valadoc_markup_reader_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	ValadocMarkupReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_TYPE_MARKUP_READER, ValadocMarkupReader);
	switch (property_id) {
		case VALADOC_MARKUP_READER_FILENAME_PROPERTY:
		g_value_set_string (value, valadoc_markup_reader_get_filename (self));
		break;
		case VALADOC_MARKUP_READER_NAME_PROPERTY:
		g_value_set_string (value, valadoc_markup_reader_get_name (self));
		break;
		case VALADOC_MARKUP_READER_CONTENT_PROPERTY:
		g_value_set_string (value, valadoc_markup_reader_get_content (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_valadoc_markup_reader_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	ValadocMarkupReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_TYPE_MARKUP_READER, ValadocMarkupReader);
	switch (property_id) {
		case VALADOC_MARKUP_READER_FILENAME_PROPERTY:
		valadoc_markup_reader_set_filename (self, g_value_get_string (value));
		break;
		case VALADOC_MARKUP_READER_NAME_PROPERTY:
		valadoc_markup_reader_set_name (self, g_value_get_string (value));
		break;
		case VALADOC_MARKUP_READER_CONTENT_PROPERTY:
		valadoc_markup_reader_set_content (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



