/* valavapigen.c generated by valac, the Vala compiler
 * generated from valavapigen.vala, do not modify */

/* valavapigen.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <valagee.h>
#include <locale.h>
#include <version.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_VAPI_GEN (vala_vapi_gen_get_type ())
#define VALA_VAPI_GEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VAPI_GEN, ValaVAPIGen))
#define VALA_VAPI_GEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VAPI_GEN, ValaVAPIGenClass))
#define VALA_IS_VAPI_GEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VAPI_GEN))
#define VALA_IS_VAPI_GEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VAPI_GEN))
#define VALA_VAPI_GEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VAPI_GEN, ValaVAPIGenClass))

typedef struct _ValaVAPIGen ValaVAPIGen;
typedef struct _ValaVAPIGenClass ValaVAPIGenClass;
typedef struct _ValaVAPIGenPrivate ValaVAPIGenPrivate;
enum  {
	VALA_VAPI_GEN_0_PROPERTY,
	VALA_VAPI_GEN_NUM_PROPERTIES
};
static GParamSpec* vala_vapi_gen_properties[VALA_VAPI_GEN_NUM_PROPERTIES];
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

#define VALA_TYPE_GIDL_PARSER (vala_gidl_parser_get_type ())
#define VALA_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParser))
#define VALA_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))
#define VALA_IS_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GIDL_PARSER))
#define VALA_IS_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GIDL_PARSER))
#define VALA_GIDL_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))

typedef struct _ValaGIdlParser ValaGIdlParser;
typedef struct _ValaGIdlParserClass ValaGIdlParserClass;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_vapi_gen_unref0(var) ((var == NULL) ? NULL : (var = (vala_vapi_gen_unref (var), NULL)))
typedef struct _ValaParamSpecVAPIGen ValaParamSpecVAPIGen;

struct _ValaVAPIGen {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaVAPIGenPrivate * priv;
};

struct _ValaVAPIGenClass {
	GTypeClass parent_class;
	void (*finalize) (ValaVAPIGen *self);
};

struct _ValaVAPIGenPrivate {
	ValaCodeContext* context;
};

struct _ValaParamSpecVAPIGen {
	GParamSpec parent_instance;
};


static gpointer vala_vapi_gen_parent_class = NULL;
static gchar* vala_vapi_gen_directory;
static gchar* vala_vapi_gen_directory = NULL;
static gboolean vala_vapi_gen_version;
static gboolean vala_vapi_gen_version = FALSE;
static gboolean vala_vapi_gen_quiet_mode;
static gboolean vala_vapi_gen_quiet_mode = FALSE;
static gboolean vala_vapi_gen_disable_warnings;
static gboolean vala_vapi_gen_disable_warnings = FALSE;
static gchar** vala_vapi_gen_sources;
static gchar** vala_vapi_gen_sources = NULL;
static gchar** vala_vapi_gen_vapi_directories;
static gchar** vala_vapi_gen_vapi_directories = NULL;
static gchar** vala_vapi_gen_gir_directories;
static gchar** vala_vapi_gen_gir_directories = NULL;
static gchar** vala_vapi_gen_metadata_directories;
static gchar** vala_vapi_gen_metadata_directories = NULL;
static gchar* vala_vapi_gen_library;
static gchar* vala_vapi_gen_library = NULL;
static gchar** vala_vapi_gen_packages;
static gchar** vala_vapi_gen_packages = NULL;
static gboolean vala_vapi_gen_nostdpkg;
static gboolean vala_vapi_gen_nostdpkg = FALSE;

G_GNUC_INTERNAL gpointer vala_vapi_gen_ref (gpointer instance);
G_GNUC_INTERNAL void vala_vapi_gen_unref (gpointer instance);
G_GNUC_INTERNAL GParamSpec* vala_param_spec_vapi_gen (const gchar* name, 
                                      const gchar* nick, 
                                      const gchar* blurb, 
                                      GType object_type, 
                                      GParamFlags flags);
G_GNUC_INTERNAL void vala_value_set_vapi_gen (GValue* value, 
                              gpointer v_object) G_GNUC_UNUSED;
G_GNUC_INTERNAL void vala_value_take_vapi_gen (GValue* value, 
                               gpointer v_object);
G_GNUC_INTERNAL gpointer vala_value_get_vapi_gen (const GValue* value) G_GNUC_UNUSED;
G_GNUC_INTERNAL GType vala_vapi_gen_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define VALA_VAPI_GEN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_VAPI_GEN, ValaVAPIGenPrivate))
static gint vala_vapi_gen_quit (ValaVAPIGen* self);
static gint vala_vapi_gen_run (ValaVAPIGen* self);
GType vala_gidl_parser_get_type (void) G_GNUC_CONST;
ValaGIdlParser* vala_gidl_parser_new (void);
ValaGIdlParser* vala_gidl_parser_construct (GType object_type);
void vala_gidl_parser_parse (ValaGIdlParser* self, 
                             ValaCodeContext* context);
static gboolean _vala_string_array_contains (gchar* * stack, 
                                      int stack_length, 
                                      gchar* needle);
static gint vala_vapi_gen_main (gchar** args, 
                         int args_length1);
G_GNUC_INTERNAL ValaVAPIGen* vala_vapi_gen_new (void);
G_GNUC_INTERNAL ValaVAPIGen* vala_vapi_gen_construct (GType object_type);
static void vala_vapi_gen_finalize (ValaVAPIGen * obj);
static void _vala_array_destroy (gpointer array, 
                          gint array_length, 
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, 
                       gint array_length, 
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry VALA_VAPI_GEN_options[12] = {{"vapidir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"girdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_gir_directories, "Look for GIR bindings in DIRECTORY", "DIRECTORY..."}, {"metadatadir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_metadata_directories, "Look for GIR .metadata files in DIRECTORY", "DIRECTORY..."}, {"nostdpkg", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_vapi_gen_nostdpkg, "Do not include standard packages", NULL}, {"pkg", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_vapi_gen_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_vapi_gen_library, "Library name", "NAME"}, {"directory", 'd', 0, G_OPTION_ARG_FILENAME, &vala_vapi_gen_directory, "Output directory", "DIRECTORY"}, {"disable-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_vapi_gen_disable_warnings, "Disable warnings", NULL}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_vapi_gen_version, "Display version number", NULL}, {"quiet", 'q', 0, G_OPTION_ARG_NONE, &vala_vapi_gen_quiet_mode, "Do not print messages to the console", NULL}, {G_OPTION_REMAINING, (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_sources, NULL, "FILE..."}, {NULL}};

static gint
vala_vapi_gen_quit (ValaVAPIGen* self)
{
	gint result = 0;
	ValaCodeContext* _tmp0_;
	ValaReport* _tmp1_;
	ValaReport* _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->context;
	_tmp1_ = vala_code_context_get_report (_tmp0_);
	_tmp2_ = _tmp1_;
	if (vala_report_get_errors (_tmp2_) == 0) {
		gboolean _tmp3_;
		_tmp3_ = vala_vapi_gen_quiet_mode;
		if (!_tmp3_) {
			FILE* _tmp4_;
			ValaCodeContext* _tmp5_;
			ValaReport* _tmp6_;
			ValaReport* _tmp7_;
			_tmp4_ = stdout;
			_tmp5_ = self->priv->context;
			_tmp6_ = vala_code_context_get_report (_tmp5_);
			_tmp7_ = _tmp6_;
			fprintf (_tmp4_, "Generation succeeded - %d warning(s)\n", vala_report_get_warnings (_tmp7_));
		}
		result = 0;
		return result;
	} else {
		gboolean _tmp8_;
		_tmp8_ = vala_vapi_gen_quiet_mode;
		if (!_tmp8_) {
			FILE* _tmp9_;
			ValaCodeContext* _tmp10_;
			ValaReport* _tmp11_;
			ValaReport* _tmp12_;
			ValaCodeContext* _tmp13_;
			ValaReport* _tmp14_;
			ValaReport* _tmp15_;
			_tmp9_ = stdout;
			_tmp10_ = self->priv->context;
			_tmp11_ = vala_code_context_get_report (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = self->priv->context;
			_tmp14_ = vala_code_context_get_report (_tmp13_);
			_tmp15_ = _tmp14_;
			fprintf (_tmp9_, "Generation failed: %d error(s), %d warning(s)\n", vala_report_get_errors (_tmp12_), vala_report_get_warnings (_tmp15_));
		}
		result = 1;
		return result;
	}
}


static glong
string_strnlen (gchar* str, 
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self, 
                  glong offset, 
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static gboolean
_vala_string_array_contains (gchar* * stack, 
                             int stack_length, 
                             gchar* needle)
{
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static gint
vala_vapi_gen_run (ValaVAPIGen* self)
{
	gint result = 0;
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	ValaCodeContext* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	ValaCodeContext* _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	ValaCodeContext* _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	ValaCodeContext* _tmp8_;
	ValaReport* _tmp9_;
	ValaReport* _tmp10_;
	gboolean _tmp11_;
	ValaCodeContext* _tmp12_;
	ValaReport* _tmp13_;
	ValaReport* _tmp14_;
	gboolean _tmp15_;
	ValaCodeContext* _tmp16_;
	ValaCodeContext* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	ValaCodeContext* _tmp22_;
	ValaReport* _tmp23_;
	ValaReport* _tmp24_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	ValaCodeContext* _tmp40_;
	ValaReport* _tmp41_;
	ValaReport* _tmp42_;
	const gchar* _tmp43_;
	ValaCodeContext* _tmp48_;
	ValaReport* _tmp49_;
	ValaReport* _tmp50_;
	gchar** _tmp51_;
	gint _tmp51__length1;
	ValaCodeContext* _tmp56_;
	ValaReport* _tmp57_;
	ValaReport* _tmp58_;
	gchar** _tmp59_;
	gint _tmp59__length1;
	ValaCodeContext* _tmp71_;
	ValaReport* _tmp72_;
	ValaReport* _tmp73_;
	ValaParser* parser = NULL;
	ValaParser* _tmp74_;
	ValaParser* _tmp75_;
	ValaCodeContext* _tmp76_;
	ValaCodeContext* _tmp77_;
	ValaReport* _tmp78_;
	ValaReport* _tmp79_;
	ValaGirParser* girparser = NULL;
	ValaGirParser* _tmp80_;
	ValaGirParser* _tmp81_;
	ValaCodeContext* _tmp82_;
	ValaCodeContext* _tmp83_;
	ValaReport* _tmp84_;
	ValaReport* _tmp85_;
	ValaGIdlParser* gidlparser = NULL;
	ValaGIdlParser* _tmp86_;
	ValaGIdlParser* _tmp87_;
	ValaCodeContext* _tmp88_;
	ValaCodeContext* _tmp89_;
	ValaReport* _tmp90_;
	ValaReport* _tmp91_;
	ValaCodeContext* _tmp92_;
	ValaCodeContext* _tmp93_;
	ValaReport* _tmp94_;
	ValaReport* _tmp95_;
	ValaCodeWriter* interface_writer = NULL;
	ValaCodeWriter* _tmp140_;
	gchar* vapi_filename = NULL;
	const gchar* _tmp141_;
	gchar* _tmp142_;
	const gchar* _tmp143_;
	ValaCodeWriter* _tmp147_;
	ValaCodeContext* _tmp148_;
	const gchar* _tmp149_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_context_new ();
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = self->priv->context;
	vala_code_context_set_profile (_tmp1_, VALA_PROFILE_GOBJECT);
	_tmp2_ = self->priv->context;
	_tmp3_ = vala_vapi_gen_vapi_directories;
	_tmp3__length1 = _vala_array_length (vala_vapi_gen_vapi_directories);
	vala_code_context_set_vapi_directories (_tmp2_, _tmp3_, _tmp3__length1);
	_tmp4_ = self->priv->context;
	_tmp5_ = vala_vapi_gen_gir_directories;
	_tmp5__length1 = _vala_array_length (vala_vapi_gen_gir_directories);
	vala_code_context_set_gir_directories (_tmp4_, _tmp5_, _tmp5__length1);
	_tmp6_ = self->priv->context;
	_tmp7_ = vala_vapi_gen_metadata_directories;
	_tmp7__length1 = _vala_array_length (vala_vapi_gen_metadata_directories);
	vala_code_context_set_metadata_directories (_tmp6_, _tmp7_, _tmp7__length1);
	_tmp8_ = self->priv->context;
	_tmp9_ = vala_code_context_get_report (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_vapi_gen_disable_warnings;
	vala_report_set_enable_warnings (_tmp10_, !_tmp11_);
	_tmp12_ = self->priv->context;
	_tmp13_ = vala_code_context_get_report (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_vapi_gen_quiet_mode;
	vala_report_set_verbose_errors (_tmp14_, !_tmp15_);
	_tmp16_ = self->priv->context;
	vala_code_context_push (_tmp16_);
	_tmp17_ = self->priv->context;
	_tmp18_ = vala_vapi_gen_nostdpkg;
	vala_code_context_set_nostdpkg (_tmp17_, _tmp18_);
	_tmp19_ = vala_vapi_gen_nostdpkg;
	if (!_tmp19_) {
		ValaCodeContext* _tmp20_;
		ValaCodeContext* _tmp21_;
		_tmp20_ = self->priv->context;
		vala_code_context_add_external_package (_tmp20_, "glib-2.0");
		_tmp21_ = self->priv->context;
		vala_code_context_add_external_package (_tmp21_, "gobject-2.0");
	}
	_tmp22_ = self->priv->context;
	_tmp23_ = vala_code_context_get_report (_tmp22_);
	_tmp24_ = _tmp23_;
	if (vala_report_get_errors (_tmp24_) > 0) {
		result = vala_vapi_gen_quit (self);
		return result;
	}
	_tmp25_ = vala_vapi_gen_sources;
	_tmp25__length1 = _vala_array_length (vala_vapi_gen_sources);
	{
		gchar** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = _tmp25_;
		source_collection_length1 = _tmp25__length1;
		for (source_it = 0; source_it < _tmp25__length1; source_it = source_it + 1) {
			gchar* _tmp26_;
			gchar* source = NULL;
			_tmp26_ = g_strdup (source_collection[source_it]);
			source = _tmp26_;
			{
				const gchar* _tmp27_;
				gchar* depsfile = NULL;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				ValaCodeContext* _tmp38_;
				const gchar* _tmp39_;
				_tmp27_ = source;
				if (!g_str_has_suffix (_tmp27_, ".gi")) {
					_g_free0 (source);
					continue;
				}
				_tmp28_ = source;
				_tmp29_ = source;
				_tmp30_ = strlen (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = strlen ("gi");
				_tmp33_ = _tmp32_;
				_tmp34_ = string_substring (_tmp28_, (glong) 0, (glong) (_tmp31_ - _tmp33_));
				_tmp35_ = _tmp34_;
				_tmp36_ = g_strconcat (_tmp35_, "deps", NULL);
				_tmp37_ = _tmp36_;
				_g_free0 (_tmp35_);
				depsfile = _tmp37_;
				_tmp38_ = self->priv->context;
				_tmp39_ = depsfile;
				vala_code_context_add_packages_from_file (_tmp38_, _tmp39_);
				_g_free0 (depsfile);
				_g_free0 (source);
			}
		}
	}
	_tmp40_ = self->priv->context;
	_tmp41_ = vala_code_context_get_report (_tmp40_);
	_tmp42_ = _tmp41_;
	if (vala_report_get_errors (_tmp42_) > 0) {
		result = vala_vapi_gen_quit (self);
		return result;
	}
	_tmp43_ = vala_vapi_gen_library;
	if (_tmp43_ != NULL) {
		gchar* depsfile = NULL;
		const gchar* _tmp44_;
		gchar* _tmp45_;
		ValaCodeContext* _tmp46_;
		const gchar* _tmp47_;
		_tmp44_ = vala_vapi_gen_library;
		_tmp45_ = g_strconcat (_tmp44_, ".deps", NULL);
		depsfile = _tmp45_;
		_tmp46_ = self->priv->context;
		_tmp47_ = depsfile;
		vala_code_context_add_packages_from_file (_tmp46_, _tmp47_);
		_g_free0 (depsfile);
	} else {
		vala_report_error (NULL, "--library option must be specified");
	}
	_tmp48_ = self->priv->context;
	_tmp49_ = vala_code_context_get_report (_tmp48_);
	_tmp50_ = _tmp49_;
	if (vala_report_get_errors (_tmp50_) > 0) {
		result = vala_vapi_gen_quit (self);
		return result;
	}
	_tmp51_ = vala_vapi_gen_packages;
	_tmp51__length1 = _vala_array_length (vala_vapi_gen_packages);
	if (_tmp51_ != NULL) {
		gchar** _tmp52_;
		gint _tmp52__length1;
		_tmp52_ = vala_vapi_gen_packages;
		_tmp52__length1 = _vala_array_length (vala_vapi_gen_packages);
		{
			gchar** package_collection = NULL;
			gint package_collection_length1 = 0;
			gint _package_collection_size_ = 0;
			gint package_it = 0;
			package_collection = _tmp52_;
			package_collection_length1 = _tmp52__length1;
			for (package_it = 0; package_it < _tmp52__length1; package_it = package_it + 1) {
				gchar* _tmp53_;
				gchar* package = NULL;
				_tmp53_ = g_strdup (package_collection[package_it]);
				package = _tmp53_;
				{
					ValaCodeContext* _tmp54_;
					const gchar* _tmp55_;
					_tmp54_ = self->priv->context;
					_tmp55_ = package;
					vala_code_context_add_external_package (_tmp54_, _tmp55_);
					_g_free0 (package);
				}
			}
		}
		vala_vapi_gen_packages = (_vala_array_free (vala_vapi_gen_packages, _vala_array_length (vala_vapi_gen_packages), (GDestroyNotify) g_free), NULL);
		vala_vapi_gen_packages = NULL;
	}
	_tmp56_ = self->priv->context;
	_tmp57_ = vala_code_context_get_report (_tmp56_);
	_tmp58_ = _tmp57_;
	if (vala_report_get_errors (_tmp58_) > 0) {
		result = vala_vapi_gen_quit (self);
		return result;
	}
	_tmp59_ = vala_vapi_gen_sources;
	_tmp59__length1 = _vala_array_length (vala_vapi_gen_sources);
	{
		gchar** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = _tmp59_;
		source_collection_length1 = _tmp59__length1;
		for (source_it = 0; source_it < _tmp59__length1; source_it = source_it + 1) {
			gchar* _tmp60_;
			gchar* source = NULL;
			_tmp60_ = g_strdup (source_collection[source_it]);
			source = _tmp60_;
			{
				const gchar* _tmp61_;
				_tmp61_ = source;
				if (g_file_test (_tmp61_, G_FILE_TEST_EXISTS)) {
					ValaSourceFile* source_file = NULL;
					ValaCodeContext* _tmp62_;
					const gchar* _tmp63_;
					ValaSourceFile* _tmp64_;
					ValaSourceFile* _tmp65_;
					ValaCodeContext* _tmp66_;
					ValaSourceFile* _tmp67_;
					_tmp62_ = self->priv->context;
					_tmp63_ = source;
					_tmp64_ = vala_source_file_new (_tmp62_, VALA_SOURCE_FILE_TYPE_PACKAGE, _tmp63_, NULL, FALSE);
					source_file = _tmp64_;
					_tmp65_ = source_file;
					vala_source_file_set_explicit (_tmp65_, TRUE);
					_tmp66_ = self->priv->context;
					_tmp67_ = source_file;
					vala_code_context_add_source_file (_tmp66_, _tmp67_);
					_vala_source_file_unref0 (source_file);
				} else {
					const gchar* _tmp68_;
					gchar* _tmp69_;
					gchar* _tmp70_;
					_tmp68_ = source;
					_tmp69_ = g_strdup_printf ("%s not found", _tmp68_);
					_tmp70_ = _tmp69_;
					vala_report_error (NULL, _tmp70_);
					_g_free0 (_tmp70_);
				}
				_g_free0 (source);
			}
		}
	}
	_tmp71_ = self->priv->context;
	_tmp72_ = vala_code_context_get_report (_tmp71_);
	_tmp73_ = _tmp72_;
	if (vala_report_get_errors (_tmp73_) > 0) {
		result = vala_vapi_gen_quit (self);
		return result;
	}
	_tmp74_ = vala_parser_new ();
	parser = _tmp74_;
	_tmp75_ = parser;
	_tmp76_ = self->priv->context;
	vala_parser_parse (_tmp75_, _tmp76_);
	_tmp77_ = self->priv->context;
	_tmp78_ = vala_code_context_get_report (_tmp77_);
	_tmp79_ = _tmp78_;
	if (vala_report_get_errors (_tmp79_) > 0) {
		result = vala_vapi_gen_quit (self);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp80_ = vala_gir_parser_new ();
	girparser = _tmp80_;
	_tmp81_ = girparser;
	_tmp82_ = self->priv->context;
	vala_gir_parser_parse (_tmp81_, _tmp82_);
	_tmp83_ = self->priv->context;
	_tmp84_ = vala_code_context_get_report (_tmp83_);
	_tmp85_ = _tmp84_;
	if (vala_report_get_errors (_tmp85_) > 0) {
		result = vala_vapi_gen_quit (self);
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp86_ = vala_gidl_parser_new ();
	gidlparser = _tmp86_;
	_tmp87_ = gidlparser;
	_tmp88_ = self->priv->context;
	vala_gidl_parser_parse (_tmp87_, _tmp88_);
	_tmp89_ = self->priv->context;
	_tmp90_ = vala_code_context_get_report (_tmp89_);
	_tmp91_ = _tmp90_;
	if (vala_report_get_errors (_tmp91_) > 0) {
		result = vala_vapi_gen_quit (self);
		_vala_code_visitor_unref0 (gidlparser);
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp92_ = self->priv->context;
	vala_code_context_check (_tmp92_);
	_tmp93_ = self->priv->context;
	_tmp94_ = vala_code_context_get_report (_tmp93_);
	_tmp95_ = _tmp94_;
	if (vala_report_get_errors (_tmp95_) > 0) {
		result = vala_vapi_gen_quit (self);
		_vala_code_visitor_unref0 (gidlparser);
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	{
		ValaList* _file_list = NULL;
		ValaCodeContext* _tmp96_;
		ValaList* _tmp97_;
		gint _file_size = 0;
		ValaList* _tmp98_;
		gint _tmp99_;
		gint _tmp100_;
		gint _file_index = 0;
		_tmp96_ = self->priv->context;
		_tmp97_ = vala_code_context_get_source_files (_tmp96_);
		_file_list = _tmp97_;
		_tmp98_ = _file_list;
		_tmp99_ = vala_collection_get_size ((ValaCollection*) _tmp98_);
		_tmp100_ = _tmp99_;
		_file_size = _tmp100_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp101_;
			gint _tmp102_;
			gint _tmp103_;
			ValaSourceFile* file = NULL;
			ValaList* _tmp104_;
			gint _tmp105_;
			gpointer _tmp106_;
			ValaSourceFile* _tmp107_;
			const gchar* _tmp108_;
			const gchar* _tmp109_;
			ValaSourceFile* _tmp110_;
			const gchar* _tmp111_;
			const gchar* _tmp112_;
			gchar** _tmp113_;
			gint _tmp113__length1;
			_tmp101_ = _file_index;
			_file_index = _tmp101_ + 1;
			_tmp102_ = _file_index;
			_tmp103_ = _file_size;
			if (!(_tmp102_ < _tmp103_)) {
				break;
			}
			_tmp104_ = _file_list;
			_tmp105_ = _file_index;
			_tmp106_ = vala_list_get (_tmp104_, _tmp105_);
			file = (ValaSourceFile*) _tmp106_;
			_tmp107_ = file;
			_tmp108_ = vala_source_file_get_filename (_tmp107_);
			_tmp109_ = _tmp108_;
			if (g_str_has_suffix (_tmp109_, ".vapi")) {
				_vala_source_file_unref0 (file);
				continue;
			}
			_tmp110_ = file;
			_tmp111_ = vala_source_file_get_filename (_tmp110_);
			_tmp112_ = _tmp111_;
			_tmp113_ = vala_vapi_gen_sources;
			_tmp113__length1 = _vala_array_length (vala_vapi_gen_sources);
			if (_vala_string_array_contains (_tmp113_, _tmp113__length1, _tmp112_)) {
				ValaSourceFile* _tmp114_;
				ValaSourceFile* _tmp115_;
				const gchar* _tmp116_;
				const gchar* _tmp117_;
				_tmp114_ = file;
				vala_source_file_set_file_type (_tmp114_, VALA_SOURCE_FILE_TYPE_SOURCE);
				_tmp115_ = file;
				_tmp116_ = vala_source_file_get_filename (_tmp115_);
				_tmp117_ = _tmp116_;
				if (g_str_has_suffix (_tmp117_, ".gir")) {
					gchar* metadata_filename = NULL;
					ValaCodeContext* _tmp118_;
					ValaSourceFile* _tmp119_;
					const gchar* _tmp120_;
					const gchar* _tmp121_;
					gchar* _tmp122_;
					const gchar* _tmp123_;
					_tmp118_ = self->priv->context;
					_tmp119_ = file;
					_tmp120_ = vala_source_file_get_filename (_tmp119_);
					_tmp121_ = _tmp120_;
					_tmp122_ = vala_code_context_get_metadata_path (_tmp118_, _tmp121_);
					metadata_filename = _tmp122_;
					_tmp123_ = metadata_filename;
					if (_tmp123_ != NULL) {
						{
							ValaList* _metadata_file_list = NULL;
							ValaCodeContext* _tmp124_;
							ValaList* _tmp125_;
							gint _metadata_file_size = 0;
							ValaList* _tmp126_;
							gint _tmp127_;
							gint _tmp128_;
							gint _metadata_file_index = 0;
							_tmp124_ = self->priv->context;
							_tmp125_ = vala_code_context_get_source_files (_tmp124_);
							_metadata_file_list = _tmp125_;
							_tmp126_ = _metadata_file_list;
							_tmp127_ = vala_collection_get_size ((ValaCollection*) _tmp126_);
							_tmp128_ = _tmp127_;
							_metadata_file_size = _tmp128_;
							_metadata_file_index = -1;
							while (TRUE) {
								gint _tmp129_;
								gint _tmp130_;
								gint _tmp131_;
								ValaSourceFile* metadata_file = NULL;
								ValaList* _tmp132_;
								gint _tmp133_;
								gpointer _tmp134_;
								ValaSourceFile* _tmp135_;
								const gchar* _tmp136_;
								const gchar* _tmp137_;
								const gchar* _tmp138_;
								_tmp129_ = _metadata_file_index;
								_metadata_file_index = _tmp129_ + 1;
								_tmp130_ = _metadata_file_index;
								_tmp131_ = _metadata_file_size;
								if (!(_tmp130_ < _tmp131_)) {
									break;
								}
								_tmp132_ = _metadata_file_list;
								_tmp133_ = _metadata_file_index;
								_tmp134_ = vala_list_get (_tmp132_, _tmp133_);
								metadata_file = (ValaSourceFile*) _tmp134_;
								_tmp135_ = metadata_file;
								_tmp136_ = vala_source_file_get_filename (_tmp135_);
								_tmp137_ = _tmp136_;
								_tmp138_ = metadata_filename;
								if (g_strcmp0 (_tmp137_, _tmp138_) == 0) {
									ValaSourceFile* _tmp139_;
									_tmp139_ = metadata_file;
									vala_source_file_set_file_type (_tmp139_, VALA_SOURCE_FILE_TYPE_SOURCE);
								}
								_vala_source_file_unref0 (metadata_file);
							}
							_vala_iterable_unref0 (_metadata_file_list);
						}
					}
					_g_free0 (metadata_filename);
				}
			}
			_vala_source_file_unref0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_tmp140_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_EXTERNAL);
	interface_writer = _tmp140_;
	_tmp141_ = vala_vapi_gen_library;
	_tmp142_ = g_strdup_printf ("%s.vapi", _tmp141_);
	vapi_filename = _tmp142_;
	_tmp143_ = vala_vapi_gen_directory;
	if (_tmp143_ != NULL) {
		const gchar* _tmp144_;
		const gchar* _tmp145_;
		gchar* _tmp146_;
		_tmp144_ = vala_vapi_gen_directory;
		_tmp145_ = vapi_filename;
		_tmp146_ = g_build_path ("/", _tmp144_, _tmp145_, NULL);
		_g_free0 (vapi_filename);
		vapi_filename = _tmp146_;
	}
	_tmp147_ = interface_writer;
	_tmp148_ = self->priv->context;
	_tmp149_ = vapi_filename;
	vala_code_writer_write_file (_tmp147_, _tmp148_, _tmp149_);
	_g_free0 (vala_vapi_gen_library);
	vala_vapi_gen_library = NULL;
	result = vala_vapi_gen_quit (self);
	_g_free0 (vapi_filename);
	_vala_code_visitor_unref0 (interface_writer);
	_vala_code_visitor_unref0 (gidlparser);
	_vala_code_visitor_unref0 (girparser);
	_vala_code_visitor_unref0 (parser);
	return result;
}


static gint
vala_vapi_gen_main (gchar** args, 
                    int args_length1)
{
	gint result = 0;
	gboolean _tmp11_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	ValaVAPIGen* vapigen = NULL;
	ValaVAPIGen* _tmp15_;
	ValaVAPIGen* _tmp16_;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp0_;
		GOptionContext* _tmp1_;
		GOptionContext* _tmp2_;
		GOptionContext* _tmp3_;
		_tmp0_ = g_option_context_new ("- Vala API Generator");
		opt_context = _tmp0_;
		_tmp1_ = opt_context;
		g_option_context_set_help_enabled (_tmp1_, TRUE);
		_tmp2_ = opt_context;
		g_option_context_add_main_entries (_tmp2_, VALA_VAPI_GEN_options, NULL);
		_tmp3_ = opt_context;
		g_option_context_parse (_tmp3_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp4_ = 0;
			_g_option_context_free0 (opt_context);
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch4_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp4_;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally4;
	__catch4_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		FILE* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = stdout;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		fprintf (_tmp5_, "%s\n", _tmp7_);
		_tmp8_ = stdout;
		_tmp9_ = args[0];
		fprintf (_tmp8_, "Run '%s --help' to see a full list of available command line options.\n", _tmp9_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp10_ = 0;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp10_;
	}
	_tmp11_ = vala_vapi_gen_version;
	if (_tmp11_) {
		FILE* _tmp12_;
		_tmp12_ = stdout;
		fprintf (_tmp12_, "Vala API Generator %s\n", BUILD_VERSION);
		result = 0;
		return result;
	}
	_tmp13_ = vala_vapi_gen_sources;
	_tmp13__length1 = _vala_array_length (vala_vapi_gen_sources);
	if (_tmp13_ == NULL) {
		FILE* _tmp14_;
		_tmp14_ = stderr;
		fprintf (_tmp14_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp15_ = vala_vapi_gen_new ();
	vapigen = _tmp15_;
	_tmp16_ = vapigen;
	result = vala_vapi_gen_run (_tmp16_);
	_vala_vapi_gen_unref0 (vapigen);
	return result;
}


int
main (int argc, 
      char ** argv)
{
	return vala_vapi_gen_main (argv, argc);
}


G_GNUC_INTERNAL ValaVAPIGen*
vala_vapi_gen_construct (GType object_type)
{
	ValaVAPIGen* self = NULL;
	self = (ValaVAPIGen*) g_type_create_instance (object_type);
	return self;
}


G_GNUC_INTERNAL ValaVAPIGen*
vala_vapi_gen_new (void)
{
	return vala_vapi_gen_construct (VALA_TYPE_VAPI_GEN);
}


static void
vala_value_vapi_gen_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
vala_value_vapi_gen_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_vapi_gen_unref (value->data[0].v_pointer);
	}
}


static void
vala_value_vapi_gen_copy_value (const GValue* src_value, 
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_vapi_gen_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
vala_value_vapi_gen_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
vala_value_vapi_gen_collect_value (GValue* value, 
                                   guint n_collect_values, 
                                   GTypeCValue* collect_values, 
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaVAPIGen * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_vapi_gen_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
vala_value_vapi_gen_lcopy_value (const GValue* value, 
                                 guint n_collect_values, 
                                 GTypeCValue* collect_values, 
                                 guint collect_flags)
{
	ValaVAPIGen ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_vapi_gen_ref (value->data[0].v_pointer);
	}
	return NULL;
}


G_GNUC_INTERNAL GParamSpec*
vala_param_spec_vapi_gen (const gchar* name, 
                          const gchar* nick, 
                          const gchar* blurb, 
                          GType object_type, 
                          GParamFlags flags)
{
	ValaParamSpecVAPIGen* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_VAPI_GEN), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


G_GNUC_INTERNAL gpointer
vala_value_get_vapi_gen (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_VAPI_GEN), NULL);
	return value->data[0].v_pointer;
}


G_GNUC_INTERNAL void
vala_value_set_vapi_gen (GValue* value, 
                         gpointer v_object)
{
	ValaVAPIGen * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_VAPI_GEN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_VAPI_GEN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_vapi_gen_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_vapi_gen_unref (old);
	}
}


G_GNUC_INTERNAL void
vala_value_take_vapi_gen (GValue* value, 
                          gpointer v_object)
{
	ValaVAPIGen * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_VAPI_GEN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_VAPI_GEN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_vapi_gen_unref (old);
	}
}


static void
vala_vapi_gen_class_init (ValaVAPIGenClass * klass)
{
	vala_vapi_gen_parent_class = g_type_class_peek_parent (klass);
	((ValaVAPIGenClass *) klass)->finalize = vala_vapi_gen_finalize;
	g_type_class_add_private (klass, sizeof (ValaVAPIGenPrivate));
}


static void
vala_vapi_gen_instance_init (ValaVAPIGen * self)
{
	self->priv = VALA_VAPI_GEN_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void
vala_vapi_gen_finalize (ValaVAPIGen * obj)
{
	ValaVAPIGen * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_VAPI_GEN, ValaVAPIGen);
	g_signal_handlers_destroy (self);
	_vala_code_context_unref0 (self->priv->context);
}


G_GNUC_INTERNAL GType
vala_vapi_gen_get_type (void)
{
	static volatile gsize vala_vapi_gen_type_id__volatile = 0;
	if (g_once_init_enter (&vala_vapi_gen_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_vapi_gen_init, vala_value_vapi_gen_free_value, vala_value_vapi_gen_copy_value, vala_value_vapi_gen_peek_pointer, "p", vala_value_vapi_gen_collect_value, "p", vala_value_vapi_gen_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaVAPIGenClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_vapi_gen_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaVAPIGen), 0, (GInstanceInitFunc) vala_vapi_gen_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_vapi_gen_type_id;
		vala_vapi_gen_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaVAPIGen", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_vapi_gen_type_id__volatile, vala_vapi_gen_type_id);
	}
	return vala_vapi_gen_type_id__volatile;
}


G_GNUC_INTERNAL gpointer
vala_vapi_gen_ref (gpointer instance)
{
	ValaVAPIGen * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


G_GNUC_INTERNAL void
vala_vapi_gen_unref (gpointer instance)
{
	ValaVAPIGen * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_VAPI_GEN_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void
_vala_array_destroy (gpointer array, 
                     gint array_length, 
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array, 
                  gint array_length, 
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



