/* valaassignment.c generated by valac, the Vala compiler
 * generated from valaassignment.vala, do not modify */

/* valaassignment.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>

enum  {
	VALA_ASSIGNMENT_0_PROPERTY,
	VALA_ASSIGNMENT_NUM_PROPERTIES
};
static GParamSpec* vala_assignment_properties[VALA_ASSIGNMENT_NUM_PROPERTIES];
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaAssignmentPrivate {
	ValaAssignmentOperator _operator;
	ValaExpression* _left;
	ValaExpression* _right;
};


static gpointer vala_assignment_parent_class = NULL;

#define VALA_ASSIGNMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ASSIGNMENT, ValaAssignmentPrivate))
static void vala_assignment_real_accept (ValaCodeNode* base, 
                                  ValaCodeVisitor* visitor);
static void vala_assignment_real_accept_children (ValaCodeNode* base, 
                                           ValaCodeVisitor* visitor);
static void vala_assignment_real_replace_expression (ValaCodeNode* base, 
                                              ValaExpression* old_node, 
                                              ValaExpression* new_node);
static gboolean vala_assignment_real_is_pure (ValaExpression* base);
static gboolean vala_assignment_real_is_accessible (ValaExpression* base, 
                                             ValaSymbol* sym);
static gboolean vala_assignment_real_check (ValaCodeNode* base, 
                                     ValaCodeContext* context);
static gboolean vala_assignment_is_array_add (ValaAssignment* self);
static void vala_assignment_real_emit (ValaCodeNode* base, 
                                ValaCodeGenerator* codegen);
static void vala_assignment_real_get_defined_variables (ValaCodeNode* base, 
                                                 ValaCollection* collection);
static void vala_assignment_real_get_used_variables (ValaCodeNode* base, 
                                              ValaCollection* collection);
static void vala_assignment_finalize (ValaCodeNode * obj);


/**
 * Creates a new assignment.
 *
 * @param left             left hand side
 * @param operator         assignment operator
 * @param right            right hand side
 * @param source_reference reference to source code
 * @return                 newly created assignment
 */
ValaAssignment*
vala_assignment_construct (GType object_type, 
                           ValaExpression* left, 
                           ValaExpression* right, 
                           ValaAssignmentOperator operator, 
                           ValaSourceReference* source_reference)
{
	ValaAssignment* self = NULL;
	g_return_val_if_fail (left != NULL, NULL);
	g_return_val_if_fail (right != NULL, NULL);
	self = (ValaAssignment*) vala_expression_construct (object_type);
	vala_assignment_set_right (self, right);
	vala_assignment_set_operator (self, operator);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_assignment_set_left (self, left);
	return self;
}


ValaAssignment*
vala_assignment_new (ValaExpression* left, 
                     ValaExpression* right, 
                     ValaAssignmentOperator operator, 
                     ValaSourceReference* source_reference)
{
	return vala_assignment_construct (VALA_TYPE_ASSIGNMENT, left, right, operator, source_reference);
}


static void
vala_assignment_real_accept (ValaCodeNode* base, 
                             ValaCodeVisitor* visitor)
{
	ValaAssignment * self;
	self = (ValaAssignment*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_assignment (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void
vala_assignment_real_accept_children (ValaCodeNode* base, 
                                      ValaCodeVisitor* visitor)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
}


static void
vala_assignment_real_replace_expression (ValaCodeNode* base, 
                                         ValaExpression* old_node, 
                                         ValaExpression* new_node)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_assignment_set_left (self, new_node);
	}
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_node) {
		vala_assignment_set_right (self, new_node);
	}
}


static gboolean
vala_assignment_real_is_pure (ValaExpression* base)
{
	ValaAssignment * self;
	gboolean result = FALSE;
	self = (ValaAssignment*) base;
	result = FALSE;
	return result;
}


static gboolean
vala_assignment_real_is_accessible (ValaExpression* base, 
                                    ValaSymbol* sym)
{
	ValaAssignment * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaAssignment*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_assignment_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_accessible (_tmp2_, sym)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_assignment_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_accessible (_tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_assignment_real_check (ValaCodeNode* base, 
                            ValaCodeContext* context)
{
	ValaAssignment * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp95_;
	ValaExpression* _tmp96_;
	ValaExpression* _tmp97_;
	ValaExpression* _tmp98_;
	ValaExpression* _tmp99_;
	ValaExpression* _tmp100_;
	ValaExpression* _tmp305_;
	ValaExpression* _tmp306_;
	gboolean _tmp307_ = FALSE;
	ValaAssignmentOperator _tmp308_;
	ValaExpression* _tmp370_;
	ValaExpression* _tmp371_;
	ValaSymbol* _tmp372_;
	ValaSymbol* _tmp373_;
	ValaExpression* _tmp815_;
	ValaExpression* _tmp816_;
	ValaDataType* _tmp817_;
	ValaDataType* _tmp818_;
	ValaExpression* _tmp827_;
	ValaExpression* _tmp828_;
	ValaList* _tmp829_;
	ValaList* _tmp830_;
	ValaExpression* _tmp831_;
	ValaExpression* _tmp832_;
	ValaList* _tmp833_;
	ValaList* _tmp834_;
	gboolean _tmp835_;
	gboolean _tmp836_;
	self = (ValaAssignment*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp6_ = vala_assignment_get_left (self);
	_tmp7_ = _tmp6_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_TUPLE)) {
		ValaAssignmentOperator _tmp8_;
		_tmp8_ = self->priv->_operator;
		_tmp5_ = _tmp8_ == VALA_ASSIGNMENT_OPERATOR_SIMPLE;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaCodeNode* _tmp9_;
		ValaCodeNode* _tmp10_;
		_tmp9_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp10_ = _tmp9_;
		_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, VALA_TYPE_EXPRESSION_STATEMENT);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaTuple* tuple = NULL;
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		ValaTuple* _tmp13_;
		ValaLocalVariable* local = NULL;
		gchar* _tmp14_;
		gchar* _tmp15_;
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		ValaExpression* _tmp18_;
		ValaExpression* _tmp19_;
		ValaSourceReference* _tmp20_;
		ValaSourceReference* _tmp21_;
		ValaLocalVariable* _tmp22_;
		ValaLocalVariable* _tmp23_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp24_;
		ValaSourceReference* _tmp25_;
		ValaSourceReference* _tmp26_;
		ValaDeclarationStatement* _tmp27_;
		ValaDeclarationStatement* _tmp28_;
		ValaSemanticAnalyzer* _tmp29_;
		ValaSemanticAnalyzer* _tmp30_;
		ValaBlock* _tmp31_;
		ValaDeclarationStatement* _tmp32_;
		gint i = 0;
		ValaExpressionStatement* stmt = NULL;
		ValaSemanticAnalyzer* _tmp85_;
		ValaSemanticAnalyzer* _tmp86_;
		ValaCodeNode* _tmp87_;
		ValaCodeNode* _tmp88_;
		ValaExpressionStatement* _tmp89_;
		ValaExpression* _tmp90_;
		ValaExpression* _tmp91_;
		ValaExpressionStatement* _tmp92_;
		ValaExpression* _tmp93_;
		ValaExpression* _tmp94_;
		_tmp11_ = vala_assignment_get_left (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_TUPLE, ValaTuple));
		tuple = _tmp13_;
		_tmp14_ = vala_code_node_get_temp_name ();
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_assignment_get_right (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_assignment_get_right (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_local_variable_new (NULL, _tmp15_, _tmp17_, _tmp21_);
		_tmp23_ = _tmp22_;
		_g_free0 (_tmp15_);
		local = _tmp23_;
		_tmp24_ = local;
		_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_declaration_statement_new ((ValaSymbol*) _tmp24_, _tmp26_);
		decl = _tmp27_;
		_tmp28_ = decl;
		vala_code_node_check ((ValaCodeNode*) _tmp28_, context);
		_tmp29_ = vala_code_context_get_analyzer (context);
		_tmp30_ = _tmp29_;
		_tmp31_ = _tmp30_->insert_block;
		_tmp32_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp31_, (ValaStatement*) _tmp32_);
		i = 0;
		stmt = NULL;
		{
			ValaList* _expr_list = NULL;
			ValaTuple* _tmp33_;
			ValaList* _tmp34_;
			gint _expr_size = 0;
			ValaList* _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			gint _expr_index = 0;
			_tmp33_ = tuple;
			_tmp34_ = vala_tuple_get_expressions (_tmp33_);
			_expr_list = _tmp34_;
			_tmp35_ = _expr_list;
			_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
			_tmp37_ = _tmp36_;
			_expr_size = _tmp37_;
			_expr_index = -1;
			while (TRUE) {
				gint _tmp38_;
				gint _tmp39_;
				gint _tmp40_;
				ValaExpression* expr = NULL;
				ValaList* _tmp41_;
				gint _tmp42_;
				gpointer _tmp43_;
				ValaExpressionStatement* _tmp44_;
				ValaMemberAccess* temp_access = NULL;
				ValaLocalVariable* _tmp50_;
				const gchar* _tmp51_;
				const gchar* _tmp52_;
				ValaExpression* _tmp53_;
				ValaExpression* _tmp54_;
				ValaSourceReference* _tmp55_;
				ValaSourceReference* _tmp56_;
				ValaMemberAccess* _tmp57_;
				ValaElementAccess* ea = NULL;
				ValaMemberAccess* _tmp58_;
				ValaExpression* _tmp59_;
				ValaSourceReference* _tmp60_;
				ValaSourceReference* _tmp61_;
				ValaElementAccess* _tmp62_;
				ValaElementAccess* _tmp63_;
				gint _tmp64_;
				gchar* _tmp65_;
				gchar* _tmp66_;
				ValaExpression* _tmp67_;
				ValaSourceReference* _tmp68_;
				ValaSourceReference* _tmp69_;
				ValaIntegerLiteral* _tmp70_;
				ValaIntegerLiteral* _tmp71_;
				ValaAssignment* assign = NULL;
				ValaExpression* _tmp72_;
				ValaElementAccess* _tmp73_;
				ValaAssignmentOperator _tmp74_;
				ValaExpression* _tmp75_;
				ValaSourceReference* _tmp76_;
				ValaSourceReference* _tmp77_;
				ValaAssignment* _tmp78_;
				ValaAssignment* _tmp79_;
				ValaExpression* _tmp80_;
				ValaSourceReference* _tmp81_;
				ValaSourceReference* _tmp82_;
				ValaExpressionStatement* _tmp83_;
				gint _tmp84_;
				_tmp38_ = _expr_index;
				_expr_index = _tmp38_ + 1;
				_tmp39_ = _expr_index;
				_tmp40_ = _expr_size;
				if (!(_tmp39_ < _tmp40_)) {
					break;
				}
				_tmp41_ = _expr_list;
				_tmp42_ = _expr_index;
				_tmp43_ = vala_list_get (_tmp41_, _tmp42_);
				expr = (ValaExpression*) _tmp43_;
				_tmp44_ = stmt;
				if (_tmp44_ != NULL) {
					ValaExpressionStatement* _tmp45_;
					ValaSemanticAnalyzer* _tmp46_;
					ValaSemanticAnalyzer* _tmp47_;
					ValaBlock* _tmp48_;
					ValaExpressionStatement* _tmp49_;
					_tmp45_ = stmt;
					vala_code_node_check ((ValaCodeNode*) _tmp45_, context);
					_tmp46_ = vala_code_context_get_analyzer (context);
					_tmp47_ = _tmp46_;
					_tmp48_ = _tmp47_->insert_block;
					_tmp49_ = stmt;
					vala_expression_insert_statement ((ValaExpression*) self, _tmp48_, (ValaStatement*) _tmp49_);
				}
				_tmp50_ = local;
				_tmp51_ = vala_symbol_get_name ((ValaSymbol*) _tmp50_);
				_tmp52_ = _tmp51_;
				_tmp53_ = vala_assignment_get_right (self);
				_tmp54_ = _tmp53_;
				_tmp55_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp54_);
				_tmp56_ = _tmp55_;
				_tmp57_ = vala_member_access_new_simple (_tmp52_, _tmp56_);
				temp_access = _tmp57_;
				_tmp58_ = temp_access;
				_tmp59_ = expr;
				_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp59_);
				_tmp61_ = _tmp60_;
				_tmp62_ = vala_element_access_new ((ValaExpression*) _tmp58_, _tmp61_);
				ea = _tmp62_;
				_tmp63_ = ea;
				_tmp64_ = i;
				_tmp65_ = g_strdup_printf ("%i", _tmp64_);
				_tmp66_ = _tmp65_;
				_tmp67_ = expr;
				_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp67_);
				_tmp69_ = _tmp68_;
				_tmp70_ = vala_integer_literal_new (_tmp66_, _tmp69_);
				_tmp71_ = _tmp70_;
				vala_element_access_append_index (_tmp63_, (ValaExpression*) _tmp71_);
				_vala_code_node_unref0 (_tmp71_);
				_g_free0 (_tmp66_);
				_tmp72_ = expr;
				_tmp73_ = ea;
				_tmp74_ = self->priv->_operator;
				_tmp75_ = expr;
				_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = vala_assignment_new (_tmp72_, (ValaExpression*) _tmp73_, _tmp74_, _tmp77_);
				assign = _tmp78_;
				_tmp79_ = assign;
				_tmp80_ = expr;
				_tmp81_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp80_);
				_tmp82_ = _tmp81_;
				_tmp83_ = vala_expression_statement_new ((ValaExpression*) _tmp79_, _tmp82_);
				_vala_code_node_unref0 (stmt);
				stmt = _tmp83_;
				_tmp84_ = i;
				i = _tmp84_ + 1;
				_vala_code_node_unref0 (assign);
				_vala_code_node_unref0 (ea);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (expr);
			}
			_vala_iterable_unref0 (_expr_list);
		}
		_tmp85_ = vala_code_context_get_analyzer (context);
		_tmp86_ = _tmp85_;
		vala_semantic_analyzer_add_replaced_node (_tmp86_, (ValaCodeNode*) self);
		_tmp87_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp88_ = _tmp87_;
		_tmp89_ = stmt;
		_tmp90_ = vala_expression_statement_get_expression (_tmp89_);
		_tmp91_ = _tmp90_;
		vala_code_node_replace_expression (_tmp88_, (ValaExpression*) self, _tmp91_);
		_tmp92_ = stmt;
		_tmp93_ = vala_expression_statement_get_expression (_tmp92_);
		_tmp94_ = _tmp93_;
		result = vala_code_node_check ((ValaCodeNode*) _tmp94_, context);
		_vala_code_node_unref0 (stmt);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		_vala_code_node_unref0 (tuple);
		return result;
	}
	_tmp95_ = vala_assignment_get_left (self);
	_tmp96_ = _tmp95_;
	vala_expression_set_lvalue (_tmp96_, TRUE);
	_tmp97_ = vala_assignment_get_left (self);
	_tmp98_ = _tmp97_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp98_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp99_ = vala_assignment_get_left (self);
	_tmp100_ = _tmp99_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp100_, VALA_TYPE_MEMBER_ACCESS)) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp101_;
		ValaExpression* _tmp102_;
		ValaMemberAccess* _tmp103_;
		ValaMemberAccess* _tmp104_;
		ValaSymbol* _tmp105_;
		ValaSymbol* _tmp106_;
		gboolean _tmp109_ = FALSE;
		gboolean _tmp110_ = FALSE;
		gboolean _tmp111_ = FALSE;
		ValaMemberAccess* _tmp112_;
		ValaSymbol* _tmp113_;
		ValaSymbol* _tmp114_;
		ValaMemberAccess* _tmp133_;
		gboolean _tmp134_;
		gboolean _tmp135_;
		gboolean _tmp145_ = FALSE;
		ValaMemberAccess* _tmp146_;
		gboolean _tmp147_;
		gboolean _tmp148_;
		ValaMemberAccess* _tmp152_;
		ValaSymbol* _tmp153_;
		ValaSymbol* _tmp154_;
		_tmp101_ = vala_assignment_get_left (self);
		_tmp102_ = _tmp101_;
		_tmp103_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		ma = _tmp103_;
		_tmp104_ = ma;
		_tmp105_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp104_);
		_tmp106_ = _tmp105_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp106_, VALA_TYPE_CONSTANT)) {
			ValaSourceReference* _tmp107_;
			ValaSourceReference* _tmp108_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp107_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp108_ = _tmp107_;
			vala_report_error (_tmp108_, "Assignment to constant after initialization");
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp112_ = ma;
		_tmp113_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp112_);
		_tmp114_ = _tmp113_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp114_, VALA_TYPE_SIGNAL)) {
			_tmp111_ = TRUE;
		} else {
			ValaMemberAccess* _tmp115_;
			ValaSymbol* _tmp116_;
			ValaSymbol* _tmp117_;
			_tmp115_ = ma;
			_tmp116_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp115_);
			_tmp117_ = _tmp116_;
			_tmp111_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp117_, VALA_TYPE_DYNAMIC_PROPERTY);
		}
		if (!_tmp111_) {
			ValaMemberAccess* _tmp118_;
			ValaDataType* _tmp119_;
			ValaDataType* _tmp120_;
			_tmp118_ = ma;
			_tmp119_ = vala_expression_get_value_type ((ValaExpression*) _tmp118_);
			_tmp120_ = _tmp119_;
			_tmp110_ = _tmp120_ == NULL;
		} else {
			_tmp110_ = FALSE;
		}
		if (_tmp110_) {
			_tmp109_ = TRUE;
		} else {
			gboolean _tmp121_ = FALSE;
			gboolean _tmp122_ = FALSE;
			ValaMemberAccess* _tmp123_;
			ValaExpression* _tmp124_;
			ValaExpression* _tmp125_;
			_tmp123_ = ma;
			_tmp124_ = vala_member_access_get_inner (_tmp123_);
			_tmp125_ = _tmp124_;
			if (_tmp125_ == NULL) {
				ValaMemberAccess* _tmp126_;
				const gchar* _tmp127_;
				const gchar* _tmp128_;
				_tmp126_ = ma;
				_tmp127_ = vala_member_access_get_member_name (_tmp126_);
				_tmp128_ = _tmp127_;
				_tmp122_ = g_strcmp0 (_tmp128_, "this") == 0;
			} else {
				_tmp122_ = FALSE;
			}
			if (_tmp122_) {
				ValaSemanticAnalyzer* _tmp129_;
				ValaSemanticAnalyzer* _tmp130_;
				_tmp129_ = vala_code_context_get_analyzer (context);
				_tmp130_ = _tmp129_;
				_tmp121_ = vala_semantic_analyzer_is_in_instance_method (_tmp130_);
			} else {
				_tmp121_ = FALSE;
			}
			_tmp109_ = _tmp121_;
		}
		if (_tmp109_) {
			ValaSourceReference* _tmp131_;
			ValaSourceReference* _tmp132_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp131_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp132_ = _tmp131_;
			vala_report_error (_tmp132_, "unsupported lvalue in assignment");
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp133_ = ma;
		_tmp134_ = vala_member_access_get_prototype_access (_tmp133_);
		_tmp135_ = _tmp134_;
		if (_tmp135_) {
			ValaSourceReference* _tmp136_;
			ValaSourceReference* _tmp137_;
			ValaMemberAccess* _tmp138_;
			ValaSymbol* _tmp139_;
			ValaSymbol* _tmp140_;
			gchar* _tmp141_;
			gchar* _tmp142_;
			gchar* _tmp143_;
			gchar* _tmp144_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp136_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp137_ = _tmp136_;
			_tmp138_ = ma;
			_tmp139_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp138_);
			_tmp140_ = _tmp139_;
			_tmp141_ = vala_symbol_get_full_name (_tmp140_);
			_tmp142_ = _tmp141_;
			_tmp143_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp142_);
			_tmp144_ = _tmp143_;
			vala_report_error (_tmp137_, _tmp144_);
			_g_free0 (_tmp144_);
			_g_free0 (_tmp142_);
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp146_ = ma;
		_tmp147_ = vala_code_node_get_error ((ValaCodeNode*) _tmp146_);
		_tmp148_ = _tmp147_;
		if (_tmp148_) {
			_tmp145_ = TRUE;
		} else {
			ValaMemberAccess* _tmp149_;
			ValaSymbol* _tmp150_;
			ValaSymbol* _tmp151_;
			_tmp149_ = ma;
			_tmp150_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp149_);
			_tmp151_ = _tmp150_;
			_tmp145_ = _tmp151_ == NULL;
		}
		if (_tmp145_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp152_ = ma;
		_tmp153_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp152_);
		_tmp154_ = _tmp153_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp154_, VALA_TYPE_DYNAMIC_SIGNAL)) {
			gboolean _tmp155_;
			gboolean _tmp156_;
			_tmp155_ = vala_code_context_get_deprecated (context);
			_tmp156_ = _tmp155_;
			if (!_tmp156_) {
				ValaSourceReference* _tmp157_;
				ValaSourceReference* _tmp158_;
				_tmp157_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp158_ = _tmp157_;
				vala_report_warning (_tmp158_, "deprecated syntax, use `connect' method instead");
			}
		} else {
			ValaMemberAccess* _tmp159_;
			ValaSymbol* _tmp160_;
			ValaSymbol* _tmp161_;
			_tmp159_ = ma;
			_tmp160_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp159_);
			_tmp161_ = _tmp160_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp161_, VALA_TYPE_SIGNAL)) {
				gboolean _tmp162_;
				gboolean _tmp163_;
				ValaSignal* sig = NULL;
				ValaMemberAccess* _tmp166_;
				ValaSymbol* _tmp167_;
				ValaSymbol* _tmp168_;
				ValaSignal* _tmp169_;
				ValaExpression* _tmp170_;
				ValaExpression* _tmp171_;
				ValaSignal* _tmp172_;
				ValaMemberAccess* _tmp173_;
				ValaExpression* _tmp174_;
				ValaExpression* _tmp175_;
				ValaDataType* _tmp176_;
				ValaDataType* _tmp177_;
				ValaDelegate* _tmp178_;
				ValaDelegate* _tmp179_;
				ValaDelegateType* _tmp180_;
				ValaDelegateType* _tmp181_;
				_tmp162_ = vala_code_context_get_deprecated (context);
				_tmp163_ = _tmp162_;
				if (!_tmp163_) {
					ValaSourceReference* _tmp164_;
					ValaSourceReference* _tmp165_;
					_tmp164_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp165_ = _tmp164_;
					vala_report_warning (_tmp165_, "deprecated syntax, use `connect' method instead");
				}
				_tmp166_ = ma;
				_tmp167_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp166_);
				_tmp168_ = _tmp167_;
				_tmp169_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp168_, VALA_TYPE_SIGNAL, ValaSignal));
				sig = _tmp169_;
				_tmp170_ = vala_assignment_get_right (self);
				_tmp171_ = _tmp170_;
				_tmp172_ = sig;
				_tmp173_ = ma;
				_tmp174_ = vala_member_access_get_inner (_tmp173_);
				_tmp175_ = _tmp174_;
				_tmp176_ = vala_expression_get_value_type (_tmp175_);
				_tmp177_ = _tmp176_;
				_tmp178_ = vala_signal_get_delegate (_tmp172_, _tmp177_, (ValaCodeNode*) self);
				_tmp179_ = _tmp178_;
				_tmp180_ = vala_delegate_type_new (_tmp179_);
				_tmp181_ = _tmp180_;
				vala_expression_set_target_type (_tmp171_, (ValaDataType*) _tmp181_);
				_vala_code_node_unref0 (_tmp181_);
				_vala_code_node_unref0 (_tmp179_);
				_vala_code_node_unref0 (sig);
			} else {
				ValaMemberAccess* _tmp182_;
				ValaSymbol* _tmp183_;
				ValaSymbol* _tmp184_;
				_tmp182_ = ma;
				_tmp183_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp182_);
				_tmp184_ = _tmp183_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp184_, VALA_TYPE_DYNAMIC_PROPERTY)) {
				} else {
					ValaExpression* _tmp185_;
					ValaExpression* _tmp186_;
					ValaMemberAccess* _tmp187_;
					ValaDataType* _tmp188_;
					ValaDataType* _tmp189_;
					ValaDataType* _tmp190_;
					ValaDataType* _tmp191_;
					ValaExpression* _tmp192_;
					ValaExpression* _tmp193_;
					ValaMemberAccess* _tmp194_;
					ValaDataType* _tmp195_;
					ValaDataType* _tmp196_;
					ValaDataType* _tmp197_;
					ValaDataType* _tmp198_;
					_tmp185_ = vala_assignment_get_right (self);
					_tmp186_ = _tmp185_;
					_tmp187_ = ma;
					_tmp188_ = vala_expression_get_formal_value_type ((ValaExpression*) _tmp187_);
					_tmp189_ = _tmp188_;
					_tmp190_ = vala_data_type_copy (_tmp189_);
					_tmp191_ = _tmp190_;
					vala_expression_set_formal_target_type (_tmp186_, _tmp191_);
					_vala_code_node_unref0 (_tmp191_);
					_tmp192_ = vala_assignment_get_right (self);
					_tmp193_ = _tmp192_;
					_tmp194_ = ma;
					_tmp195_ = vala_expression_get_value_type ((ValaExpression*) _tmp194_);
					_tmp196_ = _tmp195_;
					_tmp197_ = vala_data_type_copy (_tmp196_);
					_tmp198_ = _tmp197_;
					vala_expression_set_target_type (_tmp193_, _tmp198_);
					_vala_code_node_unref0 (_tmp198_);
				}
			}
		}
		_vala_code_node_unref0 (ma);
	} else {
		ValaExpression* _tmp199_;
		ValaExpression* _tmp200_;
		_tmp199_ = vala_assignment_get_left (self);
		_tmp200_ = _tmp199_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp200_, VALA_TYPE_ELEMENT_ACCESS)) {
			ValaElementAccess* ea = NULL;
			ValaExpression* _tmp201_;
			ValaExpression* _tmp202_;
			ValaElementAccess* _tmp203_;
			ValaElementAccess* _tmp204_;
			ValaExpression* _tmp205_;
			ValaExpression* _tmp206_;
			ValaDataType* _tmp207_;
			ValaDataType* _tmp208_;
			ValaTypeSymbol* _tmp209_;
			ValaTypeSymbol* _tmp210_;
			ValaSemanticAnalyzer* _tmp211_;
			ValaSemanticAnalyzer* _tmp212_;
			ValaDataType* _tmp213_;
			ValaTypeSymbol* _tmp214_;
			ValaTypeSymbol* _tmp215_;
			_tmp201_ = vala_assignment_get_left (self);
			_tmp202_ = _tmp201_;
			_tmp203_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp202_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
			ea = _tmp203_;
			_tmp204_ = ea;
			_tmp205_ = vala_element_access_get_container (_tmp204_);
			_tmp206_ = _tmp205_;
			_tmp207_ = vala_expression_get_value_type (_tmp206_);
			_tmp208_ = _tmp207_;
			_tmp209_ = vala_data_type_get_data_type (_tmp208_);
			_tmp210_ = _tmp209_;
			_tmp211_ = vala_code_context_get_analyzer (context);
			_tmp212_ = _tmp211_;
			_tmp213_ = _tmp212_->string_type;
			_tmp214_ = vala_data_type_get_data_type (_tmp213_);
			_tmp215_ = _tmp214_;
			if (_tmp210_ == _tmp215_) {
				ValaElementAccess* _tmp216_;
				ValaSourceReference* _tmp217_;
				ValaSourceReference* _tmp218_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp216_ = ea;
				_tmp217_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp216_);
				_tmp218_ = _tmp217_;
				vala_report_error (_tmp218_, "strings are immutable");
				result = FALSE;
				_vala_code_node_unref0 (ea);
				return result;
			} else {
				gboolean _tmp219_ = FALSE;
				ValaElementAccess* _tmp220_;
				ValaExpression* _tmp221_;
				ValaExpression* _tmp222_;
				_tmp220_ = ea;
				_tmp221_ = vala_element_access_get_container (_tmp220_);
				_tmp222_ = _tmp221_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp222_, VALA_TYPE_MEMBER_ACCESS)) {
					ValaElementAccess* _tmp223_;
					ValaExpression* _tmp224_;
					ValaExpression* _tmp225_;
					ValaSymbol* _tmp226_;
					ValaSymbol* _tmp227_;
					_tmp223_ = ea;
					_tmp224_ = vala_element_access_get_container (_tmp223_);
					_tmp225_ = _tmp224_;
					_tmp226_ = vala_expression_get_symbol_reference (_tmp225_);
					_tmp227_ = _tmp226_;
					_tmp219_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp227_, VALA_TYPE_SIGNAL);
				} else {
					_tmp219_ = FALSE;
				}
				if (_tmp219_) {
					ValaMemberAccess* ma = NULL;
					ValaElementAccess* _tmp228_;
					ValaExpression* _tmp229_;
					ValaExpression* _tmp230_;
					ValaMemberAccess* _tmp231_;
					ValaSignal* sig = NULL;
					ValaElementAccess* _tmp232_;
					ValaExpression* _tmp233_;
					ValaExpression* _tmp234_;
					ValaSymbol* _tmp235_;
					ValaSymbol* _tmp236_;
					ValaSignal* _tmp237_;
					ValaExpression* _tmp238_;
					ValaExpression* _tmp239_;
					ValaSignal* _tmp240_;
					ValaMemberAccess* _tmp241_;
					ValaExpression* _tmp242_;
					ValaExpression* _tmp243_;
					ValaDataType* _tmp244_;
					ValaDataType* _tmp245_;
					ValaDelegate* _tmp246_;
					ValaDelegate* _tmp247_;
					ValaDelegateType* _tmp248_;
					ValaDelegateType* _tmp249_;
					_tmp228_ = ea;
					_tmp229_ = vala_element_access_get_container (_tmp228_);
					_tmp230_ = _tmp229_;
					_tmp231_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp230_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
					ma = _tmp231_;
					_tmp232_ = ea;
					_tmp233_ = vala_element_access_get_container (_tmp232_);
					_tmp234_ = _tmp233_;
					_tmp235_ = vala_expression_get_symbol_reference (_tmp234_);
					_tmp236_ = _tmp235_;
					_tmp237_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp236_, VALA_TYPE_SIGNAL, ValaSignal));
					sig = _tmp237_;
					_tmp238_ = vala_assignment_get_right (self);
					_tmp239_ = _tmp238_;
					_tmp240_ = sig;
					_tmp241_ = ma;
					_tmp242_ = vala_member_access_get_inner (_tmp241_);
					_tmp243_ = _tmp242_;
					_tmp244_ = vala_expression_get_value_type (_tmp243_);
					_tmp245_ = _tmp244_;
					_tmp246_ = vala_signal_get_delegate (_tmp240_, _tmp245_, (ValaCodeNode*) self);
					_tmp247_ = _tmp246_;
					_tmp248_ = vala_delegate_type_new (_tmp247_);
					_tmp249_ = _tmp248_;
					vala_expression_set_target_type (_tmp239_, (ValaDataType*) _tmp249_);
					_vala_code_node_unref0 (_tmp249_);
					_vala_code_node_unref0 (_tmp247_);
					_vala_code_node_unref0 (sig);
					_vala_code_node_unref0 (ma);
				} else {
					ValaElementAccess* _tmp250_;
					ValaExpression* _tmp251_;
					ValaExpression* _tmp252_;
					ValaDataType* _tmp253_;
					ValaDataType* _tmp254_;
					ValaSymbol* _tmp255_;
					ValaSymbol* _tmp256_;
					gboolean _tmp257_;
					_tmp250_ = ea;
					_tmp251_ = vala_element_access_get_container (_tmp250_);
					_tmp252_ = _tmp251_;
					_tmp253_ = vala_expression_get_value_type (_tmp252_);
					_tmp254_ = _tmp253_;
					_tmp255_ = vala_data_type_get_member (_tmp254_, "set");
					_tmp256_ = _tmp255_;
					_tmp257_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp256_, VALA_TYPE_METHOD);
					_vala_code_node_unref0 (_tmp256_);
					if (_tmp257_) {
						ValaMethodCall* set_call = NULL;
						ValaElementAccess* _tmp258_;
						ValaExpression* _tmp259_;
						ValaExpression* _tmp260_;
						ValaSourceReference* _tmp261_;
						ValaSourceReference* _tmp262_;
						ValaMemberAccess* _tmp263_;
						ValaMemberAccess* _tmp264_;
						ValaSourceReference* _tmp265_;
						ValaSourceReference* _tmp266_;
						ValaMethodCall* _tmp267_;
						ValaMethodCall* _tmp268_;
						ValaMethodCall* _tmp282_;
						ValaExpression* _tmp283_;
						ValaExpression* _tmp284_;
						ValaCodeNode* _tmp285_;
						ValaCodeNode* _tmp286_;
						ValaMethodCall* _tmp287_;
						ValaMethodCall* _tmp288_;
						_tmp258_ = ea;
						_tmp259_ = vala_element_access_get_container (_tmp258_);
						_tmp260_ = _tmp259_;
						_tmp261_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp262_ = _tmp261_;
						_tmp263_ = vala_member_access_new (_tmp260_, "set", _tmp262_);
						_tmp264_ = _tmp263_;
						_tmp265_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp266_ = _tmp265_;
						_tmp267_ = vala_method_call_new ((ValaExpression*) _tmp264_, _tmp266_);
						_tmp268_ = _tmp267_;
						_vala_code_node_unref0 (_tmp264_);
						set_call = _tmp268_;
						{
							ValaList* _e_list = NULL;
							ValaElementAccess* _tmp269_;
							ValaList* _tmp270_;
							gint _e_size = 0;
							ValaList* _tmp271_;
							gint _tmp272_;
							gint _tmp273_;
							gint _e_index = 0;
							_tmp269_ = ea;
							_tmp270_ = vala_element_access_get_indices (_tmp269_);
							_e_list = _tmp270_;
							_tmp271_ = _e_list;
							_tmp272_ = vala_collection_get_size ((ValaCollection*) _tmp271_);
							_tmp273_ = _tmp272_;
							_e_size = _tmp273_;
							_e_index = -1;
							while (TRUE) {
								gint _tmp274_;
								gint _tmp275_;
								gint _tmp276_;
								ValaExpression* e = NULL;
								ValaList* _tmp277_;
								gint _tmp278_;
								gpointer _tmp279_;
								ValaMethodCall* _tmp280_;
								ValaExpression* _tmp281_;
								_tmp274_ = _e_index;
								_e_index = _tmp274_ + 1;
								_tmp275_ = _e_index;
								_tmp276_ = _e_size;
								if (!(_tmp275_ < _tmp276_)) {
									break;
								}
								_tmp277_ = _e_list;
								_tmp278_ = _e_index;
								_tmp279_ = vala_list_get (_tmp277_, _tmp278_);
								e = (ValaExpression*) _tmp279_;
								_tmp280_ = set_call;
								_tmp281_ = e;
								vala_method_call_add_argument (_tmp280_, _tmp281_);
								_vala_code_node_unref0 (e);
							}
							_vala_iterable_unref0 (_e_list);
						}
						_tmp282_ = set_call;
						_tmp283_ = vala_assignment_get_right (self);
						_tmp284_ = _tmp283_;
						vala_method_call_add_argument (_tmp282_, _tmp284_);
						_tmp285_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp286_ = _tmp285_;
						_tmp287_ = set_call;
						vala_code_node_replace_expression (_tmp286_, (ValaExpression*) self, (ValaExpression*) _tmp287_);
						_tmp288_ = set_call;
						result = vala_code_node_check ((ValaCodeNode*) _tmp288_, context);
						_vala_code_node_unref0 (set_call);
						_vala_code_node_unref0 (ea);
						return result;
					} else {
						ValaExpression* _tmp289_;
						ValaExpression* _tmp290_;
						ValaExpression* _tmp291_;
						ValaExpression* _tmp292_;
						ValaDataType* _tmp293_;
						ValaDataType* _tmp294_;
						_tmp289_ = vala_assignment_get_right (self);
						_tmp290_ = _tmp289_;
						_tmp291_ = vala_assignment_get_left (self);
						_tmp292_ = _tmp291_;
						_tmp293_ = vala_expression_get_value_type (_tmp292_);
						_tmp294_ = _tmp293_;
						vala_expression_set_target_type (_tmp290_, _tmp294_);
					}
				}
			}
			_vala_code_node_unref0 (ea);
		} else {
			ValaExpression* _tmp295_;
			ValaExpression* _tmp296_;
			_tmp295_ = vala_assignment_get_left (self);
			_tmp296_ = _tmp295_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp296_, VALA_TYPE_POINTER_INDIRECTION)) {
				ValaExpression* _tmp297_;
				ValaExpression* _tmp298_;
				ValaExpression* _tmp299_;
				ValaExpression* _tmp300_;
				ValaDataType* _tmp301_;
				ValaDataType* _tmp302_;
				_tmp297_ = vala_assignment_get_right (self);
				_tmp298_ = _tmp297_;
				_tmp299_ = vala_assignment_get_left (self);
				_tmp300_ = _tmp299_;
				_tmp301_ = vala_expression_get_value_type (_tmp300_);
				_tmp302_ = _tmp301_;
				vala_expression_set_target_type (_tmp298_, _tmp302_);
			} else {
				ValaSourceReference* _tmp303_;
				ValaSourceReference* _tmp304_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp303_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp304_ = _tmp303_;
				vala_report_error (_tmp304_, "unsupported lvalue in assignment");
				result = FALSE;
				return result;
			}
		}
	}
	_tmp305_ = vala_assignment_get_right (self);
	_tmp306_ = _tmp305_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp306_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp308_ = self->priv->_operator;
	if (_tmp308_ != VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
		ValaExpression* _tmp309_;
		ValaExpression* _tmp310_;
		_tmp309_ = vala_assignment_get_left (self);
		_tmp310_ = _tmp309_;
		_tmp307_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp310_, VALA_TYPE_MEMBER_ACCESS);
	} else {
		_tmp307_ = FALSE;
	}
	if (_tmp307_) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp311_;
		ValaExpression* _tmp312_;
		ValaMemberAccess* _tmp313_;
		ValaMemberAccess* _tmp314_;
		ValaSymbol* _tmp315_;
		ValaSymbol* _tmp316_;
		_tmp311_ = vala_assignment_get_left (self);
		_tmp312_ = _tmp311_;
		_tmp313_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp312_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		ma = _tmp313_;
		_tmp314_ = ma;
		_tmp315_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp314_);
		_tmp316_ = _tmp315_;
		if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp316_, VALA_TYPE_SIGNAL)) {
			ValaMemberAccess* old_value = NULL;
			ValaMemberAccess* _tmp317_;
			ValaExpression* _tmp318_;
			ValaExpression* _tmp319_;
			ValaMemberAccess* _tmp320_;
			const gchar* _tmp321_;
			const gchar* _tmp322_;
			ValaMemberAccess* _tmp323_;
			ValaBinaryExpression* bin = NULL;
			ValaMemberAccess* _tmp324_;
			ValaExpression* _tmp325_;
			ValaExpression* _tmp326_;
			ValaSourceReference* _tmp327_;
			ValaSourceReference* _tmp328_;
			ValaBinaryExpression* _tmp329_;
			ValaBinaryExpression* _tmp330_;
			ValaExpression* _tmp331_;
			ValaExpression* _tmp332_;
			ValaDataType* _tmp333_;
			ValaDataType* _tmp334_;
			ValaExpression* _tmp335_;
			ValaExpression* _tmp336_;
			ValaExpression* _tmp337_;
			ValaExpression* _tmp338_;
			ValaDataType* _tmp339_;
			ValaDataType* _tmp340_;
			ValaDataType* _tmp341_;
			ValaDataType* _tmp342_;
			ValaExpression* _tmp343_;
			ValaExpression* _tmp344_;
			ValaDataType* _tmp345_;
			ValaDataType* _tmp346_;
			ValaAssignmentOperator _tmp347_;
			ValaBinaryExpression* _tmp367_;
			ValaExpression* _tmp368_;
			ValaExpression* _tmp369_;
			_tmp317_ = ma;
			_tmp318_ = vala_member_access_get_inner (_tmp317_);
			_tmp319_ = _tmp318_;
			_tmp320_ = ma;
			_tmp321_ = vala_member_access_get_member_name (_tmp320_);
			_tmp322_ = _tmp321_;
			_tmp323_ = vala_member_access_new (_tmp319_, _tmp322_, NULL);
			old_value = _tmp323_;
			_tmp324_ = old_value;
			_tmp325_ = vala_assignment_get_right (self);
			_tmp326_ = _tmp325_;
			_tmp327_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp328_ = _tmp327_;
			_tmp329_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_PLUS, (ValaExpression*) _tmp324_, _tmp326_, _tmp328_);
			bin = _tmp329_;
			_tmp330_ = bin;
			_tmp331_ = vala_assignment_get_right (self);
			_tmp332_ = _tmp331_;
			_tmp333_ = vala_expression_get_target_type (_tmp332_);
			_tmp334_ = _tmp333_;
			vala_expression_set_target_type ((ValaExpression*) _tmp330_, _tmp334_);
			_tmp335_ = vala_assignment_get_right (self);
			_tmp336_ = _tmp335_;
			_tmp337_ = vala_assignment_get_right (self);
			_tmp338_ = _tmp337_;
			_tmp339_ = vala_expression_get_target_type (_tmp338_);
			_tmp340_ = _tmp339_;
			_tmp341_ = vala_data_type_copy (_tmp340_);
			_tmp342_ = _tmp341_;
			vala_expression_set_target_type (_tmp336_, _tmp342_);
			_vala_code_node_unref0 (_tmp342_);
			_tmp343_ = vala_assignment_get_right (self);
			_tmp344_ = _tmp343_;
			_tmp345_ = vala_expression_get_target_type (_tmp344_);
			_tmp346_ = _tmp345_;
			vala_data_type_set_value_owned (_tmp346_, FALSE);
			_tmp347_ = self->priv->_operator;
			if (_tmp347_ == VALA_ASSIGNMENT_OPERATOR_BITWISE_OR) {
				ValaBinaryExpression* _tmp348_;
				_tmp348_ = bin;
				vala_binary_expression_set_operator (_tmp348_, VALA_BINARY_OPERATOR_BITWISE_OR);
			} else {
				ValaAssignmentOperator _tmp349_;
				_tmp349_ = self->priv->_operator;
				if (_tmp349_ == VALA_ASSIGNMENT_OPERATOR_BITWISE_AND) {
					ValaBinaryExpression* _tmp350_;
					_tmp350_ = bin;
					vala_binary_expression_set_operator (_tmp350_, VALA_BINARY_OPERATOR_BITWISE_AND);
				} else {
					ValaAssignmentOperator _tmp351_;
					_tmp351_ = self->priv->_operator;
					if (_tmp351_ == VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR) {
						ValaBinaryExpression* _tmp352_;
						_tmp352_ = bin;
						vala_binary_expression_set_operator (_tmp352_, VALA_BINARY_OPERATOR_BITWISE_XOR);
					} else {
						ValaAssignmentOperator _tmp353_;
						_tmp353_ = self->priv->_operator;
						if (_tmp353_ == VALA_ASSIGNMENT_OPERATOR_ADD) {
							ValaBinaryExpression* _tmp354_;
							_tmp354_ = bin;
							vala_binary_expression_set_operator (_tmp354_, VALA_BINARY_OPERATOR_PLUS);
						} else {
							ValaAssignmentOperator _tmp355_;
							_tmp355_ = self->priv->_operator;
							if (_tmp355_ == VALA_ASSIGNMENT_OPERATOR_SUB) {
								ValaBinaryExpression* _tmp356_;
								_tmp356_ = bin;
								vala_binary_expression_set_operator (_tmp356_, VALA_BINARY_OPERATOR_MINUS);
							} else {
								ValaAssignmentOperator _tmp357_;
								_tmp357_ = self->priv->_operator;
								if (_tmp357_ == VALA_ASSIGNMENT_OPERATOR_MUL) {
									ValaBinaryExpression* _tmp358_;
									_tmp358_ = bin;
									vala_binary_expression_set_operator (_tmp358_, VALA_BINARY_OPERATOR_MUL);
								} else {
									ValaAssignmentOperator _tmp359_;
									_tmp359_ = self->priv->_operator;
									if (_tmp359_ == VALA_ASSIGNMENT_OPERATOR_DIV) {
										ValaBinaryExpression* _tmp360_;
										_tmp360_ = bin;
										vala_binary_expression_set_operator (_tmp360_, VALA_BINARY_OPERATOR_DIV);
									} else {
										ValaAssignmentOperator _tmp361_;
										_tmp361_ = self->priv->_operator;
										if (_tmp361_ == VALA_ASSIGNMENT_OPERATOR_PERCENT) {
											ValaBinaryExpression* _tmp362_;
											_tmp362_ = bin;
											vala_binary_expression_set_operator (_tmp362_, VALA_BINARY_OPERATOR_MOD);
										} else {
											ValaAssignmentOperator _tmp363_;
											_tmp363_ = self->priv->_operator;
											if (_tmp363_ == VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT) {
												ValaBinaryExpression* _tmp364_;
												_tmp364_ = bin;
												vala_binary_expression_set_operator (_tmp364_, VALA_BINARY_OPERATOR_SHIFT_LEFT);
											} else {
												ValaAssignmentOperator _tmp365_;
												_tmp365_ = self->priv->_operator;
												if (_tmp365_ == VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT) {
													ValaBinaryExpression* _tmp366_;
													_tmp366_ = bin;
													vala_binary_expression_set_operator (_tmp366_, VALA_BINARY_OPERATOR_SHIFT_RIGHT);
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
			_tmp367_ = bin;
			vala_assignment_set_right (self, (ValaExpression*) _tmp367_);
			_tmp368_ = vala_assignment_get_right (self);
			_tmp369_ = _tmp368_;
			vala_code_node_check ((ValaCodeNode*) _tmp369_, context);
			vala_assignment_set_operator (self, VALA_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_code_node_unref0 (bin);
			_vala_code_node_unref0 (old_value);
		}
		_vala_code_node_unref0 (ma);
	}
	_tmp370_ = vala_assignment_get_left (self);
	_tmp371_ = _tmp370_;
	_tmp372_ = vala_expression_get_symbol_reference (_tmp371_);
	_tmp373_ = _tmp372_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp373_, VALA_TYPE_SIGNAL)) {
		ValaSignal* sig = NULL;
		ValaExpression* _tmp374_;
		ValaExpression* _tmp375_;
		ValaSymbol* _tmp376_;
		ValaSymbol* _tmp377_;
		ValaSignal* _tmp378_;
		ValaMethod* m = NULL;
		ValaExpression* _tmp379_;
		ValaExpression* _tmp380_;
		ValaSymbol* _tmp381_;
		ValaSymbol* _tmp382_;
		ValaMethod* _tmp383_;
		ValaMethod* _tmp384_;
		ValaDynamicSignal* dynamic_sig = NULL;
		ValaSignal* _tmp389_;
		ValaDynamicSignal* _tmp390_;
		ValaMemberAccess* right_ma = NULL;
		ValaExpression* _tmp391_;
		ValaExpression* _tmp392_;
		ValaMemberAccess* _tmp393_;
		ValaDynamicSignal* _tmp394_;
		_tmp374_ = vala_assignment_get_left (self);
		_tmp375_ = _tmp374_;
		_tmp376_ = vala_expression_get_symbol_reference (_tmp375_);
		_tmp377_ = _tmp376_;
		_tmp378_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp377_, VALA_TYPE_SIGNAL, ValaSignal));
		sig = _tmp378_;
		_tmp379_ = vala_assignment_get_right (self);
		_tmp380_ = _tmp379_;
		_tmp381_ = vala_expression_get_symbol_reference (_tmp380_);
		_tmp382_ = _tmp381_;
		_tmp383_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp382_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp382_) : NULL);
		m = _tmp383_;
		_tmp384_ = m;
		if (_tmp384_ == NULL) {
			ValaExpression* _tmp385_;
			ValaExpression* _tmp386_;
			ValaSourceReference* _tmp387_;
			ValaSourceReference* _tmp388_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp385_ = vala_assignment_get_right (self);
			_tmp386_ = _tmp385_;
			_tmp387_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp386_);
			_tmp388_ = _tmp387_;
			vala_report_error (_tmp388_, "unsupported expression for signal handler");
			result = FALSE;
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (sig);
			return result;
		}
		_tmp389_ = sig;
		_tmp390_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp389_, VALA_TYPE_DYNAMIC_SIGNAL) ? ((ValaDynamicSignal*) _tmp389_) : NULL);
		dynamic_sig = _tmp390_;
		_tmp391_ = vala_assignment_get_right (self);
		_tmp392_ = _tmp391_;
		_tmp393_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp392_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp392_) : NULL);
		right_ma = _tmp393_;
		_tmp394_ = dynamic_sig;
		if (_tmp394_ != NULL) {
			gboolean first = FALSE;
			ValaExpression* _tmp415_;
			ValaExpression* _tmp416_;
			ValaSignal* _tmp417_;
			ValaSignal* _tmp418_;
			ValaSymbol* _tmp419_;
			ValaSymbol* _tmp420_;
			ValaObjectType* _tmp421_;
			ValaObjectType* _tmp422_;
			ValaDelegate* _tmp423_;
			ValaDelegate* _tmp424_;
			ValaDelegateType* _tmp425_;
			ValaDelegateType* _tmp426_;
			first = TRUE;
			{
				ValaList* _param_list = NULL;
				ValaDynamicSignal* _tmp395_;
				ValaExpression* _tmp396_;
				ValaExpression* _tmp397_;
				ValaDataType* _tmp398_;
				ValaDataType* _tmp399_;
				ValaList* _tmp400_;
				gint _param_size = 0;
				ValaList* _tmp401_;
				gint _tmp402_;
				gint _tmp403_;
				gint _param_index = 0;
				_tmp395_ = dynamic_sig;
				_tmp396_ = vala_dynamic_signal_get_handler (_tmp395_);
				_tmp397_ = _tmp396_;
				_tmp398_ = vala_expression_get_value_type (_tmp397_);
				_tmp399_ = _tmp398_;
				_tmp400_ = vala_data_type_get_parameters (_tmp399_);
				_param_list = _tmp400_;
				_tmp401_ = _param_list;
				_tmp402_ = vala_collection_get_size ((ValaCollection*) _tmp401_);
				_tmp403_ = _tmp402_;
				_param_size = _tmp403_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp404_;
					gint _tmp405_;
					gint _tmp406_;
					ValaParameter* param = NULL;
					ValaList* _tmp407_;
					gint _tmp408_;
					gpointer _tmp409_;
					gboolean _tmp410_;
					_tmp404_ = _param_index;
					_param_index = _tmp404_ + 1;
					_tmp405_ = _param_index;
					_tmp406_ = _param_size;
					if (!(_tmp405_ < _tmp406_)) {
						break;
					}
					_tmp407_ = _param_list;
					_tmp408_ = _param_index;
					_tmp409_ = vala_list_get (_tmp407_, _tmp408_);
					param = (ValaParameter*) _tmp409_;
					_tmp410_ = first;
					if (_tmp410_) {
						first = FALSE;
					} else {
						ValaDynamicSignal* _tmp411_;
						ValaParameter* _tmp412_;
						ValaParameter* _tmp413_;
						ValaParameter* _tmp414_;
						_tmp411_ = dynamic_sig;
						_tmp412_ = param;
						_tmp413_ = vala_parameter_copy (_tmp412_);
						_tmp414_ = _tmp413_;
						vala_callable_add_parameter ((ValaCallable*) _tmp411_, _tmp414_);
						_vala_code_node_unref0 (_tmp414_);
					}
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp415_ = vala_assignment_get_right (self);
			_tmp416_ = _tmp415_;
			_tmp417_ = sig;
			_tmp418_ = sig;
			_tmp419_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp418_);
			_tmp420_ = _tmp419_;
			_tmp421_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp420_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp422_ = _tmp421_;
			_tmp423_ = vala_signal_get_delegate (_tmp417_, (ValaDataType*) _tmp422_, (ValaCodeNode*) self);
			_tmp424_ = _tmp423_;
			_tmp425_ = vala_delegate_type_new (_tmp424_);
			_tmp426_ = _tmp425_;
			vala_expression_set_target_type (_tmp416_, (ValaDataType*) _tmp426_);
			_vala_code_node_unref0 (_tmp426_);
			_vala_code_node_unref0 (_tmp424_);
			_vala_code_node_unref0 (_tmp422_);
		} else {
			ValaExpression* _tmp427_;
			ValaExpression* _tmp428_;
			ValaDataType* _tmp429_;
			ValaDataType* _tmp430_;
			ValaExpression* _tmp431_;
			ValaExpression* _tmp432_;
			ValaDataType* _tmp433_;
			ValaDataType* _tmp434_;
			_tmp427_ = vala_assignment_get_right (self);
			_tmp428_ = _tmp427_;
			_tmp429_ = vala_expression_get_value_type (_tmp428_);
			_tmp430_ = _tmp429_;
			_tmp431_ = vala_assignment_get_right (self);
			_tmp432_ = _tmp431_;
			_tmp433_ = vala_expression_get_target_type (_tmp432_);
			_tmp434_ = _tmp433_;
			if (!vala_data_type_compatible (_tmp430_, _tmp434_)) {
				ValaDelegateType* delegate_type = NULL;
				ValaExpression* _tmp435_;
				ValaExpression* _tmp436_;
				ValaDataType* _tmp437_;
				ValaDataType* _tmp438_;
				ValaDelegateType* _tmp439_;
				ValaExpression* _tmp440_;
				ValaExpression* _tmp441_;
				ValaSourceReference* _tmp442_;
				ValaSourceReference* _tmp443_;
				ValaExpression* _tmp444_;
				ValaExpression* _tmp445_;
				ValaDataType* _tmp446_;
				ValaDataType* _tmp447_;
				gchar* _tmp448_;
				gchar* _tmp449_;
				ValaExpression* _tmp450_;
				ValaExpression* _tmp451_;
				ValaDataType* _tmp452_;
				ValaDataType* _tmp453_;
				gchar* _tmp454_;
				gchar* _tmp455_;
				ValaDelegateType* _tmp456_;
				ValaMethod* _tmp457_;
				const gchar* _tmp458_;
				const gchar* _tmp459_;
				gchar* _tmp460_;
				gchar* _tmp461_;
				gchar* _tmp462_;
				gchar* _tmp463_;
				_tmp435_ = vala_assignment_get_right (self);
				_tmp436_ = _tmp435_;
				_tmp437_ = vala_expression_get_target_type (_tmp436_);
				_tmp438_ = _tmp437_;
				_tmp439_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp438_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				delegate_type = _tmp439_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp440_ = vala_assignment_get_right (self);
				_tmp441_ = _tmp440_;
				_tmp442_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp441_);
				_tmp443_ = _tmp442_;
				_tmp444_ = vala_assignment_get_right (self);
				_tmp445_ = _tmp444_;
				_tmp446_ = vala_expression_get_value_type (_tmp445_);
				_tmp447_ = _tmp446_;
				_tmp448_ = vala_code_node_to_string ((ValaCodeNode*) _tmp447_);
				_tmp449_ = _tmp448_;
				_tmp450_ = vala_assignment_get_right (self);
				_tmp451_ = _tmp450_;
				_tmp452_ = vala_expression_get_target_type (_tmp451_);
				_tmp453_ = _tmp452_;
				_tmp454_ = vala_code_node_to_string ((ValaCodeNode*) _tmp453_);
				_tmp455_ = _tmp454_;
				_tmp456_ = delegate_type;
				_tmp457_ = m;
				_tmp458_ = vala_symbol_get_name ((ValaSymbol*) _tmp457_);
				_tmp459_ = _tmp458_;
				_tmp460_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp456_, _tmp459_);
				_tmp461_ = _tmp460_;
				_tmp462_ = g_strdup_printf ("method `%s' is incompatible with signal `%s', expected `%s'", _tmp449_, _tmp455_, _tmp461_);
				_tmp463_ = _tmp462_;
				vala_report_error (_tmp443_, _tmp463_);
				_g_free0 (_tmp463_);
				_g_free0 (_tmp461_);
				_g_free0 (_tmp455_);
				_g_free0 (_tmp449_);
				result = FALSE;
				_vala_code_node_unref0 (delegate_type);
				_vala_code_node_unref0 (right_ma);
				_vala_code_node_unref0 (dynamic_sig);
				_vala_code_node_unref0 (m);
				_vala_code_node_unref0 (sig);
				return result;
			} else {
				gboolean _tmp464_ = FALSE;
				ValaMemberAccess* _tmp465_;
				_tmp465_ = right_ma;
				if (_tmp465_ != NULL) {
					ValaMemberAccess* _tmp466_;
					gboolean _tmp467_;
					gboolean _tmp468_;
					_tmp466_ = right_ma;
					_tmp467_ = vala_member_access_get_prototype_access (_tmp466_);
					_tmp468_ = _tmp467_;
					_tmp464_ = _tmp468_;
				} else {
					_tmp464_ = FALSE;
				}
				if (_tmp464_) {
					ValaExpression* _tmp469_;
					ValaExpression* _tmp470_;
					ValaSourceReference* _tmp471_;
					ValaSourceReference* _tmp472_;
					ValaMethod* _tmp473_;
					gchar* _tmp474_;
					gchar* _tmp475_;
					gchar* _tmp476_;
					gchar* _tmp477_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp469_ = vala_assignment_get_right (self);
					_tmp470_ = _tmp469_;
					_tmp471_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp470_);
					_tmp472_ = _tmp471_;
					_tmp473_ = m;
					_tmp474_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp473_);
					_tmp475_ = _tmp474_;
					_tmp476_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp475_);
					_tmp477_ = _tmp476_;
					vala_report_error (_tmp472_, _tmp477_);
					_g_free0 (_tmp477_);
					_g_free0 (_tmp475_);
					result = FALSE;
					_vala_code_node_unref0 (right_ma);
					_vala_code_node_unref0 (dynamic_sig);
					_vala_code_node_unref0 (m);
					_vala_code_node_unref0 (sig);
					return result;
				}
			}
		}
		_vala_code_node_unref0 (right_ma);
		_vala_code_node_unref0 (dynamic_sig);
		_vala_code_node_unref0 (m);
		_vala_code_node_unref0 (sig);
	} else {
		ValaExpression* _tmp478_;
		ValaExpression* _tmp479_;
		_tmp478_ = vala_assignment_get_left (self);
		_tmp479_ = _tmp478_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp479_, VALA_TYPE_MEMBER_ACCESS)) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp480_;
			ValaExpression* _tmp481_;
			ValaMemberAccess* _tmp482_;
			ValaMemberAccess* _tmp483_;
			ValaSymbol* _tmp484_;
			ValaSymbol* _tmp485_;
			gboolean _tmp623_ = FALSE;
			ValaExpression* _tmp624_;
			ValaExpression* _tmp625_;
			ValaDataType* _tmp626_;
			ValaDataType* _tmp627_;
			ValaMemberAccess* right_ma = NULL;
			ValaExpression* _tmp682_;
			ValaExpression* _tmp683_;
			ValaMemberAccess* _tmp684_;
			gboolean _tmp685_ = FALSE;
			ValaMemberAccess* _tmp686_;
			_tmp480_ = vala_assignment_get_left (self);
			_tmp481_ = _tmp480_;
			_tmp482_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp481_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp482_;
			_tmp483_ = ma;
			_tmp484_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp483_);
			_tmp485_ = _tmp484_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp485_, VALA_TYPE_PROPERTY)) {
				ValaProperty* prop = NULL;
				ValaMemberAccess* _tmp486_;
				ValaSymbol* _tmp487_;
				ValaSymbol* _tmp488_;
				ValaProperty* _tmp489_;
				ValaDynamicProperty* dynamic_prop = NULL;
				ValaProperty* _tmp490_;
				ValaDynamicProperty* _tmp491_;
				ValaDynamicProperty* _tmp492_;
				gboolean _tmp507_ = FALSE;
				ValaProperty* _tmp508_;
				ValaPropertyAccessor* _tmp509_;
				ValaPropertyAccessor* _tmp510_;
				_tmp486_ = ma;
				_tmp487_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp486_);
				_tmp488_ = _tmp487_;
				_tmp489_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp488_, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp489_;
				_tmp490_ = prop;
				_tmp491_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp490_, VALA_TYPE_DYNAMIC_PROPERTY) ? ((ValaDynamicProperty*) _tmp490_) : NULL);
				dynamic_prop = _tmp491_;
				_tmp492_ = dynamic_prop;
				if (_tmp492_ != NULL) {
					ValaDynamicProperty* _tmp493_;
					ValaExpression* _tmp494_;
					ValaExpression* _tmp495_;
					ValaDataType* _tmp496_;
					ValaDataType* _tmp497_;
					ValaDataType* _tmp498_;
					ValaDataType* _tmp499_;
					ValaExpression* _tmp500_;
					ValaExpression* _tmp501_;
					ValaDynamicProperty* _tmp502_;
					ValaDataType* _tmp503_;
					ValaDataType* _tmp504_;
					ValaDataType* _tmp505_;
					ValaDataType* _tmp506_;
					_tmp493_ = dynamic_prop;
					_tmp494_ = vala_assignment_get_right (self);
					_tmp495_ = _tmp494_;
					_tmp496_ = vala_expression_get_value_type (_tmp495_);
					_tmp497_ = _tmp496_;
					_tmp498_ = vala_data_type_copy (_tmp497_);
					_tmp499_ = _tmp498_;
					vala_property_set_property_type ((ValaProperty*) _tmp493_, _tmp499_);
					_vala_code_node_unref0 (_tmp499_);
					_tmp500_ = vala_assignment_get_left (self);
					_tmp501_ = _tmp500_;
					_tmp502_ = dynamic_prop;
					_tmp503_ = vala_property_get_property_type ((ValaProperty*) _tmp502_);
					_tmp504_ = _tmp503_;
					_tmp505_ = vala_data_type_copy (_tmp504_);
					_tmp506_ = _tmp505_;
					vala_expression_set_value_type (_tmp501_, _tmp506_);
					_vala_code_node_unref0 (_tmp506_);
				}
				_tmp508_ = prop;
				_tmp509_ = vala_property_get_set_accessor (_tmp508_);
				_tmp510_ = _tmp509_;
				if (_tmp510_ == NULL) {
					_tmp507_ = TRUE;
				} else {
					gboolean _tmp511_ = FALSE;
					ValaProperty* _tmp512_;
					ValaPropertyAccessor* _tmp513_;
					ValaPropertyAccessor* _tmp514_;
					gboolean _tmp515_;
					gboolean _tmp516_;
					_tmp512_ = prop;
					_tmp513_ = vala_property_get_set_accessor (_tmp512_);
					_tmp514_ = _tmp513_;
					_tmp515_ = vala_property_accessor_get_writable (_tmp514_);
					_tmp516_ = _tmp515_;
					if (!_tmp516_) {
						gboolean _tmp517_ = FALSE;
						ValaSemanticAnalyzer* _tmp518_;
						ValaSemanticAnalyzer* _tmp519_;
						ValaMethod* _tmp520_;
						ValaMethod* _tmp521_;
						gboolean _tmp522_;
						_tmp518_ = vala_code_context_get_analyzer (context);
						_tmp519_ = _tmp518_;
						_tmp520_ = vala_semantic_analyzer_find_current_method (_tmp519_);
						_tmp521_ = _tmp520_;
						_tmp522_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp521_, VALA_TYPE_CREATION_METHOD);
						_vala_code_node_unref0 (_tmp521_);
						if (_tmp522_) {
							_tmp517_ = TRUE;
						} else {
							ValaSemanticAnalyzer* _tmp523_;
							ValaSemanticAnalyzer* _tmp524_;
							_tmp523_ = vala_code_context_get_analyzer (context);
							_tmp524_ = _tmp523_;
							_tmp517_ = vala_semantic_analyzer_is_in_constructor (_tmp524_);
						}
						_tmp511_ = !_tmp517_;
					} else {
						_tmp511_ = FALSE;
					}
					_tmp507_ = _tmp511_;
				}
				if (_tmp507_) {
					ValaMemberAccess* _tmp525_;
					ValaMemberAccess* _tmp526_;
					ValaSourceReference* _tmp527_;
					ValaSourceReference* _tmp528_;
					ValaProperty* _tmp529_;
					gchar* _tmp530_;
					gchar* _tmp531_;
					gchar* _tmp532_;
					gchar* _tmp533_;
					_tmp525_ = ma;
					vala_code_node_set_error ((ValaCodeNode*) _tmp525_, TRUE);
					_tmp526_ = ma;
					_tmp527_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp526_);
					_tmp528_ = _tmp527_;
					_tmp529_ = prop;
					_tmp530_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp529_);
					_tmp531_ = _tmp530_;
					_tmp532_ = g_strdup_printf ("Property `%s' is read-only", _tmp531_);
					_tmp533_ = _tmp532_;
					vala_report_error (_tmp528_, _tmp533_);
					_g_free0 (_tmp533_);
					_g_free0 (_tmp531_);
					result = FALSE;
					_vala_code_node_unref0 (dynamic_prop);
					_vala_code_node_unref0 (prop);
					_vala_code_node_unref0 (ma);
					return result;
				} else {
					gboolean _tmp534_ = FALSE;
					gboolean _tmp535_ = FALSE;
					gboolean _tmp536_;
					gboolean _tmp537_;
					_tmp536_ = vala_code_context_get_deprecated (context);
					_tmp537_ = _tmp536_;
					if (!_tmp537_) {
						ValaProperty* _tmp538_;
						ValaPropertyAccessor* _tmp539_;
						ValaPropertyAccessor* _tmp540_;
						gboolean _tmp541_;
						gboolean _tmp542_;
						_tmp538_ = prop;
						_tmp539_ = vala_property_get_set_accessor (_tmp538_);
						_tmp540_ = _tmp539_;
						_tmp541_ = vala_property_accessor_get_writable (_tmp540_);
						_tmp542_ = _tmp541_;
						_tmp535_ = !_tmp542_;
					} else {
						_tmp535_ = FALSE;
					}
					if (_tmp535_) {
						ValaSemanticAnalyzer* _tmp543_;
						ValaSemanticAnalyzer* _tmp544_;
						ValaMethod* _tmp545_;
						ValaMethod* _tmp546_;
						_tmp543_ = vala_code_context_get_analyzer (context);
						_tmp544_ = _tmp543_;
						_tmp545_ = vala_semantic_analyzer_find_current_method (_tmp544_);
						_tmp546_ = _tmp545_;
						_tmp534_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp546_, VALA_TYPE_CREATION_METHOD);
						_vala_code_node_unref0 (_tmp546_);
					} else {
						_tmp534_ = FALSE;
					}
					if (_tmp534_) {
						ValaMemberAccess* _tmp547_;
						ValaExpression* _tmp548_;
						ValaExpression* _tmp549_;
						ValaSymbol* _tmp550_;
						ValaSymbol* _tmp551_;
						ValaSemanticAnalyzer* _tmp552_;
						ValaSemanticAnalyzer* _tmp553_;
						ValaMethod* _tmp554_;
						ValaMethod* _tmp555_;
						ValaParameter* _tmp556_;
						ValaParameter* _tmp557_;
						gboolean _tmp558_;
						_tmp547_ = ma;
						_tmp548_ = vala_member_access_get_inner (_tmp547_);
						_tmp549_ = _tmp548_;
						_tmp550_ = vala_expression_get_symbol_reference (_tmp549_);
						_tmp551_ = _tmp550_;
						_tmp552_ = vala_code_context_get_analyzer (context);
						_tmp553_ = _tmp552_;
						_tmp554_ = vala_semantic_analyzer_find_current_method (_tmp553_);
						_tmp555_ = _tmp554_;
						_tmp556_ = vala_method_get_this_parameter (_tmp555_);
						_tmp557_ = _tmp556_;
						_tmp558_ = _tmp551_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp557_, VALA_TYPE_SYMBOL, ValaSymbol);
						_vala_code_node_unref0 (_tmp555_);
						if (_tmp558_) {
							ValaMemberAccess* _tmp559_;
							ValaSourceReference* _tmp560_;
							ValaSourceReference* _tmp561_;
							ValaProperty* _tmp562_;
							gchar* _tmp563_;
							gchar* _tmp564_;
							gchar* _tmp565_;
							gchar* _tmp566_;
							_tmp559_ = ma;
							_tmp560_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp559_);
							_tmp561_ = _tmp560_;
							_tmp562_ = prop;
							_tmp563_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp562_);
							_tmp564_ = _tmp563_;
							_tmp565_ = g_strdup_printf ("Property `%s' is read-only", _tmp564_);
							_tmp566_ = _tmp565_;
							vala_report_error (_tmp561_, _tmp566_);
							_g_free0 (_tmp566_);
							_g_free0 (_tmp564_);
							result = FALSE;
							_vala_code_node_unref0 (dynamic_prop);
							_vala_code_node_unref0 (prop);
							_vala_code_node_unref0 (ma);
							return result;
						} else {
							ValaMemberAccess* _tmp567_;
							ValaSourceReference* _tmp568_;
							ValaSourceReference* _tmp569_;
							_tmp567_ = ma;
							_tmp568_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp567_);
							_tmp569_ = _tmp568_;
							vala_report_error (_tmp569_, "Cannot assign to construct-only properties, use Object (property: valu" \
"e) constructor chain up");
							result = FALSE;
							_vala_code_node_unref0 (dynamic_prop);
							_vala_code_node_unref0 (prop);
							_vala_code_node_unref0 (ma);
							return result;
						}
					}
				}
				_vala_code_node_unref0 (dynamic_prop);
				_vala_code_node_unref0 (prop);
			} else {
				gboolean _tmp570_ = FALSE;
				ValaMemberAccess* _tmp571_;
				ValaSymbol* _tmp572_;
				ValaSymbol* _tmp573_;
				_tmp571_ = ma;
				_tmp572_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp571_);
				_tmp573_ = _tmp572_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp573_, VALA_TYPE_VARIABLE)) {
					ValaExpression* _tmp574_;
					ValaExpression* _tmp575_;
					ValaDataType* _tmp576_;
					ValaDataType* _tmp577_;
					_tmp574_ = vala_assignment_get_right (self);
					_tmp575_ = _tmp574_;
					_tmp576_ = vala_expression_get_value_type (_tmp575_);
					_tmp577_ = _tmp576_;
					_tmp570_ = _tmp577_ == NULL;
				} else {
					_tmp570_ = FALSE;
				}
				if (_tmp570_) {
					ValaVariable* variable = NULL;
					ValaMemberAccess* _tmp578_;
					ValaSymbol* _tmp579_;
					ValaSymbol* _tmp580_;
					ValaVariable* _tmp581_;
					gboolean _tmp582_ = FALSE;
					ValaExpression* _tmp583_;
					ValaExpression* _tmp584_;
					ValaSymbol* _tmp585_;
					ValaSymbol* _tmp586_;
					_tmp578_ = ma;
					_tmp579_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp578_);
					_tmp580_ = _tmp579_;
					_tmp581_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp580_, VALA_TYPE_VARIABLE, ValaVariable));
					variable = _tmp581_;
					_tmp583_ = vala_assignment_get_right (self);
					_tmp584_ = _tmp583_;
					_tmp585_ = vala_expression_get_symbol_reference (_tmp584_);
					_tmp586_ = _tmp585_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp586_, VALA_TYPE_METHOD)) {
						ValaVariable* _tmp587_;
						ValaDataType* _tmp588_;
						ValaDataType* _tmp589_;
						_tmp587_ = variable;
						_tmp588_ = vala_variable_get_variable_type (_tmp587_);
						_tmp589_ = _tmp588_;
						_tmp582_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp589_, VALA_TYPE_DELEGATE_TYPE);
					} else {
						_tmp582_ = FALSE;
					}
					if (_tmp582_) {
						ValaMethod* m = NULL;
						ValaExpression* _tmp590_;
						ValaExpression* _tmp591_;
						ValaSymbol* _tmp592_;
						ValaSymbol* _tmp593_;
						ValaMethod* _tmp594_;
						ValaDelegateType* dt = NULL;
						ValaVariable* _tmp595_;
						ValaDataType* _tmp596_;
						ValaDataType* _tmp597_;
						ValaDelegateType* _tmp598_;
						ValaDelegate* cb = NULL;
						ValaDelegateType* _tmp599_;
						ValaDelegate* _tmp600_;
						ValaDelegate* _tmp601_;
						ValaDelegate* _tmp602_;
						ValaDelegate* _tmp603_;
						ValaMethod* _tmp604_;
						ValaDelegateType* _tmp605_;
						ValaExpression* _tmp616_;
						ValaExpression* _tmp617_;
						ValaVariable* _tmp618_;
						ValaDataType* _tmp619_;
						ValaDataType* _tmp620_;
						_tmp590_ = vala_assignment_get_right (self);
						_tmp591_ = _tmp590_;
						_tmp592_ = vala_expression_get_symbol_reference (_tmp591_);
						_tmp593_ = _tmp592_;
						_tmp594_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp593_, VALA_TYPE_METHOD, ValaMethod));
						m = _tmp594_;
						_tmp595_ = variable;
						_tmp596_ = vala_variable_get_variable_type (_tmp595_);
						_tmp597_ = _tmp596_;
						_tmp598_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp597_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						dt = _tmp598_;
						_tmp599_ = dt;
						_tmp600_ = vala_delegate_type_get_delegate_symbol (_tmp599_);
						_tmp601_ = _tmp600_;
						_tmp602_ = _vala_code_node_ref0 (_tmp601_);
						cb = _tmp602_;
						_tmp603_ = cb;
						_tmp604_ = m;
						_tmp605_ = dt;
						if (!vala_delegate_matches_method (_tmp603_, _tmp604_, (ValaDataType*) _tmp605_)) {
							ValaSourceReference* _tmp606_;
							ValaSourceReference* _tmp607_;
							ValaMethod* _tmp608_;
							gchar* _tmp609_;
							gchar* _tmp610_;
							ValaDelegate* _tmp611_;
							gchar* _tmp612_;
							gchar* _tmp613_;
							gchar* _tmp614_;
							gchar* _tmp615_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp606_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp607_ = _tmp606_;
							_tmp608_ = m;
							_tmp609_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp608_);
							_tmp610_ = _tmp609_;
							_tmp611_ = cb;
							_tmp612_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp611_);
							_tmp613_ = _tmp612_;
							_tmp614_ = g_strdup_printf ("declaration of method `%s' doesn't match declaration of callback `%s'", _tmp610_, _tmp613_);
							_tmp615_ = _tmp614_;
							vala_report_error (_tmp607_, _tmp615_);
							_g_free0 (_tmp615_);
							_g_free0 (_tmp613_);
							_g_free0 (_tmp610_);
							result = FALSE;
							_vala_code_node_unref0 (cb);
							_vala_code_node_unref0 (dt);
							_vala_code_node_unref0 (m);
							_vala_code_node_unref0 (variable);
							_vala_code_node_unref0 (ma);
							return result;
						}
						_tmp616_ = vala_assignment_get_right (self);
						_tmp617_ = _tmp616_;
						_tmp618_ = variable;
						_tmp619_ = vala_variable_get_variable_type (_tmp618_);
						_tmp620_ = _tmp619_;
						vala_expression_set_value_type (_tmp617_, _tmp620_);
						_vala_code_node_unref0 (cb);
						_vala_code_node_unref0 (dt);
						_vala_code_node_unref0 (m);
					} else {
						ValaSourceReference* _tmp621_;
						ValaSourceReference* _tmp622_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp621_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp622_ = _tmp621_;
						vala_report_error (_tmp622_, "Assignment: Invalid assignment attempt");
						result = FALSE;
						_vala_code_node_unref0 (variable);
						_vala_code_node_unref0 (ma);
						return result;
					}
					_vala_code_node_unref0 (variable);
				}
			}
			_tmp624_ = vala_assignment_get_left (self);
			_tmp625_ = _tmp624_;
			_tmp626_ = vala_expression_get_value_type (_tmp625_);
			_tmp627_ = _tmp626_;
			if (_tmp627_ != NULL) {
				ValaExpression* _tmp628_;
				ValaExpression* _tmp629_;
				ValaDataType* _tmp630_;
				ValaDataType* _tmp631_;
				_tmp628_ = vala_assignment_get_right (self);
				_tmp629_ = _tmp628_;
				_tmp630_ = vala_expression_get_value_type (_tmp629_);
				_tmp631_ = _tmp630_;
				_tmp623_ = _tmp631_ != NULL;
			} else {
				_tmp623_ = FALSE;
			}
			if (_tmp623_) {
				ValaExpression* _tmp632_;
				ValaExpression* _tmp633_;
				ValaDataType* _tmp634_;
				ValaDataType* _tmp635_;
				ValaExpression* _tmp636_;
				ValaExpression* _tmp637_;
				ValaDataType* _tmp638_;
				ValaDataType* _tmp639_;
				ValaMemberAccess* _tmp656_;
				ValaSymbol* _tmp657_;
				ValaSymbol* _tmp658_;
				_tmp632_ = vala_assignment_get_right (self);
				_tmp633_ = _tmp632_;
				_tmp634_ = vala_expression_get_value_type (_tmp633_);
				_tmp635_ = _tmp634_;
				_tmp636_ = vala_assignment_get_left (self);
				_tmp637_ = _tmp636_;
				_tmp638_ = vala_expression_get_value_type (_tmp637_);
				_tmp639_ = _tmp638_;
				if (!vala_data_type_compatible (_tmp635_, _tmp639_)) {
					ValaSourceReference* _tmp640_;
					ValaSourceReference* _tmp641_;
					ValaExpression* _tmp642_;
					ValaExpression* _tmp643_;
					ValaDataType* _tmp644_;
					ValaDataType* _tmp645_;
					gchar* _tmp646_;
					gchar* _tmp647_;
					ValaExpression* _tmp648_;
					ValaExpression* _tmp649_;
					ValaDataType* _tmp650_;
					ValaDataType* _tmp651_;
					gchar* _tmp652_;
					gchar* _tmp653_;
					gchar* _tmp654_;
					gchar* _tmp655_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp640_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp641_ = _tmp640_;
					_tmp642_ = vala_assignment_get_right (self);
					_tmp643_ = _tmp642_;
					_tmp644_ = vala_expression_get_value_type (_tmp643_);
					_tmp645_ = _tmp644_;
					_tmp646_ = vala_code_node_to_string ((ValaCodeNode*) _tmp645_);
					_tmp647_ = _tmp646_;
					_tmp648_ = vala_assignment_get_left (self);
					_tmp649_ = _tmp648_;
					_tmp650_ = vala_expression_get_value_type (_tmp649_);
					_tmp651_ = _tmp650_;
					_tmp652_ = vala_code_node_to_string ((ValaCodeNode*) _tmp651_);
					_tmp653_ = _tmp652_;
					_tmp654_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp647_, _tmp653_);
					_tmp655_ = _tmp654_;
					vala_report_error (_tmp641_, _tmp655_);
					_g_free0 (_tmp655_);
					_g_free0 (_tmp653_);
					_g_free0 (_tmp647_);
					result = FALSE;
					_vala_code_node_unref0 (ma);
					return result;
				}
				_tmp656_ = ma;
				_tmp657_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp656_);
				_tmp658_ = _tmp657_;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp658_, VALA_TYPE_PROPERTY)) {
					ValaExpression* _tmp659_;
					ValaExpression* _tmp660_;
					ValaDataType* _tmp661_;
					ValaDataType* _tmp662_;
					_tmp659_ = vala_assignment_get_right (self);
					_tmp660_ = _tmp659_;
					_tmp661_ = vala_expression_get_value_type (_tmp660_);
					_tmp662_ = _tmp661_;
					if (vala_data_type_is_disposable (_tmp662_)) {
						gboolean _tmp663_ = FALSE;
						ValaExpression* _tmp664_;
						ValaExpression* _tmp665_;
						ValaDataType* _tmp666_;
						ValaDataType* _tmp667_;
						_tmp664_ = vala_assignment_get_left (self);
						_tmp665_ = _tmp664_;
						_tmp666_ = vala_expression_get_value_type (_tmp665_);
						_tmp667_ = _tmp666_;
						if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp667_, VALA_TYPE_POINTER_TYPE)) {
							ValaExpression* _tmp668_;
							ValaExpression* _tmp669_;
							ValaDataType* _tmp670_;
							ValaDataType* _tmp671_;
							gboolean _tmp672_;
							gboolean _tmp673_;
							_tmp668_ = vala_assignment_get_left (self);
							_tmp669_ = _tmp668_;
							_tmp670_ = vala_expression_get_value_type (_tmp669_);
							_tmp671_ = _tmp670_;
							_tmp672_ = vala_data_type_get_value_owned (_tmp671_);
							_tmp673_ = _tmp672_;
							_tmp663_ = !_tmp673_;
						} else {
							_tmp663_ = FALSE;
						}
						if (_tmp663_) {
							ValaSourceReference* _tmp674_;
							ValaSourceReference* _tmp675_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp674_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp675_ = _tmp674_;
							vala_report_error (_tmp675_, "Invalid assignment from owned expression to unowned variable");
						}
					} else {
						ValaExpression* _tmp676_;
						ValaExpression* _tmp677_;
						ValaDataType* _tmp678_;
						ValaDataType* _tmp679_;
						gboolean _tmp680_;
						gboolean _tmp681_;
						_tmp676_ = vala_assignment_get_left (self);
						_tmp677_ = _tmp676_;
						_tmp678_ = vala_expression_get_value_type (_tmp677_);
						_tmp679_ = _tmp678_;
						_tmp680_ = vala_data_type_get_value_owned (_tmp679_);
						_tmp681_ = _tmp680_;
						if (_tmp681_) {
						}
					}
				}
			}
			_tmp682_ = vala_assignment_get_right (self);
			_tmp683_ = _tmp682_;
			_tmp684_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp683_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp683_) : NULL);
			right_ma = _tmp684_;
			_tmp686_ = right_ma;
			if (_tmp686_ != NULL) {
				ValaMemberAccess* _tmp687_;
				ValaSymbol* _tmp688_;
				ValaSymbol* _tmp689_;
				ValaMemberAccess* _tmp690_;
				ValaSymbol* _tmp691_;
				ValaSymbol* _tmp692_;
				_tmp687_ = ma;
				_tmp688_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp687_);
				_tmp689_ = _tmp688_;
				_tmp690_ = right_ma;
				_tmp691_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp690_);
				_tmp692_ = _tmp691_;
				_tmp685_ = _tmp689_ == _tmp692_;
			} else {
				_tmp685_ = FALSE;
			}
			if (_tmp685_) {
				gboolean _tmp693_ = FALSE;
				ValaMemberAccess* _tmp694_;
				ValaSymbol* _tmp695_;
				ValaSymbol* _tmp696_;
				_tmp694_ = ma;
				_tmp695_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp694_);
				_tmp696_ = _tmp695_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp696_, VALA_TYPE_LOCAL_VARIABLE)) {
					_tmp693_ = TRUE;
				} else {
					ValaMemberAccess* _tmp697_;
					ValaSymbol* _tmp698_;
					ValaSymbol* _tmp699_;
					_tmp697_ = ma;
					_tmp698_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp697_);
					_tmp699_ = _tmp698_;
					_tmp693_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp699_, VALA_TYPE_PARAMETER);
				}
				if (_tmp693_) {
					ValaSourceReference* _tmp700_;
					ValaSourceReference* _tmp701_;
					_tmp700_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp701_ = _tmp700_;
					vala_report_warning (_tmp701_, "Assignment to same variable");
				} else {
					ValaMemberAccess* _tmp702_;
					ValaSymbol* _tmp703_;
					ValaSymbol* _tmp704_;
					_tmp702_ = ma;
					_tmp703_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp702_);
					_tmp704_ = _tmp703_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp704_, VALA_TYPE_FIELD)) {
						ValaField* f = NULL;
						ValaMemberAccess* _tmp705_;
						ValaSymbol* _tmp706_;
						ValaSymbol* _tmp707_;
						ValaField* _tmp708_;
						ValaField* _tmp709_;
						ValaMemberBinding _tmp710_;
						ValaMemberBinding _tmp711_;
						_tmp705_ = ma;
						_tmp706_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp705_);
						_tmp707_ = _tmp706_;
						_tmp708_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp707_, VALA_TYPE_FIELD, ValaField));
						f = _tmp708_;
						_tmp709_ = f;
						_tmp710_ = vala_field_get_binding (_tmp709_);
						_tmp711_ = _tmp710_;
						if (_tmp711_ == VALA_MEMBER_BINDING_STATIC) {
							ValaSourceReference* _tmp712_;
							ValaSourceReference* _tmp713_;
							_tmp712_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp713_ = _tmp712_;
							vala_report_warning (_tmp713_, "Assignment to same variable");
						} else {
							ValaMemberAccess* ma_inner = NULL;
							ValaMemberAccess* _tmp714_;
							ValaExpression* _tmp715_;
							ValaExpression* _tmp716_;
							ValaMemberAccess* _tmp717_;
							ValaMemberAccess* right_ma_inner = NULL;
							ValaMemberAccess* _tmp718_;
							ValaExpression* _tmp719_;
							ValaExpression* _tmp720_;
							ValaMemberAccess* _tmp721_;
							gboolean _tmp722_ = FALSE;
							gboolean _tmp723_ = FALSE;
							gboolean _tmp724_ = FALSE;
							gboolean _tmp725_ = FALSE;
							gboolean _tmp726_ = FALSE;
							ValaMemberAccess* _tmp727_;
							_tmp714_ = ma;
							_tmp715_ = vala_member_access_get_inner (_tmp714_);
							_tmp716_ = _tmp715_;
							_tmp717_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp716_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp716_) : NULL);
							ma_inner = _tmp717_;
							_tmp718_ = right_ma;
							_tmp719_ = vala_member_access_get_inner (_tmp718_);
							_tmp720_ = _tmp719_;
							_tmp721_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp720_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp720_) : NULL);
							right_ma_inner = _tmp721_;
							_tmp727_ = ma_inner;
							if (_tmp727_ != NULL) {
								ValaMemberAccess* _tmp728_;
								const gchar* _tmp729_;
								const gchar* _tmp730_;
								_tmp728_ = ma_inner;
								_tmp729_ = vala_member_access_get_member_name (_tmp728_);
								_tmp730_ = _tmp729_;
								_tmp726_ = g_strcmp0 (_tmp730_, "this") == 0;
							} else {
								_tmp726_ = FALSE;
							}
							if (_tmp726_) {
								ValaMemberAccess* _tmp731_;
								ValaExpression* _tmp732_;
								ValaExpression* _tmp733_;
								_tmp731_ = ma_inner;
								_tmp732_ = vala_member_access_get_inner (_tmp731_);
								_tmp733_ = _tmp732_;
								_tmp725_ = _tmp733_ == NULL;
							} else {
								_tmp725_ = FALSE;
							}
							if (_tmp725_) {
								ValaMemberAccess* _tmp734_;
								_tmp734_ = right_ma_inner;
								_tmp724_ = _tmp734_ != NULL;
							} else {
								_tmp724_ = FALSE;
							}
							if (_tmp724_) {
								ValaMemberAccess* _tmp735_;
								const gchar* _tmp736_;
								const gchar* _tmp737_;
								_tmp735_ = right_ma_inner;
								_tmp736_ = vala_member_access_get_member_name (_tmp735_);
								_tmp737_ = _tmp736_;
								_tmp723_ = g_strcmp0 (_tmp737_, "this") == 0;
							} else {
								_tmp723_ = FALSE;
							}
							if (_tmp723_) {
								ValaMemberAccess* _tmp738_;
								ValaExpression* _tmp739_;
								ValaExpression* _tmp740_;
								_tmp738_ = right_ma_inner;
								_tmp739_ = vala_member_access_get_inner (_tmp738_);
								_tmp740_ = _tmp739_;
								_tmp722_ = _tmp740_ == NULL;
							} else {
								_tmp722_ = FALSE;
							}
							if (_tmp722_) {
								ValaSourceReference* _tmp741_;
								ValaSourceReference* _tmp742_;
								_tmp741_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp742_ = _tmp741_;
								vala_report_warning (_tmp742_, "Assignment to same variable");
							}
							_vala_code_node_unref0 (right_ma_inner);
							_vala_code_node_unref0 (ma_inner);
						}
						_vala_code_node_unref0 (f);
					}
				}
			}
			_vala_code_node_unref0 (right_ma);
			_vala_code_node_unref0 (ma);
		} else {
			ValaExpression* _tmp743_;
			ValaExpression* _tmp744_;
			_tmp743_ = vala_assignment_get_left (self);
			_tmp744_ = _tmp743_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp744_, VALA_TYPE_ELEMENT_ACCESS)) {
				ValaElementAccess* ea = NULL;
				ValaExpression* _tmp745_;
				ValaExpression* _tmp746_;
				ValaElementAccess* _tmp747_;
				ValaExpression* _tmp748_;
				ValaExpression* _tmp749_;
				ValaDataType* _tmp750_;
				ValaDataType* _tmp751_;
				ValaExpression* _tmp752_;
				ValaExpression* _tmp753_;
				ValaDataType* _tmp754_;
				ValaDataType* _tmp755_;
				ValaExpression* _tmp772_;
				ValaExpression* _tmp773_;
				ValaDataType* _tmp774_;
				ValaDataType* _tmp775_;
				_tmp745_ = vala_assignment_get_left (self);
				_tmp746_ = _tmp745_;
				_tmp747_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp746_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
				ea = _tmp747_;
				_tmp748_ = vala_assignment_get_right (self);
				_tmp749_ = _tmp748_;
				_tmp750_ = vala_expression_get_value_type (_tmp749_);
				_tmp751_ = _tmp750_;
				_tmp752_ = vala_assignment_get_left (self);
				_tmp753_ = _tmp752_;
				_tmp754_ = vala_expression_get_value_type (_tmp753_);
				_tmp755_ = _tmp754_;
				if (!vala_data_type_compatible (_tmp751_, _tmp755_)) {
					ValaSourceReference* _tmp756_;
					ValaSourceReference* _tmp757_;
					ValaExpression* _tmp758_;
					ValaExpression* _tmp759_;
					ValaDataType* _tmp760_;
					ValaDataType* _tmp761_;
					gchar* _tmp762_;
					gchar* _tmp763_;
					ValaExpression* _tmp764_;
					ValaExpression* _tmp765_;
					ValaDataType* _tmp766_;
					ValaDataType* _tmp767_;
					gchar* _tmp768_;
					gchar* _tmp769_;
					gchar* _tmp770_;
					gchar* _tmp771_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp756_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp757_ = _tmp756_;
					_tmp758_ = vala_assignment_get_right (self);
					_tmp759_ = _tmp758_;
					_tmp760_ = vala_expression_get_value_type (_tmp759_);
					_tmp761_ = _tmp760_;
					_tmp762_ = vala_code_node_to_string ((ValaCodeNode*) _tmp761_);
					_tmp763_ = _tmp762_;
					_tmp764_ = vala_assignment_get_left (self);
					_tmp765_ = _tmp764_;
					_tmp766_ = vala_expression_get_value_type (_tmp765_);
					_tmp767_ = _tmp766_;
					_tmp768_ = vala_code_node_to_string ((ValaCodeNode*) _tmp767_);
					_tmp769_ = _tmp768_;
					_tmp770_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp763_, _tmp769_);
					_tmp771_ = _tmp770_;
					vala_report_error (_tmp757_, _tmp771_);
					_g_free0 (_tmp771_);
					_g_free0 (_tmp769_);
					_g_free0 (_tmp763_);
					result = FALSE;
					_vala_code_node_unref0 (ea);
					return result;
				}
				_tmp772_ = vala_assignment_get_right (self);
				_tmp773_ = _tmp772_;
				_tmp774_ = vala_expression_get_value_type (_tmp773_);
				_tmp775_ = _tmp774_;
				if (vala_data_type_is_disposable (_tmp775_)) {
					ValaDataType* element_type = NULL;
					ValaElementAccess* _tmp776_;
					ValaExpression* _tmp777_;
					ValaExpression* _tmp778_;
					ValaDataType* _tmp779_;
					ValaDataType* _tmp780_;
					gboolean _tmp802_ = FALSE;
					ValaDataType* _tmp803_;
					_tmp776_ = ea;
					_tmp777_ = vala_element_access_get_container (_tmp776_);
					_tmp778_ = _tmp777_;
					_tmp779_ = vala_expression_get_value_type (_tmp778_);
					_tmp780_ = _tmp779_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp780_, VALA_TYPE_ARRAY_TYPE)) {
						ValaArrayType* array_type = NULL;
						ValaElementAccess* _tmp781_;
						ValaExpression* _tmp782_;
						ValaExpression* _tmp783_;
						ValaDataType* _tmp784_;
						ValaDataType* _tmp785_;
						ValaArrayType* _tmp786_;
						ValaArrayType* _tmp787_;
						ValaDataType* _tmp788_;
						ValaDataType* _tmp789_;
						ValaDataType* _tmp790_;
						_tmp781_ = ea;
						_tmp782_ = vala_element_access_get_container (_tmp781_);
						_tmp783_ = _tmp782_;
						_tmp784_ = vala_expression_get_value_type (_tmp783_);
						_tmp785_ = _tmp784_;
						_tmp786_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp785_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp786_;
						_tmp787_ = array_type;
						_tmp788_ = vala_array_type_get_element_type (_tmp787_);
						_tmp789_ = _tmp788_;
						_tmp790_ = _vala_code_node_ref0 (_tmp789_);
						_vala_code_node_unref0 (element_type);
						element_type = _tmp790_;
						_vala_code_node_unref0 (array_type);
					} else {
						ValaList* args = NULL;
						ValaElementAccess* _tmp791_;
						ValaExpression* _tmp792_;
						ValaExpression* _tmp793_;
						ValaDataType* _tmp794_;
						ValaDataType* _tmp795_;
						ValaList* _tmp796_;
						ValaList* _tmp797_;
						gint _tmp798_;
						gint _tmp799_;
						ValaList* _tmp800_;
						gpointer _tmp801_;
						_tmp791_ = ea;
						_tmp792_ = vala_element_access_get_container (_tmp791_);
						_tmp793_ = _tmp792_;
						_tmp794_ = vala_expression_get_value_type (_tmp793_);
						_tmp795_ = _tmp794_;
						_tmp796_ = vala_data_type_get_type_arguments (_tmp795_);
						args = _tmp796_;
						_tmp797_ = args;
						_tmp798_ = vala_collection_get_size ((ValaCollection*) _tmp797_);
						_tmp799_ = _tmp798_;
						_vala_assert (_tmp799_ == 1, "args.size == 1");
						_tmp800_ = args;
						_tmp801_ = vala_list_get (_tmp800_, 0);
						_vala_code_node_unref0 (element_type);
						element_type = (ValaDataType*) _tmp801_;
						_vala_iterable_unref0 (args);
					}
					_tmp803_ = element_type;
					if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp803_, VALA_TYPE_POINTER_TYPE)) {
						ValaDataType* _tmp804_;
						gboolean _tmp805_;
						gboolean _tmp806_;
						_tmp804_ = element_type;
						_tmp805_ = vala_data_type_get_value_owned (_tmp804_);
						_tmp806_ = _tmp805_;
						_tmp802_ = !_tmp806_;
					} else {
						_tmp802_ = FALSE;
					}
					if (_tmp802_) {
						ValaSourceReference* _tmp807_;
						ValaSourceReference* _tmp808_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp807_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp808_ = _tmp807_;
						vala_report_error (_tmp808_, "Invalid assignment from owned expression to unowned variable");
						result = FALSE;
						_vala_code_node_unref0 (element_type);
						_vala_code_node_unref0 (ea);
						return result;
					}
					_vala_code_node_unref0 (element_type);
				} else {
					ValaExpression* _tmp809_;
					ValaExpression* _tmp810_;
					ValaDataType* _tmp811_;
					ValaDataType* _tmp812_;
					gboolean _tmp813_;
					gboolean _tmp814_;
					_tmp809_ = vala_assignment_get_left (self);
					_tmp810_ = _tmp809_;
					_tmp811_ = vala_expression_get_value_type (_tmp810_);
					_tmp812_ = _tmp811_;
					_tmp813_ = vala_data_type_get_value_owned (_tmp812_);
					_tmp814_ = _tmp813_;
					if (_tmp814_) {
					}
				}
				_vala_code_node_unref0 (ea);
			} else {
				result = TRUE;
				return result;
			}
		}
	}
	_tmp815_ = vala_assignment_get_left (self);
	_tmp816_ = _tmp815_;
	_tmp817_ = vala_expression_get_value_type (_tmp816_);
	_tmp818_ = _tmp817_;
	if (_tmp818_ != NULL) {
		ValaExpression* _tmp819_;
		ValaExpression* _tmp820_;
		ValaDataType* _tmp821_;
		ValaDataType* _tmp822_;
		ValaDataType* _tmp823_;
		ValaDataType* _tmp824_;
		ValaDataType* _tmp825_;
		ValaDataType* _tmp826_;
		_tmp819_ = vala_assignment_get_left (self);
		_tmp820_ = _tmp819_;
		_tmp821_ = vala_expression_get_value_type (_tmp820_);
		_tmp822_ = _tmp821_;
		_tmp823_ = vala_data_type_copy (_tmp822_);
		_tmp824_ = _tmp823_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp824_);
		_vala_code_node_unref0 (_tmp824_);
		_tmp825_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp826_ = _tmp825_;
		vala_data_type_set_value_owned (_tmp826_, FALSE);
	} else {
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
	}
	_tmp827_ = vala_assignment_get_left (self);
	_tmp828_ = _tmp827_;
	_tmp829_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp828_);
	_tmp830_ = _tmp829_;
	vala_code_node_add_error_types ((ValaCodeNode*) self, _tmp830_);
	_vala_iterable_unref0 (_tmp830_);
	_tmp831_ = vala_assignment_get_right (self);
	_tmp832_ = _tmp831_;
	_tmp833_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp832_);
	_tmp834_ = _tmp833_;
	vala_code_node_add_error_types ((ValaCodeNode*) self, _tmp834_);
	_vala_iterable_unref0 (_tmp834_);
	_tmp835_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp836_ = _tmp835_;
	result = !_tmp836_;
	return result;
}


static gboolean
vala_assignment_is_array_add (ValaAssignment* self)
{
	gboolean result = FALSE;
	ValaBinaryExpression* binary = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaBinaryExpression* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaBinaryExpression* _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_assignment_get_right (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_BINARY_EXPRESSION) ? ((ValaBinaryExpression*) _tmp1_) : NULL);
	binary = _tmp2_;
	_tmp4_ = binary;
	if (_tmp4_ != NULL) {
		ValaBinaryExpression* _tmp5_;
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp5_ = binary;
		_tmp6_ = vala_binary_expression_get_left (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_expression_get_value_type (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaBinaryExpression* _tmp10_;
		ValaBinaryOperator _tmp11_;
		ValaBinaryOperator _tmp12_;
		_tmp10_ = binary;
		_tmp11_ = vala_binary_expression_get_operator (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ == VALA_BINARY_OPERATOR_PLUS) {
			ValaExpression* _tmp13_;
			ValaExpression* _tmp14_;
			ValaSymbol* _tmp15_;
			ValaSymbol* _tmp16_;
			ValaBinaryExpression* _tmp17_;
			ValaExpression* _tmp18_;
			ValaExpression* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaSymbol* _tmp21_;
			_tmp13_ = vala_assignment_get_left (self);
			_tmp14_ = _tmp13_;
			_tmp15_ = vala_expression_get_symbol_reference (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = binary;
			_tmp18_ = vala_binary_expression_get_left (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_expression_get_symbol_reference (_tmp19_);
			_tmp21_ = _tmp20_;
			if (_tmp16_ == _tmp21_) {
				result = TRUE;
				_vala_code_node_unref0 (binary);
				return result;
			}
		}
	}
	result = FALSE;
	_vala_code_node_unref0 (binary);
	return result;
}


static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}


static void
vala_assignment_real_emit (ValaCodeNode* base, 
                           ValaCodeGenerator* codegen)
{
	ValaAssignment * self;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaMemberAccess* _tmp2_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaElementAccess* _tmp5_;
	ValaPointerIndirection* pi = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaPointerIndirection* _tmp8_;
	ValaMemberAccess* _tmp9_;
	ValaExpression* _tmp136_;
	ValaExpression* _tmp137_;
	self = (ValaAssignment*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp1_) : NULL);
	ma = _tmp2_;
	_tmp3_ = vala_assignment_get_left (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_ELEMENT_ACCESS) ? ((ValaElementAccess*) _tmp4_) : NULL);
	ea = _tmp5_;
	_tmp6_ = vala_assignment_get_left (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_POINTER_INDIRECTION) ? ((ValaPointerIndirection*) _tmp7_) : NULL);
	pi = _tmp8_;
	_tmp9_ = ma;
	if (_tmp9_ != NULL) {
		ValaLocalVariable* local = NULL;
		ValaMemberAccess* _tmp10_;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaLocalVariable* _tmp13_;
		ValaParameter* param = NULL;
		ValaMemberAccess* _tmp14_;
		ValaSymbol* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaParameter* _tmp17_;
		ValaField* field = NULL;
		ValaMemberAccess* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaField* _tmp21_;
		ValaProperty* property = NULL;
		ValaMemberAccess* _tmp22_;
		ValaSymbol* _tmp23_;
		ValaSymbol* _tmp24_;
		ValaProperty* _tmp25_;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
		ValaField* _tmp28_;
		gboolean instance = FALSE;
		gboolean _tmp37_ = FALSE;
		gboolean _tmp38_ = FALSE;
		gboolean _tmp39_ = FALSE;
		gboolean _tmp40_ = FALSE;
		ValaAssignmentOperator _tmp41_;
		gboolean _tmp121_ = FALSE;
		gboolean _tmp122_ = FALSE;
		gboolean _tmp123_;
		_tmp10_ = ma;
		_tmp11_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp12_) : NULL);
		local = _tmp13_;
		_tmp14_ = ma;
		_tmp15_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_PARAMETER) ? ((ValaParameter*) _tmp16_) : NULL);
		param = _tmp17_;
		_tmp18_ = ma;
		_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, VALA_TYPE_FIELD) ? ((ValaField*) _tmp20_) : NULL);
		field = _tmp21_;
		_tmp22_ = ma;
		_tmp23_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALA_TYPE_PROPERTY) ? ((ValaProperty*) _tmp24_) : NULL);
		property = _tmp25_;
		_tmp28_ = field;
		if (_tmp28_ != NULL) {
			ValaField* _tmp29_;
			ValaMemberBinding _tmp30_;
			ValaMemberBinding _tmp31_;
			_tmp29_ = field;
			_tmp30_ = vala_field_get_binding (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp27_ = _tmp31_ != VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			_tmp26_ = TRUE;
		} else {
			gboolean _tmp32_ = FALSE;
			ValaProperty* _tmp33_;
			_tmp33_ = property;
			if (_tmp33_ != NULL) {
				ValaProperty* _tmp34_;
				ValaMemberBinding _tmp35_;
				ValaMemberBinding _tmp36_;
				_tmp34_ = property;
				_tmp35_ = vala_property_get_binding (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp32_ = _tmp36_ != VALA_MEMBER_BINDING_STATIC;
			} else {
				_tmp32_ = FALSE;
			}
			_tmp26_ = _tmp32_;
		}
		instance = _tmp26_;
		_tmp41_ = self->priv->_operator;
		if (_tmp41_ == VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
			gboolean _tmp42_ = FALSE;
			gboolean _tmp43_ = FALSE;
			ValaLocalVariable* _tmp44_;
			_tmp44_ = local;
			if (_tmp44_ != NULL) {
				_tmp43_ = TRUE;
			} else {
				ValaParameter* _tmp45_;
				_tmp45_ = param;
				_tmp43_ = _tmp45_ != NULL;
			}
			if (_tmp43_) {
				_tmp42_ = TRUE;
			} else {
				ValaField* _tmp46_;
				_tmp46_ = field;
				_tmp42_ = _tmp46_ != NULL;
			}
			_tmp40_ = _tmp42_;
		} else {
			_tmp40_ = FALSE;
		}
		if (_tmp40_) {
			_tmp39_ = !vala_assignment_is_array_add (self);
		} else {
			_tmp39_ = FALSE;
		}
		if (_tmp39_) {
			ValaField* _tmp47_;
			_tmp47_ = field;
			_tmp38_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, VALA_TYPE_ARRAY_LENGTH_FIELD);
		} else {
			_tmp38_ = FALSE;
		}
		if (_tmp38_) {
			gboolean _tmp48_ = FALSE;
			ValaExpression* _tmp49_;
			ValaExpression* _tmp50_;
			ValaDataType* _tmp51_;
			ValaDataType* _tmp52_;
			_tmp49_ = vala_assignment_get_left (self);
			_tmp50_ = _tmp49_;
			_tmp51_ = vala_expression_get_value_type (_tmp50_);
			_tmp52_ = _tmp51_;
			if (vala_data_type_is_real_non_null_struct_type (_tmp52_)) {
				ValaExpression* _tmp53_;
				ValaExpression* _tmp54_;
				_tmp53_ = vala_assignment_get_right (self);
				_tmp54_ = _tmp53_;
				_tmp48_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp54_, VALA_TYPE_OBJECT_CREATION_EXPRESSION);
			} else {
				_tmp48_ = FALSE;
			}
			_tmp37_ = !_tmp48_;
		} else {
			_tmp37_ = FALSE;
		}
		if (_tmp37_) {
			gboolean _tmp55_ = FALSE;
			gboolean _tmp56_;
			ValaExpression* _tmp63_;
			ValaExpression* _tmp64_;
			ValaTargetValue* new_value = NULL;
			ValaExpression* _tmp65_;
			ValaExpression* _tmp66_;
			ValaTargetValue* _tmp67_;
			ValaTargetValue* _tmp68_;
			ValaTargetValue* _tmp69_;
			ValaLocalVariable* _tmp70_;
			ValaCodeNode* _tmp96_;
			ValaCodeNode* _tmp97_;
			_tmp56_ = instance;
			if (_tmp56_) {
				ValaMemberAccess* _tmp57_;
				ValaExpression* _tmp58_;
				ValaExpression* _tmp59_;
				_tmp57_ = ma;
				_tmp58_ = vala_member_access_get_inner (_tmp57_);
				_tmp59_ = _tmp58_;
				_tmp55_ = _tmp59_ != NULL;
			} else {
				_tmp55_ = FALSE;
			}
			if (_tmp55_) {
				ValaMemberAccess* _tmp60_;
				ValaExpression* _tmp61_;
				ValaExpression* _tmp62_;
				_tmp60_ = ma;
				_tmp61_ = vala_member_access_get_inner (_tmp60_);
				_tmp62_ = _tmp61_;
				vala_code_node_emit ((ValaCodeNode*) _tmp62_, codegen);
			}
			_tmp63_ = vala_assignment_get_right (self);
			_tmp64_ = _tmp63_;
			vala_code_node_emit ((ValaCodeNode*) _tmp64_, codegen);
			_tmp65_ = vala_assignment_get_right (self);
			_tmp66_ = _tmp65_;
			_tmp67_ = vala_expression_get_target_value (_tmp66_);
			_tmp68_ = _tmp67_;
			_tmp69_ = _vala_target_value_ref0 (_tmp68_);
			new_value = _tmp69_;
			_tmp70_ = local;
			if (_tmp70_ != NULL) {
				ValaLocalVariable* _tmp71_;
				ValaTargetValue* _tmp72_;
				ValaSourceReference* _tmp73_;
				ValaSourceReference* _tmp74_;
				_tmp71_ = local;
				_tmp72_ = new_value;
				_tmp73_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp74_ = _tmp73_;
				vala_code_generator_store_local (codegen, _tmp71_, _tmp72_, FALSE, _tmp74_);
			} else {
				ValaParameter* _tmp75_;
				_tmp75_ = param;
				if (_tmp75_ != NULL) {
					ValaParameter* _tmp76_;
					ValaTargetValue* _tmp77_;
					ValaSourceReference* _tmp78_;
					ValaSourceReference* _tmp79_;
					_tmp76_ = param;
					_tmp77_ = new_value;
					_tmp78_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp79_ = _tmp78_;
					vala_code_generator_store_parameter (codegen, _tmp76_, _tmp77_, FALSE, _tmp79_);
				} else {
					ValaField* _tmp80_;
					_tmp80_ = field;
					if (_tmp80_ != NULL) {
						ValaTargetValue* _tmp81_ = NULL;
						gboolean _tmp82_ = FALSE;
						gboolean _tmp83_;
						ValaField* _tmp92_;
						ValaTargetValue* _tmp93_;
						ValaSourceReference* _tmp94_;
						ValaSourceReference* _tmp95_;
						_tmp83_ = instance;
						if (_tmp83_) {
							ValaMemberAccess* _tmp84_;
							ValaExpression* _tmp85_;
							ValaExpression* _tmp86_;
							_tmp84_ = ma;
							_tmp85_ = vala_member_access_get_inner (_tmp84_);
							_tmp86_ = _tmp85_;
							_tmp82_ = _tmp86_ != NULL;
						} else {
							_tmp82_ = FALSE;
						}
						if (_tmp82_) {
							ValaMemberAccess* _tmp87_;
							ValaExpression* _tmp88_;
							ValaExpression* _tmp89_;
							ValaTargetValue* _tmp90_;
							ValaTargetValue* _tmp91_;
							_tmp87_ = ma;
							_tmp88_ = vala_member_access_get_inner (_tmp87_);
							_tmp89_ = _tmp88_;
							_tmp90_ = vala_expression_get_target_value (_tmp89_);
							_tmp91_ = _tmp90_;
							_tmp81_ = _tmp91_;
						} else {
							_tmp81_ = NULL;
						}
						_tmp92_ = field;
						_tmp93_ = new_value;
						_tmp94_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp95_ = _tmp94_;
						vala_code_generator_store_field (codegen, _tmp92_, _tmp81_, _tmp93_, _tmp95_);
					}
				}
			}
			_tmp96_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp97_ = _tmp96_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp97_, VALA_TYPE_EXPRESSION_STATEMENT)) {
				ValaLocalVariable* _tmp98_;
				_tmp98_ = local;
				if (_tmp98_ != NULL) {
					ValaLocalVariable* _tmp99_;
					ValaTargetValue* _tmp100_;
					ValaTargetValue* _tmp101_;
					_tmp99_ = local;
					_tmp100_ = vala_code_generator_load_local (codegen, _tmp99_);
					_tmp101_ = _tmp100_;
					vala_expression_set_target_value ((ValaExpression*) self, _tmp101_);
					_vala_target_value_unref0 (_tmp101_);
				} else {
					ValaParameter* _tmp102_;
					_tmp102_ = param;
					if (_tmp102_ != NULL) {
						ValaParameter* _tmp103_;
						ValaTargetValue* _tmp104_;
						ValaTargetValue* _tmp105_;
						_tmp103_ = param;
						_tmp104_ = vala_code_generator_load_parameter (codegen, _tmp103_);
						_tmp105_ = _tmp104_;
						vala_expression_set_target_value ((ValaExpression*) self, _tmp105_);
						_vala_target_value_unref0 (_tmp105_);
					} else {
						ValaField* _tmp106_;
						_tmp106_ = field;
						if (_tmp106_ != NULL) {
							ValaTargetValue* _tmp107_ = NULL;
							gboolean _tmp108_ = FALSE;
							gboolean _tmp109_;
							ValaField* _tmp118_;
							ValaTargetValue* _tmp119_;
							ValaTargetValue* _tmp120_;
							_tmp109_ = instance;
							if (_tmp109_) {
								ValaMemberAccess* _tmp110_;
								ValaExpression* _tmp111_;
								ValaExpression* _tmp112_;
								_tmp110_ = ma;
								_tmp111_ = vala_member_access_get_inner (_tmp110_);
								_tmp112_ = _tmp111_;
								_tmp108_ = _tmp112_ != NULL;
							} else {
								_tmp108_ = FALSE;
							}
							if (_tmp108_) {
								ValaMemberAccess* _tmp113_;
								ValaExpression* _tmp114_;
								ValaExpression* _tmp115_;
								ValaTargetValue* _tmp116_;
								ValaTargetValue* _tmp117_;
								_tmp113_ = ma;
								_tmp114_ = vala_member_access_get_inner (_tmp113_);
								_tmp115_ = _tmp114_;
								_tmp116_ = vala_expression_get_target_value (_tmp115_);
								_tmp117_ = _tmp116_;
								_tmp107_ = _tmp117_;
							} else {
								_tmp107_ = NULL;
							}
							_tmp118_ = field;
							_tmp119_ = vala_code_generator_load_field (codegen, _tmp118_, _tmp107_);
							_tmp120_ = _tmp119_;
							vala_expression_set_target_value ((ValaExpression*) self, _tmp120_);
							_vala_target_value_unref0 (_tmp120_);
						}
					}
				}
			}
			vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
			_vala_target_value_unref0 (new_value);
			_vala_code_node_unref0 (property);
			_vala_code_node_unref0 (field);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (pi);
			_vala_code_node_unref0 (ea);
			_vala_code_node_unref0 (ma);
			return;
		}
		_tmp123_ = instance;
		if (_tmp123_) {
			ValaMemberAccess* _tmp124_;
			ValaExpression* _tmp125_;
			ValaExpression* _tmp126_;
			_tmp124_ = ma;
			_tmp125_ = vala_member_access_get_inner (_tmp124_);
			_tmp126_ = _tmp125_;
			_tmp122_ = _tmp126_ != NULL;
		} else {
			_tmp122_ = FALSE;
		}
		if (_tmp122_) {
			ValaProperty* _tmp127_;
			_tmp127_ = property;
			_tmp121_ = _tmp127_ != NULL;
		} else {
			_tmp121_ = FALSE;
		}
		if (_tmp121_) {
			ValaMemberAccess* _tmp128_;
			ValaExpression* _tmp129_;
			ValaExpression* _tmp130_;
			_tmp128_ = ma;
			_tmp129_ = vala_member_access_get_inner (_tmp128_);
			_tmp130_ = _tmp129_;
			vala_code_node_emit ((ValaCodeNode*) _tmp130_, codegen);
		} else {
			ValaMemberAccess* _tmp131_;
			_tmp131_ = ma;
			vala_code_node_emit ((ValaCodeNode*) _tmp131_, codegen);
		}
		_vala_code_node_unref0 (property);
		_vala_code_node_unref0 (field);
		_vala_code_node_unref0 (param);
		_vala_code_node_unref0 (local);
	} else {
		ValaElementAccess* _tmp132_;
		_tmp132_ = ea;
		if (_tmp132_ != NULL) {
			ValaElementAccess* _tmp133_;
			_tmp133_ = ea;
			vala_code_node_emit ((ValaCodeNode*) _tmp133_, codegen);
		} else {
			ValaPointerIndirection* _tmp134_;
			_tmp134_ = pi;
			if (_tmp134_ != NULL) {
				ValaPointerIndirection* _tmp135_;
				_tmp135_ = pi;
				vala_code_node_emit ((ValaCodeNode*) _tmp135_, codegen);
			}
		}
	}
	_tmp136_ = vala_assignment_get_right (self);
	_tmp137_ = _tmp136_;
	vala_code_node_emit ((ValaCodeNode*) _tmp137_, codegen);
	vala_code_visitor_visit_assignment ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
	_vala_code_node_unref0 (pi);
	_vala_code_node_unref0 (ea);
	_vala_code_node_unref0 (ma);
}


static void
vala_assignment_real_get_defined_variables (ValaCodeNode* base, 
                                            ValaCollection* collection)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaLocalVariable* local = NULL;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	ValaParameter* param = NULL;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaParameter* _tmp13_;
	ValaLocalVariable* _tmp14_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_right (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_assignment_get_left (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	_tmp4_ = vala_assignment_get_left (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_expression_get_symbol_reference (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp7_) : NULL);
	local = _tmp8_;
	_tmp9_ = vala_assignment_get_left (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_expression_get_symbol_reference (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_PARAMETER) ? ((ValaParameter*) _tmp12_) : NULL);
	param = _tmp13_;
	_tmp14_ = local;
	if (_tmp14_ != NULL) {
		ValaLocalVariable* _tmp15_;
		_tmp15_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp15_);
	} else {
		gboolean _tmp16_ = FALSE;
		ValaParameter* _tmp17_;
		_tmp17_ = param;
		if (_tmp17_ != NULL) {
			ValaParameter* _tmp18_;
			ValaParameterDirection _tmp19_;
			ValaParameterDirection _tmp20_;
			_tmp18_ = param;
			_tmp19_ = vala_parameter_get_direction (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp16_ = _tmp20_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			ValaParameter* _tmp21_;
			_tmp21_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp21_);
		}
	}
	_vala_code_node_unref0 (param);
	_vala_code_node_unref0 (local);
}


static void
vala_assignment_real_get_used_variables (ValaCodeNode* base, 
                                         ValaCollection* collection)
{
	ValaAssignment * self;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaMemberAccess* _tmp2_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaElementAccess* _tmp5_;
	gboolean _tmp6_ = FALSE;
	ValaMemberAccess* _tmp7_;
	ValaExpression* _tmp16_;
	ValaExpression* _tmp17_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp1_) : NULL);
	ma = _tmp2_;
	_tmp3_ = vala_assignment_get_left (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_ELEMENT_ACCESS) ? ((ValaElementAccess*) _tmp4_) : NULL);
	ea = _tmp5_;
	_tmp7_ = ma;
	if (_tmp7_ != NULL) {
		ValaMemberAccess* _tmp8_;
		ValaExpression* _tmp9_;
		ValaExpression* _tmp10_;
		_tmp8_ = ma;
		_tmp9_ = vala_member_access_get_inner (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp6_ = _tmp10_ != NULL;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValaMemberAccess* _tmp11_;
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		_tmp11_ = ma;
		_tmp12_ = vala_member_access_get_inner (_tmp11_);
		_tmp13_ = _tmp12_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp13_, collection);
	} else {
		ValaElementAccess* _tmp14_;
		_tmp14_ = ea;
		if (_tmp14_ != NULL) {
			ValaElementAccess* _tmp15_;
			_tmp15_ = ea;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp15_, collection);
		}
	}
	_tmp16_ = vala_assignment_get_right (self);
	_tmp17_ = _tmp16_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp17_, collection);
	_vala_code_node_unref0 (ea);
	_vala_code_node_unref0 (ma);
}


ValaExpression*
vala_assignment_get_left (ValaAssignment* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_left;
	result = _tmp0_;
	return result;
}


void
vala_assignment_set_left (ValaAssignment* self, 
                          ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_left);
	self->priv->_left = _tmp0_;
	_tmp1_ = self->priv->_left;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


ValaAssignmentOperator
vala_assignment_get_operator (ValaAssignment* self)
{
	ValaAssignmentOperator result;
	ValaAssignmentOperator _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_operator;
	result = _tmp0_;
	return result;
}


void
vala_assignment_set_operator (ValaAssignment* self, 
                              ValaAssignmentOperator value)
{
	g_return_if_fail (self != NULL);
	self->priv->_operator = value;
}


ValaExpression*
vala_assignment_get_right (ValaAssignment* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_right;
	result = _tmp0_;
	return result;
}


void
vala_assignment_set_right (ValaAssignment* self, 
                           ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_right);
	self->priv->_right = _tmp0_;
	_tmp1_ = self->priv->_right;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


static void
vala_assignment_class_init (ValaAssignmentClass * klass)
{
	vala_assignment_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_assignment_finalize;
	g_type_class_add_private (klass, sizeof (ValaAssignmentPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_assignment_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_assignment_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_assignment_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression *)) vala_assignment_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression *, ValaSymbol*)) vala_assignment_real_is_accessible;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_assignment_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_assignment_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_assignment_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_assignment_real_get_used_variables;
}


static void
vala_assignment_instance_init (ValaAssignment * self)
{
	self->priv = VALA_ASSIGNMENT_GET_PRIVATE (self);
}


static void
vala_assignment_finalize (ValaCodeNode * obj)
{
	ValaAssignment * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ASSIGNMENT, ValaAssignment);
	_vala_code_node_unref0 (self->priv->_left);
	_vala_code_node_unref0 (self->priv->_right);
	VALA_CODE_NODE_CLASS (vala_assignment_parent_class)->finalize (obj);
}


/**
 * Represents an assignment expression in the source code.
 *
 * Supports =, |=, &=, ^=, +=, -=, *=, /=, %=, <<=, >>=.
 */
GType
vala_assignment_get_type (void)
{
	static volatile gsize vala_assignment_type_id__volatile = 0;
	if (g_once_init_enter (&vala_assignment_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaAssignmentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_assignment_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaAssignment), 0, (GInstanceInitFunc) vala_assignment_instance_init, NULL };
		GType vala_assignment_type_id;
		vala_assignment_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaAssignment", &g_define_type_info, 0);
		g_once_init_leave (&vala_assignment_type_id__volatile, vala_assignment_type_id);
	}
	return vala_assignment_type_id__volatile;
}


GType
vala_assignment_operator_get_type (void)
{
	static volatile gsize vala_assignment_operator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_assignment_operator_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_ASSIGNMENT_OPERATOR_NONE, "VALA_ASSIGNMENT_OPERATOR_NONE", "none"}, {VALA_ASSIGNMENT_OPERATOR_SIMPLE, "VALA_ASSIGNMENT_OPERATOR_SIMPLE", "simple"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_OR, "VALA_ASSIGNMENT_OPERATOR_BITWISE_OR", "bitwise-or"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_AND, "VALA_ASSIGNMENT_OPERATOR_BITWISE_AND", "bitwise-and"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR, "VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR", "bitwise-xor"}, {VALA_ASSIGNMENT_OPERATOR_ADD, "VALA_ASSIGNMENT_OPERATOR_ADD", "add"}, {VALA_ASSIGNMENT_OPERATOR_SUB, "VALA_ASSIGNMENT_OPERATOR_SUB", "sub"}, {VALA_ASSIGNMENT_OPERATOR_MUL, "VALA_ASSIGNMENT_OPERATOR_MUL", "mul"}, {VALA_ASSIGNMENT_OPERATOR_DIV, "VALA_ASSIGNMENT_OPERATOR_DIV", "div"}, {VALA_ASSIGNMENT_OPERATOR_PERCENT, "VALA_ASSIGNMENT_OPERATOR_PERCENT", "percent"}, {VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT, "VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT", "shift-left"}, {VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT, "VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT", "shift-right"}, {0, NULL, NULL}};
		GType vala_assignment_operator_type_id;
		vala_assignment_operator_type_id = g_enum_register_static ("ValaAssignmentOperator", values);
		g_once_init_leave (&vala_assignment_operator_type_id__volatile, vala_assignment_operator_type_id);
	}
	return vala_assignment_operator_type_id__volatile;
}



