/* valaarraycreationexpression.c generated by valac, the Vala compiler
 * generated from valaarraycreationexpression.vala, do not modify */

/* valaarraycreationexpression.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>

enum  {
	VALA_ARRAY_CREATION_EXPRESSION_0_PROPERTY,
	VALA_ARRAY_CREATION_EXPRESSION_NUM_PROPERTIES
};
static GParamSpec* vala_array_creation_expression_properties[VALA_ARRAY_CREATION_EXPRESSION_NUM_PROPERTIES];
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaArrayCreationExpressionPrivate {
	gint _rank;
	ValaList* sizes;
	ValaDataType* _element_type;
	ValaInitializerList* _initializer_list;
};


static gpointer vala_array_creation_expression_parent_class = NULL;

#define VALA_ARRAY_CREATION_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpressionPrivate))
static void vala_array_creation_expression_real_accept_children (ValaCodeNode* base, 
                                                          ValaCodeVisitor* visitor);
static void vala_array_creation_expression_real_accept (ValaCodeNode* base, 
                                                 ValaCodeVisitor* visitor);
static gboolean vala_array_creation_expression_real_is_pure (ValaExpression* base);
static gboolean vala_array_creation_expression_real_is_accessible (ValaExpression* base, 
                                                            ValaSymbol* sym);
static void vala_array_creation_expression_real_replace_expression (ValaCodeNode* base, 
                                                             ValaExpression* old_node, 
                                                             ValaExpression* new_node);
static void vala_array_creation_expression_real_replace_type (ValaCodeNode* base, 
                                                       ValaDataType* old_type, 
                                                       ValaDataType* new_type);
static gint vala_array_creation_expression_create_sizes_from_initializer_list (ValaArrayCreationExpression* self, 
                                                                        ValaCodeContext* context, 
                                                                        ValaInitializerList* il, 
                                                                        gint rank, 
                                                                        ValaList* sl);
static gboolean vala_array_creation_expression_real_check (ValaCodeNode* base, 
                                                    ValaCodeContext* context);
static void vala_array_creation_expression_real_emit (ValaCodeNode* base, 
                                               ValaCodeGenerator* codegen);
static void vala_array_creation_expression_real_get_used_variables (ValaCodeNode* base, 
                                                             ValaCollection* collection);
static void vala_array_creation_expression_finalize (ValaCodeNode * obj);


/**
 * Add a size expression.
 */
void
vala_array_creation_expression_append_size (ValaArrayCreationExpression* self, 
                                            ValaExpression* size)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (size != NULL);
	_tmp0_ = self->priv->sizes;
	vala_collection_add ((ValaCollection*) _tmp0_, size);
	if (size != NULL) {
		vala_code_node_set_parent_node ((ValaCodeNode*) size, (ValaCodeNode*) self);
	}
}


/**
 * Get the sizes for all dimensions ascending from left to right.
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_array_creation_expression_get_sizes (ValaArrayCreationExpression* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sizes;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


ValaArrayCreationExpression*
vala_array_creation_expression_construct (GType object_type, 
                                          ValaDataType* element_type, 
                                          gint rank, 
                                          ValaInitializerList* initializer_list, 
                                          ValaSourceReference* source_reference)
{
	ValaArrayCreationExpression* self = NULL;
	g_return_val_if_fail (element_type != NULL, NULL);
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaArrayCreationExpression*) vala_expression_construct (object_type);
	vala_array_creation_expression_set_element_type (self, element_type);
	vala_array_creation_expression_set_rank (self, rank);
	vala_array_creation_expression_set_initializer_list (self, initializer_list);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaArrayCreationExpression*
vala_array_creation_expression_new (ValaDataType* element_type, 
                                    gint rank, 
                                    ValaInitializerList* initializer_list, 
                                    ValaSourceReference* source_reference)
{
	return vala_array_creation_expression_construct (VALA_TYPE_ARRAY_CREATION_EXPRESSION, element_type, rank, initializer_list, source_reference);
}


static void
vala_array_creation_expression_real_accept_children (ValaCodeNode* base, 
                                                     ValaCodeVisitor* visitor)
{
	ValaArrayCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaInitializerList* _tmp16_;
	ValaInitializerList* _tmp17_;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_array_creation_expression_get_element_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		_tmp2_ = vala_array_creation_expression_get_element_type (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _e_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _e_index = 0;
		_tmp4_ = self->priv->sizes;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_e_list = _tmp5_;
		_tmp6_ = _e_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_e_size = _tmp8_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			ValaExpression* e = NULL;
			ValaList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_;
			ValaExpression* _tmp15_;
			_tmp9_ = _e_index;
			_e_index = _tmp9_ + 1;
			_tmp10_ = _e_index;
			_tmp11_ = _e_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _e_list;
			_tmp13_ = _e_index;
			_tmp14_ = vala_list_get (_tmp12_, _tmp13_);
			e = (ValaExpression*) _tmp14_;
			_tmp15_ = e;
			vala_code_node_accept ((ValaCodeNode*) _tmp15_, visitor);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp16_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp17_ = _tmp16_;
	if (_tmp17_ != NULL) {
		ValaInitializerList* _tmp18_;
		ValaInitializerList* _tmp19_;
		_tmp18_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp19_ = _tmp18_;
		vala_code_node_accept ((ValaCodeNode*) _tmp19_, visitor);
	}
}


static void
vala_array_creation_expression_real_accept (ValaCodeNode* base, 
                                            ValaCodeVisitor* visitor)
{
	ValaArrayCreationExpression * self;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_array_creation_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static gboolean
vala_array_creation_expression_real_is_pure (ValaExpression* base)
{
	ValaArrayCreationExpression * self;
	gboolean result = FALSE;
	self = (ValaArrayCreationExpression*) base;
	result = FALSE;
	return result;
}


static gboolean
vala_array_creation_expression_real_is_accessible (ValaExpression* base, 
                                                   ValaSymbol* sym)
{
	ValaArrayCreationExpression * self;
	gboolean result = FALSE;
	ValaInitializerList* _tmp12_;
	ValaInitializerList* _tmp13_;
	self = (ValaArrayCreationExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _e_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _e_index = 0;
		_tmp0_ = self->priv->sizes;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_e_list = _tmp1_;
		_tmp2_ = _e_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_e_size = _tmp4_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* e = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _e_index;
			_e_index = _tmp5_ + 1;
			_tmp6_ = _e_index;
			_tmp7_ = _e_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _e_list;
			_tmp9_ = _e_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			e = (ValaExpression*) _tmp10_;
			_tmp11_ = e;
			if (!vala_expression_is_accessible (_tmp11_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (e);
				_vala_iterable_unref0 (_e_list);
				return result;
			}
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp12_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaInitializerList* _tmp14_;
		ValaInitializerList* _tmp15_;
		_tmp14_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp15_ = _tmp14_;
		result = vala_expression_is_accessible ((ValaExpression*) _tmp15_, sym);
		return result;
	}
	result = TRUE;
	return result;
}


static void
vala_array_creation_expression_real_replace_expression (ValaCodeNode* base, 
                                                        ValaExpression* old_node, 
                                                        ValaExpression* new_node)
{
	ValaArrayCreationExpression * self;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ValaList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				ValaList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				ValaExpression* _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->sizes;
				_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->sizes;
				_tmp7_ = i;
				_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
				_tmp9_ = (ValaExpression*) _tmp8_;
				_tmp10_ = _tmp9_ == old_node;
				_vala_code_node_unref0 (_tmp9_);
				if (_tmp10_) {
					ValaList* _tmp11_;
					gint _tmp12_;
					_tmp11_ = self->priv->sizes;
					_tmp12_ = i;
					vala_list_set (_tmp11_, _tmp12_, new_node);
					return;
				}
			}
		}
	}
}


static void
vala_array_creation_expression_real_replace_type (ValaCodeNode* base, 
                                                  ValaDataType* old_type, 
                                                  ValaDataType* new_type)
{
	ValaArrayCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_array_creation_expression_get_element_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_array_creation_expression_set_element_type (self, new_type);
	}
}


static gint
vala_array_creation_expression_create_sizes_from_initializer_list (ValaArrayCreationExpression* self, 
                                                                   ValaCodeContext* context, 
                                                                   ValaInitializerList* il, 
                                                                   gint rank, 
                                                                   ValaList* sl)
{
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint subsize = 0;
	gint _tmp45_;
	gint _tmp46_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (context != NULL, 0);
	g_return_val_if_fail (il != NULL, 0);
	g_return_val_if_fail (sl != NULL, 0);
	_tmp0_ = vala_collection_get_size ((ValaCollection*) sl);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_rank;
	if (_tmp1_ == (_tmp2_ - rank)) {
		ValaIntegerLiteral* init = NULL;
		gint _tmp3_;
		gint _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaSourceReference* _tmp8_;
		ValaIntegerLiteral* _tmp9_;
		ValaIntegerLiteral* _tmp10_;
		ValaIntegerLiteral* _tmp11_;
		ValaIntegerLiteral* _tmp12_;
		_tmp3_ = vala_initializer_list_get_size (il);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("%i", _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_code_node_get_source_reference ((ValaCodeNode*) il);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_integer_literal_new (_tmp6_, _tmp8_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp6_);
		init = _tmp10_;
		_tmp11_ = init;
		vala_code_node_check ((ValaCodeNode*) _tmp11_, context);
		_tmp12_ = init;
		vala_collection_add ((ValaCollection*) sl, (ValaLiteral*) _tmp12_);
		_vala_code_node_unref0 (init);
	}
	subsize = -1;
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp13_;
		gint _e_size = 0;
		ValaList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _e_index = 0;
		_tmp13_ = vala_initializer_list_get_initializers (il);
		_e_list = _tmp13_;
		_tmp14_ = _e_list;
		_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_e_size = _tmp16_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			ValaExpression* e = NULL;
			ValaList* _tmp20_;
			gint _tmp21_;
			gpointer _tmp22_;
			ValaExpression* _tmp23_;
			_tmp17_ = _e_index;
			_e_index = _tmp17_ + 1;
			_tmp18_ = _e_index;
			_tmp19_ = _e_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _e_list;
			_tmp21_ = _e_index;
			_tmp22_ = vala_list_get (_tmp20_, _tmp21_);
			e = (ValaExpression*) _tmp22_;
			_tmp23_ = e;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, VALA_TYPE_INITIALIZER_LIST)) {
				gint size = 0;
				ValaExpression* _tmp28_;
				gint _tmp29_;
				gboolean _tmp30_ = FALSE;
				gint _tmp31_;
				if (rank == 1) {
					ValaExpression* _tmp24_;
					ValaExpression* _tmp25_;
					ValaSourceReference* _tmp26_;
					ValaSourceReference* _tmp27_;
					vala_code_node_set_error ((ValaCodeNode*) il, TRUE);
					_tmp24_ = e;
					vala_code_node_set_error ((ValaCodeNode*) _tmp24_, TRUE);
					_tmp25_ = e;
					_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp25_);
					_tmp27_ = _tmp26_;
					vala_report_error (_tmp27_, "Expected array element, got array initializer list");
					result = -1;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					return result;
				}
				_tmp28_ = e;
				size = vala_array_creation_expression_create_sizes_from_initializer_list (self, context, G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList), rank - 1, sl);
				_tmp29_ = size;
				if (_tmp29_ == -1) {
					result = -1;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					return result;
				}
				_tmp31_ = subsize;
				if (_tmp31_ >= 0) {
					gint _tmp32_;
					gint _tmp33_;
					_tmp32_ = subsize;
					_tmp33_ = size;
					_tmp30_ = _tmp32_ != _tmp33_;
				} else {
					_tmp30_ = FALSE;
				}
				if (_tmp30_) {
					ValaSourceReference* _tmp34_;
					ValaSourceReference* _tmp35_;
					gint _tmp36_;
					gint _tmp37_;
					gchar* _tmp38_;
					gchar* _tmp39_;
					vala_code_node_set_error ((ValaCodeNode*) il, TRUE);
					_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) il);
					_tmp35_ = _tmp34_;
					_tmp36_ = subsize;
					_tmp37_ = size;
					_tmp38_ = g_strdup_printf ("Expected initializer list of size %d, got size %d", _tmp36_, _tmp37_);
					_tmp39_ = _tmp38_;
					vala_report_error (_tmp35_, _tmp39_);
					_g_free0 (_tmp39_);
					result = -1;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					return result;
				} else {
					gint _tmp40_;
					_tmp40_ = size;
					subsize = _tmp40_;
				}
			} else {
				if (rank != 1) {
					ValaExpression* _tmp41_;
					ValaExpression* _tmp42_;
					ValaSourceReference* _tmp43_;
					ValaSourceReference* _tmp44_;
					vala_code_node_set_error ((ValaCodeNode*) il, TRUE);
					_tmp41_ = e;
					vala_code_node_set_error ((ValaCodeNode*) _tmp41_, TRUE);
					_tmp42_ = e;
					_tmp43_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp42_);
					_tmp44_ = _tmp43_;
					vala_report_error (_tmp44_, "Expected array initializer list, got array element");
					result = -1;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					return result;
				}
			}
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp45_ = vala_initializer_list_get_size (il);
	_tmp46_ = _tmp45_;
	result = _tmp46_;
	return result;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_array_creation_expression_real_check (ValaCodeNode* base, 
                                           ValaCodeContext* context)
{
	ValaArrayCreationExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaList* sizes = NULL;
	ValaList* _tmp4_;
	ValaInitializerList* initlist = NULL;
	ValaInitializerList* _tmp5_;
	ValaInitializerList* _tmp6_;
	ValaInitializerList* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaArrayList* calc_sizes = NULL;
	GEqualFunc _tmp24_;
	ValaArrayList* _tmp25_;
	ValaInitializerList* _tmp26_;
	ValaList* _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	gboolean _tmp82_;
	gboolean _tmp83_;
	gboolean _tmp84_ = FALSE;
	ValaInitializerList* _tmp85_;
	ValaInitializerList* _tmp86_;
	ValaDataType* _tmp91_;
	ValaDataType* _tmp92_;
	ValaDataType* _tmp95_;
	ValaDataType* _tmp96_;
	gint _tmp97_;
	ValaSourceReference* _tmp98_;
	ValaSourceReference* _tmp99_;
	ValaArrayType* _tmp100_;
	ValaArrayType* _tmp101_;
	ValaDataType* _tmp102_;
	ValaDataType* _tmp103_;
	gboolean _tmp104_;
	gboolean _tmp105_;
	self = (ValaArrayCreationExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_array_creation_expression_get_sizes (self);
	sizes = _tmp4_;
	_tmp5_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = _vala_code_node_ref0 (_tmp6_);
	initlist = _tmp7_;
	_tmp8_ = vala_array_creation_expression_get_element_type (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != NULL) {
		ValaDataType* _tmp10_;
		ValaDataType* _tmp11_;
		_tmp10_ = vala_array_creation_expression_get_element_type (self);
		_tmp11_ = _tmp10_;
		vala_code_node_check ((ValaCodeNode*) _tmp11_, context);
	}
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp12_;
		ValaList* _tmp13_;
		gint _e_size = 0;
		ValaList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _e_index = 0;
		_tmp12_ = sizes;
		_tmp13_ = _vala_iterable_ref0 (_tmp12_);
		_e_list = _tmp13_;
		_tmp14_ = _e_list;
		_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_e_size = _tmp16_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			ValaExpression* e = NULL;
			ValaList* _tmp20_;
			gint _tmp21_;
			gpointer _tmp22_;
			ValaExpression* _tmp23_;
			_tmp17_ = _e_index;
			_e_index = _tmp17_ + 1;
			_tmp18_ = _e_index;
			_tmp19_ = _e_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _e_list;
			_tmp21_ = _e_index;
			_tmp22_ = vala_list_get (_tmp20_, _tmp21_);
			e = (ValaExpression*) _tmp22_;
			_tmp23_ = e;
			vala_code_node_check ((ValaCodeNode*) _tmp23_, context);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp24_ = g_direct_equal;
	_tmp25_ = vala_array_list_new (VALA_TYPE_LITERAL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp24_);
	calc_sizes = _tmp25_;
	_tmp26_ = initlist;
	if (_tmp26_ != NULL) {
		ValaInitializerList* _tmp27_;
		ValaDataType* _tmp28_;
		ValaDataType* _tmp29_;
		gint _tmp30_;
		ValaSourceReference* _tmp31_;
		ValaSourceReference* _tmp32_;
		ValaArrayType* _tmp33_;
		ValaArrayType* _tmp34_;
		ValaInitializerList* _tmp35_;
		gint ret = 0;
		ValaInitializerList* _tmp36_;
		gint _tmp37_;
		ValaArrayList* _tmp38_;
		gint _tmp39_;
		_tmp27_ = initlist;
		_tmp28_ = vala_array_creation_expression_get_element_type (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = self->priv->_rank;
		_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp32_ = _tmp31_;
		_tmp33_ = vala_array_type_new (_tmp29_, _tmp30_, _tmp32_);
		_tmp34_ = _tmp33_;
		vala_expression_set_target_type ((ValaExpression*) _tmp27_, (ValaDataType*) _tmp34_);
		_vala_code_node_unref0 (_tmp34_);
		_tmp35_ = initlist;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp35_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		}
		_tmp36_ = initlist;
		_tmp37_ = self->priv->_rank;
		_tmp38_ = calc_sizes;
		ret = vala_array_creation_expression_create_sizes_from_initializer_list (self, context, _tmp36_, _tmp37_, (ValaList*) _tmp38_);
		_tmp39_ = ret;
		if (_tmp39_ == -1) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		}
	}
	_tmp40_ = sizes;
	_tmp41_ = vala_collection_get_size ((ValaCollection*) _tmp40_);
	_tmp42_ = _tmp41_;
	if (_tmp42_ > 0) {
		{
			ValaList* _e_list = NULL;
			ValaList* _tmp43_;
			ValaList* _tmp44_;
			gint _e_size = 0;
			ValaList* _tmp45_;
			gint _tmp46_;
			gint _tmp47_;
			gint _e_index = 0;
			_tmp43_ = sizes;
			_tmp44_ = _vala_iterable_ref0 (_tmp43_);
			_e_list = _tmp44_;
			_tmp45_ = _e_list;
			_tmp46_ = vala_collection_get_size ((ValaCollection*) _tmp45_);
			_tmp47_ = _tmp46_;
			_e_size = _tmp47_;
			_e_index = -1;
			while (TRUE) {
				gint _tmp48_;
				gint _tmp49_;
				gint _tmp50_;
				ValaExpression* e = NULL;
				ValaList* _tmp51_;
				gint _tmp52_;
				gpointer _tmp53_;
				ValaExpression* _tmp54_;
				ValaDataType* _tmp55_;
				ValaDataType* _tmp56_;
				_tmp48_ = _e_index;
				_e_index = _tmp48_ + 1;
				_tmp49_ = _e_index;
				_tmp50_ = _e_size;
				if (!(_tmp49_ < _tmp50_)) {
					break;
				}
				_tmp51_ = _e_list;
				_tmp52_ = _e_index;
				_tmp53_ = vala_list_get (_tmp51_, _tmp52_);
				e = (ValaExpression*) _tmp53_;
				_tmp54_ = e;
				_tmp55_ = vala_expression_get_value_type (_tmp54_);
				_tmp56_ = _tmp55_;
				if (_tmp56_ == NULL) {
					result = FALSE;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					_vala_iterable_unref0 (calc_sizes);
					_vala_code_node_unref0 (initlist);
					_vala_iterable_unref0 (sizes);
					return result;
				} else {
					gboolean _tmp57_ = FALSE;
					ValaExpression* _tmp58_;
					ValaDataType* _tmp59_;
					ValaDataType* _tmp60_;
					_tmp58_ = e;
					_tmp59_ = vala_expression_get_value_type (_tmp58_);
					_tmp60_ = _tmp59_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp60_, VALA_TYPE_INTEGER_TYPE)) {
						_tmp57_ = TRUE;
					} else {
						ValaExpression* _tmp61_;
						ValaDataType* _tmp62_;
						ValaDataType* _tmp63_;
						_tmp61_ = e;
						_tmp62_ = vala_expression_get_value_type (_tmp61_);
						_tmp63_ = _tmp62_;
						_tmp57_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp63_, VALA_TYPE_ENUM_VALUE_TYPE);
					}
					if (!_tmp57_) {
						ValaExpression* _tmp64_;
						ValaSourceReference* _tmp65_;
						ValaSourceReference* _tmp66_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp64_ = e;
						_tmp65_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp64_);
						_tmp66_ = _tmp65_;
						vala_report_error (_tmp66_, "Expression of integer type expected");
					}
				}
				_vala_code_node_unref0 (e);
			}
			_vala_iterable_unref0 (_e_list);
		}
	} else {
		ValaInitializerList* _tmp67_;
		_tmp67_ = initlist;
		if (_tmp67_ == NULL) {
			ValaSourceReference* _tmp68_;
			ValaSourceReference* _tmp69_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp69_ = _tmp68_;
			vala_report_error (_tmp69_, "internal error: initializer list expected");
		} else {
			{
				ValaArrayList* _size_list = NULL;
				ValaArrayList* _tmp70_;
				ValaArrayList* _tmp71_;
				gint _size_size = 0;
				ValaArrayList* _tmp72_;
				gint _tmp73_;
				gint _tmp74_;
				gint _size_index = 0;
				_tmp70_ = calc_sizes;
				_tmp71_ = _vala_iterable_ref0 (_tmp70_);
				_size_list = _tmp71_;
				_tmp72_ = _size_list;
				_tmp73_ = vala_collection_get_size ((ValaCollection*) _tmp72_);
				_tmp74_ = _tmp73_;
				_size_size = _tmp74_;
				_size_index = -1;
				while (TRUE) {
					gint _tmp75_;
					gint _tmp76_;
					gint _tmp77_;
					ValaExpression* size = NULL;
					ValaArrayList* _tmp78_;
					gint _tmp79_;
					gpointer _tmp80_;
					ValaExpression* _tmp81_;
					_tmp75_ = _size_index;
					_size_index = _tmp75_ + 1;
					_tmp76_ = _size_index;
					_tmp77_ = _size_size;
					if (!(_tmp76_ < _tmp77_)) {
						break;
					}
					_tmp78_ = _size_list;
					_tmp79_ = _size_index;
					_tmp80_ = vala_list_get ((ValaList*) _tmp78_, _tmp79_);
					size = (ValaExpression*) ((ValaLiteral*) _tmp80_);
					_tmp81_ = size;
					vala_array_creation_expression_append_size (self, _tmp81_);
					_vala_code_node_unref0 (size);
				}
				_vala_iterable_unref0 (_size_list);
			}
		}
	}
	_tmp82_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp83_ = _tmp82_;
	if (_tmp83_) {
		result = FALSE;
		_vala_iterable_unref0 (calc_sizes);
		_vala_code_node_unref0 (initlist);
		_vala_iterable_unref0 (sizes);
		return result;
	}
	_tmp85_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp86_ = _tmp85_;
	if (_tmp86_ != NULL) {
		ValaInitializerList* _tmp87_;
		ValaInitializerList* _tmp88_;
		ValaDataType* _tmp89_;
		ValaDataType* _tmp90_;
		_tmp87_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp88_ = _tmp87_;
		_tmp89_ = vala_expression_get_value_type ((ValaExpression*) _tmp88_);
		_tmp90_ = _tmp89_;
		_tmp84_ = _tmp90_ == NULL;
	} else {
		_tmp84_ = FALSE;
	}
	if (_tmp84_) {
		result = FALSE;
		_vala_iterable_unref0 (calc_sizes);
		_vala_code_node_unref0 (initlist);
		_vala_iterable_unref0 (sizes);
		return result;
	}
	_tmp91_ = vala_array_creation_expression_get_element_type (self);
	_tmp92_ = _tmp91_;
	if (_tmp92_ == NULL) {
		ValaSourceReference* _tmp93_;
		ValaSourceReference* _tmp94_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp93_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp94_ = _tmp93_;
		vala_report_error (_tmp94_, "Cannot determine the element type of the created array");
		result = FALSE;
		_vala_iterable_unref0 (calc_sizes);
		_vala_code_node_unref0 (initlist);
		_vala_iterable_unref0 (sizes);
		return result;
	}
	_tmp95_ = vala_array_creation_expression_get_element_type (self);
	_tmp96_ = _tmp95_;
	_tmp97_ = self->priv->_rank;
	_tmp98_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp99_ = _tmp98_;
	_tmp100_ = vala_array_type_new (_tmp96_, _tmp97_, _tmp99_);
	_tmp101_ = _tmp100_;
	vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp101_);
	_vala_code_node_unref0 (_tmp101_);
	_tmp102_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp103_ = _tmp102_;
	vala_data_type_set_value_owned (_tmp103_, TRUE);
	_tmp104_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp105_ = _tmp104_;
	result = !_tmp105_;
	_vala_iterable_unref0 (calc_sizes);
	_vala_code_node_unref0 (initlist);
	_vala_iterable_unref0 (sizes);
	return result;
}


static void
vala_array_creation_expression_real_emit (ValaCodeNode* base, 
                                          ValaCodeGenerator* codegen)
{
	ValaArrayCreationExpression * self;
	ValaInitializerList* _tmp12_;
	ValaInitializerList* _tmp13_;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _e_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _e_index = 0;
		_tmp0_ = self->priv->sizes;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_e_list = _tmp1_;
		_tmp2_ = _e_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_e_size = _tmp4_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* e = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _e_index;
			_e_index = _tmp5_ + 1;
			_tmp6_ = _e_index;
			_tmp7_ = _e_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _e_list;
			_tmp9_ = _e_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			e = (ValaExpression*) _tmp10_;
			_tmp11_ = e;
			vala_code_node_emit ((ValaCodeNode*) _tmp11_, codegen);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp12_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaInitializerList* _tmp14_;
		ValaInitializerList* _tmp15_;
		_tmp14_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp15_ = _tmp14_;
		vala_code_node_emit ((ValaCodeNode*) _tmp15_, codegen);
	}
	vala_code_visitor_visit_array_creation_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}


static void
vala_array_creation_expression_real_get_used_variables (ValaCodeNode* base, 
                                                        ValaCollection* collection)
{
	ValaArrayCreationExpression * self;
	ValaInitializerList* _tmp12_;
	ValaInitializerList* _tmp13_;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _e_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _e_index = 0;
		_tmp0_ = self->priv->sizes;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_e_list = _tmp1_;
		_tmp2_ = _e_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_e_size = _tmp4_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* e = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _e_index;
			_e_index = _tmp5_ + 1;
			_tmp6_ = _e_index;
			_tmp7_ = _e_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _e_list;
			_tmp9_ = _e_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			e = (ValaExpression*) _tmp10_;
			_tmp11_ = e;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp11_, collection);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp12_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaInitializerList* _tmp14_;
		ValaInitializerList* _tmp15_;
		_tmp14_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp15_ = _tmp14_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp15_, collection);
	}
}


ValaDataType*
vala_array_creation_expression_get_element_type (ValaArrayCreationExpression* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_element_type;
	result = _tmp0_;
	return result;
}


void
vala_array_creation_expression_set_element_type (ValaArrayCreationExpression* self, 
                                                 ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_element_type);
	self->priv->_element_type = _tmp0_;
	_tmp1_ = self->priv->_element_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


gint
vala_array_creation_expression_get_rank (ValaArrayCreationExpression* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_rank;
	result = _tmp0_;
	return result;
}


void
vala_array_creation_expression_set_rank (ValaArrayCreationExpression* self, 
                                         gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_rank = value;
}


ValaInitializerList*
vala_array_creation_expression_get_initializer_list (ValaArrayCreationExpression* self)
{
	ValaInitializerList* result;
	ValaInitializerList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_initializer_list;
	result = _tmp0_;
	return result;
}


void
vala_array_creation_expression_set_initializer_list (ValaArrayCreationExpression* self, 
                                                     ValaInitializerList* value)
{
	ValaInitializerList* _tmp0_;
	ValaInitializerList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_initializer_list);
	self->priv->_initializer_list = _tmp0_;
	_tmp1_ = self->priv->_initializer_list;
	if (_tmp1_ != NULL) {
		ValaInitializerList* _tmp2_;
		_tmp2_ = self->priv->_initializer_list;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}


static void
vala_array_creation_expression_class_init (ValaArrayCreationExpressionClass * klass)
{
	vala_array_creation_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_array_creation_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaArrayCreationExpressionPrivate));
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_array_creation_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_array_creation_expression_real_accept;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression *)) vala_array_creation_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression *, ValaSymbol*)) vala_array_creation_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_array_creation_expression_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode *, ValaDataType*, ValaDataType*)) vala_array_creation_expression_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_array_creation_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_array_creation_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_array_creation_expression_real_get_used_variables;
}


static void
vala_array_creation_expression_instance_init (ValaArrayCreationExpression * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_ARRAY_CREATION_EXPRESSION_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->sizes = (ValaList*) _tmp1_;
}


static void
vala_array_creation_expression_finalize (ValaCodeNode * obj)
{
	ValaArrayCreationExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression);
	_vala_iterable_unref0 (self->priv->sizes);
	_vala_code_node_unref0 (self->priv->_element_type);
	_vala_code_node_unref0 (self->priv->_initializer_list);
	VALA_CODE_NODE_CLASS (vala_array_creation_expression_parent_class)->finalize (obj);
}


/**
 * Represents an array creation expression e.g. {{{ new int[] {1,2,3} }}}.
 */
GType
vala_array_creation_expression_get_type (void)
{
	static volatile gsize vala_array_creation_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_array_creation_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaArrayCreationExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_array_creation_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaArrayCreationExpression), 0, (GInstanceInitFunc) vala_array_creation_expression_instance_init, NULL };
		GType vala_array_creation_expression_type_id;
		vala_array_creation_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaArrayCreationExpression", &g_define_type_info, 0);
		g_once_init_leave (&vala_array_creation_expression_type_id__volatile, vala_array_creation_expression_type_id);
	}
	return vala_array_creation_expression_type_id__volatile;
}



