/* valaccodebinaryexpression.c generated by valac, the Vala compiler
 * generated from valaccodebinaryexpression.vala, do not modify */

/* valaccodebinaryexpression.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "valaccode.h"

enum  {
	VALA_CCODE_BINARY_EXPRESSION_0_PROPERTY,
	VALA_CCODE_BINARY_EXPRESSION_NUM_PROPERTIES
};
static GParamSpec* vala_ccode_binary_expression_properties[VALA_CCODE_BINARY_EXPRESSION_NUM_PROPERTIES];
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))

struct _ValaCCodeBinaryExpressionPrivate {
	ValaCCodeBinaryOperator _operator;
	ValaCCodeExpression* _left;
	ValaCCodeExpression* _right;
};


static gpointer vala_ccode_binary_expression_parent_class = NULL;

#define VALA_CCODE_BINARY_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_BINARY_EXPRESSION, ValaCCodeBinaryExpressionPrivate))
static void vala_ccode_binary_expression_real_write (ValaCCodeNode* base, 
                                              ValaCCodeWriter* writer);
static void vala_ccode_binary_expression_real_write_inner (ValaCCodeExpression* base, 
                                                    ValaCCodeWriter* writer);
static void vala_ccode_binary_expression_finalize (ValaCCodeNode * obj);


ValaCCodeBinaryExpression*
vala_ccode_binary_expression_construct (GType object_type, 
                                        ValaCCodeBinaryOperator op, 
                                        ValaCCodeExpression* l, 
                                        ValaCCodeExpression* r)
{
	ValaCCodeBinaryExpression* self = NULL;
	g_return_val_if_fail (l != NULL, NULL);
	g_return_val_if_fail (r != NULL, NULL);
	self = (ValaCCodeBinaryExpression*) vala_ccode_expression_construct (object_type);
	vala_ccode_binary_expression_set_operator (self, op);
	vala_ccode_binary_expression_set_left (self, l);
	vala_ccode_binary_expression_set_right (self, r);
	return self;
}


ValaCCodeBinaryExpression*
vala_ccode_binary_expression_new (ValaCCodeBinaryOperator op, 
                                  ValaCCodeExpression* l, 
                                  ValaCCodeExpression* r)
{
	return vala_ccode_binary_expression_construct (VALA_TYPE_CCODE_BINARY_EXPRESSION, op, l, r);
}


static void
vala_ccode_binary_expression_real_write (ValaCCodeNode* base, 
                                         ValaCCodeWriter* writer)
{
	ValaCCodeBinaryExpression * self;
	ValaCCodeExpression* _tmp0_;
	ValaCCodeBinaryOperator _tmp1_;
	ValaCCodeExpression* _tmp2_;
	self = (ValaCCodeBinaryExpression*) base;
	g_return_if_fail (writer != NULL);
	_tmp0_ = self->priv->_left;
	vala_ccode_expression_write_inner (_tmp0_, writer);
	_tmp1_ = self->priv->_operator;
	switch (_tmp1_) {
		case VALA_CCODE_BINARY_OPERATOR_PLUS:
		{
			vala_ccode_writer_write_string (writer, " + ");
			break;
		}
		case VALA_CCODE_BINARY_OPERATOR_MINUS:
		{
			vala_ccode_writer_write_string (writer, " - ");
			break;
		}
		case VALA_CCODE_BINARY_OPERATOR_MUL:
		{
			vala_ccode_writer_write_string (writer, " * ");
			break;
		}
		case VALA_CCODE_BINARY_OPERATOR_DIV:
		{
			vala_ccode_writer_write_string (writer, " / ");
			break;
		}
		case VALA_CCODE_BINARY_OPERATOR_MOD:
		{
			vala_ccode_writer_write_string (writer, " % ");
			break;
		}
		case VALA_CCODE_BINARY_OPERATOR_SHIFT_LEFT:
		{
			vala_ccode_writer_write_string (writer, " << ");
			break;
		}
		case VALA_CCODE_BINARY_OPERATOR_SHIFT_RIGHT:
		{
			vala_ccode_writer_write_string (writer, " >> ");
			break;
		}
		case VALA_CCODE_BINARY_OPERATOR_LESS_THAN:
		{
			vala_ccode_writer_write_string (writer, " < ");
			break;
		}
		case VALA_CCODE_BINARY_OPERATOR_GREATER_THAN:
		{
			vala_ccode_writer_write_string (writer, " > ");
			break;
		}
		case VALA_CCODE_BINARY_OPERATOR_LESS_THAN_OR_EQUAL:
		{
			vala_ccode_writer_write_string (writer, " <= ");
			break;
		}
		case VALA_CCODE_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL:
		{
			vala_ccode_writer_write_string (writer, " >= ");
			break;
		}
		case VALA_CCODE_BINARY_OPERATOR_EQUALITY:
		{
			vala_ccode_writer_write_string (writer, " == ");
			break;
		}
		case VALA_CCODE_BINARY_OPERATOR_INEQUALITY:
		{
			vala_ccode_writer_write_string (writer, " != ");
			break;
		}
		case VALA_CCODE_BINARY_OPERATOR_BITWISE_AND:
		{
			vala_ccode_writer_write_string (writer, " & ");
			break;
		}
		case VALA_CCODE_BINARY_OPERATOR_BITWISE_OR:
		{
			vala_ccode_writer_write_string (writer, " | ");
			break;
		}
		case VALA_CCODE_BINARY_OPERATOR_BITWISE_XOR:
		{
			vala_ccode_writer_write_string (writer, " ^ ");
			break;
		}
		case VALA_CCODE_BINARY_OPERATOR_AND:
		{
			vala_ccode_writer_write_string (writer, " && ");
			break;
		}
		case VALA_CCODE_BINARY_OPERATOR_OR:
		{
			vala_ccode_writer_write_string (writer, " || ");
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp2_ = self->priv->_right;
	vala_ccode_expression_write_inner (_tmp2_, writer);
}


static void
vala_ccode_binary_expression_real_write_inner (ValaCCodeExpression* base, 
                                               ValaCCodeWriter* writer)
{
	ValaCCodeBinaryExpression * self;
	self = (ValaCCodeBinaryExpression*) base;
	g_return_if_fail (writer != NULL);
	vala_ccode_writer_write_string (writer, "(");
	vala_ccode_node_write ((ValaCCodeNode*) self, writer);
	vala_ccode_writer_write_string (writer, ")");
}


ValaCCodeBinaryOperator
vala_ccode_binary_expression_get_operator (ValaCCodeBinaryExpression* self)
{
	ValaCCodeBinaryOperator result;
	ValaCCodeBinaryOperator _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_operator;
	result = _tmp0_;
	return result;
}


void
vala_ccode_binary_expression_set_operator (ValaCCodeBinaryExpression* self, 
                                           ValaCCodeBinaryOperator value)
{
	g_return_if_fail (self != NULL);
	self->priv->_operator = value;
}


ValaCCodeExpression*
vala_ccode_binary_expression_get_left (ValaCCodeBinaryExpression* self)
{
	ValaCCodeExpression* result;
	ValaCCodeExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_left;
	result = _tmp0_;
	return result;
}


static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}


void
vala_ccode_binary_expression_set_left (ValaCCodeBinaryExpression* self, 
                                       ValaCCodeExpression* value)
{
	ValaCCodeExpression* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_ccode_node_ref0 (value);
	_vala_ccode_node_unref0 (self->priv->_left);
	self->priv->_left = _tmp0_;
}


ValaCCodeExpression*
vala_ccode_binary_expression_get_right (ValaCCodeBinaryExpression* self)
{
	ValaCCodeExpression* result;
	ValaCCodeExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_right;
	result = _tmp0_;
	return result;
}


void
vala_ccode_binary_expression_set_right (ValaCCodeBinaryExpression* self, 
                                        ValaCCodeExpression* value)
{
	ValaCCodeExpression* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_ccode_node_ref0 (value);
	_vala_ccode_node_unref0 (self->priv->_right);
	self->priv->_right = _tmp0_;
}


static void
vala_ccode_binary_expression_class_init (ValaCCodeBinaryExpressionClass * klass)
{
	vala_ccode_binary_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCCodeNodeClass *) klass)->finalize = vala_ccode_binary_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeBinaryExpressionPrivate));
	((ValaCCodeNodeClass *) klass)->write = (void (*) (ValaCCodeNode *, ValaCCodeWriter*)) vala_ccode_binary_expression_real_write;
	((ValaCCodeExpressionClass *) klass)->write_inner = (void (*) (ValaCCodeExpression *, ValaCCodeWriter*)) vala_ccode_binary_expression_real_write_inner;
}


static void
vala_ccode_binary_expression_instance_init (ValaCCodeBinaryExpression * self)
{
	self->priv = VALA_CCODE_BINARY_EXPRESSION_GET_PRIVATE (self);
}


static void
vala_ccode_binary_expression_finalize (ValaCCodeNode * obj)
{
	ValaCCodeBinaryExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CCODE_BINARY_EXPRESSION, ValaCCodeBinaryExpression);
	_vala_ccode_node_unref0 (self->priv->_left);
	_vala_ccode_node_unref0 (self->priv->_right);
	VALA_CCODE_NODE_CLASS (vala_ccode_binary_expression_parent_class)->finalize (obj);
}


/**
 * Represents an expression with two operands in C code.
 */
GType
vala_ccode_binary_expression_get_type (void)
{
	static volatile gsize vala_ccode_binary_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_binary_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeBinaryExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_binary_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeBinaryExpression), 0, (GInstanceInitFunc) vala_ccode_binary_expression_instance_init, NULL };
		GType vala_ccode_binary_expression_type_id;
		vala_ccode_binary_expression_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION, "ValaCCodeBinaryExpression", &g_define_type_info, 0);
		g_once_init_leave (&vala_ccode_binary_expression_type_id__volatile, vala_ccode_binary_expression_type_id);
	}
	return vala_ccode_binary_expression_type_id__volatile;
}


GType
vala_ccode_binary_operator_get_type (void)
{
	static volatile gsize vala_ccode_binary_operator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_binary_operator_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_CCODE_BINARY_OPERATOR_PLUS, "VALA_CCODE_BINARY_OPERATOR_PLUS", "plus"}, {VALA_CCODE_BINARY_OPERATOR_MINUS, "VALA_CCODE_BINARY_OPERATOR_MINUS", "minus"}, {VALA_CCODE_BINARY_OPERATOR_MUL, "VALA_CCODE_BINARY_OPERATOR_MUL", "mul"}, {VALA_CCODE_BINARY_OPERATOR_DIV, "VALA_CCODE_BINARY_OPERATOR_DIV", "div"}, {VALA_CCODE_BINARY_OPERATOR_MOD, "VALA_CCODE_BINARY_OPERATOR_MOD", "mod"}, {VALA_CCODE_BINARY_OPERATOR_SHIFT_LEFT, "VALA_CCODE_BINARY_OPERATOR_SHIFT_LEFT", "shift-left"}, {VALA_CCODE_BINARY_OPERATOR_SHIFT_RIGHT, "VALA_CCODE_BINARY_OPERATOR_SHIFT_RIGHT", "shift-right"}, {VALA_CCODE_BINARY_OPERATOR_LESS_THAN, "VALA_CCODE_BINARY_OPERATOR_LESS_THAN", "less-than"}, {VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, "VALA_CCODE_BINARY_OPERATOR_GREATER_THAN", "greater-than"}, {VALA_CCODE_BINARY_OPERATOR_LESS_THAN_OR_EQUAL, "VALA_CCODE_BINARY_OPERATOR_LESS_THAN_OR_EQUAL", "less-than-or-equal"}, {VALA_CCODE_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL, "VALA_CCODE_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL", "greater-than-or-equal"}, {VALA_CCODE_BINARY_OPERATOR_EQUALITY, "VALA_CCODE_BINARY_OPERATOR_EQUALITY", "equality"}, {VALA_CCODE_BINARY_OPERATOR_INEQUALITY, "VALA_CCODE_BINARY_OPERATOR_INEQUALITY", "inequality"}, {VALA_CCODE_BINARY_OPERATOR_BITWISE_AND, "VALA_CCODE_BINARY_OPERATOR_BITWISE_AND", "bitwise-and"}, {VALA_CCODE_BINARY_OPERATOR_BITWISE_OR, "VALA_CCODE_BINARY_OPERATOR_BITWISE_OR", "bitwise-or"}, {VALA_CCODE_BINARY_OPERATOR_BITWISE_XOR, "VALA_CCODE_BINARY_OPERATOR_BITWISE_XOR", "bitwise-xor"}, {VALA_CCODE_BINARY_OPERATOR_AND, "VALA_CCODE_BINARY_OPERATOR_AND", "and"}, {VALA_CCODE_BINARY_OPERATOR_OR, "VALA_CCODE_BINARY_OPERATOR_OR", "or"}, {0, NULL, NULL}};
		GType vala_ccode_binary_operator_type_id;
		vala_ccode_binary_operator_type_id = g_enum_register_static ("ValaCCodeBinaryOperator", values);
		g_once_init_leave (&vala_ccode_binary_operator_type_id__volatile, vala_ccode_binary_operator_type_id);
	}
	return vala_ccode_binary_operator_type_id__volatile;
}



