/* valascanner.c generated by valac, the Vala compiler
 * generated from valascanner.vala, do not modify */

/* valascanner.vala
 *
 * Copyright (C) 2008-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Jukka-Pekka Iivonen <jp0409@jippii.fi>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define VALA_SCANNER_TYPE_CONDITIONAL (vala_scanner_conditional_get_type ())
typedef struct _ValaScannerConditional ValaScannerConditional;

#define VALA_SCANNER_TYPE_STATE (vala_scanner_state_get_type ())
enum  {
	VALA_SCANNER_0_PROPERTY,
	VALA_SCANNER_NUM_PROPERTIES
};
static GParamSpec* vala_scanner_properties[VALA_SCANNER_NUM_PROPERTIES];
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_comment_unref0(var) ((var == NULL) ? NULL : (var = (vala_comment_unref (var), NULL)))
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ValaParamSpecScanner ValaParamSpecScanner;

struct _ValaScannerConditional {
	gboolean matched;
	gboolean else_found;
	gboolean skip_section;
};

typedef enum  {
	VALA_SCANNER_STATE_PARENS,
	VALA_SCANNER_STATE_BRACE,
	VALA_SCANNER_STATE_BRACKET,
	VALA_SCANNER_STATE_TEMPLATE,
	VALA_SCANNER_STATE_TEMPLATE_PART,
	VALA_SCANNER_STATE_REGEX_LITERAL
} ValaScannerState;

struct _ValaScannerPrivate {
	ValaSourceFile* _source_file;
	ValaTokenType previous;
	gchar* current;
	gchar* end;
	gint line;
	gint column;
	ValaComment* _comment;
	ValaScannerConditional* conditional_stack;
	gint conditional_stack_length1;
	gint _conditional_stack_size_;
	ValaScannerState* state_stack;
	gint state_stack_length1;
	gint _state_stack_size_;
};

struct _ValaParamSpecScanner {
	GParamSpec parent_instance;
};


static gpointer vala_scanner_parent_class = NULL;

static GType vala_scanner_conditional_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaScannerConditional* vala_scanner_conditional_dup (const ValaScannerConditional* self);
static void vala_scanner_conditional_free (ValaScannerConditional* self);
static GType vala_scanner_state_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define VALA_SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SCANNER, ValaScannerPrivate))
static void vala_scanner_set_source_file (ValaScanner* self, 
                                   ValaSourceFile* value);
static gboolean vala_scanner_in_template (ValaScanner* self);
static gboolean vala_scanner_in_template_part (ValaScanner* self);
static gboolean vala_scanner_in_regex_literal (ValaScanner* self);
static gboolean vala_scanner_is_ident_char (ValaScanner* self, 
                                     gchar c);
static ValaSourceReference* vala_scanner_get_source_reference (ValaScanner* self, 
                                                        gint offset, 
                                                        gint length);
static gboolean vala_scanner_matches (gchar* begin, 
                               const gchar* keyword);
static ValaTokenType vala_scanner_read_number (ValaScanner* self);
static void _vala_array_add13 (ValaScannerState* * array, 
                        int* length, 
                        int* size, 
                        ValaScannerState value);
static void _vala_array_add14 (ValaScannerState* * array, 
                        int* length, 
                        int* size, 
                        ValaScannerState value);
static void _vala_array_add15 (ValaScannerState* * array, 
                        int* length, 
                        int* size, 
                        ValaScannerState value);
static void _vala_array_add16 (ValaScannerState* * array, 
                        int* length, 
                        int* size, 
                        ValaScannerState value);
static void vala_scanner_space (ValaScanner* self);
static void _vala_array_add17 (ValaScannerState* * array, 
                        int* length, 
                        int* size, 
                        ValaScannerState value);
static void _vala_array_add18 (ValaScannerState* * array, 
                        int* length, 
                        int* size, 
                        ValaScannerState value);
static void _vala_array_add19 (ValaScannerState* * array, 
                        int* length, 
                        int* size, 
                        ValaScannerState value);
static void _vala_array_add20 (ValaScannerState* * array, 
                        int* length, 
                        int* size, 
                        ValaScannerState value);
static void _vala_array_add21 (ValaScannerState* * array, 
                        int* length, 
                        int* size, 
                        ValaScannerState value);
static gboolean vala_scanner_pp_whitespace (ValaScanner* self);
static void vala_scanner_pp_space (ValaScanner* self);
static gboolean vala_scanner_comment (ValaScanner* self, 
                               gboolean file_comment);
static void vala_scanner_pp_directive (ValaScanner* self);
static void vala_scanner_parse_pp_if (ValaScanner* self);
static void vala_scanner_parse_pp_elif (ValaScanner* self);
static void vala_scanner_parse_pp_else (ValaScanner* self);
static void vala_scanner_parse_pp_endif (ValaScanner* self);
static void vala_scanner_pp_eol (ValaScanner* self);
static gboolean vala_scanner_parse_pp_expression (ValaScanner* self);
static void _vala_array_add22 (ValaScannerConditional* * array, 
                        int* length, 
                        int* size, 
                        const ValaScannerConditional* value);
static gboolean vala_scanner_parse_pp_symbol (ValaScanner* self);
static gboolean vala_scanner_parse_pp_primary_expression (ValaScanner* self);
static gboolean vala_scanner_parse_pp_unary_expression (ValaScanner* self);
static gboolean vala_scanner_parse_pp_equality_expression (ValaScanner* self);
static gboolean vala_scanner_parse_pp_and_expression (ValaScanner* self);
static gboolean vala_scanner_parse_pp_or_expression (ValaScanner* self);
static gboolean vala_scanner_whitespace (ValaScanner* self);
static void vala_scanner_push_comment (ValaScanner* self, 
                                const gchar* comment_item, 
                                ValaSourceReference* source_reference, 
                                gboolean file_comment);
static void vala_scanner_finalize (ValaScanner * obj);


static GType
vala_scanner_state_get_type (void)
{
	static volatile gsize vala_scanner_state_type_id__volatile = 0;
	if (g_once_init_enter (&vala_scanner_state_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_SCANNER_STATE_PARENS, "VALA_SCANNER_STATE_PARENS", "parens"}, {VALA_SCANNER_STATE_BRACE, "VALA_SCANNER_STATE_BRACE", "brace"}, {VALA_SCANNER_STATE_BRACKET, "VALA_SCANNER_STATE_BRACKET", "bracket"}, {VALA_SCANNER_STATE_TEMPLATE, "VALA_SCANNER_STATE_TEMPLATE", "template"}, {VALA_SCANNER_STATE_TEMPLATE_PART, "VALA_SCANNER_STATE_TEMPLATE_PART", "template-part"}, {VALA_SCANNER_STATE_REGEX_LITERAL, "VALA_SCANNER_STATE_REGEX_LITERAL", "regex-literal"}, {0, NULL, NULL}};
		GType vala_scanner_state_type_id;
		vala_scanner_state_type_id = g_enum_register_static ("ValaScannerState", values);
		g_once_init_leave (&vala_scanner_state_type_id__volatile, vala_scanner_state_type_id);
	}
	return vala_scanner_state_type_id__volatile;
}


ValaScanner*
vala_scanner_construct (GType object_type, 
                        ValaSourceFile* source_file)
{
	ValaScanner* self = NULL;
	gchar* begin = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (source_file != NULL, NULL);
	self = (ValaScanner*) g_type_create_instance (object_type);
	vala_scanner_set_source_file (self, source_file);
	_tmp0_ = vala_source_file_get_mapped_contents (source_file);
	begin = _tmp0_;
	self->priv->end = begin + vala_source_file_get_mapped_length (source_file);
	self->priv->current = begin;
	self->priv->line = 1;
	self->priv->column = 1;
	return self;
}


ValaScanner*
vala_scanner_new (ValaSourceFile* source_file)
{
	return vala_scanner_construct (VALA_TYPE_SCANNER, source_file);
}


void
vala_scanner_seek (ValaScanner* self, 
                   ValaSourceLocation* location)
{
	gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_tmp0_ = (*location).pos;
	self->priv->current = _tmp0_;
	_tmp1_ = (*location).line;
	self->priv->line = _tmp1_;
	_tmp2_ = (*location).column;
	self->priv->column = _tmp2_;
	self->priv->conditional_stack = (g_free (self->priv->conditional_stack), NULL);
	self->priv->conditional_stack = NULL;
	self->priv->conditional_stack_length1 = 0;
	self->priv->_conditional_stack_size_ = self->priv->conditional_stack_length1;
	self->priv->state_stack = (g_free (self->priv->state_stack), NULL);
	self->priv->state_stack = NULL;
	self->priv->state_stack_length1 = 0;
	self->priv->_state_stack_size_ = self->priv->state_stack_length1;
}


static gboolean
vala_scanner_in_template (ValaScanner* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaScannerState* _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->state_stack;
	_tmp1__length1 = self->priv->state_stack_length1;
	if (_tmp1__length1 > 0) {
		ValaScannerState* _tmp2_;
		gint _tmp2__length1;
		ValaScannerState* _tmp3_;
		gint _tmp3__length1;
		ValaScannerState _tmp4_;
		_tmp2_ = self->priv->state_stack;
		_tmp2__length1 = self->priv->state_stack_length1;
		_tmp3_ = self->priv->state_stack;
		_tmp3__length1 = self->priv->state_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_ == VALA_SCANNER_STATE_TEMPLATE;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean
vala_scanner_in_template_part (ValaScanner* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaScannerState* _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->state_stack;
	_tmp1__length1 = self->priv->state_stack_length1;
	if (_tmp1__length1 > 0) {
		ValaScannerState* _tmp2_;
		gint _tmp2__length1;
		ValaScannerState* _tmp3_;
		gint _tmp3__length1;
		ValaScannerState _tmp4_;
		_tmp2_ = self->priv->state_stack;
		_tmp2__length1 = self->priv->state_stack_length1;
		_tmp3_ = self->priv->state_stack;
		_tmp3__length1 = self->priv->state_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_ == VALA_SCANNER_STATE_TEMPLATE_PART;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean
vala_scanner_in_regex_literal (ValaScanner* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaScannerState* _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->state_stack;
	_tmp1__length1 = self->priv->state_stack_length1;
	if (_tmp1__length1 > 0) {
		ValaScannerState* _tmp2_;
		gint _tmp2__length1;
		ValaScannerState* _tmp3_;
		gint _tmp3__length1;
		ValaScannerState _tmp4_;
		_tmp2_ = self->priv->state_stack;
		_tmp2__length1 = self->priv->state_stack_length1;
		_tmp3_ = self->priv->state_stack;
		_tmp3__length1 = self->priv->state_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_ == VALA_SCANNER_STATE_REGEX_LITERAL;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean
vala_scanner_is_ident_char (ValaScanner* self, 
                            gchar c)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (g_ascii_isalnum (c)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = c == '_';
	}
	result = _tmp0_;
	return result;
}


static ValaSourceReference*
vala_scanner_get_source_reference (ValaScanner* self, 
                                   gint offset, 
                                   gint length)
{
	ValaSourceReference* result = NULL;
	ValaSourceFile* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	ValaSourceLocation _tmp4_ = {0};
	gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	ValaSourceLocation _tmp8_ = {0};
	ValaSourceReference* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_file;
	_tmp1_ = self->priv->current;
	_tmp2_ = self->priv->line;
	_tmp3_ = self->priv->column;
	vala_source_location_init (&_tmp4_, _tmp1_, _tmp2_, _tmp3_ + offset);
	_tmp5_ = self->priv->current;
	_tmp6_ = self->priv->line;
	_tmp7_ = self->priv->column;
	vala_source_location_init (&_tmp8_, _tmp5_ + length, _tmp6_, (_tmp7_ + offset) + length);
	_tmp9_ = vala_source_reference_new (_tmp0_, &_tmp4_, &_tmp8_);
	result = _tmp9_;
	return result;
}


ValaTokenType
vala_scanner_read_regex_token (ValaScanner* self, 
                               ValaSourceLocation* token_begin, 
                               ValaSourceLocation* token_end)
{
	ValaSourceLocation _vala_token_begin = {0};
	ValaSourceLocation _vala_token_end = {0};
	ValaTokenType result = 0;
	ValaTokenType type = 0;
	gchar* begin = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint token_length_in_chars = 0;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint _tmp116_;
	gchar* _tmp122_;
	gint _tmp123_;
	gint _tmp124_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->current;
	begin = _tmp0_;
	_tmp1_ = begin;
	_tmp2_ = self->priv->line;
	_tmp3_ = self->priv->column;
	vala_source_location_init (&_vala_token_begin, _tmp1_, _tmp2_, _tmp3_);
	token_length_in_chars = -1;
	_tmp4_ = self->priv->current;
	_tmp5_ = self->priv->end;
	if (_tmp4_ >= _tmp5_) {
		type = VALA_TOKEN_TYPE_EOF;
	} else {
		gchar* _tmp6_;
		gchar _tmp7_;
		_tmp6_ = self->priv->current;
		_tmp7_ = _tmp6_[0];
		switch (_tmp7_) {
			case '/':
			{
				gchar* _tmp8_;
				gint _tmp9_;
				gboolean fl_i = FALSE;
				gboolean fl_s = FALSE;
				gboolean fl_m = FALSE;
				gboolean fl_x = FALSE;
				type = VALA_TOKEN_TYPE_CLOSE_REGEX_LITERAL;
				_tmp8_ = self->priv->current;
				self->priv->current = _tmp8_ + 1;
				_tmp9_ = self->priv->state_stack_length1;
				self->priv->state_stack_length1 = _tmp9_ - 1;
				fl_i = FALSE;
				fl_s = FALSE;
				fl_m = FALSE;
				fl_x = FALSE;
				while (TRUE) {
					gboolean _tmp10_ = FALSE;
					gboolean _tmp11_ = FALSE;
					gboolean _tmp12_ = FALSE;
					gchar* _tmp13_;
					gchar _tmp14_;
					gchar* _tmp21_;
					gchar _tmp22_;
					gchar* _tmp39_;
					gint _tmp40_;
					_tmp13_ = self->priv->current;
					_tmp14_ = _tmp13_[0];
					if (_tmp14_ == 'i') {
						_tmp12_ = TRUE;
					} else {
						gchar* _tmp15_;
						gchar _tmp16_;
						_tmp15_ = self->priv->current;
						_tmp16_ = _tmp15_[0];
						_tmp12_ = _tmp16_ == 's';
					}
					if (_tmp12_) {
						_tmp11_ = TRUE;
					} else {
						gchar* _tmp17_;
						gchar _tmp18_;
						_tmp17_ = self->priv->current;
						_tmp18_ = _tmp17_[0];
						_tmp11_ = _tmp18_ == 'm';
					}
					if (_tmp11_) {
						_tmp10_ = TRUE;
					} else {
						gchar* _tmp19_;
						gchar _tmp20_;
						_tmp19_ = self->priv->current;
						_tmp20_ = _tmp19_[0];
						_tmp10_ = _tmp20_ == 'x';
					}
					if (!_tmp10_) {
						break;
					}
					_tmp21_ = self->priv->current;
					_tmp22_ = _tmp21_[0];
					switch (_tmp22_) {
						case 'i':
						{
							gboolean _tmp23_;
							_tmp23_ = fl_i;
							if (_tmp23_) {
								gint _tmp24_;
								ValaSourceReference* _tmp25_;
								ValaSourceReference* _tmp26_;
								_tmp24_ = token_length_in_chars;
								_tmp25_ = vala_scanner_get_source_reference (self, _tmp24_, 0);
								_tmp26_ = _tmp25_;
								vala_report_error (_tmp26_, "modifier 'i' used more than once");
								_vala_source_reference_unref0 (_tmp26_);
							}
							fl_i = TRUE;
							break;
						}
						case 's':
						{
							gboolean _tmp27_;
							_tmp27_ = fl_s;
							if (_tmp27_) {
								gint _tmp28_;
								ValaSourceReference* _tmp29_;
								ValaSourceReference* _tmp30_;
								_tmp28_ = token_length_in_chars;
								_tmp29_ = vala_scanner_get_source_reference (self, _tmp28_, 0);
								_tmp30_ = _tmp29_;
								vala_report_error (_tmp30_, "modifier 's' used more than once");
								_vala_source_reference_unref0 (_tmp30_);
							}
							fl_s = TRUE;
							break;
						}
						case 'm':
						{
							gboolean _tmp31_;
							_tmp31_ = fl_m;
							if (_tmp31_) {
								gint _tmp32_;
								ValaSourceReference* _tmp33_;
								ValaSourceReference* _tmp34_;
								_tmp32_ = token_length_in_chars;
								_tmp33_ = vala_scanner_get_source_reference (self, _tmp32_, 0);
								_tmp34_ = _tmp33_;
								vala_report_error (_tmp34_, "modifier 'm' used more than once");
								_vala_source_reference_unref0 (_tmp34_);
							}
							fl_m = TRUE;
							break;
						}
						case 'x':
						{
							gboolean _tmp35_;
							_tmp35_ = fl_x;
							if (_tmp35_) {
								gint _tmp36_;
								ValaSourceReference* _tmp37_;
								ValaSourceReference* _tmp38_;
								_tmp36_ = token_length_in_chars;
								_tmp37_ = vala_scanner_get_source_reference (self, _tmp36_, 0);
								_tmp38_ = _tmp37_;
								vala_report_error (_tmp38_, "modifier 'x' used more than once");
								_vala_source_reference_unref0 (_tmp38_);
							}
							fl_x = TRUE;
							break;
						}
						default:
						break;
					}
					_tmp39_ = self->priv->current;
					self->priv->current = _tmp39_ + 1;
					_tmp40_ = token_length_in_chars;
					token_length_in_chars = _tmp40_ + 1;
				}
				break;
			}
			default:
			{
				gboolean _tmp104_ = FALSE;
				gchar* _tmp105_;
				gchar* _tmp106_;
				type = VALA_TOKEN_TYPE_REGEX_LITERAL;
				token_length_in_chars = 0;
				while (TRUE) {
					gboolean _tmp41_ = FALSE;
					gchar* _tmp42_;
					gchar* _tmp43_;
					gchar* _tmp46_;
					gchar _tmp47_;
					_tmp42_ = self->priv->current;
					_tmp43_ = self->priv->end;
					if (_tmp42_ < _tmp43_) {
						gchar* _tmp44_;
						gchar _tmp45_;
						_tmp44_ = self->priv->current;
						_tmp45_ = _tmp44_[0];
						_tmp41_ = _tmp45_ != '/';
					} else {
						_tmp41_ = FALSE;
					}
					if (!_tmp41_) {
						break;
					}
					_tmp46_ = self->priv->current;
					_tmp47_ = _tmp46_[0];
					if (_tmp47_ == '\\') {
						gchar* _tmp48_;
						gint _tmp49_;
						gchar* _tmp50_;
						gchar* _tmp51_;
						gchar* _tmp52_;
						gchar _tmp53_;
						_tmp48_ = self->priv->current;
						self->priv->current = _tmp48_ + 1;
						_tmp49_ = token_length_in_chars;
						token_length_in_chars = _tmp49_ + 1;
						_tmp50_ = self->priv->current;
						_tmp51_ = self->priv->end;
						if (_tmp50_ >= _tmp51_) {
							break;
						}
						_tmp52_ = self->priv->current;
						_tmp53_ = _tmp52_[0];
						switch (_tmp53_) {
							case '\'':
							case '"':
							case '\\':
							case '/':
							case '^':
							case '$':
							case '.':
							case '[':
							case ']':
							case '{':
							case '}':
							case '(':
							case ')':
							case '?':
							case '*':
							case '+':
							case '-':
							case '#':
							case '&':
							case '~':
							case ':':
							case ';':
							case '<':
							case '>':
							case '|':
							case '%':
							case '=':
							case '@':
							case '0':
							case 'b':
							case 'B':
							case 'f':
							case 'n':
							case 'r':
							case 't':
							case 'v':
							case 'a':
							case 'A':
							case 'p':
							case 'P':
							case 'e':
							case 'd':
							case 'D':
							case 's':
							case 'S':
							case 'w':
							case 'W':
							case 'G':
							case 'z':
							case 'Z':
							{
								gchar* _tmp54_;
								gint _tmp55_;
								_tmp54_ = self->priv->current;
								self->priv->current = _tmp54_ + 1;
								_tmp55_ = token_length_in_chars;
								token_length_in_chars = _tmp55_ + 1;
								break;
							}
							case 'u':
							{
								gchar* _tmp56_;
								gint _tmp57_;
								gint digit_length = 0;
								gint _tmp69_;
								_tmp56_ = self->priv->current;
								self->priv->current = _tmp56_ + 1;
								_tmp57_ = token_length_in_chars;
								token_length_in_chars = _tmp57_ + 1;
								{
									gboolean _tmp58_ = FALSE;
									digit_length = 0;
									_tmp58_ = TRUE;
									while (TRUE) {
										gboolean _tmp60_ = FALSE;
										gboolean _tmp61_ = FALSE;
										gint _tmp62_;
										gchar* _tmp67_;
										gint _tmp68_;
										if (!_tmp58_) {
											gint _tmp59_;
											_tmp59_ = digit_length;
											digit_length = _tmp59_ + 1;
										}
										_tmp58_ = FALSE;
										_tmp62_ = digit_length;
										if (_tmp62_ < 4) {
											gchar* _tmp63_;
											gchar* _tmp64_;
											_tmp63_ = self->priv->current;
											_tmp64_ = self->priv->end;
											_tmp61_ = _tmp63_ < _tmp64_;
										} else {
											_tmp61_ = FALSE;
										}
										if (_tmp61_) {
											gchar* _tmp65_;
											gchar _tmp66_;
											_tmp65_ = self->priv->current;
											_tmp66_ = _tmp65_[0];
											_tmp60_ = g_ascii_isxdigit (_tmp66_);
										} else {
											_tmp60_ = FALSE;
										}
										if (!_tmp60_) {
											break;
										}
										_tmp67_ = self->priv->current;
										self->priv->current = _tmp67_ + 1;
										_tmp68_ = token_length_in_chars;
										token_length_in_chars = _tmp68_ + 1;
									}
								}
								_tmp69_ = digit_length;
								if (_tmp69_ != 4) {
									gint _tmp70_;
									ValaSourceReference* _tmp71_;
									ValaSourceReference* _tmp72_;
									_tmp70_ = token_length_in_chars;
									_tmp71_ = vala_scanner_get_source_reference (self, _tmp70_, 0);
									_tmp72_ = _tmp71_;
									vala_report_error (_tmp72_, "\\u requires four hex digits");
									_vala_source_reference_unref0 (_tmp72_);
								}
								break;
							}
							case 'x':
							{
								gchar* _tmp73_;
								gint _tmp74_;
								gint digit_length = 0;
								gint _tmp84_;
								_tmp73_ = self->priv->current;
								self->priv->current = _tmp73_ + 1;
								_tmp74_ = token_length_in_chars;
								token_length_in_chars = _tmp74_ + 1;
								{
									gboolean _tmp75_ = FALSE;
									digit_length = 0;
									_tmp75_ = TRUE;
									while (TRUE) {
										gboolean _tmp77_ = FALSE;
										gchar* _tmp78_;
										gchar* _tmp79_;
										gchar* _tmp82_;
										gint _tmp83_;
										if (!_tmp75_) {
											gint _tmp76_;
											_tmp76_ = digit_length;
											digit_length = _tmp76_ + 1;
										}
										_tmp75_ = FALSE;
										_tmp78_ = self->priv->current;
										_tmp79_ = self->priv->end;
										if (_tmp78_ < _tmp79_) {
											gchar* _tmp80_;
											gchar _tmp81_;
											_tmp80_ = self->priv->current;
											_tmp81_ = _tmp80_[0];
											_tmp77_ = g_ascii_isxdigit (_tmp81_);
										} else {
											_tmp77_ = FALSE;
										}
										if (!_tmp77_) {
											break;
										}
										_tmp82_ = self->priv->current;
										self->priv->current = _tmp82_ + 1;
										_tmp83_ = token_length_in_chars;
										token_length_in_chars = _tmp83_ + 1;
									}
								}
								_tmp84_ = digit_length;
								if (_tmp84_ < 1) {
									gint _tmp85_;
									ValaSourceReference* _tmp86_;
									ValaSourceReference* _tmp87_;
									_tmp85_ = token_length_in_chars;
									_tmp86_ = vala_scanner_get_source_reference (self, _tmp85_, 0);
									_tmp87_ = _tmp86_;
									vala_report_error (_tmp87_, "\\x requires at least one hex digit");
									_vala_source_reference_unref0 (_tmp87_);
								}
								break;
							}
							default:
							{
								gint _tmp88_;
								ValaSourceReference* _tmp89_;
								ValaSourceReference* _tmp90_;
								_tmp88_ = token_length_in_chars;
								_tmp89_ = vala_scanner_get_source_reference (self, _tmp88_, 0);
								_tmp90_ = _tmp89_;
								vala_report_error (_tmp90_, "invalid escape sequence");
								_vala_source_reference_unref0 (_tmp90_);
								break;
							}
						}
					} else {
						gchar* _tmp91_;
						gchar _tmp92_;
						_tmp91_ = self->priv->current;
						_tmp92_ = _tmp91_[0];
						if (_tmp92_ == '\n') {
							break;
						} else {
							gunichar u = 0U;
							gchar* _tmp93_;
							gchar* _tmp94_;
							gchar* _tmp95_;
							gunichar _tmp96_;
							_tmp93_ = self->priv->current;
							_tmp94_ = self->priv->end;
							_tmp95_ = self->priv->current;
							u = g_utf8_get_char_validated ((const gchar*) _tmp93_, (gssize) ((glong) (_tmp94_ - _tmp95_)));
							_tmp96_ = u;
							if (_tmp96_ != ((gunichar) -1)) {
								gchar* _tmp97_;
								gunichar _tmp98_;
								gint _tmp99_;
								_tmp97_ = self->priv->current;
								_tmp98_ = u;
								self->priv->current = _tmp97_ + g_unichar_to_utf8 (_tmp98_, NULL);
								_tmp99_ = token_length_in_chars;
								token_length_in_chars = _tmp99_ + 1;
							} else {
								gchar* _tmp100_;
								gint _tmp101_;
								ValaSourceReference* _tmp102_;
								ValaSourceReference* _tmp103_;
								_tmp100_ = self->priv->current;
								self->priv->current = _tmp100_ + 1;
								_tmp101_ = token_length_in_chars;
								_tmp102_ = vala_scanner_get_source_reference (self, _tmp101_, 0);
								_tmp103_ = _tmp102_;
								vala_report_error (_tmp103_, "invalid UTF-8 character");
								_vala_source_reference_unref0 (_tmp103_);
							}
						}
					}
				}
				_tmp105_ = self->priv->current;
				_tmp106_ = self->priv->end;
				if (_tmp105_ >= _tmp106_) {
					_tmp104_ = TRUE;
				} else {
					gchar* _tmp107_;
					gchar _tmp108_;
					_tmp107_ = self->priv->current;
					_tmp108_ = _tmp107_[0];
					_tmp104_ = _tmp108_ == '\n';
				}
				if (_tmp104_) {
					gint _tmp109_;
					ValaSourceReference* _tmp110_;
					ValaSourceReference* _tmp111_;
					gint _tmp112_;
					ValaSourceLocation _tmp113_ = {0};
					ValaSourceLocation _tmp114_ = {0};
					ValaTokenType _tmp115_;
					_tmp109_ = token_length_in_chars;
					_tmp110_ = vala_scanner_get_source_reference (self, _tmp109_, 0);
					_tmp111_ = _tmp110_;
					vala_report_error (_tmp111_, "syntax error, expected \"");
					_vala_source_reference_unref0 (_tmp111_);
					_tmp112_ = self->priv->state_stack_length1;
					self->priv->state_stack_length1 = _tmp112_ - 1;
					_tmp115_ = vala_scanner_read_token (self, &_tmp113_, &_tmp114_);
					_vala_token_begin = _tmp113_;
					_vala_token_end = _tmp114_;
					result = _tmp115_;
					if (token_begin) {
						*token_begin = _vala_token_begin;
					}
					if (token_end) {
						*token_end = _vala_token_end;
					}
					return result;
				}
				break;
			}
		}
	}
	_tmp116_ = token_length_in_chars;
	if (_tmp116_ < 0) {
		gint _tmp117_;
		gchar* _tmp118_;
		gchar* _tmp119_;
		_tmp117_ = self->priv->column;
		_tmp118_ = self->priv->current;
		_tmp119_ = begin;
		self->priv->column = _tmp117_ + ((gint) (_tmp118_ - _tmp119_));
	} else {
		gint _tmp120_;
		gint _tmp121_;
		_tmp120_ = self->priv->column;
		_tmp121_ = token_length_in_chars;
		self->priv->column = _tmp120_ + _tmp121_;
	}
	_tmp122_ = self->priv->current;
	_tmp123_ = self->priv->line;
	_tmp124_ = self->priv->column;
	vala_source_location_init (&_vala_token_end, _tmp122_, _tmp123_, _tmp124_ - 1);
	result = type;
	if (token_begin) {
		*token_begin = _vala_token_begin;
	}
	if (token_end) {
		*token_end = _vala_token_end;
	}
	return result;
}


ValaTokenType
vala_scanner_get_identifier_or_keyword (gchar* begin, 
                                        gint len)
{
	ValaTokenType result = 0;
	switch (len) {
		case 2:
		{
			gchar _tmp0_;
			_tmp0_ = begin[0];
			switch (_tmp0_) {
				case 'a':
				{
					if (vala_scanner_matches (begin, "as")) {
						result = VALA_TOKEN_TYPE_AS;
						return result;
					}
					break;
				}
				case 'd':
				{
					if (vala_scanner_matches (begin, "do")) {
						result = VALA_TOKEN_TYPE_DO;
						return result;
					}
					break;
				}
				case 'i':
				{
					gchar _tmp1_;
					_tmp1_ = begin[1];
					switch (_tmp1_) {
						case 'f':
						{
							result = VALA_TOKEN_TYPE_IF;
							return result;
						}
						case 'n':
						{
							result = VALA_TOKEN_TYPE_IN;
							return result;
						}
						case 's':
						{
							result = VALA_TOKEN_TYPE_IS;
							return result;
						}
						default:
						break;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 3:
		{
			gchar _tmp2_;
			_tmp2_ = begin[0];
			switch (_tmp2_) {
				case 'f':
				{
					if (vala_scanner_matches (begin, "for")) {
						result = VALA_TOKEN_TYPE_FOR;
						return result;
					}
					break;
				}
				case 'g':
				{
					if (vala_scanner_matches (begin, "get")) {
						result = VALA_TOKEN_TYPE_GET;
						return result;
					}
					break;
				}
				case 'n':
				{
					if (vala_scanner_matches (begin, "new")) {
						result = VALA_TOKEN_TYPE_NEW;
						return result;
					}
					break;
				}
				case 'o':
				{
					if (vala_scanner_matches (begin, "out")) {
						result = VALA_TOKEN_TYPE_OUT;
						return result;
					}
					break;
				}
				case 'r':
				{
					if (vala_scanner_matches (begin, "ref")) {
						result = VALA_TOKEN_TYPE_REF;
						return result;
					}
					break;
				}
				case 's':
				{
					if (vala_scanner_matches (begin, "set")) {
						result = VALA_TOKEN_TYPE_SET;
						return result;
					}
					break;
				}
				case 't':
				{
					if (vala_scanner_matches (begin, "try")) {
						result = VALA_TOKEN_TYPE_TRY;
						return result;
					}
					break;
				}
				case 'v':
				{
					if (vala_scanner_matches (begin, "var")) {
						result = VALA_TOKEN_TYPE_VAR;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 4:
		{
			gchar _tmp3_;
			_tmp3_ = begin[0];
			switch (_tmp3_) {
				case 'b':
				{
					if (vala_scanner_matches (begin, "base")) {
						result = VALA_TOKEN_TYPE_BASE;
						return result;
					}
					break;
				}
				case 'c':
				{
					if (vala_scanner_matches (begin, "case")) {
						result = VALA_TOKEN_TYPE_CASE;
						return result;
					}
					break;
				}
				case 'e':
				{
					gchar _tmp4_;
					_tmp4_ = begin[1];
					switch (_tmp4_) {
						case 'l':
						{
							if (vala_scanner_matches (begin, "else")) {
								result = VALA_TOKEN_TYPE_ELSE;
								return result;
							}
							break;
						}
						case 'n':
						{
							if (vala_scanner_matches (begin, "enum")) {
								result = VALA_TOKEN_TYPE_ENUM;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'l':
				{
					if (vala_scanner_matches (begin, "lock")) {
						result = VALA_TOKEN_TYPE_LOCK;
						return result;
					}
					break;
				}
				case 'n':
				{
					if (vala_scanner_matches (begin, "null")) {
						result = VALA_TOKEN_TYPE_NULL;
						return result;
					}
					break;
				}
				case 't':
				{
					gchar _tmp5_;
					_tmp5_ = begin[1];
					switch (_tmp5_) {
						case 'h':
						{
							if (vala_scanner_matches (begin, "this")) {
								result = VALA_TOKEN_TYPE_THIS;
								return result;
							}
							break;
						}
						case 'r':
						{
							if (vala_scanner_matches (begin, "true")) {
								result = VALA_TOKEN_TYPE_TRUE;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'v':
				{
					if (vala_scanner_matches (begin, "void")) {
						result = VALA_TOKEN_TYPE_VOID;
						return result;
					}
					break;
				}
				case 'w':
				{
					if (vala_scanner_matches (begin, "weak")) {
						result = VALA_TOKEN_TYPE_WEAK;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 5:
		{
			gchar _tmp6_;
			_tmp6_ = begin[0];
			switch (_tmp6_) {
				case 'a':
				{
					if (vala_scanner_matches (begin, "async")) {
						result = VALA_TOKEN_TYPE_ASYNC;
						return result;
					}
					break;
				}
				case 'b':
				{
					if (vala_scanner_matches (begin, "break")) {
						result = VALA_TOKEN_TYPE_BREAK;
						return result;
					}
					break;
				}
				case 'c':
				{
					gchar _tmp7_;
					_tmp7_ = begin[1];
					switch (_tmp7_) {
						case 'a':
						{
							if (vala_scanner_matches (begin, "catch")) {
								result = VALA_TOKEN_TYPE_CATCH;
								return result;
							}
							break;
						}
						case 'l':
						{
							if (vala_scanner_matches (begin, "class")) {
								result = VALA_TOKEN_TYPE_CLASS;
								return result;
							}
							break;
						}
						case 'o':
						{
							if (vala_scanner_matches (begin, "const")) {
								result = VALA_TOKEN_TYPE_CONST;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'f':
				{
					if (vala_scanner_matches (begin, "false")) {
						result = VALA_TOKEN_TYPE_FALSE;
						return result;
					}
					break;
				}
				case 'o':
				{
					if (vala_scanner_matches (begin, "owned")) {
						result = VALA_TOKEN_TYPE_OWNED;
						return result;
					}
					break;
				}
				case 't':
				{
					if (vala_scanner_matches (begin, "throw")) {
						result = VALA_TOKEN_TYPE_THROW;
						return result;
					}
					break;
				}
				case 'u':
				{
					if (vala_scanner_matches (begin, "using")) {
						result = VALA_TOKEN_TYPE_USING;
						return result;
					}
					break;
				}
				case 'w':
				{
					if (vala_scanner_matches (begin, "while")) {
						result = VALA_TOKEN_TYPE_WHILE;
						return result;
					}
					break;
				}
				case 'y':
				{
					if (vala_scanner_matches (begin, "yield")) {
						result = VALA_TOKEN_TYPE_YIELD;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 6:
		{
			gchar _tmp8_;
			_tmp8_ = begin[0];
			switch (_tmp8_) {
				case 'd':
				{
					if (vala_scanner_matches (begin, "delete")) {
						result = VALA_TOKEN_TYPE_DELETE;
						return result;
					}
					break;
				}
				case 'e':
				{
					if (vala_scanner_matches (begin, "extern")) {
						result = VALA_TOKEN_TYPE_EXTERN;
						return result;
					}
					break;
				}
				case 'i':
				{
					if (vala_scanner_matches (begin, "inline")) {
						result = VALA_TOKEN_TYPE_INLINE;
						return result;
					}
					break;
				}
				case 'p':
				{
					gchar _tmp9_;
					_tmp9_ = begin[1];
					switch (_tmp9_) {
						case 'a':
						{
							if (vala_scanner_matches (begin, "params")) {
								result = VALA_TOKEN_TYPE_PARAMS;
								return result;
							}
							break;
						}
						case 'u':
						{
							if (vala_scanner_matches (begin, "public")) {
								result = VALA_TOKEN_TYPE_PUBLIC;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'r':
				{
					if (vala_scanner_matches (begin, "return")) {
						result = VALA_TOKEN_TYPE_RETURN;
						return result;
					}
					break;
				}
				case 's':
				{
					gchar _tmp10_;
					_tmp10_ = begin[1];
					switch (_tmp10_) {
						case 'e':
						{
							if (vala_scanner_matches (begin, "sealed")) {
								result = VALA_TOKEN_TYPE_SEALED;
								return result;
							}
							break;
						}
						case 'i':
						{
							gchar _tmp11_;
							_tmp11_ = begin[2];
							switch (_tmp11_) {
								case 'g':
								{
									if (vala_scanner_matches (begin, "signal")) {
										result = VALA_TOKEN_TYPE_SIGNAL;
										return result;
									}
									break;
								}
								case 'z':
								{
									if (vala_scanner_matches (begin, "sizeof")) {
										result = VALA_TOKEN_TYPE_SIZEOF;
										return result;
									}
									break;
								}
								default:
								break;
							}
							break;
						}
						case 't':
						{
							gchar _tmp12_;
							_tmp12_ = begin[2];
							switch (_tmp12_) {
								case 'a':
								{
									if (vala_scanner_matches (begin, "static")) {
										result = VALA_TOKEN_TYPE_STATIC;
										return result;
									}
									break;
								}
								case 'r':
								{
									if (vala_scanner_matches (begin, "struct")) {
										result = VALA_TOKEN_TYPE_STRUCT;
										return result;
									}
									break;
								}
								default:
								break;
							}
							break;
						}
						case 'w':
						{
							if (vala_scanner_matches (begin, "switch")) {
								result = VALA_TOKEN_TYPE_SWITCH;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 't':
				{
					gchar _tmp13_;
					_tmp13_ = begin[1];
					switch (_tmp13_) {
						case 'h':
						{
							if (vala_scanner_matches (begin, "throws")) {
								result = VALA_TOKEN_TYPE_THROWS;
								return result;
							}
							break;
						}
						case 'y':
						{
							if (vala_scanner_matches (begin, "typeof")) {
								result = VALA_TOKEN_TYPE_TYPEOF;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 7:
		{
			gchar _tmp14_;
			_tmp14_ = begin[0];
			switch (_tmp14_) {
				case 'd':
				{
					gchar _tmp15_;
					_tmp15_ = begin[1];
					switch (_tmp15_) {
						case 'e':
						{
							if (vala_scanner_matches (begin, "default")) {
								result = VALA_TOKEN_TYPE_DEFAULT;
								return result;
							}
							break;
						}
						case 'y':
						{
							if (vala_scanner_matches (begin, "dynamic")) {
								result = VALA_TOKEN_TYPE_DYNAMIC;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'e':
				{
					if (vala_scanner_matches (begin, "ensures")) {
						result = VALA_TOKEN_TYPE_ENSURES;
						return result;
					}
					break;
				}
				case 'f':
				{
					gchar _tmp16_;
					_tmp16_ = begin[1];
					switch (_tmp16_) {
						case 'i':
						{
							if (vala_scanner_matches (begin, "finally")) {
								result = VALA_TOKEN_TYPE_FINALLY;
								return result;
							}
							break;
						}
						case 'o':
						{
							if (vala_scanner_matches (begin, "foreach")) {
								result = VALA_TOKEN_TYPE_FOREACH;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'p':
				{
					if (vala_scanner_matches (begin, "private")) {
						result = VALA_TOKEN_TYPE_PRIVATE;
						return result;
					}
					break;
				}
				case 'u':
				{
					if (vala_scanner_matches (begin, "unowned")) {
						result = VALA_TOKEN_TYPE_UNOWNED;
						return result;
					}
					break;
				}
				case 'v':
				{
					if (vala_scanner_matches (begin, "virtual")) {
						result = VALA_TOKEN_TYPE_VIRTUAL;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 8:
		{
			gchar _tmp17_;
			_tmp17_ = begin[0];
			switch (_tmp17_) {
				case 'a':
				{
					if (vala_scanner_matches (begin, "abstract")) {
						result = VALA_TOKEN_TYPE_ABSTRACT;
						return result;
					}
					break;
				}
				case 'c':
				{
					if (vala_scanner_matches (begin, "continue")) {
						result = VALA_TOKEN_TYPE_CONTINUE;
						return result;
					}
					break;
				}
				case 'd':
				{
					if (vala_scanner_matches (begin, "delegate")) {
						result = VALA_TOKEN_TYPE_DELEGATE;
						return result;
					}
					break;
				}
				case 'i':
				{
					if (vala_scanner_matches (begin, "internal")) {
						result = VALA_TOKEN_TYPE_INTERNAL;
						return result;
					}
					break;
				}
				case 'o':
				{
					if (vala_scanner_matches (begin, "override")) {
						result = VALA_TOKEN_TYPE_OVERRIDE;
						return result;
					}
					break;
				}
				case 'r':
				{
					if (vala_scanner_matches (begin, "requires")) {
						result = VALA_TOKEN_TYPE_REQUIRES;
						return result;
					}
					break;
				}
				case 'v':
				{
					if (vala_scanner_matches (begin, "volatile")) {
						result = VALA_TOKEN_TYPE_VOLATILE;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 9:
		{
			gchar _tmp18_;
			_tmp18_ = begin[0];
			switch (_tmp18_) {
				case 'c':
				{
					if (vala_scanner_matches (begin, "construct")) {
						result = VALA_TOKEN_TYPE_CONSTRUCT;
						return result;
					}
					break;
				}
				case 'i':
				{
					if (vala_scanner_matches (begin, "interface")) {
						result = VALA_TOKEN_TYPE_INTERFACE;
						return result;
					}
					break;
				}
				case 'n':
				{
					if (vala_scanner_matches (begin, "namespace")) {
						result = VALA_TOKEN_TYPE_NAMESPACE;
						return result;
					}
					break;
				}
				case 'p':
				{
					if (vala_scanner_matches (begin, "protected")) {
						result = VALA_TOKEN_TYPE_PROTECTED;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 11:
		{
			if (vala_scanner_matches (begin, "errordomain")) {
				result = VALA_TOKEN_TYPE_ERRORDOMAIN;
				return result;
			}
			break;
		}
		default:
		break;
	}
	result = VALA_TOKEN_TYPE_IDENTIFIER;
	return result;
}


static ValaTokenType
vala_scanner_read_number (ValaScanner* self)
{
	ValaTokenType result = 0;
	ValaTokenType type = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gboolean _tmp39_ = FALSE;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	g_return_val_if_fail (self != NULL, 0);
	type = VALA_TOKEN_TYPE_INTEGER_LITERAL;
	_tmp3_ = self->priv->current;
	_tmp4_ = self->priv->end;
	if (_tmp3_ < (_tmp4_ - 2)) {
		gchar* _tmp5_;
		gchar _tmp6_;
		_tmp5_ = self->priv->current;
		_tmp6_ = _tmp5_[0];
		_tmp2_ = _tmp6_ == '0';
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gchar* _tmp7_;
		gchar _tmp8_;
		_tmp7_ = self->priv->current;
		_tmp8_ = _tmp7_[1];
		_tmp1_ = _tmp8_ == 'x';
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar* _tmp9_;
		gchar _tmp10_;
		_tmp9_ = self->priv->current;
		_tmp10_ = _tmp9_[2];
		_tmp0_ = g_ascii_isxdigit (_tmp10_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp11_;
		_tmp11_ = self->priv->current;
		self->priv->current = _tmp11_ + 2;
		while (TRUE) {
			gboolean _tmp12_ = FALSE;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp17_;
			_tmp13_ = self->priv->current;
			_tmp14_ = self->priv->end;
			if (_tmp13_ < _tmp14_) {
				gchar* _tmp15_;
				gchar _tmp16_;
				_tmp15_ = self->priv->current;
				_tmp16_ = _tmp15_[0];
				_tmp12_ = g_ascii_isxdigit (_tmp16_);
			} else {
				_tmp12_ = FALSE;
			}
			if (!_tmp12_) {
				break;
			}
			_tmp17_ = self->priv->current;
			self->priv->current = _tmp17_ + 1;
		}
	} else {
		while (TRUE) {
			gboolean _tmp18_ = FALSE;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp23_;
			_tmp19_ = self->priv->current;
			_tmp20_ = self->priv->end;
			if (_tmp19_ < _tmp20_) {
				gchar* _tmp21_;
				gchar _tmp22_;
				_tmp21_ = self->priv->current;
				_tmp22_ = _tmp21_[0];
				_tmp18_ = g_ascii_isdigit (_tmp22_);
			} else {
				_tmp18_ = FALSE;
			}
			if (!_tmp18_) {
				break;
			}
			_tmp23_ = self->priv->current;
			self->priv->current = _tmp23_ + 1;
		}
	}
	_tmp26_ = self->priv->current;
	_tmp27_ = self->priv->end;
	if (_tmp26_ < (_tmp27_ - 1)) {
		gchar* _tmp28_;
		gchar _tmp29_;
		_tmp28_ = self->priv->current;
		_tmp29_ = _tmp28_[0];
		_tmp25_ = _tmp29_ == '.';
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		gchar* _tmp30_;
		gchar _tmp31_;
		_tmp30_ = self->priv->current;
		_tmp31_ = _tmp30_[1];
		_tmp24_ = g_ascii_isdigit (_tmp31_);
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		gchar* _tmp32_;
		type = VALA_TOKEN_TYPE_REAL_LITERAL;
		_tmp32_ = self->priv->current;
		self->priv->current = _tmp32_ + 1;
		while (TRUE) {
			gboolean _tmp33_ = FALSE;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp38_;
			_tmp34_ = self->priv->current;
			_tmp35_ = self->priv->end;
			if (_tmp34_ < _tmp35_) {
				gchar* _tmp36_;
				gchar _tmp37_;
				_tmp36_ = self->priv->current;
				_tmp37_ = _tmp36_[0];
				_tmp33_ = g_ascii_isdigit (_tmp37_);
			} else {
				_tmp33_ = FALSE;
			}
			if (!_tmp33_) {
				break;
			}
			_tmp38_ = self->priv->current;
			self->priv->current = _tmp38_ + 1;
		}
	}
	_tmp40_ = self->priv->current;
	_tmp41_ = self->priv->end;
	if (_tmp40_ < _tmp41_) {
		gchar* _tmp42_;
		gchar _tmp43_;
		_tmp42_ = self->priv->current;
		_tmp43_ = _tmp42_[0];
		_tmp39_ = g_ascii_tolower (_tmp43_) == 'e';
	} else {
		_tmp39_ = FALSE;
	}
	if (_tmp39_) {
		gchar* _tmp44_;
		gboolean _tmp45_ = FALSE;
		gchar* _tmp46_;
		gchar* _tmp47_;
		type = VALA_TOKEN_TYPE_REAL_LITERAL;
		_tmp44_ = self->priv->current;
		self->priv->current = _tmp44_ + 1;
		_tmp46_ = self->priv->current;
		_tmp47_ = self->priv->end;
		if (_tmp46_ < _tmp47_) {
			gboolean _tmp48_ = FALSE;
			gchar* _tmp49_;
			gchar _tmp50_;
			_tmp49_ = self->priv->current;
			_tmp50_ = _tmp49_[0];
			if (_tmp50_ == '+') {
				_tmp48_ = TRUE;
			} else {
				gchar* _tmp51_;
				gchar _tmp52_;
				_tmp51_ = self->priv->current;
				_tmp52_ = _tmp51_[0];
				_tmp48_ = _tmp52_ == '-';
			}
			_tmp45_ = _tmp48_;
		} else {
			_tmp45_ = FALSE;
		}
		if (_tmp45_) {
			gchar* _tmp53_;
			_tmp53_ = self->priv->current;
			self->priv->current = _tmp53_ + 1;
		}
		while (TRUE) {
			gboolean _tmp54_ = FALSE;
			gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp59_;
			_tmp55_ = self->priv->current;
			_tmp56_ = self->priv->end;
			if (_tmp55_ < _tmp56_) {
				gchar* _tmp57_;
				gchar _tmp58_;
				_tmp57_ = self->priv->current;
				_tmp58_ = _tmp57_[0];
				_tmp54_ = g_ascii_isdigit (_tmp58_);
			} else {
				_tmp54_ = FALSE;
			}
			if (!_tmp54_) {
				break;
			}
			_tmp59_ = self->priv->current;
			self->priv->current = _tmp59_ + 1;
		}
	}
	_tmp60_ = self->priv->current;
	_tmp61_ = self->priv->end;
	if (_tmp60_ < _tmp61_) {
		gboolean real_literal = FALSE;
		ValaTokenType _tmp62_;
		gchar* _tmp63_;
		gchar _tmp64_;
		gboolean _tmp88_ = FALSE;
		gboolean _tmp89_;
		_tmp62_ = type;
		real_literal = _tmp62_ == VALA_TOKEN_TYPE_REAL_LITERAL;
		_tmp63_ = self->priv->current;
		_tmp64_ = _tmp63_[0];
		switch (_tmp64_) {
			case 'l':
			case 'L':
			{
				ValaTokenType _tmp65_;
				_tmp65_ = type;
				if (_tmp65_ == VALA_TOKEN_TYPE_INTEGER_LITERAL) {
					gchar* _tmp66_;
					gboolean _tmp67_ = FALSE;
					gchar* _tmp68_;
					gchar* _tmp69_;
					_tmp66_ = self->priv->current;
					self->priv->current = _tmp66_ + 1;
					_tmp68_ = self->priv->current;
					_tmp69_ = self->priv->end;
					if (_tmp68_ < _tmp69_) {
						gchar* _tmp70_;
						gchar _tmp71_;
						_tmp70_ = self->priv->current;
						_tmp71_ = _tmp70_[0];
						_tmp67_ = g_ascii_tolower (_tmp71_) == 'l';
					} else {
						_tmp67_ = FALSE;
					}
					if (_tmp67_) {
						gchar* _tmp72_;
						_tmp72_ = self->priv->current;
						self->priv->current = _tmp72_ + 1;
					}
				}
				break;
			}
			case 'u':
			case 'U':
			{
				ValaTokenType _tmp73_;
				_tmp73_ = type;
				if (_tmp73_ == VALA_TOKEN_TYPE_INTEGER_LITERAL) {
					gchar* _tmp74_;
					gboolean _tmp75_ = FALSE;
					gchar* _tmp76_;
					gchar* _tmp77_;
					_tmp74_ = self->priv->current;
					self->priv->current = _tmp74_ + 1;
					_tmp76_ = self->priv->current;
					_tmp77_ = self->priv->end;
					if (_tmp76_ < _tmp77_) {
						gchar* _tmp78_;
						gchar _tmp79_;
						_tmp78_ = self->priv->current;
						_tmp79_ = _tmp78_[0];
						_tmp75_ = g_ascii_tolower (_tmp79_) == 'l';
					} else {
						_tmp75_ = FALSE;
					}
					if (_tmp75_) {
						gchar* _tmp80_;
						gboolean _tmp81_ = FALSE;
						gchar* _tmp82_;
						gchar* _tmp83_;
						_tmp80_ = self->priv->current;
						self->priv->current = _tmp80_ + 1;
						_tmp82_ = self->priv->current;
						_tmp83_ = self->priv->end;
						if (_tmp82_ < _tmp83_) {
							gchar* _tmp84_;
							gchar _tmp85_;
							_tmp84_ = self->priv->current;
							_tmp85_ = _tmp84_[0];
							_tmp81_ = g_ascii_tolower (_tmp85_) == 'l';
						} else {
							_tmp81_ = FALSE;
						}
						if (_tmp81_) {
							gchar* _tmp86_;
							_tmp86_ = self->priv->current;
							self->priv->current = _tmp86_ + 1;
						}
					}
				}
				break;
			}
			case 'f':
			case 'F':
			case 'd':
			case 'D':
			{
				gchar* _tmp87_;
				type = VALA_TOKEN_TYPE_REAL_LITERAL;
				_tmp87_ = self->priv->current;
				self->priv->current = _tmp87_ + 1;
				break;
			}
			default:
			break;
		}
		_tmp89_ = real_literal;
		if (!_tmp89_) {
			gchar* _tmp90_;
			gchar _tmp91_;
			_tmp90_ = self->priv->current;
			_tmp91_ = _tmp90_[0];
			_tmp88_ = vala_scanner_is_ident_char (self, _tmp91_);
		} else {
			_tmp88_ = FALSE;
		}
		if (_tmp88_) {
			while (TRUE) {
				gboolean _tmp92_ = FALSE;
				gchar* _tmp93_;
				gchar* _tmp94_;
				gchar* _tmp97_;
				_tmp93_ = self->priv->current;
				_tmp94_ = self->priv->end;
				if (_tmp93_ < _tmp94_) {
					gchar* _tmp95_;
					gchar _tmp96_;
					_tmp95_ = self->priv->current;
					_tmp96_ = _tmp95_[0];
					_tmp92_ = vala_scanner_is_ident_char (self, _tmp96_);
				} else {
					_tmp92_ = FALSE;
				}
				if (!_tmp92_) {
					break;
				}
				_tmp97_ = self->priv->current;
				self->priv->current = _tmp97_ + 1;
			}
			type = VALA_TOKEN_TYPE_IDENTIFIER;
		}
	}
	result = type;
	return result;
}


static void
_vala_array_add13 (ValaScannerState* * array, 
                   int* length, 
                   int* size, 
                   ValaScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void
_vala_array_add14 (ValaScannerState* * array, 
                   int* length, 
                   int* size, 
                   ValaScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void
_vala_array_add15 (ValaScannerState* * array, 
                   int* length, 
                   int* size, 
                   ValaScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void
_vala_array_add16 (ValaScannerState* * array, 
                   int* length, 
                   int* size, 
                   ValaScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


ValaTokenType
vala_scanner_read_template_token (ValaScanner* self, 
                                  ValaSourceLocation* token_begin, 
                                  ValaSourceLocation* token_end)
{
	ValaSourceLocation _vala_token_begin = {0};
	ValaSourceLocation _vala_token_end = {0};
	ValaTokenType result = 0;
	ValaTokenType type = 0;
	gchar* begin = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint token_length_in_chars = 0;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint _tmp120_;
	gchar* _tmp126_;
	gint _tmp127_;
	gint _tmp128_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->current;
	begin = _tmp0_;
	_tmp1_ = begin;
	_tmp2_ = self->priv->line;
	_tmp3_ = self->priv->column;
	vala_source_location_init (&_vala_token_begin, _tmp1_, _tmp2_, _tmp3_);
	token_length_in_chars = -1;
	_tmp4_ = self->priv->current;
	_tmp5_ = self->priv->end;
	if (_tmp4_ >= _tmp5_) {
		type = VALA_TOKEN_TYPE_EOF;
	} else {
		gchar* _tmp6_;
		gchar _tmp7_;
		_tmp6_ = self->priv->current;
		_tmp7_ = _tmp6_[0];
		switch (_tmp7_) {
			case '"':
			{
				gchar* _tmp8_;
				gint _tmp9_;
				type = VALA_TOKEN_TYPE_CLOSE_TEMPLATE;
				_tmp8_ = self->priv->current;
				self->priv->current = _tmp8_ + 1;
				_tmp9_ = self->priv->state_stack_length1;
				self->priv->state_stack_length1 = _tmp9_ - 1;
				break;
			}
			case '$':
			{
				gchar* _tmp10_;
				gchar* _tmp11_;
				gboolean _tmp12_ = FALSE;
				gchar* _tmp13_;
				gchar _tmp14_;
				_tmp10_ = _vala_token_begin.pos;
				_vala_token_begin.pos = _tmp10_ + 1;
				_tmp11_ = self->priv->current;
				self->priv->current = _tmp11_ + 1;
				_tmp13_ = self->priv->current;
				_tmp14_ = _tmp13_[0];
				if (g_ascii_isalpha (_tmp14_)) {
					_tmp12_ = TRUE;
				} else {
					gchar* _tmp15_;
					gchar _tmp16_;
					_tmp15_ = self->priv->current;
					_tmp16_ = _tmp15_[0];
					_tmp12_ = _tmp16_ == '_';
				}
				if (_tmp12_) {
					gint len = 0;
					ValaScannerState* _tmp24_;
					gint _tmp24__length1;
					len = 0;
					while (TRUE) {
						gboolean _tmp17_ = FALSE;
						gchar* _tmp18_;
						gchar* _tmp19_;
						gchar* _tmp22_;
						gint _tmp23_;
						_tmp18_ = self->priv->current;
						_tmp19_ = self->priv->end;
						if (_tmp18_ < _tmp19_) {
							gchar* _tmp20_;
							gchar _tmp21_;
							_tmp20_ = self->priv->current;
							_tmp21_ = _tmp20_[0];
							_tmp17_ = vala_scanner_is_ident_char (self, _tmp21_);
						} else {
							_tmp17_ = FALSE;
						}
						if (!_tmp17_) {
							break;
						}
						_tmp22_ = self->priv->current;
						self->priv->current = _tmp22_ + 1;
						_tmp23_ = len;
						len = _tmp23_ + 1;
					}
					type = VALA_TOKEN_TYPE_IDENTIFIER;
					_tmp24_ = self->priv->state_stack;
					_tmp24__length1 = self->priv->state_stack_length1;
					_vala_array_add13 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_TEMPLATE_PART);
				} else {
					gchar* _tmp25_;
					gchar _tmp26_;
					_tmp25_ = self->priv->current;
					_tmp26_ = _tmp25_[0];
					if (_tmp26_ == '(') {
						gchar* _tmp27_;
						gint _tmp28_;
						ValaScannerState* _tmp29_;
						gint _tmp29__length1;
						ValaSourceLocation _tmp30_ = {0};
						ValaSourceLocation _tmp31_ = {0};
						ValaTokenType _tmp32_;
						_tmp27_ = self->priv->current;
						self->priv->current = _tmp27_ + 1;
						_tmp28_ = self->priv->column;
						self->priv->column = _tmp28_ + 2;
						_tmp29_ = self->priv->state_stack;
						_tmp29__length1 = self->priv->state_stack_length1;
						_vala_array_add14 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_PARENS);
						_tmp32_ = vala_scanner_read_token (self, &_tmp30_, &_tmp31_);
						_vala_token_begin = _tmp30_;
						_vala_token_end = _tmp31_;
						result = _tmp32_;
						if (token_begin) {
							*token_begin = _vala_token_begin;
						}
						if (token_end) {
							*token_end = _vala_token_end;
						}
						return result;
					} else {
						gchar* _tmp33_;
						gchar _tmp34_;
						_tmp33_ = self->priv->current;
						_tmp34_ = _tmp33_[0];
						if (_tmp34_ == '$') {
							gchar* _tmp35_;
							ValaScannerState* _tmp36_;
							gint _tmp36__length1;
							type = VALA_TOKEN_TYPE_TEMPLATE_STRING_LITERAL;
							_tmp35_ = self->priv->current;
							self->priv->current = _tmp35_ + 1;
							_tmp36_ = self->priv->state_stack;
							_tmp36__length1 = self->priv->state_stack_length1;
							_vala_array_add15 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_TEMPLATE_PART);
						} else {
							ValaSourceReference* _tmp37_;
							ValaSourceReference* _tmp38_;
							ValaSourceLocation _tmp39_ = {0};
							ValaSourceLocation _tmp40_ = {0};
							ValaTokenType _tmp41_;
							_tmp37_ = vala_scanner_get_source_reference (self, 1, 0);
							_tmp38_ = _tmp37_;
							vala_report_error (_tmp38_, "unexpected character");
							_vala_source_reference_unref0 (_tmp38_);
							_tmp41_ = vala_scanner_read_template_token (self, &_tmp39_, &_tmp40_);
							_vala_token_begin = _tmp39_;
							_vala_token_end = _tmp40_;
							result = _tmp41_;
							if (token_begin) {
								*token_begin = _vala_token_begin;
							}
							if (token_end) {
								*token_end = _vala_token_end;
							}
							return result;
						}
					}
				}
				break;
			}
			default:
			{
				gchar* _tmp110_;
				gchar* _tmp111_;
				ValaScannerState* _tmp119_;
				gint _tmp119__length1;
				type = VALA_TOKEN_TYPE_TEMPLATE_STRING_LITERAL;
				token_length_in_chars = 0;
				while (TRUE) {
					gboolean _tmp42_ = FALSE;
					gboolean _tmp43_ = FALSE;
					gchar* _tmp44_;
					gchar* _tmp45_;
					gchar* _tmp50_;
					gchar _tmp51_;
					_tmp44_ = self->priv->current;
					_tmp45_ = self->priv->end;
					if (_tmp44_ < _tmp45_) {
						gchar* _tmp46_;
						gchar _tmp47_;
						_tmp46_ = self->priv->current;
						_tmp47_ = _tmp46_[0];
						_tmp43_ = _tmp47_ != '"';
					} else {
						_tmp43_ = FALSE;
					}
					if (_tmp43_) {
						gchar* _tmp48_;
						gchar _tmp49_;
						_tmp48_ = self->priv->current;
						_tmp49_ = _tmp48_[0];
						_tmp42_ = _tmp49_ != '$';
					} else {
						_tmp42_ = FALSE;
					}
					if (!_tmp42_) {
						break;
					}
					_tmp50_ = self->priv->current;
					_tmp51_ = _tmp50_[0];
					if (_tmp51_ == '\\') {
						gchar* _tmp52_;
						gint _tmp53_;
						gchar* _tmp54_;
						gchar* _tmp55_;
						gchar* _tmp56_;
						gchar _tmp57_;
						_tmp52_ = self->priv->current;
						self->priv->current = _tmp52_ + 1;
						_tmp53_ = token_length_in_chars;
						token_length_in_chars = _tmp53_ + 1;
						_tmp54_ = self->priv->current;
						_tmp55_ = self->priv->end;
						if (_tmp54_ >= _tmp55_) {
							break;
						}
						_tmp56_ = self->priv->current;
						_tmp57_ = _tmp56_[0];
						switch (_tmp57_) {
							case '\'':
							case '"':
							case '\\':
							case '0':
							case 'b':
							case 'f':
							case 'n':
							case 'r':
							case 't':
							case 'v':
							{
								gchar* _tmp58_;
								gint _tmp59_;
								_tmp58_ = self->priv->current;
								self->priv->current = _tmp58_ + 1;
								_tmp59_ = token_length_in_chars;
								token_length_in_chars = _tmp59_ + 1;
								break;
							}
							case 'u':
							{
								gchar* _tmp60_;
								gint _tmp61_;
								gint digit_length = 0;
								gint _tmp73_;
								_tmp60_ = self->priv->current;
								self->priv->current = _tmp60_ + 1;
								_tmp61_ = token_length_in_chars;
								token_length_in_chars = _tmp61_ + 1;
								{
									gboolean _tmp62_ = FALSE;
									digit_length = 0;
									_tmp62_ = TRUE;
									while (TRUE) {
										gboolean _tmp64_ = FALSE;
										gboolean _tmp65_ = FALSE;
										gint _tmp66_;
										gchar* _tmp71_;
										gint _tmp72_;
										if (!_tmp62_) {
											gint _tmp63_;
											_tmp63_ = digit_length;
											digit_length = _tmp63_ + 1;
										}
										_tmp62_ = FALSE;
										_tmp66_ = digit_length;
										if (_tmp66_ < 4) {
											gchar* _tmp67_;
											gchar* _tmp68_;
											_tmp67_ = self->priv->current;
											_tmp68_ = self->priv->end;
											_tmp65_ = _tmp67_ < _tmp68_;
										} else {
											_tmp65_ = FALSE;
										}
										if (_tmp65_) {
											gchar* _tmp69_;
											gchar _tmp70_;
											_tmp69_ = self->priv->current;
											_tmp70_ = _tmp69_[0];
											_tmp64_ = g_ascii_isxdigit (_tmp70_);
										} else {
											_tmp64_ = FALSE;
										}
										if (!_tmp64_) {
											break;
										}
										_tmp71_ = self->priv->current;
										self->priv->current = _tmp71_ + 1;
										_tmp72_ = token_length_in_chars;
										token_length_in_chars = _tmp72_ + 1;
									}
								}
								_tmp73_ = digit_length;
								if (_tmp73_ != 4) {
									gint _tmp74_;
									ValaSourceReference* _tmp75_;
									ValaSourceReference* _tmp76_;
									_tmp74_ = token_length_in_chars;
									_tmp75_ = vala_scanner_get_source_reference (self, _tmp74_, 0);
									_tmp76_ = _tmp75_;
									vala_report_error (_tmp76_, "\\u requires four hex digits");
									_vala_source_reference_unref0 (_tmp76_);
								}
								break;
							}
							case 'x':
							{
								gchar* _tmp77_;
								gint _tmp78_;
								gint digit_length = 0;
								gint _tmp88_;
								_tmp77_ = self->priv->current;
								self->priv->current = _tmp77_ + 1;
								_tmp78_ = token_length_in_chars;
								token_length_in_chars = _tmp78_ + 1;
								{
									gboolean _tmp79_ = FALSE;
									digit_length = 0;
									_tmp79_ = TRUE;
									while (TRUE) {
										gboolean _tmp81_ = FALSE;
										gchar* _tmp82_;
										gchar* _tmp83_;
										gchar* _tmp86_;
										gint _tmp87_;
										if (!_tmp79_) {
											gint _tmp80_;
											_tmp80_ = digit_length;
											digit_length = _tmp80_ + 1;
										}
										_tmp79_ = FALSE;
										_tmp82_ = self->priv->current;
										_tmp83_ = self->priv->end;
										if (_tmp82_ < _tmp83_) {
											gchar* _tmp84_;
											gchar _tmp85_;
											_tmp84_ = self->priv->current;
											_tmp85_ = _tmp84_[0];
											_tmp81_ = g_ascii_isxdigit (_tmp85_);
										} else {
											_tmp81_ = FALSE;
										}
										if (!_tmp81_) {
											break;
										}
										_tmp86_ = self->priv->current;
										self->priv->current = _tmp86_ + 1;
										_tmp87_ = token_length_in_chars;
										token_length_in_chars = _tmp87_ + 1;
									}
								}
								_tmp88_ = digit_length;
								if (_tmp88_ < 1) {
									gint _tmp89_;
									ValaSourceReference* _tmp90_;
									ValaSourceReference* _tmp91_;
									_tmp89_ = token_length_in_chars;
									_tmp90_ = vala_scanner_get_source_reference (self, _tmp89_, 0);
									_tmp91_ = _tmp90_;
									vala_report_error (_tmp91_, "\\x requires at least one hex digit");
									_vala_source_reference_unref0 (_tmp91_);
								}
								break;
							}
							default:
							{
								gint _tmp92_;
								ValaSourceReference* _tmp93_;
								ValaSourceReference* _tmp94_;
								_tmp92_ = token_length_in_chars;
								_tmp93_ = vala_scanner_get_source_reference (self, _tmp92_, 0);
								_tmp94_ = _tmp93_;
								vala_report_error (_tmp94_, "invalid escape sequence");
								_vala_source_reference_unref0 (_tmp94_);
								break;
							}
						}
					} else {
						gchar* _tmp95_;
						gchar _tmp96_;
						_tmp95_ = self->priv->current;
						_tmp96_ = _tmp95_[0];
						if (_tmp96_ == '\n') {
							gchar* _tmp97_;
							gint _tmp98_;
							_tmp97_ = self->priv->current;
							self->priv->current = _tmp97_ + 1;
							_tmp98_ = self->priv->line;
							self->priv->line = _tmp98_ + 1;
							self->priv->column = 1;
							token_length_in_chars = 1;
						} else {
							gunichar u = 0U;
							gchar* _tmp99_;
							gchar* _tmp100_;
							gchar* _tmp101_;
							gunichar _tmp102_;
							_tmp99_ = self->priv->current;
							_tmp100_ = self->priv->end;
							_tmp101_ = self->priv->current;
							u = g_utf8_get_char_validated ((const gchar*) _tmp99_, (gssize) ((glong) (_tmp100_ - _tmp101_)));
							_tmp102_ = u;
							if (_tmp102_ != ((gunichar) -1)) {
								gchar* _tmp103_;
								gunichar _tmp104_;
								gint _tmp105_;
								_tmp103_ = self->priv->current;
								_tmp104_ = u;
								self->priv->current = _tmp103_ + g_unichar_to_utf8 (_tmp104_, NULL);
								_tmp105_ = token_length_in_chars;
								token_length_in_chars = _tmp105_ + 1;
							} else {
								gchar* _tmp106_;
								gint _tmp107_;
								ValaSourceReference* _tmp108_;
								ValaSourceReference* _tmp109_;
								_tmp106_ = self->priv->current;
								self->priv->current = _tmp106_ + 1;
								_tmp107_ = token_length_in_chars;
								_tmp108_ = vala_scanner_get_source_reference (self, _tmp107_, 0);
								_tmp109_ = _tmp108_;
								vala_report_error (_tmp109_, "invalid UTF-8 character");
								_vala_source_reference_unref0 (_tmp109_);
							}
						}
					}
				}
				_tmp110_ = self->priv->current;
				_tmp111_ = self->priv->end;
				if (_tmp110_ >= _tmp111_) {
					gint _tmp112_;
					ValaSourceReference* _tmp113_;
					ValaSourceReference* _tmp114_;
					gint _tmp115_;
					ValaSourceLocation _tmp116_ = {0};
					ValaSourceLocation _tmp117_ = {0};
					ValaTokenType _tmp118_;
					_tmp112_ = token_length_in_chars;
					_tmp113_ = vala_scanner_get_source_reference (self, _tmp112_, 0);
					_tmp114_ = _tmp113_;
					vala_report_error (_tmp114_, "syntax error, expected \"");
					_vala_source_reference_unref0 (_tmp114_);
					_tmp115_ = self->priv->state_stack_length1;
					self->priv->state_stack_length1 = _tmp115_ - 1;
					_tmp118_ = vala_scanner_read_token (self, &_tmp116_, &_tmp117_);
					_vala_token_begin = _tmp116_;
					_vala_token_end = _tmp117_;
					result = _tmp118_;
					if (token_begin) {
						*token_begin = _vala_token_begin;
					}
					if (token_end) {
						*token_end = _vala_token_end;
					}
					return result;
				}
				_tmp119_ = self->priv->state_stack;
				_tmp119__length1 = self->priv->state_stack_length1;
				_vala_array_add16 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_TEMPLATE_PART);
				break;
			}
		}
	}
	_tmp120_ = token_length_in_chars;
	if (_tmp120_ < 0) {
		gint _tmp121_;
		gchar* _tmp122_;
		gchar* _tmp123_;
		_tmp121_ = self->priv->column;
		_tmp122_ = self->priv->current;
		_tmp123_ = begin;
		self->priv->column = _tmp121_ + ((gint) (_tmp122_ - _tmp123_));
	} else {
		gint _tmp124_;
		gint _tmp125_;
		_tmp124_ = self->priv->column;
		_tmp125_ = token_length_in_chars;
		self->priv->column = _tmp124_ + _tmp125_;
	}
	_tmp126_ = self->priv->current;
	_tmp127_ = self->priv->line;
	_tmp128_ = self->priv->column;
	vala_source_location_init (&_vala_token_end, _tmp126_, _tmp127_, _tmp128_ - 1);
	result = type;
	if (token_begin) {
		*token_begin = _vala_token_begin;
	}
	if (token_end) {
		*token_end = _vala_token_end;
	}
	return result;
}


static void
_vala_array_add17 (ValaScannerState* * array, 
                   int* length, 
                   int* size, 
                   ValaScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void
_vala_array_add18 (ValaScannerState* * array, 
                   int* length, 
                   int* size, 
                   ValaScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void
_vala_array_add19 (ValaScannerState* * array, 
                   int* length, 
                   int* size, 
                   ValaScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void
_vala_array_add20 (ValaScannerState* * array, 
                   int* length, 
                   int* size, 
                   ValaScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void
_vala_array_add21 (ValaScannerState* * array, 
                   int* length, 
                   int* size, 
                   ValaScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


ValaTokenType
vala_scanner_read_token (ValaScanner* self, 
                         ValaSourceLocation* token_begin, 
                         ValaSourceLocation* token_end)
{
	ValaSourceLocation _vala_token_begin = {0};
	ValaSourceLocation _vala_token_end = {0};
	ValaTokenType result = 0;
	ValaTokenType type = 0;
	gchar* begin = NULL;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint token_length_in_chars = 0;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gint _tmp345_;
	gchar* _tmp351_;
	gint _tmp352_;
	gint _tmp353_;
	ValaTokenType _tmp354_;
	g_return_val_if_fail (self != NULL, 0);
	if (vala_scanner_in_template (self)) {
		ValaSourceLocation _tmp0_ = {0};
		ValaSourceLocation _tmp1_ = {0};
		ValaTokenType _tmp2_;
		_tmp2_ = vala_scanner_read_template_token (self, &_tmp0_, &_tmp1_);
		_vala_token_begin = _tmp0_;
		_vala_token_end = _tmp1_;
		result = _tmp2_;
		if (token_begin) {
			*token_begin = _vala_token_begin;
		}
		if (token_end) {
			*token_end = _vala_token_end;
		}
		return result;
	} else {
		if (vala_scanner_in_template_part (self)) {
			gint _tmp3_;
			gchar* _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			gchar* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			_tmp3_ = self->priv->state_stack_length1;
			self->priv->state_stack_length1 = _tmp3_ - 1;
			_tmp4_ = self->priv->current;
			_tmp5_ = self->priv->line;
			_tmp6_ = self->priv->column;
			vala_source_location_init (&_vala_token_begin, _tmp4_, _tmp5_, _tmp6_);
			_tmp7_ = self->priv->current;
			_tmp8_ = self->priv->line;
			_tmp9_ = self->priv->column;
			vala_source_location_init (&_vala_token_end, _tmp7_, _tmp8_, _tmp9_ - 1);
			result = VALA_TOKEN_TYPE_COMMA;
			if (token_begin) {
				*token_begin = _vala_token_begin;
			}
			if (token_end) {
				*token_end = _vala_token_end;
			}
			return result;
		} else {
			if (vala_scanner_in_regex_literal (self)) {
				ValaSourceLocation _tmp10_ = {0};
				ValaSourceLocation _tmp11_ = {0};
				ValaTokenType _tmp12_;
				_tmp12_ = vala_scanner_read_regex_token (self, &_tmp10_, &_tmp11_);
				_vala_token_begin = _tmp10_;
				_vala_token_end = _tmp11_;
				result = _tmp12_;
				if (token_begin) {
					*token_begin = _vala_token_begin;
				}
				if (token_end) {
					*token_end = _vala_token_end;
				}
				return result;
			}
		}
	}
	vala_scanner_space (self);
	_tmp13_ = self->priv->current;
	begin = _tmp13_;
	_tmp14_ = begin;
	_tmp15_ = self->priv->line;
	_tmp16_ = self->priv->column;
	vala_source_location_init (&_vala_token_begin, _tmp14_, _tmp15_, _tmp16_);
	token_length_in_chars = -1;
	_tmp17_ = self->priv->current;
	_tmp18_ = self->priv->end;
	if (_tmp17_ >= _tmp18_) {
		type = VALA_TOKEN_TYPE_EOF;
	} else {
		gboolean _tmp19_ = FALSE;
		gchar* _tmp20_;
		gchar _tmp21_;
		_tmp20_ = self->priv->current;
		_tmp21_ = _tmp20_[0];
		if (g_ascii_isalpha (_tmp21_)) {
			_tmp19_ = TRUE;
		} else {
			gchar* _tmp22_;
			gchar _tmp23_;
			_tmp22_ = self->priv->current;
			_tmp23_ = _tmp22_[0];
			_tmp19_ = _tmp23_ == '_';
		}
		if (_tmp19_) {
			gint len = 0;
			gchar* _tmp31_;
			gint _tmp32_;
			len = 0;
			while (TRUE) {
				gboolean _tmp24_ = FALSE;
				gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp29_;
				gint _tmp30_;
				_tmp25_ = self->priv->current;
				_tmp26_ = self->priv->end;
				if (_tmp25_ < _tmp26_) {
					gchar* _tmp27_;
					gchar _tmp28_;
					_tmp27_ = self->priv->current;
					_tmp28_ = _tmp27_[0];
					_tmp24_ = vala_scanner_is_ident_char (self, _tmp28_);
				} else {
					_tmp24_ = FALSE;
				}
				if (!_tmp24_) {
					break;
				}
				_tmp29_ = self->priv->current;
				self->priv->current = _tmp29_ + 1;
				_tmp30_ = len;
				len = _tmp30_ + 1;
			}
			_tmp31_ = begin;
			_tmp32_ = len;
			type = vala_scanner_get_identifier_or_keyword (_tmp31_, _tmp32_);
		} else {
			gchar* _tmp33_;
			gchar _tmp34_;
			_tmp33_ = self->priv->current;
			_tmp34_ = _tmp33_[0];
			if (_tmp34_ == '@') {
				gboolean _tmp35_ = FALSE;
				gchar* _tmp36_;
				gchar* _tmp37_;
				_tmp36_ = self->priv->current;
				_tmp37_ = self->priv->end;
				if (_tmp36_ < (_tmp37_ - 1)) {
					gchar* _tmp38_;
					gchar _tmp39_;
					_tmp38_ = self->priv->current;
					_tmp39_ = _tmp38_[1];
					_tmp35_ = _tmp39_ == '"';
				} else {
					_tmp35_ = FALSE;
				}
				if (_tmp35_) {
					gchar* _tmp40_;
					ValaScannerState* _tmp41_;
					gint _tmp41__length1;
					type = VALA_TOKEN_TYPE_OPEN_TEMPLATE;
					_tmp40_ = self->priv->current;
					self->priv->current = _tmp40_ + 2;
					_tmp41_ = self->priv->state_stack;
					_tmp41__length1 = self->priv->state_stack_length1;
					_vala_array_add17 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_TEMPLATE);
				} else {
					gchar* _tmp42_;
					gchar* _tmp43_;
					gint len = 0;
					_tmp42_ = _vala_token_begin.pos;
					_vala_token_begin.pos = _tmp42_ + 1;
					_tmp43_ = self->priv->current;
					self->priv->current = _tmp43_ + 1;
					len = 0;
					while (TRUE) {
						gboolean _tmp44_ = FALSE;
						gchar* _tmp45_;
						gchar* _tmp46_;
						gchar* _tmp49_;
						gint _tmp50_;
						_tmp45_ = self->priv->current;
						_tmp46_ = self->priv->end;
						if (_tmp45_ < _tmp46_) {
							gchar* _tmp47_;
							gchar _tmp48_;
							_tmp47_ = self->priv->current;
							_tmp48_ = _tmp47_[0];
							_tmp44_ = vala_scanner_is_ident_char (self, _tmp48_);
						} else {
							_tmp44_ = FALSE;
						}
						if (!_tmp44_) {
							break;
						}
						_tmp49_ = self->priv->current;
						self->priv->current = _tmp49_ + 1;
						_tmp50_ = len;
						len = _tmp50_ + 1;
					}
					type = VALA_TOKEN_TYPE_IDENTIFIER;
				}
			} else {
				gchar* _tmp51_;
				gchar _tmp52_;
				_tmp51_ = self->priv->current;
				_tmp52_ = _tmp51_[0];
				if (g_ascii_isdigit (_tmp52_)) {
					type = vala_scanner_read_number (self);
				} else {
					gchar* _tmp53_;
					gchar _tmp54_;
					_tmp53_ = self->priv->current;
					_tmp54_ = _tmp53_[0];
					switch (_tmp54_) {
						case '{':
						{
							gchar* _tmp55_;
							ValaScannerState* _tmp56_;
							gint _tmp56__length1;
							type = VALA_TOKEN_TYPE_OPEN_BRACE;
							_tmp55_ = self->priv->current;
							self->priv->current = _tmp55_ + 1;
							_tmp56_ = self->priv->state_stack;
							_tmp56__length1 = self->priv->state_stack_length1;
							_vala_array_add18 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_BRACE);
							break;
						}
						case '}':
						{
							gchar* _tmp57_;
							ValaScannerState* _tmp58_;
							gint _tmp58__length1;
							type = VALA_TOKEN_TYPE_CLOSE_BRACE;
							_tmp57_ = self->priv->current;
							self->priv->current = _tmp57_ + 1;
							_tmp58_ = self->priv->state_stack;
							_tmp58__length1 = self->priv->state_stack_length1;
							if (_tmp58__length1 > 0) {
								gint _tmp59_;
								_tmp59_ = self->priv->state_stack_length1;
								self->priv->state_stack_length1 = _tmp59_ - 1;
							}
							break;
						}
						case '(':
						{
							gchar* _tmp60_;
							ValaScannerState* _tmp61_;
							gint _tmp61__length1;
							type = VALA_TOKEN_TYPE_OPEN_PARENS;
							_tmp60_ = self->priv->current;
							self->priv->current = _tmp60_ + 1;
							_tmp61_ = self->priv->state_stack;
							_tmp61__length1 = self->priv->state_stack_length1;
							_vala_array_add19 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_PARENS);
							break;
						}
						case ')':
						{
							gchar* _tmp62_;
							ValaScannerState* _tmp63_;
							gint _tmp63__length1;
							type = VALA_TOKEN_TYPE_CLOSE_PARENS;
							_tmp62_ = self->priv->current;
							self->priv->current = _tmp62_ + 1;
							_tmp63_ = self->priv->state_stack;
							_tmp63__length1 = self->priv->state_stack_length1;
							if (_tmp63__length1 > 0) {
								gint _tmp64_;
								_tmp64_ = self->priv->state_stack_length1;
								self->priv->state_stack_length1 = _tmp64_ - 1;
							}
							if (vala_scanner_in_template (self)) {
								type = VALA_TOKEN_TYPE_COMMA;
							}
							break;
						}
						case '[':
						{
							gchar* _tmp65_;
							ValaScannerState* _tmp66_;
							gint _tmp66__length1;
							type = VALA_TOKEN_TYPE_OPEN_BRACKET;
							_tmp65_ = self->priv->current;
							self->priv->current = _tmp65_ + 1;
							_tmp66_ = self->priv->state_stack;
							_tmp66__length1 = self->priv->state_stack_length1;
							_vala_array_add20 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_BRACKET);
							break;
						}
						case ']':
						{
							gchar* _tmp67_;
							ValaScannerState* _tmp68_;
							gint _tmp68__length1;
							type = VALA_TOKEN_TYPE_CLOSE_BRACKET;
							_tmp67_ = self->priv->current;
							self->priv->current = _tmp67_ + 1;
							_tmp68_ = self->priv->state_stack;
							_tmp68__length1 = self->priv->state_stack_length1;
							if (_tmp68__length1 > 0) {
								gint _tmp69_;
								_tmp69_ = self->priv->state_stack_length1;
								self->priv->state_stack_length1 = _tmp69_ - 1;
							}
							break;
						}
						case '.':
						{
							gchar* _tmp70_;
							gchar* _tmp71_;
							gchar* _tmp72_;
							type = VALA_TOKEN_TYPE_DOT;
							_tmp70_ = self->priv->current;
							self->priv->current = _tmp70_ + 1;
							_tmp71_ = self->priv->current;
							_tmp72_ = self->priv->end;
							if (_tmp71_ < (_tmp72_ - 1)) {
								gboolean _tmp73_ = FALSE;
								gchar* _tmp74_;
								gchar _tmp75_;
								_tmp74_ = self->priv->current;
								_tmp75_ = _tmp74_[0];
								if (_tmp75_ == '.') {
									gchar* _tmp76_;
									gchar _tmp77_;
									_tmp76_ = self->priv->current;
									_tmp77_ = _tmp76_[1];
									_tmp73_ = _tmp77_ == '.';
								} else {
									_tmp73_ = FALSE;
								}
								if (_tmp73_) {
									gchar* _tmp78_;
									type = VALA_TOKEN_TYPE_ELLIPSIS;
									_tmp78_ = self->priv->current;
									self->priv->current = _tmp78_ + 2;
								}
							}
							break;
						}
						case ':':
						{
							gchar* _tmp79_;
							gboolean _tmp80_ = FALSE;
							gchar* _tmp81_;
							gchar* _tmp82_;
							type = VALA_TOKEN_TYPE_COLON;
							_tmp79_ = self->priv->current;
							self->priv->current = _tmp79_ + 1;
							_tmp81_ = self->priv->current;
							_tmp82_ = self->priv->end;
							if (_tmp81_ < _tmp82_) {
								gchar* _tmp83_;
								gchar _tmp84_;
								_tmp83_ = self->priv->current;
								_tmp84_ = _tmp83_[0];
								_tmp80_ = _tmp84_ == ':';
							} else {
								_tmp80_ = FALSE;
							}
							if (_tmp80_) {
								gchar* _tmp85_;
								type = VALA_TOKEN_TYPE_DOUBLE_COLON;
								_tmp85_ = self->priv->current;
								self->priv->current = _tmp85_ + 1;
							}
							break;
						}
						case ',':
						{
							gchar* _tmp86_;
							type = VALA_TOKEN_TYPE_COMMA;
							_tmp86_ = self->priv->current;
							self->priv->current = _tmp86_ + 1;
							break;
						}
						case ';':
						{
							gchar* _tmp87_;
							type = VALA_TOKEN_TYPE_SEMICOLON;
							_tmp87_ = self->priv->current;
							self->priv->current = _tmp87_ + 1;
							break;
						}
						case '#':
						{
							gchar* _tmp88_;
							type = VALA_TOKEN_TYPE_HASH;
							_tmp88_ = self->priv->current;
							self->priv->current = _tmp88_ + 1;
							break;
						}
						case '?':
						{
							gchar* _tmp89_;
							gboolean _tmp90_ = FALSE;
							gchar* _tmp91_;
							gchar* _tmp92_;
							type = VALA_TOKEN_TYPE_INTERR;
							_tmp89_ = self->priv->current;
							self->priv->current = _tmp89_ + 1;
							_tmp91_ = self->priv->current;
							_tmp92_ = self->priv->end;
							if (_tmp91_ < _tmp92_) {
								gchar* _tmp93_;
								gchar _tmp94_;
								_tmp93_ = self->priv->current;
								_tmp94_ = _tmp93_[0];
								_tmp90_ = _tmp94_ == '?';
							} else {
								_tmp90_ = FALSE;
							}
							if (_tmp90_) {
								gchar* _tmp95_;
								type = VALA_TOKEN_TYPE_OP_COALESCING;
								_tmp95_ = self->priv->current;
								self->priv->current = _tmp95_ + 1;
							}
							break;
						}
						case '|':
						{
							gchar* _tmp96_;
							gchar* _tmp97_;
							gchar* _tmp98_;
							type = VALA_TOKEN_TYPE_BITWISE_OR;
							_tmp96_ = self->priv->current;
							self->priv->current = _tmp96_ + 1;
							_tmp97_ = self->priv->current;
							_tmp98_ = self->priv->end;
							if (_tmp97_ < _tmp98_) {
								gchar* _tmp99_;
								gchar _tmp100_;
								_tmp99_ = self->priv->current;
								_tmp100_ = _tmp99_[0];
								switch (_tmp100_) {
									case '=':
									{
										gchar* _tmp101_;
										type = VALA_TOKEN_TYPE_ASSIGN_BITWISE_OR;
										_tmp101_ = self->priv->current;
										self->priv->current = _tmp101_ + 1;
										break;
									}
									case '|':
									{
										gchar* _tmp102_;
										type = VALA_TOKEN_TYPE_OP_OR;
										_tmp102_ = self->priv->current;
										self->priv->current = _tmp102_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '&':
						{
							gchar* _tmp103_;
							gchar* _tmp104_;
							gchar* _tmp105_;
							type = VALA_TOKEN_TYPE_BITWISE_AND;
							_tmp103_ = self->priv->current;
							self->priv->current = _tmp103_ + 1;
							_tmp104_ = self->priv->current;
							_tmp105_ = self->priv->end;
							if (_tmp104_ < _tmp105_) {
								gchar* _tmp106_;
								gchar _tmp107_;
								_tmp106_ = self->priv->current;
								_tmp107_ = _tmp106_[0];
								switch (_tmp107_) {
									case '=':
									{
										gchar* _tmp108_;
										type = VALA_TOKEN_TYPE_ASSIGN_BITWISE_AND;
										_tmp108_ = self->priv->current;
										self->priv->current = _tmp108_ + 1;
										break;
									}
									case '&':
									{
										gchar* _tmp109_;
										type = VALA_TOKEN_TYPE_OP_AND;
										_tmp109_ = self->priv->current;
										self->priv->current = _tmp109_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '^':
						{
							gchar* _tmp110_;
							gboolean _tmp111_ = FALSE;
							gchar* _tmp112_;
							gchar* _tmp113_;
							type = VALA_TOKEN_TYPE_CARRET;
							_tmp110_ = self->priv->current;
							self->priv->current = _tmp110_ + 1;
							_tmp112_ = self->priv->current;
							_tmp113_ = self->priv->end;
							if (_tmp112_ < _tmp113_) {
								gchar* _tmp114_;
								gchar _tmp115_;
								_tmp114_ = self->priv->current;
								_tmp115_ = _tmp114_[0];
								_tmp111_ = _tmp115_ == '=';
							} else {
								_tmp111_ = FALSE;
							}
							if (_tmp111_) {
								gchar* _tmp116_;
								type = VALA_TOKEN_TYPE_ASSIGN_BITWISE_XOR;
								_tmp116_ = self->priv->current;
								self->priv->current = _tmp116_ + 1;
							}
							break;
						}
						case '~':
						{
							gchar* _tmp117_;
							type = VALA_TOKEN_TYPE_TILDE;
							_tmp117_ = self->priv->current;
							self->priv->current = _tmp117_ + 1;
							break;
						}
						case '=':
						{
							gchar* _tmp118_;
							gchar* _tmp119_;
							gchar* _tmp120_;
							type = VALA_TOKEN_TYPE_ASSIGN;
							_tmp118_ = self->priv->current;
							self->priv->current = _tmp118_ + 1;
							_tmp119_ = self->priv->current;
							_tmp120_ = self->priv->end;
							if (_tmp119_ < _tmp120_) {
								gchar* _tmp121_;
								gchar _tmp122_;
								_tmp121_ = self->priv->current;
								_tmp122_ = _tmp121_[0];
								switch (_tmp122_) {
									case '=':
									{
										gchar* _tmp123_;
										type = VALA_TOKEN_TYPE_OP_EQ;
										_tmp123_ = self->priv->current;
										self->priv->current = _tmp123_ + 1;
										break;
									}
									case '>':
									{
										gchar* _tmp124_;
										type = VALA_TOKEN_TYPE_LAMBDA;
										_tmp124_ = self->priv->current;
										self->priv->current = _tmp124_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '<':
						{
							gchar* _tmp125_;
							gchar* _tmp126_;
							gchar* _tmp127_;
							type = VALA_TOKEN_TYPE_OP_LT;
							_tmp125_ = self->priv->current;
							self->priv->current = _tmp125_ + 1;
							_tmp126_ = self->priv->current;
							_tmp127_ = self->priv->end;
							if (_tmp126_ < _tmp127_) {
								gchar* _tmp128_;
								gchar _tmp129_;
								_tmp128_ = self->priv->current;
								_tmp129_ = _tmp128_[0];
								switch (_tmp129_) {
									case '=':
									{
										gchar* _tmp130_;
										type = VALA_TOKEN_TYPE_OP_LE;
										_tmp130_ = self->priv->current;
										self->priv->current = _tmp130_ + 1;
										break;
									}
									case '<':
									{
										gchar* _tmp131_;
										gboolean _tmp132_ = FALSE;
										gchar* _tmp133_;
										gchar* _tmp134_;
										type = VALA_TOKEN_TYPE_OP_SHIFT_LEFT;
										_tmp131_ = self->priv->current;
										self->priv->current = _tmp131_ + 1;
										_tmp133_ = self->priv->current;
										_tmp134_ = self->priv->end;
										if (_tmp133_ < _tmp134_) {
											gchar* _tmp135_;
											gchar _tmp136_;
											_tmp135_ = self->priv->current;
											_tmp136_ = _tmp135_[0];
											_tmp132_ = _tmp136_ == '=';
										} else {
											_tmp132_ = FALSE;
										}
										if (_tmp132_) {
											gchar* _tmp137_;
											type = VALA_TOKEN_TYPE_ASSIGN_SHIFT_LEFT;
											_tmp137_ = self->priv->current;
											self->priv->current = _tmp137_ + 1;
										}
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '>':
						{
							gchar* _tmp138_;
							gboolean _tmp139_ = FALSE;
							gchar* _tmp140_;
							gchar* _tmp141_;
							type = VALA_TOKEN_TYPE_OP_GT;
							_tmp138_ = self->priv->current;
							self->priv->current = _tmp138_ + 1;
							_tmp140_ = self->priv->current;
							_tmp141_ = self->priv->end;
							if (_tmp140_ < _tmp141_) {
								gchar* _tmp142_;
								gchar _tmp143_;
								_tmp142_ = self->priv->current;
								_tmp143_ = _tmp142_[0];
								_tmp139_ = _tmp143_ == '=';
							} else {
								_tmp139_ = FALSE;
							}
							if (_tmp139_) {
								gchar* _tmp144_;
								type = VALA_TOKEN_TYPE_OP_GE;
								_tmp144_ = self->priv->current;
								self->priv->current = _tmp144_ + 1;
							}
							break;
						}
						case '!':
						{
							gchar* _tmp145_;
							gboolean _tmp146_ = FALSE;
							gchar* _tmp147_;
							gchar* _tmp148_;
							type = VALA_TOKEN_TYPE_OP_NEG;
							_tmp145_ = self->priv->current;
							self->priv->current = _tmp145_ + 1;
							_tmp147_ = self->priv->current;
							_tmp148_ = self->priv->end;
							if (_tmp147_ < _tmp148_) {
								gchar* _tmp149_;
								gchar _tmp150_;
								_tmp149_ = self->priv->current;
								_tmp150_ = _tmp149_[0];
								_tmp146_ = _tmp150_ == '=';
							} else {
								_tmp146_ = FALSE;
							}
							if (_tmp146_) {
								gchar* _tmp151_;
								type = VALA_TOKEN_TYPE_OP_NE;
								_tmp151_ = self->priv->current;
								self->priv->current = _tmp151_ + 1;
							}
							break;
						}
						case '+':
						{
							gchar* _tmp152_;
							gchar* _tmp153_;
							gchar* _tmp154_;
							type = VALA_TOKEN_TYPE_PLUS;
							_tmp152_ = self->priv->current;
							self->priv->current = _tmp152_ + 1;
							_tmp153_ = self->priv->current;
							_tmp154_ = self->priv->end;
							if (_tmp153_ < _tmp154_) {
								gchar* _tmp155_;
								gchar _tmp156_;
								_tmp155_ = self->priv->current;
								_tmp156_ = _tmp155_[0];
								switch (_tmp156_) {
									case '=':
									{
										gchar* _tmp157_;
										type = VALA_TOKEN_TYPE_ASSIGN_ADD;
										_tmp157_ = self->priv->current;
										self->priv->current = _tmp157_ + 1;
										break;
									}
									case '+':
									{
										gchar* _tmp158_;
										type = VALA_TOKEN_TYPE_OP_INC;
										_tmp158_ = self->priv->current;
										self->priv->current = _tmp158_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '-':
						{
							gchar* _tmp159_;
							gchar* _tmp160_;
							gchar* _tmp161_;
							type = VALA_TOKEN_TYPE_MINUS;
							_tmp159_ = self->priv->current;
							self->priv->current = _tmp159_ + 1;
							_tmp160_ = self->priv->current;
							_tmp161_ = self->priv->end;
							if (_tmp160_ < _tmp161_) {
								gchar* _tmp162_;
								gchar _tmp163_;
								_tmp162_ = self->priv->current;
								_tmp163_ = _tmp162_[0];
								switch (_tmp163_) {
									case '=':
									{
										gchar* _tmp164_;
										type = VALA_TOKEN_TYPE_ASSIGN_SUB;
										_tmp164_ = self->priv->current;
										self->priv->current = _tmp164_ + 1;
										break;
									}
									case '-':
									{
										gchar* _tmp165_;
										type = VALA_TOKEN_TYPE_OP_DEC;
										_tmp165_ = self->priv->current;
										self->priv->current = _tmp165_ + 1;
										break;
									}
									case '>':
									{
										gchar* _tmp166_;
										type = VALA_TOKEN_TYPE_OP_PTR;
										_tmp166_ = self->priv->current;
										self->priv->current = _tmp166_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '*':
						{
							gchar* _tmp167_;
							gboolean _tmp168_ = FALSE;
							gchar* _tmp169_;
							gchar* _tmp170_;
							type = VALA_TOKEN_TYPE_STAR;
							_tmp167_ = self->priv->current;
							self->priv->current = _tmp167_ + 1;
							_tmp169_ = self->priv->current;
							_tmp170_ = self->priv->end;
							if (_tmp169_ < _tmp170_) {
								gchar* _tmp171_;
								gchar _tmp172_;
								_tmp171_ = self->priv->current;
								_tmp172_ = _tmp171_[0];
								_tmp168_ = _tmp172_ == '=';
							} else {
								_tmp168_ = FALSE;
							}
							if (_tmp168_) {
								gchar* _tmp173_;
								type = VALA_TOKEN_TYPE_ASSIGN_MUL;
								_tmp173_ = self->priv->current;
								self->priv->current = _tmp173_ + 1;
							}
							break;
						}
						case '/':
						{
							ValaTokenType _tmp174_;
							_tmp174_ = self->priv->previous;
							switch (_tmp174_) {
								case VALA_TOKEN_TYPE_ASSIGN:
								case VALA_TOKEN_TYPE_COMMA:
								case VALA_TOKEN_TYPE_MINUS:
								case VALA_TOKEN_TYPE_OP_AND:
								case VALA_TOKEN_TYPE_OP_COALESCING:
								case VALA_TOKEN_TYPE_OP_EQ:
								case VALA_TOKEN_TYPE_OP_GE:
								case VALA_TOKEN_TYPE_OP_GT:
								case VALA_TOKEN_TYPE_OP_LE:
								case VALA_TOKEN_TYPE_OP_LT:
								case VALA_TOKEN_TYPE_OP_NE:
								case VALA_TOKEN_TYPE_OP_NEG:
								case VALA_TOKEN_TYPE_OP_OR:
								case VALA_TOKEN_TYPE_OPEN_BRACE:
								case VALA_TOKEN_TYPE_OPEN_PARENS:
								case VALA_TOKEN_TYPE_PLUS:
								case VALA_TOKEN_TYPE_RETURN:
								{
									ValaScannerState* _tmp175_;
									gint _tmp175__length1;
									gchar* _tmp176_;
									type = VALA_TOKEN_TYPE_OPEN_REGEX_LITERAL;
									_tmp175_ = self->priv->state_stack;
									_tmp175__length1 = self->priv->state_stack_length1;
									_vala_array_add21 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_REGEX_LITERAL);
									_tmp176_ = self->priv->current;
									self->priv->current = _tmp176_ + 1;
									break;
								}
								default:
								{
									gchar* _tmp177_;
									gboolean _tmp178_ = FALSE;
									gchar* _tmp179_;
									gchar* _tmp180_;
									type = VALA_TOKEN_TYPE_DIV;
									_tmp177_ = self->priv->current;
									self->priv->current = _tmp177_ + 1;
									_tmp179_ = self->priv->current;
									_tmp180_ = self->priv->end;
									if (_tmp179_ < _tmp180_) {
										gchar* _tmp181_;
										gchar _tmp182_;
										_tmp181_ = self->priv->current;
										_tmp182_ = _tmp181_[0];
										_tmp178_ = _tmp182_ == '=';
									} else {
										_tmp178_ = FALSE;
									}
									if (_tmp178_) {
										gchar* _tmp183_;
										type = VALA_TOKEN_TYPE_ASSIGN_DIV;
										_tmp183_ = self->priv->current;
										self->priv->current = _tmp183_ + 1;
									}
									break;
								}
							}
							break;
						}
						case '%':
						{
							gchar* _tmp184_;
							gboolean _tmp185_ = FALSE;
							gchar* _tmp186_;
							gchar* _tmp187_;
							type = VALA_TOKEN_TYPE_PERCENT;
							_tmp184_ = self->priv->current;
							self->priv->current = _tmp184_ + 1;
							_tmp186_ = self->priv->current;
							_tmp187_ = self->priv->end;
							if (_tmp186_ < _tmp187_) {
								gchar* _tmp188_;
								gchar _tmp189_;
								_tmp188_ = self->priv->current;
								_tmp189_ = _tmp188_[0];
								_tmp185_ = _tmp189_ == '=';
							} else {
								_tmp185_ = FALSE;
							}
							if (_tmp185_) {
								gchar* _tmp190_;
								type = VALA_TOKEN_TYPE_ASSIGN_PERCENT;
								_tmp190_ = self->priv->current;
								self->priv->current = _tmp190_ + 1;
							}
							break;
						}
						case '\'':
						case '"':
						{
							gchar* _tmp191_;
							gchar _tmp192_;
							gchar* _tmp241_;
							gchar* _tmp320_;
							gchar* _tmp321_;
							_tmp191_ = begin;
							_tmp192_ = _tmp191_[0];
							if (_tmp192_ == '\'') {
								type = VALA_TOKEN_TYPE_CHARACTER_LITERAL;
							} else {
								gboolean _tmp193_ = FALSE;
								gboolean _tmp194_ = FALSE;
								gchar* _tmp195_;
								gchar* _tmp196_;
								_tmp195_ = self->priv->current;
								_tmp196_ = self->priv->end;
								if (_tmp195_ < (_tmp196_ - 6)) {
									gchar* _tmp197_;
									gchar _tmp198_;
									_tmp197_ = begin;
									_tmp198_ = _tmp197_[1];
									_tmp194_ = _tmp198_ == '"';
								} else {
									_tmp194_ = FALSE;
								}
								if (_tmp194_) {
									gchar* _tmp199_;
									gchar _tmp200_;
									_tmp199_ = begin;
									_tmp200_ = _tmp199_[2];
									_tmp193_ = _tmp200_ == '"';
								} else {
									_tmp193_ = FALSE;
								}
								if (_tmp193_) {
									gchar* _tmp201_;
									gboolean _tmp229_ = FALSE;
									gboolean _tmp230_ = FALSE;
									gchar* _tmp231_;
									gchar _tmp232_;
									type = VALA_TOKEN_TYPE_VERBATIM_STRING_LITERAL;
									token_length_in_chars = 6;
									_tmp201_ = self->priv->current;
									self->priv->current = _tmp201_ + 3;
									while (TRUE) {
										gchar* _tmp202_;
										gchar* _tmp203_;
										gboolean _tmp204_ = FALSE;
										gboolean _tmp205_ = FALSE;
										gboolean _tmp206_ = FALSE;
										gchar* _tmp207_;
										gchar _tmp208_;
										_tmp202_ = self->priv->current;
										_tmp203_ = self->priv->end;
										if (!(_tmp202_ < (_tmp203_ - 4))) {
											break;
										}
										_tmp207_ = self->priv->current;
										_tmp208_ = _tmp207_[0];
										if (_tmp208_ == '"') {
											gchar* _tmp209_;
											gchar _tmp210_;
											_tmp209_ = self->priv->current;
											_tmp210_ = _tmp209_[1];
											_tmp206_ = _tmp210_ == '"';
										} else {
											_tmp206_ = FALSE;
										}
										if (_tmp206_) {
											gchar* _tmp211_;
											gchar _tmp212_;
											_tmp211_ = self->priv->current;
											_tmp212_ = _tmp211_[2];
											_tmp205_ = _tmp212_ == '"';
										} else {
											_tmp205_ = FALSE;
										}
										if (_tmp205_) {
											gchar* _tmp213_;
											gchar _tmp214_;
											_tmp213_ = self->priv->current;
											_tmp214_ = _tmp213_[3];
											_tmp204_ = _tmp214_ != '"';
										} else {
											_tmp204_ = FALSE;
										}
										if (_tmp204_) {
											break;
										} else {
											gchar* _tmp215_;
											gchar _tmp216_;
											_tmp215_ = self->priv->current;
											_tmp216_ = _tmp215_[0];
											if (_tmp216_ == '\n') {
												gchar* _tmp217_;
												gint _tmp218_;
												_tmp217_ = self->priv->current;
												self->priv->current = _tmp217_ + 1;
												_tmp218_ = self->priv->line;
												self->priv->line = _tmp218_ + 1;
												self->priv->column = 1;
												token_length_in_chars = 3;
											} else {
												gunichar u = 0U;
												gchar* _tmp219_;
												gchar* _tmp220_;
												gchar* _tmp221_;
												gunichar _tmp222_;
												_tmp219_ = self->priv->current;
												_tmp220_ = self->priv->end;
												_tmp221_ = self->priv->current;
												u = g_utf8_get_char_validated ((const gchar*) _tmp219_, (gssize) ((glong) (_tmp220_ - _tmp221_)));
												_tmp222_ = u;
												if (_tmp222_ != ((gunichar) -1)) {
													gchar* _tmp223_;
													gunichar _tmp224_;
													gint _tmp225_;
													_tmp223_ = self->priv->current;
													_tmp224_ = u;
													self->priv->current = _tmp223_ + g_unichar_to_utf8 (_tmp224_, NULL);
													_tmp225_ = token_length_in_chars;
													token_length_in_chars = _tmp225_ + 1;
												} else {
													gint _tmp226_;
													ValaSourceReference* _tmp227_;
													ValaSourceReference* _tmp228_;
													_tmp226_ = token_length_in_chars;
													_tmp227_ = vala_scanner_get_source_reference (self, _tmp226_, 0);
													_tmp228_ = _tmp227_;
													vala_report_error (_tmp228_, "invalid UTF-8 character");
													_vala_source_reference_unref0 (_tmp228_);
												}
											}
										}
									}
									_tmp231_ = self->priv->current;
									_tmp232_ = _tmp231_[0];
									if (_tmp232_ == '"') {
										gchar* _tmp233_;
										gchar _tmp234_;
										_tmp233_ = self->priv->current;
										_tmp234_ = _tmp233_[1];
										_tmp230_ = _tmp234_ == '"';
									} else {
										_tmp230_ = FALSE;
									}
									if (_tmp230_) {
										gchar* _tmp235_;
										gchar _tmp236_;
										_tmp235_ = self->priv->current;
										_tmp236_ = _tmp235_[2];
										_tmp229_ = _tmp236_ == '"';
									} else {
										_tmp229_ = FALSE;
									}
									if (_tmp229_) {
										gchar* _tmp237_;
										_tmp237_ = self->priv->current;
										self->priv->current = _tmp237_ + 3;
									} else {
										gint _tmp238_;
										ValaSourceReference* _tmp239_;
										ValaSourceReference* _tmp240_;
										_tmp238_ = token_length_in_chars;
										_tmp239_ = vala_scanner_get_source_reference (self, _tmp238_, 0);
										_tmp240_ = _tmp239_;
										vala_report_error (_tmp240_, "syntax error, expected \"\"\"");
										_vala_source_reference_unref0 (_tmp240_);
									}
									break;
								} else {
									type = VALA_TOKEN_TYPE_STRING_LITERAL;
								}
							}
							token_length_in_chars = 2;
							_tmp241_ = self->priv->current;
							self->priv->current = _tmp241_ + 1;
							while (TRUE) {
								gboolean _tmp242_ = FALSE;
								gchar* _tmp243_;
								gchar* _tmp244_;
								gchar* _tmp249_;
								gchar _tmp250_;
								gboolean _tmp309_ = FALSE;
								gboolean _tmp310_ = FALSE;
								gchar* _tmp311_;
								gchar* _tmp312_;
								_tmp243_ = self->priv->current;
								_tmp244_ = self->priv->end;
								if (_tmp243_ < _tmp244_) {
									gchar* _tmp245_;
									gchar _tmp246_;
									gchar* _tmp247_;
									gchar _tmp248_;
									_tmp245_ = self->priv->current;
									_tmp246_ = _tmp245_[0];
									_tmp247_ = begin;
									_tmp248_ = _tmp247_[0];
									_tmp242_ = _tmp246_ != _tmp248_;
								} else {
									_tmp242_ = FALSE;
								}
								if (!_tmp242_) {
									break;
								}
								_tmp249_ = self->priv->current;
								_tmp250_ = _tmp249_[0];
								if (_tmp250_ == '\\') {
									gchar* _tmp251_;
									gint _tmp252_;
									gchar* _tmp253_;
									gchar* _tmp254_;
									gchar* _tmp255_;
									gchar _tmp256_;
									_tmp251_ = self->priv->current;
									self->priv->current = _tmp251_ + 1;
									_tmp252_ = token_length_in_chars;
									token_length_in_chars = _tmp252_ + 1;
									_tmp253_ = self->priv->current;
									_tmp254_ = self->priv->end;
									if (_tmp253_ >= _tmp254_) {
										break;
									}
									_tmp255_ = self->priv->current;
									_tmp256_ = _tmp255_[0];
									switch (_tmp256_) {
										case '\'':
										case '"':
										case '\\':
										case '0':
										case 'b':
										case 'f':
										case 'n':
										case 'r':
										case 't':
										case 'v':
										case '$':
										{
											gchar* _tmp257_;
											gint _tmp258_;
											_tmp257_ = self->priv->current;
											self->priv->current = _tmp257_ + 1;
											_tmp258_ = token_length_in_chars;
											token_length_in_chars = _tmp258_ + 1;
											break;
										}
										case 'u':
										{
											gchar* _tmp259_;
											gint _tmp260_;
											gint digit_length = 0;
											gint _tmp272_;
											_tmp259_ = self->priv->current;
											self->priv->current = _tmp259_ + 1;
											_tmp260_ = token_length_in_chars;
											token_length_in_chars = _tmp260_ + 1;
											{
												gboolean _tmp261_ = FALSE;
												digit_length = 0;
												_tmp261_ = TRUE;
												while (TRUE) {
													gboolean _tmp263_ = FALSE;
													gboolean _tmp264_ = FALSE;
													gint _tmp265_;
													gchar* _tmp270_;
													gint _tmp271_;
													if (!_tmp261_) {
														gint _tmp262_;
														_tmp262_ = digit_length;
														digit_length = _tmp262_ + 1;
													}
													_tmp261_ = FALSE;
													_tmp265_ = digit_length;
													if (_tmp265_ < 4) {
														gchar* _tmp266_;
														gchar* _tmp267_;
														_tmp266_ = self->priv->current;
														_tmp267_ = self->priv->end;
														_tmp264_ = _tmp266_ < _tmp267_;
													} else {
														_tmp264_ = FALSE;
													}
													if (_tmp264_) {
														gchar* _tmp268_;
														gchar _tmp269_;
														_tmp268_ = self->priv->current;
														_tmp269_ = _tmp268_[0];
														_tmp263_ = g_ascii_isxdigit (_tmp269_);
													} else {
														_tmp263_ = FALSE;
													}
													if (!_tmp263_) {
														break;
													}
													_tmp270_ = self->priv->current;
													self->priv->current = _tmp270_ + 1;
													_tmp271_ = token_length_in_chars;
													token_length_in_chars = _tmp271_ + 1;
												}
											}
											_tmp272_ = digit_length;
											if (_tmp272_ != 4) {
												gint _tmp273_;
												ValaSourceReference* _tmp274_;
												ValaSourceReference* _tmp275_;
												_tmp273_ = token_length_in_chars;
												_tmp274_ = vala_scanner_get_source_reference (self, _tmp273_, 0);
												_tmp275_ = _tmp274_;
												vala_report_error (_tmp275_, "\\u requires four hex digits");
												_vala_source_reference_unref0 (_tmp275_);
											}
											break;
										}
										case 'x':
										{
											gchar* _tmp276_;
											gint _tmp277_;
											gint digit_length = 0;
											gint _tmp287_;
											_tmp276_ = self->priv->current;
											self->priv->current = _tmp276_ + 1;
											_tmp277_ = token_length_in_chars;
											token_length_in_chars = _tmp277_ + 1;
											{
												gboolean _tmp278_ = FALSE;
												digit_length = 0;
												_tmp278_ = TRUE;
												while (TRUE) {
													gboolean _tmp280_ = FALSE;
													gchar* _tmp281_;
													gchar* _tmp282_;
													gchar* _tmp285_;
													gint _tmp286_;
													if (!_tmp278_) {
														gint _tmp279_;
														_tmp279_ = digit_length;
														digit_length = _tmp279_ + 1;
													}
													_tmp278_ = FALSE;
													_tmp281_ = self->priv->current;
													_tmp282_ = self->priv->end;
													if (_tmp281_ < _tmp282_) {
														gchar* _tmp283_;
														gchar _tmp284_;
														_tmp283_ = self->priv->current;
														_tmp284_ = _tmp283_[0];
														_tmp280_ = g_ascii_isxdigit (_tmp284_);
													} else {
														_tmp280_ = FALSE;
													}
													if (!_tmp280_) {
														break;
													}
													_tmp285_ = self->priv->current;
													self->priv->current = _tmp285_ + 1;
													_tmp286_ = token_length_in_chars;
													token_length_in_chars = _tmp286_ + 1;
												}
											}
											_tmp287_ = digit_length;
											if (_tmp287_ < 1) {
												gint _tmp288_;
												ValaSourceReference* _tmp289_;
												ValaSourceReference* _tmp290_;
												_tmp288_ = token_length_in_chars;
												_tmp289_ = vala_scanner_get_source_reference (self, _tmp288_, 0);
												_tmp290_ = _tmp289_;
												vala_report_error (_tmp290_, "\\x requires at least one hex digit");
												_vala_source_reference_unref0 (_tmp290_);
											}
											break;
										}
										default:
										{
											gint _tmp291_;
											ValaSourceReference* _tmp292_;
											ValaSourceReference* _tmp293_;
											_tmp291_ = token_length_in_chars;
											_tmp292_ = vala_scanner_get_source_reference (self, _tmp291_, 0);
											_tmp293_ = _tmp292_;
											vala_report_error (_tmp293_, "invalid escape sequence");
											_vala_source_reference_unref0 (_tmp293_);
											break;
										}
									}
								} else {
									gchar* _tmp294_;
									gchar _tmp295_;
									_tmp294_ = self->priv->current;
									_tmp295_ = _tmp294_[0];
									if (_tmp295_ == '\n') {
										gchar* _tmp296_;
										gint _tmp297_;
										_tmp296_ = self->priv->current;
										self->priv->current = _tmp296_ + 1;
										_tmp297_ = self->priv->line;
										self->priv->line = _tmp297_ + 1;
										self->priv->column = 1;
										token_length_in_chars = 1;
									} else {
										gunichar u = 0U;
										gchar* _tmp298_;
										gchar* _tmp299_;
										gchar* _tmp300_;
										gunichar _tmp301_;
										_tmp298_ = self->priv->current;
										_tmp299_ = self->priv->end;
										_tmp300_ = self->priv->current;
										u = g_utf8_get_char_validated ((const gchar*) _tmp298_, (gssize) ((glong) (_tmp299_ - _tmp300_)));
										_tmp301_ = u;
										if (_tmp301_ != ((gunichar) -1)) {
											gchar* _tmp302_;
											gunichar _tmp303_;
											gint _tmp304_;
											_tmp302_ = self->priv->current;
											_tmp303_ = u;
											self->priv->current = _tmp302_ + g_unichar_to_utf8 (_tmp303_, NULL);
											_tmp304_ = token_length_in_chars;
											token_length_in_chars = _tmp304_ + 1;
										} else {
											gchar* _tmp305_;
											gint _tmp306_;
											ValaSourceReference* _tmp307_;
											ValaSourceReference* _tmp308_;
											_tmp305_ = self->priv->current;
											self->priv->current = _tmp305_ + 1;
											_tmp306_ = token_length_in_chars;
											_tmp307_ = vala_scanner_get_source_reference (self, _tmp306_, 0);
											_tmp308_ = _tmp307_;
											vala_report_error (_tmp308_, "invalid UTF-8 character");
											_vala_source_reference_unref0 (_tmp308_);
										}
									}
								}
								_tmp311_ = self->priv->current;
								_tmp312_ = self->priv->end;
								if (_tmp311_ < _tmp312_) {
									gchar* _tmp313_;
									gchar _tmp314_;
									_tmp313_ = begin;
									_tmp314_ = _tmp313_[0];
									_tmp310_ = _tmp314_ == '\'';
								} else {
									_tmp310_ = FALSE;
								}
								if (_tmp310_) {
									gchar* _tmp315_;
									gchar _tmp316_;
									_tmp315_ = self->priv->current;
									_tmp316_ = _tmp315_[0];
									_tmp309_ = _tmp316_ != '\'';
								} else {
									_tmp309_ = FALSE;
								}
								if (_tmp309_) {
									gint _tmp317_;
									ValaSourceReference* _tmp318_;
									ValaSourceReference* _tmp319_;
									_tmp317_ = token_length_in_chars;
									_tmp318_ = vala_scanner_get_source_reference (self, _tmp317_, 0);
									_tmp319_ = _tmp318_;
									vala_report_error (_tmp319_, "invalid character literal");
									_vala_source_reference_unref0 (_tmp319_);
								}
							}
							_tmp320_ = self->priv->current;
							_tmp321_ = self->priv->end;
							if (_tmp320_ < _tmp321_) {
								gchar* _tmp322_;
								_tmp322_ = self->priv->current;
								self->priv->current = _tmp322_ + 1;
							} else {
								gint _tmp323_;
								ValaSourceReference* _tmp324_;
								ValaSourceReference* _tmp325_;
								gchar* _tmp326_;
								gchar _tmp327_;
								gchar* _tmp328_;
								gchar* _tmp329_;
								_tmp323_ = token_length_in_chars;
								_tmp324_ = vala_scanner_get_source_reference (self, _tmp323_, 0);
								_tmp325_ = _tmp324_;
								_tmp326_ = begin;
								_tmp327_ = _tmp326_[0];
								_tmp328_ = g_strdup_printf ("syntax error, expected %c", (gint) _tmp327_);
								_tmp329_ = _tmp328_;
								vala_report_error (_tmp325_, _tmp329_);
								_g_free0 (_tmp329_);
								_vala_source_reference_unref0 (_tmp325_);
							}
							break;
						}
						default:
						{
							gunichar u = 0U;
							gchar* _tmp330_;
							gchar* _tmp331_;
							gchar* _tmp332_;
							gunichar _tmp333_;
							gint _tmp341_;
							ValaSourceLocation _tmp342_ = {0};
							ValaSourceLocation _tmp343_ = {0};
							ValaTokenType _tmp344_;
							_tmp330_ = self->priv->current;
							_tmp331_ = self->priv->end;
							_tmp332_ = self->priv->current;
							u = g_utf8_get_char_validated ((const gchar*) _tmp330_, (gssize) ((glong) (_tmp331_ - _tmp332_)));
							_tmp333_ = u;
							if (_tmp333_ != ((gunichar) -1)) {
								gchar* _tmp334_;
								gunichar _tmp335_;
								ValaSourceReference* _tmp336_;
								ValaSourceReference* _tmp337_;
								_tmp334_ = self->priv->current;
								_tmp335_ = u;
								self->priv->current = _tmp334_ + g_unichar_to_utf8 (_tmp335_, NULL);
								_tmp336_ = vala_scanner_get_source_reference (self, 0, 0);
								_tmp337_ = _tmp336_;
								vala_report_error (_tmp337_, "syntax error, unexpected character");
								_vala_source_reference_unref0 (_tmp337_);
							} else {
								gchar* _tmp338_;
								ValaSourceReference* _tmp339_;
								ValaSourceReference* _tmp340_;
								_tmp338_ = self->priv->current;
								self->priv->current = _tmp338_ + 1;
								_tmp339_ = vala_scanner_get_source_reference (self, 0, 0);
								_tmp340_ = _tmp339_;
								vala_report_error (_tmp340_, "invalid UTF-8 character");
								_vala_source_reference_unref0 (_tmp340_);
							}
							_tmp341_ = self->priv->column;
							self->priv->column = _tmp341_ + 1;
							_tmp344_ = vala_scanner_read_token (self, &_tmp342_, &_tmp343_);
							_vala_token_begin = _tmp342_;
							_vala_token_end = _tmp343_;
							result = _tmp344_;
							if (token_begin) {
								*token_begin = _vala_token_begin;
							}
							if (token_end) {
								*token_end = _vala_token_end;
							}
							return result;
						}
					}
				}
			}
		}
	}
	_tmp345_ = token_length_in_chars;
	if (_tmp345_ < 0) {
		gint _tmp346_;
		gchar* _tmp347_;
		gchar* _tmp348_;
		_tmp346_ = self->priv->column;
		_tmp347_ = self->priv->current;
		_tmp348_ = begin;
		self->priv->column = _tmp346_ + ((gint) (_tmp347_ - _tmp348_));
	} else {
		gint _tmp349_;
		gint _tmp350_;
		_tmp349_ = self->priv->column;
		_tmp350_ = token_length_in_chars;
		self->priv->column = _tmp349_ + _tmp350_;
	}
	_tmp351_ = self->priv->current;
	_tmp352_ = self->priv->line;
	_tmp353_ = self->priv->column;
	vala_source_location_init (&_vala_token_end, _tmp351_, _tmp352_, _tmp353_ - 1);
	_tmp354_ = type;
	self->priv->previous = _tmp354_;
	result = type;
	if (token_begin) {
		*token_begin = _vala_token_begin;
	}
	if (token_end) {
		*token_end = _vala_token_end;
	}
	return result;
}


static gboolean
vala_scanner_matches (gchar* begin, 
                      const gchar* keyword)
{
	gboolean result = FALSE;
	gchar* keyword_array = NULL;
	glong len = 0L;
	gint _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (keyword != NULL, FALSE);
	keyword_array = (gchar*) keyword;
	_tmp0_ = strlen (keyword);
	_tmp1_ = _tmp0_;
	len = (glong) _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint _tmp4_;
				glong _tmp5_;
				gint _tmp6_;
				gchar _tmp7_;
				gchar* _tmp8_;
				gint _tmp9_;
				gchar _tmp10_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = len;
				if (!(((glong) _tmp4_) < _tmp5_)) {
					break;
				}
				_tmp6_ = i;
				_tmp7_ = begin[_tmp6_];
				_tmp8_ = keyword_array;
				_tmp9_ = i;
				_tmp10_ = _tmp8_[_tmp9_];
				if (_tmp7_ != _tmp10_) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static gboolean
vala_scanner_pp_whitespace (ValaScanner* self)
{
	gboolean result = FALSE;
	gboolean found = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp8_;
		gint _tmp9_;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->end;
		if (_tmp2_ < _tmp3_) {
			gchar* _tmp4_;
			gchar _tmp5_;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_[0];
			_tmp1_ = g_ascii_isspace (_tmp5_);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[0];
			_tmp0_ = _tmp7_ != '\n';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		found = TRUE;
		_tmp8_ = self->priv->current;
		self->priv->current = _tmp8_ + 1;
		_tmp9_ = self->priv->column;
		self->priv->column = _tmp9_ + 1;
	}
	result = found;
	return result;
}


static void
vala_scanner_pp_space (ValaScanner* self)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (vala_scanner_pp_whitespace (self)) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = vala_scanner_comment (self, FALSE);
		}
		if (!_tmp0_) {
			break;
		}
	}
}


static void
vala_scanner_pp_directive (ValaScanner* self)
{
	gchar* _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_;
	gchar* begin = NULL;
	gchar* _tmp17_;
	gint len = 0;
	gboolean _tmp26_ = FALSE;
	gint _tmp27_;
	gboolean _tmp42_ = FALSE;
	ValaScannerConditional* _tmp43_;
	gint _tmp43__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current;
	self->priv->current = _tmp0_ + 1;
	_tmp1_ = self->priv->column;
	self->priv->column = _tmp1_ + 1;
	_tmp5_ = self->priv->line;
	if (_tmp5_ == 1) {
		gint _tmp6_;
		_tmp6_ = self->priv->column;
		_tmp4_ = _tmp6_ == 2;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = self->priv->current;
		_tmp8_ = self->priv->end;
		_tmp3_ = _tmp7_ < _tmp8_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gchar* _tmp9_;
		gchar _tmp10_;
		_tmp9_ = self->priv->current;
		_tmp10_ = _tmp9_[0];
		_tmp2_ = _tmp10_ == '!';
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		while (TRUE) {
			gboolean _tmp11_ = FALSE;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp16_;
			_tmp12_ = self->priv->current;
			_tmp13_ = self->priv->end;
			if (_tmp12_ < _tmp13_) {
				gchar* _tmp14_;
				gchar _tmp15_;
				_tmp14_ = self->priv->current;
				_tmp15_ = _tmp14_[0];
				_tmp11_ = _tmp15_ != '\n';
			} else {
				_tmp11_ = FALSE;
			}
			if (!_tmp11_) {
				break;
			}
			_tmp16_ = self->priv->current;
			self->priv->current = _tmp16_ + 1;
		}
		return;
	}
	vala_scanner_pp_space (self);
	_tmp17_ = self->priv->current;
	begin = _tmp17_;
	len = 0;
	while (TRUE) {
		gboolean _tmp18_ = FALSE;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		_tmp19_ = self->priv->current;
		_tmp20_ = self->priv->end;
		if (_tmp19_ < _tmp20_) {
			gchar* _tmp21_;
			gchar _tmp22_;
			_tmp21_ = self->priv->current;
			_tmp22_ = _tmp21_[0];
			_tmp18_ = g_ascii_isalnum (_tmp22_);
		} else {
			_tmp18_ = FALSE;
		}
		if (!_tmp18_) {
			break;
		}
		_tmp23_ = self->priv->current;
		self->priv->current = _tmp23_ + 1;
		_tmp24_ = self->priv->column;
		self->priv->column = _tmp24_ + 1;
		_tmp25_ = len;
		len = _tmp25_ + 1;
	}
	_tmp27_ = len;
	if (_tmp27_ == 2) {
		gchar* _tmp28_;
		_tmp28_ = begin;
		_tmp26_ = vala_scanner_matches (_tmp28_, "if");
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		vala_scanner_parse_pp_if (self);
	} else {
		gboolean _tmp29_ = FALSE;
		gint _tmp30_;
		_tmp30_ = len;
		if (_tmp30_ == 4) {
			gchar* _tmp31_;
			_tmp31_ = begin;
			_tmp29_ = vala_scanner_matches (_tmp31_, "elif");
		} else {
			_tmp29_ = FALSE;
		}
		if (_tmp29_) {
			vala_scanner_parse_pp_elif (self);
		} else {
			gboolean _tmp32_ = FALSE;
			gint _tmp33_;
			_tmp33_ = len;
			if (_tmp33_ == 4) {
				gchar* _tmp34_;
				_tmp34_ = begin;
				_tmp32_ = vala_scanner_matches (_tmp34_, "else");
			} else {
				_tmp32_ = FALSE;
			}
			if (_tmp32_) {
				vala_scanner_parse_pp_else (self);
			} else {
				gboolean _tmp35_ = FALSE;
				gint _tmp36_;
				_tmp36_ = len;
				if (_tmp36_ == 5) {
					gchar* _tmp37_;
					_tmp37_ = begin;
					_tmp35_ = vala_scanner_matches (_tmp37_, "endif");
				} else {
					_tmp35_ = FALSE;
				}
				if (_tmp35_) {
					vala_scanner_parse_pp_endif (self);
				} else {
					gint _tmp38_;
					gint _tmp39_;
					ValaSourceReference* _tmp40_;
					ValaSourceReference* _tmp41_;
					_tmp38_ = len;
					_tmp39_ = len;
					_tmp40_ = vala_scanner_get_source_reference (self, -_tmp38_, _tmp39_);
					_tmp41_ = _tmp40_;
					vala_report_error (_tmp41_, "syntax error, invalid preprocessing directive");
					_vala_source_reference_unref0 (_tmp41_);
				}
			}
		}
	}
	_tmp43_ = self->priv->conditional_stack;
	_tmp43__length1 = self->priv->conditional_stack_length1;
	if (_tmp43__length1 > 0) {
		ValaScannerConditional* _tmp44_;
		gint _tmp44__length1;
		ValaScannerConditional* _tmp45_;
		gint _tmp45__length1;
		ValaScannerConditional _tmp46_;
		gboolean _tmp47_;
		_tmp44_ = self->priv->conditional_stack;
		_tmp44__length1 = self->priv->conditional_stack_length1;
		_tmp45_ = self->priv->conditional_stack;
		_tmp45__length1 = self->priv->conditional_stack_length1;
		_tmp46_ = _tmp44_[_tmp45__length1 - 1];
		_tmp47_ = _tmp46_.skip_section;
		_tmp42_ = _tmp47_;
	} else {
		_tmp42_ = FALSE;
	}
	if (_tmp42_) {
		gboolean bol = FALSE;
		bol = FALSE;
		while (TRUE) {
			gchar* _tmp48_;
			gchar* _tmp49_;
			gboolean _tmp50_ = FALSE;
			gboolean _tmp51_;
			gchar* _tmp56_;
			gchar _tmp57_;
			gchar* _tmp61_;
			gint _tmp62_;
			_tmp48_ = self->priv->current;
			_tmp49_ = self->priv->end;
			if (!(_tmp48_ < _tmp49_)) {
				break;
			}
			_tmp51_ = bol;
			if (_tmp51_) {
				gchar* _tmp52_;
				gchar _tmp53_;
				_tmp52_ = self->priv->current;
				_tmp53_ = _tmp52_[0];
				_tmp50_ = _tmp53_ == '#';
			} else {
				_tmp50_ = FALSE;
			}
			if (_tmp50_) {
				gchar* _tmp54_;
				gint _tmp55_;
				_tmp54_ = self->priv->current;
				_tmp55_ = self->priv->column;
				self->priv->current = _tmp54_ - (_tmp55_ - 1);
				self->priv->column = 1;
				return;
			}
			_tmp56_ = self->priv->current;
			_tmp57_ = _tmp56_[0];
			if (_tmp57_ == '\n') {
				gint _tmp58_;
				_tmp58_ = self->priv->line;
				self->priv->line = _tmp58_ + 1;
				self->priv->column = 0;
				bol = TRUE;
			} else {
				gchar* _tmp59_;
				gchar _tmp60_;
				_tmp59_ = self->priv->current;
				_tmp60_ = _tmp59_[0];
				if (!g_ascii_isspace (_tmp60_)) {
					bol = FALSE;
				}
			}
			_tmp61_ = self->priv->current;
			self->priv->current = _tmp61_ + 1;
			_tmp62_ = self->priv->column;
			self->priv->column = _tmp62_ + 1;
		}
	}
}


static void
vala_scanner_pp_eol (ValaScanner* self)
{
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	vala_scanner_pp_space (self);
	_tmp1_ = self->priv->current;
	_tmp2_ = self->priv->end;
	if (_tmp1_ >= _tmp2_) {
		_tmp0_ = TRUE;
	} else {
		gchar* _tmp3_;
		gchar _tmp4_;
		_tmp3_ = self->priv->current;
		_tmp4_ = _tmp3_[0];
		_tmp0_ = _tmp4_ != '\n';
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp5_;
		ValaSourceReference* _tmp6_;
		_tmp5_ = vala_scanner_get_source_reference (self, 0, 0);
		_tmp6_ = _tmp5_;
		vala_report_error (_tmp6_, "syntax error, expected newline");
		_vala_source_reference_unref0 (_tmp6_);
	}
}


static void
_vala_array_add22 (ValaScannerConditional* * array, 
                   int* length, 
                   int* size, 
                   const ValaScannerConditional* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerConditional, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void
vala_scanner_parse_pp_if (ValaScanner* self)
{
	gboolean condition = FALSE;
	ValaScannerConditional* _tmp0_;
	gint _tmp0__length1;
	ValaScannerConditional _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	vala_scanner_pp_space (self);
	condition = vala_scanner_parse_pp_expression (self);
	vala_scanner_pp_eol (self);
	_tmp0_ = self->priv->conditional_stack;
	_tmp0__length1 = self->priv->conditional_stack_length1;
	memset (&_tmp1_, 0, sizeof (ValaScannerConditional));
	_vala_array_add22 (&self->priv->conditional_stack, &self->priv->conditional_stack_length1, &self->priv->_conditional_stack_size_, &_tmp1_);
	_tmp3_ = condition;
	if (_tmp3_) {
		gboolean _tmp4_ = FALSE;
		ValaScannerConditional* _tmp5_;
		gint _tmp5__length1;
		_tmp5_ = self->priv->conditional_stack;
		_tmp5__length1 = self->priv->conditional_stack_length1;
		if (_tmp5__length1 == 1) {
			_tmp4_ = TRUE;
		} else {
			ValaScannerConditional* _tmp6_;
			gint _tmp6__length1;
			ValaScannerConditional* _tmp7_;
			gint _tmp7__length1;
			ValaScannerConditional _tmp8_;
			gboolean _tmp9_;
			_tmp6_ = self->priv->conditional_stack;
			_tmp6__length1 = self->priv->conditional_stack_length1;
			_tmp7_ = self->priv->conditional_stack;
			_tmp7__length1 = self->priv->conditional_stack_length1;
			_tmp8_ = _tmp6_[_tmp7__length1 - 2];
			_tmp9_ = _tmp8_.skip_section;
			_tmp4_ = !_tmp9_;
		}
		_tmp2_ = _tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaScannerConditional* _tmp10_;
		gint _tmp10__length1;
		ValaScannerConditional* _tmp11_;
		gint _tmp11__length1;
		_tmp10_ = self->priv->conditional_stack;
		_tmp10__length1 = self->priv->conditional_stack_length1;
		_tmp11_ = self->priv->conditional_stack;
		_tmp11__length1 = self->priv->conditional_stack_length1;
		_tmp10_[_tmp11__length1 - 1].matched = TRUE;
	} else {
		ValaScannerConditional* _tmp12_;
		gint _tmp12__length1;
		ValaScannerConditional* _tmp13_;
		gint _tmp13__length1;
		_tmp12_ = self->priv->conditional_stack;
		_tmp12__length1 = self->priv->conditional_stack_length1;
		_tmp13_ = self->priv->conditional_stack;
		_tmp13__length1 = self->priv->conditional_stack_length1;
		_tmp12_[_tmp13__length1 - 1].skip_section = TRUE;
	}
}


static void
vala_scanner_parse_pp_elif (ValaScanner* self)
{
	gboolean condition = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaScannerConditional* _tmp1_;
	gint _tmp1__length1;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_;
	g_return_if_fail (self != NULL);
	vala_scanner_pp_space (self);
	condition = vala_scanner_parse_pp_expression (self);
	vala_scanner_pp_eol (self);
	_tmp1_ = self->priv->conditional_stack;
	_tmp1__length1 = self->priv->conditional_stack_length1;
	if (_tmp1__length1 == 0) {
		_tmp0_ = TRUE;
	} else {
		ValaScannerConditional* _tmp2_;
		gint _tmp2__length1;
		ValaScannerConditional* _tmp3_;
		gint _tmp3__length1;
		ValaScannerConditional _tmp4_;
		gboolean _tmp5_;
		_tmp2_ = self->priv->conditional_stack;
		_tmp2__length1 = self->priv->conditional_stack_length1;
		_tmp3_ = self->priv->conditional_stack;
		_tmp3__length1 = self->priv->conditional_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp5_ = _tmp4_.else_found;
		_tmp0_ = _tmp5_;
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		_tmp6_ = vala_scanner_get_source_reference (self, 0, 0);
		_tmp7_ = _tmp6_;
		vala_report_error (_tmp7_, "syntax error, unexpected #elif");
		_vala_source_reference_unref0 (_tmp7_);
		return;
	}
	_tmp10_ = condition;
	if (_tmp10_) {
		ValaScannerConditional* _tmp11_;
		gint _tmp11__length1;
		ValaScannerConditional* _tmp12_;
		gint _tmp12__length1;
		ValaScannerConditional _tmp13_;
		gboolean _tmp14_;
		_tmp11_ = self->priv->conditional_stack;
		_tmp11__length1 = self->priv->conditional_stack_length1;
		_tmp12_ = self->priv->conditional_stack;
		_tmp12__length1 = self->priv->conditional_stack_length1;
		_tmp13_ = _tmp11_[_tmp12__length1 - 1];
		_tmp14_ = _tmp13_.matched;
		_tmp9_ = !_tmp14_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gboolean _tmp15_ = FALSE;
		ValaScannerConditional* _tmp16_;
		gint _tmp16__length1;
		_tmp16_ = self->priv->conditional_stack;
		_tmp16__length1 = self->priv->conditional_stack_length1;
		if (_tmp16__length1 == 1) {
			_tmp15_ = TRUE;
		} else {
			ValaScannerConditional* _tmp17_;
			gint _tmp17__length1;
			ValaScannerConditional* _tmp18_;
			gint _tmp18__length1;
			ValaScannerConditional _tmp19_;
			gboolean _tmp20_;
			_tmp17_ = self->priv->conditional_stack;
			_tmp17__length1 = self->priv->conditional_stack_length1;
			_tmp18_ = self->priv->conditional_stack;
			_tmp18__length1 = self->priv->conditional_stack_length1;
			_tmp19_ = _tmp17_[_tmp18__length1 - 2];
			_tmp20_ = _tmp19_.skip_section;
			_tmp15_ = !_tmp20_;
		}
		_tmp8_ = _tmp15_;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		ValaScannerConditional* _tmp21_;
		gint _tmp21__length1;
		ValaScannerConditional* _tmp22_;
		gint _tmp22__length1;
		ValaScannerConditional* _tmp23_;
		gint _tmp23__length1;
		ValaScannerConditional* _tmp24_;
		gint _tmp24__length1;
		_tmp21_ = self->priv->conditional_stack;
		_tmp21__length1 = self->priv->conditional_stack_length1;
		_tmp22_ = self->priv->conditional_stack;
		_tmp22__length1 = self->priv->conditional_stack_length1;
		_tmp21_[_tmp22__length1 - 1].matched = TRUE;
		_tmp23_ = self->priv->conditional_stack;
		_tmp23__length1 = self->priv->conditional_stack_length1;
		_tmp24_ = self->priv->conditional_stack;
		_tmp24__length1 = self->priv->conditional_stack_length1;
		_tmp23_[_tmp24__length1 - 1].skip_section = FALSE;
	} else {
		ValaScannerConditional* _tmp25_;
		gint _tmp25__length1;
		ValaScannerConditional* _tmp26_;
		gint _tmp26__length1;
		_tmp25_ = self->priv->conditional_stack;
		_tmp25__length1 = self->priv->conditional_stack_length1;
		_tmp26_ = self->priv->conditional_stack;
		_tmp26__length1 = self->priv->conditional_stack_length1;
		_tmp25_[_tmp26__length1 - 1].skip_section = TRUE;
	}
}


static void
vala_scanner_parse_pp_else (ValaScanner* self)
{
	gboolean _tmp0_ = FALSE;
	ValaScannerConditional* _tmp1_;
	gint _tmp1__length1;
	gboolean _tmp8_ = FALSE;
	ValaScannerConditional* _tmp9_;
	gint _tmp9__length1;
	ValaScannerConditional* _tmp10_;
	gint _tmp10__length1;
	ValaScannerConditional _tmp11_;
	gboolean _tmp12_;
	g_return_if_fail (self != NULL);
	vala_scanner_pp_eol (self);
	_tmp1_ = self->priv->conditional_stack;
	_tmp1__length1 = self->priv->conditional_stack_length1;
	if (_tmp1__length1 == 0) {
		_tmp0_ = TRUE;
	} else {
		ValaScannerConditional* _tmp2_;
		gint _tmp2__length1;
		ValaScannerConditional* _tmp3_;
		gint _tmp3__length1;
		ValaScannerConditional _tmp4_;
		gboolean _tmp5_;
		_tmp2_ = self->priv->conditional_stack;
		_tmp2__length1 = self->priv->conditional_stack_length1;
		_tmp3_ = self->priv->conditional_stack;
		_tmp3__length1 = self->priv->conditional_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp5_ = _tmp4_.else_found;
		_tmp0_ = _tmp5_;
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		_tmp6_ = vala_scanner_get_source_reference (self, 0, 0);
		_tmp7_ = _tmp6_;
		vala_report_error (_tmp7_, "syntax error, unexpected #else");
		_vala_source_reference_unref0 (_tmp7_);
		return;
	}
	_tmp9_ = self->priv->conditional_stack;
	_tmp9__length1 = self->priv->conditional_stack_length1;
	_tmp10_ = self->priv->conditional_stack;
	_tmp10__length1 = self->priv->conditional_stack_length1;
	_tmp11_ = _tmp9_[_tmp10__length1 - 1];
	_tmp12_ = _tmp11_.matched;
	if (!_tmp12_) {
		gboolean _tmp13_ = FALSE;
		ValaScannerConditional* _tmp14_;
		gint _tmp14__length1;
		_tmp14_ = self->priv->conditional_stack;
		_tmp14__length1 = self->priv->conditional_stack_length1;
		if (_tmp14__length1 == 1) {
			_tmp13_ = TRUE;
		} else {
			ValaScannerConditional* _tmp15_;
			gint _tmp15__length1;
			ValaScannerConditional* _tmp16_;
			gint _tmp16__length1;
			ValaScannerConditional _tmp17_;
			gboolean _tmp18_;
			_tmp15_ = self->priv->conditional_stack;
			_tmp15__length1 = self->priv->conditional_stack_length1;
			_tmp16_ = self->priv->conditional_stack;
			_tmp16__length1 = self->priv->conditional_stack_length1;
			_tmp17_ = _tmp15_[_tmp16__length1 - 2];
			_tmp18_ = _tmp17_.skip_section;
			_tmp13_ = !_tmp18_;
		}
		_tmp8_ = _tmp13_;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		ValaScannerConditional* _tmp19_;
		gint _tmp19__length1;
		ValaScannerConditional* _tmp20_;
		gint _tmp20__length1;
		ValaScannerConditional* _tmp21_;
		gint _tmp21__length1;
		ValaScannerConditional* _tmp22_;
		gint _tmp22__length1;
		_tmp19_ = self->priv->conditional_stack;
		_tmp19__length1 = self->priv->conditional_stack_length1;
		_tmp20_ = self->priv->conditional_stack;
		_tmp20__length1 = self->priv->conditional_stack_length1;
		_tmp19_[_tmp20__length1 - 1].matched = TRUE;
		_tmp21_ = self->priv->conditional_stack;
		_tmp21__length1 = self->priv->conditional_stack_length1;
		_tmp22_ = self->priv->conditional_stack;
		_tmp22__length1 = self->priv->conditional_stack_length1;
		_tmp21_[_tmp22__length1 - 1].skip_section = FALSE;
	} else {
		ValaScannerConditional* _tmp23_;
		gint _tmp23__length1;
		ValaScannerConditional* _tmp24_;
		gint _tmp24__length1;
		_tmp23_ = self->priv->conditional_stack;
		_tmp23__length1 = self->priv->conditional_stack_length1;
		_tmp24_ = self->priv->conditional_stack;
		_tmp24__length1 = self->priv->conditional_stack_length1;
		_tmp23_[_tmp24__length1 - 1].skip_section = TRUE;
	}
}


static void
vala_scanner_parse_pp_endif (ValaScanner* self)
{
	ValaScannerConditional* _tmp0_;
	gint _tmp0__length1;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	vala_scanner_pp_eol (self);
	_tmp0_ = self->priv->conditional_stack;
	_tmp0__length1 = self->priv->conditional_stack_length1;
	if (_tmp0__length1 == 0) {
		ValaSourceReference* _tmp1_;
		ValaSourceReference* _tmp2_;
		_tmp1_ = vala_scanner_get_source_reference (self, 0, 0);
		_tmp2_ = _tmp1_;
		vala_report_error (_tmp2_, "syntax error, unexpected #endif");
		_vala_source_reference_unref0 (_tmp2_);
		return;
	}
	_tmp3_ = self->priv->conditional_stack_length1;
	self->priv->conditional_stack_length1 = _tmp3_ - 1;
}


static glong
string_strnlen (gchar* str, 
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self, 
                  glong offset, 
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static gboolean
vala_scanner_parse_pp_symbol (ValaScanner* self)
{
	gboolean result = FALSE;
	gint len = 0;
	gint _tmp8_;
	gchar* identifier = NULL;
	gchar* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gchar* _tmp14_;
	gboolean defined = FALSE;
	const gchar* _tmp15_;
	g_return_val_if_fail (self != NULL, FALSE);
	len = 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp1_ = self->priv->current;
		_tmp2_ = self->priv->end;
		if (_tmp1_ < _tmp2_) {
			gchar* _tmp3_;
			gchar _tmp4_;
			_tmp3_ = self->priv->current;
			_tmp4_ = _tmp3_[0];
			_tmp0_ = vala_scanner_is_ident_char (self, _tmp4_);
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp5_ = self->priv->current;
		self->priv->current = _tmp5_ + 1;
		_tmp6_ = self->priv->column;
		self->priv->column = _tmp6_ + 1;
		_tmp7_ = len;
		len = _tmp7_ + 1;
	}
	_tmp8_ = len;
	if (_tmp8_ == 0) {
		ValaSourceReference* _tmp9_;
		ValaSourceReference* _tmp10_;
		_tmp9_ = vala_scanner_get_source_reference (self, 0, 0);
		_tmp10_ = _tmp9_;
		vala_report_error (_tmp10_, "syntax error, expected identifier");
		_vala_source_reference_unref0 (_tmp10_);
		result = FALSE;
		return result;
	}
	_tmp11_ = self->priv->current;
	_tmp12_ = len;
	_tmp13_ = len;
	_tmp14_ = string_substring ((const gchar*) (_tmp11_ - _tmp12_), (glong) 0, (glong) _tmp13_);
	identifier = _tmp14_;
	_tmp15_ = identifier;
	if (g_strcmp0 (_tmp15_, "true") == 0) {
		defined = TRUE;
	} else {
		const gchar* _tmp16_;
		_tmp16_ = identifier;
		if (g_strcmp0 (_tmp16_, "false") == 0) {
			defined = FALSE;
		} else {
			ValaSourceFile* _tmp17_;
			ValaCodeContext* _tmp18_;
			ValaCodeContext* _tmp19_;
			const gchar* _tmp20_;
			_tmp17_ = self->priv->_source_file;
			_tmp18_ = vala_source_file_get_context (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = identifier;
			defined = vala_code_context_is_defined (_tmp19_, _tmp20_);
		}
	}
	result = defined;
	_g_free0 (identifier);
	return result;
}


static gboolean
vala_scanner_parse_pp_primary_expression (ValaScanner* self)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->current;
	_tmp1_ = self->priv->end;
	if (_tmp0_ >= _tmp1_) {
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		_tmp2_ = vala_scanner_get_source_reference (self, 0, 0);
		_tmp3_ = _tmp2_;
		vala_report_error (_tmp3_, "syntax error, expected identifier");
		_vala_source_reference_unref0 (_tmp3_);
	} else {
		gchar* _tmp4_;
		gchar _tmp5_;
		_tmp4_ = self->priv->current;
		_tmp5_ = _tmp4_[0];
		if (vala_scanner_is_ident_char (self, _tmp5_)) {
			result = vala_scanner_parse_pp_symbol (self);
			return result;
		} else {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[0];
			if (_tmp7_ == '(') {
				gchar* _tmp8_;
				gint _tmp9_;
				gboolean _result_ = FALSE;
				gboolean _tmp10_ = FALSE;
				gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp8_ = self->priv->current;
				self->priv->current = _tmp8_ + 1;
				_tmp9_ = self->priv->column;
				self->priv->column = _tmp9_ + 1;
				vala_scanner_pp_space (self);
				_result_ = vala_scanner_parse_pp_expression (self);
				vala_scanner_pp_space (self);
				_tmp11_ = self->priv->current;
				_tmp12_ = self->priv->end;
				if (_tmp11_ < _tmp12_) {
					gchar* _tmp13_;
					gchar _tmp14_;
					_tmp13_ = self->priv->current;
					_tmp14_ = _tmp13_[0];
					_tmp10_ = _tmp14_ == ')';
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					gchar* _tmp15_;
					gint _tmp16_;
					_tmp15_ = self->priv->current;
					self->priv->current = _tmp15_ + 1;
					_tmp16_ = self->priv->column;
					self->priv->column = _tmp16_ + 1;
				} else {
					ValaSourceReference* _tmp17_;
					ValaSourceReference* _tmp18_;
					_tmp17_ = vala_scanner_get_source_reference (self, 0, 0);
					_tmp18_ = _tmp17_;
					vala_report_error (_tmp18_, "syntax error, expected `)'");
					_vala_source_reference_unref0 (_tmp18_);
				}
				result = _result_;
				return result;
			} else {
				ValaSourceReference* _tmp19_;
				ValaSourceReference* _tmp20_;
				_tmp19_ = vala_scanner_get_source_reference (self, 0, 0);
				_tmp20_ = _tmp19_;
				vala_report_error (_tmp20_, "syntax error, expected identifier");
				_vala_source_reference_unref0 (_tmp20_);
			}
		}
	}
	result = FALSE;
	return result;
}


static gboolean
vala_scanner_parse_pp_unary_expression (ValaScanner* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->current;
	_tmp2_ = self->priv->end;
	if (_tmp1_ < _tmp2_) {
		gchar* _tmp3_;
		gchar _tmp4_;
		_tmp3_ = self->priv->current;
		_tmp4_ = _tmp3_[0];
		_tmp0_ = _tmp4_ == '!';
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		gint _tmp6_;
		_tmp5_ = self->priv->current;
		self->priv->current = _tmp5_ + 1;
		_tmp6_ = self->priv->column;
		self->priv->column = _tmp6_ + 1;
		vala_scanner_pp_space (self);
		result = !vala_scanner_parse_pp_unary_expression (self);
		return result;
	}
	result = vala_scanner_parse_pp_primary_expression (self);
	return result;
}


static gboolean
vala_scanner_parse_pp_equality_expression (ValaScanner* self)
{
	gboolean result = FALSE;
	gboolean left = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	left = vala_scanner_parse_pp_unary_expression (self);
	vala_scanner_pp_space (self);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->end;
		if (_tmp2_ < (_tmp3_ - 1)) {
			gchar* _tmp4_;
			gchar _tmp5_;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_[0];
			_tmp1_ = _tmp5_ == '=';
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[1];
			_tmp0_ = _tmp7_ == '=';
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			gchar* _tmp8_;
			gint _tmp9_;
			gboolean right = FALSE;
			gboolean _tmp10_;
			gboolean _tmp11_;
			_tmp8_ = self->priv->current;
			self->priv->current = _tmp8_ + 2;
			_tmp9_ = self->priv->column;
			self->priv->column = _tmp9_ + 2;
			vala_scanner_pp_space (self);
			right = vala_scanner_parse_pp_unary_expression (self);
			_tmp10_ = left;
			_tmp11_ = right;
			left = _tmp10_ == _tmp11_;
		} else {
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp14_ = self->priv->current;
			_tmp15_ = self->priv->end;
			if (_tmp14_ < (_tmp15_ - 1)) {
				gchar* _tmp16_;
				gchar _tmp17_;
				_tmp16_ = self->priv->current;
				_tmp17_ = _tmp16_[0];
				_tmp13_ = _tmp17_ == '!';
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				gchar* _tmp18_;
				gchar _tmp19_;
				_tmp18_ = self->priv->current;
				_tmp19_ = _tmp18_[1];
				_tmp12_ = _tmp19_ == '=';
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				gchar* _tmp20_;
				gint _tmp21_;
				gboolean right = FALSE;
				gboolean _tmp22_;
				gboolean _tmp23_;
				_tmp20_ = self->priv->current;
				self->priv->current = _tmp20_ + 2;
				_tmp21_ = self->priv->column;
				self->priv->column = _tmp21_ + 2;
				vala_scanner_pp_space (self);
				right = vala_scanner_parse_pp_unary_expression (self);
				_tmp22_ = left;
				_tmp23_ = right;
				left = _tmp22_ != _tmp23_;
			} else {
				break;
			}
		}
	}
	result = left;
	return result;
}


static gboolean
vala_scanner_parse_pp_and_expression (ValaScanner* self)
{
	gboolean result = FALSE;
	gboolean left = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	left = vala_scanner_parse_pp_equality_expression (self);
	vala_scanner_pp_space (self);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp8_;
		gint _tmp9_;
		gboolean right = FALSE;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->end;
		if (_tmp2_ < (_tmp3_ - 1)) {
			gchar* _tmp4_;
			gchar _tmp5_;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_[0];
			_tmp1_ = _tmp5_ == '&';
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[1];
			_tmp0_ = _tmp7_ == '&';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp8_ = self->priv->current;
		self->priv->current = _tmp8_ + 2;
		_tmp9_ = self->priv->column;
		self->priv->column = _tmp9_ + 2;
		vala_scanner_pp_space (self);
		right = vala_scanner_parse_pp_equality_expression (self);
		_tmp11_ = left;
		if (_tmp11_) {
			gboolean _tmp12_;
			_tmp12_ = right;
			_tmp10_ = _tmp12_;
		} else {
			_tmp10_ = FALSE;
		}
		left = _tmp10_;
	}
	result = left;
	return result;
}


static gboolean
vala_scanner_parse_pp_or_expression (ValaScanner* self)
{
	gboolean result = FALSE;
	gboolean left = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	left = vala_scanner_parse_pp_and_expression (self);
	vala_scanner_pp_space (self);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp8_;
		gint _tmp9_;
		gboolean right = FALSE;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->end;
		if (_tmp2_ < (_tmp3_ - 1)) {
			gchar* _tmp4_;
			gchar _tmp5_;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_[0];
			_tmp1_ = _tmp5_ == '|';
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[1];
			_tmp0_ = _tmp7_ == '|';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp8_ = self->priv->current;
		self->priv->current = _tmp8_ + 2;
		_tmp9_ = self->priv->column;
		self->priv->column = _tmp9_ + 2;
		vala_scanner_pp_space (self);
		right = vala_scanner_parse_pp_and_expression (self);
		_tmp11_ = left;
		if (_tmp11_) {
			_tmp10_ = TRUE;
		} else {
			gboolean _tmp12_;
			_tmp12_ = right;
			_tmp10_ = _tmp12_;
		}
		left = _tmp10_;
	}
	result = left;
	return result;
}


static gboolean
vala_scanner_parse_pp_expression (ValaScanner* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_scanner_parse_pp_or_expression (self);
	return result;
}


static gboolean
vala_scanner_whitespace (ValaScanner* self)
{
	gboolean result = FALSE;
	gboolean found = FALSE;
	gboolean bol = FALSE;
	gint _tmp0_;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	_tmp0_ = self->priv->column;
	bol = _tmp0_ == 1;
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp6_;
		gchar _tmp7_;
		gchar* _tmp9_;
		gint _tmp10_;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->end;
		if (_tmp2_ < _tmp3_) {
			gchar* _tmp4_;
			gchar _tmp5_;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_[0];
			_tmp1_ = g_ascii_isspace (_tmp5_);
		} else {
			_tmp1_ = FALSE;
		}
		if (!_tmp1_) {
			break;
		}
		_tmp6_ = self->priv->current;
		_tmp7_ = _tmp6_[0];
		if (_tmp7_ == '\n') {
			gint _tmp8_;
			_tmp8_ = self->priv->line;
			self->priv->line = _tmp8_ + 1;
			self->priv->column = 0;
			bol = TRUE;
		}
		found = TRUE;
		_tmp9_ = self->priv->current;
		self->priv->current = _tmp9_ + 1;
		_tmp10_ = self->priv->column;
		self->priv->column = _tmp10_ + 1;
	}
	_tmp13_ = bol;
	if (_tmp13_) {
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp14_ = self->priv->current;
		_tmp15_ = self->priv->end;
		_tmp12_ = _tmp14_ < _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		gchar* _tmp16_;
		gchar _tmp17_;
		_tmp16_ = self->priv->current;
		_tmp17_ = _tmp16_[0];
		_tmp11_ = _tmp17_ == '#';
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		vala_scanner_pp_directive (self);
		result = TRUE;
		return result;
	}
	result = found;
	return result;
}


static gboolean
vala_scanner_comment (ValaScanner* self, 
                      gboolean file_comment)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_;
	gchar* _tmp13_;
	gchar _tmp14_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp3_ = self->priv->current;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = self->priv->current;
		_tmp5_ = self->priv->end;
		_tmp2_ = _tmp4_ > (_tmp5_ - 2);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gchar* _tmp6_;
		gchar _tmp7_;
		_tmp6_ = self->priv->current;
		_tmp7_ = _tmp6_[0];
		_tmp1_ = _tmp7_ != '/';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp8_ = FALSE;
		gchar* _tmp9_;
		gchar _tmp10_;
		_tmp9_ = self->priv->current;
		_tmp10_ = _tmp9_[1];
		if (_tmp10_ != '/') {
			gchar* _tmp11_;
			gchar _tmp12_;
			_tmp11_ = self->priv->current;
			_tmp12_ = _tmp11_[1];
			_tmp8_ = _tmp12_ != '*';
		} else {
			_tmp8_ = FALSE;
		}
		_tmp0_ = _tmp8_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp13_ = self->priv->current;
	_tmp14_ = _tmp13_[1];
	if (_tmp14_ == '/') {
		ValaSourceReference* source_reference = NULL;
		gchar* _tmp16_;
		gchar* begin = NULL;
		gchar* _tmp17_;
		ValaSourceReference* _tmp24_;
		source_reference = NULL;
		if (file_comment) {
			ValaSourceReference* _tmp15_;
			_tmp15_ = vala_scanner_get_source_reference (self, 0, 0);
			_vala_source_reference_unref0 (source_reference);
			source_reference = _tmp15_;
		}
		_tmp16_ = self->priv->current;
		self->priv->current = _tmp16_ + 2;
		_tmp17_ = self->priv->current;
		begin = _tmp17_;
		while (TRUE) {
			gboolean _tmp18_ = FALSE;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp23_;
			_tmp19_ = self->priv->current;
			_tmp20_ = self->priv->end;
			if (_tmp19_ < _tmp20_) {
				gchar* _tmp21_;
				gchar _tmp22_;
				_tmp21_ = self->priv->current;
				_tmp22_ = _tmp21_[0];
				_tmp18_ = _tmp22_ != '\n';
			} else {
				_tmp18_ = FALSE;
			}
			if (!_tmp18_) {
				break;
			}
			_tmp23_ = self->priv->current;
			self->priv->current = _tmp23_ + 1;
		}
		_tmp24_ = source_reference;
		if (_tmp24_ != NULL) {
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			ValaSourceReference* _tmp30_;
			_tmp25_ = begin;
			_tmp26_ = self->priv->current;
			_tmp27_ = begin;
			_tmp28_ = string_substring ((const gchar*) _tmp25_, (glong) 0, (glong) (_tmp26_ - _tmp27_));
			_tmp29_ = _tmp28_;
			_tmp30_ = source_reference;
			vala_scanner_push_comment (self, _tmp29_, _tmp30_, file_comment);
			_g_free0 (_tmp29_);
		}
		_vala_source_reference_unref0 (source_reference);
	} else {
		ValaSourceReference* source_reference = NULL;
		gboolean _tmp31_ = FALSE;
		gboolean _tmp34_ = FALSE;
		gchar* _tmp35_;
		gchar _tmp36_;
		gchar* _tmp38_;
		gint _tmp39_;
		gchar* begin = NULL;
		gchar* _tmp40_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		ValaSourceReference* _tmp58_;
		gchar* _tmp65_;
		gint _tmp66_;
		source_reference = NULL;
		if (file_comment) {
			gchar* _tmp32_;
			gchar _tmp33_;
			_tmp32_ = self->priv->current;
			_tmp33_ = _tmp32_[2];
			_tmp31_ = _tmp33_ == '*';
		} else {
			_tmp31_ = FALSE;
		}
		if (_tmp31_) {
			result = FALSE;
			_vala_source_reference_unref0 (source_reference);
			return result;
		}
		_tmp35_ = self->priv->current;
		_tmp36_ = _tmp35_[2];
		if (_tmp36_ == '*') {
			_tmp34_ = TRUE;
		} else {
			_tmp34_ = file_comment;
		}
		if (_tmp34_) {
			ValaSourceReference* _tmp37_;
			_tmp37_ = vala_scanner_get_source_reference (self, 0, 0);
			_vala_source_reference_unref0 (source_reference);
			source_reference = _tmp37_;
		}
		_tmp38_ = self->priv->current;
		self->priv->current = _tmp38_ + 2;
		_tmp39_ = self->priv->column;
		self->priv->column = _tmp39_ + 2;
		_tmp40_ = self->priv->current;
		begin = _tmp40_;
		while (TRUE) {
			gboolean _tmp41_ = FALSE;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp49_;
			gchar _tmp50_;
			gchar* _tmp52_;
			gint _tmp53_;
			_tmp42_ = self->priv->current;
			_tmp43_ = self->priv->end;
			if (_tmp42_ < (_tmp43_ - 1)) {
				gboolean _tmp44_ = FALSE;
				gchar* _tmp45_;
				gchar _tmp46_;
				_tmp45_ = self->priv->current;
				_tmp46_ = _tmp45_[0];
				if (_tmp46_ != '*') {
					_tmp44_ = TRUE;
				} else {
					gchar* _tmp47_;
					gchar _tmp48_;
					_tmp47_ = self->priv->current;
					_tmp48_ = _tmp47_[1];
					_tmp44_ = _tmp48_ != '/';
				}
				_tmp41_ = _tmp44_;
			} else {
				_tmp41_ = FALSE;
			}
			if (!_tmp41_) {
				break;
			}
			_tmp49_ = self->priv->current;
			_tmp50_ = _tmp49_[0];
			if (_tmp50_ == '\n') {
				gint _tmp51_;
				_tmp51_ = self->priv->line;
				self->priv->line = _tmp51_ + 1;
				self->priv->column = 0;
			}
			_tmp52_ = self->priv->current;
			self->priv->current = _tmp52_ + 1;
			_tmp53_ = self->priv->column;
			self->priv->column = _tmp53_ + 1;
		}
		_tmp54_ = self->priv->current;
		_tmp55_ = self->priv->end;
		if (_tmp54_ == (_tmp55_ - 1)) {
			ValaSourceReference* _tmp56_;
			ValaSourceReference* _tmp57_;
			_tmp56_ = vala_scanner_get_source_reference (self, 0, 0);
			_tmp57_ = _tmp56_;
			vala_report_error (_tmp57_, "syntax error, expected */");
			_vala_source_reference_unref0 (_tmp57_);
			result = TRUE;
			_vala_source_reference_unref0 (source_reference);
			return result;
		}
		_tmp58_ = source_reference;
		if (_tmp58_ != NULL) {
			gchar* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			ValaSourceReference* _tmp64_;
			_tmp59_ = begin;
			_tmp60_ = self->priv->current;
			_tmp61_ = begin;
			_tmp62_ = string_substring ((const gchar*) _tmp59_, (glong) 0, (glong) (_tmp60_ - _tmp61_));
			_tmp63_ = _tmp62_;
			_tmp64_ = source_reference;
			vala_scanner_push_comment (self, _tmp63_, _tmp64_, file_comment);
			_g_free0 (_tmp63_);
		}
		_tmp65_ = self->priv->current;
		self->priv->current = _tmp65_ + 2;
		_tmp66_ = self->priv->column;
		self->priv->column = _tmp66_ + 2;
		_vala_source_reference_unref0 (source_reference);
	}
	result = TRUE;
	return result;
}


static void
vala_scanner_space (ValaScanner* self)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (vala_scanner_whitespace (self)) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = vala_scanner_comment (self, FALSE);
		}
		if (!_tmp0_) {
			break;
		}
	}
}


void
vala_scanner_parse_file_comments (ValaScanner* self)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (vala_scanner_whitespace (self)) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = vala_scanner_comment (self, TRUE);
		}
		if (!_tmp0_) {
			break;
		}
	}
}


static gchar
string_get (const gchar* self, 
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}


static void
vala_scanner_push_comment (ValaScanner* self, 
                           const gchar* comment_item, 
                           ValaSourceReference* source_reference, 
                           gboolean file_comment)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (comment_item != NULL);
	g_return_if_fail (source_reference != NULL);
	if (string_get (comment_item, (glong) 0) == '*') {
		ValaComment* _tmp0_;
		ValaComment* _tmp3_;
		_tmp0_ = self->priv->_comment;
		if (_tmp0_ != NULL) {
			ValaSourceFile* _tmp1_;
			ValaComment* _tmp2_;
			_tmp1_ = self->priv->_source_file;
			_tmp2_ = self->priv->_comment;
			vala_source_file_add_comment (_tmp1_, _tmp2_);
		}
		_tmp3_ = vala_comment_new (comment_item, source_reference);
		_vala_comment_unref0 (self->priv->_comment);
		self->priv->_comment = _tmp3_;
	}
	if (file_comment) {
		ValaSourceFile* _tmp4_;
		ValaComment* _tmp5_;
		ValaComment* _tmp6_;
		_tmp4_ = self->priv->_source_file;
		_tmp5_ = vala_comment_new (comment_item, source_reference);
		_tmp6_ = _tmp5_;
		vala_source_file_add_comment (_tmp4_, _tmp6_);
		_vala_comment_unref0 (_tmp6_);
		_vala_comment_unref0 (self->priv->_comment);
		self->priv->_comment = NULL;
	}
}


/**
 * Clears and returns the content of the comment stack.
 *
 * @return saved comment
 */
static gpointer
_vala_comment_ref0 (gpointer self)
{
	return self ? vala_comment_ref (self) : NULL;
}


ValaComment*
vala_scanner_pop_comment (ValaScanner* self)
{
	ValaComment* result = NULL;
	ValaComment* _tmp0_;
	ValaComment* comment = NULL;
	ValaComment* _tmp1_;
	ValaComment* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_comment;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->_comment;
	_tmp2_ = _vala_comment_ref0 (_tmp1_);
	comment = _tmp2_;
	_vala_comment_unref0 (self->priv->_comment);
	self->priv->_comment = NULL;
	result = comment;
	return result;
}


ValaSourceFile*
vala_scanner_get_source_file (ValaScanner* self)
{
	ValaSourceFile* result;
	ValaSourceFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_file;
	result = _tmp0_;
	return result;
}


static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}


static void
vala_scanner_set_source_file (ValaScanner* self, 
                              ValaSourceFile* value)
{
	ValaSourceFile* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_source_file_ref0 (value);
	_vala_source_file_unref0 (self->priv->_source_file);
	self->priv->_source_file = _tmp0_;
}


static ValaScannerConditional*
vala_scanner_conditional_dup (const ValaScannerConditional* self)
{
	ValaScannerConditional* dup;
	dup = g_new0 (ValaScannerConditional, 1);
	memcpy (dup, self, sizeof (ValaScannerConditional));
	return dup;
}


static void
vala_scanner_conditional_free (ValaScannerConditional* self)
{
	g_free (self);
}


static GType
vala_scanner_conditional_get_type (void)
{
	static volatile gsize vala_scanner_conditional_type_id__volatile = 0;
	if (g_once_init_enter (&vala_scanner_conditional_type_id__volatile)) {
		GType vala_scanner_conditional_type_id;
		vala_scanner_conditional_type_id = g_boxed_type_register_static ("ValaScannerConditional", (GBoxedCopyFunc) vala_scanner_conditional_dup, (GBoxedFreeFunc) vala_scanner_conditional_free);
		g_once_init_leave (&vala_scanner_conditional_type_id__volatile, vala_scanner_conditional_type_id);
	}
	return vala_scanner_conditional_type_id__volatile;
}


static void
vala_value_scanner_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
vala_value_scanner_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_scanner_unref (value->data[0].v_pointer);
	}
}


static void
vala_value_scanner_copy_value (const GValue* src_value, 
                               GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_scanner_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
vala_value_scanner_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
vala_value_scanner_collect_value (GValue* value, 
                                  guint n_collect_values, 
                                  GTypeCValue* collect_values, 
                                  guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaScanner * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_scanner_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
vala_value_scanner_lcopy_value (const GValue* value, 
                                guint n_collect_values, 
                                GTypeCValue* collect_values, 
                                guint collect_flags)
{
	ValaScanner ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_scanner_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec*
vala_param_spec_scanner (const gchar* name, 
                         const gchar* nick, 
                         const gchar* blurb, 
                         GType object_type, 
                         GParamFlags flags)
{
	ValaParamSpecScanner* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_SCANNER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer
vala_value_get_scanner (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SCANNER), NULL);
	return value->data[0].v_pointer;
}


void
vala_value_set_scanner (GValue* value, 
                        gpointer v_object)
{
	ValaScanner * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SCANNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_SCANNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_scanner_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_scanner_unref (old);
	}
}


void
vala_value_take_scanner (GValue* value, 
                         gpointer v_object)
{
	ValaScanner * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SCANNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_SCANNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_scanner_unref (old);
	}
}


static void
vala_scanner_class_init (ValaScannerClass * klass)
{
	vala_scanner_parent_class = g_type_class_peek_parent (klass);
	((ValaScannerClass *) klass)->finalize = vala_scanner_finalize;
	g_type_class_add_private (klass, sizeof (ValaScannerPrivate));
}


static void
vala_scanner_instance_init (ValaScanner * self)
{
	self->priv = VALA_SCANNER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void
vala_scanner_finalize (ValaScanner * obj)
{
	ValaScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_SCANNER, ValaScanner);
	g_signal_handlers_destroy (self);
	_vala_source_file_unref0 (self->priv->_source_file);
	_vala_comment_unref0 (self->priv->_comment);
	self->priv->conditional_stack = (g_free (self->priv->conditional_stack), NULL);
	self->priv->state_stack = (g_free (self->priv->state_stack), NULL);
}


/**
 * Lexical scanner for Vala source files.
 */
GType
vala_scanner_get_type (void)
{
	static volatile gsize vala_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&vala_scanner_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_scanner_init, vala_value_scanner_free_value, vala_value_scanner_copy_value, vala_value_scanner_peek_pointer, "p", vala_value_scanner_collect_value, "p", vala_value_scanner_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaScanner), 0, (GInstanceInitFunc) vala_scanner_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_scanner_type_id;
		vala_scanner_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaScanner", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_scanner_type_id__volatile, vala_scanner_type_id);
	}
	return vala_scanner_type_id__volatile;
}


gpointer
vala_scanner_ref (gpointer instance)
{
	ValaScanner * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void
vala_scanner_unref (gpointer instance)
{
	ValaScanner * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_SCANNER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



