/* valalocalvariable.c generated by valac, the Vala compiler
 * generated from valalocalvariable.vala, do not modify */

/* valalocalvariable.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>

enum  {
	VALA_LOCAL_VARIABLE_0_PROPERTY,
	VALA_LOCAL_VARIABLE_NUM_PROPERTIES
};
static GParamSpec* vala_local_variable_properties[VALA_LOCAL_VARIABLE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

struct _ValaLocalVariablePrivate {
	gboolean _is_result;
	gboolean _captured;
	gboolean _init;
};


static gpointer vala_local_variable_parent_class = NULL;

#define VALA_LOCAL_VARIABLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariablePrivate))
static void vala_local_variable_real_accept (ValaCodeNode* base, 
                                      ValaCodeVisitor* visitor);
static void vala_local_variable_real_accept_children (ValaCodeNode* base, 
                                               ValaCodeVisitor* visitor);
static void vala_local_variable_real_replace_expression (ValaCodeNode* base, 
                                                  ValaExpression* old_node, 
                                                  ValaExpression* new_node);
static void vala_local_variable_real_replace_type (ValaCodeNode* base, 
                                            ValaDataType* old_type, 
                                            ValaDataType* new_type);
static gboolean vala_local_variable_real_check (ValaCodeNode* base, 
                                         ValaCodeContext* context);
static void vala_local_variable_finalize (ValaCodeNode * obj);


/**
 * Creates a new local variable.
 *
 * @param name              name of the variable
 * @param initializer       optional initializer expression
 * @param source_reference  reference to source code
 * @return                  newly created variable declarator
 */
ValaLocalVariable*
vala_local_variable_construct (GType object_type, 
                               ValaDataType* variable_type, 
                               const gchar* name, 
                               ValaExpression* initializer, 
                               ValaSourceReference* source_reference)
{
	ValaLocalVariable* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaLocalVariable*) vala_variable_construct (object_type, variable_type, name, initializer, source_reference, NULL);
	return self;
}


ValaLocalVariable*
vala_local_variable_new (ValaDataType* variable_type, 
                         const gchar* name, 
                         ValaExpression* initializer, 
                         ValaSourceReference* source_reference)
{
	return vala_local_variable_construct (VALA_TYPE_LOCAL_VARIABLE, variable_type, name, initializer, source_reference);
}


static void
vala_local_variable_real_accept (ValaCodeNode* base, 
                                 ValaCodeVisitor* visitor)
{
	ValaLocalVariable * self;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_local_variable (visitor, self);
}


static void
vala_local_variable_real_accept_children (ValaCodeNode* base, 
                                          ValaCodeVisitor* visitor)
{
	ValaLocalVariable * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp2_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
		_tmp4_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp5_ = _tmp4_;
		vala_code_visitor_visit_end_full_expression (visitor, _tmp5_);
	}
	_tmp6_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp8_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp9_ = _tmp8_;
		vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
	}
}


static void
vala_local_variable_real_replace_expression (ValaCodeNode* base, 
                                             ValaExpression* old_node, 
                                             ValaExpression* new_node)
{
	ValaLocalVariable * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_variable_set_initializer ((ValaVariable*) self, new_node);
	}
}


static void
vala_local_variable_real_replace_type (ValaCodeNode* base, 
                                       ValaDataType* old_type, 
                                       ValaDataType* new_type)
{
	ValaLocalVariable * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_variable_set_variable_type ((ValaVariable*) self, new_type);
	}
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_local_variable_real_check (ValaCodeNode* base, 
                                ValaCodeContext* context)
{
	ValaLocalVariable * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	gboolean is_initializer_list = FALSE;
	gint initializer_size = 0;
	ValaExpression* _tmp12_;
	ValaExpression* _tmp13_;
	ValaDataType* _tmp26_;
	ValaDataType* _tmp27_;
	gboolean _tmp68_ = FALSE;
	ValaExpression* _tmp69_;
	ValaExpression* _tmp70_;
	ValaSemanticAnalyzer* _tmp191_;
	ValaSemanticAnalyzer* _tmp192_;
	ValaSymbol* _tmp193_;
	ValaSymbol* _tmp194_;
	ValaScope* _tmp195_;
	ValaScope* _tmp196_;
	const gchar* _tmp197_;
	const gchar* _tmp198_;
	ValaBlock* block = NULL;
	ValaSemanticAnalyzer* _tmp199_;
	ValaSemanticAnalyzer* _tmp200_;
	ValaSymbol* _tmp201_;
	ValaSymbol* _tmp202_;
	ValaBlock* _tmp203_;
	ValaBlock* _tmp204_;
	gboolean _tmp206_;
	gboolean _tmp207_;
	self = (ValaLocalVariable*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		ValaDataType* _tmp10_;
		ValaDataType* _tmp11_;
		_tmp6_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp7_ = _tmp6_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_VOID_TYPE)) {
			ValaSourceReference* _tmp8_;
			ValaSourceReference* _tmp9_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp9_ = _tmp8_;
			vala_report_error (_tmp9_, "'void' not supported as variable type");
			result = FALSE;
			return result;
		}
		_tmp10_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp11_ = _tmp10_;
		vala_code_node_check ((ValaCodeNode*) _tmp11_, context);
	}
	is_initializer_list = FALSE;
	initializer_size = -1;
	_tmp12_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaExpression* _tmp14_;
		ValaExpression* _tmp15_;
		ValaDataType* _tmp16_;
		ValaDataType* _tmp17_;
		ValaExpression* _tmp18_;
		ValaExpression* _tmp19_;
		ValaExpression* _tmp24_;
		ValaExpression* _tmp25_;
		_tmp14_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp17_ = _tmp16_;
		vala_expression_set_target_type (_tmp15_, _tmp17_);
		_tmp18_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp19_ = _tmp18_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, VALA_TYPE_INITIALIZER_LIST)) {
			ValaExpression* _tmp20_;
			ValaExpression* _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			_tmp20_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_initializer_list_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
			_tmp23_ = _tmp22_;
			initializer_size = _tmp23_;
			is_initializer_list = TRUE;
		}
		_tmp24_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp25_ = _tmp24_;
		vala_code_node_check ((ValaCodeNode*) _tmp25_, context);
	}
	_tmp26_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp27_ = _tmp26_;
	if (_tmp27_ == NULL) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaExpression* _tmp32_;
		ValaExpression* _tmp33_;
		ValaDataType* _tmp34_;
		ValaDataType* _tmp35_;
		ValaExpression* _tmp38_;
		ValaExpression* _tmp39_;
		ValaDataType* _tmp40_;
		ValaDataType* _tmp41_;
		ValaExpression* _tmp54_;
		ValaExpression* _tmp55_;
		ValaDataType* _tmp56_;
		ValaDataType* _tmp57_;
		ValaDataType* _tmp58_;
		ValaDataType* _tmp59_;
		ValaDataType* _tmp60_;
		ValaDataType* _tmp61_;
		ValaDataType* _tmp62_;
		ValaDataType* _tmp63_;
		ValaExpression* _tmp64_;
		ValaExpression* _tmp65_;
		ValaDataType* _tmp66_;
		ValaDataType* _tmp67_;
		_tmp28_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp29_ = _tmp28_;
		if (_tmp29_ == NULL) {
			ValaSourceReference* _tmp30_;
			ValaSourceReference* _tmp31_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp31_ = _tmp30_;
			vala_report_error (_tmp31_, "var declaration not allowed without initializer");
			result = FALSE;
			return result;
		}
		_tmp32_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_expression_get_value_type (_tmp33_);
		_tmp35_ = _tmp34_;
		if (_tmp35_ == NULL) {
			ValaSourceReference* _tmp36_;
			ValaSourceReference* _tmp37_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp37_ = _tmp36_;
			vala_report_error (_tmp37_, "var declaration not allowed with non-typed initializer");
			result = FALSE;
			return result;
		}
		_tmp38_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_expression_get_value_type (_tmp39_);
		_tmp41_ = _tmp40_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp41_, VALA_TYPE_FIELD_PROTOTYPE)) {
			ValaExpression* _tmp42_;
			ValaExpression* _tmp43_;
			ValaSourceReference* _tmp44_;
			ValaSourceReference* _tmp45_;
			ValaExpression* _tmp46_;
			ValaExpression* _tmp47_;
			ValaSymbol* _tmp48_;
			ValaSymbol* _tmp49_;
			gchar* _tmp50_;
			gchar* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp42_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp43_ = _tmp42_;
			_tmp44_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp43_);
			_tmp45_ = _tmp44_;
			_tmp46_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp47_ = _tmp46_;
			_tmp48_ = vala_expression_get_symbol_reference (_tmp47_);
			_tmp49_ = _tmp48_;
			_tmp50_ = vala_symbol_get_full_name (_tmp49_);
			_tmp51_ = _tmp50_;
			_tmp52_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp51_);
			_tmp53_ = _tmp52_;
			vala_report_error (_tmp45_, _tmp53_);
			_g_free0 (_tmp53_);
			_g_free0 (_tmp51_);
			result = FALSE;
			return result;
		}
		_tmp54_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp55_ = _tmp54_;
		_tmp56_ = vala_expression_get_value_type (_tmp55_);
		_tmp57_ = _tmp56_;
		_tmp58_ = vala_data_type_copy (_tmp57_);
		_tmp59_ = _tmp58_;
		vala_variable_set_variable_type ((ValaVariable*) self, _tmp59_);
		_vala_code_node_unref0 (_tmp59_);
		_tmp60_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp61_ = _tmp60_;
		vala_data_type_set_value_owned (_tmp61_, TRUE);
		_tmp62_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp63_ = _tmp62_;
		vala_data_type_set_floating_reference (_tmp63_, FALSE);
		_tmp64_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp65_ = _tmp64_;
		_tmp66_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp67_ = _tmp66_;
		vala_expression_set_target_type (_tmp65_, _tmp67_);
	}
	_tmp69_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp70_ = _tmp69_;
	if (_tmp70_ != NULL) {
		ValaExpression* _tmp71_;
		ValaExpression* _tmp72_;
		gboolean _tmp73_;
		gboolean _tmp74_;
		_tmp71_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp72_ = _tmp71_;
		_tmp73_ = vala_code_node_get_error ((ValaCodeNode*) _tmp72_);
		_tmp74_ = _tmp73_;
		_tmp68_ = !_tmp74_;
	} else {
		_tmp68_ = FALSE;
	}
	if (_tmp68_) {
		ValaExpression* _tmp75_;
		ValaExpression* _tmp76_;
		ValaDataType* _tmp77_;
		ValaDataType* _tmp78_;
		ValaExpression* _tmp124_;
		ValaExpression* _tmp125_;
		ValaDataType* _tmp126_;
		ValaDataType* _tmp127_;
		ValaDataType* _tmp128_;
		ValaDataType* _tmp129_;
		ValaArrayType* variable_array_type = NULL;
		ValaDataType* _tmp144_;
		ValaDataType* _tmp145_;
		ValaArrayType* _tmp146_;
		gboolean _tmp147_ = FALSE;
		gboolean _tmp148_ = FALSE;
		gboolean _tmp149_ = FALSE;
		ValaArrayType* _tmp150_;
		gboolean _tmp166_ = FALSE;
		gboolean _tmp167_ = FALSE;
		ValaArrayType* _tmp168_;
		ValaExpression* _tmp178_;
		ValaExpression* _tmp179_;
		ValaDataType* _tmp180_;
		ValaDataType* _tmp181_;
		_tmp75_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp76_ = _tmp75_;
		_tmp77_ = vala_expression_get_value_type (_tmp76_);
		_tmp78_ = _tmp77_;
		if (_tmp78_ == NULL) {
			gboolean _tmp79_ = FALSE;
			ValaExpression* _tmp80_;
			ValaExpression* _tmp81_;
			gboolean _tmp86_ = FALSE;
			ValaExpression* _tmp87_;
			ValaExpression* _tmp88_;
			ValaSymbol* _tmp89_;
			ValaSymbol* _tmp90_;
			_tmp80_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp81_ = _tmp80_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp81_, VALA_TYPE_MEMBER_ACCESS)) {
				ValaExpression* _tmp82_;
				ValaExpression* _tmp83_;
				_tmp82_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp83_ = _tmp82_;
				_tmp79_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp83_, VALA_TYPE_LAMBDA_EXPRESSION);
			} else {
				_tmp79_ = FALSE;
			}
			if (_tmp79_) {
				ValaSourceReference* _tmp84_;
				ValaSourceReference* _tmp85_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp84_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp85_ = _tmp84_;
				vala_report_error (_tmp85_, "expression type not allowed as initializer");
				result = FALSE;
				return result;
			}
			_tmp87_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp88_ = _tmp87_;
			_tmp89_ = vala_expression_get_symbol_reference (_tmp88_);
			_tmp90_ = _tmp89_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp90_, VALA_TYPE_METHOD)) {
				ValaDataType* _tmp91_;
				ValaDataType* _tmp92_;
				_tmp91_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp92_ = _tmp91_;
				_tmp86_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp92_, VALA_TYPE_DELEGATE_TYPE);
			} else {
				_tmp86_ = FALSE;
			}
			if (_tmp86_) {
				ValaMethod* m = NULL;
				ValaExpression* _tmp93_;
				ValaExpression* _tmp94_;
				ValaSymbol* _tmp95_;
				ValaSymbol* _tmp96_;
				ValaMethod* _tmp97_;
				ValaDelegateType* dt = NULL;
				ValaDataType* _tmp98_;
				ValaDataType* _tmp99_;
				ValaDelegateType* _tmp100_;
				ValaDelegate* cb = NULL;
				ValaDelegateType* _tmp101_;
				ValaDelegate* _tmp102_;
				ValaDelegate* _tmp103_;
				ValaDelegate* _tmp104_;
				ValaDelegate* _tmp105_;
				ValaMethod* _tmp106_;
				ValaDelegateType* _tmp107_;
				ValaExpression* _tmp118_;
				ValaExpression* _tmp119_;
				ValaDataType* _tmp120_;
				ValaDataType* _tmp121_;
				_tmp93_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp94_ = _tmp93_;
				_tmp95_ = vala_expression_get_symbol_reference (_tmp94_);
				_tmp96_ = _tmp95_;
				_tmp97_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp96_, VALA_TYPE_METHOD, ValaMethod));
				m = _tmp97_;
				_tmp98_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp99_ = _tmp98_;
				_tmp100_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				dt = _tmp100_;
				_tmp101_ = dt;
				_tmp102_ = vala_delegate_type_get_delegate_symbol (_tmp101_);
				_tmp103_ = _tmp102_;
				_tmp104_ = _vala_code_node_ref0 (_tmp103_);
				cb = _tmp104_;
				_tmp105_ = cb;
				_tmp106_ = m;
				_tmp107_ = dt;
				if (!vala_delegate_matches_method (_tmp105_, _tmp106_, (ValaDataType*) _tmp107_)) {
					ValaSourceReference* _tmp108_;
					ValaSourceReference* _tmp109_;
					ValaMethod* _tmp110_;
					gchar* _tmp111_;
					gchar* _tmp112_;
					ValaDelegate* _tmp113_;
					gchar* _tmp114_;
					gchar* _tmp115_;
					gchar* _tmp116_;
					gchar* _tmp117_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp108_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp109_ = _tmp108_;
					_tmp110_ = m;
					_tmp111_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp110_);
					_tmp112_ = _tmp111_;
					_tmp113_ = cb;
					_tmp114_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp113_);
					_tmp115_ = _tmp114_;
					_tmp116_ = g_strdup_printf ("declaration of method `%s' doesn't match declaration of callback `%s'", _tmp112_, _tmp115_);
					_tmp117_ = _tmp116_;
					vala_report_error (_tmp109_, _tmp117_);
					_g_free0 (_tmp117_);
					_g_free0 (_tmp115_);
					_g_free0 (_tmp112_);
					result = FALSE;
					_vala_code_node_unref0 (cb);
					_vala_code_node_unref0 (dt);
					_vala_code_node_unref0 (m);
					return result;
				}
				_tmp118_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp119_ = _tmp118_;
				_tmp120_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp121_ = _tmp120_;
				vala_expression_set_value_type (_tmp119_, _tmp121_);
				_vala_code_node_unref0 (cb);
				_vala_code_node_unref0 (dt);
				_vala_code_node_unref0 (m);
			} else {
				ValaSourceReference* _tmp122_;
				ValaSourceReference* _tmp123_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp122_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp123_ = _tmp122_;
				vala_report_error (_tmp123_, "expression type not allowed as initializer");
				result = FALSE;
				return result;
			}
		}
		_tmp124_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp125_ = _tmp124_;
		_tmp126_ = vala_expression_get_value_type (_tmp125_);
		_tmp127_ = _tmp126_;
		_tmp128_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp129_ = _tmp128_;
		if (!vala_data_type_compatible (_tmp127_, _tmp129_)) {
			ValaSourceReference* _tmp130_;
			ValaSourceReference* _tmp131_;
			ValaExpression* _tmp132_;
			ValaExpression* _tmp133_;
			ValaDataType* _tmp134_;
			ValaDataType* _tmp135_;
			gchar* _tmp136_;
			gchar* _tmp137_;
			ValaDataType* _tmp138_;
			ValaDataType* _tmp139_;
			gchar* _tmp140_;
			gchar* _tmp141_;
			gchar* _tmp142_;
			gchar* _tmp143_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp130_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp131_ = _tmp130_;
			_tmp132_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp133_ = _tmp132_;
			_tmp134_ = vala_expression_get_value_type (_tmp133_);
			_tmp135_ = _tmp134_;
			_tmp136_ = vala_code_node_to_string ((ValaCodeNode*) _tmp135_);
			_tmp137_ = _tmp136_;
			_tmp138_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp139_ = _tmp138_;
			_tmp140_ = vala_code_node_to_string ((ValaCodeNode*) _tmp139_);
			_tmp141_ = _tmp140_;
			_tmp142_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp137_, _tmp141_);
			_tmp143_ = _tmp142_;
			vala_report_error (_tmp131_, _tmp143_);
			_g_free0 (_tmp143_);
			_g_free0 (_tmp141_);
			_g_free0 (_tmp137_);
			result = FALSE;
			return result;
		}
		_tmp144_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp145_ = _tmp144_;
		_tmp146_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp145_, VALA_TYPE_ARRAY_TYPE) ? ((ValaArrayType*) _tmp145_) : NULL);
		variable_array_type = _tmp146_;
		_tmp150_ = variable_array_type;
		if (_tmp150_ != NULL) {
			ValaArrayType* _tmp151_;
			gboolean _tmp152_;
			gboolean _tmp153_;
			_tmp151_ = variable_array_type;
			_tmp152_ = vala_array_type_get_inline_allocated (_tmp151_);
			_tmp153_ = _tmp152_;
			_tmp149_ = _tmp153_;
		} else {
			_tmp149_ = FALSE;
		}
		if (_tmp149_) {
			ValaArrayType* _tmp154_;
			gboolean _tmp155_;
			gboolean _tmp156_;
			_tmp154_ = variable_array_type;
			_tmp155_ = vala_array_type_get_fixed_length (_tmp154_);
			_tmp156_ = _tmp155_;
			_tmp148_ = !_tmp156_;
		} else {
			_tmp148_ = FALSE;
		}
		if (_tmp148_) {
			gboolean _tmp157_;
			_tmp157_ = is_initializer_list;
			_tmp147_ = _tmp157_;
		} else {
			_tmp147_ = FALSE;
		}
		if (_tmp147_) {
			ValaArrayType* _tmp158_;
			gint _tmp159_;
			gchar* _tmp160_;
			gchar* _tmp161_;
			ValaIntegerLiteral* _tmp162_;
			ValaIntegerLiteral* _tmp163_;
			ValaArrayType* _tmp164_;
			ValaArrayType* _tmp165_;
			_tmp158_ = variable_array_type;
			_tmp159_ = initializer_size;
			_tmp160_ = g_strdup_printf ("%i", _tmp159_);
			_tmp161_ = _tmp160_;
			_tmp162_ = vala_integer_literal_new (_tmp161_, NULL);
			_tmp163_ = _tmp162_;
			vala_array_type_set_length (_tmp158_, (ValaExpression*) _tmp163_);
			_vala_code_node_unref0 (_tmp163_);
			_g_free0 (_tmp161_);
			_tmp164_ = variable_array_type;
			vala_array_type_set_fixed_length (_tmp164_, TRUE);
			_tmp165_ = variable_array_type;
			vala_data_type_set_nullable ((ValaDataType*) _tmp165_, FALSE);
		}
		_tmp168_ = variable_array_type;
		if (_tmp168_ != NULL) {
			ValaArrayType* _tmp169_;
			gboolean _tmp170_;
			gboolean _tmp171_;
			_tmp169_ = variable_array_type;
			_tmp170_ = vala_array_type_get_inline_allocated (_tmp169_);
			_tmp171_ = _tmp170_;
			_tmp167_ = _tmp171_;
		} else {
			_tmp167_ = FALSE;
		}
		if (_tmp167_) {
			ValaExpression* _tmp172_;
			ValaExpression* _tmp173_;
			ValaDataType* _tmp174_;
			ValaDataType* _tmp175_;
			_tmp172_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp173_ = _tmp172_;
			_tmp174_ = vala_expression_get_value_type (_tmp173_);
			_tmp175_ = _tmp174_;
			_tmp166_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp175_, VALA_TYPE_ARRAY_TYPE) == FALSE;
		} else {
			_tmp166_ = FALSE;
		}
		if (_tmp166_) {
			ValaSourceReference* _tmp176_;
			ValaSourceReference* _tmp177_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp176_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp177_ = _tmp176_;
			vala_report_error (_tmp177_, "only arrays are allowed as initializer for arrays with fixed length");
			result = FALSE;
			_vala_code_node_unref0 (variable_array_type);
			return result;
		}
		_tmp178_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp179_ = _tmp178_;
		_tmp180_ = vala_expression_get_value_type (_tmp179_);
		_tmp181_ = _tmp180_;
		if (vala_data_type_is_disposable (_tmp181_)) {
			gboolean _tmp182_ = FALSE;
			ValaDataType* _tmp183_;
			ValaDataType* _tmp184_;
			_tmp183_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp184_ = _tmp183_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp184_, VALA_TYPE_POINTER_TYPE)) {
				ValaDataType* _tmp185_;
				ValaDataType* _tmp186_;
				gboolean _tmp187_;
				gboolean _tmp188_;
				_tmp185_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp186_ = _tmp185_;
				_tmp187_ = vala_data_type_get_value_owned (_tmp186_);
				_tmp188_ = _tmp187_;
				_tmp182_ = !_tmp188_;
			} else {
				_tmp182_ = FALSE;
			}
			if (_tmp182_) {
				ValaSourceReference* _tmp189_;
				ValaSourceReference* _tmp190_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp189_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp190_ = _tmp189_;
				vala_report_error (_tmp190_, "Invalid assignment from owned expression to unowned variable");
				result = FALSE;
				_vala_code_node_unref0 (variable_array_type);
				return result;
			}
		}
		_vala_code_node_unref0 (variable_array_type);
	}
	_tmp191_ = vala_code_context_get_analyzer (context);
	_tmp192_ = _tmp191_;
	_tmp193_ = vala_semantic_analyzer_get_current_symbol (_tmp192_);
	_tmp194_ = _tmp193_;
	_tmp195_ = vala_symbol_get_scope (_tmp194_);
	_tmp196_ = _tmp195_;
	_tmp197_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp198_ = _tmp197_;
	vala_scope_add (_tmp196_, _tmp198_, (ValaSymbol*) self);
	_tmp199_ = vala_code_context_get_analyzer (context);
	_tmp200_ = _tmp199_;
	_tmp201_ = vala_semantic_analyzer_get_current_symbol (_tmp200_);
	_tmp202_ = _tmp201_;
	_tmp203_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp202_, VALA_TYPE_BLOCK) ? ((ValaBlock*) _tmp202_) : NULL);
	block = _tmp203_;
	_tmp204_ = block;
	if (_tmp204_ != NULL) {
		ValaBlock* _tmp205_;
		_tmp205_ = block;
		vala_block_add_local_variable (_tmp205_, self);
	}
	vala_symbol_set_active ((ValaSymbol*) self, TRUE);
	_tmp206_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp207_ = _tmp206_;
	result = !_tmp207_;
	_vala_code_node_unref0 (block);
	return result;
}


gboolean
vala_local_variable_get_is_result (ValaLocalVariable* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_result;
	result = _tmp0_;
	return result;
}


void
vala_local_variable_set_is_result (ValaLocalVariable* self, 
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_result = value;
}


gboolean
vala_local_variable_get_captured (ValaLocalVariable* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_captured;
	result = _tmp0_;
	return result;
}


void
vala_local_variable_set_captured (ValaLocalVariable* self, 
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_captured = value;
}


gboolean
vala_local_variable_get_init (ValaLocalVariable* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_init;
	result = _tmp0_;
	return result;
}


void
vala_local_variable_set_init (ValaLocalVariable* self, 
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_init = value;
}


static void
vala_local_variable_class_init (ValaLocalVariableClass * klass)
{
	vala_local_variable_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_local_variable_finalize;
	g_type_class_add_private (klass, sizeof (ValaLocalVariablePrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_local_variable_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_local_variable_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_local_variable_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode *, ValaDataType*, ValaDataType*)) vala_local_variable_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_local_variable_real_check;
}


static void
vala_local_variable_instance_init (ValaLocalVariable * self)
{
	self->priv = VALA_LOCAL_VARIABLE_GET_PRIVATE (self);
}


static void
vala_local_variable_finalize (ValaCodeNode * obj)
{
	ValaLocalVariable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
	VALA_CODE_NODE_CLASS (vala_local_variable_parent_class)->finalize (obj);
}


/**
 * Represents a local variable declaration in the source code.
 */
GType
vala_local_variable_get_type (void)
{
	static volatile gsize vala_local_variable_type_id__volatile = 0;
	if (g_once_init_enter (&vala_local_variable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaLocalVariableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_local_variable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaLocalVariable), 0, (GInstanceInitFunc) vala_local_variable_instance_init, NULL };
		GType vala_local_variable_type_id;
		vala_local_variable_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaLocalVariable", &g_define_type_info, 0);
		g_once_init_leave (&vala_local_variable_type_id__volatile, vala_local_variable_type_id);
	}
	return vala_local_variable_type_id__volatile;
}



