/* valaccodecompiler.c generated by valac, the Vala compiler
 * generated from valaccodecompiler.vala, do not modify */

/* valaccodecompiler.vala
 *
 * Copyright (C) 2007-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "valacodegen.h"
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ValaParamSpecCCodeCompiler ValaParamSpecCCodeCompiler;

struct _ValaParamSpecCCodeCompiler {
	GParamSpec parent_instance;
};


static gpointer vala_ccode_compiler_parent_class = NULL;

static void vala_ccode_compiler_finalize (ValaCCodeCompiler * obj);


ValaCCodeCompiler* vala_ccode_compiler_construct (GType object_type) {
	ValaCCodeCompiler* self = NULL;
	self = (ValaCCodeCompiler*) g_type_create_instance (object_type);
	return self;
}


ValaCCodeCompiler* vala_ccode_compiler_new (void) {
	return vala_ccode_compiler_construct (VALA_TYPE_CCODE_COMPILER);
}


/**
 * Compile generated C code to object code and optionally link object
 * files.
 *
 * @param context a code context
 */
static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


void vala_ccode_compiler_compile (ValaCCodeCompiler* self, ValaCodeContext* context, const gchar* cc_command, gchar** cc_options, int cc_options_length1) {
	gchar* pc = NULL;
	gchar* _tmp0_;
	gchar* pkgflags = NULL;
	ValaCodeContext* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* cmdline = NULL;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	ValaCodeContext* _tmp27_;
	gboolean _tmp28_;
	gboolean _tmp29_;
	ValaCodeContext* _tmp32_;
	gboolean _tmp33_;
	gboolean _tmp34_;
	ValaList* source_files = NULL;
	ValaCodeContext* _tmp70_;
	ValaList* _tmp71_;
	ValaList* c_source_files = NULL;
	ValaCodeContext* _tmp95_;
	ValaList* _tmp96_;
	const gchar* _tmp115_;
	const gchar* _tmp116_;
	gchar* _tmp117_;
	gchar* _tmp118_;
	gchar* _tmp119_;
	gchar* _tmp120_;
	gchar* _tmp121_;
	gchar** _tmp122_;
	gint _tmp122__length1;
	ValaCodeContext* _tmp131_;
	gboolean _tmp132_;
	gboolean _tmp133_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = g_strdup (" gobject-2.0");
	pc = _tmp0_;
	{
		ValaList* _pkg_list = NULL;
		ValaCodeContext* _tmp1_;
		ValaList* _tmp2_;
		gint _pkg_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _pkg_index = 0;
		_tmp1_ = context;
		_tmp2_ = vala_code_context_get_packages (_tmp1_);
		_pkg_list = _tmp2_;
		_tmp3_ = _pkg_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_pkg_size = _tmp5_;
		_pkg_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gchar* pkg = NULL;
			ValaList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			ValaCodeContext* _tmp12_;
			const gchar* _tmp13_;
			gboolean _tmp14_;
			_tmp6_ = _pkg_index;
			_pkg_index = _tmp6_ + 1;
			_tmp7_ = _pkg_index;
			_tmp8_ = _pkg_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _pkg_list;
			_tmp10_ = _pkg_index;
			_tmp11_ = vala_list_get (_tmp9_, _tmp10_);
			pkg = (gchar*) _tmp11_;
			_tmp12_ = context;
			_tmp13_ = pkg;
			_tmp14_ = vala_code_context_pkg_config_exists (_tmp12_, _tmp13_);
			if (_tmp14_) {
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp15_ = pc;
				_tmp16_ = pkg;
				_tmp17_ = g_strconcat (" ", _tmp16_, NULL);
				_tmp18_ = _tmp17_;
				_tmp19_ = g_strconcat (_tmp15_, _tmp18_, NULL);
				_g_free0 (pc);
				pc = _tmp19_;
				_g_free0 (_tmp18_);
			}
			_g_free0 (pkg);
		}
		_vala_iterable_unref0 (_pkg_list);
	}
	_tmp20_ = context;
	_tmp21_ = pc;
	_tmp22_ = vala_code_context_pkg_config_compile_flags (_tmp20_, _tmp21_);
	pkgflags = _tmp22_;
	_tmp23_ = pkgflags;
	if (_tmp23_ == NULL) {
		_g_free0 (pkgflags);
		_g_free0 (pc);
		return;
	}
	_tmp24_ = cc_command;
	if (_tmp24_ == NULL) {
		cc_command = "cc";
	}
	_tmp25_ = cc_command;
	_tmp26_ = g_strdup (_tmp25_);
	cmdline = _tmp26_;
	_tmp27_ = context;
	_tmp28_ = vala_code_context_get_debug (_tmp27_);
	_tmp29_ = _tmp28_;
	if (_tmp29_) {
		const gchar* _tmp30_;
		gchar* _tmp31_;
		_tmp30_ = cmdline;
		_tmp31_ = g_strconcat (_tmp30_, " -g", NULL);
		_g_free0 (cmdline);
		cmdline = _tmp31_;
	}
	_tmp32_ = context;
	_tmp33_ = vala_code_context_get_compile_only (_tmp32_);
	_tmp34_ = _tmp33_;
	if (_tmp34_) {
		const gchar* _tmp35_;
		gchar* _tmp36_;
		_tmp35_ = cmdline;
		_tmp36_ = g_strconcat (_tmp35_, " -c", NULL);
		_g_free0 (cmdline);
		cmdline = _tmp36_;
	} else {
		ValaCodeContext* _tmp37_;
		const gchar* _tmp38_;
		const gchar* _tmp39_;
		_tmp37_ = context;
		_tmp38_ = vala_code_context_get_output (_tmp37_);
		_tmp39_ = _tmp38_;
		if (_tmp39_ != NULL) {
			gchar* output = NULL;
			ValaCodeContext* _tmp40_;
			const gchar* _tmp41_;
			const gchar* _tmp42_;
			gchar* _tmp43_;
			gboolean _tmp44_ = FALSE;
			gboolean _tmp45_ = FALSE;
			ValaCodeContext* _tmp46_;
			const gchar* _tmp47_;
			const gchar* _tmp48_;
			const gchar* _tmp63_;
			const gchar* _tmp64_;
			gchar* _tmp65_;
			gchar* _tmp66_;
			gchar* _tmp67_;
			gchar* _tmp68_;
			gchar* _tmp69_;
			_tmp40_ = context;
			_tmp41_ = vala_code_context_get_output (_tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = g_strdup (_tmp42_);
			output = _tmp43_;
			_tmp46_ = context;
			_tmp47_ = vala_code_context_get_directory (_tmp46_);
			_tmp48_ = _tmp47_;
			if (_tmp48_ != NULL) {
				ValaCodeContext* _tmp49_;
				const gchar* _tmp50_;
				const gchar* _tmp51_;
				_tmp49_ = context;
				_tmp50_ = vala_code_context_get_directory (_tmp49_);
				_tmp51_ = _tmp50_;
				_tmp45_ = g_strcmp0 (_tmp51_, "") != 0;
			} else {
				_tmp45_ = FALSE;
			}
			if (_tmp45_) {
				ValaCodeContext* _tmp52_;
				const gchar* _tmp53_;
				const gchar* _tmp54_;
				gboolean _tmp55_;
				_tmp52_ = context;
				_tmp53_ = vala_code_context_get_output (_tmp52_);
				_tmp54_ = _tmp53_;
				_tmp55_ = g_path_is_absolute (_tmp54_);
				_tmp44_ = !_tmp55_;
			} else {
				_tmp44_ = FALSE;
			}
			if (_tmp44_) {
				ValaCodeContext* _tmp56_;
				const gchar* _tmp57_;
				const gchar* _tmp58_;
				ValaCodeContext* _tmp59_;
				const gchar* _tmp60_;
				const gchar* _tmp61_;
				gchar* _tmp62_;
				_tmp56_ = context;
				_tmp57_ = vala_code_context_get_directory (_tmp56_);
				_tmp58_ = _tmp57_;
				_tmp59_ = context;
				_tmp60_ = vala_code_context_get_output (_tmp59_);
				_tmp61_ = _tmp60_;
				_tmp62_ = g_strdup_printf ("%s%c%s", _tmp58_, (gint) G_DIR_SEPARATOR, _tmp61_);
				_g_free0 (output);
				output = _tmp62_;
			}
			_tmp63_ = cmdline;
			_tmp64_ = output;
			_tmp65_ = g_shell_quote (_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = g_strconcat (" -o ", _tmp66_, NULL);
			_tmp68_ = _tmp67_;
			_tmp69_ = g_strconcat (_tmp63_, _tmp68_, NULL);
			_g_free0 (cmdline);
			cmdline = _tmp69_;
			_g_free0 (_tmp68_);
			_g_free0 (_tmp66_);
			_g_free0 (output);
		}
	}
	_tmp70_ = context;
	_tmp71_ = vala_code_context_get_source_files (_tmp70_);
	source_files = _tmp71_;
	{
		ValaList* _file_list = NULL;
		ValaList* _tmp72_;
		ValaList* _tmp73_;
		gint _file_size = 0;
		ValaList* _tmp74_;
		gint _tmp75_;
		gint _tmp76_;
		gint _file_index = 0;
		_tmp72_ = source_files;
		_tmp73_ = _vala_iterable_ref0 (_tmp72_);
		_file_list = _tmp73_;
		_tmp74_ = _file_list;
		_tmp75_ = vala_collection_get_size ((ValaCollection*) _tmp74_);
		_tmp76_ = _tmp75_;
		_file_size = _tmp76_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp77_;
			gint _tmp78_;
			gint _tmp79_;
			ValaSourceFile* file = NULL;
			ValaList* _tmp80_;
			gint _tmp81_;
			gpointer _tmp82_;
			ValaSourceFile* _tmp83_;
			ValaSourceFileType _tmp84_;
			ValaSourceFileType _tmp85_;
			_tmp77_ = _file_index;
			_file_index = _tmp77_ + 1;
			_tmp78_ = _file_index;
			_tmp79_ = _file_size;
			if (!(_tmp78_ < _tmp79_)) {
				break;
			}
			_tmp80_ = _file_list;
			_tmp81_ = _file_index;
			_tmp82_ = vala_list_get (_tmp80_, _tmp81_);
			file = (ValaSourceFile*) _tmp82_;
			_tmp83_ = file;
			_tmp84_ = vala_source_file_get_file_type (_tmp83_);
			_tmp85_ = _tmp84_;
			if (_tmp85_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
				const gchar* _tmp86_;
				ValaSourceFile* _tmp87_;
				gchar* _tmp88_;
				gchar* _tmp89_;
				gchar* _tmp90_;
				gchar* _tmp91_;
				gchar* _tmp92_;
				gchar* _tmp93_;
				gchar* _tmp94_;
				_tmp86_ = cmdline;
				_tmp87_ = file;
				_tmp88_ = vala_source_file_get_csource_filename (_tmp87_);
				_tmp89_ = _tmp88_;
				_tmp90_ = g_shell_quote (_tmp89_);
				_tmp91_ = _tmp90_;
				_tmp92_ = g_strconcat (" ", _tmp91_, NULL);
				_tmp93_ = _tmp92_;
				_tmp94_ = g_strconcat (_tmp86_, _tmp93_, NULL);
				_g_free0 (cmdline);
				cmdline = _tmp94_;
				_g_free0 (_tmp93_);
				_g_free0 (_tmp91_);
				_g_free0 (_tmp89_);
			}
			_vala_source_file_unref0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_tmp95_ = context;
	_tmp96_ = vala_code_context_get_c_source_files (_tmp95_);
	c_source_files = _tmp96_;
	{
		ValaList* _file_list = NULL;
		ValaList* _tmp97_;
		ValaList* _tmp98_;
		gint _file_size = 0;
		ValaList* _tmp99_;
		gint _tmp100_;
		gint _tmp101_;
		gint _file_index = 0;
		_tmp97_ = c_source_files;
		_tmp98_ = _vala_iterable_ref0 (_tmp97_);
		_file_list = _tmp98_;
		_tmp99_ = _file_list;
		_tmp100_ = vala_collection_get_size ((ValaCollection*) _tmp99_);
		_tmp101_ = _tmp100_;
		_file_size = _tmp101_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp102_;
			gint _tmp103_;
			gint _tmp104_;
			gchar* file = NULL;
			ValaList* _tmp105_;
			gint _tmp106_;
			gpointer _tmp107_;
			const gchar* _tmp108_;
			const gchar* _tmp109_;
			gchar* _tmp110_;
			gchar* _tmp111_;
			gchar* _tmp112_;
			gchar* _tmp113_;
			gchar* _tmp114_;
			_tmp102_ = _file_index;
			_file_index = _tmp102_ + 1;
			_tmp103_ = _file_index;
			_tmp104_ = _file_size;
			if (!(_tmp103_ < _tmp104_)) {
				break;
			}
			_tmp105_ = _file_list;
			_tmp106_ = _file_index;
			_tmp107_ = vala_list_get (_tmp105_, _tmp106_);
			file = (gchar*) _tmp107_;
			_tmp108_ = cmdline;
			_tmp109_ = file;
			_tmp110_ = g_shell_quote (_tmp109_);
			_tmp111_ = _tmp110_;
			_tmp112_ = g_strconcat (" ", _tmp111_, NULL);
			_tmp113_ = _tmp112_;
			_tmp114_ = g_strconcat (_tmp108_, _tmp113_, NULL);
			_g_free0 (cmdline);
			cmdline = _tmp114_;
			_g_free0 (_tmp113_);
			_g_free0 (_tmp111_);
			_g_free0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_tmp115_ = cmdline;
	_tmp116_ = pkgflags;
	_tmp117_ = string_strip (_tmp116_);
	_tmp118_ = _tmp117_;
	_tmp119_ = g_strconcat (" ", _tmp118_, NULL);
	_tmp120_ = _tmp119_;
	_tmp121_ = g_strconcat (_tmp115_, _tmp120_, NULL);
	_g_free0 (cmdline);
	cmdline = _tmp121_;
	_g_free0 (_tmp120_);
	_g_free0 (_tmp118_);
	_tmp122_ = cc_options;
	_tmp122__length1 = cc_options_length1;
	{
		gchar** cc_option_collection = NULL;
		gint cc_option_collection_length1 = 0;
		gint _cc_option_collection_size_ = 0;
		gint cc_option_it = 0;
		cc_option_collection = _tmp122_;
		cc_option_collection_length1 = _tmp122__length1;
		for (cc_option_it = 0; cc_option_it < _tmp122__length1; cc_option_it = cc_option_it + 1) {
			gchar* _tmp123_;
			gchar* cc_option = NULL;
			_tmp123_ = g_strdup (cc_option_collection[cc_option_it]);
			cc_option = _tmp123_;
			{
				const gchar* _tmp124_;
				const gchar* _tmp125_;
				gchar* _tmp126_;
				gchar* _tmp127_;
				gchar* _tmp128_;
				gchar* _tmp129_;
				gchar* _tmp130_;
				_tmp124_ = cmdline;
				_tmp125_ = cc_option;
				_tmp126_ = g_shell_quote (_tmp125_);
				_tmp127_ = _tmp126_;
				_tmp128_ = g_strconcat (" ", _tmp127_, NULL);
				_tmp129_ = _tmp128_;
				_tmp130_ = g_strconcat (_tmp124_, _tmp129_, NULL);
				_g_free0 (cmdline);
				cmdline = _tmp130_;
				_g_free0 (_tmp129_);
				_g_free0 (_tmp127_);
				_g_free0 (cc_option);
			}
		}
	}
	_tmp131_ = context;
	_tmp132_ = vala_code_context_get_verbose_mode (_tmp131_);
	_tmp133_ = _tmp132_;
	if (_tmp133_) {
		FILE* _tmp134_;
		const gchar* _tmp135_;
		_tmp134_ = stdout;
		_tmp135_ = cmdline;
		fprintf (_tmp134_, "%s\n", _tmp135_);
	}
	{
		gint exit_status = 0;
		const gchar* _tmp136_;
		gint _tmp137_ = 0;
		gint _tmp138_;
		_tmp136_ = cmdline;
		g_spawn_command_line_sync (_tmp136_, NULL, NULL, &_tmp137_, &_inner_error_);
		exit_status = _tmp137_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch3_g_spawn_error;
			}
			_vala_iterable_unref0 (c_source_files);
			_vala_iterable_unref0 (source_files);
			_g_free0 (cmdline);
			_g_free0 (pkgflags);
			_g_free0 (pc);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp138_ = exit_status;
		if (_tmp138_ != 0) {
			gint _tmp139_;
			gchar* _tmp140_;
			gchar* _tmp141_;
			_tmp139_ = exit_status;
			_tmp140_ = g_strdup_printf ("cc exited with status %d", _tmp139_);
			_tmp141_ = _tmp140_;
			vala_report_error (NULL, _tmp141_);
			_g_free0 (_tmp141_);
		}
	}
	goto __finally3;
	__catch3_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp142_;
		const gchar* _tmp143_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp142_ = e;
		_tmp143_ = _tmp142_->message;
		vala_report_error (NULL, _tmp143_);
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_vala_iterable_unref0 (c_source_files);
		_vala_iterable_unref0 (source_files);
		_g_free0 (cmdline);
		_g_free0 (pkgflags);
		_g_free0 (pc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		ValaList* _file_list = NULL;
		ValaList* _tmp144_;
		ValaList* _tmp145_;
		gint _file_size = 0;
		ValaList* _tmp146_;
		gint _tmp147_;
		gint _tmp148_;
		gint _file_index = 0;
		_tmp144_ = source_files;
		_tmp145_ = _vala_iterable_ref0 (_tmp144_);
		_file_list = _tmp145_;
		_tmp146_ = _file_list;
		_tmp147_ = vala_collection_get_size ((ValaCollection*) _tmp146_);
		_tmp148_ = _tmp147_;
		_file_size = _tmp148_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp149_;
			gint _tmp150_;
			gint _tmp151_;
			ValaSourceFile* file = NULL;
			ValaList* _tmp152_;
			gint _tmp153_;
			gpointer _tmp154_;
			ValaSourceFile* _tmp155_;
			ValaSourceFileType _tmp156_;
			ValaSourceFileType _tmp157_;
			_tmp149_ = _file_index;
			_file_index = _tmp149_ + 1;
			_tmp150_ = _file_index;
			_tmp151_ = _file_size;
			if (!(_tmp150_ < _tmp151_)) {
				break;
			}
			_tmp152_ = _file_list;
			_tmp153_ = _file_index;
			_tmp154_ = vala_list_get (_tmp152_, _tmp153_);
			file = (ValaSourceFile*) _tmp154_;
			_tmp155_ = file;
			_tmp156_ = vala_source_file_get_file_type (_tmp155_);
			_tmp157_ = _tmp156_;
			if (_tmp157_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
				ValaCodeContext* _tmp158_;
				gboolean _tmp159_;
				gboolean _tmp160_;
				_tmp158_ = context;
				_tmp159_ = vala_code_context_get_save_csources (_tmp158_);
				_tmp160_ = _tmp159_;
				if (!_tmp160_) {
					ValaSourceFile* _tmp161_;
					gchar* _tmp162_;
					gchar* _tmp163_;
					_tmp161_ = file;
					_tmp162_ = vala_source_file_get_csource_filename (_tmp161_);
					_tmp163_ = _tmp162_;
					g_unlink (_tmp163_);
					_g_free0 (_tmp163_);
				}
			}
			_vala_source_file_unref0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_vala_iterable_unref0 (c_source_files);
	_vala_iterable_unref0 (source_files);
	_g_free0 (cmdline);
	_g_free0 (pkgflags);
	_g_free0 (pc);
}


static void vala_value_ccode_compiler_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_ccode_compiler_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_ccode_compiler_unref (value->data[0].v_pointer);
	}
}


static void vala_value_ccode_compiler_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_ccode_compiler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_ccode_compiler_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_ccode_compiler_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaCCodeCompiler * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_ccode_compiler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_ccode_compiler_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaCCodeCompiler ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_ccode_compiler_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_ccode_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecCCodeCompiler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_CCODE_COMPILER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_ccode_compiler (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_COMPILER), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_ccode_compiler (GValue* value, gpointer v_object) {
	ValaCCodeCompiler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CCODE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_ccode_compiler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_ccode_compiler_unref (old);
	}
}


void vala_value_take_ccode_compiler (GValue* value, gpointer v_object) {
	ValaCCodeCompiler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CCODE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_ccode_compiler_unref (old);
	}
}


static void vala_ccode_compiler_class_init (ValaCCodeCompilerClass * klass) {
	vala_ccode_compiler_parent_class = g_type_class_peek_parent (klass);
	((ValaCCodeCompilerClass *) klass)->finalize = vala_ccode_compiler_finalize;
}


static void vala_ccode_compiler_instance_init (ValaCCodeCompiler * self) {
	self->ref_count = 1;
}


static void vala_ccode_compiler_finalize (ValaCCodeCompiler * obj) {
	ValaCCodeCompiler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CCODE_COMPILER, ValaCCodeCompiler);
	g_signal_handlers_destroy (self);
}


/**
 * Interface to the C compiler.
 */
GType vala_ccode_compiler_get_type (void) {
	static volatile gsize vala_ccode_compiler_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_compiler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_ccode_compiler_init, vala_value_ccode_compiler_free_value, vala_value_ccode_compiler_copy_value, vala_value_ccode_compiler_peek_pointer, "p", vala_value_ccode_compiler_collect_value, "p", vala_value_ccode_compiler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeCompilerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_compiler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeCompiler), 0, (GInstanceInitFunc) vala_ccode_compiler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_ccode_compiler_type_id;
		vala_ccode_compiler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCCodeCompiler", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_ccode_compiler_type_id__volatile, vala_ccode_compiler_type_id);
	}
	return vala_ccode_compiler_type_id__volatile;
}


gpointer vala_ccode_compiler_ref (gpointer instance) {
	ValaCCodeCompiler * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_ccode_compiler_unref (gpointer instance) {
	ValaCCodeCompiler * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_CCODE_COMPILER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



