/* valaassignment.c generated by valac, the Vala compiler
 * generated from valaassignment.vala, do not modify */

/* valaassignment.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaAssignmentPrivate {
	ValaAssignmentOperator _operator;
	ValaExpression* _left;
	ValaExpression* _right;
};


static gpointer vala_assignment_parent_class = NULL;

#define VALA_ASSIGNMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ASSIGNMENT, ValaAssignmentPrivate))
static void vala_assignment_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_assignment_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_assignment_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static gboolean vala_assignment_real_is_pure (ValaExpression* base);
static gboolean vala_assignment_real_is_accessible (ValaExpression* base, ValaSymbol* sym);
static gboolean vala_assignment_real_check (ValaCodeNode* base, ValaCodeContext* context);
static gboolean vala_assignment_is_array_add (ValaAssignment* self);
static void vala_assignment_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen);
static void vala_assignment_real_get_defined_variables (ValaCodeNode* base, ValaCollection* collection);
static void vala_assignment_real_get_used_variables (ValaCodeNode* base, ValaCollection* collection);
static void vala_assignment_finalize (ValaCodeNode * obj);


/**
 * Creates a new assignment.
 *
 * @param left             left hand side
 * @param operator         assignment operator
 * @param right            right hand side
 * @param source_reference reference to source code
 * @return                 newly created assignment
 */
ValaAssignment* vala_assignment_construct (GType object_type, ValaExpression* left, ValaExpression* right, ValaAssignmentOperator operator, ValaSourceReference* source_reference) {
	ValaAssignment* self = NULL;
	ValaExpression* _tmp0_;
	ValaAssignmentOperator _tmp1_;
	ValaSourceReference* _tmp2_;
	ValaExpression* _tmp3_;
	g_return_val_if_fail (left != NULL, NULL);
	g_return_val_if_fail (right != NULL, NULL);
	self = (ValaAssignment*) vala_expression_construct (object_type);
	_tmp0_ = right;
	vala_assignment_set_right (self, _tmp0_);
	_tmp1_ = operator;
	vala_assignment_set_operator (self, _tmp1_);
	_tmp2_ = source_reference;
	vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp2_);
	_tmp3_ = left;
	vala_assignment_set_left (self, _tmp3_);
	return self;
}


ValaAssignment* vala_assignment_new (ValaExpression* left, ValaExpression* right, ValaAssignmentOperator operator, ValaSourceReference* source_reference) {
	return vala_assignment_construct (VALA_TYPE_ASSIGNMENT, left, right, operator, source_reference);
}


static void vala_assignment_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaAssignment * self;
	ValaCodeVisitor* _tmp0_;
	ValaCodeVisitor* _tmp1_;
	self = (ValaAssignment*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_assignment (_tmp0_, self);
	_tmp1_ = visitor;
	vala_code_visitor_visit_expression (_tmp1_, (ValaExpression*) self);
}


static void vala_assignment_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCodeVisitor* _tmp2_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaCodeVisitor* _tmp5_;
	self = (ValaAssignment*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, _tmp2_);
	_tmp3_ = vala_assignment_get_right (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp4_, _tmp5_);
}


static void vala_assignment_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	self = (ValaAssignment*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_node;
	if (_tmp1_ == _tmp2_) {
		ValaExpression* _tmp3_;
		_tmp3_ = new_node;
		vala_assignment_set_left (self, _tmp3_);
	}
	_tmp4_ = vala_assignment_get_right (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = old_node;
	if (_tmp5_ == _tmp6_) {
		ValaExpression* _tmp7_;
		_tmp7_ = new_node;
		vala_assignment_set_right (self, _tmp7_);
	}
}


static gboolean vala_assignment_real_is_pure (ValaExpression* base) {
	ValaAssignment * self;
	gboolean result = FALSE;
	self = (ValaAssignment*) base;
	result = FALSE;
	return result;
}


static gboolean vala_assignment_real_is_accessible (ValaExpression* base, ValaSymbol* sym) {
	ValaAssignment * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaSymbol* _tmp3_;
	gboolean _tmp4_;
	self = (ValaAssignment*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_assignment_get_left (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = sym;
	_tmp4_ = vala_expression_is_accessible (_tmp2_, _tmp3_);
	if (_tmp4_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		ValaSymbol* _tmp7_;
		gboolean _tmp8_;
		_tmp5_ = vala_assignment_get_right (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = sym;
		_tmp8_ = vala_expression_is_accessible (_tmp6_, _tmp7_);
		_tmp0_ = _tmp8_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean vala_assignment_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaAssignment * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp103_;
	ValaExpression* _tmp104_;
	ValaExpression* _tmp105_;
	ValaExpression* _tmp106_;
	ValaCodeContext* _tmp107_;
	gboolean _tmp108_;
	ValaExpression* _tmp109_;
	ValaExpression* _tmp110_;
	ValaExpression* _tmp322_;
	ValaExpression* _tmp323_;
	ValaCodeContext* _tmp324_;
	gboolean _tmp325_;
	gboolean _tmp326_ = FALSE;
	ValaAssignmentOperator _tmp327_;
	ValaExpression* _tmp381_;
	ValaExpression* _tmp382_;
	ValaSymbol* _tmp383_;
	ValaSymbol* _tmp384_;
	ValaExpression* _tmp838_;
	ValaExpression* _tmp839_;
	ValaDataType* _tmp840_;
	ValaDataType* _tmp841_;
	ValaExpression* _tmp850_;
	ValaExpression* _tmp851_;
	ValaList* _tmp852_;
	ValaList* _tmp853_;
	ValaExpression* _tmp854_;
	ValaExpression* _tmp855_;
	ValaList* _tmp856_;
	ValaList* _tmp857_;
	gboolean _tmp858_;
	gboolean _tmp859_;
	self = (ValaAssignment*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp6_ = vala_assignment_get_left (self);
	_tmp7_ = _tmp6_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_TUPLE)) {
		ValaAssignmentOperator _tmp8_;
		_tmp8_ = self->priv->_operator;
		_tmp5_ = _tmp8_ == VALA_ASSIGNMENT_OPERATOR_SIMPLE;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaCodeNode* _tmp9_;
		ValaCodeNode* _tmp10_;
		_tmp9_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp10_ = _tmp9_;
		_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, VALA_TYPE_EXPRESSION_STATEMENT);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaTuple* tuple = NULL;
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		ValaTuple* _tmp13_;
		ValaLocalVariable* local = NULL;
		gchar* _tmp14_;
		gchar* _tmp15_;
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		ValaExpression* _tmp18_;
		ValaExpression* _tmp19_;
		ValaSourceReference* _tmp20_;
		ValaSourceReference* _tmp21_;
		ValaLocalVariable* _tmp22_;
		ValaLocalVariable* _tmp23_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp24_;
		ValaSourceReference* _tmp25_;
		ValaSourceReference* _tmp26_;
		ValaDeclarationStatement* _tmp27_;
		ValaDeclarationStatement* _tmp28_;
		ValaCodeContext* _tmp29_;
		ValaCodeContext* _tmp30_;
		ValaSemanticAnalyzer* _tmp31_;
		ValaSemanticAnalyzer* _tmp32_;
		ValaBlock* _tmp33_;
		ValaDeclarationStatement* _tmp34_;
		gint i = 0;
		ValaExpressionStatement* stmt = NULL;
		ValaCodeContext* _tmp89_;
		ValaSemanticAnalyzer* _tmp90_;
		ValaSemanticAnalyzer* _tmp91_;
		ValaList* _tmp92_;
		ValaCodeNode* _tmp93_;
		ValaCodeNode* _tmp94_;
		ValaExpressionStatement* _tmp95_;
		ValaExpression* _tmp96_;
		ValaExpression* _tmp97_;
		ValaExpressionStatement* _tmp98_;
		ValaExpression* _tmp99_;
		ValaExpression* _tmp100_;
		ValaCodeContext* _tmp101_;
		gboolean _tmp102_;
		_tmp11_ = vala_assignment_get_left (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_TUPLE, ValaTuple));
		tuple = _tmp13_;
		_tmp14_ = vala_code_node_get_temp_name ();
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_assignment_get_right (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_assignment_get_right (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_local_variable_new (NULL, _tmp15_, _tmp17_, _tmp21_);
		_tmp23_ = _tmp22_;
		_g_free0 (_tmp15_);
		local = _tmp23_;
		_tmp24_ = local;
		_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_declaration_statement_new ((ValaSymbol*) _tmp24_, _tmp26_);
		decl = _tmp27_;
		_tmp28_ = decl;
		_tmp29_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp28_, _tmp29_);
		_tmp30_ = context;
		_tmp31_ = vala_code_context_get_analyzer (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = _tmp32_->insert_block;
		_tmp34_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp33_, (ValaStatement*) _tmp34_);
		i = 0;
		stmt = NULL;
		{
			ValaList* _expr_list = NULL;
			ValaTuple* _tmp35_;
			ValaList* _tmp36_;
			gint _expr_size = 0;
			ValaList* _tmp37_;
			gint _tmp38_;
			gint _tmp39_;
			gint _expr_index = 0;
			_tmp35_ = tuple;
			_tmp36_ = vala_tuple_get_expressions (_tmp35_);
			_expr_list = _tmp36_;
			_tmp37_ = _expr_list;
			_tmp38_ = vala_collection_get_size ((ValaCollection*) _tmp37_);
			_tmp39_ = _tmp38_;
			_expr_size = _tmp39_;
			_expr_index = -1;
			while (TRUE) {
				gint _tmp40_;
				gint _tmp41_;
				gint _tmp42_;
				ValaExpression* expr = NULL;
				ValaList* _tmp43_;
				gint _tmp44_;
				gpointer _tmp45_;
				ValaExpressionStatement* _tmp46_;
				ValaMemberAccess* temp_access = NULL;
				ValaLocalVariable* _tmp54_;
				const gchar* _tmp55_;
				const gchar* _tmp56_;
				ValaExpression* _tmp57_;
				ValaExpression* _tmp58_;
				ValaSourceReference* _tmp59_;
				ValaSourceReference* _tmp60_;
				ValaMemberAccess* _tmp61_;
				ValaElementAccess* ea = NULL;
				ValaMemberAccess* _tmp62_;
				ValaExpression* _tmp63_;
				ValaSourceReference* _tmp64_;
				ValaSourceReference* _tmp65_;
				ValaElementAccess* _tmp66_;
				ValaElementAccess* _tmp67_;
				gint _tmp68_;
				gchar* _tmp69_;
				gchar* _tmp70_;
				ValaExpression* _tmp71_;
				ValaSourceReference* _tmp72_;
				ValaSourceReference* _tmp73_;
				ValaIntegerLiteral* _tmp74_;
				ValaIntegerLiteral* _tmp75_;
				ValaAssignment* assign = NULL;
				ValaExpression* _tmp76_;
				ValaElementAccess* _tmp77_;
				ValaAssignmentOperator _tmp78_;
				ValaExpression* _tmp79_;
				ValaSourceReference* _tmp80_;
				ValaSourceReference* _tmp81_;
				ValaAssignment* _tmp82_;
				ValaAssignment* _tmp83_;
				ValaExpression* _tmp84_;
				ValaSourceReference* _tmp85_;
				ValaSourceReference* _tmp86_;
				ValaExpressionStatement* _tmp87_;
				gint _tmp88_;
				_tmp40_ = _expr_index;
				_expr_index = _tmp40_ + 1;
				_tmp41_ = _expr_index;
				_tmp42_ = _expr_size;
				if (!(_tmp41_ < _tmp42_)) {
					break;
				}
				_tmp43_ = _expr_list;
				_tmp44_ = _expr_index;
				_tmp45_ = vala_list_get (_tmp43_, _tmp44_);
				expr = (ValaExpression*) _tmp45_;
				_tmp46_ = stmt;
				if (_tmp46_ != NULL) {
					ValaExpressionStatement* _tmp47_;
					ValaCodeContext* _tmp48_;
					ValaCodeContext* _tmp49_;
					ValaSemanticAnalyzer* _tmp50_;
					ValaSemanticAnalyzer* _tmp51_;
					ValaBlock* _tmp52_;
					ValaExpressionStatement* _tmp53_;
					_tmp47_ = stmt;
					_tmp48_ = context;
					vala_code_node_check ((ValaCodeNode*) _tmp47_, _tmp48_);
					_tmp49_ = context;
					_tmp50_ = vala_code_context_get_analyzer (_tmp49_);
					_tmp51_ = _tmp50_;
					_tmp52_ = _tmp51_->insert_block;
					_tmp53_ = stmt;
					vala_expression_insert_statement ((ValaExpression*) self, _tmp52_, (ValaStatement*) _tmp53_);
				}
				_tmp54_ = local;
				_tmp55_ = vala_symbol_get_name ((ValaSymbol*) _tmp54_);
				_tmp56_ = _tmp55_;
				_tmp57_ = vala_assignment_get_right (self);
				_tmp58_ = _tmp57_;
				_tmp59_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp58_);
				_tmp60_ = _tmp59_;
				_tmp61_ = vala_member_access_new_simple (_tmp56_, _tmp60_);
				temp_access = _tmp61_;
				_tmp62_ = temp_access;
				_tmp63_ = expr;
				_tmp64_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp63_);
				_tmp65_ = _tmp64_;
				_tmp66_ = vala_element_access_new ((ValaExpression*) _tmp62_, _tmp65_);
				ea = _tmp66_;
				_tmp67_ = ea;
				_tmp68_ = i;
				_tmp69_ = g_strdup_printf ("%i", _tmp68_);
				_tmp70_ = _tmp69_;
				_tmp71_ = expr;
				_tmp72_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp71_);
				_tmp73_ = _tmp72_;
				_tmp74_ = vala_integer_literal_new (_tmp70_, _tmp73_);
				_tmp75_ = _tmp74_;
				vala_element_access_append_index (_tmp67_, (ValaExpression*) _tmp75_);
				_vala_code_node_unref0 (_tmp75_);
				_g_free0 (_tmp70_);
				_tmp76_ = expr;
				_tmp77_ = ea;
				_tmp78_ = self->priv->_operator;
				_tmp79_ = expr;
				_tmp80_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp79_);
				_tmp81_ = _tmp80_;
				_tmp82_ = vala_assignment_new (_tmp76_, (ValaExpression*) _tmp77_, _tmp78_, _tmp81_);
				assign = _tmp82_;
				_tmp83_ = assign;
				_tmp84_ = expr;
				_tmp85_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp84_);
				_tmp86_ = _tmp85_;
				_tmp87_ = vala_expression_statement_new ((ValaExpression*) _tmp83_, _tmp86_);
				_vala_code_node_unref0 (stmt);
				stmt = _tmp87_;
				_tmp88_ = i;
				i = _tmp88_ + 1;
				_vala_code_node_unref0 (assign);
				_vala_code_node_unref0 (ea);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (expr);
			}
			_vala_iterable_unref0 (_expr_list);
		}
		_tmp89_ = context;
		_tmp90_ = vala_code_context_get_analyzer (_tmp89_);
		_tmp91_ = _tmp90_;
		_tmp92_ = _tmp91_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp92_, (ValaCodeNode*) self);
		_tmp93_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp94_ = _tmp93_;
		_tmp95_ = stmt;
		_tmp96_ = vala_expression_statement_get_expression (_tmp95_);
		_tmp97_ = _tmp96_;
		vala_code_node_replace_expression (_tmp94_, (ValaExpression*) self, _tmp97_);
		_tmp98_ = stmt;
		_tmp99_ = vala_expression_statement_get_expression (_tmp98_);
		_tmp100_ = _tmp99_;
		_tmp101_ = context;
		_tmp102_ = vala_code_node_check ((ValaCodeNode*) _tmp100_, _tmp101_);
		result = _tmp102_;
		_vala_code_node_unref0 (stmt);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		_vala_code_node_unref0 (tuple);
		return result;
	}
	_tmp103_ = vala_assignment_get_left (self);
	_tmp104_ = _tmp103_;
	vala_expression_set_lvalue (_tmp104_, TRUE);
	_tmp105_ = vala_assignment_get_left (self);
	_tmp106_ = _tmp105_;
	_tmp107_ = context;
	_tmp108_ = vala_code_node_check ((ValaCodeNode*) _tmp106_, _tmp107_);
	if (!_tmp108_) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp109_ = vala_assignment_get_left (self);
	_tmp110_ = _tmp109_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp110_, VALA_TYPE_MEMBER_ACCESS)) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp111_;
		ValaExpression* _tmp112_;
		ValaMemberAccess* _tmp113_;
		ValaMemberAccess* _tmp114_;
		ValaSymbol* _tmp115_;
		ValaSymbol* _tmp116_;
		gboolean _tmp119_ = FALSE;
		gboolean _tmp120_ = FALSE;
		gboolean _tmp121_ = FALSE;
		ValaMemberAccess* _tmp122_;
		ValaSymbol* _tmp123_;
		ValaSymbol* _tmp124_;
		ValaMemberAccess* _tmp145_;
		gboolean _tmp146_;
		gboolean _tmp147_;
		gboolean _tmp157_ = FALSE;
		ValaMemberAccess* _tmp158_;
		gboolean _tmp159_;
		gboolean _tmp160_;
		ValaMemberAccess* _tmp164_;
		ValaSymbol* _tmp165_;
		ValaSymbol* _tmp166_;
		_tmp111_ = vala_assignment_get_left (self);
		_tmp112_ = _tmp111_;
		_tmp113_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp112_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		ma = _tmp113_;
		_tmp114_ = ma;
		_tmp115_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp114_);
		_tmp116_ = _tmp115_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp116_, VALA_TYPE_CONSTANT)) {
			ValaSourceReference* _tmp117_;
			ValaSourceReference* _tmp118_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp117_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp118_ = _tmp117_;
			vala_report_error (_tmp118_, "Assignment to constant after initialization");
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp122_ = ma;
		_tmp123_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp122_);
		_tmp124_ = _tmp123_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp124_, VALA_TYPE_SIGNAL)) {
			_tmp121_ = TRUE;
		} else {
			ValaMemberAccess* _tmp125_;
			ValaSymbol* _tmp126_;
			ValaSymbol* _tmp127_;
			_tmp125_ = ma;
			_tmp126_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp125_);
			_tmp127_ = _tmp126_;
			_tmp121_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp127_, VALA_TYPE_DYNAMIC_PROPERTY);
		}
		if (!_tmp121_) {
			ValaMemberAccess* _tmp128_;
			ValaDataType* _tmp129_;
			ValaDataType* _tmp130_;
			_tmp128_ = ma;
			_tmp129_ = vala_expression_get_value_type ((ValaExpression*) _tmp128_);
			_tmp130_ = _tmp129_;
			_tmp120_ = _tmp130_ == NULL;
		} else {
			_tmp120_ = FALSE;
		}
		if (_tmp120_) {
			_tmp119_ = TRUE;
		} else {
			gboolean _tmp131_ = FALSE;
			gboolean _tmp132_ = FALSE;
			ValaMemberAccess* _tmp133_;
			ValaExpression* _tmp134_;
			ValaExpression* _tmp135_;
			_tmp133_ = ma;
			_tmp134_ = vala_member_access_get_inner (_tmp133_);
			_tmp135_ = _tmp134_;
			if (_tmp135_ == NULL) {
				ValaMemberAccess* _tmp136_;
				const gchar* _tmp137_;
				const gchar* _tmp138_;
				_tmp136_ = ma;
				_tmp137_ = vala_member_access_get_member_name (_tmp136_);
				_tmp138_ = _tmp137_;
				_tmp132_ = g_strcmp0 (_tmp138_, "this") == 0;
			} else {
				_tmp132_ = FALSE;
			}
			if (_tmp132_) {
				ValaCodeContext* _tmp139_;
				ValaSemanticAnalyzer* _tmp140_;
				ValaSemanticAnalyzer* _tmp141_;
				gboolean _tmp142_;
				_tmp139_ = context;
				_tmp140_ = vala_code_context_get_analyzer (_tmp139_);
				_tmp141_ = _tmp140_;
				_tmp142_ = vala_semantic_analyzer_is_in_instance_method (_tmp141_);
				_tmp131_ = _tmp142_;
			} else {
				_tmp131_ = FALSE;
			}
			_tmp119_ = _tmp131_;
		}
		if (_tmp119_) {
			ValaSourceReference* _tmp143_;
			ValaSourceReference* _tmp144_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp143_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp144_ = _tmp143_;
			vala_report_error (_tmp144_, "unsupported lvalue in assignment");
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp145_ = ma;
		_tmp146_ = vala_member_access_get_prototype_access (_tmp145_);
		_tmp147_ = _tmp146_;
		if (_tmp147_) {
			ValaSourceReference* _tmp148_;
			ValaSourceReference* _tmp149_;
			ValaMemberAccess* _tmp150_;
			ValaSymbol* _tmp151_;
			ValaSymbol* _tmp152_;
			gchar* _tmp153_;
			gchar* _tmp154_;
			gchar* _tmp155_;
			gchar* _tmp156_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp148_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp149_ = _tmp148_;
			_tmp150_ = ma;
			_tmp151_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp150_);
			_tmp152_ = _tmp151_;
			_tmp153_ = vala_symbol_get_full_name (_tmp152_);
			_tmp154_ = _tmp153_;
			_tmp155_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp154_);
			_tmp156_ = _tmp155_;
			vala_report_error (_tmp149_, _tmp156_);
			_g_free0 (_tmp156_);
			_g_free0 (_tmp154_);
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp158_ = ma;
		_tmp159_ = vala_code_node_get_error ((ValaCodeNode*) _tmp158_);
		_tmp160_ = _tmp159_;
		if (_tmp160_) {
			_tmp157_ = TRUE;
		} else {
			ValaMemberAccess* _tmp161_;
			ValaSymbol* _tmp162_;
			ValaSymbol* _tmp163_;
			_tmp161_ = ma;
			_tmp162_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp161_);
			_tmp163_ = _tmp162_;
			_tmp157_ = _tmp163_ == NULL;
		}
		if (_tmp157_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp164_ = ma;
		_tmp165_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp164_);
		_tmp166_ = _tmp165_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp166_, VALA_TYPE_DYNAMIC_SIGNAL)) {
			ValaCodeContext* _tmp167_;
			gboolean _tmp168_;
			gboolean _tmp169_;
			_tmp167_ = context;
			_tmp168_ = vala_code_context_get_deprecated (_tmp167_);
			_tmp169_ = _tmp168_;
			if (!_tmp169_) {
				ValaSourceReference* _tmp170_;
				ValaSourceReference* _tmp171_;
				_tmp170_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp171_ = _tmp170_;
				vala_report_warning (_tmp171_, "deprecated syntax, use `connect' method instead");
			}
		} else {
			ValaMemberAccess* _tmp172_;
			ValaSymbol* _tmp173_;
			ValaSymbol* _tmp174_;
			_tmp172_ = ma;
			_tmp173_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp172_);
			_tmp174_ = _tmp173_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp174_, VALA_TYPE_SIGNAL)) {
				ValaCodeContext* _tmp175_;
				gboolean _tmp176_;
				gboolean _tmp177_;
				ValaSignal* sig = NULL;
				ValaMemberAccess* _tmp180_;
				ValaSymbol* _tmp181_;
				ValaSymbol* _tmp182_;
				ValaSignal* _tmp183_;
				ValaExpression* _tmp184_;
				ValaExpression* _tmp185_;
				ValaSignal* _tmp186_;
				ValaMemberAccess* _tmp187_;
				ValaExpression* _tmp188_;
				ValaExpression* _tmp189_;
				ValaDataType* _tmp190_;
				ValaDataType* _tmp191_;
				ValaDelegate* _tmp192_;
				ValaDelegate* _tmp193_;
				ValaDelegateType* _tmp194_;
				ValaDelegateType* _tmp195_;
				_tmp175_ = context;
				_tmp176_ = vala_code_context_get_deprecated (_tmp175_);
				_tmp177_ = _tmp176_;
				if (!_tmp177_) {
					ValaSourceReference* _tmp178_;
					ValaSourceReference* _tmp179_;
					_tmp178_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp179_ = _tmp178_;
					vala_report_warning (_tmp179_, "deprecated syntax, use `connect' method instead");
				}
				_tmp180_ = ma;
				_tmp181_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp180_);
				_tmp182_ = _tmp181_;
				_tmp183_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp182_, VALA_TYPE_SIGNAL, ValaSignal));
				sig = _tmp183_;
				_tmp184_ = vala_assignment_get_right (self);
				_tmp185_ = _tmp184_;
				_tmp186_ = sig;
				_tmp187_ = ma;
				_tmp188_ = vala_member_access_get_inner (_tmp187_);
				_tmp189_ = _tmp188_;
				_tmp190_ = vala_expression_get_value_type (_tmp189_);
				_tmp191_ = _tmp190_;
				_tmp192_ = vala_signal_get_delegate (_tmp186_, _tmp191_, (ValaCodeNode*) self);
				_tmp193_ = _tmp192_;
				_tmp194_ = vala_delegate_type_new (_tmp193_);
				_tmp195_ = _tmp194_;
				vala_expression_set_target_type (_tmp185_, (ValaDataType*) _tmp195_);
				_vala_code_node_unref0 (_tmp195_);
				_vala_code_node_unref0 (_tmp193_);
				_vala_code_node_unref0 (sig);
			} else {
				ValaMemberAccess* _tmp196_;
				ValaSymbol* _tmp197_;
				ValaSymbol* _tmp198_;
				_tmp196_ = ma;
				_tmp197_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp196_);
				_tmp198_ = _tmp197_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp198_, VALA_TYPE_DYNAMIC_PROPERTY)) {
				} else {
					ValaExpression* _tmp199_;
					ValaExpression* _tmp200_;
					ValaMemberAccess* _tmp201_;
					ValaDataType* _tmp202_;
					ValaDataType* _tmp203_;
					ValaDataType* _tmp204_;
					ValaDataType* _tmp205_;
					ValaExpression* _tmp206_;
					ValaExpression* _tmp207_;
					ValaMemberAccess* _tmp208_;
					ValaDataType* _tmp209_;
					ValaDataType* _tmp210_;
					ValaDataType* _tmp211_;
					ValaDataType* _tmp212_;
					_tmp199_ = vala_assignment_get_right (self);
					_tmp200_ = _tmp199_;
					_tmp201_ = ma;
					_tmp202_ = vala_expression_get_formal_value_type ((ValaExpression*) _tmp201_);
					_tmp203_ = _tmp202_;
					_tmp204_ = vala_data_type_copy (_tmp203_);
					_tmp205_ = _tmp204_;
					vala_expression_set_formal_target_type (_tmp200_, _tmp205_);
					_vala_code_node_unref0 (_tmp205_);
					_tmp206_ = vala_assignment_get_right (self);
					_tmp207_ = _tmp206_;
					_tmp208_ = ma;
					_tmp209_ = vala_expression_get_value_type ((ValaExpression*) _tmp208_);
					_tmp210_ = _tmp209_;
					_tmp211_ = vala_data_type_copy (_tmp210_);
					_tmp212_ = _tmp211_;
					vala_expression_set_target_type (_tmp207_, _tmp212_);
					_vala_code_node_unref0 (_tmp212_);
				}
			}
		}
		_vala_code_node_unref0 (ma);
	} else {
		ValaExpression* _tmp213_;
		ValaExpression* _tmp214_;
		_tmp213_ = vala_assignment_get_left (self);
		_tmp214_ = _tmp213_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp214_, VALA_TYPE_ELEMENT_ACCESS)) {
			ValaElementAccess* ea = NULL;
			ValaExpression* _tmp215_;
			ValaExpression* _tmp216_;
			ValaElementAccess* _tmp217_;
			ValaElementAccess* _tmp218_;
			ValaExpression* _tmp219_;
			ValaExpression* _tmp220_;
			ValaDataType* _tmp221_;
			ValaDataType* _tmp222_;
			ValaTypeSymbol* _tmp223_;
			ValaTypeSymbol* _tmp224_;
			ValaCodeContext* _tmp225_;
			ValaSemanticAnalyzer* _tmp226_;
			ValaSemanticAnalyzer* _tmp227_;
			ValaDataType* _tmp228_;
			ValaTypeSymbol* _tmp229_;
			ValaTypeSymbol* _tmp230_;
			_tmp215_ = vala_assignment_get_left (self);
			_tmp216_ = _tmp215_;
			_tmp217_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp216_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
			ea = _tmp217_;
			_tmp218_ = ea;
			_tmp219_ = vala_element_access_get_container (_tmp218_);
			_tmp220_ = _tmp219_;
			_tmp221_ = vala_expression_get_value_type (_tmp220_);
			_tmp222_ = _tmp221_;
			_tmp223_ = vala_data_type_get_data_type (_tmp222_);
			_tmp224_ = _tmp223_;
			_tmp225_ = context;
			_tmp226_ = vala_code_context_get_analyzer (_tmp225_);
			_tmp227_ = _tmp226_;
			_tmp228_ = _tmp227_->string_type;
			_tmp229_ = vala_data_type_get_data_type (_tmp228_);
			_tmp230_ = _tmp229_;
			if (_tmp224_ == _tmp230_) {
				ValaElementAccess* _tmp231_;
				ValaSourceReference* _tmp232_;
				ValaSourceReference* _tmp233_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp231_ = ea;
				_tmp232_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp231_);
				_tmp233_ = _tmp232_;
				vala_report_error (_tmp233_, "strings are immutable");
				result = FALSE;
				_vala_code_node_unref0 (ea);
				return result;
			} else {
				gboolean _tmp234_ = FALSE;
				ValaElementAccess* _tmp235_;
				ValaExpression* _tmp236_;
				ValaExpression* _tmp237_;
				_tmp235_ = ea;
				_tmp236_ = vala_element_access_get_container (_tmp235_);
				_tmp237_ = _tmp236_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp237_, VALA_TYPE_MEMBER_ACCESS)) {
					ValaElementAccess* _tmp238_;
					ValaExpression* _tmp239_;
					ValaExpression* _tmp240_;
					ValaSymbol* _tmp241_;
					ValaSymbol* _tmp242_;
					_tmp238_ = ea;
					_tmp239_ = vala_element_access_get_container (_tmp238_);
					_tmp240_ = _tmp239_;
					_tmp241_ = vala_expression_get_symbol_reference (_tmp240_);
					_tmp242_ = _tmp241_;
					_tmp234_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp242_, VALA_TYPE_SIGNAL);
				} else {
					_tmp234_ = FALSE;
				}
				if (_tmp234_) {
					ValaMemberAccess* ma = NULL;
					ValaElementAccess* _tmp243_;
					ValaExpression* _tmp244_;
					ValaExpression* _tmp245_;
					ValaMemberAccess* _tmp246_;
					ValaSignal* sig = NULL;
					ValaElementAccess* _tmp247_;
					ValaExpression* _tmp248_;
					ValaExpression* _tmp249_;
					ValaSymbol* _tmp250_;
					ValaSymbol* _tmp251_;
					ValaSignal* _tmp252_;
					ValaExpression* _tmp253_;
					ValaExpression* _tmp254_;
					ValaSignal* _tmp255_;
					ValaMemberAccess* _tmp256_;
					ValaExpression* _tmp257_;
					ValaExpression* _tmp258_;
					ValaDataType* _tmp259_;
					ValaDataType* _tmp260_;
					ValaDelegate* _tmp261_;
					ValaDelegate* _tmp262_;
					ValaDelegateType* _tmp263_;
					ValaDelegateType* _tmp264_;
					_tmp243_ = ea;
					_tmp244_ = vala_element_access_get_container (_tmp243_);
					_tmp245_ = _tmp244_;
					_tmp246_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp245_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
					ma = _tmp246_;
					_tmp247_ = ea;
					_tmp248_ = vala_element_access_get_container (_tmp247_);
					_tmp249_ = _tmp248_;
					_tmp250_ = vala_expression_get_symbol_reference (_tmp249_);
					_tmp251_ = _tmp250_;
					_tmp252_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp251_, VALA_TYPE_SIGNAL, ValaSignal));
					sig = _tmp252_;
					_tmp253_ = vala_assignment_get_right (self);
					_tmp254_ = _tmp253_;
					_tmp255_ = sig;
					_tmp256_ = ma;
					_tmp257_ = vala_member_access_get_inner (_tmp256_);
					_tmp258_ = _tmp257_;
					_tmp259_ = vala_expression_get_value_type (_tmp258_);
					_tmp260_ = _tmp259_;
					_tmp261_ = vala_signal_get_delegate (_tmp255_, _tmp260_, (ValaCodeNode*) self);
					_tmp262_ = _tmp261_;
					_tmp263_ = vala_delegate_type_new (_tmp262_);
					_tmp264_ = _tmp263_;
					vala_expression_set_target_type (_tmp254_, (ValaDataType*) _tmp264_);
					_vala_code_node_unref0 (_tmp264_);
					_vala_code_node_unref0 (_tmp262_);
					_vala_code_node_unref0 (sig);
					_vala_code_node_unref0 (ma);
				} else {
					ValaElementAccess* _tmp265_;
					ValaExpression* _tmp266_;
					ValaExpression* _tmp267_;
					ValaDataType* _tmp268_;
					ValaDataType* _tmp269_;
					ValaSymbol* _tmp270_;
					ValaSymbol* _tmp271_;
					gboolean _tmp272_;
					_tmp265_ = ea;
					_tmp266_ = vala_element_access_get_container (_tmp265_);
					_tmp267_ = _tmp266_;
					_tmp268_ = vala_expression_get_value_type (_tmp267_);
					_tmp269_ = _tmp268_;
					_tmp270_ = vala_data_type_get_member (_tmp269_, "set");
					_tmp271_ = _tmp270_;
					_tmp272_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp271_, VALA_TYPE_METHOD);
					_vala_code_node_unref0 (_tmp271_);
					if (_tmp272_) {
						ValaMethodCall* set_call = NULL;
						ValaElementAccess* _tmp273_;
						ValaExpression* _tmp274_;
						ValaExpression* _tmp275_;
						ValaSourceReference* _tmp276_;
						ValaSourceReference* _tmp277_;
						ValaMemberAccess* _tmp278_;
						ValaMemberAccess* _tmp279_;
						ValaSourceReference* _tmp280_;
						ValaSourceReference* _tmp281_;
						ValaMethodCall* _tmp282_;
						ValaMethodCall* _tmp283_;
						ValaMethodCall* _tmp297_;
						ValaExpression* _tmp298_;
						ValaExpression* _tmp299_;
						ValaCodeNode* _tmp300_;
						ValaCodeNode* _tmp301_;
						ValaMethodCall* _tmp302_;
						ValaMethodCall* _tmp303_;
						ValaCodeContext* _tmp304_;
						gboolean _tmp305_;
						_tmp273_ = ea;
						_tmp274_ = vala_element_access_get_container (_tmp273_);
						_tmp275_ = _tmp274_;
						_tmp276_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp277_ = _tmp276_;
						_tmp278_ = vala_member_access_new (_tmp275_, "set", _tmp277_);
						_tmp279_ = _tmp278_;
						_tmp280_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp281_ = _tmp280_;
						_tmp282_ = vala_method_call_new ((ValaExpression*) _tmp279_, _tmp281_);
						_tmp283_ = _tmp282_;
						_vala_code_node_unref0 (_tmp279_);
						set_call = _tmp283_;
						{
							ValaList* _e_list = NULL;
							ValaElementAccess* _tmp284_;
							ValaList* _tmp285_;
							gint _e_size = 0;
							ValaList* _tmp286_;
							gint _tmp287_;
							gint _tmp288_;
							gint _e_index = 0;
							_tmp284_ = ea;
							_tmp285_ = vala_element_access_get_indices (_tmp284_);
							_e_list = _tmp285_;
							_tmp286_ = _e_list;
							_tmp287_ = vala_collection_get_size ((ValaCollection*) _tmp286_);
							_tmp288_ = _tmp287_;
							_e_size = _tmp288_;
							_e_index = -1;
							while (TRUE) {
								gint _tmp289_;
								gint _tmp290_;
								gint _tmp291_;
								ValaExpression* e = NULL;
								ValaList* _tmp292_;
								gint _tmp293_;
								gpointer _tmp294_;
								ValaMethodCall* _tmp295_;
								ValaExpression* _tmp296_;
								_tmp289_ = _e_index;
								_e_index = _tmp289_ + 1;
								_tmp290_ = _e_index;
								_tmp291_ = _e_size;
								if (!(_tmp290_ < _tmp291_)) {
									break;
								}
								_tmp292_ = _e_list;
								_tmp293_ = _e_index;
								_tmp294_ = vala_list_get (_tmp292_, _tmp293_);
								e = (ValaExpression*) _tmp294_;
								_tmp295_ = set_call;
								_tmp296_ = e;
								vala_method_call_add_argument (_tmp295_, _tmp296_);
								_vala_code_node_unref0 (e);
							}
							_vala_iterable_unref0 (_e_list);
						}
						_tmp297_ = set_call;
						_tmp298_ = vala_assignment_get_right (self);
						_tmp299_ = _tmp298_;
						vala_method_call_add_argument (_tmp297_, _tmp299_);
						_tmp300_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp301_ = _tmp300_;
						_tmp302_ = set_call;
						vala_code_node_replace_expression (_tmp301_, (ValaExpression*) self, (ValaExpression*) _tmp302_);
						_tmp303_ = set_call;
						_tmp304_ = context;
						_tmp305_ = vala_code_node_check ((ValaCodeNode*) _tmp303_, _tmp304_);
						result = _tmp305_;
						_vala_code_node_unref0 (set_call);
						_vala_code_node_unref0 (ea);
						return result;
					} else {
						ValaExpression* _tmp306_;
						ValaExpression* _tmp307_;
						ValaExpression* _tmp308_;
						ValaExpression* _tmp309_;
						ValaDataType* _tmp310_;
						ValaDataType* _tmp311_;
						_tmp306_ = vala_assignment_get_right (self);
						_tmp307_ = _tmp306_;
						_tmp308_ = vala_assignment_get_left (self);
						_tmp309_ = _tmp308_;
						_tmp310_ = vala_expression_get_value_type (_tmp309_);
						_tmp311_ = _tmp310_;
						vala_expression_set_target_type (_tmp307_, _tmp311_);
					}
				}
			}
			_vala_code_node_unref0 (ea);
		} else {
			ValaExpression* _tmp312_;
			ValaExpression* _tmp313_;
			_tmp312_ = vala_assignment_get_left (self);
			_tmp313_ = _tmp312_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp313_, VALA_TYPE_POINTER_INDIRECTION)) {
				ValaExpression* _tmp314_;
				ValaExpression* _tmp315_;
				ValaExpression* _tmp316_;
				ValaExpression* _tmp317_;
				ValaDataType* _tmp318_;
				ValaDataType* _tmp319_;
				_tmp314_ = vala_assignment_get_right (self);
				_tmp315_ = _tmp314_;
				_tmp316_ = vala_assignment_get_left (self);
				_tmp317_ = _tmp316_;
				_tmp318_ = vala_expression_get_value_type (_tmp317_);
				_tmp319_ = _tmp318_;
				vala_expression_set_target_type (_tmp315_, _tmp319_);
			} else {
				ValaSourceReference* _tmp320_;
				ValaSourceReference* _tmp321_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp320_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp321_ = _tmp320_;
				vala_report_error (_tmp321_, "unsupported lvalue in assignment");
				result = FALSE;
				return result;
			}
		}
	}
	_tmp322_ = vala_assignment_get_right (self);
	_tmp323_ = _tmp322_;
	_tmp324_ = context;
	_tmp325_ = vala_code_node_check ((ValaCodeNode*) _tmp323_, _tmp324_);
	if (!_tmp325_) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp327_ = self->priv->_operator;
	if (_tmp327_ != VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
		ValaExpression* _tmp328_;
		ValaExpression* _tmp329_;
		_tmp328_ = vala_assignment_get_left (self);
		_tmp329_ = _tmp328_;
		_tmp326_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp329_, VALA_TYPE_MEMBER_ACCESS);
	} else {
		_tmp326_ = FALSE;
	}
	if (_tmp326_) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp330_;
		ValaExpression* _tmp331_;
		ValaMemberAccess* _tmp332_;
		ValaMemberAccess* _tmp333_;
		ValaSymbol* _tmp334_;
		ValaSymbol* _tmp335_;
		_tmp330_ = vala_assignment_get_left (self);
		_tmp331_ = _tmp330_;
		_tmp332_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp331_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		ma = _tmp332_;
		_tmp333_ = ma;
		_tmp334_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp333_);
		_tmp335_ = _tmp334_;
		if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp335_, VALA_TYPE_SIGNAL)) {
			ValaMemberAccess* old_value = NULL;
			ValaMemberAccess* _tmp336_;
			ValaExpression* _tmp337_;
			ValaExpression* _tmp338_;
			ValaMemberAccess* _tmp339_;
			const gchar* _tmp340_;
			const gchar* _tmp341_;
			ValaMemberAccess* _tmp342_;
			ValaBinaryExpression* bin = NULL;
			ValaMemberAccess* _tmp343_;
			ValaExpression* _tmp344_;
			ValaExpression* _tmp345_;
			ValaSourceReference* _tmp346_;
			ValaSourceReference* _tmp347_;
			ValaBinaryExpression* _tmp348_;
			ValaBinaryExpression* _tmp349_;
			ValaExpression* _tmp350_;
			ValaExpression* _tmp351_;
			ValaDataType* _tmp352_;
			ValaDataType* _tmp353_;
			ValaExpression* _tmp354_;
			ValaExpression* _tmp355_;
			ValaExpression* _tmp356_;
			ValaExpression* _tmp357_;
			ValaDataType* _tmp358_;
			ValaDataType* _tmp359_;
			ValaDataType* _tmp360_;
			ValaDataType* _tmp361_;
			ValaExpression* _tmp362_;
			ValaExpression* _tmp363_;
			ValaDataType* _tmp364_;
			ValaDataType* _tmp365_;
			ValaAssignmentOperator _tmp366_;
			ValaBinaryExpression* _tmp377_;
			ValaExpression* _tmp378_;
			ValaExpression* _tmp379_;
			ValaCodeContext* _tmp380_;
			_tmp336_ = ma;
			_tmp337_ = vala_member_access_get_inner (_tmp336_);
			_tmp338_ = _tmp337_;
			_tmp339_ = ma;
			_tmp340_ = vala_member_access_get_member_name (_tmp339_);
			_tmp341_ = _tmp340_;
			_tmp342_ = vala_member_access_new (_tmp338_, _tmp341_, NULL);
			old_value = _tmp342_;
			_tmp343_ = old_value;
			_tmp344_ = vala_assignment_get_right (self);
			_tmp345_ = _tmp344_;
			_tmp346_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp347_ = _tmp346_;
			_tmp348_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_PLUS, (ValaExpression*) _tmp343_, _tmp345_, _tmp347_);
			bin = _tmp348_;
			_tmp349_ = bin;
			_tmp350_ = vala_assignment_get_right (self);
			_tmp351_ = _tmp350_;
			_tmp352_ = vala_expression_get_target_type (_tmp351_);
			_tmp353_ = _tmp352_;
			vala_expression_set_target_type ((ValaExpression*) _tmp349_, _tmp353_);
			_tmp354_ = vala_assignment_get_right (self);
			_tmp355_ = _tmp354_;
			_tmp356_ = vala_assignment_get_right (self);
			_tmp357_ = _tmp356_;
			_tmp358_ = vala_expression_get_target_type (_tmp357_);
			_tmp359_ = _tmp358_;
			_tmp360_ = vala_data_type_copy (_tmp359_);
			_tmp361_ = _tmp360_;
			vala_expression_set_target_type (_tmp355_, _tmp361_);
			_vala_code_node_unref0 (_tmp361_);
			_tmp362_ = vala_assignment_get_right (self);
			_tmp363_ = _tmp362_;
			_tmp364_ = vala_expression_get_target_type (_tmp363_);
			_tmp365_ = _tmp364_;
			vala_data_type_set_value_owned (_tmp365_, FALSE);
			_tmp366_ = self->priv->_operator;
			switch (_tmp366_) {
				case VALA_ASSIGNMENT_OPERATOR_BITWISE_OR:
				{
					ValaBinaryExpression* _tmp367_;
					_tmp367_ = bin;
					vala_binary_expression_set_operator (_tmp367_, VALA_BINARY_OPERATOR_BITWISE_OR);
					break;
				}
				case VALA_ASSIGNMENT_OPERATOR_BITWISE_AND:
				{
					ValaBinaryExpression* _tmp368_;
					_tmp368_ = bin;
					vala_binary_expression_set_operator (_tmp368_, VALA_BINARY_OPERATOR_BITWISE_AND);
					break;
				}
				case VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR:
				{
					ValaBinaryExpression* _tmp369_;
					_tmp369_ = bin;
					vala_binary_expression_set_operator (_tmp369_, VALA_BINARY_OPERATOR_BITWISE_XOR);
					break;
				}
				case VALA_ASSIGNMENT_OPERATOR_ADD:
				{
					ValaBinaryExpression* _tmp370_;
					_tmp370_ = bin;
					vala_binary_expression_set_operator (_tmp370_, VALA_BINARY_OPERATOR_PLUS);
					break;
				}
				case VALA_ASSIGNMENT_OPERATOR_SUB:
				{
					ValaBinaryExpression* _tmp371_;
					_tmp371_ = bin;
					vala_binary_expression_set_operator (_tmp371_, VALA_BINARY_OPERATOR_MINUS);
					break;
				}
				case VALA_ASSIGNMENT_OPERATOR_MUL:
				{
					ValaBinaryExpression* _tmp372_;
					_tmp372_ = bin;
					vala_binary_expression_set_operator (_tmp372_, VALA_BINARY_OPERATOR_MUL);
					break;
				}
				case VALA_ASSIGNMENT_OPERATOR_DIV:
				{
					ValaBinaryExpression* _tmp373_;
					_tmp373_ = bin;
					vala_binary_expression_set_operator (_tmp373_, VALA_BINARY_OPERATOR_DIV);
					break;
				}
				case VALA_ASSIGNMENT_OPERATOR_PERCENT:
				{
					ValaBinaryExpression* _tmp374_;
					_tmp374_ = bin;
					vala_binary_expression_set_operator (_tmp374_, VALA_BINARY_OPERATOR_MOD);
					break;
				}
				case VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT:
				{
					ValaBinaryExpression* _tmp375_;
					_tmp375_ = bin;
					vala_binary_expression_set_operator (_tmp375_, VALA_BINARY_OPERATOR_SHIFT_LEFT);
					break;
				}
				case VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT:
				{
					ValaBinaryExpression* _tmp376_;
					_tmp376_ = bin;
					vala_binary_expression_set_operator (_tmp376_, VALA_BINARY_OPERATOR_SHIFT_RIGHT);
					break;
				}
				default:
				break;
			}
			_tmp377_ = bin;
			vala_assignment_set_right (self, (ValaExpression*) _tmp377_);
			_tmp378_ = vala_assignment_get_right (self);
			_tmp379_ = _tmp378_;
			_tmp380_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp379_, _tmp380_);
			vala_assignment_set_operator (self, VALA_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_code_node_unref0 (bin);
			_vala_code_node_unref0 (old_value);
		}
		_vala_code_node_unref0 (ma);
	}
	_tmp381_ = vala_assignment_get_left (self);
	_tmp382_ = _tmp381_;
	_tmp383_ = vala_expression_get_symbol_reference (_tmp382_);
	_tmp384_ = _tmp383_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp384_, VALA_TYPE_SIGNAL)) {
		ValaSignal* sig = NULL;
		ValaExpression* _tmp385_;
		ValaExpression* _tmp386_;
		ValaSymbol* _tmp387_;
		ValaSymbol* _tmp388_;
		ValaSignal* _tmp389_;
		ValaMethod* m = NULL;
		ValaExpression* _tmp390_;
		ValaExpression* _tmp391_;
		ValaSymbol* _tmp392_;
		ValaSymbol* _tmp393_;
		ValaMethod* _tmp394_;
		ValaMethod* _tmp395_;
		ValaDynamicSignal* dynamic_sig = NULL;
		ValaSignal* _tmp400_;
		ValaDynamicSignal* _tmp401_;
		ValaMemberAccess* right_ma = NULL;
		ValaExpression* _tmp402_;
		ValaExpression* _tmp403_;
		ValaMemberAccess* _tmp404_;
		ValaDynamicSignal* _tmp405_;
		_tmp385_ = vala_assignment_get_left (self);
		_tmp386_ = _tmp385_;
		_tmp387_ = vala_expression_get_symbol_reference (_tmp386_);
		_tmp388_ = _tmp387_;
		_tmp389_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp388_, VALA_TYPE_SIGNAL, ValaSignal));
		sig = _tmp389_;
		_tmp390_ = vala_assignment_get_right (self);
		_tmp391_ = _tmp390_;
		_tmp392_ = vala_expression_get_symbol_reference (_tmp391_);
		_tmp393_ = _tmp392_;
		_tmp394_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp393_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp393_) : NULL);
		m = _tmp394_;
		_tmp395_ = m;
		if (_tmp395_ == NULL) {
			ValaExpression* _tmp396_;
			ValaExpression* _tmp397_;
			ValaSourceReference* _tmp398_;
			ValaSourceReference* _tmp399_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp396_ = vala_assignment_get_right (self);
			_tmp397_ = _tmp396_;
			_tmp398_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp397_);
			_tmp399_ = _tmp398_;
			vala_report_error (_tmp399_, "unsupported expression for signal handler");
			result = FALSE;
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (sig);
			return result;
		}
		_tmp400_ = sig;
		_tmp401_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp400_, VALA_TYPE_DYNAMIC_SIGNAL) ? ((ValaDynamicSignal*) _tmp400_) : NULL);
		dynamic_sig = _tmp401_;
		_tmp402_ = vala_assignment_get_right (self);
		_tmp403_ = _tmp402_;
		_tmp404_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp403_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp403_) : NULL);
		right_ma = _tmp404_;
		_tmp405_ = dynamic_sig;
		if (_tmp405_ != NULL) {
			gboolean first = FALSE;
			ValaExpression* _tmp426_;
			ValaExpression* _tmp427_;
			ValaSignal* _tmp428_;
			ValaSignal* _tmp429_;
			ValaSymbol* _tmp430_;
			ValaSymbol* _tmp431_;
			ValaObjectType* _tmp432_;
			ValaObjectType* _tmp433_;
			ValaDelegate* _tmp434_;
			ValaDelegate* _tmp435_;
			ValaDelegateType* _tmp436_;
			ValaDelegateType* _tmp437_;
			first = TRUE;
			{
				ValaList* _param_list = NULL;
				ValaDynamicSignal* _tmp406_;
				ValaExpression* _tmp407_;
				ValaExpression* _tmp408_;
				ValaDataType* _tmp409_;
				ValaDataType* _tmp410_;
				ValaList* _tmp411_;
				gint _param_size = 0;
				ValaList* _tmp412_;
				gint _tmp413_;
				gint _tmp414_;
				gint _param_index = 0;
				_tmp406_ = dynamic_sig;
				_tmp407_ = vala_dynamic_signal_get_handler (_tmp406_);
				_tmp408_ = _tmp407_;
				_tmp409_ = vala_expression_get_value_type (_tmp408_);
				_tmp410_ = _tmp409_;
				_tmp411_ = vala_data_type_get_parameters (_tmp410_);
				_param_list = _tmp411_;
				_tmp412_ = _param_list;
				_tmp413_ = vala_collection_get_size ((ValaCollection*) _tmp412_);
				_tmp414_ = _tmp413_;
				_param_size = _tmp414_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp415_;
					gint _tmp416_;
					gint _tmp417_;
					ValaParameter* param = NULL;
					ValaList* _tmp418_;
					gint _tmp419_;
					gpointer _tmp420_;
					gboolean _tmp421_;
					_tmp415_ = _param_index;
					_param_index = _tmp415_ + 1;
					_tmp416_ = _param_index;
					_tmp417_ = _param_size;
					if (!(_tmp416_ < _tmp417_)) {
						break;
					}
					_tmp418_ = _param_list;
					_tmp419_ = _param_index;
					_tmp420_ = vala_list_get (_tmp418_, _tmp419_);
					param = (ValaParameter*) _tmp420_;
					_tmp421_ = first;
					if (_tmp421_) {
						first = FALSE;
					} else {
						ValaDynamicSignal* _tmp422_;
						ValaParameter* _tmp423_;
						ValaParameter* _tmp424_;
						ValaParameter* _tmp425_;
						_tmp422_ = dynamic_sig;
						_tmp423_ = param;
						_tmp424_ = vala_parameter_copy (_tmp423_);
						_tmp425_ = _tmp424_;
						vala_callable_add_parameter ((ValaCallable*) _tmp422_, _tmp425_);
						_vala_code_node_unref0 (_tmp425_);
					}
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp426_ = vala_assignment_get_right (self);
			_tmp427_ = _tmp426_;
			_tmp428_ = sig;
			_tmp429_ = sig;
			_tmp430_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp429_);
			_tmp431_ = _tmp430_;
			_tmp432_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp431_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp433_ = _tmp432_;
			_tmp434_ = vala_signal_get_delegate (_tmp428_, (ValaDataType*) _tmp433_, (ValaCodeNode*) self);
			_tmp435_ = _tmp434_;
			_tmp436_ = vala_delegate_type_new (_tmp435_);
			_tmp437_ = _tmp436_;
			vala_expression_set_target_type (_tmp427_, (ValaDataType*) _tmp437_);
			_vala_code_node_unref0 (_tmp437_);
			_vala_code_node_unref0 (_tmp435_);
			_vala_code_node_unref0 (_tmp433_);
		} else {
			ValaExpression* _tmp438_;
			ValaExpression* _tmp439_;
			ValaDataType* _tmp440_;
			ValaDataType* _tmp441_;
			ValaExpression* _tmp442_;
			ValaExpression* _tmp443_;
			ValaDataType* _tmp444_;
			ValaDataType* _tmp445_;
			gboolean _tmp446_;
			_tmp438_ = vala_assignment_get_right (self);
			_tmp439_ = _tmp438_;
			_tmp440_ = vala_expression_get_value_type (_tmp439_);
			_tmp441_ = _tmp440_;
			_tmp442_ = vala_assignment_get_right (self);
			_tmp443_ = _tmp442_;
			_tmp444_ = vala_expression_get_target_type (_tmp443_);
			_tmp445_ = _tmp444_;
			_tmp446_ = vala_data_type_compatible (_tmp441_, _tmp445_);
			if (!_tmp446_) {
				ValaDelegateType* delegate_type = NULL;
				ValaExpression* _tmp447_;
				ValaExpression* _tmp448_;
				ValaDataType* _tmp449_;
				ValaDataType* _tmp450_;
				ValaDelegateType* _tmp451_;
				ValaExpression* _tmp452_;
				ValaExpression* _tmp453_;
				ValaSourceReference* _tmp454_;
				ValaSourceReference* _tmp455_;
				ValaExpression* _tmp456_;
				ValaExpression* _tmp457_;
				ValaDataType* _tmp458_;
				ValaDataType* _tmp459_;
				gchar* _tmp460_;
				gchar* _tmp461_;
				ValaExpression* _tmp462_;
				ValaExpression* _tmp463_;
				ValaDataType* _tmp464_;
				ValaDataType* _tmp465_;
				gchar* _tmp466_;
				gchar* _tmp467_;
				ValaDelegateType* _tmp468_;
				ValaMethod* _tmp469_;
				const gchar* _tmp470_;
				const gchar* _tmp471_;
				gchar* _tmp472_;
				gchar* _tmp473_;
				gchar* _tmp474_;
				gchar* _tmp475_;
				_tmp447_ = vala_assignment_get_right (self);
				_tmp448_ = _tmp447_;
				_tmp449_ = vala_expression_get_target_type (_tmp448_);
				_tmp450_ = _tmp449_;
				_tmp451_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp450_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				delegate_type = _tmp451_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp452_ = vala_assignment_get_right (self);
				_tmp453_ = _tmp452_;
				_tmp454_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp453_);
				_tmp455_ = _tmp454_;
				_tmp456_ = vala_assignment_get_right (self);
				_tmp457_ = _tmp456_;
				_tmp458_ = vala_expression_get_value_type (_tmp457_);
				_tmp459_ = _tmp458_;
				_tmp460_ = vala_code_node_to_string ((ValaCodeNode*) _tmp459_);
				_tmp461_ = _tmp460_;
				_tmp462_ = vala_assignment_get_right (self);
				_tmp463_ = _tmp462_;
				_tmp464_ = vala_expression_get_target_type (_tmp463_);
				_tmp465_ = _tmp464_;
				_tmp466_ = vala_code_node_to_string ((ValaCodeNode*) _tmp465_);
				_tmp467_ = _tmp466_;
				_tmp468_ = delegate_type;
				_tmp469_ = m;
				_tmp470_ = vala_symbol_get_name ((ValaSymbol*) _tmp469_);
				_tmp471_ = _tmp470_;
				_tmp472_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp468_, _tmp471_);
				_tmp473_ = _tmp472_;
				_tmp474_ = g_strdup_printf ("method `%s' is incompatible with signal `%s', expected `%s'", _tmp461_, _tmp467_, _tmp473_);
				_tmp475_ = _tmp474_;
				vala_report_error (_tmp455_, _tmp475_);
				_g_free0 (_tmp475_);
				_g_free0 (_tmp473_);
				_g_free0 (_tmp467_);
				_g_free0 (_tmp461_);
				result = FALSE;
				_vala_code_node_unref0 (delegate_type);
				_vala_code_node_unref0 (right_ma);
				_vala_code_node_unref0 (dynamic_sig);
				_vala_code_node_unref0 (m);
				_vala_code_node_unref0 (sig);
				return result;
			} else {
				gboolean _tmp476_ = FALSE;
				ValaMemberAccess* _tmp477_;
				_tmp477_ = right_ma;
				if (_tmp477_ != NULL) {
					ValaMemberAccess* _tmp478_;
					gboolean _tmp479_;
					gboolean _tmp480_;
					_tmp478_ = right_ma;
					_tmp479_ = vala_member_access_get_prototype_access (_tmp478_);
					_tmp480_ = _tmp479_;
					_tmp476_ = _tmp480_;
				} else {
					_tmp476_ = FALSE;
				}
				if (_tmp476_) {
					ValaExpression* _tmp481_;
					ValaExpression* _tmp482_;
					ValaSourceReference* _tmp483_;
					ValaSourceReference* _tmp484_;
					ValaMethod* _tmp485_;
					gchar* _tmp486_;
					gchar* _tmp487_;
					gchar* _tmp488_;
					gchar* _tmp489_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp481_ = vala_assignment_get_right (self);
					_tmp482_ = _tmp481_;
					_tmp483_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp482_);
					_tmp484_ = _tmp483_;
					_tmp485_ = m;
					_tmp486_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp485_);
					_tmp487_ = _tmp486_;
					_tmp488_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp487_);
					_tmp489_ = _tmp488_;
					vala_report_error (_tmp484_, _tmp489_);
					_g_free0 (_tmp489_);
					_g_free0 (_tmp487_);
					result = FALSE;
					_vala_code_node_unref0 (right_ma);
					_vala_code_node_unref0 (dynamic_sig);
					_vala_code_node_unref0 (m);
					_vala_code_node_unref0 (sig);
					return result;
				}
			}
		}
		_vala_code_node_unref0 (right_ma);
		_vala_code_node_unref0 (dynamic_sig);
		_vala_code_node_unref0 (m);
		_vala_code_node_unref0 (sig);
	} else {
		ValaExpression* _tmp490_;
		ValaExpression* _tmp491_;
		_tmp490_ = vala_assignment_get_left (self);
		_tmp491_ = _tmp490_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp491_, VALA_TYPE_MEMBER_ACCESS)) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp492_;
			ValaExpression* _tmp493_;
			ValaMemberAccess* _tmp494_;
			ValaMemberAccess* _tmp495_;
			ValaSymbol* _tmp496_;
			ValaSymbol* _tmp497_;
			gboolean _tmp642_ = FALSE;
			ValaExpression* _tmp643_;
			ValaExpression* _tmp644_;
			ValaDataType* _tmp645_;
			ValaDataType* _tmp646_;
			ValaMemberAccess* right_ma = NULL;
			ValaExpression* _tmp703_;
			ValaExpression* _tmp704_;
			ValaMemberAccess* _tmp705_;
			gboolean _tmp706_ = FALSE;
			ValaMemberAccess* _tmp707_;
			_tmp492_ = vala_assignment_get_left (self);
			_tmp493_ = _tmp492_;
			_tmp494_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp493_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp494_;
			_tmp495_ = ma;
			_tmp496_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp495_);
			_tmp497_ = _tmp496_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp497_, VALA_TYPE_PROPERTY)) {
				ValaProperty* prop = NULL;
				ValaMemberAccess* _tmp498_;
				ValaSymbol* _tmp499_;
				ValaSymbol* _tmp500_;
				ValaProperty* _tmp501_;
				ValaDynamicProperty* dynamic_prop = NULL;
				ValaProperty* _tmp502_;
				ValaDynamicProperty* _tmp503_;
				ValaDynamicProperty* _tmp504_;
				gboolean _tmp519_ = FALSE;
				ValaProperty* _tmp520_;
				ValaPropertyAccessor* _tmp521_;
				ValaPropertyAccessor* _tmp522_;
				_tmp498_ = ma;
				_tmp499_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp498_);
				_tmp500_ = _tmp499_;
				_tmp501_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp500_, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp501_;
				_tmp502_ = prop;
				_tmp503_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp502_, VALA_TYPE_DYNAMIC_PROPERTY) ? ((ValaDynamicProperty*) _tmp502_) : NULL);
				dynamic_prop = _tmp503_;
				_tmp504_ = dynamic_prop;
				if (_tmp504_ != NULL) {
					ValaDynamicProperty* _tmp505_;
					ValaExpression* _tmp506_;
					ValaExpression* _tmp507_;
					ValaDataType* _tmp508_;
					ValaDataType* _tmp509_;
					ValaDataType* _tmp510_;
					ValaDataType* _tmp511_;
					ValaExpression* _tmp512_;
					ValaExpression* _tmp513_;
					ValaDynamicProperty* _tmp514_;
					ValaDataType* _tmp515_;
					ValaDataType* _tmp516_;
					ValaDataType* _tmp517_;
					ValaDataType* _tmp518_;
					_tmp505_ = dynamic_prop;
					_tmp506_ = vala_assignment_get_right (self);
					_tmp507_ = _tmp506_;
					_tmp508_ = vala_expression_get_value_type (_tmp507_);
					_tmp509_ = _tmp508_;
					_tmp510_ = vala_data_type_copy (_tmp509_);
					_tmp511_ = _tmp510_;
					vala_property_set_property_type ((ValaProperty*) _tmp505_, _tmp511_);
					_vala_code_node_unref0 (_tmp511_);
					_tmp512_ = vala_assignment_get_left (self);
					_tmp513_ = _tmp512_;
					_tmp514_ = dynamic_prop;
					_tmp515_ = vala_property_get_property_type ((ValaProperty*) _tmp514_);
					_tmp516_ = _tmp515_;
					_tmp517_ = vala_data_type_copy (_tmp516_);
					_tmp518_ = _tmp517_;
					vala_expression_set_value_type (_tmp513_, _tmp518_);
					_vala_code_node_unref0 (_tmp518_);
				}
				_tmp520_ = prop;
				_tmp521_ = vala_property_get_set_accessor (_tmp520_);
				_tmp522_ = _tmp521_;
				if (_tmp522_ == NULL) {
					_tmp519_ = TRUE;
				} else {
					gboolean _tmp523_ = FALSE;
					ValaProperty* _tmp524_;
					ValaPropertyAccessor* _tmp525_;
					ValaPropertyAccessor* _tmp526_;
					gboolean _tmp527_;
					gboolean _tmp528_;
					_tmp524_ = prop;
					_tmp525_ = vala_property_get_set_accessor (_tmp524_);
					_tmp526_ = _tmp525_;
					_tmp527_ = vala_property_accessor_get_writable (_tmp526_);
					_tmp528_ = _tmp527_;
					if (!_tmp528_) {
						gboolean _tmp529_ = FALSE;
						ValaCodeContext* _tmp530_;
						ValaSemanticAnalyzer* _tmp531_;
						ValaSemanticAnalyzer* _tmp532_;
						ValaMethod* _tmp533_;
						ValaMethod* _tmp534_;
						gboolean _tmp535_;
						_tmp530_ = context;
						_tmp531_ = vala_code_context_get_analyzer (_tmp530_);
						_tmp532_ = _tmp531_;
						_tmp533_ = vala_semantic_analyzer_find_current_method (_tmp532_);
						_tmp534_ = _tmp533_;
						_tmp535_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp534_, VALA_TYPE_CREATION_METHOD);
						_vala_code_node_unref0 (_tmp534_);
						if (_tmp535_) {
							_tmp529_ = TRUE;
						} else {
							ValaCodeContext* _tmp536_;
							ValaSemanticAnalyzer* _tmp537_;
							ValaSemanticAnalyzer* _tmp538_;
							gboolean _tmp539_;
							_tmp536_ = context;
							_tmp537_ = vala_code_context_get_analyzer (_tmp536_);
							_tmp538_ = _tmp537_;
							_tmp539_ = vala_semantic_analyzer_is_in_constructor (_tmp538_);
							_tmp529_ = _tmp539_;
						}
						_tmp523_ = !_tmp529_;
					} else {
						_tmp523_ = FALSE;
					}
					_tmp519_ = _tmp523_;
				}
				if (_tmp519_) {
					ValaMemberAccess* _tmp540_;
					ValaMemberAccess* _tmp541_;
					ValaSourceReference* _tmp542_;
					ValaSourceReference* _tmp543_;
					ValaProperty* _tmp544_;
					gchar* _tmp545_;
					gchar* _tmp546_;
					gchar* _tmp547_;
					gchar* _tmp548_;
					_tmp540_ = ma;
					vala_code_node_set_error ((ValaCodeNode*) _tmp540_, TRUE);
					_tmp541_ = ma;
					_tmp542_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp541_);
					_tmp543_ = _tmp542_;
					_tmp544_ = prop;
					_tmp545_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp544_);
					_tmp546_ = _tmp545_;
					_tmp547_ = g_strdup_printf ("Property `%s' is read-only", _tmp546_);
					_tmp548_ = _tmp547_;
					vala_report_error (_tmp543_, _tmp548_);
					_g_free0 (_tmp548_);
					_g_free0 (_tmp546_);
					result = FALSE;
					_vala_code_node_unref0 (dynamic_prop);
					_vala_code_node_unref0 (prop);
					_vala_code_node_unref0 (ma);
					return result;
				} else {
					gboolean _tmp549_ = FALSE;
					gboolean _tmp550_ = FALSE;
					ValaCodeContext* _tmp551_;
					gboolean _tmp552_;
					gboolean _tmp553_;
					_tmp551_ = context;
					_tmp552_ = vala_code_context_get_deprecated (_tmp551_);
					_tmp553_ = _tmp552_;
					if (!_tmp553_) {
						ValaProperty* _tmp554_;
						ValaPropertyAccessor* _tmp555_;
						ValaPropertyAccessor* _tmp556_;
						gboolean _tmp557_;
						gboolean _tmp558_;
						_tmp554_ = prop;
						_tmp555_ = vala_property_get_set_accessor (_tmp554_);
						_tmp556_ = _tmp555_;
						_tmp557_ = vala_property_accessor_get_writable (_tmp556_);
						_tmp558_ = _tmp557_;
						_tmp550_ = !_tmp558_;
					} else {
						_tmp550_ = FALSE;
					}
					if (_tmp550_) {
						ValaCodeContext* _tmp559_;
						ValaSemanticAnalyzer* _tmp560_;
						ValaSemanticAnalyzer* _tmp561_;
						ValaMethod* _tmp562_;
						ValaMethod* _tmp563_;
						_tmp559_ = context;
						_tmp560_ = vala_code_context_get_analyzer (_tmp559_);
						_tmp561_ = _tmp560_;
						_tmp562_ = vala_semantic_analyzer_find_current_method (_tmp561_);
						_tmp563_ = _tmp562_;
						_tmp549_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp563_, VALA_TYPE_CREATION_METHOD);
						_vala_code_node_unref0 (_tmp563_);
					} else {
						_tmp549_ = FALSE;
					}
					if (_tmp549_) {
						ValaMemberAccess* _tmp564_;
						ValaExpression* _tmp565_;
						ValaExpression* _tmp566_;
						ValaSymbol* _tmp567_;
						ValaSymbol* _tmp568_;
						ValaCodeContext* _tmp569_;
						ValaSemanticAnalyzer* _tmp570_;
						ValaSemanticAnalyzer* _tmp571_;
						ValaMethod* _tmp572_;
						ValaMethod* _tmp573_;
						ValaParameter* _tmp574_;
						ValaParameter* _tmp575_;
						gboolean _tmp576_;
						_tmp564_ = ma;
						_tmp565_ = vala_member_access_get_inner (_tmp564_);
						_tmp566_ = _tmp565_;
						_tmp567_ = vala_expression_get_symbol_reference (_tmp566_);
						_tmp568_ = _tmp567_;
						_tmp569_ = context;
						_tmp570_ = vala_code_context_get_analyzer (_tmp569_);
						_tmp571_ = _tmp570_;
						_tmp572_ = vala_semantic_analyzer_find_current_method (_tmp571_);
						_tmp573_ = _tmp572_;
						_tmp574_ = vala_method_get_this_parameter (_tmp573_);
						_tmp575_ = _tmp574_;
						_tmp576_ = _tmp568_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp575_, VALA_TYPE_SYMBOL, ValaSymbol);
						_vala_code_node_unref0 (_tmp573_);
						if (_tmp576_) {
							ValaMemberAccess* _tmp577_;
							ValaSourceReference* _tmp578_;
							ValaSourceReference* _tmp579_;
							ValaProperty* _tmp580_;
							gchar* _tmp581_;
							gchar* _tmp582_;
							gchar* _tmp583_;
							gchar* _tmp584_;
							_tmp577_ = ma;
							_tmp578_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp577_);
							_tmp579_ = _tmp578_;
							_tmp580_ = prop;
							_tmp581_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp580_);
							_tmp582_ = _tmp581_;
							_tmp583_ = g_strdup_printf ("Property `%s' is read-only", _tmp582_);
							_tmp584_ = _tmp583_;
							vala_report_error (_tmp579_, _tmp584_);
							_g_free0 (_tmp584_);
							_g_free0 (_tmp582_);
							result = FALSE;
							_vala_code_node_unref0 (dynamic_prop);
							_vala_code_node_unref0 (prop);
							_vala_code_node_unref0 (ma);
							return result;
						} else {
							ValaMemberAccess* _tmp585_;
							ValaSourceReference* _tmp586_;
							ValaSourceReference* _tmp587_;
							_tmp585_ = ma;
							_tmp586_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp585_);
							_tmp587_ = _tmp586_;
							vala_report_error (_tmp587_, "Cannot assign to construct-only properties, use Object (property: valu" \
"e) constructor chain up");
							result = FALSE;
							_vala_code_node_unref0 (dynamic_prop);
							_vala_code_node_unref0 (prop);
							_vala_code_node_unref0 (ma);
							return result;
						}
					}
				}
				_vala_code_node_unref0 (dynamic_prop);
				_vala_code_node_unref0 (prop);
			} else {
				gboolean _tmp588_ = FALSE;
				ValaMemberAccess* _tmp589_;
				ValaSymbol* _tmp590_;
				ValaSymbol* _tmp591_;
				_tmp589_ = ma;
				_tmp590_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp589_);
				_tmp591_ = _tmp590_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp591_, VALA_TYPE_VARIABLE)) {
					ValaExpression* _tmp592_;
					ValaExpression* _tmp593_;
					ValaDataType* _tmp594_;
					ValaDataType* _tmp595_;
					_tmp592_ = vala_assignment_get_right (self);
					_tmp593_ = _tmp592_;
					_tmp594_ = vala_expression_get_value_type (_tmp593_);
					_tmp595_ = _tmp594_;
					_tmp588_ = _tmp595_ == NULL;
				} else {
					_tmp588_ = FALSE;
				}
				if (_tmp588_) {
					ValaVariable* variable = NULL;
					ValaMemberAccess* _tmp596_;
					ValaSymbol* _tmp597_;
					ValaSymbol* _tmp598_;
					ValaVariable* _tmp599_;
					gboolean _tmp600_ = FALSE;
					ValaExpression* _tmp601_;
					ValaExpression* _tmp602_;
					ValaSymbol* _tmp603_;
					ValaSymbol* _tmp604_;
					_tmp596_ = ma;
					_tmp597_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp596_);
					_tmp598_ = _tmp597_;
					_tmp599_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp598_, VALA_TYPE_VARIABLE, ValaVariable));
					variable = _tmp599_;
					_tmp601_ = vala_assignment_get_right (self);
					_tmp602_ = _tmp601_;
					_tmp603_ = vala_expression_get_symbol_reference (_tmp602_);
					_tmp604_ = _tmp603_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp604_, VALA_TYPE_METHOD)) {
						ValaVariable* _tmp605_;
						ValaDataType* _tmp606_;
						ValaDataType* _tmp607_;
						_tmp605_ = variable;
						_tmp606_ = vala_variable_get_variable_type (_tmp605_);
						_tmp607_ = _tmp606_;
						_tmp600_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp607_, VALA_TYPE_DELEGATE_TYPE);
					} else {
						_tmp600_ = FALSE;
					}
					if (_tmp600_) {
						ValaMethod* m = NULL;
						ValaExpression* _tmp608_;
						ValaExpression* _tmp609_;
						ValaSymbol* _tmp610_;
						ValaSymbol* _tmp611_;
						ValaMethod* _tmp612_;
						ValaDelegateType* dt = NULL;
						ValaVariable* _tmp613_;
						ValaDataType* _tmp614_;
						ValaDataType* _tmp615_;
						ValaDelegateType* _tmp616_;
						ValaDelegate* cb = NULL;
						ValaDelegateType* _tmp617_;
						ValaDelegate* _tmp618_;
						ValaDelegate* _tmp619_;
						ValaDelegate* _tmp620_;
						ValaDelegate* _tmp621_;
						ValaMethod* _tmp622_;
						ValaDelegateType* _tmp623_;
						gboolean _tmp624_;
						ValaExpression* _tmp635_;
						ValaExpression* _tmp636_;
						ValaVariable* _tmp637_;
						ValaDataType* _tmp638_;
						ValaDataType* _tmp639_;
						_tmp608_ = vala_assignment_get_right (self);
						_tmp609_ = _tmp608_;
						_tmp610_ = vala_expression_get_symbol_reference (_tmp609_);
						_tmp611_ = _tmp610_;
						_tmp612_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp611_, VALA_TYPE_METHOD, ValaMethod));
						m = _tmp612_;
						_tmp613_ = variable;
						_tmp614_ = vala_variable_get_variable_type (_tmp613_);
						_tmp615_ = _tmp614_;
						_tmp616_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp615_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						dt = _tmp616_;
						_tmp617_ = dt;
						_tmp618_ = vala_delegate_type_get_delegate_symbol (_tmp617_);
						_tmp619_ = _tmp618_;
						_tmp620_ = _vala_code_node_ref0 (_tmp619_);
						cb = _tmp620_;
						_tmp621_ = cb;
						_tmp622_ = m;
						_tmp623_ = dt;
						_tmp624_ = vala_delegate_matches_method (_tmp621_, _tmp622_, (ValaDataType*) _tmp623_);
						if (!_tmp624_) {
							ValaSourceReference* _tmp625_;
							ValaSourceReference* _tmp626_;
							ValaMethod* _tmp627_;
							gchar* _tmp628_;
							gchar* _tmp629_;
							ValaDelegate* _tmp630_;
							gchar* _tmp631_;
							gchar* _tmp632_;
							gchar* _tmp633_;
							gchar* _tmp634_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp625_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp626_ = _tmp625_;
							_tmp627_ = m;
							_tmp628_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp627_);
							_tmp629_ = _tmp628_;
							_tmp630_ = cb;
							_tmp631_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp630_);
							_tmp632_ = _tmp631_;
							_tmp633_ = g_strdup_printf ("declaration of method `%s' doesn't match declaration of callback `%s'", _tmp629_, _tmp632_);
							_tmp634_ = _tmp633_;
							vala_report_error (_tmp626_, _tmp634_);
							_g_free0 (_tmp634_);
							_g_free0 (_tmp632_);
							_g_free0 (_tmp629_);
							result = FALSE;
							_vala_code_node_unref0 (cb);
							_vala_code_node_unref0 (dt);
							_vala_code_node_unref0 (m);
							_vala_code_node_unref0 (variable);
							_vala_code_node_unref0 (ma);
							return result;
						}
						_tmp635_ = vala_assignment_get_right (self);
						_tmp636_ = _tmp635_;
						_tmp637_ = variable;
						_tmp638_ = vala_variable_get_variable_type (_tmp637_);
						_tmp639_ = _tmp638_;
						vala_expression_set_value_type (_tmp636_, _tmp639_);
						_vala_code_node_unref0 (cb);
						_vala_code_node_unref0 (dt);
						_vala_code_node_unref0 (m);
					} else {
						ValaSourceReference* _tmp640_;
						ValaSourceReference* _tmp641_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp640_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp641_ = _tmp640_;
						vala_report_error (_tmp641_, "Assignment: Invalid assignment attempt");
						result = FALSE;
						_vala_code_node_unref0 (variable);
						_vala_code_node_unref0 (ma);
						return result;
					}
					_vala_code_node_unref0 (variable);
				}
			}
			_tmp643_ = vala_assignment_get_left (self);
			_tmp644_ = _tmp643_;
			_tmp645_ = vala_expression_get_value_type (_tmp644_);
			_tmp646_ = _tmp645_;
			if (_tmp646_ != NULL) {
				ValaExpression* _tmp647_;
				ValaExpression* _tmp648_;
				ValaDataType* _tmp649_;
				ValaDataType* _tmp650_;
				_tmp647_ = vala_assignment_get_right (self);
				_tmp648_ = _tmp647_;
				_tmp649_ = vala_expression_get_value_type (_tmp648_);
				_tmp650_ = _tmp649_;
				_tmp642_ = _tmp650_ != NULL;
			} else {
				_tmp642_ = FALSE;
			}
			if (_tmp642_) {
				ValaExpression* _tmp651_;
				ValaExpression* _tmp652_;
				ValaDataType* _tmp653_;
				ValaDataType* _tmp654_;
				ValaExpression* _tmp655_;
				ValaExpression* _tmp656_;
				ValaDataType* _tmp657_;
				ValaDataType* _tmp658_;
				gboolean _tmp659_;
				ValaMemberAccess* _tmp676_;
				ValaSymbol* _tmp677_;
				ValaSymbol* _tmp678_;
				_tmp651_ = vala_assignment_get_right (self);
				_tmp652_ = _tmp651_;
				_tmp653_ = vala_expression_get_value_type (_tmp652_);
				_tmp654_ = _tmp653_;
				_tmp655_ = vala_assignment_get_left (self);
				_tmp656_ = _tmp655_;
				_tmp657_ = vala_expression_get_value_type (_tmp656_);
				_tmp658_ = _tmp657_;
				_tmp659_ = vala_data_type_compatible (_tmp654_, _tmp658_);
				if (!_tmp659_) {
					ValaSourceReference* _tmp660_;
					ValaSourceReference* _tmp661_;
					ValaExpression* _tmp662_;
					ValaExpression* _tmp663_;
					ValaDataType* _tmp664_;
					ValaDataType* _tmp665_;
					gchar* _tmp666_;
					gchar* _tmp667_;
					ValaExpression* _tmp668_;
					ValaExpression* _tmp669_;
					ValaDataType* _tmp670_;
					ValaDataType* _tmp671_;
					gchar* _tmp672_;
					gchar* _tmp673_;
					gchar* _tmp674_;
					gchar* _tmp675_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp660_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp661_ = _tmp660_;
					_tmp662_ = vala_assignment_get_right (self);
					_tmp663_ = _tmp662_;
					_tmp664_ = vala_expression_get_value_type (_tmp663_);
					_tmp665_ = _tmp664_;
					_tmp666_ = vala_code_node_to_string ((ValaCodeNode*) _tmp665_);
					_tmp667_ = _tmp666_;
					_tmp668_ = vala_assignment_get_left (self);
					_tmp669_ = _tmp668_;
					_tmp670_ = vala_expression_get_value_type (_tmp669_);
					_tmp671_ = _tmp670_;
					_tmp672_ = vala_code_node_to_string ((ValaCodeNode*) _tmp671_);
					_tmp673_ = _tmp672_;
					_tmp674_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp667_, _tmp673_);
					_tmp675_ = _tmp674_;
					vala_report_error (_tmp661_, _tmp675_);
					_g_free0 (_tmp675_);
					_g_free0 (_tmp673_);
					_g_free0 (_tmp667_);
					result = FALSE;
					_vala_code_node_unref0 (ma);
					return result;
				}
				_tmp676_ = ma;
				_tmp677_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp676_);
				_tmp678_ = _tmp677_;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp678_, VALA_TYPE_PROPERTY)) {
					ValaExpression* _tmp679_;
					ValaExpression* _tmp680_;
					ValaDataType* _tmp681_;
					ValaDataType* _tmp682_;
					gboolean _tmp683_;
					_tmp679_ = vala_assignment_get_right (self);
					_tmp680_ = _tmp679_;
					_tmp681_ = vala_expression_get_value_type (_tmp680_);
					_tmp682_ = _tmp681_;
					_tmp683_ = vala_data_type_is_disposable (_tmp682_);
					if (_tmp683_) {
						gboolean _tmp684_ = FALSE;
						ValaExpression* _tmp685_;
						ValaExpression* _tmp686_;
						ValaDataType* _tmp687_;
						ValaDataType* _tmp688_;
						_tmp685_ = vala_assignment_get_left (self);
						_tmp686_ = _tmp685_;
						_tmp687_ = vala_expression_get_value_type (_tmp686_);
						_tmp688_ = _tmp687_;
						if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp688_, VALA_TYPE_POINTER_TYPE)) {
							ValaExpression* _tmp689_;
							ValaExpression* _tmp690_;
							ValaDataType* _tmp691_;
							ValaDataType* _tmp692_;
							gboolean _tmp693_;
							gboolean _tmp694_;
							_tmp689_ = vala_assignment_get_left (self);
							_tmp690_ = _tmp689_;
							_tmp691_ = vala_expression_get_value_type (_tmp690_);
							_tmp692_ = _tmp691_;
							_tmp693_ = vala_data_type_get_value_owned (_tmp692_);
							_tmp694_ = _tmp693_;
							_tmp684_ = !_tmp694_;
						} else {
							_tmp684_ = FALSE;
						}
						if (_tmp684_) {
							ValaSourceReference* _tmp695_;
							ValaSourceReference* _tmp696_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp695_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp696_ = _tmp695_;
							vala_report_error (_tmp696_, "Invalid assignment from owned expression to unowned variable");
						}
					} else {
						ValaExpression* _tmp697_;
						ValaExpression* _tmp698_;
						ValaDataType* _tmp699_;
						ValaDataType* _tmp700_;
						gboolean _tmp701_;
						gboolean _tmp702_;
						_tmp697_ = vala_assignment_get_left (self);
						_tmp698_ = _tmp697_;
						_tmp699_ = vala_expression_get_value_type (_tmp698_);
						_tmp700_ = _tmp699_;
						_tmp701_ = vala_data_type_get_value_owned (_tmp700_);
						_tmp702_ = _tmp701_;
						if (_tmp702_) {
						}
					}
				}
			}
			_tmp703_ = vala_assignment_get_right (self);
			_tmp704_ = _tmp703_;
			_tmp705_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp704_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp704_) : NULL);
			right_ma = _tmp705_;
			_tmp707_ = right_ma;
			if (_tmp707_ != NULL) {
				ValaMemberAccess* _tmp708_;
				ValaSymbol* _tmp709_;
				ValaSymbol* _tmp710_;
				ValaMemberAccess* _tmp711_;
				ValaSymbol* _tmp712_;
				ValaSymbol* _tmp713_;
				_tmp708_ = ma;
				_tmp709_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp708_);
				_tmp710_ = _tmp709_;
				_tmp711_ = right_ma;
				_tmp712_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp711_);
				_tmp713_ = _tmp712_;
				_tmp706_ = _tmp710_ == _tmp713_;
			} else {
				_tmp706_ = FALSE;
			}
			if (_tmp706_) {
				gboolean _tmp714_ = FALSE;
				ValaMemberAccess* _tmp715_;
				ValaSymbol* _tmp716_;
				ValaSymbol* _tmp717_;
				_tmp715_ = ma;
				_tmp716_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp715_);
				_tmp717_ = _tmp716_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp717_, VALA_TYPE_LOCAL_VARIABLE)) {
					_tmp714_ = TRUE;
				} else {
					ValaMemberAccess* _tmp718_;
					ValaSymbol* _tmp719_;
					ValaSymbol* _tmp720_;
					_tmp718_ = ma;
					_tmp719_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp718_);
					_tmp720_ = _tmp719_;
					_tmp714_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp720_, VALA_TYPE_PARAMETER);
				}
				if (_tmp714_) {
					ValaSourceReference* _tmp721_;
					ValaSourceReference* _tmp722_;
					_tmp721_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp722_ = _tmp721_;
					vala_report_warning (_tmp722_, "Assignment to same variable");
				} else {
					ValaMemberAccess* _tmp723_;
					ValaSymbol* _tmp724_;
					ValaSymbol* _tmp725_;
					_tmp723_ = ma;
					_tmp724_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp723_);
					_tmp725_ = _tmp724_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp725_, VALA_TYPE_FIELD)) {
						ValaField* f = NULL;
						ValaMemberAccess* _tmp726_;
						ValaSymbol* _tmp727_;
						ValaSymbol* _tmp728_;
						ValaField* _tmp729_;
						ValaField* _tmp730_;
						ValaMemberBinding _tmp731_;
						ValaMemberBinding _tmp732_;
						_tmp726_ = ma;
						_tmp727_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp726_);
						_tmp728_ = _tmp727_;
						_tmp729_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp728_, VALA_TYPE_FIELD, ValaField));
						f = _tmp729_;
						_tmp730_ = f;
						_tmp731_ = vala_field_get_binding (_tmp730_);
						_tmp732_ = _tmp731_;
						if (_tmp732_ == VALA_MEMBER_BINDING_STATIC) {
							ValaSourceReference* _tmp733_;
							ValaSourceReference* _tmp734_;
							_tmp733_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp734_ = _tmp733_;
							vala_report_warning (_tmp734_, "Assignment to same variable");
						} else {
							ValaMemberAccess* ma_inner = NULL;
							ValaMemberAccess* _tmp735_;
							ValaExpression* _tmp736_;
							ValaExpression* _tmp737_;
							ValaMemberAccess* _tmp738_;
							ValaMemberAccess* right_ma_inner = NULL;
							ValaMemberAccess* _tmp739_;
							ValaExpression* _tmp740_;
							ValaExpression* _tmp741_;
							ValaMemberAccess* _tmp742_;
							gboolean _tmp743_ = FALSE;
							gboolean _tmp744_ = FALSE;
							gboolean _tmp745_ = FALSE;
							gboolean _tmp746_ = FALSE;
							gboolean _tmp747_ = FALSE;
							ValaMemberAccess* _tmp748_;
							_tmp735_ = ma;
							_tmp736_ = vala_member_access_get_inner (_tmp735_);
							_tmp737_ = _tmp736_;
							_tmp738_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp737_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp737_) : NULL);
							ma_inner = _tmp738_;
							_tmp739_ = right_ma;
							_tmp740_ = vala_member_access_get_inner (_tmp739_);
							_tmp741_ = _tmp740_;
							_tmp742_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp741_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp741_) : NULL);
							right_ma_inner = _tmp742_;
							_tmp748_ = ma_inner;
							if (_tmp748_ != NULL) {
								ValaMemberAccess* _tmp749_;
								const gchar* _tmp750_;
								const gchar* _tmp751_;
								_tmp749_ = ma_inner;
								_tmp750_ = vala_member_access_get_member_name (_tmp749_);
								_tmp751_ = _tmp750_;
								_tmp747_ = g_strcmp0 (_tmp751_, "this") == 0;
							} else {
								_tmp747_ = FALSE;
							}
							if (_tmp747_) {
								ValaMemberAccess* _tmp752_;
								ValaExpression* _tmp753_;
								ValaExpression* _tmp754_;
								_tmp752_ = ma_inner;
								_tmp753_ = vala_member_access_get_inner (_tmp752_);
								_tmp754_ = _tmp753_;
								_tmp746_ = _tmp754_ == NULL;
							} else {
								_tmp746_ = FALSE;
							}
							if (_tmp746_) {
								ValaMemberAccess* _tmp755_;
								_tmp755_ = right_ma_inner;
								_tmp745_ = _tmp755_ != NULL;
							} else {
								_tmp745_ = FALSE;
							}
							if (_tmp745_) {
								ValaMemberAccess* _tmp756_;
								const gchar* _tmp757_;
								const gchar* _tmp758_;
								_tmp756_ = right_ma_inner;
								_tmp757_ = vala_member_access_get_member_name (_tmp756_);
								_tmp758_ = _tmp757_;
								_tmp744_ = g_strcmp0 (_tmp758_, "this") == 0;
							} else {
								_tmp744_ = FALSE;
							}
							if (_tmp744_) {
								ValaMemberAccess* _tmp759_;
								ValaExpression* _tmp760_;
								ValaExpression* _tmp761_;
								_tmp759_ = right_ma_inner;
								_tmp760_ = vala_member_access_get_inner (_tmp759_);
								_tmp761_ = _tmp760_;
								_tmp743_ = _tmp761_ == NULL;
							} else {
								_tmp743_ = FALSE;
							}
							if (_tmp743_) {
								ValaSourceReference* _tmp762_;
								ValaSourceReference* _tmp763_;
								_tmp762_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp763_ = _tmp762_;
								vala_report_warning (_tmp763_, "Assignment to same variable");
							}
							_vala_code_node_unref0 (right_ma_inner);
							_vala_code_node_unref0 (ma_inner);
						}
						_vala_code_node_unref0 (f);
					}
				}
			}
			_vala_code_node_unref0 (right_ma);
			_vala_code_node_unref0 (ma);
		} else {
			ValaExpression* _tmp764_;
			ValaExpression* _tmp765_;
			_tmp764_ = vala_assignment_get_left (self);
			_tmp765_ = _tmp764_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp765_, VALA_TYPE_ELEMENT_ACCESS)) {
				ValaElementAccess* ea = NULL;
				ValaExpression* _tmp766_;
				ValaExpression* _tmp767_;
				ValaElementAccess* _tmp768_;
				ValaExpression* _tmp769_;
				ValaExpression* _tmp770_;
				ValaDataType* _tmp771_;
				ValaDataType* _tmp772_;
				ValaExpression* _tmp773_;
				ValaExpression* _tmp774_;
				ValaDataType* _tmp775_;
				ValaDataType* _tmp776_;
				gboolean _tmp777_;
				ValaExpression* _tmp794_;
				ValaExpression* _tmp795_;
				ValaDataType* _tmp796_;
				ValaDataType* _tmp797_;
				gboolean _tmp798_;
				_tmp766_ = vala_assignment_get_left (self);
				_tmp767_ = _tmp766_;
				_tmp768_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp767_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
				ea = _tmp768_;
				_tmp769_ = vala_assignment_get_right (self);
				_tmp770_ = _tmp769_;
				_tmp771_ = vala_expression_get_value_type (_tmp770_);
				_tmp772_ = _tmp771_;
				_tmp773_ = vala_assignment_get_left (self);
				_tmp774_ = _tmp773_;
				_tmp775_ = vala_expression_get_value_type (_tmp774_);
				_tmp776_ = _tmp775_;
				_tmp777_ = vala_data_type_compatible (_tmp772_, _tmp776_);
				if (!_tmp777_) {
					ValaSourceReference* _tmp778_;
					ValaSourceReference* _tmp779_;
					ValaExpression* _tmp780_;
					ValaExpression* _tmp781_;
					ValaDataType* _tmp782_;
					ValaDataType* _tmp783_;
					gchar* _tmp784_;
					gchar* _tmp785_;
					ValaExpression* _tmp786_;
					ValaExpression* _tmp787_;
					ValaDataType* _tmp788_;
					ValaDataType* _tmp789_;
					gchar* _tmp790_;
					gchar* _tmp791_;
					gchar* _tmp792_;
					gchar* _tmp793_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp778_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp779_ = _tmp778_;
					_tmp780_ = vala_assignment_get_right (self);
					_tmp781_ = _tmp780_;
					_tmp782_ = vala_expression_get_value_type (_tmp781_);
					_tmp783_ = _tmp782_;
					_tmp784_ = vala_code_node_to_string ((ValaCodeNode*) _tmp783_);
					_tmp785_ = _tmp784_;
					_tmp786_ = vala_assignment_get_left (self);
					_tmp787_ = _tmp786_;
					_tmp788_ = vala_expression_get_value_type (_tmp787_);
					_tmp789_ = _tmp788_;
					_tmp790_ = vala_code_node_to_string ((ValaCodeNode*) _tmp789_);
					_tmp791_ = _tmp790_;
					_tmp792_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp785_, _tmp791_);
					_tmp793_ = _tmp792_;
					vala_report_error (_tmp779_, _tmp793_);
					_g_free0 (_tmp793_);
					_g_free0 (_tmp791_);
					_g_free0 (_tmp785_);
					result = FALSE;
					_vala_code_node_unref0 (ea);
					return result;
				}
				_tmp794_ = vala_assignment_get_right (self);
				_tmp795_ = _tmp794_;
				_tmp796_ = vala_expression_get_value_type (_tmp795_);
				_tmp797_ = _tmp796_;
				_tmp798_ = vala_data_type_is_disposable (_tmp797_);
				if (_tmp798_) {
					ValaDataType* element_type = NULL;
					ValaElementAccess* _tmp799_;
					ValaExpression* _tmp800_;
					ValaExpression* _tmp801_;
					ValaDataType* _tmp802_;
					ValaDataType* _tmp803_;
					gboolean _tmp825_ = FALSE;
					ValaDataType* _tmp826_;
					_tmp799_ = ea;
					_tmp800_ = vala_element_access_get_container (_tmp799_);
					_tmp801_ = _tmp800_;
					_tmp802_ = vala_expression_get_value_type (_tmp801_);
					_tmp803_ = _tmp802_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp803_, VALA_TYPE_ARRAY_TYPE)) {
						ValaArrayType* array_type = NULL;
						ValaElementAccess* _tmp804_;
						ValaExpression* _tmp805_;
						ValaExpression* _tmp806_;
						ValaDataType* _tmp807_;
						ValaDataType* _tmp808_;
						ValaArrayType* _tmp809_;
						ValaArrayType* _tmp810_;
						ValaDataType* _tmp811_;
						ValaDataType* _tmp812_;
						ValaDataType* _tmp813_;
						_tmp804_ = ea;
						_tmp805_ = vala_element_access_get_container (_tmp804_);
						_tmp806_ = _tmp805_;
						_tmp807_ = vala_expression_get_value_type (_tmp806_);
						_tmp808_ = _tmp807_;
						_tmp809_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp808_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp809_;
						_tmp810_ = array_type;
						_tmp811_ = vala_array_type_get_element_type (_tmp810_);
						_tmp812_ = _tmp811_;
						_tmp813_ = _vala_code_node_ref0 (_tmp812_);
						_vala_code_node_unref0 (element_type);
						element_type = _tmp813_;
						_vala_code_node_unref0 (array_type);
					} else {
						ValaList* args = NULL;
						ValaElementAccess* _tmp814_;
						ValaExpression* _tmp815_;
						ValaExpression* _tmp816_;
						ValaDataType* _tmp817_;
						ValaDataType* _tmp818_;
						ValaList* _tmp819_;
						ValaList* _tmp820_;
						gint _tmp821_;
						gint _tmp822_;
						ValaList* _tmp823_;
						gpointer _tmp824_;
						_tmp814_ = ea;
						_tmp815_ = vala_element_access_get_container (_tmp814_);
						_tmp816_ = _tmp815_;
						_tmp817_ = vala_expression_get_value_type (_tmp816_);
						_tmp818_ = _tmp817_;
						_tmp819_ = vala_data_type_get_type_arguments (_tmp818_);
						args = _tmp819_;
						_tmp820_ = args;
						_tmp821_ = vala_collection_get_size ((ValaCollection*) _tmp820_);
						_tmp822_ = _tmp821_;
						_vala_assert (_tmp822_ == 1, "args.size == 1");
						_tmp823_ = args;
						_tmp824_ = vala_list_get (_tmp823_, 0);
						_vala_code_node_unref0 (element_type);
						element_type = (ValaDataType*) _tmp824_;
						_vala_iterable_unref0 (args);
					}
					_tmp826_ = element_type;
					if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp826_, VALA_TYPE_POINTER_TYPE)) {
						ValaDataType* _tmp827_;
						gboolean _tmp828_;
						gboolean _tmp829_;
						_tmp827_ = element_type;
						_tmp828_ = vala_data_type_get_value_owned (_tmp827_);
						_tmp829_ = _tmp828_;
						_tmp825_ = !_tmp829_;
					} else {
						_tmp825_ = FALSE;
					}
					if (_tmp825_) {
						ValaSourceReference* _tmp830_;
						ValaSourceReference* _tmp831_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp830_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp831_ = _tmp830_;
						vala_report_error (_tmp831_, "Invalid assignment from owned expression to unowned variable");
						result = FALSE;
						_vala_code_node_unref0 (element_type);
						_vala_code_node_unref0 (ea);
						return result;
					}
					_vala_code_node_unref0 (element_type);
				} else {
					ValaExpression* _tmp832_;
					ValaExpression* _tmp833_;
					ValaDataType* _tmp834_;
					ValaDataType* _tmp835_;
					gboolean _tmp836_;
					gboolean _tmp837_;
					_tmp832_ = vala_assignment_get_left (self);
					_tmp833_ = _tmp832_;
					_tmp834_ = vala_expression_get_value_type (_tmp833_);
					_tmp835_ = _tmp834_;
					_tmp836_ = vala_data_type_get_value_owned (_tmp835_);
					_tmp837_ = _tmp836_;
					if (_tmp837_) {
					}
				}
				_vala_code_node_unref0 (ea);
			} else {
				result = TRUE;
				return result;
			}
		}
	}
	_tmp838_ = vala_assignment_get_left (self);
	_tmp839_ = _tmp838_;
	_tmp840_ = vala_expression_get_value_type (_tmp839_);
	_tmp841_ = _tmp840_;
	if (_tmp841_ != NULL) {
		ValaExpression* _tmp842_;
		ValaExpression* _tmp843_;
		ValaDataType* _tmp844_;
		ValaDataType* _tmp845_;
		ValaDataType* _tmp846_;
		ValaDataType* _tmp847_;
		ValaDataType* _tmp848_;
		ValaDataType* _tmp849_;
		_tmp842_ = vala_assignment_get_left (self);
		_tmp843_ = _tmp842_;
		_tmp844_ = vala_expression_get_value_type (_tmp843_);
		_tmp845_ = _tmp844_;
		_tmp846_ = vala_data_type_copy (_tmp845_);
		_tmp847_ = _tmp846_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp847_);
		_vala_code_node_unref0 (_tmp847_);
		_tmp848_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp849_ = _tmp848_;
		vala_data_type_set_value_owned (_tmp849_, FALSE);
	} else {
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
	}
	_tmp850_ = vala_assignment_get_left (self);
	_tmp851_ = _tmp850_;
	_tmp852_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp851_);
	_tmp853_ = _tmp852_;
	vala_code_node_add_error_types ((ValaCodeNode*) self, _tmp853_);
	_vala_iterable_unref0 (_tmp853_);
	_tmp854_ = vala_assignment_get_right (self);
	_tmp855_ = _tmp854_;
	_tmp856_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp855_);
	_tmp857_ = _tmp856_;
	vala_code_node_add_error_types ((ValaCodeNode*) self, _tmp857_);
	_vala_iterable_unref0 (_tmp857_);
	_tmp858_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp859_ = _tmp858_;
	result = !_tmp859_;
	return result;
}


static gboolean vala_assignment_is_array_add (ValaAssignment* self) {
	gboolean result = FALSE;
	ValaBinaryExpression* binary = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaBinaryExpression* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaBinaryExpression* _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_assignment_get_right (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_BINARY_EXPRESSION) ? ((ValaBinaryExpression*) _tmp1_) : NULL);
	binary = _tmp2_;
	_tmp4_ = binary;
	if (_tmp4_ != NULL) {
		ValaBinaryExpression* _tmp5_;
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp5_ = binary;
		_tmp6_ = vala_binary_expression_get_left (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_expression_get_value_type (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaBinaryExpression* _tmp10_;
		ValaBinaryOperator _tmp11_;
		ValaBinaryOperator _tmp12_;
		_tmp10_ = binary;
		_tmp11_ = vala_binary_expression_get_operator (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ == VALA_BINARY_OPERATOR_PLUS) {
			ValaExpression* _tmp13_;
			ValaExpression* _tmp14_;
			ValaSymbol* _tmp15_;
			ValaSymbol* _tmp16_;
			ValaBinaryExpression* _tmp17_;
			ValaExpression* _tmp18_;
			ValaExpression* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaSymbol* _tmp21_;
			_tmp13_ = vala_assignment_get_left (self);
			_tmp14_ = _tmp13_;
			_tmp15_ = vala_expression_get_symbol_reference (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = binary;
			_tmp18_ = vala_binary_expression_get_left (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_expression_get_symbol_reference (_tmp19_);
			_tmp21_ = _tmp20_;
			if (_tmp16_ == _tmp21_) {
				result = TRUE;
				_vala_code_node_unref0 (binary);
				return result;
			}
		}
	}
	result = FALSE;
	_vala_code_node_unref0 (binary);
	return result;
}


static gpointer _vala_target_value_ref0 (gpointer self) {
	return self ? vala_target_value_ref (self) : NULL;
}


static void vala_assignment_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen) {
	ValaAssignment * self;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaMemberAccess* _tmp2_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaElementAccess* _tmp5_;
	ValaPointerIndirection* pi = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaPointerIndirection* _tmp8_;
	ValaMemberAccess* _tmp9_;
	ValaExpression* _tmp151_;
	ValaExpression* _tmp152_;
	ValaCodeGenerator* _tmp153_;
	ValaCodeGenerator* _tmp154_;
	ValaCodeGenerator* _tmp155_;
	self = (ValaAssignment*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp1_) : NULL);
	ma = _tmp2_;
	_tmp3_ = vala_assignment_get_left (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_ELEMENT_ACCESS) ? ((ValaElementAccess*) _tmp4_) : NULL);
	ea = _tmp5_;
	_tmp6_ = vala_assignment_get_left (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_POINTER_INDIRECTION) ? ((ValaPointerIndirection*) _tmp7_) : NULL);
	pi = _tmp8_;
	_tmp9_ = ma;
	if (_tmp9_ != NULL) {
		ValaLocalVariable* local = NULL;
		ValaMemberAccess* _tmp10_;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaLocalVariable* _tmp13_;
		ValaParameter* param = NULL;
		ValaMemberAccess* _tmp14_;
		ValaSymbol* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaParameter* _tmp17_;
		ValaField* field = NULL;
		ValaMemberAccess* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaField* _tmp21_;
		ValaProperty* property = NULL;
		ValaMemberAccess* _tmp22_;
		ValaSymbol* _tmp23_;
		ValaSymbol* _tmp24_;
		ValaProperty* _tmp25_;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
		ValaField* _tmp28_;
		gboolean instance = FALSE;
		gboolean _tmp37_ = FALSE;
		gboolean _tmp38_ = FALSE;
		gboolean _tmp39_ = FALSE;
		gboolean _tmp40_ = FALSE;
		ValaAssignmentOperator _tmp41_;
		gboolean _tmp132_ = FALSE;
		gboolean _tmp133_ = FALSE;
		gboolean _tmp134_;
		_tmp10_ = ma;
		_tmp11_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp12_) : NULL);
		local = _tmp13_;
		_tmp14_ = ma;
		_tmp15_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_PARAMETER) ? ((ValaParameter*) _tmp16_) : NULL);
		param = _tmp17_;
		_tmp18_ = ma;
		_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, VALA_TYPE_FIELD) ? ((ValaField*) _tmp20_) : NULL);
		field = _tmp21_;
		_tmp22_ = ma;
		_tmp23_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALA_TYPE_PROPERTY) ? ((ValaProperty*) _tmp24_) : NULL);
		property = _tmp25_;
		_tmp28_ = field;
		if (_tmp28_ != NULL) {
			ValaField* _tmp29_;
			ValaMemberBinding _tmp30_;
			ValaMemberBinding _tmp31_;
			_tmp29_ = field;
			_tmp30_ = vala_field_get_binding (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp27_ = _tmp31_ != VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			_tmp26_ = TRUE;
		} else {
			gboolean _tmp32_ = FALSE;
			ValaProperty* _tmp33_;
			_tmp33_ = property;
			if (_tmp33_ != NULL) {
				ValaProperty* _tmp34_;
				ValaMemberBinding _tmp35_;
				ValaMemberBinding _tmp36_;
				_tmp34_ = property;
				_tmp35_ = vala_property_get_binding (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp32_ = _tmp36_ != VALA_MEMBER_BINDING_STATIC;
			} else {
				_tmp32_ = FALSE;
			}
			_tmp26_ = _tmp32_;
		}
		instance = _tmp26_;
		_tmp41_ = self->priv->_operator;
		if (_tmp41_ == VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
			gboolean _tmp42_ = FALSE;
			gboolean _tmp43_ = FALSE;
			ValaLocalVariable* _tmp44_;
			_tmp44_ = local;
			if (_tmp44_ != NULL) {
				_tmp43_ = TRUE;
			} else {
				ValaParameter* _tmp45_;
				_tmp45_ = param;
				_tmp43_ = _tmp45_ != NULL;
			}
			if (_tmp43_) {
				_tmp42_ = TRUE;
			} else {
				ValaField* _tmp46_;
				_tmp46_ = field;
				_tmp42_ = _tmp46_ != NULL;
			}
			_tmp40_ = _tmp42_;
		} else {
			_tmp40_ = FALSE;
		}
		if (_tmp40_) {
			gboolean _tmp47_;
			_tmp47_ = vala_assignment_is_array_add (self);
			_tmp39_ = !_tmp47_;
		} else {
			_tmp39_ = FALSE;
		}
		if (_tmp39_) {
			ValaField* _tmp48_;
			_tmp48_ = field;
			_tmp38_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp48_, VALA_TYPE_ARRAY_LENGTH_FIELD);
		} else {
			_tmp38_ = FALSE;
		}
		if (_tmp38_) {
			gboolean _tmp49_ = FALSE;
			ValaExpression* _tmp50_;
			ValaExpression* _tmp51_;
			ValaDataType* _tmp52_;
			ValaDataType* _tmp53_;
			gboolean _tmp54_;
			_tmp50_ = vala_assignment_get_left (self);
			_tmp51_ = _tmp50_;
			_tmp52_ = vala_expression_get_value_type (_tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_data_type_is_real_non_null_struct_type (_tmp53_);
			if (_tmp54_) {
				ValaExpression* _tmp55_;
				ValaExpression* _tmp56_;
				_tmp55_ = vala_assignment_get_right (self);
				_tmp56_ = _tmp55_;
				_tmp49_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp56_, VALA_TYPE_OBJECT_CREATION_EXPRESSION);
			} else {
				_tmp49_ = FALSE;
			}
			_tmp37_ = !_tmp49_;
		} else {
			_tmp37_ = FALSE;
		}
		if (_tmp37_) {
			gboolean _tmp57_ = FALSE;
			gboolean _tmp58_;
			ValaExpression* _tmp66_;
			ValaExpression* _tmp67_;
			ValaCodeGenerator* _tmp68_;
			ValaTargetValue* new_value = NULL;
			ValaExpression* _tmp69_;
			ValaExpression* _tmp70_;
			ValaTargetValue* _tmp71_;
			ValaTargetValue* _tmp72_;
			ValaTargetValue* _tmp73_;
			ValaLocalVariable* _tmp74_;
			ValaCodeNode* _tmp103_;
			ValaCodeNode* _tmp104_;
			ValaCodeGenerator* _tmp131_;
			_tmp58_ = instance;
			if (_tmp58_) {
				ValaMemberAccess* _tmp59_;
				ValaExpression* _tmp60_;
				ValaExpression* _tmp61_;
				_tmp59_ = ma;
				_tmp60_ = vala_member_access_get_inner (_tmp59_);
				_tmp61_ = _tmp60_;
				_tmp57_ = _tmp61_ != NULL;
			} else {
				_tmp57_ = FALSE;
			}
			if (_tmp57_) {
				ValaMemberAccess* _tmp62_;
				ValaExpression* _tmp63_;
				ValaExpression* _tmp64_;
				ValaCodeGenerator* _tmp65_;
				_tmp62_ = ma;
				_tmp63_ = vala_member_access_get_inner (_tmp62_);
				_tmp64_ = _tmp63_;
				_tmp65_ = codegen;
				vala_code_node_emit ((ValaCodeNode*) _tmp64_, _tmp65_);
			}
			_tmp66_ = vala_assignment_get_right (self);
			_tmp67_ = _tmp66_;
			_tmp68_ = codegen;
			vala_code_node_emit ((ValaCodeNode*) _tmp67_, _tmp68_);
			_tmp69_ = vala_assignment_get_right (self);
			_tmp70_ = _tmp69_;
			_tmp71_ = vala_expression_get_target_value (_tmp70_);
			_tmp72_ = _tmp71_;
			_tmp73_ = _vala_target_value_ref0 (_tmp72_);
			new_value = _tmp73_;
			_tmp74_ = local;
			if (_tmp74_ != NULL) {
				ValaCodeGenerator* _tmp75_;
				ValaLocalVariable* _tmp76_;
				ValaTargetValue* _tmp77_;
				ValaSourceReference* _tmp78_;
				ValaSourceReference* _tmp79_;
				_tmp75_ = codegen;
				_tmp76_ = local;
				_tmp77_ = new_value;
				_tmp78_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp79_ = _tmp78_;
				vala_code_generator_store_local (_tmp75_, _tmp76_, _tmp77_, FALSE, _tmp79_);
			} else {
				ValaParameter* _tmp80_;
				_tmp80_ = param;
				if (_tmp80_ != NULL) {
					ValaCodeGenerator* _tmp81_;
					ValaParameter* _tmp82_;
					ValaTargetValue* _tmp83_;
					ValaSourceReference* _tmp84_;
					ValaSourceReference* _tmp85_;
					_tmp81_ = codegen;
					_tmp82_ = param;
					_tmp83_ = new_value;
					_tmp84_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp85_ = _tmp84_;
					vala_code_generator_store_parameter (_tmp81_, _tmp82_, _tmp83_, FALSE, _tmp85_);
				} else {
					ValaField* _tmp86_;
					_tmp86_ = field;
					if (_tmp86_ != NULL) {
						ValaTargetValue* _tmp87_ = NULL;
						gboolean _tmp88_ = FALSE;
						gboolean _tmp89_;
						ValaCodeGenerator* _tmp98_;
						ValaField* _tmp99_;
						ValaTargetValue* _tmp100_;
						ValaSourceReference* _tmp101_;
						ValaSourceReference* _tmp102_;
						_tmp89_ = instance;
						if (_tmp89_) {
							ValaMemberAccess* _tmp90_;
							ValaExpression* _tmp91_;
							ValaExpression* _tmp92_;
							_tmp90_ = ma;
							_tmp91_ = vala_member_access_get_inner (_tmp90_);
							_tmp92_ = _tmp91_;
							_tmp88_ = _tmp92_ != NULL;
						} else {
							_tmp88_ = FALSE;
						}
						if (_tmp88_) {
							ValaMemberAccess* _tmp93_;
							ValaExpression* _tmp94_;
							ValaExpression* _tmp95_;
							ValaTargetValue* _tmp96_;
							ValaTargetValue* _tmp97_;
							_tmp93_ = ma;
							_tmp94_ = vala_member_access_get_inner (_tmp93_);
							_tmp95_ = _tmp94_;
							_tmp96_ = vala_expression_get_target_value (_tmp95_);
							_tmp97_ = _tmp96_;
							_tmp87_ = _tmp97_;
						} else {
							_tmp87_ = NULL;
						}
						_tmp98_ = codegen;
						_tmp99_ = field;
						_tmp100_ = new_value;
						_tmp101_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp102_ = _tmp101_;
						vala_code_generator_store_field (_tmp98_, _tmp99_, _tmp87_, _tmp100_, _tmp102_);
					}
				}
			}
			_tmp103_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp104_ = _tmp103_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp104_, VALA_TYPE_EXPRESSION_STATEMENT)) {
				ValaLocalVariable* _tmp105_;
				_tmp105_ = local;
				if (_tmp105_ != NULL) {
					ValaCodeGenerator* _tmp106_;
					ValaLocalVariable* _tmp107_;
					ValaTargetValue* _tmp108_;
					ValaTargetValue* _tmp109_;
					_tmp106_ = codegen;
					_tmp107_ = local;
					_tmp108_ = vala_code_generator_load_local (_tmp106_, _tmp107_);
					_tmp109_ = _tmp108_;
					vala_expression_set_target_value ((ValaExpression*) self, _tmp109_);
					_vala_target_value_unref0 (_tmp109_);
				} else {
					ValaParameter* _tmp110_;
					_tmp110_ = param;
					if (_tmp110_ != NULL) {
						ValaCodeGenerator* _tmp111_;
						ValaParameter* _tmp112_;
						ValaTargetValue* _tmp113_;
						ValaTargetValue* _tmp114_;
						_tmp111_ = codegen;
						_tmp112_ = param;
						_tmp113_ = vala_code_generator_load_parameter (_tmp111_, _tmp112_);
						_tmp114_ = _tmp113_;
						vala_expression_set_target_value ((ValaExpression*) self, _tmp114_);
						_vala_target_value_unref0 (_tmp114_);
					} else {
						ValaField* _tmp115_;
						_tmp115_ = field;
						if (_tmp115_ != NULL) {
							ValaTargetValue* _tmp116_ = NULL;
							gboolean _tmp117_ = FALSE;
							gboolean _tmp118_;
							ValaCodeGenerator* _tmp127_;
							ValaField* _tmp128_;
							ValaTargetValue* _tmp129_;
							ValaTargetValue* _tmp130_;
							_tmp118_ = instance;
							if (_tmp118_) {
								ValaMemberAccess* _tmp119_;
								ValaExpression* _tmp120_;
								ValaExpression* _tmp121_;
								_tmp119_ = ma;
								_tmp120_ = vala_member_access_get_inner (_tmp119_);
								_tmp121_ = _tmp120_;
								_tmp117_ = _tmp121_ != NULL;
							} else {
								_tmp117_ = FALSE;
							}
							if (_tmp117_) {
								ValaMemberAccess* _tmp122_;
								ValaExpression* _tmp123_;
								ValaExpression* _tmp124_;
								ValaTargetValue* _tmp125_;
								ValaTargetValue* _tmp126_;
								_tmp122_ = ma;
								_tmp123_ = vala_member_access_get_inner (_tmp122_);
								_tmp124_ = _tmp123_;
								_tmp125_ = vala_expression_get_target_value (_tmp124_);
								_tmp126_ = _tmp125_;
								_tmp116_ = _tmp126_;
							} else {
								_tmp116_ = NULL;
							}
							_tmp127_ = codegen;
							_tmp128_ = field;
							_tmp129_ = vala_code_generator_load_field (_tmp127_, _tmp128_, _tmp116_);
							_tmp130_ = _tmp129_;
							vala_expression_set_target_value ((ValaExpression*) self, _tmp130_);
							_vala_target_value_unref0 (_tmp130_);
						}
					}
				}
			}
			_tmp131_ = codegen;
			vala_code_visitor_visit_expression ((ValaCodeVisitor*) _tmp131_, (ValaExpression*) self);
			_vala_target_value_unref0 (new_value);
			_vala_code_node_unref0 (property);
			_vala_code_node_unref0 (field);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (pi);
			_vala_code_node_unref0 (ea);
			_vala_code_node_unref0 (ma);
			return;
		}
		_tmp134_ = instance;
		if (_tmp134_) {
			ValaMemberAccess* _tmp135_;
			ValaExpression* _tmp136_;
			ValaExpression* _tmp137_;
			_tmp135_ = ma;
			_tmp136_ = vala_member_access_get_inner (_tmp135_);
			_tmp137_ = _tmp136_;
			_tmp133_ = _tmp137_ != NULL;
		} else {
			_tmp133_ = FALSE;
		}
		if (_tmp133_) {
			ValaProperty* _tmp138_;
			_tmp138_ = property;
			_tmp132_ = _tmp138_ != NULL;
		} else {
			_tmp132_ = FALSE;
		}
		if (_tmp132_) {
			ValaMemberAccess* _tmp139_;
			ValaExpression* _tmp140_;
			ValaExpression* _tmp141_;
			ValaCodeGenerator* _tmp142_;
			_tmp139_ = ma;
			_tmp140_ = vala_member_access_get_inner (_tmp139_);
			_tmp141_ = _tmp140_;
			_tmp142_ = codegen;
			vala_code_node_emit ((ValaCodeNode*) _tmp141_, _tmp142_);
		} else {
			ValaMemberAccess* _tmp143_;
			ValaCodeGenerator* _tmp144_;
			_tmp143_ = ma;
			_tmp144_ = codegen;
			vala_code_node_emit ((ValaCodeNode*) _tmp143_, _tmp144_);
		}
		_vala_code_node_unref0 (property);
		_vala_code_node_unref0 (field);
		_vala_code_node_unref0 (param);
		_vala_code_node_unref0 (local);
	} else {
		ValaElementAccess* _tmp145_;
		_tmp145_ = ea;
		if (_tmp145_ != NULL) {
			ValaElementAccess* _tmp146_;
			ValaCodeGenerator* _tmp147_;
			_tmp146_ = ea;
			_tmp147_ = codegen;
			vala_code_node_emit ((ValaCodeNode*) _tmp146_, _tmp147_);
		} else {
			ValaPointerIndirection* _tmp148_;
			_tmp148_ = pi;
			if (_tmp148_ != NULL) {
				ValaPointerIndirection* _tmp149_;
				ValaCodeGenerator* _tmp150_;
				_tmp149_ = pi;
				_tmp150_ = codegen;
				vala_code_node_emit ((ValaCodeNode*) _tmp149_, _tmp150_);
			}
		}
	}
	_tmp151_ = vala_assignment_get_right (self);
	_tmp152_ = _tmp151_;
	_tmp153_ = codegen;
	vala_code_node_emit ((ValaCodeNode*) _tmp152_, _tmp153_);
	_tmp154_ = codegen;
	vala_code_visitor_visit_assignment ((ValaCodeVisitor*) _tmp154_, self);
	_tmp155_ = codegen;
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) _tmp155_, (ValaExpression*) self);
	_vala_code_node_unref0 (pi);
	_vala_code_node_unref0 (ea);
	_vala_code_node_unref0 (ma);
}


static void vala_assignment_real_get_defined_variables (ValaCodeNode* base, ValaCollection* collection) {
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCollection* _tmp2_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaCollection* _tmp5_;
	ValaLocalVariable* local = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaSymbol* _tmp9_;
	ValaLocalVariable* _tmp10_;
	ValaParameter* param = NULL;
	ValaExpression* _tmp11_;
	ValaExpression* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSymbol* _tmp14_;
	ValaParameter* _tmp15_;
	ValaLocalVariable* _tmp16_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_right (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = collection;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, _tmp2_);
	_tmp3_ = vala_assignment_get_left (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = collection;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp4_, _tmp5_);
	_tmp6_ = vala_assignment_get_left (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_expression_get_symbol_reference (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp9_) : NULL);
	local = _tmp10_;
	_tmp11_ = vala_assignment_get_left (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_expression_get_symbol_reference (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALA_TYPE_PARAMETER) ? ((ValaParameter*) _tmp14_) : NULL);
	param = _tmp15_;
	_tmp16_ = local;
	if (_tmp16_ != NULL) {
		ValaCollection* _tmp17_;
		ValaLocalVariable* _tmp18_;
		_tmp17_ = collection;
		_tmp18_ = local;
		vala_collection_add (_tmp17_, (ValaVariable*) _tmp18_);
	} else {
		gboolean _tmp19_ = FALSE;
		ValaParameter* _tmp20_;
		_tmp20_ = param;
		if (_tmp20_ != NULL) {
			ValaParameter* _tmp21_;
			ValaParameterDirection _tmp22_;
			ValaParameterDirection _tmp23_;
			_tmp21_ = param;
			_tmp22_ = vala_parameter_get_direction (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp19_ = _tmp23_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			ValaCollection* _tmp24_;
			ValaParameter* _tmp25_;
			_tmp24_ = collection;
			_tmp25_ = param;
			vala_collection_add (_tmp24_, (ValaVariable*) _tmp25_);
		}
	}
	_vala_code_node_unref0 (param);
	_vala_code_node_unref0 (local);
}


static void vala_assignment_real_get_used_variables (ValaCodeNode* base, ValaCollection* collection) {
	ValaAssignment * self;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaMemberAccess* _tmp2_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaElementAccess* _tmp5_;
	gboolean _tmp6_ = FALSE;
	ValaMemberAccess* _tmp7_;
	ValaExpression* _tmp18_;
	ValaExpression* _tmp19_;
	ValaCollection* _tmp20_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp1_) : NULL);
	ma = _tmp2_;
	_tmp3_ = vala_assignment_get_left (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_ELEMENT_ACCESS) ? ((ValaElementAccess*) _tmp4_) : NULL);
	ea = _tmp5_;
	_tmp7_ = ma;
	if (_tmp7_ != NULL) {
		ValaMemberAccess* _tmp8_;
		ValaExpression* _tmp9_;
		ValaExpression* _tmp10_;
		_tmp8_ = ma;
		_tmp9_ = vala_member_access_get_inner (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp6_ = _tmp10_ != NULL;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValaMemberAccess* _tmp11_;
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		ValaCollection* _tmp14_;
		_tmp11_ = ma;
		_tmp12_ = vala_member_access_get_inner (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = collection;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp13_, _tmp14_);
	} else {
		ValaElementAccess* _tmp15_;
		_tmp15_ = ea;
		if (_tmp15_ != NULL) {
			ValaElementAccess* _tmp16_;
			ValaCollection* _tmp17_;
			_tmp16_ = ea;
			_tmp17_ = collection;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp16_, _tmp17_);
		}
	}
	_tmp18_ = vala_assignment_get_right (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = collection;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp19_, _tmp20_);
	_vala_code_node_unref0 (ea);
	_vala_code_node_unref0 (ma);
}


ValaExpression* vala_assignment_get_left (ValaAssignment* self) {
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_left;
	result = _tmp0_;
	return result;
}


void vala_assignment_set_left (ValaAssignment* self, ValaExpression* value) {
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_left);
	self->priv->_left = _tmp1_;
	_tmp2_ = self->priv->_left;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


ValaAssignmentOperator vala_assignment_get_operator (ValaAssignment* self) {
	ValaAssignmentOperator result;
	ValaAssignmentOperator _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_operator;
	result = _tmp0_;
	return result;
}


void vala_assignment_set_operator (ValaAssignment* self, ValaAssignmentOperator value) {
	ValaAssignmentOperator _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_operator = _tmp0_;
}


ValaExpression* vala_assignment_get_right (ValaAssignment* self) {
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_right;
	result = _tmp0_;
	return result;
}


void vala_assignment_set_right (ValaAssignment* self, ValaExpression* value) {
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_right);
	self->priv->_right = _tmp1_;
	_tmp2_ = self->priv->_right;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


static void vala_assignment_class_init (ValaAssignmentClass * klass) {
	vala_assignment_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_assignment_finalize;
	g_type_class_add_private (klass, sizeof (ValaAssignmentPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_assignment_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_assignment_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_assignment_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression *)) vala_assignment_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression *, ValaSymbol*)) vala_assignment_real_is_accessible;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_assignment_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_assignment_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_assignment_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_assignment_real_get_used_variables;
}


static void vala_assignment_instance_init (ValaAssignment * self) {
	self->priv = VALA_ASSIGNMENT_GET_PRIVATE (self);
}


static void vala_assignment_finalize (ValaCodeNode * obj) {
	ValaAssignment * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ASSIGNMENT, ValaAssignment);
	_vala_code_node_unref0 (self->priv->_left);
	_vala_code_node_unref0 (self->priv->_right);
	VALA_CODE_NODE_CLASS (vala_assignment_parent_class)->finalize (obj);
}


/**
 * Represents an assignment expression in the source code.
 *
 * Supports =, |=, &=, ^=, +=, -=, *=, /=, %=, <<=, >>=.
 */
GType vala_assignment_get_type (void) {
	static volatile gsize vala_assignment_type_id__volatile = 0;
	if (g_once_init_enter (&vala_assignment_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaAssignmentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_assignment_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaAssignment), 0, (GInstanceInitFunc) vala_assignment_instance_init, NULL };
		GType vala_assignment_type_id;
		vala_assignment_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaAssignment", &g_define_type_info, 0);
		g_once_init_leave (&vala_assignment_type_id__volatile, vala_assignment_type_id);
	}
	return vala_assignment_type_id__volatile;
}


GType vala_assignment_operator_get_type (void) {
	static volatile gsize vala_assignment_operator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_assignment_operator_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_ASSIGNMENT_OPERATOR_NONE, "VALA_ASSIGNMENT_OPERATOR_NONE", "none"}, {VALA_ASSIGNMENT_OPERATOR_SIMPLE, "VALA_ASSIGNMENT_OPERATOR_SIMPLE", "simple"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_OR, "VALA_ASSIGNMENT_OPERATOR_BITWISE_OR", "bitwise-or"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_AND, "VALA_ASSIGNMENT_OPERATOR_BITWISE_AND", "bitwise-and"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR, "VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR", "bitwise-xor"}, {VALA_ASSIGNMENT_OPERATOR_ADD, "VALA_ASSIGNMENT_OPERATOR_ADD", "add"}, {VALA_ASSIGNMENT_OPERATOR_SUB, "VALA_ASSIGNMENT_OPERATOR_SUB", "sub"}, {VALA_ASSIGNMENT_OPERATOR_MUL, "VALA_ASSIGNMENT_OPERATOR_MUL", "mul"}, {VALA_ASSIGNMENT_OPERATOR_DIV, "VALA_ASSIGNMENT_OPERATOR_DIV", "div"}, {VALA_ASSIGNMENT_OPERATOR_PERCENT, "VALA_ASSIGNMENT_OPERATOR_PERCENT", "percent"}, {VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT, "VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT", "shift-left"}, {VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT, "VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT", "shift-right"}, {0, NULL, NULL}};
		GType vala_assignment_operator_type_id;
		vala_assignment_operator_type_id = g_enum_register_static ("ValaAssignmentOperator", values);
		g_once_init_leave (&vala_assignment_operator_type_id__volatile, vala_assignment_operator_type_id);
	}
	return vala_assignment_operator_type_id__volatile;
}



