/* valawhilestatement.c generated by valac, the Vala compiler
 * generated from valawhilestatement.vala, do not modify */

/* valawhilestatement.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"

enum  {
	VALA_WHILE_STATEMENT_0_PROPERTY,
	VALA_WHILE_STATEMENT_NUM_PROPERTIES
};
static GParamSpec* vala_while_statement_properties[VALA_WHILE_STATEMENT_NUM_PROPERTIES];
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

struct _ValaWhileStatementPrivate {
	ValaExpression* _condition;
	ValaBlock* _body;
};


static gpointer vala_while_statement_parent_class = NULL;
static ValaStatementIface * vala_while_statement_vala_statement_parent_iface = NULL;

#define VALA_WHILE_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_WHILE_STATEMENT, ValaWhileStatementPrivate))
static void vala_while_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_while_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_while_statement_always_true (ValaWhileStatement* self, ValaExpression* condition);
static gboolean vala_while_statement_always_false (ValaWhileStatement* self, ValaExpression* condition);
static gboolean vala_while_statement_real_check (ValaCodeNode* base, ValaCodeContext* context);
static void vala_while_statement_finalize (ValaCodeNode * obj);


/**
 * Creates a new while statement.
 *
 * @param condition         loop condition
 * @param body              loop body
 * @param source_reference  reference to source code
 * @return                  newly created while statement
 */
ValaWhileStatement* vala_while_statement_construct (GType object_type, ValaExpression* condition, ValaBlock* body, ValaSourceReference* source_reference) {
	ValaWhileStatement* self = NULL;
	ValaBlock* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaExpression* _tmp2_;
	g_return_val_if_fail (condition != NULL, NULL);
	g_return_val_if_fail (body != NULL, NULL);
	self = (ValaWhileStatement*) vala_code_node_construct (object_type);
	_tmp0_ = body;
	vala_while_statement_set_body (self, _tmp0_);
	_tmp1_ = source_reference;
	vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp1_);
	_tmp2_ = condition;
	vala_while_statement_set_condition (self, _tmp2_);
	return self;
}


ValaWhileStatement* vala_while_statement_new (ValaExpression* condition, ValaBlock* body, ValaSourceReference* source_reference) {
	return vala_while_statement_construct (VALA_TYPE_WHILE_STATEMENT, condition, body, source_reference);
}


static void vala_while_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaWhileStatement * self;
	ValaCodeVisitor* _tmp0_;
	self = (ValaWhileStatement*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_while_statement (_tmp0_, self);
}


static void vala_while_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaWhileStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCodeVisitor* _tmp2_;
	ValaCodeVisitor* _tmp3_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaBlock* _tmp6_;
	ValaBlock* _tmp7_;
	ValaCodeVisitor* _tmp8_;
	self = (ValaWhileStatement*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_while_statement_get_condition (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, _tmp2_);
	_tmp3_ = visitor;
	_tmp4_ = vala_while_statement_get_condition (self);
	_tmp5_ = _tmp4_;
	vala_code_visitor_visit_end_full_expression (_tmp3_, _tmp5_);
	_tmp6_ = vala_while_statement_get_body (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp7_, _tmp8_);
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean vala_while_statement_always_true (ValaWhileStatement* self, ValaExpression* condition) {
	gboolean result = FALSE;
	ValaBooleanLiteral* literal = NULL;
	ValaExpression* _tmp0_;
	ValaBooleanLiteral* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaBooleanLiteral* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (condition != NULL, FALSE);
	_tmp0_ = condition;
	_tmp1_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_BOOLEAN_LITERAL) ? ((ValaBooleanLiteral*) _tmp0_) : NULL);
	literal = _tmp1_;
	_tmp3_ = literal;
	if (_tmp3_ != NULL) {
		ValaBooleanLiteral* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = literal;
		_tmp5_ = vala_boolean_literal_get_value (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	result = _tmp2_;
	_vala_code_node_unref0 (literal);
	return result;
}


static gboolean vala_while_statement_always_false (ValaWhileStatement* self, ValaExpression* condition) {
	gboolean result = FALSE;
	ValaBooleanLiteral* literal = NULL;
	ValaExpression* _tmp0_;
	ValaBooleanLiteral* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaBooleanLiteral* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (condition != NULL, FALSE);
	_tmp0_ = condition;
	_tmp1_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_BOOLEAN_LITERAL) ? ((ValaBooleanLiteral*) _tmp0_) : NULL);
	literal = _tmp1_;
	_tmp3_ = literal;
	if (_tmp3_ != NULL) {
		ValaBooleanLiteral* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = literal;
		_tmp5_ = vala_boolean_literal_get_value (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = !_tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	result = _tmp2_;
	_vala_code_node_unref0 (literal);
	return result;
}


static gboolean vala_while_statement_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaWhileStatement * self;
	gboolean result = FALSE;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_;
	ValaLoop* loop = NULL;
	ValaBlock* _tmp43_;
	ValaBlock* _tmp44_;
	ValaSourceReference* _tmp45_;
	ValaSourceReference* _tmp46_;
	ValaLoop* _tmp47_;
	ValaBlock* parent_block = NULL;
	ValaCodeNode* _tmp48_;
	ValaCodeNode* _tmp49_;
	ValaBlock* _tmp50_;
	ValaCodeContext* _tmp51_;
	gboolean _tmp52_;
	self = (ValaWhileStatement*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_while_statement_get_condition (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_while_statement_always_true (self, _tmp1_);
	if (_tmp2_) {
	} else {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = vala_while_statement_get_condition (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_while_statement_always_false (self, _tmp4_);
		if (_tmp5_) {
			ValaBlock* _tmp6_;
			ValaBlock* _tmp7_;
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			ValaSourceReference* _tmp10_;
			ValaSourceReference* _tmp11_;
			ValaBreakStatement* _tmp12_;
			ValaBreakStatement* _tmp13_;
			_tmp6_ = vala_while_statement_get_body (self);
			_tmp7_ = _tmp6_;
			_tmp8_ = vala_while_statement_get_condition (self);
			_tmp9_ = _tmp8_;
			_tmp10_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_break_statement_new (_tmp11_);
			_tmp13_ = _tmp12_;
			vala_block_insert_statement (_tmp7_, 0, (ValaStatement*) _tmp13_);
			_vala_code_node_unref0 (_tmp13_);
		} else {
			ValaUnaryExpression* if_condition = NULL;
			ValaExpression* _tmp14_;
			ValaExpression* _tmp15_;
			ValaExpression* _tmp16_;
			ValaExpression* _tmp17_;
			ValaSourceReference* _tmp18_;
			ValaSourceReference* _tmp19_;
			ValaUnaryExpression* _tmp20_;
			ValaBlock* true_block = NULL;
			ValaExpression* _tmp21_;
			ValaExpression* _tmp22_;
			ValaSourceReference* _tmp23_;
			ValaSourceReference* _tmp24_;
			ValaBlock* _tmp25_;
			ValaBlock* _tmp26_;
			ValaExpression* _tmp27_;
			ValaExpression* _tmp28_;
			ValaSourceReference* _tmp29_;
			ValaSourceReference* _tmp30_;
			ValaBreakStatement* _tmp31_;
			ValaBreakStatement* _tmp32_;
			ValaIfStatement* if_stmt = NULL;
			ValaUnaryExpression* _tmp33_;
			ValaBlock* _tmp34_;
			ValaExpression* _tmp35_;
			ValaExpression* _tmp36_;
			ValaSourceReference* _tmp37_;
			ValaSourceReference* _tmp38_;
			ValaIfStatement* _tmp39_;
			ValaBlock* _tmp40_;
			ValaBlock* _tmp41_;
			ValaIfStatement* _tmp42_;
			_tmp14_ = vala_while_statement_get_condition (self);
			_tmp15_ = _tmp14_;
			_tmp16_ = vala_while_statement_get_condition (self);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_unary_expression_new (VALA_UNARY_OPERATOR_LOGICAL_NEGATION, _tmp15_, _tmp19_);
			if_condition = _tmp20_;
			_tmp21_ = vala_while_statement_get_condition (self);
			_tmp22_ = _tmp21_;
			_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = vala_block_new (_tmp24_);
			true_block = _tmp25_;
			_tmp26_ = true_block;
			_tmp27_ = vala_while_statement_get_condition (self);
			_tmp28_ = _tmp27_;
			_tmp29_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = vala_break_statement_new (_tmp30_);
			_tmp32_ = _tmp31_;
			vala_block_add_statement (_tmp26_, (ValaStatement*) _tmp32_);
			_vala_code_node_unref0 (_tmp32_);
			_tmp33_ = if_condition;
			_tmp34_ = true_block;
			_tmp35_ = vala_while_statement_get_condition (self);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_if_statement_new ((ValaExpression*) _tmp33_, _tmp34_, NULL, _tmp38_);
			if_stmt = _tmp39_;
			_tmp40_ = vala_while_statement_get_body (self);
			_tmp41_ = _tmp40_;
			_tmp42_ = if_stmt;
			vala_block_insert_statement (_tmp41_, 0, (ValaStatement*) _tmp42_);
			_vala_code_node_unref0 (if_stmt);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (if_condition);
		}
	}
	_tmp43_ = vala_while_statement_get_body (self);
	_tmp44_ = _tmp43_;
	_tmp45_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp46_ = _tmp45_;
	_tmp47_ = vala_loop_new (_tmp44_, _tmp46_);
	loop = _tmp47_;
	_tmp48_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp49_ = _tmp48_;
	_tmp50_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, VALA_TYPE_BLOCK, ValaBlock));
	parent_block = _tmp50_;
	vala_block_replace_statement (parent_block, (ValaStatement*) self, (ValaStatement*) loop);
	_tmp51_ = context;
	_tmp52_ = vala_code_node_check ((ValaCodeNode*) loop, _tmp51_);
	result = _tmp52_;
	_vala_code_node_unref0 (parent_block);
	_vala_code_node_unref0 (loop);
	return result;
}


ValaExpression* vala_while_statement_get_condition (ValaWhileStatement* self) {
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_condition;
	result = _tmp0_;
	return result;
}


void vala_while_statement_set_condition (ValaWhileStatement* self, ValaExpression* value) {
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_condition);
	self->priv->_condition = _tmp1_;
	_tmp2_ = self->priv->_condition;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


ValaBlock* vala_while_statement_get_body (ValaWhileStatement* self) {
	ValaBlock* result;
	ValaBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_body;
	result = _tmp0_;
	return result;
}


void vala_while_statement_set_body (ValaWhileStatement* self, ValaBlock* value) {
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	ValaBlock* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_body);
	self->priv->_body = _tmp1_;
	_tmp2_ = self->priv->_body;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


static void vala_while_statement_class_init (ValaWhileStatementClass * klass) {
	vala_while_statement_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_while_statement_finalize;
	g_type_class_add_private (klass, sizeof (ValaWhileStatementPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_while_statement_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_while_statement_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_while_statement_real_check;
}


static void vala_while_statement_vala_statement_interface_init (ValaStatementIface * iface) {
	vala_while_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void vala_while_statement_instance_init (ValaWhileStatement * self) {
	self->priv = VALA_WHILE_STATEMENT_GET_PRIVATE (self);
}


static void vala_while_statement_finalize (ValaCodeNode * obj) {
	ValaWhileStatement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_WHILE_STATEMENT, ValaWhileStatement);
	_vala_code_node_unref0 (self->priv->_condition);
	_vala_code_node_unref0 (self->priv->_body);
	VALA_CODE_NODE_CLASS (vala_while_statement_parent_class)->finalize (obj);
}


/**
 * Represents a while iteration statement in the source code.
 */
GType vala_while_statement_get_type (void) {
	static volatile gsize vala_while_statement_type_id__volatile = 0;
	if (g_once_init_enter (&vala_while_statement_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaWhileStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_while_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaWhileStatement), 0, (GInstanceInitFunc) vala_while_statement_instance_init, NULL };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_while_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_while_statement_type_id;
		vala_while_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaWhileStatement", &g_define_type_info, 0);
		g_type_add_interface_static (vala_while_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
		g_once_init_leave (&vala_while_statement_type_id__volatile, vala_while_statement_type_id);
	}
	return vala_while_statement_type_id__volatile;
}



