/* valasignal.c generated by valac, the Vala compiler
 * generated from valasignal.vala, do not modify */

/* valasignal.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

enum  {
	VALA_SIGNAL_0_PROPERTY,
	VALA_SIGNAL_NUM_PROPERTIES
};
static GParamSpec* vala_signal_properties[VALA_SIGNAL_NUM_PROPERTIES];
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaSignalPrivate {
	gboolean _is_virtual;
	ValaList* parameters;
	ValaMethod* _default_handler;
	ValaMethod* _emitter;
	gboolean lock_used;
	ValaDataType* _return_type;
	ValaBlock* _body;
};


static gpointer vala_signal_parent_class = NULL;
static ValaLockableIface * vala_signal_vala_lockable_parent_iface = NULL;
static ValaCallableIface * vala_signal_vala_callable_parent_iface = NULL;

#define VALA_SIGNAL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SIGNAL, ValaSignalPrivate))
static void vala_signal_real_add_parameter (ValaCallable* base, ValaParameter* param);
static ValaList* vala_signal_real_get_parameters (ValaCallable* base);
static void vala_signal_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_signal_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_signal_real_get_lock_used (ValaLockable* base);
static void vala_signal_real_set_lock_used (ValaLockable* base, gboolean used);
static void vala_signal_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static gboolean vala_signal_real_check (ValaCodeNode* base, ValaCodeContext* context);
static void vala_signal_set_default_handler (ValaSignal* self, ValaMethod* value);
static void vala_signal_set_emitter (ValaSignal* self, ValaMethod* value);
static void vala_signal_finalize (ValaCodeNode * obj);


/**
 * Creates a new signal.
 *
 * @param name              signal name
 * @param return_type       signal return type
 * @param source_reference  reference to source code
 * @return                  newly created signal
 */
ValaSignal* vala_signal_construct (GType object_type, const gchar* name, ValaDataType* return_type, ValaSourceReference* source_reference, ValaComment* comment) {
	ValaSignal* self = NULL;
	const gchar* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaComment* _tmp2_;
	ValaDataType* _tmp3_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = source_reference;
	_tmp2_ = comment;
	self = (ValaSignal*) vala_symbol_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
	_tmp3_ = return_type;
	vala_callable_set_return_type ((ValaCallable*) self, _tmp3_);
	return self;
}


ValaSignal* vala_signal_new (const gchar* name, ValaDataType* return_type, ValaSourceReference* source_reference, ValaComment* comment) {
	return vala_signal_construct (VALA_TYPE_SIGNAL, name, return_type, source_reference, comment);
}


/**
 * Appends parameter to signal handler.
 *
 * @param param a formal parameter
 */
static void vala_signal_real_add_parameter (ValaCallable* base, ValaParameter* param) {
	ValaSignal * self;
	ValaList* _tmp0_;
	ValaParameter* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaParameter* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaParameter* _tmp7_;
	self = (ValaSignal*) base;
	g_return_if_fail (param != NULL);
	_tmp0_ = self->priv->parameters;
	_tmp1_ = param;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = param;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = param;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


static ValaList* vala_signal_real_get_parameters (ValaCallable* base) {
	ValaSignal * self;
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	self = (ValaSignal*) base;
	_tmp0_ = self->priv->parameters;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns generated delegate to be used for signal handlers.
 *
 * @return delegate
 */
static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


ValaDelegate* vala_signal_get_delegate (ValaSignal* self, ValaDataType* sender_type, ValaCodeNode* node_reference) {
	ValaDelegate* result = NULL;
	ValaDataType* actual_return_type = NULL;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaCodeNode* _tmp3_;
	ValaDataType* _tmp4_;
	ValaDelegate* generated_delegate = NULL;
	ValaDataType* _tmp5_;
	ValaDelegate* _tmp6_;
	ValaDelegate* _tmp7_;
	ValaDelegate* _tmp8_;
	ValaScope* _tmp9_;
	ValaScope* _tmp10_;
	ValaDataType* sender_param_type = NULL;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp13_;
	ValaDataType* _tmp14_;
	ValaDelegate* _tmp15_;
	ValaDataType* _tmp16_;
	gboolean is_generic = FALSE;
	gboolean _tmp43_;
	ValaScope* _tmp98_;
	ValaScope* _tmp99_;
	ValaDelegate* _tmp100_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sender_type != NULL, NULL);
	g_return_val_if_fail (node_reference != NULL, NULL);
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = sender_type;
	_tmp3_ = node_reference;
	_tmp4_ = vala_data_type_get_actual_type (_tmp1_, _tmp2_, NULL, _tmp3_);
	actual_return_type = _tmp4_;
	_tmp5_ = actual_return_type;
	_tmp6_ = vala_delegate_new (NULL, _tmp5_, NULL, NULL);
	generated_delegate = _tmp6_;
	_tmp7_ = generated_delegate;
	vala_symbol_set_access ((ValaSymbol*) _tmp7_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp8_ = generated_delegate;
	_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp10_ = _tmp9_;
	vala_symbol_set_owner ((ValaSymbol*) _tmp8_, _tmp10_);
	_tmp11_ = sender_type;
	_tmp12_ = vala_data_type_copy (_tmp11_);
	sender_param_type = _tmp12_;
	_tmp13_ = sender_param_type;
	vala_data_type_set_value_owned (_tmp13_, FALSE);
	_tmp14_ = sender_param_type;
	vala_data_type_set_nullable (_tmp14_, FALSE);
	_tmp15_ = generated_delegate;
	_tmp16_ = sender_param_type;
	vala_delegate_set_sender_type (_tmp15_, _tmp16_);
	is_generic = FALSE;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp17_;
		ValaList* _tmp18_;
		gint _param_size = 0;
		ValaList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _param_index = 0;
		_tmp17_ = self->priv->parameters;
		_tmp18_ = _vala_iterable_ref0 (_tmp17_);
		_param_list = _tmp18_;
		_tmp19_ = _param_list;
		_tmp20_ = vala_collection_get_size ((ValaCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_param_size = _tmp21_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			ValaParameter* param = NULL;
			ValaList* _tmp25_;
			gint _tmp26_;
			gpointer _tmp27_;
			ValaParameter* actual_param = NULL;
			ValaParameter* _tmp28_;
			ValaParameter* _tmp29_;
			ValaParameter* _tmp30_;
			ValaParameter* _tmp31_;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			ValaDataType* _tmp34_;
			ValaCodeNode* _tmp35_;
			ValaDataType* _tmp36_;
			ValaDataType* _tmp37_;
			ValaDelegate* _tmp38_;
			ValaParameter* _tmp39_;
			ValaParameter* _tmp40_;
			ValaDataType* _tmp41_;
			ValaDataType* _tmp42_;
			_tmp22_ = _param_index;
			_param_index = _tmp22_ + 1;
			_tmp23_ = _param_index;
			_tmp24_ = _param_size;
			if (!(_tmp23_ < _tmp24_)) {
				break;
			}
			_tmp25_ = _param_list;
			_tmp26_ = _param_index;
			_tmp27_ = vala_list_get (_tmp25_, _tmp26_);
			param = (ValaParameter*) _tmp27_;
			_tmp28_ = param;
			_tmp29_ = vala_parameter_copy (_tmp28_);
			actual_param = _tmp29_;
			_tmp30_ = actual_param;
			_tmp31_ = actual_param;
			_tmp32_ = vala_variable_get_variable_type ((ValaVariable*) _tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = sender_type;
			_tmp35_ = node_reference;
			_tmp36_ = vala_data_type_get_actual_type (_tmp33_, _tmp34_, NULL, _tmp35_);
			_tmp37_ = _tmp36_;
			vala_variable_set_variable_type ((ValaVariable*) _tmp30_, _tmp37_);
			_vala_code_node_unref0 (_tmp37_);
			_tmp38_ = generated_delegate;
			_tmp39_ = actual_param;
			vala_callable_add_parameter ((ValaCallable*) _tmp38_, _tmp39_);
			_tmp40_ = actual_param;
			_tmp41_ = vala_variable_get_variable_type ((ValaVariable*) _tmp40_);
			_tmp42_ = _tmp41_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp42_, VALA_TYPE_GENERIC_TYPE)) {
				is_generic = TRUE;
			}
			_vala_code_node_unref0 (actual_param);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp43_ = is_generic;
	if (_tmp43_) {
		ValaObjectTypeSymbol* cl = NULL;
		ValaSymbol* _tmp44_;
		ValaSymbol* _tmp45_;
		ValaObjectTypeSymbol* _tmp46_;
		_tmp44_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp45_ = _tmp44_;
		_tmp46_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
		cl = _tmp46_;
		{
			ValaList* _type_param_list = NULL;
			ValaObjectTypeSymbol* _tmp47_;
			ValaList* _tmp48_;
			gint _type_param_size = 0;
			ValaList* _tmp49_;
			gint _tmp50_;
			gint _tmp51_;
			gint _type_param_index = 0;
			_tmp47_ = cl;
			_tmp48_ = vala_object_type_symbol_get_type_parameters (_tmp47_);
			_type_param_list = _tmp48_;
			_tmp49_ = _type_param_list;
			_tmp50_ = vala_collection_get_size ((ValaCollection*) _tmp49_);
			_tmp51_ = _tmp50_;
			_type_param_size = _tmp51_;
			_type_param_index = -1;
			while (TRUE) {
				gint _tmp52_;
				gint _tmp53_;
				gint _tmp54_;
				ValaTypeParameter* type_param = NULL;
				ValaList* _tmp55_;
				gint _tmp56_;
				gpointer _tmp57_;
				ValaDelegate* _tmp58_;
				ValaTypeParameter* _tmp59_;
				const gchar* _tmp60_;
				const gchar* _tmp61_;
				ValaTypeParameter* _tmp62_;
				ValaSourceReference* _tmp63_;
				ValaSourceReference* _tmp64_;
				ValaTypeParameter* _tmp65_;
				ValaTypeParameter* _tmp66_;
				_tmp52_ = _type_param_index;
				_type_param_index = _tmp52_ + 1;
				_tmp53_ = _type_param_index;
				_tmp54_ = _type_param_size;
				if (!(_tmp53_ < _tmp54_)) {
					break;
				}
				_tmp55_ = _type_param_list;
				_tmp56_ = _type_param_index;
				_tmp57_ = vala_list_get (_tmp55_, _tmp56_);
				type_param = (ValaTypeParameter*) _tmp57_;
				_tmp58_ = generated_delegate;
				_tmp59_ = type_param;
				_tmp60_ = vala_symbol_get_name ((ValaSymbol*) _tmp59_);
				_tmp61_ = _tmp60_;
				_tmp62_ = type_param;
				_tmp63_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp62_);
				_tmp64_ = _tmp63_;
				_tmp65_ = vala_typeparameter_new (_tmp61_, _tmp64_);
				_tmp66_ = _tmp65_;
				vala_delegate_add_type_parameter (_tmp58_, _tmp66_);
				_vala_code_node_unref0 (_tmp66_);
				_vala_code_node_unref0 (type_param);
			}
			_vala_iterable_unref0 (_type_param_list);
		}
		{
			ValaList* _param_list = NULL;
			ValaDelegate* _tmp67_;
			ValaList* _tmp68_;
			gint _param_size = 0;
			ValaList* _tmp69_;
			gint _tmp70_;
			gint _tmp71_;
			gint _param_index = 0;
			_tmp67_ = generated_delegate;
			_tmp68_ = vala_callable_get_parameters ((ValaCallable*) _tmp67_);
			_param_list = _tmp68_;
			_tmp69_ = _param_list;
			_tmp70_ = vala_collection_get_size ((ValaCollection*) _tmp69_);
			_tmp71_ = _tmp70_;
			_param_size = _tmp71_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp72_;
				gint _tmp73_;
				gint _tmp74_;
				ValaParameter* param = NULL;
				ValaList* _tmp75_;
				gint _tmp76_;
				gpointer _tmp77_;
				ValaParameter* _tmp78_;
				ValaDataType* _tmp79_;
				ValaDataType* _tmp80_;
				_tmp72_ = _param_index;
				_param_index = _tmp72_ + 1;
				_tmp73_ = _param_index;
				_tmp74_ = _param_size;
				if (!(_tmp73_ < _tmp74_)) {
					break;
				}
				_tmp75_ = _param_list;
				_tmp76_ = _param_index;
				_tmp77_ = vala_list_get (_tmp75_, _tmp76_);
				param = (ValaParameter*) _tmp77_;
				_tmp78_ = param;
				_tmp79_ = vala_variable_get_variable_type ((ValaVariable*) _tmp78_);
				_tmp80_ = _tmp79_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp80_, VALA_TYPE_GENERIC_TYPE)) {
					ValaParameter* _tmp81_;
					ValaDataType* _tmp82_;
					ValaDataType* _tmp83_;
					ValaDelegate* _tmp84_;
					ValaList* _tmp85_;
					ValaList* _tmp86_;
					ValaDelegate* _tmp87_;
					ValaParameter* _tmp88_;
					ValaDataType* _tmp89_;
					ValaDataType* _tmp90_;
					ValaTypeParameter* _tmp91_;
					ValaTypeParameter* _tmp92_;
					const gchar* _tmp93_;
					const gchar* _tmp94_;
					gint _tmp95_;
					gpointer _tmp96_;
					ValaTypeParameter* _tmp97_;
					_tmp81_ = param;
					_tmp82_ = vala_variable_get_variable_type ((ValaVariable*) _tmp81_);
					_tmp83_ = _tmp82_;
					_tmp84_ = generated_delegate;
					_tmp85_ = vala_delegate_get_type_parameters (_tmp84_);
					_tmp86_ = _tmp85_;
					_tmp87_ = generated_delegate;
					_tmp88_ = param;
					_tmp89_ = vala_variable_get_variable_type ((ValaVariable*) _tmp88_);
					_tmp90_ = _tmp89_;
					_tmp91_ = vala_data_type_get_type_parameter (_tmp90_);
					_tmp92_ = _tmp91_;
					_tmp93_ = vala_symbol_get_name ((ValaSymbol*) _tmp92_);
					_tmp94_ = _tmp93_;
					_tmp95_ = vala_typesymbol_get_type_parameter_index ((ValaTypeSymbol*) _tmp87_, _tmp94_);
					_tmp96_ = vala_list_get (_tmp86_, _tmp95_);
					_tmp97_ = (ValaTypeParameter*) _tmp96_;
					vala_data_type_set_type_parameter (_tmp83_, _tmp97_);
					_vala_code_node_unref0 (_tmp97_);
					_vala_iterable_unref0 (_tmp86_);
				}
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp98_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp99_ = _tmp98_;
	_tmp100_ = generated_delegate;
	vala_scope_add (_tmp99_, NULL, (ValaSymbol*) _tmp100_);
	result = generated_delegate;
	_vala_code_node_unref0 (sender_param_type);
	_vala_code_node_unref0 (actual_return_type);
	return result;
}


static void vala_signal_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaSignal * self;
	ValaCodeVisitor* _tmp0_;
	self = (ValaSignal*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_signal (_tmp0_, self);
}


static void vala_signal_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaSignal * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaCodeVisitor* _tmp2_;
	gboolean _tmp16_ = FALSE;
	ValaMethod* _tmp17_;
	ValaMethod* _tmp26_;
	self = (ValaSignal*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, _tmp2_);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp3_;
		ValaList* _tmp4_;
		gint _param_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _param_index = 0;
		_tmp3_ = self->priv->parameters;
		_tmp4_ = _vala_iterable_ref0 (_tmp3_);
		_param_list = _tmp4_;
		_tmp5_ = _param_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_param_size = _tmp7_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			ValaParameter* param = NULL;
			ValaList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			ValaParameter* _tmp14_;
			ValaCodeVisitor* _tmp15_;
			_tmp8_ = _param_index;
			_param_index = _tmp8_ + 1;
			_tmp9_ = _param_index;
			_tmp10_ = _param_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _param_list;
			_tmp12_ = _param_index;
			_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
			param = (ValaParameter*) _tmp13_;
			_tmp14_ = param;
			_tmp15_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp14_, _tmp15_);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp17_ = self->priv->_default_handler;
	if (_tmp17_ == NULL) {
		ValaBlock* _tmp18_;
		ValaBlock* _tmp19_;
		_tmp18_ = vala_signal_get_body (self);
		_tmp19_ = _tmp18_;
		_tmp16_ = _tmp19_ != NULL;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		ValaBlock* _tmp20_;
		ValaBlock* _tmp21_;
		ValaCodeVisitor* _tmp22_;
		_tmp20_ = vala_signal_get_body (self);
		_tmp21_ = _tmp20_;
		_tmp22_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp21_, _tmp22_);
	} else {
		ValaMethod* _tmp23_;
		_tmp23_ = self->priv->_default_handler;
		if (_tmp23_ != NULL) {
			ValaMethod* _tmp24_;
			ValaCodeVisitor* _tmp25_;
			_tmp24_ = self->priv->_default_handler;
			_tmp25_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp24_, _tmp25_);
		}
	}
	_tmp26_ = self->priv->_emitter;
	if (_tmp26_ != NULL) {
		ValaMethod* _tmp27_;
		ValaCodeVisitor* _tmp28_;
		_tmp27_ = self->priv->_emitter;
		_tmp28_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp27_, _tmp28_);
	}
}


static gboolean vala_signal_real_get_lock_used (ValaLockable* base) {
	ValaSignal * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (ValaSignal*) base;
	_tmp0_ = self->priv->lock_used;
	result = _tmp0_;
	return result;
}


static void vala_signal_real_set_lock_used (ValaLockable* base, gboolean used) {
	ValaSignal * self;
	gboolean _tmp0_;
	self = (ValaSignal*) base;
	_tmp0_ = used;
	self->priv->lock_used = _tmp0_;
}


static void vala_signal_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaSignal * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	self = (ValaSignal*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_type;
	if (_tmp1_ == _tmp2_) {
		ValaDataType* _tmp3_;
		_tmp3_ = new_type;
		vala_callable_set_return_type ((ValaCallable*) self, _tmp3_);
	}
}


static gboolean vala_signal_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaSignal * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaCodeContext* _tmp6_;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_;
	gboolean _tmp32_;
	gboolean _tmp78_ = FALSE;
	gboolean _tmp79_;
	gboolean _tmp80_;
	gboolean _tmp154_ = FALSE;
	gboolean _tmp155_ = FALSE;
	gboolean _tmp156_;
	gboolean _tmp157_;
	gboolean _tmp172_;
	gboolean _tmp173_;
	self = (ValaSignal*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = context;
	vala_code_node_check ((ValaCodeNode*) _tmp5_, _tmp6_);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp7_;
		ValaList* _tmp8_;
		gint _param_size = 0;
		ValaList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _param_index = 0;
		_tmp7_ = self->priv->parameters;
		_tmp8_ = _vala_iterable_ref0 (_tmp7_);
		_param_list = _tmp8_;
		_tmp9_ = _param_list;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_param_size = _tmp11_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			ValaParameter* param = NULL;
			ValaList* _tmp15_;
			gint _tmp16_;
			gpointer _tmp17_;
			ValaParameter* _tmp18_;
			gboolean _tmp19_;
			gboolean _tmp20_;
			ValaParameter* _tmp24_;
			ValaCodeContext* _tmp25_;
			_tmp12_ = _param_index;
			_param_index = _tmp12_ + 1;
			_tmp13_ = _param_index;
			_tmp14_ = _param_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _param_list;
			_tmp16_ = _param_index;
			_tmp17_ = vala_list_get (_tmp15_, _tmp16_);
			param = (ValaParameter*) _tmp17_;
			_tmp18_ = param;
			_tmp19_ = vala_parameter_get_ellipsis (_tmp18_);
			_tmp20_ = _tmp19_;
			if (_tmp20_) {
				ValaParameter* _tmp21_;
				ValaSourceReference* _tmp22_;
				ValaSourceReference* _tmp23_;
				_tmp21_ = param;
				_tmp22_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp21_);
				_tmp23_ = _tmp22_;
				vala_report_error (_tmp23_, "Signals with variable argument lists are not supported");
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_tmp24_ = param;
			_tmp25_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp24_, _tmp25_);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp27_ = self->priv->_is_virtual;
	if (!_tmp27_) {
		ValaBlock* _tmp28_;
		ValaBlock* _tmp29_;
		_tmp28_ = vala_signal_get_body (self);
		_tmp29_ = _tmp28_;
		_tmp26_ = _tmp29_ != NULL;
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		ValaSourceReference* _tmp30_;
		ValaSourceReference* _tmp31_;
		_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp31_ = _tmp30_;
		vala_report_error (_tmp31_, "Only virtual signals can have a default signal handler body");
	}
	_tmp32_ = self->priv->_is_virtual;
	if (_tmp32_) {
		const gchar* _tmp33_;
		const gchar* _tmp34_;
		ValaDataType* _tmp35_;
		ValaDataType* _tmp36_;
		ValaSourceReference* _tmp37_;
		ValaSourceReference* _tmp38_;
		ValaMethod* _tmp39_;
		ValaMethod* _tmp40_;
		ValaMethod* _tmp41_;
		ValaScope* _tmp42_;
		ValaScope* _tmp43_;
		ValaMethod* _tmp44_;
		ValaSymbolAccessibility _tmp45_;
		ValaSymbolAccessibility _tmp46_;
		ValaMethod* _tmp47_;
		gboolean _tmp48_;
		gboolean _tmp49_;
		ValaMethod* _tmp50_;
		gboolean _tmp51_;
		gboolean _tmp52_;
		ValaMethod* _tmp53_;
		ValaMethod* _tmp54_;
		ValaMethod* _tmp55_;
		ValaBlock* _tmp56_;
		ValaBlock* _tmp57_;
		ValaObjectTypeSymbol* cl = NULL;
		ValaSymbol* _tmp71_;
		ValaSymbol* _tmp72_;
		ValaObjectTypeSymbol* _tmp73_;
		ValaObjectTypeSymbol* _tmp74_;
		ValaMethod* _tmp75_;
		ValaMethod* _tmp76_;
		ValaCodeContext* _tmp77_;
		_tmp33_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp34_ = _tmp33_;
		_tmp35_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp36_ = _tmp35_;
		_tmp37_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp38_ = _tmp37_;
		_tmp39_ = vala_method_new (_tmp34_, _tmp36_, _tmp38_, NULL);
		_tmp40_ = _tmp39_;
		vala_signal_set_default_handler (self, _tmp40_);
		_vala_code_node_unref0 (_tmp40_);
		_tmp41_ = self->priv->_default_handler;
		_tmp42_ = vala_symbol_get_owner ((ValaSymbol*) self);
		_tmp43_ = _tmp42_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp41_, _tmp43_);
		_tmp44_ = self->priv->_default_handler;
		_tmp45_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp46_ = _tmp45_;
		vala_symbol_set_access ((ValaSymbol*) _tmp44_, _tmp46_);
		_tmp47_ = self->priv->_default_handler;
		_tmp48_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp49_ = _tmp48_;
		vala_symbol_set_external ((ValaSymbol*) _tmp47_, _tmp49_);
		_tmp50_ = self->priv->_default_handler;
		_tmp51_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp52_ = _tmp51_;
		vala_symbol_set_hides ((ValaSymbol*) _tmp50_, _tmp52_);
		_tmp53_ = self->priv->_default_handler;
		vala_method_set_is_virtual (_tmp53_, TRUE);
		_tmp54_ = self->priv->_default_handler;
		vala_method_set_signal_reference (_tmp54_, self);
		_tmp55_ = self->priv->_default_handler;
		_tmp56_ = vala_signal_get_body (self);
		_tmp57_ = _tmp56_;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp55_, _tmp57_);
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp58_;
			ValaList* _tmp59_;
			gint _param_size = 0;
			ValaList* _tmp60_;
			gint _tmp61_;
			gint _tmp62_;
			gint _param_index = 0;
			_tmp58_ = self->priv->parameters;
			_tmp59_ = _vala_iterable_ref0 (_tmp58_);
			_param_list = _tmp59_;
			_tmp60_ = _param_list;
			_tmp61_ = vala_collection_get_size ((ValaCollection*) _tmp60_);
			_tmp62_ = _tmp61_;
			_param_size = _tmp62_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp63_;
				gint _tmp64_;
				gint _tmp65_;
				ValaParameter* param = NULL;
				ValaList* _tmp66_;
				gint _tmp67_;
				gpointer _tmp68_;
				ValaMethod* _tmp69_;
				ValaParameter* _tmp70_;
				_tmp63_ = _param_index;
				_param_index = _tmp63_ + 1;
				_tmp64_ = _param_index;
				_tmp65_ = _param_size;
				if (!(_tmp64_ < _tmp65_)) {
					break;
				}
				_tmp66_ = _param_list;
				_tmp67_ = _param_index;
				_tmp68_ = vala_list_get (_tmp66_, _tmp67_);
				param = (ValaParameter*) _tmp68_;
				_tmp69_ = self->priv->_default_handler;
				_tmp70_ = param;
				vala_callable_add_parameter ((ValaCallable*) _tmp69_, _tmp70_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp71_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp72_ = _tmp71_;
		_tmp73_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp72_, VALA_TYPE_OBJECT_TYPE_SYMBOL) ? ((ValaObjectTypeSymbol*) _tmp72_) : NULL);
		cl = _tmp73_;
		_tmp74_ = cl;
		_tmp75_ = self->priv->_default_handler;
		vala_object_type_symbol_add_hidden_method (_tmp74_, _tmp75_);
		_tmp76_ = self->priv->_default_handler;
		_tmp77_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp76_, _tmp77_);
		_vala_code_node_unref0 (cl);
	}
	_tmp79_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp80_ = _tmp79_;
	if (!_tmp80_) {
		ValaAttribute* _tmp81_;
		ValaAttribute* _tmp82_;
		_tmp81_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "HasEmitter");
		_tmp82_ = _tmp81_;
		_tmp78_ = _tmp82_ != NULL;
		_vala_code_node_unref0 (_tmp82_);
	} else {
		_tmp78_ = FALSE;
	}
	if (_tmp78_) {
		const gchar* _tmp83_;
		const gchar* _tmp84_;
		ValaDataType* _tmp85_;
		ValaDataType* _tmp86_;
		ValaSourceReference* _tmp87_;
		ValaSourceReference* _tmp88_;
		ValaMethod* _tmp89_;
		ValaMethod* _tmp90_;
		ValaMethod* _tmp91_;
		ValaScope* _tmp92_;
		ValaScope* _tmp93_;
		ValaMethod* _tmp94_;
		ValaSymbolAccessibility _tmp95_;
		ValaSymbolAccessibility _tmp96_;
		ValaBlock* body = NULL;
		ValaSourceReference* _tmp97_;
		ValaSourceReference* _tmp98_;
		ValaBlock* _tmp99_;
		ValaMethodCall* call = NULL;
		const gchar* _tmp100_;
		const gchar* _tmp101_;
		ValaSourceReference* _tmp102_;
		ValaSourceReference* _tmp103_;
		ValaMemberAccess* _tmp104_;
		ValaMemberAccess* _tmp105_;
		ValaSourceReference* _tmp106_;
		ValaSourceReference* _tmp107_;
		ValaMethodCall* _tmp108_;
		ValaMethodCall* _tmp109_;
		ValaDataType* _tmp131_;
		ValaDataType* _tmp132_;
		ValaMethod* _tmp145_;
		ValaBlock* _tmp146_;
		ValaObjectTypeSymbol* cl = NULL;
		ValaSymbol* _tmp147_;
		ValaSymbol* _tmp148_;
		ValaObjectTypeSymbol* _tmp149_;
		ValaObjectTypeSymbol* _tmp150_;
		ValaMethod* _tmp151_;
		ValaMethod* _tmp152_;
		ValaCodeContext* _tmp153_;
		_tmp83_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp84_ = _tmp83_;
		_tmp85_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp86_ = _tmp85_;
		_tmp87_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp88_ = _tmp87_;
		_tmp89_ = vala_method_new (_tmp84_, _tmp86_, _tmp88_, NULL);
		_tmp90_ = _tmp89_;
		vala_signal_set_emitter (self, _tmp90_);
		_vala_code_node_unref0 (_tmp90_);
		_tmp91_ = self->priv->_emitter;
		_tmp92_ = vala_symbol_get_owner ((ValaSymbol*) self);
		_tmp93_ = _tmp92_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp91_, _tmp93_);
		_tmp94_ = self->priv->_emitter;
		_tmp95_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp96_ = _tmp95_;
		vala_symbol_set_access ((ValaSymbol*) _tmp94_, _tmp96_);
		_tmp97_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp98_ = _tmp97_;
		_tmp99_ = vala_block_new (_tmp98_);
		body = _tmp99_;
		_tmp100_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp101_ = _tmp100_;
		_tmp102_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp103_ = _tmp102_;
		_tmp104_ = vala_member_access_new_simple (_tmp101_, _tmp103_);
		_tmp105_ = _tmp104_;
		_tmp106_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp107_ = _tmp106_;
		_tmp108_ = vala_method_call_new ((ValaExpression*) _tmp105_, _tmp107_);
		_tmp109_ = _tmp108_;
		_vala_code_node_unref0 (_tmp105_);
		call = _tmp109_;
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp110_;
			ValaList* _tmp111_;
			gint _param_size = 0;
			ValaList* _tmp112_;
			gint _tmp113_;
			gint _tmp114_;
			gint _param_index = 0;
			_tmp110_ = self->priv->parameters;
			_tmp111_ = _vala_iterable_ref0 (_tmp110_);
			_param_list = _tmp111_;
			_tmp112_ = _param_list;
			_tmp113_ = vala_collection_get_size ((ValaCollection*) _tmp112_);
			_tmp114_ = _tmp113_;
			_param_size = _tmp114_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp115_;
				gint _tmp116_;
				gint _tmp117_;
				ValaParameter* param = NULL;
				ValaList* _tmp118_;
				gint _tmp119_;
				gpointer _tmp120_;
				ValaMethod* _tmp121_;
				ValaParameter* _tmp122_;
				ValaMethodCall* _tmp123_;
				ValaParameter* _tmp124_;
				const gchar* _tmp125_;
				const gchar* _tmp126_;
				ValaSourceReference* _tmp127_;
				ValaSourceReference* _tmp128_;
				ValaMemberAccess* _tmp129_;
				ValaMemberAccess* _tmp130_;
				_tmp115_ = _param_index;
				_param_index = _tmp115_ + 1;
				_tmp116_ = _param_index;
				_tmp117_ = _param_size;
				if (!(_tmp116_ < _tmp117_)) {
					break;
				}
				_tmp118_ = _param_list;
				_tmp119_ = _param_index;
				_tmp120_ = vala_list_get (_tmp118_, _tmp119_);
				param = (ValaParameter*) _tmp120_;
				_tmp121_ = self->priv->_emitter;
				_tmp122_ = param;
				vala_callable_add_parameter ((ValaCallable*) _tmp121_, _tmp122_);
				_tmp123_ = call;
				_tmp124_ = param;
				_tmp125_ = vala_symbol_get_name ((ValaSymbol*) _tmp124_);
				_tmp126_ = _tmp125_;
				_tmp127_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp128_ = _tmp127_;
				_tmp129_ = vala_member_access_new_simple (_tmp126_, _tmp128_);
				_tmp130_ = _tmp129_;
				vala_method_call_add_argument (_tmp123_, (ValaExpression*) _tmp130_);
				_vala_code_node_unref0 (_tmp130_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp131_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp132_ = _tmp131_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp132_, VALA_TYPE_VOID_TYPE)) {
			ValaBlock* _tmp133_;
			ValaMethodCall* _tmp134_;
			ValaSourceReference* _tmp135_;
			ValaSourceReference* _tmp136_;
			ValaExpressionStatement* _tmp137_;
			ValaExpressionStatement* _tmp138_;
			_tmp133_ = body;
			_tmp134_ = call;
			_tmp135_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp136_ = _tmp135_;
			_tmp137_ = vala_expression_statement_new ((ValaExpression*) _tmp134_, _tmp136_);
			_tmp138_ = _tmp137_;
			vala_block_add_statement (_tmp133_, (ValaStatement*) _tmp138_);
			_vala_code_node_unref0 (_tmp138_);
		} else {
			ValaBlock* _tmp139_;
			ValaMethodCall* _tmp140_;
			ValaSourceReference* _tmp141_;
			ValaSourceReference* _tmp142_;
			ValaReturnStatement* _tmp143_;
			ValaReturnStatement* _tmp144_;
			_tmp139_ = body;
			_tmp140_ = call;
			_tmp141_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp142_ = _tmp141_;
			_tmp143_ = vala_return_statement_new ((ValaExpression*) _tmp140_, _tmp142_);
			_tmp144_ = _tmp143_;
			vala_block_add_statement (_tmp139_, (ValaStatement*) _tmp144_);
			_vala_code_node_unref0 (_tmp144_);
		}
		_tmp145_ = self->priv->_emitter;
		_tmp146_ = body;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp145_, _tmp146_);
		_tmp147_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp148_ = _tmp147_;
		_tmp149_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp148_, VALA_TYPE_OBJECT_TYPE_SYMBOL) ? ((ValaObjectTypeSymbol*) _tmp148_) : NULL);
		cl = _tmp149_;
		_tmp150_ = cl;
		_tmp151_ = self->priv->_emitter;
		vala_object_type_symbol_add_hidden_method (_tmp150_, _tmp151_);
		_tmp152_ = self->priv->_emitter;
		_tmp153_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp152_, _tmp153_);
		_vala_code_node_unref0 (cl);
		_vala_code_node_unref0 (call);
		_vala_code_node_unref0 (body);
	}
	_tmp156_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp157_ = _tmp156_;
	if (!_tmp157_) {
		gboolean _tmp158_;
		gboolean _tmp159_;
		_tmp158_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp159_ = _tmp158_;
		_tmp155_ = !_tmp159_;
	} else {
		_tmp155_ = FALSE;
	}
	if (_tmp155_) {
		ValaSymbol* _tmp160_;
		ValaSymbol* _tmp161_;
		_tmp160_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp161_ = _tmp160_;
		_tmp154_ = _tmp161_ != NULL;
		_vala_code_node_unref0 (_tmp161_);
	} else {
		_tmp154_ = FALSE;
	}
	if (_tmp154_) {
		ValaSourceReference* _tmp162_;
		ValaSourceReference* _tmp163_;
		gchar* _tmp164_;
		gchar* _tmp165_;
		ValaSymbol* _tmp166_;
		ValaSymbol* _tmp167_;
		gchar* _tmp168_;
		gchar* _tmp169_;
		gchar* _tmp170_;
		gchar* _tmp171_;
		_tmp162_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp163_ = _tmp162_;
		_tmp164_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp165_ = _tmp164_;
		_tmp166_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp167_ = _tmp166_;
		_tmp168_ = vala_symbol_get_full_name (_tmp167_);
		_tmp169_ = _tmp168_;
		_tmp170_ = g_strdup_printf ("%s hides inherited signal `%s'. Use the `new' keyword if hiding was in" \
"tentional", _tmp165_, _tmp169_);
		_tmp171_ = _tmp170_;
		vala_report_warning (_tmp163_, _tmp171_);
		_g_free0 (_tmp171_);
		_g_free0 (_tmp169_);
		_vala_code_node_unref0 (_tmp167_);
		_g_free0 (_tmp165_);
	}
	_tmp172_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp173_ = _tmp172_;
	result = !_tmp173_;
	return result;
}


static ValaDataType* vala_signal_real_get_return_type (ValaCallable* base) {
	ValaDataType* result;
	ValaSignal* self;
	ValaDataType* _tmp0_;
	self = (ValaSignal*) base;
	_tmp0_ = self->priv->_return_type;
	result = _tmp0_;
	return result;
}


static void vala_signal_real_set_return_type (ValaCallable* base, ValaDataType* value) {
	ValaSignal* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	self = (ValaSignal*) base;
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_return_type);
	self->priv->_return_type = _tmp1_;
	_tmp2_ = self->priv->_return_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


ValaBlock* vala_signal_get_body (ValaSignal* self) {
	ValaBlock* result;
	ValaBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_body;
	result = _tmp0_;
	return result;
}


void vala_signal_set_body (ValaSignal* self, ValaBlock* value) {
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	ValaBlock* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_body);
	self->priv->_body = _tmp1_;
	_tmp2_ = self->priv->_body;
	if (_tmp2_ != NULL) {
		ValaBlock* _tmp3_;
		ValaScope* _tmp4_;
		ValaScope* _tmp5_;
		_tmp3_ = self->priv->_body;
		_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp5_ = _tmp4_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp3_, _tmp5_);
	}
}


gboolean vala_signal_get_is_virtual (ValaSignal* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_virtual;
	result = _tmp0_;
	return result;
}


void vala_signal_set_is_virtual (ValaSignal* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_virtual = _tmp0_;
}


ValaMethod* vala_signal_get_default_handler (ValaSignal* self) {
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_handler;
	result = _tmp0_;
	return result;
}


static void vala_signal_set_default_handler (ValaSignal* self, ValaMethod* value) {
	ValaMethod* _tmp0_;
	ValaMethod* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_default_handler);
	self->priv->_default_handler = _tmp1_;
}


ValaMethod* vala_signal_get_emitter (ValaSignal* self) {
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_emitter;
	result = _tmp0_;
	return result;
}


static void vala_signal_set_emitter (ValaSignal* self, ValaMethod* value) {
	ValaMethod* _tmp0_;
	ValaMethod* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_emitter);
	self->priv->_emitter = _tmp1_;
}


static void vala_signal_class_init (ValaSignalClass * klass) {
	vala_signal_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_signal_finalize;
	g_type_class_add_private (klass, sizeof (ValaSignalPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_signal_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_signal_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode *, ValaDataType*, ValaDataType*)) vala_signal_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_signal_real_check;
}


static void vala_signal_vala_lockable_interface_init (ValaLockableIface * iface) {
	vala_signal_vala_lockable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_lock_used = (gboolean (*) (ValaLockable *)) vala_signal_real_get_lock_used;
	iface->set_lock_used = (void (*) (ValaLockable *, gboolean)) vala_signal_real_set_lock_used;
}


static void vala_signal_vala_callable_interface_init (ValaCallableIface * iface) {
	vala_signal_vala_callable_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_parameter = (void (*) (ValaCallable *, ValaParameter*)) vala_signal_real_add_parameter;
	iface->get_parameters = (ValaList* (*) (ValaCallable *)) vala_signal_real_get_parameters;
	iface->get_return_type = vala_signal_real_get_return_type;
	iface->set_return_type = vala_signal_real_set_return_type;
}


static void vala_signal_instance_init (ValaSignal * self) {
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_SIGNAL_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->parameters = (ValaList*) _tmp1_;
	self->priv->lock_used = FALSE;
}


static void vala_signal_finalize (ValaCodeNode * obj) {
	ValaSignal * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_SIGNAL, ValaSignal);
	_vala_iterable_unref0 (self->priv->parameters);
	_vala_code_node_unref0 (self->priv->_default_handler);
	_vala_code_node_unref0 (self->priv->_emitter);
	_vala_code_node_unref0 (self->priv->_return_type);
	_vala_code_node_unref0 (self->priv->_body);
	VALA_CODE_NODE_CLASS (vala_signal_parent_class)->finalize (obj);
}


/**
 * Represents an object signal. Signals enable objects to provide notifications.
 */
GType vala_signal_get_type (void) {
	static volatile gsize vala_signal_type_id__volatile = 0;
	if (g_once_init_enter (&vala_signal_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaSignalClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_signal_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSignal), 0, (GInstanceInitFunc) vala_signal_instance_init, NULL };
		static const GInterfaceInfo vala_lockable_info = { (GInterfaceInitFunc) vala_signal_vala_lockable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo vala_callable_info = { (GInterfaceInitFunc) vala_signal_vala_callable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_signal_type_id;
		vala_signal_type_id = g_type_register_static (VALA_TYPE_SYMBOL, "ValaSignal", &g_define_type_info, 0);
		g_type_add_interface_static (vala_signal_type_id, VALA_TYPE_LOCKABLE, &vala_lockable_info);
		g_type_add_interface_static (vala_signal_type_id, VALA_TYPE_CALLABLE, &vala_callable_info);
		g_once_init_leave (&vala_signal_type_id__volatile, vala_signal_type_id);
	}
	return vala_signal_type_id__volatile;
}



