/* valamethodcall.c generated by valac, the Vala compiler
 * generated from valamethodcall.vala, do not modify */

/* valamethodcall.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

enum  {
	VALA_METHOD_CALL_0_PROPERTY,
	VALA_METHOD_CALL_NUM_PROPERTIES
};
static GParamSpec* vala_method_call_properties[VALA_METHOD_CALL_NUM_PROPERTIES];
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

struct _ValaMethodCallPrivate {
	gboolean _is_yield_expression;
	gboolean _is_assert;
	gboolean _is_constructv_chainup;
	gboolean _is_chainup;
	ValaExpression* _call;
	ValaList* argument_list;
};


static gpointer vala_method_call_parent_class = NULL;

#define VALA_METHOD_CALL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_METHOD_CALL, ValaMethodCallPrivate))
static void vala_method_call_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_method_call_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_method_call_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static gboolean vala_method_call_real_is_constant (ValaExpression* base);
static gboolean vala_method_call_real_is_pure (ValaExpression* base);
static gboolean vala_method_call_real_is_accessible (ValaExpression* base, ValaSymbol* sym);
static gboolean vala_method_call_real_check (ValaCodeNode* base, ValaCodeContext* context);
static void vala_method_call_set_is_assert (ValaMethodCall* self, gboolean value);
static void vala_method_call_set_is_chainup (ValaMethodCall* self, gboolean value);
static void vala_method_call_set_is_constructv_chainup (ValaMethodCall* self, gboolean value);
static void vala_method_call_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen);
static void vala_method_call_real_get_defined_variables (ValaCodeNode* base, ValaCollection* collection);
static void vala_method_call_real_get_used_variables (ValaCodeNode* base, ValaCollection* collection);
static void vala_method_call_finalize (ValaCodeNode * obj);


/**
 * Creates a new invocation expression.
 *
 * @param call             method to call
 * @param source_reference reference to source code
 * @return                 newly created invocation expression
 */
ValaMethodCall* vala_method_call_construct (GType object_type, ValaExpression* call, ValaSourceReference* source_reference) {
	ValaMethodCall* self = NULL;
	ValaSourceReference* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_val_if_fail (call != NULL, NULL);
	self = (ValaMethodCall*) vala_expression_construct (object_type);
	_tmp0_ = source_reference;
	vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp0_);
	_tmp1_ = call;
	vala_method_call_set_call (self, _tmp1_);
	return self;
}


ValaMethodCall* vala_method_call_new (ValaExpression* call, ValaSourceReference* source_reference) {
	return vala_method_call_construct (VALA_TYPE_METHOD_CALL, call, source_reference);
}


/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
void vala_method_call_add_argument (ValaMethodCall* self, ValaExpression* arg) {
	ValaList* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	_tmp1_ = arg;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = arg;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the argument list.
 *
 * @return argument list
 */
static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vala_method_call_get_argument_list (ValaMethodCall* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->argument_list;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void vala_method_call_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaMethodCall * self;
	ValaCodeVisitor* _tmp0_;
	ValaCodeVisitor* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_method_call (_tmp0_, self);
	_tmp1_ = visitor;
	vala_code_visitor_visit_expression (_tmp1_, (ValaExpression*) self);
}


static void vala_method_call_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCodeVisitor* _tmp2_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, _tmp2_);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp3_;
		ValaList* _tmp4_;
		gint _expr_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _expr_index = 0;
		_tmp3_ = self->priv->argument_list;
		_tmp4_ = _vala_iterable_ref0 (_tmp3_);
		_expr_list = _tmp4_;
		_tmp5_ = _expr_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_expr_size = _tmp7_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			ValaExpression* expr = NULL;
			ValaList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			ValaExpression* _tmp14_;
			ValaCodeVisitor* _tmp15_;
			_tmp8_ = _expr_index;
			_expr_index = _tmp8_ + 1;
			_tmp9_ = _expr_index;
			_tmp10_ = _expr_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _expr_list;
			_tmp12_ = _expr_index;
			_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
			expr = (ValaExpression*) _tmp13_;
			_tmp14_ = expr;
			_tmp15_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp14_, _tmp15_);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
}


static void vala_method_call_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	gint index = 0;
	ValaList* _tmp4_;
	ValaExpression* _tmp5_;
	gint _tmp6_;
	gboolean _tmp7_ = FALSE;
	gint _tmp8_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_node;
	if (_tmp1_ == _tmp2_) {
		ValaExpression* _tmp3_;
		_tmp3_ = new_node;
		vala_method_call_set_call (self, _tmp3_);
	}
	_tmp4_ = self->priv->argument_list;
	_tmp5_ = old_node;
	_tmp6_ = vala_list_index_of (_tmp4_, _tmp5_);
	index = _tmp6_;
	_tmp8_ = index;
	if (_tmp8_ >= 0) {
		ValaExpression* _tmp9_;
		ValaCodeNode* _tmp10_;
		ValaCodeNode* _tmp11_;
		_tmp9_ = new_node;
		_tmp10_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp7_ = _tmp11_ == NULL;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		ValaList* _tmp12_;
		gint _tmp13_;
		ValaExpression* _tmp14_;
		ValaExpression* _tmp15_;
		_tmp12_ = self->priv->argument_list;
		_tmp13_ = index;
		_tmp14_ = new_node;
		vala_list_set (_tmp12_, _tmp13_, _tmp14_);
		_tmp15_ = new_node;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp15_, (ValaCodeNode*) self);
	}
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean vala_method_call_real_is_constant (ValaExpression* base) {
	ValaMethodCall * self;
	gboolean result = FALSE;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	ValaMethodType* _tmp5_;
	self = (ValaMethodCall*) base;
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_METHOD_TYPE) ? ((ValaMethodType*) _tmp3_) : NULL);
	method_type = _tmp4_;
	_tmp5_ = method_type;
	if (_tmp5_ != NULL) {
		ValaMethodType* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gboolean _tmp11_;
		_tmp6_ = method_type;
		_tmp7_ = vala_method_type_get_method_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strcmp0 (_tmp10_, "GLib.N_") == 0;
		_g_free0 (_tmp10_);
		if (_tmp11_) {
			ValaList* _tmp12_;
			gpointer _tmp13_;
			ValaExpression* _tmp14_;
			gboolean _tmp15_;
			gboolean _tmp16_;
			_tmp12_ = self->priv->argument_list;
			_tmp13_ = vala_list_get (_tmp12_, 0);
			_tmp14_ = (ValaExpression*) _tmp13_;
			_tmp15_ = vala_expression_is_constant (_tmp14_);
			_tmp16_ = _tmp15_;
			_vala_code_node_unref0 (_tmp14_);
			result = _tmp16_;
			_vala_code_node_unref0 (method_type);
			return result;
		} else {
			ValaMethodType* _tmp17_;
			ValaMethod* _tmp18_;
			ValaMethod* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gboolean _tmp22_;
			_tmp17_ = method_type;
			_tmp18_ = vala_method_type_get_method_symbol (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = g_strcmp0 (_tmp21_, "GLib.NC_") == 0;
			_g_free0 (_tmp21_);
			if (_tmp22_) {
				ValaList* _tmp23_;
				gpointer _tmp24_;
				ValaExpression* _tmp25_;
				gboolean _tmp26_;
				gboolean _tmp27_;
				_tmp23_ = self->priv->argument_list;
				_tmp24_ = vala_list_get (_tmp23_, 1);
				_tmp25_ = (ValaExpression*) _tmp24_;
				_tmp26_ = vala_expression_is_constant (_tmp25_);
				_tmp27_ = _tmp26_;
				_vala_code_node_unref0 (_tmp25_);
				result = _tmp27_;
				_vala_code_node_unref0 (method_type);
				return result;
			}
		}
	}
	result = FALSE;
	_vala_code_node_unref0 (method_type);
	return result;
}


static gboolean vala_method_call_real_is_pure (ValaExpression* base) {
	ValaMethodCall * self;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	result = FALSE;
	return result;
}


static gboolean vala_method_call_real_is_accessible (ValaExpression* base, ValaSymbol* sym) {
	ValaMethodCall * self;
	gboolean result = FALSE;
	ValaExpression* _tmp14_;
	ValaExpression* _tmp15_;
	ValaSymbol* _tmp16_;
	gboolean _tmp17_;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			ValaSymbol* _tmp12_;
			gboolean _tmp13_;
			_tmp5_ = _arg_index;
			_arg_index = _tmp5_ + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = _arg_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			arg = (ValaExpression*) _tmp10_;
			_tmp11_ = arg;
			_tmp12_ = sym;
			_tmp13_ = vala_expression_is_accessible (_tmp11_, _tmp12_);
			if (!_tmp13_) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp14_ = vala_method_call_get_call (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = sym;
	_tmp17_ = vala_expression_is_accessible (_tmp15_, _tmp16_);
	result = _tmp17_;
	return result;
}


static gboolean vala_method_call_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaMethodCall * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaCodeContext* _tmp6_;
	gboolean _tmp7_;
	ValaDataType* target_object_type = NULL;
	ValaList* method_type_args = NULL;
	ValaExpression* _tmp8_;
	ValaExpression* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp111_;
	ValaExpression* _tmp112_;
	ValaDataType* _tmp113_;
	ValaDataType* _tmp114_;
	ValaDataType* _tmp115_;
	gboolean gobject_chainup = FALSE;
	ValaExpression* _tmp116_;
	ValaExpression* _tmp117_;
	ValaSymbol* _tmp118_;
	ValaSymbol* _tmp119_;
	ValaCodeContext* _tmp120_;
	ValaSemanticAnalyzer* _tmp121_;
	ValaSemanticAnalyzer* _tmp122_;
	ValaClass* _tmp123_;
	gboolean _tmp124_;
	gboolean _tmp125_;
	ValaCreationMethod* base_cm = NULL;
	gboolean _tmp148_;
	gboolean _tmp246_ = FALSE;
	ValaExpression* _tmp247_;
	ValaExpression* _tmp248_;
	gboolean _tmp327_ = FALSE;
	gboolean _tmp328_;
	ValaDataType* ret_type = NULL;
	ValaDataType* _tmp344_;
	ValaDataType* _tmp345_;
	ValaList* params = NULL;
	ValaDataType* _tmp346_;
	ValaList* _tmp347_;
	ValaDataType* _tmp348_;
	ValaExpression* last_arg = NULL;
	ValaList* args = NULL;
	ValaList* _tmp421_;
	ValaIterator* arg_it = NULL;
	ValaList* _tmp422_;
	ValaIterator* _tmp423_;
	gboolean _tmp477_ = FALSE;
	ValaDataType* _tmp478_;
	gboolean _tmp503_ = FALSE;
	ValaDataType* _tmp504_;
	ValaDataType* _tmp582_;
	ValaDataType* _tmp593_;
	ValaDataType* _tmp594_;
	ValaDataType* _tmp595_;
	ValaDataType* _tmp596_;
	ValaDataType* _tmp597_;
	ValaDataType* _tmp598_;
	ValaList* _tmp599_;
	ValaDataType* _tmp600_;
	ValaDataType* _tmp601_;
	gboolean may_throw = FALSE;
	ValaDataType* _tmp602_;
	ValaCodeContext* _tmp912_;
	ValaSemanticAnalyzer* _tmp913_;
	ValaSemanticAnalyzer* _tmp914_;
	ValaDataType* _tmp915_;
	ValaList* _tmp916_;
	ValaList* _tmp917_;
	ValaList* _tmp918_;
	gboolean _tmp919_;
	gboolean _tmp920_;
	gboolean _tmp921_ = FALSE;
	gboolean _tmp922_ = FALSE;
	ValaCreationMethod* _tmp923_;
	gboolean _tmp954_;
	gboolean _tmp1013_;
	gboolean _tmp1014_;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_method_call_get_call (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = context;
	_tmp7_ = vala_code_node_check ((ValaCodeNode*) _tmp5_, _tmp6_);
	if (!_tmp7_) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	target_object_type = NULL;
	method_type_args = NULL;
	_tmp8_ = vala_method_call_get_call (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_expression_get_value_type (_tmp9_);
	_tmp11_ = _tmp10_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, VALA_TYPE_DELEGATE_TYPE)) {
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		ValaDataType* _tmp14_;
		ValaDataType* _tmp15_;
		ValaDataType* _tmp16_;
		_tmp12_ = vala_method_call_get_call (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_expression_get_value_type (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = _vala_code_node_ref0 (_tmp15_);
		_vala_code_node_unref0 (target_object_type);
		target_object_type = _tmp16_;
	} else {
		ValaExpression* _tmp17_;
		ValaExpression* _tmp18_;
		_tmp17_ = vala_method_call_get_call (self);
		_tmp18_ = _tmp17_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, VALA_TYPE_MEMBER_ACCESS)) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp19_;
			ValaExpression* _tmp20_;
			ValaMemberAccess* _tmp21_;
			ValaMemberAccess* _tmp22_;
			gboolean _tmp23_;
			gboolean _tmp24_;
			ValaMemberAccess* _tmp35_;
			ValaList* _tmp36_;
			ValaMemberAccess* _tmp37_;
			ValaExpression* _tmp38_;
			ValaExpression* _tmp39_;
			gboolean _tmp93_ = FALSE;
			ValaMemberAccess* _tmp94_;
			ValaSymbol* _tmp95_;
			ValaSymbol* _tmp96_;
			_tmp19_ = vala_method_call_get_call (self);
			_tmp20_ = _tmp19_;
			_tmp21_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp21_;
			_tmp22_ = ma;
			_tmp23_ = vala_member_access_get_prototype_access (_tmp22_);
			_tmp24_ = _tmp23_;
			if (_tmp24_) {
				ValaSourceReference* _tmp25_;
				ValaSourceReference* _tmp26_;
				ValaExpression* _tmp27_;
				ValaExpression* _tmp28_;
				ValaSymbol* _tmp29_;
				ValaSymbol* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp26_ = _tmp25_;
				_tmp27_ = vala_method_call_get_call (self);
				_tmp28_ = _tmp27_;
				_tmp29_ = vala_expression_get_symbol_reference (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = vala_symbol_get_full_name (_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp32_);
				_tmp34_ = _tmp33_;
				vala_report_error (_tmp26_, _tmp34_);
				_g_free0 (_tmp34_);
				_g_free0 (_tmp32_);
				result = FALSE;
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_tmp35_ = ma;
			_tmp36_ = vala_member_access_get_type_arguments (_tmp35_);
			_vala_iterable_unref0 (method_type_args);
			method_type_args = _tmp36_;
			_tmp37_ = ma;
			_tmp38_ = vala_member_access_get_inner (_tmp37_);
			_tmp39_ = _tmp38_;
			if (_tmp39_ != NULL) {
				ValaMemberAccess* _tmp40_;
				ValaExpression* _tmp41_;
				ValaExpression* _tmp42_;
				ValaDataType* _tmp43_;
				ValaDataType* _tmp44_;
				ValaDataType* _tmp45_;
				ValaMemberAccess* _tmp46_;
				ValaExpression* _tmp47_;
				ValaExpression* _tmp48_;
				ValaSymbol* _tmp49_;
				ValaSymbol* _tmp50_;
				ValaMethod* m = NULL;
				ValaMemberAccess* _tmp62_;
				ValaSymbol* _tmp63_;
				ValaSymbol* _tmp64_;
				ValaMethod* _tmp65_;
				gboolean _tmp66_ = FALSE;
				ValaMethod* _tmp67_;
				_tmp40_ = ma;
				_tmp41_ = vala_member_access_get_inner (_tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = vala_expression_get_value_type (_tmp42_);
				_tmp44_ = _tmp43_;
				_tmp45_ = _vala_code_node_ref0 (_tmp44_);
				_vala_code_node_unref0 (target_object_type);
				target_object_type = _tmp45_;
				_tmp46_ = ma;
				_tmp47_ = vala_member_access_get_inner (_tmp46_);
				_tmp48_ = _tmp47_;
				_tmp49_ = vala_expression_get_symbol_reference (_tmp48_);
				_tmp50_ = _tmp49_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp50_, VALA_TYPE_SIGNAL)) {
					ValaMemberAccess* sig = NULL;
					ValaMemberAccess* _tmp51_;
					ValaExpression* _tmp52_;
					ValaExpression* _tmp53_;
					ValaMemberAccess* _tmp54_;
					ValaMemberAccess* _tmp55_;
					_tmp51_ = ma;
					_tmp52_ = vala_member_access_get_inner (_tmp51_);
					_tmp53_ = _tmp52_;
					_tmp54_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp53_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp53_) : NULL);
					sig = _tmp54_;
					_tmp55_ = sig;
					if (_tmp55_ != NULL) {
						ValaMemberAccess* _tmp56_;
						ValaExpression* _tmp57_;
						ValaExpression* _tmp58_;
						ValaDataType* _tmp59_;
						ValaDataType* _tmp60_;
						ValaDataType* _tmp61_;
						_tmp56_ = sig;
						_tmp57_ = vala_member_access_get_inner (_tmp56_);
						_tmp58_ = _tmp57_;
						_tmp59_ = vala_expression_get_value_type (_tmp58_);
						_tmp60_ = _tmp59_;
						_tmp61_ = _vala_code_node_ref0 (_tmp60_);
						_vala_code_node_unref0 (target_object_type);
						target_object_type = _tmp61_;
					}
					_vala_code_node_unref0 (sig);
				}
				_tmp62_ = ma;
				_tmp63_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp62_);
				_tmp64_ = _tmp63_;
				_tmp65_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp64_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp64_) : NULL);
				m = _tmp65_;
				_tmp67_ = m;
				if (_tmp67_ != NULL) {
					ValaMethod* _tmp68_;
					gboolean _tmp69_;
					gboolean _tmp70_;
					_tmp68_ = m;
					_tmp69_ = vala_method_get_coroutine (_tmp68_);
					_tmp70_ = _tmp69_;
					_tmp66_ = _tmp70_;
				} else {
					_tmp66_ = FALSE;
				}
				if (_tmp66_) {
					gboolean _tmp71_ = FALSE;
					ValaMemberAccess* _tmp72_;
					const gchar* _tmp73_;
					const gchar* _tmp74_;
					_tmp72_ = ma;
					_tmp73_ = vala_member_access_get_member_name (_tmp72_);
					_tmp74_ = _tmp73_;
					if (g_strcmp0 (_tmp74_, "begin") == 0) {
						_tmp71_ = TRUE;
					} else {
						ValaMemberAccess* _tmp75_;
						const gchar* _tmp76_;
						const gchar* _tmp77_;
						_tmp75_ = ma;
						_tmp76_ = vala_member_access_get_member_name (_tmp75_);
						_tmp77_ = _tmp76_;
						_tmp71_ = g_strcmp0 (_tmp77_, "end") == 0;
					}
					if (_tmp71_) {
						ValaMemberAccess* method_access = NULL;
						ValaMemberAccess* _tmp78_;
						ValaExpression* _tmp79_;
						ValaExpression* _tmp80_;
						ValaMemberAccess* _tmp81_;
						gboolean _tmp82_ = FALSE;
						ValaMemberAccess* _tmp83_;
						_tmp78_ = ma;
						_tmp79_ = vala_member_access_get_inner (_tmp78_);
						_tmp80_ = _tmp79_;
						_tmp81_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp80_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp80_) : NULL);
						method_access = _tmp81_;
						_tmp83_ = method_access;
						if (_tmp83_ != NULL) {
							ValaMemberAccess* _tmp84_;
							ValaExpression* _tmp85_;
							ValaExpression* _tmp86_;
							_tmp84_ = method_access;
							_tmp85_ = vala_member_access_get_inner (_tmp84_);
							_tmp86_ = _tmp85_;
							_tmp82_ = _tmp86_ != NULL;
						} else {
							_tmp82_ = FALSE;
						}
						if (_tmp82_) {
							ValaMemberAccess* _tmp87_;
							ValaExpression* _tmp88_;
							ValaExpression* _tmp89_;
							ValaDataType* _tmp90_;
							ValaDataType* _tmp91_;
							ValaDataType* _tmp92_;
							_tmp87_ = method_access;
							_tmp88_ = vala_member_access_get_inner (_tmp87_);
							_tmp89_ = _tmp88_;
							_tmp90_ = vala_expression_get_value_type (_tmp89_);
							_tmp91_ = _tmp90_;
							_tmp92_ = _vala_code_node_ref0 (_tmp91_);
							_vala_code_node_unref0 (target_object_type);
							target_object_type = _tmp92_;
						} else {
							_vala_code_node_unref0 (target_object_type);
							target_object_type = NULL;
						}
						_vala_code_node_unref0 (method_access);
					}
				}
				_vala_code_node_unref0 (m);
			}
			_tmp94_ = ma;
			_tmp95_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp94_);
			_tmp96_ = _tmp95_;
			if (_tmp96_ != NULL) {
				ValaMemberAccess* _tmp97_;
				ValaSymbol* _tmp98_;
				ValaSymbol* _tmp99_;
				ValaAttribute* _tmp100_;
				ValaAttribute* _tmp101_;
				_tmp97_ = ma;
				_tmp98_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp97_);
				_tmp99_ = _tmp98_;
				_tmp100_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp99_, "Assert");
				_tmp101_ = _tmp100_;
				_tmp93_ = _tmp101_ != NULL;
				_vala_code_node_unref0 (_tmp101_);
			} else {
				_tmp93_ = FALSE;
			}
			if (_tmp93_) {
				ValaList* args = NULL;
				ValaList* _tmp102_;
				ValaList* _tmp103_;
				gint _tmp104_;
				gint _tmp105_;
				vala_method_call_set_is_assert (self, TRUE);
				_tmp102_ = vala_method_call_get_argument_list (self);
				args = _tmp102_;
				_tmp103_ = args;
				_tmp104_ = vala_collection_get_size ((ValaCollection*) _tmp103_);
				_tmp105_ = _tmp104_;
				if (_tmp105_ == 1) {
					ValaList* _tmp106_;
					gpointer _tmp107_;
					ValaExpression* _tmp108_;
					ValaSourceReference* _tmp109_;
					ValaSourceReference* _tmp110_;
					_tmp106_ = args;
					_tmp107_ = vala_list_get (_tmp106_, 0);
					_tmp108_ = (ValaExpression*) _tmp107_;
					_tmp109_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp108_);
					_tmp110_ = _tmp109_;
					vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp110_);
					_vala_code_node_unref0 (_tmp108_);
				}
				_vala_iterable_unref0 (args);
			}
			_vala_code_node_unref0 (ma);
		}
	}
	_tmp111_ = vala_method_call_get_call (self);
	_tmp112_ = _tmp111_;
	_tmp113_ = vala_expression_get_value_type (_tmp112_);
	_tmp114_ = _tmp113_;
	_tmp115_ = _vala_code_node_ref0 (_tmp114_);
	mtype = _tmp115_;
	_tmp116_ = vala_method_call_get_call (self);
	_tmp117_ = _tmp116_;
	_tmp118_ = vala_expression_get_symbol_reference (_tmp117_);
	_tmp119_ = _tmp118_;
	_tmp120_ = context;
	_tmp121_ = vala_code_context_get_analyzer (_tmp120_);
	_tmp122_ = _tmp121_;
	_tmp123_ = _tmp122_->object_type;
	gobject_chainup = _tmp119_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp123_, VALA_TYPE_SYMBOL, ValaSymbol);
	_tmp124_ = gobject_chainup;
	vala_method_call_set_is_chainup (self, _tmp124_);
	_tmp125_ = gobject_chainup;
	if (!_tmp125_) {
		ValaExpression* expr = NULL;
		ValaExpression* _tmp126_;
		ValaExpression* _tmp127_;
		ValaExpression* _tmp128_;
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp129_;
		ValaMemberAccess* _tmp130_;
		gboolean _tmp131_ = FALSE;
		ValaMemberAccess* _tmp132_;
		gboolean _tmp142_ = FALSE;
		ValaMemberAccess* _tmp143_;
		_tmp126_ = vala_method_call_get_call (self);
		_tmp127_ = _tmp126_;
		_tmp128_ = _vala_code_node_ref0 (_tmp127_);
		expr = _tmp128_;
		_tmp129_ = expr;
		_tmp130_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp129_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp129_) : NULL);
		ma = _tmp130_;
		_tmp132_ = ma;
		if (_tmp132_ != NULL) {
			ValaMemberAccess* _tmp133_;
			ValaSymbol* _tmp134_;
			ValaSymbol* _tmp135_;
			_tmp133_ = ma;
			_tmp134_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp133_);
			_tmp135_ = _tmp134_;
			_tmp131_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp135_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp131_ = FALSE;
		}
		if (_tmp131_) {
			ValaMemberAccess* _tmp136_;
			ValaExpression* _tmp137_;
			ValaExpression* _tmp138_;
			ValaExpression* _tmp139_;
			ValaExpression* _tmp140_;
			ValaMemberAccess* _tmp141_;
			_tmp136_ = ma;
			_tmp137_ = vala_member_access_get_inner (_tmp136_);
			_tmp138_ = _tmp137_;
			_tmp139_ = _vala_code_node_ref0 (_tmp138_);
			_vala_code_node_unref0 (expr);
			expr = _tmp139_;
			_tmp140_ = expr;
			_tmp141_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp140_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp140_) : NULL);
			_vala_code_node_unref0 (ma);
			ma = _tmp141_;
		}
		_tmp143_ = ma;
		if (_tmp143_ != NULL) {
			ValaMemberAccess* _tmp144_;
			const gchar* _tmp145_;
			const gchar* _tmp146_;
			_tmp144_ = ma;
			_tmp145_ = vala_member_access_get_member_name (_tmp144_);
			_tmp146_ = _tmp145_;
			_tmp142_ = g_strcmp0 (_tmp146_, "this") == 0;
		} else {
			_tmp142_ = FALSE;
		}
		if (_tmp142_) {
			vala_method_call_set_is_chainup (self, TRUE);
		} else {
			ValaExpression* _tmp147_;
			_tmp147_ = expr;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp147_, VALA_TYPE_BASE_ACCESS)) {
				vala_method_call_set_is_chainup (self, TRUE);
			}
		}
		_vala_code_node_unref0 (ma);
		_vala_code_node_unref0 (expr);
	}
	base_cm = NULL;
	_tmp148_ = self->priv->_is_chainup;
	if (_tmp148_) {
		ValaCreationMethod* cm = NULL;
		ValaCodeContext* _tmp149_;
		ValaSemanticAnalyzer* _tmp150_;
		ValaSemanticAnalyzer* _tmp151_;
		ValaMethod* _tmp152_;
		ValaCreationMethod* _tmp153_;
		ValaCreationMethod* _tmp154_;
		ValaCreationMethod* _tmp162_;
		ValaDataType* _tmp163_;
		_tmp149_ = context;
		_tmp150_ = vala_code_context_get_analyzer (_tmp149_);
		_tmp151_ = _tmp150_;
		_tmp152_ = vala_semantic_analyzer_find_current_method (_tmp151_);
		_tmp153_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp152_, VALA_TYPE_CREATION_METHOD) ? ((ValaCreationMethod*) _tmp152_) : NULL;
		if (_tmp153_ == NULL) {
			_vala_code_node_unref0 (_tmp152_);
		}
		cm = _tmp153_;
		_tmp154_ = cm;
		if (_tmp154_ == NULL) {
			ValaSourceReference* _tmp155_;
			ValaSourceReference* _tmp156_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp155_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp156_ = _tmp155_;
			vala_report_error (_tmp156_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (cm);
			_vala_code_node_unref0 (base_cm);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		} else {
			ValaCreationMethod* _tmp157_;
			gboolean _tmp158_;
			gboolean _tmp159_;
			_tmp157_ = cm;
			_tmp158_ = vala_creation_method_get_chain_up (_tmp157_);
			_tmp159_ = _tmp158_;
			if (_tmp159_) {
				ValaSourceReference* _tmp160_;
				ValaSourceReference* _tmp161_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp160_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp161_ = _tmp160_;
				vala_report_error (_tmp161_, "Multiple constructor calls in the same constructor are not permitted");
				result = FALSE;
				_vala_code_node_unref0 (cm);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
		_tmp162_ = cm;
		vala_creation_method_set_chain_up (_tmp162_, TRUE);
		_tmp163_ = mtype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp163_, VALA_TYPE_OBJECT_TYPE)) {
			ValaObjectType* otype = NULL;
			ValaDataType* _tmp164_;
			ValaObjectType* _tmp165_;
			ValaClass* cl = NULL;
			ValaObjectType* _tmp166_;
			ValaObjectTypeSymbol* _tmp167_;
			ValaObjectTypeSymbol* _tmp168_;
			ValaClass* _tmp169_;
			ValaClass* _tmp170_;
			ValaCreationMethod* _tmp171_;
			ValaCreationMethod* _tmp172_;
			ValaCreationMethod* _tmp173_;
			ValaCreationMethod* _tmp174_;
			_tmp164_ = mtype;
			_tmp165_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp164_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			otype = _tmp165_;
			_tmp166_ = otype;
			_tmp167_ = vala_object_type_get_type_symbol (_tmp166_);
			_tmp168_ = _tmp167_;
			_tmp169_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp168_, VALA_TYPE_CLASS, ValaClass));
			cl = _tmp169_;
			_tmp170_ = cl;
			_tmp171_ = vala_class_get_default_construction_method (_tmp170_);
			_tmp172_ = _tmp171_;
			_tmp173_ = _vala_code_node_ref0 (_tmp172_);
			_vala_code_node_unref0 (base_cm);
			base_cm = _tmp173_;
			_tmp174_ = base_cm;
			if (_tmp174_ == NULL) {
				ValaSourceReference* _tmp175_;
				ValaSourceReference* _tmp176_;
				ValaClass* _tmp177_;
				gchar* _tmp178_;
				gchar* _tmp179_;
				gchar* _tmp180_;
				gchar* _tmp181_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp175_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp176_ = _tmp175_;
				_tmp177_ = cl;
				_tmp178_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp177_);
				_tmp179_ = _tmp178_;
				_tmp180_ = g_strdup_printf ("chain up to `%s' not supported", _tmp179_);
				_tmp181_ = _tmp180_;
				vala_report_error (_tmp176_, _tmp181_);
				_g_free0 (_tmp181_);
				_g_free0 (_tmp179_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (otype);
				_vala_code_node_unref0 (cm);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaCreationMethod* _tmp182_;
				gboolean _tmp183_;
				gboolean _tmp184_;
				_tmp182_ = base_cm;
				_tmp183_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp182_);
				_tmp184_ = _tmp183_;
				if (!_tmp184_) {
					ValaSourceReference* _tmp185_;
					ValaSourceReference* _tmp186_;
					ValaCreationMethod* _tmp187_;
					gchar* _tmp188_;
					gchar* _tmp189_;
					gchar* _tmp190_;
					gchar* _tmp191_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp185_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp186_ = _tmp185_;
					_tmp187_ = base_cm;
					_tmp188_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp187_);
					_tmp189_ = _tmp188_;
					_tmp190_ = g_strdup_printf ("chain up to `%s' not supported", _tmp189_);
					_tmp191_ = _tmp190_;
					vala_report_error (_tmp186_, _tmp191_);
					_g_free0 (_tmp191_);
					_g_free0 (_tmp189_);
					result = FALSE;
					_vala_code_node_unref0 (cl);
					_vala_code_node_unref0 (otype);
					_vala_code_node_unref0 (cm);
					_vala_code_node_unref0 (base_cm);
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			}
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (otype);
		} else {
			gboolean _tmp192_ = FALSE;
			ValaExpression* _tmp193_;
			ValaExpression* _tmp194_;
			ValaSymbol* _tmp195_;
			ValaSymbol* _tmp196_;
			_tmp193_ = vala_method_call_get_call (self);
			_tmp194_ = _tmp193_;
			_tmp195_ = vala_expression_get_symbol_reference (_tmp194_);
			_tmp196_ = _tmp195_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp196_, VALA_TYPE_CREATION_METHOD)) {
				ValaExpression* _tmp197_;
				ValaExpression* _tmp198_;
				ValaSymbol* _tmp199_;
				ValaSymbol* _tmp200_;
				ValaSymbol* _tmp201_;
				ValaSymbol* _tmp202_;
				_tmp197_ = vala_method_call_get_call (self);
				_tmp198_ = _tmp197_;
				_tmp199_ = vala_expression_get_symbol_reference (_tmp198_);
				_tmp200_ = _tmp199_;
				_tmp201_ = vala_symbol_get_parent_symbol (_tmp200_);
				_tmp202_ = _tmp201_;
				_tmp192_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp202_, VALA_TYPE_CLASS);
			} else {
				_tmp192_ = FALSE;
			}
			if (_tmp192_) {
				ValaExpression* _tmp203_;
				ValaExpression* _tmp204_;
				ValaSymbol* _tmp205_;
				ValaSymbol* _tmp206_;
				ValaCreationMethod* _tmp207_;
				ValaCreationMethod* _tmp208_;
				gboolean _tmp209_;
				gboolean _tmp210_;
				_tmp203_ = vala_method_call_get_call (self);
				_tmp204_ = _tmp203_;
				_tmp205_ = vala_expression_get_symbol_reference (_tmp204_);
				_tmp206_ = _tmp205_;
				_tmp207_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp206_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
				_vala_code_node_unref0 (base_cm);
				base_cm = _tmp207_;
				_tmp208_ = base_cm;
				_tmp209_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp208_);
				_tmp210_ = _tmp209_;
				if (!_tmp210_) {
					ValaSourceReference* _tmp211_;
					ValaSourceReference* _tmp212_;
					ValaCreationMethod* _tmp213_;
					gchar* _tmp214_;
					gchar* _tmp215_;
					gchar* _tmp216_;
					gchar* _tmp217_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp211_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp212_ = _tmp211_;
					_tmp213_ = base_cm;
					_tmp214_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp213_);
					_tmp215_ = _tmp214_;
					_tmp216_ = g_strdup_printf ("chain up to `%s' not supported", _tmp215_);
					_tmp217_ = _tmp216_;
					vala_report_error (_tmp212_, _tmp217_);
					_g_free0 (_tmp217_);
					_g_free0 (_tmp215_);
					result = FALSE;
					_vala_code_node_unref0 (cm);
					_vala_code_node_unref0 (base_cm);
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			} else {
				gboolean _tmp218_;
				_tmp218_ = gobject_chainup;
				if (_tmp218_) {
					ValaClass* cl = NULL;
					ValaCreationMethod* _tmp219_;
					ValaSymbol* _tmp220_;
					ValaSymbol* _tmp221_;
					ValaClass* _tmp222_;
					gboolean _tmp223_ = FALSE;
					ValaClass* _tmp224_;
					ValaExpression* _tmp233_;
					ValaExpression* _tmp234_;
					ValaCodeContext* _tmp235_;
					ValaSemanticAnalyzer* _tmp236_;
					ValaSemanticAnalyzer* _tmp237_;
					ValaClass* _tmp238_;
					ValaObjectType* _tmp239_;
					ValaObjectType* _tmp240_;
					ValaExpression* _tmp241_;
					ValaExpression* _tmp242_;
					ValaDataType* _tmp243_;
					ValaDataType* _tmp244_;
					ValaDataType* _tmp245_;
					_tmp219_ = cm;
					_tmp220_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp219_);
					_tmp221_ = _tmp220_;
					_tmp222_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp221_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp221_) : NULL);
					cl = _tmp222_;
					_tmp224_ = cl;
					if (_tmp224_ == NULL) {
						_tmp223_ = TRUE;
					} else {
						ValaClass* _tmp225_;
						ValaCodeContext* _tmp226_;
						ValaSemanticAnalyzer* _tmp227_;
						ValaSemanticAnalyzer* _tmp228_;
						ValaClass* _tmp229_;
						gboolean _tmp230_;
						_tmp225_ = cl;
						_tmp226_ = context;
						_tmp227_ = vala_code_context_get_analyzer (_tmp226_);
						_tmp228_ = _tmp227_;
						_tmp229_ = _tmp228_->object_type;
						_tmp230_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp225_, (ValaTypeSymbol*) _tmp229_);
						_tmp223_ = !_tmp230_;
					}
					if (_tmp223_) {
						ValaSourceReference* _tmp231_;
						ValaSourceReference* _tmp232_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp231_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp232_ = _tmp231_;
						vala_report_error (_tmp232_, "chain up to `GLib.Object' not supported");
						result = FALSE;
						_vala_code_node_unref0 (cl);
						_vala_code_node_unref0 (cm);
						_vala_code_node_unref0 (base_cm);
						_vala_code_node_unref0 (mtype);
						_vala_iterable_unref0 (method_type_args);
						_vala_code_node_unref0 (target_object_type);
						return result;
					}
					_tmp233_ = vala_method_call_get_call (self);
					_tmp234_ = _tmp233_;
					_tmp235_ = context;
					_tmp236_ = vala_code_context_get_analyzer (_tmp235_);
					_tmp237_ = _tmp236_;
					_tmp238_ = _tmp237_->object_type;
					_tmp239_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp238_);
					_tmp240_ = _tmp239_;
					vala_expression_set_value_type (_tmp234_, (ValaDataType*) _tmp240_);
					_vala_code_node_unref0 (_tmp240_);
					_tmp241_ = vala_method_call_get_call (self);
					_tmp242_ = _tmp241_;
					_tmp243_ = vala_expression_get_value_type (_tmp242_);
					_tmp244_ = _tmp243_;
					_tmp245_ = _vala_code_node_ref0 (_tmp244_);
					_vala_code_node_unref0 (mtype);
					mtype = _tmp245_;
					_vala_code_node_unref0 (cl);
				}
			}
		}
		_vala_code_node_unref0 (cm);
	}
	_tmp247_ = vala_method_call_get_call (self);
	_tmp248_ = _tmp247_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp248_, VALA_TYPE_MEMBER_ACCESS)) {
		gboolean _tmp249_ = FALSE;
		gboolean _tmp250_ = FALSE;
		ValaExpression* _tmp251_;
		ValaExpression* _tmp252_;
		ValaSymbol* _tmp253_;
		ValaSymbol* _tmp254_;
		_tmp251_ = vala_method_call_get_call (self);
		_tmp252_ = _tmp251_;
		_tmp253_ = vala_expression_get_symbol_reference (_tmp252_);
		_tmp254_ = _tmp253_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp254_, VALA_TYPE_CREATION_METHOD)) {
			ValaExpression* _tmp255_;
			ValaExpression* _tmp256_;
			ValaSymbol* _tmp257_;
			ValaSymbol* _tmp258_;
			ValaSymbol* _tmp259_;
			ValaSymbol* _tmp260_;
			_tmp255_ = vala_method_call_get_call (self);
			_tmp256_ = _tmp255_;
			_tmp257_ = vala_expression_get_symbol_reference (_tmp256_);
			_tmp258_ = _tmp257_;
			_tmp259_ = vala_symbol_get_parent_symbol (_tmp258_);
			_tmp260_ = _tmp259_;
			_tmp250_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp260_, VALA_TYPE_STRUCT);
		} else {
			_tmp250_ = FALSE;
		}
		if (_tmp250_) {
			_tmp249_ = TRUE;
		} else {
			ValaExpression* _tmp261_;
			ValaExpression* _tmp262_;
			ValaSymbol* _tmp263_;
			ValaSymbol* _tmp264_;
			_tmp261_ = vala_method_call_get_call (self);
			_tmp262_ = _tmp261_;
			_tmp263_ = vala_expression_get_symbol_reference (_tmp262_);
			_tmp264_ = _tmp263_;
			_tmp249_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp264_, VALA_TYPE_STRUCT);
		}
		_tmp246_ = _tmp249_;
	} else {
		_tmp246_ = FALSE;
	}
	if (_tmp246_) {
		ValaStruct* st = NULL;
		ValaExpression* _tmp265_;
		ValaExpression* _tmp266_;
		ValaSymbol* _tmp267_;
		ValaSymbol* _tmp268_;
		ValaStruct* _tmp269_;
		gboolean _tmp270_ = FALSE;
		gboolean _tmp271_ = FALSE;
		ValaStruct* _tmp272_;
		ValaObjectCreationExpression* struct_creation_expression = NULL;
		ValaExpression* _tmp286_;
		ValaExpression* _tmp287_;
		ValaSourceReference* _tmp288_;
		ValaSourceReference* _tmp289_;
		ValaObjectCreationExpression* _tmp290_;
		ValaObjectCreationExpression* _tmp291_;
		ValaObjectCreationExpression* _tmp304_;
		ValaDataType* _tmp305_;
		ValaDataType* _tmp306_;
		ValaCodeContext* _tmp307_;
		ValaSemanticAnalyzer* _tmp308_;
		ValaSemanticAnalyzer* _tmp309_;
		ValaList* _tmp310_;
		ValaCodeNode* _tmp311_;
		ValaCodeNode* _tmp312_;
		ValaObjectCreationExpression* _tmp313_;
		ValaObjectCreationExpression* _tmp314_;
		ValaCodeContext* _tmp315_;
		_tmp265_ = vala_method_call_get_call (self);
		_tmp266_ = _tmp265_;
		_tmp267_ = vala_expression_get_symbol_reference (_tmp266_);
		_tmp268_ = _tmp267_;
		_tmp269_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp268_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp268_) : NULL);
		st = _tmp269_;
		_tmp272_ = st;
		if (_tmp272_ != NULL) {
			ValaStruct* _tmp273_;
			ValaMethod* _tmp274_;
			ValaMethod* _tmp275_;
			_tmp273_ = st;
			_tmp274_ = vala_struct_get_default_construction_method (_tmp273_);
			_tmp275_ = _tmp274_;
			_tmp271_ = _tmp275_ == NULL;
		} else {
			_tmp271_ = FALSE;
		}
		if (_tmp271_) {
			gboolean _tmp276_ = FALSE;
			gboolean _tmp277_ = FALSE;
			ValaStruct* _tmp278_;
			gboolean _tmp279_;
			_tmp278_ = st;
			_tmp279_ = vala_struct_is_boolean_type (_tmp278_);
			if (_tmp279_) {
				_tmp277_ = TRUE;
			} else {
				ValaStruct* _tmp280_;
				gboolean _tmp281_;
				_tmp280_ = st;
				_tmp281_ = vala_struct_is_integer_type (_tmp280_);
				_tmp277_ = _tmp281_;
			}
			if (_tmp277_) {
				_tmp276_ = TRUE;
			} else {
				ValaStruct* _tmp282_;
				gboolean _tmp283_;
				_tmp282_ = st;
				_tmp283_ = vala_struct_is_floating_type (_tmp282_);
				_tmp276_ = _tmp283_;
			}
			_tmp270_ = _tmp276_;
		} else {
			_tmp270_ = FALSE;
		}
		if (_tmp270_) {
			ValaSourceReference* _tmp284_;
			ValaSourceReference* _tmp285_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp284_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp285_ = _tmp284_;
			vala_report_error (_tmp285_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (base_cm);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
		_tmp286_ = vala_method_call_get_call (self);
		_tmp287_ = _tmp286_;
		_tmp288_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp289_ = _tmp288_;
		_tmp290_ = vala_object_creation_expression_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp287_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess), _tmp289_);
		struct_creation_expression = _tmp290_;
		_tmp291_ = struct_creation_expression;
		vala_object_creation_expression_set_struct_creation (_tmp291_, TRUE);
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp292_;
			gint _arg_size = 0;
			ValaList* _tmp293_;
			gint _tmp294_;
			gint _tmp295_;
			gint _arg_index = 0;
			_tmp292_ = vala_method_call_get_argument_list (self);
			_arg_list = _tmp292_;
			_tmp293_ = _arg_list;
			_tmp294_ = vala_collection_get_size ((ValaCollection*) _tmp293_);
			_tmp295_ = _tmp294_;
			_arg_size = _tmp295_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp296_;
				gint _tmp297_;
				gint _tmp298_;
				ValaExpression* arg = NULL;
				ValaList* _tmp299_;
				gint _tmp300_;
				gpointer _tmp301_;
				ValaObjectCreationExpression* _tmp302_;
				ValaExpression* _tmp303_;
				_tmp296_ = _arg_index;
				_arg_index = _tmp296_ + 1;
				_tmp297_ = _arg_index;
				_tmp298_ = _arg_size;
				if (!(_tmp297_ < _tmp298_)) {
					break;
				}
				_tmp299_ = _arg_list;
				_tmp300_ = _arg_index;
				_tmp301_ = vala_list_get (_tmp299_, _tmp300_);
				arg = (ValaExpression*) _tmp301_;
				_tmp302_ = struct_creation_expression;
				_tmp303_ = arg;
				vala_object_creation_expression_add_argument (_tmp302_, _tmp303_);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp304_ = struct_creation_expression;
		_tmp305_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp306_ = _tmp305_;
		vala_expression_set_target_type ((ValaExpression*) _tmp304_, _tmp306_);
		_tmp307_ = context;
		_tmp308_ = vala_code_context_get_analyzer (_tmp307_);
		_tmp309_ = _tmp308_;
		_tmp310_ = _tmp309_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp310_, (ValaCodeNode*) self);
		_tmp311_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp312_ = _tmp311_;
		_tmp313_ = struct_creation_expression;
		vala_code_node_replace_expression (_tmp312_, (ValaExpression*) self, (ValaExpression*) _tmp313_);
		_tmp314_ = struct_creation_expression;
		_tmp315_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp314_, _tmp315_);
		result = TRUE;
		_vala_code_node_unref0 (struct_creation_expression);
		_vala_code_node_unref0 (st);
		_vala_code_node_unref0 (base_cm);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp316_ = FALSE;
		gboolean _tmp317_ = FALSE;
		gboolean _tmp318_;
		_tmp318_ = self->priv->_is_chainup;
		if (!_tmp318_) {
			ValaExpression* _tmp319_;
			ValaExpression* _tmp320_;
			_tmp319_ = vala_method_call_get_call (self);
			_tmp320_ = _tmp319_;
			_tmp317_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp320_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp317_ = FALSE;
		}
		if (_tmp317_) {
			ValaExpression* _tmp321_;
			ValaExpression* _tmp322_;
			ValaSymbol* _tmp323_;
			ValaSymbol* _tmp324_;
			_tmp321_ = vala_method_call_get_call (self);
			_tmp322_ = _tmp321_;
			_tmp323_ = vala_expression_get_symbol_reference (_tmp322_);
			_tmp324_ = _tmp323_;
			_tmp316_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp324_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp316_ = FALSE;
		}
		if (_tmp316_) {
			ValaSourceReference* _tmp325_;
			ValaSourceReference* _tmp326_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp325_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp326_ = _tmp325_;
			vala_report_error (_tmp326_, "use `new' operator to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (base_cm);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp328_ = self->priv->_is_chainup;
	if (!_tmp328_) {
		ValaDataType* _tmp329_;
		_tmp329_ = mtype;
		_tmp327_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp329_, VALA_TYPE_OBJECT_TYPE);
	} else {
		_tmp327_ = FALSE;
	}
	if (_tmp327_) {
		ValaSourceReference* _tmp330_;
		ValaSourceReference* _tmp331_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp330_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp331_ = _tmp330_;
		vala_report_error (_tmp331_, "invocation not supported in this context");
		result = FALSE;
		_vala_code_node_unref0 (base_cm);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp332_ = FALSE;
		ValaDataType* _tmp333_;
		_tmp333_ = mtype;
		if (_tmp333_ != NULL) {
			ValaDataType* _tmp334_;
			gboolean _tmp335_;
			_tmp334_ = mtype;
			_tmp335_ = vala_data_type_is_invokable (_tmp334_);
			_tmp332_ = _tmp335_;
		} else {
			_tmp332_ = FALSE;
		}
		if (_tmp332_) {
		} else {
			ValaExpression* _tmp336_;
			ValaExpression* _tmp337_;
			ValaSymbol* _tmp338_;
			ValaSymbol* _tmp339_;
			_tmp336_ = vala_method_call_get_call (self);
			_tmp337_ = _tmp336_;
			_tmp338_ = vala_expression_get_symbol_reference (_tmp337_);
			_tmp339_ = _tmp338_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp339_, VALA_TYPE_CLASS)) {
				ValaSourceReference* _tmp340_;
				ValaSourceReference* _tmp341_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp340_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp341_ = _tmp340_;
				vala_report_error (_tmp341_, "use `new' operator to create new objects");
				result = FALSE;
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaSourceReference* _tmp342_;
				ValaSourceReference* _tmp343_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp342_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp343_ = _tmp342_;
				vala_report_error (_tmp343_, "invocation not supported in this context");
				result = FALSE;
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
	}
	_tmp344_ = mtype;
	_tmp345_ = vala_data_type_get_return_type (_tmp344_);
	ret_type = _tmp345_;
	_tmp346_ = mtype;
	_tmp347_ = vala_data_type_get_parameters (_tmp346_);
	params = _tmp347_;
	_tmp348_ = mtype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp348_, VALA_TYPE_METHOD_TYPE)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp349_;
		ValaMethod* _tmp350_;
		ValaMethod* _tmp351_;
		ValaMethod* _tmp352_;
		gboolean _tmp353_ = FALSE;
		ValaMethod* _tmp354_;
		ValaMethod* _tmp391_;
		_tmp349_ = mtype;
		_tmp350_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp349_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp351_ = _tmp350_;
		_tmp352_ = _vala_code_node_ref0 (_tmp351_);
		m = _tmp352_;
		_tmp354_ = m;
		if (_tmp354_ != NULL) {
			ValaMethod* _tmp355_;
			gboolean _tmp356_;
			gboolean _tmp357_;
			_tmp355_ = m;
			_tmp356_ = vala_method_get_coroutine (_tmp355_);
			_tmp357_ = _tmp356_;
			_tmp353_ = _tmp357_;
		} else {
			_tmp353_ = FALSE;
		}
		if (_tmp353_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp358_;
			ValaExpression* _tmp359_;
			ValaMemberAccess* _tmp360_;
			gboolean _tmp361_;
			_tmp358_ = vala_method_call_get_call (self);
			_tmp359_ = _tmp358_;
			_tmp360_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp359_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp360_;
			_tmp361_ = self->priv->_is_yield_expression;
			if (!_tmp361_) {
				ValaMemberAccess* _tmp362_;
				const gchar* _tmp363_;
				const gchar* _tmp364_;
				_tmp362_ = ma;
				_tmp363_ = vala_member_access_get_member_name (_tmp362_);
				_tmp364_ = _tmp363_;
				if (g_strcmp0 (_tmp364_, "end") != 0) {
					ValaMemberAccess* _tmp365_;
					const gchar* _tmp366_;
					const gchar* _tmp367_;
					ValaMethod* _tmp371_;
					ValaList* _tmp372_;
					ValaVoidType* _tmp373_;
					_tmp365_ = ma;
					_tmp366_ = vala_member_access_get_member_name (_tmp365_);
					_tmp367_ = _tmp366_;
					if (g_strcmp0 (_tmp367_, "begin") != 0) {
						ValaMemberAccess* _tmp368_;
						ValaSourceReference* _tmp369_;
						ValaSourceReference* _tmp370_;
						_tmp368_ = ma;
						_tmp369_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp368_);
						_tmp370_ = _tmp369_;
						vala_report_deprecated (_tmp370_, "implicit .begin is deprecated");
					}
					_tmp371_ = m;
					_tmp372_ = vala_method_get_async_begin_parameters (_tmp371_);
					_vala_iterable_unref0 (params);
					params = _tmp372_;
					_tmp373_ = vala_void_type_new (NULL);
					_vala_code_node_unref0 (ret_type);
					ret_type = (ValaDataType*) _tmp373_;
				} else {
					ValaMethod* _tmp374_;
					ValaList* _tmp375_;
					_tmp374_ = m;
					_tmp375_ = vala_method_get_async_end_parameters (_tmp374_);
					_vala_iterable_unref0 (params);
					params = _tmp375_;
				}
			} else {
				gboolean _tmp376_ = FALSE;
				ValaMemberAccess* _tmp377_;
				const gchar* _tmp378_;
				const gchar* _tmp379_;
				_tmp377_ = ma;
				_tmp378_ = vala_member_access_get_member_name (_tmp377_);
				_tmp379_ = _tmp378_;
				if (g_strcmp0 (_tmp379_, "begin") == 0) {
					_tmp376_ = TRUE;
				} else {
					ValaMemberAccess* _tmp380_;
					const gchar* _tmp381_;
					const gchar* _tmp382_;
					_tmp380_ = ma;
					_tmp381_ = vala_member_access_get_member_name (_tmp380_);
					_tmp382_ = _tmp381_;
					_tmp376_ = g_strcmp0 (_tmp382_, "end") == 0;
				}
				if (_tmp376_) {
					ValaMemberAccess* _tmp383_;
					ValaSourceReference* _tmp384_;
					ValaSourceReference* _tmp385_;
					ValaMemberAccess* _tmp386_;
					const gchar* _tmp387_;
					const gchar* _tmp388_;
					gchar* _tmp389_;
					gchar* _tmp390_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp383_ = ma;
					_tmp384_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp383_);
					_tmp385_ = _tmp384_;
					_tmp386_ = ma;
					_tmp387_ = vala_member_access_get_member_name (_tmp386_);
					_tmp388_ = _tmp387_;
					_tmp389_ = g_strdup_printf ("use of `%s' not allowed in yield statement", _tmp388_);
					_tmp390_ = _tmp389_;
					vala_report_error (_tmp385_, _tmp390_);
					_g_free0 (_tmp390_);
				}
			}
			_vala_code_node_unref0 (ma);
		}
		_tmp391_ = m;
		if (_tmp391_ != NULL) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp392_;
			ValaExpression* _tmp393_;
			ValaMemberAccess* _tmp394_;
			gint n_type_params = 0;
			ValaMethod* _tmp395_;
			ValaList* _tmp396_;
			ValaList* _tmp397_;
			gint _tmp398_;
			gint _tmp399_;
			gint _tmp400_;
			gint n_type_args = 0;
			ValaMemberAccess* _tmp401_;
			ValaList* _tmp402_;
			ValaList* _tmp403_;
			gint _tmp404_;
			gint _tmp405_;
			gint _tmp406_;
			gboolean _tmp407_ = FALSE;
			gint _tmp408_;
			_tmp392_ = vala_method_call_get_call (self);
			_tmp393_ = _tmp392_;
			_tmp394_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp393_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp394_;
			_tmp395_ = m;
			_tmp396_ = vala_method_get_type_parameters (_tmp395_);
			_tmp397_ = _tmp396_;
			_tmp398_ = vala_collection_get_size ((ValaCollection*) _tmp397_);
			_tmp399_ = _tmp398_;
			_tmp400_ = _tmp399_;
			_vala_iterable_unref0 (_tmp397_);
			n_type_params = _tmp400_;
			_tmp401_ = ma;
			_tmp402_ = vala_member_access_get_type_arguments (_tmp401_);
			_tmp403_ = _tmp402_;
			_tmp404_ = vala_collection_get_size ((ValaCollection*) _tmp403_);
			_tmp405_ = _tmp404_;
			_tmp406_ = _tmp405_;
			_vala_iterable_unref0 (_tmp403_);
			n_type_args = _tmp406_;
			_tmp408_ = n_type_args;
			if (_tmp408_ > 0) {
				gint _tmp409_;
				gint _tmp410_;
				_tmp409_ = n_type_args;
				_tmp410_ = n_type_params;
				_tmp407_ = _tmp409_ < _tmp410_;
			} else {
				_tmp407_ = FALSE;
			}
			if (_tmp407_) {
				ValaMemberAccess* _tmp411_;
				ValaSourceReference* _tmp412_;
				ValaSourceReference* _tmp413_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp411_ = ma;
				_tmp412_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp411_);
				_tmp413_ = _tmp412_;
				vala_report_error (_tmp413_, "too few type arguments");
				result = FALSE;
				_vala_code_node_unref0 (ma);
				_vala_code_node_unref0 (m);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				gboolean _tmp414_ = FALSE;
				gint _tmp415_;
				_tmp415_ = n_type_args;
				if (_tmp415_ > 0) {
					gint _tmp416_;
					gint _tmp417_;
					_tmp416_ = n_type_args;
					_tmp417_ = n_type_params;
					_tmp414_ = _tmp416_ > _tmp417_;
				} else {
					_tmp414_ = FALSE;
				}
				if (_tmp414_) {
					ValaMemberAccess* _tmp418_;
					ValaSourceReference* _tmp419_;
					ValaSourceReference* _tmp420_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp418_ = ma;
					_tmp419_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp418_);
					_tmp420_ = _tmp419_;
					vala_report_error (_tmp420_, "too many type arguments");
					result = FALSE;
					_vala_code_node_unref0 (ma);
					_vala_code_node_unref0 (m);
					_vala_iterable_unref0 (params);
					_vala_code_node_unref0 (ret_type);
					_vala_code_node_unref0 (base_cm);
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			}
			_vala_code_node_unref0 (ma);
		}
		_vala_code_node_unref0 (m);
	}
	last_arg = NULL;
	_tmp421_ = vala_method_call_get_argument_list (self);
	args = _tmp421_;
	_tmp422_ = args;
	_tmp423_ = vala_iterable_iterator ((ValaIterable*) _tmp422_);
	arg_it = _tmp423_;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp424_;
		ValaList* _tmp425_;
		gint _param_size = 0;
		ValaList* _tmp426_;
		gint _tmp427_;
		gint _tmp428_;
		gint _param_index = 0;
		_tmp424_ = params;
		_tmp425_ = _vala_iterable_ref0 (_tmp424_);
		_param_list = _tmp425_;
		_tmp426_ = _param_list;
		_tmp427_ = vala_collection_get_size ((ValaCollection*) _tmp426_);
		_tmp428_ = _tmp427_;
		_param_size = _tmp428_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp429_;
			gint _tmp430_;
			gint _tmp431_;
			ValaParameter* param = NULL;
			ValaList* _tmp432_;
			gint _tmp433_;
			gpointer _tmp434_;
			ValaParameter* _tmp435_;
			gboolean _tmp436_;
			gboolean _tmp437_;
			ValaParameter* _tmp438_;
			gboolean _tmp439_;
			gboolean _tmp440_;
			ValaIterator* _tmp459_;
			gboolean _tmp460_;
			_tmp429_ = _param_index;
			_param_index = _tmp429_ + 1;
			_tmp430_ = _param_index;
			_tmp431_ = _param_size;
			if (!(_tmp430_ < _tmp431_)) {
				break;
			}
			_tmp432_ = _param_list;
			_tmp433_ = _param_index;
			_tmp434_ = vala_list_get (_tmp432_, _tmp433_);
			param = (ValaParameter*) _tmp434_;
			_tmp435_ = param;
			_tmp436_ = vala_parameter_get_ellipsis (_tmp435_);
			_tmp437_ = _tmp436_;
			if (_tmp437_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp438_ = param;
			_tmp439_ = vala_parameter_get_params_array (_tmp438_);
			_tmp440_ = _tmp439_;
			if (_tmp440_) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp441_;
				ValaDataType* _tmp442_;
				ValaDataType* _tmp443_;
				ValaArrayType* _tmp444_;
				_tmp441_ = param;
				_tmp442_ = vala_variable_get_variable_type ((ValaVariable*) _tmp441_);
				_tmp443_ = _tmp442_;
				_tmp444_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp443_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp444_;
				while (TRUE) {
					ValaIterator* _tmp445_;
					gboolean _tmp446_;
					ValaExpression* arg = NULL;
					ValaIterator* _tmp447_;
					gpointer _tmp448_;
					ValaExpression* _tmp449_;
					ValaArrayType* _tmp450_;
					ValaDataType* _tmp451_;
					ValaDataType* _tmp452_;
					ValaExpression* _tmp453_;
					ValaDataType* _tmp454_;
					ValaDataType* _tmp455_;
					ValaArrayType* _tmp456_;
					gboolean _tmp457_;
					gboolean _tmp458_;
					_tmp445_ = arg_it;
					_tmp446_ = vala_iterator_next (_tmp445_);
					if (!_tmp446_) {
						break;
					}
					_tmp447_ = arg_it;
					_tmp448_ = vala_iterator_get (_tmp447_);
					arg = (ValaExpression*) _tmp448_;
					_tmp449_ = arg;
					_tmp450_ = array_type;
					_tmp451_ = vala_array_type_get_element_type (_tmp450_);
					_tmp452_ = _tmp451_;
					vala_expression_set_target_type (_tmp449_, _tmp452_);
					_tmp453_ = arg;
					_tmp454_ = vala_expression_get_target_type (_tmp453_);
					_tmp455_ = _tmp454_;
					_tmp456_ = array_type;
					_tmp457_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp456_);
					_tmp458_ = _tmp457_;
					vala_data_type_set_value_owned (_tmp455_, _tmp458_);
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (array_type);
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp459_ = arg_it;
			_tmp460_ = vala_iterator_next (_tmp459_);
			if (_tmp460_) {
				ValaExpression* arg = NULL;
				ValaIterator* _tmp461_;
				gpointer _tmp462_;
				ValaExpression* _tmp463_;
				ValaParameter* _tmp464_;
				ValaDataType* _tmp465_;
				ValaDataType* _tmp466_;
				ValaExpression* _tmp467_;
				ValaExpression* _tmp468_;
				ValaDataType* _tmp469_;
				ValaDataType* _tmp470_;
				ValaDataType* _tmp471_;
				ValaList* _tmp472_;
				ValaDataType* _tmp473_;
				ValaDataType* _tmp474_;
				ValaExpression* _tmp475_;
				ValaExpression* _tmp476_;
				_tmp461_ = arg_it;
				_tmp462_ = vala_iterator_get (_tmp461_);
				arg = (ValaExpression*) _tmp462_;
				_tmp463_ = arg;
				_tmp464_ = param;
				_tmp465_ = vala_variable_get_variable_type ((ValaVariable*) _tmp464_);
				_tmp466_ = _tmp465_;
				vala_expression_set_formal_target_type (_tmp463_, _tmp466_);
				_tmp467_ = arg;
				_tmp468_ = arg;
				_tmp469_ = vala_expression_get_formal_target_type (_tmp468_);
				_tmp470_ = _tmp469_;
				_tmp471_ = target_object_type;
				_tmp472_ = method_type_args;
				_tmp473_ = vala_data_type_get_actual_type (_tmp470_, _tmp471_, _tmp472_, (ValaCodeNode*) self);
				_tmp474_ = _tmp473_;
				vala_expression_set_target_type (_tmp467_, _tmp474_);
				_vala_code_node_unref0 (_tmp474_);
				_tmp475_ = arg;
				_tmp476_ = _vala_code_node_ref0 (_tmp475_);
				_vala_code_node_unref0 (last_arg);
				last_arg = _tmp476_;
				_vala_code_node_unref0 (arg);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp478_ = mtype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp478_, VALA_TYPE_METHOD_TYPE)) {
		ValaDataType* _tmp479_;
		ValaMethod* _tmp480_;
		ValaMethod* _tmp481_;
		ValaAttribute* _tmp482_;
		ValaAttribute* _tmp483_;
		_tmp479_ = mtype;
		_tmp480_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp479_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp481_ = _tmp480_;
		_tmp482_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp481_, "Print");
		_tmp483_ = _tmp482_;
		_tmp477_ = _tmp483_ != NULL;
		_vala_code_node_unref0 (_tmp483_);
	} else {
		_tmp477_ = FALSE;
	}
	if (_tmp477_) {
		ValaTemplate* template = NULL;
		ValaSourceReference* _tmp484_;
		ValaSourceReference* _tmp485_;
		ValaTemplate* _tmp486_;
		ValaList* _tmp501_;
		ValaTemplate* _tmp502_;
		_tmp484_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp485_ = _tmp484_;
		_tmp486_ = vala_template_new (_tmp485_);
		template = _tmp486_;
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp487_;
			ValaList* _tmp488_;
			gint _arg_size = 0;
			ValaList* _tmp489_;
			gint _tmp490_;
			gint _tmp491_;
			gint _arg_index = 0;
			_tmp487_ = self->priv->argument_list;
			_tmp488_ = _vala_iterable_ref0 (_tmp487_);
			_arg_list = _tmp488_;
			_tmp489_ = _arg_list;
			_tmp490_ = vala_collection_get_size ((ValaCollection*) _tmp489_);
			_tmp491_ = _tmp490_;
			_arg_size = _tmp491_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp492_;
				gint _tmp493_;
				gint _tmp494_;
				ValaExpression* arg = NULL;
				ValaList* _tmp495_;
				gint _tmp496_;
				gpointer _tmp497_;
				ValaExpression* _tmp498_;
				ValaTemplate* _tmp499_;
				ValaExpression* _tmp500_;
				_tmp492_ = _arg_index;
				_arg_index = _tmp492_ + 1;
				_tmp493_ = _arg_index;
				_tmp494_ = _arg_size;
				if (!(_tmp493_ < _tmp494_)) {
					break;
				}
				_tmp495_ = _arg_list;
				_tmp496_ = _arg_index;
				_tmp497_ = vala_list_get (_tmp495_, _tmp496_);
				arg = (ValaExpression*) _tmp497_;
				_tmp498_ = arg;
				vala_code_node_set_parent_node ((ValaCodeNode*) _tmp498_, NULL);
				_tmp499_ = template;
				_tmp500_ = arg;
				vala_template_add_expression (_tmp499_, _tmp500_);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp501_ = self->priv->argument_list;
		vala_collection_clear ((ValaCollection*) _tmp501_);
		_tmp502_ = template;
		vala_method_call_add_argument (self, (ValaExpression*) _tmp502_);
		_vala_code_node_unref0 (template);
	}
	_tmp504_ = mtype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp504_, VALA_TYPE_METHOD_TYPE)) {
		ValaDataType* _tmp505_;
		ValaMethod* _tmp506_;
		ValaMethod* _tmp507_;
		gboolean _tmp508_;
		gboolean _tmp509_;
		_tmp505_ = mtype;
		_tmp506_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp505_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp507_ = _tmp506_;
		_tmp508_ = vala_method_get_printf_format (_tmp507_);
		_tmp509_ = _tmp508_;
		_tmp503_ = _tmp509_;
	} else {
		_tmp503_ = FALSE;
	}
	if (_tmp503_) {
		ValaStringLiteral* format_literal = NULL;
		ValaExpression* _tmp510_;
		ValaStringLiteral* _tmp559_;
		format_literal = NULL;
		_tmp510_ = last_arg;
		if (_tmp510_ != NULL) {
			ValaExpression* _tmp511_;
			ValaStringLiteral* _tmp512_;
			gboolean _tmp513_ = FALSE;
			ValaStringLiteral* _tmp514_;
			_tmp511_ = last_arg;
			_tmp512_ = vala_string_literal_get_format_literal (_tmp511_);
			_vala_code_node_unref0 (format_literal);
			format_literal = _tmp512_;
			_tmp514_ = format_literal;
			if (_tmp514_ == NULL) {
				ValaList* _tmp515_;
				gint _tmp516_;
				gint _tmp517_;
				ValaList* _tmp518_;
				gint _tmp519_;
				gint _tmp520_;
				_tmp515_ = args;
				_tmp516_ = vala_collection_get_size ((ValaCollection*) _tmp515_);
				_tmp517_ = _tmp516_;
				_tmp518_ = params;
				_tmp519_ = vala_collection_get_size ((ValaCollection*) _tmp518_);
				_tmp520_ = _tmp519_;
				_tmp513_ = _tmp517_ == (_tmp520_ - 1);
			} else {
				_tmp513_ = FALSE;
			}
			if (_tmp513_) {
				ValaStringLiteral* _tmp521_;
				ValaStringLiteral* _tmp522_;
				ValaCodeContext* _tmp523_;
				ValaSemanticAnalyzer* _tmp524_;
				ValaSemanticAnalyzer* _tmp525_;
				ValaDataType* _tmp526_;
				ValaDataType* _tmp527_;
				ValaDataType* _tmp528_;
				ValaList* _tmp529_;
				ValaList* _tmp530_;
				gint _tmp531_;
				gint _tmp532_;
				ValaStringLiteral* _tmp533_;
				ValaList* _tmp534_;
				ValaIterator* _tmp535_;
				_tmp521_ = vala_string_literal_new ("\"%s\"", NULL);
				_vala_code_node_unref0 (format_literal);
				format_literal = _tmp521_;
				_tmp522_ = format_literal;
				_tmp523_ = context;
				_tmp524_ = vala_code_context_get_analyzer (_tmp523_);
				_tmp525_ = _tmp524_;
				_tmp526_ = _tmp525_->string_type;
				_tmp527_ = vala_data_type_copy (_tmp526_);
				_tmp528_ = _tmp527_;
				vala_expression_set_target_type ((ValaExpression*) _tmp522_, _tmp528_);
				_vala_code_node_unref0 (_tmp528_);
				_tmp529_ = self->priv->argument_list;
				_tmp530_ = args;
				_tmp531_ = vala_collection_get_size ((ValaCollection*) _tmp530_);
				_tmp532_ = _tmp531_;
				_tmp533_ = format_literal;
				vala_list_insert (_tmp529_, _tmp532_ - 1, (ValaExpression*) _tmp533_);
				_tmp534_ = self->priv->argument_list;
				_tmp535_ = vala_iterable_iterator ((ValaIterable*) _tmp534_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp535_;
				{
					ValaList* _param_list = NULL;
					ValaList* _tmp536_;
					ValaList* _tmp537_;
					gint _param_size = 0;
					ValaList* _tmp538_;
					gint _tmp539_;
					gint _tmp540_;
					gint _param_index = 0;
					_tmp536_ = params;
					_tmp537_ = _vala_iterable_ref0 (_tmp536_);
					_param_list = _tmp537_;
					_tmp538_ = _param_list;
					_tmp539_ = vala_collection_get_size ((ValaCollection*) _tmp538_);
					_tmp540_ = _tmp539_;
					_param_size = _tmp540_;
					_param_index = -1;
					while (TRUE) {
						gint _tmp541_;
						gint _tmp542_;
						gint _tmp543_;
						ValaParameter* param = NULL;
						ValaList* _tmp544_;
						gint _tmp545_;
						gpointer _tmp546_;
						ValaParameter* _tmp547_;
						gboolean _tmp548_;
						gboolean _tmp549_;
						ValaIterator* _tmp550_;
						_tmp541_ = _param_index;
						_param_index = _tmp541_ + 1;
						_tmp542_ = _param_index;
						_tmp543_ = _param_size;
						if (!(_tmp542_ < _tmp543_)) {
							break;
						}
						_tmp544_ = _param_list;
						_tmp545_ = _param_index;
						_tmp546_ = vala_list_get (_tmp544_, _tmp545_);
						param = (ValaParameter*) _tmp546_;
						_tmp547_ = param;
						_tmp548_ = vala_parameter_get_ellipsis (_tmp547_);
						_tmp549_ = _tmp548_;
						if (_tmp549_) {
							_vala_code_node_unref0 (param);
							break;
						}
						_tmp550_ = arg_it;
						vala_iterator_next (_tmp550_);
						_vala_code_node_unref0 (param);
					}
					_vala_iterable_unref0 (_param_list);
				}
			}
		} else {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp551_;
			ValaExpression* _tmp552_;
			ValaMemberAccess* _tmp553_;
			ValaMemberAccess* _tmp554_;
			_tmp551_ = vala_method_call_get_call (self);
			_tmp552_ = _tmp551_;
			_tmp553_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp552_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp552_) : NULL);
			ma = _tmp553_;
			_tmp554_ = ma;
			if (_tmp554_ != NULL) {
				ValaMemberAccess* _tmp555_;
				ValaExpression* _tmp556_;
				ValaExpression* _tmp557_;
				ValaStringLiteral* _tmp558_;
				_tmp555_ = ma;
				_tmp556_ = vala_member_access_get_inner (_tmp555_);
				_tmp557_ = _tmp556_;
				_tmp558_ = vala_string_literal_get_format_literal (_tmp557_);
				_vala_code_node_unref0 (format_literal);
				format_literal = _tmp558_;
			}
			_vala_code_node_unref0 (ma);
		}
		_tmp559_ = format_literal;
		if (_tmp559_ != NULL) {
			gchar* format = NULL;
			ValaStringLiteral* _tmp560_;
			gchar* _tmp561_;
			ValaCodeContext* _tmp562_;
			ValaSemanticAnalyzer* _tmp563_;
			ValaSemanticAnalyzer* _tmp564_;
			const gchar* _tmp565_;
			ValaIterator* _tmp566_;
			ValaSourceReference* _tmp567_;
			ValaSourceReference* _tmp568_;
			gboolean _tmp569_;
			_tmp560_ = format_literal;
			_tmp561_ = vala_string_literal_eval (_tmp560_);
			format = _tmp561_;
			_tmp562_ = context;
			_tmp563_ = vala_code_context_get_analyzer (_tmp562_);
			_tmp564_ = _tmp563_;
			_tmp565_ = format;
			_tmp566_ = arg_it;
			_tmp567_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp568_ = _tmp567_;
			_tmp569_ = vala_semantic_analyzer_check_print_format (_tmp564_, _tmp565_, _tmp566_, _tmp568_);
			if (!_tmp569_) {
				result = FALSE;
				_g_free0 (format);
				_vala_code_node_unref0 (format_literal);
				_vala_iterator_unref0 (arg_it);
				_vala_iterable_unref0 (args);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_g_free0 (format);
		}
		_vala_code_node_unref0 (format_literal);
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp570_;
		gint _arg_size = 0;
		ValaList* _tmp571_;
		gint _tmp572_;
		gint _tmp573_;
		gint _arg_index = 0;
		_tmp570_ = vala_method_call_get_argument_list (self);
		_arg_list = _tmp570_;
		_tmp571_ = _arg_list;
		_tmp572_ = vala_collection_get_size ((ValaCollection*) _tmp571_);
		_tmp573_ = _tmp572_;
		_arg_size = _tmp573_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp574_;
			gint _tmp575_;
			gint _tmp576_;
			ValaExpression* arg = NULL;
			ValaList* _tmp577_;
			gint _tmp578_;
			gpointer _tmp579_;
			ValaExpression* _tmp580_;
			ValaCodeContext* _tmp581_;
			_tmp574_ = _arg_index;
			_arg_index = _tmp574_ + 1;
			_tmp575_ = _arg_index;
			_tmp576_ = _arg_size;
			if (!(_tmp575_ < _tmp576_)) {
				break;
			}
			_tmp577_ = _arg_list;
			_tmp578_ = _arg_index;
			_tmp579_ = vala_list_get (_tmp577_, _tmp578_);
			arg = (ValaExpression*) _tmp579_;
			_tmp580_ = arg;
			_tmp581_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp580_, _tmp581_);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp582_ = ret_type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp582_, VALA_TYPE_VOID_TYPE)) {
		gboolean _tmp583_ = FALSE;
		gboolean _tmp584_ = FALSE;
		ValaCodeNode* _tmp585_;
		ValaCodeNode* _tmp586_;
		_tmp585_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp586_ = _tmp585_;
		if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp586_, VALA_TYPE_EXPRESSION_STATEMENT)) {
			ValaCodeNode* _tmp587_;
			ValaCodeNode* _tmp588_;
			_tmp587_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp588_ = _tmp587_;
			_tmp584_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp588_, VALA_TYPE_FOR_STATEMENT);
		} else {
			_tmp584_ = FALSE;
		}
		if (_tmp584_) {
			ValaCodeNode* _tmp589_;
			ValaCodeNode* _tmp590_;
			_tmp589_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp590_ = _tmp589_;
			_tmp583_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp590_, VALA_TYPE_YIELD_STATEMENT);
		} else {
			_tmp583_ = FALSE;
		}
		if (_tmp583_) {
			ValaSourceReference* _tmp591_;
			ValaSourceReference* _tmp592_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp591_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp592_ = _tmp591_;
			vala_report_error (_tmp592_, "invocation of void method not allowed as expression");
			result = FALSE;
			_vala_iterator_unref0 (arg_it);
			_vala_iterable_unref0 (args);
			_vala_code_node_unref0 (last_arg);
			_vala_iterable_unref0 (params);
			_vala_code_node_unref0 (ret_type);
			_vala_code_node_unref0 (base_cm);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp593_ = ret_type;
	_tmp594_ = vala_data_type_copy (_tmp593_);
	_tmp595_ = _tmp594_;
	vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp595_);
	_vala_code_node_unref0 (_tmp595_);
	_tmp596_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
	_tmp597_ = _tmp596_;
	_tmp598_ = target_object_type;
	_tmp599_ = method_type_args;
	_tmp600_ = vala_data_type_get_actual_type (_tmp597_, _tmp598_, _tmp599_, (ValaCodeNode*) self);
	_tmp601_ = _tmp600_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp601_);
	_vala_code_node_unref0 (_tmp601_);
	may_throw = FALSE;
	_tmp602_ = mtype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp602_, VALA_TYPE_METHOD_TYPE)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp603_;
		ValaMethod* _tmp604_;
		ValaMethod* _tmp605_;
		ValaMethod* _tmp606_;
		gboolean _tmp607_;
		gboolean _tmp628_ = FALSE;
		gboolean _tmp629_ = FALSE;
		gboolean _tmp630_ = FALSE;
		ValaMethod* _tmp631_;
		ValaMethod* _tmp657_;
		gboolean _tmp658_;
		gboolean _tmp659_;
		ValaMethod* _tmp662_;
		gboolean _tmp663_;
		gboolean _tmp664_;
		ValaDynamicSignal* dynamic_sig = NULL;
		ValaMethod* _tmp669_;
		ValaSymbol* _tmp670_;
		ValaSymbol* _tmp671_;
		ValaDynamicSignal* _tmp672_;
		gboolean _tmp673_ = FALSE;
		ValaDynamicSignal* _tmp674_;
		gboolean _tmp721_ = FALSE;
		ValaMethod* _tmp722_;
		gboolean _tmp849_ = FALSE;
		ValaMethod* _tmp850_;
		_tmp603_ = mtype;
		_tmp604_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp603_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp605_ = _tmp604_;
		_tmp606_ = _vala_code_node_ref0 (_tmp605_);
		m = _tmp606_;
		_tmp607_ = self->priv->_is_yield_expression;
		if (_tmp607_) {
			ValaMethod* _tmp608_;
			gboolean _tmp609_;
			gboolean _tmp610_;
			gboolean _tmp613_ = FALSE;
			ValaCodeContext* _tmp614_;
			ValaSemanticAnalyzer* _tmp615_;
			ValaSemanticAnalyzer* _tmp616_;
			ValaMethod* _tmp617_;
			ValaMethod* _tmp618_;
			_tmp608_ = m;
			_tmp609_ = vala_method_get_coroutine (_tmp608_);
			_tmp610_ = _tmp609_;
			if (!_tmp610_) {
				ValaSourceReference* _tmp611_;
				ValaSourceReference* _tmp612_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp611_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp612_ = _tmp611_;
				vala_report_error (_tmp612_, "yield expression requires async method");
			}
			_tmp614_ = context;
			_tmp615_ = vala_code_context_get_analyzer (_tmp614_);
			_tmp616_ = _tmp615_;
			_tmp617_ = vala_semantic_analyzer_get_current_method (_tmp616_);
			_tmp618_ = _tmp617_;
			if (_tmp618_ == NULL) {
				_tmp613_ = TRUE;
			} else {
				ValaCodeContext* _tmp619_;
				ValaSemanticAnalyzer* _tmp620_;
				ValaSemanticAnalyzer* _tmp621_;
				ValaMethod* _tmp622_;
				ValaMethod* _tmp623_;
				gboolean _tmp624_;
				gboolean _tmp625_;
				_tmp619_ = context;
				_tmp620_ = vala_code_context_get_analyzer (_tmp619_);
				_tmp621_ = _tmp620_;
				_tmp622_ = vala_semantic_analyzer_get_current_method (_tmp621_);
				_tmp623_ = _tmp622_;
				_tmp624_ = vala_method_get_coroutine (_tmp623_);
				_tmp625_ = _tmp624_;
				_tmp613_ = !_tmp625_;
			}
			if (_tmp613_) {
				ValaSourceReference* _tmp626_;
				ValaSourceReference* _tmp627_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp626_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp627_ = _tmp626_;
				vala_report_error (_tmp627_, "yield expression not available outside async method");
			}
		}
		_tmp631_ = m;
		if (_tmp631_ != NULL) {
			ValaMethod* _tmp632_;
			gboolean _tmp633_;
			gboolean _tmp634_;
			_tmp632_ = m;
			_tmp633_ = vala_method_get_coroutine (_tmp632_);
			_tmp634_ = _tmp633_;
			_tmp630_ = _tmp634_;
		} else {
			_tmp630_ = FALSE;
		}
		if (_tmp630_) {
			gboolean _tmp635_;
			_tmp635_ = self->priv->_is_yield_expression;
			_tmp629_ = !_tmp635_;
		} else {
			_tmp629_ = FALSE;
		}
		if (_tmp629_) {
			ValaExpression* _tmp636_;
			ValaExpression* _tmp637_;
			const gchar* _tmp638_;
			const gchar* _tmp639_;
			_tmp636_ = vala_method_call_get_call (self);
			_tmp637_ = _tmp636_;
			_tmp638_ = vala_member_access_get_member_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp637_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp639_ = _tmp638_;
			_tmp628_ = g_strcmp0 (_tmp639_, "end") != 0;
		} else {
			_tmp628_ = FALSE;
		}
		if (_tmp628_) {
		} else {
			{
				ValaList* _error_type_list = NULL;
				ValaMethod* _tmp640_;
				ValaList* _tmp641_;
				gint _error_type_size = 0;
				ValaList* _tmp642_;
				gint _tmp643_;
				gint _tmp644_;
				gint _error_type_index = 0;
				_tmp640_ = m;
				_tmp641_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp640_);
				_error_type_list = _tmp641_;
				_tmp642_ = _error_type_list;
				_tmp643_ = vala_collection_get_size ((ValaCollection*) _tmp642_);
				_tmp644_ = _tmp643_;
				_error_type_size = _tmp644_;
				_error_type_index = -1;
				while (TRUE) {
					gint _tmp645_;
					gint _tmp646_;
					gint _tmp647_;
					ValaDataType* error_type = NULL;
					ValaList* _tmp648_;
					gint _tmp649_;
					gpointer _tmp650_;
					ValaDataType* call_error_type = NULL;
					ValaDataType* _tmp651_;
					ValaDataType* _tmp652_;
					ValaDataType* _tmp653_;
					ValaSourceReference* _tmp654_;
					ValaSourceReference* _tmp655_;
					ValaDataType* _tmp656_;
					_tmp645_ = _error_type_index;
					_error_type_index = _tmp645_ + 1;
					_tmp646_ = _error_type_index;
					_tmp647_ = _error_type_size;
					if (!(_tmp646_ < _tmp647_)) {
						break;
					}
					_tmp648_ = _error_type_list;
					_tmp649_ = _error_type_index;
					_tmp650_ = vala_list_get (_tmp648_, _tmp649_);
					error_type = (ValaDataType*) _tmp650_;
					may_throw = TRUE;
					_tmp651_ = error_type;
					_tmp652_ = vala_data_type_copy (_tmp651_);
					call_error_type = _tmp652_;
					_tmp653_ = call_error_type;
					_tmp654_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp655_ = _tmp654_;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp653_, _tmp655_);
					_tmp656_ = call_error_type;
					vala_code_node_add_error_type ((ValaCodeNode*) self, _tmp656_);
					_vala_code_node_unref0 (call_error_type);
					_vala_code_node_unref0 (error_type);
				}
				_vala_iterable_unref0 (_error_type_list);
			}
		}
		_tmp657_ = m;
		_tmp658_ = vala_method_get_returns_floating_reference (_tmp657_);
		_tmp659_ = _tmp658_;
		if (_tmp659_) {
			ValaDataType* _tmp660_;
			ValaDataType* _tmp661_;
			_tmp660_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp661_ = _tmp660_;
			vala_data_type_set_floating_reference (_tmp661_, TRUE);
		}
		_tmp662_ = m;
		_tmp663_ = vala_method_get_returns_modified_pointer (_tmp662_);
		_tmp664_ = _tmp663_;
		if (_tmp664_) {
			ValaExpression* _tmp665_;
			ValaExpression* _tmp666_;
			ValaExpression* _tmp667_;
			ValaExpression* _tmp668_;
			_tmp665_ = vala_method_call_get_call (self);
			_tmp666_ = _tmp665_;
			_tmp667_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp666_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp668_ = _tmp667_;
			vala_expression_set_lvalue (_tmp668_, TRUE);
		}
		_tmp669_ = m;
		_tmp670_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp669_);
		_tmp671_ = _tmp670_;
		_tmp672_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp671_, VALA_TYPE_DYNAMIC_SIGNAL) ? ((ValaDynamicSignal*) _tmp671_) : NULL);
		dynamic_sig = _tmp672_;
		_tmp674_ = dynamic_sig;
		if (_tmp674_ != NULL) {
			ValaDynamicSignal* _tmp675_;
			ValaExpression* _tmp676_;
			ValaExpression* _tmp677_;
			_tmp675_ = dynamic_sig;
			_tmp676_ = vala_dynamic_signal_get_handler (_tmp675_);
			_tmp677_ = _tmp676_;
			_tmp673_ = _tmp677_ != NULL;
		} else {
			_tmp673_ = FALSE;
		}
		if (_tmp673_) {
			ValaDynamicSignal* _tmp678_;
			ValaDynamicSignal* _tmp679_;
			ValaExpression* _tmp680_;
			ValaExpression* _tmp681_;
			ValaDataType* _tmp682_;
			ValaDataType* _tmp683_;
			ValaDataType* _tmp684_;
			ValaDataType* _tmp685_;
			ValaDataType* _tmp686_;
			ValaDataType* _tmp687_;
			gboolean first = FALSE;
			ValaDynamicSignal* _tmp708_;
			ValaExpression* _tmp709_;
			ValaExpression* _tmp710_;
			ValaDynamicSignal* _tmp711_;
			ValaDynamicSignal* _tmp712_;
			ValaSymbol* _tmp713_;
			ValaSymbol* _tmp714_;
			ValaObjectType* _tmp715_;
			ValaObjectType* _tmp716_;
			ValaDelegate* _tmp717_;
			ValaDelegate* _tmp718_;
			ValaDelegateType* _tmp719_;
			ValaDelegateType* _tmp720_;
			_tmp678_ = dynamic_sig;
			_tmp679_ = dynamic_sig;
			_tmp680_ = vala_dynamic_signal_get_handler (_tmp679_);
			_tmp681_ = _tmp680_;
			_tmp682_ = vala_expression_get_value_type (_tmp681_);
			_tmp683_ = _tmp682_;
			_tmp684_ = vala_data_type_get_return_type (_tmp683_);
			_tmp685_ = _tmp684_;
			_tmp686_ = vala_data_type_copy (_tmp685_);
			_tmp687_ = _tmp686_;
			vala_callable_set_return_type ((ValaCallable*) _tmp678_, _tmp687_);
			_vala_code_node_unref0 (_tmp687_);
			_vala_code_node_unref0 (_tmp685_);
			first = TRUE;
			{
				ValaList* _param_list = NULL;
				ValaDynamicSignal* _tmp688_;
				ValaExpression* _tmp689_;
				ValaExpression* _tmp690_;
				ValaDataType* _tmp691_;
				ValaDataType* _tmp692_;
				ValaList* _tmp693_;
				gint _param_size = 0;
				ValaList* _tmp694_;
				gint _tmp695_;
				gint _tmp696_;
				gint _param_index = 0;
				_tmp688_ = dynamic_sig;
				_tmp689_ = vala_dynamic_signal_get_handler (_tmp688_);
				_tmp690_ = _tmp689_;
				_tmp691_ = vala_expression_get_value_type (_tmp690_);
				_tmp692_ = _tmp691_;
				_tmp693_ = vala_data_type_get_parameters (_tmp692_);
				_param_list = _tmp693_;
				_tmp694_ = _param_list;
				_tmp695_ = vala_collection_get_size ((ValaCollection*) _tmp694_);
				_tmp696_ = _tmp695_;
				_param_size = _tmp696_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp697_;
					gint _tmp698_;
					gint _tmp699_;
					ValaParameter* param = NULL;
					ValaList* _tmp700_;
					gint _tmp701_;
					gpointer _tmp702_;
					gboolean _tmp703_;
					_tmp697_ = _param_index;
					_param_index = _tmp697_ + 1;
					_tmp698_ = _param_index;
					_tmp699_ = _param_size;
					if (!(_tmp698_ < _tmp699_)) {
						break;
					}
					_tmp700_ = _param_list;
					_tmp701_ = _param_index;
					_tmp702_ = vala_list_get (_tmp700_, _tmp701_);
					param = (ValaParameter*) _tmp702_;
					_tmp703_ = first;
					if (_tmp703_) {
						first = FALSE;
					} else {
						ValaDynamicSignal* _tmp704_;
						ValaParameter* _tmp705_;
						ValaParameter* _tmp706_;
						ValaParameter* _tmp707_;
						_tmp704_ = dynamic_sig;
						_tmp705_ = param;
						_tmp706_ = vala_parameter_copy (_tmp705_);
						_tmp707_ = _tmp706_;
						vala_callable_add_parameter ((ValaCallable*) _tmp704_, _tmp707_);
						_vala_code_node_unref0 (_tmp707_);
					}
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp708_ = dynamic_sig;
			_tmp709_ = vala_dynamic_signal_get_handler (_tmp708_);
			_tmp710_ = _tmp709_;
			_tmp711_ = dynamic_sig;
			_tmp712_ = dynamic_sig;
			_tmp713_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp712_);
			_tmp714_ = _tmp713_;
			_tmp715_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp714_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp716_ = _tmp715_;
			_tmp717_ = vala_signal_get_delegate ((ValaSignal*) _tmp711_, (ValaDataType*) _tmp716_, (ValaCodeNode*) self);
			_tmp718_ = _tmp717_;
			_tmp719_ = vala_delegate_type_new (_tmp718_);
			_tmp720_ = _tmp719_;
			vala_expression_set_target_type (_tmp710_, (ValaDataType*) _tmp720_);
			_vala_code_node_unref0 (_tmp720_);
			_vala_code_node_unref0 (_tmp718_);
			_vala_code_node_unref0 (_tmp716_);
		}
		_tmp722_ = m;
		if (_tmp722_ != NULL) {
			ValaMethod* _tmp723_;
			ValaList* _tmp724_;
			ValaList* _tmp725_;
			gint _tmp726_;
			gint _tmp727_;
			_tmp723_ = m;
			_tmp724_ = vala_method_get_type_parameters (_tmp723_);
			_tmp725_ = _tmp724_;
			_tmp726_ = vala_collection_get_size ((ValaCollection*) _tmp725_);
			_tmp727_ = _tmp726_;
			_tmp721_ = _tmp727_ > 0;
			_vala_iterable_unref0 (_tmp725_);
		} else {
			_tmp721_ = FALSE;
		}
		if (_tmp721_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp728_;
			ValaExpression* _tmp729_;
			ValaMemberAccess* _tmp730_;
			ValaMemberAccess* _tmp731_;
			ValaList* _tmp732_;
			ValaList* _tmp733_;
			gint _tmp734_;
			gint _tmp735_;
			gboolean _tmp736_;
			_tmp728_ = vala_method_call_get_call (self);
			_tmp729_ = _tmp728_;
			_tmp730_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp729_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp730_;
			_tmp731_ = ma;
			_tmp732_ = vala_member_access_get_type_arguments (_tmp731_);
			_tmp733_ = _tmp732_;
			_tmp734_ = vala_collection_get_size ((ValaCollection*) _tmp733_);
			_tmp735_ = _tmp734_;
			_tmp736_ = _tmp735_ == 0;
			_vala_iterable_unref0 (_tmp733_);
			if (_tmp736_) {
				ValaList* _tmp811_;
				ValaIterator* _tmp812_;
				ValaDataType* _tmp843_;
				ValaDataType* _tmp844_;
				ValaDataType* _tmp845_;
				ValaList* _tmp846_;
				ValaDataType* _tmp847_;
				ValaDataType* _tmp848_;
				{
					ValaList* _type_param_list = NULL;
					ValaMethod* _tmp737_;
					ValaList* _tmp738_;
					gint _type_param_size = 0;
					ValaList* _tmp739_;
					gint _tmp740_;
					gint _tmp741_;
					gint _type_param_index = 0;
					_tmp737_ = m;
					_tmp738_ = vala_method_get_type_parameters (_tmp737_);
					_type_param_list = _tmp738_;
					_tmp739_ = _type_param_list;
					_tmp740_ = vala_collection_get_size ((ValaCollection*) _tmp739_);
					_tmp741_ = _tmp740_;
					_type_param_size = _tmp741_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp742_;
						gint _tmp743_;
						gint _tmp744_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp745_;
						gint _tmp746_;
						gpointer _tmp747_;
						ValaDataType* type_arg = NULL;
						ValaList* _tmp748_;
						ValaIterator* _tmp749_;
						gboolean _tmp789_ = FALSE;
						ValaDataType* _tmp790_;
						ValaDataType* _tmp800_;
						ValaMemberAccess* _tmp809_;
						ValaDataType* _tmp810_;
						_tmp742_ = _type_param_index;
						_type_param_index = _tmp742_ + 1;
						_tmp743_ = _type_param_index;
						_tmp744_ = _type_param_size;
						if (!(_tmp743_ < _tmp744_)) {
							break;
						}
						_tmp745_ = _type_param_list;
						_tmp746_ = _type_param_index;
						_tmp747_ = vala_list_get (_tmp745_, _tmp746_);
						type_param = (ValaTypeParameter*) _tmp747_;
						type_arg = NULL;
						_tmp748_ = args;
						_tmp749_ = vala_iterable_iterator ((ValaIterable*) _tmp748_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp749_;
						{
							ValaList* _param_list = NULL;
							ValaList* _tmp750_;
							ValaList* _tmp751_;
							gint _param_size = 0;
							ValaList* _tmp752_;
							gint _tmp753_;
							gint _tmp754_;
							gint _param_index = 0;
							_tmp750_ = params;
							_tmp751_ = _vala_iterable_ref0 (_tmp750_);
							_param_list = _tmp751_;
							_tmp752_ = _param_list;
							_tmp753_ = vala_collection_get_size ((ValaCollection*) _tmp752_);
							_tmp754_ = _tmp753_;
							_param_size = _tmp754_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp755_;
								gint _tmp756_;
								gint _tmp757_;
								ValaParameter* param = NULL;
								ValaList* _tmp758_;
								gint _tmp759_;
								gpointer _tmp760_;
								gboolean _tmp761_ = FALSE;
								ValaParameter* _tmp762_;
								gboolean _tmp763_;
								gboolean _tmp764_;
								ValaIterator* _tmp768_;
								gboolean _tmp769_;
								_tmp755_ = _param_index;
								_param_index = _tmp755_ + 1;
								_tmp756_ = _param_index;
								_tmp757_ = _param_size;
								if (!(_tmp756_ < _tmp757_)) {
									break;
								}
								_tmp758_ = _param_list;
								_tmp759_ = _param_index;
								_tmp760_ = vala_list_get (_tmp758_, _tmp759_);
								param = (ValaParameter*) _tmp760_;
								_tmp762_ = param;
								_tmp763_ = vala_parameter_get_ellipsis (_tmp762_);
								_tmp764_ = _tmp763_;
								if (_tmp764_) {
									_tmp761_ = TRUE;
								} else {
									ValaParameter* _tmp765_;
									gboolean _tmp766_;
									gboolean _tmp767_;
									_tmp765_ = param;
									_tmp766_ = vala_parameter_get_params_array (_tmp765_);
									_tmp767_ = _tmp766_;
									_tmp761_ = _tmp767_;
								}
								if (_tmp761_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp768_ = arg_it;
								_tmp769_ = vala_iterator_next (_tmp768_);
								if (_tmp769_) {
									ValaExpression* arg = NULL;
									ValaIterator* _tmp770_;
									gpointer _tmp771_;
									ValaParameter* _tmp772_;
									ValaDataType* _tmp773_;
									ValaDataType* _tmp774_;
									ValaTypeParameter* _tmp775_;
									ValaExpression* _tmp776_;
									ValaDataType* _tmp777_;
									ValaDataType* _tmp778_;
									ValaDataType* _tmp779_;
									ValaDataType* _tmp780_;
									ValaExpression* _tmp781_;
									ValaExpression* _tmp782_;
									ValaDataType* _tmp783_;
									ValaDataType* _tmp784_;
									ValaDataType* _tmp785_;
									ValaList* _tmp786_;
									ValaDataType* _tmp787_;
									ValaDataType* _tmp788_;
									_tmp770_ = arg_it;
									_tmp771_ = vala_iterator_get (_tmp770_);
									arg = (ValaExpression*) _tmp771_;
									_tmp772_ = param;
									_tmp773_ = vala_variable_get_variable_type ((ValaVariable*) _tmp772_);
									_tmp774_ = _tmp773_;
									_tmp775_ = type_param;
									_tmp776_ = arg;
									_tmp777_ = vala_expression_get_value_type (_tmp776_);
									_tmp778_ = _tmp777_;
									_tmp779_ = vala_data_type_infer_type_argument (_tmp774_, _tmp775_, _tmp778_);
									_vala_code_node_unref0 (type_arg);
									type_arg = _tmp779_;
									_tmp780_ = type_arg;
									if (_tmp780_ != NULL) {
										_vala_code_node_unref0 (arg);
										_vala_code_node_unref0 (param);
										break;
									}
									_tmp781_ = arg;
									_tmp782_ = arg;
									_tmp783_ = vala_expression_get_formal_target_type (_tmp782_);
									_tmp784_ = _tmp783_;
									_tmp785_ = target_object_type;
									_tmp786_ = method_type_args;
									_tmp787_ = vala_data_type_get_actual_type (_tmp784_, _tmp785_, _tmp786_, (ValaCodeNode*) self);
									_tmp788_ = _tmp787_;
									vala_expression_set_target_type (_tmp781_, _tmp788_);
									_vala_code_node_unref0 (_tmp788_);
									_vala_code_node_unref0 (arg);
								}
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp790_ = type_arg;
						if (_tmp790_ == NULL) {
							ValaDataType* _tmp791_;
							ValaDataType* _tmp792_;
							_tmp791_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp792_ = _tmp791_;
							_tmp789_ = _tmp792_ != NULL;
						} else {
							_tmp789_ = FALSE;
						}
						if (_tmp789_) {
							ValaMethod* _tmp793_;
							ValaDataType* _tmp794_;
							ValaDataType* _tmp795_;
							ValaTypeParameter* _tmp796_;
							ValaDataType* _tmp797_;
							ValaDataType* _tmp798_;
							ValaDataType* _tmp799_;
							_tmp793_ = m;
							_tmp794_ = vala_callable_get_return_type ((ValaCallable*) _tmp793_);
							_tmp795_ = _tmp794_;
							_tmp796_ = type_param;
							_tmp797_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp798_ = _tmp797_;
							_tmp799_ = vala_data_type_infer_type_argument (_tmp795_, _tmp796_, _tmp798_);
							_vala_code_node_unref0 (type_arg);
							type_arg = _tmp799_;
						}
						_tmp800_ = type_arg;
						if (_tmp800_ == NULL) {
							ValaMemberAccess* _tmp801_;
							ValaSourceReference* _tmp802_;
							ValaSourceReference* _tmp803_;
							ValaTypeParameter* _tmp804_;
							gchar* _tmp805_;
							gchar* _tmp806_;
							gchar* _tmp807_;
							gchar* _tmp808_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp801_ = ma;
							_tmp802_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp801_);
							_tmp803_ = _tmp802_;
							_tmp804_ = type_param;
							_tmp805_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp804_);
							_tmp806_ = _tmp805_;
							_tmp807_ = g_strdup_printf ("cannot infer generic type argument for type parameter `%s'", _tmp806_);
							_tmp808_ = _tmp807_;
							vala_report_error (_tmp803_, _tmp808_);
							_g_free0 (_tmp808_);
							_g_free0 (_tmp806_);
							result = FALSE;
							_vala_code_node_unref0 (type_arg);
							_vala_code_node_unref0 (type_param);
							_vala_iterable_unref0 (_type_param_list);
							_vala_code_node_unref0 (ma);
							_vala_code_node_unref0 (dynamic_sig);
							_vala_code_node_unref0 (m);
							_vala_iterator_unref0 (arg_it);
							_vala_iterable_unref0 (args);
							_vala_code_node_unref0 (last_arg);
							_vala_iterable_unref0 (params);
							_vala_code_node_unref0 (ret_type);
							_vala_code_node_unref0 (base_cm);
							_vala_code_node_unref0 (mtype);
							_vala_iterable_unref0 (method_type_args);
							_vala_code_node_unref0 (target_object_type);
							return result;
						}
						_tmp809_ = ma;
						_tmp810_ = type_arg;
						vala_member_access_add_type_argument (_tmp809_, _tmp810_);
						_vala_code_node_unref0 (type_arg);
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_tmp811_ = args;
				_tmp812_ = vala_iterable_iterator ((ValaIterable*) _tmp811_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp812_;
				{
					ValaList* _param_list = NULL;
					ValaList* _tmp813_;
					ValaList* _tmp814_;
					gint _param_size = 0;
					ValaList* _tmp815_;
					gint _tmp816_;
					gint _tmp817_;
					gint _param_index = 0;
					_tmp813_ = params;
					_tmp814_ = _vala_iterable_ref0 (_tmp813_);
					_param_list = _tmp814_;
					_tmp815_ = _param_list;
					_tmp816_ = vala_collection_get_size ((ValaCollection*) _tmp815_);
					_tmp817_ = _tmp816_;
					_param_size = _tmp817_;
					_param_index = -1;
					while (TRUE) {
						gint _tmp818_;
						gint _tmp819_;
						gint _tmp820_;
						ValaParameter* param = NULL;
						ValaList* _tmp821_;
						gint _tmp822_;
						gpointer _tmp823_;
						gboolean _tmp824_ = FALSE;
						ValaParameter* _tmp825_;
						gboolean _tmp826_;
						gboolean _tmp827_;
						ValaIterator* _tmp831_;
						gboolean _tmp832_;
						_tmp818_ = _param_index;
						_param_index = _tmp818_ + 1;
						_tmp819_ = _param_index;
						_tmp820_ = _param_size;
						if (!(_tmp819_ < _tmp820_)) {
							break;
						}
						_tmp821_ = _param_list;
						_tmp822_ = _param_index;
						_tmp823_ = vala_list_get (_tmp821_, _tmp822_);
						param = (ValaParameter*) _tmp823_;
						_tmp825_ = param;
						_tmp826_ = vala_parameter_get_ellipsis (_tmp825_);
						_tmp827_ = _tmp826_;
						if (_tmp827_) {
							_tmp824_ = TRUE;
						} else {
							ValaParameter* _tmp828_;
							gboolean _tmp829_;
							gboolean _tmp830_;
							_tmp828_ = param;
							_tmp829_ = vala_parameter_get_params_array (_tmp828_);
							_tmp830_ = _tmp829_;
							_tmp824_ = _tmp830_;
						}
						if (_tmp824_) {
							_vala_code_node_unref0 (param);
							break;
						}
						_tmp831_ = arg_it;
						_tmp832_ = vala_iterator_next (_tmp831_);
						if (_tmp832_) {
							ValaExpression* arg = NULL;
							ValaIterator* _tmp833_;
							gpointer _tmp834_;
							ValaExpression* _tmp835_;
							ValaExpression* _tmp836_;
							ValaDataType* _tmp837_;
							ValaDataType* _tmp838_;
							ValaDataType* _tmp839_;
							ValaList* _tmp840_;
							ValaDataType* _tmp841_;
							ValaDataType* _tmp842_;
							_tmp833_ = arg_it;
							_tmp834_ = vala_iterator_get (_tmp833_);
							arg = (ValaExpression*) _tmp834_;
							_tmp835_ = arg;
							_tmp836_ = arg;
							_tmp837_ = vala_expression_get_formal_target_type (_tmp836_);
							_tmp838_ = _tmp837_;
							_tmp839_ = target_object_type;
							_tmp840_ = method_type_args;
							_tmp841_ = vala_data_type_get_actual_type (_tmp838_, _tmp839_, _tmp840_, (ValaCodeNode*) self);
							_tmp842_ = _tmp841_;
							vala_expression_set_target_type (_tmp835_, _tmp842_);
							_vala_code_node_unref0 (_tmp842_);
							_vala_code_node_unref0 (arg);
						}
						_vala_code_node_unref0 (param);
					}
					_vala_iterable_unref0 (_param_list);
				}
				_tmp843_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
				_tmp844_ = _tmp843_;
				_tmp845_ = target_object_type;
				_tmp846_ = method_type_args;
				_tmp847_ = vala_data_type_get_actual_type (_tmp844_, _tmp845_, _tmp846_, (ValaCodeNode*) self);
				_tmp848_ = _tmp847_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp848_);
				_vala_code_node_unref0 (_tmp848_);
			}
			_vala_code_node_unref0 (ma);
		}
		_tmp850_ = m;
		if (_tmp850_ != NULL) {
			ValaMethod* _tmp851_;
			gboolean _tmp852_;
			gboolean _tmp853_;
			_tmp851_ = m;
			_tmp852_ = vala_method_get_coroutine (_tmp851_);
			_tmp853_ = _tmp852_;
			_tmp849_ = _tmp853_;
		} else {
			_tmp849_ = FALSE;
		}
		if (_tmp849_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp854_;
			ValaExpression* _tmp855_;
			ValaMemberAccess* _tmp856_;
			ValaMemberAccess* _tmp857_;
			const gchar* _tmp858_;
			const gchar* _tmp859_;
			_tmp854_ = vala_method_call_get_call (self);
			_tmp855_ = _tmp854_;
			_tmp856_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp855_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp856_;
			_tmp857_ = ma;
			_tmp858_ = vala_member_access_get_member_name (_tmp857_);
			_tmp859_ = _tmp858_;
			if (g_strcmp0 (_tmp859_, "end") == 0) {
				ValaMethod* _tmp860_;
				ValaMethod* _tmp861_;
				ValaMethod* _tmp862_;
				ValaMethodType* _tmp863_;
				_tmp860_ = m;
				_tmp861_ = vala_method_get_end_method (_tmp860_);
				_tmp862_ = _tmp861_;
				_tmp863_ = vala_method_type_new (_tmp862_);
				_vala_code_node_unref0 (mtype);
				mtype = (ValaDataType*) _tmp863_;
				_vala_code_node_unref0 (_tmp862_);
			}
			_vala_code_node_unref0 (ma);
		}
		_vala_code_node_unref0 (dynamic_sig);
		_vala_code_node_unref0 (m);
	} else {
		ValaDataType* _tmp864_;
		_tmp864_ = mtype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp864_, VALA_TYPE_OBJECT_TYPE)) {
			ValaClass* cl = NULL;
			ValaDataType* _tmp865_;
			ValaObjectTypeSymbol* _tmp866_;
			ValaObjectTypeSymbol* _tmp867_;
			ValaClass* _tmp868_;
			ValaCreationMethod* m = NULL;
			ValaClass* _tmp869_;
			ValaCreationMethod* _tmp870_;
			ValaCreationMethod* _tmp871_;
			ValaCreationMethod* _tmp872_;
			_tmp865_ = mtype;
			_tmp866_ = vala_object_type_get_type_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp865_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			_tmp867_ = _tmp866_;
			_tmp868_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp867_, VALA_TYPE_CLASS, ValaClass));
			cl = _tmp868_;
			_tmp869_ = cl;
			_tmp870_ = vala_class_get_default_construction_method (_tmp869_);
			_tmp871_ = _tmp870_;
			_tmp872_ = _vala_code_node_ref0 (_tmp871_);
			m = _tmp872_;
			{
				ValaList* _error_type_list = NULL;
				ValaCreationMethod* _tmp873_;
				ValaList* _tmp874_;
				gint _error_type_size = 0;
				ValaList* _tmp875_;
				gint _tmp876_;
				gint _tmp877_;
				gint _error_type_index = 0;
				_tmp873_ = m;
				_tmp874_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp873_);
				_error_type_list = _tmp874_;
				_tmp875_ = _error_type_list;
				_tmp876_ = vala_collection_get_size ((ValaCollection*) _tmp875_);
				_tmp877_ = _tmp876_;
				_error_type_size = _tmp877_;
				_error_type_index = -1;
				while (TRUE) {
					gint _tmp878_;
					gint _tmp879_;
					gint _tmp880_;
					ValaDataType* error_type = NULL;
					ValaList* _tmp881_;
					gint _tmp882_;
					gpointer _tmp883_;
					ValaDataType* call_error_type = NULL;
					ValaDataType* _tmp884_;
					ValaDataType* _tmp885_;
					ValaDataType* _tmp886_;
					ValaSourceReference* _tmp887_;
					ValaSourceReference* _tmp888_;
					ValaDataType* _tmp889_;
					_tmp878_ = _error_type_index;
					_error_type_index = _tmp878_ + 1;
					_tmp879_ = _error_type_index;
					_tmp880_ = _error_type_size;
					if (!(_tmp879_ < _tmp880_)) {
						break;
					}
					_tmp881_ = _error_type_list;
					_tmp882_ = _error_type_index;
					_tmp883_ = vala_list_get (_tmp881_, _tmp882_);
					error_type = (ValaDataType*) _tmp883_;
					may_throw = TRUE;
					_tmp884_ = error_type;
					_tmp885_ = vala_data_type_copy (_tmp884_);
					call_error_type = _tmp885_;
					_tmp886_ = call_error_type;
					_tmp887_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp888_ = _tmp887_;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp886_, _tmp888_);
					_tmp889_ = call_error_type;
					vala_code_node_add_error_type ((ValaCodeNode*) self, _tmp889_);
					_vala_code_node_unref0 (call_error_type);
					_vala_code_node_unref0 (error_type);
				}
				_vala_iterable_unref0 (_error_type_list);
			}
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (cl);
		} else {
			ValaDataType* _tmp890_;
			_tmp890_ = mtype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp890_, VALA_TYPE_DELEGATE_TYPE)) {
				ValaDelegate* d = NULL;
				ValaDataType* _tmp891_;
				ValaDelegate* _tmp892_;
				ValaDelegate* _tmp893_;
				ValaDelegate* _tmp894_;
				_tmp891_ = mtype;
				_tmp892_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp891_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				_tmp893_ = _tmp892_;
				_tmp894_ = _vala_code_node_ref0 (_tmp893_);
				d = _tmp894_;
				{
					ValaList* _error_type_list = NULL;
					ValaDelegate* _tmp895_;
					ValaList* _tmp896_;
					gint _error_type_size = 0;
					ValaList* _tmp897_;
					gint _tmp898_;
					gint _tmp899_;
					gint _error_type_index = 0;
					_tmp895_ = d;
					_tmp896_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp895_);
					_error_type_list = _tmp896_;
					_tmp897_ = _error_type_list;
					_tmp898_ = vala_collection_get_size ((ValaCollection*) _tmp897_);
					_tmp899_ = _tmp898_;
					_error_type_size = _tmp899_;
					_error_type_index = -1;
					while (TRUE) {
						gint _tmp900_;
						gint _tmp901_;
						gint _tmp902_;
						ValaDataType* error_type = NULL;
						ValaList* _tmp903_;
						gint _tmp904_;
						gpointer _tmp905_;
						ValaDataType* call_error_type = NULL;
						ValaDataType* _tmp906_;
						ValaDataType* _tmp907_;
						ValaDataType* _tmp908_;
						ValaSourceReference* _tmp909_;
						ValaSourceReference* _tmp910_;
						ValaDataType* _tmp911_;
						_tmp900_ = _error_type_index;
						_error_type_index = _tmp900_ + 1;
						_tmp901_ = _error_type_index;
						_tmp902_ = _error_type_size;
						if (!(_tmp901_ < _tmp902_)) {
							break;
						}
						_tmp903_ = _error_type_list;
						_tmp904_ = _error_type_index;
						_tmp905_ = vala_list_get (_tmp903_, _tmp904_);
						error_type = (ValaDataType*) _tmp905_;
						may_throw = TRUE;
						_tmp906_ = error_type;
						_tmp907_ = vala_data_type_copy (_tmp906_);
						call_error_type = _tmp907_;
						_tmp908_ = call_error_type;
						_tmp909_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp910_ = _tmp909_;
						vala_code_node_set_source_reference ((ValaCodeNode*) _tmp908_, _tmp910_);
						_tmp911_ = call_error_type;
						vala_code_node_add_error_type ((ValaCodeNode*) self, _tmp911_);
						_vala_code_node_unref0 (call_error_type);
						_vala_code_node_unref0 (error_type);
					}
					_vala_iterable_unref0 (_error_type_list);
				}
				_vala_code_node_unref0 (d);
			}
		}
	}
	_tmp912_ = context;
	_tmp913_ = vala_code_context_get_analyzer (_tmp912_);
	_tmp914_ = _tmp913_;
	_tmp915_ = mtype;
	_tmp916_ = params;
	_tmp917_ = vala_method_call_get_argument_list (self);
	_tmp918_ = _tmp917_;
	_tmp919_ = vala_semantic_analyzer_check_arguments (_tmp914_, (ValaExpression*) self, _tmp915_, _tmp916_, _tmp918_);
	_tmp920_ = !_tmp919_;
	_vala_iterable_unref0 (_tmp918_);
	if (_tmp920_) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_iterator_unref0 (arg_it);
		_vala_iterable_unref0 (args);
		_vala_code_node_unref0 (last_arg);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (ret_type);
		_vala_code_node_unref0 (base_cm);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	}
	_tmp923_ = base_cm;
	if (_tmp923_ != NULL) {
		ValaCreationMethod* _tmp924_;
		gboolean _tmp925_;
		_tmp924_ = base_cm;
		_tmp925_ = vala_method_is_variadic ((ValaMethod*) _tmp924_);
		_tmp922_ = _tmp925_;
	} else {
		_tmp922_ = FALSE;
	}
	if (_tmp922_) {
		ValaList* _tmp926_;
		gint _tmp927_;
		gint _tmp928_;
		ValaCreationMethod* _tmp929_;
		ValaList* _tmp930_;
		ValaList* _tmp931_;
		gint _tmp932_;
		gint _tmp933_;
		_tmp926_ = args;
		_tmp927_ = vala_collection_get_size ((ValaCollection*) _tmp926_);
		_tmp928_ = _tmp927_;
		_tmp929_ = base_cm;
		_tmp930_ = vala_callable_get_parameters ((ValaCallable*) _tmp929_);
		_tmp931_ = _tmp930_;
		_tmp932_ = vala_collection_get_size ((ValaCollection*) _tmp931_);
		_tmp933_ = _tmp932_;
		_tmp921_ = _tmp928_ == _tmp933_;
		_vala_iterable_unref0 (_tmp931_);
	} else {
		_tmp921_ = FALSE;
	}
	if (_tmp921_) {
		ValaExpression* this_last_arg = NULL;
		ValaList* _tmp934_;
		ValaList* _tmp935_;
		gint _tmp936_;
		gint _tmp937_;
		gpointer _tmp938_;
		gboolean _tmp939_ = FALSE;
		ValaExpression* _tmp940_;
		ValaDataType* _tmp941_;
		ValaDataType* _tmp942_;
		_tmp934_ = args;
		_tmp935_ = args;
		_tmp936_ = vala_collection_get_size ((ValaCollection*) _tmp935_);
		_tmp937_ = _tmp936_;
		_tmp938_ = vala_list_get (_tmp934_, _tmp937_ - 1);
		this_last_arg = (ValaExpression*) _tmp938_;
		_tmp940_ = this_last_arg;
		_tmp941_ = vala_expression_get_value_type (_tmp940_);
		_tmp942_ = _tmp941_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp942_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
			ValaExpression* _tmp943_;
			ValaDataType* _tmp944_;
			ValaDataType* _tmp945_;
			ValaTypeSymbol* _tmp946_;
			ValaTypeSymbol* _tmp947_;
			ValaCodeContext* _tmp948_;
			ValaSemanticAnalyzer* _tmp949_;
			ValaSemanticAnalyzer* _tmp950_;
			ValaDataType* _tmp951_;
			ValaTypeSymbol* _tmp952_;
			ValaTypeSymbol* _tmp953_;
			_tmp943_ = this_last_arg;
			_tmp944_ = vala_expression_get_value_type (_tmp943_);
			_tmp945_ = _tmp944_;
			_tmp946_ = vala_data_type_get_data_type (_tmp945_);
			_tmp947_ = _tmp946_;
			_tmp948_ = context;
			_tmp949_ = vala_code_context_get_analyzer (_tmp948_);
			_tmp950_ = _tmp949_;
			_tmp951_ = _tmp950_->va_list_type;
			_tmp952_ = vala_data_type_get_data_type (_tmp951_);
			_tmp953_ = _tmp952_;
			_tmp939_ = _tmp947_ == _tmp953_;
		} else {
			_tmp939_ = FALSE;
		}
		if (_tmp939_) {
			vala_method_call_set_is_constructv_chainup (self, TRUE);
		}
		_vala_code_node_unref0 (this_last_arg);
	}
	_tmp954_ = may_throw;
	if (_tmp954_) {
		gboolean _tmp955_ = FALSE;
		ValaCodeNode* _tmp956_;
		ValaCodeNode* _tmp957_;
		_tmp956_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp957_ = _tmp956_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp957_, VALA_TYPE_LOCAL_VARIABLE)) {
			_tmp955_ = TRUE;
		} else {
			ValaCodeNode* _tmp958_;
			ValaCodeNode* _tmp959_;
			_tmp958_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp959_ = _tmp958_;
			_tmp955_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp959_, VALA_TYPE_EXPRESSION_STATEMENT);
		}
		if (_tmp955_) {
		} else {
			ValaCodeContext* _tmp960_;
			ValaSemanticAnalyzer* _tmp961_;
			ValaSemanticAnalyzer* _tmp962_;
			ValaSymbol* _tmp963_;
			ValaSymbol* _tmp964_;
			_tmp960_ = context;
			_tmp961_ = vala_code_context_get_analyzer (_tmp960_);
			_tmp962_ = _tmp961_;
			_tmp963_ = vala_semantic_analyzer_get_current_symbol (_tmp962_);
			_tmp964_ = _tmp963_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp964_, VALA_TYPE_BLOCK)) {
				ValaSourceReference* _tmp965_;
				ValaSourceReference* _tmp966_;
				_tmp965_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp966_ = _tmp965_;
				vala_report_error (_tmp966_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp967_;
				ValaCodeNode* _tmp968_;
				ValaCodeNode* _tmp969_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp970_;
				ValaDataType* _tmp971_;
				ValaDataType* _tmp972_;
				ValaDataType* _tmp973_;
				gchar* _tmp974_;
				gchar* _tmp975_;
				ValaSourceReference* _tmp976_;
				ValaSourceReference* _tmp977_;
				ValaLocalVariable* _tmp978_;
				ValaLocalVariable* _tmp979_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp980_;
				ValaSourceReference* _tmp981_;
				ValaSourceReference* _tmp982_;
				ValaDeclarationStatement* _tmp983_;
				ValaCodeContext* _tmp984_;
				ValaSemanticAnalyzer* _tmp985_;
				ValaSemanticAnalyzer* _tmp986_;
				ValaBlock* _tmp987_;
				ValaDeclarationStatement* _tmp988_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp989_;
				ValaDataType* _tmp990_;
				ValaDataType* _tmp991_;
				ValaExpression* _tmp992_;
				ValaLocalVariable* _tmp993_;
				ValaDeclarationStatement* _tmp994_;
				ValaCodeContext* _tmp995_;
				ValaBlock* block = NULL;
				ValaCodeContext* _tmp996_;
				ValaSemanticAnalyzer* _tmp997_;
				ValaSemanticAnalyzer* _tmp998_;
				ValaSymbol* _tmp999_;
				ValaSymbol* _tmp1000_;
				ValaBlock* _tmp1001_;
				ValaBlock* _tmp1002_;
				ValaLocalVariable* _tmp1003_;
				ValaCodeContext* _tmp1004_;
				ValaSemanticAnalyzer* _tmp1005_;
				ValaSemanticAnalyzer* _tmp1006_;
				ValaBlock* _tmp1007_;
				ValaLocalVariable* _tmp1008_;
				ValaCodeNode* _tmp1009_;
				ValaExpression* _tmp1010_;
				ValaExpression* _tmp1011_;
				ValaCodeContext* _tmp1012_;
				_tmp967_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp968_ = _tmp967_;
				_tmp969_ = _vala_code_node_ref0 (_tmp968_);
				old_parent_node = _tmp969_;
				_tmp970_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp971_ = _tmp970_;
				_tmp972_ = vala_data_type_copy (_tmp971_);
				_tmp973_ = _tmp972_;
				_tmp974_ = vala_code_node_get_temp_name ();
				_tmp975_ = _tmp974_;
				_tmp976_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp977_ = _tmp976_;
				_tmp978_ = vala_local_variable_new (_tmp973_, _tmp975_, NULL, _tmp977_);
				_tmp979_ = _tmp978_;
				_g_free0 (_tmp975_);
				_vala_code_node_unref0 (_tmp973_);
				local = _tmp979_;
				_tmp980_ = local;
				_tmp981_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp982_ = _tmp981_;
				_tmp983_ = vala_declaration_statement_new ((ValaSymbol*) _tmp980_, _tmp982_);
				decl = _tmp983_;
				_tmp984_ = context;
				_tmp985_ = vala_code_context_get_analyzer (_tmp984_);
				_tmp986_ = _tmp985_;
				_tmp987_ = _tmp986_->insert_block;
				_tmp988_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp987_, (ValaStatement*) _tmp988_);
				_tmp989_ = local;
				_tmp990_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp991_ = _tmp990_;
				_tmp992_ = vala_semantic_analyzer_create_temp_access (_tmp989_, _tmp991_);
				temp_access = _tmp992_;
				_tmp993_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp993_, (ValaExpression*) self);
				_tmp994_ = decl;
				_tmp995_ = context;
				vala_code_node_check ((ValaCodeNode*) _tmp994_, _tmp995_);
				_tmp996_ = context;
				_tmp997_ = vala_code_context_get_analyzer (_tmp996_);
				_tmp998_ = _tmp997_;
				_tmp999_ = vala_semantic_analyzer_get_current_symbol (_tmp998_);
				_tmp1000_ = _tmp999_;
				_tmp1001_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1000_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp1001_;
				_tmp1002_ = block;
				_tmp1003_ = local;
				vala_block_remove_local_variable (_tmp1002_, _tmp1003_);
				_tmp1004_ = context;
				_tmp1005_ = vala_code_context_get_analyzer (_tmp1004_);
				_tmp1006_ = _tmp1005_;
				_tmp1007_ = _tmp1006_->insert_block;
				_tmp1008_ = local;
				vala_block_add_local_variable (_tmp1007_, _tmp1008_);
				_tmp1009_ = old_parent_node;
				_tmp1010_ = temp_access;
				vala_code_node_replace_expression (_tmp1009_, (ValaExpression*) self, _tmp1010_);
				_tmp1011_ = temp_access;
				_tmp1012_ = context;
				vala_code_node_check ((ValaCodeNode*) _tmp1011_, _tmp1012_);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp1013_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1014_ = _tmp1013_;
	result = !_tmp1014_;
	_vala_iterator_unref0 (arg_it);
	_vala_iterable_unref0 (args);
	_vala_code_node_unref0 (last_arg);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (ret_type);
	_vala_code_node_unref0 (base_cm);
	_vala_code_node_unref0 (mtype);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (target_object_type);
	return result;
}


static void vala_method_call_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen) {
	ValaMethodCall * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValaMethodType* _tmp6_;
	ValaCodeGenerator* _tmp35_;
	ValaCodeGenerator* _tmp36_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_METHOD_TYPE) ? ((ValaMethodType*) _tmp3_) : NULL);
	method_type = _tmp4_;
	_tmp6_ = method_type;
	if (_tmp6_ != NULL) {
		ValaMethodType* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp7_ = method_type;
		_tmp8_ = vala_method_type_get_method_symbol (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp5_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, VALA_TYPE_SIGNAL);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaExpression* signal_access = NULL;
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		ValaExpression* _tmp14_;
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		ValaCodeGenerator* _tmp18_;
		_tmp12_ = vala_method_call_get_call (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_tmp15_ = _tmp14_;
		_tmp16_ = _vala_code_node_ref0 (_tmp15_);
		signal_access = _tmp16_;
		_tmp17_ = signal_access;
		_tmp18_ = codegen;
		vala_code_node_emit ((ValaCodeNode*) _tmp17_, _tmp18_);
		_vala_code_node_unref0 (signal_access);
	} else {
		ValaExpression* _tmp19_;
		ValaExpression* _tmp20_;
		ValaCodeGenerator* _tmp21_;
		_tmp19_ = vala_method_call_get_call (self);
		_tmp20_ = _tmp19_;
		_tmp21_ = codegen;
		vala_code_node_emit ((ValaCodeNode*) _tmp20_, _tmp21_);
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp22_;
		ValaList* _tmp23_;
		gint _expr_size = 0;
		ValaList* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _expr_index = 0;
		_tmp22_ = self->priv->argument_list;
		_tmp23_ = _vala_iterable_ref0 (_tmp22_);
		_expr_list = _tmp23_;
		_tmp24_ = _expr_list;
		_tmp25_ = vala_collection_get_size ((ValaCollection*) _tmp24_);
		_tmp26_ = _tmp25_;
		_expr_size = _tmp26_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			ValaExpression* expr = NULL;
			ValaList* _tmp30_;
			gint _tmp31_;
			gpointer _tmp32_;
			ValaExpression* _tmp33_;
			ValaCodeGenerator* _tmp34_;
			_tmp27_ = _expr_index;
			_expr_index = _tmp27_ + 1;
			_tmp28_ = _expr_index;
			_tmp29_ = _expr_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _expr_list;
			_tmp31_ = _expr_index;
			_tmp32_ = vala_list_get (_tmp30_, _tmp31_);
			expr = (ValaExpression*) _tmp32_;
			_tmp33_ = expr;
			_tmp34_ = codegen;
			vala_code_node_emit ((ValaCodeNode*) _tmp33_, _tmp34_);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	_tmp35_ = codegen;
	vala_code_visitor_visit_method_call ((ValaCodeVisitor*) _tmp35_, self);
	_tmp36_ = codegen;
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) _tmp36_, (ValaExpression*) self);
	_vala_code_node_unref0 (method_type);
}


static void vala_method_call_real_get_defined_variables (ValaCodeNode* base, ValaCollection* collection) {
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCollection* _tmp2_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = collection;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, _tmp2_);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp3_;
		ValaList* _tmp4_;
		gint _arg_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _arg_index = 0;
		_tmp3_ = self->priv->argument_list;
		_tmp4_ = _vala_iterable_ref0 (_tmp3_);
		_arg_list = _tmp4_;
		_tmp5_ = _arg_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_arg_size = _tmp7_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			ValaExpression* arg = NULL;
			ValaList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			ValaExpression* _tmp14_;
			ValaCollection* _tmp15_;
			_tmp8_ = _arg_index;
			_arg_index = _tmp8_ + 1;
			_tmp9_ = _arg_index;
			_tmp10_ = _arg_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _arg_list;
			_tmp12_ = _arg_index;
			_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
			arg = (ValaExpression*) _tmp13_;
			_tmp14_ = arg;
			_tmp15_ = collection;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp14_, _tmp15_);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}


static void vala_method_call_real_get_used_variables (ValaCodeNode* base, ValaCollection* collection) {
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCollection* _tmp2_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = collection;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, _tmp2_);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp3_;
		ValaList* _tmp4_;
		gint _arg_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _arg_index = 0;
		_tmp3_ = self->priv->argument_list;
		_tmp4_ = _vala_iterable_ref0 (_tmp3_);
		_arg_list = _tmp4_;
		_tmp5_ = _arg_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_arg_size = _tmp7_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			ValaExpression* arg = NULL;
			ValaList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			ValaExpression* _tmp14_;
			ValaCollection* _tmp15_;
			_tmp8_ = _arg_index;
			_arg_index = _tmp8_ + 1;
			_tmp9_ = _arg_index;
			_tmp10_ = _arg_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _arg_list;
			_tmp12_ = _arg_index;
			_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
			arg = (ValaExpression*) _tmp13_;
			_tmp14_ = arg;
			_tmp15_ = collection;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp14_, _tmp15_);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}


ValaStringLiteral* vala_method_call_get_format_literal (ValaMethodCall* self) {
	ValaStringLiteral* result = NULL;
	ValaMethodType* mtype = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	ValaMethodType* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_METHOD_TYPE) ? ((ValaMethodType*) _tmp3_) : NULL);
	mtype = _tmp4_;
	_tmp5_ = mtype;
	if (_tmp5_ != NULL) {
		gint format_arg = 0;
		ValaMethodType* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		gint _tmp9_;
		gboolean _tmp10_ = FALSE;
		gint _tmp11_;
		_tmp6_ = mtype;
		_tmp7_ = vala_method_type_get_method_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_method_get_format_arg_index (_tmp8_);
		format_arg = _tmp9_;
		_tmp11_ = format_arg;
		if (_tmp11_ >= 0) {
			gint _tmp12_;
			ValaList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			_tmp12_ = format_arg;
			_tmp13_ = self->priv->argument_list;
			_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp10_ = _tmp12_ < _tmp15_;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			ValaList* _tmp16_;
			gint _tmp17_;
			gpointer _tmp18_;
			ValaExpression* _tmp19_;
			ValaStringLiteral* _tmp20_;
			ValaStringLiteral* _tmp21_;
			_tmp16_ = self->priv->argument_list;
			_tmp17_ = format_arg;
			_tmp18_ = vala_list_get (_tmp16_, _tmp17_);
			_tmp19_ = (ValaExpression*) _tmp18_;
			_tmp20_ = vala_string_literal_get_format_literal (_tmp19_);
			_tmp21_ = _tmp20_;
			_vala_code_node_unref0 (_tmp19_);
			result = _tmp21_;
			_vala_code_node_unref0 (mtype);
			return result;
		}
	}
	result = NULL;
	_vala_code_node_unref0 (mtype);
	return result;
}


ValaExpression* vala_method_call_get_call (ValaMethodCall* self) {
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_call;
	result = _tmp0_;
	return result;
}


void vala_method_call_set_call (ValaMethodCall* self, ValaExpression* value) {
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_call);
	self->priv->_call = _tmp1_;
	_tmp2_ = self->priv->_call;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


gboolean vala_method_call_get_is_yield_expression (ValaMethodCall* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_yield_expression;
	result = _tmp0_;
	return result;
}


void vala_method_call_set_is_yield_expression (ValaMethodCall* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_yield_expression = _tmp0_;
}


gboolean vala_method_call_get_is_assert (ValaMethodCall* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_assert;
	result = _tmp0_;
	return result;
}


static void vala_method_call_set_is_assert (ValaMethodCall* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_assert = _tmp0_;
}


gboolean vala_method_call_get_is_constructv_chainup (ValaMethodCall* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_constructv_chainup;
	result = _tmp0_;
	return result;
}


static void vala_method_call_set_is_constructv_chainup (ValaMethodCall* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_constructv_chainup = _tmp0_;
}


gboolean vala_method_call_get_is_chainup (ValaMethodCall* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_chainup;
	result = _tmp0_;
	return result;
}


static void vala_method_call_set_is_chainup (ValaMethodCall* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_chainup = _tmp0_;
}


static void vala_method_call_class_init (ValaMethodCallClass * klass) {
	vala_method_call_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_call_finalize;
	g_type_class_add_private (klass, sizeof (ValaMethodCallPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_method_call_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_method_call_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_method_call_real_replace_expression;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression *)) vala_method_call_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression *)) vala_method_call_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression *, ValaSymbol*)) vala_method_call_real_is_accessible;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_method_call_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_method_call_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_method_call_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_method_call_real_get_used_variables;
}


static void vala_method_call_instance_init (ValaMethodCall * self) {
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_METHOD_CALL_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
}


static void vala_method_call_finalize (ValaCodeNode * obj) {
	ValaMethodCall * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD_CALL, ValaMethodCall);
	_vala_code_node_unref0 (self->priv->_call);
	_vala_iterable_unref0 (self->priv->argument_list);
	VALA_CODE_NODE_CLASS (vala_method_call_parent_class)->finalize (obj);
}


/**
 * Represents an invocation expression in the source code.
 */
GType vala_method_call_get_type (void) {
	static volatile gsize vala_method_call_type_id__volatile = 0;
	if (g_once_init_enter (&vala_method_call_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMethodCallClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_call_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethodCall), 0, (GInstanceInitFunc) vala_method_call_instance_init, NULL };
		GType vala_method_call_type_id;
		vala_method_call_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMethodCall", &g_define_type_info, 0);
		g_once_init_leave (&vala_method_call_type_id__volatile, vala_method_call_type_id);
	}
	return vala_method_call_type_id__volatile;
}



