/* markupreader.c generated by valac, the Vala compiler
 * generated from markupreader.vala, do not modify */

/* markupreader.vala
 *
 * Copyright (C) 2008-2009  Jürg Billeter
 * Copyright (C) 2011       Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "valadoc.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

enum  {
	VALADOC_MARKUP_READER_0_PROPERTY,
	VALADOC_MARKUP_READER_FILENAME_PROPERTY,
	VALADOC_MARKUP_READER_NAME_PROPERTY,
	VALADOC_MARKUP_READER_CONTENT_PROPERTY,
	VALADOC_MARKUP_READER_NUM_PROPERTIES
};
static GParamSpec* valadoc_markup_reader_properties[VALADOC_MARKUP_READER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_mapped_file_unref0(var) ((var == NULL) ? NULL : (var = (g_mapped_file_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValadocMarkupReaderPrivate {
	gchar* _filename;
	gchar* _name;
	gchar* _content;
	GMappedFile* mapped_file;
	gchar** lines;
	gint lines_length1;
	gint _lines_size_;
	gchar* begin;
	gchar* current;
	gchar* end;
	gint line;
	gint column;
	ValaMap* attributes;
	gboolean empty_element;
	ValadocErrorReporter* reporter;
};


static gpointer valadoc_markup_reader_parent_class = NULL;

#define VALADOC_MARKUP_READER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALADOC_TYPE_MARKUP_READER, ValadocMarkupReaderPrivate))
static void valadoc_markup_reader_set_filename (ValadocMarkupReader* self, const gchar* value);
static gchar* valadoc_markup_reader_read_name (ValadocMarkupReader* self);
static void valadoc_markup_reader_set_content (ValadocMarkupReader* self, const gchar* value);
static void valadoc_markup_reader_set_name (ValadocMarkupReader* self, const gchar* value);
static void valadoc_markup_reader_space (ValadocMarkupReader* self);
static gchar* valadoc_markup_reader_text (ValadocMarkupReader* self, gchar end_char, gboolean rm_trailing_whitespace);
static void valadoc_markup_reader_finalize (GObject * obj);
static void _vala_valadoc_markup_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_valadoc_markup_reader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


ValadocMarkupReader* valadoc_markup_reader_construct_from_string (GType object_type, const gchar* filename, const gchar* content, ValadocErrorReporter* reporter) {
	ValadocMarkupReader * self = NULL;
	const gchar* _tmp0_;
	ValadocErrorReporter* _tmp1_;
	ValadocErrorReporter* _tmp2_;
	const gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gchar* _tmp11_;
	g_return_val_if_fail (filename != NULL, NULL);
	g_return_val_if_fail (content != NULL, NULL);
	g_return_val_if_fail (reporter != NULL, NULL);
	self = (ValadocMarkupReader*) g_object_new (object_type, NULL);
	_tmp0_ = filename;
	valadoc_markup_reader_set_filename (self, _tmp0_);
	_tmp1_ = reporter;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->reporter);
	self->priv->reporter = _tmp2_;
	_tmp3_ = content;
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, "\n", 0);
	self->priv->lines = (_vala_array_free (self->priv->lines, self->priv->lines_length1, (GDestroyNotify) g_free), NULL);
	self->priv->lines = _tmp5_;
	self->priv->lines_length1 = _vala_array_length (_tmp4_);
	self->priv->_lines_size_ = self->priv->lines_length1;
	_tmp6_ = content;
	self->priv->begin = _tmp6_;
	_tmp7_ = self->priv->begin;
	_tmp8_ = content;
	_tmp9_ = strlen (_tmp8_);
	_tmp10_ = _tmp9_;
	self->priv->end = _tmp7_ + _tmp10_;
	_tmp11_ = self->priv->begin;
	self->priv->current = _tmp11_;
	self->priv->column = 1;
	self->priv->line = 1;
	return self;
}


ValadocMarkupReader* valadoc_markup_reader_new_from_string (const gchar* filename, const gchar* content, ValadocErrorReporter* reporter) {
	return valadoc_markup_reader_construct_from_string (VALADOC_TYPE_MARKUP_READER, filename, content, reporter);
}


ValadocMarkupReader* valadoc_markup_reader_construct (GType object_type, const gchar* filename, ValadocErrorReporter* reporter) {
	ValadocMarkupReader * self = NULL;
	const gchar* _tmp0_;
	ValadocErrorReporter* _tmp1_;
	ValadocErrorReporter* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (filename != NULL, NULL);
	g_return_val_if_fail (reporter != NULL, NULL);
	self = (ValadocMarkupReader*) g_object_new (object_type, NULL);
	_tmp0_ = filename;
	valadoc_markup_reader_set_filename (self, _tmp0_);
	_tmp1_ = reporter;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->reporter);
	self->priv->reporter = _tmp2_;
	{
		GMappedFile* _tmp3_ = NULL;
		const gchar* _tmp4_;
		GMappedFile* _tmp5_;
		GMappedFile* _tmp6_;
		GMappedFile* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar** _tmp10_;
		gchar** _tmp11_;
		gchar* _tmp12_;
		GMappedFile* _tmp13_;
		gsize _tmp14_;
		gchar* _tmp15_;
		_tmp4_ = filename;
		_tmp5_ = g_mapped_file_new (_tmp4_, FALSE, &_inner_error_);
		_tmp3_ = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch4_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = _tmp3_;
		_tmp3_ = NULL;
		_g_mapped_file_unref0 (self->priv->mapped_file);
		self->priv->mapped_file = _tmp6_;
		_tmp7_ = self->priv->mapped_file;
		_tmp8_ = g_mapped_file_get_contents (_tmp7_);
		self->priv->begin = _tmp8_;
		_tmp9_ = self->priv->begin;
		_tmp11_ = _tmp10_ = g_strsplit ((const gchar*) _tmp9_, "\n", 0);
		self->priv->lines = (_vala_array_free (self->priv->lines, self->priv->lines_length1, (GDestroyNotify) g_free), NULL);
		self->priv->lines = _tmp11_;
		self->priv->lines_length1 = _vala_array_length (_tmp10_);
		self->priv->_lines_size_ = self->priv->lines_length1;
		_tmp12_ = self->priv->begin;
		_tmp13_ = self->priv->mapped_file;
		_tmp14_ = g_mapped_file_get_length (_tmp13_);
		self->priv->end = _tmp12_ + _tmp14_;
		_tmp15_ = self->priv->begin;
		self->priv->current = _tmp15_;
		self->priv->line = 1;
		self->priv->column = 1;
		_g_mapped_file_unref0 (_tmp3_);
	}
	goto __finally4;
	__catch4_g_file_error:
	{
		GError* e = NULL;
		ValadocErrorReporter* _tmp16_;
		const gchar* _tmp17_;
		GError* _tmp18_;
		const gchar* _tmp19_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = reporter;
		_tmp17_ = filename;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		valadoc_error_reporter_simple_error (_tmp16_, NULL, "Unable to map file '%s': %s", _tmp17_, _tmp19_);
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


ValadocMarkupReader* valadoc_markup_reader_new (const gchar* filename, ValadocErrorReporter* reporter) {
	return valadoc_markup_reader_construct (VALADOC_TYPE_MARKUP_READER, filename, reporter);
}


gchar* valadoc_markup_reader_get_line_content (ValadocMarkupReader* self, gint line_nr) {
	gchar* result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->lines;
	_tmp0__length1 = self->priv->lines_length1;
	_tmp1_ = line_nr;
	if (_tmp0__length1 > _tmp1_) {
		gchar** _tmp2_;
		gint _tmp2__length1;
		gint _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = self->priv->lines;
		_tmp2__length1 = self->priv->lines_length1;
		_tmp3_ = line_nr;
		_tmp4_ = _tmp2_[_tmp3_];
		_tmp5_ = g_strdup (_tmp4_);
		result = _tmp5_;
		return result;
	}
	result = NULL;
	return result;
}


gchar* valadoc_markup_reader_get_attribute (ValadocMarkupReader* self, const gchar* attr) {
	gchar* result = NULL;
	ValaMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (attr != NULL, NULL);
	_tmp0_ = self->priv->attributes;
	_tmp1_ = attr;
	_tmp2_ = vala_map_get (_tmp0_, _tmp1_);
	result = (gchar*) _tmp2_;
	return result;
}


ValaMap* valadoc_markup_reader_get_attributes (ValadocMarkupReader* self) {
	ValaMap* result = NULL;
	ValaHashMap* _result_ = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp0_, _tmp1_, _tmp2_);
	_result_ = _tmp3_;
	{
		ValaIterator* _key_it = NULL;
		ValaMap* _tmp4_;
		ValaSet* _tmp5_;
		ValaSet* _tmp6_;
		ValaIterator* _tmp7_;
		ValaIterator* _tmp8_;
		_tmp4_ = self->priv->attributes;
		_tmp5_ = vala_map_get_keys (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_iterable_iterator ((ValaIterable*) _tmp6_);
		_tmp8_ = _tmp7_;
		_vala_iterable_unref0 (_tmp6_);
		_key_it = _tmp8_;
		while (TRUE) {
			ValaIterator* _tmp9_;
			gboolean _tmp10_;
			gchar* key = NULL;
			ValaIterator* _tmp11_;
			gpointer _tmp12_;
			ValaHashMap* _tmp13_;
			const gchar* _tmp14_;
			ValaMap* _tmp15_;
			const gchar* _tmp16_;
			gpointer _tmp17_;
			gchar* _tmp18_;
			_tmp9_ = _key_it;
			_tmp10_ = vala_iterator_next (_tmp9_);
			if (!_tmp10_) {
				break;
			}
			_tmp11_ = _key_it;
			_tmp12_ = vala_iterator_get (_tmp11_);
			key = (gchar*) _tmp12_;
			_tmp13_ = _result_;
			_tmp14_ = key;
			_tmp15_ = self->priv->attributes;
			_tmp16_ = key;
			_tmp17_ = vala_map_get (_tmp15_, _tmp16_);
			_tmp18_ = (gchar*) _tmp17_;
			vala_map_set ((ValaMap*) _tmp13_, _tmp14_, _tmp18_);
			_g_free0 (_tmp18_);
			_g_free0 (key);
		}
		_vala_iterator_unref0 (_key_it);
	}
	result = (ValaMap*) _result_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gchar* valadoc_markup_reader_read_name (ValadocMarkupReader* self) {
	gchar* result = NULL;
	gchar* begin = NULL;
	gchar* _tmp0_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->current;
	begin = _tmp0_;
	while (TRUE) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		gchar* _tmp8_;
		gchar _tmp9_;
		gunichar u = 0U;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gunichar _tmp23_;
		gunichar _tmp24_;
		_tmp1_ = self->priv->current;
		_tmp2_ = self->priv->end;
		if (!(_tmp1_ < _tmp2_)) {
			break;
		}
		_tmp8_ = self->priv->current;
		_tmp9_ = _tmp8_[0];
		if (_tmp9_ == ' ') {
			_tmp7_ = TRUE;
		} else {
			gchar* _tmp10_;
			gchar _tmp11_;
			_tmp10_ = self->priv->current;
			_tmp11_ = _tmp10_[0];
			_tmp7_ = _tmp11_ == '\t';
		}
		if (_tmp7_) {
			_tmp6_ = TRUE;
		} else {
			gchar* _tmp12_;
			gchar _tmp13_;
			_tmp12_ = self->priv->current;
			_tmp13_ = _tmp12_[0];
			_tmp6_ = _tmp13_ == '>';
		}
		if (_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			gchar* _tmp14_;
			gchar _tmp15_;
			_tmp14_ = self->priv->current;
			_tmp15_ = _tmp14_[0];
			_tmp5_ = _tmp15_ == '/';
		}
		if (_tmp5_) {
			_tmp4_ = TRUE;
		} else {
			gchar* _tmp16_;
			gchar _tmp17_;
			_tmp16_ = self->priv->current;
			_tmp17_ = _tmp16_[0];
			_tmp4_ = _tmp17_ == '=';
		}
		if (_tmp4_) {
			_tmp3_ = TRUE;
		} else {
			gchar* _tmp18_;
			gchar _tmp19_;
			_tmp18_ = self->priv->current;
			_tmp19_ = _tmp18_[0];
			_tmp3_ = _tmp19_ == '\n';
		}
		if (_tmp3_) {
			break;
		}
		_tmp20_ = self->priv->current;
		_tmp21_ = self->priv->end;
		_tmp22_ = self->priv->current;
		_tmp23_ = g_utf8_get_char_validated ((const gchar*) _tmp20_, (gssize) ((glong) (_tmp21_ - _tmp22_)));
		u = _tmp23_;
		_tmp24_ = u;
		if (_tmp24_ != ((gunichar) -1)) {
			gchar* _tmp25_;
			gunichar _tmp26_;
			gint _tmp27_;
			_tmp25_ = self->priv->current;
			_tmp26_ = u;
			_tmp27_ = g_unichar_to_utf8 (_tmp26_, NULL);
			self->priv->current = _tmp25_ + _tmp27_;
		} else {
			ValadocErrorReporter* _tmp28_;
			const gchar* _tmp29_;
			gint _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			_tmp28_ = self->priv->reporter;
			_tmp29_ = self->priv->_filename;
			_tmp30_ = self->priv->line;
			_tmp31_ = g_strdup_printf ("%s:%d", _tmp29_, _tmp30_);
			_tmp32_ = _tmp31_;
			valadoc_error_reporter_simple_error (_tmp28_, _tmp32_, "invalid UTF-8 character");
			_g_free0 (_tmp32_);
		}
	}
	_tmp33_ = self->priv->current;
	_tmp34_ = begin;
	if (_tmp33_ == _tmp34_) {
	}
	_tmp35_ = begin;
	_tmp36_ = self->priv->current;
	_tmp37_ = begin;
	_tmp38_ = string_substring ((const gchar*) _tmp35_, (glong) 0, (glong) ((gint) (_tmp36_ - _tmp37_)));
	result = _tmp38_;
	return result;
}


ValadocMarkupTokenType valadoc_markup_reader_read_token (ValadocMarkupReader* self, ValadocMarkupSourceLocation* token_begin, ValadocMarkupSourceLocation* token_end) {
	ValadocMarkupSourceLocation _vala_token_begin = {0};
	ValadocMarkupSourceLocation _vala_token_end = {0};
	ValadocMarkupTokenType result = 0;
	ValaMap* _tmp0_;
	gboolean _tmp1_;
	ValadocMarkupTokenType type = 0;
	gchar* begin = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp111_;
	gint _tmp112_;
	gint _tmp113_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->attributes;
	vala_map_clear (_tmp0_);
	_tmp1_ = self->priv->empty_element;
	if (_tmp1_) {
		gchar* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gchar* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		self->priv->empty_element = FALSE;
		_tmp2_ = self->priv->begin;
		_tmp3_ = self->priv->line;
		_tmp4_ = self->priv->column;
		valadoc_markup_source_location_init (&_vala_token_begin, _tmp2_, _tmp3_, _tmp4_);
		_tmp5_ = self->priv->begin;
		_tmp6_ = self->priv->line;
		_tmp7_ = self->priv->column;
		valadoc_markup_source_location_init (&_vala_token_end, _tmp5_, _tmp6_, _tmp7_);
		result = VALADOC_MARKUP_TOKEN_TYPE_END_ELEMENT;
		if (token_begin) {
			*token_begin = _vala_token_begin;
		}
		if (token_end) {
			*token_end = _vala_token_end;
		}
		return result;
	}
	valadoc_markup_reader_set_content (self, NULL);
	valadoc_markup_reader_set_name (self, NULL);
	valadoc_markup_reader_space (self);
	type = VALADOC_MARKUP_TOKEN_TYPE_NONE;
	_tmp8_ = self->priv->current;
	begin = _tmp8_;
	_tmp9_ = begin;
	_tmp10_ = self->priv->line;
	_tmp11_ = self->priv->column;
	valadoc_markup_source_location_init (&_vala_token_begin, _tmp9_, _tmp10_, _tmp11_);
	_tmp12_ = self->priv->current;
	_tmp13_ = self->priv->end;
	if (_tmp12_ >= _tmp13_) {
		type = VALADOC_MARKUP_TOKEN_TYPE_EOF;
	} else {
		gchar* _tmp14_;
		gchar _tmp15_;
		_tmp14_ = self->priv->current;
		_tmp15_ = _tmp14_[0];
		if (_tmp15_ == '<') {
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp16_ = self->priv->current;
			self->priv->current = _tmp16_ + 1;
			_tmp17_ = self->priv->current;
			_tmp18_ = self->priv->end;
			if (_tmp17_ >= _tmp18_) {
			} else {
				gchar* _tmp19_;
				gchar _tmp20_;
				_tmp19_ = self->priv->current;
				_tmp20_ = _tmp19_[0];
				if (_tmp20_ == '?') {
				} else {
					gchar* _tmp21_;
					gchar _tmp22_;
					_tmp21_ = self->priv->current;
					_tmp22_ = _tmp21_[0];
					if (_tmp22_ == '!') {
						gchar* _tmp23_;
						gboolean _tmp24_ = FALSE;
						gboolean _tmp25_ = FALSE;
						gchar* _tmp26_;
						gchar* _tmp27_;
						_tmp23_ = self->priv->current;
						self->priv->current = _tmp23_ + 1;
						_tmp26_ = self->priv->current;
						_tmp27_ = self->priv->end;
						if (_tmp26_ < (_tmp27_ - 1)) {
							gchar* _tmp28_;
							gchar _tmp29_;
							_tmp28_ = self->priv->current;
							_tmp29_ = _tmp28_[0];
							_tmp25_ = _tmp29_ == '-';
						} else {
							_tmp25_ = FALSE;
						}
						if (_tmp25_) {
							gchar* _tmp30_;
							gchar _tmp31_;
							_tmp30_ = self->priv->current;
							_tmp31_ = _tmp30_[1];
							_tmp24_ = _tmp31_ == '-';
						} else {
							_tmp24_ = FALSE;
						}
						if (_tmp24_) {
							gchar* _tmp32_;
							ValadocMarkupSourceLocation _tmp48_ = {0};
							ValadocMarkupSourceLocation _tmp49_ = {0};
							ValadocMarkupTokenType _tmp50_;
							_tmp32_ = self->priv->current;
							self->priv->current = _tmp32_ + 2;
							while (TRUE) {
								gchar* _tmp33_;
								gchar* _tmp34_;
								gboolean _tmp35_ = FALSE;
								gboolean _tmp36_ = FALSE;
								gchar* _tmp37_;
								gchar _tmp38_;
								gchar* _tmp47_;
								_tmp33_ = self->priv->current;
								_tmp34_ = self->priv->end;
								if (!(_tmp33_ < (_tmp34_ - 2))) {
									break;
								}
								_tmp37_ = self->priv->current;
								_tmp38_ = _tmp37_[0];
								if (_tmp38_ == '-') {
									gchar* _tmp39_;
									gchar _tmp40_;
									_tmp39_ = self->priv->current;
									_tmp40_ = _tmp39_[1];
									_tmp36_ = _tmp40_ == '-';
								} else {
									_tmp36_ = FALSE;
								}
								if (_tmp36_) {
									gchar* _tmp41_;
									gchar _tmp42_;
									_tmp41_ = self->priv->current;
									_tmp42_ = _tmp41_[2];
									_tmp35_ = _tmp42_ == '>';
								} else {
									_tmp35_ = FALSE;
								}
								if (_tmp35_) {
									gchar* _tmp43_;
									_tmp43_ = self->priv->current;
									self->priv->current = _tmp43_ + 3;
									break;
								} else {
									gchar* _tmp44_;
									gchar _tmp45_;
									_tmp44_ = self->priv->current;
									_tmp45_ = _tmp44_[0];
									if (_tmp45_ == '\n') {
										gint _tmp46_;
										_tmp46_ = self->priv->line;
										self->priv->line = _tmp46_ + 1;
										self->priv->column = 0;
									}
								}
								_tmp47_ = self->priv->current;
								self->priv->current = _tmp47_ + 1;
							}
							_tmp50_ = valadoc_markup_reader_read_token (self, &_tmp48_, &_tmp49_);
							_vala_token_begin = _tmp48_;
							_vala_token_end = _tmp49_;
							result = _tmp50_;
							if (token_begin) {
								*token_begin = _vala_token_begin;
							}
							if (token_end) {
								*token_end = _vala_token_end;
							}
							return result;
						}
					} else {
						gchar* _tmp51_;
						gchar _tmp52_;
						_tmp51_ = self->priv->current;
						_tmp52_ = _tmp51_[0];
						if (_tmp52_ == '/') {
							gchar* _tmp53_;
							gchar* _tmp54_;
							gchar* _tmp55_;
							gboolean _tmp56_ = FALSE;
							gchar* _tmp57_;
							gchar* _tmp58_;
							gchar* _tmp61_;
							type = VALADOC_MARKUP_TOKEN_TYPE_END_ELEMENT;
							_tmp53_ = self->priv->current;
							self->priv->current = _tmp53_ + 1;
							_tmp54_ = valadoc_markup_reader_read_name (self);
							_tmp55_ = _tmp54_;
							valadoc_markup_reader_set_name (self, _tmp55_);
							_g_free0 (_tmp55_);
							_tmp57_ = self->priv->current;
							_tmp58_ = self->priv->end;
							if (_tmp57_ >= _tmp58_) {
								_tmp56_ = TRUE;
							} else {
								gchar* _tmp59_;
								gchar _tmp60_;
								_tmp59_ = self->priv->current;
								_tmp60_ = _tmp59_[0];
								_tmp56_ = _tmp60_ != '>';
							}
							if (_tmp56_) {
							}
							_tmp61_ = self->priv->current;
							self->priv->current = _tmp61_ + 1;
						} else {
							gchar* _tmp62_;
							gchar* _tmp63_;
							gchar* _tmp95_;
							gchar _tmp96_;
							gboolean _tmp98_ = FALSE;
							gchar* _tmp99_;
							gchar* _tmp100_;
							gchar* _tmp103_;
							type = VALADOC_MARKUP_TOKEN_TYPE_START_ELEMENT;
							_tmp62_ = valadoc_markup_reader_read_name (self);
							_tmp63_ = _tmp62_;
							valadoc_markup_reader_set_name (self, _tmp63_);
							_g_free0 (_tmp63_);
							valadoc_markup_reader_space (self);
							while (TRUE) {
								gboolean _tmp64_ = FALSE;
								gboolean _tmp65_ = FALSE;
								gchar* _tmp66_;
								gchar* _tmp67_;
								gchar* attr_name = NULL;
								gchar* _tmp72_;
								gboolean _tmp73_ = FALSE;
								gchar* _tmp74_;
								gchar* _tmp75_;
								gchar* _tmp78_;
								gboolean _tmp79_ = FALSE;
								gchar* _tmp80_;
								gchar* _tmp81_;
								gchar* _tmp84_;
								gchar* attr_value = NULL;
								gchar* _tmp85_;
								gboolean _tmp86_ = FALSE;
								gchar* _tmp87_;
								gchar* _tmp88_;
								gchar* _tmp91_;
								ValaMap* _tmp92_;
								const gchar* _tmp93_;
								const gchar* _tmp94_;
								_tmp66_ = self->priv->current;
								_tmp67_ = self->priv->end;
								if (_tmp66_ < _tmp67_) {
									gchar* _tmp68_;
									gchar _tmp69_;
									_tmp68_ = self->priv->current;
									_tmp69_ = _tmp68_[0];
									_tmp65_ = _tmp69_ != '>';
								} else {
									_tmp65_ = FALSE;
								}
								if (_tmp65_) {
									gchar* _tmp70_;
									gchar _tmp71_;
									_tmp70_ = self->priv->current;
									_tmp71_ = _tmp70_[0];
									_tmp64_ = _tmp71_ != '/';
								} else {
									_tmp64_ = FALSE;
								}
								if (!_tmp64_) {
									break;
								}
								_tmp72_ = valadoc_markup_reader_read_name (self);
								attr_name = _tmp72_;
								_tmp74_ = self->priv->current;
								_tmp75_ = self->priv->end;
								if (_tmp74_ >= _tmp75_) {
									_tmp73_ = TRUE;
								} else {
									gchar* _tmp76_;
									gchar _tmp77_;
									_tmp76_ = self->priv->current;
									_tmp77_ = _tmp76_[0];
									_tmp73_ = _tmp77_ != '=';
								}
								if (_tmp73_) {
								}
								_tmp78_ = self->priv->current;
								self->priv->current = _tmp78_ + 1;
								_tmp80_ = self->priv->current;
								_tmp81_ = self->priv->end;
								if (_tmp80_ >= _tmp81_) {
									_tmp79_ = TRUE;
								} else {
									gchar* _tmp82_;
									gchar _tmp83_;
									_tmp82_ = self->priv->current;
									_tmp83_ = _tmp82_[0];
									_tmp79_ = _tmp83_ != '"';
								}
								if (_tmp79_) {
								}
								_tmp84_ = self->priv->current;
								self->priv->current = _tmp84_ + 1;
								_tmp85_ = valadoc_markup_reader_text (self, '"', FALSE);
								attr_value = _tmp85_;
								_tmp87_ = self->priv->current;
								_tmp88_ = self->priv->end;
								if (_tmp87_ >= _tmp88_) {
									_tmp86_ = TRUE;
								} else {
									gchar* _tmp89_;
									gchar _tmp90_;
									_tmp89_ = self->priv->current;
									_tmp90_ = _tmp89_[0];
									_tmp86_ = _tmp90_ != '"';
								}
								if (_tmp86_) {
								}
								_tmp91_ = self->priv->current;
								self->priv->current = _tmp91_ + 1;
								_tmp92_ = self->priv->attributes;
								_tmp93_ = attr_name;
								_tmp94_ = attr_value;
								vala_map_set (_tmp92_, _tmp93_, _tmp94_);
								valadoc_markup_reader_space (self);
								_g_free0 (attr_value);
								_g_free0 (attr_name);
							}
							_tmp95_ = self->priv->current;
							_tmp96_ = _tmp95_[0];
							if (_tmp96_ == '/') {
								gchar* _tmp97_;
								self->priv->empty_element = TRUE;
								_tmp97_ = self->priv->current;
								self->priv->current = _tmp97_ + 1;
								valadoc_markup_reader_space (self);
							} else {
								self->priv->empty_element = FALSE;
							}
							_tmp99_ = self->priv->current;
							_tmp100_ = self->priv->end;
							if (_tmp99_ >= _tmp100_) {
								_tmp98_ = TRUE;
							} else {
								gchar* _tmp101_;
								gchar _tmp102_;
								_tmp101_ = self->priv->current;
								_tmp102_ = _tmp101_[0];
								_tmp98_ = _tmp102_ != '>';
							}
							if (_tmp98_) {
							}
							_tmp103_ = self->priv->current;
							self->priv->current = _tmp103_ + 1;
						}
					}
				}
			}
		} else {
			gchar* _tmp104_;
			gchar _tmp105_;
			valadoc_markup_reader_space (self);
			_tmp104_ = self->priv->current;
			_tmp105_ = _tmp104_[0];
			if (_tmp105_ != '<') {
				gchar* _tmp106_;
				gchar* _tmp107_;
				_tmp106_ = valadoc_markup_reader_text (self, '<', TRUE);
				_tmp107_ = _tmp106_;
				valadoc_markup_reader_set_content (self, _tmp107_);
				_g_free0 (_tmp107_);
			} else {
				ValadocMarkupSourceLocation _tmp108_ = {0};
				ValadocMarkupSourceLocation _tmp109_ = {0};
				ValadocMarkupTokenType _tmp110_;
				_tmp110_ = valadoc_markup_reader_read_token (self, &_tmp108_, &_tmp109_);
				_vala_token_begin = _tmp108_;
				_vala_token_end = _tmp109_;
				result = _tmp110_;
				if (token_begin) {
					*token_begin = _vala_token_begin;
				}
				if (token_end) {
					*token_end = _vala_token_end;
				}
				return result;
			}
			type = VALADOC_MARKUP_TOKEN_TYPE_TEXT;
		}
	}
	_tmp111_ = self->priv->current;
	_tmp112_ = self->priv->line;
	_tmp113_ = self->priv->column;
	valadoc_markup_source_location_init (&_vala_token_end, _tmp111_, _tmp112_, _tmp113_ - 1);
	result = type;
	if (token_begin) {
		*token_begin = _vala_token_begin;
	}
	if (token_end) {
		*token_end = _vala_token_end;
	}
	return result;
}


static gchar* valadoc_markup_reader_text (ValadocMarkupReader* self, gchar end_char, gboolean rm_trailing_whitespace) {
	gchar* result = NULL;
	GString* content = NULL;
	GString* _tmp0_;
	gchar* text_begin = NULL;
	gchar* _tmp1_;
	gchar* last_linebreak = NULL;
	gchar* _tmp2_;
	gchar* _tmp99_;
	gchar* _tmp100_;
	gint _tmp107_;
	gchar* _tmp108_;
	gchar* _tmp109_;
	gboolean _tmp110_;
	GString* _tmp129_;
	const gchar* _tmp130_;
	gchar* _tmp131_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	content = _tmp0_;
	_tmp1_ = self->priv->current;
	text_begin = _tmp1_;
	_tmp2_ = self->priv->current;
	last_linebreak = _tmp2_;
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gunichar u = 0U;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gunichar _tmp12_;
		gunichar _tmp13_;
		_tmp4_ = self->priv->current;
		_tmp5_ = self->priv->end;
		if (_tmp4_ < _tmp5_) {
			gchar* _tmp6_;
			gchar _tmp7_;
			gchar _tmp8_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[0];
			_tmp8_ = end_char;
			_tmp3_ = _tmp7_ != _tmp8_;
		} else {
			_tmp3_ = FALSE;
		}
		if (!_tmp3_) {
			break;
		}
		_tmp9_ = self->priv->current;
		_tmp10_ = self->priv->end;
		_tmp11_ = self->priv->current;
		_tmp12_ = g_utf8_get_char_validated ((const gchar*) _tmp9_, (gssize) ((glong) (_tmp10_ - _tmp11_)));
		u = _tmp12_;
		_tmp13_ = u;
		if (_tmp13_ == ((gunichar) -1)) {
			ValadocErrorReporter* _tmp14_;
			const gchar* _tmp15_;
			gint _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp14_ = self->priv->reporter;
			_tmp15_ = self->priv->_filename;
			_tmp16_ = self->priv->line;
			_tmp17_ = g_strdup_printf ("%s:%d", _tmp15_, _tmp16_);
			_tmp18_ = _tmp17_;
			valadoc_error_reporter_simple_error (_tmp14_, _tmp18_, "invalid UTF-8 character");
			_g_free0 (_tmp18_);
		} else {
			gunichar _tmp19_;
			_tmp19_ = u;
			if (_tmp19_ == ((gunichar) '&')) {
				gchar* next_pos = NULL;
				gchar* _tmp20_;
				gunichar _tmp21_;
				gint _tmp22_;
				gchar* _tmp23_;
				gboolean _tmp24_;
				_tmp20_ = self->priv->current;
				_tmp21_ = u;
				_tmp22_ = g_unichar_to_utf8 (_tmp21_, NULL);
				next_pos = _tmp20_ + _tmp22_;
				_tmp23_ = next_pos;
				_tmp24_ = g_str_has_prefix ((const gchar*) _tmp23_, "amp;");
				if (_tmp24_) {
					GString* _tmp25_;
					gchar* _tmp26_;
					gchar* _tmp27_;
					gchar* _tmp28_;
					gchar* _tmp29_;
					gchar* _tmp30_;
					GString* _tmp31_;
					gchar* _tmp32_;
					gchar* _tmp33_;
					_tmp25_ = content;
					_tmp26_ = text_begin;
					_tmp27_ = self->priv->current;
					_tmp28_ = text_begin;
					_tmp29_ = string_substring ((const gchar*) _tmp26_, (glong) 0, (glong) ((gint) (_tmp27_ - _tmp28_)));
					_tmp30_ = _tmp29_;
					g_string_append (_tmp25_, _tmp30_);
					_g_free0 (_tmp30_);
					_tmp31_ = content;
					g_string_append_c (_tmp31_, '&');
					_tmp32_ = self->priv->current;
					self->priv->current = _tmp32_ + 5;
					_tmp33_ = self->priv->current;
					text_begin = _tmp33_;
				} else {
					gchar* _tmp34_;
					gboolean _tmp35_;
					_tmp34_ = next_pos;
					_tmp35_ = g_str_has_prefix ((const gchar*) _tmp34_, "quot;");
					if (_tmp35_) {
						GString* _tmp36_;
						gchar* _tmp37_;
						gchar* _tmp38_;
						gchar* _tmp39_;
						gchar* _tmp40_;
						gchar* _tmp41_;
						GString* _tmp42_;
						gchar* _tmp43_;
						gchar* _tmp44_;
						_tmp36_ = content;
						_tmp37_ = text_begin;
						_tmp38_ = self->priv->current;
						_tmp39_ = text_begin;
						_tmp40_ = string_substring ((const gchar*) _tmp37_, (glong) 0, (glong) ((gint) (_tmp38_ - _tmp39_)));
						_tmp41_ = _tmp40_;
						g_string_append (_tmp36_, _tmp41_);
						_g_free0 (_tmp41_);
						_tmp42_ = content;
						g_string_append_c (_tmp42_, '"');
						_tmp43_ = self->priv->current;
						self->priv->current = _tmp43_ + 6;
						_tmp44_ = self->priv->current;
						text_begin = _tmp44_;
					} else {
						gchar* _tmp45_;
						gboolean _tmp46_;
						_tmp45_ = next_pos;
						_tmp46_ = g_str_has_prefix ((const gchar*) _tmp45_, "apos;");
						if (_tmp46_) {
							GString* _tmp47_;
							gchar* _tmp48_;
							gchar* _tmp49_;
							gchar* _tmp50_;
							gchar* _tmp51_;
							gchar* _tmp52_;
							GString* _tmp53_;
							gchar* _tmp54_;
							gchar* _tmp55_;
							_tmp47_ = content;
							_tmp48_ = text_begin;
							_tmp49_ = self->priv->current;
							_tmp50_ = text_begin;
							_tmp51_ = string_substring ((const gchar*) _tmp48_, (glong) 0, (glong) ((gint) (_tmp49_ - _tmp50_)));
							_tmp52_ = _tmp51_;
							g_string_append (_tmp47_, _tmp52_);
							_g_free0 (_tmp52_);
							_tmp53_ = content;
							g_string_append_c (_tmp53_, '\'');
							_tmp54_ = self->priv->current;
							self->priv->current = _tmp54_ + 6;
							_tmp55_ = self->priv->current;
							text_begin = _tmp55_;
						} else {
							gchar* _tmp56_;
							gboolean _tmp57_;
							_tmp56_ = next_pos;
							_tmp57_ = g_str_has_prefix ((const gchar*) _tmp56_, "lt;");
							if (_tmp57_) {
								GString* _tmp58_;
								gchar* _tmp59_;
								gchar* _tmp60_;
								gchar* _tmp61_;
								gchar* _tmp62_;
								gchar* _tmp63_;
								GString* _tmp64_;
								gchar* _tmp65_;
								gchar* _tmp66_;
								_tmp58_ = content;
								_tmp59_ = text_begin;
								_tmp60_ = self->priv->current;
								_tmp61_ = text_begin;
								_tmp62_ = string_substring ((const gchar*) _tmp59_, (glong) 0, (glong) ((gint) (_tmp60_ - _tmp61_)));
								_tmp63_ = _tmp62_;
								g_string_append (_tmp58_, _tmp63_);
								_g_free0 (_tmp63_);
								_tmp64_ = content;
								g_string_append_c (_tmp64_, '<');
								_tmp65_ = self->priv->current;
								self->priv->current = _tmp65_ + 4;
								_tmp66_ = self->priv->current;
								text_begin = _tmp66_;
							} else {
								gchar* _tmp67_;
								gboolean _tmp68_;
								_tmp67_ = next_pos;
								_tmp68_ = g_str_has_prefix ((const gchar*) _tmp67_, "gt;");
								if (_tmp68_) {
									GString* _tmp69_;
									gchar* _tmp70_;
									gchar* _tmp71_;
									gchar* _tmp72_;
									gchar* _tmp73_;
									gchar* _tmp74_;
									GString* _tmp75_;
									gchar* _tmp76_;
									gchar* _tmp77_;
									_tmp69_ = content;
									_tmp70_ = text_begin;
									_tmp71_ = self->priv->current;
									_tmp72_ = text_begin;
									_tmp73_ = string_substring ((const gchar*) _tmp70_, (glong) 0, (glong) ((gint) (_tmp71_ - _tmp72_)));
									_tmp74_ = _tmp73_;
									g_string_append (_tmp69_, _tmp74_);
									_g_free0 (_tmp74_);
									_tmp75_ = content;
									g_string_append_c (_tmp75_, '>');
									_tmp76_ = self->priv->current;
									self->priv->current = _tmp76_ + 4;
									_tmp77_ = self->priv->current;
									text_begin = _tmp77_;
								} else {
									gchar* _tmp78_;
									gboolean _tmp79_;
									_tmp78_ = next_pos;
									_tmp79_ = g_str_has_prefix ((const gchar*) _tmp78_, "percnt;");
									if (_tmp79_) {
										GString* _tmp80_;
										gchar* _tmp81_;
										gchar* _tmp82_;
										gchar* _tmp83_;
										gchar* _tmp84_;
										gchar* _tmp85_;
										GString* _tmp86_;
										gchar* _tmp87_;
										gchar* _tmp88_;
										_tmp80_ = content;
										_tmp81_ = text_begin;
										_tmp82_ = self->priv->current;
										_tmp83_ = text_begin;
										_tmp84_ = string_substring ((const gchar*) _tmp81_, (glong) 0, (glong) ((gint) (_tmp82_ - _tmp83_)));
										_tmp85_ = _tmp84_;
										g_string_append (_tmp80_, _tmp85_);
										_g_free0 (_tmp85_);
										_tmp86_ = content;
										g_string_append_c (_tmp86_, '>');
										_tmp87_ = self->priv->current;
										self->priv->current = _tmp87_ + 8;
										_tmp88_ = self->priv->current;
										text_begin = _tmp88_;
									} else {
										gchar* _tmp89_;
										gunichar _tmp90_;
										gint _tmp91_;
										_tmp89_ = self->priv->current;
										_tmp90_ = u;
										_tmp91_ = g_unichar_to_utf8 (_tmp90_, NULL);
										self->priv->current = _tmp89_ + _tmp91_;
									}
								}
							}
						}
					}
				}
			} else {
				gunichar _tmp92_;
				gchar* _tmp95_;
				gunichar _tmp96_;
				gint _tmp97_;
				gint _tmp98_;
				_tmp92_ = u;
				if (_tmp92_ == ((gunichar) '\n')) {
					gint _tmp93_;
					gchar* _tmp94_;
					_tmp93_ = self->priv->line;
					self->priv->line = _tmp93_ + 1;
					self->priv->column = 0;
					_tmp94_ = self->priv->current;
					last_linebreak = _tmp94_;
				}
				_tmp95_ = self->priv->current;
				_tmp96_ = u;
				_tmp97_ = g_unichar_to_utf8 (_tmp96_, NULL);
				self->priv->current = _tmp95_ + _tmp97_;
				_tmp98_ = self->priv->column;
				self->priv->column = _tmp98_ + 1;
			}
		}
	}
	_tmp99_ = text_begin;
	_tmp100_ = self->priv->current;
	if (_tmp99_ != _tmp100_) {
		GString* _tmp101_;
		gchar* _tmp102_;
		gchar* _tmp103_;
		gchar* _tmp104_;
		gchar* _tmp105_;
		gchar* _tmp106_;
		_tmp101_ = content;
		_tmp102_ = text_begin;
		_tmp103_ = self->priv->current;
		_tmp104_ = text_begin;
		_tmp105_ = string_substring ((const gchar*) _tmp102_, (glong) 0, (glong) ((gint) (_tmp103_ - _tmp104_)));
		_tmp106_ = _tmp105_;
		g_string_append (_tmp101_, _tmp106_);
		_g_free0 (_tmp106_);
	}
	_tmp107_ = self->priv->column;
	_tmp108_ = self->priv->current;
	_tmp109_ = last_linebreak;
	self->priv->column = _tmp107_ + ((gint) (_tmp108_ - _tmp109_));
	_tmp110_ = rm_trailing_whitespace;
	if (_tmp110_) {
		gchar* str_pos = NULL;
		GString* _tmp111_;
		const gchar* _tmp112_;
		GString* _tmp113_;
		gssize _tmp114_;
		GString* _tmp125_;
		gchar* _tmp126_;
		GString* _tmp127_;
		const gchar* _tmp128_;
		_tmp111_ = content;
		_tmp112_ = _tmp111_->str;
		_tmp113_ = content;
		_tmp114_ = _tmp113_->len;
		str_pos = ((gchar*) _tmp112_) + _tmp114_;
		{
			gchar* _tmp115_;
			gboolean _tmp116_ = FALSE;
			_tmp115_ = str_pos;
			str_pos = _tmp115_ - 1;
			_tmp116_ = TRUE;
			while (TRUE) {
				gboolean _tmp118_ = FALSE;
				gchar* _tmp119_;
				GString* _tmp120_;
				const gchar* _tmp121_;
				if (!_tmp116_) {
					gchar* _tmp117_;
					_tmp117_ = str_pos;
					str_pos = _tmp117_ - 1;
				}
				_tmp116_ = FALSE;
				_tmp119_ = str_pos;
				_tmp120_ = content;
				_tmp121_ = _tmp120_->str;
				if (_tmp119_ > ((gchar*) _tmp121_)) {
					gchar* _tmp122_;
					gchar _tmp123_;
					gboolean _tmp124_;
					_tmp122_ = str_pos;
					_tmp123_ = _tmp122_[0];
					_tmp124_ = g_ascii_isspace (_tmp123_);
					_tmp118_ = _tmp124_;
				} else {
					_tmp118_ = FALSE;
				}
				if (!_tmp118_) {
					break;
				}
			}
		}
		_tmp125_ = content;
		_tmp126_ = str_pos;
		_tmp127_ = content;
		_tmp128_ = _tmp127_->str;
		g_string_erase (_tmp125_, (gssize) ((_tmp126_ - ((gchar*) _tmp128_)) + 1), (gssize) -1);
	}
	_tmp129_ = content;
	_tmp130_ = _tmp129_->str;
	_tmp131_ = g_strdup (_tmp130_);
	result = _tmp131_;
	_g_string_free0 (content);
	return result;
}


static void valadoc_markup_reader_space (ValadocMarkupReader* self) {
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp6_;
		gchar _tmp7_;
		gchar* _tmp9_;
		gint _tmp10_;
		_tmp1_ = self->priv->current;
		_tmp2_ = self->priv->end;
		if (_tmp1_ < _tmp2_) {
			gchar* _tmp3_;
			gchar _tmp4_;
			gboolean _tmp5_;
			_tmp3_ = self->priv->current;
			_tmp4_ = _tmp3_[0];
			_tmp5_ = g_ascii_isspace (_tmp4_);
			_tmp0_ = _tmp5_;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp6_ = self->priv->current;
		_tmp7_ = _tmp6_[0];
		if (_tmp7_ == '\n') {
			gint _tmp8_;
			_tmp8_ = self->priv->line;
			self->priv->line = _tmp8_ + 1;
			self->priv->column = 0;
		}
		_tmp9_ = self->priv->current;
		self->priv->current = _tmp9_ + 1;
		_tmp10_ = self->priv->column;
		self->priv->column = _tmp10_ + 1;
	}
}


const gchar* valadoc_markup_reader_get_filename (ValadocMarkupReader* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_filename;
	result = _tmp0_;
	return result;
}


static void valadoc_markup_reader_set_filename (ValadocMarkupReader* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, valadoc_markup_reader_get_filename (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_filename);
		self->priv->_filename = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_markup_reader_properties[VALADOC_MARKUP_READER_FILENAME_PROPERTY]);
	}
}


const gchar* valadoc_markup_reader_get_name (ValadocMarkupReader* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


static void valadoc_markup_reader_set_name (ValadocMarkupReader* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, valadoc_markup_reader_get_name (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_markup_reader_properties[VALADOC_MARKUP_READER_NAME_PROPERTY]);
	}
}


const gchar* valadoc_markup_reader_get_content (ValadocMarkupReader* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_content;
	result = _tmp0_;
	return result;
}


static void valadoc_markup_reader_set_content (ValadocMarkupReader* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, valadoc_markup_reader_get_content (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_content);
		self->priv->_content = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_markup_reader_properties[VALADOC_MARKUP_READER_CONTENT_PROPERTY]);
	}
}


static void valadoc_markup_reader_class_init (ValadocMarkupReaderClass * klass) {
	valadoc_markup_reader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValadocMarkupReaderPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_valadoc_markup_reader_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_valadoc_markup_reader_set_property;
	G_OBJECT_CLASS (klass)->finalize = valadoc_markup_reader_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_MARKUP_READER_FILENAME_PROPERTY, valadoc_markup_reader_properties[VALADOC_MARKUP_READER_FILENAME_PROPERTY] = g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_MARKUP_READER_NAME_PROPERTY, valadoc_markup_reader_properties[VALADOC_MARKUP_READER_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_MARKUP_READER_CONTENT_PROPERTY, valadoc_markup_reader_properties[VALADOC_MARKUP_READER_CONTENT_PROPERTY] = g_param_spec_string ("content", "content", "content", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void valadoc_markup_reader_instance_init (ValadocMarkupReader * self) {
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	self->priv = VALADOC_MARKUP_READER_GET_PRIVATE (self);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp0_, _tmp1_, _tmp2_);
	self->priv->attributes = (ValaMap*) _tmp3_;
}


static void valadoc_markup_reader_finalize (GObject * obj) {
	ValadocMarkupReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_TYPE_MARKUP_READER, ValadocMarkupReader);
	_g_free0 (self->priv->_filename);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_content);
	_g_mapped_file_unref0 (self->priv->mapped_file);
	self->priv->lines = (_vala_array_free (self->priv->lines, self->priv->lines_length1, (GDestroyNotify) g_free), NULL);
	_vala_map_unref0 (self->priv->attributes);
	_g_object_unref0 (self->priv->reporter);
	G_OBJECT_CLASS (valadoc_markup_reader_parent_class)->finalize (obj);
}


/**
 * Simple reader for a subset of XML.
 */
GType valadoc_markup_reader_get_type (void) {
	static volatile gsize valadoc_markup_reader_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_markup_reader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValadocMarkupReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_markup_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocMarkupReader), 0, (GInstanceInitFunc) valadoc_markup_reader_instance_init, NULL };
		GType valadoc_markup_reader_type_id;
		valadoc_markup_reader_type_id = g_type_register_static (G_TYPE_OBJECT, "ValadocMarkupReader", &g_define_type_info, 0);
		g_once_init_leave (&valadoc_markup_reader_type_id__volatile, valadoc_markup_reader_type_id);
	}
	return valadoc_markup_reader_type_id__volatile;
}


static void _vala_valadoc_markup_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValadocMarkupReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_TYPE_MARKUP_READER, ValadocMarkupReader);
	switch (property_id) {
		case VALADOC_MARKUP_READER_FILENAME_PROPERTY:
		g_value_set_string (value, valadoc_markup_reader_get_filename (self));
		break;
		case VALADOC_MARKUP_READER_NAME_PROPERTY:
		g_value_set_string (value, valadoc_markup_reader_get_name (self));
		break;
		case VALADOC_MARKUP_READER_CONTENT_PROPERTY:
		g_value_set_string (value, valadoc_markup_reader_get_content (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_valadoc_markup_reader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValadocMarkupReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_TYPE_MARKUP_READER, ValadocMarkupReader);
	switch (property_id) {
		case VALADOC_MARKUP_READER_FILENAME_PROPERTY:
		valadoc_markup_reader_set_filename (self, g_value_get_string (value));
		break;
		case VALADOC_MARKUP_READER_NAME_PROPERTY:
		valadoc_markup_reader_set_name (self, g_value_get_string (value));
		break;
		case VALADOC_MARKUP_READER_CONTENT_PROPERTY:
		valadoc_markup_reader_set_content (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



