/* ctyperesolver.c generated by valac, the Vala compiler
 * generated from ctyperesolver.vala, do not modify */

/* ctyperesolver.vala
 *
 * Copyright (C) 2010 Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include "valadoc.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

enum  {
	VALADOC_CTYPE_RESOLVER_0_PROPERTY,
	VALADOC_CTYPE_RESOLVER_NUM_PROPERTIES
};
static GParamSpec* valadoc_ctype_resolver_properties[VALADOC_CTYPE_RESOLVER_NUM_PROPERTIES];
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _valadoc_api_tree_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_api_tree_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValadocCTypeResolverPrivate {
	ValaMap* types;
	ValaMap* nodes;
	ValadocApiTree* tree;
};


static gpointer valadoc_ctype_resolver_parent_class = NULL;

#define VALADOC_CTYPE_RESOLVER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALADOC_TYPE_CTYPE_RESOLVER, ValadocCTypeResolverPrivate))
static gchar* valadoc_ctype_resolver_convert_array_to_camelcase (ValadocCTypeResolver* self, gchar** elements, int elements_length1);
static gboolean valadoc_ctype_resolver_is_capitalized_and_underscored (ValadocCTypeResolver* self, const gchar* name);
static gchar* valadoc_ctype_resolver_translate_cname_to_g (ValadocCTypeResolver* self, const gchar* name);
static gchar** _vala_array_dup1 (gchar** self, int length);
static void valadoc_ctype_resolver_register_symbol_type (ValadocCTypeResolver* self, const gchar* name, ValadocApiTypeSymbol* symbol);
static void valadoc_ctype_resolver_register_symbol (ValadocCTypeResolver* self, const gchar* name, ValadocApiNode* node);
static gchar* valadoc_ctype_resolver_get_parent_type_cname (ValadocCTypeResolver* self, ValadocApiItem* item);
static void valadoc_ctype_resolver_real_visit_tree (ValadocApiVisitor* base, ValadocApiTree* item);
static void valadoc_ctype_resolver_real_visit_package (ValadocApiVisitor* base, ValadocApiPackage* item);
static void valadoc_ctype_resolver_real_visit_namespace (ValadocApiVisitor* base, ValadocApiNamespace* item);
static void valadoc_ctype_resolver_real_visit_interface (ValadocApiVisitor* base, ValadocApiInterface* item);
static void valadoc_ctype_resolver_real_visit_class (ValadocApiVisitor* base, ValadocApiClass* item);
static void valadoc_ctype_resolver_real_visit_struct (ValadocApiVisitor* base, ValadocApiStruct* item);
static void valadoc_ctype_resolver_real_visit_property (ValadocApiVisitor* base, ValadocApiProperty* item);
static void valadoc_ctype_resolver_real_visit_field (ValadocApiVisitor* base, ValadocApiField* item);
static void valadoc_ctype_resolver_real_visit_constant (ValadocApiVisitor* base, ValadocApiConstant* item);
static void valadoc_ctype_resolver_real_visit_delegate (ValadocApiVisitor* base, ValadocApiDelegate* item);
static void valadoc_ctype_resolver_real_visit_signal (ValadocApiVisitor* base, ValadocApiSignal* item);
static void valadoc_ctype_resolver_real_visit_method (ValadocApiVisitor* base, ValadocApiMethod* item);
static void valadoc_ctype_resolver_real_visit_error_domain (ValadocApiVisitor* base, ValadocApiErrorDomain* item);
static void valadoc_ctype_resolver_real_visit_error_code (ValadocApiVisitor* base, ValadocApiErrorCode* item);
static void valadoc_ctype_resolver_real_visit_enum (ValadocApiVisitor* base, ValadocApiEnum* item);
static void valadoc_ctype_resolver_real_visit_enum_value (ValadocApiVisitor* base, ValadocApiEnumValue* item);
static void valadoc_ctype_resolver_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _valadoc_api_tree_ref0 (gpointer self) {
	return self ? valadoc_api_tree_ref (self) : NULL;
}


ValadocCTypeResolver* valadoc_ctype_resolver_construct (GType object_type, ValadocApiTree* tree) {
	ValadocCTypeResolver * self = NULL;
	ValadocApiTree* _tmp0_;
	ValadocApiTree* _tmp1_;
	ValadocApiTree* _tmp2_;
	g_return_val_if_fail (tree != NULL, NULL);
	self = (ValadocCTypeResolver*) valadoc_api_visitor_construct (object_type);
	_tmp0_ = tree;
	valadoc_api_tree_accept (_tmp0_, (ValadocApiVisitor*) self);
	_tmp1_ = tree;
	_tmp2_ = _valadoc_api_tree_ref0 (_tmp1_);
	_valadoc_api_tree_unref0 (self->priv->tree);
	self->priv->tree = _tmp2_;
	return self;
}


ValadocCTypeResolver* valadoc_ctype_resolver_new (ValadocApiTree* tree) {
	return valadoc_ctype_resolver_construct (VALADOC_TYPE_CTYPE_RESOLVER, tree);
}


static gchar* valadoc_ctype_resolver_convert_array_to_camelcase (ValadocCTypeResolver* self, gchar** elements, int elements_length1) {
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	GString* _tmp12_;
	gchar* _tmp13_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = elements;
	_tmp1__length1 = elements_length1;
	{
		gchar** element_collection = NULL;
		gint element_collection_length1 = 0;
		gint _element_collection_size_ = 0;
		gint element_it = 0;
		element_collection = _tmp1_;
		element_collection_length1 = _tmp1__length1;
		for (element_it = 0; element_it < _tmp1__length1; element_it = element_it + 1) {
			gchar* _tmp2_;
			gchar* element = NULL;
			_tmp2_ = g_strdup (element_collection[element_it]);
			element = _tmp2_;
			{
				GString* _tmp3_;
				const gchar* _tmp4_;
				gchar _tmp5_;
				gchar _tmp6_;
				GString* _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp3_ = builder;
				_tmp4_ = element;
				_tmp5_ = ((gchar*) _tmp4_)[0];
				_tmp6_ = g_ascii_toupper (_tmp5_);
				g_string_append_c (_tmp3_, _tmp6_);
				_tmp7_ = builder;
				_tmp8_ = element;
				_tmp9_ = g_utf8_next_char (_tmp8_);
				_tmp10_ = g_utf8_strdown (_tmp9_, (gssize) -1);
				_tmp11_ = _tmp10_;
				g_string_append (_tmp7_, _tmp11_);
				_g_free0 (_tmp11_);
				_g_free0 (element);
			}
		}
	}
	_tmp12_ = builder;
	_tmp13_ = _tmp12_->str;
	_tmp12_->str = NULL;
	result = _tmp13_;
	_g_string_free0 (builder);
	return result;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_;
	gunichar _tmp1_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


static gboolean valadoc_ctype_resolver_is_capitalized_and_underscored (ValadocCTypeResolver* self, const gchar* name) {
	gboolean result = FALSE;
	const gchar* pos = NULL;
	gunichar c = 0U;
	const gchar* _tmp0_;
	gunichar _tmp1_;
	gboolean _tmp2_ = FALSE;
	gunichar _tmp3_;
	gboolean last_was_underscore = FALSE;
	gboolean _tmp24_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = name;
	_tmp1_ = string_get_char (_tmp0_, (glong) 0);
	c = _tmp1_;
	_tmp3_ = c;
	if (_tmp3_ < ((gunichar) 'A')) {
		_tmp2_ = TRUE;
	} else {
		gunichar _tmp4_;
		_tmp4_ = c;
		_tmp2_ = _tmp4_ > ((gunichar) 'Z');
	}
	if (_tmp2_) {
		result = FALSE;
		return result;
	}
	last_was_underscore = FALSE;
	{
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gunichar _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = name;
		pos = _tmp5_;
		_tmp6_ = pos;
		_tmp7_ = string_get_char (_tmp6_, (glong) 0);
		c = _tmp7_;
		_tmp8_ = TRUE;
		while (TRUE) {
			gunichar _tmp13_;
			gboolean _tmp14_ = FALSE;
			gboolean _tmp15_ = FALSE;
			gunichar _tmp16_;
			gunichar _tmp23_;
			if (!_tmp8_) {
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				gunichar _tmp12_;
				_tmp9_ = pos;
				_tmp10_ = g_utf8_next_char (_tmp9_);
				pos = _tmp10_;
				_tmp11_ = pos;
				_tmp12_ = string_get_char (_tmp11_, (glong) 0);
				c = _tmp12_;
			}
			_tmp8_ = FALSE;
			_tmp13_ = c;
			if (!(_tmp13_ != ((gunichar) '\0'))) {
				break;
			}
			_tmp16_ = c;
			if (_tmp16_ != ((gunichar) '_')) {
				gboolean _tmp17_ = FALSE;
				gunichar _tmp18_;
				_tmp18_ = c;
				if (_tmp18_ >= ((gunichar) 'A')) {
					gunichar _tmp19_;
					_tmp19_ = c;
					_tmp17_ = _tmp19_ <= ((gunichar) 'Z');
				} else {
					_tmp17_ = FALSE;
				}
				_tmp15_ = !_tmp17_;
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				_tmp14_ = TRUE;
			} else {
				gboolean _tmp20_ = FALSE;
				gboolean _tmp21_;
				_tmp21_ = last_was_underscore;
				if (_tmp21_) {
					gunichar _tmp22_;
					_tmp22_ = c;
					_tmp20_ = _tmp22_ == ((gunichar) '_');
				} else {
					_tmp20_ = FALSE;
				}
				_tmp14_ = _tmp20_;
			}
			if (_tmp14_) {
				result = FALSE;
				return result;
			}
			_tmp23_ = c;
			last_was_underscore = _tmp23_ == ((gunichar) '_');
		}
	}
	_tmp24_ = last_was_underscore;
	result = !_tmp24_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gchar* valadoc_ctype_resolver_translate_cname_to_g (ValadocCTypeResolver* self, const gchar* name) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	gint length = 0;
	const gchar* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gboolean _tmp14_ = FALSE;
	gint _tmp15_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = valadoc_ctype_resolver_is_capitalized_and_underscored (self, _tmp0_);
	if (_tmp1_) {
		gchar** segments = NULL;
		const gchar* _tmp2_;
		gchar** _tmp3_;
		gchar** _tmp4_;
		gint segments_length1;
		gint _segments_size_;
		const gchar* last_segment = NULL;
		gchar** _tmp5_;
		gint _tmp5__length1;
		gchar** _tmp6_;
		gint _tmp6__length1;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar** _tmp9_;
		gint _tmp9__length1;
		gchar* _tmp10_;
		_tmp2_ = name;
		_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, "_", 0);
		segments = _tmp4_;
		segments_length1 = _vala_array_length (_tmp3_);
		_segments_size_ = segments_length1;
		_tmp5_ = segments;
		_tmp5__length1 = segments_length1;
		_tmp6_ = segments;
		_tmp6__length1 = segments_length1;
		_tmp7_ = _tmp5_[_tmp6__length1 - 1];
		last_segment = _tmp7_;
		_tmp8_ = last_segment;
		if (g_strcmp0 (_tmp8_, "ERROR") != 0) {
			result = NULL;
			segments = (_vala_array_free (segments, segments_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		_tmp9_ = segments;
		_tmp9__length1 = segments_length1;
		_tmp10_ = valadoc_ctype_resolver_convert_array_to_camelcase (self, _tmp9_, _tmp9__length1);
		result = _tmp10_;
		segments = (_vala_array_free (segments, segments_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp11_ = name;
	_tmp12_ = strlen (_tmp11_);
	_tmp13_ = _tmp12_;
	length = _tmp13_;
	_tmp15_ = length;
	if (_tmp15_ > 5) {
		const gchar* _tmp16_;
		gboolean _tmp17_;
		_tmp16_ = name;
		_tmp17_ = g_str_has_suffix (_tmp16_, "Iface");
		_tmp14_ = _tmp17_;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		const gchar* _tmp18_;
		gint _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = name;
		_tmp19_ = length;
		_tmp20_ = string_substring (_tmp18_, (glong) 0, (glong) (_tmp19_ - 5));
		result = _tmp20_;
		return result;
	} else {
		gboolean _tmp21_ = FALSE;
		gint _tmp22_;
		_tmp22_ = length;
		if (_tmp22_ > 5) {
			const gchar* _tmp23_;
			gboolean _tmp24_;
			_tmp23_ = name;
			_tmp24_ = g_str_has_suffix (_tmp23_, "Class");
			_tmp21_ = _tmp24_;
		} else {
			_tmp21_ = FALSE;
		}
		if (_tmp21_) {
			const gchar* _tmp25_;
			gint _tmp26_;
			gchar* _tmp27_;
			_tmp25_ = name;
			_tmp26_ = length;
			_tmp27_ = string_substring (_tmp25_, (glong) 0, (glong) (_tmp26_ - 5));
			result = _tmp27_;
			return result;
		}
	}
	result = NULL;
	return result;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


ValadocApiTypeSymbol* valadoc_ctype_resolver_resolve_symbol_type (ValadocCTypeResolver* self, const gchar* name) {
	ValadocApiTypeSymbol* result = NULL;
	ValadocApiTypeSymbol* symbol = NULL;
	ValaMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_;
	ValadocApiTypeSymbol* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->types;
	_tmp1_ = name;
	_tmp2_ = vala_map_get (_tmp0_, _tmp1_);
	symbol = (ValadocApiTypeSymbol*) _tmp2_;
	_tmp3_ = symbol;
	if (_tmp3_ != NULL) {
		result = symbol;
		return result;
	}
	_tmp4_ = name;
	_tmp5_ = valadoc_ctype_resolver_is_capitalized_and_underscored (self, _tmp4_);
	if (_tmp5_) {
		gchar** segments = NULL;
		const gchar* _tmp6_;
		gchar** _tmp7_;
		gchar** _tmp8_;
		gint segments_length1;
		gint _segments_size_;
		gchar** _tmp9_;
		gint _tmp9__length1;
		gchar** _tmp10_;
		gint _tmp10__length1;
		const gchar* _tmp11_;
		_tmp6_ = name;
		_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "_", 0);
		segments = _tmp8_;
		segments_length1 = _vala_array_length (_tmp7_);
		_segments_size_ = segments_length1;
		_tmp9_ = segments;
		_tmp9__length1 = segments_length1;
		_tmp10_ = segments;
		_tmp10__length1 = segments_length1;
		_tmp11_ = _tmp9_[_tmp10__length1 - 1];
		if (g_strcmp0 (_tmp11_, "TYPE") == 0) {
			gchar** _tmp12_;
			gint _tmp12__length1;
			gint _tmp13_;
			ValaMap* _tmp14_;
			gchar** _tmp15_;
			gint _tmp15__length1;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gpointer _tmp18_;
			ValadocApiTypeSymbol* _tmp19_;
			_tmp12_ = segments;
			_tmp12__length1 = segments_length1;
			_tmp13_ = _tmp12__length1 - 1;
			segments = g_renew (gchar*, segments, _tmp12__length1 - 1);
			(_tmp13_ > segments_length1) ? memset (segments + segments_length1, 0, sizeof (gchar*) * (_tmp13_ - segments_length1)) : NULL;
			segments_length1 = _tmp13_;
			_segments_size_ = _tmp13_;
			_tmp14_ = self->priv->types;
			_tmp15_ = segments;
			_tmp15__length1 = segments_length1;
			_tmp16_ = valadoc_ctype_resolver_convert_array_to_camelcase (self, _tmp15_, _tmp15__length1);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_map_get (_tmp14_, _tmp17_);
			_tmp19_ = (ValadocApiTypeSymbol*) _tmp18_;
			_g_free0 (_tmp17_);
			result = _tmp19_;
			segments = (_vala_array_free (segments, segments_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (symbol);
			return result;
		} else {
			gboolean _tmp20_ = FALSE;
			gchar** _tmp21_;
			gint _tmp21__length1;
			_tmp21_ = segments;
			_tmp21__length1 = segments_length1;
			if (_tmp21__length1 > 2) {
				gchar** _tmp22_;
				gint _tmp22__length1;
				const gchar* _tmp23_;
				_tmp22_ = segments;
				_tmp22__length1 = segments_length1;
				_tmp23_ = _tmp22_[1];
				_tmp20_ = g_strcmp0 (_tmp23_, "TYPE") == 0;
			} else {
				_tmp20_ = FALSE;
			}
			if (_tmp20_) {
				gchar** _segments = NULL;
				gchar** _tmp24_;
				gint _tmp24__length1;
				gchar** _tmp25_;
				gint _tmp25__length1;
				gchar** _tmp26_;
				gint _tmp26__length1;
				gint _segments_length1;
				gint __segments_size_;
				gchar** _tmp27_;
				gint _tmp27__length1;
				gchar** _tmp28_;
				gint _tmp28__length1;
				const gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				ValaMap* _tmp32_;
				gchar** _tmp33_;
				gint _tmp33__length1;
				gchar* _tmp34_;
				gchar* _tmp35_;
				gpointer _tmp36_;
				ValadocApiTypeSymbol* _tmp37_;
				_tmp24_ = segments;
				_tmp24__length1 = segments_length1;
				_tmp25_ = segments;
				_tmp25__length1 = segments_length1;
				_tmp26_ = ((_tmp24_ + 1) != NULL) ? _vala_array_dup1 (_tmp24_ + 1, _tmp25__length1 - 1) : ((gpointer) (_tmp24_ + 1));
				_tmp26__length1 = _tmp25__length1 - 1;
				_segments = _tmp26_;
				_segments_length1 = _tmp26__length1;
				__segments_size_ = _segments_length1;
				_tmp27_ = _segments;
				_tmp27__length1 = _segments_length1;
				_tmp28_ = segments;
				_tmp28__length1 = segments_length1;
				_tmp29_ = _tmp28_[0];
				_tmp30_ = g_strdup (_tmp29_);
				_g_free0 (_tmp27_[0]);
				_tmp27_[0] = _tmp30_;
				_tmp31_ = _tmp27_[0];
				_tmp32_ = self->priv->types;
				_tmp33_ = _segments;
				_tmp33__length1 = _segments_length1;
				_tmp34_ = valadoc_ctype_resolver_convert_array_to_camelcase (self, _tmp33_, _tmp33__length1);
				_tmp35_ = _tmp34_;
				_tmp36_ = vala_map_get (_tmp32_, _tmp35_);
				_tmp37_ = (ValadocApiTypeSymbol*) _tmp36_;
				_g_free0 (_tmp35_);
				result = _tmp37_;
				_segments = (_vala_array_free (_segments, _segments_length1, (GDestroyNotify) g_free), NULL);
				segments = (_vala_array_free (segments, segments_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (symbol);
				return result;
			}
		}
		segments = (_vala_array_free (segments, segments_length1, (GDestroyNotify) g_free), NULL);
	}
	result = NULL;
	_g_object_unref0 (symbol);
	return result;
}


/**
 * Resolves symbols by C-names
 *
 * @param _name a C-name
 * @return the resolved node or null
 */
static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = old;
		_tmp1_ = (*((gchar*) _tmp2_)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = old;
		_tmp4_ = replacement;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (self);
		result = _tmp5_;
		return result;
	}
	{
		GRegex* regex = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		gchar* _tmp11_ = NULL;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = old;
		_tmp7_ = g_regex_escape_string (_tmp6_, -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		regex = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch3_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp12_ = regex;
		_tmp13_ = replacement;
		_tmp14_ = g_regex_replace_literal (_tmp12_, self, (gssize) -1, 0, _tmp13_, 0, &_inner_error_);
		_tmp11_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch3_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp15_ = _tmp11_;
		_tmp11_ = NULL;
		result = _tmp15_;
		_g_free0 (_tmp11_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally3;
	__catch3_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


ValadocApiNode* valadoc_ctype_resolver_resolve_symbol (ValadocCTypeResolver* self, ValadocApiNode* element, const gchar* _name) {
	ValadocApiNode* result = NULL;
	gchar* name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValadocApiNode* _tmp6_;
	ValadocApiNode* node = NULL;
	ValaMap* _tmp40_;
	const gchar* _tmp41_;
	gpointer _tmp42_;
	ValadocApiNode* _tmp43_;
	gchar* alternative = NULL;
	const gchar* _tmp44_;
	gchar* _tmp45_;
	const gchar* _tmp46_;
	gboolean _tmp50_ = FALSE;
	ValadocApiNode* _tmp51_;
	const gchar* _tmp86_;
	gint dotpos = 0;
	const gchar* _tmp92_;
	gint _tmp93_;
	gint _tmp94_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (_name != NULL, NULL);
	_tmp0_ = _name;
	_tmp1_ = string_replace (_tmp0_, "->", ".");
	_tmp2_ = _tmp1_;
	_tmp3_ = string_replace (_tmp2_, "-", "_");
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	name = _tmp4_;
	_tmp6_ = element;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		gboolean _tmp8_;
		_tmp7_ = name;
		_tmp8_ = g_str_has_prefix (_tmp7_, ":");
		_tmp5_ = _tmp8_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValadocApiItem* parent = NULL;
		ValadocApiNode* _tmp9_;
		ValadocApiItem* _tmp10_;
		gboolean _tmp20_ = FALSE;
		ValadocApiItem* _tmp21_;
		_tmp9_ = element;
		_tmp10_ = _g_object_ref0 ((ValadocApiItem*) _tmp9_);
		parent = _tmp10_;
		while (TRUE) {
			gboolean _tmp11_ = FALSE;
			ValadocApiItem* _tmp12_;
			ValadocApiItem* _tmp16_;
			ValadocApiItem* _tmp17_;
			ValadocApiItem* _tmp18_;
			ValadocApiItem* _tmp19_;
			_tmp12_ = parent;
			if (_tmp12_ != NULL) {
				gboolean _tmp13_ = FALSE;
				ValadocApiItem* _tmp14_;
				_tmp14_ = parent;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALADOC_API_TYPE_CLASS)) {
					_tmp13_ = TRUE;
				} else {
					ValadocApiItem* _tmp15_;
					_tmp15_ = parent;
					_tmp13_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, VALADOC_API_TYPE_INTERFACE);
				}
				_tmp11_ = !_tmp13_;
			} else {
				_tmp11_ = FALSE;
			}
			if (!_tmp11_) {
				break;
			}
			_tmp16_ = parent;
			_tmp17_ = valadoc_api_item_get_parent (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = _g_object_ref0 (_tmp18_);
			_g_object_unref0 (parent);
			parent = _tmp19_;
		}
		_tmp21_ = parent;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, VALADOC_API_TYPE_CLASS)) {
			ValadocApiItem* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			_tmp22_ = parent;
			_tmp23_ = valadoc_api_class_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, VALADOC_API_TYPE_CLASS, ValadocApiClass));
			_tmp24_ = _tmp23_;
			_tmp20_ = _tmp24_ != NULL;
			_g_free0 (_tmp24_);
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			ValadocApiItem* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			const gchar* _tmp28_;
			gchar* _tmp29_;
			_tmp25_ = parent;
			_tmp26_ = valadoc_api_class_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, VALADOC_API_TYPE_CLASS, ValadocApiClass));
			_tmp27_ = _tmp26_;
			_tmp28_ = name;
			_tmp29_ = g_strconcat (_tmp27_, _tmp28_, NULL);
			_g_free0 (name);
			name = _tmp29_;
			_g_free0 (_tmp27_);
		} else {
			gboolean _tmp30_ = FALSE;
			ValadocApiItem* _tmp31_;
			_tmp31_ = parent;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, VALADOC_API_TYPE_INTERFACE)) {
				ValadocApiItem* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				_tmp32_ = parent;
				_tmp33_ = valadoc_api_interface_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, VALADOC_API_TYPE_INTERFACE, ValadocApiInterface));
				_tmp34_ = _tmp33_;
				_tmp30_ = _tmp34_ != NULL;
				_g_free0 (_tmp34_);
			} else {
				_tmp30_ = FALSE;
			}
			if (_tmp30_) {
				ValadocApiItem* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				const gchar* _tmp38_;
				gchar* _tmp39_;
				_tmp35_ = parent;
				_tmp36_ = valadoc_api_interface_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, VALADOC_API_TYPE_INTERFACE, ValadocApiInterface));
				_tmp37_ = _tmp36_;
				_tmp38_ = name;
				_tmp39_ = g_strconcat (_tmp37_, _tmp38_, NULL);
				_g_free0 (name);
				name = _tmp39_;
				_g_free0 (_tmp37_);
			} else {
				result = NULL;
				_g_object_unref0 (parent);
				_g_free0 (name);
				return result;
			}
		}
		_g_object_unref0 (parent);
	}
	_tmp40_ = self->priv->nodes;
	_tmp41_ = name;
	_tmp42_ = vala_map_get (_tmp40_, _tmp41_);
	node = (ValadocApiNode*) _tmp42_;
	_tmp43_ = node;
	if (_tmp43_ != NULL) {
		result = node;
		_g_free0 (name);
		return result;
	}
	_tmp44_ = name;
	_tmp45_ = valadoc_ctype_resolver_translate_cname_to_g (self, _tmp44_);
	alternative = _tmp45_;
	_tmp46_ = alternative;
	if (_tmp46_ != NULL) {
		ValaMap* _tmp47_;
		const gchar* _tmp48_;
		gpointer _tmp49_;
		_tmp47_ = self->priv->nodes;
		_tmp48_ = alternative;
		_tmp49_ = vala_map_get (_tmp47_, _tmp48_);
		result = (ValadocApiNode*) _tmp49_;
		_g_free0 (alternative);
		_g_object_unref0 (node);
		_g_free0 (name);
		return result;
	}
	_tmp51_ = element;
	if (_tmp51_ != NULL) {
		const gchar* _tmp52_;
		gboolean _tmp53_;
		_tmp52_ = name;
		_tmp53_ = g_str_has_prefix (_tmp52_, ":");
		_tmp50_ = _tmp53_;
	} else {
		_tmp50_ = FALSE;
	}
	if (_tmp50_) {
		gboolean _tmp54_ = FALSE;
		ValadocApiNode* _tmp55_;
		_tmp55_ = element;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp55_, VALADOC_API_TYPE_CLASS)) {
			ValadocApiNode* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			_tmp56_ = element;
			_tmp57_ = valadoc_api_class_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, VALADOC_API_TYPE_CLASS, ValadocApiClass));
			_tmp58_ = _tmp57_;
			_tmp54_ = _tmp58_ != NULL;
			_g_free0 (_tmp58_);
		} else {
			_tmp54_ = FALSE;
		}
		if (_tmp54_) {
			ValaMap* _tmp59_;
			ValadocApiNode* _tmp60_;
			gchar* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			gchar* _tmp64_;
			const gchar* _tmp65_;
			gchar* _tmp66_;
			gchar* _tmp67_;
			gpointer _tmp68_;
			ValadocApiNode* _tmp69_;
			_tmp59_ = self->priv->nodes;
			_tmp60_ = element;
			_tmp61_ = valadoc_api_class_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, VALADOC_API_TYPE_CLASS, ValadocApiClass));
			_tmp62_ = _tmp61_;
			_tmp63_ = g_strconcat (_tmp62_, ".", NULL);
			_tmp64_ = _tmp63_;
			_tmp65_ = name;
			_tmp66_ = g_strconcat (_tmp64_, _tmp65_, NULL);
			_tmp67_ = _tmp66_;
			_tmp68_ = vala_map_get (_tmp59_, _tmp67_);
			_tmp69_ = (ValadocApiNode*) _tmp68_;
			_g_free0 (_tmp67_);
			_g_free0 (_tmp64_);
			_g_free0 (_tmp62_);
			result = _tmp69_;
			_g_free0 (alternative);
			_g_object_unref0 (node);
			_g_free0 (name);
			return result;
		} else {
			gboolean _tmp70_ = FALSE;
			ValadocApiNode* _tmp71_;
			_tmp71_ = element;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp71_, VALADOC_API_TYPE_STRUCT)) {
				ValadocApiNode* _tmp72_;
				gchar* _tmp73_;
				gchar* _tmp74_;
				_tmp72_ = element;
				_tmp73_ = valadoc_api_struct_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, VALADOC_API_TYPE_STRUCT, ValadocApiStruct));
				_tmp74_ = _tmp73_;
				_tmp70_ = _tmp74_ != NULL;
				_g_free0 (_tmp74_);
			} else {
				_tmp70_ = FALSE;
			}
			if (_tmp70_) {
				ValaMap* _tmp75_;
				ValadocApiNode* _tmp76_;
				gchar* _tmp77_;
				gchar* _tmp78_;
				gchar* _tmp79_;
				gchar* _tmp80_;
				const gchar* _tmp81_;
				gchar* _tmp82_;
				gchar* _tmp83_;
				gpointer _tmp84_;
				ValadocApiNode* _tmp85_;
				_tmp75_ = self->priv->nodes;
				_tmp76_ = element;
				_tmp77_ = valadoc_api_struct_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, VALADOC_API_TYPE_STRUCT, ValadocApiStruct));
				_tmp78_ = _tmp77_;
				_tmp79_ = g_strconcat (_tmp78_, ".", NULL);
				_tmp80_ = _tmp79_;
				_tmp81_ = name;
				_tmp82_ = g_strconcat (_tmp80_, _tmp81_, NULL);
				_tmp83_ = _tmp82_;
				_tmp84_ = vala_map_get (_tmp75_, _tmp83_);
				_tmp85_ = (ValadocApiNode*) _tmp84_;
				_g_free0 (_tmp83_);
				_g_free0 (_tmp80_);
				_g_free0 (_tmp78_);
				result = _tmp85_;
				_g_free0 (alternative);
				_g_object_unref0 (node);
				_g_free0 (name);
				return result;
			}
		}
	}
	_tmp86_ = name;
	if (g_strcmp0 (_tmp86_, "dgettext") == 0) {
		ValaMap* _tmp87_;
		gpointer _tmp88_;
		_tmp87_ = self->priv->nodes;
		_tmp88_ = vala_map_get (_tmp87_, "g_dgettext");
		result = (ValadocApiNode*) _tmp88_;
		_g_free0 (alternative);
		_g_object_unref0 (node);
		_g_free0 (name);
		return result;
	} else {
		const gchar* _tmp89_;
		_tmp89_ = name;
		if (g_strcmp0 (_tmp89_, "printf") == 0) {
			ValadocApiTree* _tmp90_;
			ValadocApiNode* _tmp91_;
			_tmp90_ = self->priv->tree;
			_tmp91_ = valadoc_api_tree_search_symbol_str (_tmp90_, NULL, "GLib.FileStream.printf");
			result = _tmp91_;
			_g_free0 (alternative);
			_g_object_unref0 (node);
			_g_free0 (name);
			return result;
		}
	}
	_tmp92_ = name;
	_tmp93_ = string_index_of_char (_tmp92_, (gunichar) '.', 0);
	dotpos = _tmp93_;
	_tmp94_ = dotpos;
	if (_tmp94_ > 0) {
		gchar* fst = NULL;
		const gchar* _tmp95_;
		gint _tmp96_;
		gchar* _tmp97_;
		gchar* snd = NULL;
		const gchar* _tmp98_;
		gint _tmp99_;
		gchar* _tmp100_;
		ValaMap* _tmp101_;
		const gchar* _tmp102_;
		gchar* _tmp103_;
		gchar* _tmp104_;
		const gchar* _tmp105_;
		gchar* _tmp106_;
		gchar* _tmp107_;
		gpointer _tmp108_;
		ValadocApiNode* _tmp109_;
		_tmp95_ = name;
		_tmp96_ = dotpos;
		_tmp97_ = string_substring (_tmp95_, (glong) 0, (glong) _tmp96_);
		fst = _tmp97_;
		_tmp98_ = name;
		_tmp99_ = dotpos;
		_tmp100_ = string_substring (_tmp98_, (glong) (_tmp99_ + 1), (glong) -1);
		snd = _tmp100_;
		_tmp101_ = self->priv->nodes;
		_tmp102_ = fst;
		_tmp103_ = g_strconcat (_tmp102_, ":", NULL);
		_tmp104_ = _tmp103_;
		_tmp105_ = snd;
		_tmp106_ = g_strconcat (_tmp104_, _tmp105_, NULL);
		_tmp107_ = _tmp106_;
		_tmp108_ = vala_map_get (_tmp101_, _tmp107_);
		_tmp109_ = (ValadocApiNode*) _tmp108_;
		_g_free0 (_tmp107_);
		_g_free0 (_tmp104_);
		result = _tmp109_;
		_g_free0 (snd);
		_g_free0 (fst);
		_g_free0 (alternative);
		_g_object_unref0 (node);
		_g_free0 (name);
		return result;
	}
	result = NULL;
	_g_free0 (alternative);
	_g_object_unref0 (node);
	_g_free0 (name);
	return result;
}


static void valadoc_ctype_resolver_register_symbol_type (ValadocCTypeResolver* self, const gchar* name, ValadocApiTypeSymbol* symbol) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	_tmp0_ = name;
	if (_tmp0_ != NULL) {
		ValaMap* _tmp1_;
		const gchar* _tmp2_;
		ValadocApiTypeSymbol* _tmp3_;
		_tmp1_ = self->priv->types;
		_tmp2_ = name;
		_tmp3_ = symbol;
		vala_map_set (_tmp1_, _tmp2_, _tmp3_);
	}
}


static void valadoc_ctype_resolver_register_symbol (ValadocCTypeResolver* self, const gchar* name, ValadocApiNode* node) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = name;
	if (_tmp0_ != NULL) {
		ValaMap* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		ValadocApiNode* _tmp5_;
		_tmp1_ = self->priv->nodes;
		_tmp2_ = name;
		_tmp3_ = string_replace (_tmp2_, "-", "_");
		_tmp4_ = _tmp3_;
		_tmp5_ = node;
		vala_map_set (_tmp1_, _tmp4_, _tmp5_);
		_g_free0 (_tmp4_);
	}
}


static gchar* valadoc_ctype_resolver_get_parent_type_cname (ValadocCTypeResolver* self, ValadocApiItem* item) {
	gchar* result = NULL;
	gchar* parent_cname = NULL;
	ValadocApiItem* _tmp0_;
	ValadocApiItem* _tmp1_;
	ValadocApiItem* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	parent_cname = NULL;
	_tmp0_ = item;
	_tmp1_ = valadoc_api_item_get_parent (_tmp0_);
	_tmp2_ = _tmp1_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALADOC_API_TYPE_CLASS)) {
		ValadocApiItem* _tmp3_;
		ValadocApiItem* _tmp4_;
		ValadocApiItem* _tmp5_;
		gchar* _tmp6_;
		_tmp3_ = item;
		_tmp4_ = valadoc_api_item_get_parent (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = valadoc_api_class_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, VALADOC_API_TYPE_CLASS, ValadocApiClass));
		_g_free0 (parent_cname);
		parent_cname = _tmp6_;
	} else {
		ValadocApiItem* _tmp7_;
		ValadocApiItem* _tmp8_;
		ValadocApiItem* _tmp9_;
		_tmp7_ = item;
		_tmp8_ = valadoc_api_item_get_parent (_tmp7_);
		_tmp9_ = _tmp8_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALADOC_API_TYPE_INTERFACE)) {
			ValadocApiItem* _tmp10_;
			ValadocApiItem* _tmp11_;
			ValadocApiItem* _tmp12_;
			gchar* _tmp13_;
			_tmp10_ = item;
			_tmp11_ = valadoc_api_item_get_parent (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = valadoc_api_interface_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALADOC_API_TYPE_INTERFACE, ValadocApiInterface));
			_g_free0 (parent_cname);
			parent_cname = _tmp13_;
		} else {
			ValadocApiItem* _tmp14_;
			ValadocApiItem* _tmp15_;
			ValadocApiItem* _tmp16_;
			_tmp14_ = item;
			_tmp15_ = valadoc_api_item_get_parent (_tmp14_);
			_tmp16_ = _tmp15_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALADOC_API_TYPE_STRUCT)) {
				ValadocApiItem* _tmp17_;
				ValadocApiItem* _tmp18_;
				ValadocApiItem* _tmp19_;
				gchar* _tmp20_;
				_tmp17_ = item;
				_tmp18_ = valadoc_api_item_get_parent (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = valadoc_api_struct_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALADOC_API_TYPE_STRUCT, ValadocApiStruct));
				_g_free0 (parent_cname);
				parent_cname = _tmp20_;
			} else {
				ValadocApiItem* _tmp21_;
				ValadocApiItem* _tmp22_;
				ValadocApiItem* _tmp23_;
				_tmp21_ = item;
				_tmp22_ = valadoc_api_item_get_parent (_tmp21_);
				_tmp23_ = _tmp22_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, VALADOC_API_TYPE_ERROR_DOMAIN)) {
					ValadocApiItem* _tmp24_;
					ValadocApiItem* _tmp25_;
					ValadocApiItem* _tmp26_;
					gchar* _tmp27_;
					_tmp24_ = item;
					_tmp25_ = valadoc_api_item_get_parent (_tmp24_);
					_tmp26_ = _tmp25_;
					_tmp27_ = valadoc_api_error_domain_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, VALADOC_API_TYPE_ERROR_DOMAIN, ValadocApiErrorDomain));
					_g_free0 (parent_cname);
					parent_cname = _tmp27_;
				} else {
					ValadocApiItem* _tmp28_;
					ValadocApiItem* _tmp29_;
					ValadocApiItem* _tmp30_;
					_tmp28_ = item;
					_tmp29_ = valadoc_api_item_get_parent (_tmp28_);
					_tmp30_ = _tmp29_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp30_, VALADOC_API_TYPE_ENUM)) {
						ValadocApiItem* _tmp31_;
						ValadocApiItem* _tmp32_;
						ValadocApiItem* _tmp33_;
						gchar* _tmp34_;
						_tmp31_ = item;
						_tmp32_ = valadoc_api_item_get_parent (_tmp31_);
						_tmp33_ = _tmp32_;
						_tmp34_ = valadoc_api_enum_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, VALADOC_API_TYPE_ENUM, ValadocApiEnum));
						_g_free0 (parent_cname);
						parent_cname = _tmp34_;
					} else {
						_vala_assert (TRUE, "true");
					}
				}
			}
		}
	}
	result = parent_cname;
	return result;
}


/**
 * {@inheritDoc}
 */
static void valadoc_ctype_resolver_real_visit_tree (ValadocApiVisitor* base, ValadocApiTree* item) {
	ValadocCTypeResolver * self;
	ValadocApiTree* _tmp0_;
	self = (ValadocCTypeResolver*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	valadoc_api_tree_accept_children (_tmp0_, (ValadocApiVisitor*) self);
}


/**
 * {@inheritDoc}
 */
static void valadoc_ctype_resolver_real_visit_package (ValadocApiVisitor* base, ValadocApiPackage* item) {
	ValadocCTypeResolver * self;
	ValadocApiPackage* _tmp0_;
	self = (ValadocCTypeResolver*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	valadoc_api_node_accept_all_children ((ValadocApiNode*) _tmp0_, (ValadocApiVisitor*) self, FALSE);
}


/**
 * {@inheritDoc}
 */
static void valadoc_ctype_resolver_real_visit_namespace (ValadocApiVisitor* base, ValadocApiNamespace* item) {
	ValadocCTypeResolver * self;
	ValadocApiNamespace* _tmp0_;
	self = (ValadocCTypeResolver*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	valadoc_api_node_accept_all_children ((ValadocApiNode*) _tmp0_, (ValadocApiVisitor*) self, FALSE);
}


/**
 * {@inheritDoc}
 */
static void valadoc_ctype_resolver_real_visit_interface (ValadocApiVisitor* base, ValadocApiInterface* item) {
	ValadocCTypeResolver * self;
	ValadocApiInterface* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ValadocApiInterface* _tmp3_;
	ValadocApiInterface* _tmp4_;
	self = (ValadocCTypeResolver*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	_tmp1_ = valadoc_api_interface_get_cname (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = item;
	valadoc_ctype_resolver_register_symbol (self, _tmp2_, (ValadocApiNode*) _tmp3_);
	_g_free0 (_tmp2_);
	_tmp4_ = item;
	valadoc_api_node_accept_all_children ((ValadocApiNode*) _tmp4_, (ValadocApiVisitor*) self, FALSE);
}


/**
 * {@inheritDoc}
 */
static void valadoc_ctype_resolver_real_visit_class (ValadocApiVisitor* base, ValadocApiClass* item) {
	ValadocCTypeResolver * self;
	ValadocApiClass* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ValadocApiClass* _tmp3_;
	ValadocApiClass* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	ValadocApiClass* _tmp7_;
	ValadocApiClass* _tmp8_;
	self = (ValadocCTypeResolver*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	_tmp1_ = valadoc_api_class_get_type_id (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = item;
	valadoc_ctype_resolver_register_symbol_type (self, _tmp2_, (ValadocApiTypeSymbol*) _tmp3_);
	_g_free0 (_tmp2_);
	_tmp4_ = item;
	_tmp5_ = valadoc_api_class_get_cname (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = item;
	valadoc_ctype_resolver_register_symbol (self, _tmp6_, (ValadocApiNode*) _tmp7_);
	_g_free0 (_tmp6_);
	_tmp8_ = item;
	valadoc_api_node_accept_all_children ((ValadocApiNode*) _tmp8_, (ValadocApiVisitor*) self, FALSE);
}


/**
 * {@inheritDoc}
 */
static void valadoc_ctype_resolver_real_visit_struct (ValadocApiVisitor* base, ValadocApiStruct* item) {
	ValadocCTypeResolver * self;
	ValadocApiStruct* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ValadocApiStruct* _tmp3_;
	ValadocApiStruct* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	ValadocApiStruct* _tmp7_;
	ValadocApiStruct* _tmp8_;
	self = (ValadocCTypeResolver*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	_tmp1_ = valadoc_api_struct_get_type_id (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = item;
	valadoc_ctype_resolver_register_symbol_type (self, _tmp2_, (ValadocApiTypeSymbol*) _tmp3_);
	_g_free0 (_tmp2_);
	_tmp4_ = item;
	_tmp5_ = valadoc_api_struct_get_cname (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = item;
	valadoc_ctype_resolver_register_symbol (self, _tmp6_, (ValadocApiNode*) _tmp7_);
	_g_free0 (_tmp6_);
	_tmp8_ = item;
	valadoc_api_node_accept_all_children ((ValadocApiNode*) _tmp8_, (ValadocApiVisitor*) self, FALSE);
}


/**
 * {@inheritDoc}
 */
static void valadoc_ctype_resolver_real_visit_property (ValadocApiVisitor* base, ValadocApiProperty* item) {
	ValadocCTypeResolver * self;
	gchar* parent_cname = NULL;
	ValadocApiProperty* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* cname = NULL;
	ValadocApiProperty* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValadocApiProperty* _tmp11_;
	ValaCollection* interfaces = NULL;
	ValaCollection* classes = NULL;
	ValadocApiProperty* _tmp12_;
	ValadocApiItem* _tmp13_;
	ValadocApiItem* _tmp14_;
	self = (ValadocCTypeResolver*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	_tmp1_ = valadoc_ctype_resolver_get_parent_type_cname (self, (ValadocApiItem*) _tmp0_);
	parent_cname = _tmp1_;
	_tmp2_ = parent_cname;
	_vala_assert (_tmp2_ != NULL, "parent_cname != null");
	_tmp3_ = item;
	_tmp4_ = valadoc_api_property_get_cname (_tmp3_);
	cname = _tmp4_;
	_tmp5_ = parent_cname;
	_tmp6_ = g_strconcat (_tmp5_, ":", NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = cname;
	_tmp9_ = g_strconcat (_tmp7_, _tmp8_, NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = item;
	valadoc_ctype_resolver_register_symbol (self, _tmp10_, (ValadocApiNode*) _tmp11_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp7_);
	interfaces = NULL;
	classes = NULL;
	_tmp12_ = item;
	_tmp13_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp12_);
	_tmp14_ = _tmp13_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALADOC_API_TYPE_INTERFACE)) {
		ValadocApiProperty* _tmp15_;
		ValadocApiItem* _tmp16_;
		ValadocApiItem* _tmp17_;
		ValaCollection* _tmp18_;
		ValadocApiProperty* _tmp19_;
		ValadocApiItem* _tmp20_;
		ValadocApiItem* _tmp21_;
		ValaCollection* _tmp22_;
		_tmp15_ = item;
		_tmp16_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = valadoc_api_interface_get_known_related_interfaces (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALADOC_API_TYPE_INTERFACE, ValadocApiInterface));
		_vala_iterable_unref0 (interfaces);
		interfaces = _tmp18_;
		_tmp19_ = item;
		_tmp20_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = valadoc_api_interface_get_known_implementations (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALADOC_API_TYPE_INTERFACE, ValadocApiInterface));
		_vala_iterable_unref0 (classes);
		classes = _tmp22_;
	} else {
		ValadocApiProperty* _tmp23_;
		ValadocApiItem* _tmp24_;
		ValadocApiItem* _tmp25_;
		_tmp23_ = item;
		_tmp24_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp23_);
		_tmp25_ = _tmp24_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, VALADOC_API_TYPE_CLASS)) {
			ValadocApiProperty* _tmp26_;
			ValadocApiItem* _tmp27_;
			ValadocApiItem* _tmp28_;
			ValaCollection* _tmp29_;
			ValadocApiProperty* _tmp30_;
			ValadocApiItem* _tmp31_;
			ValadocApiItem* _tmp32_;
			ValaCollection* _tmp33_;
			_tmp26_ = item;
			_tmp27_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = valadoc_api_class_get_known_derived_interfaces (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALADOC_API_TYPE_CLASS, ValadocApiClass));
			_vala_iterable_unref0 (interfaces);
			interfaces = _tmp29_;
			_tmp30_ = item;
			_tmp31_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = valadoc_api_class_get_known_child_classes (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, VALADOC_API_TYPE_CLASS, ValadocApiClass));
			_vala_iterable_unref0 (classes);
			classes = _tmp33_;
		}
	}
	{
		ValaIterator* _iface_it = NULL;
		ValaCollection* _tmp34_;
		ValaIterator* _tmp35_;
		_tmp34_ = interfaces;
		_tmp35_ = vala_iterable_iterator ((ValaIterable*) _tmp34_);
		_iface_it = _tmp35_;
		while (TRUE) {
			ValaIterator* _tmp36_;
			gboolean _tmp37_;
			ValadocApiInterface* iface = NULL;
			ValaIterator* _tmp38_;
			gpointer _tmp39_;
			ValadocApiInterface* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			const gchar* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			ValadocApiProperty* _tmp48_;
			_tmp36_ = _iface_it;
			_tmp37_ = vala_iterator_next (_tmp36_);
			if (!_tmp37_) {
				break;
			}
			_tmp38_ = _iface_it;
			_tmp39_ = vala_iterator_get (_tmp38_);
			iface = (ValadocApiInterface*) _tmp39_;
			_tmp40_ = iface;
			_tmp41_ = valadoc_api_interface_get_cname (_tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = g_strconcat (_tmp42_, ":", NULL);
			_tmp44_ = _tmp43_;
			_tmp45_ = cname;
			_tmp46_ = g_strconcat (_tmp44_, _tmp45_, NULL);
			_tmp47_ = _tmp46_;
			_tmp48_ = item;
			valadoc_ctype_resolver_register_symbol (self, _tmp47_, (ValadocApiNode*) _tmp48_);
			_g_free0 (_tmp47_);
			_g_free0 (_tmp44_);
			_g_free0 (_tmp42_);
			_g_object_unref0 (iface);
		}
		_vala_iterator_unref0 (_iface_it);
	}
	{
		ValaIterator* _cl_it = NULL;
		ValaCollection* _tmp49_;
		ValaIterator* _tmp50_;
		_tmp49_ = classes;
		_tmp50_ = vala_iterable_iterator ((ValaIterable*) _tmp49_);
		_cl_it = _tmp50_;
		while (TRUE) {
			ValaIterator* _tmp51_;
			gboolean _tmp52_;
			ValadocApiClass* cl = NULL;
			ValaIterator* _tmp53_;
			gpointer _tmp54_;
			ValadocApiClass* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			const gchar* _tmp60_;
			gchar* _tmp61_;
			gchar* _tmp62_;
			ValadocApiProperty* _tmp63_;
			_tmp51_ = _cl_it;
			_tmp52_ = vala_iterator_next (_tmp51_);
			if (!_tmp52_) {
				break;
			}
			_tmp53_ = _cl_it;
			_tmp54_ = vala_iterator_get (_tmp53_);
			cl = (ValadocApiClass*) _tmp54_;
			_tmp55_ = cl;
			_tmp56_ = valadoc_api_class_get_cname (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = g_strconcat (_tmp57_, ":", NULL);
			_tmp59_ = _tmp58_;
			_tmp60_ = cname;
			_tmp61_ = g_strconcat (_tmp59_, _tmp60_, NULL);
			_tmp62_ = _tmp61_;
			_tmp63_ = item;
			valadoc_ctype_resolver_register_symbol (self, _tmp62_, (ValadocApiNode*) _tmp63_);
			_g_free0 (_tmp62_);
			_g_free0 (_tmp59_);
			_g_free0 (_tmp57_);
			_g_object_unref0 (cl);
		}
		_vala_iterator_unref0 (_cl_it);
	}
	_vala_iterable_unref0 (classes);
	_vala_iterable_unref0 (interfaces);
	_g_free0 (cname);
	_g_free0 (parent_cname);
}


/**
 * {@inheritDoc}
 */
static void valadoc_ctype_resolver_real_visit_field (ValadocApiVisitor* base, ValadocApiField* item) {
	ValadocCTypeResolver * self;
	gboolean _tmp0_ = FALSE;
	ValadocApiField* _tmp1_;
	ValadocApiItem* _tmp2_;
	ValadocApiItem* _tmp3_;
	self = (ValadocCTypeResolver*) base;
	g_return_if_fail (item != NULL);
	_tmp1_ = item;
	_tmp2_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALADOC_API_TYPE_NAMESPACE)) {
		_tmp0_ = TRUE;
	} else {
		ValadocApiField* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = item;
		_tmp5_ = valadoc_api_field_get_is_static (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_;
	}
	if (_tmp0_) {
		ValadocApiField* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		ValadocApiField* _tmp10_;
		_tmp7_ = item;
		_tmp8_ = valadoc_api_field_get_cname (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = item;
		valadoc_ctype_resolver_register_symbol (self, _tmp9_, (ValadocApiNode*) _tmp10_);
		_g_free0 (_tmp9_);
	} else {
		gchar* parent_cname = NULL;
		ValadocApiField* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		_tmp11_ = item;
		_tmp12_ = valadoc_ctype_resolver_get_parent_type_cname (self, (ValadocApiItem*) _tmp11_);
		parent_cname = _tmp12_;
		_tmp13_ = parent_cname;
		if (_tmp13_ != NULL) {
			const gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			ValadocApiField* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			ValadocApiField* _tmp22_;
			_tmp14_ = parent_cname;
			_tmp15_ = g_strconcat (_tmp14_, ".", NULL);
			_tmp16_ = _tmp15_;
			_tmp17_ = item;
			_tmp18_ = valadoc_api_field_get_cname (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strconcat (_tmp16_, _tmp19_, NULL);
			_tmp21_ = _tmp20_;
			_tmp22_ = item;
			valadoc_ctype_resolver_register_symbol (self, _tmp21_, (ValadocApiNode*) _tmp22_);
			_g_free0 (_tmp21_);
			_g_free0 (_tmp19_);
			_g_free0 (_tmp16_);
		}
		_g_free0 (parent_cname);
	}
}


/**
 * {@inheritDoc}
 */
static void valadoc_ctype_resolver_real_visit_constant (ValadocApiVisitor* base, ValadocApiConstant* item) {
	ValadocCTypeResolver * self;
	ValadocApiConstant* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ValadocApiConstant* _tmp3_;
	self = (ValadocCTypeResolver*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	_tmp1_ = valadoc_api_constant_get_cname (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = item;
	valadoc_ctype_resolver_register_symbol (self, _tmp2_, (ValadocApiNode*) _tmp3_);
	_g_free0 (_tmp2_);
}


/**
 * {@inheritDoc}
 */
static void valadoc_ctype_resolver_real_visit_delegate (ValadocApiVisitor* base, ValadocApiDelegate* item) {
	ValadocCTypeResolver * self;
	ValadocApiDelegate* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ValadocApiDelegate* _tmp3_;
	self = (ValadocCTypeResolver*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	_tmp1_ = valadoc_api_delegate_get_cname (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = item;
	valadoc_ctype_resolver_register_symbol (self, _tmp2_, (ValadocApiNode*) _tmp3_);
	_g_free0 (_tmp2_);
}


/**
 * {@inheritDoc}
 */
static void valadoc_ctype_resolver_real_visit_signal (ValadocApiVisitor* base, ValadocApiSignal* item) {
	ValadocCTypeResolver * self;
	gchar* parent_cname = NULL;
	ValadocApiSignal* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* default_impl_cname = NULL;
	ValadocApiSignal* _tmp3_;
	gchar* _tmp4_;
	gchar* cname = NULL;
	ValadocApiSignal* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	ValadocApiSignal* _tmp13_;
	ValadocApiSignal* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	ValaCollection* interfaces = NULL;
	ValaCollection* classes = NULL;
	ValadocApiSignal* _tmp26_;
	ValadocApiItem* _tmp27_;
	ValadocApiItem* _tmp28_;
	const gchar* _tmp78_;
	self = (ValadocCTypeResolver*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	_tmp1_ = valadoc_ctype_resolver_get_parent_type_cname (self, (ValadocApiItem*) _tmp0_);
	parent_cname = _tmp1_;
	_tmp2_ = parent_cname;
	_vala_assert (_tmp2_ != NULL, "parent_cname != null");
	_tmp3_ = item;
	_tmp4_ = valadoc_api_signal_get_default_impl_cname (_tmp3_);
	default_impl_cname = _tmp4_;
	_tmp5_ = item;
	_tmp6_ = valadoc_api_signal_get_cname (_tmp5_);
	cname = _tmp6_;
	_tmp7_ = parent_cname;
	_tmp8_ = g_strconcat (_tmp7_, "::", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = cname;
	_tmp11_ = g_strconcat (_tmp9_, _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = item;
	valadoc_ctype_resolver_register_symbol (self, _tmp12_, (ValadocApiNode*) _tmp13_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp9_);
	_tmp14_ = item;
	_tmp15_ = valadoc_api_signal_get_is_virtual (_tmp14_);
	_tmp16_ = _tmp15_;
	if (_tmp16_) {
		const gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		ValadocApiSignal* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		ValadocApiSignal* _tmp25_;
		_tmp17_ = parent_cname;
		_tmp18_ = g_strconcat (_tmp17_, "Class.", NULL);
		_tmp19_ = _tmp18_;
		_tmp20_ = item;
		_tmp21_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strconcat (_tmp19_, _tmp22_, NULL);
		_tmp24_ = _tmp23_;
		_tmp25_ = item;
		valadoc_ctype_resolver_register_symbol (self, _tmp24_, (ValadocApiNode*) _tmp25_);
		_g_free0 (_tmp24_);
		_g_free0 (_tmp19_);
	}
	interfaces = NULL;
	classes = NULL;
	_tmp26_ = item;
	_tmp27_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp26_);
	_tmp28_ = _tmp27_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, VALADOC_API_TYPE_INTERFACE)) {
		ValadocApiSignal* _tmp29_;
		ValadocApiItem* _tmp30_;
		ValadocApiItem* _tmp31_;
		ValaCollection* _tmp32_;
		ValadocApiSignal* _tmp33_;
		ValadocApiItem* _tmp34_;
		ValadocApiItem* _tmp35_;
		ValaCollection* _tmp36_;
		_tmp29_ = item;
		_tmp30_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = valadoc_api_interface_get_known_related_interfaces (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, VALADOC_API_TYPE_INTERFACE, ValadocApiInterface));
		_vala_iterable_unref0 (interfaces);
		interfaces = _tmp32_;
		_tmp33_ = item;
		_tmp34_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = valadoc_api_interface_get_known_implementations (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, VALADOC_API_TYPE_INTERFACE, ValadocApiInterface));
		_vala_iterable_unref0 (classes);
		classes = _tmp36_;
	} else {
		ValadocApiSignal* _tmp37_;
		ValadocApiItem* _tmp38_;
		ValadocApiItem* _tmp39_;
		_tmp37_ = item;
		_tmp38_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp37_);
		_tmp39_ = _tmp38_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp39_, VALADOC_API_TYPE_CLASS)) {
			ValadocApiSignal* _tmp40_;
			ValadocApiItem* _tmp41_;
			ValadocApiItem* _tmp42_;
			ValaCollection* _tmp43_;
			ValadocApiSignal* _tmp44_;
			ValadocApiItem* _tmp45_;
			ValadocApiItem* _tmp46_;
			ValaCollection* _tmp47_;
			_tmp40_ = item;
			_tmp41_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = valadoc_api_class_get_known_derived_interfaces (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, VALADOC_API_TYPE_CLASS, ValadocApiClass));
			_vala_iterable_unref0 (interfaces);
			interfaces = _tmp43_;
			_tmp44_ = item;
			_tmp45_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = valadoc_api_class_get_known_child_classes (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, VALADOC_API_TYPE_CLASS, ValadocApiClass));
			_vala_iterable_unref0 (classes);
			classes = _tmp47_;
		}
	}
	{
		ValaIterator* _iface_it = NULL;
		ValaCollection* _tmp48_;
		ValaIterator* _tmp49_;
		_tmp48_ = interfaces;
		_tmp49_ = vala_iterable_iterator ((ValaIterable*) _tmp48_);
		_iface_it = _tmp49_;
		while (TRUE) {
			ValaIterator* _tmp50_;
			gboolean _tmp51_;
			ValadocApiInterface* iface = NULL;
			ValaIterator* _tmp52_;
			gpointer _tmp53_;
			ValadocApiInterface* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			const gchar* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			ValadocApiSignal* _tmp62_;
			_tmp50_ = _iface_it;
			_tmp51_ = vala_iterator_next (_tmp50_);
			if (!_tmp51_) {
				break;
			}
			_tmp52_ = _iface_it;
			_tmp53_ = vala_iterator_get (_tmp52_);
			iface = (ValadocApiInterface*) _tmp53_;
			_tmp54_ = iface;
			_tmp55_ = valadoc_api_interface_get_cname (_tmp54_);
			_tmp56_ = _tmp55_;
			_tmp57_ = g_strconcat (_tmp56_, "::", NULL);
			_tmp58_ = _tmp57_;
			_tmp59_ = cname;
			_tmp60_ = g_strconcat (_tmp58_, _tmp59_, NULL);
			_tmp61_ = _tmp60_;
			_tmp62_ = item;
			valadoc_ctype_resolver_register_symbol (self, _tmp61_, (ValadocApiNode*) _tmp62_);
			_g_free0 (_tmp61_);
			_g_free0 (_tmp58_);
			_g_free0 (_tmp56_);
			_g_object_unref0 (iface);
		}
		_vala_iterator_unref0 (_iface_it);
	}
	{
		ValaIterator* _cl_it = NULL;
		ValaCollection* _tmp63_;
		ValaIterator* _tmp64_;
		_tmp63_ = classes;
		_tmp64_ = vala_iterable_iterator ((ValaIterable*) _tmp63_);
		_cl_it = _tmp64_;
		while (TRUE) {
			ValaIterator* _tmp65_;
			gboolean _tmp66_;
			ValadocApiClass* cl = NULL;
			ValaIterator* _tmp67_;
			gpointer _tmp68_;
			ValadocApiClass* _tmp69_;
			gchar* _tmp70_;
			gchar* _tmp71_;
			gchar* _tmp72_;
			gchar* _tmp73_;
			const gchar* _tmp74_;
			gchar* _tmp75_;
			gchar* _tmp76_;
			ValadocApiSignal* _tmp77_;
			_tmp65_ = _cl_it;
			_tmp66_ = vala_iterator_next (_tmp65_);
			if (!_tmp66_) {
				break;
			}
			_tmp67_ = _cl_it;
			_tmp68_ = vala_iterator_get (_tmp67_);
			cl = (ValadocApiClass*) _tmp68_;
			_tmp69_ = cl;
			_tmp70_ = valadoc_api_class_get_cname (_tmp69_);
			_tmp71_ = _tmp70_;
			_tmp72_ = g_strconcat (_tmp71_, "::", NULL);
			_tmp73_ = _tmp72_;
			_tmp74_ = cname;
			_tmp75_ = g_strconcat (_tmp73_, _tmp74_, NULL);
			_tmp76_ = _tmp75_;
			_tmp77_ = item;
			valadoc_ctype_resolver_register_symbol (self, _tmp76_, (ValadocApiNode*) _tmp77_);
			_g_free0 (_tmp76_);
			_g_free0 (_tmp73_);
			_g_free0 (_tmp71_);
			_g_object_unref0 (cl);
		}
		_vala_iterator_unref0 (_cl_it);
	}
	_tmp78_ = default_impl_cname;
	if (_tmp78_ != NULL) {
		const gchar* _tmp79_;
		ValadocApiSignal* _tmp80_;
		_tmp79_ = default_impl_cname;
		_tmp80_ = item;
		valadoc_ctype_resolver_register_symbol (self, _tmp79_, (ValadocApiNode*) _tmp80_);
	}
	_vala_iterable_unref0 (classes);
	_vala_iterable_unref0 (interfaces);
	_g_free0 (cname);
	_g_free0 (default_impl_cname);
	_g_free0 (parent_cname);
}


/**
 * {@inheritDoc}
 */
static void valadoc_ctype_resolver_real_visit_method (ValadocApiVisitor* base, ValadocApiMethod* item) {
	ValadocCTypeResolver * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValadocApiMethod* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	ValadocApiMethod* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	ValadocApiMethod* _tmp46_;
	self = (ValadocCTypeResolver*) base;
	g_return_if_fail (item != NULL);
	_tmp2_ = item;
	_tmp3_ = valadoc_api_method_get_is_abstract (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		_tmp1_ = TRUE;
	} else {
		ValadocApiMethod* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = item;
		_tmp6_ = valadoc_api_method_get_is_virtual (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = _tmp7_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		ValadocApiMethod* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp8_ = item;
		_tmp9_ = valadoc_api_method_get_is_override (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp0_ = _tmp10_;
	}
	if (_tmp0_) {
		gchar* parent_cname = NULL;
		ValadocApiMethod* _tmp11_;
		gchar* _tmp12_;
		ValadocApiMethod* _tmp13_;
		ValadocApiItem* _tmp14_;
		ValadocApiItem* _tmp15_;
		const gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		ValadocApiMethod* _tmp37_;
		const gchar* _tmp38_;
		const gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		ValadocApiMethod* _tmp42_;
		_tmp11_ = item;
		_tmp12_ = valadoc_ctype_resolver_get_parent_type_cname (self, (ValadocApiItem*) _tmp11_);
		parent_cname = _tmp12_;
		_tmp13_ = item;
		_tmp14_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp13_);
		_tmp15_ = _tmp14_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, VALADOC_API_TYPE_CLASS)) {
			const gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			ValadocApiMethod* _tmp19_;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			ValadocApiMethod* _tmp24_;
			_tmp16_ = parent_cname;
			_tmp17_ = g_strconcat (_tmp16_, "Class.", NULL);
			_tmp18_ = _tmp17_;
			_tmp19_ = item;
			_tmp20_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = g_strconcat (_tmp18_, _tmp21_, NULL);
			_tmp23_ = _tmp22_;
			_tmp24_ = item;
			valadoc_ctype_resolver_register_symbol (self, _tmp23_, (ValadocApiNode*) _tmp24_);
			_g_free0 (_tmp23_);
			_g_free0 (_tmp18_);
		} else {
			const gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			ValadocApiMethod* _tmp28_;
			const gchar* _tmp29_;
			const gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			ValadocApiMethod* _tmp33_;
			_tmp25_ = parent_cname;
			_tmp26_ = g_strconcat (_tmp25_, "Iface.", NULL);
			_tmp27_ = _tmp26_;
			_tmp28_ = item;
			_tmp29_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = g_strconcat (_tmp27_, _tmp30_, NULL);
			_tmp32_ = _tmp31_;
			_tmp33_ = item;
			valadoc_ctype_resolver_register_symbol (self, _tmp32_, (ValadocApiNode*) _tmp33_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp27_);
		}
		_tmp34_ = parent_cname;
		_tmp35_ = g_strconcat (_tmp34_, ".", NULL);
		_tmp36_ = _tmp35_;
		_tmp37_ = item;
		_tmp38_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = g_strconcat (_tmp36_, _tmp39_, NULL);
		_tmp41_ = _tmp40_;
		_tmp42_ = item;
		valadoc_ctype_resolver_register_symbol (self, _tmp41_, (ValadocApiNode*) _tmp42_);
		_g_free0 (_tmp41_);
		_g_free0 (_tmp36_);
		_g_free0 (parent_cname);
	}
	_tmp43_ = item;
	_tmp44_ = valadoc_api_method_get_cname (_tmp43_);
	_tmp45_ = _tmp44_;
	_tmp46_ = item;
	valadoc_ctype_resolver_register_symbol (self, _tmp45_, (ValadocApiNode*) _tmp46_);
	_g_free0 (_tmp45_);
}


/**
 * {@inheritDoc}
 */
static void valadoc_ctype_resolver_real_visit_error_domain (ValadocApiVisitor* base, ValadocApiErrorDomain* item) {
	ValadocCTypeResolver * self;
	ValadocApiErrorDomain* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ValadocApiErrorDomain* _tmp3_;
	ValadocApiErrorDomain* _tmp4_;
	self = (ValadocCTypeResolver*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	_tmp1_ = valadoc_api_error_domain_get_cname (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = item;
	valadoc_ctype_resolver_register_symbol (self, _tmp2_, (ValadocApiNode*) _tmp3_);
	_g_free0 (_tmp2_);
	_tmp4_ = item;
	valadoc_api_node_accept_all_children ((ValadocApiNode*) _tmp4_, (ValadocApiVisitor*) self, FALSE);
}


/**
 * {@inheritDoc}
 */
static void valadoc_ctype_resolver_real_visit_error_code (ValadocApiVisitor* base, ValadocApiErrorCode* item) {
	ValadocCTypeResolver * self;
	ValadocApiErrorCode* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ValadocApiErrorCode* _tmp3_;
	self = (ValadocCTypeResolver*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	_tmp1_ = valadoc_api_error_code_get_cname (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = item;
	valadoc_ctype_resolver_register_symbol (self, _tmp2_, (ValadocApiNode*) _tmp3_);
	_g_free0 (_tmp2_);
}


/**
 * {@inheritDoc}
 */
static void valadoc_ctype_resolver_real_visit_enum (ValadocApiVisitor* base, ValadocApiEnum* item) {
	ValadocCTypeResolver * self;
	ValadocApiEnum* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ValadocApiEnum* _tmp3_;
	ValadocApiEnum* _tmp4_;
	self = (ValadocCTypeResolver*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	_tmp1_ = valadoc_api_enum_get_cname (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = item;
	valadoc_ctype_resolver_register_symbol (self, _tmp2_, (ValadocApiNode*) _tmp3_);
	_g_free0 (_tmp2_);
	_tmp4_ = item;
	valadoc_api_node_accept_all_children ((ValadocApiNode*) _tmp4_, (ValadocApiVisitor*) self, FALSE);
}


/**
 * {@inheritDoc}
 */
static void valadoc_ctype_resolver_real_visit_enum_value (ValadocApiVisitor* base, ValadocApiEnumValue* item) {
	ValadocCTypeResolver * self;
	ValadocApiEnumValue* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ValadocApiEnumValue* _tmp3_;
	self = (ValadocCTypeResolver*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	_tmp1_ = valadoc_api_enum_value_get_cname (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = item;
	valadoc_ctype_resolver_register_symbol (self, _tmp2_, (ValadocApiNode*) _tmp3_);
	_g_free0 (_tmp2_);
}


static void valadoc_ctype_resolver_class_init (ValadocCTypeResolverClass * klass) {
	valadoc_ctype_resolver_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValadocCTypeResolverPrivate));
	((ValadocApiVisitorClass *) klass)->visit_tree = (void (*) (ValadocApiVisitor *, ValadocApiTree*)) valadoc_ctype_resolver_real_visit_tree;
	((ValadocApiVisitorClass *) klass)->visit_package = (void (*) (ValadocApiVisitor *, ValadocApiPackage*)) valadoc_ctype_resolver_real_visit_package;
	((ValadocApiVisitorClass *) klass)->visit_namespace = (void (*) (ValadocApiVisitor *, ValadocApiNamespace*)) valadoc_ctype_resolver_real_visit_namespace;
	((ValadocApiVisitorClass *) klass)->visit_interface = (void (*) (ValadocApiVisitor *, ValadocApiInterface*)) valadoc_ctype_resolver_real_visit_interface;
	((ValadocApiVisitorClass *) klass)->visit_class = (void (*) (ValadocApiVisitor *, ValadocApiClass*)) valadoc_ctype_resolver_real_visit_class;
	((ValadocApiVisitorClass *) klass)->visit_struct = (void (*) (ValadocApiVisitor *, ValadocApiStruct*)) valadoc_ctype_resolver_real_visit_struct;
	((ValadocApiVisitorClass *) klass)->visit_property = (void (*) (ValadocApiVisitor *, ValadocApiProperty*)) valadoc_ctype_resolver_real_visit_property;
	((ValadocApiVisitorClass *) klass)->visit_field = (void (*) (ValadocApiVisitor *, ValadocApiField*)) valadoc_ctype_resolver_real_visit_field;
	((ValadocApiVisitorClass *) klass)->visit_constant = (void (*) (ValadocApiVisitor *, ValadocApiConstant*)) valadoc_ctype_resolver_real_visit_constant;
	((ValadocApiVisitorClass *) klass)->visit_delegate = (void (*) (ValadocApiVisitor *, ValadocApiDelegate*)) valadoc_ctype_resolver_real_visit_delegate;
	((ValadocApiVisitorClass *) klass)->visit_signal = (void (*) (ValadocApiVisitor *, ValadocApiSignal*)) valadoc_ctype_resolver_real_visit_signal;
	((ValadocApiVisitorClass *) klass)->visit_method = (void (*) (ValadocApiVisitor *, ValadocApiMethod*)) valadoc_ctype_resolver_real_visit_method;
	((ValadocApiVisitorClass *) klass)->visit_error_domain = (void (*) (ValadocApiVisitor *, ValadocApiErrorDomain*)) valadoc_ctype_resolver_real_visit_error_domain;
	((ValadocApiVisitorClass *) klass)->visit_error_code = (void (*) (ValadocApiVisitor *, ValadocApiErrorCode*)) valadoc_ctype_resolver_real_visit_error_code;
	((ValadocApiVisitorClass *) klass)->visit_enum = (void (*) (ValadocApiVisitor *, ValadocApiEnum*)) valadoc_ctype_resolver_real_visit_enum;
	((ValadocApiVisitorClass *) klass)->visit_enum_value = (void (*) (ValadocApiVisitor *, ValadocApiEnumValue*)) valadoc_ctype_resolver_real_visit_enum_value;
	G_OBJECT_CLASS (klass)->finalize = valadoc_ctype_resolver_finalize;
}


static void valadoc_ctype_resolver_instance_init (ValadocCTypeResolver * self) {
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	GEqualFunc _tmp6_;
	ValaHashMap* _tmp7_;
	self->priv = VALADOC_CTYPE_RESOLVER_GET_PRIVATE (self);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, VALADOC_API_TYPE_TYPESYMBOL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_, _tmp1_, _tmp2_);
	self->priv->types = (ValaMap*) _tmp3_;
	_tmp4_ = g_str_hash;
	_tmp5_ = g_str_equal;
	_tmp6_ = g_direct_equal;
	_tmp7_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, VALADOC_API_TYPE_NODE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp4_, _tmp5_, _tmp6_);
	self->priv->nodes = (ValaMap*) _tmp7_;
}


static void valadoc_ctype_resolver_finalize (GObject * obj) {
	ValadocCTypeResolver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_TYPE_CTYPE_RESOLVER, ValadocCTypeResolver);
	_vala_map_unref0 (self->priv->types);
	_vala_map_unref0 (self->priv->nodes);
	_valadoc_api_tree_unref0 (self->priv->tree);
	G_OBJECT_CLASS (valadoc_ctype_resolver_parent_class)->finalize (obj);
}


/**
 * Resolves symbols by C-names
 */
GType valadoc_ctype_resolver_get_type (void) {
	static volatile gsize valadoc_ctype_resolver_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_ctype_resolver_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValadocCTypeResolverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_ctype_resolver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocCTypeResolver), 0, (GInstanceInitFunc) valadoc_ctype_resolver_instance_init, NULL };
		GType valadoc_ctype_resolver_type_id;
		valadoc_ctype_resolver_type_id = g_type_register_static (VALADOC_API_TYPE_VISITOR, "ValadocCTypeResolver", &g_define_type_info, 0);
		g_once_init_leave (&valadoc_ctype_resolver_type_id__volatile, valadoc_ctype_resolver_type_id);
	}
	return valadoc_ctype_resolver_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



