/* valainitializerlist.c generated by valac, the Vala compiler
 * generated from valainitializerlist.vala, do not modify */

/* valainitializerlist.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

struct _ValaInitializerListPrivate {
	ValaList* initializers;
};


static gpointer vala_initializer_list_parent_class = NULL;

#define VALA_INITIALIZER_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_INITIALIZER_LIST, ValaInitializerListPrivate))
static void vala_initializer_list_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_initializer_list_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_initializer_list_real_is_constant (ValaExpression* base);
static gboolean vala_initializer_list_real_is_pure (ValaExpression* base);
static gboolean vala_initializer_list_real_is_accessible (ValaExpression* base, ValaSymbol* sym);
static void vala_initializer_list_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static gboolean vala_initializer_list_real_check (ValaCodeNode* base, ValaCodeContext* context);
static void vala_initializer_list_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen);
static void vala_initializer_list_real_get_used_variables (ValaCodeNode* base, ValaCollection* collection);
static void vala_initializer_list_finalize (ValaCodeNode * obj);


/**
 * Appends the specified expression to this initializer 
 *
 * @param expr an expression
 */
void vala_initializer_list_append (ValaInitializerList* self, ValaExpression* expr) {
	ValaList* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (expr != NULL);
	_tmp0_ = self->priv->initializers;
	_tmp1_ = expr;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = expr;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the expression 
 *
 * @return expression list
 */
static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vala_initializer_list_get_initializers (ValaInitializerList* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->initializers;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Creates a new initializer 
 *
 * @param source_reference reference to source code
 * @return                 newly created initializer list
 */
ValaInitializerList* vala_initializer_list_construct (GType object_type, ValaSourceReference* source_reference) {
	ValaInitializerList* self = NULL;
	ValaSourceReference* _tmp0_;
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaInitializerList*) vala_expression_construct (object_type);
	_tmp0_ = source_reference;
	vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp0_);
	return self;
}


ValaInitializerList* vala_initializer_list_new (ValaSourceReference* source_reference) {
	return vala_initializer_list_construct (VALA_TYPE_INITIALIZER_LIST, source_reference);
}


static void vala_initializer_list_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _expr_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _expr_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_expr_list = _tmp1_;
		_tmp2_ = _expr_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_expr_size = _tmp4_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* expr = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			ValaCodeVisitor* _tmp12_;
			_tmp5_ = _expr_index;
			_expr_index = _tmp5_ + 1;
			_tmp6_ = _expr_index;
			_tmp7_ = _expr_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _expr_list;
			_tmp9_ = _expr_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			expr = (ValaExpression*) _tmp10_;
			_tmp11_ = expr;
			_tmp12_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, _tmp12_);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
}


static void vala_initializer_list_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaInitializerList * self;
	ValaCodeVisitor* _tmp0_;
	ValaCodeVisitor* _tmp1_;
	self = (ValaInitializerList*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_initializer_list (_tmp0_, self);
	_tmp1_ = visitor;
	vala_code_visitor_visit_expression (_tmp1_, (ValaExpression*) self);
}


static gboolean vala_initializer_list_real_is_constant (ValaExpression* base) {
	ValaInitializerList * self;
	gboolean result = FALSE;
	self = (ValaInitializerList*) base;
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _initializer_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _initializer_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_initializer_list = _tmp1_;
		_tmp2_ = _initializer_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_initializer_size = _tmp4_;
		_initializer_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* initializer = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			gboolean _tmp12_;
			_tmp5_ = _initializer_index;
			_initializer_index = _tmp5_ + 1;
			_tmp6_ = _initializer_index;
			_tmp7_ = _initializer_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _initializer_list;
			_tmp9_ = _initializer_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			initializer = (ValaExpression*) _tmp10_;
			_tmp11_ = initializer;
			_tmp12_ = vala_expression_is_constant (_tmp11_);
			if (!_tmp12_) {
				result = FALSE;
				_vala_code_node_unref0 (initializer);
				_vala_iterable_unref0 (_initializer_list);
				return result;
			}
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	result = TRUE;
	return result;
}


static gboolean vala_initializer_list_real_is_pure (ValaExpression* base) {
	ValaInitializerList * self;
	gboolean result = FALSE;
	self = (ValaInitializerList*) base;
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _initializer_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _initializer_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_initializer_list = _tmp1_;
		_tmp2_ = _initializer_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_initializer_size = _tmp4_;
		_initializer_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* initializer = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			gboolean _tmp12_;
			_tmp5_ = _initializer_index;
			_initializer_index = _tmp5_ + 1;
			_tmp6_ = _initializer_index;
			_tmp7_ = _initializer_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _initializer_list;
			_tmp9_ = _initializer_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			initializer = (ValaExpression*) _tmp10_;
			_tmp11_ = initializer;
			_tmp12_ = vala_expression_is_pure (_tmp11_);
			if (!_tmp12_) {
				result = FALSE;
				_vala_code_node_unref0 (initializer);
				_vala_iterable_unref0 (_initializer_list);
				return result;
			}
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	result = TRUE;
	return result;
}


static gboolean vala_initializer_list_real_is_accessible (ValaExpression* base, ValaSymbol* sym) {
	ValaInitializerList * self;
	gboolean result = FALSE;
	self = (ValaInitializerList*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _initializer_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _initializer_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_initializer_list = _tmp1_;
		_tmp2_ = _initializer_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_initializer_size = _tmp4_;
		_initializer_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* initializer = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			ValaSymbol* _tmp12_;
			gboolean _tmp13_;
			_tmp5_ = _initializer_index;
			_initializer_index = _tmp5_ + 1;
			_tmp6_ = _initializer_index;
			_tmp7_ = _initializer_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _initializer_list;
			_tmp9_ = _initializer_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			initializer = (ValaExpression*) _tmp10_;
			_tmp11_ = initializer;
			_tmp12_ = sym;
			_tmp13_ = vala_expression_is_accessible (_tmp11_, _tmp12_);
			if (!_tmp13_) {
				result = FALSE;
				_vala_code_node_unref0 (initializer);
				_vala_iterable_unref0 (_initializer_list);
				return result;
			}
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	result = TRUE;
	return result;
}


static void vala_initializer_list_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ValaList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				ValaList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				ValaExpression* _tmp9_;
				ValaExpression* _tmp10_;
				gboolean _tmp11_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->initializers;
				_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->initializers;
				_tmp7_ = i;
				_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
				_tmp9_ = (ValaExpression*) _tmp8_;
				_tmp10_ = old_node;
				_tmp11_ = _tmp9_ == _tmp10_;
				_vala_code_node_unref0 (_tmp9_);
				if (_tmp11_) {
					ValaList* _tmp12_;
					gint _tmp13_;
					ValaExpression* _tmp14_;
					_tmp12_ = self->priv->initializers;
					_tmp13_ = i;
					_tmp14_ = new_node;
					vala_list_set (_tmp12_, _tmp13_, _tmp14_);
				}
			}
		}
	}
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean vala_initializer_list_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaInitializerList * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	gboolean _error_ = FALSE;
	gboolean _tmp215_;
	gboolean _tmp222_;
	self = (ValaInitializerList*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp7_ = _tmp6_;
		vala_report_error (_tmp7_, "initializer list used for unknown type");
		result = FALSE;
		return result;
	} else {
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp8_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp9_ = _tmp8_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_ARRAY_TYPE)) {
			ValaArrayType* array_type = NULL;
			ValaDataType* _tmp10_;
			ValaDataType* _tmp11_;
			ValaArrayType* _tmp12_;
			gboolean requires_constants_only = FALSE;
			ValaCodeNode* node = NULL;
			ValaCodeNode* _tmp13_;
			ValaCodeNode* _tmp14_;
			gboolean _tmp20_ = FALSE;
			gboolean _tmp21_ = FALSE;
			ValaCodeNode* _tmp22_;
			ValaCodeNode* _tmp23_;
			ValaDataType* inner_target_type = NULL;
			ValaArrayType* _tmp57_;
			gint _tmp58_;
			gint _tmp59_;
			_tmp10_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp11_ = _tmp10_;
			_tmp12_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
			array_type = _tmp12_;
			requires_constants_only = FALSE;
			_tmp13_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp14_ = _tmp13_;
			node = _tmp14_;
			while (TRUE) {
				ValaCodeNode* _tmp15_;
				ValaCodeNode* _tmp16_;
				ValaCodeNode* _tmp17_;
				ValaCodeNode* _tmp18_;
				ValaCodeNode* _tmp19_;
				_tmp15_ = node;
				if (!(_tmp15_ != NULL)) {
					break;
				}
				_tmp16_ = node;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_CONSTANT)) {
					requires_constants_only = TRUE;
					break;
				}
				_tmp17_ = node;
				_tmp18_ = vala_code_node_get_parent_node (_tmp17_);
				_tmp19_ = _tmp18_;
				node = _tmp19_;
			}
			_tmp22_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp23_ = _tmp22_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, VALA_TYPE_ARRAY_CREATION_EXPRESSION)) {
				gboolean _tmp24_;
				_tmp24_ = requires_constants_only;
				_tmp21_ = !_tmp24_;
			} else {
				_tmp21_ = FALSE;
			}
			if (_tmp21_) {
				gboolean _tmp25_ = FALSE;
				ValaCodeNode* _tmp26_;
				ValaCodeNode* _tmp27_;
				_tmp26_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp27_ = _tmp26_;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, VALA_TYPE_INITIALIZER_LIST)) {
					_tmp25_ = TRUE;
				} else {
					ValaCodeNode* _tmp28_;
					ValaCodeNode* _tmp29_;
					ValaDataType* _tmp30_;
					ValaDataType* _tmp31_;
					ValaTypeSymbol* _tmp32_;
					ValaTypeSymbol* _tmp33_;
					_tmp28_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp29_ = _tmp28_;
					_tmp30_ = vala_expression_get_target_type ((ValaExpression*) G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
					_tmp31_ = _tmp30_;
					_tmp32_ = vala_data_type_get_data_type (_tmp31_);
					_tmp33_ = _tmp32_;
					_tmp25_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, VALA_TYPE_STRUCT);
				}
				_tmp20_ = _tmp25_;
			} else {
				_tmp20_ = FALSE;
			}
			if (_tmp20_) {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp34_;
				ValaCodeNode* _tmp35_;
				ValaCodeNode* _tmp36_;
				ValaArrayCreationExpression* array_creation = NULL;
				ValaArrayType* _tmp37_;
				ValaDataType* _tmp38_;
				ValaDataType* _tmp39_;
				ValaDataType* _tmp40_;
				ValaDataType* _tmp41_;
				ValaArrayType* _tmp42_;
				gint _tmp43_;
				gint _tmp44_;
				ValaSourceReference* _tmp45_;
				ValaSourceReference* _tmp46_;
				ValaArrayCreationExpression* _tmp47_;
				ValaArrayCreationExpression* _tmp48_;
				ValaArrayCreationExpression* _tmp49_;
				ValaDataType* _tmp50_;
				ValaDataType* _tmp51_;
				ValaCodeNode* _tmp52_;
				ValaArrayCreationExpression* _tmp53_;
				ValaArrayCreationExpression* _tmp54_;
				ValaCodeContext* _tmp55_;
				gboolean _tmp56_;
				_tmp34_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp35_ = _tmp34_;
				_tmp36_ = _vala_code_node_ref0 (_tmp35_);
				old_parent_node = _tmp36_;
				_tmp37_ = array_type;
				_tmp38_ = vala_array_type_get_element_type (_tmp37_);
				_tmp39_ = _tmp38_;
				_tmp40_ = vala_data_type_copy (_tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = array_type;
				_tmp43_ = vala_array_type_get_rank (_tmp42_);
				_tmp44_ = _tmp43_;
				_tmp45_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp46_ = _tmp45_;
				_tmp47_ = vala_array_creation_expression_new (_tmp41_, _tmp44_, self, _tmp46_);
				_tmp48_ = _tmp47_;
				_vala_code_node_unref0 (_tmp41_);
				array_creation = _tmp48_;
				_tmp49_ = array_creation;
				_tmp50_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp51_ = _tmp50_;
				vala_expression_set_target_type ((ValaExpression*) _tmp49_, _tmp51_);
				_tmp52_ = old_parent_node;
				_tmp53_ = array_creation;
				vala_code_node_replace_expression (_tmp52_, (ValaExpression*) self, (ValaExpression*) _tmp53_);
				vala_code_node_set_checked ((ValaCodeNode*) self, FALSE);
				_tmp54_ = array_creation;
				_tmp55_ = context;
				_tmp56_ = vala_code_node_check ((ValaCodeNode*) _tmp54_, _tmp55_);
				result = _tmp56_;
				_vala_code_node_unref0 (array_creation);
				_vala_code_node_unref0 (old_parent_node);
				_vala_code_node_unref0 (array_type);
				return result;
			}
			_tmp57_ = array_type;
			_tmp58_ = vala_array_type_get_rank (_tmp57_);
			_tmp59_ = _tmp58_;
			if (_tmp59_ > 1) {
				ValaArrayType* inner_array_type = NULL;
				ValaArrayType* _tmp60_;
				ValaDataType* _tmp61_;
				ValaArrayType* _tmp62_;
				gint _tmp63_;
				gint _tmp64_;
				ValaArrayType* _tmp65_;
				ValaDataType* _tmp66_;
				_tmp60_ = array_type;
				_tmp61_ = vala_data_type_copy ((ValaDataType*) _tmp60_);
				inner_array_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
				_tmp62_ = inner_array_type;
				_tmp63_ = vala_array_type_get_rank (_tmp62_);
				_tmp64_ = _tmp63_;
				vala_array_type_set_rank (_tmp62_, _tmp64_ - 1);
				_tmp65_ = inner_array_type;
				_tmp66_ = _vala_code_node_ref0 ((ValaDataType*) _tmp65_);
				_vala_code_node_unref0 (inner_target_type);
				inner_target_type = _tmp66_;
				_vala_code_node_unref0 (inner_array_type);
			} else {
				ValaArrayType* _tmp67_;
				ValaDataType* _tmp68_;
				ValaDataType* _tmp69_;
				ValaDataType* _tmp70_;
				_tmp67_ = array_type;
				_tmp68_ = vala_array_type_get_element_type (_tmp67_);
				_tmp69_ = _tmp68_;
				_tmp70_ = vala_data_type_copy (_tmp69_);
				_vala_code_node_unref0 (inner_target_type);
				inner_target_type = _tmp70_;
			}
			{
				ValaList* _e_list = NULL;
				ValaList* _tmp71_;
				gint _e_size = 0;
				ValaList* _tmp72_;
				gint _tmp73_;
				gint _tmp74_;
				gint _e_index = 0;
				_tmp71_ = vala_initializer_list_get_initializers (self);
				_e_list = _tmp71_;
				_tmp72_ = _e_list;
				_tmp73_ = vala_collection_get_size ((ValaCollection*) _tmp72_);
				_tmp74_ = _tmp73_;
				_e_size = _tmp74_;
				_e_index = -1;
				while (TRUE) {
					gint _tmp75_;
					gint _tmp76_;
					gint _tmp77_;
					ValaExpression* e = NULL;
					ValaList* _tmp78_;
					gint _tmp79_;
					gpointer _tmp80_;
					ValaExpression* _tmp81_;
					ValaDataType* _tmp82_;
					_tmp75_ = _e_index;
					_e_index = _tmp75_ + 1;
					_tmp76_ = _e_index;
					_tmp77_ = _e_size;
					if (!(_tmp76_ < _tmp77_)) {
						break;
					}
					_tmp78_ = _e_list;
					_tmp79_ = _e_index;
					_tmp80_ = vala_list_get (_tmp78_, _tmp79_);
					e = (ValaExpression*) _tmp80_;
					_tmp81_ = e;
					_tmp82_ = inner_target_type;
					vala_expression_set_target_type (_tmp81_, _tmp82_);
					_vala_code_node_unref0 (e);
				}
				_vala_iterable_unref0 (_e_list);
			}
			_vala_code_node_unref0 (inner_target_type);
			_vala_code_node_unref0 (array_type);
		} else {
			ValaDataType* _tmp83_;
			ValaDataType* _tmp84_;
			ValaTypeSymbol* _tmp85_;
			ValaTypeSymbol* _tmp86_;
			_tmp83_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp84_ = _tmp83_;
			_tmp85_ = vala_data_type_get_data_type (_tmp84_);
			_tmp86_ = _tmp85_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp86_, VALA_TYPE_STRUCT)) {
				ValaStruct* st = NULL;
				ValaDataType* _tmp87_;
				ValaDataType* _tmp88_;
				ValaTypeSymbol* _tmp89_;
				ValaTypeSymbol* _tmp90_;
				ValaStruct* _tmp91_;
				ValaIterator* field_it = NULL;
				ValaStruct* _tmp99_;
				ValaList* _tmp100_;
				ValaList* _tmp101_;
				ValaIterator* _tmp102_;
				ValaIterator* _tmp103_;
				_tmp87_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp88_ = _tmp87_;
				_tmp89_ = vala_data_type_get_data_type (_tmp88_);
				_tmp90_ = _tmp89_;
				_tmp91_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_STRUCT, ValaStruct));
				st = _tmp91_;
				while (TRUE) {
					ValaStruct* _tmp92_;
					ValaStruct* _tmp93_;
					ValaStruct* _tmp94_;
					ValaStruct* _tmp95_;
					ValaStruct* _tmp96_;
					ValaStruct* _tmp97_;
					ValaStruct* _tmp98_;
					_tmp92_ = st;
					_tmp93_ = vala_struct_get_base_struct (_tmp92_);
					_tmp94_ = _tmp93_;
					if (!(_tmp94_ != NULL)) {
						break;
					}
					_tmp95_ = st;
					_tmp96_ = vala_struct_get_base_struct (_tmp95_);
					_tmp97_ = _tmp96_;
					_tmp98_ = _vala_code_node_ref0 (_tmp97_);
					_vala_code_node_unref0 (st);
					st = _tmp98_;
				}
				_tmp99_ = st;
				_tmp100_ = vala_struct_get_fields (_tmp99_);
				_tmp101_ = _tmp100_;
				_tmp102_ = vala_iterable_iterator ((ValaIterable*) _tmp101_);
				_tmp103_ = _tmp102_;
				_vala_iterable_unref0 (_tmp101_);
				field_it = _tmp103_;
				{
					ValaList* _e_list = NULL;
					ValaList* _tmp104_;
					gint _e_size = 0;
					ValaList* _tmp105_;
					gint _tmp106_;
					gint _tmp107_;
					gint _e_index = 0;
					_tmp104_ = vala_initializer_list_get_initializers (self);
					_e_list = _tmp104_;
					_tmp105_ = _e_list;
					_tmp106_ = vala_collection_get_size ((ValaCollection*) _tmp105_);
					_tmp107_ = _tmp106_;
					_e_size = _tmp107_;
					_e_index = -1;
					while (TRUE) {
						gint _tmp108_;
						gint _tmp109_;
						gint _tmp110_;
						ValaExpression* e = NULL;
						ValaList* _tmp111_;
						gint _tmp112_;
						gpointer _tmp113_;
						ValaField* field = NULL;
						ValaExpression* _tmp131_;
						ValaField* _tmp132_;
						ValaDataType* _tmp133_;
						ValaDataType* _tmp134_;
						ValaDataType* _tmp135_;
						ValaDataType* _tmp136_;
						ValaDataType* _tmp137_;
						ValaDataType* _tmp138_;
						gboolean _tmp139_;
						gboolean _tmp140_;
						_tmp108_ = _e_index;
						_e_index = _tmp108_ + 1;
						_tmp109_ = _e_index;
						_tmp110_ = _e_size;
						if (!(_tmp109_ < _tmp110_)) {
							break;
						}
						_tmp111_ = _e_list;
						_tmp112_ = _e_index;
						_tmp113_ = vala_list_get (_tmp111_, _tmp112_);
						e = (ValaExpression*) _tmp113_;
						field = NULL;
						while (TRUE) {
							ValaField* _tmp114_;
							ValaIterator* _tmp115_;
							gboolean _tmp116_;
							ValaIterator* _tmp126_;
							gpointer _tmp127_;
							ValaField* _tmp128_;
							ValaMemberBinding _tmp129_;
							ValaMemberBinding _tmp130_;
							_tmp114_ = field;
							if (!(_tmp114_ == NULL)) {
								break;
							}
							_tmp115_ = field_it;
							_tmp116_ = vala_iterator_next (_tmp115_);
							if (!_tmp116_) {
								ValaExpression* _tmp117_;
								ValaSourceReference* _tmp118_;
								ValaSourceReference* _tmp119_;
								ValaDataType* _tmp120_;
								ValaDataType* _tmp121_;
								gchar* _tmp122_;
								gchar* _tmp123_;
								gchar* _tmp124_;
								gchar* _tmp125_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp117_ = e;
								_tmp118_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp117_);
								_tmp119_ = _tmp118_;
								_tmp120_ = vala_expression_get_target_type ((ValaExpression*) self);
								_tmp121_ = _tmp120_;
								_tmp122_ = vala_code_node_to_string ((ValaCodeNode*) _tmp121_);
								_tmp123_ = _tmp122_;
								_tmp124_ = g_strdup_printf ("too many expressions in initializer list for `%s'", _tmp123_);
								_tmp125_ = _tmp124_;
								vala_report_error (_tmp119_, _tmp125_);
								_g_free0 (_tmp125_);
								_g_free0 (_tmp123_);
								result = FALSE;
								_vala_code_node_unref0 (field);
								_vala_code_node_unref0 (e);
								_vala_iterable_unref0 (_e_list);
								_vala_iterator_unref0 (field_it);
								_vala_code_node_unref0 (st);
								return result;
							}
							_tmp126_ = field_it;
							_tmp127_ = vala_iterator_get (_tmp126_);
							_vala_code_node_unref0 (field);
							field = (ValaField*) _tmp127_;
							_tmp128_ = field;
							_tmp129_ = vala_field_get_binding (_tmp128_);
							_tmp130_ = _tmp129_;
							if (_tmp130_ != VALA_MEMBER_BINDING_INSTANCE) {
								_vala_code_node_unref0 (field);
								field = NULL;
							}
						}
						_tmp131_ = e;
						_tmp132_ = field;
						_tmp133_ = vala_variable_get_variable_type ((ValaVariable*) _tmp132_);
						_tmp134_ = _tmp133_;
						_tmp135_ = vala_data_type_copy (_tmp134_);
						_tmp136_ = _tmp135_;
						vala_expression_set_target_type (_tmp131_, _tmp136_);
						_vala_code_node_unref0 (_tmp136_);
						_tmp137_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp138_ = _tmp137_;
						_tmp139_ = vala_data_type_get_value_owned (_tmp138_);
						_tmp140_ = _tmp139_;
						if (!_tmp140_) {
							ValaExpression* _tmp141_;
							ValaDataType* _tmp142_;
							ValaDataType* _tmp143_;
							_tmp141_ = e;
							_tmp142_ = vala_expression_get_target_type (_tmp141_);
							_tmp143_ = _tmp142_;
							vala_data_type_set_value_owned (_tmp143_, FALSE);
						}
						_vala_code_node_unref0 (field);
						_vala_code_node_unref0 (e);
					}
					_vala_iterable_unref0 (_e_list);
				}
				_vala_iterator_unref0 (field_it);
				_vala_code_node_unref0 (st);
			} else {
				ValaSourceReference* _tmp144_;
				ValaSourceReference* _tmp145_;
				ValaDataType* _tmp146_;
				ValaDataType* _tmp147_;
				gchar* _tmp148_;
				gchar* _tmp149_;
				gchar* _tmp150_;
				gchar* _tmp151_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp144_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp145_ = _tmp144_;
				_tmp146_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp147_ = _tmp146_;
				_tmp148_ = vala_code_node_to_string ((ValaCodeNode*) _tmp147_);
				_tmp149_ = _tmp148_;
				_tmp150_ = g_strdup_printf ("initializer list used for `%s', which is neither array nor struct", _tmp149_);
				_tmp151_ = _tmp150_;
				vala_report_error (_tmp145_, _tmp151_);
				_g_free0 (_tmp151_);
				_g_free0 (_tmp149_);
				result = FALSE;
				return result;
			}
		}
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp152_;
		ValaList* _tmp153_;
		gint _expr_size = 0;
		ValaList* _tmp154_;
		gint _tmp155_;
		gint _tmp156_;
		gint _expr_index = 0;
		_tmp152_ = self->priv->initializers;
		_tmp153_ = _vala_iterable_ref0 (_tmp152_);
		_expr_list = _tmp153_;
		_tmp154_ = _expr_list;
		_tmp155_ = vala_collection_get_size ((ValaCollection*) _tmp154_);
		_tmp156_ = _tmp155_;
		_expr_size = _tmp156_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp157_;
			gint _tmp158_;
			gint _tmp159_;
			ValaExpression* expr = NULL;
			ValaList* _tmp160_;
			gint _tmp161_;
			gpointer _tmp162_;
			ValaExpression* _tmp163_;
			ValaCodeContext* _tmp164_;
			_tmp157_ = _expr_index;
			_expr_index = _tmp157_ + 1;
			_tmp158_ = _expr_index;
			_tmp159_ = _expr_size;
			if (!(_tmp158_ < _tmp159_)) {
				break;
			}
			_tmp160_ = _expr_list;
			_tmp161_ = _expr_index;
			_tmp162_ = vala_list_get (_tmp160_, _tmp161_);
			expr = (ValaExpression*) _tmp162_;
			_tmp163_ = expr;
			_tmp164_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp163_, _tmp164_);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	_error_ = FALSE;
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp165_;
		gint _e_size = 0;
		ValaList* _tmp166_;
		gint _tmp167_;
		gint _tmp168_;
		gint _e_index = 0;
		_tmp165_ = vala_initializer_list_get_initializers (self);
		_e_list = _tmp165_;
		_tmp166_ = _e_list;
		_tmp167_ = vala_collection_get_size ((ValaCollection*) _tmp166_);
		_tmp168_ = _tmp167_;
		_e_size = _tmp168_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp169_;
			gint _tmp170_;
			gint _tmp171_;
			ValaExpression* e = NULL;
			ValaList* _tmp172_;
			gint _tmp173_;
			gpointer _tmp174_;
			ValaExpression* _tmp175_;
			ValaDataType* _tmp176_;
			ValaDataType* _tmp177_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp181_;
			ValaUnaryExpression* _tmp182_;
			gboolean _tmp183_ = FALSE;
			ValaUnaryExpression* _tmp184_;
			_tmp169_ = _e_index;
			_e_index = _tmp169_ + 1;
			_tmp170_ = _e_index;
			_tmp171_ = _e_size;
			if (!(_tmp170_ < _tmp171_)) {
				break;
			}
			_tmp172_ = _e_list;
			_tmp173_ = _e_index;
			_tmp174_ = vala_list_get (_tmp172_, _tmp173_);
			e = (ValaExpression*) _tmp174_;
			_tmp175_ = e;
			_tmp176_ = vala_expression_get_value_type (_tmp175_);
			_tmp177_ = _tmp176_;
			if (_tmp177_ == NULL) {
				ValaExpression* _tmp178_;
				ValaSourceReference* _tmp179_;
				ValaSourceReference* _tmp180_;
				_error_ = TRUE;
				_tmp178_ = e;
				_tmp179_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp178_);
				_tmp180_ = _tmp179_;
				vala_report_error (_tmp180_, "expression type not allowed as initializer");
				_vala_code_node_unref0 (e);
				continue;
			}
			_tmp181_ = e;
			_tmp182_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp181_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp181_) : NULL);
			unary = _tmp182_;
			_tmp184_ = unary;
			if (_tmp184_ != NULL) {
				gboolean _tmp185_ = FALSE;
				ValaUnaryExpression* _tmp186_;
				ValaUnaryOperator _tmp187_;
				ValaUnaryOperator _tmp188_;
				_tmp186_ = unary;
				_tmp187_ = vala_unary_expression_get_operator (_tmp186_);
				_tmp188_ = _tmp187_;
				if (_tmp188_ == VALA_UNARY_OPERATOR_REF) {
					_tmp185_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp189_;
					ValaUnaryOperator _tmp190_;
					ValaUnaryOperator _tmp191_;
					_tmp189_ = unary;
					_tmp190_ = vala_unary_expression_get_operator (_tmp189_);
					_tmp191_ = _tmp190_;
					_tmp185_ = _tmp191_ == VALA_UNARY_OPERATOR_OUT;
				}
				_tmp183_ = _tmp185_;
			} else {
				_tmp183_ = FALSE;
			}
			if (_tmp183_) {
			} else {
				ValaExpression* _tmp192_;
				ValaDataType* _tmp193_;
				ValaDataType* _tmp194_;
				ValaExpression* _tmp195_;
				ValaDataType* _tmp196_;
				ValaDataType* _tmp197_;
				gboolean _tmp198_;
				_tmp192_ = e;
				_tmp193_ = vala_expression_get_value_type (_tmp192_);
				_tmp194_ = _tmp193_;
				_tmp195_ = e;
				_tmp196_ = vala_expression_get_target_type (_tmp195_);
				_tmp197_ = _tmp196_;
				_tmp198_ = vala_data_type_compatible (_tmp194_, _tmp197_);
				if (!_tmp198_) {
					ValaExpression* _tmp199_;
					ValaExpression* _tmp200_;
					ValaSourceReference* _tmp201_;
					ValaSourceReference* _tmp202_;
					ValaExpression* _tmp203_;
					ValaDataType* _tmp204_;
					ValaDataType* _tmp205_;
					gchar* _tmp206_;
					gchar* _tmp207_;
					ValaExpression* _tmp208_;
					ValaDataType* _tmp209_;
					ValaDataType* _tmp210_;
					gchar* _tmp211_;
					gchar* _tmp212_;
					gchar* _tmp213_;
					gchar* _tmp214_;
					_error_ = TRUE;
					_tmp199_ = e;
					vala_code_node_set_error ((ValaCodeNode*) _tmp199_, TRUE);
					_tmp200_ = e;
					_tmp201_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp200_);
					_tmp202_ = _tmp201_;
					_tmp203_ = e;
					_tmp204_ = vala_expression_get_target_type (_tmp203_);
					_tmp205_ = _tmp204_;
					_tmp206_ = vala_code_node_to_string ((ValaCodeNode*) _tmp205_);
					_tmp207_ = _tmp206_;
					_tmp208_ = e;
					_tmp209_ = vala_expression_get_value_type (_tmp208_);
					_tmp210_ = _tmp209_;
					_tmp211_ = vala_code_node_to_string ((ValaCodeNode*) _tmp210_);
					_tmp212_ = _tmp211_;
					_tmp213_ = g_strdup_printf ("Expected initializer of type `%s' but got `%s'", _tmp207_, _tmp212_);
					_tmp214_ = _tmp213_;
					vala_report_error (_tmp202_, _tmp214_);
					_g_free0 (_tmp214_);
					_g_free0 (_tmp212_);
					_g_free0 (_tmp207_);
				}
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp215_ = _error_;
	if (!_tmp215_) {
		ValaDataType* _tmp216_;
		ValaDataType* _tmp217_;
		ValaDataType* _tmp218_;
		ValaDataType* _tmp219_;
		ValaDataType* _tmp220_;
		ValaDataType* _tmp221_;
		_tmp216_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp217_ = _tmp216_;
		_tmp218_ = vala_data_type_copy (_tmp217_);
		_tmp219_ = _tmp218_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp219_);
		_vala_code_node_unref0 (_tmp219_);
		_tmp220_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp221_ = _tmp220_;
		vala_data_type_set_nullable (_tmp221_, FALSE);
	}
	_tmp222_ = _error_;
	result = !_tmp222_;
	return result;
}


static void vala_initializer_list_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen) {
	ValaInitializerList * self;
	ValaCodeGenerator* _tmp13_;
	ValaCodeGenerator* _tmp14_;
	self = (ValaInitializerList*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _expr_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _expr_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_expr_list = _tmp1_;
		_tmp2_ = _expr_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_expr_size = _tmp4_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* expr = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			ValaCodeGenerator* _tmp12_;
			_tmp5_ = _expr_index;
			_expr_index = _tmp5_ + 1;
			_tmp6_ = _expr_index;
			_tmp7_ = _expr_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _expr_list;
			_tmp9_ = _expr_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			expr = (ValaExpression*) _tmp10_;
			_tmp11_ = expr;
			_tmp12_ = codegen;
			vala_code_node_emit ((ValaCodeNode*) _tmp11_, _tmp12_);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	_tmp13_ = codegen;
	vala_code_visitor_visit_initializer_list ((ValaCodeVisitor*) _tmp13_, self);
	_tmp14_ = codegen;
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) _tmp14_, (ValaExpression*) self);
}


static void vala_initializer_list_real_get_used_variables (ValaCodeNode* base, ValaCollection* collection) {
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _expr_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _expr_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_expr_list = _tmp1_;
		_tmp2_ = _expr_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_expr_size = _tmp4_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* expr = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			ValaCollection* _tmp12_;
			_tmp5_ = _expr_index;
			_expr_index = _tmp5_ + 1;
			_tmp6_ = _expr_index;
			_tmp7_ = _expr_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _expr_list;
			_tmp9_ = _expr_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			expr = (ValaExpression*) _tmp10_;
			_tmp11_ = expr;
			_tmp12_ = collection;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp11_, _tmp12_);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
}


gint vala_initializer_list_get_size (ValaInitializerList* self) {
	gint result;
	ValaList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->initializers;
	_tmp1_ = vala_collection_get_size ((ValaCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static void vala_initializer_list_class_init (ValaInitializerListClass * klass) {
	vala_initializer_list_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_initializer_list_finalize;
	g_type_class_add_private (klass, sizeof (ValaInitializerListPrivate));
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_initializer_list_real_accept_children;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_initializer_list_real_accept;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression *)) vala_initializer_list_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression *)) vala_initializer_list_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression *, ValaSymbol*)) vala_initializer_list_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_initializer_list_real_replace_expression;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_initializer_list_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_initializer_list_real_emit;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_initializer_list_real_get_used_variables;
}


static void vala_initializer_list_instance_init (ValaInitializerList * self) {
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_INITIALIZER_LIST_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->initializers = (ValaList*) _tmp1_;
}


static void vala_initializer_list_finalize (ValaCodeNode * obj) {
	ValaInitializerList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList);
	_vala_iterable_unref0 (self->priv->initializers);
	VALA_CODE_NODE_CLASS (vala_initializer_list_parent_class)->finalize (obj);
}


/**
 * Represents an array or struct initializer list in the source code.
 */
GType vala_initializer_list_get_type (void) {
	static volatile gsize vala_initializer_list_type_id__volatile = 0;
	if (g_once_init_enter (&vala_initializer_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaInitializerListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_initializer_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInitializerList), 0, (GInstanceInitFunc) vala_initializer_list_instance_init, NULL };
		GType vala_initializer_list_type_id;
		vala_initializer_list_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaInitializerList", &g_define_type_info, 0);
		g_once_init_leave (&vala_initializer_list_type_id__volatile, vala_initializer_list_type_id);
	}
	return vala_initializer_list_type_id__volatile;
}



