/* valagirwriter.c generated by valac, the Vala compiler
 * generated from valagirwriter.vala, do not modify */

/* valagirwriter.vala
 *
 * Copyright (C) 2008-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "valacodegen.h"
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <valagee.h>
#include <glib/gstdio.h>


#define VALA_GIR_WRITER_TYPE_GIR_NAMESPACE (vala_gir_writer_gir_namespace_get_type ())
typedef struct _ValaGIRWriterGIRNamespace ValaGIRWriterGIRNamespace;
enum  {
	VALA_GIR_WRITER_DUMMY_PROPERTY,
	VALA_GIR_WRITER_LAST_PROPERTY
};
static GParamSpec* vala_gir_writer_properties[VALA_GIR_WRITER_LAST_PROPERTY];
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_gir_writer_gir_namespace_free0(var) ((var == NULL) ? NULL : (var = (vala_gir_writer_gir_namespace_free (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ValaGIRWriterGIRNamespace {
	gchar* ns;
	gchar* version;
};

struct _ValaGIRWriterPrivate {
	ValaCodeContext* context;
	gchar* directory;
	gchar* gir_namespace;
	gchar* gir_version;
	gchar* gir_shared_library;
	GString* buffer;
	FILE* stream;
	ValaHashSet* unannotated_namespaces;
	ValaHashSet* our_namespaces;
	ValaArrayList* hierarchy;
	ValaArrayList* deferred;
	gint indent;
	ValaTypeSymbol* gobject_type;
	ValaTypeSymbol* ginitiallyunowned_type;
	ValaArrayList* externals;
	gint enum_value;
};


static gpointer vala_gir_writer_parent_class = NULL;

static GType vala_gir_writer_gir_namespace_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaGIRWriterGIRNamespace* vala_gir_writer_gir_namespace_dup (const ValaGIRWriterGIRNamespace* self);
static void vala_gir_writer_gir_namespace_free (ValaGIRWriterGIRNamespace* self);
static void vala_gir_writer_gir_namespace_copy (const ValaGIRWriterGIRNamespace* self, ValaGIRWriterGIRNamespace* dest);
static void vala_gir_writer_gir_namespace_destroy (ValaGIRWriterGIRNamespace* self);
#define VALA_GIR_WRITER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_GIR_WRITER, ValaGIRWriterPrivate))
static gboolean vala_gir_writer_gir_namespace_equal (ValaGIRWriterGIRNamespace *self, ValaGIRWriterGIRNamespace* g);
static gchar* vala_gir_writer_real_get_interface_comment (ValaGIRWriter* self, ValaInterface* iface);
static gchar* vala_gir_writer_real_get_struct_comment (ValaGIRWriter* self, ValaStruct* st);
static gchar* vala_gir_writer_real_get_enum_comment (ValaGIRWriter* self, ValaEnum* en);
static gchar* vala_gir_writer_real_get_class_comment (ValaGIRWriter* self, ValaClass* c);
static gchar* vala_gir_writer_real_get_error_code_comment (ValaGIRWriter* self, ValaErrorCode* ecode);
static gchar* vala_gir_writer_real_get_enum_value_comment (ValaGIRWriter* self, ValaEnumValue* ev);
static gchar* vala_gir_writer_real_get_constant_comment (ValaGIRWriter* self, ValaConstant* c);
static gchar* vala_gir_writer_real_get_error_domain_comment (ValaGIRWriter* self, ValaErrorDomain* edomain);
static gchar* vala_gir_writer_real_get_field_comment (ValaGIRWriter* self, ValaField* f);
static gchar* vala_gir_writer_real_get_delegate_comment (ValaGIRWriter* self, ValaDelegate* cb);
static gchar* vala_gir_writer_real_get_method_comment (ValaGIRWriter* self, ValaMethod* m);
static gchar* vala_gir_writer_real_get_property_comment (ValaGIRWriter* self, ValaProperty* prop);
static gchar* vala_gir_writer_real_get_delegate_return_comment (ValaGIRWriter* self, ValaDelegate* cb);
static gchar* vala_gir_writer_real_get_signal_return_comment (ValaGIRWriter* self, ValaSignal* sig);
static gchar* vala_gir_writer_real_get_method_return_comment (ValaGIRWriter* self, ValaMethod* m);
static gchar* vala_gir_writer_real_get_signal_comment (ValaGIRWriter* self, ValaSignal* sig);
static gchar* vala_gir_writer_real_get_parameter_comment (ValaGIRWriter* self, ValaParameter* param);
static void vala_gir_writer_write_indent_stream (ValaGIRWriter* self);
static void vala_gir_writer_write_package (ValaGIRWriter* self, const gchar* package);
static void vala_gir_writer_write_doc (ValaGIRWriter* self, const gchar* comment);
static void vala_gir_writer_write_indent (ValaGIRWriter* self);
static void vala_gir_writer_write_c_includes (ValaGIRWriter* self, ValaNamespace* ns);
static void vala_gir_writer_write_c_include (ValaGIRWriter* self, const gchar* name);
static void vala_gir_writer_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns);
static void vala_gir_writer_write_annotations (ValaGIRWriter* self, ValaCodeNode* node);
static void vala_gir_writer_visit_deferred (ValaGIRWriter* self);
static void vala_gir_writer_write_symbol_attributes (ValaGIRWriter* self, ValaSymbol* symbol);
static void vala_gir_writer_real_visit_class (ValaCodeVisitor* base, ValaClass* cl);
static gboolean vala_gir_writer_check_accessibility (ValaGIRWriter* self, ValaSymbol* sym);
static gchar* vala_gir_writer_get_gir_name (ValaGIRWriter* self, ValaSymbol* symbol);
static void vala_gir_writer_write_gtype_attributes (ValaGIRWriter* self, ValaTypeSymbol* symbol);
static gchar* vala_gir_writer_gi_type_name (ValaGIRWriter* self, ValaTypeSymbol* type_symbol);
static void vala_gir_writer_write_ctype_attributes (ValaGIRWriter* self, ValaTypeSymbol* symbol, const gchar* suffix);
static void vala_gir_writer_do_write_signature (ValaGIRWriter* self, ValaMethod* m, const gchar* tag_name, gboolean instance, const gchar* name, const gchar* cname, ValaList* params, ValaDataType* return_type, gboolean can_fail, gboolean write_comment);
static void vala_gir_writer_write_signature (ValaGIRWriter* self, ValaMethod* m, const gchar* tag_name, gboolean write_doc, gboolean instance);
static void vala_gir_writer_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st);
static void vala_gir_writer_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface);
static void vala_gir_writer_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en);
static void vala_gir_writer_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev);
static gchar* vala_gir_writer_literal_expression_to_value_string (ValaGIRWriter* self, ValaExpression* literal);
static void vala_gir_writer_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* edomain);
static void vala_gir_writer_real_visit_error_code (ValaCodeVisitor* base, ValaErrorCode* ecode);
static void vala_gir_writer_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c);
static void vala_gir_writer_write_type (ValaGIRWriter* self, ValaDataType* type, gint index, ValaParameterDirection direction);
static void vala_gir_writer_real_visit_field (ValaCodeVisitor* base, ValaField* f);
static void vala_gir_writer_write_implicit_params (ValaGIRWriter* self, ValaDataType* type, gint* index, gboolean has_array_length, const gchar* name, ValaParameterDirection direction);
static void vala_gir_writer_write_param_or_return (ValaGIRWriter* self, ValaDataType* type, gboolean is_parameter, gint* index, gboolean has_array_length, const gchar* name, const gchar* comment, ValaParameterDirection direction, gboolean constructor, gboolean caller_allocates);
static void vala_gir_writer_skip_implicit_params (ValaGIRWriter* self, ValaDataType* type, gint* index, gboolean has_array_length);
static void vala_gir_writer_write_params_and_return (ValaGIRWriter* self, ValaList* params, ValaDataType* return_type, gboolean return_array_length, const gchar* return_comment, gboolean constructor, ValaDataType* instance_type, gboolean user_data);
static void vala_gir_writer_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* cb);
static void vala_gir_writer_real_visit_method (ValaCodeVisitor* base, ValaMethod* m);
static gboolean vala_gir_writer_check_signature (ValaGIRWriter* self, ValaMethod* m);
static gboolean vala_gir_writer_check_type (ValaGIRWriter* self, ValaDataType* type);
static void vala_gir_writer_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m);
static void vala_gir_writer_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop);
static void vala_gir_writer_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig);
static gchar* vala_gir_writer_camel_case_to_canonical (ValaGIRWriter* self, const gchar* name);
static gchar* vala_gir_writer_get_full_gir_name (ValaGIRWriter* self, ValaSymbol* sym);
static void vala_gir_writer_gir_namespace_init (ValaGIRWriterGIRNamespace *self, const gchar* ns, const gchar* version);
static void vala_gir_writer_finalize (ValaCodeVisitor * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gchar* vala_gir_writer_real_get_interface_comment (ValaGIRWriter* self, ValaInterface* iface) {
	gchar* result = NULL;
	g_return_val_if_fail (iface != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_interface_comment (ValaGIRWriter* self, ValaInterface* iface) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_interface_comment (self, iface);
}


static gchar* vala_gir_writer_real_get_struct_comment (ValaGIRWriter* self, ValaStruct* st) {
	gchar* result = NULL;
	g_return_val_if_fail (st != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_struct_comment (ValaGIRWriter* self, ValaStruct* st) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_struct_comment (self, st);
}


static gchar* vala_gir_writer_real_get_enum_comment (ValaGIRWriter* self, ValaEnum* en) {
	gchar* result = NULL;
	g_return_val_if_fail (en != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_enum_comment (ValaGIRWriter* self, ValaEnum* en) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_enum_comment (self, en);
}


static gchar* vala_gir_writer_real_get_class_comment (ValaGIRWriter* self, ValaClass* c) {
	gchar* result = NULL;
	g_return_val_if_fail (c != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_class_comment (ValaGIRWriter* self, ValaClass* c) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_class_comment (self, c);
}


static gchar* vala_gir_writer_real_get_error_code_comment (ValaGIRWriter* self, ValaErrorCode* ecode) {
	gchar* result = NULL;
	g_return_val_if_fail (ecode != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_error_code_comment (ValaGIRWriter* self, ValaErrorCode* ecode) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_error_code_comment (self, ecode);
}


static gchar* vala_gir_writer_real_get_enum_value_comment (ValaGIRWriter* self, ValaEnumValue* ev) {
	gchar* result = NULL;
	g_return_val_if_fail (ev != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_enum_value_comment (ValaGIRWriter* self, ValaEnumValue* ev) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_enum_value_comment (self, ev);
}


static gchar* vala_gir_writer_real_get_constant_comment (ValaGIRWriter* self, ValaConstant* c) {
	gchar* result = NULL;
	g_return_val_if_fail (c != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_constant_comment (ValaGIRWriter* self, ValaConstant* c) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_constant_comment (self, c);
}


static gchar* vala_gir_writer_real_get_error_domain_comment (ValaGIRWriter* self, ValaErrorDomain* edomain) {
	gchar* result = NULL;
	g_return_val_if_fail (edomain != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_error_domain_comment (ValaGIRWriter* self, ValaErrorDomain* edomain) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_error_domain_comment (self, edomain);
}


static gchar* vala_gir_writer_real_get_field_comment (ValaGIRWriter* self, ValaField* f) {
	gchar* result = NULL;
	g_return_val_if_fail (f != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_field_comment (ValaGIRWriter* self, ValaField* f) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_field_comment (self, f);
}


static gchar* vala_gir_writer_real_get_delegate_comment (ValaGIRWriter* self, ValaDelegate* cb) {
	gchar* result = NULL;
	g_return_val_if_fail (cb != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_delegate_comment (ValaGIRWriter* self, ValaDelegate* cb) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_delegate_comment (self, cb);
}


static gchar* vala_gir_writer_real_get_method_comment (ValaGIRWriter* self, ValaMethod* m) {
	gchar* result = NULL;
	g_return_val_if_fail (m != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_method_comment (ValaGIRWriter* self, ValaMethod* m) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_method_comment (self, m);
}


static gchar* vala_gir_writer_real_get_property_comment (ValaGIRWriter* self, ValaProperty* prop) {
	gchar* result = NULL;
	g_return_val_if_fail (prop != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_property_comment (ValaGIRWriter* self, ValaProperty* prop) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_property_comment (self, prop);
}


static gchar* vala_gir_writer_real_get_delegate_return_comment (ValaGIRWriter* self, ValaDelegate* cb) {
	gchar* result = NULL;
	g_return_val_if_fail (cb != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_delegate_return_comment (ValaGIRWriter* self, ValaDelegate* cb) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_delegate_return_comment (self, cb);
}


static gchar* vala_gir_writer_real_get_signal_return_comment (ValaGIRWriter* self, ValaSignal* sig) {
	gchar* result = NULL;
	g_return_val_if_fail (sig != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_signal_return_comment (ValaGIRWriter* self, ValaSignal* sig) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_signal_return_comment (self, sig);
}


static gchar* vala_gir_writer_real_get_method_return_comment (ValaGIRWriter* self, ValaMethod* m) {
	gchar* result = NULL;
	g_return_val_if_fail (m != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_method_return_comment (ValaGIRWriter* self, ValaMethod* m) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_method_return_comment (self, m);
}


static gchar* vala_gir_writer_real_get_signal_comment (ValaGIRWriter* self, ValaSignal* sig) {
	gchar* result = NULL;
	g_return_val_if_fail (sig != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_signal_comment (ValaGIRWriter* self, ValaSignal* sig) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_signal_comment (self, sig);
}


static gchar* vala_gir_writer_real_get_parameter_comment (ValaGIRWriter* self, ValaParameter* param) {
	gchar* result = NULL;
	g_return_val_if_fail (param != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_parameter_comment (ValaGIRWriter* self, ValaParameter* param) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_parameter_comment (self, param);
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


void vala_gir_writer_write_includes (ValaGIRWriter* self) {
	g_return_if_fail (self != NULL);
	{
		ValaArrayList* _i_list = NULL;
		ValaArrayList* _tmp0_;
		ValaArrayList* _tmp1_;
		gint _i_size = 0;
		ValaArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _i_index = 0;
		_tmp0_ = self->priv->externals;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_i_list = _tmp1_;
		_tmp2_ = _i_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_i_size = _tmp4_;
		_i_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaGIRWriterGIRNamespace* i = NULL;
			ValaArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaGIRWriterGIRNamespace* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			_tmp5_ = _i_index;
			_i_index = _tmp5_ + 1;
			_tmp6_ = _i_index;
			_tmp7_ = _i_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _i_list;
			_tmp9_ = _i_index;
			_tmp10_ = vala_list_get ((ValaList*) _tmp8_, _tmp9_);
			i = (ValaGIRWriterGIRNamespace*) _tmp10_;
			_tmp11_ = i;
			_tmp12_ = (*_tmp11_).ns;
			_tmp13_ = self->priv->gir_namespace;
			if (g_strcmp0 (_tmp12_, _tmp13_) != 0) {
				FILE* _tmp14_;
				ValaGIRWriterGIRNamespace* _tmp15_;
				const gchar* _tmp16_;
				ValaGIRWriterGIRNamespace* _tmp17_;
				const gchar* _tmp18_;
				vala_gir_writer_write_indent_stream (self);
				_tmp14_ = self->priv->stream;
				_tmp15_ = i;
				_tmp16_ = (*_tmp15_).ns;
				_tmp17_ = i;
				_tmp18_ = (*_tmp17_).version;
				fprintf (_tmp14_, "<include name=\"%s\" version=\"%s\"/>\n", _tmp16_, _tmp18_);
			}
			_vala_gir_writer_gir_namespace_free0 (i);
		}
		_vala_iterable_unref0 (_i_list);
	}
}


/**
 * Writes the public interface of the specified code context into the
 * specified file.
 *
 * @param context      a code context
 * @param gir_filename a relative or absolute filename
 */
static gpointer _vala_code_context_ref0 (gpointer self) {
	return self ? vala_code_context_ref (self) : NULL;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_gir_writer_write_file (ValaGIRWriter* self, ValaCodeContext* context, const gchar* directory, const gchar* gir_filename, const gchar* gir_namespace, const gchar* gir_version, const gchar* package, const gchar* gir_shared_library) {
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	ValaNamespace* root_symbol = NULL;
	ValaCodeContext* _tmp10_;
	ValaNamespace* _tmp11_;
	ValaNamespace* _tmp12_;
	ValaNamespace* _tmp13_;
	ValaSymbol* glib_ns = NULL;
	ValaNamespace* _tmp14_;
	ValaScope* _tmp15_;
	ValaScope* _tmp16_;
	ValaSymbol* _tmp17_;
	ValaSymbol* _tmp18_;
	ValaScope* _tmp19_;
	ValaScope* _tmp20_;
	ValaSymbol* _tmp21_;
	ValaSymbol* _tmp22_;
	ValaScope* _tmp23_;
	ValaScope* _tmp24_;
	ValaSymbol* _tmp25_;
	const gchar* _tmp26_;
	ValaCodeContext* _tmp27_;
	gint _tmp28_;
	GString* _tmp29_;
	gchar* filename = NULL;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	const gchar* _tmp33_;
	FILE* _tmp34_;
	FILE* _tmp35_;
	FILE* _tmp39_;
	FILE* _tmp40_;
	FILE* _tmp41_;
	FILE* _tmp42_;
	FILE* _tmp43_;
	FILE* _tmp44_;
	gint _tmp45_;
	gint _tmp46_;
	FILE* _tmp47_;
	GString* _tmp48_;
	const gchar* _tmp49_;
	ValaHashSet* _tmp85_;
	gint _tmp86_;
	gint _tmp87_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (directory != NULL);
	g_return_if_fail (gir_filename != NULL);
	g_return_if_fail (gir_namespace != NULL);
	g_return_if_fail (gir_version != NULL);
	g_return_if_fail (package != NULL);
	_tmp0_ = context;
	_tmp1_ = _vala_code_context_ref0 (_tmp0_);
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp1_;
	_tmp2_ = directory;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->directory);
	self->priv->directory = _tmp3_;
	_tmp4_ = gir_namespace;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (self->priv->gir_namespace);
	self->priv->gir_namespace = _tmp5_;
	_tmp6_ = gir_version;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 (self->priv->gir_version);
	self->priv->gir_version = _tmp7_;
	_tmp8_ = gir_shared_library;
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 (self->priv->gir_shared_library);
	self->priv->gir_shared_library = _tmp9_;
	_tmp10_ = context;
	_tmp11_ = vala_code_context_get_root (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	root_symbol = _tmp13_;
	_tmp14_ = root_symbol;
	_tmp15_ = vala_symbol_get_scope ((ValaSymbol*) _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = vala_scope_lookup (_tmp16_, "GLib");
	glib_ns = _tmp17_;
	_tmp18_ = glib_ns;
	_tmp19_ = vala_symbol_get_scope (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = vala_scope_lookup (_tmp20_, "Object");
	_vala_code_node_unref0 (self->priv->gobject_type);
	self->priv->gobject_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
	_tmp22_ = glib_ns;
	_tmp23_ = vala_symbol_get_scope (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = vala_scope_lookup (_tmp24_, "InitiallyUnowned");
	_vala_code_node_unref0 (self->priv->ginitiallyunowned_type);
	self->priv->ginitiallyunowned_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
	_tmp26_ = package;
	vala_gir_writer_write_package (self, _tmp26_);
	_tmp27_ = context;
	vala_code_context_accept (_tmp27_, (ValaCodeVisitor*) self);
	_tmp28_ = self->priv->indent;
	self->priv->indent = _tmp28_ - 1;
	_tmp29_ = self->priv->buffer;
	g_string_append_printf (_tmp29_, "</repository>\n");
	_tmp30_ = directory;
	_tmp31_ = gir_filename;
	_tmp32_ = g_strdup_printf ("%s%c%s", _tmp30_, (gint) G_DIR_SEPARATOR, _tmp31_);
	filename = _tmp32_;
	_tmp33_ = filename;
	_tmp34_ = g_fopen (_tmp33_, "w");
	_fclose0 (self->priv->stream);
	self->priv->stream = _tmp34_;
	_tmp35_ = self->priv->stream;
	if (_tmp35_ == NULL) {
		const gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		_tmp36_ = filename;
		_tmp37_ = g_strdup_printf ("unable to open `%s' for writing", _tmp36_);
		_tmp38_ = _tmp37_;
		vala_report_error (NULL, _tmp38_);
		_g_free0 (_tmp38_);
		_g_free0 (filename);
		_vala_code_node_unref0 (glib_ns);
		_vala_code_node_unref0 (root_symbol);
		return;
	}
	_tmp39_ = self->priv->stream;
	fprintf (_tmp39_, "<?xml version=\"1.0\"?>\n");
	_tmp40_ = self->priv->stream;
	fprintf (_tmp40_, "<repository version=\"1.2\"");
	_tmp41_ = self->priv->stream;
	fprintf (_tmp41_, " xmlns=\"http://www.gtk.org/introspection/core/1.0\"");
	_tmp42_ = self->priv->stream;
	fprintf (_tmp42_, " xmlns:c=\"http://www.gtk.org/introspection/c/1.0\"");
	_tmp43_ = self->priv->stream;
	fprintf (_tmp43_, " xmlns:glib=\"http://www.gtk.org/introspection/glib/1.0\"");
	_tmp44_ = self->priv->stream;
	fprintf (_tmp44_, ">\n");
	_tmp45_ = self->priv->indent;
	self->priv->indent = _tmp45_ + 1;
	vala_gir_writer_write_includes (self);
	_tmp46_ = self->priv->indent;
	self->priv->indent = _tmp46_ - 1;
	_tmp47_ = self->priv->stream;
	_tmp48_ = self->priv->buffer;
	_tmp49_ = _tmp48_->str;
	fputs (_tmp49_, _tmp47_);
	_fclose0 (self->priv->stream);
	self->priv->stream = NULL;
	{
		ValaIterator* _ns_it = NULL;
		ValaHashSet* _tmp50_;
		ValaIterator* _tmp51_;
		_tmp50_ = self->priv->unannotated_namespaces;
		_tmp51_ = vala_iterable_iterator ((ValaIterable*) _tmp50_);
		_ns_it = _tmp51_;
		while (TRUE) {
			ValaIterator* _tmp52_;
			gboolean _tmp53_;
			ValaNamespace* ns = NULL;
			ValaIterator* _tmp54_;
			gpointer _tmp55_;
			ValaHashSet* _tmp56_;
			ValaNamespace* _tmp57_;
			gboolean _tmp58_;
			_tmp52_ = _ns_it;
			_tmp53_ = vala_iterator_next (_tmp52_);
			if (!_tmp53_) {
				break;
			}
			_tmp54_ = _ns_it;
			_tmp55_ = vala_iterator_get (_tmp54_);
			ns = (ValaNamespace*) _tmp55_;
			_tmp56_ = self->priv->our_namespaces;
			_tmp57_ = ns;
			_tmp58_ = vala_collection_contains ((ValaCollection*) _tmp56_, _tmp57_);
			if (!_tmp58_) {
				ValaNamespace* _tmp59_;
				ValaSourceReference* _tmp60_;
				ValaSourceReference* _tmp61_;
				ValaNamespace* _tmp62_;
				const gchar* _tmp63_;
				const gchar* _tmp64_;
				gchar* _tmp65_;
				gchar* _tmp66_;
				_tmp59_ = ns;
				_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp59_);
				_tmp61_ = _tmp60_;
				_tmp62_ = ns;
				_tmp63_ = vala_symbol_get_name ((ValaSymbol*) _tmp62_);
				_tmp64_ = _tmp63_;
				_tmp65_ = g_strdup_printf ("Namespace %s does not have a GIR namespace and version annotation", _tmp64_);
				_tmp66_ = _tmp65_;
				vala_report_warning (_tmp61_, _tmp66_);
				_g_free0 (_tmp66_);
			}
			_vala_code_node_unref0 (ns);
		}
		_vala_iterator_unref0 (_ns_it);
	}
	{
		ValaIterator* _ns_it = NULL;
		ValaHashSet* _tmp67_;
		ValaIterator* _tmp68_;
		_tmp67_ = self->priv->our_namespaces;
		_tmp68_ = vala_iterable_iterator ((ValaIterable*) _tmp67_);
		_ns_it = _tmp68_;
		while (TRUE) {
			ValaIterator* _tmp69_;
			gboolean _tmp70_;
			ValaNamespace* ns = NULL;
			ValaIterator* _tmp71_;
			gpointer _tmp72_;
			ValaNamespace* _tmp73_;
			ValaSourceReference* _tmp74_;
			ValaSourceReference* _tmp75_;
			ValaSourceFile* _tmp76_;
			ValaSourceFile* _tmp77_;
			const gchar* _tmp78_;
			ValaNamespace* _tmp79_;
			ValaSourceReference* _tmp80_;
			ValaSourceReference* _tmp81_;
			ValaSourceFile* _tmp82_;
			ValaSourceFile* _tmp83_;
			const gchar* _tmp84_;
			_tmp69_ = _ns_it;
			_tmp70_ = vala_iterator_next (_tmp69_);
			if (!_tmp70_) {
				break;
			}
			_tmp71_ = _ns_it;
			_tmp72_ = vala_iterator_get (_tmp71_);
			ns = (ValaNamespace*) _tmp72_;
			_tmp73_ = ns;
			_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp76_ = vala_source_reference_get_file (_tmp75_);
			_tmp77_ = _tmp76_;
			_tmp78_ = gir_namespace;
			vala_source_file_set_gir_namespace (_tmp77_, _tmp78_);
			_tmp79_ = ns;
			_tmp80_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp79_);
			_tmp81_ = _tmp80_;
			_tmp82_ = vala_source_reference_get_file (_tmp81_);
			_tmp83_ = _tmp82_;
			_tmp84_ = gir_version;
			vala_source_file_set_gir_version (_tmp83_, _tmp84_);
			_vala_code_node_unref0 (ns);
		}
		_vala_iterator_unref0 (_ns_it);
	}
	_tmp85_ = self->priv->our_namespaces;
	_tmp86_ = vala_collection_get_size ((ValaCollection*) _tmp85_);
	_tmp87_ = _tmp86_;
	if (_tmp87_ == 0) {
		vala_report_error (NULL, "No suitable namespace found to export for GIR");
	}
	_g_free0 (filename);
	_vala_code_node_unref0 (glib_ns);
	_vala_code_node_unref0 (root_symbol);
}


static void vala_gir_writer_write_doc (ValaGIRWriter* self, const gchar* comment) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = comment;
	if (_tmp0_ != NULL) {
		GString* _tmp1_;
		GString* _tmp2_;
		const gchar* _tmp3_;
		GString* _tmp4_;
		vala_gir_writer_write_indent (self);
		_tmp1_ = self->priv->buffer;
		g_string_append (_tmp1_, "<doc xml:whitespace=\"preserve\">");
		_tmp2_ = self->priv->buffer;
		_tmp3_ = comment;
		g_string_append (_tmp2_, _tmp3_);
		_tmp4_ = self->priv->buffer;
		g_string_append (_tmp4_, "</doc>\n");
	}
}


static void vala_gir_writer_write_package (ValaGIRWriter* self, const gchar* package) {
	GString* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (package != NULL);
	vala_gir_writer_write_indent (self);
	_tmp0_ = self->priv->buffer;
	_tmp1_ = package;
	g_string_append_printf (_tmp0_, "<package name=\"%s\"/>\n", _tmp1_);
}


static void vala_gir_writer_write_c_includes (ValaGIRWriter* self, ValaNamespace* ns) {
	ValaSet* header_filenames = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	ValaHashSet* _tmp2_;
	ValaNamespace* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp0_, _tmp1_);
	header_filenames = (ValaSet*) _tmp2_;
	_tmp3_ = ns;
	_tmp4_ = vala_ccode_base_module_get_ccode_header_filenames ((ValaSymbol*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, ",", 0);
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _vala_array_length (_tmp6_);
	_g_free0 (_tmp5_);
	{
		gchar** c_header_filename_collection = NULL;
		gint c_header_filename_collection_length1 = 0;
		gint _c_header_filename_collection_size_ = 0;
		gint c_header_filename_it = 0;
		c_header_filename_collection = _tmp8_;
		c_header_filename_collection_length1 = _tmp8__length1;
		for (c_header_filename_it = 0; c_header_filename_it < _tmp8__length1; c_header_filename_it = c_header_filename_it + 1) {
			const gchar* c_header_filename = NULL;
			c_header_filename = c_header_filename_collection[c_header_filename_it];
			{
				ValaSet* _tmp9_;
				const gchar* _tmp10_;
				_tmp9_ = header_filenames;
				_tmp10_ = c_header_filename;
				vala_collection_add ((ValaCollection*) _tmp9_, _tmp10_);
			}
		}
		c_header_filename_collection = (_vala_array_free (c_header_filename_collection, c_header_filename_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	{
		ValaIterator* _symbol_it = NULL;
		ValaNamespace* _tmp11_;
		ValaScope* _tmp12_;
		ValaScope* _tmp13_;
		ValaMap* _tmp14_;
		ValaMap* _tmp15_;
		ValaCollection* _tmp16_;
		ValaCollection* _tmp17_;
		ValaIterator* _tmp18_;
		ValaIterator* _tmp19_;
		_tmp11_ = ns;
		_tmp12_ = vala_symbol_get_scope ((ValaSymbol*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_scope_get_symbol_table (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_map_get_values (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_iterable_iterator ((ValaIterable*) _tmp17_);
		_tmp19_ = _tmp18_;
		_vala_iterable_unref0 (_tmp17_);
		_vala_map_unref0 (_tmp15_);
		_symbol_it = _tmp19_;
		while (TRUE) {
			ValaIterator* _tmp20_;
			gboolean _tmp21_;
			ValaSymbol* symbol = NULL;
			ValaIterator* _tmp22_;
			gpointer _tmp23_;
			ValaSymbol* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar** _tmp27_;
			gchar** _tmp28_;
			gchar** _tmp29_;
			gint _tmp29__length1;
			_tmp20_ = _symbol_it;
			_tmp21_ = vala_iterator_next (_tmp20_);
			if (!_tmp21_) {
				break;
			}
			_tmp22_ = _symbol_it;
			_tmp23_ = vala_iterator_get (_tmp22_);
			symbol = (ValaSymbol*) _tmp23_;
			_tmp24_ = symbol;
			_tmp25_ = vala_ccode_base_module_get_ccode_header_filenames (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp28_ = _tmp27_ = g_strsplit (_tmp26_, ",", 0);
			_tmp29_ = _tmp28_;
			_tmp29__length1 = _vala_array_length (_tmp27_);
			_g_free0 (_tmp26_);
			{
				gchar** c_header_filename_collection = NULL;
				gint c_header_filename_collection_length1 = 0;
				gint _c_header_filename_collection_size_ = 0;
				gint c_header_filename_it = 0;
				c_header_filename_collection = _tmp29_;
				c_header_filename_collection_length1 = _tmp29__length1;
				for (c_header_filename_it = 0; c_header_filename_it < _tmp29__length1; c_header_filename_it = c_header_filename_it + 1) {
					const gchar* c_header_filename = NULL;
					c_header_filename = c_header_filename_collection[c_header_filename_it];
					{
						ValaSet* _tmp30_;
						const gchar* _tmp31_;
						_tmp30_ = header_filenames;
						_tmp31_ = c_header_filename;
						vala_collection_add ((ValaCollection*) _tmp30_, _tmp31_);
					}
				}
				c_header_filename_collection = (_vala_array_free (c_header_filename_collection, c_header_filename_collection_length1, (GDestroyNotify) g_free), NULL);
			}
			_vala_code_node_unref0 (symbol);
		}
		_vala_iterator_unref0 (_symbol_it);
	}
	{
		ValaIterator* _c_header_filename_it = NULL;
		ValaSet* _tmp32_;
		ValaIterator* _tmp33_;
		_tmp32_ = header_filenames;
		_tmp33_ = vala_iterable_iterator ((ValaIterable*) _tmp32_);
		_c_header_filename_it = _tmp33_;
		while (TRUE) {
			ValaIterator* _tmp34_;
			gboolean _tmp35_;
			gchar* c_header_filename = NULL;
			ValaIterator* _tmp36_;
			gpointer _tmp37_;
			const gchar* _tmp38_;
			_tmp34_ = _c_header_filename_it;
			_tmp35_ = vala_iterator_next (_tmp34_);
			if (!_tmp35_) {
				break;
			}
			_tmp36_ = _c_header_filename_it;
			_tmp37_ = vala_iterator_get (_tmp36_);
			c_header_filename = (gchar*) _tmp37_;
			_tmp38_ = c_header_filename;
			vala_gir_writer_write_c_include (self, _tmp38_);
			_g_free0 (c_header_filename);
		}
		_vala_iterator_unref0 (_c_header_filename_it);
	}
	_vala_iterable_unref0 (header_filenames);
}


static void vala_gir_writer_write_c_include (ValaGIRWriter* self, const gchar* name) {
	GString* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	vala_gir_writer_write_indent (self);
	_tmp0_ = self->priv->buffer;
	_tmp1_ = name;
	g_string_append_printf (_tmp0_, "<c:include name=\"%s\"/>\n", _tmp1_);
}


static void vala_gir_writer_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns) {
	ValaGIRWriter * self;
	ValaNamespace* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaNamespace* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	ValaNamespace* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSymbol* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	ValaNamespace* _tmp18_;
	GString* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* cprefix = NULL;
	ValaNamespace* _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp27_;
	GString* _tmp30_;
	gint _tmp31_;
	ValaNamespace* _tmp32_;
	ValaArrayList* _tmp33_;
	ValaNamespace* _tmp34_;
	ValaNamespace* _tmp35_;
	ValaArrayList* _tmp36_;
	gpointer _tmp37_;
	ValaSymbol* _tmp38_;
	gint _tmp39_;
	GString* _tmp40_;
	ValaHashSet* _tmp41_;
	ValaNamespace* _tmp42_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (ns != NULL);
	_tmp0_ = ns;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = ns;
	_tmp4_ = vala_symbol_get_name ((ValaSymbol*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		ValaArrayList* _tmp6_;
		ValaNamespace* _tmp7_;
		ValaNamespace* _tmp8_;
		ValaArrayList* _tmp9_;
		gpointer _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp6_ = self->priv->hierarchy;
		_tmp7_ = ns;
		vala_list_insert ((ValaList*) _tmp6_, 0, (ValaSymbol*) _tmp7_);
		_tmp8_ = ns;
		vala_code_node_accept_children ((ValaCodeNode*) _tmp8_, (ValaCodeVisitor*) self);
		_tmp9_ = self->priv->hierarchy;
		_tmp10_ = vala_list_remove_at ((ValaList*) _tmp9_, 0);
		_tmp11_ = (ValaSymbol*) _tmp10_;
		_vala_code_node_unref0 (_tmp11_);
		return;
	}
	_tmp12_ = ns;
	_tmp13_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_symbol_get_name (_tmp14_);
	_tmp16_ = _tmp15_;
	if (_tmp16_ != NULL) {
		ValaNamespace* _tmp17_;
		_tmp17_ = ns;
		vala_code_node_accept_children ((ValaCodeNode*) _tmp17_, (ValaCodeVisitor*) self);
		return;
	}
	_tmp18_ = ns;
	vala_gir_writer_write_c_includes (self, _tmp18_);
	vala_gir_writer_write_indent (self);
	_tmp19_ = self->priv->buffer;
	_tmp20_ = self->priv->gir_namespace;
	_tmp21_ = self->priv->gir_version;
	g_string_append_printf (_tmp19_, "<namespace name=\"%s\" version=\"%s\"", _tmp20_, _tmp21_);
	_tmp22_ = ns;
	_tmp23_ = vala_ccode_base_module_get_ccode_prefix ((ValaSymbol*) _tmp22_);
	cprefix = _tmp23_;
	_tmp24_ = self->priv->gir_shared_library;
	if (_tmp24_ != NULL) {
		GString* _tmp25_;
		const gchar* _tmp26_;
		_tmp25_ = self->priv->buffer;
		_tmp26_ = self->priv->gir_shared_library;
		g_string_append_printf (_tmp25_, " shared-library=\"%s\"", _tmp26_);
	}
	_tmp27_ = cprefix;
	if (_tmp27_ != NULL) {
		GString* _tmp28_;
		const gchar* _tmp29_;
		_tmp28_ = self->priv->buffer;
		_tmp29_ = cprefix;
		g_string_append_printf (_tmp28_, " c:prefix=\"%s\"", _tmp29_);
	}
	_tmp30_ = self->priv->buffer;
	g_string_append_printf (_tmp30_, ">\n");
	_tmp31_ = self->priv->indent;
	self->priv->indent = _tmp31_ + 1;
	_tmp32_ = ns;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp32_);
	_tmp33_ = self->priv->hierarchy;
	_tmp34_ = ns;
	vala_list_insert ((ValaList*) _tmp33_, 0, (ValaSymbol*) _tmp34_);
	_tmp35_ = ns;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp35_, (ValaCodeVisitor*) self);
	_tmp36_ = self->priv->hierarchy;
	_tmp37_ = vala_list_remove_at ((ValaList*) _tmp36_, 0);
	_tmp38_ = (ValaSymbol*) _tmp37_;
	_vala_code_node_unref0 (_tmp38_);
	_tmp39_ = self->priv->indent;
	self->priv->indent = _tmp39_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp40_ = self->priv->buffer;
	g_string_append_printf (_tmp40_, "</namespace>\n");
	_tmp41_ = self->priv->our_namespaces;
	_tmp42_ = ns;
	vala_collection_add ((ValaCollection*) _tmp41_, _tmp42_);
	vala_gir_writer_visit_deferred (self);
	_g_free0 (cprefix);
}


static void vala_gir_writer_write_symbol_attributes (ValaGIRWriter* self, ValaSymbol* symbol) {
	ValaSymbol* _tmp0_;
	ValaVersionAttribute* _tmp1_;
	ValaVersionAttribute* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	ValaSymbol* _tmp36_;
	ValaVersionAttribute* _tmp37_;
	ValaVersionAttribute* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gboolean _tmp42_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	_tmp0_ = symbol;
	_tmp1_ = vala_symbol_get_version (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_version_attribute_get_deprecated (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		gchar* _tmp5_ = NULL;
		ValaSymbol* _tmp6_;
		ValaVersionAttribute* _tmp7_;
		ValaVersionAttribute* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gboolean _tmp12_;
		GString* _tmp21_;
		ValaSymbol* _tmp22_;
		ValaVersionAttribute* _tmp23_;
		ValaVersionAttribute* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gboolean _tmp28_;
		_tmp6_ = symbol;
		_tmp7_ = vala_symbol_get_version (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_version_attribute_get_replacement (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_ == NULL;
		_g_free0 (_tmp11_);
		if (_tmp12_) {
			gchar* _tmp13_;
			_tmp13_ = g_strdup ("");
			_g_free0 (_tmp5_);
			_tmp5_ = _tmp13_;
		} else {
			ValaSymbol* _tmp14_;
			ValaVersionAttribute* _tmp15_;
			ValaVersionAttribute* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp14_ = symbol;
			_tmp15_ = vala_symbol_get_version (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = vala_version_attribute_get_replacement (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strdup_printf ("Use %s", _tmp19_);
			_g_free0 (_tmp5_);
			_tmp5_ = _tmp20_;
			_g_free0 (_tmp19_);
		}
		_tmp21_ = self->priv->buffer;
		g_string_append_printf (_tmp21_, " deprecated=\"%s\"", _tmp5_);
		_tmp22_ = symbol;
		_tmp23_ = vala_symbol_get_version (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = vala_version_attribute_get_deprecated_since (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = _tmp26_;
		_tmp28_ = _tmp27_ != NULL;
		_g_free0 (_tmp27_);
		if (_tmp28_) {
			GString* _tmp29_;
			ValaSymbol* _tmp30_;
			ValaVersionAttribute* _tmp31_;
			ValaVersionAttribute* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			_tmp29_ = self->priv->buffer;
			_tmp30_ = symbol;
			_tmp31_ = vala_symbol_get_version (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = vala_version_attribute_get_deprecated_since (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = _tmp34_;
			g_string_append_printf (_tmp29_, " deprecated-version=\"%s\"", _tmp35_);
			_g_free0 (_tmp35_);
		}
		_g_free0 (_tmp5_);
	}
	_tmp36_ = symbol;
	_tmp37_ = vala_symbol_get_version (_tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = vala_version_attribute_get_since (_tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = _tmp40_;
	_tmp42_ = _tmp41_ != NULL;
	_g_free0 (_tmp41_);
	if (_tmp42_) {
		GString* _tmp43_;
		ValaSymbol* _tmp44_;
		ValaVersionAttribute* _tmp45_;
		ValaVersionAttribute* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		_tmp43_ = self->priv->buffer;
		_tmp44_ = symbol;
		_tmp45_ = vala_symbol_get_version (_tmp44_);
		_tmp46_ = _tmp45_;
		_tmp47_ = vala_version_attribute_get_since (_tmp46_);
		_tmp48_ = _tmp47_;
		_tmp49_ = _tmp48_;
		g_string_append_printf (_tmp43_, " version=\"%s\"", _tmp49_);
		_g_free0 (_tmp49_);
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static void vala_gir_writer_real_visit_class (ValaCodeVisitor* base, ValaClass* cl) {
	ValaGIRWriter * self;
	ValaClass* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaClass* _tmp3_;
	gboolean _tmp4_;
	ValaArrayList* _tmp5_;
	gpointer _tmp6_;
	ValaSymbol* _tmp7_;
	gboolean _tmp8_;
	ValaClass* _tmp11_;
	ValaTypeSymbol* _tmp12_;
	gboolean _tmp13_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (cl != NULL);
	_tmp0_ = cl;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = cl;
	_tmp4_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp3_);
	if (!_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->hierarchy;
	_tmp6_ = vala_list_get ((ValaList*) _tmp5_, 0);
	_tmp7_ = (ValaSymbol*) _tmp6_;
	_tmp8_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_NAMESPACE);
	_vala_code_node_unref0 (_tmp7_);
	if (_tmp8_) {
		ValaArrayList* _tmp9_;
		ValaClass* _tmp10_;
		_tmp9_ = self->priv->deferred;
		_tmp10_ = cl;
		vala_collection_add ((ValaCollection*) _tmp9_, (ValaCodeNode*) _tmp10_);
		return;
	}
	_tmp11_ = cl;
	_tmp12_ = self->priv->gobject_type;
	_tmp13_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp11_, _tmp12_);
	if (_tmp13_) {
		gchar* gtype_struct_name = NULL;
		ValaClass* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		GString* _tmp19_;
		ValaClass* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		ValaClass* _tmp23_;
		GString* _tmp24_;
		const gchar* _tmp25_;
		GString* _tmp26_;
		ValaClass* _tmp27_;
		ValaClass* _tmp28_;
		ValaClass* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		ValaClass* _tmp32_;
		gboolean _tmp33_;
		gboolean _tmp34_;
		ValaClass* _tmp36_;
		GString* _tmp37_;
		gint _tmp38_;
		ValaClass* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		ValaClass* _tmp64_;
		GString* _tmp65_;
		gint _tmp66_;
		GString* _tmp67_;
		ValaClass* _tmp68_;
		ValaClass* _tmp69_;
		ValaClass* _tmp70_;
		gchar* _tmp71_;
		gchar* _tmp72_;
		ValaClass* _tmp73_;
		ValaClass* _tmp74_;
		ValaClass* _tmp75_;
		gchar* _tmp76_;
		gchar* _tmp77_;
		gint _tmp78_;
		GString* _tmp79_;
		GString* _tmp80_;
		gint _tmp81_;
		GString* _tmp82_;
		ValaClass* _tmp83_;
		gchar* _tmp84_;
		gchar* _tmp85_;
		ValaClass* _tmp86_;
		gchar* _tmp87_;
		gchar* _tmp88_;
		gint _tmp89_;
		GString* _tmp90_;
		ValaArrayList* _tmp91_;
		ValaClass* _tmp92_;
		ValaClass* _tmp93_;
		ValaArrayList* _tmp94_;
		gpointer _tmp95_;
		ValaSymbol* _tmp96_;
		gint _tmp97_;
		GString* _tmp98_;
		GString* _tmp99_;
		const gchar* _tmp100_;
		ValaClass* _tmp101_;
		GString* _tmp102_;
		ValaClass* _tmp103_;
		const gchar* _tmp104_;
		const gchar* _tmp105_;
		GString* _tmp106_;
		gint _tmp107_;
		GString* _tmp108_;
		gint _tmp109_;
		GString* _tmp110_;
		ValaClass* _tmp111_;
		ValaClass* _tmp112_;
		ValaClass* _tmp113_;
		gchar* _tmp114_;
		gchar* _tmp115_;
		ValaClass* _tmp116_;
		ValaClass* _tmp117_;
		ValaClass* _tmp118_;
		gchar* _tmp119_;
		gchar* _tmp120_;
		gint _tmp121_;
		GString* _tmp122_;
		gint _tmp244_;
		GString* _tmp245_;
		GString* _tmp246_;
		ValaClass* _tmp247_;
		gchar* _tmp248_;
		gchar* _tmp249_;
		ValaClass* _tmp250_;
		gchar* _tmp251_;
		gchar* _tmp252_;
		_tmp14_ = cl;
		_tmp15_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strconcat (_tmp16_, "Class", NULL);
		_tmp18_ = _tmp17_;
		_g_free0 (_tmp16_);
		gtype_struct_name = _tmp18_;
		vala_gir_writer_write_indent (self);
		_tmp19_ = self->priv->buffer;
		_tmp20_ = cl;
		_tmp21_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) _tmp20_);
		_tmp22_ = _tmp21_;
		g_string_append_printf (_tmp19_, "<class name=\"%s\"", _tmp22_);
		_g_free0 (_tmp22_);
		_tmp23_ = cl;
		vala_gir_writer_write_gtype_attributes (self, (ValaTypeSymbol*) _tmp23_);
		_tmp24_ = self->priv->buffer;
		_tmp25_ = gtype_struct_name;
		g_string_append_printf (_tmp24_, " glib:type-struct=\"%s\"", _tmp25_);
		_tmp26_ = self->priv->buffer;
		_tmp27_ = cl;
		_tmp28_ = vala_class_get_base_class (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp29_);
		_tmp31_ = _tmp30_;
		g_string_append_printf (_tmp26_, " parent=\"%s\"", _tmp31_);
		_g_free0 (_tmp31_);
		_tmp32_ = cl;
		_tmp33_ = vala_class_get_is_abstract (_tmp32_);
		_tmp34_ = _tmp33_;
		if (_tmp34_) {
			GString* _tmp35_;
			_tmp35_ = self->priv->buffer;
			g_string_append_printf (_tmp35_, " abstract=\"1\"");
		}
		_tmp36_ = cl;
		vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp36_);
		_tmp37_ = self->priv->buffer;
		g_string_append_printf (_tmp37_, ">\n");
		_tmp38_ = self->priv->indent;
		self->priv->indent = _tmp38_ + 1;
		_tmp39_ = cl;
		_tmp40_ = vala_gir_writer_get_class_comment (self, _tmp39_);
		_tmp41_ = _tmp40_;
		vala_gir_writer_write_doc (self, _tmp41_);
		_g_free0 (_tmp41_);
		{
			ValaList* _base_type_list = NULL;
			ValaClass* _tmp42_;
			ValaList* _tmp43_;
			gint _base_type_size = 0;
			ValaList* _tmp44_;
			gint _tmp45_;
			gint _tmp46_;
			gint _base_type_index = 0;
			_tmp42_ = cl;
			_tmp43_ = vala_class_get_base_types (_tmp42_);
			_base_type_list = _tmp43_;
			_tmp44_ = _base_type_list;
			_tmp45_ = vala_collection_get_size ((ValaCollection*) _tmp44_);
			_tmp46_ = _tmp45_;
			_base_type_size = _tmp46_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp47_;
				gint _tmp48_;
				gint _tmp49_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp50_;
				gint _tmp51_;
				gpointer _tmp52_;
				ValaObjectType* object_type = NULL;
				ValaDataType* _tmp53_;
				ValaObjectType* _tmp54_;
				ValaObjectType* _tmp55_;
				ValaObjectTypeSymbol* _tmp56_;
				ValaObjectTypeSymbol* _tmp57_;
				_tmp47_ = _base_type_index;
				_base_type_index = _tmp47_ + 1;
				_tmp48_ = _base_type_index;
				_tmp49_ = _base_type_size;
				if (!(_tmp48_ < _tmp49_)) {
					break;
				}
				_tmp50_ = _base_type_list;
				_tmp51_ = _base_type_index;
				_tmp52_ = vala_list_get (_tmp50_, _tmp51_);
				base_type = (ValaDataType*) _tmp52_;
				_tmp53_ = base_type;
				_tmp54_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				object_type = _tmp54_;
				_tmp55_ = object_type;
				_tmp56_ = vala_object_type_get_type_symbol (_tmp55_);
				_tmp57_ = _tmp56_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp57_, VALA_TYPE_INTERFACE)) {
					GString* _tmp58_;
					ValaObjectType* _tmp59_;
					ValaObjectTypeSymbol* _tmp60_;
					ValaObjectTypeSymbol* _tmp61_;
					gchar* _tmp62_;
					gchar* _tmp63_;
					vala_gir_writer_write_indent (self);
					_tmp58_ = self->priv->buffer;
					_tmp59_ = object_type;
					_tmp60_ = vala_object_type_get_type_symbol (_tmp59_);
					_tmp61_ = _tmp60_;
					_tmp62_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp61_);
					_tmp63_ = _tmp62_;
					g_string_append_printf (_tmp58_, "<implements name=\"%s\"/>\n", _tmp63_);
					_g_free0 (_tmp63_);
				}
				_vala_code_node_unref0 (object_type);
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		_tmp64_ = cl;
		vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp64_);
		vala_gir_writer_write_indent (self);
		_tmp65_ = self->priv->buffer;
		g_string_append_printf (_tmp65_, "<field name=\"parent_instance\">\n");
		_tmp66_ = self->priv->indent;
		self->priv->indent = _tmp66_ + 1;
		vala_gir_writer_write_indent (self);
		_tmp67_ = self->priv->buffer;
		_tmp68_ = cl;
		_tmp69_ = vala_class_get_base_class (_tmp68_);
		_tmp70_ = _tmp69_;
		_tmp71_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp70_);
		_tmp72_ = _tmp71_;
		_tmp73_ = cl;
		_tmp74_ = vala_class_get_base_class (_tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp75_);
		_tmp77_ = _tmp76_;
		g_string_append_printf (_tmp67_, "<type name=\"%s\" c:type=\"%s\"/>\n", _tmp72_, _tmp77_);
		_g_free0 (_tmp77_);
		_g_free0 (_tmp72_);
		_tmp78_ = self->priv->indent;
		self->priv->indent = _tmp78_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp79_ = self->priv->buffer;
		g_string_append_printf (_tmp79_, "</field>\n");
		vala_gir_writer_write_indent (self);
		_tmp80_ = self->priv->buffer;
		g_string_append_printf (_tmp80_, "<field name=\"priv\">\n");
		_tmp81_ = self->priv->indent;
		self->priv->indent = _tmp81_ + 1;
		vala_gir_writer_write_indent (self);
		_tmp82_ = self->priv->buffer;
		_tmp83_ = cl;
		_tmp84_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) _tmp83_);
		_tmp85_ = _tmp84_;
		_tmp86_ = cl;
		_tmp87_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp86_);
		_tmp88_ = _tmp87_;
		g_string_append_printf (_tmp82_, "<type name=\"%sPrivate\" c:type=\"%sPrivate*\"/>\n", _tmp85_, _tmp88_);
		_g_free0 (_tmp88_);
		_g_free0 (_tmp85_);
		_tmp89_ = self->priv->indent;
		self->priv->indent = _tmp89_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp90_ = self->priv->buffer;
		g_string_append_printf (_tmp90_, "</field>\n");
		_tmp91_ = self->priv->hierarchy;
		_tmp92_ = cl;
		vala_list_insert ((ValaList*) _tmp91_, 0, (ValaSymbol*) _tmp92_);
		_tmp93_ = cl;
		vala_code_node_accept_children ((ValaCodeNode*) _tmp93_, (ValaCodeVisitor*) self);
		_tmp94_ = self->priv->hierarchy;
		_tmp95_ = vala_list_remove_at ((ValaList*) _tmp94_, 0);
		_tmp96_ = (ValaSymbol*) _tmp95_;
		_vala_code_node_unref0 (_tmp96_);
		_tmp97_ = self->priv->indent;
		self->priv->indent = _tmp97_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp98_ = self->priv->buffer;
		g_string_append_printf (_tmp98_, "</class>\n");
		vala_gir_writer_write_indent (self);
		_tmp99_ = self->priv->buffer;
		_tmp100_ = gtype_struct_name;
		g_string_append_printf (_tmp99_, "<record name=\"%s\"", _tmp100_);
		_tmp101_ = cl;
		vala_gir_writer_write_ctype_attributes (self, (ValaTypeSymbol*) _tmp101_, "Class");
		_tmp102_ = self->priv->buffer;
		_tmp103_ = cl;
		_tmp104_ = vala_symbol_get_name ((ValaSymbol*) _tmp103_);
		_tmp105_ = _tmp104_;
		g_string_append_printf (_tmp102_, " glib:is-gtype-struct-for=\"%s\"", _tmp105_);
		_tmp106_ = self->priv->buffer;
		g_string_append_printf (_tmp106_, ">\n");
		_tmp107_ = self->priv->indent;
		self->priv->indent = _tmp107_ + 1;
		vala_gir_writer_write_indent (self);
		_tmp108_ = self->priv->buffer;
		g_string_append_printf (_tmp108_, "<field name=\"parent_class\">\n");
		_tmp109_ = self->priv->indent;
		self->priv->indent = _tmp109_ + 1;
		vala_gir_writer_write_indent (self);
		_tmp110_ = self->priv->buffer;
		_tmp111_ = cl;
		_tmp112_ = vala_class_get_base_class (_tmp111_);
		_tmp113_ = _tmp112_;
		_tmp114_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp113_);
		_tmp115_ = _tmp114_;
		_tmp116_ = cl;
		_tmp117_ = vala_class_get_base_class (_tmp116_);
		_tmp118_ = _tmp117_;
		_tmp119_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp118_);
		_tmp120_ = _tmp119_;
		g_string_append_printf (_tmp110_, "<type name=\"%sClass\" c:type=\"%sClass\"/>\n", _tmp115_, _tmp120_);
		_g_free0 (_tmp120_);
		_g_free0 (_tmp115_);
		_tmp121_ = self->priv->indent;
		self->priv->indent = _tmp121_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp122_ = self->priv->buffer;
		g_string_append_printf (_tmp122_, "</field>\n");
		{
			ValaList* _m_list = NULL;
			ValaClass* _tmp123_;
			ValaList* _tmp124_;
			gint _m_size = 0;
			ValaList* _tmp125_;
			gint _tmp126_;
			gint _tmp127_;
			gint _m_index = 0;
			_tmp123_ = cl;
			_tmp124_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp123_);
			_m_list = _tmp124_;
			_tmp125_ = _m_list;
			_tmp126_ = vala_collection_get_size ((ValaCollection*) _tmp125_);
			_tmp127_ = _tmp126_;
			_m_size = _tmp127_;
			_m_index = -1;
			while (TRUE) {
				gint _tmp128_;
				gint _tmp129_;
				gint _tmp130_;
				ValaMethod* m = NULL;
				ValaList* _tmp131_;
				gint _tmp132_;
				gpointer _tmp133_;
				gboolean _tmp134_ = FALSE;
				ValaMethod* _tmp135_;
				gboolean _tmp136_;
				gboolean _tmp137_;
				_tmp128_ = _m_index;
				_m_index = _tmp128_ + 1;
				_tmp129_ = _m_index;
				_tmp130_ = _m_size;
				if (!(_tmp129_ < _tmp130_)) {
					break;
				}
				_tmp131_ = _m_list;
				_tmp132_ = _m_index;
				_tmp133_ = vala_list_get (_tmp131_, _tmp132_);
				m = (ValaMethod*) _tmp133_;
				_tmp135_ = m;
				_tmp136_ = vala_method_get_is_abstract (_tmp135_);
				_tmp137_ = _tmp136_;
				if (_tmp137_) {
					_tmp134_ = TRUE;
				} else {
					ValaMethod* _tmp138_;
					gboolean _tmp139_;
					gboolean _tmp140_;
					_tmp138_ = m;
					_tmp139_ = vala_method_get_is_virtual (_tmp138_);
					_tmp140_ = _tmp139_;
					_tmp134_ = _tmp140_;
				}
				if (_tmp134_) {
					ValaMethod* _tmp141_;
					gboolean _tmp142_;
					gboolean _tmp143_;
					vala_gir_writer_write_indent (self);
					_tmp141_ = m;
					_tmp142_ = vala_method_get_coroutine (_tmp141_);
					_tmp143_ = _tmp142_;
					if (_tmp143_) {
						gchar* finish_name = NULL;
						ValaMethod* _tmp144_;
						const gchar* _tmp145_;
						const gchar* _tmp146_;
						gchar* _tmp147_;
						const gchar* _tmp148_;
						gboolean _tmp149_;
						const gchar* _tmp157_;
						gchar* _tmp158_;
						GString* _tmp159_;
						ValaMethod* _tmp160_;
						const gchar* _tmp161_;
						const gchar* _tmp162_;
						gint _tmp163_;
						ValaMethod* _tmp164_;
						ValaMethod* _tmp165_;
						const gchar* _tmp166_;
						const gchar* _tmp167_;
						ValaMethod* _tmp168_;
						gchar* _tmp169_;
						gchar* _tmp170_;
						ValaMethod* _tmp171_;
						ValaList* _tmp172_;
						ValaList* _tmp173_;
						ValaVoidType* _tmp174_;
						ValaVoidType* _tmp175_;
						gint _tmp176_;
						GString* _tmp177_;
						GString* _tmp178_;
						const gchar* _tmp179_;
						gint _tmp180_;
						ValaMethod* _tmp181_;
						const gchar* _tmp182_;
						ValaMethod* _tmp183_;
						gchar* _tmp184_;
						gchar* _tmp185_;
						ValaMethod* _tmp186_;
						ValaList* _tmp187_;
						ValaList* _tmp188_;
						ValaMethod* _tmp189_;
						ValaDataType* _tmp190_;
						ValaDataType* _tmp191_;
						ValaMethod* _tmp192_;
						gboolean _tmp193_;
						gboolean _tmp194_;
						gint _tmp195_;
						GString* _tmp196_;
						_tmp144_ = m;
						_tmp145_ = vala_symbol_get_name ((ValaSymbol*) _tmp144_);
						_tmp146_ = _tmp145_;
						_tmp147_ = g_strdup (_tmp146_);
						finish_name = _tmp147_;
						_tmp148_ = finish_name;
						_tmp149_ = g_str_has_suffix (_tmp148_, "_async");
						if (_tmp149_) {
							const gchar* _tmp150_;
							const gchar* _tmp151_;
							gint _tmp152_;
							gint _tmp153_;
							gint _tmp154_;
							gint _tmp155_;
							gchar* _tmp156_;
							_tmp150_ = finish_name;
							_tmp151_ = finish_name;
							_tmp152_ = strlen (_tmp151_);
							_tmp153_ = _tmp152_;
							_tmp154_ = strlen ("_async");
							_tmp155_ = _tmp154_;
							_tmp156_ = string_substring (_tmp150_, (glong) 0, (glong) (_tmp153_ - _tmp155_));
							_g_free0 (finish_name);
							finish_name = _tmp156_;
						}
						_tmp157_ = finish_name;
						_tmp158_ = g_strconcat (_tmp157_, "_finish", NULL);
						_g_free0 (finish_name);
						finish_name = _tmp158_;
						vala_gir_writer_write_indent (self);
						_tmp159_ = self->priv->buffer;
						_tmp160_ = m;
						_tmp161_ = vala_symbol_get_name ((ValaSymbol*) _tmp160_);
						_tmp162_ = _tmp161_;
						g_string_append_printf (_tmp159_, "<field name=\"%s\">\n", _tmp162_);
						_tmp163_ = self->priv->indent;
						self->priv->indent = _tmp163_ + 1;
						_tmp164_ = m;
						_tmp165_ = m;
						_tmp166_ = vala_symbol_get_name ((ValaSymbol*) _tmp165_);
						_tmp167_ = _tmp166_;
						_tmp168_ = m;
						_tmp169_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp168_);
						_tmp170_ = _tmp169_;
						_tmp171_ = m;
						_tmp172_ = vala_method_get_async_begin_parameters (_tmp171_);
						_tmp173_ = _tmp172_;
						_tmp174_ = vala_void_type_new (NULL);
						_tmp175_ = _tmp174_;
						vala_gir_writer_do_write_signature (self, _tmp164_, "callback", TRUE, _tmp167_, _tmp170_, _tmp173_, (ValaDataType*) _tmp175_, FALSE, FALSE);
						_vala_code_node_unref0 (_tmp175_);
						_vala_iterable_unref0 (_tmp173_);
						_g_free0 (_tmp170_);
						_tmp176_ = self->priv->indent;
						self->priv->indent = _tmp176_ - 1;
						vala_gir_writer_write_indent (self);
						_tmp177_ = self->priv->buffer;
						g_string_append_printf (_tmp177_, "</field>\n");
						vala_gir_writer_write_indent (self);
						_tmp178_ = self->priv->buffer;
						_tmp179_ = finish_name;
						g_string_append_printf (_tmp178_, "<field name=\"%s\">\n", _tmp179_);
						_tmp180_ = self->priv->indent;
						self->priv->indent = _tmp180_ + 1;
						_tmp181_ = m;
						_tmp182_ = finish_name;
						_tmp183_ = m;
						_tmp184_ = vala_ccode_base_module_get_ccode_finish_name (_tmp183_);
						_tmp185_ = _tmp184_;
						_tmp186_ = m;
						_tmp187_ = vala_method_get_async_end_parameters (_tmp186_);
						_tmp188_ = _tmp187_;
						_tmp189_ = m;
						_tmp190_ = vala_callable_get_return_type ((ValaCallable*) _tmp189_);
						_tmp191_ = _tmp190_;
						_tmp192_ = m;
						_tmp193_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp192_);
						_tmp194_ = _tmp193_;
						vala_gir_writer_do_write_signature (self, _tmp181_, "callback", TRUE, _tmp182_, _tmp185_, _tmp188_, _tmp191_, _tmp194_, FALSE);
						_vala_iterable_unref0 (_tmp188_);
						_g_free0 (_tmp185_);
						_tmp195_ = self->priv->indent;
						self->priv->indent = _tmp195_ - 1;
						vala_gir_writer_write_indent (self);
						_tmp196_ = self->priv->buffer;
						g_string_append_printf (_tmp196_, "</field>\n");
						_g_free0 (finish_name);
					} else {
						GString* _tmp197_;
						ValaMethod* _tmp198_;
						const gchar* _tmp199_;
						const gchar* _tmp200_;
						gint _tmp201_;
						ValaMethod* _tmp202_;
						ValaMethod* _tmp203_;
						const gchar* _tmp204_;
						const gchar* _tmp205_;
						ValaMethod* _tmp206_;
						gchar* _tmp207_;
						gchar* _tmp208_;
						ValaMethod* _tmp209_;
						ValaList* _tmp210_;
						ValaList* _tmp211_;
						ValaMethod* _tmp212_;
						ValaDataType* _tmp213_;
						ValaDataType* _tmp214_;
						ValaMethod* _tmp215_;
						gboolean _tmp216_;
						gboolean _tmp217_;
						gint _tmp218_;
						GString* _tmp219_;
						vala_gir_writer_write_indent (self);
						_tmp197_ = self->priv->buffer;
						_tmp198_ = m;
						_tmp199_ = vala_symbol_get_name ((ValaSymbol*) _tmp198_);
						_tmp200_ = _tmp199_;
						g_string_append_printf (_tmp197_, "<field name=\"%s\">\n", _tmp200_);
						_tmp201_ = self->priv->indent;
						self->priv->indent = _tmp201_ + 1;
						_tmp202_ = m;
						_tmp203_ = m;
						_tmp204_ = vala_symbol_get_name ((ValaSymbol*) _tmp203_);
						_tmp205_ = _tmp204_;
						_tmp206_ = m;
						_tmp207_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp206_);
						_tmp208_ = _tmp207_;
						_tmp209_ = m;
						_tmp210_ = vala_callable_get_parameters ((ValaCallable*) _tmp209_);
						_tmp211_ = _tmp210_;
						_tmp212_ = m;
						_tmp213_ = vala_callable_get_return_type ((ValaCallable*) _tmp212_);
						_tmp214_ = _tmp213_;
						_tmp215_ = m;
						_tmp216_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp215_);
						_tmp217_ = _tmp216_;
						vala_gir_writer_do_write_signature (self, _tmp202_, "callback", TRUE, _tmp205_, _tmp208_, _tmp211_, _tmp214_, _tmp217_, FALSE);
						_vala_iterable_unref0 (_tmp211_);
						_g_free0 (_tmp208_);
						_tmp218_ = self->priv->indent;
						self->priv->indent = _tmp218_ - 1;
						vala_gir_writer_write_indent (self);
						_tmp219_ = self->priv->buffer;
						g_string_append_printf (_tmp219_, "</field>\n");
					}
				}
				_vala_code_node_unref0 (m);
			}
			_vala_iterable_unref0 (_m_list);
		}
		{
			ValaList* _sig_list = NULL;
			ValaClass* _tmp220_;
			ValaList* _tmp221_;
			gint _sig_size = 0;
			ValaList* _tmp222_;
			gint _tmp223_;
			gint _tmp224_;
			gint _sig_index = 0;
			_tmp220_ = cl;
			_tmp221_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) _tmp220_);
			_sig_list = _tmp221_;
			_tmp222_ = _sig_list;
			_tmp223_ = vala_collection_get_size ((ValaCollection*) _tmp222_);
			_tmp224_ = _tmp223_;
			_sig_size = _tmp224_;
			_sig_index = -1;
			while (TRUE) {
				gint _tmp225_;
				gint _tmp226_;
				gint _tmp227_;
				ValaSignal* sig = NULL;
				ValaList* _tmp228_;
				gint _tmp229_;
				gpointer _tmp230_;
				ValaSignal* _tmp231_;
				ValaMethod* _tmp232_;
				ValaMethod* _tmp233_;
				_tmp225_ = _sig_index;
				_sig_index = _tmp225_ + 1;
				_tmp226_ = _sig_index;
				_tmp227_ = _sig_size;
				if (!(_tmp226_ < _tmp227_)) {
					break;
				}
				_tmp228_ = _sig_list;
				_tmp229_ = _sig_index;
				_tmp230_ = vala_list_get (_tmp228_, _tmp229_);
				sig = (ValaSignal*) _tmp230_;
				_tmp231_ = sig;
				_tmp232_ = vala_signal_get_default_handler (_tmp231_);
				_tmp233_ = _tmp232_;
				if (_tmp233_ != NULL) {
					GString* _tmp234_;
					ValaSignal* _tmp235_;
					gchar* _tmp236_;
					gchar* _tmp237_;
					gint _tmp238_;
					ValaSignal* _tmp239_;
					ValaMethod* _tmp240_;
					ValaMethod* _tmp241_;
					gint _tmp242_;
					GString* _tmp243_;
					vala_gir_writer_write_indent (self);
					_tmp234_ = self->priv->buffer;
					_tmp235_ = sig;
					_tmp236_ = vala_ccode_base_module_get_ccode_lower_case_name ((ValaCodeNode*) _tmp235_, NULL);
					_tmp237_ = _tmp236_;
					g_string_append_printf (_tmp234_, "<field name=\"%s\">\n", _tmp237_);
					_g_free0 (_tmp237_);
					_tmp238_ = self->priv->indent;
					self->priv->indent = _tmp238_ + 1;
					_tmp239_ = sig;
					_tmp240_ = vala_signal_get_default_handler (_tmp239_);
					_tmp241_ = _tmp240_;
					vala_gir_writer_write_signature (self, _tmp241_, "callback", FALSE, TRUE);
					_tmp242_ = self->priv->indent;
					self->priv->indent = _tmp242_ - 1;
					vala_gir_writer_write_indent (self);
					_tmp243_ = self->priv->buffer;
					g_string_append_printf (_tmp243_, "</field>\n");
				}
				_vala_code_node_unref0 (sig);
			}
			_vala_iterable_unref0 (_sig_list);
		}
		_tmp244_ = self->priv->indent;
		self->priv->indent = _tmp244_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp245_ = self->priv->buffer;
		g_string_append_printf (_tmp245_, "</record>\n");
		vala_gir_writer_write_indent (self);
		_tmp246_ = self->priv->buffer;
		_tmp247_ = cl;
		_tmp248_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) _tmp247_);
		_tmp249_ = _tmp248_;
		_tmp250_ = cl;
		_tmp251_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp250_);
		_tmp252_ = _tmp251_;
		g_string_append_printf (_tmp246_, "<record name=\"%sPrivate\" c:type=\"%sPrivate\" disguised=\"1\"/>\n", _tmp249_, _tmp252_);
		_g_free0 (_tmp252_);
		_g_free0 (_tmp249_);
		_g_free0 (gtype_struct_name);
	} else {
		GString* _tmp253_;
		ValaClass* _tmp254_;
		gchar* _tmp255_;
		gchar* _tmp256_;
		ValaClass* _tmp257_;
		GString* _tmp258_;
		gint _tmp259_;
		ValaClass* _tmp260_;
		gchar* _tmp261_;
		gchar* _tmp262_;
		ValaClass* _tmp263_;
		ValaArrayList* _tmp264_;
		ValaClass* _tmp265_;
		ValaClass* _tmp266_;
		ValaArrayList* _tmp267_;
		gpointer _tmp268_;
		ValaSymbol* _tmp269_;
		gint _tmp270_;
		GString* _tmp271_;
		vala_gir_writer_write_indent (self);
		_tmp253_ = self->priv->buffer;
		_tmp254_ = cl;
		_tmp255_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) _tmp254_);
		_tmp256_ = _tmp255_;
		g_string_append_printf (_tmp253_, "<record name=\"%s\"", _tmp256_);
		_g_free0 (_tmp256_);
		_tmp257_ = cl;
		vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp257_);
		_tmp258_ = self->priv->buffer;
		g_string_append_printf (_tmp258_, ">\n");
		_tmp259_ = self->priv->indent;
		self->priv->indent = _tmp259_ + 1;
		_tmp260_ = cl;
		_tmp261_ = vala_gir_writer_get_class_comment (self, _tmp260_);
		_tmp262_ = _tmp261_;
		vala_gir_writer_write_doc (self, _tmp262_);
		_g_free0 (_tmp262_);
		_tmp263_ = cl;
		vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp263_);
		_tmp264_ = self->priv->hierarchy;
		_tmp265_ = cl;
		vala_list_insert ((ValaList*) _tmp264_, 0, (ValaSymbol*) _tmp265_);
		_tmp266_ = cl;
		vala_code_node_accept_children ((ValaCodeNode*) _tmp266_, (ValaCodeVisitor*) self);
		_tmp267_ = self->priv->hierarchy;
		_tmp268_ = vala_list_remove_at ((ValaList*) _tmp267_, 0);
		_tmp269_ = (ValaSymbol*) _tmp268_;
		_vala_code_node_unref0 (_tmp269_);
		_tmp270_ = self->priv->indent;
		self->priv->indent = _tmp270_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp271_ = self->priv->buffer;
		g_string_append_printf (_tmp271_, "</record>\n");
	}
	vala_gir_writer_visit_deferred (self);
}


static void vala_gir_writer_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st) {
	ValaGIRWriter * self;
	ValaStruct* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaStruct* _tmp3_;
	gboolean _tmp4_;
	ValaArrayList* _tmp5_;
	gpointer _tmp6_;
	ValaSymbol* _tmp7_;
	gboolean _tmp8_;
	GString* _tmp11_;
	ValaStruct* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	ValaStruct* _tmp15_;
	GString* _tmp16_;
	gint _tmp17_;
	ValaStruct* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	ValaStruct* _tmp21_;
	ValaArrayList* _tmp22_;
	ValaStruct* _tmp23_;
	ValaStruct* _tmp24_;
	ValaArrayList* _tmp25_;
	gpointer _tmp26_;
	ValaSymbol* _tmp27_;
	gint _tmp28_;
	GString* _tmp29_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (st != NULL);
	_tmp0_ = st;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = st;
	_tmp4_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp3_);
	if (!_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->hierarchy;
	_tmp6_ = vala_list_get ((ValaList*) _tmp5_, 0);
	_tmp7_ = (ValaSymbol*) _tmp6_;
	_tmp8_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_NAMESPACE);
	_vala_code_node_unref0 (_tmp7_);
	if (_tmp8_) {
		ValaArrayList* _tmp9_;
		ValaStruct* _tmp10_;
		_tmp9_ = self->priv->deferred;
		_tmp10_ = st;
		vala_collection_add ((ValaCollection*) _tmp9_, (ValaCodeNode*) _tmp10_);
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp11_ = self->priv->buffer;
	_tmp12_ = st;
	_tmp13_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) _tmp12_);
	_tmp14_ = _tmp13_;
	g_string_append_printf (_tmp11_, "<record name=\"%s\"", _tmp14_);
	_g_free0 (_tmp14_);
	_tmp15_ = st;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp15_);
	_tmp16_ = self->priv->buffer;
	g_string_append_printf (_tmp16_, ">\n");
	_tmp17_ = self->priv->indent;
	self->priv->indent = _tmp17_ + 1;
	_tmp18_ = st;
	_tmp19_ = vala_gir_writer_get_struct_comment (self, _tmp18_);
	_tmp20_ = _tmp19_;
	vala_gir_writer_write_doc (self, _tmp20_);
	_g_free0 (_tmp20_);
	_tmp21_ = st;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp21_);
	_tmp22_ = self->priv->hierarchy;
	_tmp23_ = st;
	vala_list_insert ((ValaList*) _tmp22_, 0, (ValaSymbol*) _tmp23_);
	_tmp24_ = st;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp24_, (ValaCodeVisitor*) self);
	_tmp25_ = self->priv->hierarchy;
	_tmp26_ = vala_list_remove_at ((ValaList*) _tmp25_, 0);
	_tmp27_ = (ValaSymbol*) _tmp26_;
	_vala_code_node_unref0 (_tmp27_);
	_tmp28_ = self->priv->indent;
	self->priv->indent = _tmp28_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp29_ = self->priv->buffer;
	g_string_append_printf (_tmp29_, "</record>\n");
	vala_gir_writer_visit_deferred (self);
}


static void vala_gir_writer_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface) {
	ValaGIRWriter * self;
	ValaInterface* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaInterface* _tmp3_;
	gboolean _tmp4_;
	ValaArrayList* _tmp5_;
	gpointer _tmp6_;
	ValaSymbol* _tmp7_;
	gboolean _tmp8_;
	gchar* gtype_struct_name = NULL;
	ValaInterface* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	GString* _tmp15_;
	ValaInterface* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	ValaInterface* _tmp19_;
	GString* _tmp20_;
	const gchar* _tmp21_;
	ValaInterface* _tmp22_;
	GString* _tmp23_;
	gint _tmp24_;
	ValaInterface* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	ValaInterface* _tmp28_;
	ValaList* _tmp29_;
	ValaList* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	gboolean _tmp33_;
	ValaInterface* _tmp51_;
	ValaArrayList* _tmp52_;
	ValaInterface* _tmp53_;
	ValaInterface* _tmp54_;
	ValaArrayList* _tmp55_;
	gpointer _tmp56_;
	ValaSymbol* _tmp57_;
	gint _tmp58_;
	GString* _tmp59_;
	GString* _tmp60_;
	const gchar* _tmp61_;
	ValaInterface* _tmp62_;
	GString* _tmp63_;
	ValaInterface* _tmp64_;
	const gchar* _tmp65_;
	const gchar* _tmp66_;
	GString* _tmp67_;
	gint _tmp68_;
	GString* _tmp69_;
	gint _tmp70_;
	GString* _tmp71_;
	gint _tmp72_;
	GString* _tmp73_;
	gint _tmp249_;
	GString* _tmp250_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (iface != NULL);
	_tmp0_ = iface;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = iface;
	_tmp4_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp3_);
	if (!_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->hierarchy;
	_tmp6_ = vala_list_get ((ValaList*) _tmp5_, 0);
	_tmp7_ = (ValaSymbol*) _tmp6_;
	_tmp8_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_NAMESPACE);
	_vala_code_node_unref0 (_tmp7_);
	if (_tmp8_) {
		ValaArrayList* _tmp9_;
		ValaInterface* _tmp10_;
		_tmp9_ = self->priv->deferred;
		_tmp10_ = iface;
		vala_collection_add ((ValaCollection*) _tmp9_, (ValaCodeNode*) _tmp10_);
		return;
	}
	_tmp11_ = iface;
	_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp13_, "Iface", NULL);
	gtype_struct_name = _tmp14_;
	vala_gir_writer_write_indent (self);
	_tmp15_ = self->priv->buffer;
	_tmp16_ = iface;
	_tmp17_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) _tmp16_);
	_tmp18_ = _tmp17_;
	g_string_append_printf (_tmp15_, "<interface name=\"%s\"", _tmp18_);
	_g_free0 (_tmp18_);
	_tmp19_ = iface;
	vala_gir_writer_write_gtype_attributes (self, (ValaTypeSymbol*) _tmp19_);
	_tmp20_ = self->priv->buffer;
	_tmp21_ = gtype_struct_name;
	g_string_append_printf (_tmp20_, " glib:type-struct=\"%s\"", _tmp21_);
	_tmp22_ = iface;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp22_);
	_tmp23_ = self->priv->buffer;
	g_string_append_printf (_tmp23_, ">\n");
	_tmp24_ = self->priv->indent;
	self->priv->indent = _tmp24_ + 1;
	_tmp25_ = iface;
	_tmp26_ = vala_gir_writer_get_interface_comment (self, _tmp25_);
	_tmp27_ = _tmp26_;
	vala_gir_writer_write_doc (self, _tmp27_);
	_g_free0 (_tmp27_);
	_tmp28_ = iface;
	_tmp29_ = vala_interface_get_prerequisites (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = _tmp32_ > 0;
	_vala_iterable_unref0 (_tmp30_);
	if (_tmp33_) {
		{
			ValaList* _base_type_list = NULL;
			ValaInterface* _tmp34_;
			ValaList* _tmp35_;
			gint _base_type_size = 0;
			ValaList* _tmp36_;
			gint _tmp37_;
			gint _tmp38_;
			gint _base_type_index = 0;
			_tmp34_ = iface;
			_tmp35_ = vala_interface_get_prerequisites (_tmp34_);
			_base_type_list = _tmp35_;
			_tmp36_ = _base_type_list;
			_tmp37_ = vala_collection_get_size ((ValaCollection*) _tmp36_);
			_tmp38_ = _tmp37_;
			_base_type_size = _tmp38_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp39_;
				gint _tmp40_;
				gint _tmp41_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp42_;
				gint _tmp43_;
				gpointer _tmp44_;
				GString* _tmp45_;
				ValaDataType* _tmp46_;
				ValaObjectTypeSymbol* _tmp47_;
				ValaObjectTypeSymbol* _tmp48_;
				gchar* _tmp49_;
				gchar* _tmp50_;
				_tmp39_ = _base_type_index;
				_base_type_index = _tmp39_ + 1;
				_tmp40_ = _base_type_index;
				_tmp41_ = _base_type_size;
				if (!(_tmp40_ < _tmp41_)) {
					break;
				}
				_tmp42_ = _base_type_list;
				_tmp43_ = _base_type_index;
				_tmp44_ = vala_list_get (_tmp42_, _tmp43_);
				base_type = (ValaDataType*) _tmp44_;
				vala_gir_writer_write_indent (self);
				_tmp45_ = self->priv->buffer;
				_tmp46_ = base_type;
				_tmp47_ = vala_object_type_get_type_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp48_ = _tmp47_;
				_tmp49_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp48_);
				_tmp50_ = _tmp49_;
				g_string_append_printf (_tmp45_, "<prerequisite name=\"%s\"/>\n", _tmp50_);
				_g_free0 (_tmp50_);
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
	}
	_tmp51_ = iface;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp51_);
	_tmp52_ = self->priv->hierarchy;
	_tmp53_ = iface;
	vala_list_insert ((ValaList*) _tmp52_, 0, (ValaSymbol*) _tmp53_);
	_tmp54_ = iface;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp54_, (ValaCodeVisitor*) self);
	_tmp55_ = self->priv->hierarchy;
	_tmp56_ = vala_list_remove_at ((ValaList*) _tmp55_, 0);
	_tmp57_ = (ValaSymbol*) _tmp56_;
	_vala_code_node_unref0 (_tmp57_);
	_tmp58_ = self->priv->indent;
	self->priv->indent = _tmp58_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp59_ = self->priv->buffer;
	g_string_append_printf (_tmp59_, "</interface>\n");
	vala_gir_writer_write_indent (self);
	_tmp60_ = self->priv->buffer;
	_tmp61_ = gtype_struct_name;
	g_string_append_printf (_tmp60_, "<record name=\"%s\"", _tmp61_);
	_tmp62_ = iface;
	vala_gir_writer_write_ctype_attributes (self, (ValaTypeSymbol*) _tmp62_, "Iface");
	_tmp63_ = self->priv->buffer;
	_tmp64_ = iface;
	_tmp65_ = vala_symbol_get_name ((ValaSymbol*) _tmp64_);
	_tmp66_ = _tmp65_;
	g_string_append_printf (_tmp63_, " glib:is-gtype-struct-for=\"%s\"", _tmp66_);
	_tmp67_ = self->priv->buffer;
	g_string_append_printf (_tmp67_, ">\n");
	_tmp68_ = self->priv->indent;
	self->priv->indent = _tmp68_ + 1;
	vala_gir_writer_write_indent (self);
	_tmp69_ = self->priv->buffer;
	g_string_append_printf (_tmp69_, "<field name=\"parent_iface\">\n");
	_tmp70_ = self->priv->indent;
	self->priv->indent = _tmp70_ + 1;
	vala_gir_writer_write_indent (self);
	_tmp71_ = self->priv->buffer;
	g_string_append_printf (_tmp71_, "<type name=\"GObject.TypeInterface\" c:type=\"GTypeInterface\"/>\n");
	_tmp72_ = self->priv->indent;
	self->priv->indent = _tmp72_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp73_ = self->priv->buffer;
	g_string_append_printf (_tmp73_, "</field>\n");
	{
		ValaList* _m_list = NULL;
		ValaInterface* _tmp74_;
		ValaList* _tmp75_;
		gint _m_size = 0;
		ValaList* _tmp76_;
		gint _tmp77_;
		gint _tmp78_;
		gint _m_index = 0;
		_tmp74_ = iface;
		_tmp75_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp74_);
		_m_list = _tmp75_;
		_tmp76_ = _m_list;
		_tmp77_ = vala_collection_get_size ((ValaCollection*) _tmp76_);
		_tmp78_ = _tmp77_;
		_m_size = _tmp78_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp79_;
			gint _tmp80_;
			gint _tmp81_;
			ValaMethod* m = NULL;
			ValaList* _tmp82_;
			gint _tmp83_;
			gpointer _tmp84_;
			gboolean _tmp85_ = FALSE;
			ValaMethod* _tmp86_;
			gboolean _tmp87_;
			gboolean _tmp88_;
			_tmp79_ = _m_index;
			_m_index = _tmp79_ + 1;
			_tmp80_ = _m_index;
			_tmp81_ = _m_size;
			if (!(_tmp80_ < _tmp81_)) {
				break;
			}
			_tmp82_ = _m_list;
			_tmp83_ = _m_index;
			_tmp84_ = vala_list_get (_tmp82_, _tmp83_);
			m = (ValaMethod*) _tmp84_;
			_tmp86_ = m;
			_tmp87_ = vala_method_get_is_abstract (_tmp86_);
			_tmp88_ = _tmp87_;
			if (_tmp88_) {
				_tmp85_ = TRUE;
			} else {
				ValaMethod* _tmp89_;
				gboolean _tmp90_;
				gboolean _tmp91_;
				_tmp89_ = m;
				_tmp90_ = vala_method_get_is_virtual (_tmp89_);
				_tmp91_ = _tmp90_;
				_tmp85_ = _tmp91_;
			}
			if (_tmp85_) {
				ValaMethod* _tmp92_;
				gboolean _tmp93_;
				gboolean _tmp94_;
				_tmp92_ = m;
				_tmp93_ = vala_method_get_coroutine (_tmp92_);
				_tmp94_ = _tmp93_;
				if (_tmp94_) {
					gchar* finish_name = NULL;
					ValaMethod* _tmp95_;
					const gchar* _tmp96_;
					const gchar* _tmp97_;
					gchar* _tmp98_;
					const gchar* _tmp99_;
					gboolean _tmp100_;
					const gchar* _tmp108_;
					gchar* _tmp109_;
					GString* _tmp110_;
					ValaMethod* _tmp111_;
					const gchar* _tmp112_;
					const gchar* _tmp113_;
					gint _tmp114_;
					ValaMethod* _tmp115_;
					ValaMethod* _tmp116_;
					const gchar* _tmp117_;
					const gchar* _tmp118_;
					ValaMethod* _tmp119_;
					gchar* _tmp120_;
					gchar* _tmp121_;
					ValaMethod* _tmp122_;
					ValaList* _tmp123_;
					ValaList* _tmp124_;
					ValaVoidType* _tmp125_;
					ValaVoidType* _tmp126_;
					gint _tmp127_;
					GString* _tmp128_;
					GString* _tmp129_;
					const gchar* _tmp130_;
					gint _tmp131_;
					ValaMethod* _tmp132_;
					const gchar* _tmp133_;
					ValaMethod* _tmp134_;
					gchar* _tmp135_;
					gchar* _tmp136_;
					ValaMethod* _tmp137_;
					ValaList* _tmp138_;
					ValaList* _tmp139_;
					ValaMethod* _tmp140_;
					ValaDataType* _tmp141_;
					ValaDataType* _tmp142_;
					ValaMethod* _tmp143_;
					gboolean _tmp144_;
					gboolean _tmp145_;
					gint _tmp146_;
					GString* _tmp147_;
					_tmp95_ = m;
					_tmp96_ = vala_symbol_get_name ((ValaSymbol*) _tmp95_);
					_tmp97_ = _tmp96_;
					_tmp98_ = g_strdup (_tmp97_);
					finish_name = _tmp98_;
					_tmp99_ = finish_name;
					_tmp100_ = g_str_has_suffix (_tmp99_, "_async");
					if (_tmp100_) {
						const gchar* _tmp101_;
						const gchar* _tmp102_;
						gint _tmp103_;
						gint _tmp104_;
						gint _tmp105_;
						gint _tmp106_;
						gchar* _tmp107_;
						_tmp101_ = finish_name;
						_tmp102_ = finish_name;
						_tmp103_ = strlen (_tmp102_);
						_tmp104_ = _tmp103_;
						_tmp105_ = strlen ("_async");
						_tmp106_ = _tmp105_;
						_tmp107_ = string_substring (_tmp101_, (glong) 0, (glong) (_tmp104_ - _tmp106_));
						_g_free0 (finish_name);
						finish_name = _tmp107_;
					}
					_tmp108_ = finish_name;
					_tmp109_ = g_strconcat (_tmp108_, "_finish", NULL);
					_g_free0 (finish_name);
					finish_name = _tmp109_;
					vala_gir_writer_write_indent (self);
					_tmp110_ = self->priv->buffer;
					_tmp111_ = m;
					_tmp112_ = vala_symbol_get_name ((ValaSymbol*) _tmp111_);
					_tmp113_ = _tmp112_;
					g_string_append_printf (_tmp110_, "<field name=\"%s\">\n", _tmp113_);
					_tmp114_ = self->priv->indent;
					self->priv->indent = _tmp114_ + 1;
					_tmp115_ = m;
					_tmp116_ = m;
					_tmp117_ = vala_symbol_get_name ((ValaSymbol*) _tmp116_);
					_tmp118_ = _tmp117_;
					_tmp119_ = m;
					_tmp120_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp119_);
					_tmp121_ = _tmp120_;
					_tmp122_ = m;
					_tmp123_ = vala_method_get_async_begin_parameters (_tmp122_);
					_tmp124_ = _tmp123_;
					_tmp125_ = vala_void_type_new (NULL);
					_tmp126_ = _tmp125_;
					vala_gir_writer_do_write_signature (self, _tmp115_, "callback", TRUE, _tmp118_, _tmp121_, _tmp124_, (ValaDataType*) _tmp126_, FALSE, FALSE);
					_vala_code_node_unref0 (_tmp126_);
					_vala_iterable_unref0 (_tmp124_);
					_g_free0 (_tmp121_);
					_tmp127_ = self->priv->indent;
					self->priv->indent = _tmp127_ - 1;
					vala_gir_writer_write_indent (self);
					_tmp128_ = self->priv->buffer;
					g_string_append_printf (_tmp128_, "</field>\n");
					vala_gir_writer_write_indent (self);
					_tmp129_ = self->priv->buffer;
					_tmp130_ = finish_name;
					g_string_append_printf (_tmp129_, "<field name=\"%s\">\n", _tmp130_);
					_tmp131_ = self->priv->indent;
					self->priv->indent = _tmp131_ + 1;
					_tmp132_ = m;
					_tmp133_ = finish_name;
					_tmp134_ = m;
					_tmp135_ = vala_ccode_base_module_get_ccode_finish_name (_tmp134_);
					_tmp136_ = _tmp135_;
					_tmp137_ = m;
					_tmp138_ = vala_method_get_async_end_parameters (_tmp137_);
					_tmp139_ = _tmp138_;
					_tmp140_ = m;
					_tmp141_ = vala_callable_get_return_type ((ValaCallable*) _tmp140_);
					_tmp142_ = _tmp141_;
					_tmp143_ = m;
					_tmp144_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp143_);
					_tmp145_ = _tmp144_;
					vala_gir_writer_do_write_signature (self, _tmp132_, "callback", TRUE, _tmp133_, _tmp136_, _tmp139_, _tmp142_, _tmp145_, FALSE);
					_vala_iterable_unref0 (_tmp139_);
					_g_free0 (_tmp136_);
					_tmp146_ = self->priv->indent;
					self->priv->indent = _tmp146_ - 1;
					vala_gir_writer_write_indent (self);
					_tmp147_ = self->priv->buffer;
					g_string_append_printf (_tmp147_, "</field>\n");
					_g_free0 (finish_name);
				} else {
					GString* _tmp148_;
					ValaMethod* _tmp149_;
					const gchar* _tmp150_;
					const gchar* _tmp151_;
					gint _tmp152_;
					ValaMethod* _tmp153_;
					ValaMethod* _tmp154_;
					const gchar* _tmp155_;
					const gchar* _tmp156_;
					ValaMethod* _tmp157_;
					gchar* _tmp158_;
					gchar* _tmp159_;
					ValaMethod* _tmp160_;
					ValaList* _tmp161_;
					ValaList* _tmp162_;
					ValaMethod* _tmp163_;
					ValaDataType* _tmp164_;
					ValaDataType* _tmp165_;
					ValaMethod* _tmp166_;
					gboolean _tmp167_;
					gboolean _tmp168_;
					gint _tmp169_;
					GString* _tmp170_;
					vala_gir_writer_write_indent (self);
					_tmp148_ = self->priv->buffer;
					_tmp149_ = m;
					_tmp150_ = vala_symbol_get_name ((ValaSymbol*) _tmp149_);
					_tmp151_ = _tmp150_;
					g_string_append_printf (_tmp148_, "<field name=\"%s\">\n", _tmp151_);
					_tmp152_ = self->priv->indent;
					self->priv->indent = _tmp152_ + 1;
					_tmp153_ = m;
					_tmp154_ = m;
					_tmp155_ = vala_symbol_get_name ((ValaSymbol*) _tmp154_);
					_tmp156_ = _tmp155_;
					_tmp157_ = m;
					_tmp158_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp157_);
					_tmp159_ = _tmp158_;
					_tmp160_ = m;
					_tmp161_ = vala_callable_get_parameters ((ValaCallable*) _tmp160_);
					_tmp162_ = _tmp161_;
					_tmp163_ = m;
					_tmp164_ = vala_callable_get_return_type ((ValaCallable*) _tmp163_);
					_tmp165_ = _tmp164_;
					_tmp166_ = m;
					_tmp167_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp166_);
					_tmp168_ = _tmp167_;
					vala_gir_writer_do_write_signature (self, _tmp153_, "callback", TRUE, _tmp156_, _tmp159_, _tmp162_, _tmp165_, _tmp168_, FALSE);
					_vala_iterable_unref0 (_tmp162_);
					_g_free0 (_tmp159_);
					_tmp169_ = self->priv->indent;
					self->priv->indent = _tmp169_ - 1;
					vala_gir_writer_write_indent (self);
					_tmp170_ = self->priv->buffer;
					g_string_append_printf (_tmp170_, "</field>\n");
				}
			}
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaInterface* _tmp171_;
		ValaList* _tmp172_;
		gint _prop_size = 0;
		ValaList* _tmp173_;
		gint _tmp174_;
		gint _tmp175_;
		gint _prop_index = 0;
		_tmp171_ = iface;
		_tmp172_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp171_);
		_prop_list = _tmp172_;
		_tmp173_ = _prop_list;
		_tmp174_ = vala_collection_get_size ((ValaCollection*) _tmp173_);
		_tmp175_ = _tmp174_;
		_prop_size = _tmp175_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp176_;
			gint _tmp177_;
			gint _tmp178_;
			ValaProperty* prop = NULL;
			ValaList* _tmp179_;
			gint _tmp180_;
			gpointer _tmp181_;
			gboolean _tmp182_ = FALSE;
			ValaProperty* _tmp183_;
			gboolean _tmp184_;
			gboolean _tmp185_;
			_tmp176_ = _prop_index;
			_prop_index = _tmp176_ + 1;
			_tmp177_ = _prop_index;
			_tmp178_ = _prop_size;
			if (!(_tmp177_ < _tmp178_)) {
				break;
			}
			_tmp179_ = _prop_list;
			_tmp180_ = _prop_index;
			_tmp181_ = vala_list_get (_tmp179_, _tmp180_);
			prop = (ValaProperty*) _tmp181_;
			_tmp183_ = prop;
			_tmp184_ = vala_property_get_is_abstract (_tmp183_);
			_tmp185_ = _tmp184_;
			if (_tmp185_) {
				_tmp182_ = TRUE;
			} else {
				ValaProperty* _tmp186_;
				gboolean _tmp187_;
				gboolean _tmp188_;
				_tmp186_ = prop;
				_tmp187_ = vala_property_get_is_virtual (_tmp186_);
				_tmp188_ = _tmp187_;
				_tmp182_ = _tmp188_;
			}
			if (_tmp182_) {
				ValaProperty* _tmp189_;
				ValaPropertyAccessor* _tmp190_;
				ValaPropertyAccessor* _tmp191_;
				ValaProperty* _tmp219_;
				ValaPropertyAccessor* _tmp220_;
				ValaPropertyAccessor* _tmp221_;
				_tmp189_ = prop;
				_tmp190_ = vala_property_get_get_accessor (_tmp189_);
				_tmp191_ = _tmp190_;
				if (_tmp191_ != NULL) {
					ValaMethod* m = NULL;
					ValaProperty* _tmp192_;
					ValaPropertyAccessor* _tmp193_;
					ValaPropertyAccessor* _tmp194_;
					ValaMethod* _tmp195_;
					GString* _tmp196_;
					ValaMethod* _tmp197_;
					const gchar* _tmp198_;
					const gchar* _tmp199_;
					gint _tmp200_;
					ValaMethod* _tmp201_;
					ValaMethod* _tmp202_;
					const gchar* _tmp203_;
					const gchar* _tmp204_;
					ValaMethod* _tmp205_;
					gchar* _tmp206_;
					gchar* _tmp207_;
					ValaMethod* _tmp208_;
					ValaList* _tmp209_;
					ValaList* _tmp210_;
					ValaMethod* _tmp211_;
					ValaDataType* _tmp212_;
					ValaDataType* _tmp213_;
					ValaMethod* _tmp214_;
					gboolean _tmp215_;
					gboolean _tmp216_;
					gint _tmp217_;
					GString* _tmp218_;
					_tmp192_ = prop;
					_tmp193_ = vala_property_get_get_accessor (_tmp192_);
					_tmp194_ = _tmp193_;
					_tmp195_ = vala_property_accessor_get_method (_tmp194_);
					m = _tmp195_;
					vala_gir_writer_write_indent (self);
					_tmp196_ = self->priv->buffer;
					_tmp197_ = m;
					_tmp198_ = vala_symbol_get_name ((ValaSymbol*) _tmp197_);
					_tmp199_ = _tmp198_;
					g_string_append_printf (_tmp196_, "<field name=\"%s\">\n", _tmp199_);
					_tmp200_ = self->priv->indent;
					self->priv->indent = _tmp200_ + 1;
					_tmp201_ = m;
					_tmp202_ = m;
					_tmp203_ = vala_symbol_get_name ((ValaSymbol*) _tmp202_);
					_tmp204_ = _tmp203_;
					_tmp205_ = m;
					_tmp206_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp205_);
					_tmp207_ = _tmp206_;
					_tmp208_ = m;
					_tmp209_ = vala_callable_get_parameters ((ValaCallable*) _tmp208_);
					_tmp210_ = _tmp209_;
					_tmp211_ = m;
					_tmp212_ = vala_callable_get_return_type ((ValaCallable*) _tmp211_);
					_tmp213_ = _tmp212_;
					_tmp214_ = m;
					_tmp215_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp214_);
					_tmp216_ = _tmp215_;
					vala_gir_writer_do_write_signature (self, _tmp201_, "callback", TRUE, _tmp204_, _tmp207_, _tmp210_, _tmp213_, _tmp216_, FALSE);
					_vala_iterable_unref0 (_tmp210_);
					_g_free0 (_tmp207_);
					_tmp217_ = self->priv->indent;
					self->priv->indent = _tmp217_ - 1;
					vala_gir_writer_write_indent (self);
					_tmp218_ = self->priv->buffer;
					g_string_append_printf (_tmp218_, "</field>\n");
					_vala_code_node_unref0 (m);
				}
				_tmp219_ = prop;
				_tmp220_ = vala_property_get_set_accessor (_tmp219_);
				_tmp221_ = _tmp220_;
				if (_tmp221_ != NULL) {
					ValaMethod* m = NULL;
					ValaProperty* _tmp222_;
					ValaPropertyAccessor* _tmp223_;
					ValaPropertyAccessor* _tmp224_;
					ValaMethod* _tmp225_;
					GString* _tmp226_;
					ValaMethod* _tmp227_;
					const gchar* _tmp228_;
					const gchar* _tmp229_;
					gint _tmp230_;
					ValaMethod* _tmp231_;
					ValaMethod* _tmp232_;
					const gchar* _tmp233_;
					const gchar* _tmp234_;
					ValaMethod* _tmp235_;
					gchar* _tmp236_;
					gchar* _tmp237_;
					ValaMethod* _tmp238_;
					ValaList* _tmp239_;
					ValaList* _tmp240_;
					ValaMethod* _tmp241_;
					ValaDataType* _tmp242_;
					ValaDataType* _tmp243_;
					ValaMethod* _tmp244_;
					gboolean _tmp245_;
					gboolean _tmp246_;
					gint _tmp247_;
					GString* _tmp248_;
					_tmp222_ = prop;
					_tmp223_ = vala_property_get_set_accessor (_tmp222_);
					_tmp224_ = _tmp223_;
					_tmp225_ = vala_property_accessor_get_method (_tmp224_);
					m = _tmp225_;
					vala_gir_writer_write_indent (self);
					_tmp226_ = self->priv->buffer;
					_tmp227_ = m;
					_tmp228_ = vala_symbol_get_name ((ValaSymbol*) _tmp227_);
					_tmp229_ = _tmp228_;
					g_string_append_printf (_tmp226_, "<field name=\"%s\">\n", _tmp229_);
					_tmp230_ = self->priv->indent;
					self->priv->indent = _tmp230_ + 1;
					_tmp231_ = m;
					_tmp232_ = m;
					_tmp233_ = vala_symbol_get_name ((ValaSymbol*) _tmp232_);
					_tmp234_ = _tmp233_;
					_tmp235_ = m;
					_tmp236_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp235_);
					_tmp237_ = _tmp236_;
					_tmp238_ = m;
					_tmp239_ = vala_callable_get_parameters ((ValaCallable*) _tmp238_);
					_tmp240_ = _tmp239_;
					_tmp241_ = m;
					_tmp242_ = vala_callable_get_return_type ((ValaCallable*) _tmp241_);
					_tmp243_ = _tmp242_;
					_tmp244_ = m;
					_tmp245_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp244_);
					_tmp246_ = _tmp245_;
					vala_gir_writer_do_write_signature (self, _tmp231_, "callback", TRUE, _tmp234_, _tmp237_, _tmp240_, _tmp243_, _tmp246_, FALSE);
					_vala_iterable_unref0 (_tmp240_);
					_g_free0 (_tmp237_);
					_tmp247_ = self->priv->indent;
					self->priv->indent = _tmp247_ - 1;
					vala_gir_writer_write_indent (self);
					_tmp248_ = self->priv->buffer;
					g_string_append_printf (_tmp248_, "</field>\n");
					_vala_code_node_unref0 (m);
				}
			}
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	_tmp249_ = self->priv->indent;
	self->priv->indent = _tmp249_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp250_ = self->priv->buffer;
	g_string_append_printf (_tmp250_, "</record>\n");
	vala_gir_writer_visit_deferred (self);
	_g_free0 (gtype_struct_name);
}


static void vala_gir_writer_visit_deferred (ValaGIRWriter* self) {
	ValaArrayList* nodes = NULL;
	ValaArrayList* _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->deferred;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	nodes = _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_CODE_NODE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	_vala_iterable_unref0 (self->priv->deferred);
	self->priv->deferred = _tmp3_;
	{
		ValaArrayList* _node_list = NULL;
		ValaArrayList* _tmp4_;
		ValaArrayList* _tmp5_;
		gint _node_size = 0;
		ValaArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _node_index = 0;
		_tmp4_ = nodes;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_node_list = _tmp5_;
		_tmp6_ = _node_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_node_size = _tmp8_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			ValaCodeNode* node = NULL;
			ValaArrayList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_;
			ValaCodeNode* _tmp15_;
			_tmp9_ = _node_index;
			_node_index = _tmp9_ + 1;
			_tmp10_ = _node_index;
			_tmp11_ = _node_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _node_list;
			_tmp13_ = _node_index;
			_tmp14_ = vala_list_get ((ValaList*) _tmp12_, _tmp13_);
			node = (ValaCodeNode*) _tmp14_;
			_tmp15_ = node;
			vala_code_node_accept (_tmp15_, (ValaCodeVisitor*) self);
			_vala_code_node_unref0 (node);
		}
		_vala_iterable_unref0 (_node_list);
	}
	_vala_iterable_unref0 (nodes);
}


static gchar* vala_gir_writer_get_gir_name (ValaGIRWriter* self, ValaSymbol* symbol) {
	gchar* result = NULL;
	gchar* gir_name = NULL;
	ValaSymbol* h0 = NULL;
	ValaArrayList* _tmp0_;
	gpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	gir_name = NULL;
	_tmp0_ = self->priv->hierarchy;
	_tmp1_ = vala_list_get ((ValaList*) _tmp0_, 0);
	h0 = (ValaSymbol*) _tmp1_;
	{
		ValaSymbol* cur_sym = NULL;
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		_tmp2_ = symbol;
		_tmp3_ = _vala_code_node_ref0 (_tmp2_);
		cur_sym = _tmp3_;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				ValaSymbol* _tmp9_;
				ValaSymbol* _tmp10_;
				ValaSymbol* _tmp11_;
				gchar* cur_name = NULL;
				ValaSymbol* _tmp12_;
				gchar* _tmp13_;
				const gchar* _tmp14_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				gchar* _tmp21_;
				if (!_tmp4_) {
					ValaSymbol* _tmp5_;
					ValaSymbol* _tmp6_;
					ValaSymbol* _tmp7_;
					ValaSymbol* _tmp8_;
					_tmp5_ = cur_sym;
					_tmp6_ = vala_symbol_get_parent_symbol (_tmp5_);
					_tmp7_ = _tmp6_;
					_tmp8_ = _vala_code_node_ref0 (_tmp7_);
					_vala_code_node_unref0 (cur_sym);
					cur_sym = _tmp8_;
				}
				_tmp4_ = FALSE;
				_tmp9_ = cur_sym;
				if (!(_tmp9_ != NULL)) {
					break;
				}
				_tmp10_ = cur_sym;
				_tmp11_ = h0;
				if (_tmp10_ == _tmp11_) {
					break;
				}
				_tmp12_ = cur_sym;
				_tmp13_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp12_, "GIR", "name", NULL);
				cur_name = _tmp13_;
				_tmp14_ = cur_name;
				if (_tmp14_ == NULL) {
					ValaSymbol* _tmp15_;
					const gchar* _tmp16_;
					const gchar* _tmp17_;
					gchar* _tmp18_;
					_tmp15_ = cur_sym;
					_tmp16_ = vala_symbol_get_name (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = g_strdup (_tmp17_);
					_g_free0 (cur_name);
					cur_name = _tmp18_;
				}
				_tmp19_ = cur_name;
				_tmp20_ = gir_name;
				_tmp21_ = g_strconcat (_tmp19_, _tmp20_, NULL);
				_g_free0 (gir_name);
				gir_name = _tmp21_;
				_g_free0 (cur_name);
			}
		}
		_vala_code_node_unref0 (cur_sym);
	}
	result = gir_name;
	_vala_code_node_unref0 (h0);
	return result;
}


static void vala_gir_writer_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en) {
	ValaGIRWriter * self;
	ValaEnum* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaEnum* _tmp3_;
	gboolean _tmp4_;
	ValaArrayList* _tmp5_;
	gpointer _tmp6_;
	ValaSymbol* _tmp7_;
	gboolean _tmp8_;
	const gchar* _tmp11_ = NULL;
	ValaEnum* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	gchar* element_name = NULL;
	gchar* _tmp15_;
	GString* _tmp16_;
	const gchar* _tmp17_;
	ValaEnum* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	ValaEnum* _tmp21_;
	ValaEnum* _tmp22_;
	GString* _tmp23_;
	gint _tmp24_;
	ValaEnum* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	ValaEnum* _tmp28_;
	ValaArrayList* _tmp29_;
	ValaEnum* _tmp30_;
	ValaEnum* _tmp31_;
	ValaArrayList* _tmp32_;
	gpointer _tmp33_;
	ValaSymbol* _tmp34_;
	gint _tmp35_;
	GString* _tmp36_;
	const gchar* _tmp37_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (en != NULL);
	_tmp0_ = en;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = en;
	_tmp4_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp3_);
	if (!_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->hierarchy;
	_tmp6_ = vala_list_get ((ValaList*) _tmp5_, 0);
	_tmp7_ = (ValaSymbol*) _tmp6_;
	_tmp8_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_NAMESPACE);
	_vala_code_node_unref0 (_tmp7_);
	if (_tmp8_) {
		ValaArrayList* _tmp9_;
		ValaEnum* _tmp10_;
		_tmp9_ = self->priv->deferred;
		_tmp10_ = en;
		vala_collection_add ((ValaCollection*) _tmp9_, (ValaCodeNode*) _tmp10_);
		return;
	}
	_tmp12_ = en;
	_tmp13_ = vala_enum_get_is_flags (_tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp14_) {
		_tmp11_ = "bitfield";
	} else {
		_tmp11_ = "enumeration";
	}
	_tmp15_ = g_strdup (_tmp11_);
	element_name = _tmp15_;
	vala_gir_writer_write_indent (self);
	_tmp16_ = self->priv->buffer;
	_tmp17_ = element_name;
	_tmp18_ = en;
	_tmp19_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) _tmp18_);
	_tmp20_ = _tmp19_;
	g_string_append_printf (_tmp16_, "<%s name=\"%s\"", _tmp17_, _tmp20_);
	_g_free0 (_tmp20_);
	_tmp21_ = en;
	vala_gir_writer_write_gtype_attributes (self, (ValaTypeSymbol*) _tmp21_);
	_tmp22_ = en;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp22_);
	_tmp23_ = self->priv->buffer;
	g_string_append_printf (_tmp23_, ">\n");
	_tmp24_ = self->priv->indent;
	self->priv->indent = _tmp24_ + 1;
	_tmp25_ = en;
	_tmp26_ = vala_gir_writer_get_enum_comment (self, _tmp25_);
	_tmp27_ = _tmp26_;
	vala_gir_writer_write_doc (self, _tmp27_);
	_g_free0 (_tmp27_);
	_tmp28_ = en;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp28_);
	self->priv->enum_value = 0;
	_tmp29_ = self->priv->hierarchy;
	_tmp30_ = en;
	vala_list_insert ((ValaList*) _tmp29_, 0, (ValaSymbol*) _tmp30_);
	_tmp31_ = en;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp31_, (ValaCodeVisitor*) self);
	_tmp32_ = self->priv->hierarchy;
	_tmp33_ = vala_list_remove_at ((ValaList*) _tmp32_, 0);
	_tmp34_ = (ValaSymbol*) _tmp33_;
	_vala_code_node_unref0 (_tmp34_);
	_tmp35_ = self->priv->indent;
	self->priv->indent = _tmp35_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp36_ = self->priv->buffer;
	_tmp37_ = element_name;
	g_string_append_printf (_tmp36_, "</%s>\n", _tmp37_);
	vala_gir_writer_visit_deferred (self);
	_g_free0 (element_name);
}


static void vala_gir_writer_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev) {
	ValaGIRWriter * self;
	ValaEnum* en = NULL;
	ValaArrayList* _tmp0_;
	gpointer _tmp1_;
	GString* _tmp2_;
	ValaEnumValue* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	ValaEnumValue* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaEnumValue* _tmp11_;
	ValaExpression* _tmp12_;
	ValaExpression* _tmp13_;
	ValaEnumValue* _tmp27_;
	gchar* comment = NULL;
	ValaEnumValue* _tmp28_;
	gchar* _tmp29_;
	const gchar* _tmp30_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (ev != NULL);
	vala_gir_writer_write_indent (self);
	_tmp0_ = self->priv->hierarchy;
	_tmp1_ = vala_list_get ((ValaList*) _tmp0_, 0);
	en = G_TYPE_CHECK_INSTANCE_CAST ((ValaSymbol*) _tmp1_, VALA_TYPE_ENUM, ValaEnum);
	_tmp2_ = self->priv->buffer;
	_tmp3_ = ev;
	_tmp4_ = vala_symbol_get_name ((ValaSymbol*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_utf8_strdown (_tmp5_, (gssize) -1);
	_tmp7_ = _tmp6_;
	_tmp8_ = ev;
	_tmp9_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp8_);
	_tmp10_ = _tmp9_;
	g_string_append_printf (_tmp2_, "<member name=\"%s\" c:identifier=\"%s\"", _tmp7_, _tmp10_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp7_);
	_tmp11_ = ev;
	_tmp12_ = vala_constant_get_value ((ValaConstant*) _tmp11_);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		gchar* value = NULL;
		ValaEnumValue* _tmp14_;
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		gchar* _tmp17_;
		GString* _tmp18_;
		const gchar* _tmp19_;
		_tmp14_ = ev;
		_tmp15_ = vala_constant_get_value ((ValaConstant*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_gir_writer_literal_expression_to_value_string (self, _tmp16_);
		value = _tmp17_;
		_tmp18_ = self->priv->buffer;
		_tmp19_ = value;
		g_string_append_printf (_tmp18_, " value=\"%s\"", _tmp19_);
		_g_free0 (value);
	} else {
		ValaEnum* _tmp20_;
		gboolean _tmp21_;
		gboolean _tmp22_;
		_tmp20_ = en;
		_tmp21_ = vala_enum_get_is_flags (_tmp20_);
		_tmp22_ = _tmp21_;
		if (_tmp22_) {
			GString* _tmp23_;
			gint _tmp24_;
			_tmp23_ = self->priv->buffer;
			_tmp24_ = self->priv->enum_value;
			self->priv->enum_value = _tmp24_ + 1;
			g_string_append_printf (_tmp23_, " value=\"%d\"", 1 << _tmp24_);
		} else {
			GString* _tmp25_;
			gint _tmp26_;
			_tmp25_ = self->priv->buffer;
			_tmp26_ = self->priv->enum_value;
			self->priv->enum_value = _tmp26_ + 1;
			g_string_append_printf (_tmp25_, " value=\"%d\"", _tmp26_);
		}
	}
	_tmp27_ = ev;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp27_);
	_tmp28_ = ev;
	_tmp29_ = vala_gir_writer_get_enum_value_comment (self, _tmp28_);
	comment = _tmp29_;
	_tmp30_ = comment;
	if (_tmp30_ == NULL) {
		GString* _tmp31_;
		_tmp31_ = self->priv->buffer;
		g_string_append_printf (_tmp31_, "/>\n");
	} else {
		GString* _tmp32_;
		gint _tmp33_;
		const gchar* _tmp34_;
		gint _tmp35_;
		GString* _tmp36_;
		_tmp32_ = self->priv->buffer;
		g_string_append_printf (_tmp32_, ">\n");
		_tmp33_ = self->priv->indent;
		self->priv->indent = _tmp33_ + 1;
		_tmp34_ = comment;
		vala_gir_writer_write_doc (self, _tmp34_);
		_tmp35_ = self->priv->indent;
		self->priv->indent = _tmp35_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp36_ = self->priv->buffer;
		g_string_append_printf (_tmp36_, "</member>\n");
	}
	_g_free0 (comment);
	_vala_code_node_unref0 (en);
}


static void vala_gir_writer_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* edomain) {
	ValaGIRWriter * self;
	ValaErrorDomain* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaErrorDomain* _tmp3_;
	gboolean _tmp4_;
	GString* _tmp5_;
	ValaErrorDomain* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	ValaErrorDomain* _tmp9_;
	GString* _tmp10_;
	ValaErrorDomain* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GString* _tmp14_;
	gint _tmp15_;
	ValaErrorDomain* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	ValaArrayList* _tmp19_;
	ValaErrorDomain* _tmp20_;
	ValaErrorDomain* _tmp21_;
	ValaArrayList* _tmp22_;
	gpointer _tmp23_;
	ValaSymbol* _tmp24_;
	gint _tmp25_;
	GString* _tmp26_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (edomain != NULL);
	_tmp0_ = edomain;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = edomain;
	_tmp4_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp3_);
	if (!_tmp4_) {
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp5_ = self->priv->buffer;
	_tmp6_ = edomain;
	_tmp7_ = vala_symbol_get_name ((ValaSymbol*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append_printf (_tmp5_, "<enumeration name=\"%s\"", _tmp8_);
	_tmp9_ = edomain;
	vala_gir_writer_write_ctype_attributes (self, (ValaTypeSymbol*) _tmp9_, "");
	_tmp10_ = self->priv->buffer;
	_tmp11_ = edomain;
	_tmp12_ = vala_ccode_base_module_get_quark_name (_tmp11_);
	_tmp13_ = _tmp12_;
	g_string_append_printf (_tmp10_, " glib:error-domain=\"%s\"", _tmp13_);
	_g_free0 (_tmp13_);
	_tmp14_ = self->priv->buffer;
	g_string_append_printf (_tmp14_, ">\n");
	_tmp15_ = self->priv->indent;
	self->priv->indent = _tmp15_ + 1;
	_tmp16_ = edomain;
	_tmp17_ = vala_gir_writer_get_error_domain_comment (self, _tmp16_);
	_tmp18_ = _tmp17_;
	vala_gir_writer_write_doc (self, _tmp18_);
	_g_free0 (_tmp18_);
	self->priv->enum_value = 0;
	_tmp19_ = self->priv->hierarchy;
	_tmp20_ = edomain;
	vala_list_insert ((ValaList*) _tmp19_, 0, (ValaSymbol*) _tmp20_);
	_tmp21_ = edomain;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp21_, (ValaCodeVisitor*) self);
	_tmp22_ = self->priv->hierarchy;
	_tmp23_ = vala_list_remove_at ((ValaList*) _tmp22_, 0);
	_tmp24_ = (ValaSymbol*) _tmp23_;
	_vala_code_node_unref0 (_tmp24_);
	_tmp25_ = self->priv->indent;
	self->priv->indent = _tmp25_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp26_ = self->priv->buffer;
	g_string_append_printf (_tmp26_, "</enumeration>\n");
	vala_gir_writer_visit_deferred (self);
}


static void vala_gir_writer_real_visit_error_code (ValaCodeVisitor* base, ValaErrorCode* ecode) {
	ValaGIRWriter * self;
	GString* _tmp0_;
	ValaErrorCode* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	ValaErrorCode* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	ValaErrorCode* _tmp9_;
	ValaExpression* _tmp10_;
	ValaExpression* _tmp11_;
	ValaErrorCode* _tmp20_;
	gchar* comment = NULL;
	ValaErrorCode* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (ecode != NULL);
	vala_gir_writer_write_indent (self);
	_tmp0_ = self->priv->buffer;
	_tmp1_ = ecode;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_utf8_strdown (_tmp3_, (gssize) -1);
	_tmp5_ = _tmp4_;
	_tmp6_ = ecode;
	_tmp7_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append_printf (_tmp0_, "<member name=\"%s\" c:identifier=\"%s\"", _tmp5_, _tmp8_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp5_);
	_tmp9_ = ecode;
	_tmp10_ = vala_error_code_get_value (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ != NULL) {
		gchar* value = NULL;
		ValaErrorCode* _tmp12_;
		ValaExpression* _tmp13_;
		ValaExpression* _tmp14_;
		gchar* _tmp15_;
		GString* _tmp16_;
		const gchar* _tmp17_;
		_tmp12_ = ecode;
		_tmp13_ = vala_error_code_get_value (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_gir_writer_literal_expression_to_value_string (self, _tmp14_);
		value = _tmp15_;
		_tmp16_ = self->priv->buffer;
		_tmp17_ = value;
		g_string_append_printf (_tmp16_, " value=\"%s\"", _tmp17_);
		_g_free0 (value);
	} else {
		GString* _tmp18_;
		gint _tmp19_;
		_tmp18_ = self->priv->buffer;
		_tmp19_ = self->priv->enum_value;
		self->priv->enum_value = _tmp19_ + 1;
		g_string_append_printf (_tmp18_, " value=\"%d\"", _tmp19_);
	}
	_tmp20_ = ecode;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp20_);
	_tmp21_ = ecode;
	_tmp22_ = vala_gir_writer_get_error_code_comment (self, _tmp21_);
	comment = _tmp22_;
	_tmp23_ = comment;
	if (_tmp23_ == NULL) {
		GString* _tmp24_;
		_tmp24_ = self->priv->buffer;
		g_string_append_printf (_tmp24_, "/>\n");
	} else {
		GString* _tmp25_;
		gint _tmp26_;
		const gchar* _tmp27_;
		gint _tmp28_;
		GString* _tmp29_;
		_tmp25_ = self->priv->buffer;
		g_string_append_printf (_tmp25_, ">\n");
		_tmp26_ = self->priv->indent;
		self->priv->indent = _tmp26_ + 1;
		_tmp27_ = comment;
		vala_gir_writer_write_doc (self, _tmp27_);
		_tmp28_ = self->priv->indent;
		self->priv->indent = _tmp28_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp29_ = self->priv->buffer;
		g_string_append_printf (_tmp29_, "</member>\n");
	}
	_g_free0 (comment);
}


static void vala_gir_writer_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c) {
	ValaGIRWriter * self;
	ValaConstant* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaConstant* _tmp3_;
	gboolean _tmp4_;
	ValaExpression* initializer = NULL;
	ValaConstant* _tmp5_;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	gchar* value = NULL;
	ValaExpression* _tmp9_;
	gchar* _tmp10_;
	GString* _tmp11_;
	ValaConstant* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	ValaConstant* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GString* _tmp18_;
	const gchar* _tmp19_;
	ValaConstant* _tmp20_;
	GString* _tmp21_;
	gint _tmp22_;
	ValaConstant* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	ValaExpression* _tmp26_;
	ValaDataType* _tmp27_;
	ValaDataType* _tmp28_;
	gint _tmp29_;
	GString* _tmp30_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = c;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = c;
	_tmp4_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp3_);
	if (!_tmp4_) {
		return;
	}
	_tmp5_ = c;
	_tmp6_ = vala_constant_get_value (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (_tmp7_);
	initializer = _tmp8_;
	_tmp9_ = initializer;
	_tmp10_ = vala_gir_writer_literal_expression_to_value_string (self, _tmp9_);
	value = _tmp10_;
	vala_gir_writer_write_indent (self);
	_tmp11_ = self->priv->buffer;
	_tmp12_ = c;
	_tmp13_ = vala_symbol_get_name ((ValaSymbol*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = c;
	_tmp16_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp15_);
	_tmp17_ = _tmp16_;
	g_string_append_printf (_tmp11_, "<constant name=\"%s\" c:identifier=\"%s\"", _tmp14_, _tmp17_);
	_g_free0 (_tmp17_);
	_tmp18_ = self->priv->buffer;
	_tmp19_ = value;
	g_string_append_printf (_tmp18_, " value=\"%s\"", _tmp19_);
	_tmp20_ = c;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp20_);
	_tmp21_ = self->priv->buffer;
	g_string_append_printf (_tmp21_, ">\n");
	_tmp22_ = self->priv->indent;
	self->priv->indent = _tmp22_ + 1;
	_tmp23_ = c;
	_tmp24_ = vala_gir_writer_get_constant_comment (self, _tmp23_);
	_tmp25_ = _tmp24_;
	vala_gir_writer_write_doc (self, _tmp25_);
	_g_free0 (_tmp25_);
	_tmp26_ = initializer;
	_tmp27_ = vala_expression_get_value_type (_tmp26_);
	_tmp28_ = _tmp27_;
	vala_gir_writer_write_type (self, _tmp28_, -1, VALA_PARAMETER_DIRECTION_IN);
	_tmp29_ = self->priv->indent;
	self->priv->indent = _tmp29_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp30_ = self->priv->buffer;
	g_string_append_printf (_tmp30_, "</constant>\n");
	_g_free0 (value);
	_vala_code_node_unref0 (initializer);
}


static void vala_gir_writer_real_visit_field (ValaCodeVisitor* base, ValaField* f) {
	ValaGIRWriter * self;
	ValaField* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaField* _tmp3_;
	gboolean _tmp4_;
	GString* _tmp5_;
	ValaField* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	ValaField* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	ValaField* _tmp15_;
	GString* _tmp16_;
	gint _tmp17_;
	ValaField* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	ValaField* _tmp21_;
	ValaField* _tmp22_;
	ValaDataType* _tmp23_;
	ValaDataType* _tmp24_;
	gint _tmp25_;
	GString* _tmp26_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (f != NULL);
	_tmp0_ = f;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = f;
	_tmp4_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp3_);
	if (!_tmp4_) {
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp5_ = self->priv->buffer;
	_tmp6_ = f;
	_tmp7_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append_printf (_tmp5_, "<field name=\"%s\"", _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = f;
	_tmp10_ = vala_variable_get_variable_type ((ValaVariable*) _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_data_type_get_nullable (_tmp11_);
	_tmp13_ = _tmp12_;
	if (_tmp13_) {
		GString* _tmp14_;
		_tmp14_ = self->priv->buffer;
		g_string_append_printf (_tmp14_, " allow-none=\"1\"");
	}
	_tmp15_ = f;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp15_);
	_tmp16_ = self->priv->buffer;
	g_string_append_printf (_tmp16_, ">\n");
	_tmp17_ = self->priv->indent;
	self->priv->indent = _tmp17_ + 1;
	_tmp18_ = f;
	_tmp19_ = vala_gir_writer_get_field_comment (self, _tmp18_);
	_tmp20_ = _tmp19_;
	vala_gir_writer_write_doc (self, _tmp20_);
	_g_free0 (_tmp20_);
	_tmp21_ = f;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp21_);
	_tmp22_ = f;
	_tmp23_ = vala_variable_get_variable_type ((ValaVariable*) _tmp22_);
	_tmp24_ = _tmp23_;
	vala_gir_writer_write_type (self, _tmp24_, -1, VALA_PARAMETER_DIRECTION_IN);
	_tmp25_ = self->priv->indent;
	self->priv->indent = _tmp25_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp26_ = self->priv->buffer;
	g_string_append_printf (_tmp26_, "</field>\n");
}


static void vala_gir_writer_write_implicit_params (ValaGIRWriter* self, ValaDataType* type, gint* index, gboolean has_array_length, const gchar* name, ValaParameterDirection direction) {
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (name != NULL);
	_tmp1_ = type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_ARRAY_TYPE)) {
		gboolean _tmp2_;
		_tmp2_ = has_array_length;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaIntegerType* int_type = NULL;
		ValaCodeContext* _tmp3_;
		ValaCodeContext* _tmp4_;
		ValaNamespace* _tmp5_;
		ValaNamespace* _tmp6_;
		ValaScope* _tmp7_;
		ValaScope* _tmp8_;
		ValaSymbol* _tmp9_;
		ValaStruct* _tmp10_;
		ValaStruct* _tmp11_;
		ValaIntegerType* _tmp12_;
		ValaIntegerType* _tmp13_;
		_tmp3_ = vala_code_context_get ();
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_code_context_get_root (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_symbol_get_scope ((ValaSymbol*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_scope_lookup (_tmp8_, "int");
		_tmp10_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp9_) : NULL;
		if (_tmp10_ == NULL) {
			_vala_code_node_unref0 (_tmp9_);
		}
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_integer_type_new (_tmp11_, NULL, NULL);
		_tmp13_ = _tmp12_;
		_vala_code_node_unref0 (_tmp11_);
		_vala_code_context_unref0 (_tmp4_);
		int_type = _tmp13_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp14_ = FALSE;
				_tmp14_ = TRUE;
				while (TRUE) {
					gint _tmp16_;
					ValaDataType* _tmp17_;
					gint _tmp18_;
					gint _tmp19_;
					ValaIntegerType* _tmp20_;
					gboolean _tmp21_;
					const gchar* _tmp22_;
					gint _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					ValaParameterDirection _tmp26_;
					if (!_tmp14_) {
						gint _tmp15_;
						_tmp15_ = i;
						i = _tmp15_ + 1;
					}
					_tmp14_ = FALSE;
					_tmp16_ = i;
					_tmp17_ = type;
					_tmp18_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp19_ = _tmp18_;
					if (!(_tmp16_ < _tmp19_)) {
						break;
					}
					_tmp20_ = int_type;
					_tmp21_ = has_array_length;
					_tmp22_ = name;
					_tmp23_ = i;
					_tmp24_ = g_strdup_printf ("%s_length%i", _tmp22_, _tmp23_ + 1);
					_tmp25_ = _tmp24_;
					_tmp26_ = direction;
					vala_gir_writer_write_param_or_return (self, (ValaDataType*) _tmp20_, TRUE, index, _tmp21_, _tmp25_, NULL, _tmp26_, FALSE, FALSE);
					_g_free0 (_tmp25_);
				}
			}
		}
		_vala_code_node_unref0 (int_type);
	} else {
		ValaDataType* _tmp27_;
		_tmp27_ = type;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, VALA_TYPE_DELEGATE_TYPE)) {
			ValaDelegateType* deleg_type = NULL;
			ValaDataType* _tmp28_;
			ValaDelegateType* _tmp29_;
			ValaDelegateType* _tmp30_;
			ValaDelegate* _tmp31_;
			ValaDelegate* _tmp32_;
			gboolean _tmp33_;
			gboolean _tmp34_;
			_tmp28_ = type;
			_tmp29_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp29_;
			_tmp30_ = deleg_type;
			_tmp31_ = vala_delegate_type_get_delegate_symbol (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = vala_delegate_get_has_target (_tmp32_);
			_tmp34_ = _tmp33_;
			if (_tmp34_) {
				ValaPointerType* data_type = NULL;
				ValaVoidType* _tmp35_;
				ValaVoidType* _tmp36_;
				ValaPointerType* _tmp37_;
				ValaPointerType* _tmp38_;
				ValaPointerType* _tmp39_;
				const gchar* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				ValaParameterDirection _tmp43_;
				ValaDelegateType* _tmp44_;
				gboolean _tmp45_;
				_tmp35_ = vala_void_type_new (NULL);
				_tmp36_ = _tmp35_;
				_tmp37_ = vala_pointer_type_new ((ValaDataType*) _tmp36_, NULL);
				_tmp38_ = _tmp37_;
				_vala_code_node_unref0 (_tmp36_);
				data_type = _tmp38_;
				_tmp39_ = data_type;
				_tmp40_ = name;
				_tmp41_ = g_strdup_printf ("%s_target", _tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = direction;
				vala_gir_writer_write_param_or_return (self, (ValaDataType*) _tmp39_, TRUE, index, FALSE, _tmp42_, NULL, _tmp43_, FALSE, FALSE);
				_g_free0 (_tmp42_);
				_tmp44_ = deleg_type;
				_tmp45_ = vala_data_type_is_disposable ((ValaDataType*) _tmp44_);
				if (_tmp45_) {
					ValaDelegateType* notify_type = NULL;
					ValaCodeContext* _tmp46_;
					ValaCodeContext* _tmp47_;
					ValaNamespace* _tmp48_;
					ValaNamespace* _tmp49_;
					ValaScope* _tmp50_;
					ValaScope* _tmp51_;
					ValaSymbol* _tmp52_;
					ValaSymbol* _tmp53_;
					ValaScope* _tmp54_;
					ValaScope* _tmp55_;
					ValaSymbol* _tmp56_;
					ValaDelegate* _tmp57_;
					ValaDelegate* _tmp58_;
					ValaDelegateType* _tmp59_;
					ValaDelegateType* _tmp60_;
					ValaDelegateType* _tmp61_;
					const gchar* _tmp62_;
					gchar* _tmp63_;
					gchar* _tmp64_;
					ValaParameterDirection _tmp65_;
					_tmp46_ = vala_code_context_get ();
					_tmp47_ = _tmp46_;
					_tmp48_ = vala_code_context_get_root (_tmp47_);
					_tmp49_ = _tmp48_;
					_tmp50_ = vala_symbol_get_scope ((ValaSymbol*) _tmp49_);
					_tmp51_ = _tmp50_;
					_tmp52_ = vala_scope_lookup (_tmp51_, "GLib");
					_tmp53_ = _tmp52_;
					_tmp54_ = vala_symbol_get_scope (_tmp53_);
					_tmp55_ = _tmp54_;
					_tmp56_ = vala_scope_lookup (_tmp55_, "DestroyNotify");
					_tmp57_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp56_, VALA_TYPE_DELEGATE) ? ((ValaDelegate*) _tmp56_) : NULL;
					if (_tmp57_ == NULL) {
						_vala_code_node_unref0 (_tmp56_);
					}
					_tmp58_ = _tmp57_;
					_tmp59_ = vala_delegate_type_new (_tmp58_);
					_tmp60_ = _tmp59_;
					_vala_code_node_unref0 (_tmp58_);
					_vala_code_node_unref0 (_tmp53_);
					_vala_code_context_unref0 (_tmp47_);
					notify_type = _tmp60_;
					_tmp61_ = notify_type;
					_tmp62_ = name;
					_tmp63_ = g_strdup_printf ("%s_target_destroy_notify", _tmp62_);
					_tmp64_ = _tmp63_;
					_tmp65_ = direction;
					vala_gir_writer_write_param_or_return (self, (ValaDataType*) _tmp61_, TRUE, index, FALSE, _tmp64_, NULL, _tmp65_, FALSE, FALSE);
					_g_free0 (_tmp64_);
					_vala_code_node_unref0 (notify_type);
				}
				_vala_code_node_unref0 (data_type);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
}


static void vala_gir_writer_skip_implicit_params (ValaGIRWriter* self, ValaDataType* type, gint* index, gboolean has_array_length) {
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp1_ = type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_ARRAY_TYPE)) {
		gboolean _tmp2_;
		_tmp2_ = has_array_length;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint _tmp3_;
		ValaDataType* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp3_ = *index;
		_tmp4_ = type;
		_tmp5_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		_tmp6_ = _tmp5_;
		*index = _tmp3_ + _tmp6_;
	} else {
		ValaDataType* _tmp7_;
		_tmp7_ = type;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_DELEGATE_TYPE)) {
			gint _tmp8_;
			ValaDelegateType* deleg_type = NULL;
			ValaDataType* _tmp9_;
			ValaDelegateType* _tmp10_;
			ValaDelegateType* _tmp11_;
			gboolean _tmp12_;
			_tmp8_ = *index;
			*index = _tmp8_ + 1;
			_tmp9_ = type;
			_tmp10_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp10_;
			_tmp11_ = deleg_type;
			_tmp12_ = vala_data_type_is_disposable ((ValaDataType*) _tmp11_);
			if (_tmp12_) {
				gint _tmp13_;
				_tmp13_ = *index;
				*index = _tmp13_ + 1;
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
}


static void vala_gir_writer_write_params_and_return (ValaGIRWriter* self, ValaList* params, ValaDataType* return_type, gboolean return_array_length, const gchar* return_comment, gboolean constructor, ValaDataType* instance_type, gboolean user_data) {
	gint last_index = 0;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	gboolean ret_is_struct = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	ValaList* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gboolean _tmp48_ = FALSE;
	ValaDataType* _tmp49_;
	gboolean _tmp59_ = FALSE;
	gboolean _tmp60_ = FALSE;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	ValaList* _tmp63_;
	gint _tmp64_;
	gint _tmp65_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (params != NULL);
	last_index = 0;
	_tmp1_ = return_type;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = return_type;
		_tmp3_ = vala_data_type_is_real_non_null_struct_type (_tmp2_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	ret_is_struct = _tmp0_;
	_tmp8_ = params;
	_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != 0) {
		_tmp7_ = TRUE;
	} else {
		ValaDataType* _tmp11_;
		_tmp11_ = instance_type;
		_tmp7_ = _tmp11_ != NULL;
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		gboolean _tmp12_ = FALSE;
		ValaDataType* _tmp13_;
		_tmp13_ = return_type;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, VALA_TYPE_ARRAY_TYPE)) {
			gboolean _tmp14_;
			_tmp14_ = return_array_length;
			_tmp12_ = _tmp14_;
		} else {
			_tmp12_ = FALSE;
		}
		_tmp6_ = _tmp12_;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		ValaDataType* _tmp15_;
		_tmp15_ = return_type;
		_tmp5_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, VALA_TYPE_DELEGATE_TYPE);
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		gboolean _tmp16_;
		_tmp16_ = ret_is_struct;
		_tmp4_ = _tmp16_;
	}
	if (_tmp4_) {
		gint index = 0;
		ValaDataType* _tmp17_;
		gboolean _tmp36_;
		gint _tmp47_;
		index = 0;
		_tmp17_ = instance_type;
		if (_tmp17_ != NULL) {
			gint _tmp18_;
			_tmp18_ = index;
			index = _tmp18_ + 1;
		}
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp19_;
			ValaList* _tmp20_;
			gint _param_size = 0;
			ValaList* _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			gint _param_index = 0;
			_tmp19_ = params;
			_tmp20_ = _vala_iterable_ref0 (_tmp19_);
			_param_list = _tmp20_;
			_tmp21_ = _param_list;
			_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
			_tmp23_ = _tmp22_;
			_param_size = _tmp23_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
				ValaParameter* param = NULL;
				ValaList* _tmp27_;
				gint _tmp28_;
				gpointer _tmp29_;
				gint _tmp30_;
				ValaParameter* _tmp31_;
				ValaDataType* _tmp32_;
				ValaDataType* _tmp33_;
				ValaParameter* _tmp34_;
				gboolean _tmp35_;
				_tmp24_ = _param_index;
				_param_index = _tmp24_ + 1;
				_tmp25_ = _param_index;
				_tmp26_ = _param_size;
				if (!(_tmp25_ < _tmp26_)) {
					break;
				}
				_tmp27_ = _param_list;
				_tmp28_ = _param_index;
				_tmp29_ = vala_list_get (_tmp27_, _tmp28_);
				param = (ValaParameter*) _tmp29_;
				_tmp30_ = index;
				index = _tmp30_ + 1;
				_tmp31_ = param;
				_tmp32_ = vala_variable_get_variable_type ((ValaVariable*) _tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = param;
				_tmp35_ = vala_ccode_base_module_get_ccode_array_length ((ValaCodeNode*) _tmp34_);
				vala_gir_writer_skip_implicit_params (self, _tmp33_, &index, _tmp35_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp36_ = ret_is_struct;
		if (_tmp36_) {
			gint _tmp37_;
			_tmp37_ = index;
			index = _tmp37_ + 1;
		} else {
			ValaDataType* _tmp38_;
			gboolean _tmp39_;
			gboolean _tmp40_ = FALSE;
			ValaDataType* _tmp41_;
			_tmp38_ = return_type;
			_tmp39_ = return_array_length;
			vala_gir_writer_skip_implicit_params (self, _tmp38_, &index, _tmp39_);
			_tmp41_ = return_type;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp41_, VALA_TYPE_ARRAY_TYPE)) {
				gboolean _tmp42_;
				_tmp42_ = return_array_length;
				_tmp40_ = _tmp42_;
			} else {
				_tmp40_ = FALSE;
			}
			if (_tmp40_) {
				gint _tmp43_;
				ValaDataType* _tmp44_;
				gint _tmp45_;
				gint _tmp46_;
				_tmp43_ = index;
				_tmp44_ = return_type;
				_tmp45_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp46_ = _tmp45_;
				index = _tmp43_ - (_tmp46_ - 1);
			}
		}
		_tmp47_ = index;
		last_index = _tmp47_ - 1;
	}
	_tmp49_ = return_type;
	if (_tmp49_ != NULL) {
		gboolean _tmp50_;
		_tmp50_ = ret_is_struct;
		_tmp48_ = !_tmp50_;
	} else {
		_tmp48_ = FALSE;
	}
	if (_tmp48_) {
		ValaDataType* _tmp51_;
		gboolean _tmp52_;
		const gchar* _tmp53_;
		gboolean _tmp54_;
		_tmp51_ = return_type;
		_tmp52_ = return_array_length;
		_tmp53_ = return_comment;
		_tmp54_ = constructor;
		vala_gir_writer_write_param_or_return (self, _tmp51_, FALSE, &last_index, _tmp52_, NULL, _tmp53_, VALA_PARAMETER_DIRECTION_IN, _tmp54_, FALSE);
	} else {
		gboolean _tmp55_;
		_tmp55_ = ret_is_struct;
		if (_tmp55_) {
			ValaVoidType* _tmp56_;
			ValaVoidType* _tmp57_;
			const gchar* _tmp58_;
			_tmp56_ = vala_void_type_new (NULL);
			_tmp57_ = _tmp56_;
			_tmp58_ = return_comment;
			vala_gir_writer_write_param_or_return (self, (ValaDataType*) _tmp57_, FALSE, &last_index, FALSE, NULL, _tmp58_, VALA_PARAMETER_DIRECTION_IN, FALSE, FALSE);
			_vala_code_node_unref0 (_tmp57_);
		}
	}
	_tmp63_ = params;
	_tmp64_ = vala_collection_get_size ((ValaCollection*) _tmp63_);
	_tmp65_ = _tmp64_;
	if (_tmp65_ != 0) {
		_tmp62_ = TRUE;
	} else {
		ValaDataType* _tmp66_;
		_tmp66_ = instance_type;
		_tmp62_ = _tmp66_ != NULL;
	}
	if (_tmp62_) {
		_tmp61_ = TRUE;
	} else {
		gboolean _tmp67_ = FALSE;
		ValaDataType* _tmp68_;
		_tmp68_ = return_type;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp68_, VALA_TYPE_ARRAY_TYPE)) {
			gboolean _tmp69_;
			_tmp69_ = return_array_length;
			_tmp67_ = _tmp69_;
		} else {
			_tmp67_ = FALSE;
		}
		_tmp61_ = _tmp67_;
	}
	if (_tmp61_) {
		_tmp60_ = TRUE;
	} else {
		ValaDataType* _tmp70_;
		_tmp70_ = return_type;
		_tmp60_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp70_, VALA_TYPE_DELEGATE_TYPE);
	}
	if (_tmp60_) {
		_tmp59_ = TRUE;
	} else {
		gboolean _tmp71_;
		_tmp71_ = ret_is_struct;
		_tmp59_ = _tmp71_;
	}
	if (_tmp59_) {
		GString* _tmp72_;
		gint _tmp73_;
		gint index = 0;
		ValaDataType* _tmp74_;
		gboolean _tmp112_;
		gboolean _tmp118_;
		gint _tmp125_;
		GString* _tmp126_;
		vala_gir_writer_write_indent (self);
		_tmp72_ = self->priv->buffer;
		g_string_append_printf (_tmp72_, "<parameters>\n");
		_tmp73_ = self->priv->indent;
		self->priv->indent = _tmp73_ + 1;
		index = 0;
		_tmp74_ = instance_type;
		if (_tmp74_ != NULL) {
			ValaDataType* _tmp75_;
			_tmp75_ = instance_type;
			vala_gir_writer_write_param_or_return (self, _tmp75_, TRUE, &index, FALSE, "self", NULL, VALA_PARAMETER_DIRECTION_IN, FALSE, FALSE);
		}
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp76_;
			ValaList* _tmp77_;
			gint _param_size = 0;
			ValaList* _tmp78_;
			gint _tmp79_;
			gint _tmp80_;
			gint _param_index = 0;
			_tmp76_ = params;
			_tmp77_ = _vala_iterable_ref0 (_tmp76_);
			_param_list = _tmp77_;
			_tmp78_ = _param_list;
			_tmp79_ = vala_collection_get_size ((ValaCollection*) _tmp78_);
			_tmp80_ = _tmp79_;
			_param_size = _tmp80_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp81_;
				gint _tmp82_;
				gint _tmp83_;
				ValaParameter* param = NULL;
				ValaList* _tmp84_;
				gint _tmp85_;
				gpointer _tmp86_;
				ValaParameter* _tmp87_;
				ValaDataType* _tmp88_;
				ValaDataType* _tmp89_;
				ValaParameter* _tmp90_;
				gboolean _tmp91_;
				ValaParameter* _tmp92_;
				const gchar* _tmp93_;
				const gchar* _tmp94_;
				ValaParameter* _tmp95_;
				gchar* _tmp96_;
				gchar* _tmp97_;
				ValaParameter* _tmp98_;
				ValaParameterDirection _tmp99_;
				ValaParameterDirection _tmp100_;
				ValaParameter* _tmp101_;
				ValaDataType* _tmp102_;
				ValaDataType* _tmp103_;
				ValaParameter* _tmp104_;
				gboolean _tmp105_;
				ValaParameter* _tmp106_;
				const gchar* _tmp107_;
				const gchar* _tmp108_;
				ValaParameter* _tmp109_;
				ValaParameterDirection _tmp110_;
				ValaParameterDirection _tmp111_;
				_tmp81_ = _param_index;
				_param_index = _tmp81_ + 1;
				_tmp82_ = _param_index;
				_tmp83_ = _param_size;
				if (!(_tmp82_ < _tmp83_)) {
					break;
				}
				_tmp84_ = _param_list;
				_tmp85_ = _param_index;
				_tmp86_ = vala_list_get (_tmp84_, _tmp85_);
				param = (ValaParameter*) _tmp86_;
				_tmp87_ = param;
				_tmp88_ = vala_variable_get_variable_type ((ValaVariable*) _tmp87_);
				_tmp89_ = _tmp88_;
				_tmp90_ = param;
				_tmp91_ = vala_ccode_base_module_get_ccode_array_length ((ValaCodeNode*) _tmp90_);
				_tmp92_ = param;
				_tmp93_ = vala_symbol_get_name ((ValaSymbol*) _tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = param;
				_tmp96_ = vala_gir_writer_get_parameter_comment (self, _tmp95_);
				_tmp97_ = _tmp96_;
				_tmp98_ = param;
				_tmp99_ = vala_parameter_get_direction (_tmp98_);
				_tmp100_ = _tmp99_;
				vala_gir_writer_write_param_or_return (self, _tmp89_, TRUE, &index, _tmp91_, _tmp94_, _tmp97_, _tmp100_, FALSE, FALSE);
				_g_free0 (_tmp97_);
				_tmp101_ = param;
				_tmp102_ = vala_variable_get_variable_type ((ValaVariable*) _tmp101_);
				_tmp103_ = _tmp102_;
				_tmp104_ = param;
				_tmp105_ = vala_ccode_base_module_get_ccode_array_length ((ValaCodeNode*) _tmp104_);
				_tmp106_ = param;
				_tmp107_ = vala_symbol_get_name ((ValaSymbol*) _tmp106_);
				_tmp108_ = _tmp107_;
				_tmp109_ = param;
				_tmp110_ = vala_parameter_get_direction (_tmp109_);
				_tmp111_ = _tmp110_;
				vala_gir_writer_write_implicit_params (self, _tmp103_, &index, _tmp105_, _tmp108_, _tmp111_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp112_ = ret_is_struct;
		if (_tmp112_) {
			ValaDataType* _tmp113_;
			const gchar* _tmp114_;
			gboolean _tmp115_;
			_tmp113_ = return_type;
			_tmp114_ = return_comment;
			_tmp115_ = constructor;
			vala_gir_writer_write_param_or_return (self, _tmp113_, TRUE, &index, FALSE, "result", _tmp114_, VALA_PARAMETER_DIRECTION_OUT, _tmp115_, TRUE);
		} else {
			ValaDataType* _tmp116_;
			gboolean _tmp117_;
			_tmp116_ = return_type;
			_tmp117_ = return_array_length;
			vala_gir_writer_write_implicit_params (self, _tmp116_, &index, _tmp117_, "result", VALA_PARAMETER_DIRECTION_OUT);
		}
		_tmp118_ = user_data;
		if (_tmp118_) {
			GString* _tmp119_;
			gint _tmp120_;
			gint _tmp121_;
			GString* _tmp122_;
			gint _tmp123_;
			GString* _tmp124_;
			vala_gir_writer_write_indent (self);
			_tmp119_ = self->priv->buffer;
			_tmp120_ = index;
			g_string_append_printf (_tmp119_, "<parameter name=\"user_data\" transfer-ownership=\"none\" closure=\"%d" \
"\">\n", _tmp120_);
			_tmp121_ = self->priv->indent;
			self->priv->indent = _tmp121_ + 1;
			vala_gir_writer_write_indent (self);
			_tmp122_ = self->priv->buffer;
			g_string_append_printf (_tmp122_, "<type name=\"gpointer\" c:type=\"void*\"/>\n");
			_tmp123_ = self->priv->indent;
			self->priv->indent = _tmp123_ - 1;
			vala_gir_writer_write_indent (self);
			_tmp124_ = self->priv->buffer;
			g_string_append_printf (_tmp124_, "</parameter>\n");
		}
		_tmp125_ = self->priv->indent;
		self->priv->indent = _tmp125_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp126_ = self->priv->buffer;
		g_string_append_printf (_tmp126_, "</parameters>\n");
	}
}


static void vala_gir_writer_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* cb) {
	ValaGIRWriter * self;
	ValaDelegate* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaDelegate* _tmp3_;
	gboolean _tmp4_;
	GString* _tmp5_;
	ValaDelegate* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GString* _tmp9_;
	ValaDelegate* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	ValaDelegate* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	ValaDelegate* _tmp17_;
	GString* _tmp18_;
	gint _tmp19_;
	ValaDelegate* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	ValaDelegate* _tmp23_;
	ValaDelegate* _tmp24_;
	ValaList* _tmp25_;
	ValaList* _tmp26_;
	ValaDelegate* _tmp27_;
	ValaDataType* _tmp28_;
	ValaDataType* _tmp29_;
	ValaDelegate* _tmp30_;
	gboolean _tmp31_;
	ValaDelegate* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	ValaDelegate* _tmp35_;
	gboolean _tmp36_;
	gboolean _tmp37_;
	gint _tmp38_;
	GString* _tmp39_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (cb != NULL);
	_tmp0_ = cb;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = cb;
	_tmp4_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp3_);
	if (!_tmp4_) {
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp5_ = self->priv->buffer;
	_tmp6_ = cb;
	_tmp7_ = vala_symbol_get_name ((ValaSymbol*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append_printf (_tmp5_, "<callback name=\"%s\"", _tmp8_);
	_tmp9_ = self->priv->buffer;
	_tmp10_ = cb;
	_tmp11_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp10_);
	_tmp12_ = _tmp11_;
	g_string_append_printf (_tmp9_, " c:type=\"%s\"", _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = cb;
	_tmp14_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_) {
		GString* _tmp16_;
		_tmp16_ = self->priv->buffer;
		g_string_append_printf (_tmp16_, " throws=\"1\"");
	}
	_tmp17_ = cb;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp17_);
	_tmp18_ = self->priv->buffer;
	g_string_append_printf (_tmp18_, ">\n");
	_tmp19_ = self->priv->indent;
	self->priv->indent = _tmp19_ + 1;
	_tmp20_ = cb;
	_tmp21_ = vala_gir_writer_get_delegate_comment (self, _tmp20_);
	_tmp22_ = _tmp21_;
	vala_gir_writer_write_doc (self, _tmp22_);
	_g_free0 (_tmp22_);
	_tmp23_ = cb;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp23_);
	_tmp24_ = cb;
	_tmp25_ = vala_callable_get_parameters ((ValaCallable*) _tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = cb;
	_tmp28_ = vala_callable_get_return_type ((ValaCallable*) _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = cb;
	_tmp31_ = vala_ccode_base_module_get_ccode_array_length ((ValaCodeNode*) _tmp30_);
	_tmp32_ = cb;
	_tmp33_ = vala_gir_writer_get_delegate_return_comment (self, _tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = cb;
	_tmp36_ = vala_delegate_get_has_target (_tmp35_);
	_tmp37_ = _tmp36_;
	vala_gir_writer_write_params_and_return (self, _tmp26_, _tmp29_, _tmp31_, _tmp34_, FALSE, NULL, _tmp37_);
	_g_free0 (_tmp34_);
	_vala_iterable_unref0 (_tmp26_);
	_tmp38_ = self->priv->indent;
	self->priv->indent = _tmp38_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp39_ = self->priv->buffer;
	g_string_append_printf (_tmp39_, "</callback>\n");
}


static void vala_gir_writer_real_visit_method (ValaCodeVisitor* base, ValaMethod* m) {
	ValaGIRWriter * self;
	ValaMethod* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	ValaMethod* _tmp5_;
	gboolean _tmp6_;
	ValaMethod* _tmp21_;
	gboolean _tmp22_;
	gchar* tag_name = NULL;
	gchar* _tmp23_;
	ValaSymbol* parent = NULL;
	ValaArrayList* _tmp24_;
	gpointer _tmp25_;
	ValaSymbol* _tmp26_;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_ = FALSE;
	ValaSymbol* _tmp31_;
	ValaMethod* _tmp40_;
	const gchar* _tmp41_;
	gboolean _tmp42_ = FALSE;
	ValaMethod* _tmp43_;
	gboolean _tmp44_;
	gboolean _tmp45_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = m;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp5_ = m;
	_tmp6_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp5_);
	if (!_tmp6_) {
		_tmp4_ = TRUE;
	} else {
		ValaMethod* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp7_ = m;
		_tmp8_ = vala_method_get_overrides (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp4_ = _tmp9_;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		ValaMethod* _tmp12_;
		ValaMethod* _tmp13_;
		ValaMethod* _tmp14_;
		_tmp12_ = m;
		_tmp13_ = vala_method_get_base_interface_method (_tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_ != NULL) {
			ValaMethod* _tmp15_;
			gboolean _tmp16_;
			gboolean _tmp17_;
			_tmp15_ = m;
			_tmp16_ = vala_method_get_is_abstract (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp11_ = !_tmp17_;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			ValaMethod* _tmp18_;
			gboolean _tmp19_;
			gboolean _tmp20_;
			_tmp18_ = m;
			_tmp19_ = vala_method_get_is_virtual (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp10_ = !_tmp20_;
		} else {
			_tmp10_ = FALSE;
		}
		_tmp3_ = _tmp10_;
	}
	if (_tmp3_) {
		return;
	}
	_tmp21_ = m;
	_tmp22_ = vala_gir_writer_check_signature (self, _tmp21_);
	if (!_tmp22_) {
		return;
	}
	_tmp23_ = g_strdup ("method");
	tag_name = _tmp23_;
	_tmp24_ = self->priv->hierarchy;
	_tmp25_ = vala_list_get ((ValaList*) _tmp24_, 0);
	parent = (ValaSymbol*) _tmp25_;
	_tmp26_ = parent;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, VALA_TYPE_ENUM)) {
		ValaArrayList* _tmp27_;
		ValaMethod* _tmp28_;
		_tmp27_ = self->priv->deferred;
		_tmp28_ = m;
		vala_collection_add ((ValaCollection*) _tmp27_, (ValaCodeNode*) _tmp28_);
		_vala_code_node_unref0 (parent);
		_g_free0 (tag_name);
		return;
	}
	_tmp31_ = parent;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, VALA_TYPE_NAMESPACE)) {
		_tmp30_ = TRUE;
	} else {
		ValaMethod* _tmp32_;
		ValaMemberBinding _tmp33_;
		ValaMemberBinding _tmp34_;
		_tmp32_ = m;
		_tmp33_ = vala_method_get_binding (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp30_ = _tmp34_ == VALA_MEMBER_BINDING_STATIC;
	}
	if (_tmp30_) {
		_tmp29_ = TRUE;
	} else {
		ValaSymbol* _tmp35_;
		ValaMethod* _tmp36_;
		ValaSymbol* _tmp37_;
		ValaSymbol* _tmp38_;
		_tmp35_ = parent;
		_tmp36_ = m;
		_tmp37_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp29_ = _tmp35_ != _tmp38_;
	}
	if (_tmp29_) {
		gchar* _tmp39_;
		_tmp39_ = g_strdup ("function");
		_g_free0 (tag_name);
		tag_name = _tmp39_;
	}
	_tmp40_ = m;
	_tmp41_ = tag_name;
	vala_gir_writer_write_signature (self, _tmp40_, _tmp41_, TRUE, FALSE);
	_tmp43_ = m;
	_tmp44_ = vala_method_get_is_abstract (_tmp43_);
	_tmp45_ = _tmp44_;
	if (_tmp45_) {
		_tmp42_ = TRUE;
	} else {
		ValaMethod* _tmp46_;
		gboolean _tmp47_;
		gboolean _tmp48_;
		_tmp46_ = m;
		_tmp47_ = vala_method_get_is_virtual (_tmp46_);
		_tmp48_ = _tmp47_;
		_tmp42_ = _tmp48_;
	}
	if (_tmp42_) {
		ValaMethod* _tmp49_;
		_tmp49_ = m;
		vala_gir_writer_write_signature (self, _tmp49_, "virtual-method", TRUE, FALSE);
	}
	_vala_code_node_unref0 (parent);
	_g_free0 (tag_name);
}


static gboolean vala_gir_writer_check_type (ValaGIRWriter* self, ValaDataType* type) {
	gboolean result = FALSE;
	ValaDataType* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	_tmp0_ = type;
	_tmp1_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "va_list") == 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static gboolean vala_gir_writer_check_signature (ValaGIRWriter* self, ValaMethod* m) {
	gboolean result = FALSE;
	ValaMethod* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (m != NULL, FALSE);
	_tmp0_ = m;
	_tmp1_ = vala_callable_get_return_type ((ValaCallable*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_gir_writer_check_type (self, _tmp2_);
	if (!_tmp3_) {
		result = FALSE;
		return result;
	}
	{
		ValaList* _param_list = NULL;
		ValaMethod* _tmp4_;
		ValaList* _tmp5_;
		gint _param_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _param_index = 0;
		_tmp4_ = m;
		_tmp5_ = vala_callable_get_parameters ((ValaCallable*) _tmp4_);
		_param_list = _tmp5_;
		_tmp6_ = _param_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_param_size = _tmp8_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			ValaParameter* param = NULL;
			ValaList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_;
			gboolean _tmp15_ = FALSE;
			ValaParameter* _tmp16_;
			ValaDataType* _tmp17_;
			ValaDataType* _tmp18_;
			_tmp9_ = _param_index;
			_param_index = _tmp9_ + 1;
			_tmp10_ = _param_index;
			_tmp11_ = _param_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _param_list;
			_tmp13_ = _param_index;
			_tmp14_ = vala_list_get (_tmp12_, _tmp13_);
			param = (ValaParameter*) _tmp14_;
			_tmp16_ = param;
			_tmp17_ = vala_variable_get_variable_type ((ValaVariable*) _tmp16_);
			_tmp18_ = _tmp17_;
			if (_tmp18_ == NULL) {
				_tmp15_ = TRUE;
			} else {
				ValaParameter* _tmp19_;
				ValaDataType* _tmp20_;
				ValaDataType* _tmp21_;
				gboolean _tmp22_;
				_tmp19_ = param;
				_tmp20_ = vala_variable_get_variable_type ((ValaVariable*) _tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = vala_gir_writer_check_type (self, _tmp21_);
				_tmp15_ = !_tmp22_;
			}
			if (_tmp15_) {
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = TRUE;
	return result;
}


static void vala_gir_writer_write_signature (ValaGIRWriter* self, ValaMethod* m, const gchar* tag_name, gboolean write_doc, gboolean instance) {
	ValaSymbol* parent = NULL;
	ValaArrayList* _tmp0_;
	gpointer _tmp1_;
	gchar* name = NULL;
	ValaMethod* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaMethod* _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	g_return_if_fail (tag_name != NULL);
	_tmp0_ = self->priv->hierarchy;
	_tmp1_ = vala_list_get ((ValaList*) _tmp0_, 0);
	parent = (ValaSymbol*) _tmp1_;
	_tmp2_ = m;
	_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = parent;
	if (_tmp4_ != _tmp5_) {
		ValaMethod* _tmp6_;
		gchar* _tmp7_;
		gchar* parent_prefix = NULL;
		ValaSymbol* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gboolean _tmp12_;
		instance = FALSE;
		_tmp6_ = m;
		_tmp7_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp6_);
		_g_free0 (name);
		name = _tmp7_;
		_tmp8_ = parent;
		_tmp9_ = vala_ccode_base_module_get_ccode_lower_case_prefix (_tmp8_);
		parent_prefix = _tmp9_;
		_tmp10_ = name;
		_tmp11_ = parent_prefix;
		_tmp12_ = g_str_has_prefix (_tmp10_, _tmp11_);
		if (_tmp12_) {
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			gchar* _tmp17_;
			_tmp13_ = name;
			_tmp14_ = parent_prefix;
			_tmp15_ = strlen (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = string_substring (_tmp13_, (glong) _tmp16_, (glong) -1);
			_g_free0 (name);
			name = _tmp17_;
		}
		_g_free0 (parent_prefix);
	} else {
		ValaMethod* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp18_ = m;
		_tmp19_ = vala_symbol_get_name ((ValaSymbol*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strdup (_tmp20_);
		_g_free0 (name);
		name = _tmp21_;
	}
	_tmp22_ = m;
	_tmp23_ = vala_method_get_coroutine (_tmp22_);
	_tmp24_ = _tmp23_;
	if (_tmp24_) {
		gchar* finish_name = NULL;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		const gchar* _tmp27_;
		gboolean _tmp28_;
		const gchar* _tmp36_;
		gchar* _tmp37_;
		ValaMethod* _tmp38_;
		const gchar* _tmp39_;
		gboolean _tmp40_;
		const gchar* _tmp41_;
		ValaMethod* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		ValaMethod* _tmp45_;
		ValaList* _tmp46_;
		ValaList* _tmp47_;
		ValaVoidType* _tmp48_;
		ValaVoidType* _tmp49_;
		ValaMethod* _tmp50_;
		const gchar* _tmp51_;
		gboolean _tmp52_;
		const gchar* _tmp53_;
		ValaMethod* _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		ValaMethod* _tmp57_;
		ValaList* _tmp58_;
		ValaList* _tmp59_;
		ValaMethod* _tmp60_;
		ValaDataType* _tmp61_;
		ValaDataType* _tmp62_;
		ValaMethod* _tmp63_;
		gboolean _tmp64_;
		gboolean _tmp65_;
		_tmp25_ = name;
		_tmp26_ = g_strdup (_tmp25_);
		finish_name = _tmp26_;
		_tmp27_ = finish_name;
		_tmp28_ = g_str_has_suffix (_tmp27_, "_async");
		if (_tmp28_) {
			const gchar* _tmp29_;
			const gchar* _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			gchar* _tmp35_;
			_tmp29_ = finish_name;
			_tmp30_ = finish_name;
			_tmp31_ = strlen (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = strlen ("_async");
			_tmp34_ = _tmp33_;
			_tmp35_ = string_substring (_tmp29_, (glong) 0, (glong) (_tmp32_ - _tmp34_));
			_g_free0 (finish_name);
			finish_name = _tmp35_;
		}
		_tmp36_ = finish_name;
		_tmp37_ = g_strconcat (_tmp36_, "_finish", NULL);
		_g_free0 (finish_name);
		finish_name = _tmp37_;
		_tmp38_ = m;
		_tmp39_ = tag_name;
		_tmp40_ = instance;
		_tmp41_ = name;
		_tmp42_ = m;
		_tmp43_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = m;
		_tmp46_ = vala_method_get_async_begin_parameters (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_void_type_new (NULL);
		_tmp49_ = _tmp48_;
		vala_gir_writer_do_write_signature (self, _tmp38_, _tmp39_, _tmp40_, _tmp41_, _tmp44_, _tmp47_, (ValaDataType*) _tmp49_, FALSE, TRUE);
		_vala_code_node_unref0 (_tmp49_);
		_vala_iterable_unref0 (_tmp47_);
		_g_free0 (_tmp44_);
		_tmp50_ = m;
		_tmp51_ = tag_name;
		_tmp52_ = instance;
		_tmp53_ = finish_name;
		_tmp54_ = m;
		_tmp55_ = vala_ccode_base_module_get_ccode_finish_name (_tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = m;
		_tmp58_ = vala_method_get_async_end_parameters (_tmp57_);
		_tmp59_ = _tmp58_;
		_tmp60_ = m;
		_tmp61_ = vala_callable_get_return_type ((ValaCallable*) _tmp60_);
		_tmp62_ = _tmp61_;
		_tmp63_ = m;
		_tmp64_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp63_);
		_tmp65_ = _tmp64_;
		vala_gir_writer_do_write_signature (self, _tmp50_, _tmp51_, _tmp52_, _tmp53_, _tmp56_, _tmp59_, _tmp62_, _tmp65_, FALSE);
		_vala_iterable_unref0 (_tmp59_);
		_g_free0 (_tmp56_);
		_g_free0 (finish_name);
	} else {
		ValaMethod* _tmp66_;
		const gchar* _tmp67_;
		gboolean _tmp68_;
		const gchar* _tmp69_;
		ValaMethod* _tmp70_;
		gchar* _tmp71_;
		gchar* _tmp72_;
		ValaMethod* _tmp73_;
		ValaList* _tmp74_;
		ValaList* _tmp75_;
		ValaMethod* _tmp76_;
		ValaDataType* _tmp77_;
		ValaDataType* _tmp78_;
		ValaMethod* _tmp79_;
		gboolean _tmp80_;
		gboolean _tmp81_;
		_tmp66_ = m;
		_tmp67_ = tag_name;
		_tmp68_ = instance;
		_tmp69_ = name;
		_tmp70_ = m;
		_tmp71_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp70_);
		_tmp72_ = _tmp71_;
		_tmp73_ = m;
		_tmp74_ = vala_callable_get_parameters ((ValaCallable*) _tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = m;
		_tmp77_ = vala_callable_get_return_type ((ValaCallable*) _tmp76_);
		_tmp78_ = _tmp77_;
		_tmp79_ = m;
		_tmp80_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp79_);
		_tmp81_ = _tmp80_;
		vala_gir_writer_do_write_signature (self, _tmp66_, _tmp67_, _tmp68_, _tmp69_, _tmp72_, _tmp75_, _tmp78_, _tmp81_, TRUE);
		_vala_iterable_unref0 (_tmp75_);
		_g_free0 (_tmp72_);
	}
	_g_free0 (name);
	_vala_code_node_unref0 (parent);
}


static void vala_gir_writer_do_write_signature (ValaGIRWriter* self, ValaMethod* m, const gchar* tag_name, gboolean instance, const gchar* name, const gchar* cname, ValaList* params, ValaDataType* return_type, gboolean can_fail, gboolean write_comment) {
	GString* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp11_;
	ValaMethod* _tmp13_;
	GString* _tmp14_;
	gint _tmp15_;
	gchar* return_comment = NULL;
	gboolean _tmp16_;
	ValaMethod* _tmp22_;
	ValaDataType* instance_type = NULL;
	gboolean _tmp23_;
	ValaList* _tmp28_;
	ValaDataType* _tmp29_;
	ValaMethod* _tmp30_;
	gboolean _tmp31_;
	const gchar* _tmp32_;
	ValaDataType* _tmp33_;
	gint _tmp34_;
	GString* _tmp35_;
	const gchar* _tmp36_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	g_return_if_fail (tag_name != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (cname != NULL);
	g_return_if_fail (params != NULL);
	g_return_if_fail (return_type != NULL);
	vala_gir_writer_write_indent (self);
	_tmp0_ = self->priv->buffer;
	_tmp1_ = tag_name;
	_tmp2_ = name;
	g_string_append_printf (_tmp0_, "<%s name=\"%s\"", _tmp1_, _tmp2_);
	_tmp3_ = tag_name;
	if (g_strcmp0 (_tmp3_, "virtual-method") == 0) {
		GString* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = self->priv->buffer;
		_tmp5_ = name;
		g_string_append_printf (_tmp4_, " invoker=\"%s\"", _tmp5_);
	} else {
		const gchar* _tmp6_;
		_tmp6_ = tag_name;
		if (g_strcmp0 (_tmp6_, "callback") == 0) {
			GString* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = self->priv->buffer;
			_tmp8_ = name;
			g_string_append_printf (_tmp7_, " c:type=\"%s\"", _tmp8_);
		} else {
			GString* _tmp9_;
			const gchar* _tmp10_;
			_tmp9_ = self->priv->buffer;
			_tmp10_ = cname;
			g_string_append_printf (_tmp9_, " c:identifier=\"%s\"", _tmp10_);
		}
	}
	_tmp11_ = can_fail;
	if (_tmp11_) {
		GString* _tmp12_;
		_tmp12_ = self->priv->buffer;
		g_string_append_printf (_tmp12_, " throws=\"1\"");
	}
	_tmp13_ = m;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp13_);
	_tmp14_ = self->priv->buffer;
	g_string_append_printf (_tmp14_, ">\n");
	_tmp15_ = self->priv->indent;
	self->priv->indent = _tmp15_ + 1;
	return_comment = NULL;
	_tmp16_ = write_comment;
	if (_tmp16_) {
		ValaMethod* _tmp17_;
		gchar* _tmp18_;
		ValaMethod* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp17_ = m;
		_tmp18_ = vala_gir_writer_get_method_return_comment (self, _tmp17_);
		_g_free0 (return_comment);
		return_comment = _tmp18_;
		_tmp19_ = m;
		_tmp20_ = vala_gir_writer_get_method_comment (self, _tmp19_);
		_tmp21_ = _tmp20_;
		vala_gir_writer_write_doc (self, _tmp21_);
		_g_free0 (_tmp21_);
	}
	_tmp22_ = m;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp22_);
	instance_type = NULL;
	_tmp23_ = instance;
	if (_tmp23_) {
		ValaMethod* _tmp24_;
		ValaSymbol* _tmp25_;
		ValaSymbol* _tmp26_;
		ValaDataType* _tmp27_;
		_tmp24_ = m;
		_tmp25_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_ccode_base_module_get_data_type_for_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
		_vala_code_node_unref0 (instance_type);
		instance_type = _tmp27_;
	}
	_tmp28_ = params;
	_tmp29_ = return_type;
	_tmp30_ = m;
	_tmp31_ = vala_ccode_base_module_get_ccode_array_length ((ValaCodeNode*) _tmp30_);
	_tmp32_ = return_comment;
	_tmp33_ = instance_type;
	vala_gir_writer_write_params_and_return (self, _tmp28_, _tmp29_, _tmp31_, _tmp32_, FALSE, _tmp33_, FALSE);
	_tmp34_ = self->priv->indent;
	self->priv->indent = _tmp34_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp35_ = self->priv->buffer;
	_tmp36_ = tag_name;
	g_string_append_printf (_tmp35_, "</%s>\n", _tmp36_);
	_vala_code_node_unref0 (instance_type);
	_g_free0 (return_comment);
}


static void vala_gir_writer_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m) {
	ValaGIRWriter * self;
	ValaCreationMethod* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaCreationMethod* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValaCreationMethod* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	gboolean is_struct = FALSE;
	ValaCreationMethod* _tmp14_;
	ValaSymbol* _tmp15_;
	ValaSymbol* _tmp16_;
	const gchar* _tmp17_ = NULL;
	gboolean _tmp18_;
	gchar* tag_name = NULL;
	gchar* _tmp19_;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	ValaCreationMethod* _tmp22_;
	ValaSymbol* _tmp23_;
	ValaSymbol* _tmp24_;
	ValaCreationMethod* _tmp58_;
	gboolean _tmp59_;
	gboolean _tmp60_;
	GString* _tmp62_;
	gint _tmp63_;
	ValaCreationMethod* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	ValaCreationMethod* _tmp67_;
	ValaDataType* datatype = NULL;
	ValaCreationMethod* _tmp68_;
	ValaSymbol* _tmp69_;
	ValaSymbol* _tmp70_;
	ValaDataType* _tmp71_;
	ValaCreationMethod* _tmp72_;
	ValaList* _tmp73_;
	ValaList* _tmp74_;
	ValaDataType* _tmp75_;
	ValaCreationMethod* _tmp76_;
	gchar* _tmp77_;
	gchar* _tmp78_;
	gint _tmp79_;
	GString* _tmp80_;
	const gchar* _tmp81_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = m;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = m;
	_tmp4_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp3_);
	if (!_tmp4_) {
		return;
	}
	_tmp6_ = m;
	_tmp7_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp6_);
	_tmp8_ = _tmp7_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_CLASS)) {
		ValaCreationMethod* _tmp9_;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
		_tmp9_ = m;
		_tmp10_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_class_get_is_abstract (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_CLASS, ValaClass));
		_tmp13_ = _tmp12_;
		_tmp5_ = _tmp13_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp14_ = m;
	_tmp15_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp14_);
	_tmp16_ = _tmp15_;
	is_struct = G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_STRUCT);
	_tmp18_ = is_struct;
	if (_tmp18_) {
		_tmp17_ = "function";
	} else {
		_tmp17_ = "constructor";
	}
	_tmp19_ = g_strdup (_tmp17_);
	tag_name = _tmp19_;
	_tmp22_ = m;
	_tmp23_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp22_);
	_tmp24_ = _tmp23_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALA_TYPE_CLASS)) {
		ValaCreationMethod* _tmp25_;
		ValaCreationMethod* _tmp26_;
		ValaSymbol* _tmp27_;
		ValaSymbol* _tmp28_;
		ValaCreationMethod* _tmp29_;
		ValaCreationMethod* _tmp30_;
		_tmp25_ = m;
		_tmp26_ = m;
		_tmp27_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = vala_class_get_default_construction_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_CLASS, ValaClass));
		_tmp30_ = _tmp29_;
		_tmp21_ = _tmp25_ == _tmp30_;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		_tmp20_ = TRUE;
	} else {
		gboolean _tmp31_ = FALSE;
		ValaCreationMethod* _tmp32_;
		ValaSymbol* _tmp33_;
		ValaSymbol* _tmp34_;
		_tmp32_ = m;
		_tmp33_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp32_);
		_tmp34_ = _tmp33_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, VALA_TYPE_STRUCT)) {
			ValaCreationMethod* _tmp35_;
			ValaCreationMethod* _tmp36_;
			ValaSymbol* _tmp37_;
			ValaSymbol* _tmp38_;
			ValaMethod* _tmp39_;
			ValaMethod* _tmp40_;
			_tmp35_ = m;
			_tmp36_ = m;
			_tmp37_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_struct_get_default_construction_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, VALA_TYPE_STRUCT, ValaStruct));
			_tmp40_ = _tmp39_;
			_tmp31_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, VALA_TYPE_METHOD, ValaMethod) == _tmp40_;
		} else {
			_tmp31_ = FALSE;
		}
		_tmp20_ = _tmp31_;
	}
	if (_tmp20_) {
		const gchar* _tmp41_ = NULL;
		gboolean _tmp42_;
		gchar* m_name = NULL;
		gchar* _tmp43_;
		GString* _tmp44_;
		const gchar* _tmp45_;
		const gchar* _tmp46_;
		ValaCreationMethod* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		_tmp42_ = is_struct;
		if (_tmp42_) {
			_tmp41_ = "init";
		} else {
			_tmp41_ = "new";
		}
		_tmp43_ = g_strdup (_tmp41_);
		m_name = _tmp43_;
		_tmp44_ = self->priv->buffer;
		_tmp45_ = tag_name;
		_tmp46_ = m_name;
		_tmp47_ = m;
		_tmp48_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp47_);
		_tmp49_ = _tmp48_;
		g_string_append_printf (_tmp44_, "<%s name=\"%s\" c:identifier=\"%s\"", _tmp45_, _tmp46_, _tmp49_);
		_g_free0 (_tmp49_);
		_g_free0 (m_name);
	} else {
		GString* _tmp50_;
		const gchar* _tmp51_;
		ValaCreationMethod* _tmp52_;
		const gchar* _tmp53_;
		const gchar* _tmp54_;
		ValaCreationMethod* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		_tmp50_ = self->priv->buffer;
		_tmp51_ = tag_name;
		_tmp52_ = m;
		_tmp53_ = vala_symbol_get_name ((ValaSymbol*) _tmp52_);
		_tmp54_ = _tmp53_;
		_tmp55_ = m;
		_tmp56_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp55_);
		_tmp57_ = _tmp56_;
		g_string_append_printf (_tmp50_, "<%s name=\"%s\" c:identifier=\"%s\"", _tmp51_, _tmp54_, _tmp57_);
		_g_free0 (_tmp57_);
	}
	_tmp58_ = m;
	_tmp59_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp58_);
	_tmp60_ = _tmp59_;
	if (_tmp60_) {
		GString* _tmp61_;
		_tmp61_ = self->priv->buffer;
		g_string_append_printf (_tmp61_, " throws=\"1\"");
	}
	_tmp62_ = self->priv->buffer;
	g_string_append_printf (_tmp62_, ">\n");
	_tmp63_ = self->priv->indent;
	self->priv->indent = _tmp63_ + 1;
	_tmp64_ = m;
	_tmp65_ = vala_gir_writer_get_method_comment (self, (ValaMethod*) _tmp64_);
	_tmp66_ = _tmp65_;
	vala_gir_writer_write_doc (self, _tmp66_);
	_g_free0 (_tmp66_);
	_tmp67_ = m;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp67_);
	_tmp68_ = m;
	_tmp69_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp68_);
	_tmp70_ = _tmp69_;
	_tmp71_ = vala_ccode_base_module_get_data_type_for_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
	datatype = _tmp71_;
	_tmp72_ = m;
	_tmp73_ = vala_callable_get_parameters ((ValaCallable*) _tmp72_);
	_tmp74_ = _tmp73_;
	_tmp75_ = datatype;
	_tmp76_ = m;
	_tmp77_ = vala_gir_writer_get_method_return_comment (self, (ValaMethod*) _tmp76_);
	_tmp78_ = _tmp77_;
	vala_gir_writer_write_params_and_return (self, _tmp74_, _tmp75_, FALSE, _tmp78_, TRUE, NULL, FALSE);
	_g_free0 (_tmp78_);
	_vala_iterable_unref0 (_tmp74_);
	_tmp79_ = self->priv->indent;
	self->priv->indent = _tmp79_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp80_ = self->priv->buffer;
	_tmp81_ = tag_name;
	g_string_append_printf (_tmp80_, "</%s>\n", _tmp81_);
	_vala_code_node_unref0 (datatype);
	_g_free0 (tag_name);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = old;
		_tmp1_ = (*((gchar*) _tmp2_)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = old;
		_tmp4_ = replacement;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (self);
		result = _tmp5_;
		return result;
	}
	{
		GRegex* regex = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		gchar* _tmp11_ = NULL;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = old;
		_tmp7_ = g_regex_escape_string (_tmp6_, -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		regex = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch7_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp12_ = regex;
		_tmp13_ = replacement;
		_tmp14_ = g_regex_replace_literal (_tmp12_, self, (gssize) -1, 0, _tmp13_, 0, &_inner_error_);
		_tmp11_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch7_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp15_ = _tmp11_;
		_tmp11_ = NULL;
		result = _tmp15_;
		_g_free0 (_tmp11_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally7;
	__catch7_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void vala_gir_writer_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop) {
	ValaGIRWriter * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaProperty* _tmp2_;
	gboolean _tmp3_;
	GString* _tmp18_;
	ValaProperty* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	ValaProperty* _tmp24_;
	ValaPropertyAccessor* _tmp25_;
	ValaPropertyAccessor* _tmp26_;
	ValaProperty* _tmp28_;
	ValaPropertyAccessor* _tmp29_;
	ValaPropertyAccessor* _tmp30_;
	ValaProperty* _tmp44_;
	GString* _tmp45_;
	gint _tmp46_;
	ValaProperty* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	ValaProperty* _tmp50_;
	ValaProperty* _tmp51_;
	ValaDataType* _tmp52_;
	ValaDataType* _tmp53_;
	gint _tmp54_;
	GString* _tmp55_;
	ValaProperty* _tmp56_;
	ValaPropertyAccessor* _tmp57_;
	ValaPropertyAccessor* _tmp58_;
	ValaProperty* _tmp65_;
	ValaPropertyAccessor* _tmp66_;
	ValaPropertyAccessor* _tmp67_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (prop != NULL);
	_tmp2_ = prop;
	_tmp3_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp2_);
	if (!_tmp3_) {
		_tmp1_ = TRUE;
	} else {
		ValaProperty* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = prop;
		_tmp5_ = vala_property_get_overrides (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp1_ = _tmp6_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		ValaProperty* _tmp9_;
		ValaProperty* _tmp10_;
		ValaProperty* _tmp11_;
		_tmp9_ = prop;
		_tmp10_ = vala_property_get_base_interface_property (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_ != NULL) {
			ValaProperty* _tmp12_;
			gboolean _tmp13_;
			gboolean _tmp14_;
			_tmp12_ = prop;
			_tmp13_ = vala_property_get_is_abstract (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp8_ = !_tmp14_;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			ValaProperty* _tmp15_;
			gboolean _tmp16_;
			gboolean _tmp17_;
			_tmp15_ = prop;
			_tmp16_ = vala_property_get_is_virtual (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp7_ = !_tmp17_;
		} else {
			_tmp7_ = FALSE;
		}
		_tmp0_ = _tmp7_;
	}
	if (_tmp0_) {
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp18_ = self->priv->buffer;
	_tmp19_ = prop;
	_tmp20_ = vala_symbol_get_name ((ValaSymbol*) _tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = string_replace (_tmp21_, "_", "-");
	_tmp23_ = _tmp22_;
	g_string_append_printf (_tmp18_, "<property name=\"%s\"", _tmp23_);
	_g_free0 (_tmp23_);
	_tmp24_ = prop;
	_tmp25_ = vala_property_get_get_accessor (_tmp24_);
	_tmp26_ = _tmp25_;
	if (_tmp26_ == NULL) {
		GString* _tmp27_;
		_tmp27_ = self->priv->buffer;
		g_string_append_printf (_tmp27_, " readable=\"0\"");
	}
	_tmp28_ = prop;
	_tmp29_ = vala_property_get_set_accessor (_tmp28_);
	_tmp30_ = _tmp29_;
	if (_tmp30_ != NULL) {
		GString* _tmp31_;
		ValaProperty* _tmp32_;
		ValaPropertyAccessor* _tmp33_;
		ValaPropertyAccessor* _tmp34_;
		gboolean _tmp35_;
		gboolean _tmp36_;
		_tmp31_ = self->priv->buffer;
		g_string_append_printf (_tmp31_, " writable=\"1\"");
		_tmp32_ = prop;
		_tmp33_ = vala_property_get_set_accessor (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = vala_property_accessor_get_construction (_tmp34_);
		_tmp36_ = _tmp35_;
		if (_tmp36_) {
			ValaProperty* _tmp37_;
			ValaPropertyAccessor* _tmp38_;
			ValaPropertyAccessor* _tmp39_;
			gboolean _tmp40_;
			gboolean _tmp41_;
			_tmp37_ = prop;
			_tmp38_ = vala_property_get_set_accessor (_tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_property_accessor_get_writable (_tmp39_);
			_tmp41_ = _tmp40_;
			if (!_tmp41_) {
				GString* _tmp42_;
				_tmp42_ = self->priv->buffer;
				g_string_append_printf (_tmp42_, " construct-only=\"1\"");
			} else {
				GString* _tmp43_;
				_tmp43_ = self->priv->buffer;
				g_string_append_printf (_tmp43_, " construct=\"1\"");
			}
		}
	}
	_tmp44_ = prop;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp44_);
	_tmp45_ = self->priv->buffer;
	g_string_append_printf (_tmp45_, ">\n");
	_tmp46_ = self->priv->indent;
	self->priv->indent = _tmp46_ + 1;
	_tmp47_ = prop;
	_tmp48_ = vala_gir_writer_get_property_comment (self, _tmp47_);
	_tmp49_ = _tmp48_;
	vala_gir_writer_write_doc (self, _tmp49_);
	_g_free0 (_tmp49_);
	_tmp50_ = prop;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp50_);
	_tmp51_ = prop;
	_tmp52_ = vala_property_get_property_type (_tmp51_);
	_tmp53_ = _tmp52_;
	vala_gir_writer_write_type (self, _tmp53_, -1, VALA_PARAMETER_DIRECTION_IN);
	_tmp54_ = self->priv->indent;
	self->priv->indent = _tmp54_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp55_ = self->priv->buffer;
	g_string_append_printf (_tmp55_, "</property>\n");
	_tmp56_ = prop;
	_tmp57_ = vala_property_get_get_accessor (_tmp56_);
	_tmp58_ = _tmp57_;
	if (_tmp58_ != NULL) {
		ValaMethod* m = NULL;
		ValaProperty* _tmp59_;
		ValaPropertyAccessor* _tmp60_;
		ValaPropertyAccessor* _tmp61_;
		ValaMethod* _tmp62_;
		ValaMethod* _tmp63_;
		_tmp59_ = prop;
		_tmp60_ = vala_property_get_get_accessor (_tmp59_);
		_tmp61_ = _tmp60_;
		_tmp62_ = vala_property_accessor_get_method (_tmp61_);
		m = _tmp62_;
		_tmp63_ = m;
		if (_tmp63_ != NULL) {
			ValaMethod* _tmp64_;
			_tmp64_ = m;
			vala_code_visitor_visit_method ((ValaCodeVisitor*) self, _tmp64_);
		}
		_vala_code_node_unref0 (m);
	}
	_tmp65_ = prop;
	_tmp66_ = vala_property_get_set_accessor (_tmp65_);
	_tmp67_ = _tmp66_;
	if (_tmp67_ != NULL) {
		ValaMethod* m = NULL;
		ValaProperty* _tmp68_;
		ValaPropertyAccessor* _tmp69_;
		ValaPropertyAccessor* _tmp70_;
		ValaMethod* _tmp71_;
		ValaMethod* _tmp72_;
		_tmp68_ = prop;
		_tmp69_ = vala_property_get_set_accessor (_tmp68_);
		_tmp70_ = _tmp69_;
		_tmp71_ = vala_property_accessor_get_method (_tmp70_);
		m = _tmp71_;
		_tmp72_ = m;
		if (_tmp72_ != NULL) {
			ValaMethod* _tmp73_;
			_tmp73_ = m;
			vala_code_visitor_visit_method ((ValaCodeVisitor*) self, _tmp73_);
		}
		_vala_code_node_unref0 (m);
	}
}


static void vala_gir_writer_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig) {
	ValaGIRWriter * self;
	ValaSignal* _tmp0_;
	gboolean _tmp1_;
	ValaSignal* _tmp2_;
	ValaMethod* _tmp3_;
	ValaMethod* _tmp4_;
	GString* _tmp8_;
	ValaSignal* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	ValaSignal* _tmp12_;
	GString* _tmp13_;
	gint _tmp14_;
	ValaSignal* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	ValaSignal* _tmp18_;
	ValaSignal* _tmp19_;
	ValaList* _tmp20_;
	ValaList* _tmp21_;
	ValaSignal* _tmp22_;
	ValaDataType* _tmp23_;
	ValaDataType* _tmp24_;
	ValaSignal* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gint _tmp28_;
	GString* _tmp29_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (sig != NULL);
	_tmp0_ = sig;
	_tmp1_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = sig;
	_tmp3_ = vala_signal_get_emitter (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		ValaSignal* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		_tmp5_ = sig;
		_tmp6_ = vala_signal_get_emitter (_tmp5_);
		_tmp7_ = _tmp6_;
		vala_code_node_accept ((ValaCodeNode*) _tmp7_, (ValaCodeVisitor*) self);
	}
	vala_gir_writer_write_indent (self);
	_tmp8_ = self->priv->buffer;
	_tmp9_ = sig;
	_tmp10_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp9_);
	_tmp11_ = _tmp10_;
	g_string_append_printf (_tmp8_, "<glib:signal name=\"%s\"", _tmp11_);
	_g_free0 (_tmp11_);
	_tmp12_ = sig;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp12_);
	_tmp13_ = self->priv->buffer;
	g_string_append_printf (_tmp13_, ">\n");
	_tmp14_ = self->priv->indent;
	self->priv->indent = _tmp14_ + 1;
	_tmp15_ = sig;
	_tmp16_ = vala_gir_writer_get_signal_comment (self, _tmp15_);
	_tmp17_ = _tmp16_;
	vala_gir_writer_write_doc (self, _tmp17_);
	_g_free0 (_tmp17_);
	_tmp18_ = sig;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp18_);
	_tmp19_ = sig;
	_tmp20_ = vala_callable_get_parameters ((ValaCallable*) _tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = sig;
	_tmp23_ = vala_callable_get_return_type ((ValaCallable*) _tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = sig;
	_tmp26_ = vala_gir_writer_get_signal_return_comment (self, _tmp25_);
	_tmp27_ = _tmp26_;
	vala_gir_writer_write_params_and_return (self, _tmp21_, _tmp24_, FALSE, _tmp27_, FALSE, NULL, FALSE);
	_g_free0 (_tmp27_);
	_vala_iterable_unref0 (_tmp21_);
	_tmp28_ = self->priv->indent;
	self->priv->indent = _tmp28_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp29_ = self->priv->buffer;
	g_string_append_printf (_tmp29_, "</glib:signal>\n");
}


static void vala_gir_writer_write_indent (ValaGIRWriter* self) {
	gint i = 0;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_ = FALSE;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gint _tmp2_;
			gint _tmp3_;
			GString* _tmp4_;
			if (!_tmp0_) {
				gint _tmp1_;
				_tmp1_ = i;
				i = _tmp1_ + 1;
			}
			_tmp0_ = FALSE;
			_tmp2_ = i;
			_tmp3_ = self->priv->indent;
			if (!(_tmp2_ < _tmp3_)) {
				break;
			}
			_tmp4_ = self->priv->buffer;
			g_string_append_c (_tmp4_, '\t');
		}
	}
}


static void vala_gir_writer_write_indent_stream (ValaGIRWriter* self) {
	gint i = 0;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_ = FALSE;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gint _tmp2_;
			gint _tmp3_;
			FILE* _tmp4_;
			if (!_tmp0_) {
				gint _tmp1_;
				_tmp1_ = i;
				i = _tmp1_ + 1;
			}
			_tmp0_ = FALSE;
			_tmp2_ = i;
			_tmp3_ = self->priv->indent;
			if (!(_tmp2_ < _tmp3_)) {
				break;
			}
			_tmp4_ = self->priv->stream;
			fputc ('\t', _tmp4_);
		}
	}
}


static void vala_gir_writer_write_param_or_return (ValaGIRWriter* self, ValaDataType* type, gboolean is_parameter, gint* index, gboolean has_array_length, const gchar* name, const gchar* comment, ValaParameterDirection direction, gboolean constructor, gboolean caller_allocates) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	gchar* tag = NULL;
	gchar* _tmp2_;
	GString* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	ValaParameterDirection _tmp8_;
	ValaDelegateType* delegate_type = NULL;
	ValaDataType* _tmp12_;
	ValaDelegateType* _tmp13_;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	ValaDataType* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp49_;
	ValaDataType* _tmp51_;
	gboolean _tmp52_;
	gboolean _tmp53_;
	gboolean _tmp55_ = FALSE;
	ValaDelegateType* _tmp56_;
	GString* _tmp85_;
	gint _tmp86_;
	const gchar* _tmp87_;
	gint length_param_index = 0;
	gboolean _tmp88_;
	ValaDataType* _tmp93_;
	gint _tmp94_;
	ValaParameterDirection _tmp95_;
	gint _tmp96_;
	GString* _tmp97_;
	const gchar* _tmp98_;
	gint _tmp99_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	vala_gir_writer_write_indent (self);
	_tmp1_ = is_parameter;
	if (_tmp1_) {
		_tmp0_ = "parameter";
	} else {
		_tmp0_ = "return-value";
	}
	_tmp2_ = g_strdup (_tmp0_);
	tag = _tmp2_;
	_tmp3_ = self->priv->buffer;
	_tmp4_ = tag;
	g_string_append_printf (_tmp3_, "<%s", _tmp4_);
	_tmp5_ = name;
	if (_tmp5_ != NULL) {
		GString* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = self->priv->buffer;
		_tmp7_ = name;
		g_string_append_printf (_tmp6_, " name=\"%s\"", _tmp7_);
	}
	_tmp8_ = direction;
	if (_tmp8_ == VALA_PARAMETER_DIRECTION_REF) {
		GString* _tmp9_;
		_tmp9_ = self->priv->buffer;
		g_string_append_printf (_tmp9_, " direction=\"inout\"");
	} else {
		ValaParameterDirection _tmp10_;
		_tmp10_ = direction;
		if (_tmp10_ == VALA_PARAMETER_DIRECTION_OUT) {
			GString* _tmp11_;
			_tmp11_ = self->priv->buffer;
			g_string_append_printf (_tmp11_, " direction=\"out\"");
		}
	}
	_tmp12_ = type;
	_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_DELEGATE_TYPE) ? ((ValaDelegateType*) _tmp12_) : NULL);
	delegate_type = _tmp13_;
	_tmp16_ = type;
	_tmp17_ = vala_data_type_get_value_owned (_tmp16_);
	_tmp18_ = _tmp17_;
	if (_tmp18_) {
		ValaDelegateType* _tmp19_;
		_tmp19_ = delegate_type;
		_tmp15_ = _tmp19_ == NULL;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		_tmp14_ = TRUE;
	} else {
		gboolean _tmp20_ = FALSE;
		gboolean _tmp21_;
		_tmp21_ = constructor;
		if (_tmp21_) {
			ValaDataType* _tmp22_;
			ValaTypeSymbol* _tmp23_;
			ValaTypeSymbol* _tmp24_;
			ValaTypeSymbol* _tmp25_;
			gboolean _tmp26_;
			_tmp22_ = type;
			_tmp23_ = vala_data_type_get_data_type (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = self->priv->ginitiallyunowned_type;
			_tmp26_ = vala_typesymbol_is_subtype_of (_tmp24_, _tmp25_);
			_tmp20_ = !_tmp26_;
		} else {
			_tmp20_ = FALSE;
		}
		_tmp14_ = _tmp20_;
	}
	if (_tmp14_) {
		gboolean any_owned = FALSE;
		gboolean _tmp42_ = FALSE;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		any_owned = FALSE;
		{
			ValaList* _generic_arg_list = NULL;
			ValaDataType* _tmp27_;
			ValaList* _tmp28_;
			gint _generic_arg_size = 0;
			ValaList* _tmp29_;
			gint _tmp30_;
			gint _tmp31_;
			gint _generic_arg_index = 0;
			_tmp27_ = type;
			_tmp28_ = vala_data_type_get_type_arguments (_tmp27_);
			_generic_arg_list = _tmp28_;
			_tmp29_ = _generic_arg_list;
			_tmp30_ = vala_collection_get_size ((ValaCollection*) _tmp29_);
			_tmp31_ = _tmp30_;
			_generic_arg_size = _tmp31_;
			_generic_arg_index = -1;
			while (TRUE) {
				gint _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
				ValaDataType* generic_arg = NULL;
				ValaList* _tmp35_;
				gint _tmp36_;
				gpointer _tmp37_;
				gboolean _tmp38_;
				ValaDataType* _tmp39_;
				gboolean _tmp40_;
				gboolean _tmp41_;
				_tmp32_ = _generic_arg_index;
				_generic_arg_index = _tmp32_ + 1;
				_tmp33_ = _generic_arg_index;
				_tmp34_ = _generic_arg_size;
				if (!(_tmp33_ < _tmp34_)) {
					break;
				}
				_tmp35_ = _generic_arg_list;
				_tmp36_ = _generic_arg_index;
				_tmp37_ = vala_list_get (_tmp35_, _tmp36_);
				generic_arg = (ValaDataType*) _tmp37_;
				_tmp38_ = any_owned;
				_tmp39_ = generic_arg;
				_tmp40_ = vala_data_type_get_value_owned (_tmp39_);
				_tmp41_ = _tmp40_;
				any_owned = _tmp38_ | _tmp41_;
				_vala_code_node_unref0 (generic_arg);
			}
			_vala_iterable_unref0 (_generic_arg_list);
		}
		_tmp43_ = type;
		_tmp44_ = vala_data_type_has_type_arguments (_tmp43_);
		if (_tmp44_) {
			gboolean _tmp45_;
			_tmp45_ = any_owned;
			_tmp42_ = !_tmp45_;
		} else {
			_tmp42_ = FALSE;
		}
		if (_tmp42_) {
			GString* _tmp46_;
			_tmp46_ = self->priv->buffer;
			g_string_append_printf (_tmp46_, " transfer-ownership=\"container\"");
		} else {
			GString* _tmp47_;
			_tmp47_ = self->priv->buffer;
			g_string_append_printf (_tmp47_, " transfer-ownership=\"full\"");
		}
	} else {
		GString* _tmp48_;
		_tmp48_ = self->priv->buffer;
		g_string_append_printf (_tmp48_, " transfer-ownership=\"none\"");
	}
	_tmp49_ = caller_allocates;
	if (_tmp49_) {
		GString* _tmp50_;
		_tmp50_ = self->priv->buffer;
		g_string_append_printf (_tmp50_, " caller-allocates=\"1\"");
	}
	_tmp51_ = type;
	_tmp52_ = vala_data_type_get_nullable (_tmp51_);
	_tmp53_ = _tmp52_;
	if (_tmp53_) {
		GString* _tmp54_;
		_tmp54_ = self->priv->buffer;
		g_string_append_printf (_tmp54_, " allow-none=\"1\"");
	}
	_tmp56_ = delegate_type;
	if (_tmp56_ != NULL) {
		ValaDelegateType* _tmp57_;
		ValaDelegate* _tmp58_;
		ValaDelegate* _tmp59_;
		gboolean _tmp60_;
		gboolean _tmp61_;
		_tmp57_ = delegate_type;
		_tmp58_ = vala_delegate_type_get_delegate_symbol (_tmp57_);
		_tmp59_ = _tmp58_;
		_tmp60_ = vala_delegate_get_has_target (_tmp59_);
		_tmp61_ = _tmp60_;
		_tmp55_ = _tmp61_;
	} else {
		_tmp55_ = FALSE;
	}
	if (_tmp55_) {
		gint _tmp62_ = 0;
		gboolean _tmp63_;
		gint closure_index = 0;
		GString* _tmp71_;
		gint _tmp72_;
		ValaDelegateType* _tmp73_;
		gboolean _tmp74_;
		gboolean _tmp75_;
		_tmp63_ = is_parameter;
		if (_tmp63_) {
			gint _tmp64_;
			_tmp64_ = *index;
			_tmp62_ = _tmp64_ + 1;
		} else {
			gint _tmp65_ = 0;
			ValaDataType* _tmp66_;
			gboolean _tmp67_;
			gboolean _tmp68_;
			_tmp66_ = type;
			_tmp67_ = vala_data_type_get_value_owned (_tmp66_);
			_tmp68_ = _tmp67_;
			if (_tmp68_) {
				gint _tmp69_;
				_tmp69_ = *index;
				_tmp65_ = _tmp69_ - 1;
			} else {
				gint _tmp70_;
				_tmp70_ = *index;
				_tmp65_ = _tmp70_;
			}
			_tmp62_ = _tmp65_;
		}
		closure_index = _tmp62_;
		_tmp71_ = self->priv->buffer;
		_tmp72_ = closure_index;
		g_string_append_printf (_tmp71_, " closure=\"%i\"", _tmp72_);
		_tmp73_ = delegate_type;
		_tmp74_ = vala_delegate_type_get_is_called_once (_tmp73_);
		_tmp75_ = _tmp74_;
		if (_tmp75_) {
			GString* _tmp76_;
			_tmp76_ = self->priv->buffer;
			g_string_append (_tmp76_, " scope=\"async\"");
		} else {
			ValaDataType* _tmp77_;
			gboolean _tmp78_;
			gboolean _tmp79_;
			_tmp77_ = type;
			_tmp78_ = vala_data_type_get_value_owned (_tmp77_);
			_tmp79_ = _tmp78_;
			if (_tmp79_) {
				GString* _tmp80_;
				gint _tmp81_;
				_tmp80_ = self->priv->buffer;
				_tmp81_ = closure_index;
				g_string_append_printf (_tmp80_, " scope=\"notified\" destroy=\"%i\"", _tmp81_ + 1);
			} else {
				GString* _tmp82_;
				_tmp82_ = self->priv->buffer;
				g_string_append (_tmp82_, " scope=\"call\"");
			}
		}
	} else {
		ValaDelegateType* _tmp83_;
		_tmp83_ = delegate_type;
		if (_tmp83_ != NULL) {
			GString* _tmp84_;
			_tmp84_ = self->priv->buffer;
			g_string_append (_tmp84_, " scope=\"call\"");
		}
	}
	_tmp85_ = self->priv->buffer;
	g_string_append_printf (_tmp85_, ">\n");
	_tmp86_ = self->priv->indent;
	self->priv->indent = _tmp86_ + 1;
	_tmp87_ = comment;
	vala_gir_writer_write_doc (self, _tmp87_);
	length_param_index = -1;
	_tmp88_ = has_array_length;
	if (_tmp88_) {
		gint _tmp89_ = 0;
		gboolean _tmp90_;
		_tmp90_ = is_parameter;
		if (_tmp90_) {
			gint _tmp91_;
			_tmp91_ = *index;
			_tmp89_ = _tmp91_ + 1;
		} else {
			gint _tmp92_;
			_tmp92_ = *index;
			_tmp89_ = _tmp92_;
		}
		length_param_index = _tmp89_;
	}
	_tmp93_ = type;
	_tmp94_ = length_param_index;
	_tmp95_ = direction;
	vala_gir_writer_write_type (self, _tmp93_, _tmp94_, _tmp95_);
	_tmp96_ = self->priv->indent;
	self->priv->indent = _tmp96_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp97_ = self->priv->buffer;
	_tmp98_ = tag;
	g_string_append_printf (_tmp97_, "</%s>\n", _tmp98_);
	_tmp99_ = *index;
	*index = _tmp99_ + 1;
	_vala_code_node_unref0 (delegate_type);
	_g_free0 (tag);
}


static void vala_gir_writer_write_ctype_attributes (ValaGIRWriter* self, ValaTypeSymbol* symbol, const gchar* suffix) {
	GString* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	g_return_if_fail (suffix != NULL);
	_tmp0_ = self->priv->buffer;
	_tmp1_ = symbol;
	_tmp2_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = suffix;
	g_string_append_printf (_tmp0_, " c:type=\"%s%s\"", _tmp3_, _tmp4_);
	_g_free0 (_tmp3_);
}


static void vala_gir_writer_write_gtype_attributes (ValaGIRWriter* self, ValaTypeSymbol* symbol) {
	ValaTypeSymbol* _tmp0_;
	GString* _tmp1_;
	ValaTypeSymbol* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GString* _tmp5_;
	ValaTypeSymbol* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	_tmp0_ = symbol;
	vala_gir_writer_write_ctype_attributes (self, _tmp0_, "");
	_tmp1_ = self->priv->buffer;
	_tmp2_ = symbol;
	_tmp3_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp2_);
	_tmp4_ = _tmp3_;
	g_string_append_printf (_tmp1_, " glib:type-name=\"%s\"", _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = self->priv->buffer;
	_tmp6_ = symbol;
	_tmp7_ = vala_ccode_base_module_get_ccode_lower_case_prefix ((ValaSymbol*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append_printf (_tmp5_, " glib:get-type=\"%sget_type\"", _tmp8_);
	_g_free0 (_tmp8_);
}


static void vala_gir_writer_write_type (ValaGIRWriter* self, ValaDataType* type, gint index, ValaParameterDirection direction) {
	ValaDataType* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_ARRAY_TYPE)) {
		ValaArrayType* array_type = NULL;
		ValaDataType* _tmp1_;
		ValaArrayType* _tmp2_;
		GString* _tmp3_;
		gboolean _tmp4_ = FALSE;
		ValaArrayType* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		GString* _tmp23_;
		gint _tmp24_;
		ValaArrayType* _tmp25_;
		ValaDataType* _tmp26_;
		ValaDataType* _tmp27_;
		gint _tmp28_;
		GString* _tmp29_;
		_tmp1_ = type;
		_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp2_;
		vala_gir_writer_write_indent (self);
		_tmp3_ = self->priv->buffer;
		g_string_append_printf (_tmp3_, "<array");
		_tmp5_ = array_type;
		_tmp6_ = vala_array_type_get_fixed_length (_tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp7_) {
			ValaArrayType* _tmp8_;
			ValaExpression* _tmp9_;
			ValaExpression* _tmp10_;
			_tmp8_ = array_type;
			_tmp9_ = vala_array_type_get_length (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, VALA_TYPE_INTEGER_LITERAL);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaIntegerLiteral* lit = NULL;
			ValaArrayType* _tmp11_;
			ValaExpression* _tmp12_;
			ValaExpression* _tmp13_;
			ValaIntegerLiteral* _tmp14_;
			GString* _tmp15_;
			ValaIntegerLiteral* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			gint _tmp19_;
			_tmp11_ = array_type;
			_tmp12_ = vala_array_type_get_length (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteral));
			lit = _tmp14_;
			_tmp15_ = self->priv->buffer;
			_tmp16_ = lit;
			_tmp17_ = vala_integer_literal_get_value (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = atoi (_tmp18_);
			g_string_append_printf (_tmp15_, " fixed-size=\"%i\"", _tmp19_);
			_vala_code_node_unref0 (lit);
		} else {
			gint _tmp20_;
			_tmp20_ = index;
			if (_tmp20_ != -1) {
				GString* _tmp21_;
				gint _tmp22_;
				_tmp21_ = self->priv->buffer;
				_tmp22_ = index;
				g_string_append_printf (_tmp21_, " length=\"%i\"", _tmp22_);
			}
		}
		_tmp23_ = self->priv->buffer;
		g_string_append_printf (_tmp23_, ">\n");
		_tmp24_ = self->priv->indent;
		self->priv->indent = _tmp24_ + 1;
		_tmp25_ = array_type;
		_tmp26_ = vala_array_type_get_element_type (_tmp25_);
		_tmp27_ = _tmp26_;
		vala_gir_writer_write_type (self, _tmp27_, -1, VALA_PARAMETER_DIRECTION_IN);
		_tmp28_ = self->priv->indent;
		self->priv->indent = _tmp28_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp29_ = self->priv->buffer;
		g_string_append_printf (_tmp29_, "</array>\n");
		_vala_code_node_unref0 (array_type);
	} else {
		ValaDataType* _tmp30_;
		_tmp30_ = type;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp30_, VALA_TYPE_VOID_TYPE)) {
			GString* _tmp31_;
			vala_gir_writer_write_indent (self);
			_tmp31_ = self->priv->buffer;
			g_string_append_printf (_tmp31_, "<type name=\"none\"/>\n");
		} else {
			ValaDataType* _tmp32_;
			_tmp32_ = type;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp32_, VALA_TYPE_POINTER_TYPE)) {
				GString* _tmp33_;
				ValaDataType* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				vala_gir_writer_write_indent (self);
				_tmp33_ = self->priv->buffer;
				_tmp34_ = type;
				_tmp35_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp34_);
				_tmp36_ = _tmp35_;
				g_string_append_printf (_tmp33_, "<type name=\"gpointer\" c:type=\"%s\"/>\n", _tmp36_);
				_g_free0 (_tmp36_);
			} else {
				ValaDataType* _tmp37_;
				ValaTypeSymbol* _tmp38_;
				ValaTypeSymbol* _tmp39_;
				_tmp37_ = type;
				_tmp38_ = vala_data_type_get_data_type (_tmp37_);
				_tmp39_ = _tmp38_;
				if (_tmp39_ != NULL) {
					gchar* type_name = NULL;
					ValaDataType* _tmp40_;
					ValaTypeSymbol* _tmp41_;
					ValaTypeSymbol* _tmp42_;
					gchar* _tmp43_;
					gboolean is_array = FALSE;
					gboolean _tmp44_ = FALSE;
					const gchar* _tmp45_;
					const gchar* _tmp47_ = NULL;
					gboolean _tmp48_;
					const gchar* _tmp49_ = NULL;
					ValaParameterDirection _tmp50_;
					GString* _tmp51_;
					ValaDataType* _tmp52_;
					ValaTypeSymbol* _tmp53_;
					ValaTypeSymbol* _tmp54_;
					gchar* _tmp55_;
					gchar* _tmp56_;
					ValaDataType* _tmp57_;
					gchar* _tmp58_;
					gchar* _tmp59_;
					ValaList* type_arguments = NULL;
					ValaDataType* _tmp60_;
					ValaList* _tmp61_;
					ValaList* _tmp62_;
					gint _tmp63_;
					gint _tmp64_;
					vala_gir_writer_write_indent (self);
					_tmp40_ = type;
					_tmp41_ = vala_data_type_get_data_type (_tmp40_);
					_tmp42_ = _tmp41_;
					_tmp43_ = vala_gir_writer_gi_type_name (self, _tmp42_);
					type_name = _tmp43_;
					is_array = FALSE;
					_tmp45_ = type_name;
					if (g_strcmp0 (_tmp45_, "GLib.Array") == 0) {
						_tmp44_ = TRUE;
					} else {
						const gchar* _tmp46_;
						_tmp46_ = type_name;
						_tmp44_ = g_strcmp0 (_tmp46_, "GLib.PtrArray") == 0;
					}
					if (_tmp44_) {
						is_array = TRUE;
					}
					_tmp48_ = is_array;
					if (_tmp48_) {
						_tmp47_ = "array";
					} else {
						_tmp47_ = "type";
					}
					_tmp50_ = direction;
					if (_tmp50_ == VALA_PARAMETER_DIRECTION_IN) {
						_tmp49_ = "";
					} else {
						_tmp49_ = "*";
					}
					_tmp51_ = self->priv->buffer;
					_tmp52_ = type;
					_tmp53_ = vala_data_type_get_data_type (_tmp52_);
					_tmp54_ = _tmp53_;
					_tmp55_ = vala_gir_writer_gi_type_name (self, _tmp54_);
					_tmp56_ = _tmp55_;
					_tmp57_ = type;
					_tmp58_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp57_);
					_tmp59_ = _tmp58_;
					g_string_append_printf (_tmp51_, "<%s name=\"%s\" c:type=\"%s%s\"", _tmp47_, _tmp56_, _tmp59_, _tmp49_);
					_g_free0 (_tmp59_);
					_g_free0 (_tmp56_);
					_tmp60_ = type;
					_tmp61_ = vala_data_type_get_type_arguments (_tmp60_);
					type_arguments = _tmp61_;
					_tmp62_ = type_arguments;
					_tmp63_ = vala_collection_get_size ((ValaCollection*) _tmp62_);
					_tmp64_ = _tmp63_;
					if (_tmp64_ == 0) {
						GString* _tmp65_;
						_tmp65_ = self->priv->buffer;
						g_string_append_printf (_tmp65_, "/>\n");
					} else {
						GString* _tmp66_;
						gint _tmp67_;
						gint _tmp80_;
						const gchar* _tmp81_ = NULL;
						gboolean _tmp82_;
						GString* _tmp83_;
						_tmp66_ = self->priv->buffer;
						g_string_append_printf (_tmp66_, ">\n");
						_tmp67_ = self->priv->indent;
						self->priv->indent = _tmp67_ + 1;
						{
							ValaList* _type_argument_list = NULL;
							ValaList* _tmp68_;
							ValaList* _tmp69_;
							gint _type_argument_size = 0;
							ValaList* _tmp70_;
							gint _tmp71_;
							gint _tmp72_;
							gint _type_argument_index = 0;
							_tmp68_ = type_arguments;
							_tmp69_ = _vala_iterable_ref0 (_tmp68_);
							_type_argument_list = _tmp69_;
							_tmp70_ = _type_argument_list;
							_tmp71_ = vala_collection_get_size ((ValaCollection*) _tmp70_);
							_tmp72_ = _tmp71_;
							_type_argument_size = _tmp72_;
							_type_argument_index = -1;
							while (TRUE) {
								gint _tmp73_;
								gint _tmp74_;
								gint _tmp75_;
								ValaDataType* type_argument = NULL;
								ValaList* _tmp76_;
								gint _tmp77_;
								gpointer _tmp78_;
								ValaDataType* _tmp79_;
								_tmp73_ = _type_argument_index;
								_type_argument_index = _tmp73_ + 1;
								_tmp74_ = _type_argument_index;
								_tmp75_ = _type_argument_size;
								if (!(_tmp74_ < _tmp75_)) {
									break;
								}
								_tmp76_ = _type_argument_list;
								_tmp77_ = _type_argument_index;
								_tmp78_ = vala_list_get (_tmp76_, _tmp77_);
								type_argument = (ValaDataType*) _tmp78_;
								_tmp79_ = type_argument;
								vala_gir_writer_write_type (self, _tmp79_, -1, VALA_PARAMETER_DIRECTION_IN);
								_vala_code_node_unref0 (type_argument);
							}
							_vala_iterable_unref0 (_type_argument_list);
						}
						_tmp80_ = self->priv->indent;
						self->priv->indent = _tmp80_ - 1;
						vala_gir_writer_write_indent (self);
						_tmp82_ = is_array;
						if (_tmp82_) {
							_tmp81_ = "array";
						} else {
							_tmp81_ = "type";
						}
						_tmp83_ = self->priv->buffer;
						g_string_append_printf (_tmp83_, "</%s>\n", _tmp81_);
					}
					_vala_iterable_unref0 (type_arguments);
					_g_free0 (type_name);
				} else {
					ValaDataType* _tmp84_;
					_tmp84_ = type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp84_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDelegateType* deleg_type = NULL;
						ValaDataType* _tmp85_;
						ValaDelegateType* _tmp86_;
						GString* _tmp87_;
						ValaDelegateType* _tmp88_;
						ValaDelegate* _tmp89_;
						ValaDelegate* _tmp90_;
						gchar* _tmp91_;
						gchar* _tmp92_;
						ValaDataType* _tmp93_;
						gchar* _tmp94_;
						gchar* _tmp95_;
						_tmp85_ = type;
						_tmp86_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp85_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						deleg_type = _tmp86_;
						vala_gir_writer_write_indent (self);
						_tmp87_ = self->priv->buffer;
						_tmp88_ = deleg_type;
						_tmp89_ = vala_delegate_type_get_delegate_symbol (_tmp88_);
						_tmp90_ = _tmp89_;
						_tmp91_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp90_);
						_tmp92_ = _tmp91_;
						_tmp93_ = type;
						_tmp94_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp93_);
						_tmp95_ = _tmp94_;
						g_string_append_printf (_tmp87_, "<type name=\"%s\" c:type=\"%s\"/>\n", _tmp92_, _tmp95_);
						_g_free0 (_tmp95_);
						_g_free0 (_tmp92_);
						_vala_code_node_unref0 (deleg_type);
					} else {
						ValaDataType* _tmp96_;
						_tmp96_ = type;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp96_, VALA_TYPE_GENERIC_TYPE)) {
							GString* _tmp97_;
							vala_gir_writer_write_indent (self);
							_tmp97_ = self->priv->buffer;
							g_string_append (_tmp97_, "<type name=\"gpointer\" c:type=\"gpointer\"/>\n");
						} else {
							GString* _tmp98_;
							ValaDataType* _tmp99_;
							gchar* _tmp100_;
							gchar* _tmp101_;
							vala_gir_writer_write_indent (self);
							_tmp98_ = self->priv->buffer;
							_tmp99_ = type;
							_tmp100_ = vala_code_node_to_string ((ValaCodeNode*) _tmp99_);
							_tmp101_ = _tmp100_;
							g_string_append_printf (_tmp98_, "<type name=\"%s\"/>\n", _tmp101_);
							_g_free0 (_tmp101_);
						}
					}
				}
			}
		}
	}
}


static void vala_gir_writer_write_annotations (ValaGIRWriter* self, ValaCodeNode* node) {
	ValaCodeNode* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = _tmp0_->attributes;
	{
		GList* attr_collection = NULL;
		GList* attr_it = NULL;
		attr_collection = _tmp1_;
		for (attr_it = attr_collection; attr_it != NULL; attr_it = attr_it->next) {
			ValaAttribute* _tmp2_;
			ValaAttribute* attr = NULL;
			_tmp2_ = _vala_code_node_ref0 ((ValaAttribute*) attr_it->data);
			attr = _tmp2_;
			{
				gchar* name = NULL;
				ValaAttribute* _tmp3_;
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp3_ = attr;
				_tmp4_ = vala_attribute_get_name (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = vala_gir_writer_camel_case_to_canonical (self, _tmp5_);
				name = _tmp6_;
				{
					ValaIterator* _arg_name_it = NULL;
					ValaAttribute* _tmp7_;
					ValaMap* _tmp8_;
					ValaSet* _tmp9_;
					ValaSet* _tmp10_;
					ValaIterator* _tmp11_;
					ValaIterator* _tmp12_;
					_tmp7_ = attr;
					_tmp8_ = _tmp7_->args;
					_tmp9_ = vala_map_get_keys (_tmp8_);
					_tmp10_ = _tmp9_;
					_tmp11_ = vala_iterable_iterator ((ValaIterable*) _tmp10_);
					_tmp12_ = _tmp11_;
					_vala_iterable_unref0 (_tmp10_);
					_arg_name_it = _tmp12_;
					while (TRUE) {
						ValaIterator* _tmp13_;
						gboolean _tmp14_;
						gchar* arg_name = NULL;
						ValaIterator* _tmp15_;
						gpointer _tmp16_;
						gchar* value = NULL;
						ValaAttribute* _tmp17_;
						ValaMap* _tmp18_;
						const gchar* _tmp19_;
						gpointer _tmp20_;
						const gchar* _tmp21_;
						gboolean _tmp22_;
						GString* _tmp26_;
						const gchar* _tmp27_;
						const gchar* _tmp28_;
						gchar* _tmp29_;
						gchar* _tmp30_;
						const gchar* _tmp31_;
						_tmp13_ = _arg_name_it;
						_tmp14_ = vala_iterator_next (_tmp13_);
						if (!_tmp14_) {
							break;
						}
						_tmp15_ = _arg_name_it;
						_tmp16_ = vala_iterator_get (_tmp15_);
						arg_name = (gchar*) _tmp16_;
						_tmp17_ = attr;
						_tmp18_ = _tmp17_->args;
						_tmp19_ = arg_name;
						_tmp20_ = vala_map_get (_tmp18_, _tmp19_);
						value = (gchar*) _tmp20_;
						_tmp21_ = value;
						_tmp22_ = g_str_has_prefix (_tmp21_, "\"");
						if (_tmp22_) {
							ValaAttribute* _tmp23_;
							const gchar* _tmp24_;
							gchar* _tmp25_;
							_tmp23_ = attr;
							_tmp24_ = arg_name;
							_tmp25_ = vala_attribute_get_string (_tmp23_, _tmp24_, NULL);
							_g_free0 (value);
							value = _tmp25_;
						}
						vala_gir_writer_write_indent (self);
						_tmp26_ = self->priv->buffer;
						_tmp27_ = name;
						_tmp28_ = arg_name;
						_tmp29_ = vala_gir_writer_camel_case_to_canonical (self, _tmp28_);
						_tmp30_ = _tmp29_;
						_tmp31_ = value;
						g_string_append_printf (_tmp26_, "<attribute name=\"%s.%s\" value=\"%s\"/>\n", _tmp27_, _tmp30_, _tmp31_);
						_g_free0 (_tmp30_);
						_g_free0 (value);
						_g_free0 (arg_name);
					}
					_vala_iterator_unref0 (_arg_name_it);
				}
				_g_free0 (name);
				_vala_code_node_unref0 (attr);
			}
		}
	}
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gchar* vala_gir_writer_get_full_gir_name (ValaGIRWriter* self, ValaSymbol* sym) {
	gchar* result = NULL;
	gchar* gir_fullname = NULL;
	ValaSymbol* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* gir_name = NULL;
	ValaSymbol* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	const gchar* _tmp10_;
	ValaSymbol* _tmp15_;
	ValaSymbol* _tmp16_;
	ValaSymbol* _tmp17_;
	ValaSymbol* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* parent_gir_name = NULL;
	ValaSymbol* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gchar* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_ = NULL;
	const gchar* _tmp31_;
	gboolean _tmp32_;
	gchar* self_gir_name = NULL;
	gchar* _tmp37_;
	const gchar* _tmp38_;
	gboolean _tmp39_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = sym;
	_tmp1_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp0_, "GIR", "fullname", NULL);
	gir_fullname = _tmp1_;
	_tmp2_ = gir_fullname;
	if (_tmp2_ != NULL) {
		result = gir_fullname;
		return result;
	}
	_tmp3_ = sym;
	_tmp4_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp3_, "GIR", "name", NULL);
	gir_name = _tmp4_;
	_tmp6_ = gir_name;
	if (_tmp6_ == NULL) {
		ValaSymbol* _tmp7_;
		_tmp7_ = sym;
		_tmp5_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_NAMESPACE);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaSymbol* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = sym;
		_tmp9_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp8_, "CCode", "gir_namespace", NULL);
		_g_free0 (gir_name);
		gir_name = _tmp9_;
	}
	_tmp10_ = gir_name;
	if (_tmp10_ == NULL) {
		ValaSymbol* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp11_ = sym;
		_tmp12_ = vala_symbol_get_name (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strdup (_tmp13_);
		_g_free0 (gir_name);
		gir_name = _tmp14_;
	}
	_tmp15_ = sym;
	_tmp16_ = vala_symbol_get_parent_symbol (_tmp15_);
	_tmp17_ = _tmp16_;
	if (_tmp17_ == NULL) {
		result = gir_name;
		_g_free0 (gir_fullname);
		return result;
	}
	_tmp18_ = sym;
	_tmp19_ = vala_symbol_get_name (_tmp18_);
	_tmp20_ = _tmp19_;
	if (_tmp20_ == NULL) {
		ValaSymbol* _tmp21_;
		ValaSymbol* _tmp22_;
		ValaSymbol* _tmp23_;
		gchar* _tmp24_;
		_tmp21_ = sym;
		_tmp22_ = vala_symbol_get_parent_symbol (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = vala_gir_writer_get_full_gir_name (self, _tmp23_);
		result = _tmp24_;
		_g_free0 (gir_name);
		_g_free0 (gir_fullname);
		return result;
	}
	_tmp25_ = sym;
	_tmp26_ = vala_symbol_get_parent_symbol (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_gir_writer_get_full_gir_name (self, _tmp27_);
	parent_gir_name = _tmp28_;
	_tmp29_ = parent_gir_name;
	if (_tmp29_ == NULL) {
		result = gir_name;
		_g_free0 (parent_gir_name);
		_g_free0 (gir_fullname);
		return result;
	}
	_tmp31_ = gir_name;
	_tmp32_ = g_str_has_prefix (_tmp31_, ".");
	if (_tmp32_) {
		const gchar* _tmp33_;
		gchar* _tmp34_;
		_tmp33_ = gir_name;
		_tmp34_ = string_substring (_tmp33_, (glong) 1, (glong) -1);
		_g_free0 (_tmp30_);
		_tmp30_ = _tmp34_;
	} else {
		const gchar* _tmp35_;
		gchar* _tmp36_;
		_tmp35_ = gir_name;
		_tmp36_ = g_strdup (_tmp35_);
		_g_free0 (_tmp30_);
		_tmp30_ = _tmp36_;
	}
	_tmp37_ = g_strdup (_tmp30_);
	self_gir_name = _tmp37_;
	_tmp38_ = parent_gir_name;
	_tmp39_ = string_contains (_tmp38_, ".");
	if (_tmp39_) {
		const gchar* _tmp40_;
		const gchar* _tmp41_;
		gchar* _tmp42_;
		_tmp40_ = parent_gir_name;
		_tmp41_ = self_gir_name;
		_tmp42_ = g_strdup_printf ("%s%s", _tmp40_, _tmp41_);
		result = _tmp42_;
		_g_free0 (self_gir_name);
		_g_free0 (_tmp30_);
		_g_free0 (parent_gir_name);
		_g_free0 (gir_name);
		_g_free0 (gir_fullname);
		return result;
	} else {
		const gchar* _tmp43_;
		const gchar* _tmp44_;
		gchar* _tmp45_;
		_tmp43_ = parent_gir_name;
		_tmp44_ = self_gir_name;
		_tmp45_ = g_strdup_printf ("%s.%s", _tmp43_, _tmp44_);
		result = _tmp45_;
		_g_free0 (self_gir_name);
		_g_free0 (_tmp30_);
		_g_free0 (parent_gir_name);
		_g_free0 (gir_name);
		_g_free0 (gir_fullname);
		return result;
	}
	_g_free0 (self_gir_name);
	_g_free0 (_tmp30_);
	_g_free0 (parent_gir_name);
	_g_free0 (gir_name);
	_g_free0 (gir_fullname);
}


static gchar* vala_gir_writer_gi_type_name (ValaGIRWriter* self, ValaTypeSymbol* type_symbol) {
	gchar* result = NULL;
	ValaSymbol* parent = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaTypeSymbol* _tmp64_;
	gchar* _tmp65_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_symbol != NULL, NULL);
	_tmp0_ = type_symbol;
	_tmp1_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _vala_code_node_ref0 (_tmp2_);
	parent = _tmp3_;
	_tmp4_ = parent;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_NAMESPACE)) {
		ValaNamespace* ns = NULL;
		ValaSymbol* _tmp5_;
		ValaNamespace* _tmp6_;
		gchar* _tmp7_ = NULL;
		ValaNamespace* _tmp8_;
		gchar* _tmp9_;
		gchar* ns_gir_name = NULL;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		_tmp5_ = parent;
		_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_NAMESPACE) ? ((ValaNamespace*) _tmp5_) : NULL);
		ns = _tmp6_;
		_tmp8_ = ns;
		_tmp9_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp8_, "GIR", "name", NULL);
		_tmp7_ = _tmp9_;
		if (_tmp7_ == NULL) {
			ValaNamespace* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp10_ = ns;
			_tmp11_ = vala_symbol_get_name ((ValaSymbol*) _tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strdup (_tmp12_);
			_g_free0 (_tmp7_);
			_tmp7_ = _tmp13_;
		}
		_tmp14_ = _tmp7_;
		_tmp7_ = NULL;
		ns_gir_name = _tmp14_;
		_tmp15_ = ns_gir_name;
		if (_tmp15_ != NULL) {
			ValaTypeSymbol* _tmp16_;
			ValaSourceReference* _tmp17_;
			ValaSourceReference* _tmp18_;
			ValaSourceFile* _tmp19_;
			ValaSourceFile* _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			_tmp16_ = type_symbol;
			_tmp17_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_source_reference_get_file (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_source_file_get_gir_namespace (_tmp20_);
			_tmp22_ = _tmp21_;
			if (_tmp22_ != NULL) {
				ValaGIRWriterGIRNamespace external = {0};
				ValaTypeSymbol* _tmp23_;
				ValaSourceReference* _tmp24_;
				ValaSourceReference* _tmp25_;
				ValaSourceFile* _tmp26_;
				ValaSourceFile* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				ValaTypeSymbol* _tmp30_;
				ValaSourceReference* _tmp31_;
				ValaSourceReference* _tmp32_;
				ValaSourceFile* _tmp33_;
				ValaSourceFile* _tmp34_;
				const gchar* _tmp35_;
				const gchar* _tmp36_;
				ValaArrayList* _tmp37_;
				ValaGIRWriterGIRNamespace _tmp38_;
				gboolean _tmp39_;
				gchar* gir_fullname = NULL;
				ValaTypeSymbol* _tmp42_;
				gchar* _tmp43_;
				const gchar* _tmp44_;
				gchar* _tmp45_ = NULL;
				ValaTypeSymbol* _tmp46_;
				gchar* _tmp47_;
				gchar* type_name = NULL;
				gchar* _tmp52_;
				ValaTypeSymbol* _tmp53_;
				ValaSourceReference* _tmp54_;
				ValaSourceReference* _tmp55_;
				ValaSourceFile* _tmp56_;
				ValaSourceFile* _tmp57_;
				const gchar* _tmp58_;
				const gchar* _tmp59_;
				const gchar* _tmp60_;
				gchar* _tmp61_;
				_tmp23_ = type_symbol;
				_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = vala_source_reference_get_file (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = vala_source_file_get_gir_namespace (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = type_symbol;
				_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = vala_source_reference_get_file (_tmp32_);
				_tmp34_ = _tmp33_;
				_tmp35_ = vala_source_file_get_gir_version (_tmp34_);
				_tmp36_ = _tmp35_;
				vala_gir_writer_gir_namespace_init (&external, _tmp29_, _tmp36_);
				_tmp37_ = self->priv->externals;
				_tmp38_ = external;
				_tmp39_ = vala_collection_contains ((ValaCollection*) _tmp37_, &_tmp38_);
				if (!_tmp39_) {
					ValaArrayList* _tmp40_;
					ValaGIRWriterGIRNamespace _tmp41_;
					_tmp40_ = self->priv->externals;
					_tmp41_ = external;
					vala_collection_add ((ValaCollection*) _tmp40_, &_tmp41_);
				}
				_tmp42_ = type_symbol;
				_tmp43_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp42_, "GIR", "fullname", NULL);
				gir_fullname = _tmp43_;
				_tmp44_ = gir_fullname;
				if (_tmp44_ != NULL) {
					result = gir_fullname;
					vala_gir_writer_gir_namespace_destroy (&external);
					_g_free0 (ns_gir_name);
					_g_free0 (_tmp7_);
					_vala_code_node_unref0 (ns);
					_vala_code_node_unref0 (parent);
					return result;
				}
				_tmp46_ = type_symbol;
				_tmp47_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp46_, "GIR", "name", NULL);
				_tmp45_ = _tmp47_;
				if (_tmp45_ == NULL) {
					ValaTypeSymbol* _tmp48_;
					const gchar* _tmp49_;
					const gchar* _tmp50_;
					gchar* _tmp51_;
					_tmp48_ = type_symbol;
					_tmp49_ = vala_symbol_get_name ((ValaSymbol*) _tmp48_);
					_tmp50_ = _tmp49_;
					_tmp51_ = g_strdup (_tmp50_);
					_g_free0 (_tmp45_);
					_tmp45_ = _tmp51_;
				}
				_tmp52_ = _tmp45_;
				_tmp45_ = NULL;
				type_name = _tmp52_;
				_tmp53_ = type_symbol;
				_tmp54_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp53_);
				_tmp55_ = _tmp54_;
				_tmp56_ = vala_source_reference_get_file (_tmp55_);
				_tmp57_ = _tmp56_;
				_tmp58_ = vala_source_file_get_gir_namespace (_tmp57_);
				_tmp59_ = _tmp58_;
				_tmp60_ = type_name;
				_tmp61_ = g_strdup_printf ("%s.%s", _tmp59_, _tmp60_);
				result = _tmp61_;
				_g_free0 (type_name);
				_g_free0 (_tmp45_);
				_g_free0 (gir_fullname);
				vala_gir_writer_gir_namespace_destroy (&external);
				_g_free0 (ns_gir_name);
				_g_free0 (_tmp7_);
				_vala_code_node_unref0 (ns);
				_vala_code_node_unref0 (parent);
				return result;
			} else {
				ValaHashSet* _tmp62_;
				ValaNamespace* _tmp63_;
				_tmp62_ = self->priv->unannotated_namespaces;
				_tmp63_ = ns;
				vala_collection_add ((ValaCollection*) _tmp62_, _tmp63_);
			}
		}
		_g_free0 (ns_gir_name);
		_g_free0 (_tmp7_);
		_vala_code_node_unref0 (ns);
	}
	_tmp64_ = type_symbol;
	_tmp65_ = vala_gir_writer_get_full_gir_name (self, (ValaSymbol*) _tmp64_);
	result = _tmp65_;
	_vala_code_node_unref0 (parent);
	return result;
}


static gchar* vala_gir_writer_literal_expression_to_value_string (ValaGIRWriter* self, ValaExpression* literal) {
	gchar* result = NULL;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (literal != NULL, NULL);
	_tmp0_ = literal;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_STRING_LITERAL)) {
		ValaStringLiteral* lit = NULL;
		ValaExpression* _tmp1_;
		ValaStringLiteral* _tmp2_;
		ValaStringLiteral* _tmp3_;
		_tmp1_ = literal;
		_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_STRING_LITERAL) ? ((ValaStringLiteral*) _tmp1_) : NULL);
		lit = _tmp2_;
		_tmp3_ = lit;
		if (_tmp3_ != NULL) {
			ValaStringLiteral* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp4_ = lit;
			_tmp5_ = vala_string_literal_eval (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = g_markup_escape_text (_tmp6_, (gssize) -1);
			_tmp8_ = _tmp7_;
			_g_free0 (_tmp6_);
			result = _tmp8_;
			_vala_code_node_unref0 (lit);
			return result;
		}
		_vala_code_node_unref0 (lit);
	} else {
		ValaExpression* _tmp9_;
		_tmp9_ = literal;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_CHARACTER_LITERAL)) {
			ValaExpression* _tmp10_;
			gunichar _tmp11_;
			gchar* _tmp12_;
			_tmp10_ = literal;
			_tmp11_ = vala_character_literal_get_char (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_CHARACTER_LITERAL, ValaCharacterLiteral));
			_tmp12_ = g_strdup_printf ("%c", (gint) ((gchar) _tmp11_));
			result = _tmp12_;
			return result;
		} else {
			ValaExpression* _tmp13_;
			_tmp13_ = literal;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, VALA_TYPE_BOOLEAN_LITERAL)) {
				const gchar* _tmp14_ = NULL;
				ValaExpression* _tmp15_;
				gboolean _tmp16_;
				gboolean _tmp17_;
				gchar* _tmp18_;
				_tmp15_ = literal;
				_tmp16_ = vala_boolean_literal_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, VALA_TYPE_BOOLEAN_LITERAL, ValaBooleanLiteral));
				_tmp17_ = _tmp16_;
				if (_tmp17_) {
					_tmp14_ = "true";
				} else {
					_tmp14_ = "false";
				}
				_tmp18_ = g_strdup (_tmp14_);
				result = _tmp18_;
				return result;
			} else {
				ValaExpression* _tmp19_;
				_tmp19_ = literal;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, VALA_TYPE_REAL_LITERAL)) {
					ValaExpression* _tmp20_;
					const gchar* _tmp21_;
					const gchar* _tmp22_;
					gchar* _tmp23_;
					_tmp20_ = literal;
					_tmp21_ = vala_real_literal_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_REAL_LITERAL, ValaRealLiteral));
					_tmp22_ = _tmp21_;
					_tmp23_ = g_strdup (_tmp22_);
					result = _tmp23_;
					return result;
				} else {
					ValaExpression* _tmp24_;
					_tmp24_ = literal;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALA_TYPE_INTEGER_LITERAL)) {
						ValaExpression* _tmp25_;
						const gchar* _tmp26_;
						const gchar* _tmp27_;
						gchar* _tmp28_;
						_tmp25_ = literal;
						_tmp26_ = vala_integer_literal_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteral));
						_tmp27_ = _tmp26_;
						_tmp28_ = g_strdup (_tmp27_);
						result = _tmp28_;
						return result;
					} else {
						ValaExpression* _tmp29_;
						_tmp29_ = literal;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, VALA_TYPE_UNARY_EXPRESSION)) {
							ValaUnaryExpression* unary = NULL;
							ValaExpression* _tmp30_;
							ValaUnaryExpression* _tmp31_;
							ValaUnaryExpression* _tmp32_;
							ValaUnaryOperator _tmp33_;
							ValaUnaryOperator _tmp34_;
							_tmp30_ = literal;
							_tmp31_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression));
							unary = _tmp31_;
							_tmp32_ = unary;
							_tmp33_ = vala_unary_expression_get_operator (_tmp32_);
							_tmp34_ = _tmp33_;
							if (_tmp34_ == VALA_UNARY_OPERATOR_MINUS) {
								ValaUnaryExpression* _tmp35_;
								ValaExpression* _tmp36_;
								ValaExpression* _tmp37_;
								_tmp35_ = unary;
								_tmp36_ = vala_unary_expression_get_inner (_tmp35_);
								_tmp37_ = _tmp36_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp37_, VALA_TYPE_REAL_LITERAL)) {
									ValaUnaryExpression* _tmp38_;
									ValaExpression* _tmp39_;
									ValaExpression* _tmp40_;
									const gchar* _tmp41_;
									const gchar* _tmp42_;
									gchar* _tmp43_;
									_tmp38_ = unary;
									_tmp39_ = vala_unary_expression_get_inner (_tmp38_);
									_tmp40_ = _tmp39_;
									_tmp41_ = vala_real_literal_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, VALA_TYPE_REAL_LITERAL, ValaRealLiteral));
									_tmp42_ = _tmp41_;
									_tmp43_ = g_strconcat ("-", _tmp42_, NULL);
									result = _tmp43_;
									_vala_code_node_unref0 (unary);
									return result;
								} else {
									ValaUnaryExpression* _tmp44_;
									ValaExpression* _tmp45_;
									ValaExpression* _tmp46_;
									_tmp44_ = unary;
									_tmp45_ = vala_unary_expression_get_inner (_tmp44_);
									_tmp46_ = _tmp45_;
									if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp46_, VALA_TYPE_INTEGER_LITERAL)) {
										ValaUnaryExpression* _tmp47_;
										ValaExpression* _tmp48_;
										ValaExpression* _tmp49_;
										const gchar* _tmp50_;
										const gchar* _tmp51_;
										gchar* _tmp52_;
										_tmp47_ = unary;
										_tmp48_ = vala_unary_expression_get_inner (_tmp47_);
										_tmp49_ = _tmp48_;
										_tmp50_ = vala_integer_literal_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteral));
										_tmp51_ = _tmp50_;
										_tmp52_ = g_strconcat ("-", _tmp51_, NULL);
										result = _tmp52_;
										_vala_code_node_unref0 (unary);
										return result;
									}
								}
							}
							_vala_code_node_unref0 (unary);
						}
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_;
	gint _tmp3__length1;
	_tmp0_ = separator;
	if (_tmp0_ == NULL) {
		separator = "";
	}
	_tmp3_ = str_array;
	_tmp3__length1 = str_array_length1;
	if (_tmp3_ != NULL) {
		_tmp2_ = TRUE;
	} else {
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = str_array;
		_tmp4__length1 = str_array_length1;
		_tmp2_ = _tmp4__length1 > 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_;
		gint _tmp6__length1;
		_tmp6_ = str_array;
		_tmp6__length1 = str_array_length1;
		if (_tmp6__length1 == -1) {
			gchar** _tmp7_;
			gint _tmp7__length1;
			const gchar* _tmp8_;
			_tmp7_ = str_array;
			_tmp7__length1 = str_array_length1;
			_tmp8_ = _tmp7_[0];
			_tmp5_ = _tmp8_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_;
		gint _tmp33_;
		gint _tmp34_;
		gsize _tmp35_;
		const gchar* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		const gchar* res = NULL;
		gsize _tmp40_;
		void* _tmp41_;
		void* ptr = NULL;
		const gchar* _tmp42_;
		gchar** _tmp43_;
		gint _tmp43__length1;
		const gchar* _tmp44_;
		void* _tmp45_;
		const gchar* _tmp62_;
		len = (gsize) 1;
		{
			gboolean _tmp9_ = FALSE;
			i = 0;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_;
				gint _tmp13__length1;
				gint _tmp21_ = 0;
				gchar** _tmp22_;
				gint _tmp22__length1;
				gint _tmp23_;
				const gchar* _tmp24_;
				gsize _tmp30_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp13_ = str_array;
				_tmp13__length1 = str_array_length1;
				if (_tmp13__length1 != -1) {
					gint _tmp14_;
					gchar** _tmp15_;
					gint _tmp15__length1;
					_tmp14_ = i;
					_tmp15_ = str_array;
					_tmp15__length1 = str_array_length1;
					_tmp12_ = _tmp14_ < _tmp15__length1;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					_tmp11_ = TRUE;
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_;
					gint _tmp17__length1;
					_tmp17_ = str_array;
					_tmp17__length1 = str_array_length1;
					if (_tmp17__length1 == -1) {
						gchar** _tmp18_;
						gint _tmp18__length1;
						gint _tmp19_;
						const gchar* _tmp20_;
						_tmp18_ = str_array;
						_tmp18__length1 = str_array_length1;
						_tmp19_ = i;
						_tmp20_ = _tmp18_[_tmp19_];
						_tmp16_ = _tmp20_ != NULL;
					} else {
						_tmp16_ = FALSE;
					}
					_tmp11_ = _tmp16_;
				}
				if (!_tmp11_) {
					break;
				}
				_tmp22_ = str_array;
				_tmp22__length1 = str_array_length1;
				_tmp23_ = i;
				_tmp24_ = _tmp22_[_tmp23_];
				if (_tmp24_ != NULL) {
					gchar** _tmp25_;
					gint _tmp25__length1;
					gint _tmp26_;
					const gchar* _tmp27_;
					gint _tmp28_;
					gint _tmp29_;
					_tmp25_ = str_array;
					_tmp25__length1 = str_array_length1;
					_tmp26_ = i;
					_tmp27_ = _tmp25_[_tmp26_];
					_tmp28_ = strlen ((const gchar*) _tmp27_);
					_tmp29_ = _tmp28_;
					_tmp21_ = _tmp29_;
				} else {
					_tmp21_ = 0;
				}
				_tmp30_ = len;
				len = _tmp30_ + _tmp21_;
			}
		}
		_tmp31_ = i;
		if (_tmp31_ == 0) {
			gchar* _tmp32_;
			_tmp32_ = g_strdup ("");
			result = _tmp32_;
			return result;
		}
		_tmp33_ = i;
		str_array_length1 = _tmp33_;
		_tmp34_ = str_array_length1;
		_tmp35_ = len;
		_tmp36_ = separator;
		_tmp37_ = strlen ((const gchar*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = i;
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
		_tmp40_ = len;
		_tmp41_ = g_malloc (_tmp40_);
		res = _tmp41_;
		_tmp42_ = res;
		_tmp43_ = str_array;
		_tmp43__length1 = str_array_length1;
		_tmp44_ = _tmp43_[0];
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
		ptr = _tmp45_;
		{
			gboolean _tmp46_ = FALSE;
			i = 1;
			_tmp46_ = TRUE;
			while (TRUE) {
				gint _tmp48_;
				gchar** _tmp49_;
				gint _tmp49__length1;
				void* _tmp50_;
				const gchar* _tmp51_;
				void* _tmp52_;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_;
				gint _tmp54__length1;
				gint _tmp55_;
				const gchar* _tmp56_;
				void* _tmp60_;
				void* _tmp61_;
				if (!_tmp46_) {
					gint _tmp47_;
					_tmp47_ = i;
					i = _tmp47_ + 1;
				}
				_tmp46_ = FALSE;
				_tmp48_ = i;
				_tmp49_ = str_array;
				_tmp49__length1 = str_array_length1;
				if (!(_tmp48_ < _tmp49__length1)) {
					break;
				}
				_tmp50_ = ptr;
				_tmp51_ = separator;
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
				ptr = _tmp52_;
				_tmp54_ = str_array;
				_tmp54__length1 = str_array_length1;
				_tmp55_ = i;
				_tmp56_ = _tmp54_[_tmp55_];
				if (_tmp56_ != NULL) {
					gchar** _tmp57_;
					gint _tmp57__length1;
					gint _tmp58_;
					const gchar* _tmp59_;
					_tmp57_ = str_array;
					_tmp57__length1 = str_array_length1;
					_tmp58_ = i;
					_tmp59_ = _tmp57_[_tmp58_];
					_tmp53_ = (const gchar*) _tmp59_;
				} else {
					_tmp53_ = "";
				}
				_tmp60_ = ptr;
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
				ptr = _tmp61_;
			}
		}
		_tmp62_ = res;
		res = NULL;
		result = (gchar*) _tmp62_;
		return result;
	} else {
		gchar* _tmp63_;
		_tmp63_ = g_strdup ("");
		result = _tmp63_;
		return result;
	}
}


static gchar* vala_gir_writer_camel_case_to_canonical (ValaGIRWriter* self, const gchar* name) {
	gchar* result = NULL;
	gchar** parts = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gint parts_length1;
	gint _parts_size_;
	gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = vala_symbol_camel_case_to_lower_case (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, "_", 0);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _vala_array_length (_tmp3_);
	_g_free0 (_tmp2_);
	parts = _tmp5_;
	parts_length1 = _tmp5__length1;
	_parts_size_ = parts_length1;
	_tmp6_ = _vala_g_strjoinv ("-", parts, parts_length1);
	result = _tmp6_;
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gboolean vala_gir_writer_check_accessibility (ValaGIRWriter* self, ValaSymbol* sym) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbolAccessibility _tmp2_;
	ValaSymbolAccessibility _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = sym;
	_tmp2_ = vala_symbol_get_access (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp4_;
		ValaSymbolAccessibility _tmp5_;
		ValaSymbolAccessibility _tmp6_;
		_tmp4_ = sym;
		_tmp5_ = vala_symbol_get_access (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


ValaGIRWriter* vala_gir_writer_construct (GType object_type) {
	ValaGIRWriter* self = NULL;
	self = (ValaGIRWriter*) vala_code_visitor_construct (object_type);
	return self;
}


ValaGIRWriter* vala_gir_writer_new (void) {
	return vala_gir_writer_construct (VALA_TYPE_GIR_WRITER);
}


static void vala_gir_writer_gir_namespace_init (ValaGIRWriterGIRNamespace *self, const gchar* ns, const gchar* version) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (ns != NULL);
	g_return_if_fail (version != NULL);
	memset (self, 0, sizeof (ValaGIRWriterGIRNamespace));
	_tmp0_ = ns;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*self).ns);
	(*self).ns = _tmp1_;
	_tmp2_ = version;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*self).version);
	(*self).version = _tmp3_;
}


static gboolean vala_gir_writer_gir_namespace_equal (ValaGIRWriterGIRNamespace *self, ValaGIRWriterGIRNamespace* g) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	ValaGIRWriterGIRNamespace _tmp2_;
	const gchar* _tmp3_;
	g_return_val_if_fail (g != NULL, FALSE);
	_tmp1_ = (*self).ns;
	_tmp2_ = *g;
	_tmp3_ = _tmp2_.ns;
	if (g_strcmp0 (_tmp1_, _tmp3_) == 0) {
		const gchar* _tmp4_;
		ValaGIRWriterGIRNamespace _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = (*self).version;
		_tmp5_ = *g;
		_tmp6_ = _tmp5_.version;
		_tmp0_ = g_strcmp0 (_tmp4_, _tmp6_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static void vala_gir_writer_gir_namespace_copy (const ValaGIRWriterGIRNamespace* self, ValaGIRWriterGIRNamespace* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).ns;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).ns);
	(*dest).ns = _tmp1_;
	_tmp2_ = (*self).version;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).version);
	(*dest).version = _tmp3_;
}


static void vala_gir_writer_gir_namespace_destroy (ValaGIRWriterGIRNamespace* self) {
	_g_free0 ((*self).ns);
	_g_free0 ((*self).version);
}


static ValaGIRWriterGIRNamespace* vala_gir_writer_gir_namespace_dup (const ValaGIRWriterGIRNamespace* self) {
	ValaGIRWriterGIRNamespace* dup;
	dup = g_new0 (ValaGIRWriterGIRNamespace, 1);
	vala_gir_writer_gir_namespace_copy (self, dup);
	return dup;
}


static void vala_gir_writer_gir_namespace_free (ValaGIRWriterGIRNamespace* self) {
	vala_gir_writer_gir_namespace_destroy (self);
	g_free (self);
}


static GType vala_gir_writer_gir_namespace_get_type (void) {
	static volatile gsize vala_gir_writer_gir_namespace_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_writer_gir_namespace_type_id__volatile)) {
		GType vala_gir_writer_gir_namespace_type_id;
		vala_gir_writer_gir_namespace_type_id = g_boxed_type_register_static ("ValaGIRWriterGIRNamespace", (GBoxedCopyFunc) vala_gir_writer_gir_namespace_dup, (GBoxedFreeFunc) vala_gir_writer_gir_namespace_free);
		g_once_init_leave (&vala_gir_writer_gir_namespace_type_id__volatile, vala_gir_writer_gir_namespace_type_id);
	}
	return vala_gir_writer_gir_namespace_type_id__volatile;
}


static void vala_gir_writer_class_init (ValaGIRWriterClass * klass) {
	vala_gir_writer_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_gir_writer_finalize;
	g_type_class_add_private (klass, sizeof (ValaGIRWriterPrivate));
	((ValaGIRWriterClass *) klass)->get_interface_comment = (gchar* (*) (ValaGIRWriter *, ValaInterface*)) vala_gir_writer_real_get_interface_comment;
	((ValaGIRWriterClass *) klass)->get_struct_comment = (gchar* (*) (ValaGIRWriter *, ValaStruct*)) vala_gir_writer_real_get_struct_comment;
	((ValaGIRWriterClass *) klass)->get_enum_comment = (gchar* (*) (ValaGIRWriter *, ValaEnum*)) vala_gir_writer_real_get_enum_comment;
	((ValaGIRWriterClass *) klass)->get_class_comment = (gchar* (*) (ValaGIRWriter *, ValaClass*)) vala_gir_writer_real_get_class_comment;
	((ValaGIRWriterClass *) klass)->get_error_code_comment = (gchar* (*) (ValaGIRWriter *, ValaErrorCode*)) vala_gir_writer_real_get_error_code_comment;
	((ValaGIRWriterClass *) klass)->get_enum_value_comment = (gchar* (*) (ValaGIRWriter *, ValaEnumValue*)) vala_gir_writer_real_get_enum_value_comment;
	((ValaGIRWriterClass *) klass)->get_constant_comment = (gchar* (*) (ValaGIRWriter *, ValaConstant*)) vala_gir_writer_real_get_constant_comment;
	((ValaGIRWriterClass *) klass)->get_error_domain_comment = (gchar* (*) (ValaGIRWriter *, ValaErrorDomain*)) vala_gir_writer_real_get_error_domain_comment;
	((ValaGIRWriterClass *) klass)->get_field_comment = (gchar* (*) (ValaGIRWriter *, ValaField*)) vala_gir_writer_real_get_field_comment;
	((ValaGIRWriterClass *) klass)->get_delegate_comment = (gchar* (*) (ValaGIRWriter *, ValaDelegate*)) vala_gir_writer_real_get_delegate_comment;
	((ValaGIRWriterClass *) klass)->get_method_comment = (gchar* (*) (ValaGIRWriter *, ValaMethod*)) vala_gir_writer_real_get_method_comment;
	((ValaGIRWriterClass *) klass)->get_property_comment = (gchar* (*) (ValaGIRWriter *, ValaProperty*)) vala_gir_writer_real_get_property_comment;
	((ValaGIRWriterClass *) klass)->get_delegate_return_comment = (gchar* (*) (ValaGIRWriter *, ValaDelegate*)) vala_gir_writer_real_get_delegate_return_comment;
	((ValaGIRWriterClass *) klass)->get_signal_return_comment = (gchar* (*) (ValaGIRWriter *, ValaSignal*)) vala_gir_writer_real_get_signal_return_comment;
	((ValaGIRWriterClass *) klass)->get_method_return_comment = (gchar* (*) (ValaGIRWriter *, ValaMethod*)) vala_gir_writer_real_get_method_return_comment;
	((ValaGIRWriterClass *) klass)->get_signal_comment = (gchar* (*) (ValaGIRWriter *, ValaSignal*)) vala_gir_writer_real_get_signal_comment;
	((ValaGIRWriterClass *) klass)->get_parameter_comment = (gchar* (*) (ValaGIRWriter *, ValaParameter*)) vala_gir_writer_real_get_parameter_comment;
	((ValaCodeVisitorClass *) klass)->visit_namespace = (void (*) (ValaCodeVisitor *, ValaNamespace*)) vala_gir_writer_real_visit_namespace;
	((ValaCodeVisitorClass *) klass)->visit_class = (void (*) (ValaCodeVisitor *, ValaClass*)) vala_gir_writer_real_visit_class;
	((ValaCodeVisitorClass *) klass)->visit_struct = (void (*) (ValaCodeVisitor *, ValaStruct*)) vala_gir_writer_real_visit_struct;
	((ValaCodeVisitorClass *) klass)->visit_interface = (void (*) (ValaCodeVisitor *, ValaInterface*)) vala_gir_writer_real_visit_interface;
	((ValaCodeVisitorClass *) klass)->visit_enum = (void (*) (ValaCodeVisitor *, ValaEnum*)) vala_gir_writer_real_visit_enum;
	((ValaCodeVisitorClass *) klass)->visit_enum_value = (void (*) (ValaCodeVisitor *, ValaEnumValue*)) vala_gir_writer_real_visit_enum_value;
	((ValaCodeVisitorClass *) klass)->visit_error_domain = (void (*) (ValaCodeVisitor *, ValaErrorDomain*)) vala_gir_writer_real_visit_error_domain;
	((ValaCodeVisitorClass *) klass)->visit_error_code = (void (*) (ValaCodeVisitor *, ValaErrorCode*)) vala_gir_writer_real_visit_error_code;
	((ValaCodeVisitorClass *) klass)->visit_constant = (void (*) (ValaCodeVisitor *, ValaConstant*)) vala_gir_writer_real_visit_constant;
	((ValaCodeVisitorClass *) klass)->visit_field = (void (*) (ValaCodeVisitor *, ValaField*)) vala_gir_writer_real_visit_field;
	((ValaCodeVisitorClass *) klass)->visit_delegate = (void (*) (ValaCodeVisitor *, ValaDelegate*)) vala_gir_writer_real_visit_delegate;
	((ValaCodeVisitorClass *) klass)->visit_method = (void (*) (ValaCodeVisitor *, ValaMethod*)) vala_gir_writer_real_visit_method;
	((ValaCodeVisitorClass *) klass)->visit_creation_method = (void (*) (ValaCodeVisitor *, ValaCreationMethod*)) vala_gir_writer_real_visit_creation_method;
	((ValaCodeVisitorClass *) klass)->visit_property = (void (*) (ValaCodeVisitor *, ValaProperty*)) vala_gir_writer_real_visit_property;
	((ValaCodeVisitorClass *) klass)->visit_signal = (void (*) (ValaCodeVisitor *, ValaSignal*)) vala_gir_writer_real_visit_signal;
}


static void vala_gir_writer_instance_init (ValaGIRWriter * self) {
	GString* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashSet* _tmp3_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	ValaHashSet* _tmp6_;
	GEqualFunc _tmp7_;
	ValaArrayList* _tmp8_;
	GEqualFunc _tmp9_;
	ValaArrayList* _tmp10_;
	ValaArrayList* _tmp11_;
	self->priv = VALA_GIR_WRITER_GET_PRIVATE (self);
	_tmp0_ = g_string_new ("");
	self->priv->buffer = _tmp0_;
	_tmp1_ = g_direct_hash;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_set_new (VALA_TYPE_NAMESPACE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_, _tmp2_);
	self->priv->unannotated_namespaces = _tmp3_;
	_tmp4_ = g_direct_hash;
	_tmp5_ = g_direct_equal;
	_tmp6_ = vala_hash_set_new (VALA_TYPE_NAMESPACE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_, _tmp5_);
	self->priv->our_namespaces = _tmp6_;
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_array_list_new (VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp7_);
	self->priv->hierarchy = _tmp8_;
	_tmp9_ = g_direct_equal;
	_tmp10_ = vala_array_list_new (VALA_TYPE_CODE_NODE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp9_);
	self->priv->deferred = _tmp10_;
	_tmp11_ = vala_array_list_new (VALA_GIR_WRITER_TYPE_GIR_NAMESPACE, (GBoxedCopyFunc) vala_gir_writer_gir_namespace_dup, (GDestroyNotify) vala_gir_writer_gir_namespace_free, (GEqualFunc) vala_gir_writer_gir_namespace_equal);
	self->priv->externals = _tmp11_;
}


static void vala_gir_writer_finalize (ValaCodeVisitor * obj) {
	ValaGIRWriter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_GIR_WRITER, ValaGIRWriter);
	_vala_code_context_unref0 (self->priv->context);
	_g_free0 (self->priv->directory);
	_g_free0 (self->priv->gir_namespace);
	_g_free0 (self->priv->gir_version);
	_g_free0 (self->priv->gir_shared_library);
	_g_string_free0 (self->priv->buffer);
	_fclose0 (self->priv->stream);
	_vala_iterable_unref0 (self->priv->unannotated_namespaces);
	_vala_iterable_unref0 (self->priv->our_namespaces);
	_vala_iterable_unref0 (self->priv->hierarchy);
	_vala_iterable_unref0 (self->priv->deferred);
	_vala_code_node_unref0 (self->priv->gobject_type);
	_vala_code_node_unref0 (self->priv->ginitiallyunowned_type);
	_vala_iterable_unref0 (self->priv->externals);
	VALA_CODE_VISITOR_CLASS (vala_gir_writer_parent_class)->finalize (obj);
}


/**
 * Code visitor generating .gir file for the public interface.
 */
GType vala_gir_writer_get_type (void) {
	static volatile gsize vala_gir_writer_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_writer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGIRWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGIRWriter), 0, (GInstanceInitFunc) vala_gir_writer_instance_init, NULL };
		GType vala_gir_writer_type_id;
		vala_gir_writer_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaGIRWriter", &g_define_type_info, 0);
		g_once_init_leave (&vala_gir_writer_type_id__volatile, vala_gir_writer_type_id);
	}
	return vala_gir_writer_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



