/* valagirwriter.c generated by valac, the Vala compiler
 * generated from valagirwriter.vala, do not modify */

/* valagirwriter.vala
 *
 * Copyright (C) 2008-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <valagee.h>
#include <glib/gstdio.h>
#include <version.h>


#define VALA_TYPE_GIR_WRITER (vala_gir_writer_get_type ())
#define VALA_GIR_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GIR_WRITER, ValaGIRWriter))
#define VALA_GIR_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GIR_WRITER, ValaGIRWriterClass))
#define VALA_IS_GIR_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GIR_WRITER))
#define VALA_IS_GIR_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GIR_WRITER))
#define VALA_GIR_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GIR_WRITER, ValaGIRWriterClass))

typedef struct _ValaGIRWriter ValaGIRWriter;
typedef struct _ValaGIRWriterClass ValaGIRWriterClass;
typedef struct _ValaGIRWriterPrivate ValaGIRWriterPrivate;

#define VALA_GIR_WRITER_TYPE_GIR_NAMESPACE (vala_gir_writer_gir_namespace_get_type ())
typedef struct _ValaGIRWriterGIRNamespace ValaGIRWriterGIRNamespace;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_gir_writer_gir_namespace_free0(var) ((var == NULL) ? NULL : (var = (vala_gir_writer_gir_namespace_free (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_mapped_file_unref0(var) ((var == NULL) ? NULL : (var = (g_mapped_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))

#define VALA_TYPE_CCODE_BASE_MODULE (vala_ccode_base_module_get_type ())
#define VALA_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModule))
#define VALA_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))
#define VALA_IS_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_IS_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_CCODE_BASE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))

typedef struct _ValaCCodeBaseModule ValaCCodeBaseModule;
typedef struct _ValaCCodeBaseModuleClass ValaCCodeBaseModuleClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _ValaGIRWriter {
	ValaCodeVisitor parent_instance;
	ValaGIRWriterPrivate * priv;
};

struct _ValaGIRWriterClass {
	ValaCodeVisitorClass parent_class;
	gchar* (*get_interface_comment) (ValaGIRWriter* self, ValaInterface* iface);
	gchar* (*get_struct_comment) (ValaGIRWriter* self, ValaStruct* st);
	gchar* (*get_enum_comment) (ValaGIRWriter* self, ValaEnum* en);
	gchar* (*get_class_comment) (ValaGIRWriter* self, ValaClass* c);
	gchar* (*get_error_code_comment) (ValaGIRWriter* self, ValaErrorCode* ecode);
	gchar* (*get_enum_value_comment) (ValaGIRWriter* self, ValaEnumValue* ev);
	gchar* (*get_constant_comment) (ValaGIRWriter* self, ValaConstant* c);
	gchar* (*get_error_domain_comment) (ValaGIRWriter* self, ValaErrorDomain* edomain);
	gchar* (*get_field_comment) (ValaGIRWriter* self, ValaField* f);
	gchar* (*get_delegate_comment) (ValaGIRWriter* self, ValaDelegate* cb);
	gchar* (*get_method_comment) (ValaGIRWriter* self, ValaMethod* m);
	gchar* (*get_property_comment) (ValaGIRWriter* self, ValaProperty* prop);
	gchar* (*get_delegate_return_comment) (ValaGIRWriter* self, ValaDelegate* cb);
	gchar* (*get_signal_return_comment) (ValaGIRWriter* self, ValaSignal* sig);
	gchar* (*get_method_return_comment) (ValaGIRWriter* self, ValaMethod* m);
	gchar* (*get_signal_comment) (ValaGIRWriter* self, ValaSignal* sig);
	gchar* (*get_parameter_comment) (ValaGIRWriter* self, ValaParameter* param);
};

struct _ValaGIRWriterGIRNamespace {
	gchar* ns;
	gchar* version;
};

struct _ValaGIRWriterPrivate {
	ValaCodeContext* context;
	gchar* directory;
	gchar* gir_namespace;
	gchar* gir_version;
	gchar* gir_shared_library;
	GString* buffer;
	FILE* stream;
	ValaHashSet* unannotated_namespaces;
	ValaHashSet* our_namespaces;
	ValaArrayList* hierarchy;
	ValaArrayList* deferred;
	gint indent;
	ValaTypeSymbol* gobject_type;
	ValaTypeSymbol* ginitiallyunowned_type;
	ValaTypeSymbol* gtypeinterface_type;
	ValaTypeSymbol* gtypeinstance_type;
	ValaTypeSymbol* gtype_type;
	ValaArrayList* externals;
	gint enum_value;
};


static gpointer vala_gir_writer_parent_class = NULL;

GType vala_gir_writer_get_type (void) G_GNUC_CONST;
static GType vala_gir_writer_gir_namespace_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaGIRWriterGIRNamespace* vala_gir_writer_gir_namespace_dup (const ValaGIRWriterGIRNamespace* self);
static void vala_gir_writer_gir_namespace_free (ValaGIRWriterGIRNamespace* self);
static void vala_gir_writer_gir_namespace_copy (const ValaGIRWriterGIRNamespace* self, ValaGIRWriterGIRNamespace* dest);
static void vala_gir_writer_gir_namespace_destroy (ValaGIRWriterGIRNamespace* self);
#define VALA_GIR_WRITER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_GIR_WRITER, ValaGIRWriterPrivate))
enum  {
	VALA_GIR_WRITER_0_PROPERTY
};
static gboolean vala_gir_writer_gir_namespace_equal (ValaGIRWriterGIRNamespace *self, ValaGIRWriterGIRNamespace* g);
gchar* vala_gir_writer_get_interface_comment (ValaGIRWriter* self, ValaInterface* iface);
static gchar* vala_gir_writer_real_get_interface_comment (ValaGIRWriter* self, ValaInterface* iface);
gchar* vala_gir_writer_get_struct_comment (ValaGIRWriter* self, ValaStruct* st);
static gchar* vala_gir_writer_real_get_struct_comment (ValaGIRWriter* self, ValaStruct* st);
gchar* vala_gir_writer_get_enum_comment (ValaGIRWriter* self, ValaEnum* en);
static gchar* vala_gir_writer_real_get_enum_comment (ValaGIRWriter* self, ValaEnum* en);
gchar* vala_gir_writer_get_class_comment (ValaGIRWriter* self, ValaClass* c);
static gchar* vala_gir_writer_real_get_class_comment (ValaGIRWriter* self, ValaClass* c);
gchar* vala_gir_writer_get_error_code_comment (ValaGIRWriter* self, ValaErrorCode* ecode);
static gchar* vala_gir_writer_real_get_error_code_comment (ValaGIRWriter* self, ValaErrorCode* ecode);
gchar* vala_gir_writer_get_enum_value_comment (ValaGIRWriter* self, ValaEnumValue* ev);
static gchar* vala_gir_writer_real_get_enum_value_comment (ValaGIRWriter* self, ValaEnumValue* ev);
gchar* vala_gir_writer_get_constant_comment (ValaGIRWriter* self, ValaConstant* c);
static gchar* vala_gir_writer_real_get_constant_comment (ValaGIRWriter* self, ValaConstant* c);
gchar* vala_gir_writer_get_error_domain_comment (ValaGIRWriter* self, ValaErrorDomain* edomain);
static gchar* vala_gir_writer_real_get_error_domain_comment (ValaGIRWriter* self, ValaErrorDomain* edomain);
gchar* vala_gir_writer_get_field_comment (ValaGIRWriter* self, ValaField* f);
static gchar* vala_gir_writer_real_get_field_comment (ValaGIRWriter* self, ValaField* f);
gchar* vala_gir_writer_get_delegate_comment (ValaGIRWriter* self, ValaDelegate* cb);
static gchar* vala_gir_writer_real_get_delegate_comment (ValaGIRWriter* self, ValaDelegate* cb);
gchar* vala_gir_writer_get_method_comment (ValaGIRWriter* self, ValaMethod* m);
static gchar* vala_gir_writer_real_get_method_comment (ValaGIRWriter* self, ValaMethod* m);
gchar* vala_gir_writer_get_property_comment (ValaGIRWriter* self, ValaProperty* prop);
static gchar* vala_gir_writer_real_get_property_comment (ValaGIRWriter* self, ValaProperty* prop);
gchar* vala_gir_writer_get_delegate_return_comment (ValaGIRWriter* self, ValaDelegate* cb);
static gchar* vala_gir_writer_real_get_delegate_return_comment (ValaGIRWriter* self, ValaDelegate* cb);
gchar* vala_gir_writer_get_signal_return_comment (ValaGIRWriter* self, ValaSignal* sig);
static gchar* vala_gir_writer_real_get_signal_return_comment (ValaGIRWriter* self, ValaSignal* sig);
gchar* vala_gir_writer_get_method_return_comment (ValaGIRWriter* self, ValaMethod* m);
static gchar* vala_gir_writer_real_get_method_return_comment (ValaGIRWriter* self, ValaMethod* m);
gchar* vala_gir_writer_get_signal_comment (ValaGIRWriter* self, ValaSignal* sig);
static gchar* vala_gir_writer_real_get_signal_comment (ValaGIRWriter* self, ValaSignal* sig);
gchar* vala_gir_writer_get_parameter_comment (ValaGIRWriter* self, ValaParameter* param);
static gchar* vala_gir_writer_real_get_parameter_comment (ValaGIRWriter* self, ValaParameter* param);
void vala_gir_writer_write_includes (ValaGIRWriter* self);
static void vala_gir_writer_write_indent_stream (ValaGIRWriter* self);
void vala_gir_writer_write_file (ValaGIRWriter* self, ValaCodeContext* context, const gchar* directory, const gchar* gir_filename, const gchar* gir_namespace, const gchar* gir_version, const gchar* package, const gchar* gir_shared_library);
static void vala_gir_writer_write_package (ValaGIRWriter* self, const gchar* package);
static void vala_gir_writer_write_doc (ValaGIRWriter* self, const gchar* comment);
static void vala_gir_writer_write_indent (ValaGIRWriter* self);
static void vala_gir_writer_write_c_includes (ValaGIRWriter* self, ValaNamespace* ns);
gchar* vala_ccode_base_module_get_ccode_header_filenames (ValaSymbol* sym);
static void vala_gir_writer_write_c_include (ValaGIRWriter* self, const gchar* name);
static void vala_gir_writer_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file);
static void vala_gir_writer_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns);
static gboolean vala_gir_writer_is_visibility (ValaGIRWriter* self, ValaSymbol* sym);
gchar* vala_ccode_base_module_get_ccode_prefix (ValaSymbol* sym);
static void vala_gir_writer_visit_deferred (ValaGIRWriter* self);
static void vala_gir_writer_write_symbol_attributes (ValaGIRWriter* self, ValaSymbol* symbol);
static gboolean vala_gir_writer_is_introspectable (ValaGIRWriter* self, ValaSymbol* sym);
static void vala_gir_writer_real_visit_class (ValaCodeVisitor* base, ValaClass* cl);
static gboolean vala_gir_writer_check_accessibility (ValaGIRWriter* self, ValaSymbol* sym);
static gchar* vala_gir_writer_get_gir_name (ValaGIRWriter* self, ValaSymbol* symbol);
static void vala_gir_writer_write_gtype_attributes (ValaGIRWriter* self, ValaTypeSymbol* symbol);
gchar* vala_ccode_base_module_get_ccode_ref_function (ValaTypeSymbol* sym);
gchar* vala_ccode_base_module_get_ccode_unref_function (ValaObjectTypeSymbol* sym);
gchar* vala_ccode_base_module_get_ccode_set_value_function (ValaCodeNode* sym);
gchar* vala_ccode_base_module_get_ccode_get_value_function (ValaCodeNode* sym);
static gchar* vala_gir_writer_gi_type_name (ValaGIRWriter* self, ValaTypeSymbol* type_symbol);
gchar* vala_ccode_base_module_get_ccode_name (ValaCodeNode* node);
static void vala_gir_writer_write_type_parameter (ValaGIRWriter* self, ValaTypeParameter* type_parameter, const gchar* tag_type);
static void vala_gir_writer_write_ctype_attributes (ValaGIRWriter* self, ValaTypeSymbol* symbol, const gchar* suffix);
static void vala_gir_writer_do_write_signature (ValaGIRWriter* self, ValaMethod* m, const gchar* tag_name, gboolean instance, const gchar* name, const gchar* cname, ValaList* params, ValaDataType* return_type, gboolean can_fail, gboolean write_comment);
gchar* vala_ccode_base_module_get_ccode_finish_name (ValaMethod* m);
gchar* vala_ccode_base_module_get_ccode_lower_case_name (ValaCodeNode* node, const gchar* infix);
static void vala_gir_writer_write_signature (ValaGIRWriter* self, ValaMethod* m, const gchar* tag_name, gboolean write_doc, gboolean instance);
static void vala_gir_writer_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st);
gboolean vala_ccode_base_module_get_ccode_has_type_id (ValaTypeSymbol* sym);
static void vala_gir_writer_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface);
static void vala_gir_writer_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en);
static void vala_gir_writer_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev);
static gchar* vala_gir_writer_literal_expression_to_value_string (ValaGIRWriter* self, ValaExpression* literal);
static void vala_gir_writer_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* edomain);
gchar* vala_ccode_base_module_get_quark_name (ValaErrorDomain* edomain);
static void vala_gir_writer_real_visit_error_code (ValaCodeVisitor* base, ValaErrorCode* ecode);
static void vala_gir_writer_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c);
static void vala_gir_writer_write_type (ValaGIRWriter* self, ValaDataType* type, gint index, ValaParameterDirection direction);
static void vala_gir_writer_real_visit_field (ValaCodeVisitor* base, ValaField* f);
gboolean vala_ccode_base_module_get_ccode_array_length (ValaCodeNode* node);
gchar* vala_ccode_base_module_get_ccode_delegate_target_name (ValaVariable* variable);
GType vala_ccode_base_module_get_type (void) G_GNUC_CONST;
gchar* vala_ccode_base_module_get_delegate_target_destroy_notify_cname (ValaCCodeBaseModule* self, const gchar* delegate_cname);
static void vala_gir_writer_write_implicit_params (ValaGIRWriter* self, ValaDataType* type, gint* index, gboolean has_array_length, const gchar* name, ValaParameterDirection direction);
static void vala_gir_writer_write_param_or_return (ValaGIRWriter* self, ValaDataType* type, gboolean is_parameter, gint* index, gboolean has_array_length, const gchar* name, const gchar* comment, ValaParameterDirection direction, gboolean constructor, gboolean caller_allocates, gboolean ellipsis);
static void vala_gir_writer_skip_implicit_params (ValaGIRWriter* self, ValaDataType* type, gint* index, gboolean has_array_length);
static void vala_gir_writer_write_params_and_return (ValaGIRWriter* self, ValaList* params, ValaList* type_params, ValaDataType* return_type, gboolean return_array_length, const gchar* return_comment, gboolean constructor, ValaDataType* instance_type, gboolean user_data);
static void vala_gir_writer_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* cb);
static void vala_gir_writer_real_visit_method (ValaCodeVisitor* base, ValaMethod* m);
static gboolean vala_gir_writer_is_type_introspectable (ValaGIRWriter* self, ValaDataType* type);
static gboolean vala_gir_writer_is_method_introspectable (ValaGIRWriter* self, ValaMethod* m);
gchar* vala_ccode_base_module_get_ccode_lower_case_prefix (ValaSymbol* sym);
ValaDataType* vala_ccode_base_module_get_data_type_for_symbol (ValaTypeSymbol* sym);
static void vala_gir_writer_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m);
static void vala_gir_writer_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop);
gboolean vala_ccode_base_module_is_gobject_property (ValaCCodeBaseModule* self, ValaProperty* prop);
static void vala_gir_writer_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig);
static gchar* vala_gir_writer_get_full_gir_name (ValaGIRWriter* self, ValaSymbol* sym);
static void vala_gir_writer_gir_namespace_init (ValaGIRWriterGIRNamespace *self, const gchar* ns, const gchar* version);
ValaGIRWriter* vala_gir_writer_new (void);
ValaGIRWriter* vala_gir_writer_construct (GType object_type);
static void vala_gir_writer_finalize (ValaCodeVisitor * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gchar* vala_gir_writer_real_get_interface_comment (ValaGIRWriter* self, ValaInterface* iface) {
	gchar* result = NULL;
	g_return_val_if_fail (iface != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_interface_comment (ValaGIRWriter* self, ValaInterface* iface) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_interface_comment (self, iface);
}


static gchar* vala_gir_writer_real_get_struct_comment (ValaGIRWriter* self, ValaStruct* st) {
	gchar* result = NULL;
	g_return_val_if_fail (st != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_struct_comment (ValaGIRWriter* self, ValaStruct* st) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_struct_comment (self, st);
}


static gchar* vala_gir_writer_real_get_enum_comment (ValaGIRWriter* self, ValaEnum* en) {
	gchar* result = NULL;
	g_return_val_if_fail (en != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_enum_comment (ValaGIRWriter* self, ValaEnum* en) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_enum_comment (self, en);
}


static gchar* vala_gir_writer_real_get_class_comment (ValaGIRWriter* self, ValaClass* c) {
	gchar* result = NULL;
	g_return_val_if_fail (c != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_class_comment (ValaGIRWriter* self, ValaClass* c) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_class_comment (self, c);
}


static gchar* vala_gir_writer_real_get_error_code_comment (ValaGIRWriter* self, ValaErrorCode* ecode) {
	gchar* result = NULL;
	g_return_val_if_fail (ecode != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_error_code_comment (ValaGIRWriter* self, ValaErrorCode* ecode) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_error_code_comment (self, ecode);
}


static gchar* vala_gir_writer_real_get_enum_value_comment (ValaGIRWriter* self, ValaEnumValue* ev) {
	gchar* result = NULL;
	g_return_val_if_fail (ev != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_enum_value_comment (ValaGIRWriter* self, ValaEnumValue* ev) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_enum_value_comment (self, ev);
}


static gchar* vala_gir_writer_real_get_constant_comment (ValaGIRWriter* self, ValaConstant* c) {
	gchar* result = NULL;
	g_return_val_if_fail (c != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_constant_comment (ValaGIRWriter* self, ValaConstant* c) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_constant_comment (self, c);
}


static gchar* vala_gir_writer_real_get_error_domain_comment (ValaGIRWriter* self, ValaErrorDomain* edomain) {
	gchar* result = NULL;
	g_return_val_if_fail (edomain != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_error_domain_comment (ValaGIRWriter* self, ValaErrorDomain* edomain) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_error_domain_comment (self, edomain);
}


static gchar* vala_gir_writer_real_get_field_comment (ValaGIRWriter* self, ValaField* f) {
	gchar* result = NULL;
	g_return_val_if_fail (f != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_field_comment (ValaGIRWriter* self, ValaField* f) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_field_comment (self, f);
}


static gchar* vala_gir_writer_real_get_delegate_comment (ValaGIRWriter* self, ValaDelegate* cb) {
	gchar* result = NULL;
	g_return_val_if_fail (cb != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_delegate_comment (ValaGIRWriter* self, ValaDelegate* cb) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_delegate_comment (self, cb);
}


static gchar* vala_gir_writer_real_get_method_comment (ValaGIRWriter* self, ValaMethod* m) {
	gchar* result = NULL;
	g_return_val_if_fail (m != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_method_comment (ValaGIRWriter* self, ValaMethod* m) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_method_comment (self, m);
}


static gchar* vala_gir_writer_real_get_property_comment (ValaGIRWriter* self, ValaProperty* prop) {
	gchar* result = NULL;
	g_return_val_if_fail (prop != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_property_comment (ValaGIRWriter* self, ValaProperty* prop) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_property_comment (self, prop);
}


static gchar* vala_gir_writer_real_get_delegate_return_comment (ValaGIRWriter* self, ValaDelegate* cb) {
	gchar* result = NULL;
	g_return_val_if_fail (cb != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_delegate_return_comment (ValaGIRWriter* self, ValaDelegate* cb) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_delegate_return_comment (self, cb);
}


static gchar* vala_gir_writer_real_get_signal_return_comment (ValaGIRWriter* self, ValaSignal* sig) {
	gchar* result = NULL;
	g_return_val_if_fail (sig != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_signal_return_comment (ValaGIRWriter* self, ValaSignal* sig) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_signal_return_comment (self, sig);
}


static gchar* vala_gir_writer_real_get_method_return_comment (ValaGIRWriter* self, ValaMethod* m) {
	gchar* result = NULL;
	g_return_val_if_fail (m != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_method_return_comment (ValaGIRWriter* self, ValaMethod* m) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_method_return_comment (self, m);
}


static gchar* vala_gir_writer_real_get_signal_comment (ValaGIRWriter* self, ValaSignal* sig) {
	gchar* result = NULL;
	g_return_val_if_fail (sig != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_signal_comment (ValaGIRWriter* self, ValaSignal* sig) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_signal_comment (self, sig);
}


static gchar* vala_gir_writer_real_get_parameter_comment (ValaGIRWriter* self, ValaParameter* param) {
	gchar* result = NULL;
	g_return_val_if_fail (param != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_parameter_comment (ValaGIRWriter* self, ValaParameter* param) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_parameter_comment (self, param);
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


void vala_gir_writer_write_includes (ValaGIRWriter* self) {
	g_return_if_fail (self != NULL);
	{
		ValaArrayList* _i_list = NULL;
		ValaArrayList* _tmp0_;
		ValaArrayList* _tmp1_;
		gint _i_size = 0;
		ValaArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _i_index = 0;
		_tmp0_ = self->priv->externals;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_i_list = _tmp1_;
		_tmp2_ = _i_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_i_size = _tmp4_;
		_i_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaGIRWriterGIRNamespace* i = NULL;
			ValaArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaGIRWriterGIRNamespace* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			_tmp5_ = _i_index;
			_i_index = _tmp5_ + 1;
			_tmp6_ = _i_index;
			_tmp7_ = _i_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _i_list;
			_tmp9_ = _i_index;
			_tmp10_ = vala_list_get ((ValaList*) _tmp8_, _tmp9_);
			i = (ValaGIRWriterGIRNamespace*) _tmp10_;
			_tmp11_ = i;
			_tmp12_ = (*_tmp11_).ns;
			_tmp13_ = self->priv->gir_namespace;
			if (g_strcmp0 (_tmp12_, _tmp13_) != 0) {
				FILE* _tmp14_;
				ValaGIRWriterGIRNamespace* _tmp15_;
				const gchar* _tmp16_;
				ValaGIRWriterGIRNamespace* _tmp17_;
				const gchar* _tmp18_;
				vala_gir_writer_write_indent_stream (self);
				_tmp14_ = self->priv->stream;
				_tmp15_ = i;
				_tmp16_ = (*_tmp15_).ns;
				_tmp17_ = i;
				_tmp18_ = (*_tmp17_).version;
				fprintf (_tmp14_, "<include name=\"%s\" version=\"%s\"/>\n", _tmp16_, _tmp18_);
			}
			_vala_gir_writer_gir_namespace_free0 (i);
		}
		_vala_iterable_unref0 (_i_list);
	}
}


/**
 * Writes the public interface of the specified code context into the
 * specified file.
 *
 * @param context      a code context
 * @param gir_filename a relative or absolute filename
 */
static gpointer _vala_code_context_ref0 (gpointer self) {
	return self ? vala_code_context_ref (self) : NULL;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_gir_writer_write_file (ValaGIRWriter* self, ValaCodeContext* context, const gchar* directory, const gchar* gir_filename, const gchar* gir_namespace, const gchar* gir_version, const gchar* package, const gchar* gir_shared_library) {
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	ValaNamespace* root_symbol = NULL;
	ValaCodeContext* _tmp10_;
	ValaNamespace* _tmp11_;
	ValaNamespace* _tmp12_;
	ValaNamespace* _tmp13_;
	ValaSymbol* glib_ns = NULL;
	ValaNamespace* _tmp14_;
	ValaScope* _tmp15_;
	ValaScope* _tmp16_;
	ValaSymbol* _tmp17_;
	ValaSymbol* _tmp18_;
	ValaScope* _tmp19_;
	ValaScope* _tmp20_;
	ValaSymbol* _tmp21_;
	ValaSymbol* _tmp22_;
	ValaScope* _tmp23_;
	ValaScope* _tmp24_;
	ValaSymbol* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaScope* _tmp27_;
	ValaScope* _tmp28_;
	ValaSymbol* _tmp29_;
	ValaSymbol* _tmp30_;
	ValaScope* _tmp31_;
	ValaScope* _tmp32_;
	ValaSymbol* _tmp33_;
	ValaSymbol* _tmp34_;
	ValaScope* _tmp35_;
	ValaScope* _tmp36_;
	ValaSymbol* _tmp37_;
	const gchar* _tmp38_;
	ValaCodeContext* _tmp51_;
	gint _tmp52_;
	GString* _tmp53_;
	gchar* filename = NULL;
	const gchar* _tmp54_;
	const gchar* _tmp55_;
	gchar* _tmp56_;
	gboolean file_exists = FALSE;
	const gchar* _tmp57_;
	gboolean _tmp58_;
	gchar* temp_filename = NULL;
	const gchar* _tmp59_;
	gchar* _tmp60_;
	gboolean _tmp61_;
	FILE* _tmp66_;
	FILE* _tmp70_;
	gchar* _tmp71_ = NULL;
	ValaCodeContext* _tmp72_;
	gboolean _tmp73_;
	gboolean _tmp74_;
	gchar* header = NULL;
	gchar* _tmp85_;
	FILE* _tmp86_;
	const gchar* _tmp87_;
	FILE* _tmp88_;
	FILE* _tmp89_;
	FILE* _tmp90_;
	FILE* _tmp91_;
	FILE* _tmp92_;
	gint _tmp93_;
	gint _tmp94_;
	FILE* _tmp95_;
	GString* _tmp96_;
	const gchar* _tmp97_;
	gboolean _tmp98_;
	ValaHashSet* _tmp153_;
	gint _tmp154_;
	gint _tmp155_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (directory != NULL);
	g_return_if_fail (gir_filename != NULL);
	g_return_if_fail (gir_namespace != NULL);
	g_return_if_fail (gir_version != NULL);
	g_return_if_fail (package != NULL);
	_tmp0_ = context;
	_tmp1_ = _vala_code_context_ref0 (_tmp0_);
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp1_;
	_tmp2_ = directory;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->directory);
	self->priv->directory = _tmp3_;
	_tmp4_ = gir_namespace;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (self->priv->gir_namespace);
	self->priv->gir_namespace = _tmp5_;
	_tmp6_ = gir_version;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 (self->priv->gir_version);
	self->priv->gir_version = _tmp7_;
	_tmp8_ = gir_shared_library;
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 (self->priv->gir_shared_library);
	self->priv->gir_shared_library = _tmp9_;
	_tmp10_ = context;
	_tmp11_ = vala_code_context_get_root (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	root_symbol = _tmp13_;
	_tmp14_ = root_symbol;
	_tmp15_ = vala_symbol_get_scope ((ValaSymbol*) _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = vala_scope_lookup (_tmp16_, "GLib");
	glib_ns = _tmp17_;
	_tmp18_ = glib_ns;
	_tmp19_ = vala_symbol_get_scope (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = vala_scope_lookup (_tmp20_, "Object");
	_vala_code_node_unref0 (self->priv->gobject_type);
	self->priv->gobject_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
	_tmp22_ = glib_ns;
	_tmp23_ = vala_symbol_get_scope (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = vala_scope_lookup (_tmp24_, "InitiallyUnowned");
	_vala_code_node_unref0 (self->priv->ginitiallyunowned_type);
	self->priv->ginitiallyunowned_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
	_tmp26_ = glib_ns;
	_tmp27_ = vala_symbol_get_scope (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = vala_scope_lookup (_tmp28_, "TypeInterface");
	_vala_code_node_unref0 (self->priv->gtypeinterface_type);
	self->priv->gtypeinterface_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
	_tmp30_ = glib_ns;
	_tmp31_ = vala_symbol_get_scope (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = vala_scope_lookup (_tmp32_, "TypeInstance");
	_vala_code_node_unref0 (self->priv->gtypeinstance_type);
	self->priv->gtypeinstance_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
	_tmp34_ = glib_ns;
	_tmp35_ = vala_symbol_get_scope (_tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = vala_scope_lookup (_tmp36_, "Type");
	_vala_code_node_unref0 (self->priv->gtype_type);
	self->priv->gtype_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
	_tmp38_ = package;
	vala_gir_writer_write_package (self, _tmp38_);
	{
		ValaList* _file_list = NULL;
		ValaCodeContext* _tmp39_;
		ValaList* _tmp40_;
		gint _file_size = 0;
		ValaList* _tmp41_;
		gint _tmp42_;
		gint _tmp43_;
		gint _file_index = 0;
		_tmp39_ = context;
		_tmp40_ = vala_code_context_get_source_files (_tmp39_);
		_file_list = _tmp40_;
		_tmp41_ = _file_list;
		_tmp42_ = vala_collection_get_size ((ValaCollection*) _tmp41_);
		_tmp43_ = _tmp42_;
		_file_size = _tmp43_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp44_;
			gint _tmp45_;
			gint _tmp46_;
			ValaSourceFile* file = NULL;
			ValaList* _tmp47_;
			gint _tmp48_;
			gpointer _tmp49_;
			ValaSourceFile* _tmp50_;
			_tmp44_ = _file_index;
			_file_index = _tmp44_ + 1;
			_tmp45_ = _file_index;
			_tmp46_ = _file_size;
			if (!(_tmp45_ < _tmp46_)) {
				break;
			}
			_tmp47_ = _file_list;
			_tmp48_ = _file_index;
			_tmp49_ = vala_list_get (_tmp47_, _tmp48_);
			file = (ValaSourceFile*) _tmp49_;
			_tmp50_ = file;
			vala_source_file_accept (_tmp50_, (ValaCodeVisitor*) self);
			_vala_source_file_unref0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_tmp51_ = context;
	vala_code_context_accept (_tmp51_, (ValaCodeVisitor*) self);
	_tmp52_ = self->priv->indent;
	self->priv->indent = _tmp52_ - 1;
	_tmp53_ = self->priv->buffer;
	g_string_append_printf (_tmp53_, "</repository>\n");
	_tmp54_ = directory;
	_tmp55_ = gir_filename;
	_tmp56_ = g_strdup_printf ("%s%c%s", _tmp54_, (gint) G_DIR_SEPARATOR, _tmp55_);
	filename = _tmp56_;
	_tmp57_ = filename;
	_tmp58_ = g_file_test (_tmp57_, G_FILE_TEST_EXISTS);
	file_exists = _tmp58_;
	_tmp59_ = filename;
	_tmp60_ = g_strdup_printf ("%s.valatmp", _tmp59_);
	temp_filename = _tmp60_;
	_tmp61_ = file_exists;
	if (_tmp61_) {
		const gchar* _tmp62_;
		FILE* _tmp63_;
		_tmp62_ = temp_filename;
		_tmp63_ = g_fopen (_tmp62_, "w");
		_fclose0 (self->priv->stream);
		self->priv->stream = _tmp63_;
	} else {
		const gchar* _tmp64_;
		FILE* _tmp65_;
		_tmp64_ = filename;
		_tmp65_ = g_fopen (_tmp64_, "w");
		_fclose0 (self->priv->stream);
		self->priv->stream = _tmp65_;
	}
	_tmp66_ = self->priv->stream;
	if (_tmp66_ == NULL) {
		const gchar* _tmp67_;
		gchar* _tmp68_;
		gchar* _tmp69_;
		_tmp67_ = filename;
		_tmp68_ = g_strdup_printf ("unable to open `%s' for writing", _tmp67_);
		_tmp69_ = _tmp68_;
		vala_report_error (NULL, _tmp69_);
		_g_free0 (_tmp69_);
		_g_free0 (temp_filename);
		_g_free0 (filename);
		_vala_code_node_unref0 (glib_ns);
		_vala_code_node_unref0 (root_symbol);
		return;
	}
	_tmp70_ = self->priv->stream;
	fprintf (_tmp70_, "<?xml version=\"1.0\"?>\n");
	_tmp72_ = context;
	_tmp73_ = vala_code_context_get_version_header (_tmp72_);
	_tmp74_ = _tmp73_;
	if (_tmp74_) {
		const gchar* _tmp75_;
		gchar* _tmp76_;
		gchar* _tmp77_;
		const gchar* _tmp78_;
		gchar* _tmp79_;
		_tmp75_ = filename;
		_tmp76_ = g_path_get_basename (_tmp75_);
		_tmp77_ = _tmp76_;
		_tmp78_ = g_get_prgname ();
		_tmp79_ = g_strdup_printf ("<!-- %s generated by %s %s, do not modify. -->", _tmp77_, _tmp78_, BUILD_VERSION);
		_g_free0 (_tmp71_);
		_tmp71_ = _tmp79_;
		_g_free0 (_tmp77_);
	} else {
		const gchar* _tmp80_;
		gchar* _tmp81_;
		gchar* _tmp82_;
		const gchar* _tmp83_;
		gchar* _tmp84_;
		_tmp80_ = filename;
		_tmp81_ = g_path_get_basename (_tmp80_);
		_tmp82_ = _tmp81_;
		_tmp83_ = g_get_prgname ();
		_tmp84_ = g_strdup_printf ("<!-- %s generated by %s, do not modify. -->", _tmp82_, _tmp83_);
		_g_free0 (_tmp71_);
		_tmp71_ = _tmp84_;
		_g_free0 (_tmp82_);
	}
	_tmp85_ = g_strdup (_tmp71_);
	header = _tmp85_;
	_tmp86_ = self->priv->stream;
	_tmp87_ = header;
	fprintf (_tmp86_, "%s\n", _tmp87_);
	_tmp88_ = self->priv->stream;
	fprintf (_tmp88_, "<repository version=\"1.2\"");
	_tmp89_ = self->priv->stream;
	fprintf (_tmp89_, " xmlns=\"http://www.gtk.org/introspection/core/1.0\"");
	_tmp90_ = self->priv->stream;
	fprintf (_tmp90_, " xmlns:c=\"http://www.gtk.org/introspection/c/1.0\"");
	_tmp91_ = self->priv->stream;
	fprintf (_tmp91_, " xmlns:glib=\"http://www.gtk.org/introspection/glib/1.0\"");
	_tmp92_ = self->priv->stream;
	fprintf (_tmp92_, ">\n");
	_tmp93_ = self->priv->indent;
	self->priv->indent = _tmp93_ + 1;
	vala_gir_writer_write_includes (self);
	_tmp94_ = self->priv->indent;
	self->priv->indent = _tmp94_ - 1;
	_tmp95_ = self->priv->stream;
	_tmp96_ = self->priv->buffer;
	_tmp97_ = _tmp96_->str;
	fputs (_tmp97_, _tmp95_);
	_fclose0 (self->priv->stream);
	self->priv->stream = NULL;
	_tmp98_ = file_exists;
	if (_tmp98_) {
		gboolean changed = FALSE;
		gboolean _tmp114_;
		changed = TRUE;
		{
			GMappedFile* old_file = NULL;
			const gchar* _tmp99_;
			GMappedFile* _tmp100_;
			GMappedFile* new_file = NULL;
			const gchar* _tmp101_;
			GMappedFile* _tmp102_;
			gsize len = 0UL;
			GMappedFile* _tmp103_;
			gsize _tmp104_;
			gsize _tmp105_;
			GMappedFile* _tmp106_;
			gsize _tmp107_;
			_tmp99_ = filename;
			_tmp100_ = g_mapped_file_new (_tmp99_, FALSE, &_inner_error0_);
			old_file = _tmp100_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch5_g_file_error;
				}
				_g_free0 (header);
				_g_free0 (_tmp71_);
				_g_free0 (temp_filename);
				_g_free0 (filename);
				_vala_code_node_unref0 (glib_ns);
				_vala_code_node_unref0 (root_symbol);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp101_ = temp_filename;
			_tmp102_ = g_mapped_file_new (_tmp101_, FALSE, &_inner_error0_);
			new_file = _tmp102_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_mapped_file_unref0 (old_file);
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch5_g_file_error;
				}
				_g_mapped_file_unref0 (old_file);
				_g_free0 (header);
				_g_free0 (_tmp71_);
				_g_free0 (temp_filename);
				_g_free0 (filename);
				_vala_code_node_unref0 (glib_ns);
				_vala_code_node_unref0 (root_symbol);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp103_ = old_file;
			_tmp104_ = g_mapped_file_get_length (_tmp103_);
			len = _tmp104_;
			_tmp105_ = len;
			_tmp106_ = new_file;
			_tmp107_ = g_mapped_file_get_length (_tmp106_);
			if (_tmp105_ == _tmp107_) {
				GMappedFile* _tmp108_;
				gchar* _tmp109_;
				GMappedFile* _tmp110_;
				gchar* _tmp111_;
				gsize _tmp112_;
				gint _tmp113_;
				_tmp108_ = old_file;
				_tmp109_ = g_mapped_file_get_contents (_tmp108_);
				_tmp110_ = new_file;
				_tmp111_ = g_mapped_file_get_contents (_tmp110_);
				_tmp112_ = len;
				_tmp113_ = memcmp (_tmp109_, _tmp111_, _tmp112_);
				if (_tmp113_ == 0) {
					changed = FALSE;
				}
			}
			_g_mapped_file_unref0 (old_file);
			old_file = NULL;
			_g_mapped_file_unref0 (new_file);
			new_file = NULL;
			_g_mapped_file_unref0 (new_file);
			_g_mapped_file_unref0 (old_file);
		}
		goto __finally5;
		__catch5_g_file_error:
		{
			GError* e = NULL;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_g_error_free0 (e);
		}
		__finally5:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (header);
			_g_free0 (_tmp71_);
			_g_free0 (temp_filename);
			_g_free0 (filename);
			_vala_code_node_unref0 (glib_ns);
			_vala_code_node_unref0 (root_symbol);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp114_ = changed;
		if (_tmp114_) {
			const gchar* _tmp115_;
			const gchar* _tmp116_;
			_tmp115_ = temp_filename;
			_tmp116_ = filename;
			g_rename (_tmp115_, _tmp116_);
		} else {
			const gchar* _tmp117_;
			_tmp117_ = temp_filename;
			g_unlink (_tmp117_);
		}
	}
	{
		ValaIterator* _ns_it = NULL;
		ValaHashSet* _tmp118_;
		ValaIterator* _tmp119_;
		_tmp118_ = self->priv->unannotated_namespaces;
		_tmp119_ = vala_iterable_iterator ((ValaIterable*) _tmp118_);
		_ns_it = _tmp119_;
		while (TRUE) {
			ValaIterator* _tmp120_;
			gboolean _tmp121_;
			ValaNamespace* ns = NULL;
			ValaIterator* _tmp122_;
			gpointer _tmp123_;
			ValaHashSet* _tmp124_;
			ValaNamespace* _tmp125_;
			gboolean _tmp126_;
			_tmp120_ = _ns_it;
			_tmp121_ = vala_iterator_next (_tmp120_);
			if (!_tmp121_) {
				break;
			}
			_tmp122_ = _ns_it;
			_tmp123_ = vala_iterator_get (_tmp122_);
			ns = (ValaNamespace*) _tmp123_;
			_tmp124_ = self->priv->our_namespaces;
			_tmp125_ = ns;
			_tmp126_ = vala_collection_contains ((ValaCollection*) _tmp124_, _tmp125_);
			if (!_tmp126_) {
				ValaNamespace* _tmp127_;
				ValaSourceReference* _tmp128_;
				ValaSourceReference* _tmp129_;
				ValaNamespace* _tmp130_;
				const gchar* _tmp131_;
				const gchar* _tmp132_;
				gchar* _tmp133_;
				gchar* _tmp134_;
				_tmp127_ = ns;
				_tmp128_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp127_);
				_tmp129_ = _tmp128_;
				_tmp130_ = ns;
				_tmp131_ = vala_symbol_get_name ((ValaSymbol*) _tmp130_);
				_tmp132_ = _tmp131_;
				_tmp133_ = g_strdup_printf ("Namespace %s does not have a GIR namespace and version annotation", _tmp132_);
				_tmp134_ = _tmp133_;
				vala_report_warning (_tmp129_, _tmp134_);
				_g_free0 (_tmp134_);
			}
			_vala_code_node_unref0 (ns);
		}
		_vala_iterator_unref0 (_ns_it);
	}
	{
		ValaIterator* _ns_it = NULL;
		ValaHashSet* _tmp135_;
		ValaIterator* _tmp136_;
		_tmp135_ = self->priv->our_namespaces;
		_tmp136_ = vala_iterable_iterator ((ValaIterable*) _tmp135_);
		_ns_it = _tmp136_;
		while (TRUE) {
			ValaIterator* _tmp137_;
			gboolean _tmp138_;
			ValaNamespace* ns = NULL;
			ValaIterator* _tmp139_;
			gpointer _tmp140_;
			ValaNamespace* _tmp141_;
			ValaSourceReference* _tmp142_;
			ValaSourceReference* _tmp143_;
			ValaSourceFile* _tmp144_;
			ValaSourceFile* _tmp145_;
			const gchar* _tmp146_;
			ValaNamespace* _tmp147_;
			ValaSourceReference* _tmp148_;
			ValaSourceReference* _tmp149_;
			ValaSourceFile* _tmp150_;
			ValaSourceFile* _tmp151_;
			const gchar* _tmp152_;
			_tmp137_ = _ns_it;
			_tmp138_ = vala_iterator_next (_tmp137_);
			if (!_tmp138_) {
				break;
			}
			_tmp139_ = _ns_it;
			_tmp140_ = vala_iterator_get (_tmp139_);
			ns = (ValaNamespace*) _tmp140_;
			_tmp141_ = ns;
			_tmp142_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp141_);
			_tmp143_ = _tmp142_;
			_tmp144_ = vala_source_reference_get_file (_tmp143_);
			_tmp145_ = _tmp144_;
			_tmp146_ = gir_namespace;
			vala_source_file_set_gir_namespace (_tmp145_, _tmp146_);
			_tmp147_ = ns;
			_tmp148_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp147_);
			_tmp149_ = _tmp148_;
			_tmp150_ = vala_source_reference_get_file (_tmp149_);
			_tmp151_ = _tmp150_;
			_tmp152_ = gir_version;
			vala_source_file_set_gir_version (_tmp151_, _tmp152_);
			_vala_code_node_unref0 (ns);
		}
		_vala_iterator_unref0 (_ns_it);
	}
	_tmp153_ = self->priv->our_namespaces;
	_tmp154_ = vala_collection_get_size ((ValaCollection*) _tmp153_);
	_tmp155_ = _tmp154_;
	if (_tmp155_ == 0) {
		vala_report_error (NULL, "No suitable namespace found to export for GIR");
	}
	_g_free0 (header);
	_g_free0 (_tmp71_);
	_g_free0 (temp_filename);
	_g_free0 (filename);
	_vala_code_node_unref0 (glib_ns);
	_vala_code_node_unref0 (root_symbol);
}


static void vala_gir_writer_write_doc (ValaGIRWriter* self, const gchar* comment) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = comment;
	if (_tmp0_ != NULL) {
		GString* _tmp1_;
		GString* _tmp2_;
		const gchar* _tmp3_;
		GString* _tmp4_;
		vala_gir_writer_write_indent (self);
		_tmp1_ = self->priv->buffer;
		g_string_append (_tmp1_, "<doc xml:whitespace=\"preserve\">");
		_tmp2_ = self->priv->buffer;
		_tmp3_ = comment;
		g_string_append (_tmp2_, _tmp3_);
		_tmp4_ = self->priv->buffer;
		g_string_append (_tmp4_, "</doc>\n");
	}
}


static void vala_gir_writer_write_package (ValaGIRWriter* self, const gchar* package) {
	GString* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (package != NULL);
	vala_gir_writer_write_indent (self);
	_tmp0_ = self->priv->buffer;
	_tmp1_ = package;
	g_string_append_printf (_tmp0_, "<package name=\"%s\"/>\n", _tmp1_);
}


static void vala_gir_writer_write_c_includes (ValaGIRWriter* self, ValaNamespace* ns) {
	ValaSet* header_filenames = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	ValaHashSet* _tmp2_;
	ValaNamespace* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp0_, _tmp1_);
	header_filenames = (ValaSet*) _tmp2_;
	_tmp3_ = ns;
	_tmp4_ = vala_ccode_base_module_get_ccode_header_filenames ((ValaSymbol*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, ",", 0);
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _vala_array_length (_tmp6_);
	_g_free0 (_tmp5_);
	{
		gchar** c_header_filename_collection = NULL;
		gint c_header_filename_collection_length1 = 0;
		gint _c_header_filename_collection_size_ = 0;
		gint c_header_filename_it = 0;
		c_header_filename_collection = _tmp8_;
		c_header_filename_collection_length1 = _tmp8__length1;
		for (c_header_filename_it = 0; c_header_filename_it < c_header_filename_collection_length1; c_header_filename_it = c_header_filename_it + 1) {
			const gchar* c_header_filename = NULL;
			c_header_filename = c_header_filename_collection[c_header_filename_it];
			{
				ValaSet* _tmp9_;
				const gchar* _tmp10_;
				_tmp9_ = header_filenames;
				_tmp10_ = c_header_filename;
				vala_collection_add ((ValaCollection*) _tmp9_, _tmp10_);
			}
		}
		c_header_filename_collection = (_vala_array_free (c_header_filename_collection, c_header_filename_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	{
		ValaIterator* _symbol_it = NULL;
		ValaNamespace* _tmp11_;
		ValaScope* _tmp12_;
		ValaScope* _tmp13_;
		ValaMap* _tmp14_;
		ValaMap* _tmp15_;
		ValaCollection* _tmp16_;
		ValaCollection* _tmp17_;
		ValaIterator* _tmp18_;
		ValaIterator* _tmp19_;
		_tmp11_ = ns;
		_tmp12_ = vala_symbol_get_scope ((ValaSymbol*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_scope_get_symbol_table (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_map_get_values (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_iterable_iterator ((ValaIterable*) _tmp17_);
		_tmp19_ = _tmp18_;
		_vala_iterable_unref0 (_tmp17_);
		_vala_map_unref0 (_tmp15_);
		_symbol_it = _tmp19_;
		while (TRUE) {
			ValaIterator* _tmp20_;
			gboolean _tmp21_;
			ValaSymbol* symbol = NULL;
			ValaIterator* _tmp22_;
			gpointer _tmp23_;
			ValaSymbol* _tmp24_;
			gboolean _tmp25_;
			gboolean _tmp26_;
			ValaSymbol* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar** _tmp30_;
			gchar** _tmp31_;
			gchar** _tmp32_;
			gint _tmp32__length1;
			_tmp20_ = _symbol_it;
			_tmp21_ = vala_iterator_next (_tmp20_);
			if (!_tmp21_) {
				break;
			}
			_tmp22_ = _symbol_it;
			_tmp23_ = vala_iterator_get (_tmp22_);
			symbol = (ValaSymbol*) _tmp23_;
			_tmp24_ = symbol;
			_tmp25_ = vala_symbol_get_external_package (_tmp24_);
			_tmp26_ = _tmp25_;
			if (_tmp26_) {
				_vala_code_node_unref0 (symbol);
				continue;
			}
			_tmp27_ = symbol;
			_tmp28_ = vala_ccode_base_module_get_ccode_header_filenames (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp31_ = _tmp30_ = g_strsplit (_tmp29_, ",", 0);
			_tmp32_ = _tmp31_;
			_tmp32__length1 = _vala_array_length (_tmp30_);
			_g_free0 (_tmp29_);
			{
				gchar** c_header_filename_collection = NULL;
				gint c_header_filename_collection_length1 = 0;
				gint _c_header_filename_collection_size_ = 0;
				gint c_header_filename_it = 0;
				c_header_filename_collection = _tmp32_;
				c_header_filename_collection_length1 = _tmp32__length1;
				for (c_header_filename_it = 0; c_header_filename_it < c_header_filename_collection_length1; c_header_filename_it = c_header_filename_it + 1) {
					const gchar* c_header_filename = NULL;
					c_header_filename = c_header_filename_collection[c_header_filename_it];
					{
						ValaSet* _tmp33_;
						const gchar* _tmp34_;
						_tmp33_ = header_filenames;
						_tmp34_ = c_header_filename;
						vala_collection_add ((ValaCollection*) _tmp33_, _tmp34_);
					}
				}
				c_header_filename_collection = (_vala_array_free (c_header_filename_collection, c_header_filename_collection_length1, (GDestroyNotify) g_free), NULL);
			}
			_vala_code_node_unref0 (symbol);
		}
		_vala_iterator_unref0 (_symbol_it);
	}
	{
		ValaIterator* _c_header_filename_it = NULL;
		ValaSet* _tmp35_;
		ValaIterator* _tmp36_;
		_tmp35_ = header_filenames;
		_tmp36_ = vala_iterable_iterator ((ValaIterable*) _tmp35_);
		_c_header_filename_it = _tmp36_;
		while (TRUE) {
			ValaIterator* _tmp37_;
			gboolean _tmp38_;
			gchar* c_header_filename = NULL;
			ValaIterator* _tmp39_;
			gpointer _tmp40_;
			const gchar* _tmp41_;
			_tmp37_ = _c_header_filename_it;
			_tmp38_ = vala_iterator_next (_tmp37_);
			if (!_tmp38_) {
				break;
			}
			_tmp39_ = _c_header_filename_it;
			_tmp40_ = vala_iterator_get (_tmp39_);
			c_header_filename = (gchar*) _tmp40_;
			_tmp41_ = c_header_filename;
			vala_gir_writer_write_c_include (self, _tmp41_);
			_g_free0 (c_header_filename);
		}
		_vala_iterator_unref0 (_c_header_filename_it);
	}
	_vala_iterable_unref0 (header_filenames);
}


static void vala_gir_writer_write_c_include (ValaGIRWriter* self, const gchar* name) {
	GString* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	vala_gir_writer_write_indent (self);
	_tmp0_ = self->priv->buffer;
	_tmp1_ = name;
	g_string_append_printf (_tmp0_, "<c:include name=\"%s\"/>\n", _tmp1_);
}


static void vala_gir_writer_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file) {
	ValaGIRWriter * self;
	ValaSourceFile* _tmp0_;
	ValaSourceFileType _tmp1_;
	ValaSourceFileType _tmp2_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (source_file != NULL);
	_tmp0_ = source_file;
	_tmp1_ = vala_source_file_get_file_type (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != VALA_SOURCE_FILE_TYPE_PACKAGE) {
		return;
	}
	{
		ValaList* _node_list = NULL;
		ValaSourceFile* _tmp3_;
		ValaList* _tmp4_;
		gint _node_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _node_index = 0;
		_tmp3_ = source_file;
		_tmp4_ = vala_source_file_get_nodes (_tmp3_);
		_node_list = _tmp4_;
		_tmp5_ = _node_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_node_size = _tmp7_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			ValaCodeNode* node = NULL;
			ValaList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			gboolean _tmp14_ = FALSE;
			ValaCodeNode* _tmp15_;
			_tmp8_ = _node_index;
			_node_index = _tmp8_ + 1;
			_tmp9_ = _node_index;
			_tmp10_ = _node_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _node_list;
			_tmp12_ = _node_index;
			_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
			node = (ValaCodeNode*) _tmp13_;
			_tmp15_ = node;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, VALA_TYPE_NAMESPACE)) {
				ValaCodeNode* _tmp16_;
				ValaSymbol* _tmp17_;
				ValaSymbol* _tmp18_;
				ValaCodeContext* _tmp19_;
				ValaNamespace* _tmp20_;
				ValaNamespace* _tmp21_;
				_tmp16_ = node;
				_tmp17_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALA_TYPE_NAMESPACE, ValaNamespace));
				_tmp18_ = _tmp17_;
				_tmp19_ = self->priv->context;
				_tmp20_ = vala_code_context_get_root (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp14_ = _tmp18_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_SYMBOL, ValaSymbol);
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				ValaAttribute* a = NULL;
				ValaCodeNode* _tmp22_;
				ValaAttribute* _tmp23_;
				gboolean _tmp24_ = FALSE;
				ValaAttribute* _tmp25_;
				gboolean _tmp32_ = FALSE;
				ValaAttribute* _tmp33_;
				_tmp22_ = node;
				_tmp23_ = vala_code_node_get_attribute (_tmp22_, "CCode");
				a = _tmp23_;
				_tmp25_ = a;
				if (_tmp25_ != NULL) {
					ValaAttribute* _tmp26_;
					gboolean _tmp27_;
					_tmp26_ = a;
					_tmp27_ = vala_attribute_has_argument (_tmp26_, "gir_namespace");
					_tmp24_ = _tmp27_;
				} else {
					_tmp24_ = FALSE;
				}
				if (_tmp24_) {
					ValaSourceFile* _tmp28_;
					ValaAttribute* _tmp29_;
					gchar* _tmp30_;
					gchar* _tmp31_;
					_tmp28_ = source_file;
					_tmp29_ = a;
					_tmp30_ = vala_attribute_get_string (_tmp29_, "gir_namespace", NULL);
					_tmp31_ = _tmp30_;
					vala_source_file_set_gir_namespace (_tmp28_, _tmp31_);
					_g_free0 (_tmp31_);
				}
				_tmp33_ = a;
				if (_tmp33_ != NULL) {
					ValaAttribute* _tmp34_;
					gboolean _tmp35_;
					_tmp34_ = a;
					_tmp35_ = vala_attribute_has_argument (_tmp34_, "gir_version");
					_tmp32_ = _tmp35_;
				} else {
					_tmp32_ = FALSE;
				}
				if (_tmp32_) {
					ValaSourceFile* _tmp36_;
					ValaAttribute* _tmp37_;
					gchar* _tmp38_;
					gchar* _tmp39_;
					_tmp36_ = source_file;
					_tmp37_ = a;
					_tmp38_ = vala_attribute_get_string (_tmp37_, "gir_version", NULL);
					_tmp39_ = _tmp38_;
					vala_source_file_set_gir_version (_tmp36_, _tmp39_);
					_g_free0 (_tmp39_);
				}
				_vala_code_node_unref0 (a);
				_vala_code_node_unref0 (node);
				break;
			}
			_vala_code_node_unref0 (node);
		}
		_vala_iterable_unref0 (_node_list);
	}
}


static void vala_gir_writer_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns) {
	ValaGIRWriter * self;
	ValaNamespace* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaNamespace* _tmp3_;
	gboolean _tmp4_;
	ValaNamespace* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	ValaNamespace* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSymbol* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	ValaNamespace* _tmp18_;
	GString* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* cprefix = NULL;
	ValaNamespace* _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp27_;
	GString* _tmp30_;
	gint _tmp31_;
	ValaArrayList* _tmp32_;
	ValaNamespace* _tmp33_;
	ValaNamespace* _tmp34_;
	ValaArrayList* _tmp35_;
	gint _tmp36_;
	GString* _tmp37_;
	ValaHashSet* _tmp38_;
	ValaNamespace* _tmp39_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (ns != NULL);
	_tmp0_ = ns;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = ns;
	_tmp4_ = vala_gir_writer_is_visibility (self, (ValaSymbol*) _tmp3_);
	if (!_tmp4_) {
		return;
	}
	_tmp5_ = ns;
	_tmp6_ = vala_symbol_get_name ((ValaSymbol*) _tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == NULL) {
		ValaArrayList* _tmp8_;
		ValaNamespace* _tmp9_;
		ValaNamespace* _tmp10_;
		ValaArrayList* _tmp11_;
		_tmp8_ = self->priv->hierarchy;
		_tmp9_ = ns;
		vala_list_insert ((ValaList*) _tmp8_, 0, (ValaSymbol*) _tmp9_);
		_tmp10_ = ns;
		vala_code_node_accept_children ((ValaCodeNode*) _tmp10_, (ValaCodeVisitor*) self);
		_tmp11_ = self->priv->hierarchy;
		vala_list_remove_at ((ValaList*) _tmp11_, 0);
		return;
	}
	_tmp12_ = ns;
	_tmp13_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_symbol_get_name (_tmp14_);
	_tmp16_ = _tmp15_;
	if (_tmp16_ != NULL) {
		ValaNamespace* _tmp17_;
		_tmp17_ = ns;
		vala_code_node_accept_children ((ValaCodeNode*) _tmp17_, (ValaCodeVisitor*) self);
		return;
	}
	_tmp18_ = ns;
	vala_gir_writer_write_c_includes (self, _tmp18_);
	vala_gir_writer_write_indent (self);
	_tmp19_ = self->priv->buffer;
	_tmp20_ = self->priv->gir_namespace;
	_tmp21_ = self->priv->gir_version;
	g_string_append_printf (_tmp19_, "<namespace name=\"%s\" version=\"%s\"", _tmp20_, _tmp21_);
	_tmp22_ = ns;
	_tmp23_ = vala_ccode_base_module_get_ccode_prefix ((ValaSymbol*) _tmp22_);
	cprefix = _tmp23_;
	_tmp24_ = self->priv->gir_shared_library;
	if (_tmp24_ != NULL) {
		GString* _tmp25_;
		const gchar* _tmp26_;
		_tmp25_ = self->priv->buffer;
		_tmp26_ = self->priv->gir_shared_library;
		g_string_append_printf (_tmp25_, " shared-library=\"%s\"", _tmp26_);
	}
	_tmp27_ = cprefix;
	if (_tmp27_ != NULL) {
		GString* _tmp28_;
		const gchar* _tmp29_;
		_tmp28_ = self->priv->buffer;
		_tmp29_ = cprefix;
		g_string_append_printf (_tmp28_, " c:prefix=\"%s\"", _tmp29_);
	}
	_tmp30_ = self->priv->buffer;
	g_string_append_printf (_tmp30_, ">\n");
	_tmp31_ = self->priv->indent;
	self->priv->indent = _tmp31_ + 1;
	_tmp32_ = self->priv->hierarchy;
	_tmp33_ = ns;
	vala_list_insert ((ValaList*) _tmp32_, 0, (ValaSymbol*) _tmp33_);
	_tmp34_ = ns;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp34_, (ValaCodeVisitor*) self);
	_tmp35_ = self->priv->hierarchy;
	vala_list_remove_at ((ValaList*) _tmp35_, 0);
	_tmp36_ = self->priv->indent;
	self->priv->indent = _tmp36_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp37_ = self->priv->buffer;
	g_string_append_printf (_tmp37_, "</namespace>\n");
	_tmp38_ = self->priv->our_namespaces;
	_tmp39_ = ns;
	vala_collection_add ((ValaCollection*) _tmp38_, _tmp39_);
	vala_gir_writer_visit_deferred (self);
	_g_free0 (cprefix);
}


static void vala_gir_writer_write_symbol_attributes (ValaGIRWriter* self, ValaSymbol* symbol) {
	ValaSymbol* _tmp0_;
	gboolean _tmp1_;
	ValaSymbol* _tmp3_;
	ValaVersionAttribute* _tmp4_;
	ValaVersionAttribute* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	ValaSymbol* _tmp23_;
	ValaVersionAttribute* _tmp24_;
	ValaVersionAttribute* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gboolean _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	_tmp0_ = symbol;
	_tmp1_ = vala_gir_writer_is_introspectable (self, _tmp0_);
	if (!_tmp1_) {
		GString* _tmp2_;
		_tmp2_ = self->priv->buffer;
		g_string_append_printf (_tmp2_, " introspectable=\"0\"");
	}
	_tmp3_ = symbol;
	_tmp4_ = vala_symbol_get_version (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_version_attribute_get_deprecated (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		GString* _tmp8_;
		ValaSymbol* _tmp9_;
		ValaVersionAttribute* _tmp10_;
		ValaVersionAttribute* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gboolean _tmp15_;
		_tmp8_ = self->priv->buffer;
		g_string_append_printf (_tmp8_, " deprecated=\"1\"");
		_tmp9_ = symbol;
		_tmp10_ = vala_symbol_get_version (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_version_attribute_get_deprecated_since (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_ != NULL;
		_g_free0 (_tmp14_);
		if (_tmp15_) {
			GString* _tmp16_;
			ValaSymbol* _tmp17_;
			ValaVersionAttribute* _tmp18_;
			ValaVersionAttribute* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			_tmp16_ = self->priv->buffer;
			_tmp17_ = symbol;
			_tmp18_ = vala_symbol_get_version (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_version_attribute_get_deprecated_since (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = _tmp21_;
			g_string_append_printf (_tmp16_, " deprecated-version=\"%s\"", _tmp22_);
			_g_free0 (_tmp22_);
		}
	}
	_tmp23_ = symbol;
	_tmp24_ = vala_symbol_get_version (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_version_attribute_get_since (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = _tmp27_;
	_tmp29_ = _tmp28_ != NULL;
	_g_free0 (_tmp28_);
	if (_tmp29_) {
		GString* _tmp30_;
		ValaSymbol* _tmp31_;
		ValaVersionAttribute* _tmp32_;
		ValaVersionAttribute* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		_tmp30_ = self->priv->buffer;
		_tmp31_ = symbol;
		_tmp32_ = vala_symbol_get_version (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_version_attribute_get_since (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = _tmp35_;
		g_string_append_printf (_tmp30_, " version=\"%s\"", _tmp36_);
		_g_free0 (_tmp36_);
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static void vala_gir_writer_real_visit_class (ValaCodeVisitor* base, ValaClass* cl) {
	ValaGIRWriter * self;
	ValaClass* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaClass* _tmp3_;
	gboolean _tmp4_;
	ValaArrayList* _tmp5_;
	gpointer _tmp6_;
	ValaSymbol* _tmp7_;
	gboolean _tmp8_;
	ValaClass* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (cl != NULL);
	_tmp0_ = cl;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = cl;
	_tmp4_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp3_);
	if (!_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->hierarchy;
	_tmp6_ = vala_list_get ((ValaList*) _tmp5_, 0);
	_tmp7_ = (ValaSymbol*) _tmp6_;
	_tmp8_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_NAMESPACE);
	_vala_code_node_unref0 (_tmp7_);
	if (_tmp8_) {
		ValaArrayList* _tmp9_;
		ValaClass* _tmp10_;
		_tmp9_ = self->priv->deferred;
		_tmp10_ = cl;
		vala_collection_add ((ValaCollection*) _tmp9_, (ValaCodeNode*) _tmp10_);
		return;
	}
	_tmp11_ = cl;
	_tmp12_ = vala_class_get_is_compact (_tmp11_);
	_tmp13_ = _tmp12_;
	if (!_tmp13_) {
		gchar* gtype_struct_name = NULL;
		ValaClass* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		GString* _tmp19_;
		ValaClass* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		ValaClass* _tmp23_;
		GString* _tmp24_;
		const gchar* _tmp25_;
		ValaClass* _tmp26_;
		ValaClass* _tmp27_;
		ValaClass* _tmp28_;
		ValaClass* _tmp52_;
		gboolean _tmp53_;
		gboolean _tmp54_;
		ValaClass* _tmp56_;
		GString* _tmp57_;
		gint _tmp58_;
		ValaClass* _tmp59_;
		gchar* _tmp60_;
		gchar* _tmp61_;
		GString* _tmp84_;
		gint _tmp85_;
		ValaClass* _tmp86_;
		ValaClass* _tmp87_;
		ValaClass* _tmp88_;
		gint _tmp107_;
		GString* _tmp108_;
		ValaClass* _tmp109_;
		ValaClass* _tmp110_;
		ValaClass* _tmp111_;
		GString* _tmp117_;
		gint _tmp118_;
		GString* _tmp119_;
		ValaClass* _tmp120_;
		gchar* _tmp121_;
		gchar* _tmp122_;
		ValaClass* _tmp123_;
		gchar* _tmp124_;
		gchar* _tmp125_;
		gint _tmp126_;
		GString* _tmp127_;
		gboolean _tmp128_ = FALSE;
		ValaClass* _tmp129_;
		ValaClass* _tmp130_;
		ValaClass* _tmp131_;
		ValaArrayList* _tmp149_;
		ValaClass* _tmp150_;
		ValaClass* _tmp151_;
		ValaArrayList* _tmp152_;
		gint _tmp153_;
		GString* _tmp154_;
		GString* _tmp155_;
		const gchar* _tmp156_;
		ValaClass* _tmp157_;
		GString* _tmp158_;
		ValaClass* _tmp159_;
		gchar* _tmp160_;
		gchar* _tmp161_;
		GString* _tmp162_;
		gint _tmp163_;
		GString* _tmp164_;
		gint _tmp165_;
		ValaClass* _tmp166_;
		ValaClass* _tmp167_;
		ValaClass* _tmp168_;
		gint _tmp184_;
		GString* _tmp185_;
		gint _tmp307_;
		GString* _tmp308_;
		GString* _tmp309_;
		ValaClass* _tmp310_;
		gchar* _tmp311_;
		gchar* _tmp312_;
		ValaClass* _tmp313_;
		gchar* _tmp314_;
		gchar* _tmp315_;
		_tmp14_ = cl;
		_tmp15_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strconcat (_tmp16_, "Class", NULL);
		_tmp18_ = _tmp17_;
		_g_free0 (_tmp16_);
		gtype_struct_name = _tmp18_;
		vala_gir_writer_write_indent (self);
		_tmp19_ = self->priv->buffer;
		_tmp20_ = cl;
		_tmp21_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) _tmp20_);
		_tmp22_ = _tmp21_;
		g_string_append_printf (_tmp19_, "<class name=\"%s\"", _tmp22_);
		_g_free0 (_tmp22_);
		_tmp23_ = cl;
		vala_gir_writer_write_gtype_attributes (self, (ValaTypeSymbol*) _tmp23_);
		_tmp24_ = self->priv->buffer;
		_tmp25_ = gtype_struct_name;
		g_string_append_printf (_tmp24_, " glib:type-struct=\"%s\"", _tmp25_);
		_tmp26_ = cl;
		_tmp27_ = vala_class_get_base_class (_tmp26_);
		_tmp28_ = _tmp27_;
		if (_tmp28_ == NULL) {
			GString* _tmp29_;
			GString* _tmp30_;
			ValaClass* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			GString* _tmp34_;
			ValaClass* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			GString* _tmp38_;
			ValaClass* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			GString* _tmp42_;
			ValaClass* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			_tmp29_ = self->priv->buffer;
			g_string_append_printf (_tmp29_, " glib:fundamental=\"1\"");
			_tmp30_ = self->priv->buffer;
			_tmp31_ = cl;
			_tmp32_ = vala_ccode_base_module_get_ccode_ref_function ((ValaTypeSymbol*) _tmp31_);
			_tmp33_ = _tmp32_;
			g_string_append_printf (_tmp30_, " glib:ref-func=\"%s\"", _tmp33_);
			_g_free0 (_tmp33_);
			_tmp34_ = self->priv->buffer;
			_tmp35_ = cl;
			_tmp36_ = vala_ccode_base_module_get_ccode_unref_function ((ValaObjectTypeSymbol*) _tmp35_);
			_tmp37_ = _tmp36_;
			g_string_append_printf (_tmp34_, " glib:unref-func=\"%s\"", _tmp37_);
			_g_free0 (_tmp37_);
			_tmp38_ = self->priv->buffer;
			_tmp39_ = cl;
			_tmp40_ = vala_ccode_base_module_get_ccode_set_value_function ((ValaCodeNode*) _tmp39_);
			_tmp41_ = _tmp40_;
			g_string_append_printf (_tmp38_, " glib:set-value-func=\"%s\"", _tmp41_);
			_g_free0 (_tmp41_);
			_tmp42_ = self->priv->buffer;
			_tmp43_ = cl;
			_tmp44_ = vala_ccode_base_module_get_ccode_get_value_function ((ValaCodeNode*) _tmp43_);
			_tmp45_ = _tmp44_;
			g_string_append_printf (_tmp42_, " glib:get-value-func=\"%s\"", _tmp45_);
			_g_free0 (_tmp45_);
		} else {
			GString* _tmp46_;
			ValaClass* _tmp47_;
			ValaClass* _tmp48_;
			ValaClass* _tmp49_;
			gchar* _tmp50_;
			gchar* _tmp51_;
			_tmp46_ = self->priv->buffer;
			_tmp47_ = cl;
			_tmp48_ = vala_class_get_base_class (_tmp47_);
			_tmp49_ = _tmp48_;
			_tmp50_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp49_);
			_tmp51_ = _tmp50_;
			g_string_append_printf (_tmp46_, " parent=\"%s\"", _tmp51_);
			_g_free0 (_tmp51_);
		}
		_tmp52_ = cl;
		_tmp53_ = vala_class_get_is_abstract (_tmp52_);
		_tmp54_ = _tmp53_;
		if (_tmp54_) {
			GString* _tmp55_;
			_tmp55_ = self->priv->buffer;
			g_string_append_printf (_tmp55_, " abstract=\"1\"");
		}
		_tmp56_ = cl;
		vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp56_);
		_tmp57_ = self->priv->buffer;
		g_string_append_printf (_tmp57_, ">\n");
		_tmp58_ = self->priv->indent;
		self->priv->indent = _tmp58_ + 1;
		_tmp59_ = cl;
		_tmp60_ = vala_gir_writer_get_class_comment (self, _tmp59_);
		_tmp61_ = _tmp60_;
		vala_gir_writer_write_doc (self, _tmp61_);
		_g_free0 (_tmp61_);
		{
			ValaList* _base_type_list = NULL;
			ValaClass* _tmp62_;
			ValaList* _tmp63_;
			gint _base_type_size = 0;
			ValaList* _tmp64_;
			gint _tmp65_;
			gint _tmp66_;
			gint _base_type_index = 0;
			_tmp62_ = cl;
			_tmp63_ = vala_class_get_base_types (_tmp62_);
			_base_type_list = _tmp63_;
			_tmp64_ = _base_type_list;
			_tmp65_ = vala_collection_get_size ((ValaCollection*) _tmp64_);
			_tmp66_ = _tmp65_;
			_base_type_size = _tmp66_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp67_;
				gint _tmp68_;
				gint _tmp69_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp70_;
				gint _tmp71_;
				gpointer _tmp72_;
				ValaObjectType* object_type = NULL;
				ValaDataType* _tmp73_;
				ValaObjectType* _tmp74_;
				ValaObjectType* _tmp75_;
				ValaObjectTypeSymbol* _tmp76_;
				ValaObjectTypeSymbol* _tmp77_;
				_tmp67_ = _base_type_index;
				_base_type_index = _tmp67_ + 1;
				_tmp68_ = _base_type_index;
				_tmp69_ = _base_type_size;
				if (!(_tmp68_ < _tmp69_)) {
					break;
				}
				_tmp70_ = _base_type_list;
				_tmp71_ = _base_type_index;
				_tmp72_ = vala_list_get (_tmp70_, _tmp71_);
				base_type = (ValaDataType*) _tmp72_;
				_tmp73_ = base_type;
				_tmp74_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				object_type = _tmp74_;
				_tmp75_ = object_type;
				_tmp76_ = vala_object_type_get_type_symbol (_tmp75_);
				_tmp77_ = _tmp76_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp77_, VALA_TYPE_INTERFACE)) {
					GString* _tmp78_;
					ValaObjectType* _tmp79_;
					ValaObjectTypeSymbol* _tmp80_;
					ValaObjectTypeSymbol* _tmp81_;
					gchar* _tmp82_;
					gchar* _tmp83_;
					vala_gir_writer_write_indent (self);
					_tmp78_ = self->priv->buffer;
					_tmp79_ = object_type;
					_tmp80_ = vala_object_type_get_type_symbol (_tmp79_);
					_tmp81_ = _tmp80_;
					_tmp82_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp81_);
					_tmp83_ = _tmp82_;
					g_string_append_printf (_tmp78_, "<implements name=\"%s\"/>\n", _tmp83_);
					_g_free0 (_tmp83_);
				}
				_vala_code_node_unref0 (object_type);
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		vala_gir_writer_write_indent (self);
		_tmp84_ = self->priv->buffer;
		g_string_append_printf (_tmp84_, "<field name=\"parent_instance\">\n");
		_tmp85_ = self->priv->indent;
		self->priv->indent = _tmp85_ + 1;
		vala_gir_writer_write_indent (self);
		_tmp86_ = cl;
		_tmp87_ = vala_class_get_base_class (_tmp86_);
		_tmp88_ = _tmp87_;
		if (_tmp88_ == NULL) {
			GString* _tmp89_;
			ValaTypeSymbol* _tmp90_;
			gchar* _tmp91_;
			gchar* _tmp92_;
			ValaTypeSymbol* _tmp93_;
			gchar* _tmp94_;
			gchar* _tmp95_;
			_tmp89_ = self->priv->buffer;
			_tmp90_ = self->priv->gtypeinstance_type;
			_tmp91_ = vala_gir_writer_gi_type_name (self, _tmp90_);
			_tmp92_ = _tmp91_;
			_tmp93_ = self->priv->gtypeinstance_type;
			_tmp94_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp93_);
			_tmp95_ = _tmp94_;
			g_string_append_printf (_tmp89_, "<type name=\"%s\" c:type=\"%s\"/>\n", _tmp92_, _tmp95_);
			_g_free0 (_tmp95_);
			_g_free0 (_tmp92_);
		} else {
			GString* _tmp96_;
			ValaClass* _tmp97_;
			ValaClass* _tmp98_;
			ValaClass* _tmp99_;
			gchar* _tmp100_;
			gchar* _tmp101_;
			ValaClass* _tmp102_;
			ValaClass* _tmp103_;
			ValaClass* _tmp104_;
			gchar* _tmp105_;
			gchar* _tmp106_;
			_tmp96_ = self->priv->buffer;
			_tmp97_ = cl;
			_tmp98_ = vala_class_get_base_class (_tmp97_);
			_tmp99_ = _tmp98_;
			_tmp100_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp99_);
			_tmp101_ = _tmp100_;
			_tmp102_ = cl;
			_tmp103_ = vala_class_get_base_class (_tmp102_);
			_tmp104_ = _tmp103_;
			_tmp105_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp104_);
			_tmp106_ = _tmp105_;
			g_string_append_printf (_tmp96_, "<type name=\"%s\" c:type=\"%s\"/>\n", _tmp101_, _tmp106_);
			_g_free0 (_tmp106_);
			_g_free0 (_tmp101_);
		}
		_tmp107_ = self->priv->indent;
		self->priv->indent = _tmp107_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp108_ = self->priv->buffer;
		g_string_append_printf (_tmp108_, "</field>\n");
		_tmp109_ = cl;
		_tmp110_ = vala_class_get_base_class (_tmp109_);
		_tmp111_ = _tmp110_;
		if (_tmp111_ == NULL) {
			GString* _tmp112_;
			gint _tmp113_;
			GString* _tmp114_;
			gint _tmp115_;
			GString* _tmp116_;
			vala_gir_writer_write_indent (self);
			_tmp112_ = self->priv->buffer;
			g_string_append_printf (_tmp112_, "<field name=\"ref_count\">\n");
			_tmp113_ = self->priv->indent;
			self->priv->indent = _tmp113_ + 1;
			vala_gir_writer_write_indent (self);
			_tmp114_ = self->priv->buffer;
			g_string_append_printf (_tmp114_, "<type name=\"gint\" c:type=\"volatile int\"/>\n");
			_tmp115_ = self->priv->indent;
			self->priv->indent = _tmp115_ - 1;
			vala_gir_writer_write_indent (self);
			_tmp116_ = self->priv->buffer;
			g_string_append_printf (_tmp116_, "</field>\n");
		}
		vala_gir_writer_write_indent (self);
		_tmp117_ = self->priv->buffer;
		g_string_append_printf (_tmp117_, "<field name=\"priv\">\n");
		_tmp118_ = self->priv->indent;
		self->priv->indent = _tmp118_ + 1;
		vala_gir_writer_write_indent (self);
		_tmp119_ = self->priv->buffer;
		_tmp120_ = cl;
		_tmp121_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) _tmp120_);
		_tmp122_ = _tmp121_;
		_tmp123_ = cl;
		_tmp124_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp123_);
		_tmp125_ = _tmp124_;
		g_string_append_printf (_tmp119_, "<type name=\"%sPrivate\" c:type=\"%sPrivate*\"/>\n", _tmp122_, _tmp125_);
		_g_free0 (_tmp125_);
		_g_free0 (_tmp122_);
		_tmp126_ = self->priv->indent;
		self->priv->indent = _tmp126_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp127_ = self->priv->buffer;
		g_string_append_printf (_tmp127_, "</field>\n");
		_tmp129_ = cl;
		_tmp130_ = vala_class_get_base_class (_tmp129_);
		_tmp131_ = _tmp130_;
		if (_tmp131_ != NULL) {
			ValaClass* _tmp132_;
			ValaClass* _tmp133_;
			ValaClass* _tmp134_;
			ValaTypeSymbol* _tmp135_;
			gboolean _tmp136_;
			_tmp132_ = cl;
			_tmp133_ = vala_class_get_base_class (_tmp132_);
			_tmp134_ = _tmp133_;
			_tmp135_ = self->priv->gobject_type;
			_tmp136_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp134_, _tmp135_);
			_tmp128_ = _tmp136_;
		} else {
			_tmp128_ = FALSE;
		}
		if (_tmp128_) {
			{
				ValaList* _p_list = NULL;
				ValaClass* _tmp137_;
				ValaList* _tmp138_;
				gint _p_size = 0;
				ValaList* _tmp139_;
				gint _tmp140_;
				gint _tmp141_;
				gint _p_index = 0;
				_tmp137_ = cl;
				_tmp138_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp137_);
				_p_list = _tmp138_;
				_tmp139_ = _p_list;
				_tmp140_ = vala_collection_get_size ((ValaCollection*) _tmp139_);
				_tmp141_ = _tmp140_;
				_p_size = _tmp141_;
				_p_index = -1;
				while (TRUE) {
					gint _tmp142_;
					gint _tmp143_;
					gint _tmp144_;
					ValaTypeParameter* p = NULL;
					ValaList* _tmp145_;
					gint _tmp146_;
					gpointer _tmp147_;
					ValaTypeParameter* _tmp148_;
					_tmp142_ = _p_index;
					_p_index = _tmp142_ + 1;
					_tmp143_ = _p_index;
					_tmp144_ = _p_size;
					if (!(_tmp143_ < _tmp144_)) {
						break;
					}
					_tmp145_ = _p_list;
					_tmp146_ = _p_index;
					_tmp147_ = vala_list_get (_tmp145_, _tmp146_);
					p = (ValaTypeParameter*) _tmp147_;
					_tmp148_ = p;
					vala_gir_writer_write_type_parameter (self, _tmp148_, "property");
					_vala_code_node_unref0 (p);
				}
				_vala_iterable_unref0 (_p_list);
			}
		}
		_tmp149_ = self->priv->hierarchy;
		_tmp150_ = cl;
		vala_list_insert ((ValaList*) _tmp149_, 0, (ValaSymbol*) _tmp150_);
		_tmp151_ = cl;
		vala_code_node_accept_children ((ValaCodeNode*) _tmp151_, (ValaCodeVisitor*) self);
		_tmp152_ = self->priv->hierarchy;
		vala_list_remove_at ((ValaList*) _tmp152_, 0);
		_tmp153_ = self->priv->indent;
		self->priv->indent = _tmp153_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp154_ = self->priv->buffer;
		g_string_append_printf (_tmp154_, "</class>\n");
		vala_gir_writer_write_indent (self);
		_tmp155_ = self->priv->buffer;
		_tmp156_ = gtype_struct_name;
		g_string_append_printf (_tmp155_, "<record name=\"%s\"", _tmp156_);
		_tmp157_ = cl;
		vala_gir_writer_write_ctype_attributes (self, (ValaTypeSymbol*) _tmp157_, "Class");
		_tmp158_ = self->priv->buffer;
		_tmp159_ = cl;
		_tmp160_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) _tmp159_);
		_tmp161_ = _tmp160_;
		g_string_append_printf (_tmp158_, " glib:is-gtype-struct-for=\"%s\"", _tmp161_);
		_g_free0 (_tmp161_);
		_tmp162_ = self->priv->buffer;
		g_string_append_printf (_tmp162_, ">\n");
		_tmp163_ = self->priv->indent;
		self->priv->indent = _tmp163_ + 1;
		vala_gir_writer_write_indent (self);
		_tmp164_ = self->priv->buffer;
		g_string_append_printf (_tmp164_, "<field name=\"parent_class\">\n");
		_tmp165_ = self->priv->indent;
		self->priv->indent = _tmp165_ + 1;
		vala_gir_writer_write_indent (self);
		_tmp166_ = cl;
		_tmp167_ = vala_class_get_base_class (_tmp166_);
		_tmp168_ = _tmp167_;
		if (_tmp168_ == NULL) {
			GString* _tmp169_;
			ValaTypeSymbol* _tmp170_;
			gchar* _tmp171_;
			gchar* _tmp172_;
			_tmp169_ = self->priv->buffer;
			_tmp170_ = self->priv->gtype_type;
			_tmp171_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp170_);
			_tmp172_ = _tmp171_;
			g_string_append_printf (_tmp169_, "<type name=\"%sClass\" c:type=\"%sClass\"/>\n", "GObject.Type", _tmp172_);
			_g_free0 (_tmp172_);
		} else {
			GString* _tmp173_;
			ValaClass* _tmp174_;
			ValaClass* _tmp175_;
			ValaClass* _tmp176_;
			gchar* _tmp177_;
			gchar* _tmp178_;
			ValaClass* _tmp179_;
			ValaClass* _tmp180_;
			ValaClass* _tmp181_;
			gchar* _tmp182_;
			gchar* _tmp183_;
			_tmp173_ = self->priv->buffer;
			_tmp174_ = cl;
			_tmp175_ = vala_class_get_base_class (_tmp174_);
			_tmp176_ = _tmp175_;
			_tmp177_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp176_);
			_tmp178_ = _tmp177_;
			_tmp179_ = cl;
			_tmp180_ = vala_class_get_base_class (_tmp179_);
			_tmp181_ = _tmp180_;
			_tmp182_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp181_);
			_tmp183_ = _tmp182_;
			g_string_append_printf (_tmp173_, "<type name=\"%sClass\" c:type=\"%sClass\"/>\n", _tmp178_, _tmp183_);
			_g_free0 (_tmp183_);
			_g_free0 (_tmp178_);
		}
		_tmp184_ = self->priv->indent;
		self->priv->indent = _tmp184_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp185_ = self->priv->buffer;
		g_string_append_printf (_tmp185_, "</field>\n");
		{
			ValaList* _m_list = NULL;
			ValaClass* _tmp186_;
			ValaList* _tmp187_;
			gint _m_size = 0;
			ValaList* _tmp188_;
			gint _tmp189_;
			gint _tmp190_;
			gint _m_index = 0;
			_tmp186_ = cl;
			_tmp187_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp186_);
			_m_list = _tmp187_;
			_tmp188_ = _m_list;
			_tmp189_ = vala_collection_get_size ((ValaCollection*) _tmp188_);
			_tmp190_ = _tmp189_;
			_m_size = _tmp190_;
			_m_index = -1;
			while (TRUE) {
				gint _tmp191_;
				gint _tmp192_;
				gint _tmp193_;
				ValaMethod* m = NULL;
				ValaList* _tmp194_;
				gint _tmp195_;
				gpointer _tmp196_;
				gboolean _tmp197_ = FALSE;
				ValaMethod* _tmp198_;
				gboolean _tmp199_;
				gboolean _tmp200_;
				_tmp191_ = _m_index;
				_m_index = _tmp191_ + 1;
				_tmp192_ = _m_index;
				_tmp193_ = _m_size;
				if (!(_tmp192_ < _tmp193_)) {
					break;
				}
				_tmp194_ = _m_list;
				_tmp195_ = _m_index;
				_tmp196_ = vala_list_get (_tmp194_, _tmp195_);
				m = (ValaMethod*) _tmp196_;
				_tmp198_ = m;
				_tmp199_ = vala_method_get_is_abstract (_tmp198_);
				_tmp200_ = _tmp199_;
				if (_tmp200_) {
					_tmp197_ = TRUE;
				} else {
					ValaMethod* _tmp201_;
					gboolean _tmp202_;
					gboolean _tmp203_;
					_tmp201_ = m;
					_tmp202_ = vala_method_get_is_virtual (_tmp201_);
					_tmp203_ = _tmp202_;
					_tmp197_ = _tmp203_;
				}
				if (_tmp197_) {
					ValaMethod* _tmp204_;
					gboolean _tmp205_;
					gboolean _tmp206_;
					_tmp204_ = m;
					_tmp205_ = vala_method_get_coroutine (_tmp204_);
					_tmp206_ = _tmp205_;
					if (_tmp206_) {
						gchar* finish_name = NULL;
						ValaMethod* _tmp207_;
						const gchar* _tmp208_;
						const gchar* _tmp209_;
						gchar* _tmp210_;
						const gchar* _tmp211_;
						gboolean _tmp212_;
						const gchar* _tmp220_;
						gchar* _tmp221_;
						GString* _tmp222_;
						ValaMethod* _tmp223_;
						const gchar* _tmp224_;
						const gchar* _tmp225_;
						gint _tmp226_;
						ValaMethod* _tmp227_;
						ValaMethod* _tmp228_;
						const gchar* _tmp229_;
						const gchar* _tmp230_;
						ValaMethod* _tmp231_;
						gchar* _tmp232_;
						gchar* _tmp233_;
						ValaMethod* _tmp234_;
						ValaList* _tmp235_;
						ValaList* _tmp236_;
						ValaVoidType* _tmp237_;
						ValaVoidType* _tmp238_;
						gint _tmp239_;
						GString* _tmp240_;
						GString* _tmp241_;
						const gchar* _tmp242_;
						gint _tmp243_;
						ValaMethod* _tmp244_;
						const gchar* _tmp245_;
						ValaMethod* _tmp246_;
						gchar* _tmp247_;
						gchar* _tmp248_;
						ValaMethod* _tmp249_;
						ValaList* _tmp250_;
						ValaList* _tmp251_;
						ValaMethod* _tmp252_;
						ValaDataType* _tmp253_;
						ValaDataType* _tmp254_;
						ValaMethod* _tmp255_;
						gboolean _tmp256_;
						gboolean _tmp257_;
						gint _tmp258_;
						GString* _tmp259_;
						_tmp207_ = m;
						_tmp208_ = vala_symbol_get_name ((ValaSymbol*) _tmp207_);
						_tmp209_ = _tmp208_;
						_tmp210_ = g_strdup (_tmp209_);
						finish_name = _tmp210_;
						_tmp211_ = finish_name;
						_tmp212_ = g_str_has_suffix (_tmp211_, "_async");
						if (_tmp212_) {
							const gchar* _tmp213_;
							const gchar* _tmp214_;
							gint _tmp215_;
							gint _tmp216_;
							gint _tmp217_;
							gint _tmp218_;
							gchar* _tmp219_;
							_tmp213_ = finish_name;
							_tmp214_ = finish_name;
							_tmp215_ = strlen (_tmp214_);
							_tmp216_ = _tmp215_;
							_tmp217_ = strlen ("_async");
							_tmp218_ = _tmp217_;
							_tmp219_ = string_substring (_tmp213_, (glong) 0, (glong) (_tmp216_ - _tmp218_));
							_g_free0 (finish_name);
							finish_name = _tmp219_;
						}
						_tmp220_ = finish_name;
						_tmp221_ = g_strconcat (_tmp220_, "_finish", NULL);
						_g_free0 (finish_name);
						finish_name = _tmp221_;
						vala_gir_writer_write_indent (self);
						_tmp222_ = self->priv->buffer;
						_tmp223_ = m;
						_tmp224_ = vala_symbol_get_name ((ValaSymbol*) _tmp223_);
						_tmp225_ = _tmp224_;
						g_string_append_printf (_tmp222_, "<field name=\"%s\">\n", _tmp225_);
						_tmp226_ = self->priv->indent;
						self->priv->indent = _tmp226_ + 1;
						_tmp227_ = m;
						_tmp228_ = m;
						_tmp229_ = vala_symbol_get_name ((ValaSymbol*) _tmp228_);
						_tmp230_ = _tmp229_;
						_tmp231_ = m;
						_tmp232_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp231_);
						_tmp233_ = _tmp232_;
						_tmp234_ = m;
						_tmp235_ = vala_method_get_async_begin_parameters (_tmp234_);
						_tmp236_ = _tmp235_;
						_tmp237_ = vala_void_type_new (NULL);
						_tmp238_ = _tmp237_;
						vala_gir_writer_do_write_signature (self, _tmp227_, "callback", TRUE, _tmp230_, _tmp233_, _tmp236_, (ValaDataType*) _tmp238_, FALSE, FALSE);
						_vala_code_node_unref0 (_tmp238_);
						_vala_iterable_unref0 (_tmp236_);
						_g_free0 (_tmp233_);
						_tmp239_ = self->priv->indent;
						self->priv->indent = _tmp239_ - 1;
						vala_gir_writer_write_indent (self);
						_tmp240_ = self->priv->buffer;
						g_string_append_printf (_tmp240_, "</field>\n");
						vala_gir_writer_write_indent (self);
						_tmp241_ = self->priv->buffer;
						_tmp242_ = finish_name;
						g_string_append_printf (_tmp241_, "<field name=\"%s\">\n", _tmp242_);
						_tmp243_ = self->priv->indent;
						self->priv->indent = _tmp243_ + 1;
						_tmp244_ = m;
						_tmp245_ = finish_name;
						_tmp246_ = m;
						_tmp247_ = vala_ccode_base_module_get_ccode_finish_name (_tmp246_);
						_tmp248_ = _tmp247_;
						_tmp249_ = m;
						_tmp250_ = vala_method_get_async_end_parameters (_tmp249_);
						_tmp251_ = _tmp250_;
						_tmp252_ = m;
						_tmp253_ = vala_callable_get_return_type ((ValaCallable*) _tmp252_);
						_tmp254_ = _tmp253_;
						_tmp255_ = m;
						_tmp256_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp255_);
						_tmp257_ = _tmp256_;
						vala_gir_writer_do_write_signature (self, _tmp244_, "callback", TRUE, _tmp245_, _tmp248_, _tmp251_, _tmp254_, _tmp257_, FALSE);
						_vala_iterable_unref0 (_tmp251_);
						_g_free0 (_tmp248_);
						_tmp258_ = self->priv->indent;
						self->priv->indent = _tmp258_ - 1;
						vala_gir_writer_write_indent (self);
						_tmp259_ = self->priv->buffer;
						g_string_append_printf (_tmp259_, "</field>\n");
						_g_free0 (finish_name);
					} else {
						GString* _tmp260_;
						ValaMethod* _tmp261_;
						const gchar* _tmp262_;
						const gchar* _tmp263_;
						gint _tmp264_;
						ValaMethod* _tmp265_;
						ValaMethod* _tmp266_;
						const gchar* _tmp267_;
						const gchar* _tmp268_;
						ValaMethod* _tmp269_;
						gchar* _tmp270_;
						gchar* _tmp271_;
						ValaMethod* _tmp272_;
						ValaList* _tmp273_;
						ValaList* _tmp274_;
						ValaMethod* _tmp275_;
						ValaDataType* _tmp276_;
						ValaDataType* _tmp277_;
						ValaMethod* _tmp278_;
						gboolean _tmp279_;
						gboolean _tmp280_;
						gint _tmp281_;
						GString* _tmp282_;
						vala_gir_writer_write_indent (self);
						_tmp260_ = self->priv->buffer;
						_tmp261_ = m;
						_tmp262_ = vala_symbol_get_name ((ValaSymbol*) _tmp261_);
						_tmp263_ = _tmp262_;
						g_string_append_printf (_tmp260_, "<field name=\"%s\">\n", _tmp263_);
						_tmp264_ = self->priv->indent;
						self->priv->indent = _tmp264_ + 1;
						_tmp265_ = m;
						_tmp266_ = m;
						_tmp267_ = vala_symbol_get_name ((ValaSymbol*) _tmp266_);
						_tmp268_ = _tmp267_;
						_tmp269_ = m;
						_tmp270_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp269_);
						_tmp271_ = _tmp270_;
						_tmp272_ = m;
						_tmp273_ = vala_callable_get_parameters ((ValaCallable*) _tmp272_);
						_tmp274_ = _tmp273_;
						_tmp275_ = m;
						_tmp276_ = vala_callable_get_return_type ((ValaCallable*) _tmp275_);
						_tmp277_ = _tmp276_;
						_tmp278_ = m;
						_tmp279_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp278_);
						_tmp280_ = _tmp279_;
						vala_gir_writer_do_write_signature (self, _tmp265_, "callback", TRUE, _tmp268_, _tmp271_, _tmp274_, _tmp277_, _tmp280_, FALSE);
						_vala_iterable_unref0 (_tmp274_);
						_g_free0 (_tmp271_);
						_tmp281_ = self->priv->indent;
						self->priv->indent = _tmp281_ - 1;
						vala_gir_writer_write_indent (self);
						_tmp282_ = self->priv->buffer;
						g_string_append_printf (_tmp282_, "</field>\n");
					}
				}
				_vala_code_node_unref0 (m);
			}
			_vala_iterable_unref0 (_m_list);
		}
		{
			ValaList* _sig_list = NULL;
			ValaClass* _tmp283_;
			ValaList* _tmp284_;
			gint _sig_size = 0;
			ValaList* _tmp285_;
			gint _tmp286_;
			gint _tmp287_;
			gint _sig_index = 0;
			_tmp283_ = cl;
			_tmp284_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) _tmp283_);
			_sig_list = _tmp284_;
			_tmp285_ = _sig_list;
			_tmp286_ = vala_collection_get_size ((ValaCollection*) _tmp285_);
			_tmp287_ = _tmp286_;
			_sig_size = _tmp287_;
			_sig_index = -1;
			while (TRUE) {
				gint _tmp288_;
				gint _tmp289_;
				gint _tmp290_;
				ValaSignal* sig = NULL;
				ValaList* _tmp291_;
				gint _tmp292_;
				gpointer _tmp293_;
				ValaSignal* _tmp294_;
				ValaMethod* _tmp295_;
				ValaMethod* _tmp296_;
				_tmp288_ = _sig_index;
				_sig_index = _tmp288_ + 1;
				_tmp289_ = _sig_index;
				_tmp290_ = _sig_size;
				if (!(_tmp289_ < _tmp290_)) {
					break;
				}
				_tmp291_ = _sig_list;
				_tmp292_ = _sig_index;
				_tmp293_ = vala_list_get (_tmp291_, _tmp292_);
				sig = (ValaSignal*) _tmp293_;
				_tmp294_ = sig;
				_tmp295_ = vala_signal_get_default_handler (_tmp294_);
				_tmp296_ = _tmp295_;
				if (_tmp296_ != NULL) {
					GString* _tmp297_;
					ValaSignal* _tmp298_;
					gchar* _tmp299_;
					gchar* _tmp300_;
					gint _tmp301_;
					ValaSignal* _tmp302_;
					ValaMethod* _tmp303_;
					ValaMethod* _tmp304_;
					gint _tmp305_;
					GString* _tmp306_;
					vala_gir_writer_write_indent (self);
					_tmp297_ = self->priv->buffer;
					_tmp298_ = sig;
					_tmp299_ = vala_ccode_base_module_get_ccode_lower_case_name ((ValaCodeNode*) _tmp298_, NULL);
					_tmp300_ = _tmp299_;
					g_string_append_printf (_tmp297_, "<field name=\"%s\">\n", _tmp300_);
					_g_free0 (_tmp300_);
					_tmp301_ = self->priv->indent;
					self->priv->indent = _tmp301_ + 1;
					_tmp302_ = sig;
					_tmp303_ = vala_signal_get_default_handler (_tmp302_);
					_tmp304_ = _tmp303_;
					vala_gir_writer_write_signature (self, _tmp304_, "callback", FALSE, TRUE);
					_tmp305_ = self->priv->indent;
					self->priv->indent = _tmp305_ - 1;
					vala_gir_writer_write_indent (self);
					_tmp306_ = self->priv->buffer;
					g_string_append_printf (_tmp306_, "</field>\n");
				}
				_vala_code_node_unref0 (sig);
			}
			_vala_iterable_unref0 (_sig_list);
		}
		_tmp307_ = self->priv->indent;
		self->priv->indent = _tmp307_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp308_ = self->priv->buffer;
		g_string_append_printf (_tmp308_, "</record>\n");
		vala_gir_writer_write_indent (self);
		_tmp309_ = self->priv->buffer;
		_tmp310_ = cl;
		_tmp311_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) _tmp310_);
		_tmp312_ = _tmp311_;
		_tmp313_ = cl;
		_tmp314_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp313_);
		_tmp315_ = _tmp314_;
		g_string_append_printf (_tmp309_, "<record name=\"%sPrivate\" c:type=\"%sPrivate\" disguised=\"1\"/>\n", _tmp312_, _tmp315_);
		_g_free0 (_tmp315_);
		_g_free0 (_tmp312_);
		_g_free0 (gtype_struct_name);
	} else {
		GString* _tmp316_;
		ValaClass* _tmp317_;
		gchar* _tmp318_;
		gchar* _tmp319_;
		ValaClass* _tmp320_;
		GString* _tmp321_;
		gint _tmp322_;
		ValaClass* _tmp323_;
		gchar* _tmp324_;
		gchar* _tmp325_;
		ValaArrayList* _tmp326_;
		ValaClass* _tmp327_;
		ValaClass* _tmp328_;
		ValaArrayList* _tmp329_;
		gint _tmp330_;
		GString* _tmp331_;
		vala_gir_writer_write_indent (self);
		_tmp316_ = self->priv->buffer;
		_tmp317_ = cl;
		_tmp318_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) _tmp317_);
		_tmp319_ = _tmp318_;
		g_string_append_printf (_tmp316_, "<record name=\"%s\"", _tmp319_);
		_g_free0 (_tmp319_);
		_tmp320_ = cl;
		vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp320_);
		_tmp321_ = self->priv->buffer;
		g_string_append_printf (_tmp321_, ">\n");
		_tmp322_ = self->priv->indent;
		self->priv->indent = _tmp322_ + 1;
		_tmp323_ = cl;
		_tmp324_ = vala_gir_writer_get_class_comment (self, _tmp323_);
		_tmp325_ = _tmp324_;
		vala_gir_writer_write_doc (self, _tmp325_);
		_g_free0 (_tmp325_);
		_tmp326_ = self->priv->hierarchy;
		_tmp327_ = cl;
		vala_list_insert ((ValaList*) _tmp326_, 0, (ValaSymbol*) _tmp327_);
		_tmp328_ = cl;
		vala_code_node_accept_children ((ValaCodeNode*) _tmp328_, (ValaCodeVisitor*) self);
		_tmp329_ = self->priv->hierarchy;
		vala_list_remove_at ((ValaList*) _tmp329_, 0);
		_tmp330_ = self->priv->indent;
		self->priv->indent = _tmp330_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp331_ = self->priv->buffer;
		g_string_append_printf (_tmp331_, "</record>\n");
	}
	vala_gir_writer_visit_deferred (self);
}


static void vala_gir_writer_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st) {
	ValaGIRWriter * self;
	ValaStruct* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaStruct* _tmp3_;
	gboolean _tmp4_;
	ValaArrayList* _tmp5_;
	gpointer _tmp6_;
	ValaSymbol* _tmp7_;
	gboolean _tmp8_;
	GString* _tmp11_;
	ValaStruct* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	ValaStruct* _tmp15_;
	gboolean _tmp16_;
	ValaStruct* _tmp19_;
	GString* _tmp20_;
	gint _tmp21_;
	ValaStruct* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	ValaArrayList* _tmp25_;
	ValaStruct* _tmp26_;
	ValaStruct* _tmp27_;
	ValaArrayList* _tmp28_;
	gint _tmp29_;
	GString* _tmp30_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (st != NULL);
	_tmp0_ = st;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = st;
	_tmp4_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp3_);
	if (!_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->hierarchy;
	_tmp6_ = vala_list_get ((ValaList*) _tmp5_, 0);
	_tmp7_ = (ValaSymbol*) _tmp6_;
	_tmp8_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_NAMESPACE);
	_vala_code_node_unref0 (_tmp7_);
	if (_tmp8_) {
		ValaArrayList* _tmp9_;
		ValaStruct* _tmp10_;
		_tmp9_ = self->priv->deferred;
		_tmp10_ = st;
		vala_collection_add ((ValaCollection*) _tmp9_, (ValaCodeNode*) _tmp10_);
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp11_ = self->priv->buffer;
	_tmp12_ = st;
	_tmp13_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) _tmp12_);
	_tmp14_ = _tmp13_;
	g_string_append_printf (_tmp11_, "<record name=\"%s\"", _tmp14_);
	_g_free0 (_tmp14_);
	_tmp15_ = st;
	_tmp16_ = vala_ccode_base_module_get_ccode_has_type_id ((ValaTypeSymbol*) _tmp15_);
	if (_tmp16_) {
		ValaStruct* _tmp17_;
		_tmp17_ = st;
		vala_gir_writer_write_gtype_attributes (self, (ValaTypeSymbol*) _tmp17_);
	} else {
		ValaStruct* _tmp18_;
		_tmp18_ = st;
		vala_gir_writer_write_ctype_attributes (self, (ValaTypeSymbol*) _tmp18_, "");
	}
	_tmp19_ = st;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp19_);
	_tmp20_ = self->priv->buffer;
	g_string_append_printf (_tmp20_, ">\n");
	_tmp21_ = self->priv->indent;
	self->priv->indent = _tmp21_ + 1;
	_tmp22_ = st;
	_tmp23_ = vala_gir_writer_get_struct_comment (self, _tmp22_);
	_tmp24_ = _tmp23_;
	vala_gir_writer_write_doc (self, _tmp24_);
	_g_free0 (_tmp24_);
	_tmp25_ = self->priv->hierarchy;
	_tmp26_ = st;
	vala_list_insert ((ValaList*) _tmp25_, 0, (ValaSymbol*) _tmp26_);
	_tmp27_ = st;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp27_, (ValaCodeVisitor*) self);
	_tmp28_ = self->priv->hierarchy;
	vala_list_remove_at ((ValaList*) _tmp28_, 0);
	_tmp29_ = self->priv->indent;
	self->priv->indent = _tmp29_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp30_ = self->priv->buffer;
	g_string_append_printf (_tmp30_, "</record>\n");
	vala_gir_writer_visit_deferred (self);
}


static void vala_gir_writer_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface) {
	ValaGIRWriter * self;
	ValaInterface* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaInterface* _tmp3_;
	gboolean _tmp4_;
	ValaArrayList* _tmp5_;
	gpointer _tmp6_;
	ValaSymbol* _tmp7_;
	gboolean _tmp8_;
	gchar* gtype_struct_name = NULL;
	ValaInterface* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GString* _tmp16_;
	ValaInterface* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	ValaInterface* _tmp20_;
	GString* _tmp21_;
	const gchar* _tmp22_;
	ValaInterface* _tmp23_;
	GString* _tmp24_;
	gint _tmp25_;
	ValaInterface* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	ValaInterface* _tmp29_;
	ValaList* _tmp30_;
	ValaList* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	gboolean _tmp34_;
	ValaArrayList* _tmp52_;
	ValaInterface* _tmp53_;
	ValaInterface* _tmp54_;
	ValaArrayList* _tmp55_;
	gint _tmp56_;
	GString* _tmp57_;
	GString* _tmp58_;
	const gchar* _tmp59_;
	ValaInterface* _tmp60_;
	GString* _tmp61_;
	ValaInterface* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	GString* _tmp65_;
	gint _tmp66_;
	GString* _tmp67_;
	gint _tmp68_;
	GString* _tmp69_;
	ValaTypeSymbol* _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	ValaTypeSymbol* _tmp73_;
	gchar* _tmp74_;
	gchar* _tmp75_;
	gint _tmp76_;
	GString* _tmp77_;
	gint _tmp259_;
	GString* _tmp260_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (iface != NULL);
	_tmp0_ = iface;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = iface;
	_tmp4_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp3_);
	if (!_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->hierarchy;
	_tmp6_ = vala_list_get ((ValaList*) _tmp5_, 0);
	_tmp7_ = (ValaSymbol*) _tmp6_;
	_tmp8_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_NAMESPACE);
	_vala_code_node_unref0 (_tmp7_);
	if (_tmp8_) {
		ValaArrayList* _tmp9_;
		ValaInterface* _tmp10_;
		_tmp9_ = self->priv->deferred;
		_tmp10_ = iface;
		vala_collection_add ((ValaCollection*) _tmp9_, (ValaCodeNode*) _tmp10_);
		return;
	}
	_tmp11_ = iface;
	_tmp12_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp13_, "Iface", NULL);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	gtype_struct_name = _tmp15_;
	vala_gir_writer_write_indent (self);
	_tmp16_ = self->priv->buffer;
	_tmp17_ = iface;
	_tmp18_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) _tmp17_);
	_tmp19_ = _tmp18_;
	g_string_append_printf (_tmp16_, "<interface name=\"%s\"", _tmp19_);
	_g_free0 (_tmp19_);
	_tmp20_ = iface;
	vala_gir_writer_write_gtype_attributes (self, (ValaTypeSymbol*) _tmp20_);
	_tmp21_ = self->priv->buffer;
	_tmp22_ = gtype_struct_name;
	g_string_append_printf (_tmp21_, " glib:type-struct=\"%s\"", _tmp22_);
	_tmp23_ = iface;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp23_);
	_tmp24_ = self->priv->buffer;
	g_string_append_printf (_tmp24_, ">\n");
	_tmp25_ = self->priv->indent;
	self->priv->indent = _tmp25_ + 1;
	_tmp26_ = iface;
	_tmp27_ = vala_gir_writer_get_interface_comment (self, _tmp26_);
	_tmp28_ = _tmp27_;
	vala_gir_writer_write_doc (self, _tmp28_);
	_g_free0 (_tmp28_);
	_tmp29_ = iface;
	_tmp30_ = vala_interface_get_prerequisites (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = vala_collection_get_size ((ValaCollection*) _tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = _tmp33_ > 0;
	_vala_iterable_unref0 (_tmp31_);
	if (_tmp34_) {
		{
			ValaList* _base_type_list = NULL;
			ValaInterface* _tmp35_;
			ValaList* _tmp36_;
			gint _base_type_size = 0;
			ValaList* _tmp37_;
			gint _tmp38_;
			gint _tmp39_;
			gint _base_type_index = 0;
			_tmp35_ = iface;
			_tmp36_ = vala_interface_get_prerequisites (_tmp35_);
			_base_type_list = _tmp36_;
			_tmp37_ = _base_type_list;
			_tmp38_ = vala_collection_get_size ((ValaCollection*) _tmp37_);
			_tmp39_ = _tmp38_;
			_base_type_size = _tmp39_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp40_;
				gint _tmp41_;
				gint _tmp42_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp43_;
				gint _tmp44_;
				gpointer _tmp45_;
				GString* _tmp46_;
				ValaDataType* _tmp47_;
				ValaObjectTypeSymbol* _tmp48_;
				ValaObjectTypeSymbol* _tmp49_;
				gchar* _tmp50_;
				gchar* _tmp51_;
				_tmp40_ = _base_type_index;
				_base_type_index = _tmp40_ + 1;
				_tmp41_ = _base_type_index;
				_tmp42_ = _base_type_size;
				if (!(_tmp41_ < _tmp42_)) {
					break;
				}
				_tmp43_ = _base_type_list;
				_tmp44_ = _base_type_index;
				_tmp45_ = vala_list_get (_tmp43_, _tmp44_);
				base_type = (ValaDataType*) _tmp45_;
				vala_gir_writer_write_indent (self);
				_tmp46_ = self->priv->buffer;
				_tmp47_ = base_type;
				_tmp48_ = vala_object_type_get_type_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp49_ = _tmp48_;
				_tmp50_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp49_);
				_tmp51_ = _tmp50_;
				g_string_append_printf (_tmp46_, "<prerequisite name=\"%s\"/>\n", _tmp51_);
				_g_free0 (_tmp51_);
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
	}
	_tmp52_ = self->priv->hierarchy;
	_tmp53_ = iface;
	vala_list_insert ((ValaList*) _tmp52_, 0, (ValaSymbol*) _tmp53_);
	_tmp54_ = iface;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp54_, (ValaCodeVisitor*) self);
	_tmp55_ = self->priv->hierarchy;
	vala_list_remove_at ((ValaList*) _tmp55_, 0);
	_tmp56_ = self->priv->indent;
	self->priv->indent = _tmp56_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp57_ = self->priv->buffer;
	g_string_append_printf (_tmp57_, "</interface>\n");
	vala_gir_writer_write_indent (self);
	_tmp58_ = self->priv->buffer;
	_tmp59_ = gtype_struct_name;
	g_string_append_printf (_tmp58_, "<record name=\"%s\"", _tmp59_);
	_tmp60_ = iface;
	vala_gir_writer_write_ctype_attributes (self, (ValaTypeSymbol*) _tmp60_, "Iface");
	_tmp61_ = self->priv->buffer;
	_tmp62_ = iface;
	_tmp63_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) _tmp62_);
	_tmp64_ = _tmp63_;
	g_string_append_printf (_tmp61_, " glib:is-gtype-struct-for=\"%s\"", _tmp64_);
	_g_free0 (_tmp64_);
	_tmp65_ = self->priv->buffer;
	g_string_append_printf (_tmp65_, ">\n");
	_tmp66_ = self->priv->indent;
	self->priv->indent = _tmp66_ + 1;
	vala_gir_writer_write_indent (self);
	_tmp67_ = self->priv->buffer;
	g_string_append_printf (_tmp67_, "<field name=\"parent_iface\">\n");
	_tmp68_ = self->priv->indent;
	self->priv->indent = _tmp68_ + 1;
	vala_gir_writer_write_indent (self);
	_tmp69_ = self->priv->buffer;
	_tmp70_ = self->priv->gtypeinterface_type;
	_tmp71_ = vala_gir_writer_gi_type_name (self, _tmp70_);
	_tmp72_ = _tmp71_;
	_tmp73_ = self->priv->gtypeinterface_type;
	_tmp74_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp73_);
	_tmp75_ = _tmp74_;
	g_string_append_printf (_tmp69_, "<type name=\"%s\" c:type=\"%s\"/>\n", _tmp72_, _tmp75_);
	_g_free0 (_tmp75_);
	_g_free0 (_tmp72_);
	_tmp76_ = self->priv->indent;
	self->priv->indent = _tmp76_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp77_ = self->priv->buffer;
	g_string_append_printf (_tmp77_, "</field>\n");
	{
		ValaList* _m_list = NULL;
		ValaInterface* _tmp78_;
		ValaList* _tmp79_;
		gint _m_size = 0;
		ValaList* _tmp80_;
		gint _tmp81_;
		gint _tmp82_;
		gint _m_index = 0;
		_tmp78_ = iface;
		_tmp79_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp78_);
		_m_list = _tmp79_;
		_tmp80_ = _m_list;
		_tmp81_ = vala_collection_get_size ((ValaCollection*) _tmp80_);
		_tmp82_ = _tmp81_;
		_m_size = _tmp82_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp83_;
			gint _tmp84_;
			gint _tmp85_;
			ValaMethod* m = NULL;
			ValaList* _tmp86_;
			gint _tmp87_;
			gpointer _tmp88_;
			gboolean _tmp89_ = FALSE;
			ValaMethod* _tmp90_;
			gboolean _tmp91_;
			gboolean _tmp92_;
			_tmp83_ = _m_index;
			_m_index = _tmp83_ + 1;
			_tmp84_ = _m_index;
			_tmp85_ = _m_size;
			if (!(_tmp84_ < _tmp85_)) {
				break;
			}
			_tmp86_ = _m_list;
			_tmp87_ = _m_index;
			_tmp88_ = vala_list_get (_tmp86_, _tmp87_);
			m = (ValaMethod*) _tmp88_;
			_tmp90_ = m;
			_tmp91_ = vala_method_get_is_abstract (_tmp90_);
			_tmp92_ = _tmp91_;
			if (_tmp92_) {
				_tmp89_ = TRUE;
			} else {
				ValaMethod* _tmp93_;
				gboolean _tmp94_;
				gboolean _tmp95_;
				_tmp93_ = m;
				_tmp94_ = vala_method_get_is_virtual (_tmp93_);
				_tmp95_ = _tmp94_;
				_tmp89_ = _tmp95_;
			}
			if (_tmp89_) {
				ValaMethod* _tmp96_;
				gboolean _tmp97_;
				gboolean _tmp98_;
				_tmp96_ = m;
				_tmp97_ = vala_method_get_coroutine (_tmp96_);
				_tmp98_ = _tmp97_;
				if (_tmp98_) {
					gchar* finish_name = NULL;
					ValaMethod* _tmp99_;
					const gchar* _tmp100_;
					const gchar* _tmp101_;
					gchar* _tmp102_;
					const gchar* _tmp103_;
					gboolean _tmp104_;
					const gchar* _tmp112_;
					gchar* _tmp113_;
					GString* _tmp114_;
					ValaMethod* _tmp115_;
					const gchar* _tmp116_;
					const gchar* _tmp117_;
					gint _tmp118_;
					ValaMethod* _tmp119_;
					ValaMethod* _tmp120_;
					const gchar* _tmp121_;
					const gchar* _tmp122_;
					ValaMethod* _tmp123_;
					gchar* _tmp124_;
					gchar* _tmp125_;
					ValaMethod* _tmp126_;
					ValaList* _tmp127_;
					ValaList* _tmp128_;
					ValaVoidType* _tmp129_;
					ValaVoidType* _tmp130_;
					gint _tmp131_;
					GString* _tmp132_;
					GString* _tmp133_;
					const gchar* _tmp134_;
					gint _tmp135_;
					ValaMethod* _tmp136_;
					const gchar* _tmp137_;
					ValaMethod* _tmp138_;
					gchar* _tmp139_;
					gchar* _tmp140_;
					ValaMethod* _tmp141_;
					ValaList* _tmp142_;
					ValaList* _tmp143_;
					ValaMethod* _tmp144_;
					ValaDataType* _tmp145_;
					ValaDataType* _tmp146_;
					ValaMethod* _tmp147_;
					gboolean _tmp148_;
					gboolean _tmp149_;
					gint _tmp150_;
					GString* _tmp151_;
					_tmp99_ = m;
					_tmp100_ = vala_symbol_get_name ((ValaSymbol*) _tmp99_);
					_tmp101_ = _tmp100_;
					_tmp102_ = g_strdup (_tmp101_);
					finish_name = _tmp102_;
					_tmp103_ = finish_name;
					_tmp104_ = g_str_has_suffix (_tmp103_, "_async");
					if (_tmp104_) {
						const gchar* _tmp105_;
						const gchar* _tmp106_;
						gint _tmp107_;
						gint _tmp108_;
						gint _tmp109_;
						gint _tmp110_;
						gchar* _tmp111_;
						_tmp105_ = finish_name;
						_tmp106_ = finish_name;
						_tmp107_ = strlen (_tmp106_);
						_tmp108_ = _tmp107_;
						_tmp109_ = strlen ("_async");
						_tmp110_ = _tmp109_;
						_tmp111_ = string_substring (_tmp105_, (glong) 0, (glong) (_tmp108_ - _tmp110_));
						_g_free0 (finish_name);
						finish_name = _tmp111_;
					}
					_tmp112_ = finish_name;
					_tmp113_ = g_strconcat (_tmp112_, "_finish", NULL);
					_g_free0 (finish_name);
					finish_name = _tmp113_;
					vala_gir_writer_write_indent (self);
					_tmp114_ = self->priv->buffer;
					_tmp115_ = m;
					_tmp116_ = vala_symbol_get_name ((ValaSymbol*) _tmp115_);
					_tmp117_ = _tmp116_;
					g_string_append_printf (_tmp114_, "<field name=\"%s\">\n", _tmp117_);
					_tmp118_ = self->priv->indent;
					self->priv->indent = _tmp118_ + 1;
					_tmp119_ = m;
					_tmp120_ = m;
					_tmp121_ = vala_symbol_get_name ((ValaSymbol*) _tmp120_);
					_tmp122_ = _tmp121_;
					_tmp123_ = m;
					_tmp124_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp123_);
					_tmp125_ = _tmp124_;
					_tmp126_ = m;
					_tmp127_ = vala_method_get_async_begin_parameters (_tmp126_);
					_tmp128_ = _tmp127_;
					_tmp129_ = vala_void_type_new (NULL);
					_tmp130_ = _tmp129_;
					vala_gir_writer_do_write_signature (self, _tmp119_, "callback", TRUE, _tmp122_, _tmp125_, _tmp128_, (ValaDataType*) _tmp130_, FALSE, FALSE);
					_vala_code_node_unref0 (_tmp130_);
					_vala_iterable_unref0 (_tmp128_);
					_g_free0 (_tmp125_);
					_tmp131_ = self->priv->indent;
					self->priv->indent = _tmp131_ - 1;
					vala_gir_writer_write_indent (self);
					_tmp132_ = self->priv->buffer;
					g_string_append_printf (_tmp132_, "</field>\n");
					vala_gir_writer_write_indent (self);
					_tmp133_ = self->priv->buffer;
					_tmp134_ = finish_name;
					g_string_append_printf (_tmp133_, "<field name=\"%s\">\n", _tmp134_);
					_tmp135_ = self->priv->indent;
					self->priv->indent = _tmp135_ + 1;
					_tmp136_ = m;
					_tmp137_ = finish_name;
					_tmp138_ = m;
					_tmp139_ = vala_ccode_base_module_get_ccode_finish_name (_tmp138_);
					_tmp140_ = _tmp139_;
					_tmp141_ = m;
					_tmp142_ = vala_method_get_async_end_parameters (_tmp141_);
					_tmp143_ = _tmp142_;
					_tmp144_ = m;
					_tmp145_ = vala_callable_get_return_type ((ValaCallable*) _tmp144_);
					_tmp146_ = _tmp145_;
					_tmp147_ = m;
					_tmp148_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp147_);
					_tmp149_ = _tmp148_;
					vala_gir_writer_do_write_signature (self, _tmp136_, "callback", TRUE, _tmp137_, _tmp140_, _tmp143_, _tmp146_, _tmp149_, FALSE);
					_vala_iterable_unref0 (_tmp143_);
					_g_free0 (_tmp140_);
					_tmp150_ = self->priv->indent;
					self->priv->indent = _tmp150_ - 1;
					vala_gir_writer_write_indent (self);
					_tmp151_ = self->priv->buffer;
					g_string_append_printf (_tmp151_, "</field>\n");
					_g_free0 (finish_name);
				} else {
					GString* _tmp152_;
					ValaMethod* _tmp153_;
					const gchar* _tmp154_;
					const gchar* _tmp155_;
					gint _tmp156_;
					ValaMethod* _tmp157_;
					ValaMethod* _tmp158_;
					const gchar* _tmp159_;
					const gchar* _tmp160_;
					ValaMethod* _tmp161_;
					gchar* _tmp162_;
					gchar* _tmp163_;
					ValaMethod* _tmp164_;
					ValaList* _tmp165_;
					ValaList* _tmp166_;
					ValaMethod* _tmp167_;
					ValaDataType* _tmp168_;
					ValaDataType* _tmp169_;
					ValaMethod* _tmp170_;
					gboolean _tmp171_;
					gboolean _tmp172_;
					gint _tmp173_;
					GString* _tmp174_;
					vala_gir_writer_write_indent (self);
					_tmp152_ = self->priv->buffer;
					_tmp153_ = m;
					_tmp154_ = vala_symbol_get_name ((ValaSymbol*) _tmp153_);
					_tmp155_ = _tmp154_;
					g_string_append_printf (_tmp152_, "<field name=\"%s\">\n", _tmp155_);
					_tmp156_ = self->priv->indent;
					self->priv->indent = _tmp156_ + 1;
					_tmp157_ = m;
					_tmp158_ = m;
					_tmp159_ = vala_symbol_get_name ((ValaSymbol*) _tmp158_);
					_tmp160_ = _tmp159_;
					_tmp161_ = m;
					_tmp162_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp161_);
					_tmp163_ = _tmp162_;
					_tmp164_ = m;
					_tmp165_ = vala_callable_get_parameters ((ValaCallable*) _tmp164_);
					_tmp166_ = _tmp165_;
					_tmp167_ = m;
					_tmp168_ = vala_callable_get_return_type ((ValaCallable*) _tmp167_);
					_tmp169_ = _tmp168_;
					_tmp170_ = m;
					_tmp171_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp170_);
					_tmp172_ = _tmp171_;
					vala_gir_writer_do_write_signature (self, _tmp157_, "callback", TRUE, _tmp160_, _tmp163_, _tmp166_, _tmp169_, _tmp172_, FALSE);
					_vala_iterable_unref0 (_tmp166_);
					_g_free0 (_tmp163_);
					_tmp173_ = self->priv->indent;
					self->priv->indent = _tmp173_ - 1;
					vala_gir_writer_write_indent (self);
					_tmp174_ = self->priv->buffer;
					g_string_append_printf (_tmp174_, "</field>\n");
				}
			}
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaInterface* _tmp175_;
		ValaList* _tmp176_;
		gint _prop_size = 0;
		ValaList* _tmp177_;
		gint _tmp178_;
		gint _tmp179_;
		gint _prop_index = 0;
		_tmp175_ = iface;
		_tmp176_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp175_);
		_prop_list = _tmp176_;
		_tmp177_ = _prop_list;
		_tmp178_ = vala_collection_get_size ((ValaCollection*) _tmp177_);
		_tmp179_ = _tmp178_;
		_prop_size = _tmp179_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp180_;
			gint _tmp181_;
			gint _tmp182_;
			ValaProperty* prop = NULL;
			ValaList* _tmp183_;
			gint _tmp184_;
			gpointer _tmp185_;
			gboolean _tmp186_ = FALSE;
			ValaProperty* _tmp187_;
			gboolean _tmp188_;
			gboolean _tmp189_;
			_tmp180_ = _prop_index;
			_prop_index = _tmp180_ + 1;
			_tmp181_ = _prop_index;
			_tmp182_ = _prop_size;
			if (!(_tmp181_ < _tmp182_)) {
				break;
			}
			_tmp183_ = _prop_list;
			_tmp184_ = _prop_index;
			_tmp185_ = vala_list_get (_tmp183_, _tmp184_);
			prop = (ValaProperty*) _tmp185_;
			_tmp187_ = prop;
			_tmp188_ = vala_property_get_is_abstract (_tmp187_);
			_tmp189_ = _tmp188_;
			if (_tmp189_) {
				_tmp186_ = TRUE;
			} else {
				ValaProperty* _tmp190_;
				gboolean _tmp191_;
				gboolean _tmp192_;
				_tmp190_ = prop;
				_tmp191_ = vala_property_get_is_virtual (_tmp190_);
				_tmp192_ = _tmp191_;
				_tmp186_ = _tmp192_;
			}
			if (_tmp186_) {
				ValaProperty* _tmp193_;
				ValaPropertyAccessor* _tmp194_;
				ValaPropertyAccessor* _tmp195_;
				gboolean _tmp223_ = FALSE;
				ValaProperty* _tmp224_;
				ValaPropertyAccessor* _tmp225_;
				ValaPropertyAccessor* _tmp226_;
				_tmp193_ = prop;
				_tmp194_ = vala_property_get_get_accessor (_tmp193_);
				_tmp195_ = _tmp194_;
				if (_tmp195_ != NULL) {
					ValaMethod* m = NULL;
					ValaProperty* _tmp196_;
					ValaPropertyAccessor* _tmp197_;
					ValaPropertyAccessor* _tmp198_;
					ValaMethod* _tmp199_;
					GString* _tmp200_;
					ValaMethod* _tmp201_;
					const gchar* _tmp202_;
					const gchar* _tmp203_;
					gint _tmp204_;
					ValaMethod* _tmp205_;
					ValaMethod* _tmp206_;
					const gchar* _tmp207_;
					const gchar* _tmp208_;
					ValaMethod* _tmp209_;
					gchar* _tmp210_;
					gchar* _tmp211_;
					ValaMethod* _tmp212_;
					ValaList* _tmp213_;
					ValaList* _tmp214_;
					ValaMethod* _tmp215_;
					ValaDataType* _tmp216_;
					ValaDataType* _tmp217_;
					ValaMethod* _tmp218_;
					gboolean _tmp219_;
					gboolean _tmp220_;
					gint _tmp221_;
					GString* _tmp222_;
					_tmp196_ = prop;
					_tmp197_ = vala_property_get_get_accessor (_tmp196_);
					_tmp198_ = _tmp197_;
					_tmp199_ = vala_property_accessor_get_method (_tmp198_);
					m = _tmp199_;
					vala_gir_writer_write_indent (self);
					_tmp200_ = self->priv->buffer;
					_tmp201_ = m;
					_tmp202_ = vala_symbol_get_name ((ValaSymbol*) _tmp201_);
					_tmp203_ = _tmp202_;
					g_string_append_printf (_tmp200_, "<field name=\"%s\">\n", _tmp203_);
					_tmp204_ = self->priv->indent;
					self->priv->indent = _tmp204_ + 1;
					_tmp205_ = m;
					_tmp206_ = m;
					_tmp207_ = vala_symbol_get_name ((ValaSymbol*) _tmp206_);
					_tmp208_ = _tmp207_;
					_tmp209_ = m;
					_tmp210_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp209_);
					_tmp211_ = _tmp210_;
					_tmp212_ = m;
					_tmp213_ = vala_callable_get_parameters ((ValaCallable*) _tmp212_);
					_tmp214_ = _tmp213_;
					_tmp215_ = m;
					_tmp216_ = vala_callable_get_return_type ((ValaCallable*) _tmp215_);
					_tmp217_ = _tmp216_;
					_tmp218_ = m;
					_tmp219_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp218_);
					_tmp220_ = _tmp219_;
					vala_gir_writer_do_write_signature (self, _tmp205_, "callback", TRUE, _tmp208_, _tmp211_, _tmp214_, _tmp217_, _tmp220_, FALSE);
					_vala_iterable_unref0 (_tmp214_);
					_g_free0 (_tmp211_);
					_tmp221_ = self->priv->indent;
					self->priv->indent = _tmp221_ - 1;
					vala_gir_writer_write_indent (self);
					_tmp222_ = self->priv->buffer;
					g_string_append_printf (_tmp222_, "</field>\n");
					_vala_code_node_unref0 (m);
				}
				_tmp224_ = prop;
				_tmp225_ = vala_property_get_set_accessor (_tmp224_);
				_tmp226_ = _tmp225_;
				if (_tmp226_ != NULL) {
					ValaProperty* _tmp227_;
					ValaPropertyAccessor* _tmp228_;
					ValaPropertyAccessor* _tmp229_;
					gboolean _tmp230_;
					gboolean _tmp231_;
					_tmp227_ = prop;
					_tmp228_ = vala_property_get_set_accessor (_tmp227_);
					_tmp229_ = _tmp228_;
					_tmp230_ = vala_property_accessor_get_writable (_tmp229_);
					_tmp231_ = _tmp230_;
					_tmp223_ = _tmp231_;
				} else {
					_tmp223_ = FALSE;
				}
				if (_tmp223_) {
					ValaMethod* m = NULL;
					ValaProperty* _tmp232_;
					ValaPropertyAccessor* _tmp233_;
					ValaPropertyAccessor* _tmp234_;
					ValaMethod* _tmp235_;
					GString* _tmp236_;
					ValaMethod* _tmp237_;
					const gchar* _tmp238_;
					const gchar* _tmp239_;
					gint _tmp240_;
					ValaMethod* _tmp241_;
					ValaMethod* _tmp242_;
					const gchar* _tmp243_;
					const gchar* _tmp244_;
					ValaMethod* _tmp245_;
					gchar* _tmp246_;
					gchar* _tmp247_;
					ValaMethod* _tmp248_;
					ValaList* _tmp249_;
					ValaList* _tmp250_;
					ValaMethod* _tmp251_;
					ValaDataType* _tmp252_;
					ValaDataType* _tmp253_;
					ValaMethod* _tmp254_;
					gboolean _tmp255_;
					gboolean _tmp256_;
					gint _tmp257_;
					GString* _tmp258_;
					_tmp232_ = prop;
					_tmp233_ = vala_property_get_set_accessor (_tmp232_);
					_tmp234_ = _tmp233_;
					_tmp235_ = vala_property_accessor_get_method (_tmp234_);
					m = _tmp235_;
					vala_gir_writer_write_indent (self);
					_tmp236_ = self->priv->buffer;
					_tmp237_ = m;
					_tmp238_ = vala_symbol_get_name ((ValaSymbol*) _tmp237_);
					_tmp239_ = _tmp238_;
					g_string_append_printf (_tmp236_, "<field name=\"%s\">\n", _tmp239_);
					_tmp240_ = self->priv->indent;
					self->priv->indent = _tmp240_ + 1;
					_tmp241_ = m;
					_tmp242_ = m;
					_tmp243_ = vala_symbol_get_name ((ValaSymbol*) _tmp242_);
					_tmp244_ = _tmp243_;
					_tmp245_ = m;
					_tmp246_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp245_);
					_tmp247_ = _tmp246_;
					_tmp248_ = m;
					_tmp249_ = vala_callable_get_parameters ((ValaCallable*) _tmp248_);
					_tmp250_ = _tmp249_;
					_tmp251_ = m;
					_tmp252_ = vala_callable_get_return_type ((ValaCallable*) _tmp251_);
					_tmp253_ = _tmp252_;
					_tmp254_ = m;
					_tmp255_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp254_);
					_tmp256_ = _tmp255_;
					vala_gir_writer_do_write_signature (self, _tmp241_, "callback", TRUE, _tmp244_, _tmp247_, _tmp250_, _tmp253_, _tmp256_, FALSE);
					_vala_iterable_unref0 (_tmp250_);
					_g_free0 (_tmp247_);
					_tmp257_ = self->priv->indent;
					self->priv->indent = _tmp257_ - 1;
					vala_gir_writer_write_indent (self);
					_tmp258_ = self->priv->buffer;
					g_string_append_printf (_tmp258_, "</field>\n");
					_vala_code_node_unref0 (m);
				}
			}
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	_tmp259_ = self->priv->indent;
	self->priv->indent = _tmp259_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp260_ = self->priv->buffer;
	g_string_append_printf (_tmp260_, "</record>\n");
	vala_gir_writer_visit_deferred (self);
	_g_free0 (gtype_struct_name);
}


static void vala_gir_writer_visit_deferred (ValaGIRWriter* self) {
	ValaArrayList* nodes = NULL;
	ValaArrayList* _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->deferred;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	nodes = _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_CODE_NODE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	_vala_iterable_unref0 (self->priv->deferred);
	self->priv->deferred = _tmp3_;
	{
		ValaArrayList* _node_list = NULL;
		ValaArrayList* _tmp4_;
		ValaArrayList* _tmp5_;
		gint _node_size = 0;
		ValaArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _node_index = 0;
		_tmp4_ = nodes;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_node_list = _tmp5_;
		_tmp6_ = _node_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_node_size = _tmp8_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			ValaCodeNode* node = NULL;
			ValaArrayList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_;
			ValaCodeNode* _tmp15_;
			_tmp9_ = _node_index;
			_node_index = _tmp9_ + 1;
			_tmp10_ = _node_index;
			_tmp11_ = _node_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _node_list;
			_tmp13_ = _node_index;
			_tmp14_ = vala_list_get ((ValaList*) _tmp12_, _tmp13_);
			node = (ValaCodeNode*) _tmp14_;
			_tmp15_ = node;
			vala_code_node_accept (_tmp15_, (ValaCodeVisitor*) self);
			_vala_code_node_unref0 (node);
		}
		_vala_iterable_unref0 (_node_list);
	}
	_vala_iterable_unref0 (nodes);
}


static gchar* vala_gir_writer_get_gir_name (ValaGIRWriter* self, ValaSymbol* symbol) {
	gchar* result = NULL;
	gchar* gir_name = NULL;
	ValaSymbol* h0 = NULL;
	ValaArrayList* _tmp0_;
	gpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	gir_name = NULL;
	_tmp0_ = self->priv->hierarchy;
	_tmp1_ = vala_list_get ((ValaList*) _tmp0_, 0);
	h0 = (ValaSymbol*) _tmp1_;
	{
		ValaSymbol* cur_sym = NULL;
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		_tmp2_ = symbol;
		_tmp3_ = _vala_code_node_ref0 (_tmp2_);
		cur_sym = _tmp3_;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				ValaSymbol* _tmp9_;
				ValaSymbol* _tmp10_;
				ValaSymbol* _tmp11_;
				gchar* cur_name = NULL;
				ValaSymbol* _tmp12_;
				gchar* _tmp13_;
				const gchar* _tmp14_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				gchar* _tmp21_;
				if (!_tmp4_) {
					ValaSymbol* _tmp5_;
					ValaSymbol* _tmp6_;
					ValaSymbol* _tmp7_;
					ValaSymbol* _tmp8_;
					_tmp5_ = cur_sym;
					_tmp6_ = vala_symbol_get_parent_symbol (_tmp5_);
					_tmp7_ = _tmp6_;
					_tmp8_ = _vala_code_node_ref0 (_tmp7_);
					_vala_code_node_unref0 (cur_sym);
					cur_sym = _tmp8_;
				}
				_tmp4_ = FALSE;
				_tmp9_ = cur_sym;
				if (!(_tmp9_ != NULL)) {
					break;
				}
				_tmp10_ = cur_sym;
				_tmp11_ = h0;
				if (_tmp10_ == _tmp11_) {
					break;
				}
				_tmp12_ = cur_sym;
				_tmp13_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp12_, "GIR", "name", NULL);
				cur_name = _tmp13_;
				_tmp14_ = cur_name;
				if (_tmp14_ == NULL) {
					ValaSymbol* _tmp15_;
					const gchar* _tmp16_;
					const gchar* _tmp17_;
					gchar* _tmp18_;
					_tmp15_ = cur_sym;
					_tmp16_ = vala_symbol_get_name (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = g_strdup (_tmp17_);
					_g_free0 (cur_name);
					cur_name = _tmp18_;
				}
				_tmp19_ = cur_name;
				_tmp20_ = gir_name;
				_tmp21_ = g_strconcat (_tmp19_, _tmp20_, NULL);
				_g_free0 (gir_name);
				gir_name = _tmp21_;
				_g_free0 (cur_name);
			}
		}
		_vala_code_node_unref0 (cur_sym);
	}
	result = gir_name;
	_vala_code_node_unref0 (h0);
	return result;
}


static void vala_gir_writer_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en) {
	ValaGIRWriter * self;
	ValaEnum* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaEnum* _tmp3_;
	gboolean _tmp4_;
	ValaArrayList* _tmp5_;
	gpointer _tmp6_;
	ValaSymbol* _tmp7_;
	gboolean _tmp8_;
	const gchar* _tmp11_ = NULL;
	ValaEnum* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	gchar* element_name = NULL;
	gchar* _tmp15_;
	GString* _tmp16_;
	const gchar* _tmp17_;
	ValaEnum* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	ValaEnum* _tmp21_;
	gboolean _tmp22_;
	ValaEnum* _tmp25_;
	GString* _tmp26_;
	gint _tmp27_;
	ValaEnum* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	ValaArrayList* _tmp31_;
	ValaEnum* _tmp32_;
	ValaEnum* _tmp33_;
	ValaArrayList* _tmp34_;
	gint _tmp35_;
	GString* _tmp36_;
	const gchar* _tmp37_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (en != NULL);
	_tmp0_ = en;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = en;
	_tmp4_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp3_);
	if (!_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->hierarchy;
	_tmp6_ = vala_list_get ((ValaList*) _tmp5_, 0);
	_tmp7_ = (ValaSymbol*) _tmp6_;
	_tmp8_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_NAMESPACE);
	_vala_code_node_unref0 (_tmp7_);
	if (_tmp8_) {
		ValaArrayList* _tmp9_;
		ValaEnum* _tmp10_;
		_tmp9_ = self->priv->deferred;
		_tmp10_ = en;
		vala_collection_add ((ValaCollection*) _tmp9_, (ValaCodeNode*) _tmp10_);
		return;
	}
	_tmp12_ = en;
	_tmp13_ = vala_enum_get_is_flags (_tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp14_) {
		_tmp11_ = "bitfield";
	} else {
		_tmp11_ = "enumeration";
	}
	_tmp15_ = g_strdup (_tmp11_);
	element_name = _tmp15_;
	vala_gir_writer_write_indent (self);
	_tmp16_ = self->priv->buffer;
	_tmp17_ = element_name;
	_tmp18_ = en;
	_tmp19_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) _tmp18_);
	_tmp20_ = _tmp19_;
	g_string_append_printf (_tmp16_, "<%s name=\"%s\"", _tmp17_, _tmp20_);
	_g_free0 (_tmp20_);
	_tmp21_ = en;
	_tmp22_ = vala_ccode_base_module_get_ccode_has_type_id ((ValaTypeSymbol*) _tmp21_);
	if (_tmp22_) {
		ValaEnum* _tmp23_;
		_tmp23_ = en;
		vala_gir_writer_write_gtype_attributes (self, (ValaTypeSymbol*) _tmp23_);
	} else {
		ValaEnum* _tmp24_;
		_tmp24_ = en;
		vala_gir_writer_write_ctype_attributes (self, (ValaTypeSymbol*) _tmp24_, "");
	}
	_tmp25_ = en;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp25_);
	_tmp26_ = self->priv->buffer;
	g_string_append_printf (_tmp26_, ">\n");
	_tmp27_ = self->priv->indent;
	self->priv->indent = _tmp27_ + 1;
	_tmp28_ = en;
	_tmp29_ = vala_gir_writer_get_enum_comment (self, _tmp28_);
	_tmp30_ = _tmp29_;
	vala_gir_writer_write_doc (self, _tmp30_);
	_g_free0 (_tmp30_);
	self->priv->enum_value = 0;
	_tmp31_ = self->priv->hierarchy;
	_tmp32_ = en;
	vala_list_insert ((ValaList*) _tmp31_, 0, (ValaSymbol*) _tmp32_);
	_tmp33_ = en;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp33_, (ValaCodeVisitor*) self);
	_tmp34_ = self->priv->hierarchy;
	vala_list_remove_at ((ValaList*) _tmp34_, 0);
	_tmp35_ = self->priv->indent;
	self->priv->indent = _tmp35_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp36_ = self->priv->buffer;
	_tmp37_ = element_name;
	g_string_append_printf (_tmp36_, "</%s>\n", _tmp37_);
	vala_gir_writer_visit_deferred (self);
	_g_free0 (element_name);
}


static void vala_gir_writer_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev) {
	ValaGIRWriter * self;
	ValaEnum* en = NULL;
	ValaArrayList* _tmp0_;
	gpointer _tmp1_;
	GString* _tmp2_;
	ValaEnumValue* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	ValaEnumValue* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaEnumValue* _tmp11_;
	ValaExpression* _tmp12_;
	ValaExpression* _tmp13_;
	ValaEnumValue* _tmp27_;
	gchar* comment = NULL;
	ValaEnumValue* _tmp28_;
	gchar* _tmp29_;
	const gchar* _tmp30_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (ev != NULL);
	vala_gir_writer_write_indent (self);
	_tmp0_ = self->priv->hierarchy;
	_tmp1_ = vala_list_get ((ValaList*) _tmp0_, 0);
	en = G_TYPE_CHECK_INSTANCE_CAST ((ValaSymbol*) _tmp1_, VALA_TYPE_ENUM, ValaEnum);
	_tmp2_ = self->priv->buffer;
	_tmp3_ = ev;
	_tmp4_ = vala_symbol_get_name ((ValaSymbol*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_utf8_strdown (_tmp5_, (gssize) -1);
	_tmp7_ = _tmp6_;
	_tmp8_ = ev;
	_tmp9_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp8_);
	_tmp10_ = _tmp9_;
	g_string_append_printf (_tmp2_, "<member name=\"%s\" c:identifier=\"%s\"", _tmp7_, _tmp10_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp7_);
	_tmp11_ = ev;
	_tmp12_ = vala_constant_get_value ((ValaConstant*) _tmp11_);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		gchar* value = NULL;
		ValaEnumValue* _tmp14_;
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		gchar* _tmp17_;
		GString* _tmp18_;
		const gchar* _tmp19_;
		_tmp14_ = ev;
		_tmp15_ = vala_constant_get_value ((ValaConstant*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_gir_writer_literal_expression_to_value_string (self, _tmp16_);
		value = _tmp17_;
		_tmp18_ = self->priv->buffer;
		_tmp19_ = value;
		g_string_append_printf (_tmp18_, " value=\"%s\"", _tmp19_);
		_g_free0 (value);
	} else {
		ValaEnum* _tmp20_;
		gboolean _tmp21_;
		gboolean _tmp22_;
		_tmp20_ = en;
		_tmp21_ = vala_enum_get_is_flags (_tmp20_);
		_tmp22_ = _tmp21_;
		if (_tmp22_) {
			GString* _tmp23_;
			gint _tmp24_;
			_tmp23_ = self->priv->buffer;
			_tmp24_ = self->priv->enum_value;
			self->priv->enum_value = _tmp24_ + 1;
			g_string_append_printf (_tmp23_, " value=\"%d\"", 1 << _tmp24_);
		} else {
			GString* _tmp25_;
			gint _tmp26_;
			_tmp25_ = self->priv->buffer;
			_tmp26_ = self->priv->enum_value;
			self->priv->enum_value = _tmp26_ + 1;
			g_string_append_printf (_tmp25_, " value=\"%d\"", _tmp26_);
		}
	}
	_tmp27_ = ev;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp27_);
	_tmp28_ = ev;
	_tmp29_ = vala_gir_writer_get_enum_value_comment (self, _tmp28_);
	comment = _tmp29_;
	_tmp30_ = comment;
	if (_tmp30_ == NULL) {
		GString* _tmp31_;
		_tmp31_ = self->priv->buffer;
		g_string_append_printf (_tmp31_, "/>\n");
	} else {
		GString* _tmp32_;
		gint _tmp33_;
		const gchar* _tmp34_;
		gint _tmp35_;
		GString* _tmp36_;
		_tmp32_ = self->priv->buffer;
		g_string_append_printf (_tmp32_, ">\n");
		_tmp33_ = self->priv->indent;
		self->priv->indent = _tmp33_ + 1;
		_tmp34_ = comment;
		vala_gir_writer_write_doc (self, _tmp34_);
		_tmp35_ = self->priv->indent;
		self->priv->indent = _tmp35_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp36_ = self->priv->buffer;
		g_string_append_printf (_tmp36_, "</member>\n");
	}
	_g_free0 (comment);
	_vala_code_node_unref0 (en);
}


static void vala_gir_writer_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* edomain) {
	ValaGIRWriter * self;
	ValaErrorDomain* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaErrorDomain* _tmp3_;
	gboolean _tmp4_;
	GString* _tmp5_;
	ValaErrorDomain* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	ValaErrorDomain* _tmp9_;
	GString* _tmp10_;
	ValaErrorDomain* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	ValaErrorDomain* _tmp14_;
	GString* _tmp15_;
	gint _tmp16_;
	ValaErrorDomain* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	ValaArrayList* _tmp20_;
	ValaErrorDomain* _tmp21_;
	ValaErrorDomain* _tmp22_;
	ValaArrayList* _tmp23_;
	gint _tmp24_;
	GString* _tmp25_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (edomain != NULL);
	_tmp0_ = edomain;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = edomain;
	_tmp4_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp3_);
	if (!_tmp4_) {
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp5_ = self->priv->buffer;
	_tmp6_ = edomain;
	_tmp7_ = vala_symbol_get_name ((ValaSymbol*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append_printf (_tmp5_, "<enumeration name=\"%s\"", _tmp8_);
	_tmp9_ = edomain;
	vala_gir_writer_write_ctype_attributes (self, (ValaTypeSymbol*) _tmp9_, "");
	_tmp10_ = self->priv->buffer;
	_tmp11_ = edomain;
	_tmp12_ = vala_ccode_base_module_get_quark_name (_tmp11_);
	_tmp13_ = _tmp12_;
	g_string_append_printf (_tmp10_, " glib:error-domain=\"%s\"", _tmp13_);
	_g_free0 (_tmp13_);
	_tmp14_ = edomain;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp14_);
	_tmp15_ = self->priv->buffer;
	g_string_append_printf (_tmp15_, ">\n");
	_tmp16_ = self->priv->indent;
	self->priv->indent = _tmp16_ + 1;
	_tmp17_ = edomain;
	_tmp18_ = vala_gir_writer_get_error_domain_comment (self, _tmp17_);
	_tmp19_ = _tmp18_;
	vala_gir_writer_write_doc (self, _tmp19_);
	_g_free0 (_tmp19_);
	self->priv->enum_value = 0;
	_tmp20_ = self->priv->hierarchy;
	_tmp21_ = edomain;
	vala_list_insert ((ValaList*) _tmp20_, 0, (ValaSymbol*) _tmp21_);
	_tmp22_ = edomain;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp22_, (ValaCodeVisitor*) self);
	_tmp23_ = self->priv->hierarchy;
	vala_list_remove_at ((ValaList*) _tmp23_, 0);
	_tmp24_ = self->priv->indent;
	self->priv->indent = _tmp24_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp25_ = self->priv->buffer;
	g_string_append_printf (_tmp25_, "</enumeration>\n");
	vala_gir_writer_visit_deferred (self);
}


static void vala_gir_writer_real_visit_error_code (ValaCodeVisitor* base, ValaErrorCode* ecode) {
	ValaGIRWriter * self;
	GString* _tmp0_;
	ValaErrorCode* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	ValaErrorCode* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	ValaErrorCode* _tmp9_;
	ValaExpression* _tmp10_;
	ValaExpression* _tmp11_;
	ValaErrorCode* _tmp20_;
	gchar* comment = NULL;
	ValaErrorCode* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (ecode != NULL);
	vala_gir_writer_write_indent (self);
	_tmp0_ = self->priv->buffer;
	_tmp1_ = ecode;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_utf8_strdown (_tmp3_, (gssize) -1);
	_tmp5_ = _tmp4_;
	_tmp6_ = ecode;
	_tmp7_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append_printf (_tmp0_, "<member name=\"%s\" c:identifier=\"%s\"", _tmp5_, _tmp8_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp5_);
	_tmp9_ = ecode;
	_tmp10_ = vala_error_code_get_value (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ != NULL) {
		gchar* value = NULL;
		ValaErrorCode* _tmp12_;
		ValaExpression* _tmp13_;
		ValaExpression* _tmp14_;
		gchar* _tmp15_;
		GString* _tmp16_;
		const gchar* _tmp17_;
		_tmp12_ = ecode;
		_tmp13_ = vala_error_code_get_value (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_gir_writer_literal_expression_to_value_string (self, _tmp14_);
		value = _tmp15_;
		_tmp16_ = self->priv->buffer;
		_tmp17_ = value;
		g_string_append_printf (_tmp16_, " value=\"%s\"", _tmp17_);
		_g_free0 (value);
	} else {
		GString* _tmp18_;
		gint _tmp19_;
		_tmp18_ = self->priv->buffer;
		_tmp19_ = self->priv->enum_value;
		self->priv->enum_value = _tmp19_ + 1;
		g_string_append_printf (_tmp18_, " value=\"%d\"", _tmp19_);
	}
	_tmp20_ = ecode;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp20_);
	_tmp21_ = ecode;
	_tmp22_ = vala_gir_writer_get_error_code_comment (self, _tmp21_);
	comment = _tmp22_;
	_tmp23_ = comment;
	if (_tmp23_ == NULL) {
		GString* _tmp24_;
		_tmp24_ = self->priv->buffer;
		g_string_append_printf (_tmp24_, "/>\n");
	} else {
		GString* _tmp25_;
		gint _tmp26_;
		const gchar* _tmp27_;
		gint _tmp28_;
		GString* _tmp29_;
		_tmp25_ = self->priv->buffer;
		g_string_append_printf (_tmp25_, ">\n");
		_tmp26_ = self->priv->indent;
		self->priv->indent = _tmp26_ + 1;
		_tmp27_ = comment;
		vala_gir_writer_write_doc (self, _tmp27_);
		_tmp28_ = self->priv->indent;
		self->priv->indent = _tmp28_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp29_ = self->priv->buffer;
		g_string_append_printf (_tmp29_, "</member>\n");
	}
	_g_free0 (comment);
}


static void vala_gir_writer_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c) {
	ValaGIRWriter * self;
	ValaConstant* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaConstant* _tmp3_;
	gboolean _tmp4_;
	ValaExpression* initializer = NULL;
	ValaConstant* _tmp5_;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	gchar* value = NULL;
	ValaExpression* _tmp9_;
	gchar* _tmp10_;
	GString* _tmp11_;
	ValaConstant* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	ValaConstant* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GString* _tmp18_;
	const gchar* _tmp19_;
	ValaConstant* _tmp20_;
	GString* _tmp21_;
	gint _tmp22_;
	ValaConstant* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	ValaExpression* _tmp26_;
	ValaDataType* _tmp27_;
	ValaDataType* _tmp28_;
	gint _tmp29_;
	GString* _tmp30_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = c;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = c;
	_tmp4_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp3_);
	if (!_tmp4_) {
		return;
	}
	_tmp5_ = c;
	_tmp6_ = vala_constant_get_value (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (_tmp7_);
	initializer = _tmp8_;
	_tmp9_ = initializer;
	_tmp10_ = vala_gir_writer_literal_expression_to_value_string (self, _tmp9_);
	value = _tmp10_;
	vala_gir_writer_write_indent (self);
	_tmp11_ = self->priv->buffer;
	_tmp12_ = c;
	_tmp13_ = vala_symbol_get_name ((ValaSymbol*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = c;
	_tmp16_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp15_);
	_tmp17_ = _tmp16_;
	g_string_append_printf (_tmp11_, "<constant name=\"%s\" c:identifier=\"%s\"", _tmp14_, _tmp17_);
	_g_free0 (_tmp17_);
	_tmp18_ = self->priv->buffer;
	_tmp19_ = value;
	g_string_append_printf (_tmp18_, " value=\"%s\"", _tmp19_);
	_tmp20_ = c;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp20_);
	_tmp21_ = self->priv->buffer;
	g_string_append_printf (_tmp21_, ">\n");
	_tmp22_ = self->priv->indent;
	self->priv->indent = _tmp22_ + 1;
	_tmp23_ = c;
	_tmp24_ = vala_gir_writer_get_constant_comment (self, _tmp23_);
	_tmp25_ = _tmp24_;
	vala_gir_writer_write_doc (self, _tmp25_);
	_g_free0 (_tmp25_);
	_tmp26_ = initializer;
	_tmp27_ = vala_expression_get_value_type (_tmp26_);
	_tmp28_ = _tmp27_;
	vala_gir_writer_write_type (self, _tmp28_, -1, VALA_PARAMETER_DIRECTION_IN);
	_tmp29_ = self->priv->indent;
	self->priv->indent = _tmp29_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp30_ = self->priv->buffer;
	g_string_append_printf (_tmp30_, "</constant>\n");
	_g_free0 (value);
	_vala_code_node_unref0 (initializer);
}


static void vala_gir_writer_real_visit_field (ValaCodeVisitor* base, ValaField* f) {
	ValaGIRWriter * self;
	ValaField* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaField* _tmp3_;
	gboolean _tmp4_;
	GString* _tmp5_;
	ValaField* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	ValaField* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	ValaField* _tmp15_;
	GString* _tmp16_;
	gint _tmp17_;
	ValaField* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	ValaField* _tmp21_;
	ValaDataType* _tmp22_;
	ValaDataType* _tmp23_;
	gint _tmp24_;
	GString* _tmp25_;
	gboolean _tmp26_ = FALSE;
	ValaField* _tmp27_;
	ValaDataType* _tmp28_;
	ValaDataType* _tmp29_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (f != NULL);
	_tmp0_ = f;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = f;
	_tmp4_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp3_);
	if (!_tmp4_) {
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp5_ = self->priv->buffer;
	_tmp6_ = f;
	_tmp7_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append_printf (_tmp5_, "<field name=\"%s\"", _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = f;
	_tmp10_ = vala_variable_get_variable_type ((ValaVariable*) _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_data_type_get_nullable (_tmp11_);
	_tmp13_ = _tmp12_;
	if (_tmp13_) {
		GString* _tmp14_;
		_tmp14_ = self->priv->buffer;
		g_string_append_printf (_tmp14_, " allow-none=\"1\"");
	}
	_tmp15_ = f;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp15_);
	_tmp16_ = self->priv->buffer;
	g_string_append_printf (_tmp16_, ">\n");
	_tmp17_ = self->priv->indent;
	self->priv->indent = _tmp17_ + 1;
	_tmp18_ = f;
	_tmp19_ = vala_gir_writer_get_field_comment (self, _tmp18_);
	_tmp20_ = _tmp19_;
	vala_gir_writer_write_doc (self, _tmp20_);
	_g_free0 (_tmp20_);
	_tmp21_ = f;
	_tmp22_ = vala_variable_get_variable_type ((ValaVariable*) _tmp21_);
	_tmp23_ = _tmp22_;
	vala_gir_writer_write_type (self, _tmp23_, -1, VALA_PARAMETER_DIRECTION_IN);
	_tmp24_ = self->priv->indent;
	self->priv->indent = _tmp24_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp25_ = self->priv->buffer;
	g_string_append_printf (_tmp25_, "</field>\n");
	_tmp27_ = f;
	_tmp28_ = vala_variable_get_variable_type ((ValaVariable*) _tmp27_);
	_tmp29_ = _tmp28_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, VALA_TYPE_ARRAY_TYPE)) {
		ValaField* _tmp30_;
		gboolean _tmp31_;
		_tmp30_ = f;
		_tmp31_ = vala_ccode_base_module_get_ccode_array_length ((ValaCodeNode*) _tmp30_);
		_tmp26_ = _tmp31_;
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		ValaArrayType* array_type = NULL;
		ValaField* _tmp32_;
		ValaDataType* _tmp33_;
		ValaDataType* _tmp34_;
		ValaArrayType* _tmp35_;
		ValaArrayType* _tmp36_;
		gboolean _tmp37_;
		gboolean _tmp38_;
		_tmp32_ = f;
		_tmp33_ = vala_variable_get_variable_type ((ValaVariable*) _tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp35_;
		_tmp36_ = array_type;
		_tmp37_ = vala_array_type_get_fixed_length (_tmp36_);
		_tmp38_ = _tmp37_;
		if (!_tmp38_) {
			ValaIntegerType* int_type = NULL;
			ValaCodeContext* _tmp39_;
			ValaNamespace* _tmp40_;
			ValaNamespace* _tmp41_;
			ValaScope* _tmp42_;
			ValaScope* _tmp43_;
			ValaSymbol* _tmp44_;
			ValaStruct* _tmp45_;
			ValaStruct* _tmp46_;
			ValaIntegerType* _tmp47_;
			ValaIntegerType* _tmp48_;
			_tmp39_ = self->priv->context;
			_tmp40_ = vala_code_context_get_root (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_symbol_get_scope ((ValaSymbol*) _tmp41_);
			_tmp43_ = _tmp42_;
			_tmp44_ = vala_scope_lookup (_tmp43_, "int");
			_tmp45_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp44_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp44_) : NULL;
			if (_tmp45_ == NULL) {
				_vala_code_node_unref0 (_tmp44_);
			}
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_integer_type_new (_tmp46_, NULL, NULL);
			_tmp48_ = _tmp47_;
			_vala_code_node_unref0 (_tmp46_);
			int_type = _tmp48_;
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp49_ = FALSE;
					_tmp49_ = TRUE;
					while (TRUE) {
						gint _tmp51_;
						ValaArrayType* _tmp52_;
						gint _tmp53_;
						gint _tmp54_;
						GString* _tmp55_;
						ValaField* _tmp56_;
						gchar* _tmp57_;
						gchar* _tmp58_;
						gint _tmp59_;
						ValaField* _tmp60_;
						GString* _tmp61_;
						gint _tmp62_;
						ValaIntegerType* _tmp63_;
						gint _tmp64_;
						GString* _tmp65_;
						if (!_tmp49_) {
							gint _tmp50_;
							_tmp50_ = i;
							i = _tmp50_ + 1;
						}
						_tmp49_ = FALSE;
						_tmp51_ = i;
						_tmp52_ = array_type;
						_tmp53_ = vala_array_type_get_rank (_tmp52_);
						_tmp54_ = _tmp53_;
						if (!(_tmp51_ < _tmp54_)) {
							break;
						}
						vala_gir_writer_write_indent (self);
						_tmp55_ = self->priv->buffer;
						_tmp56_ = f;
						_tmp57_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp56_);
						_tmp58_ = _tmp57_;
						_tmp59_ = i;
						g_string_append_printf (_tmp55_, "<field name=\"%s_length%i\"", _tmp58_, _tmp59_ + 1);
						_g_free0 (_tmp58_);
						_tmp60_ = f;
						vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp60_);
						_tmp61_ = self->priv->buffer;
						g_string_append_printf (_tmp61_, ">\n");
						_tmp62_ = self->priv->indent;
						self->priv->indent = _tmp62_ + 1;
						_tmp63_ = int_type;
						vala_gir_writer_write_type (self, (ValaDataType*) _tmp63_, -1, VALA_PARAMETER_DIRECTION_IN);
						_tmp64_ = self->priv->indent;
						self->priv->indent = _tmp64_ - 1;
						vala_gir_writer_write_indent (self);
						_tmp65_ = self->priv->buffer;
						g_string_append_printf (_tmp65_, "</field>\n");
					}
				}
			}
			_vala_code_node_unref0 (int_type);
		}
		_vala_code_node_unref0 (array_type);
	} else {
		ValaField* _tmp66_;
		ValaDataType* _tmp67_;
		ValaDataType* _tmp68_;
		_tmp66_ = f;
		_tmp67_ = vala_variable_get_variable_type ((ValaVariable*) _tmp66_);
		_tmp68_ = _tmp67_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp68_, VALA_TYPE_DELEGATE_TYPE)) {
			ValaDelegateType* deleg_type = NULL;
			ValaField* _tmp69_;
			ValaDataType* _tmp70_;
			ValaDataType* _tmp71_;
			ValaDelegateType* _tmp72_;
			ValaDelegateType* _tmp73_;
			ValaDelegate* _tmp74_;
			ValaDelegate* _tmp75_;
			gboolean _tmp76_;
			gboolean _tmp77_;
			_tmp69_ = f;
			_tmp70_ = vala_variable_get_variable_type ((ValaVariable*) _tmp69_);
			_tmp71_ = _tmp70_;
			_tmp72_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp72_;
			_tmp73_ = deleg_type;
			_tmp74_ = vala_delegate_type_get_delegate_symbol (_tmp73_);
			_tmp75_ = _tmp74_;
			_tmp76_ = vala_delegate_get_has_target (_tmp75_);
			_tmp77_ = _tmp76_;
			if (_tmp77_) {
				GString* _tmp78_;
				ValaField* _tmp79_;
				gchar* _tmp80_;
				gchar* _tmp81_;
				ValaField* _tmp82_;
				GString* _tmp83_;
				gint _tmp84_;
				GString* _tmp85_;
				gint _tmp86_;
				GString* _tmp87_;
				ValaDelegateType* _tmp88_;
				gboolean _tmp89_;
				vala_gir_writer_write_indent (self);
				_tmp78_ = self->priv->buffer;
				_tmp79_ = f;
				_tmp80_ = vala_ccode_base_module_get_ccode_delegate_target_name ((ValaVariable*) _tmp79_);
				_tmp81_ = _tmp80_;
				g_string_append_printf (_tmp78_, "<field name=\"%s\"", _tmp81_);
				_g_free0 (_tmp81_);
				_tmp82_ = f;
				vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp82_);
				_tmp83_ = self->priv->buffer;
				g_string_append_printf (_tmp83_, ">\n");
				_tmp84_ = self->priv->indent;
				self->priv->indent = _tmp84_ + 1;
				vala_gir_writer_write_indent (self);
				_tmp85_ = self->priv->buffer;
				g_string_append_printf (_tmp85_, "<type name=\"gpointer\" c:type=\"gpointer\"/>\n");
				_tmp86_ = self->priv->indent;
				self->priv->indent = _tmp86_ - 1;
				vala_gir_writer_write_indent (self);
				_tmp87_ = self->priv->buffer;
				g_string_append_printf (_tmp87_, "</field>\n");
				_tmp88_ = deleg_type;
				_tmp89_ = vala_data_type_is_disposable ((ValaDataType*) _tmp88_);
				if (_tmp89_) {
					GString* _tmp90_;
					ValaCodeContext* _tmp91_;
					ValaCodeGenerator* _tmp92_;
					ValaCodeGenerator* _tmp93_;
					ValaField* _tmp94_;
					gchar* _tmp95_;
					gchar* _tmp96_;
					gchar* _tmp97_;
					gchar* _tmp98_;
					ValaField* _tmp99_;
					GString* _tmp100_;
					gint _tmp101_;
					GString* _tmp102_;
					gint _tmp103_;
					GString* _tmp104_;
					vala_gir_writer_write_indent (self);
					_tmp90_ = self->priv->buffer;
					_tmp91_ = self->priv->context;
					_tmp92_ = vala_code_context_get_codegen (_tmp91_);
					_tmp93_ = _tmp92_;
					_tmp94_ = f;
					_tmp95_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp94_);
					_tmp96_ = _tmp95_;
					_tmp97_ = vala_ccode_base_module_get_delegate_target_destroy_notify_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModule), _tmp96_);
					_tmp98_ = _tmp97_;
					g_string_append_printf (_tmp90_, "<field name=\"%s\"", _tmp98_);
					_g_free0 (_tmp98_);
					_g_free0 (_tmp96_);
					_tmp99_ = f;
					vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp99_);
					_tmp100_ = self->priv->buffer;
					g_string_append_printf (_tmp100_, ">\n");
					_tmp101_ = self->priv->indent;
					self->priv->indent = _tmp101_ + 1;
					vala_gir_writer_write_indent (self);
					_tmp102_ = self->priv->buffer;
					g_string_append_printf (_tmp102_, "<type name=\"GLib.DestroyNotify\" c:type=\"GDestroyNotify\"/>\n");
					_tmp103_ = self->priv->indent;
					self->priv->indent = _tmp103_ - 1;
					vala_gir_writer_write_indent (self);
					_tmp104_ = self->priv->buffer;
					g_string_append_printf (_tmp104_, "</field>\n");
				}
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
}


static void vala_gir_writer_write_implicit_params (ValaGIRWriter* self, ValaDataType* type, gint* index, gboolean has_array_length, const gchar* name, ValaParameterDirection direction) {
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_ARRAY_TYPE)) {
		gboolean _tmp2_;
		_tmp2_ = has_array_length;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaIntegerType* int_type = NULL;
		ValaCodeContext* _tmp3_;
		ValaCodeContext* _tmp4_;
		ValaNamespace* _tmp5_;
		ValaNamespace* _tmp6_;
		ValaScope* _tmp7_;
		ValaScope* _tmp8_;
		ValaSymbol* _tmp9_;
		ValaStruct* _tmp10_;
		ValaStruct* _tmp11_;
		ValaIntegerType* _tmp12_;
		ValaIntegerType* _tmp13_;
		_tmp3_ = vala_code_context_get ();
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_code_context_get_root (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_symbol_get_scope ((ValaSymbol*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_scope_lookup (_tmp8_, "int");
		_tmp10_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp9_) : NULL;
		if (_tmp10_ == NULL) {
			_vala_code_node_unref0 (_tmp9_);
		}
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_integer_type_new (_tmp11_, NULL, NULL);
		_tmp13_ = _tmp12_;
		_vala_code_node_unref0 (_tmp11_);
		_vala_code_context_unref0 (_tmp4_);
		int_type = _tmp13_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp14_ = FALSE;
				_tmp14_ = TRUE;
				while (TRUE) {
					gint _tmp16_;
					ValaDataType* _tmp17_;
					gint _tmp18_;
					gint _tmp19_;
					ValaIntegerType* _tmp20_;
					gboolean _tmp21_;
					const gchar* _tmp22_;
					gint _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					ValaParameterDirection _tmp26_;
					if (!_tmp14_) {
						gint _tmp15_;
						_tmp15_ = i;
						i = _tmp15_ + 1;
					}
					_tmp14_ = FALSE;
					_tmp16_ = i;
					_tmp17_ = type;
					_tmp18_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp19_ = _tmp18_;
					if (!(_tmp16_ < _tmp19_)) {
						break;
					}
					_tmp20_ = int_type;
					_tmp21_ = has_array_length;
					_tmp22_ = name;
					_tmp23_ = i;
					_tmp24_ = g_strdup_printf ("%s_length%i", _tmp22_, _tmp23_ + 1);
					_tmp25_ = _tmp24_;
					_tmp26_ = direction;
					vala_gir_writer_write_param_or_return (self, (ValaDataType*) _tmp20_, TRUE, index, _tmp21_, _tmp25_, NULL, _tmp26_, FALSE, FALSE, FALSE);
					_g_free0 (_tmp25_);
				}
			}
		}
		_vala_code_node_unref0 (int_type);
	} else {
		ValaDataType* _tmp27_;
		_tmp27_ = type;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, VALA_TYPE_DELEGATE_TYPE)) {
			ValaDelegateType* deleg_type = NULL;
			ValaDataType* _tmp28_;
			ValaDelegateType* _tmp29_;
			ValaDelegateType* _tmp30_;
			ValaDelegate* _tmp31_;
			ValaDelegate* _tmp32_;
			gboolean _tmp33_;
			gboolean _tmp34_;
			_tmp28_ = type;
			_tmp29_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp29_;
			_tmp30_ = deleg_type;
			_tmp31_ = vala_delegate_type_get_delegate_symbol (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = vala_delegate_get_has_target (_tmp32_);
			_tmp34_ = _tmp33_;
			if (_tmp34_) {
				ValaPointerType* data_type = NULL;
				ValaVoidType* _tmp35_;
				ValaVoidType* _tmp36_;
				ValaPointerType* _tmp37_;
				ValaPointerType* _tmp38_;
				ValaPointerType* _tmp39_;
				const gchar* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				ValaParameterDirection _tmp43_;
				ValaDelegateType* _tmp44_;
				gboolean _tmp45_;
				_tmp35_ = vala_void_type_new (NULL);
				_tmp36_ = _tmp35_;
				_tmp37_ = vala_pointer_type_new ((ValaDataType*) _tmp36_, NULL);
				_tmp38_ = _tmp37_;
				_vala_code_node_unref0 (_tmp36_);
				data_type = _tmp38_;
				_tmp39_ = data_type;
				_tmp40_ = name;
				_tmp41_ = g_strdup_printf ("%s_target", _tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = direction;
				vala_gir_writer_write_param_or_return (self, (ValaDataType*) _tmp39_, TRUE, index, FALSE, _tmp42_, NULL, _tmp43_, FALSE, FALSE, FALSE);
				_g_free0 (_tmp42_);
				_tmp44_ = deleg_type;
				_tmp45_ = vala_data_type_is_disposable ((ValaDataType*) _tmp44_);
				if (_tmp45_) {
					ValaDelegateType* notify_type = NULL;
					ValaCodeContext* _tmp46_;
					ValaCodeContext* _tmp47_;
					ValaNamespace* _tmp48_;
					ValaNamespace* _tmp49_;
					ValaScope* _tmp50_;
					ValaScope* _tmp51_;
					ValaSymbol* _tmp52_;
					ValaSymbol* _tmp53_;
					ValaScope* _tmp54_;
					ValaScope* _tmp55_;
					ValaSymbol* _tmp56_;
					ValaDelegate* _tmp57_;
					ValaDelegate* _tmp58_;
					ValaDelegateType* _tmp59_;
					ValaDelegateType* _tmp60_;
					ValaDelegateType* _tmp61_;
					const gchar* _tmp62_;
					gchar* _tmp63_;
					gchar* _tmp64_;
					ValaParameterDirection _tmp65_;
					_tmp46_ = vala_code_context_get ();
					_tmp47_ = _tmp46_;
					_tmp48_ = vala_code_context_get_root (_tmp47_);
					_tmp49_ = _tmp48_;
					_tmp50_ = vala_symbol_get_scope ((ValaSymbol*) _tmp49_);
					_tmp51_ = _tmp50_;
					_tmp52_ = vala_scope_lookup (_tmp51_, "GLib");
					_tmp53_ = _tmp52_;
					_tmp54_ = vala_symbol_get_scope (_tmp53_);
					_tmp55_ = _tmp54_;
					_tmp56_ = vala_scope_lookup (_tmp55_, "DestroyNotify");
					_tmp57_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp56_, VALA_TYPE_DELEGATE) ? ((ValaDelegate*) _tmp56_) : NULL;
					if (_tmp57_ == NULL) {
						_vala_code_node_unref0 (_tmp56_);
					}
					_tmp58_ = _tmp57_;
					_tmp59_ = vala_delegate_type_new (_tmp58_);
					_tmp60_ = _tmp59_;
					_vala_code_node_unref0 (_tmp58_);
					_vala_code_node_unref0 (_tmp53_);
					_vala_code_context_unref0 (_tmp47_);
					notify_type = _tmp60_;
					_tmp61_ = notify_type;
					_tmp62_ = name;
					_tmp63_ = g_strdup_printf ("%s_target_destroy_notify", _tmp62_);
					_tmp64_ = _tmp63_;
					_tmp65_ = direction;
					vala_gir_writer_write_param_or_return (self, (ValaDataType*) _tmp61_, TRUE, index, FALSE, _tmp64_, NULL, _tmp65_, FALSE, FALSE, FALSE);
					_g_free0 (_tmp64_);
					_vala_code_node_unref0 (notify_type);
				}
				_vala_code_node_unref0 (data_type);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
}


static void vala_gir_writer_skip_implicit_params (ValaGIRWriter* self, ValaDataType* type, gint* index, gboolean has_array_length) {
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_ARRAY_TYPE)) {
		gboolean _tmp2_;
		_tmp2_ = has_array_length;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint _tmp3_;
		ValaDataType* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp3_ = *index;
		_tmp4_ = type;
		_tmp5_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		_tmp6_ = _tmp5_;
		*index = _tmp3_ + _tmp6_;
	} else {
		ValaDataType* _tmp7_;
		_tmp7_ = type;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_DELEGATE_TYPE)) {
			gint _tmp8_;
			ValaDelegateType* deleg_type = NULL;
			ValaDataType* _tmp9_;
			ValaDelegateType* _tmp10_;
			ValaDelegateType* _tmp11_;
			gboolean _tmp12_;
			_tmp8_ = *index;
			*index = _tmp8_ + 1;
			_tmp9_ = type;
			_tmp10_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp10_;
			_tmp11_ = deleg_type;
			_tmp12_ = vala_data_type_is_disposable ((ValaDataType*) _tmp11_);
			if (_tmp12_) {
				gint _tmp13_;
				_tmp13_ = *index;
				*index = _tmp13_ + 1;
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
}


static void vala_gir_writer_write_type_parameter (ValaGIRWriter* self, ValaTypeParameter* type_parameter, const gchar* tag_type) {
	const gchar* _tmp0_;
	gint _tmp15_;
	GString* _tmp16_;
	gint _tmp17_;
	GString* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gint _tmp35_;
	GString* _tmp36_;
	gint _tmp37_;
	GString* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	gint _tmp55_;
	GString* _tmp56_;
	gint _tmp57_;
	GString* _tmp58_;
	const gchar* _tmp59_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type_parameter != NULL);
	g_return_if_fail (tag_type != NULL);
	vala_gir_writer_write_indent (self);
	_tmp0_ = tag_type;
	if (g_strcmp0 (_tmp0_, "property") == 0) {
		GString* _tmp1_;
		const gchar* _tmp2_;
		ValaTypeParameter* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp1_ = self->priv->buffer;
		_tmp2_ = tag_type;
		_tmp3_ = type_parameter;
		_tmp4_ = vala_symbol_get_name ((ValaSymbol*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_utf8_strdown (_tmp5_, (gssize) -1);
		_tmp7_ = _tmp6_;
		g_string_append_printf (_tmp1_, "<%s name=\"%s-type\" writable=\"1\" construct-only=\"1\">\n", _tmp2_, _tmp7_);
		_g_free0 (_tmp7_);
	} else {
		GString* _tmp8_;
		const gchar* _tmp9_;
		ValaTypeParameter* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp8_ = self->priv->buffer;
		_tmp9_ = tag_type;
		_tmp10_ = type_parameter;
		_tmp11_ = vala_symbol_get_name ((ValaSymbol*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_utf8_strdown (_tmp12_, (gssize) -1);
		_tmp14_ = _tmp13_;
		g_string_append_printf (_tmp8_, "<%s name=\"%s_type\" transfer-ownership=\"none\">\n", _tmp9_, _tmp14_);
		_g_free0 (_tmp14_);
	}
	_tmp15_ = self->priv->indent;
	self->priv->indent = _tmp15_ + 1;
	vala_gir_writer_write_indent (self);
	_tmp16_ = self->priv->buffer;
	g_string_append_printf (_tmp16_, "<type name=\"GType\" c:type=\"GType\"/>\n");
	_tmp17_ = self->priv->indent;
	self->priv->indent = _tmp17_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp18_ = self->priv->buffer;
	_tmp19_ = tag_type;
	g_string_append_printf (_tmp18_, "</%s>\n", _tmp19_);
	vala_gir_writer_write_indent (self);
	_tmp20_ = tag_type;
	if (g_strcmp0 (_tmp20_, "property") == 0) {
		GString* _tmp21_;
		const gchar* _tmp22_;
		ValaTypeParameter* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		_tmp21_ = self->priv->buffer;
		_tmp22_ = tag_type;
		_tmp23_ = type_parameter;
		_tmp24_ = vala_symbol_get_name ((ValaSymbol*) _tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_utf8_strdown (_tmp25_, (gssize) -1);
		_tmp27_ = _tmp26_;
		g_string_append_printf (_tmp21_, "<%s name=\"%s-dup-func\" writable=\"1\" construct-only=\"1\">\n", _tmp22_, _tmp27_);
		_g_free0 (_tmp27_);
	} else {
		GString* _tmp28_;
		const gchar* _tmp29_;
		ValaTypeParameter* _tmp30_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		_tmp28_ = self->priv->buffer;
		_tmp29_ = tag_type;
		_tmp30_ = type_parameter;
		_tmp31_ = vala_symbol_get_name ((ValaSymbol*) _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_utf8_strdown (_tmp32_, (gssize) -1);
		_tmp34_ = _tmp33_;
		g_string_append_printf (_tmp28_, "<%s name=\"%s_dup_func\" transfer-ownership=\"none\">\n", _tmp29_, _tmp34_);
		_g_free0 (_tmp34_);
	}
	_tmp35_ = self->priv->indent;
	self->priv->indent = _tmp35_ + 1;
	vala_gir_writer_write_indent (self);
	_tmp36_ = self->priv->buffer;
	g_string_append_printf (_tmp36_, "<type name=\"GObject.BoxedCopyFunc\" c:type=\"GBoxedCopyFunc\"/>\n");
	_tmp37_ = self->priv->indent;
	self->priv->indent = _tmp37_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp38_ = self->priv->buffer;
	_tmp39_ = tag_type;
	g_string_append_printf (_tmp38_, "</%s>\n", _tmp39_);
	vala_gir_writer_write_indent (self);
	_tmp40_ = tag_type;
	if (g_strcmp0 (_tmp40_, "property") == 0) {
		GString* _tmp41_;
		const gchar* _tmp42_;
		ValaTypeParameter* _tmp43_;
		const gchar* _tmp44_;
		const gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		_tmp41_ = self->priv->buffer;
		_tmp42_ = tag_type;
		_tmp43_ = type_parameter;
		_tmp44_ = vala_symbol_get_name ((ValaSymbol*) _tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = g_utf8_strdown (_tmp45_, (gssize) -1);
		_tmp47_ = _tmp46_;
		g_string_append_printf (_tmp41_, "<%s name=\"%s-destroy-func\" writable=\"1\" construct-only=\"1\">\n", _tmp42_, _tmp47_);
		_g_free0 (_tmp47_);
	} else {
		GString* _tmp48_;
		const gchar* _tmp49_;
		ValaTypeParameter* _tmp50_;
		const gchar* _tmp51_;
		const gchar* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		_tmp48_ = self->priv->buffer;
		_tmp49_ = tag_type;
		_tmp50_ = type_parameter;
		_tmp51_ = vala_symbol_get_name ((ValaSymbol*) _tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = g_utf8_strdown (_tmp52_, (gssize) -1);
		_tmp54_ = _tmp53_;
		g_string_append_printf (_tmp48_, "<%s name=\"%s_destroy_func\" transfer-ownership=\"none\">\n", _tmp49_, _tmp54_);
		_g_free0 (_tmp54_);
	}
	_tmp55_ = self->priv->indent;
	self->priv->indent = _tmp55_ + 1;
	vala_gir_writer_write_indent (self);
	_tmp56_ = self->priv->buffer;
	g_string_append_printf (_tmp56_, "<type name=\"GLib.DestroyNotify\" c:type=\"GDestroyNotify\"/>\n");
	_tmp57_ = self->priv->indent;
	self->priv->indent = _tmp57_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp58_ = self->priv->buffer;
	_tmp59_ = tag_type;
	g_string_append_printf (_tmp58_, "</%s>\n", _tmp59_);
}


static void vala_gir_writer_write_params_and_return (ValaGIRWriter* self, ValaList* params, ValaList* type_params, ValaDataType* return_type, gboolean return_array_length, const gchar* return_comment, gboolean constructor, ValaDataType* instance_type, gboolean user_data) {
	gint last_index = 0;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	gboolean ret_is_struct = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	ValaList* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gboolean _tmp48_ = FALSE;
	ValaDataType* _tmp49_;
	gboolean _tmp59_ = FALSE;
	gboolean _tmp60_ = FALSE;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp63_ = FALSE;
	ValaList* _tmp64_;
	gint _tmp65_;
	gint _tmp66_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (params != NULL);
	last_index = 0;
	_tmp1_ = return_type;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = return_type;
		_tmp3_ = vala_data_type_is_real_non_null_struct_type (_tmp2_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	ret_is_struct = _tmp0_;
	_tmp8_ = params;
	_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != 0) {
		_tmp7_ = TRUE;
	} else {
		ValaDataType* _tmp11_;
		_tmp11_ = instance_type;
		_tmp7_ = _tmp11_ != NULL;
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		gboolean _tmp12_ = FALSE;
		ValaDataType* _tmp13_;
		_tmp13_ = return_type;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, VALA_TYPE_ARRAY_TYPE)) {
			gboolean _tmp14_;
			_tmp14_ = return_array_length;
			_tmp12_ = _tmp14_;
		} else {
			_tmp12_ = FALSE;
		}
		_tmp6_ = _tmp12_;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		ValaDataType* _tmp15_;
		_tmp15_ = return_type;
		_tmp5_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, VALA_TYPE_DELEGATE_TYPE);
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		gboolean _tmp16_;
		_tmp16_ = ret_is_struct;
		_tmp4_ = _tmp16_;
	}
	if (_tmp4_) {
		gint index = 0;
		ValaDataType* _tmp17_;
		gboolean _tmp36_;
		gint _tmp47_;
		index = 0;
		_tmp17_ = instance_type;
		if (_tmp17_ != NULL) {
			gint _tmp18_;
			_tmp18_ = index;
			index = _tmp18_ + 1;
		}
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp19_;
			ValaList* _tmp20_;
			gint _param_size = 0;
			ValaList* _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			gint _param_index = 0;
			_tmp19_ = params;
			_tmp20_ = _vala_iterable_ref0 (_tmp19_);
			_param_list = _tmp20_;
			_tmp21_ = _param_list;
			_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
			_tmp23_ = _tmp22_;
			_param_size = _tmp23_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
				ValaParameter* param = NULL;
				ValaList* _tmp27_;
				gint _tmp28_;
				gpointer _tmp29_;
				gint _tmp30_;
				ValaParameter* _tmp31_;
				ValaDataType* _tmp32_;
				ValaDataType* _tmp33_;
				ValaParameter* _tmp34_;
				gboolean _tmp35_;
				_tmp24_ = _param_index;
				_param_index = _tmp24_ + 1;
				_tmp25_ = _param_index;
				_tmp26_ = _param_size;
				if (!(_tmp25_ < _tmp26_)) {
					break;
				}
				_tmp27_ = _param_list;
				_tmp28_ = _param_index;
				_tmp29_ = vala_list_get (_tmp27_, _tmp28_);
				param = (ValaParameter*) _tmp29_;
				_tmp30_ = index;
				index = _tmp30_ + 1;
				_tmp31_ = param;
				_tmp32_ = vala_variable_get_variable_type ((ValaVariable*) _tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = param;
				_tmp35_ = vala_ccode_base_module_get_ccode_array_length ((ValaCodeNode*) _tmp34_);
				vala_gir_writer_skip_implicit_params (self, _tmp33_, &index, _tmp35_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp36_ = ret_is_struct;
		if (_tmp36_) {
			gint _tmp37_;
			_tmp37_ = index;
			index = _tmp37_ + 1;
		} else {
			ValaDataType* _tmp38_;
			gboolean _tmp39_;
			gboolean _tmp40_ = FALSE;
			ValaDataType* _tmp41_;
			_tmp38_ = return_type;
			_tmp39_ = return_array_length;
			vala_gir_writer_skip_implicit_params (self, _tmp38_, &index, _tmp39_);
			_tmp41_ = return_type;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp41_, VALA_TYPE_ARRAY_TYPE)) {
				gboolean _tmp42_;
				_tmp42_ = return_array_length;
				_tmp40_ = _tmp42_;
			} else {
				_tmp40_ = FALSE;
			}
			if (_tmp40_) {
				gint _tmp43_;
				ValaDataType* _tmp44_;
				gint _tmp45_;
				gint _tmp46_;
				_tmp43_ = index;
				_tmp44_ = return_type;
				_tmp45_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp46_ = _tmp45_;
				index = _tmp43_ - (_tmp46_ - 1);
			}
		}
		_tmp47_ = index;
		last_index = _tmp47_ - 1;
	}
	_tmp49_ = return_type;
	if (_tmp49_ != NULL) {
		gboolean _tmp50_;
		_tmp50_ = ret_is_struct;
		_tmp48_ = !_tmp50_;
	} else {
		_tmp48_ = FALSE;
	}
	if (_tmp48_) {
		ValaDataType* _tmp51_;
		gboolean _tmp52_;
		const gchar* _tmp53_;
		gboolean _tmp54_;
		_tmp51_ = return_type;
		_tmp52_ = return_array_length;
		_tmp53_ = return_comment;
		_tmp54_ = constructor;
		vala_gir_writer_write_param_or_return (self, _tmp51_, FALSE, &last_index, _tmp52_, NULL, _tmp53_, VALA_PARAMETER_DIRECTION_IN, _tmp54_, FALSE, FALSE);
	} else {
		gboolean _tmp55_;
		_tmp55_ = ret_is_struct;
		if (_tmp55_) {
			ValaVoidType* _tmp56_;
			ValaVoidType* _tmp57_;
			const gchar* _tmp58_;
			_tmp56_ = vala_void_type_new (NULL);
			_tmp57_ = _tmp56_;
			_tmp58_ = return_comment;
			vala_gir_writer_write_param_or_return (self, (ValaDataType*) _tmp57_, FALSE, &last_index, FALSE, NULL, _tmp58_, VALA_PARAMETER_DIRECTION_IN, FALSE, FALSE, FALSE);
			_vala_code_node_unref0 (_tmp57_);
		}
	}
	_tmp64_ = params;
	_tmp65_ = vala_collection_get_size ((ValaCollection*) _tmp64_);
	_tmp66_ = _tmp65_;
	if (_tmp66_ != 0) {
		_tmp63_ = TRUE;
	} else {
		gboolean _tmp67_ = FALSE;
		ValaList* _tmp68_;
		_tmp68_ = type_params;
		if (_tmp68_ != NULL) {
			ValaList* _tmp69_;
			gint _tmp70_;
			gint _tmp71_;
			_tmp69_ = type_params;
			_tmp70_ = vala_collection_get_size ((ValaCollection*) _tmp69_);
			_tmp71_ = _tmp70_;
			_tmp67_ = _tmp71_ > 0;
		} else {
			_tmp67_ = FALSE;
		}
		_tmp63_ = _tmp67_;
	}
	if (_tmp63_) {
		_tmp62_ = TRUE;
	} else {
		ValaDataType* _tmp72_;
		_tmp72_ = instance_type;
		_tmp62_ = _tmp72_ != NULL;
	}
	if (_tmp62_) {
		_tmp61_ = TRUE;
	} else {
		gboolean _tmp73_ = FALSE;
		ValaDataType* _tmp74_;
		_tmp74_ = return_type;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp74_, VALA_TYPE_ARRAY_TYPE)) {
			gboolean _tmp75_;
			_tmp75_ = return_array_length;
			_tmp73_ = _tmp75_;
		} else {
			_tmp73_ = FALSE;
		}
		_tmp61_ = _tmp73_;
	}
	if (_tmp61_) {
		_tmp60_ = TRUE;
	} else {
		ValaDataType* _tmp76_;
		_tmp76_ = return_type;
		_tmp60_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp76_, VALA_TYPE_DELEGATE_TYPE);
	}
	if (_tmp60_) {
		_tmp59_ = TRUE;
	} else {
		gboolean _tmp77_;
		_tmp77_ = ret_is_struct;
		_tmp59_ = _tmp77_;
	}
	if (_tmp59_) {
		GString* _tmp78_;
		gint _tmp79_;
		gint index = 0;
		ValaDataType* _tmp80_;
		ValaList* _tmp82_;
		gboolean _tmp135_;
		gboolean _tmp141_;
		gint _tmp148_;
		GString* _tmp149_;
		vala_gir_writer_write_indent (self);
		_tmp78_ = self->priv->buffer;
		g_string_append_printf (_tmp78_, "<parameters>\n");
		_tmp79_ = self->priv->indent;
		self->priv->indent = _tmp79_ + 1;
		index = 0;
		_tmp80_ = instance_type;
		if (_tmp80_ != NULL) {
			ValaDataType* _tmp81_;
			_tmp81_ = instance_type;
			vala_gir_writer_write_param_or_return (self, _tmp81_, TRUE, &index, FALSE, "self", NULL, VALA_PARAMETER_DIRECTION_IN, FALSE, FALSE, FALSE);
		}
		_tmp82_ = type_params;
		if (_tmp82_ != NULL) {
			{
				ValaList* _p_list = NULL;
				ValaList* _tmp83_;
				ValaList* _tmp84_;
				gint _p_size = 0;
				ValaList* _tmp85_;
				gint _tmp86_;
				gint _tmp87_;
				gint _p_index = 0;
				_tmp83_ = type_params;
				_tmp84_ = _vala_iterable_ref0 (_tmp83_);
				_p_list = _tmp84_;
				_tmp85_ = _p_list;
				_tmp86_ = vala_collection_get_size ((ValaCollection*) _tmp85_);
				_tmp87_ = _tmp86_;
				_p_size = _tmp87_;
				_p_index = -1;
				while (TRUE) {
					gint _tmp88_;
					gint _tmp89_;
					gint _tmp90_;
					ValaTypeParameter* p = NULL;
					ValaList* _tmp91_;
					gint _tmp92_;
					gpointer _tmp93_;
					ValaTypeParameter* _tmp94_;
					gint _tmp95_;
					_tmp88_ = _p_index;
					_p_index = _tmp88_ + 1;
					_tmp89_ = _p_index;
					_tmp90_ = _p_size;
					if (!(_tmp89_ < _tmp90_)) {
						break;
					}
					_tmp91_ = _p_list;
					_tmp92_ = _p_index;
					_tmp93_ = vala_list_get (_tmp91_, _tmp92_);
					p = (ValaTypeParameter*) _tmp93_;
					_tmp94_ = p;
					vala_gir_writer_write_type_parameter (self, _tmp94_, "parameter");
					_tmp95_ = index;
					index = _tmp95_ + 3;
					_vala_code_node_unref0 (p);
				}
				_vala_iterable_unref0 (_p_list);
			}
		}
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp96_;
			ValaList* _tmp97_;
			gint _param_size = 0;
			ValaList* _tmp98_;
			gint _tmp99_;
			gint _tmp100_;
			gint _param_index = 0;
			_tmp96_ = params;
			_tmp97_ = _vala_iterable_ref0 (_tmp96_);
			_param_list = _tmp97_;
			_tmp98_ = _param_list;
			_tmp99_ = vala_collection_get_size ((ValaCollection*) _tmp98_);
			_tmp100_ = _tmp99_;
			_param_size = _tmp100_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp101_;
				gint _tmp102_;
				gint _tmp103_;
				ValaParameter* param = NULL;
				ValaList* _tmp104_;
				gint _tmp105_;
				gpointer _tmp106_;
				ValaParameter* _tmp107_;
				ValaDataType* _tmp108_;
				ValaDataType* _tmp109_;
				ValaParameter* _tmp110_;
				gboolean _tmp111_;
				ValaParameter* _tmp112_;
				const gchar* _tmp113_;
				const gchar* _tmp114_;
				ValaParameter* _tmp115_;
				gchar* _tmp116_;
				gchar* _tmp117_;
				ValaParameter* _tmp118_;
				ValaParameterDirection _tmp119_;
				ValaParameterDirection _tmp120_;
				ValaParameter* _tmp121_;
				gboolean _tmp122_;
				gboolean _tmp123_;
				ValaParameter* _tmp124_;
				ValaDataType* _tmp125_;
				ValaDataType* _tmp126_;
				ValaParameter* _tmp127_;
				gboolean _tmp128_;
				ValaParameter* _tmp129_;
				const gchar* _tmp130_;
				const gchar* _tmp131_;
				ValaParameter* _tmp132_;
				ValaParameterDirection _tmp133_;
				ValaParameterDirection _tmp134_;
				_tmp101_ = _param_index;
				_param_index = _tmp101_ + 1;
				_tmp102_ = _param_index;
				_tmp103_ = _param_size;
				if (!(_tmp102_ < _tmp103_)) {
					break;
				}
				_tmp104_ = _param_list;
				_tmp105_ = _param_index;
				_tmp106_ = vala_list_get (_tmp104_, _tmp105_);
				param = (ValaParameter*) _tmp106_;
				_tmp107_ = param;
				_tmp108_ = vala_variable_get_variable_type ((ValaVariable*) _tmp107_);
				_tmp109_ = _tmp108_;
				_tmp110_ = param;
				_tmp111_ = vala_ccode_base_module_get_ccode_array_length ((ValaCodeNode*) _tmp110_);
				_tmp112_ = param;
				_tmp113_ = vala_symbol_get_name ((ValaSymbol*) _tmp112_);
				_tmp114_ = _tmp113_;
				_tmp115_ = param;
				_tmp116_ = vala_gir_writer_get_parameter_comment (self, _tmp115_);
				_tmp117_ = _tmp116_;
				_tmp118_ = param;
				_tmp119_ = vala_parameter_get_direction (_tmp118_);
				_tmp120_ = _tmp119_;
				_tmp121_ = param;
				_tmp122_ = vala_parameter_get_ellipsis (_tmp121_);
				_tmp123_ = _tmp122_;
				vala_gir_writer_write_param_or_return (self, _tmp109_, TRUE, &index, _tmp111_, _tmp114_, _tmp117_, _tmp120_, FALSE, FALSE, _tmp123_);
				_g_free0 (_tmp117_);
				_tmp124_ = param;
				_tmp125_ = vala_variable_get_variable_type ((ValaVariable*) _tmp124_);
				_tmp126_ = _tmp125_;
				_tmp127_ = param;
				_tmp128_ = vala_ccode_base_module_get_ccode_array_length ((ValaCodeNode*) _tmp127_);
				_tmp129_ = param;
				_tmp130_ = vala_symbol_get_name ((ValaSymbol*) _tmp129_);
				_tmp131_ = _tmp130_;
				_tmp132_ = param;
				_tmp133_ = vala_parameter_get_direction (_tmp132_);
				_tmp134_ = _tmp133_;
				vala_gir_writer_write_implicit_params (self, _tmp126_, &index, _tmp128_, _tmp131_, _tmp134_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp135_ = ret_is_struct;
		if (_tmp135_) {
			ValaDataType* _tmp136_;
			const gchar* _tmp137_;
			gboolean _tmp138_;
			_tmp136_ = return_type;
			_tmp137_ = return_comment;
			_tmp138_ = constructor;
			vala_gir_writer_write_param_or_return (self, _tmp136_, TRUE, &index, FALSE, "result", _tmp137_, VALA_PARAMETER_DIRECTION_OUT, _tmp138_, TRUE, FALSE);
		} else {
			ValaDataType* _tmp139_;
			gboolean _tmp140_;
			_tmp139_ = return_type;
			_tmp140_ = return_array_length;
			vala_gir_writer_write_implicit_params (self, _tmp139_, &index, _tmp140_, "result", VALA_PARAMETER_DIRECTION_OUT);
		}
		_tmp141_ = user_data;
		if (_tmp141_) {
			GString* _tmp142_;
			gint _tmp143_;
			gint _tmp144_;
			GString* _tmp145_;
			gint _tmp146_;
			GString* _tmp147_;
			vala_gir_writer_write_indent (self);
			_tmp142_ = self->priv->buffer;
			_tmp143_ = index;
			g_string_append_printf (_tmp142_, "<parameter name=\"user_data\" transfer-ownership=\"none\" closure=\"%d" \
"\">\n", _tmp143_);
			_tmp144_ = self->priv->indent;
			self->priv->indent = _tmp144_ + 1;
			vala_gir_writer_write_indent (self);
			_tmp145_ = self->priv->buffer;
			g_string_append_printf (_tmp145_, "<type name=\"gpointer\" c:type=\"void*\"/>\n");
			_tmp146_ = self->priv->indent;
			self->priv->indent = _tmp146_ - 1;
			vala_gir_writer_write_indent (self);
			_tmp147_ = self->priv->buffer;
			g_string_append_printf (_tmp147_, "</parameter>\n");
		}
		_tmp148_ = self->priv->indent;
		self->priv->indent = _tmp148_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp149_ = self->priv->buffer;
		g_string_append_printf (_tmp149_, "</parameters>\n");
	}
}


static void vala_gir_writer_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* cb) {
	ValaGIRWriter * self;
	ValaDelegate* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaDelegate* _tmp3_;
	gboolean _tmp4_;
	GString* _tmp5_;
	ValaDelegate* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GString* _tmp9_;
	ValaDelegate* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	ValaDelegate* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	ValaDelegate* _tmp17_;
	GString* _tmp18_;
	gint _tmp19_;
	ValaDelegate* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	ValaDelegate* _tmp23_;
	ValaList* _tmp24_;
	ValaList* _tmp25_;
	ValaDelegate* _tmp26_;
	ValaList* _tmp27_;
	ValaList* _tmp28_;
	ValaDelegate* _tmp29_;
	ValaDataType* _tmp30_;
	ValaDataType* _tmp31_;
	ValaDelegate* _tmp32_;
	gboolean _tmp33_;
	ValaDelegate* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	ValaDelegate* _tmp37_;
	gboolean _tmp38_;
	gboolean _tmp39_;
	gint _tmp40_;
	GString* _tmp41_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (cb != NULL);
	_tmp0_ = cb;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = cb;
	_tmp4_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp3_);
	if (!_tmp4_) {
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp5_ = self->priv->buffer;
	_tmp6_ = cb;
	_tmp7_ = vala_symbol_get_name ((ValaSymbol*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append_printf (_tmp5_, "<callback name=\"%s\"", _tmp8_);
	_tmp9_ = self->priv->buffer;
	_tmp10_ = cb;
	_tmp11_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp10_);
	_tmp12_ = _tmp11_;
	g_string_append_printf (_tmp9_, " c:type=\"%s\"", _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = cb;
	_tmp14_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_) {
		GString* _tmp16_;
		_tmp16_ = self->priv->buffer;
		g_string_append_printf (_tmp16_, " throws=\"1\"");
	}
	_tmp17_ = cb;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp17_);
	_tmp18_ = self->priv->buffer;
	g_string_append_printf (_tmp18_, ">\n");
	_tmp19_ = self->priv->indent;
	self->priv->indent = _tmp19_ + 1;
	_tmp20_ = cb;
	_tmp21_ = vala_gir_writer_get_delegate_comment (self, _tmp20_);
	_tmp22_ = _tmp21_;
	vala_gir_writer_write_doc (self, _tmp22_);
	_g_free0 (_tmp22_);
	_tmp23_ = cb;
	_tmp24_ = vala_callable_get_parameters ((ValaCallable*) _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = cb;
	_tmp27_ = vala_delegate_get_type_parameters (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = cb;
	_tmp30_ = vala_callable_get_return_type ((ValaCallable*) _tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = cb;
	_tmp33_ = vala_ccode_base_module_get_ccode_array_length ((ValaCodeNode*) _tmp32_);
	_tmp34_ = cb;
	_tmp35_ = vala_gir_writer_get_delegate_return_comment (self, _tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = cb;
	_tmp38_ = vala_delegate_get_has_target (_tmp37_);
	_tmp39_ = _tmp38_;
	vala_gir_writer_write_params_and_return (self, _tmp25_, _tmp28_, _tmp31_, _tmp33_, _tmp36_, FALSE, NULL, _tmp39_);
	_g_free0 (_tmp36_);
	_vala_iterable_unref0 (_tmp28_);
	_vala_iterable_unref0 (_tmp25_);
	_tmp40_ = self->priv->indent;
	self->priv->indent = _tmp40_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp41_ = self->priv->buffer;
	g_string_append_printf (_tmp41_, "</callback>\n");
}


static void vala_gir_writer_real_visit_method (ValaCodeVisitor* base, ValaMethod* m) {
	ValaGIRWriter * self;
	ValaMethod* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	ValaMethod* _tmp5_;
	gboolean _tmp6_;
	gchar* tag_name = NULL;
	gchar* _tmp21_;
	ValaSymbol* parent = NULL;
	ValaArrayList* _tmp22_;
	gpointer _tmp23_;
	ValaSymbol* _tmp24_;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	ValaSymbol* _tmp29_;
	ValaMethod* _tmp38_;
	const gchar* _tmp39_;
	gboolean _tmp40_ = FALSE;
	ValaMethod* _tmp41_;
	gboolean _tmp42_;
	gboolean _tmp43_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = m;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp5_ = m;
	_tmp6_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp5_);
	if (!_tmp6_) {
		_tmp4_ = TRUE;
	} else {
		ValaMethod* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp7_ = m;
		_tmp8_ = vala_method_get_overrides (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp4_ = _tmp9_;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		ValaMethod* _tmp12_;
		ValaMethod* _tmp13_;
		ValaMethod* _tmp14_;
		_tmp12_ = m;
		_tmp13_ = vala_method_get_base_interface_method (_tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_ != NULL) {
			ValaMethod* _tmp15_;
			gboolean _tmp16_;
			gboolean _tmp17_;
			_tmp15_ = m;
			_tmp16_ = vala_method_get_is_abstract (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp11_ = !_tmp17_;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			ValaMethod* _tmp18_;
			gboolean _tmp19_;
			gboolean _tmp20_;
			_tmp18_ = m;
			_tmp19_ = vala_method_get_is_virtual (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp10_ = !_tmp20_;
		} else {
			_tmp10_ = FALSE;
		}
		_tmp3_ = _tmp10_;
	}
	if (_tmp3_) {
		return;
	}
	_tmp21_ = g_strdup ("method");
	tag_name = _tmp21_;
	_tmp22_ = self->priv->hierarchy;
	_tmp23_ = vala_list_get ((ValaList*) _tmp22_, 0);
	parent = (ValaSymbol*) _tmp23_;
	_tmp24_ = parent;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALA_TYPE_ENUM)) {
		ValaArrayList* _tmp25_;
		ValaMethod* _tmp26_;
		_tmp25_ = self->priv->deferred;
		_tmp26_ = m;
		vala_collection_add ((ValaCollection*) _tmp25_, (ValaCodeNode*) _tmp26_);
		_vala_code_node_unref0 (parent);
		_g_free0 (tag_name);
		return;
	}
	_tmp29_ = parent;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, VALA_TYPE_NAMESPACE)) {
		_tmp28_ = TRUE;
	} else {
		ValaMethod* _tmp30_;
		ValaMemberBinding _tmp31_;
		ValaMemberBinding _tmp32_;
		_tmp30_ = m;
		_tmp31_ = vala_method_get_binding (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp28_ = _tmp32_ == VALA_MEMBER_BINDING_STATIC;
	}
	if (_tmp28_) {
		_tmp27_ = TRUE;
	} else {
		ValaSymbol* _tmp33_;
		ValaMethod* _tmp34_;
		ValaSymbol* _tmp35_;
		ValaSymbol* _tmp36_;
		_tmp33_ = parent;
		_tmp34_ = m;
		_tmp35_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp34_);
		_tmp36_ = _tmp35_;
		_tmp27_ = _tmp33_ != _tmp36_;
	}
	if (_tmp27_) {
		gchar* _tmp37_;
		_tmp37_ = g_strdup ("function");
		_g_free0 (tag_name);
		tag_name = _tmp37_;
	}
	_tmp38_ = m;
	_tmp39_ = tag_name;
	vala_gir_writer_write_signature (self, _tmp38_, _tmp39_, TRUE, FALSE);
	_tmp41_ = m;
	_tmp42_ = vala_method_get_is_abstract (_tmp41_);
	_tmp43_ = _tmp42_;
	if (_tmp43_) {
		_tmp40_ = TRUE;
	} else {
		ValaMethod* _tmp44_;
		gboolean _tmp45_;
		gboolean _tmp46_;
		_tmp44_ = m;
		_tmp45_ = vala_method_get_is_virtual (_tmp44_);
		_tmp46_ = _tmp45_;
		_tmp40_ = _tmp46_;
	}
	if (_tmp40_) {
		ValaMethod* _tmp47_;
		_tmp47_ = m;
		vala_gir_writer_write_signature (self, _tmp47_, "virtual-method", TRUE, FALSE);
	}
	_vala_code_node_unref0 (parent);
	_g_free0 (tag_name);
}


static gboolean vala_gir_writer_is_type_introspectable (ValaGIRWriter* self, ValaDataType* type) {
	gboolean result = FALSE;
	ValaDataType* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	_tmp0_ = type;
	_tmp1_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "va_list") == 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static gboolean vala_gir_writer_is_method_introspectable (ValaGIRWriter* self, ValaMethod* m) {
	gboolean result = FALSE;
	ValaMethod* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (m != NULL, FALSE);
	_tmp0_ = m;
	_tmp1_ = vala_callable_get_return_type ((ValaCallable*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_gir_writer_is_type_introspectable (self, _tmp2_);
	if (!_tmp3_) {
		result = FALSE;
		return result;
	}
	{
		ValaList* _param_list = NULL;
		ValaMethod* _tmp4_;
		ValaList* _tmp5_;
		gint _param_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _param_index = 0;
		_tmp4_ = m;
		_tmp5_ = vala_callable_get_parameters ((ValaCallable*) _tmp4_);
		_param_list = _tmp5_;
		_tmp6_ = _param_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_param_size = _tmp8_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			ValaParameter* param = NULL;
			ValaList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_;
			gboolean _tmp15_ = FALSE;
			ValaParameter* _tmp16_;
			gboolean _tmp17_;
			gboolean _tmp18_;
			_tmp9_ = _param_index;
			_param_index = _tmp9_ + 1;
			_tmp10_ = _param_index;
			_tmp11_ = _param_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _param_list;
			_tmp13_ = _param_index;
			_tmp14_ = vala_list_get (_tmp12_, _tmp13_);
			param = (ValaParameter*) _tmp14_;
			_tmp16_ = param;
			_tmp17_ = vala_parameter_get_ellipsis (_tmp16_);
			_tmp18_ = _tmp17_;
			if (_tmp18_) {
				_tmp15_ = TRUE;
			} else {
				ValaParameter* _tmp19_;
				ValaDataType* _tmp20_;
				ValaDataType* _tmp21_;
				gboolean _tmp22_;
				_tmp19_ = param;
				_tmp20_ = vala_variable_get_variable_type ((ValaVariable*) _tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = vala_gir_writer_is_type_introspectable (self, _tmp21_);
				_tmp15_ = !_tmp22_;
			}
			if (_tmp15_) {
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = TRUE;
	return result;
}


static gboolean vala_gir_writer_is_introspectable (ValaGIRWriter* self, ValaSymbol* sym) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp4_;
	gboolean _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_METHOD)) {
		ValaSymbol* _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = sym;
		_tmp3_ = vala_gir_writer_is_method_introspectable (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, VALA_TYPE_METHOD, ValaMethod));
		_tmp0_ = !_tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = sym;
	_tmp5_ = vala_gir_writer_is_visibility (self, _tmp4_);
	result = _tmp5_;
	return result;
}


static void vala_gir_writer_write_signature (ValaGIRWriter* self, ValaMethod* m, const gchar* tag_name, gboolean write_doc, gboolean instance) {
	ValaSymbol* parent = NULL;
	ValaArrayList* _tmp0_;
	gpointer _tmp1_;
	gchar* name = NULL;
	ValaMethod* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaMethod* _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	g_return_if_fail (tag_name != NULL);
	_tmp0_ = self->priv->hierarchy;
	_tmp1_ = vala_list_get ((ValaList*) _tmp0_, 0);
	parent = (ValaSymbol*) _tmp1_;
	_tmp2_ = m;
	_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = parent;
	if (_tmp4_ != _tmp5_) {
		ValaMethod* _tmp6_;
		gchar* _tmp7_;
		gchar* parent_prefix = NULL;
		ValaSymbol* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gboolean _tmp12_;
		instance = FALSE;
		_tmp6_ = m;
		_tmp7_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp6_);
		_g_free0 (name);
		name = _tmp7_;
		_tmp8_ = parent;
		_tmp9_ = vala_ccode_base_module_get_ccode_lower_case_prefix (_tmp8_);
		parent_prefix = _tmp9_;
		_tmp10_ = name;
		_tmp11_ = parent_prefix;
		_tmp12_ = g_str_has_prefix (_tmp10_, _tmp11_);
		if (_tmp12_) {
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			gchar* _tmp17_;
			_tmp13_ = name;
			_tmp14_ = parent_prefix;
			_tmp15_ = strlen (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = string_substring (_tmp13_, (glong) _tmp16_, (glong) -1);
			_g_free0 (name);
			name = _tmp17_;
		}
		_g_free0 (parent_prefix);
	} else {
		ValaMethod* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp18_ = m;
		_tmp19_ = vala_symbol_get_name ((ValaSymbol*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strdup (_tmp20_);
		_g_free0 (name);
		name = _tmp21_;
	}
	_tmp22_ = m;
	_tmp23_ = vala_method_get_coroutine (_tmp22_);
	_tmp24_ = _tmp23_;
	if (_tmp24_) {
		gchar* finish_name = NULL;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		const gchar* _tmp27_;
		gboolean _tmp28_;
		const gchar* _tmp36_;
		gchar* _tmp37_;
		ValaMethod* _tmp38_;
		const gchar* _tmp39_;
		gboolean _tmp40_;
		const gchar* _tmp41_;
		ValaMethod* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		ValaMethod* _tmp45_;
		ValaList* _tmp46_;
		ValaList* _tmp47_;
		ValaVoidType* _tmp48_;
		ValaVoidType* _tmp49_;
		ValaMethod* _tmp50_;
		const gchar* _tmp51_;
		gboolean _tmp52_;
		const gchar* _tmp53_;
		ValaMethod* _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		ValaMethod* _tmp57_;
		ValaList* _tmp58_;
		ValaList* _tmp59_;
		ValaMethod* _tmp60_;
		ValaDataType* _tmp61_;
		ValaDataType* _tmp62_;
		ValaMethod* _tmp63_;
		gboolean _tmp64_;
		gboolean _tmp65_;
		_tmp25_ = name;
		_tmp26_ = g_strdup (_tmp25_);
		finish_name = _tmp26_;
		_tmp27_ = finish_name;
		_tmp28_ = g_str_has_suffix (_tmp27_, "_async");
		if (_tmp28_) {
			const gchar* _tmp29_;
			const gchar* _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			gchar* _tmp35_;
			_tmp29_ = finish_name;
			_tmp30_ = finish_name;
			_tmp31_ = strlen (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = strlen ("_async");
			_tmp34_ = _tmp33_;
			_tmp35_ = string_substring (_tmp29_, (glong) 0, (glong) (_tmp32_ - _tmp34_));
			_g_free0 (finish_name);
			finish_name = _tmp35_;
		}
		_tmp36_ = finish_name;
		_tmp37_ = g_strconcat (_tmp36_, "_finish", NULL);
		_g_free0 (finish_name);
		finish_name = _tmp37_;
		_tmp38_ = m;
		_tmp39_ = tag_name;
		_tmp40_ = instance;
		_tmp41_ = name;
		_tmp42_ = m;
		_tmp43_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = m;
		_tmp46_ = vala_method_get_async_begin_parameters (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_void_type_new (NULL);
		_tmp49_ = _tmp48_;
		vala_gir_writer_do_write_signature (self, _tmp38_, _tmp39_, _tmp40_, _tmp41_, _tmp44_, _tmp47_, (ValaDataType*) _tmp49_, FALSE, TRUE);
		_vala_code_node_unref0 (_tmp49_);
		_vala_iterable_unref0 (_tmp47_);
		_g_free0 (_tmp44_);
		_tmp50_ = m;
		_tmp51_ = tag_name;
		_tmp52_ = instance;
		_tmp53_ = finish_name;
		_tmp54_ = m;
		_tmp55_ = vala_ccode_base_module_get_ccode_finish_name (_tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = m;
		_tmp58_ = vala_method_get_async_end_parameters (_tmp57_);
		_tmp59_ = _tmp58_;
		_tmp60_ = m;
		_tmp61_ = vala_callable_get_return_type ((ValaCallable*) _tmp60_);
		_tmp62_ = _tmp61_;
		_tmp63_ = m;
		_tmp64_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp63_);
		_tmp65_ = _tmp64_;
		vala_gir_writer_do_write_signature (self, _tmp50_, _tmp51_, _tmp52_, _tmp53_, _tmp56_, _tmp59_, _tmp62_, _tmp65_, FALSE);
		_vala_iterable_unref0 (_tmp59_);
		_g_free0 (_tmp56_);
		_g_free0 (finish_name);
	} else {
		ValaMethod* _tmp66_;
		const gchar* _tmp67_;
		gboolean _tmp68_;
		const gchar* _tmp69_;
		ValaMethod* _tmp70_;
		gchar* _tmp71_;
		gchar* _tmp72_;
		ValaMethod* _tmp73_;
		ValaList* _tmp74_;
		ValaList* _tmp75_;
		ValaMethod* _tmp76_;
		ValaDataType* _tmp77_;
		ValaDataType* _tmp78_;
		ValaMethod* _tmp79_;
		gboolean _tmp80_;
		gboolean _tmp81_;
		_tmp66_ = m;
		_tmp67_ = tag_name;
		_tmp68_ = instance;
		_tmp69_ = name;
		_tmp70_ = m;
		_tmp71_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp70_);
		_tmp72_ = _tmp71_;
		_tmp73_ = m;
		_tmp74_ = vala_callable_get_parameters ((ValaCallable*) _tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = m;
		_tmp77_ = vala_callable_get_return_type ((ValaCallable*) _tmp76_);
		_tmp78_ = _tmp77_;
		_tmp79_ = m;
		_tmp80_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp79_);
		_tmp81_ = _tmp80_;
		vala_gir_writer_do_write_signature (self, _tmp66_, _tmp67_, _tmp68_, _tmp69_, _tmp72_, _tmp75_, _tmp78_, _tmp81_, TRUE);
		_vala_iterable_unref0 (_tmp75_);
		_g_free0 (_tmp72_);
	}
	_g_free0 (name);
	_vala_code_node_unref0 (parent);
}


static void vala_gir_writer_do_write_signature (ValaGIRWriter* self, ValaMethod* m, const gchar* tag_name, gboolean instance, const gchar* name, const gchar* cname, ValaList* params, ValaDataType* return_type, gboolean can_fail, gboolean write_comment) {
	GString* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp11_;
	ValaMethod* _tmp13_;
	GString* _tmp14_;
	gint _tmp15_;
	gchar* return_comment = NULL;
	gboolean _tmp16_;
	ValaDataType* instance_type = NULL;
	gboolean _tmp22_;
	ValaList* _tmp27_;
	ValaMethod* _tmp28_;
	ValaList* _tmp29_;
	ValaList* _tmp30_;
	ValaDataType* _tmp31_;
	ValaMethod* _tmp32_;
	gboolean _tmp33_;
	const gchar* _tmp34_;
	ValaDataType* _tmp35_;
	gint _tmp36_;
	GString* _tmp37_;
	const gchar* _tmp38_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	g_return_if_fail (tag_name != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (cname != NULL);
	g_return_if_fail (params != NULL);
	g_return_if_fail (return_type != NULL);
	vala_gir_writer_write_indent (self);
	_tmp0_ = self->priv->buffer;
	_tmp1_ = tag_name;
	_tmp2_ = name;
	g_string_append_printf (_tmp0_, "<%s name=\"%s\"", _tmp1_, _tmp2_);
	_tmp3_ = tag_name;
	if (g_strcmp0 (_tmp3_, "virtual-method") == 0) {
		GString* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = self->priv->buffer;
		_tmp5_ = name;
		g_string_append_printf (_tmp4_, " invoker=\"%s\"", _tmp5_);
	} else {
		const gchar* _tmp6_;
		_tmp6_ = tag_name;
		if (g_strcmp0 (_tmp6_, "callback") == 0) {
			GString* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = self->priv->buffer;
			_tmp8_ = name;
			g_string_append_printf (_tmp7_, " c:type=\"%s\"", _tmp8_);
		} else {
			GString* _tmp9_;
			const gchar* _tmp10_;
			_tmp9_ = self->priv->buffer;
			_tmp10_ = cname;
			g_string_append_printf (_tmp9_, " c:identifier=\"%s\"", _tmp10_);
		}
	}
	_tmp11_ = can_fail;
	if (_tmp11_) {
		GString* _tmp12_;
		_tmp12_ = self->priv->buffer;
		g_string_append_printf (_tmp12_, " throws=\"1\"");
	}
	_tmp13_ = m;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp13_);
	_tmp14_ = self->priv->buffer;
	g_string_append_printf (_tmp14_, ">\n");
	_tmp15_ = self->priv->indent;
	self->priv->indent = _tmp15_ + 1;
	return_comment = NULL;
	_tmp16_ = write_comment;
	if (_tmp16_) {
		ValaMethod* _tmp17_;
		gchar* _tmp18_;
		ValaMethod* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp17_ = m;
		_tmp18_ = vala_gir_writer_get_method_return_comment (self, _tmp17_);
		_g_free0 (return_comment);
		return_comment = _tmp18_;
		_tmp19_ = m;
		_tmp20_ = vala_gir_writer_get_method_comment (self, _tmp19_);
		_tmp21_ = _tmp20_;
		vala_gir_writer_write_doc (self, _tmp21_);
		_g_free0 (_tmp21_);
	}
	instance_type = NULL;
	_tmp22_ = instance;
	if (_tmp22_) {
		ValaMethod* _tmp23_;
		ValaSymbol* _tmp24_;
		ValaSymbol* _tmp25_;
		ValaDataType* _tmp26_;
		_tmp23_ = m;
		_tmp24_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_ccode_base_module_get_data_type_for_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
		_vala_code_node_unref0 (instance_type);
		instance_type = _tmp26_;
	}
	_tmp27_ = params;
	_tmp28_ = m;
	_tmp29_ = vala_method_get_type_parameters (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = return_type;
	_tmp32_ = m;
	_tmp33_ = vala_ccode_base_module_get_ccode_array_length ((ValaCodeNode*) _tmp32_);
	_tmp34_ = return_comment;
	_tmp35_ = instance_type;
	vala_gir_writer_write_params_and_return (self, _tmp27_, _tmp30_, _tmp31_, _tmp33_, _tmp34_, FALSE, _tmp35_, FALSE);
	_vala_iterable_unref0 (_tmp30_);
	_tmp36_ = self->priv->indent;
	self->priv->indent = _tmp36_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp37_ = self->priv->buffer;
	_tmp38_ = tag_name;
	g_string_append_printf (_tmp37_, "</%s>\n", _tmp38_);
	_vala_code_node_unref0 (instance_type);
	_g_free0 (return_comment);
}


static void vala_gir_writer_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m) {
	ValaGIRWriter * self;
	ValaCreationMethod* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaCreationMethod* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValaCreationMethod* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	gboolean is_struct = FALSE;
	ValaCreationMethod* _tmp14_;
	ValaSymbol* _tmp15_;
	ValaSymbol* _tmp16_;
	const gchar* _tmp17_ = NULL;
	gboolean _tmp18_;
	gchar* tag_name = NULL;
	gchar* _tmp19_;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	ValaCreationMethod* _tmp22_;
	ValaSymbol* _tmp23_;
	ValaSymbol* _tmp24_;
	ValaCreationMethod* _tmp58_;
	gboolean _tmp59_;
	gboolean _tmp60_;
	ValaCreationMethod* _tmp62_;
	GString* _tmp63_;
	gint _tmp64_;
	ValaCreationMethod* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	ValaDataType* datatype = NULL;
	ValaCreationMethod* _tmp68_;
	ValaSymbol* _tmp69_;
	ValaSymbol* _tmp70_;
	ValaDataType* _tmp71_;
	ValaList* type_params = NULL;
	ValaCreationMethod* _tmp72_;
	ValaSymbol* _tmp73_;
	ValaSymbol* _tmp74_;
	ValaCreationMethod* _tmp79_;
	ValaList* _tmp80_;
	ValaList* _tmp81_;
	ValaList* _tmp82_;
	ValaDataType* _tmp83_;
	ValaCreationMethod* _tmp84_;
	gchar* _tmp85_;
	gchar* _tmp86_;
	gint _tmp87_;
	GString* _tmp88_;
	const gchar* _tmp89_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = m;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = m;
	_tmp4_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp3_);
	if (!_tmp4_) {
		return;
	}
	_tmp6_ = m;
	_tmp7_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp6_);
	_tmp8_ = _tmp7_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_CLASS)) {
		ValaCreationMethod* _tmp9_;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
		_tmp9_ = m;
		_tmp10_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_class_get_is_abstract (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_CLASS, ValaClass));
		_tmp13_ = _tmp12_;
		_tmp5_ = _tmp13_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp14_ = m;
	_tmp15_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp14_);
	_tmp16_ = _tmp15_;
	is_struct = G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_STRUCT);
	_tmp18_ = is_struct;
	if (_tmp18_) {
		_tmp17_ = "function";
	} else {
		_tmp17_ = "constructor";
	}
	_tmp19_ = g_strdup (_tmp17_);
	tag_name = _tmp19_;
	_tmp22_ = m;
	_tmp23_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp22_);
	_tmp24_ = _tmp23_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALA_TYPE_CLASS)) {
		ValaCreationMethod* _tmp25_;
		ValaCreationMethod* _tmp26_;
		ValaSymbol* _tmp27_;
		ValaSymbol* _tmp28_;
		ValaCreationMethod* _tmp29_;
		ValaCreationMethod* _tmp30_;
		_tmp25_ = m;
		_tmp26_ = m;
		_tmp27_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = vala_class_get_default_construction_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_CLASS, ValaClass));
		_tmp30_ = _tmp29_;
		_tmp21_ = _tmp25_ == _tmp30_;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		_tmp20_ = TRUE;
	} else {
		gboolean _tmp31_ = FALSE;
		ValaCreationMethod* _tmp32_;
		ValaSymbol* _tmp33_;
		ValaSymbol* _tmp34_;
		_tmp32_ = m;
		_tmp33_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp32_);
		_tmp34_ = _tmp33_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, VALA_TYPE_STRUCT)) {
			ValaCreationMethod* _tmp35_;
			ValaCreationMethod* _tmp36_;
			ValaSymbol* _tmp37_;
			ValaSymbol* _tmp38_;
			ValaMethod* _tmp39_;
			ValaMethod* _tmp40_;
			_tmp35_ = m;
			_tmp36_ = m;
			_tmp37_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_struct_get_default_construction_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, VALA_TYPE_STRUCT, ValaStruct));
			_tmp40_ = _tmp39_;
			_tmp31_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, VALA_TYPE_METHOD, ValaMethod) == _tmp40_;
		} else {
			_tmp31_ = FALSE;
		}
		_tmp20_ = _tmp31_;
	}
	if (_tmp20_) {
		const gchar* _tmp41_ = NULL;
		gboolean _tmp42_;
		gchar* m_name = NULL;
		gchar* _tmp43_;
		GString* _tmp44_;
		const gchar* _tmp45_;
		const gchar* _tmp46_;
		ValaCreationMethod* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		_tmp42_ = is_struct;
		if (_tmp42_) {
			_tmp41_ = "init";
		} else {
			_tmp41_ = "new";
		}
		_tmp43_ = g_strdup (_tmp41_);
		m_name = _tmp43_;
		_tmp44_ = self->priv->buffer;
		_tmp45_ = tag_name;
		_tmp46_ = m_name;
		_tmp47_ = m;
		_tmp48_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp47_);
		_tmp49_ = _tmp48_;
		g_string_append_printf (_tmp44_, "<%s name=\"%s\" c:identifier=\"%s\"", _tmp45_, _tmp46_, _tmp49_);
		_g_free0 (_tmp49_);
		_g_free0 (m_name);
	} else {
		GString* _tmp50_;
		const gchar* _tmp51_;
		ValaCreationMethod* _tmp52_;
		const gchar* _tmp53_;
		const gchar* _tmp54_;
		ValaCreationMethod* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		_tmp50_ = self->priv->buffer;
		_tmp51_ = tag_name;
		_tmp52_ = m;
		_tmp53_ = vala_symbol_get_name ((ValaSymbol*) _tmp52_);
		_tmp54_ = _tmp53_;
		_tmp55_ = m;
		_tmp56_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp55_);
		_tmp57_ = _tmp56_;
		g_string_append_printf (_tmp50_, "<%s name=\"%s\" c:identifier=\"%s\"", _tmp51_, _tmp54_, _tmp57_);
		_g_free0 (_tmp57_);
	}
	_tmp58_ = m;
	_tmp59_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp58_);
	_tmp60_ = _tmp59_;
	if (_tmp60_) {
		GString* _tmp61_;
		_tmp61_ = self->priv->buffer;
		g_string_append_printf (_tmp61_, " throws=\"1\"");
	}
	_tmp62_ = m;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp62_);
	_tmp63_ = self->priv->buffer;
	g_string_append_printf (_tmp63_, ">\n");
	_tmp64_ = self->priv->indent;
	self->priv->indent = _tmp64_ + 1;
	_tmp65_ = m;
	_tmp66_ = vala_gir_writer_get_method_comment (self, (ValaMethod*) _tmp65_);
	_tmp67_ = _tmp66_;
	vala_gir_writer_write_doc (self, _tmp67_);
	_g_free0 (_tmp67_);
	_tmp68_ = m;
	_tmp69_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp68_);
	_tmp70_ = _tmp69_;
	_tmp71_ = vala_ccode_base_module_get_data_type_for_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
	datatype = _tmp71_;
	type_params = NULL;
	_tmp72_ = m;
	_tmp73_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp72_);
	_tmp74_ = _tmp73_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp74_, VALA_TYPE_CLASS)) {
		ValaCreationMethod* _tmp75_;
		ValaSymbol* _tmp76_;
		ValaSymbol* _tmp77_;
		ValaList* _tmp78_;
		_tmp75_ = m;
		_tmp76_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp75_);
		_tmp77_ = _tmp76_;
		_tmp78_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, VALA_TYPE_CLASS, ValaClass));
		_vala_iterable_unref0 (type_params);
		type_params = _tmp78_;
	}
	_tmp79_ = m;
	_tmp80_ = vala_callable_get_parameters ((ValaCallable*) _tmp79_);
	_tmp81_ = _tmp80_;
	_tmp82_ = type_params;
	_tmp83_ = datatype;
	_tmp84_ = m;
	_tmp85_ = vala_gir_writer_get_method_return_comment (self, (ValaMethod*) _tmp84_);
	_tmp86_ = _tmp85_;
	vala_gir_writer_write_params_and_return (self, _tmp81_, _tmp82_, _tmp83_, FALSE, _tmp86_, TRUE, NULL, FALSE);
	_g_free0 (_tmp86_);
	_vala_iterable_unref0 (_tmp81_);
	_tmp87_ = self->priv->indent;
	self->priv->indent = _tmp87_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp88_ = self->priv->buffer;
	_tmp89_ = tag_name;
	g_string_append_printf (_tmp88_, "</%s>\n", _tmp89_);
	_vala_iterable_unref0 (type_params);
	_vala_code_node_unref0 (datatype);
	_g_free0 (tag_name);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = old;
		_tmp1_ = (*((gchar*) _tmp2_)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = old;
		_tmp4_ = replacement;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (self);
		result = _tmp5_;
		return result;
	}
	{
		GRegex* regex = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		gchar* _tmp11_ = NULL;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = old;
		_tmp7_ = g_regex_escape_string (_tmp6_, -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error0_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		regex = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch6_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp12_ = regex;
		_tmp13_ = replacement;
		_tmp14_ = g_regex_replace_literal (_tmp12_, self, (gssize) -1, 0, _tmp13_, 0, &_inner_error0_);
		_tmp11_ = _tmp14_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch6_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp15_ = _tmp11_;
		_tmp11_ = NULL;
		result = _tmp15_;
		_g_free0 (_tmp11_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally6;
	__catch6_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally6:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}


static void vala_gir_writer_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop) {
	ValaGIRWriter * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaProperty* _tmp2_;
	gboolean _tmp3_;
	ValaCodeContext* _tmp18_;
	ValaCodeGenerator* _tmp19_;
	ValaCodeGenerator* _tmp20_;
	ValaProperty* _tmp21_;
	gboolean _tmp22_;
	ValaProperty* _tmp60_;
	ValaPropertyAccessor* _tmp61_;
	ValaPropertyAccessor* _tmp62_;
	ValaProperty* _tmp69_;
	ValaPropertyAccessor* _tmp70_;
	ValaPropertyAccessor* _tmp71_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (prop != NULL);
	_tmp2_ = prop;
	_tmp3_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp2_);
	if (!_tmp3_) {
		_tmp1_ = TRUE;
	} else {
		ValaProperty* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = prop;
		_tmp5_ = vala_property_get_overrides (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp1_ = _tmp6_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		ValaProperty* _tmp9_;
		ValaProperty* _tmp10_;
		ValaProperty* _tmp11_;
		_tmp9_ = prop;
		_tmp10_ = vala_property_get_base_interface_property (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_ != NULL) {
			ValaProperty* _tmp12_;
			gboolean _tmp13_;
			gboolean _tmp14_;
			_tmp12_ = prop;
			_tmp13_ = vala_property_get_is_abstract (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp8_ = !_tmp14_;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			ValaProperty* _tmp15_;
			gboolean _tmp16_;
			gboolean _tmp17_;
			_tmp15_ = prop;
			_tmp16_ = vala_property_get_is_virtual (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp7_ = !_tmp17_;
		} else {
			_tmp7_ = FALSE;
		}
		_tmp0_ = _tmp7_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp18_ = self->priv->context;
	_tmp19_ = vala_code_context_get_codegen (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = prop;
	_tmp22_ = vala_ccode_base_module_is_gobject_property (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModule), _tmp21_);
	if (_tmp22_) {
		GString* _tmp23_;
		ValaProperty* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		ValaProperty* _tmp29_;
		ValaPropertyAccessor* _tmp30_;
		ValaPropertyAccessor* _tmp31_;
		ValaProperty* _tmp33_;
		ValaPropertyAccessor* _tmp34_;
		ValaPropertyAccessor* _tmp35_;
		ValaProperty* _tmp49_;
		GString* _tmp50_;
		gint _tmp51_;
		ValaProperty* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		ValaProperty* _tmp55_;
		ValaDataType* _tmp56_;
		ValaDataType* _tmp57_;
		gint _tmp58_;
		GString* _tmp59_;
		vala_gir_writer_write_indent (self);
		_tmp23_ = self->priv->buffer;
		_tmp24_ = prop;
		_tmp25_ = vala_symbol_get_name ((ValaSymbol*) _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = string_replace (_tmp26_, "_", "-");
		_tmp28_ = _tmp27_;
		g_string_append_printf (_tmp23_, "<property name=\"%s\"", _tmp28_);
		_g_free0 (_tmp28_);
		_tmp29_ = prop;
		_tmp30_ = vala_property_get_get_accessor (_tmp29_);
		_tmp31_ = _tmp30_;
		if (_tmp31_ == NULL) {
			GString* _tmp32_;
			_tmp32_ = self->priv->buffer;
			g_string_append_printf (_tmp32_, " readable=\"0\"");
		}
		_tmp33_ = prop;
		_tmp34_ = vala_property_get_set_accessor (_tmp33_);
		_tmp35_ = _tmp34_;
		if (_tmp35_ != NULL) {
			GString* _tmp36_;
			ValaProperty* _tmp37_;
			ValaPropertyAccessor* _tmp38_;
			ValaPropertyAccessor* _tmp39_;
			gboolean _tmp40_;
			gboolean _tmp41_;
			_tmp36_ = self->priv->buffer;
			g_string_append_printf (_tmp36_, " writable=\"1\"");
			_tmp37_ = prop;
			_tmp38_ = vala_property_get_set_accessor (_tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_property_accessor_get_construction (_tmp39_);
			_tmp41_ = _tmp40_;
			if (_tmp41_) {
				ValaProperty* _tmp42_;
				ValaPropertyAccessor* _tmp43_;
				ValaPropertyAccessor* _tmp44_;
				gboolean _tmp45_;
				gboolean _tmp46_;
				_tmp42_ = prop;
				_tmp43_ = vala_property_get_set_accessor (_tmp42_);
				_tmp44_ = _tmp43_;
				_tmp45_ = vala_property_accessor_get_writable (_tmp44_);
				_tmp46_ = _tmp45_;
				if (!_tmp46_) {
					GString* _tmp47_;
					_tmp47_ = self->priv->buffer;
					g_string_append_printf (_tmp47_, " construct-only=\"1\"");
				} else {
					GString* _tmp48_;
					_tmp48_ = self->priv->buffer;
					g_string_append_printf (_tmp48_, " construct=\"1\"");
				}
			}
		}
		_tmp49_ = prop;
		vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp49_);
		_tmp50_ = self->priv->buffer;
		g_string_append_printf (_tmp50_, ">\n");
		_tmp51_ = self->priv->indent;
		self->priv->indent = _tmp51_ + 1;
		_tmp52_ = prop;
		_tmp53_ = vala_gir_writer_get_property_comment (self, _tmp52_);
		_tmp54_ = _tmp53_;
		vala_gir_writer_write_doc (self, _tmp54_);
		_g_free0 (_tmp54_);
		_tmp55_ = prop;
		_tmp56_ = vala_property_get_property_type (_tmp55_);
		_tmp57_ = _tmp56_;
		vala_gir_writer_write_type (self, _tmp57_, -1, VALA_PARAMETER_DIRECTION_IN);
		_tmp58_ = self->priv->indent;
		self->priv->indent = _tmp58_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp59_ = self->priv->buffer;
		g_string_append_printf (_tmp59_, "</property>\n");
	}
	_tmp60_ = prop;
	_tmp61_ = vala_property_get_get_accessor (_tmp60_);
	_tmp62_ = _tmp61_;
	if (_tmp62_ != NULL) {
		ValaMethod* m = NULL;
		ValaProperty* _tmp63_;
		ValaPropertyAccessor* _tmp64_;
		ValaPropertyAccessor* _tmp65_;
		ValaMethod* _tmp66_;
		ValaMethod* _tmp67_;
		_tmp63_ = prop;
		_tmp64_ = vala_property_get_get_accessor (_tmp63_);
		_tmp65_ = _tmp64_;
		_tmp66_ = vala_property_accessor_get_method (_tmp65_);
		m = _tmp66_;
		_tmp67_ = m;
		if (_tmp67_ != NULL) {
			ValaMethod* _tmp68_;
			_tmp68_ = m;
			vala_code_visitor_visit_method ((ValaCodeVisitor*) self, _tmp68_);
		}
		_vala_code_node_unref0 (m);
	}
	_tmp69_ = prop;
	_tmp70_ = vala_property_get_set_accessor (_tmp69_);
	_tmp71_ = _tmp70_;
	if (_tmp71_ != NULL) {
		ValaMethod* m = NULL;
		ValaProperty* _tmp72_;
		ValaPropertyAccessor* _tmp73_;
		ValaPropertyAccessor* _tmp74_;
		ValaMethod* _tmp75_;
		ValaMethod* _tmp76_;
		_tmp72_ = prop;
		_tmp73_ = vala_property_get_set_accessor (_tmp72_);
		_tmp74_ = _tmp73_;
		_tmp75_ = vala_property_accessor_get_method (_tmp74_);
		m = _tmp75_;
		_tmp76_ = m;
		if (_tmp76_ != NULL) {
			ValaMethod* _tmp77_;
			_tmp77_ = m;
			vala_code_visitor_visit_method ((ValaCodeVisitor*) self, _tmp77_);
		}
		_vala_code_node_unref0 (m);
	}
}


static void vala_gir_writer_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig) {
	ValaGIRWriter * self;
	ValaSignal* _tmp0_;
	gboolean _tmp1_;
	ValaSignal* _tmp2_;
	ValaMethod* _tmp3_;
	ValaMethod* _tmp4_;
	GString* _tmp8_;
	ValaSignal* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	ValaSignal* _tmp12_;
	GString* _tmp13_;
	gint _tmp14_;
	ValaSignal* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	ValaSignal* _tmp18_;
	ValaList* _tmp19_;
	ValaList* _tmp20_;
	ValaSignal* _tmp21_;
	ValaDataType* _tmp22_;
	ValaDataType* _tmp23_;
	ValaSignal* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gint _tmp27_;
	GString* _tmp28_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (sig != NULL);
	_tmp0_ = sig;
	_tmp1_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = sig;
	_tmp3_ = vala_signal_get_emitter (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		ValaSignal* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		_tmp5_ = sig;
		_tmp6_ = vala_signal_get_emitter (_tmp5_);
		_tmp7_ = _tmp6_;
		vala_code_node_accept ((ValaCodeNode*) _tmp7_, (ValaCodeVisitor*) self);
	}
	vala_gir_writer_write_indent (self);
	_tmp8_ = self->priv->buffer;
	_tmp9_ = sig;
	_tmp10_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp9_);
	_tmp11_ = _tmp10_;
	g_string_append_printf (_tmp8_, "<glib:signal name=\"%s\"", _tmp11_);
	_g_free0 (_tmp11_);
	_tmp12_ = sig;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp12_);
	_tmp13_ = self->priv->buffer;
	g_string_append_printf (_tmp13_, ">\n");
	_tmp14_ = self->priv->indent;
	self->priv->indent = _tmp14_ + 1;
	_tmp15_ = sig;
	_tmp16_ = vala_gir_writer_get_signal_comment (self, _tmp15_);
	_tmp17_ = _tmp16_;
	vala_gir_writer_write_doc (self, _tmp17_);
	_g_free0 (_tmp17_);
	_tmp18_ = sig;
	_tmp19_ = vala_callable_get_parameters ((ValaCallable*) _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = sig;
	_tmp22_ = vala_callable_get_return_type ((ValaCallable*) _tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = sig;
	_tmp25_ = vala_gir_writer_get_signal_return_comment (self, _tmp24_);
	_tmp26_ = _tmp25_;
	vala_gir_writer_write_params_and_return (self, _tmp20_, NULL, _tmp23_, FALSE, _tmp26_, FALSE, NULL, FALSE);
	_g_free0 (_tmp26_);
	_vala_iterable_unref0 (_tmp20_);
	_tmp27_ = self->priv->indent;
	self->priv->indent = _tmp27_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp28_ = self->priv->buffer;
	g_string_append_printf (_tmp28_, "</glib:signal>\n");
}


static void vala_gir_writer_write_indent (ValaGIRWriter* self) {
	gint i = 0;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_ = FALSE;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gint _tmp2_;
			gint _tmp3_;
			GString* _tmp4_;
			if (!_tmp0_) {
				gint _tmp1_;
				_tmp1_ = i;
				i = _tmp1_ + 1;
			}
			_tmp0_ = FALSE;
			_tmp2_ = i;
			_tmp3_ = self->priv->indent;
			if (!(_tmp2_ < _tmp3_)) {
				break;
			}
			_tmp4_ = self->priv->buffer;
			g_string_append_c (_tmp4_, '\t');
		}
	}
}


static void vala_gir_writer_write_indent_stream (ValaGIRWriter* self) {
	gint i = 0;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_ = FALSE;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gint _tmp2_;
			gint _tmp3_;
			FILE* _tmp4_;
			if (!_tmp0_) {
				gint _tmp1_;
				_tmp1_ = i;
				i = _tmp1_ + 1;
			}
			_tmp0_ = FALSE;
			_tmp2_ = i;
			_tmp3_ = self->priv->indent;
			if (!(_tmp2_ < _tmp3_)) {
				break;
			}
			_tmp4_ = self->priv->stream;
			fputc ('\t', _tmp4_);
		}
	}
}


static void vala_gir_writer_write_param_or_return (ValaGIRWriter* self, ValaDataType* type, gboolean is_parameter, gint* index, gboolean has_array_length, const gchar* name, const gchar* comment, ValaParameterDirection direction, gboolean constructor, gboolean caller_allocates, gboolean ellipsis) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	gchar* tag = NULL;
	gchar* _tmp2_;
	GString* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_;
	const gchar* _tmp6_;
	ValaParameterDirection _tmp9_;
	ValaDelegateType* delegate_type = NULL;
	ValaDataType* _tmp13_;
	ValaArrayType* array_type = NULL;
	ValaDataType* _tmp14_;
	gboolean _tmp15_ = FALSE;
	ValaDataType* _tmp16_;
	gboolean _tmp60_;
	gboolean _tmp62_ = FALSE;
	ValaDataType* _tmp63_;
	gboolean _tmp68_ = FALSE;
	ValaDelegateType* _tmp69_;
	GString* _tmp98_;
	gint _tmp99_;
	const gchar* _tmp100_;
	gboolean _tmp101_;
	gint _tmp112_;
	GString* _tmp113_;
	const gchar* _tmp114_;
	gint _tmp115_;
	g_return_if_fail (self != NULL);
	vala_gir_writer_write_indent (self);
	_tmp1_ = is_parameter;
	if (_tmp1_) {
		_tmp0_ = "parameter";
	} else {
		_tmp0_ = "return-value";
	}
	_tmp2_ = g_strdup (_tmp0_);
	tag = _tmp2_;
	_tmp3_ = self->priv->buffer;
	_tmp4_ = tag;
	g_string_append_printf (_tmp3_, "<%s", _tmp4_);
	_tmp5_ = ellipsis;
	if (_tmp5_) {
		name = "...";
	}
	_tmp6_ = name;
	if (_tmp6_ != NULL) {
		GString* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = self->priv->buffer;
		_tmp8_ = name;
		g_string_append_printf (_tmp7_, " name=\"%s\"", _tmp8_);
	}
	_tmp9_ = direction;
	if (_tmp9_ == VALA_PARAMETER_DIRECTION_REF) {
		GString* _tmp10_;
		_tmp10_ = self->priv->buffer;
		g_string_append_printf (_tmp10_, " direction=\"inout\"");
	} else {
		ValaParameterDirection _tmp11_;
		_tmp11_ = direction;
		if (_tmp11_ == VALA_PARAMETER_DIRECTION_OUT) {
			GString* _tmp12_;
			_tmp12_ = self->priv->buffer;
			g_string_append_printf (_tmp12_, " direction=\"out\"");
		}
	}
	_tmp13_ = type;
	delegate_type = G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, VALA_TYPE_DELEGATE_TYPE) ? ((ValaDelegateType*) _tmp13_) : NULL;
	_tmp14_ = type;
	array_type = G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALA_TYPE_ARRAY_TYPE) ? ((ValaArrayType*) _tmp14_) : NULL;
	_tmp16_ = type;
	if (_tmp16_ != NULL) {
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		ValaDataType* _tmp19_;
		gboolean _tmp20_;
		gboolean _tmp21_;
		_tmp19_ = type;
		_tmp20_ = vala_data_type_get_value_owned (_tmp19_);
		_tmp21_ = _tmp20_;
		if (_tmp21_) {
			ValaDelegateType* _tmp22_;
			_tmp22_ = delegate_type;
			_tmp18_ = _tmp22_ == NULL;
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			_tmp17_ = TRUE;
		} else {
			gboolean _tmp23_ = FALSE;
			gboolean _tmp24_;
			_tmp24_ = constructor;
			if (_tmp24_) {
				ValaDataType* _tmp25_;
				ValaTypeSymbol* _tmp26_;
				ValaTypeSymbol* _tmp27_;
				ValaTypeSymbol* _tmp28_;
				gboolean _tmp29_;
				_tmp25_ = type;
				_tmp26_ = vala_data_type_get_data_type (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = self->priv->ginitiallyunowned_type;
				_tmp29_ = vala_typesymbol_is_subtype_of (_tmp27_, _tmp28_);
				_tmp23_ = !_tmp29_;
			} else {
				_tmp23_ = FALSE;
			}
			_tmp17_ = _tmp23_;
		}
		_tmp15_ = _tmp17_;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		gboolean any_owned = FALSE;
		gboolean _tmp45_ = FALSE;
		ValaDataType* _tmp46_;
		gboolean _tmp47_;
		any_owned = FALSE;
		{
			ValaList* _generic_arg_list = NULL;
			ValaDataType* _tmp30_;
			ValaList* _tmp31_;
			gint _generic_arg_size = 0;
			ValaList* _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			gint _generic_arg_index = 0;
			_tmp30_ = type;
			_tmp31_ = vala_data_type_get_type_arguments (_tmp30_);
			_generic_arg_list = _tmp31_;
			_tmp32_ = _generic_arg_list;
			_tmp33_ = vala_collection_get_size ((ValaCollection*) _tmp32_);
			_tmp34_ = _tmp33_;
			_generic_arg_size = _tmp34_;
			_generic_arg_index = -1;
			while (TRUE) {
				gint _tmp35_;
				gint _tmp36_;
				gint _tmp37_;
				ValaDataType* generic_arg = NULL;
				ValaList* _tmp38_;
				gint _tmp39_;
				gpointer _tmp40_;
				gboolean _tmp41_;
				ValaDataType* _tmp42_;
				gboolean _tmp43_;
				gboolean _tmp44_;
				_tmp35_ = _generic_arg_index;
				_generic_arg_index = _tmp35_ + 1;
				_tmp36_ = _generic_arg_index;
				_tmp37_ = _generic_arg_size;
				if (!(_tmp36_ < _tmp37_)) {
					break;
				}
				_tmp38_ = _generic_arg_list;
				_tmp39_ = _generic_arg_index;
				_tmp40_ = vala_list_get (_tmp38_, _tmp39_);
				generic_arg = (ValaDataType*) _tmp40_;
				_tmp41_ = any_owned;
				_tmp42_ = generic_arg;
				_tmp43_ = vala_data_type_get_value_owned (_tmp42_);
				_tmp44_ = _tmp43_;
				any_owned = _tmp41_ | _tmp44_;
				_vala_code_node_unref0 (generic_arg);
			}
			_vala_iterable_unref0 (_generic_arg_list);
		}
		_tmp46_ = type;
		_tmp47_ = vala_data_type_has_type_arguments (_tmp46_);
		if (_tmp47_) {
			gboolean _tmp48_;
			_tmp48_ = any_owned;
			_tmp45_ = !_tmp48_;
		} else {
			_tmp45_ = FALSE;
		}
		if (_tmp45_) {
			GString* _tmp49_;
			_tmp49_ = self->priv->buffer;
			g_string_append_printf (_tmp49_, " transfer-ownership=\"container\"");
		} else {
			gboolean _tmp50_ = FALSE;
			ValaArrayType* _tmp51_;
			_tmp51_ = array_type;
			if (_tmp51_ != NULL) {
				ValaArrayType* _tmp52_;
				ValaDataType* _tmp53_;
				ValaDataType* _tmp54_;
				gboolean _tmp55_;
				gboolean _tmp56_;
				_tmp52_ = array_type;
				_tmp53_ = vala_array_type_get_element_type (_tmp52_);
				_tmp54_ = _tmp53_;
				_tmp55_ = vala_data_type_get_value_owned (_tmp54_);
				_tmp56_ = _tmp55_;
				_tmp50_ = !_tmp56_;
			} else {
				_tmp50_ = FALSE;
			}
			if (_tmp50_) {
				GString* _tmp57_;
				_tmp57_ = self->priv->buffer;
				g_string_append_printf (_tmp57_, " transfer-ownership=\"container\"");
			} else {
				GString* _tmp58_;
				_tmp58_ = self->priv->buffer;
				g_string_append_printf (_tmp58_, " transfer-ownership=\"full\"");
			}
		}
	} else {
		GString* _tmp59_;
		_tmp59_ = self->priv->buffer;
		g_string_append_printf (_tmp59_, " transfer-ownership=\"none\"");
	}
	_tmp60_ = caller_allocates;
	if (_tmp60_) {
		GString* _tmp61_;
		_tmp61_ = self->priv->buffer;
		g_string_append_printf (_tmp61_, " caller-allocates=\"1\"");
	}
	_tmp63_ = type;
	if (_tmp63_ != NULL) {
		ValaDataType* _tmp64_;
		gboolean _tmp65_;
		gboolean _tmp66_;
		_tmp64_ = type;
		_tmp65_ = vala_data_type_get_nullable (_tmp64_);
		_tmp66_ = _tmp65_;
		_tmp62_ = _tmp66_;
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		GString* _tmp67_;
		_tmp67_ = self->priv->buffer;
		g_string_append_printf (_tmp67_, " allow-none=\"1\"");
	}
	_tmp69_ = delegate_type;
	if (_tmp69_ != NULL) {
		ValaDelegateType* _tmp70_;
		ValaDelegate* _tmp71_;
		ValaDelegate* _tmp72_;
		gboolean _tmp73_;
		gboolean _tmp74_;
		_tmp70_ = delegate_type;
		_tmp71_ = vala_delegate_type_get_delegate_symbol (_tmp70_);
		_tmp72_ = _tmp71_;
		_tmp73_ = vala_delegate_get_has_target (_tmp72_);
		_tmp74_ = _tmp73_;
		_tmp68_ = _tmp74_;
	} else {
		_tmp68_ = FALSE;
	}
	if (_tmp68_) {
		gint _tmp75_ = 0;
		gboolean _tmp76_;
		gint closure_index = 0;
		GString* _tmp84_;
		gint _tmp85_;
		ValaDelegateType* _tmp86_;
		gboolean _tmp87_;
		gboolean _tmp88_;
		_tmp76_ = is_parameter;
		if (_tmp76_) {
			gint _tmp77_;
			_tmp77_ = *index;
			_tmp75_ = _tmp77_ + 1;
		} else {
			gint _tmp78_ = 0;
			ValaDataType* _tmp79_;
			gboolean _tmp80_;
			gboolean _tmp81_;
			_tmp79_ = type;
			_tmp80_ = vala_data_type_get_value_owned (_tmp79_);
			_tmp81_ = _tmp80_;
			if (_tmp81_) {
				gint _tmp82_;
				_tmp82_ = *index;
				_tmp78_ = _tmp82_ - 1;
			} else {
				gint _tmp83_;
				_tmp83_ = *index;
				_tmp78_ = _tmp83_;
			}
			_tmp75_ = _tmp78_;
		}
		closure_index = _tmp75_;
		_tmp84_ = self->priv->buffer;
		_tmp85_ = closure_index;
		g_string_append_printf (_tmp84_, " closure=\"%i\"", _tmp85_);
		_tmp86_ = delegate_type;
		_tmp87_ = vala_delegate_type_get_is_called_once (_tmp86_);
		_tmp88_ = _tmp87_;
		if (_tmp88_) {
			GString* _tmp89_;
			_tmp89_ = self->priv->buffer;
			g_string_append (_tmp89_, " scope=\"async\"");
		} else {
			ValaDataType* _tmp90_;
			gboolean _tmp91_;
			gboolean _tmp92_;
			_tmp90_ = type;
			_tmp91_ = vala_data_type_get_value_owned (_tmp90_);
			_tmp92_ = _tmp91_;
			if (_tmp92_) {
				GString* _tmp93_;
				gint _tmp94_;
				_tmp93_ = self->priv->buffer;
				_tmp94_ = closure_index;
				g_string_append_printf (_tmp93_, " scope=\"notified\" destroy=\"%i\"", _tmp94_ + 1);
			} else {
				GString* _tmp95_;
				_tmp95_ = self->priv->buffer;
				g_string_append (_tmp95_, " scope=\"call\"");
			}
		}
	} else {
		ValaDelegateType* _tmp96_;
		_tmp96_ = delegate_type;
		if (_tmp96_ != NULL) {
			GString* _tmp97_;
			_tmp97_ = self->priv->buffer;
			g_string_append (_tmp97_, " scope=\"call\"");
		}
	}
	_tmp98_ = self->priv->buffer;
	g_string_append_printf (_tmp98_, ">\n");
	_tmp99_ = self->priv->indent;
	self->priv->indent = _tmp99_ + 1;
	_tmp100_ = comment;
	vala_gir_writer_write_doc (self, _tmp100_);
	_tmp101_ = ellipsis;
	if (_tmp101_) {
		GString* _tmp102_;
		vala_gir_writer_write_indent (self);
		_tmp102_ = self->priv->buffer;
		g_string_append (_tmp102_, "<varargs/>\n");
	} else {
		ValaDataType* _tmp103_;
		_tmp103_ = type;
		if (_tmp103_ != NULL) {
			gint length_param_index = 0;
			gboolean _tmp104_;
			ValaDataType* _tmp109_;
			gint _tmp110_;
			ValaParameterDirection _tmp111_;
			length_param_index = -1;
			_tmp104_ = has_array_length;
			if (_tmp104_) {
				gint _tmp105_ = 0;
				gboolean _tmp106_;
				_tmp106_ = is_parameter;
				if (_tmp106_) {
					gint _tmp107_;
					_tmp107_ = *index;
					_tmp105_ = _tmp107_ + 1;
				} else {
					gint _tmp108_;
					_tmp108_ = *index;
					_tmp105_ = _tmp108_;
				}
				length_param_index = _tmp105_;
			}
			_tmp109_ = type;
			_tmp110_ = length_param_index;
			_tmp111_ = direction;
			vala_gir_writer_write_type (self, _tmp109_, _tmp110_, _tmp111_);
		}
	}
	_tmp112_ = self->priv->indent;
	self->priv->indent = _tmp112_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp113_ = self->priv->buffer;
	_tmp114_ = tag;
	g_string_append_printf (_tmp113_, "</%s>\n", _tmp114_);
	_tmp115_ = *index;
	*index = _tmp115_ + 1;
	_g_free0 (tag);
}


static void vala_gir_writer_write_ctype_attributes (ValaGIRWriter* self, ValaTypeSymbol* symbol, const gchar* suffix) {
	GString* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	g_return_if_fail (suffix != NULL);
	_tmp0_ = self->priv->buffer;
	_tmp1_ = symbol;
	_tmp2_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = suffix;
	g_string_append_printf (_tmp0_, " c:type=\"%s%s\"", _tmp3_, _tmp4_);
	_g_free0 (_tmp3_);
}


static void vala_gir_writer_write_gtype_attributes (ValaGIRWriter* self, ValaTypeSymbol* symbol) {
	ValaTypeSymbol* _tmp0_;
	GString* _tmp1_;
	ValaTypeSymbol* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GString* _tmp5_;
	ValaTypeSymbol* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	_tmp0_ = symbol;
	vala_gir_writer_write_ctype_attributes (self, _tmp0_, "");
	_tmp1_ = self->priv->buffer;
	_tmp2_ = symbol;
	_tmp3_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp2_);
	_tmp4_ = _tmp3_;
	g_string_append_printf (_tmp1_, " glib:type-name=\"%s\"", _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = self->priv->buffer;
	_tmp6_ = symbol;
	_tmp7_ = vala_ccode_base_module_get_ccode_lower_case_prefix ((ValaSymbol*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append_printf (_tmp5_, " glib:get-type=\"%sget_type\"", _tmp8_);
	_g_free0 (_tmp8_);
}


static void vala_gir_writer_write_type (ValaGIRWriter* self, ValaDataType* type, gint index, ValaParameterDirection direction) {
	ValaDataType* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_ARRAY_TYPE)) {
		ValaArrayType* array_type = NULL;
		ValaDataType* _tmp1_;
		ValaArrayType* _tmp2_;
		GString* _tmp3_;
		gboolean _tmp4_ = FALSE;
		ValaArrayType* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		const gchar* _tmp23_ = NULL;
		ValaParameterDirection _tmp24_;
		GString* _tmp25_;
		ValaArrayType* _tmp26_;
		ValaDataType* _tmp27_;
		ValaDataType* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		GString* _tmp31_;
		gint _tmp32_;
		ValaArrayType* _tmp33_;
		ValaDataType* _tmp34_;
		ValaDataType* _tmp35_;
		gint _tmp36_;
		GString* _tmp37_;
		_tmp1_ = type;
		_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp2_;
		vala_gir_writer_write_indent (self);
		_tmp3_ = self->priv->buffer;
		g_string_append_printf (_tmp3_, "<array");
		_tmp5_ = array_type;
		_tmp6_ = vala_array_type_get_fixed_length (_tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp7_) {
			ValaArrayType* _tmp8_;
			ValaExpression* _tmp9_;
			ValaExpression* _tmp10_;
			_tmp8_ = array_type;
			_tmp9_ = vala_array_type_get_length (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, VALA_TYPE_INTEGER_LITERAL);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaIntegerLiteral* lit = NULL;
			ValaArrayType* _tmp11_;
			ValaExpression* _tmp12_;
			ValaExpression* _tmp13_;
			ValaIntegerLiteral* _tmp14_;
			GString* _tmp15_;
			ValaIntegerLiteral* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			gint _tmp19_;
			_tmp11_ = array_type;
			_tmp12_ = vala_array_type_get_length (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteral));
			lit = _tmp14_;
			_tmp15_ = self->priv->buffer;
			_tmp16_ = lit;
			_tmp17_ = vala_integer_literal_get_value (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = atoi (_tmp18_);
			g_string_append_printf (_tmp15_, " fixed-size=\"%i\"", _tmp19_);
			_vala_code_node_unref0 (lit);
		} else {
			gint _tmp20_;
			_tmp20_ = index;
			if (_tmp20_ != -1) {
				GString* _tmp21_;
				gint _tmp22_;
				_tmp21_ = self->priv->buffer;
				_tmp22_ = index;
				g_string_append_printf (_tmp21_, " length=\"%i\"", _tmp22_);
			}
		}
		_tmp24_ = direction;
		if (_tmp24_ == VALA_PARAMETER_DIRECTION_IN) {
			_tmp23_ = "*";
		} else {
			_tmp23_ = "**";
		}
		_tmp25_ = self->priv->buffer;
		_tmp26_ = array_type;
		_tmp27_ = vala_array_type_get_element_type (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp28_);
		_tmp30_ = _tmp29_;
		g_string_append_printf (_tmp25_, " c:type=\"%s%s\"", _tmp30_, _tmp23_);
		_g_free0 (_tmp30_);
		_tmp31_ = self->priv->buffer;
		g_string_append_printf (_tmp31_, ">\n");
		_tmp32_ = self->priv->indent;
		self->priv->indent = _tmp32_ + 1;
		_tmp33_ = array_type;
		_tmp34_ = vala_array_type_get_element_type (_tmp33_);
		_tmp35_ = _tmp34_;
		vala_gir_writer_write_type (self, _tmp35_, -1, VALA_PARAMETER_DIRECTION_IN);
		_tmp36_ = self->priv->indent;
		self->priv->indent = _tmp36_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp37_ = self->priv->buffer;
		g_string_append_printf (_tmp37_, "</array>\n");
		_vala_code_node_unref0 (array_type);
	} else {
		ValaDataType* _tmp38_;
		_tmp38_ = type;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp38_, VALA_TYPE_VOID_TYPE)) {
			GString* _tmp39_;
			vala_gir_writer_write_indent (self);
			_tmp39_ = self->priv->buffer;
			g_string_append_printf (_tmp39_, "<type name=\"none\"/>\n");
		} else {
			ValaDataType* _tmp40_;
			_tmp40_ = type;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp40_, VALA_TYPE_POINTER_TYPE)) {
				const gchar* _tmp41_ = NULL;
				ValaParameterDirection _tmp42_;
				GString* _tmp43_;
				ValaDataType* _tmp44_;
				gchar* _tmp45_;
				gchar* _tmp46_;
				vala_gir_writer_write_indent (self);
				_tmp42_ = direction;
				if (_tmp42_ == VALA_PARAMETER_DIRECTION_IN) {
					_tmp41_ = "";
				} else {
					_tmp41_ = "*";
				}
				_tmp43_ = self->priv->buffer;
				_tmp44_ = type;
				_tmp45_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp44_);
				_tmp46_ = _tmp45_;
				g_string_append_printf (_tmp43_, "<type name=\"gpointer\" c:type=\"%s%s\"/>\n", _tmp46_, _tmp41_);
				_g_free0 (_tmp46_);
			} else {
				ValaDataType* _tmp47_;
				ValaTypeSymbol* _tmp48_;
				ValaTypeSymbol* _tmp49_;
				_tmp47_ = type;
				_tmp48_ = vala_data_type_get_data_type (_tmp47_);
				_tmp49_ = _tmp48_;
				if (_tmp49_ != NULL) {
					gchar* type_name = NULL;
					ValaDataType* _tmp50_;
					ValaTypeSymbol* _tmp51_;
					ValaTypeSymbol* _tmp52_;
					gchar* _tmp53_;
					gboolean is_array = FALSE;
					gboolean _tmp54_ = FALSE;
					const gchar* _tmp55_;
					const gchar* _tmp57_ = NULL;
					gboolean _tmp58_;
					const gchar* _tmp59_ = NULL;
					ValaParameterDirection _tmp60_;
					GString* _tmp61_;
					ValaDataType* _tmp62_;
					ValaTypeSymbol* _tmp63_;
					ValaTypeSymbol* _tmp64_;
					gchar* _tmp65_;
					gchar* _tmp66_;
					ValaDataType* _tmp67_;
					gchar* _tmp68_;
					gchar* _tmp69_;
					ValaList* type_arguments = NULL;
					ValaDataType* _tmp70_;
					ValaList* _tmp71_;
					ValaList* _tmp72_;
					gint _tmp73_;
					gint _tmp74_;
					vala_gir_writer_write_indent (self);
					_tmp50_ = type;
					_tmp51_ = vala_data_type_get_data_type (_tmp50_);
					_tmp52_ = _tmp51_;
					_tmp53_ = vala_gir_writer_gi_type_name (self, _tmp52_);
					type_name = _tmp53_;
					is_array = FALSE;
					_tmp55_ = type_name;
					if (g_strcmp0 (_tmp55_, "GLib.Array") == 0) {
						_tmp54_ = TRUE;
					} else {
						const gchar* _tmp56_;
						_tmp56_ = type_name;
						_tmp54_ = g_strcmp0 (_tmp56_, "GLib.PtrArray") == 0;
					}
					if (_tmp54_) {
						is_array = TRUE;
					}
					_tmp58_ = is_array;
					if (_tmp58_) {
						_tmp57_ = "array";
					} else {
						_tmp57_ = "type";
					}
					_tmp60_ = direction;
					if (_tmp60_ == VALA_PARAMETER_DIRECTION_IN) {
						_tmp59_ = "";
					} else {
						_tmp59_ = "*";
					}
					_tmp61_ = self->priv->buffer;
					_tmp62_ = type;
					_tmp63_ = vala_data_type_get_data_type (_tmp62_);
					_tmp64_ = _tmp63_;
					_tmp65_ = vala_gir_writer_gi_type_name (self, _tmp64_);
					_tmp66_ = _tmp65_;
					_tmp67_ = type;
					_tmp68_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp67_);
					_tmp69_ = _tmp68_;
					g_string_append_printf (_tmp61_, "<%s name=\"%s\" c:type=\"%s%s\"", _tmp57_, _tmp66_, _tmp69_, _tmp59_);
					_g_free0 (_tmp69_);
					_g_free0 (_tmp66_);
					_tmp70_ = type;
					_tmp71_ = vala_data_type_get_type_arguments (_tmp70_);
					type_arguments = _tmp71_;
					_tmp72_ = type_arguments;
					_tmp73_ = vala_collection_get_size ((ValaCollection*) _tmp72_);
					_tmp74_ = _tmp73_;
					if (_tmp74_ == 0) {
						GString* _tmp75_;
						_tmp75_ = self->priv->buffer;
						g_string_append_printf (_tmp75_, "/>\n");
					} else {
						GString* _tmp76_;
						gint _tmp77_;
						gint _tmp90_;
						const gchar* _tmp91_ = NULL;
						gboolean _tmp92_;
						GString* _tmp93_;
						_tmp76_ = self->priv->buffer;
						g_string_append_printf (_tmp76_, ">\n");
						_tmp77_ = self->priv->indent;
						self->priv->indent = _tmp77_ + 1;
						{
							ValaList* _type_argument_list = NULL;
							ValaList* _tmp78_;
							ValaList* _tmp79_;
							gint _type_argument_size = 0;
							ValaList* _tmp80_;
							gint _tmp81_;
							gint _tmp82_;
							gint _type_argument_index = 0;
							_tmp78_ = type_arguments;
							_tmp79_ = _vala_iterable_ref0 (_tmp78_);
							_type_argument_list = _tmp79_;
							_tmp80_ = _type_argument_list;
							_tmp81_ = vala_collection_get_size ((ValaCollection*) _tmp80_);
							_tmp82_ = _tmp81_;
							_type_argument_size = _tmp82_;
							_type_argument_index = -1;
							while (TRUE) {
								gint _tmp83_;
								gint _tmp84_;
								gint _tmp85_;
								ValaDataType* type_argument = NULL;
								ValaList* _tmp86_;
								gint _tmp87_;
								gpointer _tmp88_;
								ValaDataType* _tmp89_;
								_tmp83_ = _type_argument_index;
								_type_argument_index = _tmp83_ + 1;
								_tmp84_ = _type_argument_index;
								_tmp85_ = _type_argument_size;
								if (!(_tmp84_ < _tmp85_)) {
									break;
								}
								_tmp86_ = _type_argument_list;
								_tmp87_ = _type_argument_index;
								_tmp88_ = vala_list_get (_tmp86_, _tmp87_);
								type_argument = (ValaDataType*) _tmp88_;
								_tmp89_ = type_argument;
								vala_gir_writer_write_type (self, _tmp89_, -1, VALA_PARAMETER_DIRECTION_IN);
								_vala_code_node_unref0 (type_argument);
							}
							_vala_iterable_unref0 (_type_argument_list);
						}
						_tmp90_ = self->priv->indent;
						self->priv->indent = _tmp90_ - 1;
						vala_gir_writer_write_indent (self);
						_tmp92_ = is_array;
						if (_tmp92_) {
							_tmp91_ = "array";
						} else {
							_tmp91_ = "type";
						}
						_tmp93_ = self->priv->buffer;
						g_string_append_printf (_tmp93_, "</%s>\n", _tmp91_);
					}
					_vala_iterable_unref0 (type_arguments);
					_g_free0 (type_name);
				} else {
					ValaDataType* _tmp94_;
					_tmp94_ = type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp94_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDelegateType* deleg_type = NULL;
						ValaDataType* _tmp95_;
						ValaDelegateType* _tmp96_;
						const gchar* _tmp97_ = NULL;
						ValaParameterDirection _tmp98_;
						GString* _tmp99_;
						ValaDelegateType* _tmp100_;
						ValaDelegate* _tmp101_;
						ValaDelegate* _tmp102_;
						gchar* _tmp103_;
						gchar* _tmp104_;
						ValaDataType* _tmp105_;
						gchar* _tmp106_;
						gchar* _tmp107_;
						_tmp95_ = type;
						_tmp96_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp95_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						deleg_type = _tmp96_;
						vala_gir_writer_write_indent (self);
						_tmp98_ = direction;
						if (_tmp98_ == VALA_PARAMETER_DIRECTION_IN) {
							_tmp97_ = "";
						} else {
							_tmp97_ = "*";
						}
						_tmp99_ = self->priv->buffer;
						_tmp100_ = deleg_type;
						_tmp101_ = vala_delegate_type_get_delegate_symbol (_tmp100_);
						_tmp102_ = _tmp101_;
						_tmp103_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp102_);
						_tmp104_ = _tmp103_;
						_tmp105_ = type;
						_tmp106_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp105_);
						_tmp107_ = _tmp106_;
						g_string_append_printf (_tmp99_, "<type name=\"%s\" c:type=\"%s%s\"/>\n", _tmp104_, _tmp107_, _tmp97_);
						_g_free0 (_tmp107_);
						_g_free0 (_tmp104_);
						_vala_code_node_unref0 (deleg_type);
					} else {
						ValaDataType* _tmp108_;
						_tmp108_ = type;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp108_, VALA_TYPE_GENERIC_TYPE)) {
							GString* _tmp109_;
							vala_gir_writer_write_indent (self);
							_tmp109_ = self->priv->buffer;
							g_string_append (_tmp109_, "<type name=\"gpointer\" c:type=\"gpointer\"/>\n");
						} else {
							GString* _tmp110_;
							ValaDataType* _tmp111_;
							gchar* _tmp112_;
							gchar* _tmp113_;
							vala_gir_writer_write_indent (self);
							_tmp110_ = self->priv->buffer;
							_tmp111_ = type;
							_tmp112_ = vala_code_node_to_string ((ValaCodeNode*) _tmp111_);
							_tmp113_ = _tmp112_;
							g_string_append_printf (_tmp110_, "<type name=\"%s\"/>\n", _tmp113_);
							_g_free0 (_tmp113_);
						}
					}
				}
			}
		}
	}
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gchar* vala_gir_writer_get_full_gir_name (ValaGIRWriter* self, ValaSymbol* sym) {
	gchar* result = NULL;
	gchar* gir_fullname = NULL;
	ValaSymbol* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* gir_name = NULL;
	ValaSymbol* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	const gchar* _tmp10_;
	ValaSymbol* _tmp15_;
	ValaSymbol* _tmp16_;
	ValaSymbol* _tmp17_;
	ValaSymbol* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* parent_gir_name = NULL;
	ValaSymbol* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gchar* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_ = NULL;
	const gchar* _tmp31_;
	gboolean _tmp32_;
	gchar* self_gir_name = NULL;
	gchar* _tmp37_;
	const gchar* _tmp38_;
	gboolean _tmp39_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = sym;
	_tmp1_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp0_, "GIR", "fullname", NULL);
	gir_fullname = _tmp1_;
	_tmp2_ = gir_fullname;
	if (_tmp2_ != NULL) {
		result = gir_fullname;
		return result;
	}
	_tmp3_ = sym;
	_tmp4_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp3_, "GIR", "name", NULL);
	gir_name = _tmp4_;
	_tmp6_ = gir_name;
	if (_tmp6_ == NULL) {
		ValaSymbol* _tmp7_;
		_tmp7_ = sym;
		_tmp5_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_NAMESPACE);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaSymbol* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = sym;
		_tmp9_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp8_, "CCode", "gir_namespace", NULL);
		_g_free0 (gir_name);
		gir_name = _tmp9_;
	}
	_tmp10_ = gir_name;
	if (_tmp10_ == NULL) {
		ValaSymbol* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp11_ = sym;
		_tmp12_ = vala_symbol_get_name (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strdup (_tmp13_);
		_g_free0 (gir_name);
		gir_name = _tmp14_;
	}
	_tmp15_ = sym;
	_tmp16_ = vala_symbol_get_parent_symbol (_tmp15_);
	_tmp17_ = _tmp16_;
	if (_tmp17_ == NULL) {
		result = gir_name;
		_g_free0 (gir_fullname);
		return result;
	}
	_tmp18_ = sym;
	_tmp19_ = vala_symbol_get_name (_tmp18_);
	_tmp20_ = _tmp19_;
	if (_tmp20_ == NULL) {
		ValaSymbol* _tmp21_;
		ValaSymbol* _tmp22_;
		ValaSymbol* _tmp23_;
		gchar* _tmp24_;
		_tmp21_ = sym;
		_tmp22_ = vala_symbol_get_parent_symbol (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = vala_gir_writer_get_full_gir_name (self, _tmp23_);
		result = _tmp24_;
		_g_free0 (gir_name);
		_g_free0 (gir_fullname);
		return result;
	}
	_tmp25_ = sym;
	_tmp26_ = vala_symbol_get_parent_symbol (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_gir_writer_get_full_gir_name (self, _tmp27_);
	parent_gir_name = _tmp28_;
	_tmp29_ = parent_gir_name;
	if (_tmp29_ == NULL) {
		result = gir_name;
		_g_free0 (parent_gir_name);
		_g_free0 (gir_fullname);
		return result;
	}
	_tmp31_ = gir_name;
	_tmp32_ = g_str_has_prefix (_tmp31_, ".");
	if (_tmp32_) {
		const gchar* _tmp33_;
		gchar* _tmp34_;
		_tmp33_ = gir_name;
		_tmp34_ = string_substring (_tmp33_, (glong) 1, (glong) -1);
		_g_free0 (_tmp30_);
		_tmp30_ = _tmp34_;
	} else {
		const gchar* _tmp35_;
		gchar* _tmp36_;
		_tmp35_ = gir_name;
		_tmp36_ = g_strdup (_tmp35_);
		_g_free0 (_tmp30_);
		_tmp30_ = _tmp36_;
	}
	_tmp37_ = g_strdup (_tmp30_);
	self_gir_name = _tmp37_;
	_tmp38_ = parent_gir_name;
	_tmp39_ = string_contains (_tmp38_, ".");
	if (_tmp39_) {
		const gchar* _tmp40_;
		const gchar* _tmp41_;
		gchar* _tmp42_;
		_tmp40_ = parent_gir_name;
		_tmp41_ = self_gir_name;
		_tmp42_ = g_strdup_printf ("%s%s", _tmp40_, _tmp41_);
		result = _tmp42_;
		_g_free0 (self_gir_name);
		_g_free0 (_tmp30_);
		_g_free0 (parent_gir_name);
		_g_free0 (gir_name);
		_g_free0 (gir_fullname);
		return result;
	} else {
		const gchar* _tmp43_;
		const gchar* _tmp44_;
		gchar* _tmp45_;
		_tmp43_ = parent_gir_name;
		_tmp44_ = self_gir_name;
		_tmp45_ = g_strdup_printf ("%s.%s", _tmp43_, _tmp44_);
		result = _tmp45_;
		_g_free0 (self_gir_name);
		_g_free0 (_tmp30_);
		_g_free0 (parent_gir_name);
		_g_free0 (gir_name);
		_g_free0 (gir_fullname);
		return result;
	}
	_g_free0 (self_gir_name);
	_g_free0 (_tmp30_);
	_g_free0 (parent_gir_name);
	_g_free0 (gir_name);
	_g_free0 (gir_fullname);
}


static gchar* vala_gir_writer_gi_type_name (ValaGIRWriter* self, ValaTypeSymbol* type_symbol) {
	gchar* result = NULL;
	ValaSymbol* parent = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaTypeSymbol* _tmp64_;
	gchar* _tmp65_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_symbol != NULL, NULL);
	_tmp0_ = type_symbol;
	_tmp1_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _vala_code_node_ref0 (_tmp2_);
	parent = _tmp3_;
	_tmp4_ = parent;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_NAMESPACE)) {
		ValaNamespace* ns = NULL;
		ValaSymbol* _tmp5_;
		ValaNamespace* _tmp6_;
		gchar* _tmp7_ = NULL;
		ValaNamespace* _tmp8_;
		gchar* _tmp9_;
		gchar* ns_gir_name = NULL;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		_tmp5_ = parent;
		_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_NAMESPACE) ? ((ValaNamespace*) _tmp5_) : NULL);
		ns = _tmp6_;
		_tmp8_ = ns;
		_tmp9_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp8_, "GIR", "name", NULL);
		_tmp7_ = _tmp9_;
		if (_tmp7_ == NULL) {
			ValaNamespace* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp10_ = ns;
			_tmp11_ = vala_symbol_get_name ((ValaSymbol*) _tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strdup (_tmp12_);
			_g_free0 (_tmp7_);
			_tmp7_ = _tmp13_;
		}
		_tmp14_ = g_strdup (_tmp7_);
		ns_gir_name = _tmp14_;
		_tmp15_ = ns_gir_name;
		if (_tmp15_ != NULL) {
			ValaTypeSymbol* _tmp16_;
			ValaSourceReference* _tmp17_;
			ValaSourceReference* _tmp18_;
			ValaSourceFile* _tmp19_;
			ValaSourceFile* _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			_tmp16_ = type_symbol;
			_tmp17_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_source_reference_get_file (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_source_file_get_gir_namespace (_tmp20_);
			_tmp22_ = _tmp21_;
			if (_tmp22_ != NULL) {
				ValaGIRWriterGIRNamespace external = {0};
				ValaTypeSymbol* _tmp23_;
				ValaSourceReference* _tmp24_;
				ValaSourceReference* _tmp25_;
				ValaSourceFile* _tmp26_;
				ValaSourceFile* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				ValaTypeSymbol* _tmp30_;
				ValaSourceReference* _tmp31_;
				ValaSourceReference* _tmp32_;
				ValaSourceFile* _tmp33_;
				ValaSourceFile* _tmp34_;
				const gchar* _tmp35_;
				const gchar* _tmp36_;
				ValaArrayList* _tmp37_;
				ValaGIRWriterGIRNamespace _tmp38_;
				gboolean _tmp39_;
				gchar* gir_fullname = NULL;
				ValaTypeSymbol* _tmp42_;
				gchar* _tmp43_;
				const gchar* _tmp44_;
				gchar* _tmp45_ = NULL;
				ValaTypeSymbol* _tmp46_;
				gchar* _tmp47_;
				gchar* type_name = NULL;
				gchar* _tmp52_;
				ValaTypeSymbol* _tmp53_;
				ValaSourceReference* _tmp54_;
				ValaSourceReference* _tmp55_;
				ValaSourceFile* _tmp56_;
				ValaSourceFile* _tmp57_;
				const gchar* _tmp58_;
				const gchar* _tmp59_;
				const gchar* _tmp60_;
				gchar* _tmp61_;
				_tmp23_ = type_symbol;
				_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = vala_source_reference_get_file (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = vala_source_file_get_gir_namespace (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = type_symbol;
				_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = vala_source_reference_get_file (_tmp32_);
				_tmp34_ = _tmp33_;
				_tmp35_ = vala_source_file_get_gir_version (_tmp34_);
				_tmp36_ = _tmp35_;
				vala_gir_writer_gir_namespace_init (&external, _tmp29_, _tmp36_);
				_tmp37_ = self->priv->externals;
				_tmp38_ = external;
				_tmp39_ = vala_collection_contains ((ValaCollection*) _tmp37_, &_tmp38_);
				if (!_tmp39_) {
					ValaArrayList* _tmp40_;
					ValaGIRWriterGIRNamespace _tmp41_;
					_tmp40_ = self->priv->externals;
					_tmp41_ = external;
					vala_collection_add ((ValaCollection*) _tmp40_, &_tmp41_);
				}
				_tmp42_ = type_symbol;
				_tmp43_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp42_, "GIR", "fullname", NULL);
				gir_fullname = _tmp43_;
				_tmp44_ = gir_fullname;
				if (_tmp44_ != NULL) {
					result = gir_fullname;
					vala_gir_writer_gir_namespace_destroy (&external);
					_g_free0 (ns_gir_name);
					_g_free0 (_tmp7_);
					_vala_code_node_unref0 (ns);
					_vala_code_node_unref0 (parent);
					return result;
				}
				_tmp46_ = type_symbol;
				_tmp47_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp46_, "GIR", "name", NULL);
				_tmp45_ = _tmp47_;
				if (_tmp45_ == NULL) {
					ValaTypeSymbol* _tmp48_;
					const gchar* _tmp49_;
					const gchar* _tmp50_;
					gchar* _tmp51_;
					_tmp48_ = type_symbol;
					_tmp49_ = vala_symbol_get_name ((ValaSymbol*) _tmp48_);
					_tmp50_ = _tmp49_;
					_tmp51_ = g_strdup (_tmp50_);
					_g_free0 (_tmp45_);
					_tmp45_ = _tmp51_;
				}
				_tmp52_ = g_strdup (_tmp45_);
				type_name = _tmp52_;
				_tmp53_ = type_symbol;
				_tmp54_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp53_);
				_tmp55_ = _tmp54_;
				_tmp56_ = vala_source_reference_get_file (_tmp55_);
				_tmp57_ = _tmp56_;
				_tmp58_ = vala_source_file_get_gir_namespace (_tmp57_);
				_tmp59_ = _tmp58_;
				_tmp60_ = type_name;
				_tmp61_ = g_strdup_printf ("%s.%s", _tmp59_, _tmp60_);
				result = _tmp61_;
				_g_free0 (type_name);
				_g_free0 (_tmp45_);
				_g_free0 (gir_fullname);
				vala_gir_writer_gir_namespace_destroy (&external);
				_g_free0 (ns_gir_name);
				_g_free0 (_tmp7_);
				_vala_code_node_unref0 (ns);
				_vala_code_node_unref0 (parent);
				return result;
			} else {
				ValaHashSet* _tmp62_;
				ValaNamespace* _tmp63_;
				_tmp62_ = self->priv->unannotated_namespaces;
				_tmp63_ = ns;
				vala_collection_add ((ValaCollection*) _tmp62_, _tmp63_);
			}
		}
		_g_free0 (ns_gir_name);
		_g_free0 (_tmp7_);
		_vala_code_node_unref0 (ns);
	}
	_tmp64_ = type_symbol;
	_tmp65_ = vala_gir_writer_get_full_gir_name (self, (ValaSymbol*) _tmp64_);
	result = _tmp65_;
	_vala_code_node_unref0 (parent);
	return result;
}


static gchar* vala_gir_writer_literal_expression_to_value_string (ValaGIRWriter* self, ValaExpression* literal) {
	gchar* result = NULL;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (literal != NULL, NULL);
	_tmp0_ = literal;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_STRING_LITERAL)) {
		ValaStringLiteral* lit = NULL;
		ValaExpression* _tmp1_;
		ValaStringLiteral* _tmp2_;
		ValaStringLiteral* _tmp3_;
		_tmp1_ = literal;
		_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_STRING_LITERAL) ? ((ValaStringLiteral*) _tmp1_) : NULL);
		lit = _tmp2_;
		_tmp3_ = lit;
		if (_tmp3_ != NULL) {
			ValaStringLiteral* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp4_ = lit;
			_tmp5_ = vala_string_literal_eval (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = g_markup_escape_text (_tmp6_, (gssize) -1);
			_tmp8_ = _tmp7_;
			_g_free0 (_tmp6_);
			result = _tmp8_;
			_vala_code_node_unref0 (lit);
			return result;
		}
		_vala_code_node_unref0 (lit);
	} else {
		ValaExpression* _tmp9_;
		_tmp9_ = literal;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_CHARACTER_LITERAL)) {
			ValaExpression* _tmp10_;
			gunichar _tmp11_;
			gchar* _tmp12_;
			_tmp10_ = literal;
			_tmp11_ = vala_character_literal_get_char (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_CHARACTER_LITERAL, ValaCharacterLiteral));
			_tmp12_ = g_strdup_printf ("%c", (gint) ((gchar) _tmp11_));
			result = _tmp12_;
			return result;
		} else {
			ValaExpression* _tmp13_;
			_tmp13_ = literal;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, VALA_TYPE_BOOLEAN_LITERAL)) {
				const gchar* _tmp14_ = NULL;
				ValaExpression* _tmp15_;
				gboolean _tmp16_;
				gboolean _tmp17_;
				gchar* _tmp18_;
				_tmp15_ = literal;
				_tmp16_ = vala_boolean_literal_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, VALA_TYPE_BOOLEAN_LITERAL, ValaBooleanLiteral));
				_tmp17_ = _tmp16_;
				if (_tmp17_) {
					_tmp14_ = "true";
				} else {
					_tmp14_ = "false";
				}
				_tmp18_ = g_strdup (_tmp14_);
				result = _tmp18_;
				return result;
			} else {
				ValaExpression* _tmp19_;
				_tmp19_ = literal;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, VALA_TYPE_REAL_LITERAL)) {
					ValaExpression* _tmp20_;
					const gchar* _tmp21_;
					const gchar* _tmp22_;
					gchar* _tmp23_;
					_tmp20_ = literal;
					_tmp21_ = vala_real_literal_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_REAL_LITERAL, ValaRealLiteral));
					_tmp22_ = _tmp21_;
					_tmp23_ = g_strdup (_tmp22_);
					result = _tmp23_;
					return result;
				} else {
					ValaExpression* _tmp24_;
					_tmp24_ = literal;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALA_TYPE_INTEGER_LITERAL)) {
						ValaExpression* _tmp25_;
						const gchar* _tmp26_;
						const gchar* _tmp27_;
						gchar* _tmp28_;
						_tmp25_ = literal;
						_tmp26_ = vala_integer_literal_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteral));
						_tmp27_ = _tmp26_;
						_tmp28_ = g_strdup (_tmp27_);
						result = _tmp28_;
						return result;
					} else {
						ValaExpression* _tmp29_;
						_tmp29_ = literal;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, VALA_TYPE_UNARY_EXPRESSION)) {
							ValaUnaryExpression* unary = NULL;
							ValaExpression* _tmp30_;
							ValaUnaryExpression* _tmp31_;
							ValaUnaryExpression* _tmp32_;
							ValaUnaryOperator _tmp33_;
							ValaUnaryOperator _tmp34_;
							_tmp30_ = literal;
							_tmp31_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression));
							unary = _tmp31_;
							_tmp32_ = unary;
							_tmp33_ = vala_unary_expression_get_operator (_tmp32_);
							_tmp34_ = _tmp33_;
							if (_tmp34_ == VALA_UNARY_OPERATOR_MINUS) {
								ValaUnaryExpression* _tmp35_;
								ValaExpression* _tmp36_;
								ValaExpression* _tmp37_;
								_tmp35_ = unary;
								_tmp36_ = vala_unary_expression_get_inner (_tmp35_);
								_tmp37_ = _tmp36_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp37_, VALA_TYPE_REAL_LITERAL)) {
									ValaUnaryExpression* _tmp38_;
									ValaExpression* _tmp39_;
									ValaExpression* _tmp40_;
									const gchar* _tmp41_;
									const gchar* _tmp42_;
									gchar* _tmp43_;
									_tmp38_ = unary;
									_tmp39_ = vala_unary_expression_get_inner (_tmp38_);
									_tmp40_ = _tmp39_;
									_tmp41_ = vala_real_literal_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, VALA_TYPE_REAL_LITERAL, ValaRealLiteral));
									_tmp42_ = _tmp41_;
									_tmp43_ = g_strconcat ("-", _tmp42_, NULL);
									result = _tmp43_;
									_vala_code_node_unref0 (unary);
									return result;
								} else {
									ValaUnaryExpression* _tmp44_;
									ValaExpression* _tmp45_;
									ValaExpression* _tmp46_;
									_tmp44_ = unary;
									_tmp45_ = vala_unary_expression_get_inner (_tmp44_);
									_tmp46_ = _tmp45_;
									if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp46_, VALA_TYPE_INTEGER_LITERAL)) {
										ValaUnaryExpression* _tmp47_;
										ValaExpression* _tmp48_;
										ValaExpression* _tmp49_;
										const gchar* _tmp50_;
										const gchar* _tmp51_;
										gchar* _tmp52_;
										_tmp47_ = unary;
										_tmp48_ = vala_unary_expression_get_inner (_tmp47_);
										_tmp49_ = _tmp48_;
										_tmp50_ = vala_integer_literal_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteral));
										_tmp51_ = _tmp50_;
										_tmp52_ = g_strconcat ("-", _tmp51_, NULL);
										result = _tmp52_;
										_vala_code_node_unref0 (unary);
										return result;
									}
								}
							}
							_vala_code_node_unref0 (unary);
						}
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}


static gboolean vala_gir_writer_check_accessibility (ValaGIRWriter* self, ValaSymbol* sym) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbolAccessibility _tmp2_;
	ValaSymbolAccessibility _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = sym;
	_tmp2_ = vala_symbol_get_access (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp4_;
		ValaSymbolAccessibility _tmp5_;
		ValaSymbolAccessibility _tmp6_;
		_tmp4_ = sym;
		_tmp5_ = vala_symbol_get_access (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean vala_gir_writer_is_visibility (ValaGIRWriter* self, ValaSymbol* sym) {
	gboolean result = FALSE;
	ValaSymbol* _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp0_ = sym;
	_tmp1_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp0_, "GIR", "visible", TRUE);
	result = _tmp1_;
	return result;
}


ValaGIRWriter* vala_gir_writer_construct (GType object_type) {
	ValaGIRWriter* self = NULL;
	self = (ValaGIRWriter*) vala_code_visitor_construct (object_type);
	return self;
}


ValaGIRWriter* vala_gir_writer_new (void) {
	return vala_gir_writer_construct (VALA_TYPE_GIR_WRITER);
}


static void vala_gir_writer_gir_namespace_init (ValaGIRWriterGIRNamespace *self, const gchar* ns, const gchar* version) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (ns != NULL);
	g_return_if_fail (version != NULL);
	memset (self, 0, sizeof (ValaGIRWriterGIRNamespace));
	_tmp0_ = ns;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*self).ns);
	(*self).ns = _tmp1_;
	_tmp2_ = version;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*self).version);
	(*self).version = _tmp3_;
}


static gboolean vala_gir_writer_gir_namespace_equal (ValaGIRWriterGIRNamespace *self, ValaGIRWriterGIRNamespace* g) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	ValaGIRWriterGIRNamespace _tmp2_;
	const gchar* _tmp3_;
	g_return_val_if_fail (g != NULL, FALSE);
	_tmp1_ = (*self).ns;
	_tmp2_ = *g;
	_tmp3_ = _tmp2_.ns;
	if (g_strcmp0 (_tmp1_, _tmp3_) == 0) {
		const gchar* _tmp4_;
		ValaGIRWriterGIRNamespace _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = (*self).version;
		_tmp5_ = *g;
		_tmp6_ = _tmp5_.version;
		_tmp0_ = g_strcmp0 (_tmp4_, _tmp6_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static void vala_gir_writer_gir_namespace_copy (const ValaGIRWriterGIRNamespace* self, ValaGIRWriterGIRNamespace* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).ns;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).ns);
	(*dest).ns = _tmp1_;
	_tmp2_ = (*self).version;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).version);
	(*dest).version = _tmp3_;
}


static void vala_gir_writer_gir_namespace_destroy (ValaGIRWriterGIRNamespace* self) {
	_g_free0 ((*self).ns);
	_g_free0 ((*self).version);
}


static ValaGIRWriterGIRNamespace* vala_gir_writer_gir_namespace_dup (const ValaGIRWriterGIRNamespace* self) {
	ValaGIRWriterGIRNamespace* dup;
	dup = g_new0 (ValaGIRWriterGIRNamespace, 1);
	vala_gir_writer_gir_namespace_copy (self, dup);
	return dup;
}


static void vala_gir_writer_gir_namespace_free (ValaGIRWriterGIRNamespace* self) {
	vala_gir_writer_gir_namespace_destroy (self);
	g_free (self);
}


static GType vala_gir_writer_gir_namespace_get_type (void) {
	static volatile gsize vala_gir_writer_gir_namespace_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_writer_gir_namespace_type_id__volatile)) {
		GType vala_gir_writer_gir_namespace_type_id;
		vala_gir_writer_gir_namespace_type_id = g_boxed_type_register_static ("ValaGIRWriterGIRNamespace", (GBoxedCopyFunc) vala_gir_writer_gir_namespace_dup, (GBoxedFreeFunc) vala_gir_writer_gir_namespace_free);
		g_once_init_leave (&vala_gir_writer_gir_namespace_type_id__volatile, vala_gir_writer_gir_namespace_type_id);
	}
	return vala_gir_writer_gir_namespace_type_id__volatile;
}


static void vala_gir_writer_class_init (ValaGIRWriterClass * klass) {
	vala_gir_writer_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_gir_writer_finalize;
	g_type_class_add_private (klass, sizeof (ValaGIRWriterPrivate));
	((ValaGIRWriterClass *) klass)->get_interface_comment = (gchar* (*) (ValaGIRWriter*, ValaInterface*)) vala_gir_writer_real_get_interface_comment;
	((ValaGIRWriterClass *) klass)->get_struct_comment = (gchar* (*) (ValaGIRWriter*, ValaStruct*)) vala_gir_writer_real_get_struct_comment;
	((ValaGIRWriterClass *) klass)->get_enum_comment = (gchar* (*) (ValaGIRWriter*, ValaEnum*)) vala_gir_writer_real_get_enum_comment;
	((ValaGIRWriterClass *) klass)->get_class_comment = (gchar* (*) (ValaGIRWriter*, ValaClass*)) vala_gir_writer_real_get_class_comment;
	((ValaGIRWriterClass *) klass)->get_error_code_comment = (gchar* (*) (ValaGIRWriter*, ValaErrorCode*)) vala_gir_writer_real_get_error_code_comment;
	((ValaGIRWriterClass *) klass)->get_enum_value_comment = (gchar* (*) (ValaGIRWriter*, ValaEnumValue*)) vala_gir_writer_real_get_enum_value_comment;
	((ValaGIRWriterClass *) klass)->get_constant_comment = (gchar* (*) (ValaGIRWriter*, ValaConstant*)) vala_gir_writer_real_get_constant_comment;
	((ValaGIRWriterClass *) klass)->get_error_domain_comment = (gchar* (*) (ValaGIRWriter*, ValaErrorDomain*)) vala_gir_writer_real_get_error_domain_comment;
	((ValaGIRWriterClass *) klass)->get_field_comment = (gchar* (*) (ValaGIRWriter*, ValaField*)) vala_gir_writer_real_get_field_comment;
	((ValaGIRWriterClass *) klass)->get_delegate_comment = (gchar* (*) (ValaGIRWriter*, ValaDelegate*)) vala_gir_writer_real_get_delegate_comment;
	((ValaGIRWriterClass *) klass)->get_method_comment = (gchar* (*) (ValaGIRWriter*, ValaMethod*)) vala_gir_writer_real_get_method_comment;
	((ValaGIRWriterClass *) klass)->get_property_comment = (gchar* (*) (ValaGIRWriter*, ValaProperty*)) vala_gir_writer_real_get_property_comment;
	((ValaGIRWriterClass *) klass)->get_delegate_return_comment = (gchar* (*) (ValaGIRWriter*, ValaDelegate*)) vala_gir_writer_real_get_delegate_return_comment;
	((ValaGIRWriterClass *) klass)->get_signal_return_comment = (gchar* (*) (ValaGIRWriter*, ValaSignal*)) vala_gir_writer_real_get_signal_return_comment;
	((ValaGIRWriterClass *) klass)->get_method_return_comment = (gchar* (*) (ValaGIRWriter*, ValaMethod*)) vala_gir_writer_real_get_method_return_comment;
	((ValaGIRWriterClass *) klass)->get_signal_comment = (gchar* (*) (ValaGIRWriter*, ValaSignal*)) vala_gir_writer_real_get_signal_comment;
	((ValaGIRWriterClass *) klass)->get_parameter_comment = (gchar* (*) (ValaGIRWriter*, ValaParameter*)) vala_gir_writer_real_get_parameter_comment;
	((ValaCodeVisitorClass *) klass)->visit_source_file = (void (*) (ValaCodeVisitor*, ValaSourceFile*)) vala_gir_writer_real_visit_source_file;
	((ValaCodeVisitorClass *) klass)->visit_namespace = (void (*) (ValaCodeVisitor*, ValaNamespace*)) vala_gir_writer_real_visit_namespace;
	((ValaCodeVisitorClass *) klass)->visit_class = (void (*) (ValaCodeVisitor*, ValaClass*)) vala_gir_writer_real_visit_class;
	((ValaCodeVisitorClass *) klass)->visit_struct = (void (*) (ValaCodeVisitor*, ValaStruct*)) vala_gir_writer_real_visit_struct;
	((ValaCodeVisitorClass *) klass)->visit_interface = (void (*) (ValaCodeVisitor*, ValaInterface*)) vala_gir_writer_real_visit_interface;
	((ValaCodeVisitorClass *) klass)->visit_enum = (void (*) (ValaCodeVisitor*, ValaEnum*)) vala_gir_writer_real_visit_enum;
	((ValaCodeVisitorClass *) klass)->visit_enum_value = (void (*) (ValaCodeVisitor*, ValaEnumValue*)) vala_gir_writer_real_visit_enum_value;
	((ValaCodeVisitorClass *) klass)->visit_error_domain = (void (*) (ValaCodeVisitor*, ValaErrorDomain*)) vala_gir_writer_real_visit_error_domain;
	((ValaCodeVisitorClass *) klass)->visit_error_code = (void (*) (ValaCodeVisitor*, ValaErrorCode*)) vala_gir_writer_real_visit_error_code;
	((ValaCodeVisitorClass *) klass)->visit_constant = (void (*) (ValaCodeVisitor*, ValaConstant*)) vala_gir_writer_real_visit_constant;
	((ValaCodeVisitorClass *) klass)->visit_field = (void (*) (ValaCodeVisitor*, ValaField*)) vala_gir_writer_real_visit_field;
	((ValaCodeVisitorClass *) klass)->visit_delegate = (void (*) (ValaCodeVisitor*, ValaDelegate*)) vala_gir_writer_real_visit_delegate;
	((ValaCodeVisitorClass *) klass)->visit_method = (void (*) (ValaCodeVisitor*, ValaMethod*)) vala_gir_writer_real_visit_method;
	((ValaCodeVisitorClass *) klass)->visit_creation_method = (void (*) (ValaCodeVisitor*, ValaCreationMethod*)) vala_gir_writer_real_visit_creation_method;
	((ValaCodeVisitorClass *) klass)->visit_property = (void (*) (ValaCodeVisitor*, ValaProperty*)) vala_gir_writer_real_visit_property;
	((ValaCodeVisitorClass *) klass)->visit_signal = (void (*) (ValaCodeVisitor*, ValaSignal*)) vala_gir_writer_real_visit_signal;
}


static void vala_gir_writer_instance_init (ValaGIRWriter * self) {
	GString* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashSet* _tmp3_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	ValaHashSet* _tmp6_;
	GEqualFunc _tmp7_;
	ValaArrayList* _tmp8_;
	GEqualFunc _tmp9_;
	ValaArrayList* _tmp10_;
	ValaArrayList* _tmp11_;
	self->priv = VALA_GIR_WRITER_GET_PRIVATE (self);
	_tmp0_ = g_string_new ("");
	self->priv->buffer = _tmp0_;
	_tmp1_ = g_direct_hash;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_set_new (VALA_TYPE_NAMESPACE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_, _tmp2_);
	self->priv->unannotated_namespaces = _tmp3_;
	_tmp4_ = g_direct_hash;
	_tmp5_ = g_direct_equal;
	_tmp6_ = vala_hash_set_new (VALA_TYPE_NAMESPACE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_, _tmp5_);
	self->priv->our_namespaces = _tmp6_;
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_array_list_new (VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp7_);
	self->priv->hierarchy = _tmp8_;
	_tmp9_ = g_direct_equal;
	_tmp10_ = vala_array_list_new (VALA_TYPE_CODE_NODE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp9_);
	self->priv->deferred = _tmp10_;
	_tmp11_ = vala_array_list_new (VALA_GIR_WRITER_TYPE_GIR_NAMESPACE, (GBoxedCopyFunc) vala_gir_writer_gir_namespace_dup, (GDestroyNotify) vala_gir_writer_gir_namespace_free, (GEqualFunc) vala_gir_writer_gir_namespace_equal);
	self->priv->externals = _tmp11_;
}


static void vala_gir_writer_finalize (ValaCodeVisitor * obj) {
	ValaGIRWriter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_GIR_WRITER, ValaGIRWriter);
	_vala_code_context_unref0 (self->priv->context);
	_g_free0 (self->priv->directory);
	_g_free0 (self->priv->gir_namespace);
	_g_free0 (self->priv->gir_version);
	_g_free0 (self->priv->gir_shared_library);
	_g_string_free0 (self->priv->buffer);
	_fclose0 (self->priv->stream);
	_vala_iterable_unref0 (self->priv->unannotated_namespaces);
	_vala_iterable_unref0 (self->priv->our_namespaces);
	_vala_iterable_unref0 (self->priv->hierarchy);
	_vala_iterable_unref0 (self->priv->deferred);
	_vala_code_node_unref0 (self->priv->gobject_type);
	_vala_code_node_unref0 (self->priv->ginitiallyunowned_type);
	_vala_code_node_unref0 (self->priv->gtypeinterface_type);
	_vala_code_node_unref0 (self->priv->gtypeinstance_type);
	_vala_code_node_unref0 (self->priv->gtype_type);
	_vala_iterable_unref0 (self->priv->externals);
	VALA_CODE_VISITOR_CLASS (vala_gir_writer_parent_class)->finalize (obj);
}


/**
 * Code visitor generating .gir file for the public interface.
 */
GType vala_gir_writer_get_type (void) {
	static volatile gsize vala_gir_writer_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_writer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGIRWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGIRWriter), 0, (GInstanceInitFunc) vala_gir_writer_instance_init, NULL };
		GType vala_gir_writer_type_id;
		vala_gir_writer_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaGIRWriter", &g_define_type_info, 0);
		g_once_init_leave (&vala_gir_writer_type_id__volatile, vala_gir_writer_type_id);
	}
	return vala_gir_writer_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



