/* valaccodeinvocationexpressionbinding.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodeinvocationexpressionbinding.h>
#include <vala/valacodenode.h>
#include <vala/valacodevisitor.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeexpression.h>
#include <vala/valamethod.h>
#include <gee/list.h>
#include <vala/valamemberaccess.h>
#include <vala/valaexpression.h>
#include <vala/valadatatype.h>
#include <vala/valamethodtype.h>
#include <vala/valasignaltype.h>
#include <gee/hashmap.h>
#include <vala/valaarrayresizemethod.h>
#include <vala/valaarraytype.h>
#include <gee/map.h>
#include <float.h>
#include <math.h>
#include <ccode/valaccodeidentifier.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valaarraymovemethod.h>
#include <vala/valamember.h>
#include <vala/valasymbol.h>
#include <vala/valastruct.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodememberaccess.h>
#include <ccode/valaccodecommaexpression.h>
#include <vala/valalocalvariable.h>
#include <ccode/valaccodeassignment.h>
#include <vala/valaclass.h>
#include <vala/valatypesymbol.h>
#include <vala/valadynamicmethod.h>
#include <vala/valaunaryexpression.h>
#include <vala/valaformalparameter.h>
#include <vala/valasourcereference.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <gee/arraylist.h>
#include <vala/valadelegatetype.h>
#include <vala/valadelegate.h>
#include <ccode/valaccodeconstant.h>
#include <vala/valanulltype.h>
#include <vala/valavoidtype.h>
#include <ccode/valaccodecastexpression.h>
#include <vala/valareport.h>
#include <vala/valapointertype.h>
#include <vala/valasignal.h>
#include <ccode/valaccodeparenthesizedexpression.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeconditionalexpression.h>
#include <gobject/valaccodebinding.h>
#include <gobject/valaccodedynamicmethodbinding.h>




struct _ValaCCodeInvocationExpressionBindingPrivate {
	ValaInvocationExpression* _invocation_expression;
};

#define VALA_CCODE_INVOCATION_EXPRESSION_BINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_INVOCATION_EXPRESSION_BINDING, ValaCCodeInvocationExpressionBindingPrivate))
enum  {
	VALA_CCODE_INVOCATION_EXPRESSION_BINDING_DUMMY_PROPERTY,
	VALA_CCODE_INVOCATION_EXPRESSION_BINDING_INVOCATION_EXPRESSION
};
static void vala_ccode_invocation_expression_binding_real_emit (ValaCCodeBinding* base);
static gpointer vala_ccode_invocation_expression_binding_parent_class = NULL;
static void vala_ccode_invocation_expression_binding_finalize (GObject * obj);



ValaCCodeInvocationExpressionBinding* vala_ccode_invocation_expression_binding_new (ValaCCodeGenerator* codegen, ValaInvocationExpression* invocation_expression) {
	ValaCCodeInvocationExpressionBinding * self;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (codegen), NULL);
	g_return_val_if_fail (VALA_IS_INVOCATION_EXPRESSION (invocation_expression), NULL);
	self = g_object_newv (VALA_TYPE_CCODE_INVOCATION_EXPRESSION_BINDING, 0, NULL);
	vala_ccode_invocation_expression_binding_set_invocation_expression (self, invocation_expression);
	vala_ccode_binding_set_codegen (VALA_CCODE_BINDING (self), codegen);
	return self;
}


static void vala_ccode_invocation_expression_binding_real_emit (ValaCCodeBinding* base) {
	ValaCCodeInvocationExpressionBinding * self;
	ValaInvocationExpression* _tmp0;
	ValaInvocationExpression* expr;
	ValaCCodeFunctionCall* ccall;
	ValaMethod* m;
	GeeList* params;
	ValaMemberAccess* _tmp2;
	ValaExpression* _tmp1;
	ValaMemberAccess* ma;
	ValaDataType* _tmp3;
	ValaDataType* itype;
	GeeList* _tmp4;
	ValaCCodeExpression* _tmp9;
	ValaCCodeExpression* ccall_expr;
	GeeHashMap* carg_map;
	ValaCCodeExpression* instance;
	gboolean ellipsis;
	gint i;
	gint arg_pos;
	GeeIterator* params_it;
	ValaDataType* _tmp130;
	gboolean _tmp131;
	gint last_pos;
	gint min_pos;
	self = VALA_CCODE_INVOCATION_EXPRESSION_BINDING (base);
	_tmp0 = NULL;
	expr = (_tmp0 = self->priv->_invocation_expression, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	vala_code_node_accept_children (VALA_CODE_NODE (expr), VALA_CODE_VISITOR (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))));
	/* the bare function call*/
	ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_invocation_expression_get_call (expr)))));
	m = NULL;
	params = NULL;
	_tmp2 = NULL;
	_tmp1 = NULL;
	ma = (_tmp2 = (_tmp1 = vala_invocation_expression_get_call (expr), (VALA_IS_MEMBER_ACCESS (_tmp1) ? ((ValaMemberAccess*) (_tmp1)) : NULL)), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
	_tmp3 = NULL;
	itype = (_tmp3 = vala_expression_get_value_type (vala_invocation_expression_get_call (expr)), (_tmp3 == NULL ? NULL : g_object_ref (_tmp3)));
	_tmp4 = NULL;
	params = (_tmp4 = vala_data_type_get_parameters (itype), (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), _tmp4);
	if (VALA_IS_METHOD_TYPE (itype)) {
		ValaMethod* _tmp6;
		ValaMethod* _tmp5;
		g_assert (ma != NULL);
		_tmp6 = NULL;
		_tmp5 = NULL;
		m = (_tmp6 = (_tmp5 = vala_method_type_get_method_symbol ((VALA_METHOD_TYPE (itype))), (_tmp5 == NULL ? NULL : g_object_ref (_tmp5))), (m == NULL ? NULL : (m = (g_object_unref (m), NULL))), _tmp6);
	} else {
		if (VALA_IS_SIGNAL_TYPE (itype)) {
			ValaCCodeFunctionCall* _tmp8;
			ValaCCodeFunctionCall* _tmp7;
			_tmp8 = NULL;
			_tmp7 = NULL;
			ccall = (_tmp8 = (_tmp7 = VALA_CCODE_FUNCTION_CALL (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_invocation_expression_get_call (expr)))), (_tmp7 == NULL ? NULL : g_object_ref (_tmp7))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp8);
		}
	}
	/* the complete call expression, might include casts, comma expressions, and/or assignments*/
	_tmp9 = NULL;
	ccall_expr = (_tmp9 = VALA_CCODE_EXPRESSION (ccall), (_tmp9 == NULL ? NULL : g_object_ref (_tmp9)));
	carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		ValaArrayType* _tmp10;
		ValaArrayType* array_type;
		ValaCCodeIdentifier* _tmp12;
		char* _tmp11;
		_tmp10 = NULL;
		array_type = (_tmp10 = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (ma))), (_tmp10 == NULL ? NULL : g_object_ref (_tmp10)));
		_tmp12 = NULL;
		_tmp11 = NULL;
		gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ((double) (0)), FALSE)), VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_identifier_new ((_tmp11 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))))));
		(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
		_tmp11 = (g_free (_tmp11), NULL);
		(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
	} else {
		if (VALA_IS_ARRAY_MOVE_METHOD (m)) {
			vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->requires_array_move = TRUE;
		}
	}
	instance = NULL;
	if (m != NULL && vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		ValaCCodeExpression* _tmp14;
		ValaCCodeExpression* _tmp13;
		ValaStruct* _tmp16;
		ValaSymbol* _tmp15;
		ValaStruct* st;
		_tmp14 = NULL;
		_tmp13 = NULL;
		instance = (_tmp14 = (_tmp13 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))), (_tmp13 == NULL ? NULL : g_object_ref (_tmp13))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), _tmp14);
		_tmp16 = NULL;
		_tmp15 = NULL;
		st = (_tmp16 = (_tmp15 = vala_symbol_get_parent_symbol (VALA_SYMBOL (m)), (VALA_IS_STRUCT (_tmp15) ? ((ValaStruct*) (_tmp15)) : NULL)), (_tmp16 == NULL ? NULL : g_object_ref (_tmp16)));
		if (st != NULL && !vala_struct_is_simple_type (st)) {
			ValaCCodeUnaryExpression* _tmp18;
			ValaCCodeExpression* _tmp17;
			ValaCCodeUnaryExpression* unary;
			/* we need to pass struct instance by reference*/
			_tmp18 = NULL;
			_tmp17 = NULL;
			unary = (_tmp18 = (_tmp17 = instance, (VALA_IS_CCODE_UNARY_EXPRESSION (_tmp17) ? ((ValaCCodeUnaryExpression*) (_tmp17)) : NULL)), (_tmp18 == NULL ? NULL : g_object_ref (_tmp18)));
			if (unary != NULL && vala_ccode_unary_expression_get_operator (unary) == VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION) {
				ValaCCodeExpression* _tmp20;
				ValaCCodeExpression* _tmp19;
				/* *expr => expr*/
				_tmp20 = NULL;
				_tmp19 = NULL;
				instance = (_tmp20 = (_tmp19 = vala_ccode_unary_expression_get_inner (unary), (_tmp19 == NULL ? NULL : g_object_ref (_tmp19))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), _tmp20);
			} else {
				if (VALA_IS_CCODE_IDENTIFIER (instance) || VALA_IS_CCODE_MEMBER_ACCESS (instance)) {
					ValaCCodeExpression* _tmp21;
					_tmp21 = NULL;
					instance = (_tmp21 = VALA_CCODE_EXPRESSION (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, instance)), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), _tmp21);
				} else {
					ValaCCodeCommaExpression* ccomma;
					ValaLocalVariable* temp_var;
					ValaCCodeAssignment* _tmp23;
					ValaCCodeIdentifier* _tmp22;
					ValaCCodeUnaryExpression* _tmp25;
					ValaCCodeIdentifier* _tmp24;
					ValaCCodeExpression* _tmp27;
					ValaCCodeExpression* _tmp26;
					/* if instance is e.g. a function call, we can't take the address of the expression
					 (tmp = expr, &tmp)*/
					ccomma = vala_ccode_comma_expression_new ();
					temp_var = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_target_type (vala_member_access_get_inner (ma)), TRUE, NULL);
					gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_var);
					_tmp23 = NULL;
					_tmp22 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var))))), instance, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
					(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
					(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
					_tmp25 = NULL;
					_tmp24 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var)))))))));
					(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
					(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
					_tmp27 = NULL;
					_tmp26 = NULL;
					instance = (_tmp27 = (_tmp26 = VALA_CCODE_EXPRESSION (ccomma), (_tmp26 == NULL ? NULL : g_object_ref (_tmp26))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), _tmp27);
					(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
					(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
				}
			}
			(unary == NULL ? NULL : (unary = (g_object_unref (unary), NULL)));
		}
		gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cinstance_parameter_position (m), FALSE)), instance);
		(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
	} else {
		if (m != NULL && vala_method_get_binding (m) == MEMBER_BINDING_CLASS) {
			ValaClass* _tmp28;
			ValaClass* cl;
			ValaCCodeIdentifier* _tmp31;
			char* _tmp30;
			char* _tmp29;
			ValaCCodeFunctionCall* _tmp32;
			ValaCCodeFunctionCall* cast;
			ValaCCodeExpression* klass;
			ValaMemberAccess* _tmp34;
			ValaExpression* _tmp33;
			ValaMemberAccess* ma;
			_tmp28 = NULL;
			cl = (_tmp28 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp28 == NULL ? NULL : g_object_ref (_tmp28)));
			_tmp31 = NULL;
			_tmp30 = NULL;
			_tmp29 = NULL;
			_tmp32 = NULL;
			cast = (_tmp32 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_identifier_new ((_tmp30 = g_strconcat ((_tmp29 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (cl), NULL)), "_CLASS", NULL)))))), (_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL))), (_tmp30 = (g_free (_tmp30), NULL)), (_tmp29 = (g_free (_tmp29), NULL)), _tmp32);
			klass = NULL;
			_tmp34 = NULL;
			_tmp33 = NULL;
			ma = (_tmp34 = (_tmp33 = vala_invocation_expression_get_call (expr), (VALA_IS_MEMBER_ACCESS (_tmp33) ? ((ValaMemberAccess*) (_tmp33)) : NULL)), (_tmp34 == NULL ? NULL : g_object_ref (_tmp34)));
			if (vala_member_access_get_inner (ma) == NULL) {
				if (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->in_static_or_class_ctor) {
					ValaCCodeExpression* _tmp35;
					/* Accessing the method from a static or class constructor*/
					_tmp35 = NULL;
					klass = (_tmp35 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("klass")), (klass == NULL ? NULL : (klass = (g_object_unref (klass), NULL))), _tmp35);
				} else {
					ValaCCodeIdentifier* _tmp36;
					ValaCCodeFunctionCall* _tmp37;
					ValaCCodeFunctionCall* k;
					ValaCCodeIdentifier* _tmp38;
					ValaCCodeExpression* _tmp40;
					ValaCCodeExpression* _tmp39;
					/* Accessing the method from within an instance method*/
					_tmp36 = NULL;
					_tmp37 = NULL;
					k = (_tmp37 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp36 = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS")))), (_tmp36 == NULL ? NULL : (_tmp36 = (g_object_unref (_tmp36), NULL))), _tmp37);
					_tmp38 = NULL;
					vala_ccode_function_call_add_argument (k, VALA_CCODE_EXPRESSION ((_tmp38 = vala_ccode_identifier_new ("self"))));
					(_tmp38 == NULL ? NULL : (_tmp38 = (g_object_unref (_tmp38), NULL)));
					_tmp40 = NULL;
					_tmp39 = NULL;
					klass = (_tmp40 = (_tmp39 = VALA_CCODE_EXPRESSION (k), (_tmp39 == NULL ? NULL : g_object_ref (_tmp39))), (klass == NULL ? NULL : (klass = (g_object_unref (klass), NULL))), _tmp40);
					(k == NULL ? NULL : (k = (g_object_unref (k), NULL)));
				}
			} else {
				ValaCCodeIdentifier* _tmp41;
				ValaCCodeFunctionCall* _tmp42;
				ValaCCodeFunctionCall* k;
				ValaCCodeExpression* _tmp44;
				ValaCCodeExpression* _tmp43;
				/* Accessing the method of an instance*/
				_tmp41 = NULL;
				_tmp42 = NULL;
				k = (_tmp42 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp41 = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS")))), (_tmp41 == NULL ? NULL : (_tmp41 = (g_object_unref (_tmp41), NULL))), _tmp42);
				vala_ccode_function_call_add_argument (k, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))));
				_tmp44 = NULL;
				_tmp43 = NULL;
				klass = (_tmp44 = (_tmp43 = VALA_CCODE_EXPRESSION (k), (_tmp43 == NULL ? NULL : g_object_ref (_tmp43))), (klass == NULL ? NULL : (klass = (g_object_unref (klass), NULL))), _tmp44);
				(k == NULL ? NULL : (k = (g_object_unref (k), NULL)));
			}
			vala_ccode_function_call_add_argument (cast, klass);
			gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cinstance_parameter_position (m), FALSE)), VALA_CCODE_EXPRESSION (cast));
			(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
			(cast == NULL ? NULL : (cast = (g_object_unref (cast), NULL)));
			(klass == NULL ? NULL : (klass = (g_object_unref (klass), NULL)));
			(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
		}
	}
	if (VALA_IS_ARRAY_MOVE_METHOD (m)) {
		ValaArrayType* _tmp45;
		ValaArrayType* array_type;
		ValaCCodeIdentifier* _tmp46;
		ValaCCodeFunctionCall* _tmp47;
		ValaCCodeFunctionCall* csizeof;
		ValaCCodeIdentifier* _tmp49;
		char* _tmp48;
		_tmp45 = NULL;
		array_type = (_tmp45 = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (ma))), (_tmp45 == NULL ? NULL : g_object_ref (_tmp45)));
		_tmp46 = NULL;
		_tmp47 = NULL;
		csizeof = (_tmp47 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp46 = vala_ccode_identifier_new ("sizeof")))), (_tmp46 == NULL ? NULL : (_tmp46 = (g_object_unref (_tmp46), NULL))), _tmp47);
		_tmp49 = NULL;
		_tmp48 = NULL;
		vala_ccode_function_call_add_argument (csizeof, VALA_CCODE_EXPRESSION ((_tmp49 = vala_ccode_identifier_new ((_tmp48 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))))));
		(_tmp49 == NULL ? NULL : (_tmp49 = (g_object_unref (_tmp49), NULL)));
		_tmp48 = (g_free (_tmp48), NULL);
		gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), 0.1, FALSE)), VALA_CCODE_EXPRESSION (csizeof));
		(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
		(csizeof == NULL ? NULL : (csizeof = (g_object_unref (csizeof), NULL)));
	} else {
		if (VALA_IS_DYNAMIC_METHOD (m)) {
			gint param_nr;
			ValaCCodeDynamicMethodBinding* _tmp58;
			vala_method_clear_parameters (m);
			param_nr = 1;
			{
				GeeList* arg_collection;
				int arg_it;
				arg_collection = vala_invocation_expression_get_argument_list (expr);
				for (arg_it = 0; arg_it < gee_collection_get_size (GEE_COLLECTION (arg_collection)); arg_it = arg_it + 1) {
					ValaExpression* arg;
					arg = ((ValaExpression*) (gee_list_get (GEE_LIST (arg_collection), arg_it)));
					{
						ValaUnaryExpression* _tmp51;
						ValaExpression* _tmp50;
						ValaUnaryExpression* unary;
						_tmp51 = NULL;
						_tmp50 = NULL;
						unary = (_tmp51 = (_tmp50 = arg, (VALA_IS_UNARY_EXPRESSION (_tmp50) ? ((ValaUnaryExpression*) (_tmp50)) : NULL)), (_tmp51 == NULL ? NULL : g_object_ref (_tmp51)));
						if (unary != NULL && vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_OUT) {
							char* _tmp52;
							ValaFormalParameter* _tmp53;
							ValaFormalParameter* param;
							/* out argument*/
							_tmp52 = NULL;
							_tmp53 = NULL;
							param = (_tmp53 = vala_formal_parameter_new ((_tmp52 = g_strdup_printf ("param%d", param_nr)), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), NULL), (_tmp52 = (g_free (_tmp52), NULL)), _tmp53);
							vala_formal_parameter_set_direction (param, VALA_PARAMETER_DIRECTION_OUT);
							vala_method_add_parameter (m, param);
							(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
						} else {
							if (unary != NULL && vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_REF) {
								char* _tmp54;
								ValaFormalParameter* _tmp55;
								ValaFormalParameter* param;
								/* ref argument*/
								_tmp54 = NULL;
								_tmp55 = NULL;
								param = (_tmp55 = vala_formal_parameter_new ((_tmp54 = g_strdup_printf ("param%d", param_nr)), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), NULL), (_tmp54 = (g_free (_tmp54), NULL)), _tmp55);
								vala_formal_parameter_set_direction (param, VALA_PARAMETER_DIRECTION_REF);
								vala_method_add_parameter (m, param);
								(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
							} else {
								ValaFormalParameter* _tmp57;
								char* _tmp56;
								/* in argument*/
								_tmp57 = NULL;
								_tmp56 = NULL;
								vala_method_add_parameter (m, (_tmp57 = vala_formal_parameter_new ((_tmp56 = g_strdup_printf ("param%d", param_nr)), vala_expression_get_value_type (arg), NULL)));
								(_tmp57 == NULL ? NULL : (_tmp57 = (g_object_unref (_tmp57), NULL)));
								_tmp56 = (g_free (_tmp56), NULL);
							}
						}
						param_nr++;
						(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
						(unary == NULL ? NULL : (unary = (g_object_unref (unary), NULL)));
					}
				}
				(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
			}
			{
				GeeList* param_collection;
				int param_it;
				param_collection = vala_method_get_parameters (m);
				for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
					ValaFormalParameter* param;
					param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
					{
						vala_code_node_accept (VALA_CODE_NODE (param), VALA_CODE_VISITOR (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))));
						(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
					}
				}
				(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
			}
			_tmp58 = NULL;
			vala_ccode_dynamic_method_binding_generate_wrapper ((_tmp58 = vala_ccode_generator_dynamic_method_binding (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_DYNAMIC_METHOD (m))));
			(_tmp58 == NULL ? NULL : (_tmp58 = (g_object_unref (_tmp58), NULL)));
		}
	}
	ellipsis = FALSE;
	i = 1;
	arg_pos = 0;
	params_it = gee_iterable_iterator (GEE_ITERABLE (params));
	{
		GeeList* arg_collection;
		int arg_it;
		arg_collection = vala_invocation_expression_get_argument_list (expr);
		for (arg_it = 0; arg_it < gee_collection_get_size (GEE_COLLECTION (arg_collection)); arg_it = arg_it + 1) {
			ValaExpression* arg;
			arg = ((ValaExpression*) (gee_list_get (GEE_LIST (arg_collection), arg_it)));
			{
				ValaCCodeExpression* _tmp59;
				ValaCCodeExpression* cexpr;
				GeeList* extra_args;
				_tmp59 = NULL;
				cexpr = (_tmp59 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (arg))), (_tmp59 == NULL ? NULL : g_object_ref (_tmp59)));
				extra_args = GEE_LIST (gee_array_list_new (VALA_TYPE_CCODE_EXPRESSION, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal));
				if (gee_iterator_next (params_it)) {
					ValaFormalParameter* param;
					param = ((ValaFormalParameter*) (gee_iterator_get (params_it)));
					ellipsis = vala_formal_parameter_get_ellipsis (param);
					if (!ellipsis) {
						gboolean multiple_cargs;
						/* if the vala argument expands to multiple C arguments,
						 we have to make sure that the C arguments don't depend
						 on each other as there is no guaranteed argument
						 evaluation order
						 http://bugzilla.gnome.org/show_bug.cgi?id=519597*/
						multiple_cargs = FALSE;
						if (!vala_formal_parameter_get_no_array_length (param) && VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))) {
							ValaArrayType* _tmp60;
							ValaArrayType* array_type;
							_tmp60 = NULL;
							array_type = (_tmp60 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp60 == NULL ? NULL : g_object_ref (_tmp60)));
							{
								gint dim;
								dim = 1;
								for (; dim <= vala_array_type_get_rank (array_type); dim++) {
									ValaCCodeExpression* _tmp61;
									_tmp61 = NULL;
									gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_carray_length_parameter_position (param) + 0.01 * dim, FALSE)), (_tmp61 = vala_ccode_generator_get_array_length_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), arg, dim)));
									(_tmp61 == NULL ? NULL : (_tmp61 = (g_object_unref (_tmp61), NULL)));
								}
							}
							multiple_cargs = TRUE;
							(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
						} else {
							if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param))) {
								ValaDelegateType* _tmp62;
								ValaDelegateType* deleg_type;
								ValaDelegate* _tmp63;
								ValaDelegate* d;
								_tmp62 = NULL;
								deleg_type = (_tmp62 = VALA_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp62 == NULL ? NULL : g_object_ref (_tmp62)));
								_tmp63 = NULL;
								d = (_tmp63 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp63 == NULL ? NULL : g_object_ref (_tmp63)));
								if (vala_delegate_get_has_target (d)) {
									ValaCCodeExpression* delegate_target;
									delegate_target = vala_ccode_generator_get_delegate_target_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), arg);
									if (vala_data_type_get_value_owned (VALA_DATA_TYPE (deleg_type))) {
										ValaCCodeExpression* delegate_target_destroy_notify;
										ValaMethod* _tmp65;
										ValaSymbol* _tmp64;
										ValaMethod* delegate_method;
										ValaMemberAccess* _tmp67;
										ValaExpression* _tmp66;
										ValaMemberAccess* ma;
										delegate_target_destroy_notify = NULL;
										_tmp65 = NULL;
										_tmp64 = NULL;
										delegate_method = (_tmp65 = (_tmp64 = vala_expression_get_symbol_reference (arg), (VALA_IS_METHOD (_tmp64) ? ((ValaMethod*) (_tmp64)) : NULL)), (_tmp65 == NULL ? NULL : g_object_ref (_tmp65)));
										_tmp67 = NULL;
										_tmp66 = NULL;
										ma = (_tmp67 = (_tmp66 = arg, (VALA_IS_MEMBER_ACCESS (_tmp66) ? ((ValaMemberAccess*) (_tmp66)) : NULL)), (_tmp67 == NULL ? NULL : g_object_ref (_tmp67)));
										if (delegate_method != NULL && vala_method_get_binding (delegate_method) == MEMBER_BINDING_INSTANCE && vala_member_access_get_inner (ma) != NULL && vala_data_type_get_data_type (vala_expression_get_value_type (vala_member_access_get_inner (ma))) != NULL && vala_typesymbol_is_reference_counting (vala_data_type_get_data_type (vala_expression_get_value_type (vala_member_access_get_inner (ma))))) {
											ValaCCodeExpression* _tmp68;
											ValaCCodeFunctionCall* _tmp69;
											ValaCCodeFunctionCall* ref_call;
											ValaCCodeExpression* _tmp71;
											ValaCCodeExpression* _tmp70;
											ValaCCodeExpression* _tmp72;
											_tmp68 = NULL;
											_tmp69 = NULL;
											ref_call = (_tmp69 = vala_ccode_function_call_new ((_tmp68 = vala_ccode_generator_get_dup_func_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_value_type (vala_member_access_get_inner (ma)), vala_code_node_get_source_reference (VALA_CODE_NODE (arg))))), (_tmp68 == NULL ? NULL : (_tmp68 = (g_object_unref (_tmp68), NULL))), _tmp69);
											vala_ccode_function_call_add_argument (ref_call, delegate_target);
											_tmp71 = NULL;
											_tmp70 = NULL;
											delegate_target = (_tmp71 = (_tmp70 = VALA_CCODE_EXPRESSION (ref_call), (_tmp70 == NULL ? NULL : g_object_ref (_tmp70))), (delegate_target == NULL ? NULL : (delegate_target = (g_object_unref (delegate_target), NULL))), _tmp71);
											_tmp72 = NULL;
											delegate_target_destroy_notify = (_tmp72 = vala_ccode_generator_get_destroy_func_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_value_type (vala_member_access_get_inner (ma))), (delegate_target_destroy_notify == NULL ? NULL : (delegate_target_destroy_notify = (g_object_unref (delegate_target_destroy_notify), NULL))), _tmp72);
											(ref_call == NULL ? NULL : (ref_call = (g_object_unref (ref_call), NULL)));
										} else {
											ValaCCodeExpression* _tmp73;
											_tmp73 = NULL;
											delegate_target_destroy_notify = (_tmp73 = VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")), (delegate_target_destroy_notify == NULL ? NULL : (delegate_target_destroy_notify = (g_object_unref (delegate_target_destroy_notify), NULL))), _tmp73);
										}
										gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param) + 0.01, FALSE)), delegate_target_destroy_notify);
										(delegate_target_destroy_notify == NULL ? NULL : (delegate_target_destroy_notify = (g_object_unref (delegate_target_destroy_notify), NULL)));
										(delegate_method == NULL ? NULL : (delegate_method = (g_object_unref (delegate_method), NULL)));
										(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
									}
									gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), delegate_target);
									multiple_cargs = TRUE;
									(delegate_target == NULL ? NULL : (delegate_target = (g_object_unref (delegate_target), NULL)));
								}
								(deleg_type == NULL ? NULL : (deleg_type = (g_object_unref (deleg_type), NULL)));
								(d == NULL ? NULL : (d = (g_object_unref (d), NULL)));
							} else {
								if (VALA_IS_METHOD_TYPE (vala_formal_parameter_get_parameter_type (param))) {
									ValaCCodeExpression* _tmp74;
									_tmp74 = NULL;
									gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), (_tmp74 = vala_ccode_generator_get_delegate_target_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), arg)));
									(_tmp74 == NULL ? NULL : (_tmp74 = (g_object_unref (_tmp74), NULL)));
									multiple_cargs = TRUE;
								}
							}
						}
						/* pass non-simple struct instances always by reference*/
						if (!(VALA_IS_NULL_TYPE (vala_expression_get_value_type (arg))) && VALA_IS_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param))) && !vala_struct_is_simple_type ((VALA_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param)))))) {
							/* we already use a reference for arguments of ref, out, and nullable parameters*/
							if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN && !vala_data_type_get_nullable (vala_formal_parameter_get_parameter_type (param))) {
								ValaCCodeUnaryExpression* _tmp76;
								ValaCCodeExpression* _tmp75;
								ValaCCodeUnaryExpression* unary;
								_tmp76 = NULL;
								_tmp75 = NULL;
								unary = (_tmp76 = (_tmp75 = cexpr, (VALA_IS_CCODE_UNARY_EXPRESSION (_tmp75) ? ((ValaCCodeUnaryExpression*) (_tmp75)) : NULL)), (_tmp76 == NULL ? NULL : g_object_ref (_tmp76)));
								if (unary != NULL && vala_ccode_unary_expression_get_operator (unary) == VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION) {
									ValaCCodeExpression* _tmp78;
									ValaCCodeExpression* _tmp77;
									/* *expr => expr*/
									_tmp78 = NULL;
									_tmp77 = NULL;
									cexpr = (_tmp78 = (_tmp77 = vala_ccode_unary_expression_get_inner (unary), (_tmp77 == NULL ? NULL : g_object_ref (_tmp77))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp78);
								} else {
									if (VALA_IS_CCODE_IDENTIFIER (cexpr) || VALA_IS_CCODE_MEMBER_ACCESS (cexpr)) {
										ValaCCodeExpression* _tmp79;
										_tmp79 = NULL;
										cexpr = (_tmp79 = VALA_CCODE_EXPRESSION (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, cexpr)), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp79);
									} else {
										ValaCCodeCommaExpression* ccomma;
										ValaLocalVariable* temp_var;
										ValaCCodeAssignment* _tmp81;
										ValaCCodeIdentifier* _tmp80;
										ValaCCodeUnaryExpression* _tmp83;
										ValaCCodeIdentifier* _tmp82;
										ValaCCodeExpression* _tmp85;
										ValaCCodeExpression* _tmp84;
										/* if cexpr is e.g. a function call, we can't take the address of the expression
										 (tmp = expr, &tmp)*/
										ccomma = vala_ccode_comma_expression_new ();
										temp_var = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_value_type (arg), TRUE, NULL);
										gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_var);
										_tmp81 = NULL;
										_tmp80 = NULL;
										vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp81 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp80 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var))))), cexpr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
										(_tmp81 == NULL ? NULL : (_tmp81 = (g_object_unref (_tmp81), NULL)));
										(_tmp80 == NULL ? NULL : (_tmp80 = (g_object_unref (_tmp80), NULL)));
										_tmp83 = NULL;
										_tmp82 = NULL;
										vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp83 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp82 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var)))))))));
										(_tmp83 == NULL ? NULL : (_tmp83 = (g_object_unref (_tmp83), NULL)));
										(_tmp82 == NULL ? NULL : (_tmp82 = (g_object_unref (_tmp82), NULL)));
										_tmp85 = NULL;
										_tmp84 = NULL;
										cexpr = (_tmp85 = (_tmp84 = VALA_CCODE_EXPRESSION (ccomma), (_tmp84 == NULL ? NULL : g_object_ref (_tmp84))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp85);
										(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
										(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
									}
								}
								(unary == NULL ? NULL : (unary = (g_object_unref (unary), NULL)));
							}
						}
						if (multiple_cargs && VALA_IS_INVOCATION_EXPRESSION (arg)) {
							ValaCCodeCommaExpression* ccomma;
							ValaLocalVariable* temp_decl;
							ValaCCodeAssignment* _tmp87;
							ValaCCodeIdentifier* _tmp86;
							ValaCCodeExpression* _tmp88;
							ValaCCodeExpression* _tmp90;
							ValaCCodeExpression* _tmp89;
							/* if vala argument is invocation expression
							 the auxiliary C argument(s) will depend on the main C argument
							 (tmp = arg1, call (tmp, arg2, arg3,...))*/
							ccomma = vala_ccode_comma_expression_new ();
							temp_decl = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_value_type (arg), TRUE, NULL);
							gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_decl);
							_tmp87 = NULL;
							_tmp86 = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp87 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp86 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl))))), cexpr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
							(_tmp87 == NULL ? NULL : (_tmp87 = (g_object_unref (_tmp87), NULL)));
							(_tmp86 == NULL ? NULL : (_tmp86 = (g_object_unref (_tmp86), NULL)));
							_tmp88 = NULL;
							cexpr = (_tmp88 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl)))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp88);
							vala_ccode_comma_expression_append_expression (ccomma, ccall_expr);
							_tmp90 = NULL;
							_tmp89 = NULL;
							ccall_expr = (_tmp90 = (_tmp89 = VALA_CCODE_EXPRESSION (ccomma), (_tmp89 == NULL ? NULL : g_object_ref (_tmp89))), (ccall_expr == NULL ? NULL : (ccall_expr = (g_object_unref (ccall_expr), NULL))), _tmp90);
							(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
							(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
						}
						/* unref old value for non-null non-weak ref/out arguments
						 disabled for arrays for now as that requires special handling
						 (ret_tmp = call (&tmp), var1 = (assign_tmp = dup (tmp), free (var1), assign_tmp), ret_tmp)*/
						if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN && vala_ccode_generator_requires_destroy (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_value_type (arg)) && (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT || !vala_data_type_get_value_owned (vala_formal_parameter_get_parameter_type (param))) && !(VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)))) {
							ValaUnaryExpression* _tmp91;
							ValaUnaryExpression* unary;
							ValaCCodeCommaExpression* ccomma;
							ValaLocalVariable* temp_var;
							ValaCCodeExpression* _tmp93;
							ValaCCodeIdentifier* _tmp92;
							ValaLocalVariable* ret_temp_var;
							ValaCCodeCommaExpression* cassign_comma;
							ValaLocalVariable* assign_temp_var;
							ValaCCodeAssignment* _tmp104;
							ValaCCodeExpression* _tmp103;
							ValaCCodeIdentifier* _tmp102;
							ValaCCodeIdentifier* _tmp101;
							ValaCCodeExpression* _tmp105;
							ValaCCodeIdentifier* _tmp106;
							ValaCCodeAssignment* _tmp107;
							ValaCCodeExpression* _tmp110;
							ValaCCodeExpression* _tmp109;
							_tmp91 = NULL;
							unary = (_tmp91 = VALA_UNARY_EXPRESSION (arg), (_tmp91 == NULL ? NULL : g_object_ref (_tmp91)));
							ccomma = vala_ccode_comma_expression_new ();
							temp_var = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_parameter_type (param), vala_data_type_get_value_owned (vala_formal_parameter_get_parameter_type (param)), NULL);
							gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_var);
							_tmp93 = NULL;
							_tmp92 = NULL;
							cexpr = (_tmp93 = VALA_CCODE_EXPRESSION (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp92 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var))))))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp93);
							(_tmp92 == NULL ? NULL : (_tmp92 = (g_object_unref (_tmp92), NULL)));
							if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_REF) {
								ValaCCodeCommaExpression* crefcomma;
								ValaCCodeAssignment* _tmp95;
								ValaCCodeIdentifier* _tmp94;
								ValaCCodeExpression* _tmp97;
								ValaCCodeExpression* _tmp96;
								crefcomma = vala_ccode_comma_expression_new ();
								_tmp95 = NULL;
								_tmp94 = NULL;
								vala_ccode_comma_expression_append_expression (crefcomma, VALA_CCODE_EXPRESSION ((_tmp95 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp94 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_unary_expression_get_inner (unary)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
								(_tmp95 == NULL ? NULL : (_tmp95 = (g_object_unref (_tmp95), NULL)));
								(_tmp94 == NULL ? NULL : (_tmp94 = (g_object_unref (_tmp94), NULL)));
								vala_ccode_comma_expression_append_expression (crefcomma, cexpr);
								_tmp97 = NULL;
								_tmp96 = NULL;
								cexpr = (_tmp97 = (_tmp96 = VALA_CCODE_EXPRESSION (crefcomma), (_tmp96 == NULL ? NULL : g_object_ref (_tmp96))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp97);
								(crefcomma == NULL ? NULL : (crefcomma = (g_object_unref (crefcomma), NULL)));
							}
							/* call function*/
							ret_temp_var = NULL;
							if (VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
								vala_ccode_comma_expression_append_expression (ccomma, ccall_expr);
							} else {
								ValaLocalVariable* _tmp98;
								ValaCCodeAssignment* _tmp100;
								ValaCCodeIdentifier* _tmp99;
								_tmp98 = NULL;
								ret_temp_var = (_tmp98 = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_return_type (m), TRUE, NULL), (ret_temp_var == NULL ? NULL : (ret_temp_var = (g_object_unref (ret_temp_var), NULL))), _tmp98);
								gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, ret_temp_var);
								_tmp100 = NULL;
								_tmp99 = NULL;
								vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp100 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp99 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (ret_temp_var))))), ccall_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
								(_tmp100 == NULL ? NULL : (_tmp100 = (g_object_unref (_tmp100), NULL)));
								(_tmp99 == NULL ? NULL : (_tmp99 = (g_object_unref (_tmp99), NULL)));
							}
							cassign_comma = vala_ccode_comma_expression_new ();
							assign_temp_var = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), vala_data_type_get_value_owned (vala_expression_get_value_type (vala_unary_expression_get_inner (unary))), NULL);
							gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, assign_temp_var);
							_tmp104 = NULL;
							_tmp103 = NULL;
							_tmp102 = NULL;
							_tmp101 = NULL;
							vala_ccode_comma_expression_append_expression (cassign_comma, VALA_CCODE_EXPRESSION ((_tmp104 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp101 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (assign_temp_var))))), (_tmp103 = vala_ccode_generator_transform_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_CCODE_EXPRESSION ((_tmp102 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var))))), vala_formal_parameter_get_parameter_type (param), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), arg)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
							(_tmp104 == NULL ? NULL : (_tmp104 = (g_object_unref (_tmp104), NULL)));
							(_tmp103 == NULL ? NULL : (_tmp103 = (g_object_unref (_tmp103), NULL)));
							(_tmp102 == NULL ? NULL : (_tmp102 = (g_object_unref (_tmp102), NULL)));
							(_tmp101 == NULL ? NULL : (_tmp101 = (g_object_unref (_tmp101), NULL)));
							/* unref old value*/
							_tmp105 = NULL;
							vala_ccode_comma_expression_append_expression (cassign_comma, (_tmp105 = vala_ccode_generator_get_unref_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_unary_expression_get_inner (unary)))), vala_expression_get_value_type (arg), arg)));
							(_tmp105 == NULL ? NULL : (_tmp105 = (g_object_unref (_tmp105), NULL)));
							_tmp106 = NULL;
							vala_ccode_comma_expression_append_expression (cassign_comma, VALA_CCODE_EXPRESSION ((_tmp106 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (assign_temp_var))))));
							(_tmp106 == NULL ? NULL : (_tmp106 = (g_object_unref (_tmp106), NULL)));
							/* assign new value*/
							_tmp107 = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp107 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_unary_expression_get_inner (unary)))), VALA_CCODE_EXPRESSION (cassign_comma), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
							(_tmp107 == NULL ? NULL : (_tmp107 = (g_object_unref (_tmp107), NULL)));
							/* return value*/
							if (!(VALA_IS_VOID_TYPE (vala_method_get_return_type (m)))) {
								ValaCCodeIdentifier* _tmp108;
								_tmp108 = NULL;
								vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp108 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (ret_temp_var))))));
								(_tmp108 == NULL ? NULL : (_tmp108 = (g_object_unref (_tmp108), NULL)));
							}
							_tmp110 = NULL;
							_tmp109 = NULL;
							ccall_expr = (_tmp110 = (_tmp109 = VALA_CCODE_EXPRESSION (ccomma), (_tmp109 == NULL ? NULL : g_object_ref (_tmp109))), (ccall_expr == NULL ? NULL : (ccall_expr = (g_object_unref (ccall_expr), NULL))), _tmp110);
							(unary == NULL ? NULL : (unary = (g_object_unref (unary), NULL)));
							(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
							(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
							(ret_temp_var == NULL ? NULL : (ret_temp_var = (g_object_unref (ret_temp_var), NULL)));
							(cassign_comma == NULL ? NULL : (cassign_comma = (g_object_unref (cassign_comma), NULL)));
							(assign_temp_var == NULL ? NULL : (assign_temp_var = (g_object_unref (assign_temp_var), NULL)));
						}
						if (vala_formal_parameter_get_ctype (param) != NULL) {
							ValaCCodeExpression* _tmp111;
							_tmp111 = NULL;
							cexpr = (_tmp111 = VALA_CCODE_EXPRESSION (vala_ccode_cast_expression_new (cexpr, vala_formal_parameter_get_ctype (param))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp111);
						}
					}
					arg_pos = vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cparameter_position (param), ellipsis);
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
				} else {
					/* default argument position*/
					arg_pos = vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ((double) (i)), ellipsis);
				}
				gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (arg_pos), cexpr);
				i++;
				(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
				(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
				(extra_args == NULL ? NULL : (extra_args = (g_object_unref (extra_args), NULL)));
			}
		}
		(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
	}
	while (gee_iterator_next (params_it)) {
		ValaFormalParameter* param;
		param = ((ValaFormalParameter*) (gee_iterator_get (params_it)));
		if (vala_formal_parameter_get_ellipsis (param)) {
			ellipsis = TRUE;
			(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			break;
		}
		if (vala_formal_parameter_get_default_expression (param) == NULL) {
			char* _tmp112;
			_tmp112 = NULL;
			vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), (_tmp112 = g_strdup_printf ("no default expression for argument %d", i)));
			_tmp112 = (g_free (_tmp112), NULL);
			(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
			(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
			(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
			(itype == NULL ? NULL : (itype = (g_object_unref (itype), NULL)));
			(ccall_expr == NULL ? NULL : (ccall_expr = (g_object_unref (ccall_expr), NULL)));
			(carg_map == NULL ? NULL : (carg_map = (g_object_unref (carg_map), NULL)));
			(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
			(params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL)));
			return;
		}
		/* evaluate default expression here as the code
		 * generator might not have visited the formal
		 * parameter yet */
		vala_code_node_accept (VALA_CODE_NODE (vala_formal_parameter_get_default_expression (param)), VALA_CODE_VISITOR (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))));
		if (!vala_formal_parameter_get_no_array_length (param) && vala_formal_parameter_get_parameter_type (param) != NULL && VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))) {
			ValaArrayType* _tmp113;
			ValaArrayType* array_type;
			_tmp113 = NULL;
			array_type = (_tmp113 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp113 == NULL ? NULL : g_object_ref (_tmp113)));
			{
				gint dim;
				dim = 1;
				for (; dim <= vala_array_type_get_rank (array_type); dim++) {
					ValaCCodeExpression* _tmp114;
					_tmp114 = NULL;
					gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_carray_length_parameter_position (param) + 0.01 * dim, FALSE)), (_tmp114 = vala_ccode_generator_get_array_length_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_default_expression (param), dim)));
					(_tmp114 == NULL ? NULL : (_tmp114 = (g_object_unref (_tmp114), NULL)));
				}
			}
			(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
		}
		gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cparameter_position (param), FALSE)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_formal_parameter_get_default_expression (param)))));
		i++;
		(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
	}
	/* add length argument for methods returning arrays */
	if (m != NULL && VALA_IS_ARRAY_TYPE (vala_method_get_return_type (m))) {
		ValaArrayType* _tmp115;
		ValaArrayType* array_type;
		_tmp115 = NULL;
		array_type = (_tmp115 = VALA_ARRAY_TYPE (vala_method_get_return_type (m)), (_tmp115 == NULL ? NULL : g_object_ref (_tmp115)));
		{
			gint dim;
			dim = 1;
			for (; dim <= vala_array_type_get_rank (array_type); dim++) {
				if (!vala_method_get_no_array_length (m)) {
					ValaLocalVariable* temp_var;
					ValaCCodeIdentifier* temp_ref;
					ValaCCodeUnaryExpression* _tmp116;
					temp_var = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->int_type, TRUE, NULL);
					temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var)));
					gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_var);
					_tmp116 = NULL;
					gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_carray_length_parameter_position (m) + 0.01 * dim, FALSE)), VALA_CCODE_EXPRESSION ((_tmp116 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (temp_ref)))));
					(_tmp116 == NULL ? NULL : (_tmp116 = (g_object_unref (_tmp116), NULL)));
					vala_invocation_expression_append_array_size (expr, VALA_CCODE_EXPRESSION (temp_ref));
					(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
					(temp_ref == NULL ? NULL : (temp_ref = (g_object_unref (temp_ref), NULL)));
				} else {
					ValaCCodeConstant* _tmp117;
					_tmp117 = NULL;
					vala_invocation_expression_append_array_size (expr, VALA_CCODE_EXPRESSION ((_tmp117 = vala_ccode_constant_new ("-1"))));
					(_tmp117 == NULL ? NULL : (_tmp117 = (g_object_unref (_tmp117), NULL)));
				}
			}
		}
		(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
	} else {
		if (m != NULL && VALA_IS_DELEGATE_TYPE (vala_method_get_return_type (m))) {
			ValaDelegateType* _tmp118;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp119;
			ValaDelegate* d;
			_tmp118 = NULL;
			deleg_type = (_tmp118 = VALA_DELEGATE_TYPE (vala_method_get_return_type (m)), (_tmp118 == NULL ? NULL : g_object_ref (_tmp118)));
			_tmp119 = NULL;
			d = (_tmp119 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp119 == NULL ? NULL : g_object_ref (_tmp119)));
			if (vala_delegate_get_has_target (d)) {
				ValaPointerType* _tmp121;
				ValaVoidType* _tmp120;
				ValaLocalVariable* _tmp122;
				ValaLocalVariable* temp_var;
				ValaCCodeIdentifier* temp_ref;
				ValaCCodeUnaryExpression* _tmp123;
				_tmp121 = NULL;
				_tmp120 = NULL;
				_tmp122 = NULL;
				temp_var = (_tmp122 = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_DATA_TYPE ((_tmp121 = vala_pointer_type_new (VALA_DATA_TYPE ((_tmp120 = vala_void_type_new ())), NULL))), TRUE, NULL), (_tmp121 == NULL ? NULL : (_tmp121 = (g_object_unref (_tmp121), NULL))), (_tmp120 == NULL ? NULL : (_tmp120 = (g_object_unref (_tmp120), NULL))), _tmp122);
				temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var)));
				gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_var);
				_tmp123 = NULL;
				gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cdelegate_target_parameter_position (m), FALSE)), VALA_CCODE_EXPRESSION ((_tmp123 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (temp_ref)))));
				(_tmp123 == NULL ? NULL : (_tmp123 = (g_object_unref (_tmp123), NULL)));
				vala_invocation_expression_set_delegate_target (expr, VALA_CCODE_EXPRESSION (temp_ref));
				(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
				(temp_ref == NULL ? NULL : (temp_ref = (g_object_unref (temp_ref), NULL)));
			}
			(deleg_type == NULL ? NULL : (deleg_type = (g_object_unref (deleg_type), NULL)));
			(d == NULL ? NULL : (d = (g_object_unref (d), NULL)));
		}
	}
	if (vala_code_node_get_tree_can_fail (VALA_CODE_NODE (expr))) {
		ValaCCodeUnaryExpression* _tmp125;
		ValaCCodeIdentifier* _tmp124;
		/* method can fail*/
		vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method_inner_error = TRUE;
		/* add &inner_error before the ellipsis arguments*/
		_tmp125 = NULL;
		_tmp124 = NULL;
		gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ((double) (-2)), FALSE)), VALA_CCODE_EXPRESSION ((_tmp125 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp124 = vala_ccode_identifier_new ("inner_error")))))));
		(_tmp125 == NULL ? NULL : (_tmp125 = (g_object_unref (_tmp125), NULL)));
		(_tmp124 == NULL ? NULL : (_tmp124 = (g_object_unref (_tmp124), NULL)));
	}
	if (ellipsis) {
		/* ensure variable argument list ends with NULL
		 * except when using printf-style arguments */
		if ((m == NULL || !vala_method_get_printf_format (m))) {
			ValaCCodeConstant* _tmp126;
			_tmp126 = NULL;
			gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ((double) (-1)), TRUE)), VALA_CCODE_EXPRESSION ((_tmp126 = vala_ccode_constant_new (vala_method_get_sentinel (m)))));
			(_tmp126 == NULL ? NULL : (_tmp126 = (g_object_unref (_tmp126), NULL)));
		}
	} else {
		if (VALA_IS_DELEGATE_TYPE (itype)) {
			ValaDelegateType* _tmp127;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp128;
			ValaDelegate* d;
			_tmp127 = NULL;
			deleg_type = (_tmp127 = VALA_DELEGATE_TYPE (itype), (_tmp127 == NULL ? NULL : g_object_ref (_tmp127)));
			_tmp128 = NULL;
			d = (_tmp128 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp128 == NULL ? NULL : g_object_ref (_tmp128)));
			if (vala_delegate_get_has_target (d)) {
				ValaCCodeExpression* _tmp129;
				_tmp129 = NULL;
				gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_delegate_get_cinstance_parameter_position (d), FALSE)), (_tmp129 = vala_ccode_generator_get_delegate_target_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_invocation_expression_get_call (expr))));
				(_tmp129 == NULL ? NULL : (_tmp129 = (g_object_unref (_tmp129), NULL)));
			}
			(deleg_type == NULL ? NULL : (deleg_type = (g_object_unref (deleg_type), NULL)));
			(d == NULL ? NULL : (d = (g_object_unref (d), NULL)));
		}
	}
	/* pass address for the return value of non-void signals without emitter functions*/
	_tmp130 = NULL;
	if ((_tmp131 = VALA_IS_SIGNAL_TYPE (itype) && !(VALA_IS_VOID_TYPE ((_tmp130 = vala_data_type_get_return_type (itype)))), (_tmp130 == NULL ? NULL : (_tmp130 = (g_object_unref (_tmp130), NULL))), _tmp131)) {
		ValaSignal* _tmp132;
		ValaSignal* sig;
		_tmp132 = NULL;
		sig = (_tmp132 = vala_signal_type_get_signal_symbol ((VALA_SIGNAL_TYPE (itype))), (_tmp132 == NULL ? NULL : g_object_ref (_tmp132)));
		if (!vala_signal_get_has_emitter (sig)) {
			ValaDataType* _tmp133;
			ValaLocalVariable* _tmp134;
			ValaLocalVariable* temp_var;
			ValaCCodeIdentifier* temp_ref;
			ValaCCodeUnaryExpression* _tmp135;
			ValaCCodeCommaExpression* ccomma;
			ValaCCodeExpression* _tmp137;
			ValaCCodeExpression* _tmp136;
			_tmp133 = NULL;
			_tmp134 = NULL;
			temp_var = (_tmp134 = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), (_tmp133 = vala_data_type_get_return_type (itype)), TRUE, NULL), (_tmp133 == NULL ? NULL : (_tmp133 = (g_object_unref (_tmp133), NULL))), _tmp134);
			temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var)));
			gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_var);
			_tmp135 = NULL;
			gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ((double) (-1)), TRUE)), VALA_CCODE_EXPRESSION ((_tmp135 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (temp_ref)))));
			(_tmp135 == NULL ? NULL : (_tmp135 = (g_object_unref (_tmp135), NULL)));
			ccomma = vala_ccode_comma_expression_new ();
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall_expr));
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (temp_ref));
			_tmp137 = NULL;
			_tmp136 = NULL;
			ccall_expr = (_tmp137 = (_tmp136 = VALA_CCODE_EXPRESSION (ccomma), (_tmp136 == NULL ? NULL : g_object_ref (_tmp136))), (ccall_expr == NULL ? NULL : (ccall_expr = (g_object_unref (ccall_expr), NULL))), _tmp137);
			(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
			(temp_ref == NULL ? NULL : (temp_ref = (g_object_unref (temp_ref), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		}
		(sig == NULL ? NULL : (sig = (g_object_unref (sig), NULL)));
	}
	/* append C arguments in the right order*/
	last_pos = -1;
	min_pos = 0;
	while (TRUE) {
		ValaCCodeExpression* _tmp138;
		min_pos = -1;
		{
			GeeSet* pos_collection;
			GeeIterator* pos_it;
			pos_collection = gee_map_get_keys (GEE_MAP (carg_map));
			pos_it = gee_iterable_iterator (GEE_ITERABLE (pos_collection));
			while (gee_iterator_next (pos_it)) {
				gint pos;
				pos = GPOINTER_TO_INT (gee_iterator_get (pos_it));
				{
					if (pos > last_pos && (min_pos == -1 || pos < min_pos)) {
						min_pos = pos;
					}
				}
			}
			(pos_it == NULL ? NULL : (pos_it = (g_object_unref (pos_it), NULL)));
			(pos_collection == NULL ? NULL : (pos_collection = (g_object_unref (pos_collection), NULL)));
		}
		if (min_pos == -1) {
			break;
		}
		_tmp138 = NULL;
		vala_ccode_function_call_add_argument (ccall, (_tmp138 = ((ValaCCodeExpression*) (gee_map_get (GEE_MAP (carg_map), GINT_TO_POINTER (min_pos))))));
		(_tmp138 == NULL ? NULL : (_tmp138 = (g_object_unref (_tmp138), NULL)));
		last_pos = min_pos;
	}
	if (m != NULL && vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE && vala_method_get_returns_modified_pointer (m)) {
		ValaCCodeAssignment* _tmp139;
		_tmp139 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp139 = vala_ccode_assignment_new (instance, ccall_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(_tmp139 == NULL ? NULL : (_tmp139 = (g_object_unref (_tmp139), NULL)));
	} else {
		/* cast pointer to actual type if this is a generic method return value */
		if (m != NULL && vala_data_type_get_type_parameter (vala_method_get_return_type (m)) != NULL && vala_data_type_get_data_type (vala_expression_get_value_type (VALA_EXPRESSION (expr))) != NULL) {
			ValaCCodeExpression* _tmp140;
			_tmp140 = NULL;
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp140 = vala_ccode_generator_convert_from_generic_pointer (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ccall_expr, vala_expression_get_value_type (VALA_EXPRESSION (expr))))));
			(_tmp140 == NULL ? NULL : (_tmp140 = (g_object_unref (_tmp140), NULL)));
		} else {
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall_expr));
		}
	}
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		GeeList* _tmp141;
		GeeIterator* _tmp142;
		GeeIterator* arg_it;
		ValaCCodeExpression* _tmp144;
		ValaExpression* _tmp143;
		ValaCCodeExpression* _tmp145;
		ValaCCodeExpression* new_size;
		ValaLocalVariable* temp_decl;
		ValaCCodeIdentifier* temp_ref;
		ValaCCodeExpression* clen;
		ValaCCodeExpression* _tmp146;
		ValaCCodeExpression* celems;
		ValaArrayType* _tmp147;
		ValaArrayType* array_type;
		char* _tmp149;
		char* _tmp148;
		ValaCCodeIdentifier* _tmp150;
		ValaCCodeIdentifier* csizeof;
		ValaCCodeBinaryExpression* _tmp151;
		ValaCCodeParenthesizedExpression* _tmp152;
		ValaCCodeParenthesizedExpression* cdelta;
		ValaCCodeBinaryExpression* ccheck;
		ValaCCodeIdentifier* _tmp153;
		ValaCCodeFunctionCall* _tmp154;
		ValaCCodeFunctionCall* czero;
		ValaCCodeBinaryExpression* _tmp155;
		ValaCCodeConstant* _tmp156;
		ValaCCodeBinaryExpression* _tmp157;
		ValaCCodeCommaExpression* ccomma;
		ValaCCodeAssignment* _tmp158;
		ValaCCodeConditionalExpression* _tmp160;
		ValaCCodeConstant* _tmp159;
		ValaCCodeAssignment* _tmp162;
		ValaCCodeExpression* _tmp161;
		/* FIXME: size expression must not be evaluated twice at runtime (potential side effects)*/
		_tmp141 = NULL;
		_tmp142 = NULL;
		arg_it = (_tmp142 = gee_iterable_iterator (GEE_ITERABLE ((_tmp141 = vala_invocation_expression_get_argument_list (expr)))), (_tmp141 == NULL ? NULL : (_tmp141 = (g_object_unref (_tmp141), NULL))), _tmp142);
		gee_iterator_next (arg_it);
		_tmp144 = NULL;
		_tmp143 = NULL;
		_tmp145 = NULL;
		new_size = (_tmp145 = (_tmp144 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE ((_tmp143 = ((ValaExpression*) (gee_iterator_get (arg_it))))))), (_tmp144 == NULL ? NULL : g_object_ref (_tmp144))), (_tmp143 == NULL ? NULL : (_tmp143 = (g_object_unref (_tmp143), NULL))), _tmp145);
		temp_decl = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->int_type, TRUE, NULL);
		temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl)));
		gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_decl);
		/* memset needs string.h */
		vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_h_needed = TRUE;
		clen = vala_ccode_generator_get_array_length_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_member_access_get_inner (ma), 1);
		_tmp146 = NULL;
		celems = (_tmp146 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))), (_tmp146 == NULL ? NULL : g_object_ref (_tmp146)));
		_tmp147 = NULL;
		array_type = (_tmp147 = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (ma))), (_tmp147 == NULL ? NULL : g_object_ref (_tmp147)));
		_tmp149 = NULL;
		_tmp148 = NULL;
		_tmp150 = NULL;
		csizeof = (_tmp150 = vala_ccode_identifier_new ((_tmp149 = g_strdup_printf ("sizeof (%s)", (_tmp148 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))))), (_tmp149 = (g_free (_tmp149), NULL)), (_tmp148 = (g_free (_tmp148), NULL)), _tmp150);
		_tmp151 = NULL;
		_tmp152 = NULL;
		cdelta = (_tmp152 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION ((_tmp151 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, VALA_CCODE_EXPRESSION (temp_ref), clen)))), (_tmp151 == NULL ? NULL : (_tmp151 = (g_object_unref (_tmp151), NULL))), _tmp152);
		ccheck = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, VALA_CCODE_EXPRESSION (temp_ref), clen);
		_tmp153 = NULL;
		_tmp154 = NULL;
		czero = (_tmp154 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp153 = vala_ccode_identifier_new ("memset")))), (_tmp153 == NULL ? NULL : (_tmp153 = (g_object_unref (_tmp153), NULL))), _tmp154);
		_tmp155 = NULL;
		vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp155 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, celems, clen))));
		(_tmp155 == NULL ? NULL : (_tmp155 = (g_object_unref (_tmp155), NULL)));
		_tmp156 = NULL;
		vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp156 = vala_ccode_constant_new ("0"))));
		(_tmp156 == NULL ? NULL : (_tmp156 = (g_object_unref (_tmp156), NULL)));
		_tmp157 = NULL;
		vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp157 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION (csizeof), VALA_CCODE_EXPRESSION (cdelta)))));
		(_tmp157 == NULL ? NULL : (_tmp157 = (g_object_unref (_tmp157), NULL)));
		ccomma = vala_ccode_comma_expression_new ();
		_tmp158 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp158 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (temp_ref), new_size, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(_tmp158 == NULL ? NULL : (_tmp158 = (g_object_unref (_tmp158), NULL)));
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))));
		_tmp160 = NULL;
		_tmp159 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp160 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (ccheck), VALA_CCODE_EXPRESSION (czero), VALA_CCODE_EXPRESSION ((_tmp159 = vala_ccode_constant_new ("NULL")))))));
		(_tmp160 == NULL ? NULL : (_tmp160 = (g_object_unref (_tmp160), NULL)));
		(_tmp159 == NULL ? NULL : (_tmp159 = (g_object_unref (_tmp159), NULL)));
		_tmp162 = NULL;
		_tmp161 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp162 = vala_ccode_assignment_new ((_tmp161 = vala_ccode_generator_get_array_length_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_member_access_get_inner (ma), 1)), VALA_CCODE_EXPRESSION (temp_ref), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(_tmp162 == NULL ? NULL : (_tmp162 = (g_object_unref (_tmp162), NULL)));
		(_tmp161 == NULL ? NULL : (_tmp161 = (g_object_unref (_tmp161), NULL)));
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
		(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
		(new_size == NULL ? NULL : (new_size = (g_object_unref (new_size), NULL)));
		(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
		(temp_ref == NULL ? NULL : (temp_ref = (g_object_unref (temp_ref), NULL)));
		(clen == NULL ? NULL : (clen = (g_object_unref (clen), NULL)));
		(celems == NULL ? NULL : (celems = (g_object_unref (celems), NULL)));
		(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
		(csizeof == NULL ? NULL : (csizeof = (g_object_unref (csizeof), NULL)));
		(cdelta == NULL ? NULL : (cdelta = (g_object_unref (cdelta), NULL)));
		(ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL)));
		(czero == NULL ? NULL : (czero = (g_object_unref (czero), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
	} else {
		if (m == vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->substring_method) {
			ValaLocalVariable* temp_decl;
			ValaCCodeIdentifier* temp_ref;
			GeeList* args;
			ValaCCodeIdentifier* _tmp163;
			ValaCCodeFunctionCall* _tmp164;
			ValaCCodeFunctionCall* coffsetcall;
			ValaCCodeExpression* _tmp165;
			ValaCCodeExpression* _tmp166;
			ValaCCodeIdentifier* _tmp167;
			ValaCCodeFunctionCall* _tmp168;
			ValaCCodeFunctionCall* coffsetcall2;
			ValaCCodeExpression* _tmp169;
			ValaCCodeIdentifier* _tmp170;
			ValaCCodeFunctionCall* _tmp171;
			ValaCCodeFunctionCall* cndupcall;
			ValaCCodeBinaryExpression* _tmp172;
			ValaCCodeCommaExpression* ccomma;
			ValaCCodeAssignment* _tmp173;
			temp_decl = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type, TRUE, NULL);
			temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl)));
			gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_decl);
			args = vala_ccode_function_call_get_arguments (ccall);
			_tmp163 = NULL;
			_tmp164 = NULL;
			coffsetcall = (_tmp164 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp163 = vala_ccode_identifier_new ("g_utf8_offset_to_pointer")))), (_tmp163 == NULL ? NULL : (_tmp163 = (g_object_unref (_tmp163), NULL))), _tmp164);
			/* full string*/
			_tmp165 = NULL;
			vala_ccode_function_call_add_argument (coffsetcall, (_tmp165 = ((ValaCCodeExpression*) (gee_list_get (((GeeList*) (args)), 0)))));
			(_tmp165 == NULL ? NULL : (_tmp165 = (g_object_unref (_tmp165), NULL)));
			/* offset*/
			_tmp166 = NULL;
			vala_ccode_function_call_add_argument (coffsetcall, (_tmp166 = ((ValaCCodeExpression*) (gee_list_get (((GeeList*) (args)), 1)))));
			(_tmp166 == NULL ? NULL : (_tmp166 = (g_object_unref (_tmp166), NULL)));
			_tmp167 = NULL;
			_tmp168 = NULL;
			coffsetcall2 = (_tmp168 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp167 = vala_ccode_identifier_new ("g_utf8_offset_to_pointer")))), (_tmp167 == NULL ? NULL : (_tmp167 = (g_object_unref (_tmp167), NULL))), _tmp168);
			vala_ccode_function_call_add_argument (coffsetcall2, VALA_CCODE_EXPRESSION (temp_ref));
			/* len*/
			_tmp169 = NULL;
			vala_ccode_function_call_add_argument (coffsetcall2, (_tmp169 = ((ValaCCodeExpression*) (gee_list_get (((GeeList*) (args)), 2)))));
			(_tmp169 == NULL ? NULL : (_tmp169 = (g_object_unref (_tmp169), NULL)));
			_tmp170 = NULL;
			_tmp171 = NULL;
			cndupcall = (_tmp171 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp170 = vala_ccode_identifier_new ("g_strndup")))), (_tmp170 == NULL ? NULL : (_tmp170 = (g_object_unref (_tmp170), NULL))), _tmp171);
			vala_ccode_function_call_add_argument (cndupcall, VALA_CCODE_EXPRESSION (temp_ref));
			_tmp172 = NULL;
			vala_ccode_function_call_add_argument (cndupcall, VALA_CCODE_EXPRESSION ((_tmp172 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, VALA_CCODE_EXPRESSION (coffsetcall2), VALA_CCODE_EXPRESSION (temp_ref)))));
			(_tmp172 == NULL ? NULL : (_tmp172 = (g_object_unref (_tmp172), NULL)));
			ccomma = vala_ccode_comma_expression_new ();
			_tmp173 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp173 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (temp_ref), VALA_CCODE_EXPRESSION (coffsetcall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(_tmp173 == NULL ? NULL : (_tmp173 = (g_object_unref (_tmp173), NULL)));
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cndupcall));
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
			(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
			(temp_ref == NULL ? NULL : (temp_ref = (g_object_unref (temp_ref), NULL)));
			(args == NULL ? NULL : (args = (g_object_unref (args), NULL)));
			(coffsetcall == NULL ? NULL : (coffsetcall = (g_object_unref (coffsetcall), NULL)));
			(coffsetcall2 == NULL ? NULL : (coffsetcall2 = (g_object_unref (coffsetcall2), NULL)));
			(cndupcall == NULL ? NULL : (cndupcall = (g_object_unref (cndupcall), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		}
	}
	(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
	(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
	(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
	(itype == NULL ? NULL : (itype = (g_object_unref (itype), NULL)));
	(ccall_expr == NULL ? NULL : (ccall_expr = (g_object_unref (ccall_expr), NULL)));
	(carg_map == NULL ? NULL : (carg_map = (g_object_unref (carg_map), NULL)));
	(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
	(params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL)));
}


ValaInvocationExpression* vala_ccode_invocation_expression_binding_get_invocation_expression (ValaCCodeInvocationExpressionBinding* self) {
	g_return_val_if_fail (VALA_IS_CCODE_INVOCATION_EXPRESSION_BINDING (self), NULL);
	return self->priv->_invocation_expression;
}


void vala_ccode_invocation_expression_binding_set_invocation_expression (ValaCCodeInvocationExpressionBinding* self, ValaInvocationExpression* value) {
	ValaInvocationExpression* _tmp2;
	ValaInvocationExpression* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_INVOCATION_EXPRESSION_BINDING (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_invocation_expression = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_invocation_expression == NULL ? NULL : (self->priv->_invocation_expression = (g_object_unref (self->priv->_invocation_expression), NULL))), _tmp2);
	g_object_notify (((GObject *) (self)), "invocation-expression");
}


static void vala_ccode_invocation_expression_binding_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeInvocationExpressionBinding * self;
	self = VALA_CCODE_INVOCATION_EXPRESSION_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_INVOCATION_EXPRESSION_BINDING_INVOCATION_EXPRESSION:
		g_value_set_object (value, vala_ccode_invocation_expression_binding_get_invocation_expression (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_invocation_expression_binding_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeInvocationExpressionBinding * self;
	self = VALA_CCODE_INVOCATION_EXPRESSION_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_INVOCATION_EXPRESSION_BINDING_INVOCATION_EXPRESSION:
		vala_ccode_invocation_expression_binding_set_invocation_expression (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_invocation_expression_binding_class_init (ValaCCodeInvocationExpressionBindingClass * klass) {
	vala_ccode_invocation_expression_binding_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeInvocationExpressionBindingPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_invocation_expression_binding_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_invocation_expression_binding_set_property;
	G_OBJECT_CLASS (klass)->finalize = vala_ccode_invocation_expression_binding_finalize;
	VALA_CCODE_BINDING_CLASS (klass)->emit = vala_ccode_invocation_expression_binding_real_emit;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_INVOCATION_EXPRESSION_BINDING_INVOCATION_EXPRESSION, g_param_spec_object ("invocation-expression", "invocation-expression", "invocation-expression", VALA_TYPE_INVOCATION_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_invocation_expression_binding_instance_init (ValaCCodeInvocationExpressionBinding * self) {
	self->priv = VALA_CCODE_INVOCATION_EXPRESSION_BINDING_GET_PRIVATE (self);
}


static void vala_ccode_invocation_expression_binding_finalize (GObject * obj) {
	ValaCCodeInvocationExpressionBinding * self;
	self = VALA_CCODE_INVOCATION_EXPRESSION_BINDING (obj);
	(self->priv->_invocation_expression == NULL ? NULL : (self->priv->_invocation_expression = (g_object_unref (self->priv->_invocation_expression), NULL)));
	G_OBJECT_CLASS (vala_ccode_invocation_expression_binding_parent_class)->finalize (obj);
}


GType vala_ccode_invocation_expression_binding_get_type (void) {
	static GType vala_ccode_invocation_expression_binding_type_id = 0;
	if (vala_ccode_invocation_expression_binding_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeInvocationExpressionBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_invocation_expression_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeInvocationExpressionBinding), 0, (GInstanceInitFunc) vala_ccode_invocation_expression_binding_instance_init };
		vala_ccode_invocation_expression_binding_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION_BINDING, "ValaCCodeInvocationExpressionBinding", &g_define_type_info, 0);
	}
	return vala_ccode_invocation_expression_binding_type_id;
}




