/* valaccodeinvocationexpressionbinding.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodeinvocationexpressionbinding.h>
#include <vala/valacodenode.h>
#include <vala/valacodevisitor.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeexpression.h>
#include <vala/valamethod.h>
#include <gee/list.h>
#include <vala/valamemberaccess.h>
#include <vala/valaexpression.h>
#include <vala/valadatatype.h>
#include <vala/valamethodtype.h>
#include <vala/valasignaltype.h>
#include <gee/hashmap.h>
#include <vala/valaarrayresizemethod.h>
#include <vala/valaarraytype.h>
#include <gee/map.h>
#include <float.h>
#include <math.h>
#include <ccode/valaccodeidentifier.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valaarraymovemethod.h>
#include <vala/valamember.h>
#include <vala/valasymbol.h>
#include <vala/valastruct.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodememberaccess.h>
#include <ccode/valaccodecommaexpression.h>
#include <vala/valalocalvariable.h>
#include <ccode/valaccodeassignment.h>
#include <vala/valaclass.h>
#include <vala/valatypesymbol.h>
#include <vala/valadynamicmethod.h>
#include <vala/valaunaryexpression.h>
#include <vala/valaformalparameter.h>
#include <vala/valasourcereference.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <gee/arraylist.h>
#include <vala/valadelegatetype.h>
#include <vala/valadelegate.h>
#include <ccode/valaccodeconstant.h>
#include <vala/valanulltype.h>
#include <vala/valavoidtype.h>
#include <vala/valareport.h>
#include <vala/valapointertype.h>
#include <vala/valasignal.h>
#include <ccode/valaccodeparenthesizedexpression.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeconditionalexpression.h>
#include <gobject/valaccodebinding.h>
#include <gobject/valaccodedynamicmethodbinding.h>




struct _ValaCCodeInvocationExpressionBindingPrivate {
	ValaInvocationExpression* _invocation_expression;
};

#define VALA_CCODE_INVOCATION_EXPRESSION_BINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_INVOCATION_EXPRESSION_BINDING, ValaCCodeInvocationExpressionBindingPrivate))
enum  {
	VALA_CCODE_INVOCATION_EXPRESSION_BINDING_DUMMY_PROPERTY,
	VALA_CCODE_INVOCATION_EXPRESSION_BINDING_INVOCATION_EXPRESSION
};
static void vala_ccode_invocation_expression_binding_real_emit (ValaCCodeBinding* base);
static gpointer vala_ccode_invocation_expression_binding_parent_class = NULL;
static void vala_ccode_invocation_expression_binding_dispose (GObject * obj);



ValaCCodeInvocationExpressionBinding* vala_ccode_invocation_expression_binding_new (ValaCCodeGenerator* codegen, ValaInvocationExpression* invocation_expression) {
	ValaCCodeInvocationExpressionBinding * self;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (codegen), NULL);
	g_return_val_if_fail (VALA_IS_INVOCATION_EXPRESSION (invocation_expression), NULL);
	self = g_object_newv (VALA_TYPE_CCODE_INVOCATION_EXPRESSION_BINDING, 0, NULL);
	vala_ccode_invocation_expression_binding_set_invocation_expression (self, invocation_expression);
	vala_ccode_binding_set_codegen (VALA_CCODE_BINDING (self), codegen);
	return self;
}


static void vala_ccode_invocation_expression_binding_real_emit (ValaCCodeBinding* base) {
	ValaCCodeInvocationExpressionBinding * self;
	ValaInvocationExpression* _tmp0;
	ValaInvocationExpression* expr;
	ValaCCodeFunctionCall* ccall;
	ValaMethod* m;
	GeeList* params;
	ValaMemberAccess* _tmp2;
	ValaExpression* _tmp1;
	ValaMemberAccess* ma;
	ValaDataType* _tmp3;
	ValaDataType* itype;
	GeeList* _tmp4;
	ValaCCodeExpression* _tmp9;
	ValaCCodeExpression* ccall_expr;
	GeeHashMap* carg_map;
	ValaCCodeExpression* instance;
	gboolean ellipsis;
	gint i;
	gint arg_pos;
	GeeIterator* params_it;
	ValaDataType* _tmp118;
	gboolean _tmp119;
	gint last_pos;
	gint min_pos;
	self = VALA_CCODE_INVOCATION_EXPRESSION_BINDING (base);
	_tmp0 = NULL;
	expr = (_tmp0 = self->priv->_invocation_expression, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	vala_code_node_accept_children (VALA_CODE_NODE (expr), VALA_CODE_VISITOR (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))));
	/* the bare function call*/
	ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_invocation_expression_get_call (expr)))));
	m = NULL;
	params = NULL;
	_tmp2 = NULL;
	_tmp1 = NULL;
	ma = (_tmp2 = (_tmp1 = vala_invocation_expression_get_call (expr), (VALA_IS_MEMBER_ACCESS (_tmp1) ? ((ValaMemberAccess*) (_tmp1)) : NULL)), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
	_tmp3 = NULL;
	itype = (_tmp3 = vala_expression_get_value_type (vala_invocation_expression_get_call (expr)), (_tmp3 == NULL ? NULL : g_object_ref (_tmp3)));
	_tmp4 = NULL;
	params = (_tmp4 = vala_data_type_get_parameters (itype), (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), _tmp4);
	if (VALA_IS_METHOD_TYPE (itype)) {
		ValaMethod* _tmp6;
		ValaMethod* _tmp5;
		g_assert (ma != NULL);
		_tmp6 = NULL;
		_tmp5 = NULL;
		m = (_tmp6 = (_tmp5 = vala_method_type_get_method_symbol ((VALA_METHOD_TYPE (itype))), (_tmp5 == NULL ? NULL : g_object_ref (_tmp5))), (m == NULL ? NULL : (m = (g_object_unref (m), NULL))), _tmp6);
	} else {
		if (VALA_IS_SIGNAL_TYPE (itype)) {
			ValaCCodeFunctionCall* _tmp8;
			ValaCCodeFunctionCall* _tmp7;
			_tmp8 = NULL;
			_tmp7 = NULL;
			ccall = (_tmp8 = (_tmp7 = VALA_CCODE_FUNCTION_CALL (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_invocation_expression_get_call (expr)))), (_tmp7 == NULL ? NULL : g_object_ref (_tmp7))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp8);
		}
	}
	/* the complete call expression, might include casts, comma expressions, and/or assignments*/
	_tmp9 = NULL;
	ccall_expr = (_tmp9 = VALA_CCODE_EXPRESSION (ccall), (_tmp9 == NULL ? NULL : g_object_ref (_tmp9)));
	carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		ValaArrayType* _tmp10;
		ValaArrayType* array_type;
		ValaCCodeIdentifier* _tmp12;
		char* _tmp11;
		_tmp10 = NULL;
		array_type = (_tmp10 = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (ma))), (_tmp10 == NULL ? NULL : g_object_ref (_tmp10)));
		_tmp12 = NULL;
		_tmp11 = NULL;
		gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ((double) (0)), FALSE)), VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_identifier_new ((_tmp11 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))))));
		(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
		_tmp11 = (g_free (_tmp11), NULL);
		(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
	} else {
		if (VALA_IS_ARRAY_MOVE_METHOD (m)) {
			vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->requires_array_move = TRUE;
		}
	}
	instance = NULL;
	if (m != NULL && vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		ValaCCodeExpression* _tmp14;
		ValaCCodeExpression* _tmp13;
		ValaStruct* _tmp16;
		ValaSymbol* _tmp15;
		ValaStruct* st;
		_tmp14 = NULL;
		_tmp13 = NULL;
		instance = (_tmp14 = (_tmp13 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))), (_tmp13 == NULL ? NULL : g_object_ref (_tmp13))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), _tmp14);
		_tmp16 = NULL;
		_tmp15 = NULL;
		st = (_tmp16 = (_tmp15 = vala_symbol_get_parent_symbol (VALA_SYMBOL (m)), (VALA_IS_STRUCT (_tmp15) ? ((ValaStruct*) (_tmp15)) : NULL)), (_tmp16 == NULL ? NULL : g_object_ref (_tmp16)));
		if (st != NULL && !vala_struct_is_simple_type (st)) {
			ValaCCodeUnaryExpression* _tmp18;
			ValaCCodeExpression* _tmp17;
			ValaCCodeUnaryExpression* unary;
			/* we need to pass struct instance by reference*/
			_tmp18 = NULL;
			_tmp17 = NULL;
			unary = (_tmp18 = (_tmp17 = instance, (VALA_IS_CCODE_UNARY_EXPRESSION (_tmp17) ? ((ValaCCodeUnaryExpression*) (_tmp17)) : NULL)), (_tmp18 == NULL ? NULL : g_object_ref (_tmp18)));
			if (unary != NULL && vala_ccode_unary_expression_get_operator (unary) == VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION) {
				ValaCCodeExpression* _tmp20;
				ValaCCodeExpression* _tmp19;
				/* *expr => expr*/
				_tmp20 = NULL;
				_tmp19 = NULL;
				instance = (_tmp20 = (_tmp19 = vala_ccode_unary_expression_get_inner (unary), (_tmp19 == NULL ? NULL : g_object_ref (_tmp19))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), _tmp20);
			} else {
				if (VALA_IS_CCODE_IDENTIFIER (instance) || VALA_IS_CCODE_MEMBER_ACCESS (instance)) {
					ValaCCodeExpression* _tmp21;
					_tmp21 = NULL;
					instance = (_tmp21 = VALA_CCODE_EXPRESSION (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, instance)), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), _tmp21);
				} else {
					ValaCCodeCommaExpression* ccomma;
					ValaLocalVariable* temp_var;
					ValaCCodeAssignment* _tmp23;
					ValaCCodeIdentifier* _tmp22;
					ValaCCodeUnaryExpression* _tmp25;
					ValaCCodeIdentifier* _tmp24;
					ValaCCodeExpression* _tmp27;
					ValaCCodeExpression* _tmp26;
					/* if instance is e.g. a function call, we can't take the address of the expression
					 (tmp = expr, &tmp)*/
					ccomma = vala_ccode_comma_expression_new ();
					temp_var = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_target_type (vala_member_access_get_inner (ma)), TRUE, NULL);
					gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_var);
					_tmp23 = NULL;
					_tmp22 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var))))), instance, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
					(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
					(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
					_tmp25 = NULL;
					_tmp24 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var)))))))));
					(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
					(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
					_tmp27 = NULL;
					_tmp26 = NULL;
					instance = (_tmp27 = (_tmp26 = VALA_CCODE_EXPRESSION (ccomma), (_tmp26 == NULL ? NULL : g_object_ref (_tmp26))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), _tmp27);
					(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
					(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
				}
			}
			(unary == NULL ? NULL : (unary = (g_object_unref (unary), NULL)));
		}
		gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cinstance_parameter_position (m), FALSE)), instance);
		(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
	} else {
		if (m != NULL && vala_method_get_binding (m) == MEMBER_BINDING_CLASS) {
			ValaClass* _tmp28;
			ValaClass* cl;
			ValaCCodeIdentifier* _tmp31;
			char* _tmp30;
			char* _tmp29;
			ValaCCodeFunctionCall* _tmp32;
			ValaCCodeFunctionCall* cast;
			ValaCCodeIdentifier* _tmp33;
			_tmp28 = NULL;
			cl = (_tmp28 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp28 == NULL ? NULL : g_object_ref (_tmp28)));
			_tmp31 = NULL;
			_tmp30 = NULL;
			_tmp29 = NULL;
			_tmp32 = NULL;
			cast = (_tmp32 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_identifier_new ((_tmp30 = g_strconcat ((_tmp29 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (cl), NULL)), "_CLASS", NULL)))))), (_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL))), (_tmp30 = (g_free (_tmp30), NULL)), (_tmp29 = (g_free (_tmp29), NULL)), _tmp32);
			_tmp33 = NULL;
			vala_ccode_function_call_add_argument (cast, VALA_CCODE_EXPRESSION ((_tmp33 = vala_ccode_identifier_new ("klass"))));
			(_tmp33 == NULL ? NULL : (_tmp33 = (g_object_unref (_tmp33), NULL)));
			gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cinstance_parameter_position (m), FALSE)), VALA_CCODE_EXPRESSION (cast));
			(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
			(cast == NULL ? NULL : (cast = (g_object_unref (cast), NULL)));
		}
	}
	if (VALA_IS_ARRAY_MOVE_METHOD (m)) {
		ValaArrayType* _tmp34;
		ValaArrayType* array_type;
		ValaCCodeIdentifier* _tmp35;
		ValaCCodeFunctionCall* _tmp36;
		ValaCCodeFunctionCall* csizeof;
		ValaCCodeIdentifier* _tmp38;
		char* _tmp37;
		_tmp34 = NULL;
		array_type = (_tmp34 = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (ma))), (_tmp34 == NULL ? NULL : g_object_ref (_tmp34)));
		_tmp35 = NULL;
		_tmp36 = NULL;
		csizeof = (_tmp36 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp35 = vala_ccode_identifier_new ("sizeof")))), (_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL))), _tmp36);
		_tmp38 = NULL;
		_tmp37 = NULL;
		vala_ccode_function_call_add_argument (csizeof, VALA_CCODE_EXPRESSION ((_tmp38 = vala_ccode_identifier_new ((_tmp37 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))))));
		(_tmp38 == NULL ? NULL : (_tmp38 = (g_object_unref (_tmp38), NULL)));
		_tmp37 = (g_free (_tmp37), NULL);
		gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), 0.1, FALSE)), VALA_CCODE_EXPRESSION (csizeof));
		(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
		(csizeof == NULL ? NULL : (csizeof = (g_object_unref (csizeof), NULL)));
	} else {
		if (VALA_IS_DYNAMIC_METHOD (m)) {
			gint param_nr;
			ValaCCodeDynamicMethodBinding* _tmp47;
			vala_method_clear_parameters (m);
			param_nr = 1;
			{
				GeeList* arg_collection;
				int arg_it;
				arg_collection = vala_invocation_expression_get_argument_list (expr);
				for (arg_it = 0; arg_it < gee_collection_get_size (GEE_COLLECTION (arg_collection)); arg_it = arg_it + 1) {
					ValaExpression* arg;
					arg = ((ValaExpression*) (gee_list_get (GEE_LIST (arg_collection), arg_it)));
					{
						ValaUnaryExpression* _tmp40;
						ValaExpression* _tmp39;
						ValaUnaryExpression* unary;
						_tmp40 = NULL;
						_tmp39 = NULL;
						unary = (_tmp40 = (_tmp39 = arg, (VALA_IS_UNARY_EXPRESSION (_tmp39) ? ((ValaUnaryExpression*) (_tmp39)) : NULL)), (_tmp40 == NULL ? NULL : g_object_ref (_tmp40)));
						if (unary != NULL && vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_OUT) {
							char* _tmp41;
							ValaFormalParameter* _tmp42;
							ValaFormalParameter* param;
							/* out argument*/
							_tmp41 = NULL;
							_tmp42 = NULL;
							param = (_tmp42 = vala_formal_parameter_new ((_tmp41 = g_strdup_printf ("param%d", param_nr)), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), NULL), (_tmp41 = (g_free (_tmp41), NULL)), _tmp42);
							vala_formal_parameter_set_direction (param, VALA_PARAMETER_DIRECTION_OUT);
							vala_method_add_parameter (m, param);
							(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
						} else {
							if (unary != NULL && vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_REF) {
								char* _tmp43;
								ValaFormalParameter* _tmp44;
								ValaFormalParameter* param;
								/* ref argument*/
								_tmp43 = NULL;
								_tmp44 = NULL;
								param = (_tmp44 = vala_formal_parameter_new ((_tmp43 = g_strdup_printf ("param%d", param_nr)), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), NULL), (_tmp43 = (g_free (_tmp43), NULL)), _tmp44);
								vala_formal_parameter_set_direction (param, VALA_PARAMETER_DIRECTION_REF);
								vala_method_add_parameter (m, param);
								(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
							} else {
								ValaFormalParameter* _tmp46;
								char* _tmp45;
								/* in argument*/
								_tmp46 = NULL;
								_tmp45 = NULL;
								vala_method_add_parameter (m, (_tmp46 = vala_formal_parameter_new ((_tmp45 = g_strdup_printf ("param%d", param_nr)), vala_expression_get_value_type (arg), NULL)));
								(_tmp46 == NULL ? NULL : (_tmp46 = (g_object_unref (_tmp46), NULL)));
								_tmp45 = (g_free (_tmp45), NULL);
							}
						}
						param_nr++;
						(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
						(unary == NULL ? NULL : (unary = (g_object_unref (unary), NULL)));
					}
				}
				(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
			}
			{
				GeeList* param_collection;
				int param_it;
				param_collection = vala_method_get_parameters (m);
				for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
					ValaFormalParameter* param;
					param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
					{
						vala_code_node_accept (VALA_CODE_NODE (param), VALA_CODE_VISITOR (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))));
						(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
					}
				}
				(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
			}
			_tmp47 = NULL;
			vala_ccode_dynamic_method_binding_generate_wrapper ((_tmp47 = vala_ccode_generator_dynamic_method_binding (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_DYNAMIC_METHOD (m))));
			(_tmp47 == NULL ? NULL : (_tmp47 = (g_object_unref (_tmp47), NULL)));
		}
	}
	ellipsis = FALSE;
	i = 1;
	arg_pos = 0;
	params_it = gee_iterable_iterator (GEE_ITERABLE (params));
	{
		GeeList* arg_collection;
		int arg_it;
		arg_collection = vala_invocation_expression_get_argument_list (expr);
		for (arg_it = 0; arg_it < gee_collection_get_size (GEE_COLLECTION (arg_collection)); arg_it = arg_it + 1) {
			ValaExpression* arg;
			arg = ((ValaExpression*) (gee_list_get (GEE_LIST (arg_collection), arg_it)));
			{
				ValaCCodeExpression* _tmp48;
				ValaCCodeExpression* cexpr;
				GeeList* extra_args;
				_tmp48 = NULL;
				cexpr = (_tmp48 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (arg))), (_tmp48 == NULL ? NULL : g_object_ref (_tmp48)));
				extra_args = GEE_LIST (gee_array_list_new (VALA_TYPE_CCODE_EXPRESSION, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal));
				if (gee_iterator_next (params_it)) {
					ValaFormalParameter* param;
					param = ((ValaFormalParameter*) (gee_iterator_get (params_it)));
					ellipsis = vala_formal_parameter_get_ellipsis (param);
					if (!ellipsis) {
						gboolean multiple_cargs;
						/* if the vala argument expands to multiple C arguments,
						 we have to make sure that the C arguments don't depend
						 on each other as there is no guaranteed argument
						 evaluation order
						 http://bugzilla.gnome.org/show_bug.cgi?id=519597*/
						multiple_cargs = FALSE;
						if (!vala_formal_parameter_get_no_array_length (param) && VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))) {
							ValaArrayType* _tmp49;
							ValaArrayType* array_type;
							_tmp49 = NULL;
							array_type = (_tmp49 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp49 == NULL ? NULL : g_object_ref (_tmp49)));
							{
								gint dim;
								dim = 1;
								for (; dim <= vala_array_type_get_rank (array_type); dim++) {
									ValaCCodeExpression* _tmp50;
									_tmp50 = NULL;
									gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_carray_length_parameter_position (param) + 0.01 * dim, FALSE)), (_tmp50 = vala_ccode_generator_get_array_length_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), arg, dim)));
									(_tmp50 == NULL ? NULL : (_tmp50 = (g_object_unref (_tmp50), NULL)));
								}
							}
							multiple_cargs = TRUE;
							(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
						} else {
							if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param))) {
								ValaDelegateType* _tmp51;
								ValaDelegateType* deleg_type;
								ValaDelegate* _tmp52;
								ValaDelegate* d;
								_tmp51 = NULL;
								deleg_type = (_tmp51 = VALA_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp51 == NULL ? NULL : g_object_ref (_tmp51)));
								_tmp52 = NULL;
								d = (_tmp52 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp52 == NULL ? NULL : g_object_ref (_tmp52)));
								if (vala_delegate_get_has_target (d)) {
									ValaCCodeExpression* delegate_target;
									delegate_target = vala_ccode_generator_get_delegate_target_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), arg);
									if (vala_data_type_get_value_owned (VALA_DATA_TYPE (deleg_type))) {
										ValaCCodeExpression* delegate_target_destroy_notify;
										ValaMethod* _tmp54;
										ValaSymbol* _tmp53;
										ValaMethod* delegate_method;
										ValaMemberAccess* _tmp56;
										ValaExpression* _tmp55;
										ValaMemberAccess* ma;
										delegate_target_destroy_notify = NULL;
										_tmp54 = NULL;
										_tmp53 = NULL;
										delegate_method = (_tmp54 = (_tmp53 = vala_expression_get_symbol_reference (arg), (VALA_IS_METHOD (_tmp53) ? ((ValaMethod*) (_tmp53)) : NULL)), (_tmp54 == NULL ? NULL : g_object_ref (_tmp54)));
										_tmp56 = NULL;
										_tmp55 = NULL;
										ma = (_tmp56 = (_tmp55 = arg, (VALA_IS_MEMBER_ACCESS (_tmp55) ? ((ValaMemberAccess*) (_tmp55)) : NULL)), (_tmp56 == NULL ? NULL : g_object_ref (_tmp56)));
										if (delegate_method != NULL && vala_method_get_binding (delegate_method) == MEMBER_BINDING_INSTANCE && vala_member_access_get_inner (ma) != NULL && vala_data_type_get_data_type (vala_expression_get_value_type (vala_member_access_get_inner (ma))) != NULL && vala_typesymbol_is_reference_counting (vala_data_type_get_data_type (vala_expression_get_value_type (vala_member_access_get_inner (ma))))) {
											ValaCCodeExpression* _tmp57;
											ValaCCodeFunctionCall* _tmp58;
											ValaCCodeFunctionCall* ref_call;
											ValaCCodeExpression* _tmp60;
											ValaCCodeExpression* _tmp59;
											ValaCCodeExpression* _tmp61;
											_tmp57 = NULL;
											_tmp58 = NULL;
											ref_call = (_tmp58 = vala_ccode_function_call_new ((_tmp57 = vala_ccode_generator_get_dup_func_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_value_type (vala_member_access_get_inner (ma)), vala_code_node_get_source_reference (VALA_CODE_NODE (arg))))), (_tmp57 == NULL ? NULL : (_tmp57 = (g_object_unref (_tmp57), NULL))), _tmp58);
											vala_ccode_function_call_add_argument (ref_call, delegate_target);
											_tmp60 = NULL;
											_tmp59 = NULL;
											delegate_target = (_tmp60 = (_tmp59 = VALA_CCODE_EXPRESSION (ref_call), (_tmp59 == NULL ? NULL : g_object_ref (_tmp59))), (delegate_target == NULL ? NULL : (delegate_target = (g_object_unref (delegate_target), NULL))), _tmp60);
											_tmp61 = NULL;
											delegate_target_destroy_notify = (_tmp61 = vala_ccode_generator_get_destroy_func_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_value_type (vala_member_access_get_inner (ma))), (delegate_target_destroy_notify == NULL ? NULL : (delegate_target_destroy_notify = (g_object_unref (delegate_target_destroy_notify), NULL))), _tmp61);
											(ref_call == NULL ? NULL : (ref_call = (g_object_unref (ref_call), NULL)));
										} else {
											ValaCCodeExpression* _tmp62;
											_tmp62 = NULL;
											delegate_target_destroy_notify = (_tmp62 = VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")), (delegate_target_destroy_notify == NULL ? NULL : (delegate_target_destroy_notify = (g_object_unref (delegate_target_destroy_notify), NULL))), _tmp62);
										}
										gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param) + 0.01, FALSE)), delegate_target_destroy_notify);
										(delegate_target_destroy_notify == NULL ? NULL : (delegate_target_destroy_notify = (g_object_unref (delegate_target_destroy_notify), NULL)));
										(delegate_method == NULL ? NULL : (delegate_method = (g_object_unref (delegate_method), NULL)));
										(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
									}
									gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), delegate_target);
									multiple_cargs = TRUE;
									(delegate_target == NULL ? NULL : (delegate_target = (g_object_unref (delegate_target), NULL)));
								}
								(deleg_type == NULL ? NULL : (deleg_type = (g_object_unref (deleg_type), NULL)));
								(d == NULL ? NULL : (d = (g_object_unref (d), NULL)));
							} else {
								if (VALA_IS_METHOD_TYPE (vala_formal_parameter_get_parameter_type (param))) {
									ValaCCodeExpression* _tmp63;
									_tmp63 = NULL;
									gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), (_tmp63 = vala_ccode_generator_get_delegate_target_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), arg)));
									(_tmp63 == NULL ? NULL : (_tmp63 = (g_object_unref (_tmp63), NULL)));
									multiple_cargs = TRUE;
								}
							}
						}
						/* pass non-simple struct instances always by reference*/
						if (!(VALA_IS_NULL_TYPE (vala_expression_get_value_type (arg))) && VALA_IS_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param))) && !vala_struct_is_simple_type ((VALA_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param)))))) {
							/* we already use a reference for arguments of ref, out, and nullable parameters*/
							if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN && !vala_data_type_get_nullable (vala_formal_parameter_get_parameter_type (param))) {
								ValaCCodeUnaryExpression* _tmp65;
								ValaCCodeExpression* _tmp64;
								ValaCCodeUnaryExpression* unary;
								_tmp65 = NULL;
								_tmp64 = NULL;
								unary = (_tmp65 = (_tmp64 = cexpr, (VALA_IS_CCODE_UNARY_EXPRESSION (_tmp64) ? ((ValaCCodeUnaryExpression*) (_tmp64)) : NULL)), (_tmp65 == NULL ? NULL : g_object_ref (_tmp65)));
								if (unary != NULL && vala_ccode_unary_expression_get_operator (unary) == VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION) {
									ValaCCodeExpression* _tmp67;
									ValaCCodeExpression* _tmp66;
									/* *expr => expr*/
									_tmp67 = NULL;
									_tmp66 = NULL;
									cexpr = (_tmp67 = (_tmp66 = vala_ccode_unary_expression_get_inner (unary), (_tmp66 == NULL ? NULL : g_object_ref (_tmp66))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp67);
								} else {
									if (VALA_IS_CCODE_IDENTIFIER (cexpr) || VALA_IS_CCODE_MEMBER_ACCESS (cexpr)) {
										ValaCCodeExpression* _tmp68;
										_tmp68 = NULL;
										cexpr = (_tmp68 = VALA_CCODE_EXPRESSION (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, cexpr)), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp68);
									} else {
										ValaCCodeCommaExpression* ccomma;
										ValaLocalVariable* temp_var;
										ValaCCodeAssignment* _tmp70;
										ValaCCodeIdentifier* _tmp69;
										ValaCCodeUnaryExpression* _tmp72;
										ValaCCodeIdentifier* _tmp71;
										ValaCCodeExpression* _tmp74;
										ValaCCodeExpression* _tmp73;
										/* if cexpr is e.g. a function call, we can't take the address of the expression
										 (tmp = expr, &tmp)*/
										ccomma = vala_ccode_comma_expression_new ();
										temp_var = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_value_type (arg), TRUE, NULL);
										gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_var);
										_tmp70 = NULL;
										_tmp69 = NULL;
										vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp70 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp69 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var))))), cexpr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
										(_tmp70 == NULL ? NULL : (_tmp70 = (g_object_unref (_tmp70), NULL)));
										(_tmp69 == NULL ? NULL : (_tmp69 = (g_object_unref (_tmp69), NULL)));
										_tmp72 = NULL;
										_tmp71 = NULL;
										vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp72 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp71 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var)))))))));
										(_tmp72 == NULL ? NULL : (_tmp72 = (g_object_unref (_tmp72), NULL)));
										(_tmp71 == NULL ? NULL : (_tmp71 = (g_object_unref (_tmp71), NULL)));
										_tmp74 = NULL;
										_tmp73 = NULL;
										cexpr = (_tmp74 = (_tmp73 = VALA_CCODE_EXPRESSION (ccomma), (_tmp73 == NULL ? NULL : g_object_ref (_tmp73))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp74);
										(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
										(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
									}
								}
								(unary == NULL ? NULL : (unary = (g_object_unref (unary), NULL)));
							}
						}
						if (multiple_cargs && VALA_IS_INVOCATION_EXPRESSION (arg)) {
							ValaCCodeCommaExpression* ccomma;
							ValaLocalVariable* temp_decl;
							ValaCCodeAssignment* _tmp76;
							ValaCCodeIdentifier* _tmp75;
							ValaCCodeExpression* _tmp77;
							ValaCCodeExpression* _tmp79;
							ValaCCodeExpression* _tmp78;
							/* if vala argument is invocation expression
							 the auxiliary C argument(s) will depend on the main C argument
							 (tmp = arg1, call (tmp, arg2, arg3,...))*/
							ccomma = vala_ccode_comma_expression_new ();
							temp_decl = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_value_type (arg), TRUE, NULL);
							gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_decl);
							_tmp76 = NULL;
							_tmp75 = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp76 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp75 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl))))), cexpr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
							(_tmp76 == NULL ? NULL : (_tmp76 = (g_object_unref (_tmp76), NULL)));
							(_tmp75 == NULL ? NULL : (_tmp75 = (g_object_unref (_tmp75), NULL)));
							_tmp77 = NULL;
							cexpr = (_tmp77 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl)))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp77);
							vala_ccode_comma_expression_append_expression (ccomma, ccall_expr);
							_tmp79 = NULL;
							_tmp78 = NULL;
							ccall_expr = (_tmp79 = (_tmp78 = VALA_CCODE_EXPRESSION (ccomma), (_tmp78 == NULL ? NULL : g_object_ref (_tmp78))), (ccall_expr == NULL ? NULL : (ccall_expr = (g_object_unref (ccall_expr), NULL))), _tmp79);
							(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
							(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
						}
						/* unref old value for non-null non-weak ref/out arguments
						 disabled for arrays for now as that requires special handling
						 (ret_tmp = call (&tmp), var1 = (assign_tmp = dup (tmp), free (var1), assign_tmp), ret_tmp)*/
						if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN && vala_ccode_generator_requires_destroy (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_value_type (arg)) && (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT || !vala_data_type_get_value_owned (vala_formal_parameter_get_parameter_type (param))) && !(VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)))) {
							ValaUnaryExpression* _tmp80;
							ValaUnaryExpression* unary;
							ValaCCodeCommaExpression* ccomma;
							ValaLocalVariable* temp_var;
							ValaCCodeExpression* _tmp82;
							ValaCCodeIdentifier* _tmp81;
							ValaLocalVariable* ret_temp_var;
							ValaCCodeCommaExpression* cassign_comma;
							ValaLocalVariable* assign_temp_var;
							ValaCCodeAssignment* _tmp93;
							ValaCCodeExpression* _tmp92;
							ValaCCodeIdentifier* _tmp91;
							ValaCCodeIdentifier* _tmp90;
							ValaCCodeExpression* _tmp94;
							ValaCCodeIdentifier* _tmp95;
							ValaCCodeAssignment* _tmp96;
							ValaCCodeExpression* _tmp99;
							ValaCCodeExpression* _tmp98;
							_tmp80 = NULL;
							unary = (_tmp80 = VALA_UNARY_EXPRESSION (arg), (_tmp80 == NULL ? NULL : g_object_ref (_tmp80)));
							ccomma = vala_ccode_comma_expression_new ();
							temp_var = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_parameter_type (param), vala_data_type_get_value_owned (vala_formal_parameter_get_parameter_type (param)), NULL);
							gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_var);
							_tmp82 = NULL;
							_tmp81 = NULL;
							cexpr = (_tmp82 = VALA_CCODE_EXPRESSION (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp81 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var))))))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp82);
							(_tmp81 == NULL ? NULL : (_tmp81 = (g_object_unref (_tmp81), NULL)));
							if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_REF) {
								ValaCCodeCommaExpression* crefcomma;
								ValaCCodeAssignment* _tmp84;
								ValaCCodeIdentifier* _tmp83;
								ValaCCodeExpression* _tmp86;
								ValaCCodeExpression* _tmp85;
								crefcomma = vala_ccode_comma_expression_new ();
								_tmp84 = NULL;
								_tmp83 = NULL;
								vala_ccode_comma_expression_append_expression (crefcomma, VALA_CCODE_EXPRESSION ((_tmp84 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp83 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_unary_expression_get_inner (unary)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
								(_tmp84 == NULL ? NULL : (_tmp84 = (g_object_unref (_tmp84), NULL)));
								(_tmp83 == NULL ? NULL : (_tmp83 = (g_object_unref (_tmp83), NULL)));
								vala_ccode_comma_expression_append_expression (crefcomma, cexpr);
								_tmp86 = NULL;
								_tmp85 = NULL;
								cexpr = (_tmp86 = (_tmp85 = VALA_CCODE_EXPRESSION (crefcomma), (_tmp85 == NULL ? NULL : g_object_ref (_tmp85))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp86);
								(crefcomma == NULL ? NULL : (crefcomma = (g_object_unref (crefcomma), NULL)));
							}
							/* call function*/
							ret_temp_var = NULL;
							if (VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
								vala_ccode_comma_expression_append_expression (ccomma, ccall_expr);
							} else {
								ValaLocalVariable* _tmp87;
								ValaCCodeAssignment* _tmp89;
								ValaCCodeIdentifier* _tmp88;
								_tmp87 = NULL;
								ret_temp_var = (_tmp87 = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_return_type (m), TRUE, NULL), (ret_temp_var == NULL ? NULL : (ret_temp_var = (g_object_unref (ret_temp_var), NULL))), _tmp87);
								gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, ret_temp_var);
								_tmp89 = NULL;
								_tmp88 = NULL;
								vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp89 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp88 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (ret_temp_var))))), ccall_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
								(_tmp89 == NULL ? NULL : (_tmp89 = (g_object_unref (_tmp89), NULL)));
								(_tmp88 == NULL ? NULL : (_tmp88 = (g_object_unref (_tmp88), NULL)));
							}
							cassign_comma = vala_ccode_comma_expression_new ();
							assign_temp_var = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), vala_data_type_get_value_owned (vala_expression_get_value_type (vala_unary_expression_get_inner (unary))), NULL);
							gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, assign_temp_var);
							_tmp93 = NULL;
							_tmp92 = NULL;
							_tmp91 = NULL;
							_tmp90 = NULL;
							vala_ccode_comma_expression_append_expression (cassign_comma, VALA_CCODE_EXPRESSION ((_tmp93 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp90 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (assign_temp_var))))), (_tmp92 = vala_ccode_generator_transform_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_CCODE_EXPRESSION ((_tmp91 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var))))), vala_formal_parameter_get_parameter_type (param), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), arg)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
							(_tmp93 == NULL ? NULL : (_tmp93 = (g_object_unref (_tmp93), NULL)));
							(_tmp92 == NULL ? NULL : (_tmp92 = (g_object_unref (_tmp92), NULL)));
							(_tmp91 == NULL ? NULL : (_tmp91 = (g_object_unref (_tmp91), NULL)));
							(_tmp90 == NULL ? NULL : (_tmp90 = (g_object_unref (_tmp90), NULL)));
							/* unref old value*/
							_tmp94 = NULL;
							vala_ccode_comma_expression_append_expression (cassign_comma, (_tmp94 = vala_ccode_generator_get_unref_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_unary_expression_get_inner (unary)))), vala_expression_get_value_type (arg), arg)));
							(_tmp94 == NULL ? NULL : (_tmp94 = (g_object_unref (_tmp94), NULL)));
							_tmp95 = NULL;
							vala_ccode_comma_expression_append_expression (cassign_comma, VALA_CCODE_EXPRESSION ((_tmp95 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (assign_temp_var))))));
							(_tmp95 == NULL ? NULL : (_tmp95 = (g_object_unref (_tmp95), NULL)));
							/* assign new value*/
							_tmp96 = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp96 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_unary_expression_get_inner (unary)))), VALA_CCODE_EXPRESSION (cassign_comma), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
							(_tmp96 == NULL ? NULL : (_tmp96 = (g_object_unref (_tmp96), NULL)));
							/* return value*/
							if (!(VALA_IS_VOID_TYPE (vala_method_get_return_type (m)))) {
								ValaCCodeIdentifier* _tmp97;
								_tmp97 = NULL;
								vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp97 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (ret_temp_var))))));
								(_tmp97 == NULL ? NULL : (_tmp97 = (g_object_unref (_tmp97), NULL)));
							}
							_tmp99 = NULL;
							_tmp98 = NULL;
							ccall_expr = (_tmp99 = (_tmp98 = VALA_CCODE_EXPRESSION (ccomma), (_tmp98 == NULL ? NULL : g_object_ref (_tmp98))), (ccall_expr == NULL ? NULL : (ccall_expr = (g_object_unref (ccall_expr), NULL))), _tmp99);
							(unary == NULL ? NULL : (unary = (g_object_unref (unary), NULL)));
							(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
							(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
							(ret_temp_var == NULL ? NULL : (ret_temp_var = (g_object_unref (ret_temp_var), NULL)));
							(cassign_comma == NULL ? NULL : (cassign_comma = (g_object_unref (cassign_comma), NULL)));
							(assign_temp_var == NULL ? NULL : (assign_temp_var = (g_object_unref (assign_temp_var), NULL)));
						}
					}
					arg_pos = vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cparameter_position (param), ellipsis);
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
				} else {
					/* default argument position*/
					arg_pos = vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ((double) (i)), ellipsis);
				}
				gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (arg_pos), cexpr);
				i++;
				(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
				(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
				(extra_args == NULL ? NULL : (extra_args = (g_object_unref (extra_args), NULL)));
			}
		}
		(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
	}
	while (gee_iterator_next (params_it)) {
		ValaFormalParameter* param;
		param = ((ValaFormalParameter*) (gee_iterator_get (params_it)));
		if (vala_formal_parameter_get_ellipsis (param)) {
			ellipsis = TRUE;
			(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			break;
		}
		if (vala_formal_parameter_get_default_expression (param) == NULL) {
			char* _tmp100;
			_tmp100 = NULL;
			vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), (_tmp100 = g_strdup_printf ("no default expression for argument %d", i)));
			_tmp100 = (g_free (_tmp100), NULL);
			(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
			(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
			(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
			(itype == NULL ? NULL : (itype = (g_object_unref (itype), NULL)));
			(ccall_expr == NULL ? NULL : (ccall_expr = (g_object_unref (ccall_expr), NULL)));
			(carg_map == NULL ? NULL : (carg_map = (g_object_unref (carg_map), NULL)));
			(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
			(params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL)));
			return;
		}
		/* evaluate default expression here as the code
		 * generator might not have visited the formal
		 * parameter yet */
		vala_code_node_accept (VALA_CODE_NODE (vala_formal_parameter_get_default_expression (param)), VALA_CODE_VISITOR (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))));
		if (!vala_formal_parameter_get_no_array_length (param) && vala_formal_parameter_get_parameter_type (param) != NULL && VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))) {
			ValaArrayType* _tmp101;
			ValaArrayType* array_type;
			_tmp101 = NULL;
			array_type = (_tmp101 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp101 == NULL ? NULL : g_object_ref (_tmp101)));
			{
				gint dim;
				dim = 1;
				for (; dim <= vala_array_type_get_rank (array_type); dim++) {
					ValaCCodeExpression* _tmp102;
					_tmp102 = NULL;
					gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_carray_length_parameter_position (param) + 0.01 * dim, FALSE)), (_tmp102 = vala_ccode_generator_get_array_length_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_default_expression (param), dim)));
					(_tmp102 == NULL ? NULL : (_tmp102 = (g_object_unref (_tmp102), NULL)));
				}
			}
			(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
		}
		gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cparameter_position (param), FALSE)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_formal_parameter_get_default_expression (param)))));
		i++;
		(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
	}
	/* add length argument for methods returning arrays */
	if (m != NULL && VALA_IS_ARRAY_TYPE (vala_method_get_return_type (m))) {
		ValaArrayType* _tmp103;
		ValaArrayType* array_type;
		_tmp103 = NULL;
		array_type = (_tmp103 = VALA_ARRAY_TYPE (vala_method_get_return_type (m)), (_tmp103 == NULL ? NULL : g_object_ref (_tmp103)));
		{
			gint dim;
			dim = 1;
			for (; dim <= vala_array_type_get_rank (array_type); dim++) {
				if (!vala_method_get_no_array_length (m)) {
					ValaLocalVariable* temp_var;
					ValaCCodeIdentifier* temp_ref;
					ValaCCodeUnaryExpression* _tmp104;
					temp_var = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->int_type, TRUE, NULL);
					temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var)));
					gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_var);
					_tmp104 = NULL;
					gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_carray_length_parameter_position (m) + 0.01 * dim, FALSE)), VALA_CCODE_EXPRESSION ((_tmp104 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (temp_ref)))));
					(_tmp104 == NULL ? NULL : (_tmp104 = (g_object_unref (_tmp104), NULL)));
					vala_invocation_expression_append_array_size (expr, VALA_CCODE_EXPRESSION (temp_ref));
					(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
					(temp_ref == NULL ? NULL : (temp_ref = (g_object_unref (temp_ref), NULL)));
				} else {
					ValaCCodeConstant* _tmp105;
					_tmp105 = NULL;
					vala_invocation_expression_append_array_size (expr, VALA_CCODE_EXPRESSION ((_tmp105 = vala_ccode_constant_new ("-1"))));
					(_tmp105 == NULL ? NULL : (_tmp105 = (g_object_unref (_tmp105), NULL)));
				}
			}
		}
		(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
	} else {
		if (m != NULL && VALA_IS_DELEGATE_TYPE (vala_method_get_return_type (m))) {
			ValaDelegateType* _tmp106;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp107;
			ValaDelegate* d;
			_tmp106 = NULL;
			deleg_type = (_tmp106 = VALA_DELEGATE_TYPE (vala_method_get_return_type (m)), (_tmp106 == NULL ? NULL : g_object_ref (_tmp106)));
			_tmp107 = NULL;
			d = (_tmp107 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp107 == NULL ? NULL : g_object_ref (_tmp107)));
			if (vala_delegate_get_has_target (d)) {
				ValaPointerType* _tmp109;
				ValaVoidType* _tmp108;
				ValaLocalVariable* _tmp110;
				ValaLocalVariable* temp_var;
				ValaCCodeIdentifier* temp_ref;
				ValaCCodeUnaryExpression* _tmp111;
				_tmp109 = NULL;
				_tmp108 = NULL;
				_tmp110 = NULL;
				temp_var = (_tmp110 = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_DATA_TYPE ((_tmp109 = vala_pointer_type_new (VALA_DATA_TYPE ((_tmp108 = vala_void_type_new ())), NULL))), TRUE, NULL), (_tmp109 == NULL ? NULL : (_tmp109 = (g_object_unref (_tmp109), NULL))), (_tmp108 == NULL ? NULL : (_tmp108 = (g_object_unref (_tmp108), NULL))), _tmp110);
				temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var)));
				gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_var);
				_tmp111 = NULL;
				gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cdelegate_target_parameter_position (m), FALSE)), VALA_CCODE_EXPRESSION ((_tmp111 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (temp_ref)))));
				(_tmp111 == NULL ? NULL : (_tmp111 = (g_object_unref (_tmp111), NULL)));
				vala_invocation_expression_set_delegate_target (expr, VALA_CCODE_EXPRESSION (temp_ref));
				(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
				(temp_ref == NULL ? NULL : (temp_ref = (g_object_unref (temp_ref), NULL)));
			}
			(deleg_type == NULL ? NULL : (deleg_type = (g_object_unref (deleg_type), NULL)));
			(d == NULL ? NULL : (d = (g_object_unref (d), NULL)));
		}
	}
	if (vala_code_node_get_tree_can_fail (VALA_CODE_NODE (expr))) {
		ValaCCodeUnaryExpression* _tmp113;
		ValaCCodeIdentifier* _tmp112;
		/* method can fail*/
		vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method_inner_error = TRUE;
		/* add &inner_error before the ellipsis arguments*/
		_tmp113 = NULL;
		_tmp112 = NULL;
		gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ((double) (-2)), FALSE)), VALA_CCODE_EXPRESSION ((_tmp113 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp112 = vala_ccode_identifier_new ("inner_error")))))));
		(_tmp113 == NULL ? NULL : (_tmp113 = (g_object_unref (_tmp113), NULL)));
		(_tmp112 == NULL ? NULL : (_tmp112 = (g_object_unref (_tmp112), NULL)));
	}
	if (ellipsis) {
		/* ensure variable argument list ends with NULL
		 * except when using printf-style arguments */
		if ((m == NULL || !vala_method_get_printf_format (m))) {
			ValaCCodeConstant* _tmp114;
			_tmp114 = NULL;
			gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ((double) (-1)), TRUE)), VALA_CCODE_EXPRESSION ((_tmp114 = vala_ccode_constant_new (vala_method_get_sentinel (m)))));
			(_tmp114 == NULL ? NULL : (_tmp114 = (g_object_unref (_tmp114), NULL)));
		}
	} else {
		if (VALA_IS_DELEGATE_TYPE (itype)) {
			ValaDelegateType* _tmp115;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp116;
			ValaDelegate* d;
			_tmp115 = NULL;
			deleg_type = (_tmp115 = VALA_DELEGATE_TYPE (itype), (_tmp115 == NULL ? NULL : g_object_ref (_tmp115)));
			_tmp116 = NULL;
			d = (_tmp116 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp116 == NULL ? NULL : g_object_ref (_tmp116)));
			if (vala_delegate_get_has_target (d)) {
				ValaCCodeExpression* _tmp117;
				_tmp117 = NULL;
				gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_delegate_get_cinstance_parameter_position (d), FALSE)), (_tmp117 = vala_ccode_generator_get_delegate_target_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_invocation_expression_get_call (expr))));
				(_tmp117 == NULL ? NULL : (_tmp117 = (g_object_unref (_tmp117), NULL)));
			}
			(deleg_type == NULL ? NULL : (deleg_type = (g_object_unref (deleg_type), NULL)));
			(d == NULL ? NULL : (d = (g_object_unref (d), NULL)));
		}
	}
	/* pass address for the return value of non-void signals without emitter functions*/
	_tmp118 = NULL;
	if ((_tmp119 = VALA_IS_SIGNAL_TYPE (itype) && !(VALA_IS_VOID_TYPE ((_tmp118 = vala_data_type_get_return_type (itype)))), (_tmp118 == NULL ? NULL : (_tmp118 = (g_object_unref (_tmp118), NULL))), _tmp119)) {
		ValaSignal* _tmp120;
		ValaSignal* sig;
		_tmp120 = NULL;
		sig = (_tmp120 = vala_signal_type_get_signal_symbol ((VALA_SIGNAL_TYPE (itype))), (_tmp120 == NULL ? NULL : g_object_ref (_tmp120)));
		if (!vala_signal_get_has_emitter (sig)) {
			ValaDataType* _tmp121;
			ValaLocalVariable* _tmp122;
			ValaLocalVariable* temp_var;
			ValaCCodeIdentifier* temp_ref;
			ValaCCodeUnaryExpression* _tmp123;
			ValaCCodeCommaExpression* ccomma;
			ValaCCodeExpression* _tmp125;
			ValaCCodeExpression* _tmp124;
			_tmp121 = NULL;
			_tmp122 = NULL;
			temp_var = (_tmp122 = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), (_tmp121 = vala_data_type_get_return_type (itype)), TRUE, NULL), (_tmp121 == NULL ? NULL : (_tmp121 = (g_object_unref (_tmp121), NULL))), _tmp122);
			temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var)));
			gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_var);
			_tmp123 = NULL;
			gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ((double) (-1)), TRUE)), VALA_CCODE_EXPRESSION ((_tmp123 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (temp_ref)))));
			(_tmp123 == NULL ? NULL : (_tmp123 = (g_object_unref (_tmp123), NULL)));
			ccomma = vala_ccode_comma_expression_new ();
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall_expr));
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (temp_ref));
			_tmp125 = NULL;
			_tmp124 = NULL;
			ccall_expr = (_tmp125 = (_tmp124 = VALA_CCODE_EXPRESSION (ccomma), (_tmp124 == NULL ? NULL : g_object_ref (_tmp124))), (ccall_expr == NULL ? NULL : (ccall_expr = (g_object_unref (ccall_expr), NULL))), _tmp125);
			(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
			(temp_ref == NULL ? NULL : (temp_ref = (g_object_unref (temp_ref), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		}
		(sig == NULL ? NULL : (sig = (g_object_unref (sig), NULL)));
	}
	/* append C arguments in the right order*/
	last_pos = -1;
	min_pos = 0;
	while (TRUE) {
		ValaCCodeExpression* _tmp126;
		min_pos = -1;
		{
			GeeSet* pos_collection;
			GeeIterator* pos_it;
			pos_collection = gee_map_get_keys (GEE_MAP (carg_map));
			pos_it = gee_iterable_iterator (GEE_ITERABLE (pos_collection));
			while (gee_iterator_next (pos_it)) {
				gint pos;
				pos = GPOINTER_TO_INT (gee_iterator_get (pos_it));
				{
					if (pos > last_pos && (min_pos == -1 || pos < min_pos)) {
						min_pos = pos;
					}
				}
			}
			(pos_it == NULL ? NULL : (pos_it = (g_object_unref (pos_it), NULL)));
			(pos_collection == NULL ? NULL : (pos_collection = (g_object_unref (pos_collection), NULL)));
		}
		if (min_pos == -1) {
			break;
		}
		_tmp126 = NULL;
		vala_ccode_function_call_add_argument (ccall, (_tmp126 = ((ValaCCodeExpression*) (gee_map_get (GEE_MAP (carg_map), GINT_TO_POINTER (min_pos))))));
		(_tmp126 == NULL ? NULL : (_tmp126 = (g_object_unref (_tmp126), NULL)));
		last_pos = min_pos;
	}
	if (m != NULL && vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE && vala_method_get_returns_modified_pointer (m)) {
		ValaCCodeAssignment* _tmp127;
		_tmp127 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp127 = vala_ccode_assignment_new (instance, ccall_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(_tmp127 == NULL ? NULL : (_tmp127 = (g_object_unref (_tmp127), NULL)));
	} else {
		/* cast pointer to actual type if this is a generic method return value */
		if (m != NULL && vala_data_type_get_type_parameter (vala_method_get_return_type (m)) != NULL && vala_data_type_get_data_type (vala_expression_get_value_type (VALA_EXPRESSION (expr))) != NULL) {
			ValaCCodeExpression* _tmp128;
			_tmp128 = NULL;
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp128 = vala_ccode_generator_convert_from_generic_pointer (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ccall_expr, vala_expression_get_value_type (VALA_EXPRESSION (expr))))));
			(_tmp128 == NULL ? NULL : (_tmp128 = (g_object_unref (_tmp128), NULL)));
		} else {
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall_expr));
		}
	}
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		GeeList* _tmp129;
		GeeIterator* _tmp130;
		GeeIterator* arg_it;
		ValaCCodeExpression* _tmp132;
		ValaExpression* _tmp131;
		ValaCCodeExpression* _tmp133;
		ValaCCodeExpression* new_size;
		ValaLocalVariable* temp_decl;
		ValaCCodeIdentifier* temp_ref;
		ValaCCodeExpression* clen;
		ValaCCodeExpression* _tmp134;
		ValaCCodeExpression* celems;
		ValaArrayType* _tmp135;
		ValaArrayType* array_type;
		char* _tmp137;
		char* _tmp136;
		ValaCCodeIdentifier* _tmp138;
		ValaCCodeIdentifier* csizeof;
		ValaCCodeBinaryExpression* _tmp139;
		ValaCCodeParenthesizedExpression* _tmp140;
		ValaCCodeParenthesizedExpression* cdelta;
		ValaCCodeBinaryExpression* ccheck;
		ValaCCodeIdentifier* _tmp141;
		ValaCCodeFunctionCall* _tmp142;
		ValaCCodeFunctionCall* czero;
		ValaCCodeBinaryExpression* _tmp143;
		ValaCCodeConstant* _tmp144;
		ValaCCodeBinaryExpression* _tmp145;
		ValaCCodeCommaExpression* ccomma;
		ValaCCodeAssignment* _tmp146;
		ValaCCodeConditionalExpression* _tmp148;
		ValaCCodeConstant* _tmp147;
		ValaCCodeAssignment* _tmp150;
		ValaCCodeExpression* _tmp149;
		/* FIXME: size expression must not be evaluated twice at runtime (potential side effects)*/
		_tmp129 = NULL;
		_tmp130 = NULL;
		arg_it = (_tmp130 = gee_iterable_iterator (GEE_ITERABLE ((_tmp129 = vala_invocation_expression_get_argument_list (expr)))), (_tmp129 == NULL ? NULL : (_tmp129 = (g_object_unref (_tmp129), NULL))), _tmp130);
		gee_iterator_next (arg_it);
		_tmp132 = NULL;
		_tmp131 = NULL;
		_tmp133 = NULL;
		new_size = (_tmp133 = (_tmp132 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE ((_tmp131 = ((ValaExpression*) (gee_iterator_get (arg_it))))))), (_tmp132 == NULL ? NULL : g_object_ref (_tmp132))), (_tmp131 == NULL ? NULL : (_tmp131 = (g_object_unref (_tmp131), NULL))), _tmp133);
		temp_decl = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->int_type, TRUE, NULL);
		temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl)));
		gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_decl);
		/* memset needs string.h */
		vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_h_needed = TRUE;
		clen = vala_ccode_generator_get_array_length_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_member_access_get_inner (ma), 1);
		_tmp134 = NULL;
		celems = (_tmp134 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))), (_tmp134 == NULL ? NULL : g_object_ref (_tmp134)));
		_tmp135 = NULL;
		array_type = (_tmp135 = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (ma))), (_tmp135 == NULL ? NULL : g_object_ref (_tmp135)));
		_tmp137 = NULL;
		_tmp136 = NULL;
		_tmp138 = NULL;
		csizeof = (_tmp138 = vala_ccode_identifier_new ((_tmp137 = g_strdup_printf ("sizeof (%s)", (_tmp136 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))))), (_tmp137 = (g_free (_tmp137), NULL)), (_tmp136 = (g_free (_tmp136), NULL)), _tmp138);
		_tmp139 = NULL;
		_tmp140 = NULL;
		cdelta = (_tmp140 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION ((_tmp139 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, VALA_CCODE_EXPRESSION (temp_ref), clen)))), (_tmp139 == NULL ? NULL : (_tmp139 = (g_object_unref (_tmp139), NULL))), _tmp140);
		ccheck = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, VALA_CCODE_EXPRESSION (temp_ref), clen);
		_tmp141 = NULL;
		_tmp142 = NULL;
		czero = (_tmp142 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp141 = vala_ccode_identifier_new ("memset")))), (_tmp141 == NULL ? NULL : (_tmp141 = (g_object_unref (_tmp141), NULL))), _tmp142);
		_tmp143 = NULL;
		vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp143 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, celems, clen))));
		(_tmp143 == NULL ? NULL : (_tmp143 = (g_object_unref (_tmp143), NULL)));
		_tmp144 = NULL;
		vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp144 = vala_ccode_constant_new ("0"))));
		(_tmp144 == NULL ? NULL : (_tmp144 = (g_object_unref (_tmp144), NULL)));
		_tmp145 = NULL;
		vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp145 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION (csizeof), VALA_CCODE_EXPRESSION (cdelta)))));
		(_tmp145 == NULL ? NULL : (_tmp145 = (g_object_unref (_tmp145), NULL)));
		ccomma = vala_ccode_comma_expression_new ();
		_tmp146 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp146 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (temp_ref), new_size, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(_tmp146 == NULL ? NULL : (_tmp146 = (g_object_unref (_tmp146), NULL)));
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))));
		_tmp148 = NULL;
		_tmp147 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp148 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (ccheck), VALA_CCODE_EXPRESSION (czero), VALA_CCODE_EXPRESSION ((_tmp147 = vala_ccode_constant_new ("NULL")))))));
		(_tmp148 == NULL ? NULL : (_tmp148 = (g_object_unref (_tmp148), NULL)));
		(_tmp147 == NULL ? NULL : (_tmp147 = (g_object_unref (_tmp147), NULL)));
		_tmp150 = NULL;
		_tmp149 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp150 = vala_ccode_assignment_new ((_tmp149 = vala_ccode_generator_get_array_length_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_member_access_get_inner (ma), 1)), VALA_CCODE_EXPRESSION (temp_ref), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(_tmp150 == NULL ? NULL : (_tmp150 = (g_object_unref (_tmp150), NULL)));
		(_tmp149 == NULL ? NULL : (_tmp149 = (g_object_unref (_tmp149), NULL)));
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
		(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
		(new_size == NULL ? NULL : (new_size = (g_object_unref (new_size), NULL)));
		(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
		(temp_ref == NULL ? NULL : (temp_ref = (g_object_unref (temp_ref), NULL)));
		(clen == NULL ? NULL : (clen = (g_object_unref (clen), NULL)));
		(celems == NULL ? NULL : (celems = (g_object_unref (celems), NULL)));
		(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
		(csizeof == NULL ? NULL : (csizeof = (g_object_unref (csizeof), NULL)));
		(cdelta == NULL ? NULL : (cdelta = (g_object_unref (cdelta), NULL)));
		(ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL)));
		(czero == NULL ? NULL : (czero = (g_object_unref (czero), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
	} else {
		if (m == vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->substring_method) {
			ValaLocalVariable* temp_decl;
			ValaCCodeIdentifier* temp_ref;
			GeeList* args;
			ValaCCodeIdentifier* _tmp151;
			ValaCCodeFunctionCall* _tmp152;
			ValaCCodeFunctionCall* coffsetcall;
			ValaCCodeExpression* _tmp153;
			ValaCCodeExpression* _tmp154;
			ValaCCodeIdentifier* _tmp155;
			ValaCCodeFunctionCall* _tmp156;
			ValaCCodeFunctionCall* coffsetcall2;
			ValaCCodeExpression* _tmp157;
			ValaCCodeIdentifier* _tmp158;
			ValaCCodeFunctionCall* _tmp159;
			ValaCCodeFunctionCall* cndupcall;
			ValaCCodeBinaryExpression* _tmp160;
			ValaCCodeCommaExpression* ccomma;
			ValaCCodeAssignment* _tmp161;
			temp_decl = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type, TRUE, NULL);
			temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl)));
			gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_decl);
			args = vala_ccode_function_call_get_arguments (ccall);
			_tmp151 = NULL;
			_tmp152 = NULL;
			coffsetcall = (_tmp152 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp151 = vala_ccode_identifier_new ("g_utf8_offset_to_pointer")))), (_tmp151 == NULL ? NULL : (_tmp151 = (g_object_unref (_tmp151), NULL))), _tmp152);
			/* full string*/
			_tmp153 = NULL;
			vala_ccode_function_call_add_argument (coffsetcall, (_tmp153 = ((ValaCCodeExpression*) (gee_list_get (((GeeList*) (args)), 0)))));
			(_tmp153 == NULL ? NULL : (_tmp153 = (g_object_unref (_tmp153), NULL)));
			/* offset*/
			_tmp154 = NULL;
			vala_ccode_function_call_add_argument (coffsetcall, (_tmp154 = ((ValaCCodeExpression*) (gee_list_get (((GeeList*) (args)), 1)))));
			(_tmp154 == NULL ? NULL : (_tmp154 = (g_object_unref (_tmp154), NULL)));
			_tmp155 = NULL;
			_tmp156 = NULL;
			coffsetcall2 = (_tmp156 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp155 = vala_ccode_identifier_new ("g_utf8_offset_to_pointer")))), (_tmp155 == NULL ? NULL : (_tmp155 = (g_object_unref (_tmp155), NULL))), _tmp156);
			vala_ccode_function_call_add_argument (coffsetcall2, VALA_CCODE_EXPRESSION (temp_ref));
			/* len*/
			_tmp157 = NULL;
			vala_ccode_function_call_add_argument (coffsetcall2, (_tmp157 = ((ValaCCodeExpression*) (gee_list_get (((GeeList*) (args)), 2)))));
			(_tmp157 == NULL ? NULL : (_tmp157 = (g_object_unref (_tmp157), NULL)));
			_tmp158 = NULL;
			_tmp159 = NULL;
			cndupcall = (_tmp159 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp158 = vala_ccode_identifier_new ("g_strndup")))), (_tmp158 == NULL ? NULL : (_tmp158 = (g_object_unref (_tmp158), NULL))), _tmp159);
			vala_ccode_function_call_add_argument (cndupcall, VALA_CCODE_EXPRESSION (temp_ref));
			_tmp160 = NULL;
			vala_ccode_function_call_add_argument (cndupcall, VALA_CCODE_EXPRESSION ((_tmp160 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, VALA_CCODE_EXPRESSION (coffsetcall2), VALA_CCODE_EXPRESSION (temp_ref)))));
			(_tmp160 == NULL ? NULL : (_tmp160 = (g_object_unref (_tmp160), NULL)));
			ccomma = vala_ccode_comma_expression_new ();
			_tmp161 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp161 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (temp_ref), VALA_CCODE_EXPRESSION (coffsetcall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(_tmp161 == NULL ? NULL : (_tmp161 = (g_object_unref (_tmp161), NULL)));
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cndupcall));
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
			(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
			(temp_ref == NULL ? NULL : (temp_ref = (g_object_unref (temp_ref), NULL)));
			(args == NULL ? NULL : (args = (g_object_unref (args), NULL)));
			(coffsetcall == NULL ? NULL : (coffsetcall = (g_object_unref (coffsetcall), NULL)));
			(coffsetcall2 == NULL ? NULL : (coffsetcall2 = (g_object_unref (coffsetcall2), NULL)));
			(cndupcall == NULL ? NULL : (cndupcall = (g_object_unref (cndupcall), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		}
	}
	(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
	(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
	(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
	(itype == NULL ? NULL : (itype = (g_object_unref (itype), NULL)));
	(ccall_expr == NULL ? NULL : (ccall_expr = (g_object_unref (ccall_expr), NULL)));
	(carg_map == NULL ? NULL : (carg_map = (g_object_unref (carg_map), NULL)));
	(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
	(params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL)));
}


ValaInvocationExpression* vala_ccode_invocation_expression_binding_get_invocation_expression (ValaCCodeInvocationExpressionBinding* self) {
	g_return_val_if_fail (VALA_IS_CCODE_INVOCATION_EXPRESSION_BINDING (self), NULL);
	return self->priv->_invocation_expression;
}


void vala_ccode_invocation_expression_binding_set_invocation_expression (ValaCCodeInvocationExpressionBinding* self, ValaInvocationExpression* value) {
	ValaInvocationExpression* _tmp2;
	ValaInvocationExpression* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_INVOCATION_EXPRESSION_BINDING (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_invocation_expression = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_invocation_expression == NULL ? NULL : (self->priv->_invocation_expression = (g_object_unref (self->priv->_invocation_expression), NULL))), _tmp2);
}


static void vala_ccode_invocation_expression_binding_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeInvocationExpressionBinding * self;
	self = VALA_CCODE_INVOCATION_EXPRESSION_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_INVOCATION_EXPRESSION_BINDING_INVOCATION_EXPRESSION:
		g_value_set_object (value, vala_ccode_invocation_expression_binding_get_invocation_expression (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_invocation_expression_binding_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeInvocationExpressionBinding * self;
	self = VALA_CCODE_INVOCATION_EXPRESSION_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_INVOCATION_EXPRESSION_BINDING_INVOCATION_EXPRESSION:
		vala_ccode_invocation_expression_binding_set_invocation_expression (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_invocation_expression_binding_class_init (ValaCCodeInvocationExpressionBindingClass * klass) {
	vala_ccode_invocation_expression_binding_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeInvocationExpressionBindingPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_invocation_expression_binding_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_invocation_expression_binding_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_invocation_expression_binding_dispose;
	VALA_CCODE_BINDING_CLASS (klass)->emit = vala_ccode_invocation_expression_binding_real_emit;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_INVOCATION_EXPRESSION_BINDING_INVOCATION_EXPRESSION, g_param_spec_object ("invocation-expression", "invocation-expression", "invocation-expression", VALA_TYPE_INVOCATION_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_invocation_expression_binding_instance_init (ValaCCodeInvocationExpressionBinding * self) {
	self->priv = VALA_CCODE_INVOCATION_EXPRESSION_BINDING_GET_PRIVATE (self);
}


static void vala_ccode_invocation_expression_binding_dispose (GObject * obj) {
	ValaCCodeInvocationExpressionBinding * self;
	self = VALA_CCODE_INVOCATION_EXPRESSION_BINDING (obj);
	(self->priv->_invocation_expression == NULL ? NULL : (self->priv->_invocation_expression = (g_object_unref (self->priv->_invocation_expression), NULL)));
	G_OBJECT_CLASS (vala_ccode_invocation_expression_binding_parent_class)->dispose (obj);
}


GType vala_ccode_invocation_expression_binding_get_type (void) {
	static GType vala_ccode_invocation_expression_binding_type_id = 0;
	if (G_UNLIKELY (vala_ccode_invocation_expression_binding_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeInvocationExpressionBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_invocation_expression_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeInvocationExpressionBinding), 0, (GInstanceInitFunc) vala_ccode_invocation_expression_binding_instance_init };
		vala_ccode_invocation_expression_binding_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION_BINDING, "ValaCCodeInvocationExpressionBinding", &g_define_type_info, 0);
	}
	return vala_ccode_invocation_expression_binding_type_id;
}




