/* valaccodeidentifier.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __CCODE_VALACCODEIDENTIFIER_H__
#define __CCODE_VALACCODEIDENTIFIER_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodewriter.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_IDENTIFIER (vala_ccode_identifier_get_type ())
#define VALA_CCODE_IDENTIFIER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_IDENTIFIER, ValaCCodeIdentifier))
#define VALA_CCODE_IDENTIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_IDENTIFIER, ValaCCodeIdentifierClass))
#define VALA_IS_CCODE_IDENTIFIER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_IDENTIFIER))
#define VALA_IS_CCODE_IDENTIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_IDENTIFIER))
#define VALA_CCODE_IDENTIFIER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_IDENTIFIER, ValaCCodeIdentifierClass))

typedef struct _ValaCCodeIdentifier ValaCCodeIdentifier;
typedef struct _ValaCCodeIdentifierClass ValaCCodeIdentifierClass;
typedef struct _ValaCCodeIdentifierPrivate ValaCCodeIdentifierPrivate;

/**
 * Represents a identifier in the C code.
 */
struct _ValaCCodeIdentifier {
	ValaCCodeExpression parent_instance;
	ValaCCodeIdentifierPrivate * priv;
};

struct _ValaCCodeIdentifierClass {
	ValaCCodeExpressionClass parent_class;
};


ValaCCodeIdentifier* vala_ccode_identifier_new (const char* _name);
const char* vala_ccode_identifier_get_name (ValaCCodeIdentifier* self);
void vala_ccode_identifier_set_name (ValaCCodeIdentifier* self, const char* value);
GType vala_ccode_identifier_get_type (void);


G_END_DECLS

#endif
