/* valatype.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#ifndef __VALA_VALATYPESYMBOL_H__
#define __VALA_VALATYPESYMBOL_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee/collection.h>
#include <vala/valasymbol.h>

G_BEGIN_DECLS


#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypesymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypesymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypesymbolClass))

typedef struct _ValaTypesymbol ValaTypesymbol;
typedef struct _ValaTypesymbolClass ValaTypesymbolClass;
typedef struct _ValaTypesymbolPrivate ValaTypesymbolPrivate;

/**
 * Represents a runtime data type. This data type may be defined in Vala source
 * code or imported from an external library with a Vala API file.
 */
struct _ValaTypesymbol {
	ValaSymbol parent_instance;
	ValaTypesymbolPrivate * priv;
};
struct _ValaTypesymbolClass {
	ValaSymbolClass parent_class;
	char* (*get_cname) (ValaTypesymbol* self, gboolean const_type);
	gboolean (*is_reference_type) (ValaTypesymbol* self);
	char* (*get_dup_function) (ValaTypesymbol* self);
	char* (*get_free_function) (ValaTypesymbol* self);
	gboolean (*is_reference_counting) (ValaTypesymbol* self);
	char* (*get_ref_function) (ValaTypesymbol* self);
	char* (*get_unref_function) (ValaTypesymbol* self);
	char* (*get_type_id) (ValaTypesymbol* self);
	char* (*get_marshaller_type_name) (ValaTypesymbol* self);
	char* (*get_get_value_function) (ValaTypesymbol* self);
	char* (*get_set_value_function) (ValaTypesymbol* self);
	char* (*get_upper_case_cname) (ValaTypesymbol* self, const char* infix);
	char* (*get_default_value) (ValaTypesymbol* self);
	gboolean (*is_subtype_of) (ValaTypesymbol* self, ValaTypesymbol* t);
	gint (*get_type_parameter_index) (ValaTypesymbol* self, const char* name);
};

char* vala_typesymbol_get_cname (ValaTypesymbol* self, gboolean const_type);
gboolean vala_typesymbol_is_reference_type (ValaTypesymbol* self);
char* vala_typesymbol_get_dup_function (ValaTypesymbol* self);
char* vala_typesymbol_get_free_function (ValaTypesymbol* self);
gboolean vala_typesymbol_is_reference_counting (ValaTypesymbol* self);
char* vala_typesymbol_get_ref_function (ValaTypesymbol* self);
char* vala_typesymbol_get_unref_function (ValaTypesymbol* self);
char* vala_typesymbol_get_type_id (ValaTypesymbol* self);
char* vala_typesymbol_get_marshaller_type_name (ValaTypesymbol* self);
char* vala_typesymbol_get_get_value_function (ValaTypesymbol* self);
char* vala_typesymbol_get_set_value_function (ValaTypesymbol* self);
char* vala_typesymbol_get_upper_case_cname (ValaTypesymbol* self, const char* infix);
char* vala_typesymbol_get_default_value (ValaTypesymbol* self);
void vala_typesymbol_add_cheader_filename (ValaTypesymbol* self, const char* filename);
gboolean vala_typesymbol_is_subtype_of (ValaTypesymbol* self, ValaTypesymbol* t);
gint vala_typesymbol_get_type_parameter_index (ValaTypesymbol* self, const char* name);
GType vala_typesymbol_get_type (void);


G_END_DECLS

#endif
