/* valastruct.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALASTRUCT_H__
#define __VALA_VALASTRUCT_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee/collection.h>
#include <vala/valatypesymbol.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStructPrivate ValaStructPrivate;

/**
 * Represents a struct declaration in the source code.
 */
struct _ValaStruct {
	ValaTypesymbol parent_instance;
	ValaStructPrivate * priv;
};
struct _ValaStructClass {
	ValaTypesymbolClass parent_class;
};

ValaStruct* vala_struct_new (const char* name, ValaSourceReference* source_reference);
void vala_struct_add_type_parameter (ValaStruct* self, ValaTypeParameter* p);
void vala_struct_add_constant (ValaStruct* self, ValaConstant* c);
void vala_struct_add_field (ValaStruct* self, ValaField* f);
GeeCollection* vala_struct_get_fields (ValaStruct* self);
void vala_struct_add_method (ValaStruct* self, ValaMethod* m);
GeeCollection* vala_struct_get_methods (ValaStruct* self);
gboolean vala_struct_is_integer_type (ValaStruct* self);
gboolean vala_struct_is_floating_type (ValaStruct* self);
gint vala_struct_get_rank (ValaStruct* self);
void vala_struct_process_attributes (ValaStruct* self);
void vala_struct_set_type_id (ValaStruct* self, const char* name);
void vala_struct_add_base_type (ValaStruct* self, ValaDataType* type);
GeeCollection* vala_struct_get_base_types (ValaStruct* self);
gboolean vala_struct_is_simple_type (ValaStruct* self);
void vala_struct_set_simple_type (ValaStruct* self, gboolean simple_type);
ValaMethod* vala_struct_get_default_construction_method (ValaStruct* self);
void vala_struct_set_default_construction_method (ValaStruct* self, ValaMethod* value);
GType vala_struct_get_type (void);


G_END_DECLS

#endif
