/* valaforeachstatement.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaforeachstatement.h>
#include <vala/valavariabledeclarator.h>
#include <vala/valaexpression.h>
#include <vala/valadatatype.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>




struct _ValaForeachStatementPrivate {
	char* _variable_name;
	ValaVariableDeclarator* _variable_declarator;
	ValaVariableDeclarator* _collection_variable_declarator;
	ValaVariableDeclarator* _iterator_variable_declarator;
	ValaExpression* _collection;
	ValaBlock* _body;
	ValaDataType* _data_type;
};
#define VALA_FOREACH_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_FOREACH_STATEMENT, ValaForeachStatementPrivate))
enum  {
	VALA_FOREACH_STATEMENT_DUMMY_PROPERTY,
	VALA_FOREACH_STATEMENT_TYPE_REFERENCE,
	VALA_FOREACH_STATEMENT_VARIABLE_NAME,
	VALA_FOREACH_STATEMENT_COLLECTION,
	VALA_FOREACH_STATEMENT_BODY,
	VALA_FOREACH_STATEMENT_VARIABLE_DECLARATOR,
	VALA_FOREACH_STATEMENT_COLLECTION_VARIABLE_DECLARATOR,
	VALA_FOREACH_STATEMENT_ITERATOR_VARIABLE_DECLARATOR
};
static void vala_foreach_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_foreach_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_foreach_statement_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static void vala_foreach_statement_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static gpointer vala_foreach_statement_parent_class = NULL;
static void vala_foreach_statement_dispose (GObject * obj);



/**
 * Creates a new foreach statement.
 *
 * @param type   element type
 * @param id     element variable name
 * @param col    loop body
 * @param source reference to source code
 * @return       newly created foreach statement
 */
ValaForeachStatement* vala_foreach_statement_new (ValaDataType* type_reference, const char* variable_name, ValaExpression* collection, ValaBlock* body, ValaSourceReference* source_reference) {
	GParameter * __params;
	GParameter * __params_it;
	ValaForeachStatement * self;
	g_return_val_if_fail (type_reference == NULL || VALA_IS_DATA_TYPE (type_reference), NULL);
	g_return_val_if_fail (collection == NULL || VALA_IS_EXPRESSION (collection), NULL);
	g_return_val_if_fail (body == NULL || VALA_IS_BLOCK (body), NULL);
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	__params_it->name = "variable-name";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, variable_name);
	__params_it++;
	__params_it->name = "collection";
	g_value_init (&__params_it->value, VALA_TYPE_EXPRESSION);
	g_value_set_object (&__params_it->value, collection);
	__params_it++;
	self = g_object_newv (VALA_TYPE_FOREACH_STATEMENT, __params_it - __params, __params);
	vala_foreach_statement_set_type_reference (self, type_reference);
	vala_foreach_statement_set_body (self, body);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source_reference);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


static void vala_foreach_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaForeachStatement * self;
	self = VALA_FOREACH_STATEMENT (base);
	g_return_if_fail (visitor == NULL || VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_foreach_statement (visitor, self);
}


static void vala_foreach_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaForeachStatement * self;
	self = VALA_FOREACH_STATEMENT (base);
	g_return_if_fail (visitor == NULL || VALA_IS_CODE_VISITOR (visitor));
	vala_code_node_accept (VALA_CODE_NODE (vala_foreach_statement_get_type_reference (self)), visitor);
	vala_code_node_accept (VALA_CODE_NODE (vala_foreach_statement_get_collection (self)), visitor);
	vala_code_visitor_visit_end_full_expression (visitor, vala_foreach_statement_get_collection (self));
	vala_code_node_accept (VALA_CODE_NODE (vala_foreach_statement_get_body (self)), visitor);
}


static void vala_foreach_statement_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaForeachStatement * self;
	self = VALA_FOREACH_STATEMENT (base);
	g_return_if_fail (old_node == NULL || VALA_IS_EXPRESSION (old_node));
	g_return_if_fail (new_node == NULL || VALA_IS_EXPRESSION (new_node));
	if (vala_foreach_statement_get_collection (self) == old_node) {
		vala_foreach_statement_set_collection (self, new_node);
	}
}


static void vala_foreach_statement_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaForeachStatement * self;
	self = VALA_FOREACH_STATEMENT (base);
	g_return_if_fail (old_type == NULL || VALA_IS_DATA_TYPE (old_type));
	g_return_if_fail (new_type == NULL || VALA_IS_DATA_TYPE (new_type));
	if (vala_foreach_statement_get_type_reference (self) == old_type) {
		vala_foreach_statement_set_type_reference (self, new_type);
	}
}


ValaDataType* vala_foreach_statement_get_type_reference (ValaForeachStatement* self) {
	g_return_val_if_fail (VALA_IS_FOREACH_STATEMENT (self), NULL);
	return self->priv->_data_type;
}


void vala_foreach_statement_set_type_reference (ValaForeachStatement* self, ValaDataType* value) {
	ValaDataType* _tmp2;
	ValaDataType* _tmp1;
	g_return_if_fail (VALA_IS_FOREACH_STATEMENT (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_data_type = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_data_type == NULL ? NULL : (self->priv->_data_type = (g_object_unref (self->priv->_data_type), NULL))), _tmp2);
	vala_code_node_set_parent_node (VALA_CODE_NODE (self->priv->_data_type), VALA_CODE_NODE (self));
}


char* vala_foreach_statement_get_variable_name (ValaForeachStatement* self) {
	g_return_val_if_fail (VALA_IS_FOREACH_STATEMENT (self), NULL);
	return self->priv->_variable_name;
}


void vala_foreach_statement_set_variable_name (ValaForeachStatement* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (VALA_IS_FOREACH_STATEMENT (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_variable_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (self->priv->_variable_name = (g_free (self->priv->_variable_name), NULL)), _tmp2);
}


ValaExpression* vala_foreach_statement_get_collection (ValaForeachStatement* self) {
	g_return_val_if_fail (VALA_IS_FOREACH_STATEMENT (self), NULL);
	return self->priv->_collection;
}


void vala_foreach_statement_set_collection (ValaForeachStatement* self, ValaExpression* value) {
	ValaExpression* _tmp2;
	ValaExpression* _tmp1;
	g_return_if_fail (VALA_IS_FOREACH_STATEMENT (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_collection = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_collection == NULL ? NULL : (self->priv->_collection = (g_object_unref (self->priv->_collection), NULL))), _tmp2);
	vala_code_node_set_parent_node (VALA_CODE_NODE (self->priv->_collection), VALA_CODE_NODE (self));
}


ValaBlock* vala_foreach_statement_get_body (ValaForeachStatement* self) {
	g_return_val_if_fail (VALA_IS_FOREACH_STATEMENT (self), NULL);
	return self->priv->_body;
}


void vala_foreach_statement_set_body (ValaForeachStatement* self, ValaBlock* value) {
	ValaBlock* _tmp2;
	ValaBlock* _tmp1;
	g_return_if_fail (VALA_IS_FOREACH_STATEMENT (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_body = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_body == NULL ? NULL : (self->priv->_body = (g_object_unref (self->priv->_body), NULL))), _tmp2);
	vala_code_node_set_parent_node (VALA_CODE_NODE (self->priv->_body), VALA_CODE_NODE (self));
}


ValaVariableDeclarator* vala_foreach_statement_get_variable_declarator (ValaForeachStatement* self) {
	g_return_val_if_fail (VALA_IS_FOREACH_STATEMENT (self), NULL);
	return self->priv->_variable_declarator;
}


void vala_foreach_statement_set_variable_declarator (ValaForeachStatement* self, ValaVariableDeclarator* value) {
	ValaVariableDeclarator* _tmp2;
	ValaVariableDeclarator* _tmp1;
	g_return_if_fail (VALA_IS_FOREACH_STATEMENT (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_variable_declarator = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_variable_declarator == NULL ? NULL : (self->priv->_variable_declarator = (g_object_unref (self->priv->_variable_declarator), NULL))), _tmp2);
}


ValaVariableDeclarator* vala_foreach_statement_get_collection_variable_declarator (ValaForeachStatement* self) {
	g_return_val_if_fail (VALA_IS_FOREACH_STATEMENT (self), NULL);
	return self->priv->_collection_variable_declarator;
}


void vala_foreach_statement_set_collection_variable_declarator (ValaForeachStatement* self, ValaVariableDeclarator* value) {
	ValaVariableDeclarator* _tmp2;
	ValaVariableDeclarator* _tmp1;
	g_return_if_fail (VALA_IS_FOREACH_STATEMENT (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_collection_variable_declarator = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_collection_variable_declarator == NULL ? NULL : (self->priv->_collection_variable_declarator = (g_object_unref (self->priv->_collection_variable_declarator), NULL))), _tmp2);
}


ValaVariableDeclarator* vala_foreach_statement_get_iterator_variable_declarator (ValaForeachStatement* self) {
	g_return_val_if_fail (VALA_IS_FOREACH_STATEMENT (self), NULL);
	return self->priv->_iterator_variable_declarator;
}


void vala_foreach_statement_set_iterator_variable_declarator (ValaForeachStatement* self, ValaVariableDeclarator* value) {
	ValaVariableDeclarator* _tmp2;
	ValaVariableDeclarator* _tmp1;
	g_return_if_fail (VALA_IS_FOREACH_STATEMENT (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_iterator_variable_declarator = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_iterator_variable_declarator == NULL ? NULL : (self->priv->_iterator_variable_declarator = (g_object_unref (self->priv->_iterator_variable_declarator), NULL))), _tmp2);
}


static void vala_foreach_statement_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaForeachStatement * self;
	self = VALA_FOREACH_STATEMENT (object);
	switch (property_id) {
		case VALA_FOREACH_STATEMENT_TYPE_REFERENCE:
		g_value_set_object (value, vala_foreach_statement_get_type_reference (self));
		break;
		case VALA_FOREACH_STATEMENT_VARIABLE_NAME:
		g_value_set_string (value, vala_foreach_statement_get_variable_name (self));
		break;
		case VALA_FOREACH_STATEMENT_COLLECTION:
		g_value_set_object (value, vala_foreach_statement_get_collection (self));
		break;
		case VALA_FOREACH_STATEMENT_BODY:
		g_value_set_object (value, vala_foreach_statement_get_body (self));
		break;
		case VALA_FOREACH_STATEMENT_VARIABLE_DECLARATOR:
		g_value_set_object (value, vala_foreach_statement_get_variable_declarator (self));
		break;
		case VALA_FOREACH_STATEMENT_COLLECTION_VARIABLE_DECLARATOR:
		g_value_set_object (value, vala_foreach_statement_get_collection_variable_declarator (self));
		break;
		case VALA_FOREACH_STATEMENT_ITERATOR_VARIABLE_DECLARATOR:
		g_value_set_object (value, vala_foreach_statement_get_iterator_variable_declarator (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_foreach_statement_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaForeachStatement * self;
	self = VALA_FOREACH_STATEMENT (object);
	switch (property_id) {
		case VALA_FOREACH_STATEMENT_TYPE_REFERENCE:
		vala_foreach_statement_set_type_reference (self, g_value_get_object (value));
		break;
		case VALA_FOREACH_STATEMENT_VARIABLE_NAME:
		vala_foreach_statement_set_variable_name (self, g_value_get_string (value));
		break;
		case VALA_FOREACH_STATEMENT_COLLECTION:
		vala_foreach_statement_set_collection (self, g_value_get_object (value));
		break;
		case VALA_FOREACH_STATEMENT_BODY:
		vala_foreach_statement_set_body (self, g_value_get_object (value));
		break;
		case VALA_FOREACH_STATEMENT_VARIABLE_DECLARATOR:
		vala_foreach_statement_set_variable_declarator (self, g_value_get_object (value));
		break;
		case VALA_FOREACH_STATEMENT_COLLECTION_VARIABLE_DECLARATOR:
		vala_foreach_statement_set_collection_variable_declarator (self, g_value_get_object (value));
		break;
		case VALA_FOREACH_STATEMENT_ITERATOR_VARIABLE_DECLARATOR:
		vala_foreach_statement_set_iterator_variable_declarator (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_foreach_statement_class_init (ValaForeachStatementClass * klass) {
	vala_foreach_statement_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaForeachStatementPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_foreach_statement_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_foreach_statement_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_foreach_statement_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_foreach_statement_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_foreach_statement_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->replace_expression = vala_foreach_statement_real_replace_expression;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_foreach_statement_real_replace_type;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_FOREACH_STATEMENT_TYPE_REFERENCE, g_param_spec_object ("type-reference", "type-reference", "type-reference", VALA_TYPE_DATA_TYPE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_FOREACH_STATEMENT_VARIABLE_NAME, g_param_spec_string ("variable-name", "variable-name", "variable-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_FOREACH_STATEMENT_COLLECTION, g_param_spec_object ("collection", "collection", "collection", VALA_TYPE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_FOREACH_STATEMENT_BODY, g_param_spec_object ("body", "body", "body", VALA_TYPE_BLOCK, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_FOREACH_STATEMENT_VARIABLE_DECLARATOR, g_param_spec_object ("variable-declarator", "variable-declarator", "variable-declarator", VALA_TYPE_VARIABLE_DECLARATOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_FOREACH_STATEMENT_COLLECTION_VARIABLE_DECLARATOR, g_param_spec_object ("collection-variable-declarator", "collection-variable-declarator", "collection-variable-declarator", VALA_TYPE_VARIABLE_DECLARATOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_FOREACH_STATEMENT_ITERATOR_VARIABLE_DECLARATOR, g_param_spec_object ("iterator-variable-declarator", "iterator-variable-declarator", "iterator-variable-declarator", VALA_TYPE_VARIABLE_DECLARATOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_foreach_statement_init (ValaForeachStatement * self) {
	self->priv = VALA_FOREACH_STATEMENT_GET_PRIVATE (self);
}


static void vala_foreach_statement_dispose (GObject * obj) {
	ValaForeachStatement * self;
	self = VALA_FOREACH_STATEMENT (obj);
	self->priv->_variable_name = (g_free (self->priv->_variable_name), NULL);
	(self->priv->_variable_declarator == NULL ? NULL : (self->priv->_variable_declarator = (g_object_unref (self->priv->_variable_declarator), NULL)));
	(self->priv->_collection_variable_declarator == NULL ? NULL : (self->priv->_collection_variable_declarator = (g_object_unref (self->priv->_collection_variable_declarator), NULL)));
	(self->priv->_iterator_variable_declarator == NULL ? NULL : (self->priv->_iterator_variable_declarator = (g_object_unref (self->priv->_iterator_variable_declarator), NULL)));
	(self->priv->_collection == NULL ? NULL : (self->priv->_collection = (g_object_unref (self->priv->_collection), NULL)));
	(self->priv->_body == NULL ? NULL : (self->priv->_body = (g_object_unref (self->priv->_body), NULL)));
	(self->priv->_data_type == NULL ? NULL : (self->priv->_data_type = (g_object_unref (self->priv->_data_type), NULL)));
	G_OBJECT_CLASS (vala_foreach_statement_parent_class)->dispose (obj);
}


GType vala_foreach_statement_get_type (void) {
	static GType vala_foreach_statement_type_id = 0;
	if (G_UNLIKELY (vala_foreach_statement_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaForeachStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_foreach_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaForeachStatement), 0, (GInstanceInitFunc) vala_foreach_statement_init };
		vala_foreach_statement_type_id = g_type_register_static (VALA_TYPE_BLOCK, "ValaForeachStatement", &g_define_type_info, 0);
	}
	return vala_foreach_statement_type_id;
}




