/* valagidlparser.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <rasa@gmx.ch>
 */

#ifndef __VALAGIDLPARSER_H__
#define __VALAGIDLPARSER_H__
typedef struct _ValaGIdlParser ValaGIdlParser;
typedef struct _ValaGIdlParserClass ValaGIdlParserClass;
typedef struct _ValaGIdlParserPrivate ValaGIdlParserPrivate;

#include <glib.h>
#include <glib-object.h>
#include <vala/valacodevisitor.h>
#include <vala/valacodecontext.h>
#include <vala/valasourcefile.h>
#include <stdlib.h>
#include <string.h>
#include <gidlmodule.h>
#include <vala/valanamespace.h>
#include <vala/valacallback.h>
#include <gidlnode.h>
#include <vala/valastruct.h>
#include <vala/valaenum.h>
#include <vala/valaclass.h>
#include <vala/valainterface.h>
#include <vala/valatypereference.h>
#include <vala/valamethod.h>
#include <vala/valaproperty.h>
#include <vala/valaconstant.h>
#include <vala/valafield.h>
#include <vala/valasignal.h>

G_BEGIN_DECLS


#define VALA_TYPE_GIDL_PARSER (vala_gidl_parser_get_type ())
#define VALA_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParser))
#define VALA_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))
#define VALA_IS_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GIDL_PARSER))
#define VALA_IS_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GIDL_PARSER))
#define VALA_GIDL_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))


/**
 * Code visitor parsing all GIDL files.
 */
struct _ValaGIdlParser {
	ValaCodeVisitor parent;
	ValaGIdlParserPrivate * priv;
};
struct _ValaGIdlParserClass {
	ValaCodeVisitorClass parent;
};

void vala_gidl_parser_parse (ValaGIdlParser* self, ValaCodeContext* context);
GType vala_gidl_parser_get_type ();

G_END_DECLS

#endif
