/* valapostfixexpression.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valapostfixexpression.h"
#include <vala/valasourcereference.h>
#include <vala/valapostfixexpression.h>
#include <vala/valacodevisitor.h>

struct _ValaPostfixExpressionPrivate {
	ValaExpression* _inner;
	gboolean _increment;
};
#define VALA_POSTFIX_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_POSTFIX_EXPRESSION, ValaPostfixExpressionPrivate))
enum  {
	VALA_POSTFIX_EXPRESSION_DUMMY_PROPERTY,
	VALA_POSTFIX_EXPRESSION_INNER,
	VALA_POSTFIX_EXPRESSION_INCREMENT
};
static void vala_postfix_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_postfix_expression_parent_class = NULL;
static void vala_postfix_expression_dispose (GObject * obj);


/**
 * Creates a new postfix expression.
 *
 * @param inner  operand expression
 * @param inc    true for increment, false for decrement
 * @param source reference to source code
 * @return newly created postfix expression
 */
ValaPostfixExpression* vala_postfix_expression_new (ValaExpression* _inner, gboolean inc, ValaSourceReference* source)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaPostfixExpression * self;
	g_return_val_if_fail (VALA_IS_EXPRESSION (_inner), NULL);
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	__params = g_new0 (GParameter, 3);
	__params_it = __params;
	(__params_it->name = "inner", g_value_init (&__params_it->value, VALA_TYPE_EXPRESSION), g_value_set_object (&__params_it->value, _inner), __params_it++);
	(__params_it->name = "increment", g_value_init (&__params_it->value, G_TYPE_BOOLEAN), g_value_set_boolean (&__params_it->value, inc), __params_it++);
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source), __params_it++);
	self = g_object_newv (VALA_TYPE_POSTFIX_EXPRESSION, __params_it - __params, __params);
	return self;
}


static void vala_postfix_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaPostfixExpression * self;
	self = VALA_POSTFIX_EXPRESSION (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_node_accept (VALA_CODE_NODE (vala_postfix_expression_get_inner (self)), visitor);
	vala_code_visitor_visit_postfix_expression (visitor, self);
}


ValaExpression* vala_postfix_expression_get_inner (ValaPostfixExpression* self)
{
	g_return_val_if_fail (VALA_IS_POSTFIX_EXPRESSION (self), NULL);
	return self->priv->_inner;
}


void vala_postfix_expression_set_inner (ValaPostfixExpression* self, ValaExpression* value)
{
	ValaExpression* __temp1;
	g_return_if_fail (VALA_IS_POSTFIX_EXPRESSION (self));
	__temp1 = NULL;
	self->priv->_inner = (__temp1 = g_object_ref (value), (self->priv->_inner == NULL ? NULL : (self->priv->_inner = (g_object_unref (self->priv->_inner), NULL))), __temp1);
}


gboolean vala_postfix_expression_get_increment (ValaPostfixExpression* self)
{
	g_return_val_if_fail (VALA_IS_POSTFIX_EXPRESSION (self), FALSE);
	return self->priv->_increment;
}


void vala_postfix_expression_set_increment (ValaPostfixExpression* self, gboolean value)
{
	g_return_if_fail (VALA_IS_POSTFIX_EXPRESSION (self));
	self->priv->_increment = value;
}


static void vala_postfix_expression_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaPostfixExpression * self;
	self = VALA_POSTFIX_EXPRESSION (object);
	switch (property_id) {
		case VALA_POSTFIX_EXPRESSION_INNER:
		g_value_set_object (value, vala_postfix_expression_get_inner (self));
		break;
		case VALA_POSTFIX_EXPRESSION_INCREMENT:
		g_value_set_boolean (value, vala_postfix_expression_get_increment (self));
		break;
	}
}


static void vala_postfix_expression_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaPostfixExpression * self;
	self = VALA_POSTFIX_EXPRESSION (object);
	switch (property_id) {
		case VALA_POSTFIX_EXPRESSION_INNER:
		vala_postfix_expression_set_inner (self, g_value_get_object (value));
		break;
		case VALA_POSTFIX_EXPRESSION_INCREMENT:
		vala_postfix_expression_set_increment (self, g_value_get_boolean (value));
		break;
	}
}


static void vala_postfix_expression_class_init (ValaPostfixExpressionClass * klass)
{
	vala_postfix_expression_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaPostfixExpressionPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_postfix_expression_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_postfix_expression_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_postfix_expression_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_postfix_expression_real_accept;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_POSTFIX_EXPRESSION_INNER, g_param_spec_object ("inner", "foo", "bar", VALA_TYPE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_POSTFIX_EXPRESSION_INCREMENT, g_param_spec_boolean ("increment", "foo", "bar", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_postfix_expression_init (ValaPostfixExpression * self)
{
	self->priv = VALA_POSTFIX_EXPRESSION_GET_PRIVATE (self);
}


static void vala_postfix_expression_dispose (GObject * obj)
{
	ValaPostfixExpression * self;
	ValaPostfixExpressionClass * klass;
	GObjectClass * parent_class;
	self = VALA_POSTFIX_EXPRESSION (obj);
	(self->priv->_inner == NULL ? NULL : (self->priv->_inner = (g_object_unref (self->priv->_inner), NULL)));
	klass = VALA_POSTFIX_EXPRESSION_CLASS (g_type_class_peek (VALA_TYPE_POSTFIX_EXPRESSION));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_postfix_expression_get_type ()
{
	static GType vala_postfix_expression_type_id = 0;
	if (G_UNLIKELY (vala_postfix_expression_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaPostfixExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_postfix_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaPostfixExpression), 0, (GInstanceInitFunc) vala_postfix_expression_init };
		vala_postfix_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaPostfixExpression", &g_define_type_info, 0);
	}
	return vala_postfix_expression_type_id;
}




