/* valaparser.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valaparser.h"
#include <vala/valaparser.h>

struct _ValaParserPrivate {
	char* comment;
	char* _file_comment;
};
#define VALA_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_PARSER, ValaParserPrivate))
enum  {
	VALA_PARSER_DUMMY_PROPERTY
};
static void vala_parser_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file);
static gpointer vala_parser_parent_class = NULL;
static void vala_parser_dispose (GObject * obj);


/**
 * Parse all source files in the specified code context and build a
 * code tree.
 *
 * @param context a code context
 */
void vala_parser_parse (ValaParser* self, ValaCodeContext* context)
{
	g_return_if_fail (VALA_IS_PARSER (self));
	g_return_if_fail (VALA_IS_CODE_CONTEXT (context));
	vala_code_context_accept (context, VALA_CODE_VISITOR (self));
}


static void vala_parser_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file)
{
	ValaParser * self;
	char* __temp0;
	self = VALA_PARSER (base);
	g_return_if_fail (VALA_IS_SOURCE_FILE (source_file));
	if (g_str_has_suffix (vala_source_file_get_filename (source_file), ".vala")) {
		vala_parser_parse_file (self, source_file);
		(vala_source_file_set_comment (source_file, self->priv->_file_comment), vala_source_file_get_comment (source_file));
	}
	__temp0 = NULL;
	self->priv->_file_comment = (__temp0 = NULL, (self->priv->_file_comment = (g_free (self->priv->_file_comment), NULL)), __temp0);
}


/**
 * Adds the specified comment to the comment stack.
 *
 * @param comment_item a comment string
 * @param file_comment true if file header comment, false otherwise
 */
void vala_parser_push_comment (ValaParser* self, const char* comment_item, gboolean file_comment)
{
	g_return_if_fail (VALA_IS_PARSER (self));
	g_return_if_fail (comment_item != NULL);
	if (self->priv->comment == NULL) {
		char* __temp1;
		__temp1 = NULL;
		self->priv->comment = (__temp1 = g_strdup (comment_item), (self->priv->comment = (g_free (self->priv->comment), NULL)), __temp1);
	} else {
		char* __temp2;
		__temp2 = NULL;
		self->priv->comment = (__temp2 = g_strdup_printf ("%s\n%s", self->priv->comment, comment_item), (self->priv->comment = (g_free (self->priv->comment), NULL)), __temp2);
	}
	if (file_comment) {
		char* __temp4;
		const char* __temp3;
		char* __temp5;
		__temp4 = NULL;
		__temp3 = NULL;
		self->priv->_file_comment = (__temp4 = (__temp3 = self->priv->comment, (__temp3 == NULL ? NULL : g_strdup (__temp3))), (self->priv->_file_comment = (g_free (self->priv->_file_comment), NULL)), __temp4);
		__temp5 = NULL;
		self->priv->comment = (__temp5 = NULL, (self->priv->comment = (g_free (self->priv->comment), NULL)), __temp5);
	}
}


/**
 * Clears and returns the content of the comment stack.
 *
 * @return saved comment
 */
char* vala_parser_pop_comment (ValaParser* self)
{
	GString* result;
	char* __temp7;
	const char* index;
	const char* __temp8;
	char* __temp9;
	g_return_val_if_fail (VALA_IS_PARSER (self), NULL);
	if (self->priv->comment == NULL) {
		return NULL;
	}
	result = g_string_new (self->priv->comment);
	__temp7 = NULL;
	self->priv->comment = (__temp7 = NULL, (self->priv->comment = (g_free (self->priv->comment), NULL)), __temp7);
	index = NULL;
	while ((index = g_utf8_strchr (result->str, -1, '\t')) != NULL) {
		g_string_erase (result, g_utf8_pointer_to_offset (result->str, index), 1);
	}
	__temp8 = NULL;
	__temp9 = NULL;
	return (__temp9 = (__temp8 = result->str, (__temp8 == NULL ? NULL : g_strdup (__temp8))), (result == NULL ? NULL : (result = (g_string_free (result, TRUE), NULL))), __temp9);
	(result == NULL ? NULL : (result = (g_string_free (result, TRUE), NULL)));
}


static void vala_parser_class_init (ValaParserClass * klass)
{
	vala_parser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaParserPrivate));
	G_OBJECT_CLASS (klass)->dispose = vala_parser_dispose;
	VALA_CODE_VISITOR_CLASS (klass)->visit_source_file = vala_parser_real_visit_source_file;
}


static void vala_parser_init (ValaParser * self)
{
	self->priv = VALA_PARSER_GET_PRIVATE (self);
}


static void vala_parser_dispose (GObject * obj)
{
	ValaParser * self;
	ValaParserClass * klass;
	GObjectClass * parent_class;
	self = VALA_PARSER (obj);
	(self->priv->comment = (g_free (self->priv->comment), NULL));
	(self->priv->_file_comment = (g_free (self->priv->_file_comment), NULL));
	klass = VALA_PARSER_CLASS (g_type_class_peek (VALA_TYPE_PARSER));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_parser_get_type ()
{
	static GType vala_parser_type_id = 0;
	if (G_UNLIKELY (vala_parser_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaParser), 0, (GInstanceInitFunc) vala_parser_init };
		vala_parser_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaParser", &g_define_type_info, 0);
	}
	return vala_parser_type_id;
}




