/* valamemorymanager.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <rasa@gmx.ch>
 */

#ifndef __VALAMEMORYMANAGER_H__
#define __VALAMEMORYMANAGER_H__
typedef struct _ValaMemoryManager ValaMemoryManager;
typedef struct _ValaMemoryManagerClass ValaMemoryManagerClass;
typedef struct _ValaMemoryManagerPrivate ValaMemoryManagerPrivate;

#include <glib.h>
#include <glib-object.h>
#include <vala/valacodevisitor.h>
#include <vala/valacodecontext.h>
#include <vala/valaexpression.h>
#include <vala/valasourcefile.h>
#include <vala/valanamespace.h>
#include <vala/valaclass.h>
#include <vala/valastruct.h>
#include <vala/valainterface.h>
#include <vala/valafield.h>
#include <vala/valamethod.h>
#include <vala/valacreationmethod.h>
#include <vala/valaproperty.h>
#include <vala/valapropertyaccessor.h>
#include <vala/valaconstructor.h>
#include <vala/valadestructor.h>
#include <vala/valanamedargument.h>
#include <vala/valavariabledeclarator.h>
#include <vala/valaexpressionstatement.h>
#include <vala/valareturnstatement.h>
#include <vala/valamemberaccess.h>
#include <vala/valainvocationexpression.h>
#include <vala/valabinaryexpression.h>
#include <vala/valaassignment.h>

G_BEGIN_DECLS


#define VALA_TYPE_MEMORY_MANAGER (vala_memory_manager_get_type ())
#define VALA_MEMORY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMORY_MANAGER, ValaMemoryManager))
#define VALA_MEMORY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMORY_MANAGER, ValaMemoryManagerClass))
#define VALA_IS_MEMORY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMORY_MANAGER))
#define VALA_IS_MEMORY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMORY_MANAGER))
#define VALA_MEMORY_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMORY_MANAGER, ValaMemoryManagerClass))


/**
 * Code visitor analyzing memory usage. The memory manager finds leaked and
 * copied references.
 */
struct _ValaMemoryManager {
	ValaCodeVisitor parent;
	ValaMemoryManagerPrivate * priv;
};
struct _ValaMemoryManagerClass {
	ValaCodeVisitorClass parent;
};

void vala_memory_manager_analyze (ValaMemoryManager* self, ValaCodeContext* context);
GType vala_memory_manager_get_type ();

G_END_DECLS

#endif
