/* valaflagsvalue.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALAFLAGSVALUE_H__
#define __VALAFLAGSVALUE_H__
typedef struct _ValaFlagsValuePrivate ValaFlagsValuePrivate;

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_FLAGS_VALUE (vala_flags_value_get_type ())
#define VALA_FLAGS_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FLAGS_VALUE, ValaFlagsValue))
#define VALA_FLAGS_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FLAGS_VALUE, ValaFlagsValueClass))
#define VALA_IS_FLAGS_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FLAGS_VALUE))
#define VALA_IS_FLAGS_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FLAGS_VALUE))
#define VALA_FLAGS_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FLAGS_VALUE, ValaFlagsValueClass))


/**
 * Represents a flags member in the source code.
 */
struct _ValaFlagsValue {
	ValaCodeNode parent;
	ValaFlagsValuePrivate * priv;
};
struct _ValaFlagsValueClass {
	ValaCodeNodeClass parent;
};

ValaFlagsValue* vala_flags_value_new (const char* _name);
ValaFlagsValue* vala_flags_value_new_with_value (const char* _name, ValaExpression* _value);
char* vala_flags_value_get_cname (ValaFlagsValue* self);
char* vala_flags_value_get_name (ValaFlagsValue* self);
void vala_flags_value_set_name (ValaFlagsValue* self, const char* value);
ValaExpression* vala_flags_value_get_value (ValaFlagsValue* self);
void vala_flags_value_set_value (ValaFlagsValue* self, ValaExpression* value);
GType vala_flags_value_get_type ();

G_END_DECLS

#endif
