/* valaelementaccess.vala
 *
 * Copyright (C) 2006-2007  Raffaele Sandrini, Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Raffaele Sandrini <rasa@gmx.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valaelementaccess.h"
#include <vala/valaelementaccess.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>

struct _ValaElementAccessPrivate {
	ValaExpression* _container;
	GList* indices;
};
#define VALA_ELEMENT_ACCESS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ELEMENT_ACCESS, ValaElementAccessPrivate))
enum  {
	VALA_ELEMENT_ACCESS_DUMMY_PROPERTY,
	VALA_ELEMENT_ACCESS_CONTAINER
};
static void vala_element_access_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_element_access_parent_class = NULL;
static void vala_element_access_dispose (GObject * obj);


void vala_element_access_append_index (ValaElementAccess* self, ValaExpression* index)
{
	g_return_if_fail (VALA_IS_ELEMENT_ACCESS (self));
	g_return_if_fail (VALA_IS_EXPRESSION (index));
	self->priv->indices = g_list_append (self->priv->indices, g_object_ref (index));
}


GList* vala_element_access_get_indices (ValaElementAccess* self)
{
	g_return_val_if_fail (VALA_IS_ELEMENT_ACCESS (self), NULL);
	return g_list_copy (self->priv->indices);
}


ValaElementAccess* vala_element_access_new (ValaExpression* _container, ValaSourceReference* source)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaElementAccess * self;
	g_return_val_if_fail (_container == NULL || VALA_IS_EXPRESSION (_container), NULL);
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	(__params_it->name = "container", g_value_init (&__params_it->value, VALA_TYPE_EXPRESSION), g_value_set_object (&__params_it->value, _container), __params_it++);
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source), __params_it++);
	self = g_object_newv (VALA_TYPE_ELEMENT_ACCESS, __params_it - __params, __params);
	return self;
}


static void vala_element_access_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaElementAccess * self;
	self = VALA_ELEMENT_ACCESS (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_node_accept (VALA_CODE_NODE (vala_element_access_get_container (self)), visitor);
	{
		GList* __temp1;
		GList* e_it;
		__temp1 = NULL;
		__temp1 = self->priv->indices;
		for (e_it = __temp1; e_it != NULL; e_it = e_it->next) {
			ValaExpression* e;
			e = e_it->data;
			{
				vala_code_node_accept (VALA_CODE_NODE (e), visitor);
			}
		}
	}
	vala_code_visitor_visit_element_access (visitor, self);
}


ValaExpression* vala_element_access_get_container (ValaElementAccess* self)
{
	g_return_val_if_fail (VALA_IS_ELEMENT_ACCESS (self), NULL);
	return self->priv->_container;
}


void vala_element_access_set_container (ValaElementAccess* self, ValaExpression* value)
{
	ValaExpression* __temp3;
	g_return_if_fail (VALA_IS_ELEMENT_ACCESS (self));
	__temp3 = NULL;
	self->priv->_container = (__temp3 = g_object_ref (value), (self->priv->_container == NULL ? NULL : (self->priv->_container = (g_object_unref (self->priv->_container), NULL))), __temp3);
}


static void vala_element_access_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaElementAccess * self;
	self = VALA_ELEMENT_ACCESS (object);
	switch (property_id) {
		case VALA_ELEMENT_ACCESS_CONTAINER:
		g_value_set_object (value, vala_element_access_get_container (self));
		break;
	}
}


static void vala_element_access_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaElementAccess * self;
	self = VALA_ELEMENT_ACCESS (object);
	switch (property_id) {
		case VALA_ELEMENT_ACCESS_CONTAINER:
		vala_element_access_set_container (self, g_value_get_object (value));
		break;
	}
}


static void vala_element_access_class_init (ValaElementAccessClass * klass)
{
	vala_element_access_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaElementAccessPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_element_access_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_element_access_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_element_access_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_element_access_real_accept;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_ELEMENT_ACCESS_CONTAINER, g_param_spec_object ("container", "foo", "bar", VALA_TYPE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_element_access_init (ValaElementAccess * self)
{
	self->priv = VALA_ELEMENT_ACCESS_GET_PRIVATE (self);
}


static void vala_element_access_dispose (GObject * obj)
{
	ValaElementAccess * self;
	ValaElementAccessClass * klass;
	GObjectClass * parent_class;
	self = VALA_ELEMENT_ACCESS (obj);
	(self->priv->_container == NULL ? NULL : (self->priv->_container = (g_object_unref (self->priv->_container), NULL)));
	(self->priv->indices == NULL ? NULL : (self->priv->indices = (g_list_foreach (self->priv->indices, (GFunc) g_object_unref, NULL), g_list_free (self->priv->indices), NULL)));
	klass = VALA_ELEMENT_ACCESS_CLASS (g_type_class_peek (VALA_TYPE_ELEMENT_ACCESS));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_element_access_get_type ()
{
	static GType vala_element_access_type_id = 0;
	if (G_UNLIKELY (vala_element_access_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaElementAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_element_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaElementAccess), 0, (GInstanceInitFunc) vala_element_access_init };
		vala_element_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaElementAccess", &g_define_type_info, 0);
	}
	return vala_element_access_type_id;
}




