/* valaarray.vala
 *
 * Copyright (C) 2006-2007  Raffaele Sandrini, Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Raffaele Sandrini <rasa@gmx.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valaarray.h"
#include <vala/valatypeparameter.h>
#include <vala/valaarraylengthfield.h>
#include <vala/valaarrayresizemethod.h>
#include <vala/valasourcereference.h>
#include <vala/valaarray.h>
#include <vala/valareport.h>
#include <vala/valasymbol.h>

struct _ValaArrayPrivate {
	ValaDataType* _element_type;
	ValaTypeParameter* _element_type_parameter;
	gint _rank;
	char* cname;
	ValaArrayLengthField* length_field;
	ValaArrayResizeMethod* resize_method;
};
#define VALA_ARRAY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ARRAY, ValaArrayPrivate))
enum  {
	VALA_ARRAY_DUMMY_PROPERTY,
	VALA_ARRAY_ELEMENT_TYPE,
	VALA_ARRAY_ELEMENT_TYPE_PARAMETER,
	VALA_ARRAY_RANK
};
static char* vala_array_real_get_cname (ValaDataType* base, gboolean const_type);
static gboolean vala_array_real_is_reference_type (ValaDataType* base);
static char* vala_array_real_get_upper_case_cname (ValaDataType* base, const char* infix);
static char* vala_array_real_get_lower_case_cname (ValaDataType* base, const char* infix);
static char* vala_array_real_get_free_function (ValaDataType* base);
static GList* vala_array_real_get_cheader_filenames (ValaDataType* base);
static char* vala_array_real_get_marshaller_type_name (ValaDataType* base);
static char* vala_array_real_get_get_value_function (ValaDataType* base);
static char* vala_array_real_get_set_value_function (ValaDataType* base);
static GObject * vala_array_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer vala_array_parent_class = NULL;
static void vala_array_dispose (GObject * obj);


ValaArray* vala_array_new (ValaDataType* _element_type, gint _rank, ValaSourceReference* _source_reference)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaArray * self;
	g_return_val_if_fail (VALA_IS_DATA_TYPE (_element_type), NULL);
	g_return_val_if_fail (VALA_IS_SOURCE_REFERENCE (_source_reference), NULL);
	__params = g_new0 (GParameter, 3);
	__params_it = __params;
	(__params_it->name = "rank", g_value_init (&__params_it->value, G_TYPE_INT), g_value_set_int (&__params_it->value, _rank), __params_it++);
	(__params_it->name = "element-type", g_value_init (&__params_it->value, VALA_TYPE_DATA_TYPE), g_value_set_object (&__params_it->value, _element_type), __params_it++);
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, _source_reference), __params_it++);
	self = g_object_newv (VALA_TYPE_ARRAY, __params_it - __params, __params);
	return self;
}


ValaArray* vala_array_new_with_type_parameter (ValaTypeParameter* _element_type_parameter, gint _rank, ValaSourceReference* _source_reference)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaArray * self;
	g_return_val_if_fail (VALA_IS_TYPE_PARAMETER (_element_type_parameter), NULL);
	g_return_val_if_fail (VALA_IS_SOURCE_REFERENCE (_source_reference), NULL);
	__params = g_new0 (GParameter, 3);
	__params_it = __params;
	(__params_it->name = "rank", g_value_init (&__params_it->value, G_TYPE_INT), g_value_set_int (&__params_it->value, _rank), __params_it++);
	(__params_it->name = "element-type-parameter", g_value_init (&__params_it->value, VALA_TYPE_TYPE_PARAMETER), g_value_set_object (&__params_it->value, _element_type_parameter), __params_it++);
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, _source_reference), __params_it++);
	self = g_object_newv (VALA_TYPE_ARRAY, __params_it - __params, __params);
	return self;
}


/**
 * Returns the name of this data type as it is used in C code.
 *
 * @return the name to be used in C code
 */
static char* vala_array_real_get_cname (ValaDataType* base, gboolean const_type)
{
	ValaArray * self;
	const char* __temp4;
	self = VALA_ARRAY (base);
	if (self->priv->cname == NULL) {
		if (vala_array_get_element_type (self) != NULL) {
			if (vala_data_type_is_reference_type (vala_array_get_element_type (self))) {
				char* __temp1;
				char* __temp0;
				__temp1 = NULL;
				__temp0 = NULL;
				self->priv->cname = (__temp1 = g_strdup_printf ("%s*", (__temp0 = vala_data_type_get_cname (vala_array_get_element_type (self), FALSE))), (self->priv->cname = (g_free (self->priv->cname), NULL)), __temp1);
				(__temp0 = (g_free (__temp0), NULL));
			} else {
				char* __temp2;
				__temp2 = NULL;
				self->priv->cname = (__temp2 = vala_data_type_get_cname (vala_array_get_element_type (self), FALSE), (self->priv->cname = (g_free (self->priv->cname), NULL)), __temp2);
			}
		} else {
			char* __temp3;
			__temp3 = NULL;
			self->priv->cname = (__temp3 = g_strdup ("gpointer"), (self->priv->cname = (g_free (self->priv->cname), NULL)), __temp3);
		}
	}
	__temp4 = NULL;
	return (__temp4 = self->priv->cname, (__temp4 == NULL ? NULL : g_strdup (__temp4)));
}


/**
 * Checks whether this data type has value or reference type semantics.
 *
 * @return true if this data type has reference type semantics
 */
static gboolean vala_array_real_is_reference_type (ValaDataType* base)
{
	ValaArray * self;
	self = VALA_ARRAY (base);
	return TRUE;
}


/**
 * Returns the C name of this data type in upper case. Words are
 * separated by underscores. The upper case C name of the namespace is
 * prefix of the result.
 *
 * @param infix a string to be placed between namespace and data type
 *              name or null
 * @return      the upper case name to be used in C code
 */
static char* vala_array_real_get_upper_case_cname (ValaDataType* base, const char* infix)
{
	ValaArray * self;
	self = VALA_ARRAY (base);
	return NULL;
}


/**
 * Returns the C name of this data type in lower case. Words are
 * separated by underscores. The lower case C name of the namespace is
 * prefix of the result.
 *
 * @param infix a string to be placed between namespace and data type
 *              name or null
 * @return      the lower case name to be used in C code
 */
static char* vala_array_real_get_lower_case_cname (ValaDataType* base, const char* infix)
{
	ValaArray * self;
	self = VALA_ARRAY (base);
	return NULL;
}


/**
 * Returns the C function name that frees instances of this data type.
 * This is only valid for data types with reference type semantics that
 * do not support reference counting. The specified C function must
 * accept one argument pointing to the instance to be freed.
 *
 * @return the name of the C function or null if this data type is not a
 *         reference type or if it supports reference counting
 */
static char* vala_array_real_get_free_function (ValaDataType* base)
{
	ValaArray * self;
	self = VALA_ARRAY (base);
	return g_strdup ("g_free");
}


/**
 * Returns a list of C header filenames users of this data type must
 * include.
 *
 * @return list of C header filenames for this data type
 */
static GList* vala_array_real_get_cheader_filenames (ValaDataType* base)
{
	ValaArray * self;
	self = VALA_ARRAY (base);
	if (vala_array_get_element_type (self) != NULL) {
		return vala_data_type_get_cheader_filenames (vala_array_get_element_type (self));
	} else {
		return NULL;
	}
}


static char* vala_array_real_get_marshaller_type_name (ValaDataType* base)
{
	ValaArray * self;
	self = VALA_ARRAY (base);
	return g_strdup ("POINTER");
}


static char* vala_array_real_get_get_value_function (ValaDataType* base)
{
	ValaArray * self;
	self = VALA_ARRAY (base);
	return g_strdup ("g_value_get_pointer");
}


static char* vala_array_real_get_set_value_function (ValaDataType* base)
{
	ValaArray * self;
	self = VALA_ARRAY (base);
	return g_strdup ("g_value_set_pointer");
}


ValaArrayLengthField* vala_array_get_length_field (ValaArray* self)
{
	ValaArrayLengthField* __temp15;
	g_return_val_if_fail (VALA_IS_ARRAY (self), NULL);
	__temp15 = NULL;
	return (__temp15 = self->priv->length_field, (__temp15 == NULL ? NULL : g_object_ref (__temp15)));
}


ValaArrayResizeMethod* vala_array_get_resize_method (ValaArray* self)
{
	ValaArrayResizeMethod* __temp17;
	g_return_val_if_fail (VALA_IS_ARRAY (self), NULL);
	__temp17 = NULL;
	return (__temp17 = self->priv->resize_method, (__temp17 == NULL ? NULL : g_object_ref (__temp17)));
}


ValaDataType* vala_array_get_element_type (ValaArray* self)
{
	g_return_val_if_fail (VALA_IS_ARRAY (self), NULL);
	return self->priv->_element_type;
}


void vala_array_set_element_type (ValaArray* self, ValaDataType* value)
{
	ValaDataType* __temp21;
	ValaDataType* __temp20;
	g_return_if_fail (VALA_IS_ARRAY (self));
	__temp21 = NULL;
	__temp20 = NULL;
	self->priv->_element_type = (__temp21 = (__temp20 = value, (__temp20 == NULL ? NULL : g_object_ref (__temp20))), (self->priv->_element_type == NULL ? NULL : (self->priv->_element_type = (g_object_unref (self->priv->_element_type), NULL))), __temp21);
}


ValaTypeParameter* vala_array_get_element_type_parameter (ValaArray* self)
{
	g_return_val_if_fail (VALA_IS_ARRAY (self), NULL);
	return self->priv->_element_type_parameter;
}


void vala_array_set_element_type_parameter (ValaArray* self, ValaTypeParameter* value)
{
	ValaTypeParameter* __temp24;
	ValaTypeParameter* __temp23;
	g_return_if_fail (VALA_IS_ARRAY (self));
	__temp24 = NULL;
	__temp23 = NULL;
	self->priv->_element_type_parameter = (__temp24 = (__temp23 = value, (__temp23 == NULL ? NULL : g_object_ref (__temp23))), (self->priv->_element_type_parameter == NULL ? NULL : (self->priv->_element_type_parameter = (g_object_unref (self->priv->_element_type_parameter), NULL))), __temp24);
}


gint vala_array_get_rank (ValaArray* self)
{
	g_return_val_if_fail (VALA_IS_ARRAY (self), 0);
	return self->priv->_rank;
}


void vala_array_set_rank (ValaArray* self, gint value)
{
	g_return_if_fail (VALA_IS_ARRAY (self));
	self->priv->_rank = value;
}


static GObject * vala_array_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties)
{
	GObject * obj;
	ValaArrayClass * klass;
	GObjectClass * parent_class;
	ValaArray * self;
	klass = VALA_ARRAY_CLASS (g_type_class_peek (VALA_TYPE_ARRAY));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = VALA_ARRAY (obj);
	{
		gint i;
		char* __temp29;
		ValaArrayLengthField* __temp30;
		ValaSymbol* __temp31;
		ValaArrayResizeMethod* __temp32;
		ValaSymbol* __temp33;
		/* FIXME: this implementation reveals compiler bugs 
		string commas = "";
		int i = rank - 1;
		
		while (i > 0) {
		string += ",";
		i--;
		}
		
		name = "%s[%s]".printf (element_type.name, commas); */
		if (vala_array_get_rank (self) < 1) {
			vala_report_error (NULL, "internal: attempt to create an array with rank smaller than 1");
		}
		i = vala_array_get_rank (self) - 1;
		if (vala_array_get_element_type (self) != NULL) {
			char* __temp26;
			__temp26 = NULL;
			(vala_data_type_set_name (VALA_DATA_TYPE (self), (__temp26 = g_strdup_printf ("%s[", vala_data_type_get_name (vala_array_get_element_type (self))))), vala_data_type_get_name (VALA_DATA_TYPE (self)));
			(__temp26 = (g_free (__temp26), NULL));
		} else {
			char* __temp27;
			__temp27 = NULL;
			(vala_data_type_set_name (VALA_DATA_TYPE (self), (__temp27 = g_strdup_printf ("%s[", vala_type_parameter_get_name (vala_array_get_element_type_parameter (self))))), vala_data_type_get_name (VALA_DATA_TYPE (self)));
			(__temp27 = (g_free (__temp27), NULL));
		}
		while (i > 0) {
			char* __temp28;
			__temp28 = NULL;
			(vala_data_type_set_name (VALA_DATA_TYPE (self), (__temp28 = g_strdup_printf ("%s,", vala_data_type_get_name (VALA_DATA_TYPE (self))))), vala_data_type_get_name (VALA_DATA_TYPE (self)));
			(__temp28 = (g_free (__temp28), NULL));
			i--;
		}
		__temp29 = NULL;
		(vala_data_type_set_name (VALA_DATA_TYPE (self), (__temp29 = g_strdup_printf ("%s]", vala_data_type_get_name (VALA_DATA_TYPE (self))))), vala_data_type_get_name (VALA_DATA_TYPE (self)));
		(__temp29 = (g_free (__temp29), NULL));
		__temp30 = NULL;
		self->priv->length_field = (__temp30 = vala_array_length_field_new (vala_code_node_get_source_reference (VALA_CODE_NODE (self))), (self->priv->length_field == NULL ? NULL : (self->priv->length_field = (g_object_unref (self->priv->length_field), NULL))), __temp30);
		__temp31 = NULL;
		(vala_code_node_set_symbol (VALA_CODE_NODE (self->priv->length_field), (__temp31 = vala_symbol_new (VALA_CODE_NODE (self->priv->length_field)))), vala_code_node_get_symbol (VALA_CODE_NODE (self->priv->length_field)));
		(__temp31 == NULL ? NULL : (__temp31 = (g_object_unref (__temp31), NULL)));
		__temp32 = NULL;
		self->priv->resize_method = (__temp32 = vala_array_resize_method_new (vala_code_node_get_source_reference (VALA_CODE_NODE (self))), (self->priv->resize_method == NULL ? NULL : (self->priv->resize_method = (g_object_unref (self->priv->resize_method), NULL))), __temp32);
		__temp33 = NULL;
		(vala_code_node_set_symbol (VALA_CODE_NODE (self->priv->resize_method), (__temp33 = vala_symbol_new (VALA_CODE_NODE (self->priv->resize_method)))), vala_code_node_get_symbol (VALA_CODE_NODE (self->priv->resize_method)));
		(__temp33 == NULL ? NULL : (__temp33 = (g_object_unref (__temp33), NULL)));
	}
	return obj;
}


static void vala_array_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaArray * self;
	self = VALA_ARRAY (object);
	switch (property_id) {
		case VALA_ARRAY_ELEMENT_TYPE:
		g_value_set_object (value, vala_array_get_element_type (self));
		break;
		case VALA_ARRAY_ELEMENT_TYPE_PARAMETER:
		g_value_set_object (value, vala_array_get_element_type_parameter (self));
		break;
		case VALA_ARRAY_RANK:
		g_value_set_int (value, vala_array_get_rank (self));
		break;
	}
}


static void vala_array_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaArray * self;
	self = VALA_ARRAY (object);
	switch (property_id) {
		case VALA_ARRAY_ELEMENT_TYPE:
		vala_array_set_element_type (self, g_value_get_object (value));
		break;
		case VALA_ARRAY_ELEMENT_TYPE_PARAMETER:
		vala_array_set_element_type_parameter (self, g_value_get_object (value));
		break;
		case VALA_ARRAY_RANK:
		vala_array_set_rank (self, g_value_get_int (value));
		break;
	}
}


static void vala_array_class_init (ValaArrayClass * klass)
{
	vala_array_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaArrayPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_array_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_array_set_property;
	G_OBJECT_CLASS (klass)->constructor = vala_array_constructor;
	G_OBJECT_CLASS (klass)->dispose = vala_array_dispose;
	VALA_DATA_TYPE_CLASS (klass)->get_cname = vala_array_real_get_cname;
	VALA_DATA_TYPE_CLASS (klass)->is_reference_type = vala_array_real_is_reference_type;
	VALA_DATA_TYPE_CLASS (klass)->get_upper_case_cname = vala_array_real_get_upper_case_cname;
	VALA_DATA_TYPE_CLASS (klass)->get_lower_case_cname = vala_array_real_get_lower_case_cname;
	VALA_DATA_TYPE_CLASS (klass)->get_free_function = vala_array_real_get_free_function;
	VALA_DATA_TYPE_CLASS (klass)->get_cheader_filenames = vala_array_real_get_cheader_filenames;
	VALA_DATA_TYPE_CLASS (klass)->get_marshaller_type_name = vala_array_real_get_marshaller_type_name;
	VALA_DATA_TYPE_CLASS (klass)->get_get_value_function = vala_array_real_get_get_value_function;
	VALA_DATA_TYPE_CLASS (klass)->get_set_value_function = vala_array_real_get_set_value_function;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_ARRAY_ELEMENT_TYPE, g_param_spec_object ("element-type", "foo", "bar", VALA_TYPE_DATA_TYPE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_ARRAY_ELEMENT_TYPE_PARAMETER, g_param_spec_object ("element-type-parameter", "foo", "bar", VALA_TYPE_TYPE_PARAMETER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_ARRAY_RANK, g_param_spec_int ("rank", "foo", "bar", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_array_init (ValaArray * self)
{
	self->priv = VALA_ARRAY_GET_PRIVATE (self);
}


static void vala_array_dispose (GObject * obj)
{
	ValaArray * self;
	ValaArrayClass * klass;
	GObjectClass * parent_class;
	self = VALA_ARRAY (obj);
	(self->priv->_element_type == NULL ? NULL : (self->priv->_element_type = (g_object_unref (self->priv->_element_type), NULL)));
	(self->priv->_element_type_parameter == NULL ? NULL : (self->priv->_element_type_parameter = (g_object_unref (self->priv->_element_type_parameter), NULL)));
	(self->priv->cname = (g_free (self->priv->cname), NULL));
	(self->priv->length_field == NULL ? NULL : (self->priv->length_field = (g_object_unref (self->priv->length_field), NULL)));
	(self->priv->resize_method == NULL ? NULL : (self->priv->resize_method = (g_object_unref (self->priv->resize_method), NULL)));
	klass = VALA_ARRAY_CLASS (g_type_class_peek (VALA_TYPE_ARRAY));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_array_get_type ()
{
	static GType vala_array_type_id = 0;
	if (G_UNLIKELY (vala_array_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaArrayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_array_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaArray), 0, (GInstanceInitFunc) vala_array_init };
		vala_array_type_id = g_type_register_static (VALA_TYPE_DATA_TYPE, "ValaArray", &g_define_type_info, 0);
	}
	return vala_array_type_id;
}




