/* valaccodecompiler.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valaccodecompiler.h"
#include <stdlib.h>
#include <string.h>
#include <vala/valareport.h>
#include <vala/valasourcereference.h>
#include <vala/valasourcefile.h>
#include <glib/gstdio.h>

enum  {
	VALA_CCODE_COMPILER_DUMMY_PROPERTY
};
static gpointer vala_ccode_compiler_parent_class = NULL;


ValaCCodeCompiler* vala_ccode_compiler_new ()
{
	GParameter * __params;
	GParameter * __params_it;
	ValaCCodeCompiler * self;
	__params = g_new0 (GParameter, 0);
	__params_it = __params;
	self = g_object_newv (VALA_TYPE_CCODE_COMPILER, __params_it - __params, __params);
	return self;
}


/**
 * Compile generated C code to object code and optionally link object
 * files.
 *
 * @param context a code context
 */
void vala_ccode_compiler_compile (ValaCCodeCompiler* self, ValaCodeContext* context)
{
	char* pc;
	char* pkgflags;
	gint exit_status;
	GError* err;
	char* cmdline;
	char* __temp7;
	char* __temp6;
	char* __temp13;
	char* __temp12;
	GList* source_files;
	gboolean success;
	g_return_if_fail (VALA_IS_CCODE_COMPILER (self));
	g_return_if_fail (VALA_IS_CODE_CONTEXT (context));
	pc = g_strdup ("pkg-config --cflags");
	if (!vala_code_context_get_compile_only (context)) {
		char* __temp0;
		__temp0 = NULL;
		pc = (__temp0 = g_strconcat (pc, (" --libs"), NULL), (pc = (g_free (pc), NULL)), __temp0);
	}
	{
		GList* __temp3;
		GList* pkg_it;
		__temp3 = NULL;
		__temp3 = vala_code_context_get_packages (context);
		for (pkg_it = __temp3; pkg_it != NULL; pkg_it = pkg_it->next) {
			char* pkg;
			pkg = pkg_it->data;
			{
				char* __temp2;
				char* __temp1;
				__temp2 = NULL;
				__temp1 = NULL;
				pc = (__temp2 = g_strconcat (pc, (__temp1 = (g_strconcat (" ", pkg, NULL))), NULL), (pc = (g_free (pc), NULL)), __temp2);
				(__temp1 = (g_free (__temp1), NULL));
			}
		}
		(__temp3 == NULL ? NULL : (__temp3 = (g_list_free (__temp3), NULL)));
	}
	pkgflags = NULL;
	exit_status = 0;
	err = NULL;
	if (!g_spawn_command_line_sync (pc, &pkgflags, NULL, &exit_status, &err)) {
		vala_report_error (NULL, err->message);
		(pc = (g_free (pc), NULL));
		(pkgflags = (g_free (pkgflags), NULL));
		(err == NULL ? NULL : (err = (g_error_free (err), NULL)));
		return;
	} else {
		if (exit_status != 0) {
			char* __temp4;
			__temp4 = NULL;
			vala_report_error (NULL, (__temp4 = g_strdup_printf ("pkg-config exited with status %d", exit_status)));
			(__temp4 = (g_free (__temp4), NULL));
			(pc = (g_free (pc), NULL));
			(pkgflags = (g_free (pkgflags), NULL));
			(err == NULL ? NULL : (err = (g_error_free (err), NULL)));
			return;
		}
	}
	/* TODO compile the C code files in parallel*/
	cmdline = g_strdup ("cc");
	if (vala_code_context_get_debug (context)) {
		char* __temp5;
		__temp5 = NULL;
		cmdline = (__temp5 = g_strconcat (cmdline, (" -g"), NULL), (cmdline = (g_free (cmdline), NULL)), __temp5);
	}
	__temp7 = NULL;
	__temp6 = NULL;
	cmdline = (__temp7 = g_strconcat (cmdline, (__temp6 = (g_strdup_printf (" -O%d", vala_code_context_get_optlevel (context)))), NULL), (cmdline = (g_free (cmdline), NULL)), __temp7);
	(__temp6 = (g_free (__temp6), NULL));
	if (vala_code_context_get_compile_only (context)) {
		char* __temp8;
		__temp8 = NULL;
		cmdline = (__temp8 = g_strconcat (cmdline, (" -c"), NULL), (cmdline = (g_free (cmdline), NULL)), __temp8);
	} else {
		if (vala_code_context_get_output (context) != NULL) {
			char* __temp11;
			char* __temp10;
			char* __temp9;
			__temp11 = NULL;
			__temp10 = NULL;
			__temp9 = NULL;
			cmdline = (__temp11 = g_strconcat (cmdline, (__temp10 = (g_strconcat (" -o ", (__temp9 = g_shell_quote (vala_code_context_get_output (context))), NULL))), NULL), (cmdline = (g_free (cmdline), NULL)), __temp11);
			(__temp10 = (g_free (__temp10), NULL));
			(__temp9 = (g_free (__temp9), NULL));
		}
	}
	__temp13 = NULL;
	__temp12 = NULL;
	cmdline = (__temp13 = g_strconcat (cmdline, (__temp12 = (g_strconcat (" ", pkgflags, NULL))), NULL), (cmdline = (g_free (cmdline), NULL)), __temp13);
	(__temp12 = (g_free (__temp12), NULL));
	/* we're only interested in non-pkg source files */
	source_files = vala_code_context_get_source_files (context);
	{
		GList* __temp18;
		GList* file_it;
		__temp18 = NULL;
		__temp18 = source_files;
		for (file_it = __temp18; file_it != NULL; file_it = file_it->next) {
			ValaSourceFile* file;
			file = file_it->data;
			{
				if (!vala_source_file_get_pkg (file)) {
					char* __temp17;
					char* __temp16;
					char* __temp15;
					char* __temp14;
					__temp17 = NULL;
					__temp16 = NULL;
					__temp15 = NULL;
					__temp14 = NULL;
					cmdline = (__temp17 = g_strconcat (cmdline, (__temp16 = (g_strconcat (" ", (__temp15 = g_shell_quote ((__temp14 = vala_source_file_get_csource_filename (file)))), NULL))), NULL), (cmdline = (g_free (cmdline), NULL)), __temp17);
					(__temp16 = (g_free (__temp16), NULL));
					(__temp15 = (g_free (__temp15), NULL));
					(__temp14 = (g_free (__temp14), NULL));
				}
			}
		}
	}
	success = g_spawn_command_line_sync (cmdline, NULL, NULL, &exit_status, &err);
	{
		GList* __temp21;
		GList* file_it;
		__temp21 = NULL;
		__temp21 = source_files;
		for (file_it = __temp21; file_it != NULL; file_it = file_it->next) {
			ValaSourceFile* file;
			file = file_it->data;
			{
				/* remove generated C source and header files */
				if (!vala_source_file_get_pkg (file)) {
					char* __temp19;
					char* __temp20;
					__temp19 = NULL;
					g_unlink ((__temp19 = vala_source_file_get_csource_filename (file)));
					(__temp19 = (g_free (__temp19), NULL));
					__temp20 = NULL;
					g_unlink ((__temp20 = vala_source_file_get_cheader_filename (file)));
					(__temp20 = (g_free (__temp20), NULL));
				}
			}
		}
	}
	if (!success) {
		vala_report_error (NULL, err->message);
	} else {
		if (exit_status != 0) {
			char* __temp22;
			__temp22 = NULL;
			vala_report_error (NULL, (__temp22 = g_strdup_printf ("cc exited with status %d", exit_status)));
			(__temp22 = (g_free (__temp22), NULL));
		}
	}
	(pc = (g_free (pc), NULL));
	(pkgflags = (g_free (pkgflags), NULL));
	(err == NULL ? NULL : (err = (g_error_free (err), NULL)));
	(cmdline = (g_free (cmdline), NULL));
	(source_files == NULL ? NULL : (source_files = (g_list_free (source_files), NULL)));
}


static void vala_ccode_compiler_class_init (ValaCCodeCompilerClass * klass)
{
	vala_ccode_compiler_parent_class = g_type_class_peek_parent (klass);
}


static void vala_ccode_compiler_init (ValaCCodeCompiler * self)
{
}


GType vala_ccode_compiler_get_type ()
{
	static GType vala_ccode_compiler_type_id = 0;
	if (G_UNLIKELY (vala_ccode_compiler_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeCompilerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_compiler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeCompiler), 0, (GInstanceInitFunc) vala_ccode_compiler_init };
		vala_ccode_compiler_type_id = g_type_register_static (G_TYPE_OBJECT, "ValaCCodeCompiler", &g_define_type_info, 0);
	}
	return vala_ccode_compiler_type_id;
}




