/* valaswitchstatement.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valaswitchstatement.h"
#include <vala/valaexpression.h>
#include <vala/valasourcereference.h>
#include <vala/valaswitchstatement.h>
#include <vala/valaswitchsection.h>
#include <vala/valacodevisitor.h>

struct _ValaSwitchStatementPrivate {
	ValaExpression* _expression;
	GList* sections;
};
#define VALA_SWITCH_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SWITCH_STATEMENT, ValaSwitchStatementPrivate))
enum  {
	VALA_SWITCH_STATEMENT_DUMMY_PROPERTY,
	VALA_SWITCH_STATEMENT_EXPRESSION,
};
static void vala_switch_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_switch_statement_real_replace (ValaCodeNode* base, ValaCodeNode* old_node, ValaCodeNode* new_node);
static gpointer vala_switch_statement_parent_class = NULL;
static void vala_switch_statement_dispose (GObject * obj);


/**
 * Creates a new switch statement.
 *
 * @param expr   switch expression
 * @param source reference to source code
 * @return       newly created switch statement
 */
ValaSwitchStatement* vala_switch_statement_new (ValaExpression* expr, ValaSourceReference* source)
{
	g_return_val_if_fail (VALA_IS_EXPRESSION (expr), NULL);
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	GParameter * __params = g_new0 (GParameter, 2);
	GParameter * __params_it = __params;
	(__params_it->name = "expression", g_value_init (&__params_it->value, VALA_TYPE_EXPRESSION), g_value_set_object (&__params_it->value, expr), __params_it++);
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source), __params_it++);
	ValaSwitchStatement * self = g_object_newv (VALA_TYPE_SWITCH_STATEMENT, __params_it - __params, __params);
	return self;
}


/**
 * Appends the specified section to the list of switch sections.
 *
 * @param section a switch section
 */
void vala_switch_statement_add_section (ValaSwitchStatement* self, ValaSwitchSection* section)
{
	g_return_if_fail (VALA_IS_SWITCH_STATEMENT (self));
	g_return_if_fail (VALA_IS_SWITCH_SECTION (section));
	self->priv->sections = g_list_append (self->priv->sections, g_object_ref (section));
}


/**
 * Returns a copy of the list of switch sections.
 *
 * @return section list
 */
GList* vala_switch_statement_get_sections (ValaSwitchStatement* self)
{
	g_return_val_if_fail (VALA_IS_SWITCH_STATEMENT (self), NULL);
	return g_list_copy (self->priv->sections);
}


static void vala_switch_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaSwitchStatement * self = VALA_SWITCH_STATEMENT (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_node_accept (VALA_CODE_NODE (vala_switch_statement_get_expression (self)), visitor);
	vala_code_visitor_visit_end_full_expression (visitor, vala_switch_statement_get_expression (self));
	{
		GList* __temp1 = NULL;
		__temp1 = self->priv->sections;
		GList* section_it;
		for (section_it = __temp1; section_it != NULL; section_it = section_it->next) {
			ValaSwitchSection* section = section_it->data;
			{
				vala_code_node_accept (VALA_CODE_NODE (section), visitor);
			}
		}
	}
	vala_code_visitor_visit_switch_statement (visitor, self);
}


static void vala_switch_statement_real_replace (ValaCodeNode* base, ValaCodeNode* old_node, ValaCodeNode* new_node)
{
	ValaSwitchStatement * self = VALA_SWITCH_STATEMENT (base);
	g_return_if_fail (VALA_IS_CODE_NODE (old_node));
	g_return_if_fail (VALA_IS_CODE_NODE (new_node));
	if (VALA_CODE_NODE (vala_switch_statement_get_expression (self)) == old_node) {
		(vala_switch_statement_set_expression (self, VALA_EXPRESSION (new_node)), vala_switch_statement_get_expression (self));
	}
}


ValaExpression* vala_switch_statement_get_expression (ValaSwitchStatement* self)
{
	g_return_val_if_fail (VALA_IS_SWITCH_STATEMENT (self), NULL);
	return self->priv->_expression;
}


void vala_switch_statement_set_expression (ValaSwitchStatement* self, ValaExpression* value)
{
	g_return_if_fail (VALA_IS_SWITCH_STATEMENT (self));
	ValaExpression* __temp3 = NULL;
	self->priv->_expression = (__temp3 = g_object_ref (value), (self->priv->_expression == NULL ? NULL : (self->priv->_expression = (g_object_unref (self->priv->_expression), NULL))), __temp3);
	(vala_code_node_set_parent_node (VALA_CODE_NODE (self->priv->_expression), VALA_CODE_NODE (self)), vala_code_node_get_parent_node (VALA_CODE_NODE (self->priv->_expression)));
}


static void vala_switch_statement_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaSwitchStatement * self = VALA_SWITCH_STATEMENT (object);
	switch (property_id) {
		case VALA_SWITCH_STATEMENT_EXPRESSION:
		g_value_set_object (value, vala_switch_statement_get_expression (self));
		break;
	}
}


static void vala_switch_statement_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaSwitchStatement * self = VALA_SWITCH_STATEMENT (object);
	switch (property_id) {
		case VALA_SWITCH_STATEMENT_EXPRESSION:
		vala_switch_statement_set_expression (self, g_value_get_object (value));
		break;
	}
}


static void vala_switch_statement_class_init (ValaSwitchStatementClass * klass)
{
	vala_switch_statement_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaSwitchStatementPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_switch_statement_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_switch_statement_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_switch_statement_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_switch_statement_real_accept;
	VALA_CODE_NODE_CLASS (klass)->replace = vala_switch_statement_real_replace;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_SWITCH_STATEMENT_EXPRESSION, g_param_spec_object ("expression", "foo", "bar", VALA_TYPE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_switch_statement_init (ValaSwitchStatement * self)
{
	self->priv = VALA_SWITCH_STATEMENT_GET_PRIVATE (self);
}


static void vala_switch_statement_dispose (GObject * obj)
{
	ValaSwitchStatement * self = VALA_SWITCH_STATEMENT (obj);
	(self->priv->_expression == NULL ? NULL : (self->priv->_expression = (g_object_unref (self->priv->_expression), NULL)));
	(self->priv->sections == NULL ? NULL : (self->priv->sections = (g_list_foreach (self->priv->sections, (GFunc) g_object_unref, NULL), g_list_free (self->priv->sections), NULL)));
	ValaSwitchStatementClass * klass;
	GObjectClass * parent_class;
	klass = VALA_SWITCH_STATEMENT_CLASS (g_type_class_peek (VALA_TYPE_SWITCH_STATEMENT));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_switch_statement_get_type ()
{
	static GType vala_switch_statement_type_id = 0;
	if (G_UNLIKELY (vala_switch_statement_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaSwitchStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_switch_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSwitchStatement), 0, (GInstanceInitFunc) vala_switch_statement_init };
		vala_switch_statement_type_id = g_type_register_static (VALA_TYPE_STATEMENT, "ValaSwitchStatement", &g_define_type_info, 0);
	}
	return vala_switch_statement_type_id;
}




