/* valastatement.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valastatement.h"

struct _ValaStatementPrivate {
};
#define VALA_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_STATEMENT, ValaStatementPrivate))
enum  {
	VALA_STATEMENT_DUMMY_PROPERTY,
};
static gint vala_statement_real_get_number_of_set_construction_parameters (ValaStatement* self);
static gpointer vala_statement_parent_class = NULL;


/**
 * Returns the number of construction parameters this statement sets in
 * maximum or -1 if this statement may not be used in the construction
 * part of a construction method.
 *
 * @return number of construction parameters set or -1
 */
static gint vala_statement_real_get_number_of_set_construction_parameters (ValaStatement* self)
{
	g_return_val_if_fail (VALA_IS_STATEMENT (self), 0);
	return -1;
}


gint vala_statement_get_number_of_set_construction_parameters (ValaStatement* self)
{
	return VALA_STATEMENT_GET_CLASS (self)->get_number_of_set_construction_parameters (self);
}


static void vala_statement_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaStatement * self = VALA_STATEMENT (object);
	switch (property_id) {
	}
}


static void vala_statement_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaStatement * self = VALA_STATEMENT (object);
	switch (property_id) {
	}
}


static void vala_statement_class_init (ValaStatementClass * klass)
{
	vala_statement_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = vala_statement_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_statement_set_property;
	VALA_STATEMENT_CLASS (klass)->get_number_of_set_construction_parameters = vala_statement_real_get_number_of_set_construction_parameters;
}


static void vala_statement_init (ValaStatement * self)
{
}


GType vala_statement_get_type ()
{
	static GType vala_statement_type_id = 0;
	if (G_UNLIKELY (vala_statement_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaStatement), 0, (GInstanceInitFunc) vala_statement_init };
		vala_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaStatement", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_statement_type_id;
}




