/* valanullliteral.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valanullliteral.h"
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>
#include <vala/valanullliteral.h>

struct _ValaNullLiteralPrivate {
};
#define VALA_NULL_LITERAL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_NULL_LITERAL, ValaNullLiteralPrivate))
enum  {
	VALA_NULL_LITERAL_DUMMY_PROPERTY,
};
static void vala_null_literal_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static char* vala_null_literal_real_to_string (ValaCodeNode* base);
static gpointer vala_null_literal_parent_class = NULL;


/**
 * Creates a new null literal.
 *
 * @param source reference to source code
 * @return       newly created null literal
 */
ValaNullLiteral* vala_null_literal_new (ValaSourceReference* source)
{
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	GParameter * __params = g_new0 (GParameter, 1);
	GParameter * __params_it = __params;
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source), __params_it++);
	ValaNullLiteral * self = g_object_newv (VALA_TYPE_NULL_LITERAL, __params_it - __params, __params);
	return self;
}


static void vala_null_literal_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaNullLiteral * self = VALA_NULL_LITERAL (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_null_literal (visitor, self);
}


static char* vala_null_literal_real_to_string (ValaCodeNode* base)
{
	ValaNullLiteral * self = VALA_NULL_LITERAL (base);
	return g_strdup ("null");
}


static void vala_null_literal_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaNullLiteral * self = VALA_NULL_LITERAL (object);
	switch (property_id) {
	}
}


static void vala_null_literal_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaNullLiteral * self = VALA_NULL_LITERAL (object);
	switch (property_id) {
	}
}


static void vala_null_literal_class_init (ValaNullLiteralClass * klass)
{
	vala_null_literal_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = vala_null_literal_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_null_literal_set_property;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_null_literal_real_accept;
	VALA_CODE_NODE_CLASS (klass)->to_string = vala_null_literal_real_to_string;
}


static void vala_null_literal_init (ValaNullLiteral * self)
{
}


GType vala_null_literal_get_type ()
{
	static GType vala_null_literal_type_id = 0;
	if (G_UNLIKELY (vala_null_literal_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaNullLiteralClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_null_literal_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaNullLiteral), 0, (GInstanceInitFunc) vala_null_literal_init };
		vala_null_literal_type_id = g_type_register_static (VALA_TYPE_LITERAL, "ValaNullLiteral", &g_define_type_info, 0);
	}
	return vala_null_literal_type_id;
}




