/* valaforeachstatement.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valaforeachstatement.h"
#include <vala/valatypereference.h>
#include <vala/valavariabledeclarator.h>
#include <vala/valaexpression.h>
#include <vala/valasourcereference.h>
#include <vala/valaforeachstatement.h>
#include <vala/valacodevisitor.h>

struct _ValaForeachStatementPrivate {
	ValaTypeReference* _type_reference;
	char* _variable_name;
	ValaStatement* _body;
	ValaVariableDeclarator* _variable_declarator;
	ValaExpression* _collection;
};
#define VALA_FOREACH_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_FOREACH_STATEMENT, ValaForeachStatementPrivate))
enum  {
	VALA_FOREACH_STATEMENT_DUMMY_PROPERTY,
	VALA_FOREACH_STATEMENT_TYPE_REFERENCE,
	VALA_FOREACH_STATEMENT_VARIABLE_NAME,
	VALA_FOREACH_STATEMENT_COLLECTION,
	VALA_FOREACH_STATEMENT_BODY,
	VALA_FOREACH_STATEMENT_VARIABLE_DECLARATOR,
};
static void vala_foreach_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_foreach_statement_real_replace (ValaCodeNode* base, ValaCodeNode* old_node, ValaCodeNode* new_node);
static gpointer vala_foreach_statement_parent_class = NULL;
static void vala_foreach_statement_dispose (GObject * obj);


/**
 * Creates a new foreach statement.
 *
 * @param type   element type
 * @param id     element variable name
 * @param col    loop body
 * @param source reference to source code
 * @return       newly created foreach statement
 */
ValaForeachStatement* vala_foreach_statement_new (ValaTypeReference* type, const char* id, ValaExpression* col, ValaStatement* _body, ValaSourceReference* source)
{
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (type), NULL);
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (col), NULL);
	g_return_val_if_fail (_body == NULL || VALA_IS_STATEMENT (_body), NULL);
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	GParameter * __params = g_new0 (GParameter, 5);
	GParameter * __params_it = __params;
	(__params_it->name = "type-reference", g_value_init (&__params_it->value, VALA_TYPE_TYPE_REFERENCE), g_value_set_object (&__params_it->value, type), __params_it++);
	(__params_it->name = "variable-name", g_value_init (&__params_it->value, G_TYPE_STRING), g_value_set_string (&__params_it->value, id), __params_it++);
	(__params_it->name = "collection", g_value_init (&__params_it->value, VALA_TYPE_EXPRESSION), g_value_set_object (&__params_it->value, col), __params_it++);
	(__params_it->name = "body", g_value_init (&__params_it->value, VALA_TYPE_STATEMENT), g_value_set_object (&__params_it->value, _body), __params_it++);
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source), __params_it++);
	ValaForeachStatement * self = g_object_newv (VALA_TYPE_FOREACH_STATEMENT, __params_it - __params, __params);
	return self;
}


static void vala_foreach_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaForeachStatement * self = VALA_FOREACH_STATEMENT (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_begin_foreach_statement (visitor, self);
	vala_code_node_accept (VALA_CODE_NODE (vala_foreach_statement_get_type_reference (self)), visitor);
	vala_code_node_accept (VALA_CODE_NODE (vala_foreach_statement_get_collection (self)), visitor);
	vala_code_node_accept (VALA_CODE_NODE (vala_foreach_statement_get_body (self)), visitor);
	vala_code_visitor_visit_end_foreach_statement (visitor, self);
}


static void vala_foreach_statement_real_replace (ValaCodeNode* base, ValaCodeNode* old_node, ValaCodeNode* new_node)
{
	ValaForeachStatement * self = VALA_FOREACH_STATEMENT (base);
	g_return_if_fail (VALA_IS_CODE_NODE (old_node));
	g_return_if_fail (VALA_IS_CODE_NODE (new_node));
	if (VALA_CODE_NODE (vala_foreach_statement_get_collection (self)) == old_node) {
		(vala_foreach_statement_set_collection (self, VALA_EXPRESSION (new_node)), vala_foreach_statement_get_collection (self));
	}
}


ValaTypeReference* vala_foreach_statement_get_type_reference (ValaForeachStatement* self)
{
	g_return_val_if_fail (VALA_IS_FOREACH_STATEMENT (self), NULL);
	return self->priv->_type_reference;
}


void vala_foreach_statement_set_type_reference (ValaForeachStatement* self, ValaTypeReference* value)
{
	g_return_if_fail (VALA_IS_FOREACH_STATEMENT (self));
	ValaTypeReference* __temp1 = NULL;
	self->priv->_type_reference = (__temp1 = g_object_ref (value), (self->priv->_type_reference == NULL ? NULL : (self->priv->_type_reference = (g_object_unref (self->priv->_type_reference), NULL))), __temp1);
}


char* vala_foreach_statement_get_variable_name (ValaForeachStatement* self)
{
	g_return_val_if_fail (VALA_IS_FOREACH_STATEMENT (self), NULL);
	return self->priv->_variable_name;
}


void vala_foreach_statement_set_variable_name (ValaForeachStatement* self, const char* value)
{
	g_return_if_fail (VALA_IS_FOREACH_STATEMENT (self));
	char* __temp3 = NULL;
	self->priv->_variable_name = (__temp3 = g_strdup (value), (self->priv->_variable_name = (g_free (self->priv->_variable_name), NULL)), __temp3);
}


ValaExpression* vala_foreach_statement_get_collection (ValaForeachStatement* self)
{
	g_return_val_if_fail (VALA_IS_FOREACH_STATEMENT (self), NULL);
	return self->priv->_collection;
}


void vala_foreach_statement_set_collection (ValaForeachStatement* self, ValaExpression* value)
{
	g_return_if_fail (VALA_IS_FOREACH_STATEMENT (self));
	ValaExpression* __temp5 = NULL;
	self->priv->_collection = (__temp5 = g_object_ref (value), (self->priv->_collection == NULL ? NULL : (self->priv->_collection = (g_object_unref (self->priv->_collection), NULL))), __temp5);
	(vala_code_node_set_parent_node (VALA_CODE_NODE (self->priv->_collection), VALA_CODE_NODE (self)), vala_code_node_get_parent_node (VALA_CODE_NODE (self->priv->_collection)));
}


ValaStatement* vala_foreach_statement_get_body (ValaForeachStatement* self)
{
	g_return_val_if_fail (VALA_IS_FOREACH_STATEMENT (self), NULL);
	return self->priv->_body;
}


void vala_foreach_statement_set_body (ValaForeachStatement* self, ValaStatement* value)
{
	g_return_if_fail (VALA_IS_FOREACH_STATEMENT (self));
	ValaStatement* __temp8 = NULL;
	ValaStatement* __temp7 = NULL;
	self->priv->_body = (__temp8 = (__temp7 = value, (__temp7 == NULL ? NULL : g_object_ref (__temp7))), (self->priv->_body == NULL ? NULL : (self->priv->_body = (g_object_unref (self->priv->_body), NULL))), __temp8);
}


ValaVariableDeclarator* vala_foreach_statement_get_variable_declarator (ValaForeachStatement* self)
{
	g_return_val_if_fail (VALA_IS_FOREACH_STATEMENT (self), NULL);
	return self->priv->_variable_declarator;
}


void vala_foreach_statement_set_variable_declarator (ValaForeachStatement* self, ValaVariableDeclarator* value)
{
	g_return_if_fail (VALA_IS_FOREACH_STATEMENT (self));
	ValaVariableDeclarator* __temp11 = NULL;
	ValaVariableDeclarator* __temp10 = NULL;
	self->priv->_variable_declarator = (__temp11 = (__temp10 = value, (__temp10 == NULL ? NULL : g_object_ref (__temp10))), (self->priv->_variable_declarator == NULL ? NULL : (self->priv->_variable_declarator = (g_object_unref (self->priv->_variable_declarator), NULL))), __temp11);
}


static void vala_foreach_statement_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaForeachStatement * self = VALA_FOREACH_STATEMENT (object);
	switch (property_id) {
		case VALA_FOREACH_STATEMENT_TYPE_REFERENCE:
		g_value_set_object (value, vala_foreach_statement_get_type_reference (self));
		break;
		case VALA_FOREACH_STATEMENT_VARIABLE_NAME:
		g_value_set_string (value, vala_foreach_statement_get_variable_name (self));
		break;
		case VALA_FOREACH_STATEMENT_COLLECTION:
		g_value_set_object (value, vala_foreach_statement_get_collection (self));
		break;
		case VALA_FOREACH_STATEMENT_BODY:
		g_value_set_object (value, vala_foreach_statement_get_body (self));
		break;
		case VALA_FOREACH_STATEMENT_VARIABLE_DECLARATOR:
		g_value_set_object (value, vala_foreach_statement_get_variable_declarator (self));
		break;
	}
}


static void vala_foreach_statement_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaForeachStatement * self = VALA_FOREACH_STATEMENT (object);
	switch (property_id) {
		case VALA_FOREACH_STATEMENT_TYPE_REFERENCE:
		vala_foreach_statement_set_type_reference (self, g_value_get_object (value));
		break;
		case VALA_FOREACH_STATEMENT_VARIABLE_NAME:
		vala_foreach_statement_set_variable_name (self, g_value_get_string (value));
		break;
		case VALA_FOREACH_STATEMENT_COLLECTION:
		vala_foreach_statement_set_collection (self, g_value_get_object (value));
		break;
		case VALA_FOREACH_STATEMENT_BODY:
		vala_foreach_statement_set_body (self, g_value_get_object (value));
		break;
		case VALA_FOREACH_STATEMENT_VARIABLE_DECLARATOR:
		vala_foreach_statement_set_variable_declarator (self, g_value_get_object (value));
		break;
	}
}


static void vala_foreach_statement_class_init (ValaForeachStatementClass * klass)
{
	vala_foreach_statement_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaForeachStatementPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_foreach_statement_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_foreach_statement_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_foreach_statement_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_foreach_statement_real_accept;
	VALA_CODE_NODE_CLASS (klass)->replace = vala_foreach_statement_real_replace;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_FOREACH_STATEMENT_TYPE_REFERENCE, g_param_spec_object ("type-reference", "foo", "bar", VALA_TYPE_TYPE_REFERENCE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_FOREACH_STATEMENT_VARIABLE_NAME, g_param_spec_string ("variable-name", "foo", "bar", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_FOREACH_STATEMENT_COLLECTION, g_param_spec_object ("collection", "foo", "bar", VALA_TYPE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_FOREACH_STATEMENT_BODY, g_param_spec_object ("body", "foo", "bar", VALA_TYPE_STATEMENT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_FOREACH_STATEMENT_VARIABLE_DECLARATOR, g_param_spec_object ("variable-declarator", "foo", "bar", VALA_TYPE_VARIABLE_DECLARATOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_foreach_statement_init (ValaForeachStatement * self)
{
	self->priv = VALA_FOREACH_STATEMENT_GET_PRIVATE (self);
}


static void vala_foreach_statement_dispose (GObject * obj)
{
	ValaForeachStatement * self = VALA_FOREACH_STATEMENT (obj);
	(self->priv->_type_reference == NULL ? NULL : (self->priv->_type_reference = (g_object_unref (self->priv->_type_reference), NULL)));
	(self->priv->_variable_name = (g_free (self->priv->_variable_name), NULL));
	(self->priv->_body == NULL ? NULL : (self->priv->_body = (g_object_unref (self->priv->_body), NULL)));
	(self->priv->_variable_declarator == NULL ? NULL : (self->priv->_variable_declarator = (g_object_unref (self->priv->_variable_declarator), NULL)));
	(self->priv->_collection == NULL ? NULL : (self->priv->_collection = (g_object_unref (self->priv->_collection), NULL)));
	ValaForeachStatementClass * klass;
	GObjectClass * parent_class;
	klass = VALA_FOREACH_STATEMENT_CLASS (g_type_class_peek (VALA_TYPE_FOREACH_STATEMENT));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_foreach_statement_get_type ()
{
	static GType vala_foreach_statement_type_id = 0;
	if (G_UNLIKELY (vala_foreach_statement_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaForeachStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_foreach_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaForeachStatement), 0, (GInstanceInitFunc) vala_foreach_statement_init };
		vala_foreach_statement_type_id = g_type_register_static (VALA_TYPE_STATEMENT, "ValaForeachStatement", &g_define_type_info, 0);
	}
	return vala_foreach_statement_type_id;
}




