/* valacodegenerator.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <rasa@gmx.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valacodegenerator.h"
#include <ccode/valaccodestruct.h>
#include <ccode/valaccodeenum.h>
#include <ccode/valaccodefunction.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodetypedefinition.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodemacroreplacement.h>
#include <ccode/valaccodecomment.h>
#include <ccode/valaccodewriter.h>
#include <ccode/valaccodeoncesection.h>
#include <ccode/valaccodenewline.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodememberaccess.h>
#include <ccode/valaccodeswitchstatement.h>
#include <ccode/valaccodecasestatement.h>
#include <ccode/valaccodebreakstatement.h>
#include <ccode/valaccodeifstatement.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodefunctiondeclarator.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodereturnstatement.h>
#include <ccode/valaccodecastexpression.h>
#include <ccode/valaccodeconditionalexpression.h>
#include <ccode/valaccodeemptystatement.h>
#include <ccode/valaccodeinitializerlist.h>
#include <ccode/valaccodeparenthesizedexpression.h>
#include <ccode/valaccodedostatement.h>
#include <ccode/valaccodewhilestatement.h>
#include <ccode/valaccodeforstatement.h>
#include <ccode/valaccodeelementaccess.h>
#include <ccode/valaccodecontinuestatement.h>
#include <vala/valacodegenerator.h>
#include <vala/valasourcefilecycle.h>
#include <vala/valanamespace.h>
#include <vala/valasourcereference.h>
#include <vala/valaclassregisterfunction.h>
#include <vala/valatyperegisterfunction.h>
#include <vala/valatypeparameter.h>
#include <vala/valainterfaceregisterfunction.h>
#include <vala/valaliteral.h>
#include <vala/valamemberaccessibility.h>
#include <vala/valalockable.h>
#include <vala/valaarray.h>
#include <vala/valapointer.h>
#include <vala/valareport.h>
#include <vala/valalocalvariabledeclaration.h>
#include <vala/valainstancecast.h>
#include <vala/valaswitchsection.h>
#include <vala/valaswitchlabel.h>
#include <vala/valaarraylengthfield.h>
#include <vala/valainvokable.h>
#include <vala/valaarrayresizemethod.h>

struct _ValaCodeGeneratorPrivate {
	gboolean _memory_management;
	ValaCodeContext* context;
	ValaSymbol* root_symbol;
	ValaSymbol* current_symbol;
	ValaSymbol* current_type_symbol;
	ValaClass* current_class;
	ValaTypeReference* current_return_type;
	ValaCCodeFragment* header_begin;
	ValaCCodeFragment* header_type_declaration;
	ValaCCodeFragment* header_type_definition;
	ValaCCodeFragment* header_type_member_declaration;
	ValaCCodeFragment* source_begin;
	ValaCCodeFragment* source_include_directives;
	ValaCCodeFragment* source_type_member_declaration;
	ValaCCodeFragment* source_signal_marshaller_declaration;
	ValaCCodeFragment* source_type_member_definition;
	ValaCCodeFragment* instance_init_fragment;
	ValaCCodeFragment* instance_dispose_fragment;
	ValaCCodeFragment* source_signal_marshaller_definition;
	ValaCCodeFragment* module_init_fragment;
	ValaCCodeStruct* instance_struct;
	ValaCCodeStruct* type_struct;
	ValaCCodeStruct* instance_priv_struct;
	ValaCCodeEnum* prop_enum;
	ValaCCodeEnum* cenum;
	ValaCCodeFunction* function;
	ValaCCodeBlock* block;
	GList* temp_vars;
	GList* temp_ref_vars;
	GHashTable* user_marshal_list;
	GHashTable* predefined_marshal_list;
	gint next_temp_var_id;
	gboolean in_creation_method;
	ValaTypeReference* bool_type;
	ValaTypeReference* char_type;
	ValaTypeReference* unichar_type;
	ValaTypeReference* short_type;
	ValaTypeReference* ushort_type;
	ValaTypeReference* int_type;
	ValaTypeReference* uint_type;
	ValaTypeReference* long_type;
	ValaTypeReference* ulong_type;
	ValaTypeReference* int64_type;
	ValaTypeReference* uint64_type;
	ValaTypeReference* string_type;
	ValaTypeReference* float_type;
	ValaTypeReference* double_type;
	ValaDataType* list_type;
	ValaDataType* slist_type;
	ValaTypeReference* mutex_type;
	ValaDataType* type_module_type;
	gboolean in_plugin;
	char* module_init_param_name;
	gboolean string_h_needed;
};
#define VALA_CODE_GENERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorPrivate))
enum  {
	VALA_CODE_GENERATOR_DUMMY_PROPERTY,
	VALA_CODE_GENERATOR_MEMORY_MANAGEMENT,
};
static ValaCCodeIncludeDirective* vala_code_generator_get_internal_include (ValaCodeGenerator* self, const char* filename);
static void vala_code_generator_real_visit_begin_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file);
static char* vala_code_generator_get_define_for_filename (const char* filename);
static void vala_code_generator_real_visit_end_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file);
static void vala_code_generator_real_visit_begin_class (ValaCodeVisitor* base, ValaClass* cl);
static void vala_code_generator_real_visit_end_class (ValaCodeVisitor* base, ValaClass* cl);
static void vala_code_generator_add_class_init_function (ValaCodeGenerator* self, ValaClass* cl);
static void vala_code_generator_add_interface_init_function (ValaCodeGenerator* self, ValaClass* cl, ValaInterface* iface);
static void vala_code_generator_add_instance_init_function (ValaCodeGenerator* self, ValaClass* cl);
static void vala_code_generator_add_dispose_function (ValaCodeGenerator* self, ValaClass* cl);
static ValaCCodeIdentifier* vala_code_generator_get_value_setter_function (ValaCodeGenerator* self, ValaTypeReference* type_reference);
static void vala_code_generator_add_get_property_function (ValaCodeGenerator* self, ValaClass* cl);
static void vala_code_generator_add_set_property_function (ValaCodeGenerator* self, ValaClass* cl);
static void vala_code_generator_real_visit_begin_struct (ValaCodeVisitor* base, ValaStruct* st);
static void vala_code_generator_real_visit_end_struct (ValaCodeVisitor* base, ValaStruct* st);
static void vala_code_generator_real_visit_begin_interface (ValaCodeVisitor* base, ValaInterface* iface);
static void vala_code_generator_real_visit_end_interface (ValaCodeVisitor* base, ValaInterface* iface);
static ValaCCodeFunctionCall* vala_code_generator_get_param_spec (ValaCodeGenerator* self, ValaProperty* prop);
static ValaCCodeFunctionCall* vala_code_generator_get_signal_creation (ValaCodeGenerator* self, ValaSignal* sig, ValaDataType* type);
static void vala_code_generator_add_interface_base_init_function (ValaCodeGenerator* self, ValaInterface* iface);
static void vala_code_generator_real_visit_begin_enum (ValaCodeVisitor* base, ValaEnum* en);
static void vala_code_generator_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev);
static void vala_code_generator_real_visit_begin_flags (ValaCodeVisitor* base, ValaFlags* fl);
static void vala_code_generator_real_visit_flags_value (ValaCodeVisitor* base, ValaFlagsValue* fv);
static void vala_code_generator_real_visit_end_callback (ValaCodeVisitor* base, ValaCallback* cb);
static void vala_code_generator_real_visit_member (ValaCodeVisitor* base, ValaMember* m);
static void vala_code_generator_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c);
static void vala_code_generator_real_visit_field (ValaCodeVisitor* base, ValaField* f);
static void vala_code_generator_real_visit_begin_method (ValaCodeVisitor* base, ValaMethod* m);
static ValaCCodeStatement* vala_code_generator_create_method_type_check_statement (ValaCodeGenerator* self, ValaMethod* m, ValaDataType* t, gboolean non_null, const char* var_name);
static ValaCCodeStatement* vala_code_generator_create_property_type_check_statement (ValaCodeGenerator* self, ValaProperty* prop, gboolean getter, ValaDataType* t, gboolean non_null, const char* var_name);
static ValaCCodeStatement* vala_code_generator_create_type_check_statement (ValaCodeGenerator* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaDataType* t, gboolean non_null, const char* var_name);
static ValaDataType* vala_code_generator_find_parent_type (ValaCodeGenerator* self, ValaCodeNode* node);
static char* vala_code_generator_get_array_length_cname (ValaCodeGenerator* self, const char* array_cname, gint dim);
static void vala_code_generator_real_visit_end_method (ValaCodeVisitor* base, ValaMethod* m);
static void vala_code_generator_real_visit_begin_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m);
static void vala_code_generator_real_visit_end_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m);
static gboolean vala_code_generator_is_possible_entry_point (ValaCodeGenerator* self, ValaMethod* m, gboolean* return_value, gboolean* args_parameter);
static void vala_code_generator_real_visit_formal_parameter (ValaCodeVisitor* base, ValaFormalParameter* p);
static void vala_code_generator_real_visit_end_property (ValaCodeVisitor* base, ValaProperty* prop);
static void vala_code_generator_real_visit_begin_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc);
static void vala_code_generator_real_visit_end_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc);
static char* vala_code_generator_get_marshaller_type_name (ValaCodeGenerator* self, ValaTypeReference* t);
static char* vala_code_generator_get_signal_marshaller_function (ValaCodeGenerator* self, ValaSignal* sig, const char* prefix);
static char* vala_code_generator_get_value_type_name_from_type_reference (ValaCodeGenerator* self, ValaTypeReference* t);
static char* vala_code_generator_get_signal_signature (ValaCodeGenerator* self, ValaSignal* sig);
static void vala_code_generator_real_visit_end_signal (ValaCodeVisitor* base, ValaSignal* sig);
static void vala_code_generator_real_visit_end_constructor (ValaCodeVisitor* base, ValaConstructor* c);
static void vala_code_generator_real_visit_begin_block (ValaCodeVisitor* base, ValaBlock* b);
static void vala_code_generator_add_object_creation (ValaCodeGenerator* self, ValaCCodeBlock* b);
static void vala_code_generator_real_visit_end_block (ValaCodeVisitor* base, ValaBlock* b);
static void vala_code_generator_real_visit_empty_statement (ValaCodeVisitor* base, ValaEmptyStatement* stmt);
static gboolean vala_code_generator_struct_has_instance_fields (ValaCodeGenerator* self, ValaStruct* st);
static void vala_code_generator_real_visit_declaration_statement (ValaCodeVisitor* base, ValaDeclarationStatement* stmt);
static void vala_code_generator_real_visit_variable_declarator (ValaCodeVisitor* base, ValaVariableDeclarator* decl);
static void vala_code_generator_real_visit_end_initializer_list (ValaCodeVisitor* base, ValaInitializerList* list);
static ValaVariableDeclarator* vala_code_generator_get_temp_variable_declarator (ValaCodeGenerator* self, ValaTypeReference* type, gboolean takes_ownership);
static ValaCCodeExpression* vala_code_generator_get_destroy_func_expression (ValaCodeGenerator* self, ValaTypeReference* type);
static ValaCCodeExpression* vala_code_generator_get_unref_expression (ValaCodeGenerator* self, ValaCCodeExpression* cvar, ValaTypeReference* type);
static void vala_code_generator_real_visit_end_full_expression (ValaCodeVisitor* base, ValaExpression* expr);
static void vala_code_generator_append_temp_decl (ValaCodeGenerator* self, ValaCCodeFragment* cfrag, GList* temp_vars);
static void vala_code_generator_real_visit_expression_statement (ValaCodeVisitor* base, ValaExpressionStatement* stmt);
static void vala_code_generator_create_temp_decl (ValaCodeGenerator* self, ValaStatement* stmt, GList* temp_vars);
static void vala_code_generator_real_visit_if_statement (ValaCodeVisitor* base, ValaIfStatement* stmt);
static void vala_code_generator_real_visit_switch_statement (ValaCodeVisitor* base, ValaSwitchStatement* stmt);
static void vala_code_generator_real_visit_while_statement (ValaCodeVisitor* base, ValaWhileStatement* stmt);
static void vala_code_generator_real_visit_do_statement (ValaCodeVisitor* base, ValaDoStatement* stmt);
static void vala_code_generator_real_visit_for_statement (ValaCodeVisitor* base, ValaForStatement* stmt);
static void vala_code_generator_real_visit_end_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt);
static void vala_code_generator_real_visit_break_statement (ValaCodeVisitor* base, ValaBreakStatement* stmt);
static void vala_code_generator_real_visit_continue_statement (ValaCodeVisitor* base, ValaContinueStatement* stmt);
static void vala_code_generator_append_local_free (ValaCodeGenerator* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, gboolean stop_at_loop);
static void vala_code_generator_create_local_free (ValaCodeGenerator* self, ValaStatement* stmt);
static gboolean vala_code_generator_append_local_free_expr (ValaCodeGenerator* self, ValaSymbol* sym, ValaCCodeCommaExpression* ccomma, gboolean stop_at_loop);
static void vala_code_generator_create_local_free_expr (ValaCodeGenerator* self, ValaExpression* expr);
static void vala_code_generator_real_visit_begin_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt);
static void vala_code_generator_real_visit_end_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt);
static char* vala_code_generator_get_symbol_lock_name (ValaCodeGenerator* self, ValaSymbol* sym);
static void vala_code_generator_real_visit_lock_statement (ValaCodeVisitor* base, ValaLockStatement* stmt);
static void vala_code_generator_real_visit_end_array_creation_expression (ValaCodeVisitor* base, ValaArrayCreationExpression* expr);
static void vala_code_generator_real_visit_boolean_literal (ValaCodeVisitor* base, ValaBooleanLiteral* expr);
static void vala_code_generator_real_visit_character_literal (ValaCodeVisitor* base, ValaCharacterLiteral* expr);
static void vala_code_generator_real_visit_integer_literal (ValaCodeVisitor* base, ValaIntegerLiteral* expr);
static void vala_code_generator_real_visit_real_literal (ValaCodeVisitor* base, ValaRealLiteral* expr);
static void vala_code_generator_real_visit_string_literal (ValaCodeVisitor* base, ValaStringLiteral* expr);
static void vala_code_generator_real_visit_null_literal (ValaCodeVisitor* base, ValaNullLiteral* expr);
static void vala_code_generator_real_visit_literal_expression (ValaCodeVisitor* base, ValaLiteralExpression* expr);
static void vala_code_generator_process_cmember (ValaCodeGenerator* self, ValaMemberAccess* expr, ValaCCodeExpression* pub_inst, ValaDataType* base_type);
static void vala_code_generator_real_visit_parenthesized_expression (ValaCodeVisitor* base, ValaParenthesizedExpression* expr);
static void vala_code_generator_real_visit_member_access (ValaCodeVisitor* base, ValaMemberAccess* expr);
static ValaCCodeExpression* vala_code_generator_get_array_length_cexpression (ValaCodeGenerator* self, ValaExpression* array_expr, gint dim);
static void vala_code_generator_real_visit_end_invocation_expression (ValaCodeVisitor* base, ValaInvocationExpression* expr);
static void vala_code_generator_real_visit_element_access (ValaCodeVisitor* base, ValaElementAccess* expr);
static void vala_code_generator_real_visit_base_access (ValaCodeVisitor* base, ValaBaseAccess* expr);
static void vala_code_generator_real_visit_postfix_expression (ValaCodeVisitor* base, ValaPostfixExpression* expr);
static ValaMemberAccess* vala_code_generator_find_property_access (ValaCodeGenerator* self, ValaExpression* expr);
static ValaCCodeExpression* vala_code_generator_get_ref_expression (ValaCodeGenerator* self, ValaExpression* expr);
static void vala_code_generator_visit_expression (ValaCodeGenerator* self, ValaExpression* expr);
static void vala_code_generator_real_visit_end_object_creation_expression (ValaCodeVisitor* base, ValaObjectCreationExpression* expr);
static void vala_code_generator_real_visit_typeof_expression (ValaCodeVisitor* base, ValaTypeofExpression* expr);
static void vala_code_generator_real_visit_unary_expression (ValaCodeVisitor* base, ValaUnaryExpression* expr);
static void vala_code_generator_real_visit_cast_expression (ValaCodeVisitor* base, ValaCastExpression* expr);
static void vala_code_generator_real_visit_pointer_indirection (ValaCodeVisitor* base, ValaPointerIndirection* expr);
static void vala_code_generator_real_visit_addressof_expression (ValaCodeVisitor* base, ValaAddressofExpression* expr);
static void vala_code_generator_real_visit_reference_transfer_expression (ValaCodeVisitor* base, ValaReferenceTransferExpression* expr);
static void vala_code_generator_real_visit_binary_expression (ValaCodeVisitor* base, ValaBinaryExpression* expr);
static void vala_code_generator_real_visit_type_check (ValaCodeVisitor* base, ValaTypeCheck* expr);
static void vala_code_generator_real_visit_conditional_expression (ValaCodeVisitor* base, ValaConditionalExpression* expr);
static void vala_code_generator_real_visit_end_lambda_expression (ValaCodeVisitor* base, ValaLambdaExpression* l);
static void vala_code_generator_real_visit_end_assignment (ValaCodeVisitor* base, ValaAssignment* a);
static ValaCCodeFunctionCall* vala_code_generator_get_property_set_call (ValaCodeGenerator* self, ValaProperty* prop, ValaMemberAccess* ma, ValaCCodeExpression* cexpr);
static GObject * vala_code_generator_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer vala_code_generator_parent_class = NULL;
static void vala_code_generator_dispose (GObject * obj);


ValaCodeGenerator* vala_code_generator_new (gboolean manage_memory)
{
	GParameter * __params = g_new0 (GParameter, 1);
	GParameter * __params_it = __params;
	(__params_it->name = "memory-management", g_value_init (&__params_it->value, G_TYPE_BOOLEAN), g_value_set_boolean (&__params_it->value, manage_memory), __params_it++);
	ValaCodeGenerator * self = g_object_newv (VALA_TYPE_CODE_GENERATOR, __params_it - __params, __params);
	return self;
}


/**
 * Generate and emit C code for the specified code context.
 *
 * @param context a code context
 */
void vala_code_generator_emit (ValaCodeGenerator* self, ValaCodeContext* context)
{
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CODE_CONTEXT (context));
	ValaCodeContext* __temp0 = NULL;
	self->priv->context = (__temp0 = g_object_ref (context), (self->priv->context == NULL ? NULL : (self->priv->context = (g_object_unref (self->priv->context), NULL))), __temp0);
	vala_code_context_find_header_cycles (context);
	ValaSymbol* __temp1 = NULL;
	self->priv->root_symbol = (__temp1 = vala_code_context_get_root (context), (self->priv->root_symbol == NULL ? NULL : (self->priv->root_symbol = (g_object_unref (self->priv->root_symbol), NULL))), __temp1);
	ValaTypeReference* __temp2 = NULL;
	self->priv->bool_type = (__temp2 = vala_type_reference_new (), (self->priv->bool_type == NULL ? NULL : (self->priv->bool_type = (g_object_unref (self->priv->bool_type), NULL))), __temp2);
	ValaSymbol* __temp3 = NULL;
	(vala_type_reference_set_data_type (self->priv->bool_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp3 = vala_symbol_lookup (self->priv->root_symbol, "bool"))))), vala_type_reference_get_data_type (self->priv->bool_type));
	(__temp3 == NULL ? NULL : (__temp3 = (g_object_unref (__temp3), NULL)));
	ValaTypeReference* __temp4 = NULL;
	self->priv->char_type = (__temp4 = vala_type_reference_new (), (self->priv->char_type == NULL ? NULL : (self->priv->char_type = (g_object_unref (self->priv->char_type), NULL))), __temp4);
	ValaSymbol* __temp5 = NULL;
	(vala_type_reference_set_data_type (self->priv->char_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp5 = vala_symbol_lookup (self->priv->root_symbol, "char"))))), vala_type_reference_get_data_type (self->priv->char_type));
	(__temp5 == NULL ? NULL : (__temp5 = (g_object_unref (__temp5), NULL)));
	ValaTypeReference* __temp6 = NULL;
	self->priv->unichar_type = (__temp6 = vala_type_reference_new (), (self->priv->unichar_type == NULL ? NULL : (self->priv->unichar_type = (g_object_unref (self->priv->unichar_type), NULL))), __temp6);
	ValaSymbol* __temp7 = NULL;
	(vala_type_reference_set_data_type (self->priv->unichar_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp7 = vala_symbol_lookup (self->priv->root_symbol, "unichar"))))), vala_type_reference_get_data_type (self->priv->unichar_type));
	(__temp7 == NULL ? NULL : (__temp7 = (g_object_unref (__temp7), NULL)));
	ValaTypeReference* __temp8 = NULL;
	self->priv->short_type = (__temp8 = vala_type_reference_new (), (self->priv->short_type == NULL ? NULL : (self->priv->short_type = (g_object_unref (self->priv->short_type), NULL))), __temp8);
	ValaSymbol* __temp9 = NULL;
	(vala_type_reference_set_data_type (self->priv->short_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp9 = vala_symbol_lookup (self->priv->root_symbol, "short"))))), vala_type_reference_get_data_type (self->priv->short_type));
	(__temp9 == NULL ? NULL : (__temp9 = (g_object_unref (__temp9), NULL)));
	ValaTypeReference* __temp10 = NULL;
	self->priv->ushort_type = (__temp10 = vala_type_reference_new (), (self->priv->ushort_type == NULL ? NULL : (self->priv->ushort_type = (g_object_unref (self->priv->ushort_type), NULL))), __temp10);
	ValaSymbol* __temp11 = NULL;
	(vala_type_reference_set_data_type (self->priv->ushort_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp11 = vala_symbol_lookup (self->priv->root_symbol, "ushort"))))), vala_type_reference_get_data_type (self->priv->ushort_type));
	(__temp11 == NULL ? NULL : (__temp11 = (g_object_unref (__temp11), NULL)));
	ValaTypeReference* __temp12 = NULL;
	self->priv->int_type = (__temp12 = vala_type_reference_new (), (self->priv->int_type == NULL ? NULL : (self->priv->int_type = (g_object_unref (self->priv->int_type), NULL))), __temp12);
	ValaSymbol* __temp13 = NULL;
	(vala_type_reference_set_data_type (self->priv->int_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp13 = vala_symbol_lookup (self->priv->root_symbol, "int"))))), vala_type_reference_get_data_type (self->priv->int_type));
	(__temp13 == NULL ? NULL : (__temp13 = (g_object_unref (__temp13), NULL)));
	ValaTypeReference* __temp14 = NULL;
	self->priv->uint_type = (__temp14 = vala_type_reference_new (), (self->priv->uint_type == NULL ? NULL : (self->priv->uint_type = (g_object_unref (self->priv->uint_type), NULL))), __temp14);
	ValaSymbol* __temp15 = NULL;
	(vala_type_reference_set_data_type (self->priv->uint_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp15 = vala_symbol_lookup (self->priv->root_symbol, "uint"))))), vala_type_reference_get_data_type (self->priv->uint_type));
	(__temp15 == NULL ? NULL : (__temp15 = (g_object_unref (__temp15), NULL)));
	ValaTypeReference* __temp16 = NULL;
	self->priv->long_type = (__temp16 = vala_type_reference_new (), (self->priv->long_type == NULL ? NULL : (self->priv->long_type = (g_object_unref (self->priv->long_type), NULL))), __temp16);
	ValaSymbol* __temp17 = NULL;
	(vala_type_reference_set_data_type (self->priv->long_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp17 = vala_symbol_lookup (self->priv->root_symbol, "long"))))), vala_type_reference_get_data_type (self->priv->long_type));
	(__temp17 == NULL ? NULL : (__temp17 = (g_object_unref (__temp17), NULL)));
	ValaTypeReference* __temp18 = NULL;
	self->priv->ulong_type = (__temp18 = vala_type_reference_new (), (self->priv->ulong_type == NULL ? NULL : (self->priv->ulong_type = (g_object_unref (self->priv->ulong_type), NULL))), __temp18);
	ValaSymbol* __temp19 = NULL;
	(vala_type_reference_set_data_type (self->priv->ulong_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp19 = vala_symbol_lookup (self->priv->root_symbol, "ulong"))))), vala_type_reference_get_data_type (self->priv->ulong_type));
	(__temp19 == NULL ? NULL : (__temp19 = (g_object_unref (__temp19), NULL)));
	ValaTypeReference* __temp20 = NULL;
	self->priv->int64_type = (__temp20 = vala_type_reference_new (), (self->priv->int64_type == NULL ? NULL : (self->priv->int64_type = (g_object_unref (self->priv->int64_type), NULL))), __temp20);
	ValaSymbol* __temp21 = NULL;
	(vala_type_reference_set_data_type (self->priv->int64_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp21 = vala_symbol_lookup (self->priv->root_symbol, "int64"))))), vala_type_reference_get_data_type (self->priv->int64_type));
	(__temp21 == NULL ? NULL : (__temp21 = (g_object_unref (__temp21), NULL)));
	ValaTypeReference* __temp22 = NULL;
	self->priv->uint64_type = (__temp22 = vala_type_reference_new (), (self->priv->uint64_type == NULL ? NULL : (self->priv->uint64_type = (g_object_unref (self->priv->uint64_type), NULL))), __temp22);
	ValaSymbol* __temp23 = NULL;
	(vala_type_reference_set_data_type (self->priv->uint64_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp23 = vala_symbol_lookup (self->priv->root_symbol, "uint64"))))), vala_type_reference_get_data_type (self->priv->uint64_type));
	(__temp23 == NULL ? NULL : (__temp23 = (g_object_unref (__temp23), NULL)));
	ValaTypeReference* __temp24 = NULL;
	self->priv->float_type = (__temp24 = vala_type_reference_new (), (self->priv->float_type == NULL ? NULL : (self->priv->float_type = (g_object_unref (self->priv->float_type), NULL))), __temp24);
	ValaSymbol* __temp25 = NULL;
	(vala_type_reference_set_data_type (self->priv->float_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp25 = vala_symbol_lookup (self->priv->root_symbol, "float"))))), vala_type_reference_get_data_type (self->priv->float_type));
	(__temp25 == NULL ? NULL : (__temp25 = (g_object_unref (__temp25), NULL)));
	ValaTypeReference* __temp26 = NULL;
	self->priv->double_type = (__temp26 = vala_type_reference_new (), (self->priv->double_type == NULL ? NULL : (self->priv->double_type = (g_object_unref (self->priv->double_type), NULL))), __temp26);
	ValaSymbol* __temp27 = NULL;
	(vala_type_reference_set_data_type (self->priv->double_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp27 = vala_symbol_lookup (self->priv->root_symbol, "double"))))), vala_type_reference_get_data_type (self->priv->double_type));
	(__temp27 == NULL ? NULL : (__temp27 = (g_object_unref (__temp27), NULL)));
	ValaTypeReference* __temp28 = NULL;
	self->priv->string_type = (__temp28 = vala_type_reference_new (), (self->priv->string_type == NULL ? NULL : (self->priv->string_type = (g_object_unref (self->priv->string_type), NULL))), __temp28);
	ValaSymbol* __temp29 = NULL;
	(vala_type_reference_set_data_type (self->priv->string_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp29 = vala_symbol_lookup (self->priv->root_symbol, "string"))))), vala_type_reference_get_data_type (self->priv->string_type));
	(__temp29 == NULL ? NULL : (__temp29 = (g_object_unref (__temp29), NULL)));
	ValaSymbol* glib_ns = vala_symbol_lookup (self->priv->root_symbol, "GLib");
	ValaDataType* __temp32 = NULL;
	ValaDataType* __temp31 = NULL;
	ValaSymbol* __temp30 = NULL;
	self->priv->list_type = (__temp32 = (__temp31 = VALA_DATA_TYPE (vala_symbol_get_node ((__temp30 = vala_symbol_lookup (glib_ns, "List")))), (__temp31 == NULL ? NULL : g_object_ref (__temp31))), (self->priv->list_type == NULL ? NULL : (self->priv->list_type = (g_object_unref (self->priv->list_type), NULL))), __temp32);
	(__temp30 == NULL ? NULL : (__temp30 = (g_object_unref (__temp30), NULL)));
	ValaDataType* __temp35 = NULL;
	ValaDataType* __temp34 = NULL;
	ValaSymbol* __temp33 = NULL;
	self->priv->slist_type = (__temp35 = (__temp34 = VALA_DATA_TYPE (vala_symbol_get_node ((__temp33 = vala_symbol_lookup (glib_ns, "SList")))), (__temp34 == NULL ? NULL : g_object_ref (__temp34))), (self->priv->slist_type == NULL ? NULL : (self->priv->slist_type = (g_object_unref (self->priv->slist_type), NULL))), __temp35);
	(__temp33 == NULL ? NULL : (__temp33 = (g_object_unref (__temp33), NULL)));
	ValaTypeReference* __temp36 = NULL;
	self->priv->mutex_type = (__temp36 = vala_type_reference_new (), (self->priv->mutex_type == NULL ? NULL : (self->priv->mutex_type = (g_object_unref (self->priv->mutex_type), NULL))), __temp36);
	ValaSymbol* __temp37 = NULL;
	(vala_type_reference_set_data_type (self->priv->mutex_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp37 = vala_symbol_lookup (glib_ns, "Mutex"))))), vala_type_reference_get_data_type (self->priv->mutex_type));
	(__temp37 == NULL ? NULL : (__temp37 = (g_object_unref (__temp37), NULL)));
	ValaDataType* __temp40 = NULL;
	ValaDataType* __temp39 = NULL;
	ValaSymbol* __temp38 = NULL;
	self->priv->type_module_type = (__temp40 = (__temp39 = VALA_DATA_TYPE (vala_symbol_get_node ((__temp38 = vala_symbol_lookup (glib_ns, "TypeModule")))), (__temp39 == NULL ? NULL : g_object_ref (__temp39))), (self->priv->type_module_type == NULL ? NULL : (self->priv->type_module_type = (g_object_unref (self->priv->type_module_type), NULL))), __temp40);
	(__temp38 == NULL ? NULL : (__temp38 = (g_object_unref (__temp38), NULL)));
	if (vala_code_context_get_module_init_method (context) != NULL) {
		ValaCCodeFragment* __temp41 = NULL;
		self->priv->module_init_fragment = (__temp41 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->module_init_fragment == NULL ? NULL : (self->priv->module_init_fragment = (g_object_unref (self->priv->module_init_fragment), NULL))), __temp41);
		{
			GList* __temp43 = NULL;
			__temp43 = vala_invokable_get_parameters (VALA_INVOKABLE (vala_code_context_get_module_init_method (context)));
			GList* parameter_it;
			for (parameter_it = __temp43; parameter_it != NULL; parameter_it = parameter_it->next) {
				ValaFormalParameter* parameter = parameter_it->data;
				{
					if (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (parameter)) == self->priv->type_module_type) {
						self->priv->in_plugin = TRUE;
						char* __temp42 = NULL;
						self->priv->module_init_param_name = (__temp42 = g_strdup (vala_formal_parameter_get_name (parameter)), (self->priv->module_init_param_name = (g_free (self->priv->module_init_param_name), NULL)), __temp42);
						break;
					}
				}
			}
			(__temp43 == NULL ? NULL : (__temp43 = (g_list_free (__temp43), NULL)));
		}
	}
	/* we're only interested in non-pkg source files */
	GList* source_files = vala_code_context_get_source_files (context);
	{
		GList* __temp44 = NULL;
		__temp44 = source_files;
		GList* file_it;
		for (file_it = __temp44; file_it != NULL; file_it = file_it->next) {
			ValaSourceFile* file = file_it->data;
			{
				if (!vala_source_file_get_pkg (file)) {
					vala_source_file_accept (file, VALA_CODE_VISITOR (self));
				}
			}
		}
	}
	(glib_ns == NULL ? NULL : (glib_ns = (g_object_unref (glib_ns), NULL)));
	(source_files == NULL ? NULL : (source_files = (g_list_free (source_files), NULL)));
}


static ValaCCodeIncludeDirective* vala_code_generator_get_internal_include (ValaCodeGenerator* self, const char* filename)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	return vala_ccode_include_directive_new (filename, vala_code_context_get_library (self->priv->context) == NULL);
}


static void vala_code_generator_real_visit_begin_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_SOURCE_FILE (source_file));
	ValaCCodeFragment* __temp46 = NULL;
	self->priv->header_begin = (__temp46 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->header_begin == NULL ? NULL : (self->priv->header_begin = (g_object_unref (self->priv->header_begin), NULL))), __temp46);
	ValaCCodeFragment* __temp47 = NULL;
	self->priv->header_type_declaration = (__temp47 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->header_type_declaration == NULL ? NULL : (self->priv->header_type_declaration = (g_object_unref (self->priv->header_type_declaration), NULL))), __temp47);
	ValaCCodeFragment* __temp48 = NULL;
	self->priv->header_type_definition = (__temp48 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->header_type_definition == NULL ? NULL : (self->priv->header_type_definition = (g_object_unref (self->priv->header_type_definition), NULL))), __temp48);
	ValaCCodeFragment* __temp49 = NULL;
	self->priv->header_type_member_declaration = (__temp49 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->header_type_member_declaration == NULL ? NULL : (self->priv->header_type_member_declaration = (g_object_unref (self->priv->header_type_member_declaration), NULL))), __temp49);
	ValaCCodeFragment* __temp50 = NULL;
	self->priv->source_begin = (__temp50 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->source_begin == NULL ? NULL : (self->priv->source_begin = (g_object_unref (self->priv->source_begin), NULL))), __temp50);
	ValaCCodeFragment* __temp51 = NULL;
	self->priv->source_include_directives = (__temp51 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->source_include_directives == NULL ? NULL : (self->priv->source_include_directives = (g_object_unref (self->priv->source_include_directives), NULL))), __temp51);
	ValaCCodeFragment* __temp52 = NULL;
	self->priv->source_type_member_declaration = (__temp52 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->source_type_member_declaration == NULL ? NULL : (self->priv->source_type_member_declaration = (g_object_unref (self->priv->source_type_member_declaration), NULL))), __temp52);
	ValaCCodeFragment* __temp53 = NULL;
	self->priv->source_type_member_definition = (__temp53 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->source_type_member_definition == NULL ? NULL : (self->priv->source_type_member_definition = (g_object_unref (self->priv->source_type_member_definition), NULL))), __temp53);
	ValaCCodeFragment* __temp54 = NULL;
	self->priv->source_signal_marshaller_definition = (__temp54 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->source_signal_marshaller_definition == NULL ? NULL : (self->priv->source_signal_marshaller_definition = (g_object_unref (self->priv->source_signal_marshaller_definition), NULL))), __temp54);
	ValaCCodeFragment* __temp55 = NULL;
	self->priv->source_signal_marshaller_declaration = (__temp55 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->source_signal_marshaller_declaration == NULL ? NULL : (self->priv->source_signal_marshaller_declaration = (g_object_unref (self->priv->source_signal_marshaller_declaration), NULL))), __temp55);
	GHashTable* __temp56 = NULL;
	self->priv->user_marshal_list = (__temp56 = g_hash_table_new (g_str_hash, g_str_equal), (self->priv->user_marshal_list == NULL ? NULL : (self->priv->user_marshal_list = (g_hash_table_unref (self->priv->user_marshal_list), NULL))), __temp56);
	self->priv->next_temp_var_id = 0;
	self->priv->string_h_needed = FALSE;
	ValaCCodeIncludeDirective* __temp57 = NULL;
	vala_ccode_fragment_append (self->priv->header_begin, VALA_CCODE_NODE ((__temp57 = vala_ccode_include_directive_new ("glib.h", FALSE))));
	(__temp57 == NULL ? NULL : (__temp57 = (g_object_unref (__temp57), NULL)));
	ValaCCodeIncludeDirective* __temp58 = NULL;
	vala_ccode_fragment_append (self->priv->header_begin, VALA_CCODE_NODE ((__temp58 = vala_ccode_include_directive_new ("glib-object.h", FALSE))));
	(__temp58 == NULL ? NULL : (__temp58 = (g_object_unref (__temp58), NULL)));
	ValaCCodeIncludeDirective* __temp59 = NULL;
	vala_ccode_fragment_append (self->priv->source_include_directives, VALA_CCODE_NODE ((__temp59 = vala_ccode_include_directive_new (vala_source_file_get_cheader_filename (source_file), TRUE))));
	(__temp59 == NULL ? NULL : (__temp59 = (g_object_unref (__temp59), NULL)));
	GList* used_includes = NULL;
	used_includes = g_list_append (used_includes, "glib.h");
	used_includes = g_list_append (used_includes, "glib-object.h");
	char* __temp60 = NULL;
	used_includes = g_list_append (used_includes, (__temp60 = vala_source_file_get_cheader_filename (source_file)));
	(__temp60 = (g_free (__temp60), NULL));
	{
		GList* __temp62 = NULL;
		__temp62 = vala_source_file_get_header_external_includes (source_file);
		GList* filename1_it;
		for (filename1_it = __temp62; filename1_it != NULL; filename1_it = filename1_it->next) {
			char* filename1 = filename1_it->data;
			{
				if (g_list_find_custom (used_includes, filename1, ((GCompareFunc) strcmp)) == NULL) {
					ValaCCodeIncludeDirective* __temp61 = NULL;
					vala_ccode_fragment_append (self->priv->header_begin, VALA_CCODE_NODE ((__temp61 = vala_ccode_include_directive_new (filename1, FALSE))));
					(__temp61 == NULL ? NULL : (__temp61 = (g_object_unref (__temp61), NULL)));
					used_includes = g_list_append (used_includes, filename1);
				}
			}
		}
	}
	{
		GList* __temp64 = NULL;
		__temp64 = vala_source_file_get_header_internal_includes (source_file);
		GList* filename2_it;
		for (filename2_it = __temp64; filename2_it != NULL; filename2_it = filename2_it->next) {
			char* filename2 = filename2_it->data;
			{
				if (g_list_find_custom (used_includes, filename2, ((GCompareFunc) strcmp)) == NULL) {
					ValaCCodeIncludeDirective* __temp63 = NULL;
					vala_ccode_fragment_append (self->priv->header_begin, VALA_CCODE_NODE ((__temp63 = vala_code_generator_get_internal_include (self, filename2))));
					(__temp63 == NULL ? NULL : (__temp63 = (g_object_unref (__temp63), NULL)));
					used_includes = g_list_append (used_includes, filename2);
				}
			}
		}
	}
	{
		GList* __temp66 = NULL;
		__temp66 = vala_source_file_get_source_external_includes (source_file);
		GList* filename3_it;
		for (filename3_it = __temp66; filename3_it != NULL; filename3_it = filename3_it->next) {
			char* filename3 = filename3_it->data;
			{
				if (g_list_find_custom (used_includes, filename3, ((GCompareFunc) strcmp)) == NULL) {
					ValaCCodeIncludeDirective* __temp65 = NULL;
					vala_ccode_fragment_append (self->priv->source_include_directives, VALA_CCODE_NODE ((__temp65 = vala_ccode_include_directive_new (filename3, FALSE))));
					(__temp65 == NULL ? NULL : (__temp65 = (g_object_unref (__temp65), NULL)));
					used_includes = g_list_append (used_includes, filename3);
				}
			}
		}
	}
	{
		GList* __temp68 = NULL;
		__temp68 = vala_source_file_get_source_internal_includes (source_file);
		GList* filename4_it;
		for (filename4_it = __temp68; filename4_it != NULL; filename4_it = filename4_it->next) {
			char* filename4 = filename4_it->data;
			{
				if (g_list_find_custom (used_includes, filename4, ((GCompareFunc) strcmp)) == NULL) {
					ValaCCodeIncludeDirective* __temp67 = NULL;
					vala_ccode_fragment_append (self->priv->source_include_directives, VALA_CCODE_NODE ((__temp67 = vala_code_generator_get_internal_include (self, filename4))));
					(__temp67 == NULL ? NULL : (__temp67 = (g_object_unref (__temp67), NULL)));
					used_includes = g_list_append (used_includes, filename4);
				}
			}
		}
	}
	if (vala_source_file_get_is_cycle_head (source_file)) {
		{
			GList* __temp84 = NULL;
			__temp84 = vala_source_file_get_cycle (source_file)->files;
			GList* cycle_file_it;
			for (cycle_file_it = __temp84; cycle_file_it != NULL; cycle_file_it = cycle_file_it->next) {
				ValaSourceFile* cycle_file = cycle_file_it->data;
				{
					GList* namespaces = vala_source_file_get_namespaces (cycle_file);
					{
						GList* __temp83 = NULL;
						__temp83 = namespaces;
						GList* ns_it;
						for (ns_it = __temp83; ns_it != NULL; ns_it = ns_it->next) {
							ValaNamespace* ns = ns_it->data;
							{
								GList* structs = vala_namespace_get_structs (ns);
								{
									GList* __temp71 = NULL;
									__temp71 = structs;
									GList* st_it;
									for (st_it = __temp71; st_it != NULL; st_it = st_it->next) {
										ValaStruct* st = st_it->data;
										{
											ValaCCodeTypeDefinition* __temp70 = NULL;
											char* __temp69 = NULL;
											vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp70 = vala_ccode_type_definition_new (g_strdup_printf ("struct _%s", (__temp69 = vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE))), VALA_CCODE_DECLARATOR (vala_ccode_variable_declarator_new (vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE)))))));
											(__temp70 == NULL ? NULL : (__temp70 = (g_object_unref (__temp70), NULL)));
											(__temp69 = (g_free (__temp69), NULL));
										}
									}
								}
								GList* classes = vala_namespace_get_classes (ns);
								{
									GList* __temp77 = NULL;
									__temp77 = classes;
									GList* cl_it;
									for (cl_it = __temp77; cl_it != NULL; cl_it = cl_it->next) {
										ValaClass* cl = cl_it->data;
										{
											ValaCCodeTypeDefinition* __temp73 = NULL;
											char* __temp72 = NULL;
											vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp73 = vala_ccode_type_definition_new (g_strdup_printf ("struct _%s", (__temp72 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))), VALA_CCODE_DECLARATOR (vala_ccode_variable_declarator_new (vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))))));
											(__temp73 == NULL ? NULL : (__temp73 = (g_object_unref (__temp73), NULL)));
											(__temp72 = (g_free (__temp72), NULL));
											ValaCCodeTypeDefinition* __temp76 = NULL;
											char* __temp75 = NULL;
											char* __temp74 = NULL;
											vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp76 = vala_ccode_type_definition_new (g_strdup_printf ("struct _%sClass", (__temp74 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))), VALA_CCODE_DECLARATOR (vala_ccode_variable_declarator_new (g_strdup_printf ("%sClass", (__temp75 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))))))));
											(__temp76 == NULL ? NULL : (__temp76 = (g_object_unref (__temp76), NULL)));
											(__temp75 = (g_free (__temp75), NULL));
											(__temp74 = (g_free (__temp74), NULL));
										}
									}
								}
								GList* ifaces = vala_namespace_get_interfaces (ns);
								{
									GList* __temp82 = NULL;
									__temp82 = ifaces;
									GList* iface_it;
									for (iface_it = __temp82; iface_it != NULL; iface_it = iface_it->next) {
										ValaInterface* iface = iface_it->data;
										{
											ValaCCodeTypeDefinition* __temp79 = NULL;
											char* __temp78 = NULL;
											vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp79 = vala_ccode_type_definition_new (g_strdup_printf ("struct _%s", (__temp78 = vala_data_type_get_cname (VALA_DATA_TYPE (iface), FALSE))), VALA_CCODE_DECLARATOR (vala_ccode_variable_declarator_new (vala_data_type_get_cname (VALA_DATA_TYPE (iface), FALSE)))))));
											(__temp79 == NULL ? NULL : (__temp79 = (g_object_unref (__temp79), NULL)));
											(__temp78 = (g_free (__temp78), NULL));
											ValaCCodeTypeDefinition* __temp81 = NULL;
											char* __temp80 = NULL;
											vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp81 = vala_ccode_type_definition_new (g_strdup_printf ("struct _%s", (__temp80 = vala_interface_get_type_cname (iface))), VALA_CCODE_DECLARATOR (vala_ccode_variable_declarator_new (vala_interface_get_type_cname (iface)))))));
											(__temp81 == NULL ? NULL : (__temp81 = (g_object_unref (__temp81), NULL)));
											(__temp80 = (g_free (__temp80), NULL));
										}
									}
								}
								(structs == NULL ? NULL : (structs = (g_list_free (structs), NULL)));
								(classes == NULL ? NULL : (classes = (g_list_free (classes), NULL)));
								(ifaces == NULL ? NULL : (ifaces = (g_list_free (ifaces), NULL)));
							}
						}
					}
					(namespaces == NULL ? NULL : (namespaces = (g_list_free (namespaces), NULL)));
				}
			}
		}
	}
	/* generate hardcoded "well-known" macros */
	ValaCCodeMacroReplacement* __temp85 = NULL;
	vala_ccode_fragment_append (self->priv->source_begin, VALA_CCODE_NODE ((__temp85 = vala_ccode_macro_replacement_new ("VALA_FREE_CHECKED(o,f)", "((o) == NULL ? NULL : ((o) = (f (o), NULL)))"))));
	(__temp85 == NULL ? NULL : (__temp85 = (g_object_unref (__temp85), NULL)));
	ValaCCodeMacroReplacement* __temp86 = NULL;
	vala_ccode_fragment_append (self->priv->source_begin, VALA_CCODE_NODE ((__temp86 = vala_ccode_macro_replacement_new ("VALA_FREE_UNCHECKED(o,f)", "((o) = (f (o), NULL))"))));
	(__temp86 == NULL ? NULL : (__temp86 = (g_object_unref (__temp86), NULL)));
	(used_includes == NULL ? NULL : (used_includes = (g_list_free (used_includes), NULL)));
}


static char* vala_code_generator_get_define_for_filename (const char* filename)
{
	g_return_val_if_fail (filename != NULL, NULL);
	GString* define = g_string_new ("__");
	char* i = g_strdup (filename);
	while (g_utf8_strlen (i, -1) > 0) {
		gunichar c = g_utf8_get_char (i);
		if (g_unichar_isalnum (c) && c < 0x80) {
			g_string_append_unichar (define, g_unichar_toupper (c));
		} else {
			g_string_append_c (define, '_');
		}
		char* __temp88 = NULL;
		const char* __temp87 = NULL;
		i = (__temp88 = (__temp87 = g_utf8_next_char (i), (__temp87 == NULL ? NULL : g_strdup (__temp87))), (i = (g_free (i), NULL)), __temp88);
	}
	g_string_append (define, "__");
	const char* __temp89 = NULL;
	char* __temp90 = NULL;
	return (__temp90 = (__temp89 = define->str, (__temp89 == NULL ? NULL : g_strdup (__temp89))), (define == NULL ? NULL : (define = (g_string_free (define, TRUE), NULL))), (i = (g_free (i), NULL)), __temp90);
	(define == NULL ? NULL : (define = (g_string_free (define, TRUE), NULL)));
	(i = (g_free (i), NULL));
}


static void vala_code_generator_real_visit_end_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_SOURCE_FILE (source_file));
	char* __temp91 = NULL;
	char* __temp92 = NULL;
	char* header_define = (__temp92 = vala_code_generator_get_define_for_filename ((__temp91 = vala_source_file_get_cheader_filename (source_file))), (__temp91 = (g_free (__temp91), NULL)), __temp92);
	if (self->priv->string_h_needed) {
		ValaCCodeIncludeDirective* __temp93 = NULL;
		vala_ccode_fragment_append (self->priv->source_include_directives, VALA_CCODE_NODE ((__temp93 = vala_ccode_include_directive_new ("string.h", FALSE))));
		(__temp93 == NULL ? NULL : (__temp93 = (g_object_unref (__temp93), NULL)));
	}
	ValaCCodeComment* comment = NULL;
	if (vala_source_file_get_comment (source_file) != NULL) {
		ValaCCodeComment* __temp94 = NULL;
		comment = (__temp94 = vala_ccode_comment_new (vala_source_file_get_comment (source_file)), (comment == NULL ? NULL : (comment = (g_object_unref (comment), NULL))), __temp94);
	}
	ValaCCodeWriter* writer = vala_ccode_writer_new (vala_source_file_get_cheader_filename (source_file));
	if (comment != NULL) {
		vala_ccode_node_write (VALA_CCODE_NODE (comment), writer);
	}
	vala_ccode_writer_write_newline (writer);
	ValaCCodeOnceSection* once = vala_ccode_once_section_new (header_define);
	ValaCCodeNewline* __temp95 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp95 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp95 == NULL ? NULL : (__temp95 = (g_object_unref (__temp95), NULL)));
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE (self->priv->header_begin));
	ValaCCodeNewline* __temp96 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp96 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp96 == NULL ? NULL : (__temp96 = (g_object_unref (__temp96), NULL)));
	ValaCCodeIdentifier* __temp97 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp97 = vala_ccode_identifier_new ("G_BEGIN_DECLS"))));
	(__temp97 == NULL ? NULL : (__temp97 = (g_object_unref (__temp97), NULL)));
	ValaCCodeNewline* __temp98 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp98 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp98 == NULL ? NULL : (__temp98 = (g_object_unref (__temp98), NULL)));
	ValaCCodeNewline* __temp99 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp99 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp99 == NULL ? NULL : (__temp99 = (g_object_unref (__temp99), NULL)));
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE (self->priv->header_type_declaration));
	ValaCCodeNewline* __temp100 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp100 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp100 == NULL ? NULL : (__temp100 = (g_object_unref (__temp100), NULL)));
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE (self->priv->header_type_definition));
	ValaCCodeNewline* __temp101 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp101 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp101 == NULL ? NULL : (__temp101 = (g_object_unref (__temp101), NULL)));
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE (self->priv->header_type_member_declaration));
	ValaCCodeNewline* __temp102 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp102 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp102 == NULL ? NULL : (__temp102 = (g_object_unref (__temp102), NULL)));
	ValaCCodeIdentifier* __temp103 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp103 = vala_ccode_identifier_new ("G_END_DECLS"))));
	(__temp103 == NULL ? NULL : (__temp103 = (g_object_unref (__temp103), NULL)));
	ValaCCodeNewline* __temp104 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp104 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp104 == NULL ? NULL : (__temp104 = (g_object_unref (__temp104), NULL)));
	ValaCCodeNewline* __temp105 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp105 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp105 == NULL ? NULL : (__temp105 = (g_object_unref (__temp105), NULL)));
	vala_ccode_node_write (VALA_CCODE_NODE (once), writer);
	vala_ccode_writer_close (writer);
	ValaCCodeWriter* __temp106 = NULL;
	writer = (__temp106 = vala_ccode_writer_new (vala_source_file_get_csource_filename (source_file)), (writer == NULL ? NULL : (writer = (g_object_unref (writer), NULL))), __temp106);
	if (comment != NULL) {
		vala_ccode_node_write (VALA_CCODE_NODE (comment), writer);
	}
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->source_begin), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->source_include_directives), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->source_type_member_declaration), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->source_signal_marshaller_declaration), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->source_type_member_definition), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->source_signal_marshaller_definition), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_writer_close (writer);
	ValaCCodeFragment* __temp107 = NULL;
	self->priv->header_begin = (__temp107 = NULL, (self->priv->header_begin == NULL ? NULL : (self->priv->header_begin = (g_object_unref (self->priv->header_begin), NULL))), __temp107);
	ValaCCodeFragment* __temp108 = NULL;
	self->priv->header_type_declaration = (__temp108 = NULL, (self->priv->header_type_declaration == NULL ? NULL : (self->priv->header_type_declaration = (g_object_unref (self->priv->header_type_declaration), NULL))), __temp108);
	ValaCCodeFragment* __temp109 = NULL;
	self->priv->header_type_definition = (__temp109 = NULL, (self->priv->header_type_definition == NULL ? NULL : (self->priv->header_type_definition = (g_object_unref (self->priv->header_type_definition), NULL))), __temp109);
	ValaCCodeFragment* __temp110 = NULL;
	self->priv->header_type_member_declaration = (__temp110 = NULL, (self->priv->header_type_member_declaration == NULL ? NULL : (self->priv->header_type_member_declaration = (g_object_unref (self->priv->header_type_member_declaration), NULL))), __temp110);
	ValaCCodeFragment* __temp111 = NULL;
	self->priv->source_begin = (__temp111 = NULL, (self->priv->source_begin == NULL ? NULL : (self->priv->source_begin = (g_object_unref (self->priv->source_begin), NULL))), __temp111);
	ValaCCodeFragment* __temp112 = NULL;
	self->priv->source_include_directives = (__temp112 = NULL, (self->priv->source_include_directives == NULL ? NULL : (self->priv->source_include_directives = (g_object_unref (self->priv->source_include_directives), NULL))), __temp112);
	ValaCCodeFragment* __temp113 = NULL;
	self->priv->source_type_member_declaration = (__temp113 = NULL, (self->priv->source_type_member_declaration == NULL ? NULL : (self->priv->source_type_member_declaration = (g_object_unref (self->priv->source_type_member_declaration), NULL))), __temp113);
	ValaCCodeFragment* __temp114 = NULL;
	self->priv->source_type_member_definition = (__temp114 = NULL, (self->priv->source_type_member_definition == NULL ? NULL : (self->priv->source_type_member_definition = (g_object_unref (self->priv->source_type_member_definition), NULL))), __temp114);
	ValaCCodeFragment* __temp115 = NULL;
	self->priv->source_signal_marshaller_definition = (__temp115 = NULL, (self->priv->source_signal_marshaller_definition == NULL ? NULL : (self->priv->source_signal_marshaller_definition = (g_object_unref (self->priv->source_signal_marshaller_definition), NULL))), __temp115);
	ValaCCodeFragment* __temp116 = NULL;
	self->priv->source_signal_marshaller_declaration = (__temp116 = NULL, (self->priv->source_signal_marshaller_declaration == NULL ? NULL : (self->priv->source_signal_marshaller_declaration = (g_object_unref (self->priv->source_signal_marshaller_declaration), NULL))), __temp116);
	(header_define = (g_free (header_define), NULL));
	(comment == NULL ? NULL : (comment = (g_object_unref (comment), NULL)));
	(writer == NULL ? NULL : (writer = (g_object_unref (writer), NULL)));
	(once == NULL ? NULL : (once = (g_object_unref (once), NULL)));
}


static void vala_code_generator_real_visit_begin_class (ValaCodeVisitor* base, ValaClass* cl)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CLASS (cl));
	ValaSymbol* __temp118 = NULL;
	ValaSymbol* __temp117 = NULL;
	self->priv->current_symbol = (__temp118 = (__temp117 = vala_code_node_get_symbol (VALA_CODE_NODE (cl)), (__temp117 == NULL ? NULL : g_object_ref (__temp117))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp118);
	ValaSymbol* __temp120 = NULL;
	ValaSymbol* __temp119 = NULL;
	self->priv->current_type_symbol = (__temp120 = (__temp119 = vala_code_node_get_symbol (VALA_CODE_NODE (cl)), (__temp119 == NULL ? NULL : g_object_ref (__temp119))), (self->priv->current_type_symbol == NULL ? NULL : (self->priv->current_type_symbol = (g_object_unref (self->priv->current_type_symbol), NULL))), __temp120);
	ValaClass* __temp121 = NULL;
	self->priv->current_class = (__temp121 = g_object_ref (cl), (self->priv->current_class == NULL ? NULL : (self->priv->current_class = (g_object_unref (self->priv->current_class), NULL))), __temp121);
	if (vala_class_get_is_static (cl)) {
		return;
	}
	ValaCCodeStruct* __temp123 = NULL;
	char* __temp122 = NULL;
	self->priv->instance_struct = (__temp123 = vala_ccode_struct_new (g_strdup_printf ("_%s", (__temp122 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), (self->priv->instance_struct == NULL ? NULL : (self->priv->instance_struct = (g_object_unref (self->priv->instance_struct), NULL))), __temp123);
	(__temp122 = (g_free (__temp122), NULL));
	ValaCCodeStruct* __temp125 = NULL;
	char* __temp124 = NULL;
	self->priv->type_struct = (__temp125 = vala_ccode_struct_new (g_strdup_printf ("_%sClass", (__temp124 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), (self->priv->type_struct == NULL ? NULL : (self->priv->type_struct = (g_object_unref (self->priv->type_struct), NULL))), __temp125);
	(__temp124 = (g_free (__temp124), NULL));
	ValaCCodeStruct* __temp127 = NULL;
	char* __temp126 = NULL;
	self->priv->instance_priv_struct = (__temp127 = vala_ccode_struct_new (g_strdup_printf ("_%sPrivate", (__temp126 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), (self->priv->instance_priv_struct == NULL ? NULL : (self->priv->instance_priv_struct = (g_object_unref (self->priv->instance_priv_struct), NULL))), __temp127);
	(__temp126 = (g_free (__temp126), NULL));
	ValaCCodeEnum* __temp128 = NULL;
	self->priv->prop_enum = (__temp128 = vala_ccode_enum_new (NULL), (self->priv->prop_enum == NULL ? NULL : (self->priv->prop_enum = (g_object_unref (self->priv->prop_enum), NULL))), __temp128);
	char* __temp130 = NULL;
	char* __temp129 = NULL;
	vala_ccode_enum_add_value (self->priv->prop_enum, (__temp130 = g_strdup_printf ("%s_DUMMY_PROPERTY", (__temp129 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))), NULL);
	(__temp130 = (g_free (__temp130), NULL));
	(__temp129 = (g_free (__temp129), NULL));
	ValaCCodeFragment* __temp131 = NULL;
	self->priv->instance_init_fragment = (__temp131 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->instance_init_fragment == NULL ? NULL : (self->priv->instance_init_fragment = (g_object_unref (self->priv->instance_init_fragment), NULL))), __temp131);
	ValaCCodeFragment* __temp132 = NULL;
	self->priv->instance_dispose_fragment = (__temp132 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->instance_dispose_fragment == NULL ? NULL : (self->priv->instance_dispose_fragment = (g_object_unref (self->priv->instance_dispose_fragment), NULL))), __temp132);
	ValaCCodeNewline* __temp133 = NULL;
	vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp133 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp133 == NULL ? NULL : (__temp133 = (g_object_unref (__temp133), NULL)));
	char* __temp134 = NULL;
	char* __temp135 = NULL;
	char* macro = (__temp135 = g_strdup_printf ("(%s_get_type ())", (__temp134 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL))), (__temp134 = (g_free (__temp134), NULL)), __temp135);
	ValaCCodeMacroReplacement* __temp136 = NULL;
	vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp136 = vala_ccode_macro_replacement_new (vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_"), macro))));
	(__temp136 == NULL ? NULL : (__temp136 = (g_object_unref (__temp136), NULL)));
	char* __temp139 = NULL;
	char* __temp138 = NULL;
	char* __temp137 = NULL;
	macro = (__temp139 = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_CAST ((obj), %s, %s))", (__temp137 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_")), (__temp138 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))), (macro = (g_free (macro), NULL)), __temp139);
	(__temp138 = (g_free (__temp138), NULL));
	(__temp137 = (g_free (__temp137), NULL));
	ValaCCodeMacroReplacement* __temp141 = NULL;
	char* __temp140 = NULL;
	vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp141 = vala_ccode_macro_replacement_new (g_strdup_printf ("%s(obj)", (__temp140 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL))), macro))));
	(__temp141 == NULL ? NULL : (__temp141 = (g_object_unref (__temp141), NULL)));
	(__temp140 = (g_free (__temp140), NULL));
	char* __temp144 = NULL;
	char* __temp143 = NULL;
	char* __temp142 = NULL;
	macro = (__temp144 = g_strdup_printf ("(G_TYPE_CHECK_CLASS_CAST ((klass), %s, %sClass))", (__temp142 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_")), (__temp143 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))), (macro = (g_free (macro), NULL)), __temp144);
	(__temp143 = (g_free (__temp143), NULL));
	(__temp142 = (g_free (__temp142), NULL));
	ValaCCodeMacroReplacement* __temp146 = NULL;
	char* __temp145 = NULL;
	vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp146 = vala_ccode_macro_replacement_new (g_strdup_printf ("%s_CLASS(klass)", (__temp145 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL))), macro))));
	(__temp146 == NULL ? NULL : (__temp146 = (g_object_unref (__temp146), NULL)));
	(__temp145 = (g_free (__temp145), NULL));
	char* __temp148 = NULL;
	char* __temp147 = NULL;
	macro = (__temp148 = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_TYPE ((obj), %s))", (__temp147 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_"))), (macro = (g_free (macro), NULL)), __temp148);
	(__temp147 = (g_free (__temp147), NULL));
	ValaCCodeMacroReplacement* __temp150 = NULL;
	char* __temp149 = NULL;
	vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp150 = vala_ccode_macro_replacement_new (g_strdup_printf ("%s(obj)", (__temp149 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "IS_"))), macro))));
	(__temp150 == NULL ? NULL : (__temp150 = (g_object_unref (__temp150), NULL)));
	(__temp149 = (g_free (__temp149), NULL));
	char* __temp152 = NULL;
	char* __temp151 = NULL;
	macro = (__temp152 = g_strdup_printf ("(G_TYPE_CHECK_CLASS_TYPE ((klass), %s))", (__temp151 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_"))), (macro = (g_free (macro), NULL)), __temp152);
	(__temp151 = (g_free (__temp151), NULL));
	ValaCCodeMacroReplacement* __temp154 = NULL;
	char* __temp153 = NULL;
	vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp154 = vala_ccode_macro_replacement_new (g_strdup_printf ("%s_CLASS(klass)", (__temp153 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "IS_"))), macro))));
	(__temp154 == NULL ? NULL : (__temp154 = (g_object_unref (__temp154), NULL)));
	(__temp153 = (g_free (__temp153), NULL));
	char* __temp157 = NULL;
	char* __temp156 = NULL;
	char* __temp155 = NULL;
	macro = (__temp157 = g_strdup_printf ("(G_TYPE_INSTANCE_GET_CLASS ((obj), %s, %sClass))", (__temp155 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_")), (__temp156 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))), (macro = (g_free (macro), NULL)), __temp157);
	(__temp156 = (g_free (__temp156), NULL));
	(__temp155 = (g_free (__temp155), NULL));
	ValaCCodeMacroReplacement* __temp159 = NULL;
	char* __temp158 = NULL;
	vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp159 = vala_ccode_macro_replacement_new (g_strdup_printf ("%s_GET_CLASS(obj)", (__temp158 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL))), macro))));
	(__temp159 == NULL ? NULL : (__temp159 = (g_object_unref (__temp159), NULL)));
	(__temp158 = (g_free (__temp158), NULL));
	ValaCCodeNewline* __temp160 = NULL;
	vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp160 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp160 == NULL ? NULL : (__temp160 = (g_object_unref (__temp160), NULL)));
	if (vala_source_file_get_cycle (vala_source_reference_get_file (vala_code_node_get_source_reference (VALA_CODE_NODE (cl)))) == NULL) {
		ValaCCodeTypeDefinition* __temp161 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp161 = vala_ccode_type_definition_new (g_strdup_printf ("struct %s", vala_ccode_struct_get_name (self->priv->instance_struct)), VALA_CCODE_DECLARATOR (vala_ccode_variable_declarator_new (vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))))));
		(__temp161 == NULL ? NULL : (__temp161 = (g_object_unref (__temp161), NULL)));
		ValaCCodeTypeDefinition* __temp163 = NULL;
		char* __temp162 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp163 = vala_ccode_type_definition_new (g_strdup_printf ("struct %s", vala_ccode_struct_get_name (self->priv->type_struct)), VALA_CCODE_DECLARATOR (vala_ccode_variable_declarator_new (g_strdup_printf ("%sClass", (__temp162 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))))))));
		(__temp163 == NULL ? NULL : (__temp163 = (g_object_unref (__temp163), NULL)));
		(__temp162 = (g_free (__temp162), NULL));
	}
	ValaCCodeTypeDefinition* __temp165 = NULL;
	char* __temp164 = NULL;
	vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp165 = vala_ccode_type_definition_new (g_strdup_printf ("struct %s", vala_ccode_struct_get_name (self->priv->instance_priv_struct)), VALA_CCODE_DECLARATOR (vala_ccode_variable_declarator_new (g_strdup_printf ("%sPrivate", (__temp164 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))))))));
	(__temp165 == NULL ? NULL : (__temp165 = (g_object_unref (__temp165), NULL)));
	(__temp164 = (g_free (__temp164), NULL));
	char* __temp166 = NULL;
	vala_ccode_struct_add_field (self->priv->instance_struct, (__temp166 = vala_data_type_get_cname (VALA_DATA_TYPE (vala_class_get_base_class (cl)), FALSE)), "parent");
	(__temp166 = (g_free (__temp166), NULL));
	char* __temp168 = NULL;
	char* __temp167 = NULL;
	vala_ccode_struct_add_field (self->priv->instance_struct, (__temp168 = g_strdup_printf ("%sPrivate *", (__temp167 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), "priv");
	(__temp168 = (g_free (__temp168), NULL));
	(__temp167 = (g_free (__temp167), NULL));
	char* __temp170 = NULL;
	char* __temp169 = NULL;
	vala_ccode_struct_add_field (self->priv->type_struct, (__temp170 = g_strdup_printf ("%sClass", (__temp169 = vala_data_type_get_cname (VALA_DATA_TYPE (vala_class_get_base_class (cl)), FALSE)))), "parent");
	(__temp170 = (g_free (__temp170), NULL));
	(__temp169 = (g_free (__temp169), NULL));
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (cl))) != NULL) {
		ValaCCodeComment* __temp171 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE ((__temp171 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (cl)))))));
		(__temp171 == NULL ? NULL : (__temp171 = (g_object_unref (__temp171), NULL)));
	}
	vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE (self->priv->instance_struct));
	vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE (self->priv->type_struct));
	vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (self->priv->instance_priv_struct));
	char* __temp174 = NULL;
	char* __temp173 = NULL;
	char* __temp172 = NULL;
	macro = (__temp174 = g_strdup_printf ("(G_TYPE_INSTANCE_GET_PRIVATE ((o), %s, %sPrivate))", (__temp172 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_")), (__temp173 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))), (macro = (g_free (macro), NULL)), __temp174);
	(__temp173 = (g_free (__temp173), NULL));
	(__temp172 = (g_free (__temp172), NULL));
	ValaCCodeMacroReplacement* __temp176 = NULL;
	char* __temp175 = NULL;
	vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((__temp176 = vala_ccode_macro_replacement_new (g_strdup_printf ("%s_GET_PRIVATE(o)", (__temp175 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL))), macro))));
	(__temp176 == NULL ? NULL : (__temp176 = (g_object_unref (__temp176), NULL)));
	(__temp175 = (g_free (__temp175), NULL));
	vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (self->priv->prop_enum));
	(macro = (g_free (macro), NULL));
}


static void vala_code_generator_real_visit_end_class (ValaCodeVisitor* base, ValaClass* cl)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CLASS (cl));
	if (!vala_class_get_is_static (cl)) {
		vala_code_generator_add_get_property_function (self, cl);
		vala_code_generator_add_set_property_function (self, cl);
		vala_code_generator_add_class_init_function (self, cl);
		{
			GList* __temp177 = NULL;
			__temp177 = vala_class_get_base_types (cl);
			GList* base_type_it;
			for (base_type_it = __temp177; base_type_it != NULL; base_type_it = base_type_it->next) {
				ValaTypeReference* base_type = base_type_it->data;
				{
					if (VALA_IS_INTERFACE (vala_type_reference_get_data_type (base_type))) {
						vala_code_generator_add_interface_init_function (self, cl, VALA_INTERFACE (vala_type_reference_get_data_type (base_type)));
					}
				}
			}
			(__temp177 == NULL ? NULL : (__temp177 = (g_list_free (__temp177), NULL)));
		}
		vala_code_generator_add_instance_init_function (self, cl);
		GList* __temp178 = NULL;
		gboolean __temp179;
		if ((__temp179 = vala_code_generator_get_memory_management (self) && (__temp178 = vala_class_get_fields (cl)) != NULL, (__temp178 == NULL ? NULL : (__temp178 = (g_list_free (__temp178), NULL))), __temp179)) {
			vala_code_generator_add_dispose_function (self, cl);
		}
		ValaClassRegisterFunction* type_fun = vala_class_register_function_new (cl);
		vala_type_register_function_init_from_type (VALA_TYPE_REGISTER_FUNCTION (type_fun), self->priv->in_plugin);
		ValaCCodeFragment* __temp180 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((__temp180 = vala_type_register_function_get_declaration (VALA_TYPE_REGISTER_FUNCTION (type_fun)))));
		(__temp180 = (g_object_unref (__temp180), NULL));
		ValaCCodeFragment* __temp181 = NULL;
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE ((__temp181 = vala_type_register_function_get_definition (VALA_TYPE_REGISTER_FUNCTION (type_fun)))));
		(__temp181 = (g_object_unref (__temp181), NULL));
		if (self->priv->in_plugin) {
			/* FIXME resolve potential dependency issues, i.e. base types have to be registered before derived types*/
			char* __temp182 = NULL;
			ValaCCodeFunctionCall* __temp183 = NULL;
			ValaCCodeFunctionCall* register_call = (__temp183 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_register_type", (__temp182 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL)))))), (__temp182 = (g_free (__temp182), NULL)), __temp183);
			ValaCCodeIdentifier* __temp184 = NULL;
			vala_ccode_function_call_add_argument (register_call, VALA_CCODE_EXPRESSION ((__temp184 = vala_ccode_identifier_new (self->priv->module_init_param_name))));
			(__temp184 == NULL ? NULL : (__temp184 = (g_object_unref (__temp184), NULL)));
			ValaCCodeExpressionStatement* __temp185 = NULL;
			vala_ccode_fragment_append (self->priv->module_init_fragment, VALA_CCODE_NODE ((__temp185 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (register_call)))));
			(__temp185 == NULL ? NULL : (__temp185 = (g_object_unref (__temp185), NULL)));
			(register_call == NULL ? NULL : (register_call = (g_object_unref (register_call), NULL)));
		}
		(type_fun == NULL ? NULL : (type_fun = (g_object_unref (type_fun), NULL)));
	}
	ValaSymbol* __temp186 = NULL;
	self->priv->current_type_symbol = (__temp186 = NULL, (self->priv->current_type_symbol == NULL ? NULL : (self->priv->current_type_symbol = (g_object_unref (self->priv->current_type_symbol), NULL))), __temp186);
	ValaClass* __temp187 = NULL;
	self->priv->current_class = (__temp187 = NULL, (self->priv->current_class == NULL ? NULL : (self->priv->current_class = (g_object_unref (self->priv->current_class), NULL))), __temp187);
	ValaCCodeFragment* __temp188 = NULL;
	self->priv->instance_dispose_fragment = (__temp188 = NULL, (self->priv->instance_dispose_fragment == NULL ? NULL : (self->priv->instance_dispose_fragment = (g_object_unref (self->priv->instance_dispose_fragment), NULL))), __temp188);
}


static void vala_code_generator_add_class_init_function (ValaCodeGenerator* self, ValaClass* cl)
{
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	char* __temp189 = NULL;
	ValaCCodeFunction* __temp190 = NULL;
	ValaCCodeFunction* class_init = (__temp190 = vala_ccode_function_new (g_strdup_printf ("%s_class_init", (__temp189 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL))), "void"), (__temp189 = (g_free (__temp189), NULL)), __temp190);
	ValaCCodeFormalParameter* __temp192 = NULL;
	char* __temp191 = NULL;
	vala_ccode_function_add_parameter (class_init, (__temp192 = vala_ccode_formal_parameter_new ("klass", g_strdup_printf ("%sClass *", (__temp191 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))))));
	(__temp192 == NULL ? NULL : (__temp192 = (g_object_unref (__temp192), NULL)));
	(__temp191 = (g_free (__temp191), NULL));
	(vala_ccode_function_set_modifiers (class_init, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_function_get_modifiers (class_init));
	ValaCCodeBlock* init_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	(vala_ccode_function_set_block (class_init, init_block), vala_ccode_function_get_block (class_init));
	ValaCCodeFunctionCall* ccall = NULL;
	/* save pointer to parent class */
	ValaCCodeDeclaration* parent_decl = vala_ccode_declaration_new ("gpointer");
	char* __temp193 = NULL;
	ValaCCodeVariableDeclarator* __temp194 = NULL;
	ValaCCodeVariableDeclarator* parent_var_decl = (__temp194 = vala_ccode_variable_declarator_new (g_strdup_printf ("%s_parent_class", (__temp193 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL)))), (__temp193 = (g_free (__temp193), NULL)), __temp194);
	ValaCCodeConstant* __temp195 = NULL;
	(vala_ccode_variable_declarator_set_initializer (parent_var_decl, VALA_CCODE_EXPRESSION ((__temp195 = vala_ccode_constant_new ("NULL")))), vala_ccode_variable_declarator_get_initializer (parent_var_decl));
	(__temp195 == NULL ? NULL : (__temp195 = (g_object_unref (__temp195), NULL)));
	vala_ccode_declaration_add_declarator (parent_decl, VALA_CCODE_DECLARATOR (parent_var_decl));
	(vala_ccode_declaration_set_modifiers (parent_decl, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_declaration_get_modifiers (parent_decl));
	vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (parent_decl));
	ValaCCodeFunctionCall* __temp196 = NULL;
	ccall = (__temp196 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_type_class_peek_parent"))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp196);
	ValaCCodeIdentifier* __temp197 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp197 = vala_ccode_identifier_new ("klass"))));
	(__temp197 == NULL ? NULL : (__temp197 = (g_object_unref (__temp197), NULL)));
	char* __temp198 = NULL;
	ValaCCodeAssignment* __temp199 = NULL;
	ValaCCodeAssignment* parent_assignment = (__temp199 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_parent_class", (__temp198 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL))))), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (__temp198 = (g_free (__temp198), NULL)), __temp199);
	ValaCCodeExpressionStatement* __temp200 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp200 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (parent_assignment)))));
	(__temp200 == NULL ? NULL : (__temp200 = (g_object_unref (__temp200), NULL)));
	/* add struct for private fields */
	if (vala_class_get_has_private_fields (cl)) {
		ValaCCodeFunctionCall* __temp201 = NULL;
		ccall = (__temp201 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_type_class_add_private"))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp201);
		ValaCCodeIdentifier* __temp202 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp202 = vala_ccode_identifier_new ("klass"))));
		(__temp202 == NULL ? NULL : (__temp202 = (g_object_unref (__temp202), NULL)));
		ValaCCodeConstant* __temp204 = NULL;
		char* __temp203 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp204 = vala_ccode_constant_new (g_strdup_printf ("sizeof (%sPrivate)", (__temp203 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))))));
		(__temp204 == NULL ? NULL : (__temp204 = (g_object_unref (__temp204), NULL)));
		(__temp203 = (g_free (__temp203), NULL));
		ValaCCodeExpressionStatement* __temp205 = NULL;
		vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp205 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
		(__temp205 == NULL ? NULL : (__temp205 = (g_object_unref (__temp205), NULL)));
	}
	/* set property handlers */
	ValaCCodeFunctionCall* __temp206 = NULL;
	ccall = (__temp206 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("G_OBJECT_CLASS"))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp206);
	ValaCCodeIdentifier* __temp207 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp207 = vala_ccode_identifier_new ("klass"))));
	(__temp207 == NULL ? NULL : (__temp207 = (g_object_unref (__temp207), NULL)));
	ValaCCodeExpressionStatement* __temp209 = NULL;
	char* __temp208 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp209 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccall), "get_property")), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_get_property", (__temp208 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp209 == NULL ? NULL : (__temp209 = (g_object_unref (__temp209), NULL)));
	(__temp208 = (g_free (__temp208), NULL));
	ValaCCodeExpressionStatement* __temp211 = NULL;
	char* __temp210 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp211 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccall), "set_property")), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_set_property", (__temp210 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp211 == NULL ? NULL : (__temp211 = (g_object_unref (__temp211), NULL)));
	(__temp210 = (g_free (__temp210), NULL));
	/* set constructor */
	if (vala_class_get_constructor (cl) != NULL) {
		ValaCCodeFunctionCall* ccast = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("G_OBJECT_CLASS")));
		ValaCCodeIdentifier* __temp212 = NULL;
		vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((__temp212 = vala_ccode_identifier_new ("klass"))));
		(__temp212 == NULL ? NULL : (__temp212 = (g_object_unref (__temp212), NULL)));
		ValaCCodeExpressionStatement* __temp214 = NULL;
		char* __temp213 = NULL;
		vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp214 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccast), "constructor")), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_constructor", (__temp213 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
		(__temp214 == NULL ? NULL : (__temp214 = (g_object_unref (__temp214), NULL)));
		(__temp213 = (g_free (__temp213), NULL));
		(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
	}
	/* set dispose function */
	GList* __temp215 = NULL;
	gboolean __temp216;
	if ((__temp216 = vala_code_generator_get_memory_management (self) && (__temp215 = vala_class_get_fields (cl)) != NULL, (__temp215 == NULL ? NULL : (__temp215 = (g_list_free (__temp215), NULL))), __temp216)) {
		ValaCCodeFunctionCall* ccast = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("G_OBJECT_CLASS")));
		ValaCCodeIdentifier* __temp217 = NULL;
		vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((__temp217 = vala_ccode_identifier_new ("klass"))));
		(__temp217 == NULL ? NULL : (__temp217 = (g_object_unref (__temp217), NULL)));
		ValaCCodeExpressionStatement* __temp219 = NULL;
		char* __temp218 = NULL;
		vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp219 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccast), "dispose")), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_dispose", (__temp218 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
		(__temp219 == NULL ? NULL : (__temp219 = (g_object_unref (__temp219), NULL)));
		(__temp218 = (g_free (__temp218), NULL));
		(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
	}
	/* connect overridden methods */
	GList* methods = vala_class_get_methods (cl);
	{
		GList* __temp225 = NULL;
		__temp225 = methods;
		GList* m_it;
		for (m_it = __temp225; m_it != NULL; m_it = m_it->next) {
			ValaMethod* m = m_it->data;
			{
				if (vala_method_get_base_method (m) == NULL) {
					continue;
				}
				ValaCodeNode* __temp220 = NULL;
				ValaCodeNode* base_type = (__temp220 = vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (vala_method_get_base_method (m))))), (__temp220 == NULL ? NULL : g_object_ref (__temp220)));
				char* __temp221 = NULL;
				ValaCCodeFunctionCall* __temp222 = NULL;
				ValaCCodeFunctionCall* ccast = (__temp222 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_CLASS", (__temp221 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE ((VALA_CLASS (base_type))), NULL)))))), (__temp221 = (g_free (__temp221), NULL)), __temp222);
				ValaCCodeIdentifier* __temp223 = NULL;
				vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((__temp223 = vala_ccode_identifier_new ("klass"))));
				(__temp223 == NULL ? NULL : (__temp223 = (g_object_unref (__temp223), NULL)));
				ValaCCodeExpressionStatement* __temp224 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp224 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccast), vala_method_get_name (m))), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_method_get_real_cname (m))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
				(__temp224 == NULL ? NULL : (__temp224 = (g_object_unref (__temp224), NULL)));
				(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
				(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
			}
		}
	}
	{
		GList* __temp238 = NULL;
		__temp238 = vala_class_get_type_parameters (cl);
		GList* type_param_it;
		for (type_param_it = __temp238; type_param_it != NULL; type_param_it = type_param_it->next) {
			ValaTypeParameter* type_param = type_param_it->data;
			{
				/* create destroy_func properties for generic types */
				char* __temp226 = NULL;
				char* __temp227 = NULL;
				char* func_name = (__temp227 = g_strdup_printf ("%s_destroy_func", (__temp226 = g_utf8_strdown (vala_type_parameter_get_name (type_param), -1))), (__temp226 = (g_free (__temp226), NULL)), __temp227);
				char* __temp228 = NULL;
				ValaCCodeConstant* __temp229 = NULL;
				ValaCCodeConstant* func_name_constant = (__temp229 = vala_ccode_constant_new (g_strdup_printf ("\"%s-destroy-func\"", (__temp228 = g_utf8_strdown (vala_type_parameter_get_name (type_param), -1)))), (__temp228 = (g_free (__temp228), NULL)), __temp229);
				char* __temp231 = NULL;
				char* __temp230 = NULL;
				char* __temp232 = NULL;
				char* enum_value = (__temp232 = g_utf8_strup ((__temp231 = g_strdup_printf ("%s_%s", (__temp230 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL)), func_name)), -1), (__temp231 = (g_free (__temp231), NULL)), (__temp230 = (g_free (__temp230), NULL)), __temp232);
				ValaCCodeFunctionCall* cinst = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_object_class_install_property")));
				vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (ccall));
				ValaCCodeConstant* __temp233 = NULL;
				vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((__temp233 = vala_ccode_constant_new (enum_value))));
				(__temp233 == NULL ? NULL : (__temp233 = (g_object_unref (__temp233), NULL)));
				ValaCCodeFunctionCall* cspec = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_param_spec_pointer")));
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (func_name_constant));
				ValaCCodeConstant* __temp234 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp234 = vala_ccode_constant_new ("\"destroy func\""))));
				(__temp234 == NULL ? NULL : (__temp234 = (g_object_unref (__temp234), NULL)));
				ValaCCodeConstant* __temp235 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp235 = vala_ccode_constant_new ("\"destroy func\""))));
				(__temp235 == NULL ? NULL : (__temp235 = (g_object_unref (__temp235), NULL)));
				ValaCCodeConstant* __temp236 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp236 = vala_ccode_constant_new ("G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY"))));
				(__temp236 == NULL ? NULL : (__temp236 = (g_object_unref (__temp236), NULL)));
				vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (cspec));
				ValaCCodeExpressionStatement* __temp237 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp237 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
				(__temp237 == NULL ? NULL : (__temp237 = (g_object_unref (__temp237), NULL)));
				vala_ccode_enum_add_value (self->priv->prop_enum, enum_value, NULL);
				vala_ccode_struct_add_field (self->priv->instance_priv_struct, "GDestroyNotify", func_name);
				(func_name = (g_free (func_name), NULL));
				(func_name_constant == NULL ? NULL : (func_name_constant = (g_object_unref (func_name_constant), NULL)));
				(enum_value = (g_free (enum_value), NULL));
				(cinst == NULL ? NULL : (cinst = (g_object_unref (cinst), NULL)));
				(cspec == NULL ? NULL : (cspec = (g_object_unref (cspec), NULL)));
			}
		}
		(__temp238 == NULL ? NULL : (__temp238 = (g_list_free (__temp238), NULL)));
	}
	/* create properties */
	GList* props = vala_class_get_properties (cl);
	{
		GList* __temp245 = NULL;
		__temp245 = props;
		GList* prop_it;
		for (prop_it = __temp245; prop_it != NULL; prop_it = prop_it->next) {
			ValaProperty* prop = prop_it->data;
			{
				if (vala_property_get_overrides (prop) || vala_property_get_base_interface_property (prop) != NULL) {
					ValaCCodeFunctionCall* cinst = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_object_class_override_property")));
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (ccall));
					ValaCCodeConstant* __temp239 = NULL;
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((__temp239 = vala_ccode_constant_new (vala_property_get_upper_case_cname (prop)))));
					(__temp239 == NULL ? NULL : (__temp239 = (g_object_unref (__temp239), NULL)));
					ValaCCodeConstant* __temp240 = NULL;
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((__temp240 = vala_property_get_canonical_cconstant (prop))));
					(__temp240 = (g_object_unref (__temp240), NULL));
					ValaCCodeExpressionStatement* __temp241 = NULL;
					vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp241 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
					(__temp241 == NULL ? NULL : (__temp241 = (g_object_unref (__temp241), NULL)));
					(cinst == NULL ? NULL : (cinst = (g_object_unref (cinst), NULL)));
				} else {
					ValaCCodeFunctionCall* cinst = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_object_class_install_property")));
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (ccall));
					ValaCCodeConstant* __temp242 = NULL;
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((__temp242 = vala_ccode_constant_new (vala_property_get_upper_case_cname (prop)))));
					(__temp242 == NULL ? NULL : (__temp242 = (g_object_unref (__temp242), NULL)));
					ValaCCodeFunctionCall* __temp243 = NULL;
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((__temp243 = vala_code_generator_get_param_spec (self, prop))));
					(__temp243 = (g_object_unref (__temp243), NULL));
					ValaCCodeExpressionStatement* __temp244 = NULL;
					vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp244 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
					(__temp244 == NULL ? NULL : (__temp244 = (g_object_unref (__temp244), NULL)));
					(cinst == NULL ? NULL : (cinst = (g_object_unref (cinst), NULL)));
				}
			}
		}
	}
	{
		GList* __temp247 = NULL;
		__temp247 = vala_class_get_signals (cl);
		GList* sig_it;
		for (sig_it = __temp247; sig_it != NULL; sig_it = sig_it->next) {
			ValaSignal* sig = sig_it->data;
			{
				/* create signals */
				ValaCCodeExpressionStatement* __temp246 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp246 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_code_generator_get_signal_creation (self, sig, VALA_DATA_TYPE (cl)))))));
				(__temp246 == NULL ? NULL : (__temp246 = (g_object_unref (__temp246), NULL)));
			}
		}
		(__temp247 == NULL ? NULL : (__temp247 = (g_list_free (__temp247), NULL)));
	}
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (class_init));
	(class_init == NULL ? NULL : (class_init = (g_object_unref (class_init), NULL)));
	(init_block == NULL ? NULL : (init_block = (g_object_unref (init_block), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(parent_decl == NULL ? NULL : (parent_decl = (g_object_unref (parent_decl), NULL)));
	(parent_var_decl == NULL ? NULL : (parent_var_decl = (g_object_unref (parent_var_decl), NULL)));
	(parent_assignment == NULL ? NULL : (parent_assignment = (g_object_unref (parent_assignment), NULL)));
	(methods == NULL ? NULL : (methods = (g_list_free (methods), NULL)));
	(props == NULL ? NULL : (props = (g_list_free (props), NULL)));
}


static void vala_code_generator_add_interface_init_function (ValaCodeGenerator* self, ValaClass* cl, ValaInterface* iface)
{
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	g_return_if_fail (VALA_IS_INTERFACE (iface));
	char* __temp249 = NULL;
	char* __temp248 = NULL;
	ValaCCodeFunction* __temp250 = NULL;
	ValaCCodeFunction* iface_init = (__temp250 = vala_ccode_function_new (g_strdup_printf ("%s_%s_interface_init", (__temp248 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL)), (__temp249 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (iface), NULL))), "void"), (__temp249 = (g_free (__temp249), NULL)), (__temp248 = (g_free (__temp248), NULL)), __temp250);
	ValaCCodeFormalParameter* __temp252 = NULL;
	char* __temp251 = NULL;
	vala_ccode_function_add_parameter (iface_init, (__temp252 = vala_ccode_formal_parameter_new ("iface", g_strdup_printf ("%s *", (__temp251 = vala_interface_get_type_cname (iface))))));
	(__temp252 == NULL ? NULL : (__temp252 = (g_object_unref (__temp252), NULL)));
	(__temp251 = (g_free (__temp251), NULL));
	(vala_ccode_function_set_modifiers (iface_init, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_function_get_modifiers (iface_init));
	ValaCCodeBlock* init_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	(vala_ccode_function_set_block (iface_init, init_block), vala_ccode_function_get_block (iface_init));
	ValaCCodeFunctionCall* ccall = NULL;
	/* save pointer to parent vtable */
	char* __temp254 = NULL;
	char* __temp253 = NULL;
	char* __temp255 = NULL;
	char* parent_iface_var = (__temp255 = g_strdup_printf ("%s_%s_parent_iface", (__temp253 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL)), (__temp254 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (iface), NULL))), (__temp254 = (g_free (__temp254), NULL)), (__temp253 = (g_free (__temp253), NULL)), __temp255);
	char* __temp256 = NULL;
	ValaCCodeDeclaration* __temp257 = NULL;
	ValaCCodeDeclaration* parent_decl = (__temp257 = vala_ccode_declaration_new (g_strconcat ((__temp256 = vala_interface_get_type_cname (iface)), "*", NULL)), (__temp256 = (g_free (__temp256), NULL)), __temp257);
	ValaCCodeVariableDeclarator* parent_var_decl = vala_ccode_variable_declarator_new (parent_iface_var);
	ValaCCodeConstant* __temp258 = NULL;
	(vala_ccode_variable_declarator_set_initializer (parent_var_decl, VALA_CCODE_EXPRESSION ((__temp258 = vala_ccode_constant_new ("NULL")))), vala_ccode_variable_declarator_get_initializer (parent_var_decl));
	(__temp258 == NULL ? NULL : (__temp258 = (g_object_unref (__temp258), NULL)));
	vala_ccode_declaration_add_declarator (parent_decl, VALA_CCODE_DECLARATOR (parent_var_decl));
	(vala_ccode_declaration_set_modifiers (parent_decl, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_declaration_get_modifiers (parent_decl));
	vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (parent_decl));
	ValaCCodeFunctionCall* __temp259 = NULL;
	ccall = (__temp259 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_type_interface_peek_parent"))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp259);
	ValaCCodeIdentifier* __temp260 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp260 = vala_ccode_identifier_new ("iface"))));
	(__temp260 == NULL ? NULL : (__temp260 = (g_object_unref (__temp260), NULL)));
	ValaCCodeAssignment* parent_assignment = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (parent_iface_var)), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	ValaCCodeExpressionStatement* __temp261 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp261 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (parent_assignment)))));
	(__temp261 == NULL ? NULL : (__temp261 = (g_object_unref (__temp261), NULL)));
	GList* methods = vala_class_get_methods (cl);
	{
		GList* __temp264 = NULL;
		__temp264 = methods;
		GList* m_it;
		for (m_it = __temp264; m_it != NULL; m_it = m_it->next) {
			ValaMethod* m = m_it->data;
			{
				if (vala_method_get_base_interface_method (m) == NULL) {
					continue;
				}
				ValaCodeNode* __temp262 = NULL;
				ValaCodeNode* base_type = (__temp262 = vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (vala_method_get_base_interface_method (m))))), (__temp262 == NULL ? NULL : g_object_ref (__temp262)));
				if (base_type != VALA_CODE_NODE (iface)) {
					continue;
				}
				ValaCCodeIdentifier* ciface = vala_ccode_identifier_new ("iface");
				ValaCCodeExpressionStatement* __temp263 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp263 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ciface), vala_method_get_name (m))), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_method_get_real_cname (m))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
				(__temp263 == NULL ? NULL : (__temp263 = (g_object_unref (__temp263), NULL)));
				(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
				(ciface == NULL ? NULL : (ciface = (g_object_unref (ciface), NULL)));
			}
		}
	}
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (iface_init));
	(iface_init == NULL ? NULL : (iface_init = (g_object_unref (iface_init), NULL)));
	(init_block == NULL ? NULL : (init_block = (g_object_unref (init_block), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(parent_iface_var = (g_free (parent_iface_var), NULL));
	(parent_decl == NULL ? NULL : (parent_decl = (g_object_unref (parent_decl), NULL)));
	(parent_var_decl == NULL ? NULL : (parent_var_decl = (g_object_unref (parent_var_decl), NULL)));
	(parent_assignment == NULL ? NULL : (parent_assignment = (g_object_unref (parent_assignment), NULL)));
	(methods == NULL ? NULL : (methods = (g_list_free (methods), NULL)));
}


static void vala_code_generator_add_instance_init_function (ValaCodeGenerator* self, ValaClass* cl)
{
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	char* __temp265 = NULL;
	ValaCCodeFunction* __temp266 = NULL;
	ValaCCodeFunction* instance_init = (__temp266 = vala_ccode_function_new (g_strdup_printf ("%s_init", (__temp265 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL))), "void"), (__temp265 = (g_free (__temp265), NULL)), __temp266);
	ValaCCodeFormalParameter* __temp268 = NULL;
	char* __temp267 = NULL;
	vala_ccode_function_add_parameter (instance_init, (__temp268 = vala_ccode_formal_parameter_new ("self", g_strdup_printf ("%s *", (__temp267 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))))));
	(__temp268 == NULL ? NULL : (__temp268 = (g_object_unref (__temp268), NULL)));
	(__temp267 = (g_free (__temp267), NULL));
	(vala_ccode_function_set_modifiers (instance_init, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_function_get_modifiers (instance_init));
	ValaCCodeBlock* init_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	(vala_ccode_function_set_block (instance_init, init_block), vala_ccode_function_get_block (instance_init));
	if (vala_class_get_has_private_fields (cl)) {
		char* __temp269 = NULL;
		ValaCCodeFunctionCall* __temp270 = NULL;
		ValaCCodeFunctionCall* ccall = (__temp270 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_GET_PRIVATE", (__temp269 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))))), (__temp269 = (g_free (__temp269), NULL)), __temp270);
		ValaCCodeIdentifier* __temp271 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp271 = vala_ccode_identifier_new ("self"))));
		(__temp271 == NULL ? NULL : (__temp271 = (g_object_unref (__temp271), NULL)));
		ValaCCodeExpressionStatement* __temp272 = NULL;
		vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp272 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), "priv")), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
		(__temp272 == NULL ? NULL : (__temp272 = (g_object_unref (__temp272), NULL)));
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	}
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE (self->priv->instance_init_fragment));
	ValaSymbol* init_sym = vala_symbol_lookup (vala_code_node_get_symbol (VALA_CODE_NODE (cl)), "init");
	if (init_sym != NULL) {
		ValaMethod* __temp273 = NULL;
		ValaMethod* init_fun = (__temp273 = VALA_METHOD (vala_symbol_get_node (init_sym)), (__temp273 == NULL ? NULL : g_object_ref (__temp273)));
		vala_ccode_block_add_statement (init_block, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_method_get_body (init_fun))));
		(init_fun == NULL ? NULL : (init_fun = (g_object_unref (init_fun), NULL)));
	}
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (instance_init));
	(instance_init == NULL ? NULL : (instance_init = (g_object_unref (instance_init), NULL)));
	(init_block == NULL ? NULL : (init_block = (g_object_unref (init_block), NULL)));
	(init_sym == NULL ? NULL : (init_sym = (g_object_unref (init_sym), NULL)));
}


static void vala_code_generator_add_dispose_function (ValaCodeGenerator* self, ValaClass* cl)
{
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	ValaCCodeFunction* __temp275 = NULL;
	char* __temp274 = NULL;
	self->priv->function = (__temp275 = vala_ccode_function_new (g_strdup_printf ("%s_dispose", (__temp274 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL))), "void"), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), __temp275);
	(__temp274 = (g_free (__temp274), NULL));
	(vala_ccode_function_set_modifiers (self->priv->function, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_function_get_modifiers (self->priv->function));
	ValaCCodeFormalParameter* __temp276 = NULL;
	vala_ccode_function_add_parameter (self->priv->function, (__temp276 = vala_ccode_formal_parameter_new ("obj", "GObject *")));
	(__temp276 == NULL ? NULL : (__temp276 = (g_object_unref (__temp276), NULL)));
	ValaCCodeFunction* __temp277 = NULL;
	vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((__temp277 = vala_ccode_function_copy (self->priv->function))));
	(__temp277 = (g_object_unref (__temp277), NULL));
	ValaCCodeBlock* cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	ValaCCodeFunctionCall* ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL))));
	ValaCCodeIdentifier* __temp278 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp278 = vala_ccode_identifier_new ("obj"))));
	(__temp278 == NULL ? NULL : (__temp278 = (g_object_unref (__temp278), NULL)));
	char* __temp279 = NULL;
	ValaCCodeDeclaration* __temp280 = NULL;
	ValaCCodeDeclaration* cdecl = (__temp280 = vala_ccode_declaration_new (g_strdup_printf ("%s *", (__temp279 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), (__temp279 = (g_free (__temp279), NULL)), __temp280);
	ValaCCodeVariableDeclarator* __temp281 = NULL;
	vala_ccode_declaration_add_declarator (cdecl, VALA_CCODE_DECLARATOR ((__temp281 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
	(__temp281 == NULL ? NULL : (__temp281 = (g_object_unref (__temp281), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (self->priv->instance_dispose_fragment));
	ValaCCodeDeclaration* __temp283 = NULL;
	char* __temp282 = NULL;
	cdecl = (__temp283 = vala_ccode_declaration_new (g_strdup_printf ("%sClass *", (__temp282 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), (cdecl == NULL ? NULL : (cdecl = (g_object_unref (cdecl), NULL))), __temp283);
	(__temp282 = (g_free (__temp282), NULL));
	ValaCCodeVariableDeclarator* __temp284 = NULL;
	vala_ccode_declaration_add_declarator (cdecl, VALA_CCODE_DECLARATOR ((__temp284 = vala_ccode_variable_declarator_new ("klass"))));
	(__temp284 == NULL ? NULL : (__temp284 = (g_object_unref (__temp284), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl));
	ValaCCodeDeclaration* __temp285 = NULL;
	cdecl = (__temp285 = vala_ccode_declaration_new ("GObjectClass *"), (cdecl == NULL ? NULL : (cdecl = (g_object_unref (cdecl), NULL))), __temp285);
	ValaCCodeVariableDeclarator* __temp286 = NULL;
	vala_ccode_declaration_add_declarator (cdecl, VALA_CCODE_DECLARATOR ((__temp286 = vala_ccode_variable_declarator_new ("parent_class"))));
	(__temp286 == NULL ? NULL : (__temp286 = (g_object_unref (__temp286), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl));
	ValaCCodeFunctionCall* __temp287 = NULL;
	ccall = (__temp287 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_type_class_peek"))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp287);
	ValaCCodeIdentifier* __temp288 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp288 = vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_")))));
	(__temp288 == NULL ? NULL : (__temp288 = (g_object_unref (__temp288), NULL)));
	char* __temp289 = NULL;
	ValaCCodeFunctionCall* __temp290 = NULL;
	ValaCCodeFunctionCall* ccast = (__temp290 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_CLASS", (__temp289 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))))), (__temp289 = (g_free (__temp289), NULL)), __temp290);
	vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION (ccall));
	ValaCCodeExpressionStatement* __temp291 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp291 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("klass")), VALA_CCODE_EXPRESSION (ccast), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp291 == NULL ? NULL : (__temp291 = (g_object_unref (__temp291), NULL)));
	ValaCCodeFunctionCall* __temp292 = NULL;
	ccall = (__temp292 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_type_class_peek_parent"))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp292);
	ValaCCodeIdentifier* __temp293 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp293 = vala_ccode_identifier_new ("klass"))));
	(__temp293 == NULL ? NULL : (__temp293 = (g_object_unref (__temp293), NULL)));
	ValaCCodeFunctionCall* __temp294 = NULL;
	ccast = (__temp294 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("G_OBJECT_CLASS"))), (ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL))), __temp294);
	vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION (ccall));
	ValaCCodeExpressionStatement* __temp295 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp295 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("parent_class")), VALA_CCODE_EXPRESSION (ccast), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp295 == NULL ? NULL : (__temp295 = (g_object_unref (__temp295), NULL)));
	ValaCCodeFunctionCall* __temp296 = NULL;
	ccall = (__temp296 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("parent_class")), "dispose"))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp296);
	ValaCCodeIdentifier* __temp297 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp297 = vala_ccode_identifier_new ("obj"))));
	(__temp297 == NULL ? NULL : (__temp297 = (g_object_unref (__temp297), NULL)));
	ValaCCodeExpressionStatement* __temp298 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp298 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
	(__temp298 == NULL ? NULL : (__temp298 = (g_object_unref (__temp298), NULL)));
	(vala_ccode_function_set_block (self->priv->function, cblock), vala_ccode_function_get_block (self->priv->function));
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (self->priv->function));
	(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(cdecl == NULL ? NULL : (cdecl = (g_object_unref (cdecl), NULL)));
	(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
}


static ValaCCodeIdentifier* vala_code_generator_get_value_setter_function (ValaCodeGenerator* self, ValaTypeReference* type_reference)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (type_reference), NULL);
	if (VALA_IS_CLASS (vala_type_reference_get_data_type (type_reference)) || VALA_IS_INTERFACE (vala_type_reference_get_data_type (type_reference))) {
		return vala_ccode_identifier_new ("g_value_set_object");
	} else {
		if (vala_type_reference_get_data_type (type_reference) == vala_type_reference_get_data_type (self->priv->string_type)) {
			return vala_ccode_identifier_new ("g_value_set_string");
		} else {
			if (vala_type_reference_get_data_type (type_reference) == vala_type_reference_get_data_type (self->priv->int_type) || VALA_IS_ENUM (vala_type_reference_get_data_type (type_reference))) {
				return vala_ccode_identifier_new ("g_value_set_int");
			} else {
				if (vala_type_reference_get_data_type (type_reference) == vala_type_reference_get_data_type (self->priv->uint_type)) {
					return vala_ccode_identifier_new ("g_value_set_uint");
				} else {
					if (vala_type_reference_get_data_type (type_reference) == vala_type_reference_get_data_type (self->priv->long_type)) {
						return vala_ccode_identifier_new ("g_value_set_long");
					} else {
						if (vala_type_reference_get_data_type (type_reference) == vala_type_reference_get_data_type (self->priv->ulong_type)) {
							return vala_ccode_identifier_new ("g_value_set_ulong");
						} else {
							if (vala_type_reference_get_data_type (type_reference) == vala_type_reference_get_data_type (self->priv->bool_type)) {
								return vala_ccode_identifier_new ("g_value_set_boolean");
							} else {
								if (vala_type_reference_get_data_type (type_reference) == vala_type_reference_get_data_type (self->priv->float_type)) {
									return vala_ccode_identifier_new ("g_value_set_float");
								} else {
									if (vala_type_reference_get_data_type (type_reference) == vala_type_reference_get_data_type (self->priv->double_type)) {
										return vala_ccode_identifier_new ("g_value_set_double");
									} else {
										return vala_ccode_identifier_new ("g_value_set_pointer");
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


static void vala_code_generator_add_get_property_function (ValaCodeGenerator* self, ValaClass* cl)
{
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	char* __temp309 = NULL;
	ValaCCodeFunction* __temp310 = NULL;
	ValaCCodeFunction* get_prop = (__temp310 = vala_ccode_function_new (g_strdup_printf ("%s_get_property", (__temp309 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL))), "void"), (__temp309 = (g_free (__temp309), NULL)), __temp310);
	(vala_ccode_function_set_modifiers (get_prop, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_function_get_modifiers (get_prop));
	ValaCCodeFormalParameter* __temp311 = NULL;
	vala_ccode_function_add_parameter (get_prop, (__temp311 = vala_ccode_formal_parameter_new ("object", "GObject *")));
	(__temp311 == NULL ? NULL : (__temp311 = (g_object_unref (__temp311), NULL)));
	ValaCCodeFormalParameter* __temp312 = NULL;
	vala_ccode_function_add_parameter (get_prop, (__temp312 = vala_ccode_formal_parameter_new ("property_id", "guint")));
	(__temp312 == NULL ? NULL : (__temp312 = (g_object_unref (__temp312), NULL)));
	ValaCCodeFormalParameter* __temp313 = NULL;
	vala_ccode_function_add_parameter (get_prop, (__temp313 = vala_ccode_formal_parameter_new ("value", "GValue *")));
	(__temp313 == NULL ? NULL : (__temp313 = (g_object_unref (__temp313), NULL)));
	ValaCCodeFormalParameter* __temp314 = NULL;
	vala_ccode_function_add_parameter (get_prop, (__temp314 = vala_ccode_formal_parameter_new ("pspec", "GParamSpec *")));
	(__temp314 == NULL ? NULL : (__temp314 = (g_object_unref (__temp314), NULL)));
	ValaCCodeBlock* block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	ValaCCodeFunctionCall* ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL))));
	ValaCCodeIdentifier* __temp315 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp315 = vala_ccode_identifier_new ("object"))));
	(__temp315 == NULL ? NULL : (__temp315 = (g_object_unref (__temp315), NULL)));
	char* __temp316 = NULL;
	ValaCCodeDeclaration* __temp317 = NULL;
	ValaCCodeDeclaration* cdecl = (__temp317 = vala_ccode_declaration_new (g_strdup_printf ("%s *", (__temp316 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), (__temp316 = (g_free (__temp316), NULL)), __temp317);
	ValaCCodeVariableDeclarator* __temp318 = NULL;
	vala_ccode_declaration_add_declarator (cdecl, VALA_CCODE_DECLARATOR ((__temp318 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
	(__temp318 == NULL ? NULL : (__temp318 = (g_object_unref (__temp318), NULL)));
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cdecl));
	ValaCCodeSwitchStatement* cswitch = vala_ccode_switch_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("property_id")));
	GList* props = vala_class_get_properties (cl);
	{
		GList* __temp325 = NULL;
		__temp325 = props;
		GList* prop_it;
		for (prop_it = __temp325; prop_it != NULL; prop_it = prop_it->next) {
			ValaProperty* prop = prop_it->data;
			{
				if (vala_property_get_get_accessor (prop) == NULL || vala_property_get_is_abstract (prop)) {
					continue;
				}
				gboolean is_virtual = vala_property_get_base_property (prop) != NULL || vala_property_get_base_interface_property (prop) != NULL;
				char* prefix = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL);
				if (is_virtual) {
					char* __temp319 = NULL;
					prefix = (__temp319 = g_strconcat (prefix, ("_real"), NULL), (prefix = (g_free (prefix), NULL)), __temp319);
				}
				ValaCCodeCaseStatement* ccase = vala_ccode_case_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_property_get_upper_case_cname (prop))));
				ValaCCodeFunctionCall* ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_get_%s", prefix, vala_property_get_name (prop)))));
				ValaCCodeIdentifier* __temp320 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp320 = vala_ccode_identifier_new ("self"))));
				(__temp320 == NULL ? NULL : (__temp320 = (g_object_unref (__temp320), NULL)));
				ValaCCodeFunctionCall* csetcall = vala_ccode_function_call_new (NULL);
				ValaCCodeIdentifier* __temp321 = NULL;
				(vala_ccode_function_call_set_call (csetcall, VALA_CCODE_EXPRESSION ((__temp321 = vala_code_generator_get_value_setter_function (self, vala_property_get_type_reference (prop))))), vala_ccode_function_call_get_call (csetcall));
				(__temp321 = (g_object_unref (__temp321), NULL));
				ValaCCodeIdentifier* __temp322 = NULL;
				vala_ccode_function_call_add_argument (csetcall, VALA_CCODE_EXPRESSION ((__temp322 = vala_ccode_identifier_new ("value"))));
				(__temp322 == NULL ? NULL : (__temp322 = (g_object_unref (__temp322), NULL)));
				vala_ccode_function_call_add_argument (csetcall, VALA_CCODE_EXPRESSION (ccall));
				ValaCCodeExpressionStatement* __temp323 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((__temp323 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (csetcall)))));
				(__temp323 == NULL ? NULL : (__temp323 = (g_object_unref (__temp323), NULL)));
				ValaCCodeBreakStatement* __temp324 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((__temp324 = g_object_new (VALA_TYPE_CCODE_BREAK_STATEMENT, NULL))));
				(__temp324 == NULL ? NULL : (__temp324 = (g_object_unref (__temp324), NULL)));
				vala_ccode_switch_statement_add_case (cswitch, ccase);
				(prefix = (g_free (prefix), NULL));
				(ccase == NULL ? NULL : (ccase = (g_object_unref (ccase), NULL)));
				(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
				(csetcall == NULL ? NULL : (csetcall = (g_object_unref (csetcall), NULL)));
			}
		}
	}
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cswitch));
	(vala_ccode_function_set_block (get_prop, block), vala_ccode_function_get_block (get_prop));
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (get_prop));
	(get_prop == NULL ? NULL : (get_prop = (g_object_unref (get_prop), NULL)));
	(block == NULL ? NULL : (block = (g_object_unref (block), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(cdecl == NULL ? NULL : (cdecl = (g_object_unref (cdecl), NULL)));
	(cswitch == NULL ? NULL : (cswitch = (g_object_unref (cswitch), NULL)));
	(props == NULL ? NULL : (props = (g_list_free (props), NULL)));
}


static void vala_code_generator_add_set_property_function (ValaCodeGenerator* self, ValaClass* cl)
{
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	char* __temp326 = NULL;
	ValaCCodeFunction* __temp327 = NULL;
	ValaCCodeFunction* set_prop = (__temp327 = vala_ccode_function_new (g_strdup_printf ("%s_set_property", (__temp326 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL))), "void"), (__temp326 = (g_free (__temp326), NULL)), __temp327);
	(vala_ccode_function_set_modifiers (set_prop, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_function_get_modifiers (set_prop));
	ValaCCodeFormalParameter* __temp328 = NULL;
	vala_ccode_function_add_parameter (set_prop, (__temp328 = vala_ccode_formal_parameter_new ("object", "GObject *")));
	(__temp328 == NULL ? NULL : (__temp328 = (g_object_unref (__temp328), NULL)));
	ValaCCodeFormalParameter* __temp329 = NULL;
	vala_ccode_function_add_parameter (set_prop, (__temp329 = vala_ccode_formal_parameter_new ("property_id", "guint")));
	(__temp329 == NULL ? NULL : (__temp329 = (g_object_unref (__temp329), NULL)));
	ValaCCodeFormalParameter* __temp330 = NULL;
	vala_ccode_function_add_parameter (set_prop, (__temp330 = vala_ccode_formal_parameter_new ("value", "const GValue *")));
	(__temp330 == NULL ? NULL : (__temp330 = (g_object_unref (__temp330), NULL)));
	ValaCCodeFormalParameter* __temp331 = NULL;
	vala_ccode_function_add_parameter (set_prop, (__temp331 = vala_ccode_formal_parameter_new ("pspec", "GParamSpec *")));
	(__temp331 == NULL ? NULL : (__temp331 = (g_object_unref (__temp331), NULL)));
	ValaCCodeBlock* block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	ValaCCodeFunctionCall* ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL))));
	ValaCCodeIdentifier* __temp332 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp332 = vala_ccode_identifier_new ("object"))));
	(__temp332 == NULL ? NULL : (__temp332 = (g_object_unref (__temp332), NULL)));
	char* __temp333 = NULL;
	ValaCCodeDeclaration* __temp334 = NULL;
	ValaCCodeDeclaration* cdecl = (__temp334 = vala_ccode_declaration_new (g_strdup_printf ("%s *", (__temp333 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), (__temp333 = (g_free (__temp333), NULL)), __temp334);
	ValaCCodeVariableDeclarator* __temp335 = NULL;
	vala_ccode_declaration_add_declarator (cdecl, VALA_CCODE_DECLARATOR ((__temp335 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
	(__temp335 == NULL ? NULL : (__temp335 = (g_object_unref (__temp335), NULL)));
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cdecl));
	ValaCCodeSwitchStatement* cswitch = vala_ccode_switch_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("property_id")));
	GList* props = vala_class_get_properties (cl);
	{
		GList* __temp351 = NULL;
		__temp351 = props;
		GList* prop_it;
		for (prop_it = __temp351; prop_it != NULL; prop_it = prop_it->next) {
			ValaProperty* prop = prop_it->data;
			{
				if (vala_property_get_set_accessor (prop) == NULL || vala_property_get_is_abstract (prop)) {
					continue;
				}
				gboolean is_virtual = vala_property_get_base_property (prop) != NULL || vala_property_get_base_interface_property (prop) != NULL;
				char* prefix = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL);
				if (is_virtual) {
					char* __temp336 = NULL;
					prefix = (__temp336 = g_strconcat (prefix, ("_real"), NULL), (prefix = (g_free (prefix), NULL)), __temp336);
				}
				ValaCCodeCaseStatement* ccase = vala_ccode_case_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_property_get_upper_case_cname (prop))));
				ValaCCodeFunctionCall* ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_set_%s", prefix, vala_property_get_name (prop)))));
				ValaCCodeIdentifier* __temp337 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp337 = vala_ccode_identifier_new ("self"))));
				(__temp337 == NULL ? NULL : (__temp337 = (g_object_unref (__temp337), NULL)));
				ValaCCodeFunctionCall* cgetcall = vala_ccode_function_call_new (NULL);
				if (VALA_IS_CLASS (vala_type_reference_get_data_type (vala_property_get_type_reference (prop))) || VALA_IS_INTERFACE (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)))) {
					ValaCCodeIdentifier* __temp338 = NULL;
					(vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp338 = vala_ccode_identifier_new ("g_value_get_object")))), vala_ccode_function_call_get_call (cgetcall));
					(__temp338 == NULL ? NULL : (__temp338 = (g_object_unref (__temp338), NULL)));
				} else {
					if (g_utf8_collate (vala_type_reference_get_type_name (vala_property_get_type_reference (prop)), "string") == 0) {
						ValaCCodeIdentifier* __temp339 = NULL;
						(vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp339 = vala_ccode_identifier_new ("g_value_get_string")))), vala_ccode_function_call_get_call (cgetcall));
						(__temp339 == NULL ? NULL : (__temp339 = (g_object_unref (__temp339), NULL)));
					} else {
						if (g_utf8_collate (vala_type_reference_get_type_name (vala_property_get_type_reference (prop)), "int") == 0 || VALA_IS_ENUM (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)))) {
							ValaCCodeIdentifier* __temp340 = NULL;
							(vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp340 = vala_ccode_identifier_new ("g_value_get_int")))), vala_ccode_function_call_get_call (cgetcall));
							(__temp340 == NULL ? NULL : (__temp340 = (g_object_unref (__temp340), NULL)));
						} else {
							if (g_utf8_collate (vala_type_reference_get_type_name (vala_property_get_type_reference (prop)), "uint") == 0) {
								ValaCCodeIdentifier* __temp341 = NULL;
								(vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp341 = vala_ccode_identifier_new ("g_value_get_uint")))), vala_ccode_function_call_get_call (cgetcall));
								(__temp341 == NULL ? NULL : (__temp341 = (g_object_unref (__temp341), NULL)));
							} else {
								if (g_utf8_collate (vala_type_reference_get_type_name (vala_property_get_type_reference (prop)), "long") == 0) {
									ValaCCodeIdentifier* __temp342 = NULL;
									(vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp342 = vala_ccode_identifier_new ("g_value_get_long")))), vala_ccode_function_call_get_call (cgetcall));
									(__temp342 == NULL ? NULL : (__temp342 = (g_object_unref (__temp342), NULL)));
								} else {
									if (g_utf8_collate (vala_type_reference_get_type_name (vala_property_get_type_reference (prop)), "ulong") == 0) {
										ValaCCodeIdentifier* __temp343 = NULL;
										(vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp343 = vala_ccode_identifier_new ("g_value_get_ulong")))), vala_ccode_function_call_get_call (cgetcall));
										(__temp343 == NULL ? NULL : (__temp343 = (g_object_unref (__temp343), NULL)));
									} else {
										if (g_utf8_collate (vala_type_reference_get_type_name (vala_property_get_type_reference (prop)), "bool") == 0) {
											ValaCCodeIdentifier* __temp344 = NULL;
											(vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp344 = vala_ccode_identifier_new ("g_value_get_boolean")))), vala_ccode_function_call_get_call (cgetcall));
											(__temp344 == NULL ? NULL : (__temp344 = (g_object_unref (__temp344), NULL)));
										} else {
											if (g_utf8_collate (vala_type_reference_get_type_name (vala_property_get_type_reference (prop)), "float") == 0) {
												ValaCCodeIdentifier* __temp345 = NULL;
												(vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp345 = vala_ccode_identifier_new ("g_value_get_float")))), vala_ccode_function_call_get_call (cgetcall));
												(__temp345 == NULL ? NULL : (__temp345 = (g_object_unref (__temp345), NULL)));
											} else {
												if (g_utf8_collate (vala_type_reference_get_type_name (vala_property_get_type_reference (prop)), "double") == 0) {
													ValaCCodeIdentifier* __temp346 = NULL;
													(vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp346 = vala_ccode_identifier_new ("g_value_get_double")))), vala_ccode_function_call_get_call (cgetcall));
													(__temp346 == NULL ? NULL : (__temp346 = (g_object_unref (__temp346), NULL)));
												} else {
													ValaCCodeIdentifier* __temp347 = NULL;
													(vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp347 = vala_ccode_identifier_new ("g_value_get_pointer")))), vala_ccode_function_call_get_call (cgetcall));
													(__temp347 == NULL ? NULL : (__temp347 = (g_object_unref (__temp347), NULL)));
												}
											}
										}
									}
								}
							}
						}
					}
				}
				ValaCCodeIdentifier* __temp348 = NULL;
				vala_ccode_function_call_add_argument (cgetcall, VALA_CCODE_EXPRESSION ((__temp348 = vala_ccode_identifier_new ("value"))));
				(__temp348 == NULL ? NULL : (__temp348 = (g_object_unref (__temp348), NULL)));
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (cgetcall));
				ValaCCodeExpressionStatement* __temp349 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((__temp349 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
				(__temp349 == NULL ? NULL : (__temp349 = (g_object_unref (__temp349), NULL)));
				ValaCCodeBreakStatement* __temp350 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((__temp350 = g_object_new (VALA_TYPE_CCODE_BREAK_STATEMENT, NULL))));
				(__temp350 == NULL ? NULL : (__temp350 = (g_object_unref (__temp350), NULL)));
				vala_ccode_switch_statement_add_case (cswitch, ccase);
				(prefix = (g_free (prefix), NULL));
				(ccase == NULL ? NULL : (ccase = (g_object_unref (ccase), NULL)));
				(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
				(cgetcall == NULL ? NULL : (cgetcall = (g_object_unref (cgetcall), NULL)));
			}
		}
	}
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cswitch));
	{
		GList* __temp360 = NULL;
		__temp360 = vala_class_get_type_parameters (cl);
		GList* type_param_it;
		for (type_param_it = __temp360; type_param_it != NULL; type_param_it = type_param_it->next) {
			ValaTypeParameter* type_param = type_param_it->data;
			{
				/* destroy func properties for generic types */
				char* __temp352 = NULL;
				char* __temp353 = NULL;
				char* func_name = (__temp353 = g_strdup_printf ("%s_destroy_func", (__temp352 = g_utf8_strdown (vala_type_parameter_get_name (type_param), -1))), (__temp352 = (g_free (__temp352), NULL)), __temp353);
				char* __temp355 = NULL;
				char* __temp354 = NULL;
				char* __temp356 = NULL;
				char* enum_value = (__temp356 = g_utf8_strup ((__temp355 = g_strdup_printf ("%s_%s", (__temp354 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL)), func_name)), -1), (__temp355 = (g_free (__temp355), NULL)), (__temp354 = (g_free (__temp354), NULL)), __temp356);
				ValaCCodeCaseStatement* ccase = vala_ccode_case_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (enum_value)));
				ValaCCodeMemberAccess* cfield = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), "priv")), func_name);
				ValaCCodeFunctionCall* cgetcall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_value_get_pointer")));
				ValaCCodeIdentifier* __temp357 = NULL;
				vala_ccode_function_call_add_argument (cgetcall, VALA_CCODE_EXPRESSION ((__temp357 = vala_ccode_identifier_new ("value"))));
				(__temp357 == NULL ? NULL : (__temp357 = (g_object_unref (__temp357), NULL)));
				ValaCCodeExpressionStatement* __temp358 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((__temp358 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cfield), VALA_CCODE_EXPRESSION (cgetcall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
				(__temp358 == NULL ? NULL : (__temp358 = (g_object_unref (__temp358), NULL)));
				ValaCCodeBreakStatement* __temp359 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((__temp359 = g_object_new (VALA_TYPE_CCODE_BREAK_STATEMENT, NULL))));
				(__temp359 == NULL ? NULL : (__temp359 = (g_object_unref (__temp359), NULL)));
				vala_ccode_switch_statement_add_case (cswitch, ccase);
				(func_name = (g_free (func_name), NULL));
				(enum_value = (g_free (enum_value), NULL));
				(ccase == NULL ? NULL : (ccase = (g_object_unref (ccase), NULL)));
				(cfield == NULL ? NULL : (cfield = (g_object_unref (cfield), NULL)));
				(cgetcall == NULL ? NULL : (cgetcall = (g_object_unref (cgetcall), NULL)));
			}
		}
		(__temp360 == NULL ? NULL : (__temp360 = (g_list_free (__temp360), NULL)));
	}
	(vala_ccode_function_set_block (set_prop, block), vala_ccode_function_get_block (set_prop));
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (set_prop));
	(set_prop == NULL ? NULL : (set_prop = (g_object_unref (set_prop), NULL)));
	(block == NULL ? NULL : (block = (g_object_unref (block), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(cdecl == NULL ? NULL : (cdecl = (g_object_unref (cdecl), NULL)));
	(cswitch == NULL ? NULL : (cswitch = (g_object_unref (cswitch), NULL)));
	(props == NULL ? NULL : (props = (g_list_free (props), NULL)));
}


static void vala_code_generator_real_visit_begin_struct (ValaCodeVisitor* base, ValaStruct* st)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_STRUCT (st));
	ValaSymbol* __temp362 = NULL;
	ValaSymbol* __temp361 = NULL;
	self->priv->current_type_symbol = (__temp362 = (__temp361 = vala_code_node_get_symbol (VALA_CODE_NODE (st)), (__temp361 == NULL ? NULL : g_object_ref (__temp361))), (self->priv->current_type_symbol == NULL ? NULL : (self->priv->current_type_symbol = (g_object_unref (self->priv->current_type_symbol), NULL))), __temp362);
	ValaCCodeStruct* __temp364 = NULL;
	char* __temp363 = NULL;
	self->priv->instance_struct = (__temp364 = vala_ccode_struct_new (g_strdup_printf ("_%s", (__temp363 = vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE)))), (self->priv->instance_struct == NULL ? NULL : (self->priv->instance_struct = (g_object_unref (self->priv->instance_struct), NULL))), __temp364);
	(__temp363 = (g_free (__temp363), NULL));
	if (vala_source_file_get_cycle (vala_source_reference_get_file (vala_code_node_get_source_reference (VALA_CODE_NODE (st)))) == NULL) {
		ValaCCodeTypeDefinition* __temp366 = NULL;
		char* __temp365 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp366 = vala_ccode_type_definition_new (g_strdup_printf ("struct _%s", (__temp365 = vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE))), VALA_CCODE_DECLARATOR (vala_ccode_variable_declarator_new (vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE)))))));
		(__temp366 == NULL ? NULL : (__temp366 = (g_object_unref (__temp366), NULL)));
		(__temp365 = (g_free (__temp365), NULL));
	}
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (st))) != NULL) {
		ValaCCodeComment* __temp367 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE ((__temp367 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (st)))))));
		(__temp367 == NULL ? NULL : (__temp367 = (g_object_unref (__temp367), NULL)));
	}
	vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE (self->priv->instance_struct));
}


static void vala_code_generator_real_visit_end_struct (ValaCodeVisitor* base, ValaStruct* st)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_STRUCT (st));
	ValaSymbol* __temp368 = NULL;
	self->priv->current_type_symbol = (__temp368 = NULL, (self->priv->current_type_symbol == NULL ? NULL : (self->priv->current_type_symbol = (g_object_unref (self->priv->current_type_symbol), NULL))), __temp368);
}


static void vala_code_generator_real_visit_begin_interface (ValaCodeVisitor* base, ValaInterface* iface)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_INTERFACE (iface));
	ValaSymbol* __temp370 = NULL;
	ValaSymbol* __temp369 = NULL;
	self->priv->current_symbol = (__temp370 = (__temp369 = vala_code_node_get_symbol (VALA_CODE_NODE (iface)), (__temp369 == NULL ? NULL : g_object_ref (__temp369))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp370);
	ValaSymbol* __temp372 = NULL;
	ValaSymbol* __temp371 = NULL;
	self->priv->current_type_symbol = (__temp372 = (__temp371 = vala_code_node_get_symbol (VALA_CODE_NODE (iface)), (__temp371 == NULL ? NULL : g_object_ref (__temp371))), (self->priv->current_type_symbol == NULL ? NULL : (self->priv->current_type_symbol = (g_object_unref (self->priv->current_type_symbol), NULL))), __temp372);
	if (vala_interface_get_is_static (iface)) {
		return;
	}
	ValaCCodeStruct* __temp374 = NULL;
	char* __temp373 = NULL;
	self->priv->type_struct = (__temp374 = vala_ccode_struct_new (g_strdup_printf ("_%s", (__temp373 = vala_interface_get_type_cname (iface)))), (self->priv->type_struct == NULL ? NULL : (self->priv->type_struct = (g_object_unref (self->priv->type_struct), NULL))), __temp374);
	(__temp373 = (g_free (__temp373), NULL));
	ValaCCodeNewline* __temp375 = NULL;
	vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp375 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp375 == NULL ? NULL : (__temp375 = (g_object_unref (__temp375), NULL)));
	char* __temp376 = NULL;
	char* __temp377 = NULL;
	char* macro = (__temp377 = g_strdup_printf ("(%s_get_type ())", (__temp376 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (iface), NULL))), (__temp376 = (g_free (__temp376), NULL)), __temp377);
	ValaCCodeMacroReplacement* __temp378 = NULL;
	vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp378 = vala_ccode_macro_replacement_new (vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), "TYPE_"), macro))));
	(__temp378 == NULL ? NULL : (__temp378 = (g_object_unref (__temp378), NULL)));
	char* __temp381 = NULL;
	char* __temp380 = NULL;
	char* __temp379 = NULL;
	macro = (__temp381 = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_CAST ((obj), %s, %s))", (__temp379 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), "TYPE_")), (__temp380 = vala_data_type_get_cname (VALA_DATA_TYPE (iface), FALSE))), (macro = (g_free (macro), NULL)), __temp381);
	(__temp380 = (g_free (__temp380), NULL));
	(__temp379 = (g_free (__temp379), NULL));
	ValaCCodeMacroReplacement* __temp383 = NULL;
	char* __temp382 = NULL;
	vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp383 = vala_ccode_macro_replacement_new (g_strdup_printf ("%s(obj)", (__temp382 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), NULL))), macro))));
	(__temp383 == NULL ? NULL : (__temp383 = (g_object_unref (__temp383), NULL)));
	(__temp382 = (g_free (__temp382), NULL));
	char* __temp385 = NULL;
	char* __temp384 = NULL;
	macro = (__temp385 = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_TYPE ((obj), %s))", (__temp384 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), "TYPE_"))), (macro = (g_free (macro), NULL)), __temp385);
	(__temp384 = (g_free (__temp384), NULL));
	ValaCCodeMacroReplacement* __temp387 = NULL;
	char* __temp386 = NULL;
	vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp387 = vala_ccode_macro_replacement_new (g_strdup_printf ("%s(obj)", (__temp386 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), "IS_"))), macro))));
	(__temp387 == NULL ? NULL : (__temp387 = (g_object_unref (__temp387), NULL)));
	(__temp386 = (g_free (__temp386), NULL));
	char* __temp390 = NULL;
	char* __temp389 = NULL;
	char* __temp388 = NULL;
	macro = (__temp390 = g_strdup_printf ("(G_TYPE_INSTANCE_GET_INTERFACE ((obj), %s, %s))", (__temp388 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), "TYPE_")), (__temp389 = vala_interface_get_type_cname (iface))), (macro = (g_free (macro), NULL)), __temp390);
	(__temp389 = (g_free (__temp389), NULL));
	(__temp388 = (g_free (__temp388), NULL));
	ValaCCodeMacroReplacement* __temp392 = NULL;
	char* __temp391 = NULL;
	vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp392 = vala_ccode_macro_replacement_new (g_strdup_printf ("%s_GET_INTERFACE(obj)", (__temp391 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), NULL))), macro))));
	(__temp392 == NULL ? NULL : (__temp392 = (g_object_unref (__temp392), NULL)));
	(__temp391 = (g_free (__temp391), NULL));
	ValaCCodeNewline* __temp393 = NULL;
	vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp393 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp393 == NULL ? NULL : (__temp393 = (g_object_unref (__temp393), NULL)));
	if (vala_source_file_get_cycle (vala_source_reference_get_file (vala_code_node_get_source_reference (VALA_CODE_NODE (iface)))) == NULL) {
		ValaCCodeTypeDefinition* __temp395 = NULL;
		char* __temp394 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp395 = vala_ccode_type_definition_new (g_strdup_printf ("struct _%s", (__temp394 = vala_data_type_get_cname (VALA_DATA_TYPE (iface), FALSE))), VALA_CCODE_DECLARATOR (vala_ccode_variable_declarator_new (vala_data_type_get_cname (VALA_DATA_TYPE (iface), FALSE)))))));
		(__temp395 == NULL ? NULL : (__temp395 = (g_object_unref (__temp395), NULL)));
		(__temp394 = (g_free (__temp394), NULL));
		ValaCCodeTypeDefinition* __temp396 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp396 = vala_ccode_type_definition_new (g_strdup_printf ("struct %s", vala_ccode_struct_get_name (self->priv->type_struct)), VALA_CCODE_DECLARATOR (vala_ccode_variable_declarator_new (vala_interface_get_type_cname (iface)))))));
		(__temp396 == NULL ? NULL : (__temp396 = (g_object_unref (__temp396), NULL)));
	}
	vala_ccode_struct_add_field (self->priv->type_struct, "GTypeInterface", "parent");
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (iface))) != NULL) {
		ValaCCodeComment* __temp397 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE ((__temp397 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (iface)))))));
		(__temp397 == NULL ? NULL : (__temp397 = (g_object_unref (__temp397), NULL)));
	}
	vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE (self->priv->type_struct));
	(macro = (g_free (macro), NULL));
}


static void vala_code_generator_real_visit_end_interface (ValaCodeVisitor* base, ValaInterface* iface)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_INTERFACE (iface));
	if (!vala_interface_get_is_static (iface)) {
		vala_code_generator_add_interface_base_init_function (self, iface);
		ValaInterfaceRegisterFunction* type_fun = vala_interface_register_function_new (iface);
		vala_type_register_function_init_from_type (VALA_TYPE_REGISTER_FUNCTION (type_fun), FALSE);
		ValaCCodeFragment* __temp398 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((__temp398 = vala_type_register_function_get_declaration (VALA_TYPE_REGISTER_FUNCTION (type_fun)))));
		(__temp398 = (g_object_unref (__temp398), NULL));
		ValaCCodeFragment* __temp399 = NULL;
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE ((__temp399 = vala_type_register_function_get_definition (VALA_TYPE_REGISTER_FUNCTION (type_fun)))));
		(__temp399 = (g_object_unref (__temp399), NULL));
		(type_fun == NULL ? NULL : (type_fun = (g_object_unref (type_fun), NULL)));
	}
	ValaSymbol* __temp400 = NULL;
	self->priv->current_type_symbol = (__temp400 = NULL, (self->priv->current_type_symbol == NULL ? NULL : (self->priv->current_type_symbol = (g_object_unref (self->priv->current_type_symbol), NULL))), __temp400);
}


static ValaCCodeFunctionCall* vala_code_generator_get_param_spec (ValaCodeGenerator* self, ValaProperty* prop)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_PROPERTY (prop), NULL);
	ValaCCodeFunctionCall* cspec = vala_ccode_function_call_new (NULL);
	ValaCCodeConstant* __temp401 = NULL;
	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp401 = vala_property_get_canonical_cconstant (prop))));
	(__temp401 = (g_object_unref (__temp401), NULL));
	ValaCCodeConstant* __temp402 = NULL;
	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp402 = vala_ccode_constant_new ("\"foo\""))));
	(__temp402 == NULL ? NULL : (__temp402 = (g_object_unref (__temp402), NULL)));
	ValaCCodeConstant* __temp403 = NULL;
	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp403 = vala_ccode_constant_new ("\"bar\""))));
	(__temp403 == NULL ? NULL : (__temp403 = (g_object_unref (__temp403), NULL)));
	if (VALA_IS_CLASS (vala_type_reference_get_data_type (vala_property_get_type_reference (prop))) || VALA_IS_INTERFACE (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)))) {
		ValaCCodeIdentifier* __temp404 = NULL;
		(vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp404 = vala_ccode_identifier_new ("g_param_spec_object")))), vala_ccode_function_call_get_call (cspec));
		(__temp404 == NULL ? NULL : (__temp404 = (g_object_unref (__temp404), NULL)));
		ValaCCodeIdentifier* __temp405 = NULL;
		vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp405 = vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)), "TYPE_")))));
		(__temp405 == NULL ? NULL : (__temp405 = (g_object_unref (__temp405), NULL)));
	} else {
		if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->string_type)) {
			ValaCCodeIdentifier* __temp406 = NULL;
			(vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp406 = vala_ccode_identifier_new ("g_param_spec_string")))), vala_ccode_function_call_get_call (cspec));
			(__temp406 == NULL ? NULL : (__temp406 = (g_object_unref (__temp406), NULL)));
			ValaCCodeConstant* __temp407 = NULL;
			vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp407 = vala_ccode_constant_new ("NULL"))));
			(__temp407 == NULL ? NULL : (__temp407 = (g_object_unref (__temp407), NULL)));
		} else {
			if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->int_type) || VALA_IS_ENUM (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)))) {
				ValaCCodeIdentifier* __temp408 = NULL;
				(vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp408 = vala_ccode_identifier_new ("g_param_spec_int")))), vala_ccode_function_call_get_call (cspec));
				(__temp408 == NULL ? NULL : (__temp408 = (g_object_unref (__temp408), NULL)));
				ValaCCodeConstant* __temp409 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp409 = vala_ccode_constant_new ("G_MININT"))));
				(__temp409 == NULL ? NULL : (__temp409 = (g_object_unref (__temp409), NULL)));
				ValaCCodeConstant* __temp410 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp410 = vala_ccode_constant_new ("G_MAXINT"))));
				(__temp410 == NULL ? NULL : (__temp410 = (g_object_unref (__temp410), NULL)));
				ValaCCodeConstant* __temp411 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp411 = vala_ccode_constant_new ("0"))));
				(__temp411 == NULL ? NULL : (__temp411 = (g_object_unref (__temp411), NULL)));
			} else {
				if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->uint_type)) {
					ValaCCodeIdentifier* __temp412 = NULL;
					(vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp412 = vala_ccode_identifier_new ("g_param_spec_uint")))), vala_ccode_function_call_get_call (cspec));
					(__temp412 == NULL ? NULL : (__temp412 = (g_object_unref (__temp412), NULL)));
					ValaCCodeConstant* __temp413 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp413 = vala_ccode_constant_new ("0"))));
					(__temp413 == NULL ? NULL : (__temp413 = (g_object_unref (__temp413), NULL)));
					ValaCCodeConstant* __temp414 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp414 = vala_ccode_constant_new ("G_MAXUINT"))));
					(__temp414 == NULL ? NULL : (__temp414 = (g_object_unref (__temp414), NULL)));
					ValaCCodeConstant* __temp415 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp415 = vala_ccode_constant_new ("0U"))));
					(__temp415 == NULL ? NULL : (__temp415 = (g_object_unref (__temp415), NULL)));
				} else {
					if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->long_type)) {
						ValaCCodeIdentifier* __temp416 = NULL;
						(vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp416 = vala_ccode_identifier_new ("g_param_spec_long")))), vala_ccode_function_call_get_call (cspec));
						(__temp416 == NULL ? NULL : (__temp416 = (g_object_unref (__temp416), NULL)));
						ValaCCodeConstant* __temp417 = NULL;
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp417 = vala_ccode_constant_new ("G_MINLONG"))));
						(__temp417 == NULL ? NULL : (__temp417 = (g_object_unref (__temp417), NULL)));
						ValaCCodeConstant* __temp418 = NULL;
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp418 = vala_ccode_constant_new ("G_MAXLONG"))));
						(__temp418 == NULL ? NULL : (__temp418 = (g_object_unref (__temp418), NULL)));
						ValaCCodeConstant* __temp419 = NULL;
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp419 = vala_ccode_constant_new ("0L"))));
						(__temp419 == NULL ? NULL : (__temp419 = (g_object_unref (__temp419), NULL)));
					} else {
						if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->ulong_type)) {
							ValaCCodeIdentifier* __temp420 = NULL;
							(vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp420 = vala_ccode_identifier_new ("g_param_spec_ulong")))), vala_ccode_function_call_get_call (cspec));
							(__temp420 == NULL ? NULL : (__temp420 = (g_object_unref (__temp420), NULL)));
							ValaCCodeConstant* __temp421 = NULL;
							vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp421 = vala_ccode_constant_new ("0"))));
							(__temp421 == NULL ? NULL : (__temp421 = (g_object_unref (__temp421), NULL)));
							ValaCCodeConstant* __temp422 = NULL;
							vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp422 = vala_ccode_constant_new ("G_MAXULONG"))));
							(__temp422 == NULL ? NULL : (__temp422 = (g_object_unref (__temp422), NULL)));
							ValaCCodeConstant* __temp423 = NULL;
							vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp423 = vala_ccode_constant_new ("0UL"))));
							(__temp423 == NULL ? NULL : (__temp423 = (g_object_unref (__temp423), NULL)));
						} else {
							if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->bool_type)) {
								ValaCCodeIdentifier* __temp424 = NULL;
								(vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp424 = vala_ccode_identifier_new ("g_param_spec_boolean")))), vala_ccode_function_call_get_call (cspec));
								(__temp424 == NULL ? NULL : (__temp424 = (g_object_unref (__temp424), NULL)));
								ValaCCodeConstant* __temp425 = NULL;
								vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp425 = vala_ccode_constant_new ("FALSE"))));
								(__temp425 == NULL ? NULL : (__temp425 = (g_object_unref (__temp425), NULL)));
							} else {
								if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->float_type)) {
									ValaCCodeIdentifier* __temp426 = NULL;
									(vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp426 = vala_ccode_identifier_new ("g_param_spec_float")))), vala_ccode_function_call_get_call (cspec));
									(__temp426 == NULL ? NULL : (__temp426 = (g_object_unref (__temp426), NULL)));
									ValaCCodeConstant* __temp427 = NULL;
									vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp427 = vala_ccode_constant_new ("-G_MAXFLOAT"))));
									(__temp427 == NULL ? NULL : (__temp427 = (g_object_unref (__temp427), NULL)));
									ValaCCodeConstant* __temp428 = NULL;
									vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp428 = vala_ccode_constant_new ("G_MAXFLOAT"))));
									(__temp428 == NULL ? NULL : (__temp428 = (g_object_unref (__temp428), NULL)));
									ValaCCodeConstant* __temp429 = NULL;
									vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp429 = vala_ccode_constant_new ("0.0F"))));
									(__temp429 == NULL ? NULL : (__temp429 = (g_object_unref (__temp429), NULL)));
								} else {
									if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->double_type)) {
										ValaCCodeIdentifier* __temp430 = NULL;
										(vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp430 = vala_ccode_identifier_new ("g_param_spec_double")))), vala_ccode_function_call_get_call (cspec));
										(__temp430 == NULL ? NULL : (__temp430 = (g_object_unref (__temp430), NULL)));
										ValaCCodeConstant* __temp431 = NULL;
										vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp431 = vala_ccode_constant_new ("-G_MAXDOUBLE"))));
										(__temp431 == NULL ? NULL : (__temp431 = (g_object_unref (__temp431), NULL)));
										ValaCCodeConstant* __temp432 = NULL;
										vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp432 = vala_ccode_constant_new ("G_MAXDOUBLE"))));
										(__temp432 == NULL ? NULL : (__temp432 = (g_object_unref (__temp432), NULL)));
										ValaCCodeConstant* __temp433 = NULL;
										vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp433 = vala_ccode_constant_new ("0.0"))));
										(__temp433 == NULL ? NULL : (__temp433 = (g_object_unref (__temp433), NULL)));
									} else {
										ValaCCodeIdentifier* __temp434 = NULL;
										(vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp434 = vala_ccode_identifier_new ("g_param_spec_pointer")))), vala_ccode_function_call_get_call (cspec));
										(__temp434 == NULL ? NULL : (__temp434 = (g_object_unref (__temp434), NULL)));
									}
								}
							}
						}
					}
				}
			}
		}
	}
	char* pflags = g_strdup ("G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB");
	if (vala_property_get_get_accessor (prop) != NULL) {
		char* __temp435 = NULL;
		pflags = (__temp435 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_READABLE"), (pflags = (g_free (pflags), NULL)), __temp435);
	}
	if (vala_property_get_set_accessor (prop) != NULL) {
		char* __temp436 = NULL;
		pflags = (__temp436 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_WRITABLE"), (pflags = (g_free (pflags), NULL)), __temp436);
		if (vala_property_accessor_get_construction (vala_property_get_set_accessor (prop))) {
			if (vala_property_accessor_get_writable (vala_property_get_set_accessor (prop))) {
				char* __temp437 = NULL;
				pflags = (__temp437 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_CONSTRUCT"), (pflags = (g_free (pflags), NULL)), __temp437);
			} else {
				char* __temp438 = NULL;
				pflags = (__temp438 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_CONSTRUCT_ONLY"), (pflags = (g_free (pflags), NULL)), __temp438);
			}
		}
	}
	ValaCCodeConstant* __temp439 = NULL;
	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp439 = vala_ccode_constant_new (pflags))));
	(__temp439 == NULL ? NULL : (__temp439 = (g_object_unref (__temp439), NULL)));
	ValaCCodeFunctionCall* __temp440 = NULL;
	return (__temp440 = cspec, (pflags = (g_free (pflags), NULL)), __temp440);
	(cspec == NULL ? NULL : (cspec = (g_object_unref (cspec), NULL)));
	(pflags = (g_free (pflags), NULL));
}


static ValaCCodeFunctionCall* vala_code_generator_get_signal_creation (ValaCodeGenerator* self, ValaSignal* sig, ValaDataType* type)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_SIGNAL (sig), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (type), NULL);
	ValaCCodeFunctionCall* csignew = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_signal_new")));
	ValaCCodeConstant* __temp441 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp441 = vala_ccode_constant_new (g_strdup_printf ("\"%s\"", vala_signal_get_name (sig))))));
	(__temp441 == NULL ? NULL : (__temp441 = (g_object_unref (__temp441), NULL)));
	ValaCCodeIdentifier* __temp442 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp442 = vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (type, "TYPE_")))));
	(__temp442 == NULL ? NULL : (__temp442 = (g_object_unref (__temp442), NULL)));
	ValaCCodeConstant* __temp443 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp443 = vala_ccode_constant_new ("G_SIGNAL_RUN_LAST"))));
	(__temp443 == NULL ? NULL : (__temp443 = (g_object_unref (__temp443), NULL)));
	ValaCCodeConstant* __temp444 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp444 = vala_ccode_constant_new ("0"))));
	(__temp444 == NULL ? NULL : (__temp444 = (g_object_unref (__temp444), NULL)));
	ValaCCodeConstant* __temp445 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp445 = vala_ccode_constant_new ("NULL"))));
	(__temp445 == NULL ? NULL : (__temp445 = (g_object_unref (__temp445), NULL)));
	ValaCCodeConstant* __temp446 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp446 = vala_ccode_constant_new ("NULL"))));
	(__temp446 == NULL ? NULL : (__temp446 = (g_object_unref (__temp446), NULL)));
	char* marshaller = vala_code_generator_get_signal_marshaller_function (self, sig, NULL);
	ValaCCodeIdentifier* marshal_arg = vala_ccode_identifier_new (marshaller);
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION (marshal_arg));
	GList* params = vala_invokable_get_parameters (VALA_INVOKABLE (sig));
	guint params_len = g_list_length (params);
	if (vala_type_reference_get_type_parameter (vala_signal_get_return_type (sig)) != NULL) {
		ValaCCodeConstant* __temp447 = NULL;
		vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp447 = vala_ccode_constant_new ("G_TYPE_POINTER"))));
		(__temp447 == NULL ? NULL : (__temp447 = (g_object_unref (__temp447), NULL)));
	} else {
		if (vala_type_reference_get_data_type (vala_signal_get_return_type (sig)) == NULL) {
			ValaCCodeConstant* __temp448 = NULL;
			vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp448 = vala_ccode_constant_new ("G_TYPE_NONE"))));
			(__temp448 == NULL ? NULL : (__temp448 = (g_object_unref (__temp448), NULL)));
		} else {
			ValaCCodeConstant* __temp449 = NULL;
			vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp449 = vala_ccode_constant_new (vala_data_type_get_type_id (vala_type_reference_get_data_type (vala_signal_get_return_type (sig)))))));
			(__temp449 == NULL ? NULL : (__temp449 = (g_object_unref (__temp449), NULL)));
		}
	}
	ValaCCodeConstant* __temp450 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp450 = vala_ccode_constant_new (g_strdup_printf ("%d", params_len)))));
	(__temp450 == NULL ? NULL : (__temp450 = (g_object_unref (__temp450), NULL)));
	{
		GList* __temp453 = NULL;
		__temp453 = params;
		GList* param_it;
		for (param_it = __temp453; param_it != NULL; param_it = param_it->next) {
			ValaFormalParameter* param = param_it->data;
			{
				if (vala_type_reference_get_type_parameter (vala_formal_parameter_get_type_reference (param)) != NULL) {
					ValaCCodeConstant* __temp451 = NULL;
					vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp451 = vala_ccode_constant_new ("G_TYPE_POINTER"))));
					(__temp451 == NULL ? NULL : (__temp451 = (g_object_unref (__temp451), NULL)));
				} else {
					ValaCCodeConstant* __temp452 = NULL;
					vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp452 = vala_ccode_constant_new (vala_data_type_get_type_id (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)))))));
					(__temp452 == NULL ? NULL : (__temp452 = (g_object_unref (__temp452), NULL)));
				}
			}
		}
	}
	(vala_ccode_identifier_set_name (marshal_arg, marshaller), vala_ccode_identifier_get_name (marshal_arg));
	ValaCCodeFunctionCall* __temp454 = NULL;
	return (__temp454 = csignew, (marshaller = (g_free (marshaller), NULL)), (marshal_arg == NULL ? NULL : (marshal_arg = (g_object_unref (marshal_arg), NULL))), (params == NULL ? NULL : (params = (g_list_free (params), NULL))), __temp454);
	(csignew == NULL ? NULL : (csignew = (g_object_unref (csignew), NULL)));
	(marshaller = (g_free (marshaller), NULL));
	(marshal_arg == NULL ? NULL : (marshal_arg = (g_object_unref (marshal_arg), NULL)));
	(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
}


static void vala_code_generator_add_interface_base_init_function (ValaCodeGenerator* self, ValaInterface* iface)
{
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_INTERFACE (iface));
	char* __temp455 = NULL;
	ValaCCodeFunction* __temp456 = NULL;
	ValaCCodeFunction* base_init = (__temp456 = vala_ccode_function_new (g_strdup_printf ("%s_base_init", (__temp455 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (iface), NULL))), "void"), (__temp455 = (g_free (__temp455), NULL)), __temp456);
	ValaCCodeFormalParameter* __temp458 = NULL;
	char* __temp457 = NULL;
	vala_ccode_function_add_parameter (base_init, (__temp458 = vala_ccode_formal_parameter_new ("iface", g_strdup_printf ("%sIface *", (__temp457 = vala_data_type_get_cname (VALA_DATA_TYPE (iface), FALSE))))));
	(__temp458 == NULL ? NULL : (__temp458 = (g_object_unref (__temp458), NULL)));
	(__temp457 = (g_free (__temp457), NULL));
	(vala_ccode_function_set_modifiers (base_init, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_function_get_modifiers (base_init));
	ValaCCodeBlock* init_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	/* make sure not to run the initialization code twice */
	ValaCCodeBlock* __temp459 = NULL;
	(vala_ccode_function_set_block (base_init, (__temp459 = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL))), vala_ccode_function_get_block (base_init));
	(__temp459 == NULL ? NULL : (__temp459 = (g_object_unref (__temp459), NULL)));
	ValaCCodeDeclaration* decl = vala_ccode_declaration_new (vala_type_reference_get_cname (self->priv->bool_type, FALSE, FALSE));
	(vala_ccode_declaration_set_modifiers (decl, vala_ccode_declaration_get_modifiers (decl) | (VALA_CCODE_MODIFIERS_STATIC)), vala_ccode_declaration_get_modifiers (decl));
	ValaCCodeVariableDeclarator* __temp460 = NULL;
	vala_ccode_declaration_add_declarator (decl, VALA_CCODE_DECLARATOR ((__temp460 = vala_ccode_variable_declarator_new_with_initializer ("initialized", VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("FALSE"))))));
	(__temp460 == NULL ? NULL : (__temp460 = (g_object_unref (__temp460), NULL)));
	vala_ccode_block_add_statement (vala_ccode_function_get_block (base_init), VALA_CCODE_NODE (decl));
	ValaCCodeIfStatement* cif = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("initialized")))), VALA_CCODE_STATEMENT (init_block), NULL);
	vala_ccode_block_add_statement (vala_ccode_function_get_block (base_init), VALA_CCODE_NODE (cif));
	ValaCCodeExpressionStatement* __temp461 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp461 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("initialized")), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("TRUE")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp461 == NULL ? NULL : (__temp461 = (g_object_unref (__temp461), NULL)));
	/* create properties */
	GList* props = vala_interface_get_properties (iface);
	{
		GList* __temp465 = NULL;
		__temp465 = props;
		GList* prop_it;
		for (prop_it = __temp465; prop_it != NULL; prop_it = prop_it->next) {
			ValaProperty* prop = prop_it->data;
			{
				ValaCCodeFunctionCall* cinst = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_object_interface_install_property")));
				ValaCCodeIdentifier* __temp462 = NULL;
				vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((__temp462 = vala_ccode_identifier_new ("iface"))));
				(__temp462 == NULL ? NULL : (__temp462 = (g_object_unref (__temp462), NULL)));
				ValaCCodeFunctionCall* __temp463 = NULL;
				vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((__temp463 = vala_code_generator_get_param_spec (self, prop))));
				(__temp463 = (g_object_unref (__temp463), NULL));
				ValaCCodeExpressionStatement* __temp464 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp464 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
				(__temp464 == NULL ? NULL : (__temp464 = (g_object_unref (__temp464), NULL)));
				(cinst == NULL ? NULL : (cinst = (g_object_unref (cinst), NULL)));
			}
		}
	}
	{
		GList* __temp467 = NULL;
		__temp467 = vala_interface_get_signals (iface);
		GList* sig_it;
		for (sig_it = __temp467; sig_it != NULL; sig_it = sig_it->next) {
			ValaSignal* sig = sig_it->data;
			{
				/* create signals */
				ValaCCodeExpressionStatement* __temp466 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp466 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_code_generator_get_signal_creation (self, sig, VALA_DATA_TYPE (iface)))))));
				(__temp466 == NULL ? NULL : (__temp466 = (g_object_unref (__temp466), NULL)));
			}
		}
		(__temp467 == NULL ? NULL : (__temp467 = (g_list_free (__temp467), NULL)));
	}
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (base_init));
	(base_init == NULL ? NULL : (base_init = (g_object_unref (base_init), NULL)));
	(init_block == NULL ? NULL : (init_block = (g_object_unref (init_block), NULL)));
	(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
	(cif == NULL ? NULL : (cif = (g_object_unref (cif), NULL)));
	(props == NULL ? NULL : (props = (g_list_free (props), NULL)));
}


static void vala_code_generator_real_visit_begin_enum (ValaCodeVisitor* base, ValaEnum* en)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_ENUM (en));
	ValaCCodeEnum* __temp468 = NULL;
	self->priv->cenum = (__temp468 = vala_ccode_enum_new (vala_data_type_get_cname (VALA_DATA_TYPE (en), FALSE)), (self->priv->cenum == NULL ? NULL : (self->priv->cenum = (g_object_unref (self->priv->cenum), NULL))), __temp468);
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (en))) != NULL) {
		ValaCCodeComment* __temp469 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE ((__temp469 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (en)))))));
		(__temp469 == NULL ? NULL : (__temp469 = (g_object_unref (__temp469), NULL)));
	}
	vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE (self->priv->cenum));
}


static void vala_code_generator_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_ENUM_VALUE (ev));
	char* val = NULL;
	if (VALA_IS_LITERAL_EXPRESSION (vala_enum_value_get_value (ev))) {
		ValaLiteral* __temp470 = NULL;
		ValaLiteral* lit = (__temp470 = vala_literal_expression_get_literal ((VALA_LITERAL_EXPRESSION (vala_enum_value_get_value (ev)))), (__temp470 == NULL ? NULL : g_object_ref (__temp470)));
		if (VALA_IS_INTEGER_LITERAL (lit)) {
			char* __temp471 = NULL;
			val = (__temp471 = g_strdup (vala_integer_literal_get_value ((VALA_INTEGER_LITERAL (lit)))), (val = (g_free (val), NULL)), __temp471);
		}
		(lit == NULL ? NULL : (lit = (g_object_unref (lit), NULL)));
	}
	char* __temp472 = NULL;
	vala_ccode_enum_add_value (self->priv->cenum, (__temp472 = vala_enum_value_get_cname (ev)), val);
	(__temp472 = (g_free (__temp472), NULL));
	(val = (g_free (val), NULL));
}


static void vala_code_generator_real_visit_begin_flags (ValaCodeVisitor* base, ValaFlags* fl)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_FLAGS (fl));
	ValaCCodeEnum* __temp473 = NULL;
	self->priv->cenum = (__temp473 = vala_ccode_enum_new (vala_data_type_get_cname (VALA_DATA_TYPE (fl), FALSE)), (self->priv->cenum == NULL ? NULL : (self->priv->cenum = (g_object_unref (self->priv->cenum), NULL))), __temp473);
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (fl))) != NULL) {
		ValaCCodeComment* __temp474 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE ((__temp474 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (fl)))))));
		(__temp474 == NULL ? NULL : (__temp474 = (g_object_unref (__temp474), NULL)));
	}
	vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE (self->priv->cenum));
}


static void vala_code_generator_real_visit_flags_value (ValaCodeVisitor* base, ValaFlagsValue* fv)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_FLAGS_VALUE (fv));
	char* val = NULL;
	if (VALA_IS_LITERAL_EXPRESSION (vala_flags_value_get_value (fv))) {
		ValaLiteral* __temp475 = NULL;
		ValaLiteral* lit = (__temp475 = vala_literal_expression_get_literal ((VALA_LITERAL_EXPRESSION (vala_flags_value_get_value (fv)))), (__temp475 == NULL ? NULL : g_object_ref (__temp475)));
		if (VALA_IS_INTEGER_LITERAL (lit)) {
			char* __temp476 = NULL;
			val = (__temp476 = g_strdup (vala_integer_literal_get_value ((VALA_INTEGER_LITERAL (lit)))), (val = (g_free (val), NULL)), __temp476);
		}
		(lit == NULL ? NULL : (lit = (g_object_unref (lit), NULL)));
	}
	char* __temp477 = NULL;
	vala_ccode_enum_add_value (self->priv->cenum, (__temp477 = vala_flags_value_get_cname (fv)), val);
	(__temp477 = (g_free (__temp477), NULL));
	(val = (g_free (val), NULL));
}


static void vala_code_generator_real_visit_end_callback (ValaCodeVisitor* base, ValaCallback* cb)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CALLBACK (cb));
	ValaCCodeFunctionDeclarator* cfundecl = vala_ccode_function_declarator_new (vala_data_type_get_cname (VALA_DATA_TYPE (cb), FALSE));
	{
		GList* __temp478 = NULL;
		__temp478 = vala_callback_get_parameters (cb);
		GList* param_it;
		for (param_it = __temp478; param_it != NULL; param_it = param_it->next) {
			ValaFormalParameter* param = param_it->data;
			{
				vala_ccode_function_declarator_add_parameter (cfundecl, VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (VALA_CODE_NODE (param))));
			}
		}
		(__temp478 == NULL ? NULL : (__temp478 = (g_list_free (__temp478), NULL)));
	}
	ValaCCodeTypeDefinition* ctypedef = vala_ccode_type_definition_new (vala_type_reference_get_cname (vala_callback_get_return_type (cb), FALSE, FALSE), VALA_CCODE_DECLARATOR (cfundecl));
	if (VALA_DATA_TYPE (cb)->access != VALA_MEMBER_ACCESSIBILITY_PRIVATE) {
		vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE (ctypedef));
	} else {
		vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (ctypedef));
	}
	(cfundecl == NULL ? NULL : (cfundecl = (g_object_unref (cfundecl), NULL)));
	(ctypedef == NULL ? NULL : (ctypedef = (g_object_unref (ctypedef), NULL)));
}


static void vala_code_generator_real_visit_member (ValaCodeVisitor* base, ValaMember* m)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_MEMBER (m));
	/* stuff meant for all lockable members */
	if (VALA_IS_LOCKABLE (m) && vala_lockable_get_lock_used ((VALA_LOCKABLE (m)))) {
		char* __temp480 = NULL;
		char* __temp479 = NULL;
		vala_ccode_struct_add_field (self->priv->instance_priv_struct, (__temp479 = vala_type_reference_get_cname (self->priv->mutex_type, FALSE, FALSE)), (__temp480 = vala_code_generator_get_symbol_lock_name (self, vala_code_node_get_symbol (VALA_CODE_NODE (m)))));
		(__temp480 = (g_free (__temp480), NULL));
		(__temp479 = (g_free (__temp479), NULL));
		ValaCCodeExpressionStatement* __temp481 = NULL;
		vala_ccode_fragment_append (self->priv->instance_init_fragment, VALA_CCODE_NODE ((__temp481 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), "priv")), vala_code_generator_get_symbol_lock_name (self, vala_code_node_get_symbol (VALA_CODE_NODE (m))))), VALA_CCODE_EXPRESSION (vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_method_get_cname (vala_struct_get_default_construction_method ((VALA_STRUCT (vala_type_reference_get_data_type (self->priv->mutex_type))))))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
		(__temp481 == NULL ? NULL : (__temp481 = (g_object_unref (__temp481), NULL)));
		ValaCCodeFunctionCall* fc = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("VALA_FREE_CHECKED")));
		ValaCCodeMemberAccess* __temp482 = NULL;
		vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((__temp482 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), "priv")), vala_code_generator_get_symbol_lock_name (self, vala_code_node_get_symbol (VALA_CODE_NODE (m)))))));
		(__temp482 == NULL ? NULL : (__temp482 = (g_object_unref (__temp482), NULL)));
		ValaCCodeIdentifier* __temp483 = NULL;
		vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((__temp483 = vala_ccode_identifier_new (vala_data_type_get_free_function (vala_type_reference_get_data_type (self->priv->mutex_type))))));
		(__temp483 == NULL ? NULL : (__temp483 = (g_object_unref (__temp483), NULL)));
		if (self->priv->instance_dispose_fragment != NULL) {
			ValaCCodeExpressionStatement* __temp484 = NULL;
			vala_ccode_fragment_append (self->priv->instance_dispose_fragment, VALA_CCODE_NODE ((__temp484 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
			(__temp484 == NULL ? NULL : (__temp484 = (g_object_unref (__temp484), NULL)));
		}
		(fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL)));
	}
}


static void vala_code_generator_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CONSTANT (c));
	if (VALA_IS_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (c)))))) {
		ValaDataType* __temp485 = NULL;
		ValaDataType* t = (__temp485 = VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (c))))), (__temp485 == NULL ? NULL : g_object_ref (__temp485)));
		ValaCCodeDeclaration* cdecl = vala_ccode_declaration_new (vala_type_reference_get_const_cname (vala_constant_get_type_reference (c)));
		char* arr = g_strdup ("");
		if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_constant_get_type_reference (c)))) {
			char* __temp486 = NULL;
			arr = (__temp486 = g_strdup ("[]"), (arr = (g_free (arr), NULL)), __temp486);
		}
		ValaCCodeVariableDeclarator* __temp488 = NULL;
		char* __temp487 = NULL;
		vala_ccode_declaration_add_declarator (cdecl, VALA_CCODE_DECLARATOR ((__temp488 = vala_ccode_variable_declarator_new_with_initializer (g_strdup_printf ("%s%s", (__temp487 = vala_constant_get_cname (c)), arr), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_constant_get_initializer (c))))))));
		(__temp488 == NULL ? NULL : (__temp488 = (g_object_unref (__temp488), NULL)));
		(__temp487 = (g_free (__temp487), NULL));
		(vala_ccode_declaration_set_modifiers (cdecl, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_declaration_get_modifiers (cdecl));
		if (c->access != VALA_MEMBER_ACCESSIBILITY_PRIVATE) {
			vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE (cdecl));
		} else {
			vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (cdecl));
		}
		(t == NULL ? NULL : (t = (g_object_unref (t), NULL)));
		(cdecl == NULL ? NULL : (cdecl = (g_object_unref (cdecl), NULL)));
		(arr = (g_free (arr), NULL));
	}
}


static void vala_code_generator_real_visit_field (ValaCodeVisitor* base, ValaField* f)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_FIELD (f));
	ValaCCodeExpression* lhs = NULL;
	ValaCCodeStruct* st = NULL;
	if (f->access != VALA_MEMBER_ACCESSIBILITY_PRIVATE) {
		ValaCCodeStruct* __temp490 = NULL;
		ValaCCodeStruct* __temp489 = NULL;
		st = (__temp490 = (__temp489 = self->priv->instance_struct, (__temp489 == NULL ? NULL : g_object_ref (__temp489))), (st == NULL ? NULL : (st = (g_object_unref (st), NULL))), __temp490);
		if (vala_field_get_instance (f)) {
			ValaCCodeExpression* __temp491 = NULL;
			lhs = (__temp491 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), vala_field_get_cname (f))), (lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL))), __temp491);
		}
	} else {
		if (f->access == VALA_MEMBER_ACCESSIBILITY_PRIVATE) {
			if (vala_field_get_instance (f)) {
				ValaCCodeStruct* __temp493 = NULL;
				ValaCCodeStruct* __temp492 = NULL;
				st = (__temp493 = (__temp492 = self->priv->instance_priv_struct, (__temp492 == NULL ? NULL : g_object_ref (__temp492))), (st == NULL ? NULL : (st = (g_object_unref (st), NULL))), __temp493);
				ValaCCodeExpression* __temp494 = NULL;
				lhs = (__temp494 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), "priv")), vala_field_get_cname (f))), (lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL))), __temp494);
			} else {
				if (VALA_IS_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (f)))))) {
					ValaDataType* __temp495 = NULL;
					ValaDataType* t = (__temp495 = VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (f))))), (__temp495 == NULL ? NULL : g_object_ref (__temp495)));
					ValaCCodeDeclaration* cdecl = vala_ccode_declaration_new (vala_type_reference_get_cname (vala_field_get_type_reference (f), FALSE, FALSE));
					ValaCCodeVariableDeclarator* var_decl = vala_ccode_variable_declarator_new (vala_field_get_cname (f));
					if (vala_field_get_initializer (f) != NULL) {
						(vala_ccode_variable_declarator_set_initializer (var_decl, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_field_get_initializer (f))))), vala_ccode_variable_declarator_get_initializer (var_decl));
					}
					vala_ccode_declaration_add_declarator (cdecl, VALA_CCODE_DECLARATOR (var_decl));
					(vala_ccode_declaration_set_modifiers (cdecl, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_declaration_get_modifiers (cdecl));
					vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (cdecl));
					(t == NULL ? NULL : (t = (g_object_unref (t), NULL)));
					(cdecl == NULL ? NULL : (cdecl = (g_object_unref (cdecl), NULL)));
					(var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL)));
				}
			}
		}
	}
	if (vala_field_get_instance (f)) {
		char* __temp497 = NULL;
		char* __temp496 = NULL;
		vala_ccode_struct_add_field (st, (__temp496 = vala_type_reference_get_cname (vala_field_get_type_reference (f), FALSE, FALSE)), (__temp497 = vala_field_get_cname (f)));
		(__temp497 = (g_free (__temp497), NULL));
		(__temp496 = (g_free (__temp496), NULL));
		if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_field_get_type_reference (f))) && !vala_field_get_no_array_length (f)) {
			/* create fields to store array dimensions*/
			ValaArray* __temp498 = NULL;
			ValaArray* arr = (__temp498 = VALA_ARRAY (vala_type_reference_get_data_type (vala_field_get_type_reference (f))), (__temp498 == NULL ? NULL : g_object_ref (__temp498)));
			{
				gint dim = 0;
				for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
					ValaTypeReference* len_type = vala_type_reference_new ();
					(vala_type_reference_set_data_type (len_type, vala_type_reference_get_data_type (self->priv->int_type)), vala_type_reference_get_data_type (len_type));
					char* __temp500 = NULL;
					char* __temp499 = NULL;
					vala_ccode_struct_add_field (st, (__temp499 = vala_type_reference_get_cname (len_type, FALSE, FALSE)), (__temp500 = vala_code_generator_get_array_length_cname (self, vala_field_get_name (f), dim)));
					(__temp500 = (g_free (__temp500), NULL));
					(__temp499 = (g_free (__temp499), NULL));
					(len_type == NULL ? NULL : (len_type = (g_object_unref (len_type), NULL)));
				}
			}
			(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
		}
		if (vala_field_get_initializer (f) != NULL) {
			ValaCCodeExpressionStatement* __temp501 = NULL;
			vala_ccode_fragment_append (self->priv->instance_init_fragment, VALA_CCODE_NODE ((__temp501 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (lhs, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_field_get_initializer (f)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
			(__temp501 == NULL ? NULL : (__temp501 = (g_object_unref (__temp501), NULL)));
			if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_field_get_type_reference (f))) && !vala_field_get_no_array_length (f) && VALA_IS_ARRAY_CREATION_EXPRESSION (vala_field_get_initializer (f))) {
				ValaMemberAccess* ma = vala_member_access_new_simple (vala_field_get_name (f), NULL);
				(vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), vala_code_node_get_symbol (VALA_CODE_NODE (f))), vala_expression_get_symbol_reference (VALA_EXPRESSION (ma)));
				ValaCCodeExpression* array_len_lhs = vala_code_generator_get_array_length_cexpression (self, VALA_EXPRESSION (ma), 1);
				GList* sizes = vala_array_creation_expression_get_sizes ((VALA_ARRAY_CREATION_EXPRESSION (vala_field_get_initializer (f))));
				ValaExpression* __temp502 = NULL;
				ValaExpression* size = (__temp502 = VALA_EXPRESSION (sizes->data), (__temp502 == NULL ? NULL : g_object_ref (__temp502)));
				ValaCCodeExpressionStatement* __temp503 = NULL;
				vala_ccode_fragment_append (self->priv->instance_init_fragment, VALA_CCODE_NODE ((__temp503 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (array_len_lhs, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (size))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
				(__temp503 == NULL ? NULL : (__temp503 = (g_object_unref (__temp503), NULL)));
				(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
				(array_len_lhs = (g_object_unref (array_len_lhs), NULL));
				(sizes == NULL ? NULL : (sizes = (g_list_free (sizes), NULL)));
				(size == NULL ? NULL : (size = (g_object_unref (size), NULL)));
			}
		}
		if (vala_type_reference_get_takes_ownership (vala_field_get_type_reference (f)) && self->priv->instance_dispose_fragment != NULL) {
			ValaCCodeExpressionStatement* __temp504 = NULL;
			vala_ccode_fragment_append (self->priv->instance_dispose_fragment, VALA_CCODE_NODE ((__temp504 = vala_ccode_expression_statement_new (vala_code_generator_get_unref_expression (self, lhs, vala_field_get_type_reference (f))))));
			(__temp504 == NULL ? NULL : (__temp504 = (g_object_unref (__temp504), NULL)));
		}
	}
	(lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL)));
	(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
}


static void vala_code_generator_real_visit_begin_method (ValaCodeVisitor* base, ValaMethod* m)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_METHOD (m));
	ValaSymbol* __temp506 = NULL;
	ValaSymbol* __temp505 = NULL;
	self->priv->current_symbol = (__temp506 = (__temp505 = vala_code_node_get_symbol (VALA_CODE_NODE (m)), (__temp505 == NULL ? NULL : g_object_ref (__temp505))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp506);
	ValaTypeReference* __temp508 = NULL;
	ValaTypeReference* __temp507 = NULL;
	self->priv->current_return_type = (__temp508 = (__temp507 = vala_method_get_return_type (m), (__temp507 == NULL ? NULL : g_object_ref (__temp507))), (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL))), __temp508);
}


static ValaCCodeStatement* vala_code_generator_create_method_type_check_statement (ValaCodeGenerator* self, ValaMethod* m, ValaDataType* t, gboolean non_null, const char* var_name)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_METHOD (m), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (t), NULL);
	g_return_val_if_fail (var_name != NULL, NULL);
	return vala_code_generator_create_type_check_statement (self, VALA_CODE_NODE (m), vala_type_reference_get_data_type (vala_method_get_return_type (m)), t, non_null, var_name);
}


static ValaCCodeStatement* vala_code_generator_create_property_type_check_statement (ValaCodeGenerator* self, ValaProperty* prop, gboolean getter, ValaDataType* t, gboolean non_null, const char* var_name)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_PROPERTY (prop), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (t), NULL);
	g_return_val_if_fail (var_name != NULL, NULL);
	if (getter) {
		return vala_code_generator_create_type_check_statement (self, VALA_CODE_NODE (prop), vala_type_reference_get_data_type (vala_property_get_type_reference (prop)), t, non_null, var_name);
	} else {
		return vala_code_generator_create_type_check_statement (self, VALA_CODE_NODE (prop), NULL, t, non_null, var_name);
	}
}


static ValaCCodeStatement* vala_code_generator_create_type_check_statement (ValaCodeGenerator* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaDataType* t, gboolean non_null, const char* var_name)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_CODE_NODE (method_node), NULL);
	g_return_val_if_fail (ret_type == NULL || VALA_IS_DATA_TYPE (ret_type), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (t), NULL);
	g_return_val_if_fail (var_name != NULL, NULL);
	ValaCCodeFunctionCall* ccheck = vala_ccode_function_call_new (NULL);
	if (VALA_IS_CLASS (t) || VALA_IS_INTERFACE (t)) {
		ValaCCodeFunctionCall* ctype_check = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (t, "IS_"))));
		ValaCCodeIdentifier* __temp512 = NULL;
		vala_ccode_function_call_add_argument (ctype_check, VALA_CCODE_EXPRESSION ((__temp512 = vala_ccode_identifier_new (var_name))));
		(__temp512 == NULL ? NULL : (__temp512 = (g_object_unref (__temp512), NULL)));
		ValaCCodeFunctionCall* __temp513 = NULL;
		ValaCCodeExpression* cexpr = VALA_CCODE_EXPRESSION ((__temp513 = ctype_check, (__temp513 == NULL ? NULL : g_object_ref (__temp513))));
		if (!non_null) {
			ValaCCodeBinaryExpression* cnull = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (var_name)), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")));
			ValaCCodeExpression* __temp514 = NULL;
			cexpr = (__temp514 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, VALA_CCODE_EXPRESSION (cnull), VALA_CCODE_EXPRESSION (ctype_check))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), __temp514);
			(cnull == NULL ? NULL : (cnull = (g_object_unref (cnull), NULL)));
		}
		vala_ccode_function_call_add_argument (ccheck, cexpr);
		(ctype_check == NULL ? NULL : (ctype_check = (g_object_unref (ctype_check), NULL)));
		(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
	} else {
		if (!non_null) {
			gpointer __temp515;
			return VALA_CCODE_STATEMENT ((__temp515 = NULL, (ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL))), __temp515));
		} else {
			ValaCCodeBinaryExpression* cnonnull = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (var_name)), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")));
			vala_ccode_function_call_add_argument (ccheck, VALA_CCODE_EXPRESSION (cnonnull));
			(cnonnull == NULL ? NULL : (cnonnull = (g_object_unref (cnonnull), NULL)));
		}
	}
	if (ret_type == NULL) {
		/* void function */
		ValaCCodeIdentifier* __temp516 = NULL;
		(vala_ccode_function_call_set_call (ccheck, VALA_CCODE_EXPRESSION ((__temp516 = vala_ccode_identifier_new ("g_return_if_fail")))), vala_ccode_function_call_get_call (ccheck));
		(__temp516 == NULL ? NULL : (__temp516 = (g_object_unref (__temp516), NULL)));
	} else {
		ValaCCodeIdentifier* __temp517 = NULL;
		(vala_ccode_function_call_set_call (ccheck, VALA_CCODE_EXPRESSION ((__temp517 = vala_ccode_identifier_new ("g_return_val_if_fail")))), vala_ccode_function_call_get_call (ccheck));
		(__temp517 == NULL ? NULL : (__temp517 = (g_object_unref (__temp517), NULL)));
		if (vala_data_type_is_reference_type (ret_type) || VALA_IS_POINTER (ret_type)) {
			ValaCCodeConstant* __temp518 = NULL;
			vala_ccode_function_call_add_argument (ccheck, VALA_CCODE_EXPRESSION ((__temp518 = vala_ccode_constant_new ("NULL"))));
			(__temp518 == NULL ? NULL : (__temp518 = (g_object_unref (__temp518), NULL)));
		} else {
			char* __temp519 = NULL;
			gboolean __temp520;
			if ((__temp520 = (__temp519 = vala_data_type_get_default_value (ret_type)) != NULL, (__temp519 = (g_free (__temp519), NULL)), __temp520)) {
				ValaCCodeConstant* __temp521 = NULL;
				vala_ccode_function_call_add_argument (ccheck, VALA_CCODE_EXPRESSION ((__temp521 = vala_ccode_constant_new (vala_data_type_get_default_value (ret_type)))));
				(__temp521 == NULL ? NULL : (__temp521 = (g_object_unref (__temp521), NULL)));
			} else {
				vala_report_warning (vala_code_node_get_source_reference (method_node), "not supported return type for runtime type checks");
				ValaCCodeExpressionStatement* __temp522 = NULL;
				return VALA_CCODE_STATEMENT ((__temp522 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("0"))), (ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL))), __temp522));
			}
		}
	}
	ValaCCodeExpressionStatement* __temp523 = NULL;
	return VALA_CCODE_STATEMENT ((__temp523 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccheck)), (ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL))), __temp523));
	(ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL)));
}


static ValaDataType* vala_code_generator_find_parent_type (ValaCodeGenerator* self, ValaCodeNode* node)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (node == NULL || VALA_IS_CODE_NODE (node), NULL);
	ValaSymbol* __temp524 = NULL;
	ValaSymbol* sym = (__temp524 = vala_code_node_get_symbol (node), (__temp524 == NULL ? NULL : g_object_ref (__temp524)));
	while (sym != NULL) {
		if (VALA_IS_DATA_TYPE (vala_symbol_get_node (sym))) {
			ValaDataType* __temp525 = NULL;
			ValaDataType* __temp526 = NULL;
			return (__temp526 = (__temp525 = VALA_DATA_TYPE (vala_symbol_get_node (sym)), (__temp525 == NULL ? NULL : g_object_ref (__temp525))), (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), __temp526);
		}
		ValaSymbol* __temp528 = NULL;
		ValaSymbol* __temp527 = NULL;
		sym = (__temp528 = (__temp527 = vala_symbol_get_parent_symbol (sym), (__temp527 == NULL ? NULL : g_object_ref (__temp527))), (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), __temp528);
	}
	gpointer __temp529;
	return VALA_DATA_TYPE ((__temp529 = NULL, (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), __temp529));
	(sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL)));
}


static char* vala_code_generator_get_array_length_cname (ValaCodeGenerator* self, const char* array_cname, gint dim)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (array_cname != NULL, NULL);
	return g_strdup_printf ("%s_length%d", array_cname, dim);
}


static void vala_code_generator_real_visit_end_method (ValaCodeVisitor* base, ValaMethod* m)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_METHOD (m));
	ValaSymbol* __temp532 = NULL;
	ValaSymbol* __temp531 = NULL;
	self->priv->current_symbol = (__temp532 = (__temp531 = vala_symbol_get_parent_symbol (self->priv->current_symbol), (__temp531 == NULL ? NULL : g_object_ref (__temp531))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp532);
	ValaTypeReference* __temp533 = NULL;
	self->priv->current_return_type = (__temp533 = NULL, (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL))), __temp533);
	if (self->priv->current_type_symbol != NULL && VALA_IS_INTERFACE (vala_symbol_get_node (self->priv->current_type_symbol))) {
		ValaInterface* __temp534 = NULL;
		ValaInterface* iface = (__temp534 = VALA_INTERFACE (vala_symbol_get_node (self->priv->current_type_symbol)), (__temp534 == NULL ? NULL : g_object_ref (__temp534)));
		if (vala_interface_get_is_static (iface)) {
			(iface == NULL ? NULL : (iface = (g_object_unref (iface), NULL)));
			return;
		}
		(iface == NULL ? NULL : (iface = (g_object_unref (iface), NULL)));
	}
	if (vala_symbol_get_parent_symbol (self->priv->current_symbol) != NULL && VALA_IS_METHOD (vala_symbol_get_node (vala_symbol_get_parent_symbol (self->priv->current_symbol)))) {
		/* lambda expressions produce nested methods */
		ValaMethod* __temp535 = NULL;
		ValaMethod* up_method = (__temp535 = VALA_METHOD (vala_symbol_get_node (vala_symbol_get_parent_symbol (self->priv->current_symbol))), (__temp535 == NULL ? NULL : g_object_ref (__temp535)));
		ValaTypeReference* __temp537 = NULL;
		ValaTypeReference* __temp536 = NULL;
		self->priv->current_return_type = (__temp537 = (__temp536 = vala_method_get_return_type (up_method), (__temp536 == NULL ? NULL : g_object_ref (__temp536))), (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL))), __temp537);
		(up_method == NULL ? NULL : (up_method = (g_object_unref (up_method), NULL)));
	}
	ValaCCodeFunction* __temp538 = NULL;
	self->priv->function = (__temp538 = vala_ccode_function_new (vala_method_get_real_cname (m), vala_type_reference_get_cname (vala_method_get_return_type (m), FALSE, FALSE)), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), __temp538);
	ValaCCodeFunctionDeclarator* vdeclarator = NULL;
	ValaCCodeFormalParameter* instance_param = NULL;
	if (vala_method_get_instance (m)) {
		ValaTypeReference* this_type = vala_type_reference_new ();
		ValaDataType* __temp539 = NULL;
		(vala_type_reference_set_data_type (this_type, (__temp539 = vala_code_generator_find_parent_type (self, VALA_CODE_NODE (m)))), vala_type_reference_get_data_type (this_type));
		(__temp539 == NULL ? NULL : (__temp539 = (g_object_unref (__temp539), NULL)));
		if (vala_method_get_base_interface_method (m) != NULL) {
			ValaTypeReference* base_type = vala_type_reference_new ();
			(vala_type_reference_set_data_type (base_type, VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (vala_method_get_base_interface_method (m))))))), vala_type_reference_get_data_type (base_type));
			ValaCCodeFormalParameter* __temp540 = NULL;
			instance_param = (__temp540 = vala_ccode_formal_parameter_new ("base", vala_type_reference_get_cname (base_type, FALSE, FALSE)), (instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL))), __temp540);
			(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
		} else {
			if (vala_method_get_overrides (m)) {
				ValaTypeReference* base_type = vala_type_reference_new ();
				(vala_type_reference_set_data_type (base_type, VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (vala_method_get_base_method (m))))))), vala_type_reference_get_data_type (base_type));
				ValaCCodeFormalParameter* __temp541 = NULL;
				instance_param = (__temp541 = vala_ccode_formal_parameter_new ("base", vala_type_reference_get_cname (base_type, FALSE, FALSE)), (instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL))), __temp541);
				(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
			} else {
				if (vala_method_get_instance_by_reference (m)) {
					ValaCCodeFormalParameter* __temp542 = NULL;
					instance_param = (__temp542 = vala_ccode_formal_parameter_new ("*self", vala_type_reference_get_cname (this_type, FALSE, FALSE)), (instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL))), __temp542);
				} else {
					ValaCCodeFormalParameter* __temp543 = NULL;
					instance_param = (__temp543 = vala_ccode_formal_parameter_new ("self", vala_type_reference_get_cname (this_type, FALSE, FALSE)), (instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL))), __temp543);
				}
			}
		}
		if (!vala_method_get_instance_last (m)) {
			vala_ccode_function_add_parameter (self->priv->function, instance_param);
		}
		if (vala_method_get_is_abstract (m) || vala_method_get_is_virtual (m)) {
			ValaCCodeDeclaration* vdecl = vala_ccode_declaration_new (vala_type_reference_get_cname (vala_method_get_return_type (m), FALSE, FALSE));
			ValaCCodeFunctionDeclarator* __temp544 = NULL;
			vdeclarator = (__temp544 = vala_ccode_function_declarator_new (vala_method_get_name (m)), (vdeclarator == NULL ? NULL : (vdeclarator = (g_object_unref (vdeclarator), NULL))), __temp544);
			vala_ccode_declaration_add_declarator (vdecl, VALA_CCODE_DECLARATOR (vdeclarator));
			vala_ccode_struct_add_declaration (self->priv->type_struct, vdecl);
			vala_ccode_function_declarator_add_parameter (vdeclarator, instance_param);
			(vdecl == NULL ? NULL : (vdecl = (g_object_unref (vdecl), NULL)));
		}
		(this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL)));
	}
	if (VALA_IS_CREATION_METHOD (m) && self->priv->current_class != NULL) {
		{
			GList* __temp547 = NULL;
			__temp547 = vala_class_get_type_parameters (self->priv->current_class);
			GList* type_param_it;
			for (type_param_it = __temp547; type_param_it != NULL; type_param_it = type_param_it->next) {
				ValaTypeParameter* type_param = type_param_it->data;
				{
					/* memory management for generic types*/
					char* __temp545 = NULL;
					ValaCCodeFormalParameter* __temp546 = NULL;
					ValaCCodeFormalParameter* cparam = (__temp546 = vala_ccode_formal_parameter_new (g_strdup_printf ("%s_destroy_func", (__temp545 = g_utf8_strdown (vala_type_parameter_get_name (type_param), -1))), "GDestroyNotify"), (__temp545 = (g_free (__temp545), NULL)), __temp546);
					vala_ccode_function_add_parameter (self->priv->function, cparam);
					(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
				}
			}
			(__temp547 == NULL ? NULL : (__temp547 = (g_list_free (__temp547), NULL)));
		}
	}
	GList* params = vala_invokable_get_parameters (VALA_INVOKABLE (m));
	{
		GList* __temp550 = NULL;
		__temp550 = params;
		GList* param_it;
		for (param_it = __temp550; param_it != NULL; param_it = param_it->next) {
			ValaFormalParameter* param = param_it->data;
			{
				if (!vala_formal_parameter_get_no_array_length (param) && VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)))) {
					ValaArray* __temp548 = NULL;
					ValaArray* arr = (__temp548 = VALA_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))), (__temp548 == NULL ? NULL : g_object_ref (__temp548)));
					char* length_ctype = g_strdup ("int");
					if (vala_type_reference_get_is_out (vala_formal_parameter_get_type_reference (param))) {
						char* __temp549 = NULL;
						length_ctype = (__temp549 = g_strdup ("int*"), (length_ctype = (g_free (length_ctype), NULL)), __temp549);
					}
					{
						gint dim = 0;
						for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
							ValaCCodeFormalParameter* cparam = vala_ccode_formal_parameter_new (vala_code_generator_get_array_length_cname (self, vala_formal_parameter_get_name (param), dim), length_ctype);
							vala_ccode_function_add_parameter (self->priv->function, cparam);
							if (vdeclarator != NULL) {
								vala_ccode_function_declarator_add_parameter (vdeclarator, cparam);
							}
							(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
						}
					}
					(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
					(length_ctype = (g_free (length_ctype), NULL));
				}
				vala_ccode_function_add_parameter (self->priv->function, VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (VALA_CODE_NODE (param))));
				if (vdeclarator != NULL) {
					vala_ccode_function_declarator_add_parameter (vdeclarator, VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (VALA_CODE_NODE (param))));
				}
			}
		}
	}
	if (vala_method_get_instance (m) && vala_method_get_instance_last (m)) {
		vala_ccode_function_add_parameter (self->priv->function, instance_param);
	}
	/* real function declaration and definition not needed
	 * for abstract methods */
	if (!vala_method_get_is_abstract (m)) {
		if (m->access != VALA_MEMBER_ACCESSIBILITY_PRIVATE && vala_method_get_base_method (m) == NULL && vala_method_get_base_interface_method (m) == NULL) {
			/* public methods need function declaration in
			 * header file except virtual/overridden methods */
			ValaCCodeFunction* __temp551 = NULL;
			vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((__temp551 = vala_ccode_function_copy (self->priv->function))));
			(__temp551 = (g_object_unref (__temp551), NULL));
		} else {
			/* declare all other functions in source file to
			 * avoid dependency on order within source file */
			(vala_ccode_function_set_modifiers (self->priv->function, vala_ccode_function_get_modifiers (self->priv->function) | (VALA_CCODE_MODIFIERS_STATIC)), vala_ccode_function_get_modifiers (self->priv->function));
			ValaCCodeFunction* __temp552 = NULL;
			vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((__temp552 = vala_ccode_function_copy (self->priv->function))));
			(__temp552 = (g_object_unref (__temp552), NULL));
		}
		/* Methods imported from a plain C file don't
		 * have a body, e.g. Vala.Parser.parse_file () */
		if (vala_method_get_body (m) != NULL) {
			(vala_ccode_function_set_block (self->priv->function, VALA_CCODE_BLOCK (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_method_get_body (m))))), vala_ccode_function_get_block (self->priv->function));
			ValaCCodeFragment* cinit = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
			vala_ccode_block_prepend_statement (vala_ccode_function_get_block (self->priv->function), VALA_CCODE_NODE (cinit));
			if (VALA_IS_CLASS (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (m)))))) {
				ValaClass* __temp553 = NULL;
				ValaClass* cl = (__temp553 = VALA_CLASS (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (m))))), (__temp553 == NULL ? NULL : g_object_ref (__temp553)));
				if (vala_method_get_overrides (m) || vala_method_get_base_interface_method (m) != NULL) {
					ValaCCodeFunctionCall* ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL))));
					ValaCCodeIdentifier* __temp554 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp554 = vala_ccode_identifier_new ("base"))));
					(__temp554 == NULL ? NULL : (__temp554 = (g_object_unref (__temp554), NULL)));
					char* __temp555 = NULL;
					ValaCCodeDeclaration* __temp556 = NULL;
					ValaCCodeDeclaration* cdecl = (__temp556 = vala_ccode_declaration_new (g_strdup_printf ("%s *", (__temp555 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), (__temp555 = (g_free (__temp555), NULL)), __temp556);
					ValaCCodeVariableDeclarator* __temp557 = NULL;
					vala_ccode_declaration_add_declarator (cdecl, VALA_CCODE_DECLARATOR ((__temp557 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
					(__temp557 == NULL ? NULL : (__temp557 = (g_object_unref (__temp557), NULL)));
					vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl));
					(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
					(cdecl == NULL ? NULL : (cdecl = (g_object_unref (cdecl), NULL)));
				} else {
					if (vala_method_get_instance (m)) {
						ValaCCodeStatement* __temp558 = NULL;
						vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((__temp558 = vala_code_generator_create_method_type_check_statement (self, m, VALA_DATA_TYPE (cl), TRUE, "self"))));
						(__temp558 == NULL ? NULL : (__temp558 = (g_object_unref (__temp558), NULL)));
					}
				}
				(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
			}
			{
				GList* __temp560 = NULL;
				__temp560 = vala_invokable_get_parameters (VALA_INVOKABLE (m));
				GList* param_it;
				for (param_it = __temp560; param_it != NULL; param_it = param_it->next) {
					ValaFormalParameter* param = param_it->data;
					{
						ValaDataType* __temp559 = NULL;
						ValaDataType* t = (__temp559 = vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)), (__temp559 == NULL ? NULL : g_object_ref (__temp559)));
						if (t != NULL && vala_data_type_is_reference_type (t) && !vala_type_reference_get_is_out (vala_formal_parameter_get_type_reference (param))) {
							ValaCCodeStatement* type_check = vala_code_generator_create_method_type_check_statement (self, m, t, vala_type_reference_get_non_null (vala_formal_parameter_get_type_reference (param)), vala_formal_parameter_get_name (param));
							if (type_check != NULL) {
								vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (type_check));
							}
							(type_check == NULL ? NULL : (type_check = (g_object_unref (type_check), NULL)));
						}
						(t == NULL ? NULL : (t = (g_object_unref (t), NULL)));
					}
				}
				(__temp560 == NULL ? NULL : (__temp560 = (g_list_free (__temp560), NULL)));
			}
			if (vala_code_node_get_source_reference (VALA_CODE_NODE (m)) != NULL && vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (m))) != NULL) {
				ValaCCodeComment* __temp561 = NULL;
				vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE ((__temp561 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (m)))))));
				(__temp561 == NULL ? NULL : (__temp561 = (g_object_unref (__temp561), NULL)));
			}
			vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (self->priv->function));
			if (VALA_IS_CREATION_METHOD (m)) {
				if (self->priv->current_class != NULL) {
					gint n_params = vala_creation_method_get_n_construction_params ((VALA_CREATION_METHOD (m)));
					GList* __temp562 = NULL;
					n_params = n_params + (((gint) g_list_length ((__temp562 = vala_class_get_type_parameters (self->priv->current_class)))));
					(__temp562 == NULL ? NULL : (__temp562 = (g_list_free (__temp562), NULL)));
					/* declare construction parameter array*/
					ValaCCodeFunctionCall* cparamsinit = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_new0")));
					ValaCCodeIdentifier* __temp563 = NULL;
					vala_ccode_function_call_add_argument (cparamsinit, VALA_CCODE_EXPRESSION ((__temp563 = vala_ccode_identifier_new ("GParameter"))));
					(__temp563 == NULL ? NULL : (__temp563 = (g_object_unref (__temp563), NULL)));
					ValaCCodeConstant* __temp564 = NULL;
					vala_ccode_function_call_add_argument (cparamsinit, VALA_CCODE_EXPRESSION ((__temp564 = vala_ccode_constant_new (g_strdup_printf ("%i", n_params)))));
					(__temp564 == NULL ? NULL : (__temp564 = (g_object_unref (__temp564), NULL)));
					ValaCCodeDeclaration* cdecl = vala_ccode_declaration_new ("GParameter *");
					ValaCCodeVariableDeclarator* __temp565 = NULL;
					vala_ccode_declaration_add_declarator (cdecl, VALA_CCODE_DECLARATOR ((__temp565 = vala_ccode_variable_declarator_new_with_initializer ("__params", VALA_CCODE_EXPRESSION (cparamsinit)))));
					(__temp565 == NULL ? NULL : (__temp565 = (g_object_unref (__temp565), NULL)));
					vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl));
					ValaCCodeDeclaration* __temp566 = NULL;
					cdecl = (__temp566 = vala_ccode_declaration_new ("GParameter *"), (cdecl == NULL ? NULL : (cdecl = (g_object_unref (cdecl), NULL))), __temp566);
					ValaCCodeVariableDeclarator* __temp567 = NULL;
					vala_ccode_declaration_add_declarator (cdecl, VALA_CCODE_DECLARATOR ((__temp567 = vala_ccode_variable_declarator_new_with_initializer ("__params_it", VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("__params"))))));
					(__temp567 == NULL ? NULL : (__temp567 = (g_object_unref (__temp567), NULL)));
					vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl));
					{
						GList* __temp577 = NULL;
						__temp577 = vala_class_get_type_parameters (self->priv->current_class);
						GList* type_param_it;
						for (type_param_it = __temp577; type_param_it != NULL; type_param_it = type_param_it->next) {
							ValaTypeParameter* type_param = type_param_it->data;
							{
								/* destroy func properties for generic types */
								char* __temp568 = NULL;
								char* __temp569 = NULL;
								char* func_name = (__temp569 = g_strdup_printf ("%s_destroy_func", (__temp568 = g_utf8_strdown (vala_type_parameter_get_name (type_param), -1))), (__temp568 = (g_free (__temp568), NULL)), __temp569);
								char* __temp570 = NULL;
								ValaCCodeConstant* __temp571 = NULL;
								ValaCCodeConstant* func_name_constant = (__temp571 = vala_ccode_constant_new (g_strdup_printf ("\"%s-destroy-func\"", (__temp570 = g_utf8_strdown (vala_type_parameter_get_name (type_param), -1)))), (__temp570 = (g_free (__temp570), NULL)), __temp571);
								/* this property is used as a construction parameter*/
								ValaCCodeIdentifier* cpointer = vala_ccode_identifier_new ("__params_it");
								ValaCCodeCommaExpression* ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
								/* set name in array for current parameter*/
								ValaCCodeMemberAccess* cnamemember = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (cpointer), "name");
								ValaCCodeAssignment* __temp572 = NULL;
								vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp572 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cnamemember), VALA_CCODE_EXPRESSION (func_name_constant), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
								(__temp572 == NULL ? NULL : (__temp572 = (g_object_unref (__temp572), NULL)));
								ValaCCodeUnaryExpression* gvaluearg = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (cpointer), "value")));
								/* initialize GValue in array for current parameter*/
								ValaCCodeFunctionCall* cvalueinit = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_value_init")));
								vala_ccode_function_call_add_argument (cvalueinit, VALA_CCODE_EXPRESSION (gvaluearg));
								ValaCCodeIdentifier* __temp573 = NULL;
								vala_ccode_function_call_add_argument (cvalueinit, VALA_CCODE_EXPRESSION ((__temp573 = vala_ccode_identifier_new ("G_TYPE_POINTER"))));
								(__temp573 == NULL ? NULL : (__temp573 = (g_object_unref (__temp573), NULL)));
								vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cvalueinit));
								/* set GValue for current parameter*/
								ValaCCodeFunctionCall* cvalueset = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_value_set_pointer")));
								vala_ccode_function_call_add_argument (cvalueset, VALA_CCODE_EXPRESSION (gvaluearg));
								ValaCCodeIdentifier* __temp574 = NULL;
								vala_ccode_function_call_add_argument (cvalueset, VALA_CCODE_EXPRESSION ((__temp574 = vala_ccode_identifier_new (func_name))));
								(__temp574 == NULL ? NULL : (__temp574 = (g_object_unref (__temp574), NULL)));
								vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cvalueset));
								/* move pointer to next parameter in array*/
								ValaCCodeUnaryExpression* __temp575 = NULL;
								vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp575 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, VALA_CCODE_EXPRESSION (cpointer)))));
								(__temp575 == NULL ? NULL : (__temp575 = (g_object_unref (__temp575), NULL)));
								ValaCCodeExpressionStatement* __temp576 = NULL;
								vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((__temp576 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccomma)))));
								(__temp576 == NULL ? NULL : (__temp576 = (g_object_unref (__temp576), NULL)));
								(func_name = (g_free (func_name), NULL));
								(func_name_constant == NULL ? NULL : (func_name_constant = (g_object_unref (func_name_constant), NULL)));
								(cpointer == NULL ? NULL : (cpointer = (g_object_unref (cpointer), NULL)));
								(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
								(cnamemember == NULL ? NULL : (cnamemember = (g_object_unref (cnamemember), NULL)));
								(gvaluearg == NULL ? NULL : (gvaluearg = (g_object_unref (gvaluearg), NULL)));
								(cvalueinit == NULL ? NULL : (cvalueinit = (g_object_unref (cvalueinit), NULL)));
								(cvalueset == NULL ? NULL : (cvalueset = (g_object_unref (cvalueset), NULL)));
							}
						}
						(__temp577 == NULL ? NULL : (__temp577 = (g_list_free (__temp577), NULL)));
					}
					(cparamsinit == NULL ? NULL : (cparamsinit = (g_object_unref (cparamsinit), NULL)));
					(cdecl == NULL ? NULL : (cdecl = (g_object_unref (cdecl), NULL)));
				} else {
					ValaStruct* __temp578 = NULL;
					ValaStruct* st = (__temp578 = VALA_STRUCT (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (m))))), (__temp578 == NULL ? NULL : g_object_ref (__temp578)));
					char* __temp579 = NULL;
					ValaCCodeDeclaration* __temp580 = NULL;
					ValaCCodeDeclaration* cdecl = (__temp580 = vala_ccode_declaration_new (g_strconcat ((__temp579 = vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE)), "*", NULL)), (__temp579 = (g_free (__temp579), NULL)), __temp580);
					ValaCCodeFunctionCall* ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_new0")));
					ValaCCodeConstant* __temp581 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp581 = vala_ccode_constant_new (vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE)))));
					(__temp581 == NULL ? NULL : (__temp581 = (g_object_unref (__temp581), NULL)));
					ValaCCodeConstant* __temp582 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp582 = vala_ccode_constant_new ("1"))));
					(__temp582 == NULL ? NULL : (__temp582 = (g_object_unref (__temp582), NULL)));
					ValaCCodeVariableDeclarator* __temp583 = NULL;
					vala_ccode_declaration_add_declarator (cdecl, VALA_CCODE_DECLARATOR ((__temp583 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
					(__temp583 == NULL ? NULL : (__temp583 = (g_object_unref (__temp583), NULL)));
					vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl));
					(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
					(cdecl == NULL ? NULL : (cdecl = (g_object_unref (cdecl), NULL)));
					(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
				}
			}
			if (vala_code_context_get_module_init_method (self->priv->context) == m && self->priv->in_plugin) {
				/* GTypeModule-based plug-in, register types*/
				vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (self->priv->module_init_fragment));
			}
			(cinit == NULL ? NULL : (cinit = (g_object_unref (cinit), NULL)));
		}
	}
	if (vala_method_get_is_abstract (m) || vala_method_get_is_virtual (m)) {
		ValaCCodeFunction* vfunc = vala_ccode_function_new (vala_method_get_cname (m), vala_type_reference_get_cname (vala_method_get_return_type (m), FALSE, FALSE));
		ValaTypeReference* this_type = vala_type_reference_new ();
		(vala_type_reference_set_data_type (this_type, VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (m)))))), vala_type_reference_get_data_type (this_type));
		ValaCCodeFormalParameter* cparam = vala_ccode_formal_parameter_new ("self", vala_type_reference_get_cname (this_type, FALSE, FALSE));
		vala_ccode_function_add_parameter (vfunc, cparam);
		ValaCCodeBlock* vblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
		ValaCCodeFunctionCall* vcast = NULL;
		if (VALA_IS_INTERFACE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (m)))))) {
			ValaInterface* __temp584 = NULL;
			ValaInterface* iface = (__temp584 = VALA_INTERFACE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (m))))), (__temp584 == NULL ? NULL : g_object_ref (__temp584)));
			ValaCCodeFunctionCall* __temp586 = NULL;
			char* __temp585 = NULL;
			vcast = (__temp586 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_GET_INTERFACE", (__temp585 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), NULL)))))), (vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL))), __temp586);
			(__temp585 = (g_free (__temp585), NULL));
			(iface == NULL ? NULL : (iface = (g_object_unref (iface), NULL)));
		} else {
			ValaClass* __temp587 = NULL;
			ValaClass* cl = (__temp587 = VALA_CLASS (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (m))))), (__temp587 == NULL ? NULL : g_object_ref (__temp587)));
			ValaCCodeFunctionCall* __temp589 = NULL;
			char* __temp588 = NULL;
			vcast = (__temp589 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_GET_CLASS", (__temp588 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))))), (vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL))), __temp589);
			(__temp588 = (g_free (__temp588), NULL));
			(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
		}
		ValaCCodeIdentifier* __temp590 = NULL;
		vala_ccode_function_call_add_argument (vcast, VALA_CCODE_EXPRESSION ((__temp590 = vala_ccode_identifier_new ("self"))));
		(__temp590 == NULL ? NULL : (__temp590 = (g_object_unref (__temp590), NULL)));
		ValaCCodeFunctionCall* vcall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vcast), vala_method_get_name (m))));
		ValaCCodeIdentifier* __temp591 = NULL;
		vala_ccode_function_call_add_argument (vcall, VALA_CCODE_EXPRESSION ((__temp591 = vala_ccode_identifier_new ("self"))));
		(__temp591 == NULL ? NULL : (__temp591 = (g_object_unref (__temp591), NULL)));
		GList* params = vala_invokable_get_parameters (VALA_INVOKABLE (m));
		{
			GList* __temp593 = NULL;
			__temp593 = params;
			GList* param_it;
			for (param_it = __temp593; param_it != NULL; param_it = param_it->next) {
				ValaFormalParameter* param = param_it->data;
				{
					vala_ccode_function_add_parameter (vfunc, VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (VALA_CODE_NODE (param))));
					ValaCCodeIdentifier* __temp592 = NULL;
					vala_ccode_function_call_add_argument (vcall, VALA_CCODE_EXPRESSION ((__temp592 = vala_ccode_identifier_new (vala_formal_parameter_get_name (param)))));
					(__temp592 == NULL ? NULL : (__temp592 = (g_object_unref (__temp592), NULL)));
				}
			}
		}
		if (vala_type_reference_get_data_type (vala_method_get_return_type (m)) == NULL) {
			ValaCCodeExpressionStatement* __temp594 = NULL;
			vala_ccode_block_add_statement (vblock, VALA_CCODE_NODE ((__temp594 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vcall)))));
			(__temp594 == NULL ? NULL : (__temp594 = (g_object_unref (__temp594), NULL)));
		} else {
			/* pass method return value */
			ValaCCodeReturnStatement* __temp595 = NULL;
			vala_ccode_block_add_statement (vblock, VALA_CCODE_NODE ((__temp595 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (vcall)))));
			(__temp595 == NULL ? NULL : (__temp595 = (g_object_unref (__temp595), NULL)));
		}
		ValaCCodeFunction* __temp596 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((__temp596 = vala_ccode_function_copy (vfunc))));
		(__temp596 = (g_object_unref (__temp596), NULL));
		(vala_ccode_function_set_block (vfunc, vblock), vala_ccode_function_get_block (vfunc));
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (vfunc));
		(vfunc == NULL ? NULL : (vfunc = (g_object_unref (vfunc), NULL)));
		(this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL)));
		(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
		(vblock == NULL ? NULL : (vblock = (g_object_unref (vblock), NULL)));
		(vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL)));
		(vcall == NULL ? NULL : (vcall = (g_object_unref (vcall), NULL)));
		(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaCCodeReturnStatement* creturn = vala_ccode_return_statement_new (NULL);
		ValaCCodeIdentifier* __temp597 = NULL;
		(vala_ccode_return_statement_set_return_expression (creturn, VALA_CCODE_EXPRESSION ((__temp597 = vala_ccode_identifier_new ("self")))), vala_ccode_return_statement_get_return_expression (creturn));
		(__temp597 == NULL ? NULL : (__temp597 = (g_object_unref (__temp597), NULL)));
		vala_ccode_block_add_statement (vala_ccode_function_get_block (self->priv->function), VALA_CCODE_NODE (creturn));
		(creturn == NULL ? NULL : (creturn = (g_object_unref (creturn), NULL)));
	}
	gboolean return_value = TRUE;
	gboolean args_parameter = TRUE;
	if (vala_code_generator_is_possible_entry_point (self, m, &return_value, &args_parameter)) {
		/* m is possible entry point, add appropriate startup code*/
		ValaCCodeFunction* cmain = vala_ccode_function_new ("main", "int");
		ValaCCodeFormalParameter* __temp598 = NULL;
		vala_ccode_function_add_parameter (cmain, (__temp598 = vala_ccode_formal_parameter_new ("argc", "int")));
		(__temp598 == NULL ? NULL : (__temp598 = (g_object_unref (__temp598), NULL)));
		ValaCCodeFormalParameter* __temp599 = NULL;
		vala_ccode_function_add_parameter (cmain, (__temp599 = vala_ccode_formal_parameter_new ("argv", "char **")));
		(__temp599 == NULL ? NULL : (__temp599 = (g_object_unref (__temp599), NULL)));
		ValaCCodeBlock* main_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
		ValaCCodeExpressionStatement* __temp600 = NULL;
		vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE ((__temp600 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_type_init"))))))));
		(__temp600 == NULL ? NULL : (__temp600 = (g_object_unref (__temp600), NULL)));
		ValaCCodeFunctionCall* main_call = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_ccode_function_get_name (self->priv->function))));
		if (args_parameter) {
			ValaCCodeIdentifier* __temp601 = NULL;
			vala_ccode_function_call_add_argument (main_call, VALA_CCODE_EXPRESSION ((__temp601 = vala_ccode_identifier_new ("argc"))));
			(__temp601 == NULL ? NULL : (__temp601 = (g_object_unref (__temp601), NULL)));
			ValaCCodeIdentifier* __temp602 = NULL;
			vala_ccode_function_call_add_argument (main_call, VALA_CCODE_EXPRESSION ((__temp602 = vala_ccode_identifier_new ("argv"))));
			(__temp602 == NULL ? NULL : (__temp602 = (g_object_unref (__temp602), NULL)));
		}
		if (return_value) {
			ValaCCodeReturnStatement* __temp603 = NULL;
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE ((__temp603 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (main_call)))));
			(__temp603 == NULL ? NULL : (__temp603 = (g_object_unref (__temp603), NULL)));
		} else {
			/* method returns void, always use 0 as exit code*/
			ValaCCodeExpressionStatement* __temp604 = NULL;
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE ((__temp604 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (main_call)))));
			(__temp604 == NULL ? NULL : (__temp604 = (g_object_unref (__temp604), NULL)));
			ValaCCodeReturnStatement* __temp605 = NULL;
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE ((__temp605 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("0"))))));
			(__temp605 == NULL ? NULL : (__temp605 = (g_object_unref (__temp605), NULL)));
		}
		(vala_ccode_function_set_block (cmain, main_block), vala_ccode_function_get_block (cmain));
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (cmain));
		(cmain == NULL ? NULL : (cmain = (g_object_unref (cmain), NULL)));
		(main_block == NULL ? NULL : (main_block = (g_object_unref (main_block), NULL)));
		(main_call == NULL ? NULL : (main_call = (g_object_unref (main_call), NULL)));
	}
	(vdeclarator == NULL ? NULL : (vdeclarator = (g_object_unref (vdeclarator), NULL)));
	(instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL)));
	(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
}


static void vala_code_generator_real_visit_begin_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CREATION_METHOD (m));
	ValaSymbol* __temp607 = NULL;
	ValaSymbol* __temp606 = NULL;
	self->priv->current_symbol = (__temp607 = (__temp606 = vala_code_node_get_symbol (VALA_CODE_NODE (m)), (__temp606 == NULL ? NULL : g_object_ref (__temp606))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp607);
	ValaTypeReference* __temp609 = NULL;
	ValaTypeReference* __temp608 = NULL;
	self->priv->current_return_type = (__temp609 = (__temp608 = vala_method_get_return_type (VALA_METHOD (m)), (__temp608 == NULL ? NULL : g_object_ref (__temp608))), (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL))), __temp609);
	self->priv->in_creation_method = TRUE;
}


static void vala_code_generator_real_visit_end_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CREATION_METHOD (m));
	if (self->priv->current_class != NULL && vala_method_get_body (VALA_METHOD (m)) != NULL) {
		vala_code_generator_add_object_creation (self, VALA_CCODE_BLOCK (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_method_get_body (VALA_METHOD (m))))));
	}
	self->priv->in_creation_method = FALSE;
	vala_code_visitor_visit_end_method (VALA_CODE_VISITOR (self), VALA_METHOD (m));
}


static gboolean vala_code_generator_is_possible_entry_point (ValaCodeGenerator* self, ValaMethod* m, gboolean* return_value, gboolean* args_parameter)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), FALSE);
	g_return_val_if_fail (VALA_IS_METHOD (m), FALSE);
	if (vala_method_get_name (m) == NULL || g_utf8_collate (vala_method_get_name (m), "main") != 0) {
		return FALSE;
	}
	/* method must be called "main"*/
	if (vala_method_get_instance (m)) {
		return FALSE;
	}
	/* method must be static*/
	if (vala_type_reference_get_data_type (vala_method_get_return_type (m)) == NULL) {
		(*return_value) = FALSE;
	} else {
		if (vala_type_reference_get_data_type (vala_method_get_return_type (m)) == vala_type_reference_get_data_type (self->priv->int_type)) {
			(*return_value) = TRUE;
		} else {
			return FALSE;
		}
	}
	/* return type must be void or int*/
	GList* params = vala_invokable_get_parameters (VALA_INVOKABLE (m));
	if (g_list_length (params) == 0) {
		/* method may have no parameters*/
		(*args_parameter) = FALSE;
		gboolean __temp613;
		return (__temp613 = TRUE, (params == NULL ? NULL : (params = (g_list_free (params), NULL))), __temp613);
	}
	if (g_list_length (params) > 1) {
		gboolean __temp614;
		return (__temp614 = FALSE, (params == NULL ? NULL : (params = (g_list_free (params), NULL))), __temp614);
	}
	/* method must not have more than one parameter*/
	ValaFormalParameter* __temp615 = NULL;
	ValaFormalParameter* param = (__temp615 = VALA_FORMAL_PARAMETER (params->data), (__temp615 == NULL ? NULL : g_object_ref (__temp615)));
	if (vala_type_reference_get_is_out (vala_formal_parameter_get_type_reference (param))) {
		gboolean __temp616;
		return (__temp616 = FALSE, (params == NULL ? NULL : (params = (g_list_free (params), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), __temp616);
	}
	/* parameter must not be an out parameter*/
	if (!(VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))))) {
		gboolean __temp617;
		return (__temp617 = FALSE, (params == NULL ? NULL : (params = (g_list_free (params), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), __temp617);
	}
	/* parameter must be an array*/
	ValaArray* __temp618 = NULL;
	ValaArray* array_type = (__temp618 = VALA_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))), (__temp618 == NULL ? NULL : g_object_ref (__temp618)));
	if (vala_array_get_element_type (array_type) != vala_type_reference_get_data_type (self->priv->string_type)) {
		gboolean __temp619;
		return (__temp619 = FALSE, (params == NULL ? NULL : (params = (g_list_free (params), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), (array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL))), __temp619);
	}
	/* parameter must be an array of strings*/
	(*args_parameter) = TRUE;
	gboolean __temp620;
	return (__temp620 = TRUE, (params == NULL ? NULL : (params = (g_list_free (params), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), (array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL))), __temp620);
	(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
	(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
	(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
}


static void vala_code_generator_real_visit_formal_parameter (ValaCodeVisitor* base, ValaFormalParameter* p)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_FORMAL_PARAMETER (p));
	if (!vala_formal_parameter_get_ellipsis (p)) {
		ValaCCodeFormalParameter* __temp621 = NULL;
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (p), VALA_CCODE_NODE ((__temp621 = vala_ccode_formal_parameter_new (vala_formal_parameter_get_name (p), vala_type_reference_get_cname (vala_formal_parameter_get_type_reference (p), FALSE, !vala_type_reference_get_takes_ownership (vala_formal_parameter_get_type_reference (p))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (p)));
		(__temp621 == NULL ? NULL : (__temp621 = (g_object_unref (__temp621), NULL)));
	}
}


static void vala_code_generator_real_visit_end_property (ValaCodeVisitor* base, ValaProperty* prop)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_PROPERTY (prop));
	char* __temp622 = NULL;
	vala_ccode_enum_add_value (self->priv->prop_enum, (__temp622 = vala_property_get_upper_case_cname (prop)), NULL);
	(__temp622 = (g_free (__temp622), NULL));
}


static void vala_code_generator_real_visit_begin_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_PROPERTY_ACCESSOR (acc));
	ValaProperty* __temp623 = NULL;
	ValaProperty* prop = (__temp623 = VALA_PROPERTY (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (acc))))), (__temp623 == NULL ? NULL : g_object_ref (__temp623)));
	if (vala_property_accessor_get_readable (acc)) {
		ValaTypeReference* __temp624 = NULL;
		self->priv->current_return_type = (__temp624 = g_object_ref (vala_property_get_type_reference (prop)), (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL))), __temp624);
	} else {
		/* void*/
		ValaTypeReference* __temp625 = NULL;
		self->priv->current_return_type = (__temp625 = vala_type_reference_new (), (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL))), __temp625);
	}
	(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
}


static void vala_code_generator_real_visit_end_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_PROPERTY_ACCESSOR (acc));
	ValaProperty* __temp626 = NULL;
	ValaProperty* prop = (__temp626 = VALA_PROPERTY (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (acc))))), (__temp626 == NULL ? NULL : g_object_ref (__temp626)));
	ValaTypeReference* __temp627 = NULL;
	self->priv->current_return_type = (__temp627 = NULL, (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL))), __temp627);
	ValaDataType* __temp628 = NULL;
	ValaDataType* t = (__temp628 = VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (prop))))), (__temp628 == NULL ? NULL : g_object_ref (__temp628)));
	ValaTypeReference* this_type = vala_type_reference_new ();
	(vala_type_reference_set_data_type (this_type, t), vala_type_reference_get_data_type (this_type));
	ValaCCodeFormalParameter* cselfparam = vala_ccode_formal_parameter_new ("self", vala_type_reference_get_cname (this_type, FALSE, FALSE));
	ValaCCodeFormalParameter* cvalueparam = vala_ccode_formal_parameter_new ("value", vala_type_reference_get_cname (vala_property_get_type_reference (prop), FALSE, TRUE));
	if (vala_property_get_is_abstract (prop) || vala_property_get_is_virtual (prop)) {
		if (vala_property_accessor_get_readable (acc)) {
			ValaCCodeFunction* __temp630 = NULL;
			char* __temp629 = NULL;
			self->priv->function = (__temp630 = vala_ccode_function_new (g_strdup_printf ("%s_get_%s", (__temp629 = vala_data_type_get_lower_case_cname (t, NULL)), vala_property_get_name (prop)), vala_type_reference_get_cname (vala_property_get_type_reference (prop), FALSE, FALSE)), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), __temp630);
			(__temp629 = (g_free (__temp629), NULL));
		} else {
			ValaCCodeFunction* __temp632 = NULL;
			char* __temp631 = NULL;
			self->priv->function = (__temp632 = vala_ccode_function_new (g_strdup_printf ("%s_set_%s", (__temp631 = vala_data_type_get_lower_case_cname (t, NULL)), vala_property_get_name (prop)), "void"), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), __temp632);
			(__temp631 = (g_free (__temp631), NULL));
		}
		vala_ccode_function_add_parameter (self->priv->function, cselfparam);
		if (vala_property_accessor_get_writable (acc) || vala_property_accessor_get_construction (acc)) {
			vala_ccode_function_add_parameter (self->priv->function, cvalueparam);
		}
		ValaCCodeFunction* __temp633 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((__temp633 = vala_ccode_function_copy (self->priv->function))));
		(__temp633 = (g_object_unref (__temp633), NULL));
		ValaCCodeBlock* block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
		(vala_ccode_function_set_block (self->priv->function, block), vala_ccode_function_get_block (self->priv->function));
		if (vala_property_accessor_get_readable (acc)) {
			/* declare temporary variable to save the property value*/
			ValaCCodeDeclaration* decl = vala_ccode_declaration_new (vala_type_reference_get_cname (vala_property_get_type_reference (prop), FALSE, FALSE));
			ValaCCodeVariableDeclarator* __temp634 = NULL;
			vala_ccode_declaration_add_declarator (decl, VALA_CCODE_DECLARATOR ((__temp634 = vala_ccode_variable_declarator_new ("value"))));
			(__temp634 == NULL ? NULL : (__temp634 = (g_object_unref (__temp634), NULL)));
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE (decl));
			ValaCCodeFunctionCall* ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_object_get")));
			ValaCCodeFunctionCall* ccast = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("G_OBJECT")));
			ValaCCodeIdentifier* __temp635 = NULL;
			vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((__temp635 = vala_ccode_identifier_new ("self"))));
			(__temp635 == NULL ? NULL : (__temp635 = (g_object_unref (__temp635), NULL)));
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccast));
			/* property name is second argument of g_object_get*/
			ValaCCodeConstant* __temp636 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp636 = vala_property_get_canonical_cconstant (prop))));
			(__temp636 = (g_object_unref (__temp636), NULL));
			ValaCCodeUnaryExpression* __temp637 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp637 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("value"))))));
			(__temp637 == NULL ? NULL : (__temp637 = (g_object_unref (__temp637), NULL)));
			ValaCCodeConstant* __temp638 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp638 = vala_ccode_constant_new ("NULL"))));
			(__temp638 == NULL ? NULL : (__temp638 = (g_object_unref (__temp638), NULL)));
			ValaCCodeExpressionStatement* __temp639 = NULL;
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((__temp639 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
			(__temp639 == NULL ? NULL : (__temp639 = (g_object_unref (__temp639), NULL)));
			ValaCCodeReturnStatement* __temp640 = NULL;
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((__temp640 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("value"))))));
			(__temp640 == NULL ? NULL : (__temp640 = (g_object_unref (__temp640), NULL)));
			(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
		} else {
			ValaCCodeFunctionCall* ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_object_set")));
			ValaCCodeFunctionCall* ccast = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("G_OBJECT")));
			ValaCCodeIdentifier* __temp641 = NULL;
			vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((__temp641 = vala_ccode_identifier_new ("self"))));
			(__temp641 == NULL ? NULL : (__temp641 = (g_object_unref (__temp641), NULL)));
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccast));
			/* property name is second argument of g_object_set*/
			ValaCCodeConstant* __temp642 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp642 = vala_property_get_canonical_cconstant (prop))));
			(__temp642 = (g_object_unref (__temp642), NULL));
			ValaCCodeIdentifier* __temp643 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp643 = vala_ccode_identifier_new ("value"))));
			(__temp643 == NULL ? NULL : (__temp643 = (g_object_unref (__temp643), NULL)));
			ValaCCodeConstant* __temp644 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp644 = vala_ccode_constant_new ("NULL"))));
			(__temp644 == NULL ? NULL : (__temp644 = (g_object_unref (__temp644), NULL)));
			ValaCCodeExpressionStatement* __temp645 = NULL;
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((__temp645 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
			(__temp645 == NULL ? NULL : (__temp645 = (g_object_unref (__temp645), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
		}
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (self->priv->function));
		(block == NULL ? NULL : (block = (g_object_unref (block), NULL)));
	}
	if (!vala_property_get_is_abstract (prop)) {
		gboolean is_virtual = vala_property_get_base_property (prop) != NULL || vala_property_get_base_interface_property (prop) != NULL;
		char* prefix = vala_data_type_get_lower_case_cname (t, NULL);
		if (is_virtual) {
			char* __temp646 = NULL;
			prefix = (__temp646 = g_strconcat (prefix, ("_real"), NULL), (prefix = (g_free (prefix), NULL)), __temp646);
		}
		if (vala_property_accessor_get_readable (acc)) {
			ValaCCodeFunction* __temp647 = NULL;
			self->priv->function = (__temp647 = vala_ccode_function_new (g_strdup_printf ("%s_get_%s", prefix, vala_property_get_name (prop)), vala_type_reference_get_cname (vala_property_get_type_reference (prop), FALSE, FALSE)), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), __temp647);
		} else {
			ValaCCodeFunction* __temp648 = NULL;
			self->priv->function = (__temp648 = vala_ccode_function_new (g_strdup_printf ("%s_set_%s", prefix, vala_property_get_name (prop)), "void"), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), __temp648);
		}
		if (is_virtual) {
			(vala_ccode_function_set_modifiers (self->priv->function, vala_ccode_function_get_modifiers (self->priv->function) | (VALA_CCODE_MODIFIERS_STATIC)), vala_ccode_function_get_modifiers (self->priv->function));
		}
		vala_ccode_function_add_parameter (self->priv->function, cselfparam);
		if (vala_property_accessor_get_writable (acc) || vala_property_accessor_get_construction (acc)) {
			vala_ccode_function_add_parameter (self->priv->function, cvalueparam);
		}
		if (!is_virtual) {
			ValaCCodeFunction* __temp649 = NULL;
			vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((__temp649 = vala_ccode_function_copy (self->priv->function))));
			(__temp649 = (g_object_unref (__temp649), NULL));
		}
		if (vala_property_accessor_get_body (acc) != NULL) {
			(vala_ccode_function_set_block (self->priv->function, VALA_CCODE_BLOCK (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_property_accessor_get_body (acc))))), vala_ccode_function_get_block (self->priv->function));
			ValaCCodeStatement* __temp650 = NULL;
			vala_ccode_block_prepend_statement (vala_ccode_function_get_block (self->priv->function), VALA_CCODE_NODE ((__temp650 = vala_code_generator_create_property_type_check_statement (self, prop, vala_property_accessor_get_readable (acc), t, TRUE, "self"))));
			(__temp650 == NULL ? NULL : (__temp650 = (g_object_unref (__temp650), NULL)));
		}
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (self->priv->function));
		(prefix = (g_free (prefix), NULL));
	}
	(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
	(t == NULL ? NULL : (t = (g_object_unref (t), NULL)));
	(this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL)));
	(cselfparam == NULL ? NULL : (cselfparam = (g_object_unref (cselfparam), NULL)));
	(cvalueparam == NULL ? NULL : (cvalueparam = (g_object_unref (cvalueparam), NULL)));
}


static char* vala_code_generator_get_marshaller_type_name (ValaCodeGenerator* self, ValaTypeReference* t)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (t == NULL || VALA_IS_TYPE_REFERENCE (t), NULL);
	if (vala_type_reference_get_type_parameter (t) != NULL) {
		return g_strdup (("POINTER"));
	} else {
		if (vala_type_reference_get_data_type (t) == NULL) {
			return g_strdup (("VOID"));
		} else {
			return vala_data_type_get_marshaller_type_name (vala_type_reference_get_data_type (t));
		}
	}
}


static char* vala_code_generator_get_signal_marshaller_function (ValaCodeGenerator* self, ValaSignal* sig, const char* prefix)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_SIGNAL (sig), NULL);
	char* signature = vala_code_generator_get_signal_signature (self, sig);
	char* ret = NULL;
	GList* params = vala_invokable_get_parameters (VALA_INVOKABLE (sig));
	if (prefix == NULL) {
		/* FIXME remove equality check with cast in next revision*/
		if (GPOINTER_TO_INT (g_hash_table_lookup (self->priv->predefined_marshal_list, signature)) != ((gboolean) NULL)) {
			prefix = "g_cclosure_marshal";
		} else {
			prefix = "g_cclosure_user_marshal";
		}
	}
	char* __temp655 = NULL;
	char* __temp654 = NULL;
	ret = (__temp655 = g_strdup_printf ("%s_%s_", prefix, (__temp654 = vala_code_generator_get_marshaller_type_name (self, vala_signal_get_return_type (sig)))), (ret = (g_free (ret), NULL)), __temp655);
	(__temp654 = (g_free (__temp654), NULL));
	if (params == NULL) {
		char* __temp656 = NULL;
		ret = (__temp656 = g_strconcat (ret, "_VOID", NULL), (ret = (g_free (ret), NULL)), __temp656);
	} else {
		{
			GList* __temp659 = NULL;
			__temp659 = params;
			GList* p_it;
			for (p_it = __temp659; p_it != NULL; p_it = p_it->next) {
				ValaFormalParameter* p = p_it->data;
				{
					char* __temp658 = NULL;
					char* __temp657 = NULL;
					ret = (__temp658 = g_strdup_printf ("%s_%s", ret, (__temp657 = vala_code_generator_get_marshaller_type_name (self, vala_formal_parameter_get_type_reference (p)))), (ret = (g_free (ret), NULL)), __temp658);
					(__temp657 = (g_free (__temp657), NULL));
				}
			}
		}
	}
	char* __temp660 = NULL;
	return (__temp660 = ret, (signature = (g_free (signature), NULL)), (params == NULL ? NULL : (params = (g_list_free (params), NULL))), __temp660);
	(signature = (g_free (signature), NULL));
	(ret = (g_free (ret), NULL));
	(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
}


static char* vala_code_generator_get_value_type_name_from_type_reference (ValaCodeGenerator* self, ValaTypeReference* t)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (t), NULL);
	if (vala_type_reference_get_type_parameter (t) != NULL) {
		return g_strdup ("gpointer");
	} else {
		if (vala_type_reference_get_data_type (t) == NULL) {
			return g_strdup ("void");
		} else {
			if (VALA_IS_CLASS (vala_type_reference_get_data_type (t)) || VALA_IS_INTERFACE (vala_type_reference_get_data_type (t))) {
				return g_strdup ("GObject *");
			} else {
				if (VALA_IS_STRUCT (vala_type_reference_get_data_type (t))) {
					if (vala_data_type_is_reference_type (VALA_DATA_TYPE ((VALA_STRUCT (vala_type_reference_get_data_type (t)))))) {
						return g_strdup ("gpointer");
					} else {
						return vala_data_type_get_cname (vala_type_reference_get_data_type (t), FALSE);
					}
				} else {
					if (VALA_IS_ENUM (vala_type_reference_get_data_type (t))) {
						return g_strdup ("gint");
					} else {
						if (VALA_IS_FLAGS (vala_type_reference_get_data_type (t))) {
							return g_strdup ("guint");
						} else {
							if (VALA_IS_ARRAY (vala_type_reference_get_data_type (t))) {
								return g_strdup ("gpointer");
							}
						}
					}
				}
			}
		}
	}
	return NULL;
}


static char* vala_code_generator_get_signal_signature (ValaCodeGenerator* self, ValaSignal* sig)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_SIGNAL (sig), NULL);
	char* signature = NULL;
	GList* params = vala_invokable_get_parameters (VALA_INVOKABLE (sig));
	char* __temp671 = NULL;
	char* __temp670 = NULL;
	signature = (__temp671 = g_strdup_printf ("%s:", (__temp670 = vala_code_generator_get_marshaller_type_name (self, vala_signal_get_return_type (sig)))), (signature = (g_free (signature), NULL)), __temp671);
	(__temp670 = (g_free (__temp670), NULL));
	if (params == NULL) {
		char* __temp672 = NULL;
		signature = (__temp672 = g_strconcat (signature, "VOID", NULL), (signature = (g_free (signature), NULL)), __temp672);
	} else {
		gboolean first = TRUE;
		{
			GList* __temp677 = NULL;
			__temp677 = params;
			GList* p_it;
			for (p_it = __temp677; p_it != NULL; p_it = p_it->next) {
				ValaFormalParameter* p = p_it->data;
				{
					if (first) {
						char* __temp674 = NULL;
						char* __temp673 = NULL;
						signature = (__temp674 = g_strconcat (signature, (__temp673 = vala_code_generator_get_marshaller_type_name (self, vala_formal_parameter_get_type_reference (p))), NULL), (signature = (g_free (signature), NULL)), __temp674);
						(__temp673 = (g_free (__temp673), NULL));
						first = FALSE;
					} else {
						char* __temp676 = NULL;
						char* __temp675 = NULL;
						signature = (__temp676 = g_strdup_printf ("%s,%s", signature, (__temp675 = vala_code_generator_get_marshaller_type_name (self, vala_formal_parameter_get_type_reference (p)))), (signature = (g_free (signature), NULL)), __temp676);
						(__temp675 = (g_free (__temp675), NULL));
					}
				}
			}
		}
	}
	char* __temp678 = NULL;
	return (__temp678 = signature, (params == NULL ? NULL : (params = (g_list_free (params), NULL))), __temp678);
	(signature = (g_free (signature), NULL));
	(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
}


static void vala_code_generator_real_visit_end_signal (ValaCodeVisitor* base, ValaSignal* sig)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_SIGNAL (sig));
	char* signature = NULL;
	GList* params = vala_invokable_get_parameters (VALA_INVOKABLE (sig));
	gint n_params = 0;
	gint i = 0;
	/* check whether a signal with the same signature already exists for this source file (or predefined) */
	char* __temp679 = NULL;
	signature = (__temp679 = vala_code_generator_get_signal_signature (self, sig), (signature = (g_free (signature), NULL)), __temp679);
	/* FIXME remove equality checks with cast in next revision*/
	if (GPOINTER_TO_INT (g_hash_table_lookup (self->priv->predefined_marshal_list, signature)) != ((gboolean) NULL) || GPOINTER_TO_INT (g_hash_table_lookup (self->priv->user_marshal_list, signature)) != ((gboolean) NULL)) {
		(signature = (g_free (signature), NULL));
		(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
		return;
	}
	ValaCCodeFunction* signal_marshaller = vala_ccode_function_new (vala_code_generator_get_signal_marshaller_function (self, sig, NULL), "void");
	(vala_ccode_function_set_modifiers (signal_marshaller, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_function_get_modifiers (signal_marshaller));
	ValaCCodeFormalParameter* __temp680 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (__temp680 = vala_ccode_formal_parameter_new ("closure", "GClosure *")));
	(__temp680 == NULL ? NULL : (__temp680 = (g_object_unref (__temp680), NULL)));
	ValaCCodeFormalParameter* __temp681 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (__temp681 = vala_ccode_formal_parameter_new ("return_value", "GValue *")));
	(__temp681 == NULL ? NULL : (__temp681 = (g_object_unref (__temp681), NULL)));
	ValaCCodeFormalParameter* __temp682 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (__temp682 = vala_ccode_formal_parameter_new ("n_param_values", "guint")));
	(__temp682 == NULL ? NULL : (__temp682 = (g_object_unref (__temp682), NULL)));
	ValaCCodeFormalParameter* __temp683 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (__temp683 = vala_ccode_formal_parameter_new ("param_values", "const GValue *")));
	(__temp683 == NULL ? NULL : (__temp683 = (g_object_unref (__temp683), NULL)));
	ValaCCodeFormalParameter* __temp684 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (__temp684 = vala_ccode_formal_parameter_new ("invocation_hint", "gpointer")));
	(__temp684 == NULL ? NULL : (__temp684 = (g_object_unref (__temp684), NULL)));
	ValaCCodeFormalParameter* __temp685 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (__temp685 = vala_ccode_formal_parameter_new ("marshal_data", "gpointer")));
	(__temp685 == NULL ? NULL : (__temp685 = (g_object_unref (__temp685), NULL)));
	ValaCCodeFunction* __temp686 = NULL;
	vala_ccode_fragment_append (self->priv->source_signal_marshaller_declaration, VALA_CCODE_NODE ((__temp686 = vala_ccode_function_copy (signal_marshaller))));
	(__temp686 = (g_object_unref (__temp686), NULL));
	ValaCCodeBlock* marshaller_body = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	ValaCCodeFunctionDeclarator* callback_decl = vala_ccode_function_declarator_new (vala_code_generator_get_signal_marshaller_function (self, sig, "GMarshalFunc"));
	ValaCCodeFormalParameter* __temp687 = NULL;
	vala_ccode_function_declarator_add_parameter (callback_decl, (__temp687 = vala_ccode_formal_parameter_new ("data1", "gpointer")));
	(__temp687 == NULL ? NULL : (__temp687 = (g_object_unref (__temp687), NULL)));
	n_params = 1;
	{
		GList* __temp689 = NULL;
		__temp689 = params;
		GList* p_it;
		for (p_it = __temp689; p_it != NULL; p_it = p_it->next) {
			ValaFormalParameter* p = p_it->data;
			{
				ValaCCodeFormalParameter* __temp688 = NULL;
				vala_ccode_function_declarator_add_parameter (callback_decl, (__temp688 = vala_ccode_formal_parameter_new (g_strdup_printf ("arg_%d", n_params), vala_code_generator_get_value_type_name_from_type_reference (self, vala_formal_parameter_get_type_reference (p)))));
				(__temp688 == NULL ? NULL : (__temp688 = (g_object_unref (__temp688), NULL)));
				n_params++;
			}
		}
	}
	ValaCCodeFormalParameter* __temp690 = NULL;
	vala_ccode_function_declarator_add_parameter (callback_decl, (__temp690 = vala_ccode_formal_parameter_new ("data2", "gpointer")));
	(__temp690 == NULL ? NULL : (__temp690 = (g_object_unref (__temp690), NULL)));
	ValaCCodeTypeDefinition* __temp691 = NULL;
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((__temp691 = vala_ccode_type_definition_new (vala_code_generator_get_value_type_name_from_type_reference (self, vala_signal_get_return_type (sig)), VALA_CCODE_DECLARATOR (callback_decl)))));
	(__temp691 == NULL ? NULL : (__temp691 = (g_object_unref (__temp691), NULL)));
	ValaCCodeDeclaration* var_decl = vala_ccode_declaration_new (vala_code_generator_get_signal_marshaller_function (self, sig, "GMarshalFunc"));
	(vala_ccode_declaration_set_modifiers (var_decl, VALA_CCODE_MODIFIERS_REGISTER), vala_ccode_declaration_get_modifiers (var_decl));
	ValaCCodeVariableDeclarator* __temp692 = NULL;
	vala_ccode_declaration_add_declarator (var_decl, VALA_CCODE_DECLARATOR ((__temp692 = vala_ccode_variable_declarator_new ("callback"))));
	(__temp692 == NULL ? NULL : (__temp692 = (g_object_unref (__temp692), NULL)));
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE (var_decl));
	ValaCCodeDeclaration* __temp693 = NULL;
	var_decl = (__temp693 = vala_ccode_declaration_new ("GCClosure *"), (var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL))), __temp693);
	(vala_ccode_declaration_set_modifiers (var_decl, VALA_CCODE_MODIFIERS_REGISTER), vala_ccode_declaration_get_modifiers (var_decl));
	ValaCCodeVariableDeclarator* __temp694 = NULL;
	vala_ccode_declaration_add_declarator (var_decl, VALA_CCODE_DECLARATOR ((__temp694 = vala_ccode_variable_declarator_new_with_initializer ("cc", VALA_CCODE_EXPRESSION (vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("closure")), "GCClosure *"))))));
	(__temp694 == NULL ? NULL : (__temp694 = (g_object_unref (__temp694), NULL)));
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE (var_decl));
	ValaCCodeDeclaration* __temp695 = NULL;
	var_decl = (__temp695 = vala_ccode_declaration_new ("gpointer"), (var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL))), __temp695);
	(vala_ccode_declaration_set_modifiers (var_decl, VALA_CCODE_MODIFIERS_REGISTER), vala_ccode_declaration_get_modifiers (var_decl));
	ValaCCodeVariableDeclarator* __temp696 = NULL;
	vala_ccode_declaration_add_declarator (var_decl, VALA_CCODE_DECLARATOR ((__temp696 = vala_ccode_variable_declarator_new ("data1"))));
	(__temp696 == NULL ? NULL : (__temp696 = (g_object_unref (__temp696), NULL)));
	ValaCCodeVariableDeclarator* __temp697 = NULL;
	vala_ccode_declaration_add_declarator (var_decl, VALA_CCODE_DECLARATOR ((__temp697 = vala_ccode_variable_declarator_new ("data2"))));
	(__temp697 == NULL ? NULL : (__temp697 = (g_object_unref (__temp697), NULL)));
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE (var_decl));
	ValaCCodeFunctionCall* fc = NULL;
	if (vala_type_reference_get_data_type (vala_signal_get_return_type (sig)) != NULL) {
		ValaCCodeDeclaration* __temp698 = NULL;
		var_decl = (__temp698 = vala_ccode_declaration_new (vala_code_generator_get_value_type_name_from_type_reference (self, vala_signal_get_return_type (sig))), (var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL))), __temp698);
		ValaCCodeVariableDeclarator* __temp699 = NULL;
		vala_ccode_declaration_add_declarator (var_decl, VALA_CCODE_DECLARATOR ((__temp699 = vala_ccode_variable_declarator_new ("v_return"))));
		(__temp699 == NULL ? NULL : (__temp699 = (g_object_unref (__temp699), NULL)));
		vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE (var_decl));
		ValaCCodeFunctionCall* __temp700 = NULL;
		fc = (__temp700 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_return_if_fail"))), (fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL))), __temp700);
		ValaCCodeBinaryExpression* __temp701 = NULL;
		vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((__temp701 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("return_value")), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"))))));
		(__temp701 == NULL ? NULL : (__temp701 = (g_object_unref (__temp701), NULL)));
		ValaCCodeExpressionStatement* __temp702 = NULL;
		vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((__temp702 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
		(__temp702 == NULL ? NULL : (__temp702 = (g_object_unref (__temp702), NULL)));
	}
	ValaCCodeFunctionCall* __temp703 = NULL;
	fc = (__temp703 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_return_if_fail"))), (fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL))), __temp703);
	ValaCCodeBinaryExpression* __temp704 = NULL;
	vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((__temp704 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("n_param_values")), VALA_CCODE_EXPRESSION (vala_ccode_constant_new (g_strdup_printf ("%i", n_params)))))));
	(__temp704 == NULL ? NULL : (__temp704 = (g_object_unref (__temp704), NULL)));
	ValaCCodeExpressionStatement* __temp705 = NULL;
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((__temp705 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
	(__temp705 == NULL ? NULL : (__temp705 = (g_object_unref (__temp705), NULL)));
	ValaCCodeMemberAccess* data = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("closure")), "data", TRUE);
	ValaCCodeMemberAccess* param = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("param_values")), "data[0]", TRUE)), "v_pointer", FALSE);
	ValaCCodeFunctionCall* cond = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("G_CCLOSURE_SWAP_DATA")));
	ValaCCodeIdentifier* __temp706 = NULL;
	vala_ccode_function_call_add_argument (cond, VALA_CCODE_EXPRESSION ((__temp706 = vala_ccode_identifier_new ("closure"))));
	(__temp706 == NULL ? NULL : (__temp706 = (g_object_unref (__temp706), NULL)));
	ValaCCodeBlock* true_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	ValaCCodeExpressionStatement* __temp707 = NULL;
	vala_ccode_block_add_statement (true_block, VALA_CCODE_NODE ((__temp707 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("data1")), VALA_CCODE_EXPRESSION (data), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp707 == NULL ? NULL : (__temp707 = (g_object_unref (__temp707), NULL)));
	ValaCCodeExpressionStatement* __temp708 = NULL;
	vala_ccode_block_add_statement (true_block, VALA_CCODE_NODE ((__temp708 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("data2")), VALA_CCODE_EXPRESSION (param), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp708 == NULL ? NULL : (__temp708 = (g_object_unref (__temp708), NULL)));
	ValaCCodeBlock* false_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	ValaCCodeExpressionStatement* __temp709 = NULL;
	vala_ccode_block_add_statement (false_block, VALA_CCODE_NODE ((__temp709 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("data1")), VALA_CCODE_EXPRESSION (param), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp709 == NULL ? NULL : (__temp709 = (g_object_unref (__temp709), NULL)));
	ValaCCodeExpressionStatement* __temp710 = NULL;
	vala_ccode_block_add_statement (false_block, VALA_CCODE_NODE ((__temp710 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("data2")), VALA_CCODE_EXPRESSION (data), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp710 == NULL ? NULL : (__temp710 = (g_object_unref (__temp710), NULL)));
	ValaCCodeIfStatement* __temp711 = NULL;
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((__temp711 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (cond), VALA_CCODE_STATEMENT (true_block), VALA_CCODE_STATEMENT (false_block)))));
	(__temp711 == NULL ? NULL : (__temp711 = (g_object_unref (__temp711), NULL)));
	ValaCCodeAssignment* c_assign = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("callback")), VALA_CCODE_EXPRESSION (vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("marshal_data")), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("marshal_data")), VALA_CCODE_EXPRESSION (vala_ccode_member_access_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("cc")), "callback", TRUE)))), vala_code_generator_get_signal_marshaller_function (self, sig, "GMarshalFunc"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	ValaCCodeExpressionStatement* __temp712 = NULL;
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((__temp712 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (c_assign)))));
	(__temp712 == NULL ? NULL : (__temp712 = (g_object_unref (__temp712), NULL)));
	ValaCCodeFunctionCall* __temp713 = NULL;
	fc = (__temp713 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("callback"))), (fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL))), __temp713);
	ValaCCodeIdentifier* __temp714 = NULL;
	vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((__temp714 = vala_ccode_identifier_new ("data1"))));
	(__temp714 == NULL ? NULL : (__temp714 = (g_object_unref (__temp714), NULL)));
	i = 1;
	{
		GList* __temp718 = NULL;
		__temp718 = params;
		GList* p_it;
		for (p_it = __temp718; p_it != NULL; p_it = p_it->next) {
			ValaFormalParameter* p = p_it->data;
			{
				char* get_value_function = NULL;
				if (vala_type_reference_get_type_parameter (vala_formal_parameter_get_type_reference (p)) != NULL) {
					char* __temp715 = NULL;
					get_value_function = (__temp715 = g_strdup ("g_value_get_pointer"), (get_value_function = (g_free (get_value_function), NULL)), __temp715);
				} else {
					char* __temp716 = NULL;
					get_value_function = (__temp716 = vala_data_type_get_get_value_function (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (p))), (get_value_function = (g_free (get_value_function), NULL)), __temp716);
				}
				ValaCCodeFunctionCall* inner_fc = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (get_value_function)));
				ValaCCodeBinaryExpression* __temp717 = NULL;
				vala_ccode_function_call_add_argument (inner_fc, VALA_CCODE_EXPRESSION ((__temp717 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("param_values")), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%i", i)))))));
				(__temp717 == NULL ? NULL : (__temp717 = (g_object_unref (__temp717), NULL)));
				vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION (inner_fc));
				i++;
				(get_value_function = (g_free (get_value_function), NULL));
				(inner_fc == NULL ? NULL : (inner_fc = (g_object_unref (inner_fc), NULL)));
			}
		}
	}
	ValaCCodeIdentifier* __temp719 = NULL;
	vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((__temp719 = vala_ccode_identifier_new ("data2"))));
	(__temp719 == NULL ? NULL : (__temp719 = (g_object_unref (__temp719), NULL)));
	if (vala_type_reference_get_data_type (vala_signal_get_return_type (sig)) != NULL) {
		ValaCCodeExpressionStatement* __temp720 = NULL;
		vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((__temp720 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("v_return")), VALA_CCODE_EXPRESSION (fc), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
		(__temp720 == NULL ? NULL : (__temp720 = (g_object_unref (__temp720), NULL)));
		ValaCCodeFunctionCall* set_fc = NULL;
		if (vala_type_reference_get_type_parameter (vala_signal_get_return_type (sig)) != NULL) {
			ValaCCodeFunctionCall* __temp721 = NULL;
			set_fc = (__temp721 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_value_set_pointer"))), (set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL))), __temp721);
		} else {
			if (VALA_IS_CLASS (vala_type_reference_get_data_type (vala_signal_get_return_type (sig))) || VALA_IS_INTERFACE (vala_type_reference_get_data_type (vala_signal_get_return_type (sig)))) {
				ValaCCodeFunctionCall* __temp722 = NULL;
				set_fc = (__temp722 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_value_take_object"))), (set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL))), __temp722);
			} else {
				if (vala_type_reference_get_data_type (vala_signal_get_return_type (sig)) == vala_type_reference_get_data_type (self->priv->string_type)) {
					ValaCCodeFunctionCall* __temp723 = NULL;
					set_fc = (__temp723 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_value_take_string"))), (set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL))), __temp723);
				} else {
					ValaCCodeFunctionCall* __temp724 = NULL;
					set_fc = (__temp724 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_set_value_function (vala_type_reference_get_data_type (vala_signal_get_return_type (sig)))))), (set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL))), __temp724);
				}
			}
		}
		ValaCCodeIdentifier* __temp725 = NULL;
		vala_ccode_function_call_add_argument (set_fc, VALA_CCODE_EXPRESSION ((__temp725 = vala_ccode_identifier_new ("return_value"))));
		(__temp725 == NULL ? NULL : (__temp725 = (g_object_unref (__temp725), NULL)));
		ValaCCodeIdentifier* __temp726 = NULL;
		vala_ccode_function_call_add_argument (set_fc, VALA_CCODE_EXPRESSION ((__temp726 = vala_ccode_identifier_new ("v_return"))));
		(__temp726 == NULL ? NULL : (__temp726 = (g_object_unref (__temp726), NULL)));
		ValaCCodeExpressionStatement* __temp727 = NULL;
		vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((__temp727 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (set_fc)))));
		(__temp727 == NULL ? NULL : (__temp727 = (g_object_unref (__temp727), NULL)));
		(set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL)));
	} else {
		ValaCCodeExpressionStatement* __temp728 = NULL;
		vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((__temp728 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
		(__temp728 == NULL ? NULL : (__temp728 = (g_object_unref (__temp728), NULL)));
	}
	(vala_ccode_function_set_block (signal_marshaller, marshaller_body), vala_ccode_function_get_block (signal_marshaller));
	vala_ccode_fragment_append (self->priv->source_signal_marshaller_definition, VALA_CCODE_NODE (signal_marshaller));
	const char* __temp729 = NULL;
	g_hash_table_insert (self->priv->user_marshal_list, (__temp729 = signature, (__temp729 == NULL ? NULL : g_strdup (__temp729))), GINT_TO_POINTER (TRUE));
	(signature = (g_free (signature), NULL));
	(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
	(signal_marshaller == NULL ? NULL : (signal_marshaller = (g_object_unref (signal_marshaller), NULL)));
	(marshaller_body == NULL ? NULL : (marshaller_body = (g_object_unref (marshaller_body), NULL)));
	(callback_decl == NULL ? NULL : (callback_decl = (g_object_unref (callback_decl), NULL)));
	(var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL)));
	(fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL)));
	(data == NULL ? NULL : (data = (g_object_unref (data), NULL)));
	(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
	(cond == NULL ? NULL : (cond = (g_object_unref (cond), NULL)));
	(true_block == NULL ? NULL : (true_block = (g_object_unref (true_block), NULL)));
	(false_block == NULL ? NULL : (false_block = (g_object_unref (false_block), NULL)));
	(c_assign == NULL ? NULL : (c_assign = (g_object_unref (c_assign), NULL)));
}


static void vala_code_generator_real_visit_end_constructor (ValaCodeVisitor* base, ValaConstructor* c)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CONSTRUCTOR (c));
	ValaClass* __temp730 = NULL;
	ValaClass* cl = (__temp730 = VALA_CLASS (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (c))))), (__temp730 == NULL ? NULL : g_object_ref (__temp730)));
	ValaCCodeFunction* __temp732 = NULL;
	char* __temp731 = NULL;
	self->priv->function = (__temp732 = vala_ccode_function_new (g_strdup_printf ("%s_constructor", (__temp731 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL))), "GObject *"), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), __temp732);
	(__temp731 = (g_free (__temp731), NULL));
	(vala_ccode_function_set_modifiers (self->priv->function, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_function_get_modifiers (self->priv->function));
	ValaCCodeFormalParameter* __temp733 = NULL;
	vala_ccode_function_add_parameter (self->priv->function, (__temp733 = vala_ccode_formal_parameter_new ("type", "GType")));
	(__temp733 == NULL ? NULL : (__temp733 = (g_object_unref (__temp733), NULL)));
	ValaCCodeFormalParameter* __temp734 = NULL;
	vala_ccode_function_add_parameter (self->priv->function, (__temp734 = vala_ccode_formal_parameter_new ("n_construct_properties", "guint")));
	(__temp734 == NULL ? NULL : (__temp734 = (g_object_unref (__temp734), NULL)));
	ValaCCodeFormalParameter* __temp735 = NULL;
	vala_ccode_function_add_parameter (self->priv->function, (__temp735 = vala_ccode_formal_parameter_new ("construct_properties", "GObjectConstructParam *")));
	(__temp735 == NULL ? NULL : (__temp735 = (g_object_unref (__temp735), NULL)));
	ValaCCodeFunction* __temp736 = NULL;
	vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((__temp736 = vala_ccode_function_copy (self->priv->function))));
	(__temp736 = (g_object_unref (__temp736), NULL));
	ValaCCodeBlock* cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	ValaCCodeDeclaration* cdecl = vala_ccode_declaration_new ("GObject *");
	ValaCCodeVariableDeclarator* __temp737 = NULL;
	vala_ccode_declaration_add_declarator (cdecl, VALA_CCODE_DECLARATOR ((__temp737 = vala_ccode_variable_declarator_new ("obj"))));
	(__temp737 == NULL ? NULL : (__temp737 = (g_object_unref (__temp737), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl));
	ValaCCodeDeclaration* __temp739 = NULL;
	char* __temp738 = NULL;
	cdecl = (__temp739 = vala_ccode_declaration_new (g_strdup_printf ("%sClass *", (__temp738 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), (cdecl == NULL ? NULL : (cdecl = (g_object_unref (cdecl), NULL))), __temp739);
	(__temp738 = (g_free (__temp738), NULL));
	ValaCCodeVariableDeclarator* __temp740 = NULL;
	vala_ccode_declaration_add_declarator (cdecl, VALA_CCODE_DECLARATOR ((__temp740 = vala_ccode_variable_declarator_new ("klass"))));
	(__temp740 == NULL ? NULL : (__temp740 = (g_object_unref (__temp740), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl));
	ValaCCodeDeclaration* __temp741 = NULL;
	cdecl = (__temp741 = vala_ccode_declaration_new ("GObjectClass *"), (cdecl == NULL ? NULL : (cdecl = (g_object_unref (cdecl), NULL))), __temp741);
	ValaCCodeVariableDeclarator* __temp742 = NULL;
	vala_ccode_declaration_add_declarator (cdecl, VALA_CCODE_DECLARATOR ((__temp742 = vala_ccode_variable_declarator_new ("parent_class"))));
	(__temp742 == NULL ? NULL : (__temp742 = (g_object_unref (__temp742), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl));
	ValaCCodeFunctionCall* ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_type_class_peek")));
	ValaCCodeIdentifier* __temp743 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp743 = vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_")))));
	(__temp743 == NULL ? NULL : (__temp743 = (g_object_unref (__temp743), NULL)));
	char* __temp744 = NULL;
	ValaCCodeFunctionCall* __temp745 = NULL;
	ValaCCodeFunctionCall* ccast = (__temp745 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_CLASS", (__temp744 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))))), (__temp744 = (g_free (__temp744), NULL)), __temp745);
	vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION (ccall));
	ValaCCodeExpressionStatement* __temp746 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp746 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("klass")), VALA_CCODE_EXPRESSION (ccast), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp746 == NULL ? NULL : (__temp746 = (g_object_unref (__temp746), NULL)));
	ValaCCodeFunctionCall* __temp747 = NULL;
	ccall = (__temp747 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_type_class_peek_parent"))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp747);
	ValaCCodeIdentifier* __temp748 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp748 = vala_ccode_identifier_new ("klass"))));
	(__temp748 == NULL ? NULL : (__temp748 = (g_object_unref (__temp748), NULL)));
	ValaCCodeFunctionCall* __temp749 = NULL;
	ccast = (__temp749 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("G_OBJECT_CLASS"))), (ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL))), __temp749);
	vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION (ccall));
	ValaCCodeExpressionStatement* __temp750 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp750 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("parent_class")), VALA_CCODE_EXPRESSION (ccast), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp750 == NULL ? NULL : (__temp750 = (g_object_unref (__temp750), NULL)));
	ValaCCodeFunctionCall* __temp751 = NULL;
	ccall = (__temp751 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("parent_class")), "constructor"))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp751);
	ValaCCodeIdentifier* __temp752 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp752 = vala_ccode_identifier_new ("type"))));
	(__temp752 == NULL ? NULL : (__temp752 = (g_object_unref (__temp752), NULL)));
	ValaCCodeIdentifier* __temp753 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp753 = vala_ccode_identifier_new ("n_construct_properties"))));
	(__temp753 == NULL ? NULL : (__temp753 = (g_object_unref (__temp753), NULL)));
	ValaCCodeIdentifier* __temp754 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp754 = vala_ccode_identifier_new ("construct_properties"))));
	(__temp754 == NULL ? NULL : (__temp754 = (g_object_unref (__temp754), NULL)));
	ValaCCodeExpressionStatement* __temp755 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp755 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("obj")), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp755 == NULL ? NULL : (__temp755 = (g_object_unref (__temp755), NULL)));
	ValaCCodeFunctionCall* __temp756 = NULL;
	ccall = (__temp756 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp756);
	ValaCCodeIdentifier* __temp757 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp757 = vala_ccode_identifier_new ("obj"))));
	(__temp757 == NULL ? NULL : (__temp757 = (g_object_unref (__temp757), NULL)));
	ValaCCodeDeclaration* __temp759 = NULL;
	char* __temp758 = NULL;
	cdecl = (__temp759 = vala_ccode_declaration_new (g_strdup_printf ("%s *", (__temp758 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), (cdecl == NULL ? NULL : (cdecl = (g_object_unref (cdecl), NULL))), __temp759);
	(__temp758 = (g_free (__temp758), NULL));
	ValaCCodeVariableDeclarator* __temp760 = NULL;
	vala_ccode_declaration_add_declarator (cdecl, VALA_CCODE_DECLARATOR ((__temp760 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
	(__temp760 == NULL ? NULL : (__temp760 = (g_object_unref (__temp760), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl));
	vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_constructor_get_body (c))));
	ValaCCodeReturnStatement* __temp761 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp761 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("obj"))))));
	(__temp761 == NULL ? NULL : (__temp761 = (g_object_unref (__temp761), NULL)));
	(vala_ccode_function_set_block (self->priv->function, cblock), vala_ccode_function_get_block (self->priv->function));
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (c))) != NULL) {
		ValaCCodeComment* __temp762 = NULL;
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE ((__temp762 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (c)))))));
		(__temp762 == NULL ? NULL : (__temp762 = (g_object_unref (__temp762), NULL)));
	}
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (self->priv->function));
	(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
	(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
	(cdecl == NULL ? NULL : (cdecl = (g_object_unref (cdecl), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
}


static void vala_code_generator_real_visit_begin_block (ValaCodeVisitor* base, ValaBlock* b)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_BLOCK (b));
	ValaSymbol* __temp764 = NULL;
	ValaSymbol* __temp763 = NULL;
	self->priv->current_symbol = (__temp764 = (__temp763 = vala_code_node_get_symbol (VALA_CODE_NODE (b)), (__temp763 == NULL ? NULL : g_object_ref (__temp763))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp764);
}


static void vala_code_generator_add_object_creation (ValaCodeGenerator* self, ValaCCodeBlock* b)
{
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CCODE_BLOCK (b));
	ValaClass* __temp765 = NULL;
	ValaClass* cl = (__temp765 = VALA_CLASS (vala_symbol_get_node (self->priv->current_type_symbol)), (__temp765 == NULL ? NULL : g_object_ref (__temp765)));
	ValaCCodeFunctionCall* ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_object_newv")));
	ValaCCodeConstant* __temp766 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp766 = vala_ccode_constant_new (vala_data_type_get_type_id (VALA_DATA_TYPE (cl))))));
	(__temp766 == NULL ? NULL : (__temp766 = (g_object_unref (__temp766), NULL)));
	ValaCCodeConstant* __temp767 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp767 = vala_ccode_constant_new ("__params_it - __params"))));
	(__temp767 == NULL ? NULL : (__temp767 = (g_object_unref (__temp767), NULL)));
	ValaCCodeConstant* __temp768 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp768 = vala_ccode_constant_new ("__params"))));
	(__temp768 == NULL ? NULL : (__temp768 = (g_object_unref (__temp768), NULL)));
	ValaCCodeVariableDeclarator* cdecl = vala_ccode_variable_declarator_new ("self");
	(vala_ccode_variable_declarator_set_initializer (cdecl, VALA_CCODE_EXPRESSION (ccall)), vala_ccode_variable_declarator_get_initializer (cdecl));
	char* __temp769 = NULL;
	ValaCCodeDeclaration* __temp770 = NULL;
	ValaCCodeDeclaration* cdeclaration = (__temp770 = vala_ccode_declaration_new (g_strdup_printf ("%s *", (__temp769 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), (__temp769 = (g_free (__temp769), NULL)), __temp770);
	vala_ccode_declaration_add_declarator (cdeclaration, VALA_CCODE_DECLARATOR (cdecl));
	vala_ccode_block_add_statement (b, VALA_CCODE_NODE (cdeclaration));
	(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(cdecl == NULL ? NULL : (cdecl = (g_object_unref (cdecl), NULL)));
	(cdeclaration == NULL ? NULL : (cdeclaration = (g_object_unref (cdeclaration), NULL)));
}


static void vala_code_generator_real_visit_end_block (ValaCodeVisitor* base, ValaBlock* b)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_BLOCK (b));
	GList* local_vars = vala_block_get_local_variables (b);
	{
		GList* __temp771 = NULL;
		__temp771 = local_vars;
		GList* decl_it;
		for (decl_it = __temp771; decl_it != NULL; decl_it = decl_it->next) {
			ValaVariableDeclarator* decl = decl_it->data;
			{
				(vala_symbol_set_active (vala_code_node_get_symbol (VALA_CODE_NODE (decl)), FALSE), vala_symbol_get_active (vala_code_node_get_symbol (VALA_CODE_NODE (decl))));
			}
		}
	}
	ValaCCodeBlock* cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	{
		GList* __temp775 = NULL;
		__temp775 = vala_block_get_statements (b);
		GList* stmt_it;
		for (stmt_it = __temp775; stmt_it != NULL; stmt_it = stmt_it->next) {
			ValaStatement* stmt = stmt_it->data;
			{
				ValaSourceReference* __temp772 = NULL;
				ValaSourceReference* src = (__temp772 = vala_code_node_get_source_reference (VALA_CODE_NODE (stmt)), (__temp772 == NULL ? NULL : g_object_ref (__temp772)));
				if (src != NULL && vala_source_reference_get_comment (src) != NULL) {
					ValaCCodeComment* __temp773 = NULL;
					vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp773 = vala_ccode_comment_new (vala_source_reference_get_comment (src)))));
					(__temp773 == NULL ? NULL : (__temp773 = (g_object_unref (__temp773), NULL)));
				}
				if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)))) {
					{
						GList* __temp774 = NULL;
						__temp774 = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)))));
						GList* cstmt_it;
						for (cstmt_it = __temp774; cstmt_it != NULL; cstmt_it = cstmt_it->next) {
							ValaCCodeStatement* cstmt = cstmt_it->data;
							{
								vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cstmt));
							}
						}
						(__temp774 == NULL ? NULL : (__temp774 = (g_list_free (__temp774), NULL)));
					}
				} else {
					vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)))));
				}
				(src == NULL ? NULL : (src = (g_object_unref (src), NULL)));
			}
		}
		(__temp775 == NULL ? NULL : (__temp775 = (g_list_free (__temp775), NULL)));
	}
	if (vala_code_generator_get_memory_management (self)) {
		{
			GList* __temp778 = NULL;
			__temp778 = local_vars;
			GList* decl_it;
			for (decl_it = __temp778; decl_it != NULL; decl_it = decl_it->next) {
				ValaVariableDeclarator* decl = decl_it->data;
				{
					if (vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))) {
						ValaCCodeExpressionStatement* __temp777 = NULL;
						ValaCCodeIdentifier* __temp776 = NULL;
						vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp777 = vala_ccode_expression_statement_new (vala_code_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((__temp776 = vala_ccode_identifier_new (vala_variable_declarator_get_name (decl)))), vala_variable_declarator_get_type_reference (decl))))));
						(__temp777 == NULL ? NULL : (__temp777 = (g_object_unref (__temp777), NULL)));
						(__temp776 == NULL ? NULL : (__temp776 = (g_object_unref (__temp776), NULL)));
					}
				}
			}
		}
	}
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (b), VALA_CCODE_NODE (cblock)), vala_code_node_get_ccodenode (VALA_CODE_NODE (b)));
	ValaSymbol* __temp780 = NULL;
	ValaSymbol* __temp779 = NULL;
	self->priv->current_symbol = (__temp780 = (__temp779 = vala_symbol_get_parent_symbol (self->priv->current_symbol), (__temp779 == NULL ? NULL : g_object_ref (__temp779))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp780);
	(local_vars == NULL ? NULL : (local_vars = (g_list_free (local_vars), NULL)));
	(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
}


static void vala_code_generator_real_visit_empty_statement (ValaCodeVisitor* base, ValaEmptyStatement* stmt)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_EMPTY_STATEMENT (stmt));
	ValaCCodeEmptyStatement* __temp781 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp781 = g_object_new (VALA_TYPE_CCODE_EMPTY_STATEMENT, NULL)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	(__temp781 == NULL ? NULL : (__temp781 = (g_object_unref (__temp781), NULL)));
}


static gboolean vala_code_generator_struct_has_instance_fields (ValaCodeGenerator* self, ValaStruct* st)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), FALSE);
	g_return_val_if_fail (VALA_IS_STRUCT (st), FALSE);
	{
		GList* __temp783 = NULL;
		__temp783 = vala_struct_get_fields (st);
		GList* f_it;
		for (f_it = __temp783; f_it != NULL; f_it = f_it->next) {
			ValaField* f = f_it->data;
			{
				if (vala_field_get_instance (f)) {
					return TRUE;
				}
			}
		}
		(__temp783 == NULL ? NULL : (__temp783 = (g_list_free (__temp783), NULL)));
	}
	return FALSE;
}


static void vala_code_generator_real_visit_declaration_statement (ValaCodeVisitor* base, ValaDeclarationStatement* stmt)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_DECLARATION_STATEMENT (stmt));
	/* split declaration statement as var declarators
	 * might have different types */
	ValaCCodeFragment* cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	{
		GList* __temp797 = NULL;
		__temp797 = vala_local_variable_declaration_get_variable_declarators (vala_declaration_statement_get_declaration (stmt));
		GList* decl_it;
		for (decl_it = __temp797; decl_it != NULL; decl_it = decl_it->next) {
			ValaVariableDeclarator* decl = decl_it->data;
			{
				ValaCCodeDeclaration* cdecl = vala_ccode_declaration_new (vala_type_reference_get_cname (vala_variable_declarator_get_type_reference (decl), FALSE, !vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))));
				vala_ccode_declaration_add_declarator (cdecl, VALA_CCODE_DECLARATOR (VALA_CCODE_VARIABLE_DECLARATOR (vala_code_node_get_ccodenode (VALA_CODE_NODE (decl)))));
				vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE (cdecl));
				/* try to initialize uninitialized variables */
				if (vala_variable_declarator_get_initializer (decl) == NULL && VALA_IS_STRUCT (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))) {
					if (vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))) {
						ValaCCodeConstant* __temp785 = NULL;
						(vala_ccode_variable_declarator_set_initializer ((VALA_CCODE_VARIABLE_DECLARATOR (vala_code_node_get_ccodenode (VALA_CODE_NODE (decl)))), VALA_CCODE_EXPRESSION ((__temp785 = vala_ccode_constant_new ("NULL")))), vala_ccode_variable_declarator_get_initializer ((VALA_CCODE_VARIABLE_DECLARATOR (vala_code_node_get_ccodenode (VALA_CODE_NODE (decl))))));
						(__temp785 == NULL ? NULL : (__temp785 = (g_object_unref (__temp785), NULL)));
					} else {
						char* __temp786 = NULL;
						gboolean __temp787;
						if ((__temp787 = (__temp786 = vala_data_type_get_default_value (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))) != NULL, (__temp786 = (g_free (__temp786), NULL)), __temp787)) {
							ValaCCodeConstant* __temp788 = NULL;
							(vala_ccode_variable_declarator_set_initializer ((VALA_CCODE_VARIABLE_DECLARATOR (vala_code_node_get_ccodenode (VALA_CODE_NODE (decl)))), VALA_CCODE_EXPRESSION ((__temp788 = vala_ccode_constant_new (vala_data_type_get_default_value (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))))))), vala_ccode_variable_declarator_get_initializer ((VALA_CCODE_VARIABLE_DECLARATOR (vala_code_node_get_ccodenode (VALA_CODE_NODE (decl))))));
							(__temp788 == NULL ? NULL : (__temp788 = (g_object_unref (__temp788), NULL)));
						} else {
							if (VALA_IS_STRUCT (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))) && vala_code_generator_struct_has_instance_fields (self, VALA_STRUCT (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))))) {
								ValaStruct* __temp789 = NULL;
								ValaStruct* st = (__temp789 = VALA_STRUCT (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))), (__temp789 == NULL ? NULL : g_object_ref (__temp789)));
								/* memset needs string.h */
								self->priv->string_h_needed = TRUE;
								ValaCCodeFunctionCall* czero = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("memset")));
								ValaCCodeUnaryExpression* __temp790 = NULL;
								vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((__temp790 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (decl)))))));
								(__temp790 == NULL ? NULL : (__temp790 = (g_object_unref (__temp790), NULL)));
								ValaCCodeConstant* __temp791 = NULL;
								vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((__temp791 = vala_ccode_constant_new ("0"))));
								(__temp791 == NULL ? NULL : (__temp791 = (g_object_unref (__temp791), NULL)));
								ValaCCodeIdentifier* __temp793 = NULL;
								char* __temp792 = NULL;
								vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((__temp793 = vala_ccode_identifier_new (g_strdup_printf ("sizeof (%s)", (__temp792 = vala_type_reference_get_cname (vala_variable_declarator_get_type_reference (decl), FALSE, FALSE)))))));
								(__temp793 == NULL ? NULL : (__temp793 = (g_object_unref (__temp793), NULL)));
								(__temp792 = (g_free (__temp792), NULL));
								ValaCCodeExpressionStatement* __temp794 = NULL;
								vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((__temp794 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (czero)))));
								(__temp794 == NULL ? NULL : (__temp794 = (g_object_unref (__temp794), NULL)));
								(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
								(czero == NULL ? NULL : (czero = (g_object_unref (czero), NULL)));
							} else {
								char* __temp796 = NULL;
								char* __temp795 = NULL;
								vala_report_warning (vala_code_node_get_source_reference (VALA_CODE_NODE (decl)), (__temp796 = g_strdup_printf ("unable to initialize a variable of type `%s'", (__temp795 = vala_symbol_get_full_name (vala_code_node_get_symbol (VALA_CODE_NODE (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))))))));
								(__temp796 = (g_free (__temp796), NULL));
								(__temp795 = (g_free (__temp795), NULL));
							}
						}
					}
				}
				(cdecl == NULL ? NULL : (cdecl = (g_object_unref (cdecl), NULL)));
			}
		}
		(__temp797 == NULL ? NULL : (__temp797 = (g_list_free (__temp797), NULL)));
	}
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfrag)), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	{
		GList* __temp798 = NULL;
		__temp798 = vala_local_variable_declaration_get_variable_declarators (vala_declaration_statement_get_declaration (stmt));
		GList* decl_it;
		for (decl_it = __temp798; decl_it != NULL; decl_it = decl_it->next) {
			ValaVariableDeclarator* decl = decl_it->data;
			{
				if (vala_variable_declarator_get_initializer (decl) != NULL) {
					vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), vala_variable_declarator_get_initializer (decl)->temp_vars);
				}
			}
		}
		(__temp798 == NULL ? NULL : (__temp798 = (g_list_free (__temp798), NULL)));
	}
	vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), self->priv->temp_vars);
	GList* __temp799 = NULL;
	self->priv->temp_vars = (__temp799 = NULL, (self->priv->temp_vars == NULL ? NULL : (self->priv->temp_vars = (g_list_foreach (self->priv->temp_vars, (GFunc) g_object_unref, NULL), g_list_free (self->priv->temp_vars), NULL))), __temp799);
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static void vala_code_generator_real_visit_variable_declarator (ValaCodeVisitor* base, ValaVariableDeclarator* decl)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_VARIABLE_DECLARATOR (decl));
	if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))) {
		/* create variables to store array dimensions*/
		ValaArray* __temp800 = NULL;
		ValaArray* arr = (__temp800 = VALA_ARRAY (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))), (__temp800 == NULL ? NULL : g_object_ref (__temp800)));
		{
			gint dim = 0;
			for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
				ValaVariableDeclarator* len_decl = vala_variable_declarator_new (vala_code_generator_get_array_length_cname (self, vala_variable_declarator_get_name (decl), dim), NULL, NULL);
				ValaTypeReference* __temp801 = NULL;
				(vala_variable_declarator_set_type_reference (len_decl, (__temp801 = vala_type_reference_new ())), vala_variable_declarator_get_type_reference (len_decl));
				(__temp801 == NULL ? NULL : (__temp801 = (g_object_unref (__temp801), NULL)));
				(vala_type_reference_set_data_type (vala_variable_declarator_get_type_reference (len_decl), vala_type_reference_get_data_type (self->priv->int_type)), vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (len_decl)));
				ValaVariableDeclarator* __temp802 = NULL;
				self->priv->temp_vars = g_list_prepend (self->priv->temp_vars, (__temp802 = len_decl, (__temp802 == NULL ? NULL : g_object_ref (__temp802))));
				(len_decl == NULL ? NULL : (len_decl = (g_object_unref (len_decl), NULL)));
			}
		}
		(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
	}
	ValaCCodeExpression* rhs = NULL;
	if (vala_variable_declarator_get_initializer (decl) != NULL) {
		ValaCCodeExpression* __temp804 = NULL;
		ValaCCodeExpression* __temp803 = NULL;
		rhs = (__temp804 = (__temp803 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_variable_declarator_get_initializer (decl)))), (__temp803 == NULL ? NULL : g_object_ref (__temp803))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), __temp804);
		if (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)) != NULL && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_variable_declarator_get_initializer (decl))) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))) && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_variable_declarator_get_initializer (decl))) != vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))) {
			/* FIXME: use C cast if debugging disabled*/
			ValaCCodeExpression* __temp805 = NULL;
			rhs = (__temp805 = VALA_CCODE_EXPRESSION (vala_instance_cast_new (rhs, vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), __temp805);
		}
		if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))) {
			ValaCCodeCommaExpression* ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
			ValaVariableDeclarator* temp_decl = vala_code_generator_get_temp_variable_declarator (self, vala_variable_declarator_get_type_reference (decl), TRUE);
			ValaVariableDeclarator* __temp806 = NULL;
			self->priv->temp_vars = g_list_prepend (self->priv->temp_vars, (__temp806 = temp_decl, (__temp806 == NULL ? NULL : g_object_ref (__temp806))));
			ValaCCodeAssignment* __temp807 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp807 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl))), rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(__temp807 == NULL ? NULL : (__temp807 = (g_object_unref (__temp807), NULL)));
			ValaCCodeIdentifier* lhs_array_len = vala_ccode_identifier_new (vala_code_generator_get_array_length_cname (self, vala_variable_declarator_get_name (decl), 1));
			ValaCCodeExpression* rhs_array_len = vala_code_generator_get_array_length_cexpression (self, vala_variable_declarator_get_initializer (decl), 1);
			ValaCCodeAssignment* __temp808 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp808 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (lhs_array_len), rhs_array_len, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(__temp808 == NULL ? NULL : (__temp808 = (g_object_unref (__temp808), NULL)));
			ValaCCodeIdentifier* __temp809 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp809 = vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl)))));
			(__temp809 == NULL ? NULL : (__temp809 = (g_object_unref (__temp809), NULL)));
			ValaCCodeExpression* __temp811 = NULL;
			ValaCCodeCommaExpression* __temp810 = NULL;
			rhs = (__temp811 = VALA_CCODE_EXPRESSION ((__temp810 = ccomma, (__temp810 == NULL ? NULL : g_object_ref (__temp810)))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), __temp811);
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
			(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
			(lhs_array_len == NULL ? NULL : (lhs_array_len = (g_object_unref (lhs_array_len), NULL)));
			(rhs_array_len = (g_object_unref (rhs_array_len), NULL));
		}
	} else {
		if (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))) {
			ValaCCodeExpression* __temp812 = NULL;
			rhs = (__temp812 = VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), __temp812);
		}
	}
	ValaCCodeVariableDeclarator* __temp813 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (decl), VALA_CCODE_NODE ((__temp813 = vala_ccode_variable_declarator_new_with_initializer (vala_variable_declarator_get_name (decl), rhs)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (decl)));
	(__temp813 == NULL ? NULL : (__temp813 = (g_object_unref (__temp813), NULL)));
	(vala_symbol_set_active (vala_code_node_get_symbol (VALA_CODE_NODE (decl)), TRUE), vala_symbol_get_active (vala_code_node_get_symbol (VALA_CODE_NODE (decl))));
	(rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL)));
}


static void vala_code_generator_real_visit_end_initializer_list (ValaCodeVisitor* base, ValaInitializerList* list)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_INITIALIZER_LIST (list));
	if (vala_expression_get_expected_type (VALA_EXPRESSION (list)) != NULL && VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_expression_get_expected_type (VALA_EXPRESSION (list))))) {
	} else {
		/* TODO */
		ValaCCodeInitializerList* clist = g_object_new (VALA_TYPE_CCODE_INITIALIZER_LIST, NULL);
		{
			GList* __temp814 = NULL;
			__temp814 = vala_initializer_list_get_initializers (list);
			GList* expr_it;
			for (expr_it = __temp814; expr_it != NULL; expr_it = expr_it->next) {
				ValaExpression* expr = expr_it->data;
				{
					vala_ccode_initializer_list_append (clist, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))));
				}
			}
			(__temp814 == NULL ? NULL : (__temp814 = (g_list_free (__temp814), NULL)));
		}
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (list), VALA_CCODE_NODE (clist)), vala_code_node_get_ccodenode (VALA_CODE_NODE (list)));
		(clist == NULL ? NULL : (clist = (g_object_unref (clist), NULL)));
	}
}


static ValaVariableDeclarator* vala_code_generator_get_temp_variable_declarator (ValaCodeGenerator* self, ValaTypeReference* type, gboolean takes_ownership)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (type), NULL);
	ValaVariableDeclarator* decl = vala_variable_declarator_new (g_strdup_printf ("__temp%d", self->priv->next_temp_var_id), NULL, NULL);
	ValaTypeReference* __temp815 = NULL;
	(vala_variable_declarator_set_type_reference (decl, (__temp815 = vala_type_reference_copy (type))), vala_variable_declarator_get_type_reference (decl));
	(__temp815 = (g_object_unref (__temp815), NULL));
	(vala_type_reference_set_reference_to_value_type (vala_variable_declarator_get_type_reference (decl), FALSE), vala_type_reference_get_reference_to_value_type (vala_variable_declarator_get_type_reference (decl)));
	(vala_type_reference_set_is_out (vala_variable_declarator_get_type_reference (decl), FALSE), vala_type_reference_get_is_out (vala_variable_declarator_get_type_reference (decl)));
	(vala_type_reference_set_takes_ownership (vala_variable_declarator_get_type_reference (decl), takes_ownership), vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl)));
	self->priv->next_temp_var_id++;
	return decl;
	(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
}


static ValaCCodeExpression* vala_code_generator_get_destroy_func_expression (ValaCodeGenerator* self, ValaTypeReference* type)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (type), NULL);
	if (vala_type_reference_get_data_type (type) != NULL) {
		char* unref_function = NULL;
		if (vala_data_type_is_reference_counting (vala_type_reference_get_data_type (type))) {
			char* __temp817 = NULL;
			unref_function = (__temp817 = vala_data_type_get_unref_function (vala_type_reference_get_data_type (type)), (unref_function = (g_free (unref_function), NULL)), __temp817);
		} else {
			char* __temp818 = NULL;
			unref_function = (__temp818 = vala_data_type_get_free_function (vala_type_reference_get_data_type (type)), (unref_function = (g_free (unref_function), NULL)), __temp818);
		}
		ValaCCodeIdentifier* __temp819 = NULL;
		return VALA_CCODE_EXPRESSION ((__temp819 = vala_ccode_identifier_new (unref_function), (unref_function = (g_free (unref_function), NULL)), __temp819));
		(unref_function = (g_free (unref_function), NULL));
	} else {
		if (vala_type_reference_get_type_parameter (type) != NULL && self->priv->current_class != NULL) {
			char* __temp820 = NULL;
			char* __temp821 = NULL;
			char* func_name = (__temp821 = g_strdup_printf ("%s_destroy_func", (__temp820 = g_utf8_strdown (vala_type_parameter_get_name (vala_type_reference_get_type_parameter (type)), -1))), (__temp820 = (g_free (__temp820), NULL)), __temp821);
			ValaCCodeMemberAccess* __temp822 = NULL;
			return VALA_CCODE_EXPRESSION ((__temp822 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), "priv")), func_name), (func_name = (g_free (func_name), NULL)), __temp822));
			(func_name = (g_free (func_name), NULL));
		} else {
			return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"));
		}
	}
}


static ValaCCodeExpression* vala_code_generator_get_unref_expression (ValaCodeGenerator* self, ValaCCodeExpression* cvar, ValaTypeReference* type)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (cvar), NULL);
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (type), NULL);
	/* (foo == NULL ? NULL : foo = (unref (foo), NULL)) 
	 can be simplified to
	 * foo = (unref (foo), NULL)
	 * if foo is of static type non-null
	 */
	if (vala_type_reference_get_is_null (type)) {
		return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"));
	}
	ValaCCodeBinaryExpression* cisnull = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, cvar, VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")));
	if (vala_type_reference_get_data_type (type) == NULL) {
		if (self->priv->current_class == NULL) {
			ValaCCodeConstant* __temp825 = NULL;
			return VALA_CCODE_EXPRESSION ((__temp825 = vala_ccode_constant_new ("NULL"), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), __temp825));
		}
		/* unref functions are optional for type parameters*/
		ValaCCodeBinaryExpression* cunrefisnull = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, vala_code_generator_get_destroy_func_expression (self, type), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")));
		ValaCCodeBinaryExpression* __temp826 = NULL;
		cisnull = (__temp826 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, VALA_CCODE_EXPRESSION (cisnull), VALA_CCODE_EXPRESSION (cunrefisnull)), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), __temp826);
		(cunrefisnull == NULL ? NULL : (cunrefisnull = (g_object_unref (cunrefisnull), NULL)));
	}
	ValaCCodeFunctionCall* ccall = vala_ccode_function_call_new (vala_code_generator_get_destroy_func_expression (self, type));
	vala_ccode_function_call_add_argument (ccall, cvar);
	/* set freed references to NULL to prevent further use */
	ValaCCodeCommaExpression* ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
	/* TODO cleanup*/
	if (vala_type_reference_get_data_type (type) != NULL && !vala_data_type_is_reference_counting (vala_type_reference_get_data_type (type))) {
		char* unref_function = vala_data_type_get_free_function (vala_type_reference_get_data_type (type));
		if (g_utf8_collate (unref_function, "g_list_free") == 0) {
			gboolean is_ref = FALSE;
			gboolean is_class = FALSE;
			gboolean is_interface = FALSE;
			{
				GList* __temp827 = NULL;
				__temp827 = vala_type_reference_get_type_arguments (type);
				GList* type_arg_it;
				for (type_arg_it = __temp827; type_arg_it != NULL; type_arg_it = type_arg_it->next) {
					ValaTypeReference* type_arg = type_arg_it->data;
					{
						is_ref = is_ref | (vala_type_reference_get_takes_ownership (type_arg));
						is_class = is_class | (VALA_IS_CLASS (vala_type_reference_get_data_type (type_arg)));
						is_interface = is_interface | (VALA_IS_INTERFACE (vala_type_reference_get_data_type (type_arg)));
					}
				}
				(__temp827 == NULL ? NULL : (__temp827 = (g_list_free (__temp827), NULL)));
			}
			if (is_ref) {
				ValaCCodeFunctionCall* cunrefcall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_list_foreach")));
				vala_ccode_function_call_add_argument (cunrefcall, cvar);
				if (is_class || is_interface) {
					ValaCCodeIdentifier* __temp828 = NULL;
					vala_ccode_function_call_add_argument (cunrefcall, VALA_CCODE_EXPRESSION ((__temp828 = vala_ccode_identifier_new ("(GFunc) g_object_unref"))));
					(__temp828 == NULL ? NULL : (__temp828 = (g_object_unref (__temp828), NULL)));
				} else {
					ValaCCodeIdentifier* __temp829 = NULL;
					vala_ccode_function_call_add_argument (cunrefcall, VALA_CCODE_EXPRESSION ((__temp829 = vala_ccode_identifier_new ("(GFunc) g_free"))));
					(__temp829 == NULL ? NULL : (__temp829 = (g_object_unref (__temp829), NULL)));
				}
				ValaCCodeConstant* __temp830 = NULL;
				vala_ccode_function_call_add_argument (cunrefcall, VALA_CCODE_EXPRESSION ((__temp830 = vala_ccode_constant_new ("NULL"))));
				(__temp830 == NULL ? NULL : (__temp830 = (g_object_unref (__temp830), NULL)));
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cunrefcall));
				(cunrefcall == NULL ? NULL : (cunrefcall = (g_object_unref (cunrefcall), NULL)));
			}
		} else {
			if (g_utf8_collate (unref_function, "g_string_free") == 0) {
				ValaCCodeConstant* __temp831 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp831 = vala_ccode_constant_new ("TRUE"))));
				(__temp831 == NULL ? NULL : (__temp831 = (g_object_unref (__temp831), NULL)));
			}
		}
		(unref_function = (g_free (unref_function), NULL));
	}
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
	ValaCCodeConstant* __temp832 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp832 = vala_ccode_constant_new ("NULL"))));
	(__temp832 == NULL ? NULL : (__temp832 = (g_object_unref (__temp832), NULL)));
	ValaCCodeAssignment* cassign = vala_ccode_assignment_new (cvar, VALA_CCODE_EXPRESSION (ccomma), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	/* g_free (NULL) is allowed*/
	char* __temp833 = NULL;
	gboolean __temp834;
	if ((__temp834 = vala_type_reference_get_non_null (type) || (vala_type_reference_get_data_type (type) != NULL && !vala_data_type_is_reference_counting (vala_type_reference_get_data_type (type)) && g_utf8_collate ((__temp833 = vala_data_type_get_free_function (vala_type_reference_get_data_type (type))), "g_free") == 0), (__temp833 = (g_free (__temp833), NULL)), __temp834)) {
		ValaCCodeParenthesizedExpression* __temp835 = NULL;
		return VALA_CCODE_EXPRESSION ((__temp835 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (cassign)), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), (ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL))), (cassign == NULL ? NULL : (cassign = (g_object_unref (cassign), NULL))), __temp835));
	}
	ValaCCodeConditionalExpression* __temp836 = NULL;
	return VALA_CCODE_EXPRESSION ((__temp836 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (cisnull), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")), VALA_CCODE_EXPRESSION (vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (cassign)))), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), (ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL))), (cassign == NULL ? NULL : (cassign = (g_object_unref (cassign), NULL))), __temp836));
	(cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
	(cassign == NULL ? NULL : (cassign = (g_object_unref (cassign), NULL)));
}


static void vala_code_generator_real_visit_end_full_expression (ValaCodeVisitor* base, ValaExpression* expr)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_EXPRESSION (expr));
	if (!vala_code_generator_get_memory_management (self)) {
		GList* __temp837 = NULL;
		self->priv->temp_vars = (__temp837 = NULL, (self->priv->temp_vars == NULL ? NULL : (self->priv->temp_vars = (g_list_foreach (self->priv->temp_vars, (GFunc) g_object_unref, NULL), g_list_free (self->priv->temp_vars), NULL))), __temp837);
		GList* __temp838 = NULL;
		self->priv->temp_ref_vars = (__temp838 = NULL, (self->priv->temp_ref_vars == NULL ? NULL : (self->priv->temp_ref_vars = (g_list_foreach (self->priv->temp_ref_vars, (GFunc) g_object_unref, NULL), g_list_free (self->priv->temp_ref_vars), NULL))), __temp838);
		return;
	}
	/* expr is a full expression, i.e. an initializer, the
	 * expression in an expression statement, the controlling
	 * expression in if, while, for, or foreach statements
	 *
	 * we unref temporary variables at the end of a full
	 * expression
	 
	 can't automatically deep copy lists yet, so do it
	 * manually for now
	 * replace with
	 * expr.temp_vars = temp_vars;
	 * when deep list copying works
	 */
	GList* __temp839 = NULL;
	expr->temp_vars = (__temp839 = NULL, (expr->temp_vars == NULL ? NULL : (expr->temp_vars = (g_list_foreach (expr->temp_vars, (GFunc) g_object_unref, NULL), g_list_free (expr->temp_vars), NULL))), __temp839);
	{
		GList* __temp841 = NULL;
		__temp841 = self->priv->temp_vars;
		GList* decl1_it;
		for (decl1_it = __temp841; decl1_it != NULL; decl1_it = decl1_it->next) {
			ValaVariableDeclarator* decl1 = decl1_it->data;
			{
				ValaVariableDeclarator* __temp840 = NULL;
				expr->temp_vars = g_list_append (expr->temp_vars, (__temp840 = decl1, (__temp840 == NULL ? NULL : g_object_ref (__temp840))));
			}
		}
	}
	GList* __temp842 = NULL;
	self->priv->temp_vars = (__temp842 = NULL, (self->priv->temp_vars == NULL ? NULL : (self->priv->temp_vars = (g_list_foreach (self->priv->temp_vars, (GFunc) g_object_unref, NULL), g_list_free (self->priv->temp_vars), NULL))), __temp842);
	if (self->priv->temp_ref_vars == NULL) {
		return;
	}
	/* nothing to do without temporary variables */
	ValaVariableDeclarator* full_expr_decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (expr), TRUE);
	ValaVariableDeclarator* __temp843 = NULL;
	expr->temp_vars = g_list_append (expr->temp_vars, (__temp843 = full_expr_decl, (__temp843 == NULL ? NULL : g_object_ref (__temp843))));
	ValaCCodeCommaExpression* expr_list = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
	ValaCCodeAssignment* __temp844 = NULL;
	vala_ccode_comma_expression_append_expression (expr_list, VALA_CCODE_EXPRESSION ((__temp844 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (full_expr_decl))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
	(__temp844 == NULL ? NULL : (__temp844 = (g_object_unref (__temp844), NULL)));
	{
		GList* __temp847 = NULL;
		__temp847 = self->priv->temp_ref_vars;
		GList* decl_it;
		for (decl_it = __temp847; decl_it != NULL; decl_it = decl_it->next) {
			ValaVariableDeclarator* decl = decl_it->data;
			{
				ValaCCodeExpression* __temp846 = NULL;
				ValaCCodeIdentifier* __temp845 = NULL;
				vala_ccode_comma_expression_append_expression (expr_list, (__temp846 = vala_code_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((__temp845 = vala_ccode_identifier_new (vala_variable_declarator_get_name (decl)))), vala_variable_declarator_get_type_reference (decl))));
				(__temp846 == NULL ? NULL : (__temp846 = (g_object_unref (__temp846), NULL)));
				(__temp845 == NULL ? NULL : (__temp845 = (g_object_unref (__temp845), NULL)));
			}
		}
	}
	ValaCCodeIdentifier* __temp848 = NULL;
	vala_ccode_comma_expression_append_expression (expr_list, VALA_CCODE_EXPRESSION ((__temp848 = vala_ccode_identifier_new (vala_variable_declarator_get_name (full_expr_decl)))));
	(__temp848 == NULL ? NULL : (__temp848 = (g_object_unref (__temp848), NULL)));
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (expr_list)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	GList* __temp849 = NULL;
	self->priv->temp_ref_vars = (__temp849 = NULL, (self->priv->temp_ref_vars == NULL ? NULL : (self->priv->temp_ref_vars = (g_list_foreach (self->priv->temp_ref_vars, (GFunc) g_object_unref, NULL), g_list_free (self->priv->temp_ref_vars), NULL))), __temp849);
	(full_expr_decl == NULL ? NULL : (full_expr_decl = (g_object_unref (full_expr_decl), NULL)));
	(expr_list == NULL ? NULL : (expr_list = (g_object_unref (expr_list), NULL)));
}


static void vala_code_generator_append_temp_decl (ValaCodeGenerator* self, ValaCCodeFragment* cfrag, GList* temp_vars)
{
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CCODE_FRAGMENT (cfrag));
	{
		GList* __temp851 = NULL;
		__temp851 = temp_vars;
		GList* decl_it;
		for (decl_it = __temp851; decl_it != NULL; decl_it = decl_it->next) {
			ValaVariableDeclarator* decl = decl_it->data;
			{
				ValaCCodeDeclaration* cdecl = vala_ccode_declaration_new (vala_type_reference_get_cname (vala_variable_declarator_get_type_reference (decl), TRUE, !vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))));
				ValaCCodeVariableDeclarator* vardecl = vala_ccode_variable_declarator_new (vala_variable_declarator_get_name (decl));
				vala_ccode_declaration_add_declarator (cdecl, VALA_CCODE_DECLARATOR (vardecl));
				if (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))) {
					ValaCCodeConstant* __temp850 = NULL;
					(vala_ccode_variable_declarator_set_initializer (vardecl, VALA_CCODE_EXPRESSION ((__temp850 = vala_ccode_constant_new ("NULL")))), vala_ccode_variable_declarator_get_initializer (vardecl));
					(__temp850 == NULL ? NULL : (__temp850 = (g_object_unref (__temp850), NULL)));
				}
				vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE (cdecl));
				(cdecl == NULL ? NULL : (cdecl = (g_object_unref (cdecl), NULL)));
				(vardecl == NULL ? NULL : (vardecl = (g_object_unref (vardecl), NULL)));
			}
		}
	}
}


static void vala_code_generator_real_visit_expression_statement (ValaCodeVisitor* base, ValaExpressionStatement* stmt)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_EXPRESSION_STATEMENT (stmt));
	ValaCCodeExpressionStatement* __temp852 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp852 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_expression_statement_get_expression (stmt)))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	(__temp852 == NULL ? NULL : (__temp852 = (g_object_unref (__temp852), NULL)));
	/* free temporary objects */
	if (!vala_code_generator_get_memory_management (self)) {
		GList* __temp853 = NULL;
		self->priv->temp_vars = (__temp853 = NULL, (self->priv->temp_vars == NULL ? NULL : (self->priv->temp_vars = (g_list_foreach (self->priv->temp_vars, (GFunc) g_object_unref, NULL), g_list_free (self->priv->temp_vars), NULL))), __temp853);
		GList* __temp854 = NULL;
		self->priv->temp_ref_vars = (__temp854 = NULL, (self->priv->temp_ref_vars == NULL ? NULL : (self->priv->temp_ref_vars = (g_list_foreach (self->priv->temp_ref_vars, (GFunc) g_object_unref, NULL), g_list_free (self->priv->temp_ref_vars), NULL))), __temp854);
		return;
	}
	if (self->priv->temp_vars == NULL) {
		return;
	}
	/* nothing to do without temporary variables */
	ValaCCodeFragment* cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	vala_code_generator_append_temp_decl (self, cfrag, self->priv->temp_vars);
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	{
		GList* __temp857 = NULL;
		__temp857 = self->priv->temp_ref_vars;
		GList* decl_it;
		for (decl_it = __temp857; decl_it != NULL; decl_it = decl_it->next) {
			ValaVariableDeclarator* decl = decl_it->data;
			{
				ValaCCodeExpressionStatement* __temp856 = NULL;
				ValaCCodeIdentifier* __temp855 = NULL;
				vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((__temp856 = vala_ccode_expression_statement_new (vala_code_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((__temp855 = vala_ccode_identifier_new (vala_variable_declarator_get_name (decl)))), vala_variable_declarator_get_type_reference (decl))))));
				(__temp856 == NULL ? NULL : (__temp856 = (g_object_unref (__temp856), NULL)));
				(__temp855 == NULL ? NULL : (__temp855 = (g_object_unref (__temp855), NULL)));
			}
		}
	}
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfrag)), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	GList* __temp858 = NULL;
	self->priv->temp_vars = (__temp858 = NULL, (self->priv->temp_vars == NULL ? NULL : (self->priv->temp_vars = (g_list_foreach (self->priv->temp_vars, (GFunc) g_object_unref, NULL), g_list_free (self->priv->temp_vars), NULL))), __temp858);
	GList* __temp859 = NULL;
	self->priv->temp_ref_vars = (__temp859 = NULL, (self->priv->temp_ref_vars == NULL ? NULL : (self->priv->temp_ref_vars = (g_list_foreach (self->priv->temp_ref_vars, (GFunc) g_object_unref, NULL), g_list_free (self->priv->temp_ref_vars), NULL))), __temp859);
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static void vala_code_generator_create_temp_decl (ValaCodeGenerator* self, ValaStatement* stmt, GList* temp_vars)
{
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_STATEMENT (stmt));
	/* declare temporary variables */
	if (temp_vars == NULL) {
		return;
	}
	/* nothing to do without temporary variables */
	ValaCCodeFragment* cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	vala_code_generator_append_temp_decl (self, cfrag, temp_vars);
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfrag)), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static void vala_code_generator_real_visit_if_statement (ValaCodeVisitor* base, ValaIfStatement* stmt)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_IF_STATEMENT (stmt));
	if (vala_if_statement_get_false_statement (stmt) != NULL) {
		ValaCCodeIfStatement* __temp860 = NULL;
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp860 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_if_statement_get_condition (stmt)))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_if_statement_get_true_statement (stmt)))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_if_statement_get_false_statement (stmt)))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
		(__temp860 == NULL ? NULL : (__temp860 = (g_object_unref (__temp860), NULL)));
	} else {
		ValaCCodeIfStatement* __temp861 = NULL;
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp861 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_if_statement_get_condition (stmt)))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_if_statement_get_true_statement (stmt)))), NULL)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
		(__temp861 == NULL ? NULL : (__temp861 = (g_object_unref (__temp861), NULL)));
	}
	vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), vala_if_statement_get_condition (stmt)->temp_vars);
}


static void vala_code_generator_real_visit_switch_statement (ValaCodeVisitor* base, ValaSwitchStatement* stmt)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_SWITCH_STATEMENT (stmt));
	/* we need a temporary variable to save the property value*/
	ValaVariableDeclarator* temp_decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (vala_switch_statement_get_expression (stmt)), TRUE);
	ValaVariableDeclarator* __temp862 = NULL;
	vala_switch_statement_get_expression (stmt)->temp_vars = g_list_prepend (vala_switch_statement_get_expression (stmt)->temp_vars, (__temp862 = temp_decl, (__temp862 == NULL ? NULL : g_object_ref (__temp862))));
	ValaCCodeIdentifier* ctemp = vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl));
	ValaCCodeAssignment* cinit = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (ctemp), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_switch_statement_get_expression (stmt)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	ValaCCodeFragment* cswitchblock = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	ValaCCodeExpressionStatement* __temp863 = NULL;
	vala_ccode_fragment_append (cswitchblock, VALA_CCODE_NODE ((__temp863 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinit)))));
	(__temp863 == NULL ? NULL : (__temp863 = (g_object_unref (__temp863), NULL)));
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cswitchblock)), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), vala_switch_statement_get_expression (stmt)->temp_vars);
	GList* default_statements = NULL;
	/* generate nested if statements*/
	ValaCCodeStatement* ctopstmt = NULL;
	ValaCCodeIfStatement* coldif = NULL;
	{
		GList* __temp875 = NULL;
		__temp875 = vala_switch_statement_get_sections (stmt);
		GList* section_it;
		for (section_it = __temp875; section_it != NULL; section_it = section_it->next) {
			ValaSwitchSection* section = section_it->data;
			{
				if (vala_switch_section_has_default_label (section)) {
					GList* __temp864 = NULL;
					default_statements = (__temp864 = vala_switch_section_get_statements (section), (default_statements == NULL ? NULL : (default_statements = (g_list_free (default_statements), NULL))), __temp864);
				} else {
					ValaCCodeBinaryExpression* cor = NULL;
					{
						GList* __temp868 = NULL;
						__temp868 = vala_switch_section_get_labels (section);
						GList* label_it;
						for (label_it = __temp868; label_it != NULL; label_it = label_it->next) {
							ValaSwitchLabel* label = label_it->data;
							{
								ValaCCodeBinaryExpression* ccmp = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION (ctemp), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_switch_label_get_expression (label)))));
								if (cor == NULL) {
									ValaCCodeBinaryExpression* __temp866 = NULL;
									ValaCCodeBinaryExpression* __temp865 = NULL;
									cor = (__temp866 = (__temp865 = ccmp, (__temp865 == NULL ? NULL : g_object_ref (__temp865))), (cor == NULL ? NULL : (cor = (g_object_unref (cor), NULL))), __temp866);
								} else {
									ValaCCodeBinaryExpression* __temp867 = NULL;
									cor = (__temp867 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, VALA_CCODE_EXPRESSION (cor), VALA_CCODE_EXPRESSION (ccmp)), (cor == NULL ? NULL : (cor = (g_object_unref (cor), NULL))), __temp867);
								}
								(ccmp == NULL ? NULL : (ccmp = (g_object_unref (ccmp), NULL)));
							}
						}
						(__temp868 == NULL ? NULL : (__temp868 = (g_list_free (__temp868), NULL)));
					}
					ValaCCodeBlock* cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
					{
						GList* __temp870 = NULL;
						__temp870 = vala_switch_section_get_statements (section);
						GList* body_stmt_it;
						for (body_stmt_it = __temp870; body_stmt_it != NULL; body_stmt_it = body_stmt_it->next) {
							ValaStatement* body_stmt = body_stmt_it->data;
							{
								if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (body_stmt)))) {
									{
										GList* __temp869 = NULL;
										__temp869 = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (body_stmt)))));
										GList* cstmt_it;
										for (cstmt_it = __temp869; cstmt_it != NULL; cstmt_it = cstmt_it->next) {
											ValaCCodeStatement* cstmt = cstmt_it->data;
											{
												vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cstmt));
											}
										}
										(__temp869 == NULL ? NULL : (__temp869 = (g_list_free (__temp869), NULL)));
									}
								} else {
									vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (body_stmt)))));
								}
							}
						}
						(__temp870 == NULL ? NULL : (__temp870 = (g_list_free (__temp870), NULL)));
					}
					ValaCCodeDoStatement* cdo = vala_ccode_do_statement_new (VALA_CCODE_STATEMENT (cblock), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("0")));
					ValaCCodeIfStatement* cif = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (cor), VALA_CCODE_STATEMENT (cdo), NULL);
					if (coldif != NULL) {
						(vala_ccode_if_statement_set_false_statement (coldif, VALA_CCODE_STATEMENT (cif)), vala_ccode_if_statement_get_false_statement (coldif));
					} else {
						ValaCCodeStatement* __temp872 = NULL;
						ValaCCodeIfStatement* __temp871 = NULL;
						ctopstmt = (__temp872 = VALA_CCODE_STATEMENT ((__temp871 = cif, (__temp871 == NULL ? NULL : g_object_ref (__temp871)))), (ctopstmt == NULL ? NULL : (ctopstmt = (g_object_unref (ctopstmt), NULL))), __temp872);
					}
					ValaCCodeIfStatement* __temp874 = NULL;
					ValaCCodeIfStatement* __temp873 = NULL;
					coldif = (__temp874 = (__temp873 = cif, (__temp873 == NULL ? NULL : g_object_ref (__temp873))), (coldif == NULL ? NULL : (coldif = (g_object_unref (coldif), NULL))), __temp874);
					(cor == NULL ? NULL : (cor = (g_object_unref (cor), NULL)));
					(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
					(cdo == NULL ? NULL : (cdo = (g_object_unref (cdo), NULL)));
					(cif == NULL ? NULL : (cif = (g_object_unref (cif), NULL)));
				}
			}
		}
		(__temp875 == NULL ? NULL : (__temp875 = (g_list_free (__temp875), NULL)));
	}
	if (default_statements != NULL) {
		ValaCCodeBlock* cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
		{
			GList* __temp876 = NULL;
			__temp876 = default_statements;
			GList* body_stmt_it;
			for (body_stmt_it = __temp876; body_stmt_it != NULL; body_stmt_it = body_stmt_it->next) {
				ValaStatement* body_stmt = body_stmt_it->data;
				{
					vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (body_stmt)))));
				}
			}
		}
		ValaCCodeDoStatement* cdo = vala_ccode_do_statement_new (VALA_CCODE_STATEMENT (cblock), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("0")));
		if (coldif == NULL) {
			/* there is only one section and that section
			 contains a default label*/
			ValaCCodeStatement* __temp878 = NULL;
			ValaCCodeDoStatement* __temp877 = NULL;
			ctopstmt = (__temp878 = VALA_CCODE_STATEMENT ((__temp877 = cdo, (__temp877 == NULL ? NULL : g_object_ref (__temp877)))), (ctopstmt == NULL ? NULL : (ctopstmt = (g_object_unref (ctopstmt), NULL))), __temp878);
		} else {
			(vala_ccode_if_statement_set_false_statement (coldif, VALA_CCODE_STATEMENT (cdo)), vala_ccode_if_statement_get_false_statement (coldif));
		}
		(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
		(cdo == NULL ? NULL : (cdo = (g_object_unref (cdo), NULL)));
	}
	vala_ccode_fragment_append (cswitchblock, VALA_CCODE_NODE (ctopstmt));
	(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
	(ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL)));
	(cinit == NULL ? NULL : (cinit = (g_object_unref (cinit), NULL)));
	(cswitchblock == NULL ? NULL : (cswitchblock = (g_object_unref (cswitchblock), NULL)));
	(default_statements == NULL ? NULL : (default_statements = (g_list_free (default_statements), NULL)));
	(ctopstmt == NULL ? NULL : (ctopstmt = (g_object_unref (ctopstmt), NULL)));
	(coldif == NULL ? NULL : (coldif = (g_object_unref (coldif), NULL)));
}


static void vala_code_generator_real_visit_while_statement (ValaCodeVisitor* base, ValaWhileStatement* stmt)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_WHILE_STATEMENT (stmt));
	ValaCCodeWhileStatement* __temp879 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp879 = vala_ccode_while_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_while_statement_get_condition (stmt)))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_while_statement_get_body (stmt)))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	(__temp879 == NULL ? NULL : (__temp879 = (g_object_unref (__temp879), NULL)));
	vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), vala_while_statement_get_condition (stmt)->temp_vars);
}


static void vala_code_generator_real_visit_do_statement (ValaCodeVisitor* base, ValaDoStatement* stmt)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_DO_STATEMENT (stmt));
	ValaCCodeDoStatement* __temp880 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp880 = vala_ccode_do_statement_new (VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_do_statement_get_body (stmt)))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_do_statement_get_condition (stmt)))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	(__temp880 == NULL ? NULL : (__temp880 = (g_object_unref (__temp880), NULL)));
	vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), vala_do_statement_get_condition (stmt)->temp_vars);
}


static void vala_code_generator_real_visit_for_statement (ValaCodeVisitor* base, ValaForStatement* stmt)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_FOR_STATEMENT (stmt));
	ValaCCodeForStatement* cfor = vala_ccode_for_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_for_statement_get_condition (stmt)))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_for_statement_get_body (stmt)))));
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfor)), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	{
		GList* __temp881 = NULL;
		__temp881 = vala_for_statement_get_initializer (stmt);
		GList* init_expr_it;
		for (init_expr_it = __temp881; init_expr_it != NULL; init_expr_it = init_expr_it->next) {
			ValaExpression* init_expr = init_expr_it->data;
			{
				vala_ccode_for_statement_add_initializer (cfor, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (init_expr))));
				vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), init_expr->temp_vars);
			}
		}
		(__temp881 == NULL ? NULL : (__temp881 = (g_list_free (__temp881), NULL)));
	}
	{
		GList* __temp882 = NULL;
		__temp882 = vala_for_statement_get_iterator (stmt);
		GList* it_expr_it;
		for (it_expr_it = __temp882; it_expr_it != NULL; it_expr_it = it_expr_it->next) {
			ValaExpression* it_expr = it_expr_it->data;
			{
				vala_ccode_for_statement_add_iterator (cfor, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (it_expr))));
				vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), it_expr->temp_vars);
			}
		}
		(__temp882 == NULL ? NULL : (__temp882 = (g_list_free (__temp882), NULL)));
	}
	vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), vala_for_statement_get_condition (stmt)->temp_vars);
	(cfor == NULL ? NULL : (cfor = (g_object_unref (cfor), NULL)));
}


static void vala_code_generator_real_visit_end_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_FOREACH_STATEMENT (stmt));
	ValaCCodeBlock* cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	ValaCCodeForStatement* cfor = NULL;
	ValaVariableDeclarator* collection_backup = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt)), TRUE);
	ValaVariableDeclarator* __temp883 = NULL;
	vala_foreach_statement_get_collection (stmt)->temp_vars = g_list_prepend (vala_foreach_statement_get_collection (stmt)->temp_vars, (__temp883 = collection_backup, (__temp883 == NULL ? NULL : g_object_ref (__temp883))));
	ValaCCodeFragment* cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	vala_code_generator_append_temp_decl (self, cfrag, vala_foreach_statement_get_collection (stmt)->temp_vars);
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cfrag));
	ValaCCodeExpressionStatement* __temp884 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp884 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (collection_backup))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_foreach_statement_get_collection (stmt)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp884 == NULL ? NULL : (__temp884 = (g_object_unref (__temp884), NULL)));
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cblock)), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt))))) {
		ValaArray* __temp885 = NULL;
		ValaArray* arr = (__temp885 = VALA_ARRAY (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt)))), (__temp885 == NULL ? NULL : g_object_ref (__temp885)));
		ValaCCodeExpression* array_len = vala_code_generator_get_array_length_cexpression (self, vala_foreach_statement_get_collection (stmt), 1);
		/* the array has no length parameter i.e. is NULL-terminated array */
		if (VALA_IS_CCODE_CONSTANT (array_len)) {
			char* it_name = g_strdup_printf ("%s_it", vala_foreach_statement_get_variable_name (stmt));
			ValaCCodeDeclaration* citdecl = vala_ccode_declaration_new (vala_type_reference_get_cname (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt)), FALSE, FALSE));
			ValaCCodeVariableDeclarator* __temp886 = NULL;
			vala_ccode_declaration_add_declarator (citdecl, VALA_CCODE_DECLARATOR ((__temp886 = vala_ccode_variable_declarator_new (it_name))));
			(__temp886 == NULL ? NULL : (__temp886 = (g_object_unref (__temp886), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (citdecl));
			ValaCCodeBlock* cbody = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
			ValaCCodeDeclaration* cdecl = vala_ccode_declaration_new (vala_type_reference_get_cname (vala_foreach_statement_get_type_reference (stmt), FALSE, FALSE));
			ValaCCodeVariableDeclarator* __temp887 = NULL;
			vala_ccode_declaration_add_declarator (cdecl, VALA_CCODE_DECLARATOR ((__temp887 = vala_ccode_variable_declarator_new_with_initializer (vala_foreach_statement_get_variable_name (stmt), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("*%s", it_name)))))));
			(__temp887 == NULL ? NULL : (__temp887 = (g_object_unref (__temp887), NULL)));
			vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cdecl));
			vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_foreach_statement_get_body (stmt))));
			ValaCCodeBinaryExpression* ccond = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("*%s", it_name))), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")));
			ValaCCodeForStatement* cfor = vala_ccode_for_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cbody));
			ValaCCodeAssignment* __temp888 = NULL;
			vala_ccode_for_statement_add_initializer (cfor, VALA_CCODE_EXPRESSION ((__temp888 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (collection_backup))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(__temp888 == NULL ? NULL : (__temp888 = (g_object_unref (__temp888), NULL)));
			ValaCCodeAssignment* __temp889 = NULL;
			vala_ccode_for_statement_add_iterator (cfor, VALA_CCODE_EXPRESSION ((__temp889 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)), VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("1")))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(__temp889 == NULL ? NULL : (__temp889 = (g_object_unref (__temp889), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cfor));
			(it_name = (g_free (it_name), NULL));
			(citdecl == NULL ? NULL : (citdecl = (g_object_unref (citdecl), NULL)));
			(cbody == NULL ? NULL : (cbody = (g_object_unref (cbody), NULL)));
			(cdecl == NULL ? NULL : (cdecl = (g_object_unref (cdecl), NULL)));
			(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
			(cfor == NULL ? NULL : (cfor = (g_object_unref (cfor), NULL)));
		} else {
			/* the array has a length parameter */
			char* it_name = (g_strconcat (vala_foreach_statement_get_variable_name (stmt), "_it", NULL));
			ValaCCodeDeclaration* citdecl = vala_ccode_declaration_new ("int");
			ValaCCodeVariableDeclarator* __temp890 = NULL;
			vala_ccode_declaration_add_declarator (citdecl, VALA_CCODE_DECLARATOR ((__temp890 = vala_ccode_variable_declarator_new (it_name))));
			(__temp890 == NULL ? NULL : (__temp890 = (g_object_unref (__temp890), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (citdecl));
			ValaCCodeBlock* cbody = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
			ValaCCodeDeclaration* cdecl = vala_ccode_declaration_new (vala_type_reference_get_cname (vala_foreach_statement_get_type_reference (stmt), FALSE, FALSE));
			ValaCCodeVariableDeclarator* __temp891 = NULL;
			vala_ccode_declaration_add_declarator (cdecl, VALA_CCODE_DECLARATOR ((__temp891 = vala_ccode_variable_declarator_new_with_initializer (vala_foreach_statement_get_variable_name (stmt), VALA_CCODE_EXPRESSION (vala_ccode_element_access_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (collection_backup))), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name))))))));
			(__temp891 == NULL ? NULL : (__temp891 = (g_object_unref (__temp891), NULL)));
			vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cdecl));
			vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_foreach_statement_get_body (stmt))));
			ValaCCodeBinaryExpression* ccond_ind1 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, array_len, VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("-1")));
			ValaCCodeBinaryExpression* ccond_ind2 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)), array_len);
			ValaCCodeBinaryExpression* ccond_ind = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_AND, VALA_CCODE_EXPRESSION (ccond_ind1), VALA_CCODE_EXPRESSION (ccond_ind2));
			/* only check for null if the containers elements are of reference-type */
			ValaCCodeBinaryExpression* ccond = NULL;
			if (vala_data_type_is_reference_type (vala_array_get_element_type (arr))) {
				ValaCCodeBinaryExpression* ccond_term1 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, array_len, VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("-1")));
				ValaCCodeBinaryExpression* ccond_term2 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION (vala_ccode_element_access_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (collection_backup))), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)))), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")));
				ValaCCodeBinaryExpression* ccond_term = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_AND, VALA_CCODE_EXPRESSION (ccond_term1), VALA_CCODE_EXPRESSION (ccond_term2));
				ValaCCodeBinaryExpression* __temp892 = NULL;
				ccond = (__temp892 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, VALA_CCODE_EXPRESSION (vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (ccond_ind))), VALA_CCODE_EXPRESSION (vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (ccond_term)))), (ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL))), __temp892);
				(ccond_term1 == NULL ? NULL : (ccond_term1 = (g_object_unref (ccond_term1), NULL)));
				(ccond_term2 == NULL ? NULL : (ccond_term2 = (g_object_unref (ccond_term2), NULL)));
				(ccond_term == NULL ? NULL : (ccond_term = (g_object_unref (ccond_term), NULL)));
			} else {
				ValaCCodeBinaryExpression* __temp894 = NULL;
				ValaCCodeBinaryExpression* __temp893 = NULL;
				ccond = (__temp894 = (__temp893 = ccond_ind, (__temp893 == NULL ? NULL : g_object_ref (__temp893))), (ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL))), __temp894);
			}
			ValaCCodeForStatement* cfor = vala_ccode_for_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cbody));
			ValaCCodeAssignment* __temp895 = NULL;
			vala_ccode_for_statement_add_initializer (cfor, VALA_CCODE_EXPRESSION ((__temp895 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("0")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(__temp895 == NULL ? NULL : (__temp895 = (g_object_unref (__temp895), NULL)));
			ValaCCodeAssignment* __temp896 = NULL;
			vala_ccode_for_statement_add_iterator (cfor, VALA_CCODE_EXPRESSION ((__temp896 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)), VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("1")))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(__temp896 == NULL ? NULL : (__temp896 = (g_object_unref (__temp896), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cfor));
			(it_name = (g_free (it_name), NULL));
			(citdecl == NULL ? NULL : (citdecl = (g_object_unref (citdecl), NULL)));
			(cbody == NULL ? NULL : (cbody = (g_object_unref (cbody), NULL)));
			(cdecl == NULL ? NULL : (cdecl = (g_object_unref (cdecl), NULL)));
			(ccond_ind1 == NULL ? NULL : (ccond_ind1 = (g_object_unref (ccond_ind1), NULL)));
			(ccond_ind2 == NULL ? NULL : (ccond_ind2 = (g_object_unref (ccond_ind2), NULL)));
			(ccond_ind == NULL ? NULL : (ccond_ind = (g_object_unref (ccond_ind), NULL)));
			(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
			(cfor == NULL ? NULL : (cfor = (g_object_unref (cfor), NULL)));
		}
		(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
		(array_len = (g_object_unref (array_len), NULL));
	} else {
		if (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt))) == self->priv->list_type || vala_type_reference_get_data_type (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt))) == self->priv->slist_type) {
			char* it_name = g_strdup_printf ("%s_it", vala_foreach_statement_get_variable_name (stmt));
			ValaCCodeDeclaration* citdecl = vala_ccode_declaration_new (vala_type_reference_get_cname (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt)), FALSE, FALSE));
			ValaCCodeVariableDeclarator* __temp897 = NULL;
			vala_ccode_declaration_add_declarator (citdecl, VALA_CCODE_DECLARATOR ((__temp897 = vala_ccode_variable_declarator_new (it_name))));
			(__temp897 == NULL ? NULL : (__temp897 = (g_object_unref (__temp897), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (citdecl));
			ValaCCodeBlock* cbody = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
			ValaCCodeExpression* element_expr = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)), "data"));
			/* cast pointer to actual type if appropriate */
			if (VALA_IS_STRUCT (vala_type_reference_get_data_type (vala_foreach_statement_get_type_reference (stmt)))) {
				ValaStruct* __temp898 = NULL;
				ValaStruct* st = (__temp898 = VALA_STRUCT (vala_type_reference_get_data_type (vala_foreach_statement_get_type_reference (stmt))), (__temp898 == NULL ? NULL : g_object_ref (__temp898)));
				if (VALA_DATA_TYPE (st) == vala_type_reference_get_data_type (self->priv->uint_type)) {
					ValaCCodeFunctionCall* cconv = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("GPOINTER_TO_UINT")));
					vala_ccode_function_call_add_argument (cconv, element_expr);
					ValaCCodeExpression* __temp900 = NULL;
					ValaCCodeFunctionCall* __temp899 = NULL;
					element_expr = (__temp900 = VALA_CCODE_EXPRESSION ((__temp899 = cconv, (__temp899 == NULL ? NULL : g_object_ref (__temp899)))), (element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL))), __temp900);
					(cconv == NULL ? NULL : (cconv = (g_object_unref (cconv), NULL)));
				} else {
					if (VALA_DATA_TYPE (st) == vala_type_reference_get_data_type (self->priv->bool_type) || vala_struct_is_integer_type (st)) {
						ValaCCodeFunctionCall* cconv = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("GPOINTER_TO_INT")));
						vala_ccode_function_call_add_argument (cconv, element_expr);
						ValaCCodeExpression* __temp902 = NULL;
						ValaCCodeFunctionCall* __temp901 = NULL;
						element_expr = (__temp902 = VALA_CCODE_EXPRESSION ((__temp901 = cconv, (__temp901 == NULL ? NULL : g_object_ref (__temp901)))), (element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL))), __temp902);
						(cconv == NULL ? NULL : (cconv = (g_object_unref (cconv), NULL)));
					}
				}
				(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
			}
			ValaCCodeDeclaration* cdecl = vala_ccode_declaration_new (vala_type_reference_get_cname (vala_foreach_statement_get_type_reference (stmt), FALSE, FALSE));
			ValaCCodeVariableDeclarator* __temp903 = NULL;
			vala_ccode_declaration_add_declarator (cdecl, VALA_CCODE_DECLARATOR ((__temp903 = vala_ccode_variable_declarator_new_with_initializer (vala_foreach_statement_get_variable_name (stmt), element_expr))));
			(__temp903 == NULL ? NULL : (__temp903 = (g_object_unref (__temp903), NULL)));
			vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cdecl));
			vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_foreach_statement_get_body (stmt))));
			ValaCCodeBinaryExpression* ccond = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")));
			ValaCCodeForStatement* cfor = vala_ccode_for_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cbody));
			ValaCCodeAssignment* __temp904 = NULL;
			vala_ccode_for_statement_add_initializer (cfor, VALA_CCODE_EXPRESSION ((__temp904 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (collection_backup))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(__temp904 == NULL ? NULL : (__temp904 = (g_object_unref (__temp904), NULL)));
			ValaCCodeAssignment* __temp905 = NULL;
			vala_ccode_for_statement_add_iterator (cfor, VALA_CCODE_EXPRESSION ((__temp905 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)), VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)), "next")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(__temp905 == NULL ? NULL : (__temp905 = (g_object_unref (__temp905), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cfor));
			(it_name = (g_free (it_name), NULL));
			(citdecl == NULL ? NULL : (citdecl = (g_object_unref (citdecl), NULL)));
			(cbody == NULL ? NULL : (cbody = (g_object_unref (cbody), NULL)));
			(element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL)));
			(cdecl == NULL ? NULL : (cdecl = (g_object_unref (cdecl), NULL)));
			(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
			(cfor == NULL ? NULL : (cfor = (g_object_unref (cfor), NULL)));
		}
	}
	if (vala_code_generator_get_memory_management (self) && vala_type_reference_get_transfers_ownership (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt)))) {
		ValaCCodeExpressionStatement* __temp907 = NULL;
		ValaCCodeIdentifier* __temp906 = NULL;
		vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp907 = vala_ccode_expression_statement_new (vala_code_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((__temp906 = vala_ccode_identifier_new (vala_variable_declarator_get_name (collection_backup)))), vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt)))))));
		(__temp907 == NULL ? NULL : (__temp907 = (g_object_unref (__temp907), NULL)));
		(__temp906 == NULL ? NULL : (__temp906 = (g_object_unref (__temp906), NULL)));
	}
	(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
	(cfor == NULL ? NULL : (cfor = (g_object_unref (cfor), NULL)));
	(collection_backup == NULL ? NULL : (collection_backup = (g_object_unref (collection_backup), NULL)));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static void vala_code_generator_real_visit_break_statement (ValaCodeVisitor* base, ValaBreakStatement* stmt)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_BREAK_STATEMENT (stmt));
	ValaCCodeBreakStatement* __temp908 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp908 = g_object_new (VALA_TYPE_CCODE_BREAK_STATEMENT, NULL)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	(__temp908 == NULL ? NULL : (__temp908 = (g_object_unref (__temp908), NULL)));
}


static void vala_code_generator_real_visit_continue_statement (ValaCodeVisitor* base, ValaContinueStatement* stmt)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CONTINUE_STATEMENT (stmt));
	ValaCCodeContinueStatement* __temp909 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp909 = g_object_new (VALA_TYPE_CCODE_CONTINUE_STATEMENT, NULL)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	(__temp909 == NULL ? NULL : (__temp909 = (g_object_unref (__temp909), NULL)));
}


static void vala_code_generator_append_local_free (ValaCodeGenerator* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, gboolean stop_at_loop)
{
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (sym == NULL || VALA_IS_SYMBOL (sym));
	g_return_if_fail (cfrag == NULL || VALA_IS_CCODE_FRAGMENT (cfrag));
	ValaBlock* __temp910 = NULL;
	ValaBlock* b = (__temp910 = VALA_BLOCK (vala_symbol_get_node (sym)), (__temp910 == NULL ? NULL : g_object_ref (__temp910)));
	GList* local_vars = vala_block_get_local_variables (b);
	{
		GList* __temp913 = NULL;
		__temp913 = local_vars;
		GList* decl_it;
		for (decl_it = __temp913; decl_it != NULL; decl_it = decl_it->next) {
			ValaVariableDeclarator* decl = decl_it->data;
			{
				if (vala_symbol_get_active (vala_code_node_get_symbol (VALA_CODE_NODE (decl))) && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))) && vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))) {
					ValaCCodeExpressionStatement* __temp912 = NULL;
					ValaCCodeIdentifier* __temp911 = NULL;
					vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((__temp912 = vala_ccode_expression_statement_new (vala_code_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((__temp911 = vala_ccode_identifier_new (vala_variable_declarator_get_name (decl)))), vala_variable_declarator_get_type_reference (decl))))));
					(__temp912 == NULL ? NULL : (__temp912 = (g_object_unref (__temp912), NULL)));
					(__temp911 == NULL ? NULL : (__temp911 = (g_object_unref (__temp911), NULL)));
				}
			}
		}
	}
	if (VALA_IS_BLOCK (vala_symbol_get_node (vala_symbol_get_parent_symbol (sym)))) {
		vala_code_generator_append_local_free (self, vala_symbol_get_parent_symbol (sym), cfrag, stop_at_loop);
	}
	(b == NULL ? NULL : (b = (g_object_unref (b), NULL)));
	(local_vars == NULL ? NULL : (local_vars = (g_list_free (local_vars), NULL)));
}


static void vala_code_generator_create_local_free (ValaCodeGenerator* self, ValaStatement* stmt)
{
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (stmt == NULL || VALA_IS_STATEMENT (stmt));
	if (!vala_code_generator_get_memory_management (self)) {
		return;
	}
	ValaCCodeFragment* cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	vala_code_generator_append_local_free (self, self->priv->current_symbol, cfrag, FALSE);
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfrag)), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static gboolean vala_code_generator_append_local_free_expr (ValaCodeGenerator* self, ValaSymbol* sym, ValaCCodeCommaExpression* ccomma, gboolean stop_at_loop)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), FALSE);
	g_return_val_if_fail (sym == NULL || VALA_IS_SYMBOL (sym), FALSE);
	g_return_val_if_fail (ccomma == NULL || VALA_IS_CCODE_COMMA_EXPRESSION (ccomma), FALSE);
	gboolean found = FALSE;
	ValaBlock* __temp914 = NULL;
	ValaBlock* b = (__temp914 = VALA_BLOCK (vala_symbol_get_node (sym)), (__temp914 == NULL ? NULL : g_object_ref (__temp914)));
	GList* local_vars = vala_block_get_local_variables (b);
	{
		GList* __temp917 = NULL;
		__temp917 = local_vars;
		GList* decl_it;
		for (decl_it = __temp917; decl_it != NULL; decl_it = decl_it->next) {
			ValaVariableDeclarator* decl = decl_it->data;
			{
				if (vala_symbol_get_active (vala_code_node_get_symbol (VALA_CODE_NODE (decl))) && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))) && vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))) {
					found = TRUE;
					ValaCCodeExpression* __temp916 = NULL;
					ValaCCodeIdentifier* __temp915 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (__temp916 = vala_code_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((__temp915 = vala_ccode_identifier_new (vala_variable_declarator_get_name (decl)))), vala_variable_declarator_get_type_reference (decl))));
					(__temp916 == NULL ? NULL : (__temp916 = (g_object_unref (__temp916), NULL)));
					(__temp915 == NULL ? NULL : (__temp915 = (g_object_unref (__temp915), NULL)));
				}
			}
		}
	}
	if (VALA_IS_BLOCK (vala_symbol_get_node (vala_symbol_get_parent_symbol (sym)))) {
		found = found || vala_code_generator_append_local_free_expr (self, vala_symbol_get_parent_symbol (sym), ccomma, stop_at_loop);
	}
	gboolean __temp918;
	return (__temp918 = found, (b == NULL ? NULL : (b = (g_object_unref (b), NULL))), (local_vars == NULL ? NULL : (local_vars = (g_list_free (local_vars), NULL))), __temp918);
	(b == NULL ? NULL : (b = (g_object_unref (b), NULL)));
	(local_vars == NULL ? NULL : (local_vars = (g_list_free (local_vars), NULL)));
}


static void vala_code_generator_create_local_free_expr (ValaCodeGenerator* self, ValaExpression* expr)
{
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (expr == NULL || VALA_IS_EXPRESSION (expr));
	if (!vala_code_generator_get_memory_management (self)) {
		return;
	}
	ValaVariableDeclarator* return_expr_decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (expr), TRUE);
	ValaCCodeCommaExpression* ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
	ValaCCodeAssignment* __temp919 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp919 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (return_expr_decl))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
	(__temp919 == NULL ? NULL : (__temp919 = (g_object_unref (__temp919), NULL)));
	if (!vala_code_generator_append_local_free_expr (self, self->priv->current_symbol, ccomma, FALSE)) {
		(return_expr_decl == NULL ? NULL : (return_expr_decl = (g_object_unref (return_expr_decl), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		return;
	}
	/* no local variables need to be freed */
	ValaCCodeIdentifier* __temp920 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp920 = vala_ccode_identifier_new (vala_variable_declarator_get_name (return_expr_decl)))));
	(__temp920 == NULL ? NULL : (__temp920 = (g_object_unref (__temp920), NULL)));
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	ValaVariableDeclarator* __temp921 = NULL;
	expr->temp_vars = g_list_append (expr->temp_vars, (__temp921 = return_expr_decl, (__temp921 == NULL ? NULL : g_object_ref (__temp921))));
	(return_expr_decl == NULL ? NULL : (return_expr_decl = (g_object_unref (return_expr_decl), NULL)));
	(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
}


static void vala_code_generator_real_visit_begin_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_RETURN_STATEMENT (stmt));
	if (vala_return_statement_get_return_expression (stmt) != NULL) {
		/* avoid unnecessary ref/unref pair*/
		if (vala_expression_get_ref_missing (vala_return_statement_get_return_expression (stmt)) && vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt)) != NULL && VALA_IS_VARIABLE_DECLARATOR (vala_symbol_get_node (vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt))))) {
			ValaVariableDeclarator* __temp922 = NULL;
			ValaVariableDeclarator* decl = (__temp922 = VALA_VARIABLE_DECLARATOR (vala_symbol_get_node (vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt)))), (__temp922 == NULL ? NULL : g_object_ref (__temp922)));
			if (vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))) {
				/* return expression is local variable taking ownership and
				 * current method is transferring ownership */
				(vala_expression_set_ref_sink (vala_return_statement_get_return_expression (stmt), TRUE), vala_expression_get_ref_sink (vala_return_statement_get_return_expression (stmt)));
				/* don't ref expression*/
				(vala_expression_set_ref_missing (vala_return_statement_get_return_expression (stmt), FALSE), vala_expression_get_ref_missing (vala_return_statement_get_return_expression (stmt)));
			}
			(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
		}
	}
}


static void vala_code_generator_real_visit_end_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_RETURN_STATEMENT (stmt));
	if (vala_return_statement_get_return_expression (stmt) == NULL) {
		ValaCCodeReturnStatement* __temp923 = NULL;
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp923 = vala_ccode_return_statement_new (NULL)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
		(__temp923 == NULL ? NULL : (__temp923 = (g_object_unref (__temp923), NULL)));
		vala_code_generator_create_local_free (self, VALA_STATEMENT (stmt));
	} else {
		ValaSymbol* return_expression_symbol = NULL;
		/* avoid unnecessary ref/unref pair*/
		if (vala_expression_get_ref_sink (vala_return_statement_get_return_expression (stmt)) && vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt)) != NULL && VALA_IS_VARIABLE_DECLARATOR (vala_symbol_get_node (vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt))))) {
			ValaVariableDeclarator* __temp924 = NULL;
			ValaVariableDeclarator* decl = (__temp924 = VALA_VARIABLE_DECLARATOR (vala_symbol_get_node (vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt)))), (__temp924 == NULL ? NULL : g_object_ref (__temp924)));
			if (vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))) {
				/* return expression is local variable taking ownership and
				 * current method is transferring ownership 
				 don't unref expression*/
				ValaSymbol* __temp926 = NULL;
				ValaSymbol* __temp925 = NULL;
				return_expression_symbol = (__temp926 = (__temp925 = vala_code_node_get_symbol (VALA_CODE_NODE (decl)), (__temp925 == NULL ? NULL : g_object_ref (__temp925))), (return_expression_symbol == NULL ? NULL : (return_expression_symbol = (g_object_unref (return_expression_symbol), NULL))), __temp926);
				(vala_symbol_set_active (return_expression_symbol, FALSE), vala_symbol_get_active (return_expression_symbol));
			}
			(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
		}
		vala_code_generator_create_local_free_expr (self, vala_return_statement_get_return_expression (stmt));
		if (vala_expression_get_static_type (vala_return_statement_get_return_expression (stmt)) != NULL && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_return_statement_get_return_expression (stmt))) != vala_type_reference_get_data_type (self->priv->current_return_type)) {
			/* cast required */
			if (VALA_IS_CLASS (vala_type_reference_get_data_type (self->priv->current_return_type)) || VALA_IS_INTERFACE (vala_type_reference_get_data_type (self->priv->current_return_type))) {
				ValaInstanceCast* __temp927 = NULL;
				(vala_code_node_set_ccodenode (VALA_CODE_NODE (vala_return_statement_get_return_expression (stmt)), VALA_CCODE_NODE ((__temp927 = vala_instance_cast_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_return_statement_get_return_expression (stmt)))), vala_type_reference_get_data_type (self->priv->current_return_type))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_return_statement_get_return_expression (stmt))));
				(__temp927 == NULL ? NULL : (__temp927 = (g_object_unref (__temp927), NULL)));
			}
		}
		ValaCCodeReturnStatement* __temp928 = NULL;
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp928 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_return_statement_get_return_expression (stmt)))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
		(__temp928 == NULL ? NULL : (__temp928 = (g_object_unref (__temp928), NULL)));
		vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), vala_return_statement_get_return_expression (stmt)->temp_vars);
		if (return_expression_symbol != NULL) {
			(vala_symbol_set_active (return_expression_symbol, TRUE), vala_symbol_get_active (return_expression_symbol));
		}
		(return_expression_symbol == NULL ? NULL : (return_expression_symbol = (g_object_unref (return_expression_symbol), NULL)));
	}
}


static char* vala_code_generator_get_symbol_lock_name (ValaCodeGenerator* self, ValaSymbol* sym)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_SYMBOL (sym), NULL);
	return g_strdup_printf ("__lock_%s", vala_symbol_get_name (sym));
}


/**
 * Visit operation called for lock statements.
 *
 * @param stmt a lock statement
 */
static void vala_code_generator_real_visit_lock_statement (ValaCodeVisitor* base, ValaLockStatement* stmt)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_LOCK_STATEMENT (stmt));
	ValaCCodeFragment* cn = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	ValaCCodeExpression* l = NULL;
	ValaCCodeFunctionCall* fc = NULL;
	ValaExpression* __temp930 = NULL;
	ValaExpression* inner_node = (__temp930 = vala_member_access_get_inner ((VALA_MEMBER_ACCESS (vala_lock_statement_get_resource (stmt)))), (__temp930 == NULL ? NULL : g_object_ref (__temp930)));
	if (inner_node == NULL) {
		ValaCCodeExpression* __temp931 = NULL;
		l = (__temp931 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (l == NULL ? NULL : (l = (g_object_unref (l), NULL))), __temp931);
	} else {
		if (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt)))) != VALA_CODE_NODE (self->priv->current_class)) {
			ValaCCodeExpression* __temp932 = NULL;
			l = (__temp932 = VALA_CCODE_EXPRESSION (vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname ((VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt)))))), NULL))))), (l == NULL ? NULL : (l = (g_object_unref (l), NULL))), __temp932);
			vala_ccode_function_call_add_argument ((VALA_CCODE_FUNCTION_CALL (l)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (inner_node))));
		} else {
			ValaCCodeExpression* __temp934 = NULL;
			ValaCCodeExpression* __temp933 = NULL;
			l = (__temp934 = (__temp933 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (inner_node))), (__temp933 == NULL ? NULL : g_object_ref (__temp933))), (l == NULL ? NULL : (l = (g_object_unref (l), NULL))), __temp934);
		}
	}
	ValaCCodeExpression* __temp935 = NULL;
	l = (__temp935 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (l, "priv")), vala_code_generator_get_symbol_lock_name (self, vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt))))), (l == NULL ? NULL : (l = (g_object_unref (l), NULL))), __temp935);
	ValaCCodeFunctionCall* __temp937 = NULL;
	ValaSymbol* __temp936 = NULL;
	fc = (__temp937 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_method_get_cname ((VALA_METHOD (vala_symbol_get_node ((__temp936 = vala_symbol_lookup (vala_code_node_get_symbol (VALA_CODE_NODE (vala_type_reference_get_data_type (self->priv->mutex_type))), "lock"))))))))), (fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL))), __temp937);
	(__temp936 == NULL ? NULL : (__temp936 = (g_object_unref (__temp936), NULL)));
	vala_ccode_function_call_add_argument (fc, l);
	ValaCCodeExpressionStatement* __temp938 = NULL;
	vala_ccode_fragment_append (cn, VALA_CCODE_NODE ((__temp938 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
	(__temp938 == NULL ? NULL : (__temp938 = (g_object_unref (__temp938), NULL)));
	vala_ccode_fragment_append (cn, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_lock_statement_get_body (stmt))));
	ValaCCodeFunctionCall* __temp940 = NULL;
	ValaSymbol* __temp939 = NULL;
	fc = (__temp940 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_method_get_cname ((VALA_METHOD (vala_symbol_get_node ((__temp939 = vala_symbol_lookup (vala_code_node_get_symbol (VALA_CODE_NODE (vala_type_reference_get_data_type (self->priv->mutex_type))), "unlock"))))))))), (fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL))), __temp940);
	(__temp939 == NULL ? NULL : (__temp939 = (g_object_unref (__temp939), NULL)));
	vala_ccode_function_call_add_argument (fc, l);
	ValaCCodeExpressionStatement* __temp941 = NULL;
	vala_ccode_fragment_append (cn, VALA_CCODE_NODE ((__temp941 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
	(__temp941 == NULL ? NULL : (__temp941 = (g_object_unref (__temp941), NULL)));
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cn)), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	(cn == NULL ? NULL : (cn = (g_object_unref (cn), NULL)));
	(l == NULL ? NULL : (l = (g_object_unref (l), NULL)));
	(fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL)));
	(inner_node == NULL ? NULL : (inner_node = (g_object_unref (inner_node), NULL)));
}


/**
 * Visit operations called for array creation expresions.
 *
 * @param expr an array creation expression
 */
static void vala_code_generator_real_visit_end_array_creation_expression (ValaCodeVisitor* base, ValaArrayCreationExpression* expr)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_ARRAY_CREATION_EXPRESSION (expr));
	/* FIXME: rank > 1 not supported yet */
	if (vala_array_creation_expression_get_rank (expr) > 1) {
		(vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE), vala_code_node_get_error (VALA_CODE_NODE (expr)));
		vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), "Creating arrays with rank greater than 1 is not supported yet");
	}
	GList* sizes = vala_array_creation_expression_get_sizes (expr);
	ValaCCodeFunctionCall* gnew = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_new0")));
	ValaCCodeIdentifier* __temp942 = NULL;
	vala_ccode_function_call_add_argument (gnew, VALA_CCODE_EXPRESSION ((__temp942 = vala_ccode_identifier_new (vala_type_reference_get_cname (vala_array_creation_expression_get_element_type (expr), FALSE, FALSE)))));
	(__temp942 == NULL ? NULL : (__temp942 = (g_object_unref (__temp942), NULL)));
	/* FIXME: had to add Expression cast due to possible compiler bug */
	vala_ccode_function_call_add_argument (gnew, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE ((VALA_EXPRESSION (g_list_first (sizes)->data))))));
	if (vala_array_creation_expression_get_initializer_list (expr) != NULL) {
		ValaCCodeCommaExpression* ce = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
		ValaVariableDeclarator* temp_var = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (VALA_EXPRESSION (expr)), TRUE);
		ValaCCodeIdentifier* name_cnode = vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_var));
		gint i = 0;
		ValaVariableDeclarator* __temp943 = NULL;
		self->priv->temp_vars = g_list_prepend (self->priv->temp_vars, (__temp943 = temp_var, (__temp943 == NULL ? NULL : g_object_ref (__temp943))));
		/* FIXME: had to add Expression cast due to possible compiler bug */
		ValaCCodeAssignment* __temp944 = NULL;
		vala_ccode_comma_expression_append_expression (ce, VALA_CCODE_EXPRESSION ((__temp944 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (name_cnode), VALA_CCODE_EXPRESSION (gnew), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(__temp944 == NULL ? NULL : (__temp944 = (g_object_unref (__temp944), NULL)));
		{
			GList* __temp946 = NULL;
			__temp946 = vala_initializer_list_get_initializers (vala_array_creation_expression_get_initializer_list (expr));
			GList* e_it;
			for (e_it = __temp946; e_it != NULL; e_it = e_it->next) {
				ValaExpression* e = e_it->data;
				{
					ValaCCodeAssignment* __temp945 = NULL;
					vala_ccode_comma_expression_append_expression (ce, VALA_CCODE_EXPRESSION ((__temp945 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_element_access_new (VALA_CCODE_EXPRESSION (name_cnode), VALA_CCODE_EXPRESSION (vala_ccode_constant_new (g_strdup_printf ("%i", i))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (e))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
					(__temp945 == NULL ? NULL : (__temp945 = (g_object_unref (__temp945), NULL)));
					i++;
				}
			}
			(__temp946 == NULL ? NULL : (__temp946 = (g_list_free (__temp946), NULL)));
		}
		vala_ccode_comma_expression_append_expression (ce, VALA_CCODE_EXPRESSION (name_cnode));
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ce)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		(ce == NULL ? NULL : (ce = (g_object_unref (ce), NULL)));
		(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
		(name_cnode == NULL ? NULL : (name_cnode = (g_object_unref (name_cnode), NULL)));
	} else {
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (gnew)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	}
	(sizes == NULL ? NULL : (sizes = (g_list_free (sizes), NULL)));
	(gnew == NULL ? NULL : (gnew = (g_object_unref (gnew), NULL)));
}


static void vala_code_generator_real_visit_boolean_literal (ValaCodeVisitor* base, ValaBooleanLiteral* expr)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_BOOLEAN_LITERAL (expr));
	ValaCCodeConstant* __temp947 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp947 = vala_ccode_constant_new ((vala_boolean_literal_get_value (expr) ? "TRUE" : "FALSE"))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp947 == NULL ? NULL : (__temp947 = (g_object_unref (__temp947), NULL)));
}


static void vala_code_generator_real_visit_character_literal (ValaCodeVisitor* base, ValaCharacterLiteral* expr)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CHARACTER_LITERAL (expr));
	if (vala_character_literal_get_char (expr) >= 0x20 && vala_character_literal_get_char (expr) < 0x80) {
		ValaCCodeConstant* __temp948 = NULL;
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp948 = vala_ccode_constant_new (vala_character_literal_get_value (expr))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		(__temp948 == NULL ? NULL : (__temp948 = (g_object_unref (__temp948), NULL)));
	} else {
		ValaCCodeConstant* __temp949 = NULL;
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp949 = vala_ccode_constant_new (g_strdup_printf ("%uU", vala_character_literal_get_char (expr)))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		(__temp949 == NULL ? NULL : (__temp949 = (g_object_unref (__temp949), NULL)));
	}
}


static void vala_code_generator_real_visit_integer_literal (ValaCodeVisitor* base, ValaIntegerLiteral* expr)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_INTEGER_LITERAL (expr));
	ValaCCodeConstant* __temp950 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp950 = vala_ccode_constant_new (vala_integer_literal_get_value (expr))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp950 == NULL ? NULL : (__temp950 = (g_object_unref (__temp950), NULL)));
}


static void vala_code_generator_real_visit_real_literal (ValaCodeVisitor* base, ValaRealLiteral* expr)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_REAL_LITERAL (expr));
	ValaCCodeConstant* __temp951 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp951 = vala_ccode_constant_new (vala_real_literal_get_value (expr))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp951 == NULL ? NULL : (__temp951 = (g_object_unref (__temp951), NULL)));
}


static void vala_code_generator_real_visit_string_literal (ValaCodeVisitor* base, ValaStringLiteral* expr)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_STRING_LITERAL (expr));
	ValaCCodeConstant* __temp952 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp952 = vala_ccode_constant_new (vala_string_literal_get_value (expr))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp952 == NULL ? NULL : (__temp952 = (g_object_unref (__temp952), NULL)));
}


static void vala_code_generator_real_visit_null_literal (ValaCodeVisitor* base, ValaNullLiteral* expr)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_NULL_LITERAL (expr));
	ValaCCodeConstant* __temp953 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp953 = vala_ccode_constant_new ("NULL")))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp953 == NULL ? NULL : (__temp953 = (g_object_unref (__temp953), NULL)));
}


static void vala_code_generator_real_visit_literal_expression (ValaCodeVisitor* base, ValaLiteralExpression* expr)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_LITERAL_EXPRESSION (expr));
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_literal_expression_get_literal (expr)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static void vala_code_generator_process_cmember (ValaCodeGenerator* self, ValaMemberAccess* expr, ValaCCodeExpression* pub_inst, ValaDataType* base_type)
{
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_MEMBER_ACCESS (expr));
	g_return_if_fail (pub_inst == NULL || VALA_IS_CCODE_EXPRESSION (pub_inst));
	g_return_if_fail (base_type == NULL || VALA_IS_DATA_TYPE (base_type));
	if (VALA_IS_METHOD (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))))) {
		ValaMethod* __temp954 = NULL;
		ValaMethod* m = (__temp954 = VALA_METHOD (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))), (__temp954 == NULL ? NULL : g_object_ref (__temp954)));
		if (VALA_IS_BASE_ACCESS (vala_member_access_get_inner (expr))) {
			if (vala_method_get_base_interface_method (m) != NULL) {
				ValaInterface* __temp955 = NULL;
				ValaInterface* base_iface = (__temp955 = VALA_INTERFACE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (vala_method_get_base_interface_method (m)))))), (__temp955 == NULL ? NULL : g_object_ref (__temp955)));
				char* __temp957 = NULL;
				char* __temp956 = NULL;
				char* __temp958 = NULL;
				char* parent_iface_var = (__temp958 = g_strdup_printf ("%s_%s_parent_iface", (__temp956 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (self->priv->current_class), NULL)), (__temp957 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (base_iface), NULL))), (__temp957 = (g_free (__temp957), NULL)), (__temp956 = (g_free (__temp956), NULL)), __temp958);
				ValaCCodeMemberAccess* __temp959 = NULL;
				(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp959 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (parent_iface_var)), vala_method_get_name (m))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
				(__temp959 == NULL ? NULL : (__temp959 = (g_object_unref (__temp959), NULL)));
				(base_iface == NULL ? NULL : (base_iface = (g_object_unref (base_iface), NULL)));
				(parent_iface_var = (g_free (parent_iface_var), NULL));
				(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
				return;
				(base_iface == NULL ? NULL : (base_iface = (g_object_unref (base_iface), NULL)));
				(parent_iface_var = (g_free (parent_iface_var), NULL));
			} else {
				if (vala_method_get_base_method (m) != NULL) {
					ValaClass* __temp960 = NULL;
					ValaClass* base_class = (__temp960 = VALA_CLASS (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (vala_method_get_base_method (m)))))), (__temp960 == NULL ? NULL : g_object_ref (__temp960)));
					char* __temp961 = NULL;
					ValaCCodeFunctionCall* __temp962 = NULL;
					ValaCCodeFunctionCall* vcast = (__temp962 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_CLASS", (__temp961 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (base_class), NULL)))))), (__temp961 = (g_free (__temp961), NULL)), __temp962);
					ValaCCodeIdentifier* __temp964 = NULL;
					char* __temp963 = NULL;
					vala_ccode_function_call_add_argument (vcast, VALA_CCODE_EXPRESSION ((__temp964 = vala_ccode_identifier_new (g_strdup_printf ("%s_parent_class", (__temp963 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (self->priv->current_class), NULL)))))));
					(__temp964 == NULL ? NULL : (__temp964 = (g_object_unref (__temp964), NULL)));
					(__temp963 = (g_free (__temp963), NULL));
					ValaCCodeMemberAccess* __temp965 = NULL;
					(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp965 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vcast), vala_method_get_name (m))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
					(__temp965 == NULL ? NULL : (__temp965 = (g_object_unref (__temp965), NULL)));
					(base_class == NULL ? NULL : (base_class = (g_object_unref (base_class), NULL)));
					(vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL)));
					(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
					return;
					(base_class == NULL ? NULL : (base_class = (g_object_unref (base_class), NULL)));
					(vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL)));
				}
			}
		}
		if (vala_method_get_base_interface_method (m) != NULL) {
			ValaCCodeIdentifier* __temp966 = NULL;
			(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp966 = vala_ccode_identifier_new (vala_method_get_cname (vala_method_get_base_interface_method (m)))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
			(__temp966 == NULL ? NULL : (__temp966 = (g_object_unref (__temp966), NULL)));
		} else {
			if (vala_method_get_base_method (m) != NULL) {
				ValaCCodeIdentifier* __temp967 = NULL;
				(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp967 = vala_ccode_identifier_new (vala_method_get_cname (vala_method_get_base_method (m)))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
				(__temp967 == NULL ? NULL : (__temp967 = (g_object_unref (__temp967), NULL)));
			} else {
				ValaCCodeIdentifier* __temp968 = NULL;
				(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp968 = vala_ccode_identifier_new (vala_method_get_cname (m))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
				(__temp968 == NULL ? NULL : (__temp968 = (g_object_unref (__temp968), NULL)));
			}
		}
		(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
	} else {
		if (VALA_IS_ARRAY_LENGTH_FIELD (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))))) {
			ValaCCodeExpression* __temp969 = NULL;
			(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp969 = vala_code_generator_get_array_length_cexpression (self, vala_member_access_get_inner (expr), 1)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
			(__temp969 = (g_object_unref (__temp969), NULL));
		} else {
			if (VALA_IS_FIELD (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))))) {
				ValaField* __temp970 = NULL;
				ValaField* f = (__temp970 = VALA_FIELD (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))), (__temp970 == NULL ? NULL : g_object_ref (__temp970)));
				if (vala_field_get_instance (f)) {
					ValaCCodeExpression* typed_inst = NULL;
					if (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (f)))) != VALA_CODE_NODE (base_type)) {
						/* FIXME: use C cast if debugging disabled*/
						ValaCCodeExpression* __temp971 = NULL;
						typed_inst = (__temp971 = VALA_CCODE_EXPRESSION (vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname ((VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (f)))))), NULL))))), (typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL))), __temp971);
						vala_ccode_function_call_add_argument ((VALA_CCODE_FUNCTION_CALL (typed_inst)), pub_inst);
					} else {
						ValaCCodeExpression* __temp973 = NULL;
						ValaCCodeExpression* __temp972 = NULL;
						typed_inst = (__temp973 = (__temp972 = pub_inst, (__temp972 == NULL ? NULL : g_object_ref (__temp972))), (typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL))), __temp973);
					}
					ValaCCodeExpression* inst = NULL;
					if (f->access == VALA_MEMBER_ACCESSIBILITY_PRIVATE) {
						ValaCCodeExpression* __temp974 = NULL;
						inst = (__temp974 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (typed_inst, "priv")), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), __temp974);
					} else {
						ValaCCodeExpression* __temp976 = NULL;
						ValaCCodeExpression* __temp975 = NULL;
						inst = (__temp976 = (__temp975 = typed_inst, (__temp975 == NULL ? NULL : g_object_ref (__temp975))), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), __temp976);
					}
					if (vala_data_type_is_reference_type ((VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (f)))))))) {
						ValaCCodeMemberAccess* __temp977 = NULL;
						(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp977 = vala_ccode_member_access_new_pointer (inst, vala_field_get_cname (f))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
						(__temp977 == NULL ? NULL : (__temp977 = (g_object_unref (__temp977), NULL)));
					} else {
						ValaCCodeMemberAccess* __temp978 = NULL;
						(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp978 = vala_ccode_member_access_new (inst, vala_field_get_cname (f), FALSE)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
						(__temp978 == NULL ? NULL : (__temp978 = (g_object_unref (__temp978), NULL)));
					}
					(typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL)));
					(inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL)));
				} else {
					ValaCCodeIdentifier* __temp979 = NULL;
					(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp979 = vala_ccode_identifier_new (vala_field_get_cname (f))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
					(__temp979 == NULL ? NULL : (__temp979 = (g_object_unref (__temp979), NULL)));
				}
				(f == NULL ? NULL : (f = (g_object_unref (f), NULL)));
			} else {
				if (VALA_IS_CONSTANT (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))))) {
					ValaConstant* __temp980 = NULL;
					ValaConstant* c = (__temp980 = VALA_CONSTANT (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))), (__temp980 == NULL ? NULL : g_object_ref (__temp980)));
					ValaCCodeIdentifier* __temp981 = NULL;
					(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp981 = vala_ccode_identifier_new (vala_constant_get_cname (c))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
					(__temp981 == NULL ? NULL : (__temp981 = (g_object_unref (__temp981), NULL)));
					(c == NULL ? NULL : (c = (g_object_unref (c), NULL)));
				} else {
					if (VALA_IS_PROPERTY (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))))) {
						ValaProperty* __temp982 = NULL;
						ValaProperty* prop = (__temp982 = VALA_PROPERTY (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))), (__temp982 == NULL ? NULL : g_object_ref (__temp982)));
						if (!vala_property_get_no_accessor_method (prop)) {
							ValaProperty* __temp983 = NULL;
							ValaProperty* base_property = (__temp983 = prop, (__temp983 == NULL ? NULL : g_object_ref (__temp983)));
							if (vala_property_get_base_property (prop) != NULL) {
								ValaProperty* __temp985 = NULL;
								ValaProperty* __temp984 = NULL;
								base_property = (__temp985 = (__temp984 = vala_property_get_base_property (prop), (__temp984 == NULL ? NULL : g_object_ref (__temp984))), (base_property == NULL ? NULL : (base_property = (g_object_unref (base_property), NULL))), __temp985);
							} else {
								if (vala_property_get_base_interface_property (prop) != NULL) {
									ValaProperty* __temp987 = NULL;
									ValaProperty* __temp986 = NULL;
									base_property = (__temp987 = (__temp986 = vala_property_get_base_interface_property (prop), (__temp986 == NULL ? NULL : g_object_ref (__temp986))), (base_property == NULL ? NULL : (base_property = (g_object_unref (base_property), NULL))), __temp987);
								}
							}
							ValaDataType* __temp988 = NULL;
							ValaDataType* base_property_type = (__temp988 = VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (base_property))))), (__temp988 == NULL ? NULL : g_object_ref (__temp988)));
							char* __temp989 = NULL;
							ValaCCodeFunctionCall* __temp990 = NULL;
							ValaCCodeFunctionCall* ccall = (__temp990 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_get_%s", (__temp989 = vala_data_type_get_lower_case_cname (base_property_type, NULL)), vala_property_get_name (base_property))))), (__temp989 = (g_free (__temp989), NULL)), __temp990);
							/* explicitly use strong reference as ccast
							 * gets unrefed at the end of the inner block
							 */
							ValaCCodeExpression* __temp991 = NULL;
							ValaCCodeExpression* typed_pub_inst = (__temp991 = pub_inst, (__temp991 == NULL ? NULL : g_object_ref (__temp991)));
							/* cast if necessary */
							if (base_property_type != base_type) {
								/* FIXME: use C cast if debugging disabled*/
								ValaCCodeFunctionCall* ccast = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (base_property_type, NULL))));
								vala_ccode_function_call_add_argument (ccast, pub_inst);
								ValaCCodeExpression* __temp993 = NULL;
								ValaCCodeFunctionCall* __temp992 = NULL;
								typed_pub_inst = (__temp993 = VALA_CCODE_EXPRESSION ((__temp992 = ccast, (__temp992 == NULL ? NULL : g_object_ref (__temp992)))), (typed_pub_inst == NULL ? NULL : (typed_pub_inst = (g_object_unref (typed_pub_inst), NULL))), __temp993);
								(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
							}
							vala_ccode_function_call_add_argument (ccall, typed_pub_inst);
							(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
							(base_property == NULL ? NULL : (base_property = (g_object_unref (base_property), NULL)));
							(base_property_type == NULL ? NULL : (base_property_type = (g_object_unref (base_property_type), NULL)));
							(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
							(typed_pub_inst == NULL ? NULL : (typed_pub_inst = (g_object_unref (typed_pub_inst), NULL)));
						} else {
							ValaCCodeFunctionCall* ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_object_get")));
							ValaCCodeFunctionCall* ccast = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("G_OBJECT")));
							vala_ccode_function_call_add_argument (ccast, pub_inst);
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccast));
							/* property name is second argument of g_object_get*/
							ValaCCodeConstant* __temp994 = NULL;
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp994 = vala_property_get_canonical_cconstant (prop))));
							(__temp994 = (g_object_unref (__temp994), NULL));
							/* we need a temporary variable to save the property value*/
							ValaVariableDeclarator* temp_decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (VALA_EXPRESSION (expr)), TRUE);
							ValaVariableDeclarator* __temp995 = NULL;
							self->priv->temp_vars = g_list_prepend (self->priv->temp_vars, (__temp995 = temp_decl, (__temp995 == NULL ? NULL : g_object_ref (__temp995))));
							ValaCCodeIdentifier* ctemp = vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl));
							ValaCCodeUnaryExpression* __temp996 = NULL;
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp996 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (ctemp)))));
							(__temp996 == NULL ? NULL : (__temp996 = (g_object_unref (__temp996), NULL)));
							ValaCCodeConstant* __temp997 = NULL;
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp997 = vala_ccode_constant_new ("NULL"))));
							(__temp997 == NULL ? NULL : (__temp997 = (g_object_unref (__temp997), NULL)));
							ValaCCodeCommaExpression* ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
							vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
							vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ctemp));
							(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
							(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
							(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
							(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
							(ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL)));
							(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
						}
						(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
					} else {
						if (VALA_IS_ENUM_VALUE (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))))) {
							ValaEnumValue* __temp998 = NULL;
							ValaEnumValue* ev = (__temp998 = VALA_ENUM_VALUE (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))), (__temp998 == NULL ? NULL : g_object_ref (__temp998)));
							ValaCCodeConstant* __temp999 = NULL;
							(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp999 = vala_ccode_constant_new (vala_enum_value_get_cname (ev))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
							(__temp999 == NULL ? NULL : (__temp999 = (g_object_unref (__temp999), NULL)));
							(ev == NULL ? NULL : (ev = (g_object_unref (ev), NULL)));
						} else {
							if (VALA_IS_VARIABLE_DECLARATOR (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))))) {
								ValaVariableDeclarator* __temp1000 = NULL;
								ValaVariableDeclarator* decl = (__temp1000 = VALA_VARIABLE_DECLARATOR (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))), (__temp1000 == NULL ? NULL : g_object_ref (__temp1000)));
								ValaCCodeIdentifier* __temp1001 = NULL;
								(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1001 = vala_ccode_identifier_new (vala_variable_declarator_get_name (decl))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
								(__temp1001 == NULL ? NULL : (__temp1001 = (g_object_unref (__temp1001), NULL)));
								(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
							} else {
								if (VALA_IS_FORMAL_PARAMETER (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))))) {
									ValaFormalParameter* __temp1002 = NULL;
									ValaFormalParameter* p = (__temp1002 = VALA_FORMAL_PARAMETER (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))), (__temp1002 == NULL ? NULL : g_object_ref (__temp1002)));
									if (g_utf8_collate (vala_formal_parameter_get_name (p), "this") == 0) {
										(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (pub_inst)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
									} else {
										if (vala_type_reference_get_is_out (vala_formal_parameter_get_type_reference (p)) || vala_type_reference_get_reference_to_value_type (vala_formal_parameter_get_type_reference (p))) {
											ValaCCodeIdentifier* __temp1003 = NULL;
											(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1003 = vala_ccode_identifier_new (g_strdup_printf ("(*%s)", vala_formal_parameter_get_name (p)))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
											(__temp1003 == NULL ? NULL : (__temp1003 = (g_object_unref (__temp1003), NULL)));
										} else {
											ValaCCodeIdentifier* __temp1004 = NULL;
											(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1004 = vala_ccode_identifier_new (vala_formal_parameter_get_name (p))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
											(__temp1004 == NULL ? NULL : (__temp1004 = (g_object_unref (__temp1004), NULL)));
										}
									}
									(p == NULL ? NULL : (p = (g_object_unref (p), NULL)));
								} else {
									if (VALA_IS_SIGNAL (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))))) {
										ValaSignal* __temp1005 = NULL;
										ValaSignal* sig = (__temp1005 = VALA_SIGNAL (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))), (__temp1005 == NULL ? NULL : g_object_ref (__temp1005)));
										ValaDataType* __temp1006 = NULL;
										ValaDataType* cl = (__temp1006 = VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (sig))))), (__temp1006 == NULL ? NULL : g_object_ref (__temp1006)));
										if (vala_signal_get_has_emitter (sig)) {
											char* __temp1007 = NULL;
											ValaCCodeFunctionCall* __temp1008 = NULL;
											ValaCCodeFunctionCall* ccall = (__temp1008 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_%s", (__temp1007 = vala_data_type_get_lower_case_cname (cl, NULL)), vala_signal_get_name (sig))))), (__temp1007 = (g_free (__temp1007), NULL)), __temp1008);
											/* explicitly use strong reference as ccast
											 * gets unrefed at the end of the inner block
											 */
											ValaCCodeExpression* __temp1009 = NULL;
											ValaCCodeExpression* typed_pub_inst = (__temp1009 = pub_inst, (__temp1009 == NULL ? NULL : g_object_ref (__temp1009)));
											/* cast if necessary */
											if (cl != base_type) {
												/* FIXME: use C cast if debugging disabled*/
												ValaCCodeFunctionCall* ccast = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (cl, NULL))));
												vala_ccode_function_call_add_argument (ccast, pub_inst);
												ValaCCodeExpression* __temp1011 = NULL;
												ValaCCodeFunctionCall* __temp1010 = NULL;
												typed_pub_inst = (__temp1011 = VALA_CCODE_EXPRESSION ((__temp1010 = ccast, (__temp1010 == NULL ? NULL : g_object_ref (__temp1010)))), (typed_pub_inst == NULL ? NULL : (typed_pub_inst = (g_object_unref (typed_pub_inst), NULL))), __temp1011);
												(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
											}
											vala_ccode_function_call_add_argument (ccall, typed_pub_inst);
											(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
											(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
											(typed_pub_inst == NULL ? NULL : (typed_pub_inst = (g_object_unref (typed_pub_inst), NULL)));
										} else {
											ValaCCodeFunctionCall* ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_signal_emit_by_name")));
											/* FIXME: use C cast if debugging disabled*/
											ValaCCodeFunctionCall* ccast = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("G_OBJECT")));
											vala_ccode_function_call_add_argument (ccast, pub_inst);
											vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccast));
											ValaCCodeConstant* __temp1012 = NULL;
											vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1012 = vala_signal_get_canonical_cconstant (sig))));
											(__temp1012 = (g_object_unref (__temp1012), NULL));
											(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
											(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
											(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
										}
										(sig == NULL ? NULL : (sig = (g_object_unref (sig), NULL)));
										(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


static void vala_code_generator_real_visit_parenthesized_expression (ValaCodeVisitor* base, ValaParenthesizedExpression* expr)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_PARENTHESIZED_EXPRESSION (expr));
	ValaCCodeParenthesizedExpression* __temp1013 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1013 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_parenthesized_expression_get_inner (expr)))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp1013 == NULL ? NULL : (__temp1013 = (g_object_unref (__temp1013), NULL)));
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static void vala_code_generator_real_visit_member_access (ValaCodeVisitor* base, ValaMemberAccess* expr)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_MEMBER_ACCESS (expr));
	ValaCCodeExpression* pub_inst = NULL;
	ValaDataType* base_type = NULL;
	if (vala_member_access_get_inner (expr) == NULL) {
		ValaCCodeExpression* __temp1014 = NULL;
		pub_inst = (__temp1014 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), __temp1014);
		if (self->priv->current_type_symbol != NULL) {
			/* base type is available if this is a type method */
			ValaDataType* __temp1016 = NULL;
			ValaDataType* __temp1015 = NULL;
			base_type = (__temp1016 = (__temp1015 = VALA_DATA_TYPE (vala_symbol_get_node (self->priv->current_type_symbol)), (__temp1015 == NULL ? NULL : g_object_ref (__temp1015))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), __temp1016);
			if (!vala_data_type_is_reference_type (base_type)) {
				ValaCCodeExpression* __temp1017 = NULL;
				pub_inst = (__temp1017 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("(*self)")), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), __temp1017);
			}
		}
	} else {
		ValaCCodeExpression* __temp1019 = NULL;
		ValaCCodeExpression* __temp1018 = NULL;
		pub_inst = (__temp1019 = (__temp1018 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (expr)))), (__temp1018 == NULL ? NULL : g_object_ref (__temp1018))), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), __temp1019);
		if (vala_expression_get_static_type (vala_member_access_get_inner (expr)) != NULL) {
			ValaDataType* __temp1021 = NULL;
			ValaDataType* __temp1020 = NULL;
			base_type = (__temp1021 = (__temp1020 = vala_type_reference_get_data_type (vala_expression_get_static_type (vala_member_access_get_inner (expr))), (__temp1020 == NULL ? NULL : g_object_ref (__temp1020))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), __temp1021);
		}
	}
	vala_code_generator_process_cmember (self, expr, pub_inst, base_type);
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
	(pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL)));
	(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
}


static ValaCCodeExpression* vala_code_generator_get_array_length_cexpression (ValaCodeGenerator* self, ValaExpression* array_expr, gint dim)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (array_expr), NULL);
	gboolean is_out = FALSE;
	if (VALA_IS_UNARY_EXPRESSION (array_expr)) {
		ValaUnaryExpression* __temp1022 = NULL;
		ValaUnaryExpression* unary_expr = (__temp1022 = VALA_UNARY_EXPRESSION (array_expr), (__temp1022 == NULL ? NULL : g_object_ref (__temp1022)));
		if (vala_unary_expression_get_operator (unary_expr) == VALA_UNARY_OPERATOR_OUT) {
			array_expr = vala_unary_expression_get_inner (unary_expr);
			is_out = TRUE;
		}
		(unary_expr == NULL ? NULL : (unary_expr = (g_object_unref (unary_expr), NULL)));
	}
	if (VALA_IS_ARRAY_CREATION_EXPRESSION (array_expr)) {
		GList* size = vala_array_creation_expression_get_sizes ((VALA_ARRAY_CREATION_EXPRESSION (array_expr)));
		ValaExpression* __temp1023 = NULL;
		ValaExpression* length_expr = (__temp1023 = VALA_EXPRESSION (g_list_nth_data (size, dim - 1)), (__temp1023 == NULL ? NULL : g_object_ref (__temp1023)));
		ValaCCodeExpression* __temp1024 = NULL;
		ValaCCodeExpression* __temp1025 = NULL;
		return (__temp1025 = (__temp1024 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (length_expr))), (__temp1024 == NULL ? NULL : g_object_ref (__temp1024))), (size == NULL ? NULL : (size = (g_list_free (size), NULL))), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), __temp1025);
		(size == NULL ? NULL : (size = (g_list_free (size), NULL)));
		(length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL)));
	} else {
		if (vala_expression_get_symbol_reference (array_expr) != NULL) {
			if (VALA_IS_FORMAL_PARAMETER (vala_symbol_get_node (vala_expression_get_symbol_reference (array_expr)))) {
				ValaFormalParameter* __temp1026 = NULL;
				ValaFormalParameter* param = (__temp1026 = VALA_FORMAL_PARAMETER (vala_symbol_get_node (vala_expression_get_symbol_reference (array_expr))), (__temp1026 == NULL ? NULL : g_object_ref (__temp1026)));
				if (!vala_formal_parameter_get_no_array_length (param)) {
					ValaCCodeIdentifier* length_expr = vala_ccode_identifier_new (vala_code_generator_get_array_length_cname (self, vala_formal_parameter_get_name (param), dim));
					if (is_out) {
						ValaCCodeUnaryExpression* __temp1027 = NULL;
						return VALA_CCODE_EXPRESSION ((__temp1027 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (length_expr)), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), __temp1027));
					} else {
						ValaCCodeIdentifier* __temp1028 = NULL;
						return VALA_CCODE_EXPRESSION ((__temp1028 = length_expr, (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), __temp1028));
					}
					(length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL)));
				}
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			} else {
				if (VALA_IS_VARIABLE_DECLARATOR (vala_symbol_get_node (vala_expression_get_symbol_reference (array_expr)))) {
					ValaVariableDeclarator* __temp1029 = NULL;
					ValaVariableDeclarator* decl = (__temp1029 = VALA_VARIABLE_DECLARATOR (vala_symbol_get_node (vala_expression_get_symbol_reference (array_expr))), (__temp1029 == NULL ? NULL : g_object_ref (__temp1029)));
					ValaCCodeIdentifier* length_expr = vala_ccode_identifier_new (vala_code_generator_get_array_length_cname (self, vala_variable_declarator_get_name (decl), dim));
					if (is_out) {
						ValaCCodeUnaryExpression* __temp1030 = NULL;
						return VALA_CCODE_EXPRESSION ((__temp1030 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (length_expr)), (decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL))), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), __temp1030));
					} else {
						ValaCCodeIdentifier* __temp1031 = NULL;
						return VALA_CCODE_EXPRESSION ((__temp1031 = length_expr, (decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL))), __temp1031));
					}
					(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
					(length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL)));
				} else {
					if (VALA_IS_FIELD (vala_symbol_get_node (vala_expression_get_symbol_reference (array_expr)))) {
						ValaField* __temp1032 = NULL;
						ValaField* field = (__temp1032 = VALA_FIELD (vala_symbol_get_node (vala_expression_get_symbol_reference (array_expr))), (__temp1032 == NULL ? NULL : g_object_ref (__temp1032)));
						if (!vala_field_get_no_array_length (field)) {
							char* length_cname = vala_code_generator_get_array_length_cname (self, vala_field_get_name (field), dim);
							ValaMemberAccess* __temp1033 = NULL;
							ValaMemberAccess* ma = (__temp1033 = VALA_MEMBER_ACCESS (array_expr), (__temp1033 == NULL ? NULL : g_object_ref (__temp1033)));
							ValaCCodeExpression* pub_inst = NULL;
							ValaDataType* base_type = NULL;
							ValaCCodeExpression* length_expr = NULL;
							if (vala_member_access_get_inner (ma) == NULL) {
								ValaCCodeExpression* __temp1034 = NULL;
								pub_inst = (__temp1034 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), __temp1034);
								if (self->priv->current_type_symbol != NULL) {
									/* base type is available if this is a type method */
									ValaDataType* __temp1036 = NULL;
									ValaDataType* __temp1035 = NULL;
									base_type = (__temp1036 = (__temp1035 = VALA_DATA_TYPE (vala_symbol_get_node (self->priv->current_type_symbol)), (__temp1035 == NULL ? NULL : g_object_ref (__temp1035))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), __temp1036);
								}
							} else {
								ValaCCodeExpression* __temp1038 = NULL;
								ValaCCodeExpression* __temp1037 = NULL;
								pub_inst = (__temp1038 = (__temp1037 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))), (__temp1037 == NULL ? NULL : g_object_ref (__temp1037))), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), __temp1038);
								if (vala_expression_get_static_type (vala_member_access_get_inner (ma)) != NULL) {
									ValaDataType* __temp1040 = NULL;
									ValaDataType* __temp1039 = NULL;
									base_type = (__temp1040 = (__temp1039 = vala_type_reference_get_data_type (vala_expression_get_static_type (vala_member_access_get_inner (ma))), (__temp1039 == NULL ? NULL : g_object_ref (__temp1039))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), __temp1040);
								}
							}
							if (vala_field_get_instance (field)) {
								ValaCCodeExpression* typed_inst = NULL;
								if (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (field)))) != VALA_CODE_NODE (base_type)) {
									/* FIXME: use C cast if debugging disabled*/
									ValaCCodeExpression* __temp1041 = NULL;
									typed_inst = (__temp1041 = VALA_CCODE_EXPRESSION (vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname ((VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (field)))))), NULL))))), (typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL))), __temp1041);
									vala_ccode_function_call_add_argument ((VALA_CCODE_FUNCTION_CALL (typed_inst)), pub_inst);
								} else {
									ValaCCodeExpression* __temp1043 = NULL;
									ValaCCodeExpression* __temp1042 = NULL;
									typed_inst = (__temp1043 = (__temp1042 = pub_inst, (__temp1042 == NULL ? NULL : g_object_ref (__temp1042))), (typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL))), __temp1043);
								}
								ValaCCodeExpression* inst = NULL;
								if (field->access == VALA_MEMBER_ACCESSIBILITY_PRIVATE) {
									ValaCCodeExpression* __temp1044 = NULL;
									inst = (__temp1044 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (typed_inst, "priv")), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), __temp1044);
								} else {
									ValaCCodeExpression* __temp1046 = NULL;
									ValaCCodeExpression* __temp1045 = NULL;
									inst = (__temp1046 = (__temp1045 = typed_inst, (__temp1045 == NULL ? NULL : g_object_ref (__temp1045))), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), __temp1046);
								}
								if (vala_data_type_is_reference_type ((VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (field)))))))) {
									ValaCCodeExpression* __temp1047 = NULL;
									length_expr = (__temp1047 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (inst, length_cname)), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), __temp1047);
								} else {
									ValaCCodeExpression* __temp1048 = NULL;
									length_expr = (__temp1048 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new (inst, length_cname, FALSE)), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), __temp1048);
								}
								(typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL)));
								(inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL)));
							} else {
								ValaCCodeExpression* __temp1049 = NULL;
								length_expr = (__temp1049 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (length_cname)), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), __temp1049);
							}
							if (is_out) {
								ValaCCodeUnaryExpression* __temp1050 = NULL;
								return VALA_CCODE_EXPRESSION ((__temp1050 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, length_expr), (length_cname = (g_free (length_cname), NULL)), (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), __temp1050));
							} else {
								ValaCCodeExpression* __temp1051 = NULL;
								return (__temp1051 = length_expr, (length_cname = (g_free (length_cname), NULL)), (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), __temp1051);
							}
							(length_cname = (g_free (length_cname), NULL));
							(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
							(pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL)));
							(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
							(length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL)));
						}
						(field == NULL ? NULL : (field = (g_object_unref (field), NULL)));
					}
				}
			}
		}
	}
	/* if we reach this point we were not able to get the explicit length of the array
	 * this is not allowed for an array of non-reference-type structs
	 */
	if (VALA_IS_STRUCT (vala_array_get_element_type ((VALA_ARRAY (vala_type_reference_get_data_type (vala_expression_get_static_type (array_expr))))))) {
		ValaStruct* __temp1052 = NULL;
		ValaStruct* s = (__temp1052 = VALA_STRUCT (vala_array_get_element_type ((VALA_ARRAY (vala_type_reference_get_data_type (vala_expression_get_static_type (array_expr)))))), (__temp1052 == NULL ? NULL : g_object_ref (__temp1052)));
		if (!vala_data_type_is_reference_type (VALA_DATA_TYPE (s))) {
			(vala_code_node_set_error (VALA_CODE_NODE (array_expr), TRUE), vala_code_node_get_error (VALA_CODE_NODE (array_expr)));
			vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (array_expr)), "arrays of value-type structs with no explicit length parameter are not supported");
		}
		(s == NULL ? NULL : (s = (g_object_unref (s), NULL)));
	}
	if (!is_out) {
		return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("-1"));
	} else {
		return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"));
	}
}


static void vala_code_generator_real_visit_end_invocation_expression (ValaCodeVisitor* base, ValaInvocationExpression* expr)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_INVOCATION_EXPRESSION (expr));
	ValaCCodeFunctionCall* ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_invocation_expression_get_call (expr)))));
	ValaMethod* m = NULL;
	GList* params = NULL;
	if (!(VALA_IS_MEMBER_ACCESS (vala_invocation_expression_get_call (expr)))) {
		(vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE), vala_code_node_get_error (VALA_CODE_NODE (expr)));
		vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), "unsupported method invocation");
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
		(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
		return;
	}
	ValaMemberAccess* __temp1055 = NULL;
	ValaMemberAccess* ma = (__temp1055 = VALA_MEMBER_ACCESS (vala_invocation_expression_get_call (expr)), (__temp1055 == NULL ? NULL : g_object_ref (__temp1055)));
	if (VALA_IS_INVOKABLE (vala_symbol_get_node (vala_expression_get_symbol_reference (vala_invocation_expression_get_call (expr))))) {
		ValaInvokable* __temp1056 = NULL;
		ValaInvokable* i = (__temp1056 = VALA_INVOKABLE (vala_symbol_get_node (vala_expression_get_symbol_reference (vala_invocation_expression_get_call (expr)))), (__temp1056 == NULL ? NULL : g_object_ref (__temp1056)));
		GList* __temp1057 = NULL;
		params = (__temp1057 = vala_invokable_get_parameters (i), (params == NULL ? NULL : (params = (g_list_free (params), NULL))), __temp1057);
		if (VALA_IS_METHOD (i)) {
			ValaMethod* __temp1059 = NULL;
			ValaMethod* __temp1058 = NULL;
			m = (__temp1059 = (__temp1058 = VALA_METHOD (i), (__temp1058 == NULL ? NULL : g_object_ref (__temp1058))), (m == NULL ? NULL : (m = (g_object_unref (m), NULL))), __temp1059);
		} else {
			if (VALA_IS_SIGNAL (i)) {
				ValaCCodeFunctionCall* __temp1061 = NULL;
				ValaCCodeFunctionCall* __temp1060 = NULL;
				ccall = (__temp1061 = (__temp1060 = VALA_CCODE_FUNCTION_CALL (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_invocation_expression_get_call (expr)))), (__temp1060 == NULL ? NULL : g_object_ref (__temp1060))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp1061);
			}
		}
		(i == NULL ? NULL : (i = (g_object_unref (i), NULL)));
	}
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		ValaArray* __temp1062 = NULL;
		ValaArray* array = (__temp1062 = VALA_ARRAY (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (m))))), (__temp1062 == NULL ? NULL : g_object_ref (__temp1062)));
		ValaCCodeIdentifier* __temp1063 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1063 = vala_ccode_identifier_new (vala_data_type_get_cname (VALA_DATA_TYPE (array), FALSE)))));
		(__temp1063 == NULL ? NULL : (__temp1063 = (g_object_unref (__temp1063), NULL)));
		(array == NULL ? NULL : (array = (g_object_unref (array), NULL)));
	}
	/* explicitly use strong reference as ccall gets unrefed
	 * at end of inner block
	 */
	ValaCCodeExpression* instance = NULL;
	if (m != NULL && vala_method_get_instance (m)) {
		ValaMethod* __temp1064 = NULL;
		ValaMethod* base_method = (__temp1064 = m, (__temp1064 == NULL ? NULL : g_object_ref (__temp1064)));
		if (vala_method_get_base_interface_method (m) != NULL) {
			ValaMethod* __temp1066 = NULL;
			ValaMethod* __temp1065 = NULL;
			base_method = (__temp1066 = (__temp1065 = vala_method_get_base_interface_method (m), (__temp1065 == NULL ? NULL : g_object_ref (__temp1065))), (base_method == NULL ? NULL : (base_method = (g_object_unref (base_method), NULL))), __temp1066);
		} else {
			if (vala_method_get_base_method (m) != NULL) {
				ValaMethod* __temp1068 = NULL;
				ValaMethod* __temp1067 = NULL;
				base_method = (__temp1068 = (__temp1067 = vala_method_get_base_method (m), (__temp1067 == NULL ? NULL : g_object_ref (__temp1067))), (base_method == NULL ? NULL : (base_method = (g_object_unref (base_method), NULL))), __temp1068);
			}
		}
		gboolean req_cast = FALSE;
		if (vala_member_access_get_inner (ma) == NULL) {
			ValaCCodeExpression* __temp1069 = NULL;
			instance = (__temp1069 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), __temp1069);
			/* require casts for overriden and inherited methods */
			req_cast = vala_method_get_overrides (m) || vala_method_get_base_interface_method (m) != NULL || (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (m))) != self->priv->current_type_symbol);
		} else {
			ValaCCodeExpression* __temp1071 = NULL;
			ValaCCodeExpression* __temp1070 = NULL;
			instance = (__temp1071 = (__temp1070 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))), (__temp1070 == NULL ? NULL : g_object_ref (__temp1070))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), __temp1071);
			/* reqiure casts if the type of the used instance is
			 * different than the type which declared the method */
			req_cast = vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (base_method)))) != VALA_CODE_NODE (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_member_access_get_inner (ma))));
		}
		if (vala_method_get_instance_by_reference (m) && (vala_member_access_get_inner (ma) != NULL || vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (m))) != self->priv->current_type_symbol)) {
			ValaCCodeExpression* __temp1072 = NULL;
			instance = (__temp1072 = VALA_CCODE_EXPRESSION (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, instance)), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), __temp1072);
		}
		if (req_cast && vala_data_type_is_reference_type ((VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (m)))))))) {
			/* FIXME: use C cast if debugging disabled*/
			ValaCCodeFunctionCall* ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname ((VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (base_method)))))), NULL))));
			vala_ccode_function_call_add_argument (ccall, instance);
			ValaCCodeExpression* __temp1074 = NULL;
			ValaCCodeFunctionCall* __temp1073 = NULL;
			instance = (__temp1074 = VALA_CCODE_EXPRESSION ((__temp1073 = ccall, (__temp1073 == NULL ? NULL : g_object_ref (__temp1073)))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), __temp1074);
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		}
		if (!vala_method_get_instance_last (m)) {
			vala_ccode_function_call_add_argument (ccall, instance);
		}
		(base_method == NULL ? NULL : (base_method = (g_object_unref (base_method), NULL)));
	}
	gboolean ellipsis = FALSE;
	gint i = 1;
	GList* params_it = params;
	{
		GList* __temp1085 = NULL;
		__temp1085 = vala_invocation_expression_get_argument_list (expr);
		GList* arg_it;
		for (arg_it = __temp1085; arg_it != NULL; arg_it = arg_it->next) {
			ValaExpression* arg = arg_it->data;
			{
				/* explicitly use strong reference as ccall gets
				 * unrefed at end of inner block
				 */
				ValaCCodeExpression* __temp1075 = NULL;
				ValaCCodeExpression* cexpr = (__temp1075 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (arg))), (__temp1075 == NULL ? NULL : g_object_ref (__temp1075)));
				if (params_it != NULL) {
					ValaFormalParameter* __temp1076 = NULL;
					ValaFormalParameter* param = (__temp1076 = VALA_FORMAL_PARAMETER (params_it->data), (__temp1076 == NULL ? NULL : g_object_ref (__temp1076)));
					ellipsis = vala_formal_parameter_get_ellipsis (param);
					if (!ellipsis) {
						if (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))) && vala_type_reference_get_data_type (vala_expression_get_static_type (arg)) != NULL) {
							if (!vala_formal_parameter_get_no_array_length (param) && VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)))) {
								ValaArray* __temp1077 = NULL;
								ValaArray* arr = (__temp1077 = VALA_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))), (__temp1077 == NULL ? NULL : g_object_ref (__temp1077)));
								{
									gint dim = 0;
									for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
										ValaCCodeExpression* __temp1078 = NULL;
										vala_ccode_function_call_add_argument (ccall, (__temp1078 = vala_code_generator_get_array_length_cexpression (self, arg, dim)));
										(__temp1078 = (g_object_unref (__temp1078), NULL));
									}
								}
								(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
							}
							if (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)) != vala_type_reference_get_data_type (vala_expression_get_static_type (arg))) {
								/* FIXME: use C cast if debugging disabled*/
								ValaCCodeFunctionCall* ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)), NULL))));
								vala_ccode_function_call_add_argument (ccall, cexpr);
								ValaCCodeExpression* __temp1080 = NULL;
								ValaCCodeFunctionCall* __temp1079 = NULL;
								cexpr = (__temp1080 = VALA_CCODE_EXPRESSION ((__temp1079 = ccall, (__temp1079 == NULL ? NULL : g_object_ref (__temp1079)))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), __temp1080);
								(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
							}
						} else {
							if (VALA_IS_CALLBACK (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)))) {
								ValaCCodeExpression* __temp1081 = NULL;
								cexpr = (__temp1081 = VALA_CCODE_EXPRESSION (vala_ccode_cast_expression_new (cexpr, vala_data_type_get_cname (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)), FALSE))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), __temp1081);
							} else {
								if (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)) == NULL && VALA_IS_STRUCT (vala_type_reference_get_data_type (vala_expression_get_static_type (arg)))) {
									/* convert integer to pointer if this is a generic method parameter */
									ValaStruct* __temp1082 = NULL;
									ValaStruct* st = (__temp1082 = VALA_STRUCT (vala_type_reference_get_data_type (vala_expression_get_static_type (arg))), (__temp1082 == NULL ? NULL : g_object_ref (__temp1082)));
									if (VALA_DATA_TYPE (st) == vala_type_reference_get_data_type (self->priv->bool_type) || vala_struct_is_integer_type (st)) {
										ValaCCodeFunctionCall* cconv = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("GINT_TO_POINTER")));
										vala_ccode_function_call_add_argument (cconv, cexpr);
										ValaCCodeExpression* __temp1084 = NULL;
										ValaCCodeFunctionCall* __temp1083 = NULL;
										cexpr = (__temp1084 = VALA_CCODE_EXPRESSION ((__temp1083 = cconv, (__temp1083 == NULL ? NULL : g_object_ref (__temp1083)))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), __temp1084);
										(cconv == NULL ? NULL : (cconv = (g_object_unref (cconv), NULL)));
									}
									(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
								}
							}
						}
					}
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
				}
				vala_ccode_function_call_add_argument (ccall, cexpr);
				i++;
				if (params_it != NULL) {
					params_it = params_it->next;
				}
				(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
			}
		}
		(__temp1085 == NULL ? NULL : (__temp1085 = (g_list_free (__temp1085), NULL)));
	}
	while (params_it != NULL) {
		ValaFormalParameter* __temp1086 = NULL;
		ValaFormalParameter* param = (__temp1086 = VALA_FORMAL_PARAMETER (params_it->data), (__temp1086 == NULL ? NULL : g_object_ref (__temp1086)));
		if (vala_formal_parameter_get_ellipsis (param)) {
			ellipsis = TRUE;
			break;
		}
		if (vala_formal_parameter_get_default_expression (param) == NULL) {
			char* __temp1087 = NULL;
			vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), (__temp1087 = g_strdup_printf ("no default expression for argument %d", i)));
			(__temp1087 = (g_free (__temp1087), NULL));
			(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
			(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
			(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
			(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
			return;
		}
		/* evaluate default expression here as the code
		 * generator might not have visited the formal
		 * parameter yet */
		vala_code_node_accept (VALA_CODE_NODE (vala_formal_parameter_get_default_expression (param)), VALA_CODE_VISITOR (self));
		if (!vala_formal_parameter_get_no_array_length (param) && vala_formal_parameter_get_type_reference (param) != NULL && VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)))) {
			ValaArray* __temp1088 = NULL;
			ValaArray* arr = (__temp1088 = VALA_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))), (__temp1088 == NULL ? NULL : g_object_ref (__temp1088)));
			{
				gint dim = 0;
				for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
					ValaCCodeExpression* __temp1089 = NULL;
					vala_ccode_function_call_add_argument (ccall, (__temp1089 = vala_code_generator_get_array_length_cexpression (self, vala_formal_parameter_get_default_expression (param), dim)));
					(__temp1089 = (g_object_unref (__temp1089), NULL));
				}
			}
			(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
		}
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_formal_parameter_get_default_expression (param)))));
		i++;
		params_it = params_it->next;
		(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
	}
	if (m != NULL && vala_method_get_instance (m) && vala_method_get_instance_last (m)) {
		vala_ccode_function_call_add_argument (ccall, instance);
	} else {
		if (ellipsis) {
			/* ensure variable argument list ends with NULL
			 * except when using printf-style arguments */
			if (m == NULL || !vala_method_get_printf_format (m)) {
				ValaCCodeConstant* __temp1090 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1090 = vala_ccode_constant_new ("NULL"))));
				(__temp1090 == NULL ? NULL : (__temp1090 = (g_object_unref (__temp1090), NULL)));
			}
		}
	}
	if (m != NULL && vala_method_get_instance (m) && vala_method_get_returns_modified_pointer (m)) {
		ValaCCodeAssignment* __temp1091 = NULL;
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1091 = vala_ccode_assignment_new (instance, VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		(__temp1091 == NULL ? NULL : (__temp1091 = (g_object_unref (__temp1091), NULL)));
	} else {
		/* cast pointer to actual type if this is a generic method return value */
		if (m != NULL && vala_type_reference_get_type_parameter (vala_method_get_return_type (m)) != NULL && vala_type_reference_get_data_type (vala_expression_get_static_type (VALA_EXPRESSION (expr))) != NULL) {
			if (VALA_IS_STRUCT (vala_type_reference_get_data_type (vala_expression_get_static_type (VALA_EXPRESSION (expr))))) {
				ValaStruct* __temp1092 = NULL;
				ValaStruct* st = (__temp1092 = VALA_STRUCT (vala_type_reference_get_data_type (vala_expression_get_static_type (VALA_EXPRESSION (expr)))), (__temp1092 == NULL ? NULL : g_object_ref (__temp1092)));
				if (VALA_DATA_TYPE (st) == vala_type_reference_get_data_type (self->priv->uint_type)) {
					ValaCCodeFunctionCall* cconv = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("GPOINTER_TO_UINT")));
					vala_ccode_function_call_add_argument (cconv, VALA_CCODE_EXPRESSION (ccall));
					ValaCCodeFunctionCall* __temp1094 = NULL;
					ValaCCodeFunctionCall* __temp1093 = NULL;
					ccall = (__temp1094 = (__temp1093 = cconv, (__temp1093 == NULL ? NULL : g_object_ref (__temp1093))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp1094);
					(cconv == NULL ? NULL : (cconv = (g_object_unref (cconv), NULL)));
				} else {
					if (VALA_DATA_TYPE (st) == vala_type_reference_get_data_type (self->priv->bool_type) || vala_struct_is_integer_type (st)) {
						ValaCCodeFunctionCall* cconv = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("GPOINTER_TO_INT")));
						vala_ccode_function_call_add_argument (cconv, VALA_CCODE_EXPRESSION (ccall));
						ValaCCodeFunctionCall* __temp1096 = NULL;
						ValaCCodeFunctionCall* __temp1095 = NULL;
						ccall = (__temp1096 = (__temp1095 = cconv, (__temp1095 == NULL ? NULL : g_object_ref (__temp1095))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp1096);
						(cconv == NULL ? NULL : (cconv = (g_object_unref (cconv), NULL)));
					}
				}
				(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
			}
		}
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
	}
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		/* FIXME: size expression must not be evaluated twice at runtime (potential side effects)*/
		ValaCCodeExpression* __temp1098 = NULL;
		GList* __temp1097 = NULL;
		ValaCCodeExpression* __temp1099 = NULL;
		ValaCCodeExpression* new_size = (__temp1099 = (__temp1098 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((VALA_CODE_NODE ((__temp1097 = vala_invocation_expression_get_argument_list (expr))->data)))), (__temp1098 == NULL ? NULL : g_object_ref (__temp1098))), (__temp1097 == NULL ? NULL : (__temp1097 = (g_list_free (__temp1097), NULL))), __temp1099);
		ValaVariableDeclarator* temp_decl = vala_code_generator_get_temp_variable_declarator (self, self->priv->int_type, TRUE);
		ValaCCodeIdentifier* temp_ref = vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl));
		ValaVariableDeclarator* __temp1100 = NULL;
		self->priv->temp_vars = g_list_prepend (self->priv->temp_vars, (__temp1100 = temp_decl, (__temp1100 == NULL ? NULL : g_object_ref (__temp1100))));
		/* memset needs string.h */
		self->priv->string_h_needed = TRUE;
		ValaCCodeExpression* clen = vala_code_generator_get_array_length_cexpression (self, vala_member_access_get_inner (ma), 1);
		ValaCCodeExpression* __temp1101 = NULL;
		ValaCCodeExpression* celems = (__temp1101 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))), (__temp1101 == NULL ? NULL : g_object_ref (__temp1101)));
		char* __temp1102 = NULL;
		ValaCCodeIdentifier* __temp1103 = NULL;
		ValaCCodeIdentifier* csizeof = (__temp1103 = vala_ccode_identifier_new (g_strdup_printf ("sizeof (%s)", (__temp1102 = vala_data_type_get_cname (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_member_access_get_inner (ma))), FALSE)))), (__temp1102 = (g_free (__temp1102), NULL)), __temp1103);
		ValaCCodeParenthesizedExpression* cdelta = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, VALA_CCODE_EXPRESSION (temp_ref), clen)));
		ValaCCodeBinaryExpression* ccheck = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, VALA_CCODE_EXPRESSION (temp_ref), clen);
		ValaCCodeFunctionCall* czero = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("memset")));
		ValaCCodeBinaryExpression* __temp1104 = NULL;
		vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((__temp1104 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, celems, clen))));
		(__temp1104 == NULL ? NULL : (__temp1104 = (g_object_unref (__temp1104), NULL)));
		ValaCCodeConstant* __temp1105 = NULL;
		vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((__temp1105 = vala_ccode_constant_new ("0"))));
		(__temp1105 == NULL ? NULL : (__temp1105 = (g_object_unref (__temp1105), NULL)));
		ValaCCodeBinaryExpression* __temp1106 = NULL;
		vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((__temp1106 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION (csizeof), VALA_CCODE_EXPRESSION (cdelta)))));
		(__temp1106 == NULL ? NULL : (__temp1106 = (g_object_unref (__temp1106), NULL)));
		ValaCCodeCommaExpression* ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
		ValaCCodeAssignment* __temp1107 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp1107 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (temp_ref), new_size, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(__temp1107 == NULL ? NULL : (__temp1107 = (g_object_unref (__temp1107), NULL)));
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))));
		ValaCCodeConditionalExpression* __temp1108 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp1108 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (ccheck), VALA_CCODE_EXPRESSION (czero), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"))))));
		(__temp1108 == NULL ? NULL : (__temp1108 = (g_object_unref (__temp1108), NULL)));
		ValaCCodeAssignment* __temp1109 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp1109 = vala_ccode_assignment_new (vala_code_generator_get_array_length_cexpression (self, vala_member_access_get_inner (ma), 1), VALA_CCODE_EXPRESSION (temp_ref), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(__temp1109 == NULL ? NULL : (__temp1109 = (g_object_unref (__temp1109), NULL)));
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		(new_size == NULL ? NULL : (new_size = (g_object_unref (new_size), NULL)));
		(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
		(temp_ref == NULL ? NULL : (temp_ref = (g_object_unref (temp_ref), NULL)));
		(clen = (g_object_unref (clen), NULL));
		(celems == NULL ? NULL : (celems = (g_object_unref (celems), NULL)));
		(csizeof == NULL ? NULL : (csizeof = (g_object_unref (csizeof), NULL)));
		(cdelta == NULL ? NULL : (cdelta = (g_object_unref (cdelta), NULL)));
		(ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL)));
		(czero == NULL ? NULL : (czero = (g_object_unref (czero), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
	}
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
	(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
	(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
	(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
}


static void vala_code_generator_real_visit_element_access (ValaCodeVisitor* base, ValaElementAccess* expr)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_ELEMENT_ACCESS (expr));
	GList* indices = vala_element_access_get_indices (expr);
	gint rank = g_list_length (indices);
	if (rank == 1) {
		/* FIXME: had to add Expression cast due to possible compiler bug */
		ValaCCodeElementAccess* __temp1110 = NULL;
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1110 = vala_ccode_element_access_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_element_access_get_container (expr)))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE ((VALA_EXPRESSION (g_list_first (indices)->data))))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		(__temp1110 == NULL ? NULL : (__temp1110 = (g_object_unref (__temp1110), NULL)));
	} else {
		(vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE), vala_code_node_get_error (VALA_CODE_NODE (expr)));
		vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), "Arrays with more then one dimension are not supported yet");
		(indices == NULL ? NULL : (indices = (g_list_free (indices), NULL)));
		return;
	}
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
	(indices == NULL ? NULL : (indices = (g_list_free (indices), NULL)));
}


static void vala_code_generator_real_visit_base_access (ValaCodeVisitor* base, ValaBaseAccess* expr)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_BASE_ACCESS (expr));
	ValaInstanceCast* __temp1111 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1111 = vala_instance_cast_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), vala_type_reference_get_data_type (vala_expression_get_static_type (VALA_EXPRESSION (expr))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp1111 == NULL ? NULL : (__temp1111 = (g_object_unref (__temp1111), NULL)));
}


static void vala_code_generator_real_visit_postfix_expression (ValaCodeVisitor* base, ValaPostfixExpression* expr)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_POSTFIX_EXPRESSION (expr));
	ValaMemberAccess* ma = vala_code_generator_find_property_access (self, vala_postfix_expression_get_inner (expr));
	if (ma != NULL) {
		/* property postfix expression*/
		ValaProperty* __temp1112 = NULL;
		ValaProperty* prop = (__temp1112 = VALA_PROPERTY (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (ma)))), (__temp1112 == NULL ? NULL : g_object_ref (__temp1112)));
		ValaCCodeCommaExpression* ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
		/* assign current value to temp variable*/
		ValaVariableDeclarator* temp_decl = vala_code_generator_get_temp_variable_declarator (self, vala_property_get_type_reference (prop), TRUE);
		ValaVariableDeclarator* __temp1113 = NULL;
		self->priv->temp_vars = g_list_prepend (self->priv->temp_vars, (__temp1113 = temp_decl, (__temp1113 == NULL ? NULL : g_object_ref (__temp1113))));
		ValaCCodeAssignment* __temp1114 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp1114 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_postfix_expression_get_inner (expr)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(__temp1114 == NULL ? NULL : (__temp1114 = (g_object_unref (__temp1114), NULL)));
		/* increment/decrement property*/
		ValaCCodeBinaryOperator op = (vala_postfix_expression_get_increment (expr) ? VALA_CCODE_BINARY_OPERATOR_PLUS : VALA_CCODE_BINARY_OPERATOR_MINUS);
		ValaCCodeBinaryExpression* cexpr = vala_ccode_binary_expression_new (op, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl))), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("1")));
		ValaCCodeFunctionCall* ccall = vala_code_generator_get_property_set_call (self, prop, ma, VALA_CCODE_EXPRESSION (cexpr));
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
		/* return previous value*/
		ValaCCodeIdentifier* __temp1115 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp1115 = vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl)))));
		(__temp1115 == NULL ? NULL : (__temp1115 = (g_object_unref (__temp1115), NULL)));
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
		(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
		return;
		(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
		(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	}
	ValaCCodeUnaryOperator op = (vala_postfix_expression_get_increment (expr) ? VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT : VALA_CCODE_UNARY_OPERATOR_POSTFIX_DECREMENT);
	ValaCCodeUnaryExpression* __temp1116 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1116 = vala_ccode_unary_expression_new (op, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_postfix_expression_get_inner (expr)))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp1116 == NULL ? NULL : (__temp1116 = (g_object_unref (__temp1116), NULL)));
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
	(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
}


static ValaMemberAccess* vala_code_generator_find_property_access (ValaCodeGenerator* self, ValaExpression* expr)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (expr), NULL);
	if (VALA_IS_PARENTHESIZED_EXPRESSION (expr)) {
		ValaParenthesizedExpression* __temp1117 = NULL;
		ValaParenthesizedExpression* pe = (__temp1117 = VALA_PARENTHESIZED_EXPRESSION (expr), (__temp1117 == NULL ? NULL : g_object_ref (__temp1117)));
		ValaMemberAccess* __temp1118 = NULL;
		return (__temp1118 = vala_code_generator_find_property_access (self, vala_parenthesized_expression_get_inner (pe)), (pe == NULL ? NULL : (pe = (g_object_unref (pe), NULL))), __temp1118);
		(pe == NULL ? NULL : (pe = (g_object_unref (pe), NULL)));
	}
	if (!(VALA_IS_MEMBER_ACCESS (expr))) {
		return VALA_MEMBER_ACCESS (NULL);
	}
	ValaMemberAccess* __temp1120 = NULL;
	ValaMemberAccess* ma = (__temp1120 = VALA_MEMBER_ACCESS (expr), (__temp1120 == NULL ? NULL : g_object_ref (__temp1120)));
	if (VALA_IS_PROPERTY (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (ma))))) {
		return ma;
	}
	gpointer __temp1122;
	return VALA_MEMBER_ACCESS ((__temp1122 = NULL, (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), __temp1122));
	(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
}


static ValaCCodeExpression* vala_code_generator_get_ref_expression (ValaCodeGenerator* self, ValaExpression* expr)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (expr), NULL);
	/* (temp = expr, temp == NULL ? NULL : ref (temp))
	 *
	 * can be simplified to
	 * ref (expr)
	 * if static type of expr is non-null
	 */
	if (vala_type_reference_get_data_type (vala_expression_get_static_type (expr)) == NULL && vala_type_reference_get_type_parameter (vala_expression_get_static_type (expr)) != NULL) {
		vala_report_warning (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), "Missing generics support for memory management");
		ValaCCodeExpression* __temp1123 = NULL;
		return (__temp1123 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))), (__temp1123 == NULL ? NULL : g_object_ref (__temp1123)));
	}
	char* ref_function = NULL;
	if (vala_data_type_is_reference_counting (vala_type_reference_get_data_type (vala_expression_get_static_type (expr)))) {
		char* __temp1125 = NULL;
		ref_function = (__temp1125 = vala_data_type_get_ref_function (vala_type_reference_get_data_type (vala_expression_get_static_type (expr))), (ref_function = (g_free (ref_function), NULL)), __temp1125);
	} else {
		if (vala_type_reference_get_data_type (vala_expression_get_static_type (expr)) != vala_type_reference_get_data_type (self->priv->string_type)) {
			/* duplicating non-reference counted structs may cause side-effects (and performance issues)*/
			char* __temp1126 = NULL;
			vala_report_warning (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), (__temp1126 = g_strdup_printf ("duplicating %s instance, use weak variable or explicitly invoke copy method", vala_data_type_get_name (vala_type_reference_get_data_type (vala_expression_get_static_type (expr))))));
			(__temp1126 = (g_free (__temp1126), NULL));
		}
		char* __temp1127 = NULL;
		ref_function = (__temp1127 = vala_data_type_get_dup_function (vala_type_reference_get_data_type (vala_expression_get_static_type (expr))), (ref_function = (g_free (ref_function), NULL)), __temp1127);
	}
	ValaCCodeFunctionCall* ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (ref_function)));
	if (vala_type_reference_get_non_null (vala_expression_get_static_type (expr))) {
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))));
		ValaCCodeFunctionCall* __temp1128 = NULL;
		return VALA_CCODE_EXPRESSION ((__temp1128 = ccall, (ref_function = (g_free (ref_function), NULL)), __temp1128));
	} else {
		ValaVariableDeclarator* decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (expr), FALSE);
		ValaVariableDeclarator* __temp1129 = NULL;
		self->priv->temp_vars = g_list_prepend (self->priv->temp_vars, (__temp1129 = decl, (__temp1129 == NULL ? NULL : g_object_ref (__temp1129))));
		ValaCCodeIdentifier* ctemp = vala_ccode_identifier_new (vala_variable_declarator_get_name (decl));
		ValaCCodeBinaryExpression* cisnull = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION (ctemp), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")));
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ctemp));
		ValaCCodeCommaExpression* ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
		ValaCCodeAssignment* __temp1130 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp1130 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (ctemp), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(__temp1130 == NULL ? NULL : (__temp1130 = (g_object_unref (__temp1130), NULL)));
		if (g_utf8_collate (ref_function, "g_list_copy") == 0) {
			gboolean is_ref = FALSE;
			gboolean is_class = FALSE;
			gboolean is_interface = FALSE;
			{
				GList* __temp1131 = NULL;
				__temp1131 = vala_type_reference_get_type_arguments (vala_expression_get_static_type (expr));
				GList* type_arg_it;
				for (type_arg_it = __temp1131; type_arg_it != NULL; type_arg_it = type_arg_it->next) {
					ValaTypeReference* type_arg = type_arg_it->data;
					{
						is_ref = is_ref | (vala_type_reference_get_takes_ownership (type_arg));
						is_class = is_class | (VALA_IS_CLASS (vala_type_reference_get_data_type (type_arg)));
						is_interface = is_interface | (VALA_IS_INTERFACE (vala_type_reference_get_data_type (type_arg)));
					}
				}
				(__temp1131 == NULL ? NULL : (__temp1131 = (g_list_free (__temp1131), NULL)));
			}
			if (is_ref && (is_class || is_interface)) {
				ValaCCodeFunctionCall* crefcall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_list_foreach")));
				vala_ccode_function_call_add_argument (crefcall, VALA_CCODE_EXPRESSION (ctemp));
				ValaCCodeIdentifier* __temp1132 = NULL;
				vala_ccode_function_call_add_argument (crefcall, VALA_CCODE_EXPRESSION ((__temp1132 = vala_ccode_identifier_new ("(GFunc) g_object_ref"))));
				(__temp1132 == NULL ? NULL : (__temp1132 = (g_object_unref (__temp1132), NULL)));
				ValaCCodeConstant* __temp1133 = NULL;
				vala_ccode_function_call_add_argument (crefcall, VALA_CCODE_EXPRESSION ((__temp1133 = vala_ccode_constant_new ("NULL"))));
				(__temp1133 == NULL ? NULL : (__temp1133 = (g_object_unref (__temp1133), NULL)));
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (crefcall));
				(crefcall == NULL ? NULL : (crefcall = (g_object_unref (crefcall), NULL)));
			}
		}
		ValaCCodeConditionalExpression* __temp1134 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp1134 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (cisnull), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")), VALA_CCODE_EXPRESSION (ccall)))));
		(__temp1134 == NULL ? NULL : (__temp1134 = (g_object_unref (__temp1134), NULL)));
		ValaCCodeCommaExpression* __temp1135 = NULL;
		return VALA_CCODE_EXPRESSION ((__temp1135 = ccomma, (decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL))), (ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL))), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), __temp1135));
		(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
		(ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL)));
		(cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
	}
	(ref_function = (g_free (ref_function), NULL));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
}


static void vala_code_generator_visit_expression (ValaCodeGenerator* self, ValaExpression* expr)
{
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_EXPRESSION (expr));
	if (vala_expression_get_static_type (expr) != NULL && vala_type_reference_get_transfers_ownership (vala_expression_get_static_type (expr)) && vala_type_reference_get_floating_reference (vala_expression_get_static_type (expr))) {
		/* constructor of GInitiallyUnowned subtype
		 * returns floating reference, sink it
		 */
		ValaCCodeFunctionCall* csink = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_object_ref_sink")));
		vala_ccode_function_call_add_argument (csink, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))));
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (csink)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		(csink == NULL ? NULL : (csink = (g_object_unref (csink), NULL)));
	}
	if (vala_expression_get_ref_leaked (expr)) {
		ValaVariableDeclarator* decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (expr), TRUE);
		ValaVariableDeclarator* __temp1136 = NULL;
		self->priv->temp_vars = g_list_prepend (self->priv->temp_vars, (__temp1136 = decl, (__temp1136 == NULL ? NULL : g_object_ref (__temp1136))));
		ValaVariableDeclarator* __temp1137 = NULL;
		self->priv->temp_ref_vars = g_list_prepend (self->priv->temp_ref_vars, (__temp1137 = decl, (__temp1137 == NULL ? NULL : g_object_ref (__temp1137))));
		ValaCCodeParenthesizedExpression* __temp1138 = NULL;
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1138 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (decl))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		(__temp1138 == NULL ? NULL : (__temp1138 = (g_object_unref (__temp1138), NULL)));
		(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
	} else {
		if (vala_expression_get_ref_missing (expr)) {
			ValaCCodeExpression* __temp1139 = NULL;
			(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1139 = vala_code_generator_get_ref_expression (self, expr)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
			(__temp1139 == NULL ? NULL : (__temp1139 = (g_object_unref (__temp1139), NULL)));
		}
	}
}


static void vala_code_generator_real_visit_end_object_creation_expression (ValaCodeVisitor* base, ValaObjectCreationExpression* expr)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_OBJECT_CREATION_EXPRESSION (expr));
	if (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)) == NULL) {
		/* no creation method*/
		if (VALA_IS_CLASS (vala_type_reference_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
			ValaCCodeFunctionCall* ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_object_new")));
			ValaCCodeConstant* __temp1140 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1140 = vala_ccode_constant_new (vala_data_type_get_type_id (vala_type_reference_get_data_type (vala_object_creation_expression_get_type_reference (expr)))))));
			(__temp1140 == NULL ? NULL : (__temp1140 = (g_object_unref (__temp1140), NULL)));
			ValaCCodeConstant* __temp1141 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1141 = vala_ccode_constant_new ("NULL"))));
			(__temp1141 == NULL ? NULL : (__temp1141 = (g_object_unref (__temp1141), NULL)));
			(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		} else {
			if (vala_type_reference_get_data_type (vala_object_creation_expression_get_type_reference (expr)) == self->priv->list_type || vala_type_reference_get_data_type (vala_object_creation_expression_get_type_reference (expr)) == self->priv->slist_type) {
				/* NULL is an empty list*/
				ValaCCodeConstant* __temp1142 = NULL;
				(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1142 = vala_ccode_constant_new ("NULL")))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
				(__temp1142 == NULL ? NULL : (__temp1142 = (g_object_unref (__temp1142), NULL)));
			} else {
				ValaCCodeFunctionCall* ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_new0")));
				ValaCCodeConstant* __temp1143 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1143 = vala_ccode_constant_new (vala_data_type_get_cname (vala_type_reference_get_data_type (vala_object_creation_expression_get_type_reference (expr)), FALSE)))));
				(__temp1143 == NULL ? NULL : (__temp1143 = (g_object_unref (__temp1143), NULL)));
				ValaCCodeConstant* __temp1144 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1144 = vala_ccode_constant_new ("1"))));
				(__temp1144 == NULL ? NULL : (__temp1144 = (g_object_unref (__temp1144), NULL)));
				(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
				(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			}
		}
	} else {
		/* use creation method*/
		ValaMethod* __temp1145 = NULL;
		ValaMethod* m = (__temp1145 = VALA_METHOD (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))), (__temp1145 == NULL ? NULL : g_object_ref (__temp1145)));
		GList* params = vala_invokable_get_parameters (VALA_INVOKABLE (m));
		ValaCCodeFunctionCall* ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_method_get_cname (m))));
		if (VALA_IS_CLASS (vala_type_reference_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
			{
				GList* __temp1148 = NULL;
				__temp1148 = vala_type_reference_get_type_arguments (vala_object_creation_expression_get_type_reference (expr));
				GList* type_arg_it;
				for (type_arg_it = __temp1148; type_arg_it != NULL; type_arg_it = type_arg_it->next) {
					ValaTypeReference* type_arg = type_arg_it->data;
					{
						if (vala_type_reference_get_takes_ownership (type_arg)) {
							ValaCCodeExpression* __temp1146 = NULL;
							vala_ccode_function_call_add_argument (ccall, (__temp1146 = vala_code_generator_get_destroy_func_expression (self, type_arg)));
							(__temp1146 == NULL ? NULL : (__temp1146 = (g_object_unref (__temp1146), NULL)));
						} else {
							ValaCCodeConstant* __temp1147 = NULL;
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1147 = vala_ccode_constant_new ("NULL"))));
							(__temp1147 == NULL ? NULL : (__temp1147 = (g_object_unref (__temp1147), NULL)));
						}
					}
				}
				(__temp1148 == NULL ? NULL : (__temp1148 = (g_list_free (__temp1148), NULL)));
			}
		}
		gboolean ellipsis = FALSE;
		gint i = 1;
		GList* params_it = params;
		{
			GList* __temp1153 = NULL;
			__temp1153 = vala_object_creation_expression_get_argument_list (expr);
			GList* arg_it;
			for (arg_it = __temp1153; arg_it != NULL; arg_it = arg_it->next) {
				ValaExpression* arg = arg_it->data;
				{
					/* explicitly use strong reference as ccall gets
					 * unrefed at end of inner block
					 */
					ValaCCodeExpression* __temp1149 = NULL;
					ValaCCodeExpression* cexpr = (__temp1149 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (arg))), (__temp1149 == NULL ? NULL : g_object_ref (__temp1149)));
					if (params_it != NULL) {
						ValaFormalParameter* __temp1150 = NULL;
						ValaFormalParameter* param = (__temp1150 = VALA_FORMAL_PARAMETER (params_it->data), (__temp1150 == NULL ? NULL : g_object_ref (__temp1150)));
						ellipsis = vala_formal_parameter_get_ellipsis (param);
						if (!vala_formal_parameter_get_ellipsis (param) && vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))) && vala_type_reference_get_data_type (vala_expression_get_static_type (arg)) != NULL && vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)) != vala_type_reference_get_data_type (vala_expression_get_static_type (arg))) {
							/* FIXME: use C cast if debugging disabled*/
							ValaCCodeFunctionCall* ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)), NULL))));
							vala_ccode_function_call_add_argument (ccall, cexpr);
							ValaCCodeExpression* __temp1152 = NULL;
							ValaCCodeFunctionCall* __temp1151 = NULL;
							cexpr = (__temp1152 = VALA_CCODE_EXPRESSION ((__temp1151 = ccall, (__temp1151 == NULL ? NULL : g_object_ref (__temp1151)))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), __temp1152);
							(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
						}
						(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
					}
					vala_ccode_function_call_add_argument (ccall, cexpr);
					i++;
					if (params_it != NULL) {
						params_it = params_it->next;
					}
					(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
				}
			}
			(__temp1153 == NULL ? NULL : (__temp1153 = (g_list_free (__temp1153), NULL)));
		}
		while (params_it != NULL) {
			ValaFormalParameter* __temp1154 = NULL;
			ValaFormalParameter* param = (__temp1154 = VALA_FORMAL_PARAMETER (params_it->data), (__temp1154 == NULL ? NULL : g_object_ref (__temp1154)));
			if (vala_formal_parameter_get_ellipsis (param)) {
				ellipsis = TRUE;
				break;
			}
			if (vala_formal_parameter_get_default_expression (param) == NULL) {
				char* __temp1155 = NULL;
				vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), (__temp1155 = g_strdup_printf ("no default expression for argument %d", i)));
				(__temp1155 = (g_free (__temp1155), NULL));
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
				(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
				(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
				(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
				return;
			}
			/* evaluate default expression here as the code
			 * generator might not have visited the formal
			 * parameter yet */
			vala_code_node_accept (VALA_CODE_NODE (vala_formal_parameter_get_default_expression (param)), VALA_CODE_VISITOR (self));
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_formal_parameter_get_default_expression (param)))));
			i++;
			params_it = params_it->next;
			(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
		}
		if (ellipsis) {
			/* ensure variable argument list ends with NULL*/
			ValaCCodeConstant* __temp1156 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1156 = vala_ccode_constant_new ("NULL"))));
			(__temp1156 == NULL ? NULL : (__temp1156 = (g_object_unref (__temp1156), NULL)));
		}
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
		(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	}
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static void vala_code_generator_real_visit_typeof_expression (ValaCodeVisitor* base, ValaTypeofExpression* expr)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_TYPEOF_EXPRESSION (expr));
	ValaCCodeIdentifier* __temp1157 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1157 = vala_ccode_identifier_new (vala_data_type_get_type_id (vala_type_reference_get_data_type (vala_typeof_expression_get_type_reference (expr))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp1157 == NULL ? NULL : (__temp1157 = (g_object_unref (__temp1157), NULL)));
}


static void vala_code_generator_real_visit_unary_expression (ValaCodeVisitor* base, ValaUnaryExpression* expr)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_UNARY_EXPRESSION (expr));
	ValaCCodeUnaryOperator op;
	if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_PLUS) {
		op = VALA_CCODE_UNARY_OPERATOR_PLUS;
	} else {
		if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_MINUS) {
			op = VALA_CCODE_UNARY_OPERATOR_MINUS;
		} else {
			if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_LOGICAL_NEGATION) {
				op = VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION;
			} else {
				if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT) {
					op = VALA_CCODE_UNARY_OPERATOR_BITWISE_COMPLEMENT;
				} else {
					if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_INCREMENT) {
						op = VALA_CCODE_UNARY_OPERATOR_PREFIX_INCREMENT;
					} else {
						if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_DECREMENT) {
							op = VALA_CCODE_UNARY_OPERATOR_PREFIX_DECREMENT;
						} else {
							if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_REF) {
								op = VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF;
							} else {
								if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_OUT) {
									op = VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF;
								}
							}
						}
					}
				}
			}
		}
	}
	ValaCCodeUnaryExpression* __temp1158 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1158 = vala_ccode_unary_expression_new (op, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_unary_expression_get_inner (expr)))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp1158 == NULL ? NULL : (__temp1158 = (g_object_unref (__temp1158), NULL)));
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static void vala_code_generator_real_visit_cast_expression (ValaCodeVisitor* base, ValaCastExpression* expr)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CAST_EXPRESSION (expr));
	if (VALA_IS_CLASS (vala_type_reference_get_data_type (vala_cast_expression_get_type_reference (expr))) || VALA_IS_INTERFACE (vala_type_reference_get_data_type (vala_cast_expression_get_type_reference (expr)))) {
		/* GObject cast*/
		ValaInstanceCast* __temp1159 = NULL;
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1159 = vala_instance_cast_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_cast_expression_get_inner (expr)))), vala_type_reference_get_data_type (vala_cast_expression_get_type_reference (expr)))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		(__temp1159 == NULL ? NULL : (__temp1159 = (g_object_unref (__temp1159), NULL)));
	} else {
		ValaCCodeCastExpression* __temp1160 = NULL;
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1160 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_cast_expression_get_inner (expr)))), vala_type_reference_get_cname (vala_cast_expression_get_type_reference (expr), FALSE, FALSE))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		(__temp1160 == NULL ? NULL : (__temp1160 = (g_object_unref (__temp1160), NULL)));
	}
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static void vala_code_generator_real_visit_pointer_indirection (ValaCodeVisitor* base, ValaPointerIndirection* expr)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_POINTER_INDIRECTION (expr));
	ValaCCodeUnaryExpression* __temp1161 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1161 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_pointer_indirection_get_inner (expr)))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp1161 == NULL ? NULL : (__temp1161 = (g_object_unref (__temp1161), NULL)));
}


static void vala_code_generator_real_visit_addressof_expression (ValaCodeVisitor* base, ValaAddressofExpression* expr)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_ADDRESSOF_EXPRESSION (expr));
	ValaCCodeUnaryExpression* __temp1162 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1162 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_addressof_expression_get_inner (expr)))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp1162 == NULL ? NULL : (__temp1162 = (g_object_unref (__temp1162), NULL)));
}


static void vala_code_generator_real_visit_reference_transfer_expression (ValaCodeVisitor* base, ValaReferenceTransferExpression* expr)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_REFERENCE_TRANSFER_EXPRESSION (expr));
	/* (tmp = var, var = null, tmp) */
	ValaCCodeCommaExpression* ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
	ValaVariableDeclarator* temp_decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (VALA_EXPRESSION (expr)), TRUE);
	ValaVariableDeclarator* __temp1163 = NULL;
	self->priv->temp_vars = g_list_prepend (self->priv->temp_vars, (__temp1163 = temp_decl, (__temp1163 == NULL ? NULL : g_object_ref (__temp1163))));
	ValaCCodeIdentifier* cvar = vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl));
	ValaCCodeAssignment* __temp1164 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp1164 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cvar), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_reference_transfer_expression_get_inner (expr)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
	(__temp1164 == NULL ? NULL : (__temp1164 = (g_object_unref (__temp1164), NULL)));
	ValaCCodeAssignment* __temp1165 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp1165 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_reference_transfer_expression_get_inner (expr)))), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
	(__temp1165 == NULL ? NULL : (__temp1165 = (g_object_unref (__temp1165), NULL)));
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cvar));
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
	(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
	(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
	(cvar == NULL ? NULL : (cvar = (g_object_unref (cvar), NULL)));
}


static void vala_code_generator_real_visit_binary_expression (ValaCodeVisitor* base, ValaBinaryExpression* expr)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_BINARY_EXPRESSION (expr));
	ValaCCodeBinaryOperator op;
	if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_PLUS) {
		op = VALA_CCODE_BINARY_OPERATOR_PLUS;
	} else {
		if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_MINUS) {
			op = VALA_CCODE_BINARY_OPERATOR_MINUS;
		} else {
			if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_MUL) {
				op = VALA_CCODE_BINARY_OPERATOR_MUL;
			} else {
				if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_DIV) {
					op = VALA_CCODE_BINARY_OPERATOR_DIV;
				} else {
					if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_MOD) {
						op = VALA_CCODE_BINARY_OPERATOR_MOD;
					} else {
						if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_SHIFT_LEFT) {
							op = VALA_CCODE_BINARY_OPERATOR_SHIFT_LEFT;
						} else {
							if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_SHIFT_RIGHT) {
								op = VALA_CCODE_BINARY_OPERATOR_SHIFT_RIGHT;
							} else {
								if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_LESS_THAN) {
									op = VALA_CCODE_BINARY_OPERATOR_LESS_THAN;
								} else {
									if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_GREATER_THAN) {
										op = VALA_CCODE_BINARY_OPERATOR_GREATER_THAN;
									} else {
										if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL) {
											op = VALA_CCODE_BINARY_OPERATOR_LESS_THAN_OR_EQUAL;
										} else {
											if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL) {
												op = VALA_CCODE_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL;
											} else {
												if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_EQUALITY) {
													op = VALA_CCODE_BINARY_OPERATOR_EQUALITY;
												} else {
													if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_INEQUALITY) {
														op = VALA_CCODE_BINARY_OPERATOR_INEQUALITY;
													} else {
														if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_BITWISE_AND) {
															op = VALA_CCODE_BINARY_OPERATOR_BITWISE_AND;
														} else {
															if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_BITWISE_OR) {
																op = VALA_CCODE_BINARY_OPERATOR_BITWISE_OR;
															} else {
																if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_BITWISE_XOR) {
																	op = VALA_CCODE_BINARY_OPERATOR_BITWISE_XOR;
																} else {
																	if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_AND) {
																		op = VALA_CCODE_BINARY_OPERATOR_AND;
																	} else {
																		if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_OR) {
																			op = VALA_CCODE_BINARY_OPERATOR_OR;
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	ValaCCodeExpression* __temp1166 = NULL;
	ValaCCodeExpression* cleft = (__temp1166 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_binary_expression_get_left (expr)))), (__temp1166 == NULL ? NULL : g_object_ref (__temp1166)));
	ValaCCodeExpression* __temp1167 = NULL;
	ValaCCodeExpression* cright = (__temp1167 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_binary_expression_get_right (expr)))), (__temp1167 == NULL ? NULL : g_object_ref (__temp1167)));
	if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_EQUALITY || vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_INEQUALITY) {
		if (vala_expression_get_static_type (vala_binary_expression_get_left (expr)) != NULL && vala_expression_get_static_type (vala_binary_expression_get_right (expr)) != NULL && VALA_IS_CLASS (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_binary_expression_get_left (expr)))) && VALA_IS_CLASS (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_binary_expression_get_right (expr))))) {
			ValaClass* __temp1168 = NULL;
			ValaClass* left_cl = (__temp1168 = VALA_CLASS (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_binary_expression_get_left (expr)))), (__temp1168 == NULL ? NULL : g_object_ref (__temp1168)));
			ValaClass* __temp1169 = NULL;
			ValaClass* right_cl = (__temp1169 = VALA_CLASS (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_binary_expression_get_right (expr)))), (__temp1169 == NULL ? NULL : g_object_ref (__temp1169)));
			if (left_cl != right_cl) {
				if (vala_data_type_is_subtype_of (VALA_DATA_TYPE (left_cl), VALA_DATA_TYPE (right_cl))) {
					ValaCCodeExpression* __temp1170 = NULL;
					cleft = (__temp1170 = VALA_CCODE_EXPRESSION (vala_instance_cast_new (cleft, VALA_DATA_TYPE (right_cl))), (cleft == NULL ? NULL : (cleft = (g_object_unref (cleft), NULL))), __temp1170);
				} else {
					if (vala_data_type_is_subtype_of (VALA_DATA_TYPE (right_cl), VALA_DATA_TYPE (left_cl))) {
						ValaCCodeExpression* __temp1171 = NULL;
						cright = (__temp1171 = VALA_CCODE_EXPRESSION (vala_instance_cast_new (cright, VALA_DATA_TYPE (left_cl))), (cright == NULL ? NULL : (cright = (g_object_unref (cright), NULL))), __temp1171);
					}
				}
			}
			(left_cl == NULL ? NULL : (left_cl = (g_object_unref (left_cl), NULL)));
			(right_cl == NULL ? NULL : (right_cl = (g_object_unref (right_cl), NULL)));
		}
	}
	ValaCCodeBinaryExpression* __temp1172 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1172 = vala_ccode_binary_expression_new (op, cleft, cright)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp1172 == NULL ? NULL : (__temp1172 = (g_object_unref (__temp1172), NULL)));
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
	(cleft == NULL ? NULL : (cleft = (g_object_unref (cleft), NULL)));
	(cright == NULL ? NULL : (cright = (g_object_unref (cright), NULL)));
}


static void vala_code_generator_real_visit_type_check (ValaCodeVisitor* base, ValaTypeCheck* expr)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_TYPE_CHECK (expr));
	ValaCCodeFunctionCall* ccheck = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (vala_type_reference_get_data_type (vala_type_check_get_type_reference (expr)), "IS_"))));
	vala_ccode_function_call_add_argument (ccheck, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_type_check_get_expression (expr)))));
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccheck)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL)));
}


static void vala_code_generator_real_visit_conditional_expression (ValaCodeVisitor* base, ValaConditionalExpression* expr)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CONDITIONAL_EXPRESSION (expr));
	ValaCCodeConditionalExpression* __temp1173 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1173 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_conditional_expression_get_condition (expr)))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_conditional_expression_get_true_expression (expr)))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_conditional_expression_get_false_expression (expr)))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp1173 == NULL ? NULL : (__temp1173 = (g_object_unref (__temp1173), NULL)));
}


static void vala_code_generator_real_visit_end_lambda_expression (ValaCodeVisitor* base, ValaLambdaExpression* l)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_LAMBDA_EXPRESSION (l));
	ValaCCodeIdentifier* __temp1174 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (l), VALA_CCODE_NODE ((__temp1174 = vala_ccode_identifier_new (vala_method_get_cname (vala_lambda_expression_get_method (l)))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (l)));
	(__temp1174 == NULL ? NULL : (__temp1174 = (g_object_unref (__temp1174), NULL)));
}


static void vala_code_generator_real_visit_end_assignment (ValaCodeVisitor* base, ValaAssignment* a)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_ASSIGNMENT (a));
	ValaMemberAccess* ma = NULL;
	if (VALA_IS_MEMBER_ACCESS (vala_assignment_get_left (a))) {
		ValaMemberAccess* __temp1176 = NULL;
		ValaMemberAccess* __temp1175 = NULL;
		ma = (__temp1176 = (__temp1175 = VALA_MEMBER_ACCESS (vala_assignment_get_left (a)), (__temp1175 == NULL ? NULL : g_object_ref (__temp1175))), (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), __temp1176);
	}
	if (vala_expression_get_symbol_reference (vala_assignment_get_left (a)) != NULL && VALA_IS_PROPERTY (vala_symbol_get_node (vala_expression_get_symbol_reference (vala_assignment_get_left (a))))) {
		ValaProperty* __temp1177 = NULL;
		ValaProperty* prop = (__temp1177 = VALA_PROPERTY (vala_symbol_get_node (vala_expression_get_symbol_reference (vala_assignment_get_left (a)))), (__temp1177 == NULL ? NULL : g_object_ref (__temp1177)));
		if (self->priv->current_class != NULL && vala_member_access_get_inner (ma) == NULL && self->priv->in_creation_method) {
			/* this property is used as a construction parameter*/
			ValaCCodeIdentifier* cpointer = vala_ccode_identifier_new ("__params_it");
			ValaCCodeCommaExpression* ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
			/* set name in array for current parameter*/
			ValaCCodeMemberAccess* cnamemember = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (cpointer), "name");
			ValaCCodeAssignment* cnameassign = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cnamemember), VALA_CCODE_EXPRESSION (vala_property_get_canonical_cconstant (prop)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cnameassign));
			ValaCCodeUnaryExpression* gvaluearg = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (cpointer), "value")));
			/* initialize GValue in array for current parameter*/
			ValaCCodeFunctionCall* cvalueinit = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_value_init")));
			vala_ccode_function_call_add_argument (cvalueinit, VALA_CCODE_EXPRESSION (gvaluearg));
			ValaCCodeIdentifier* __temp1178 = NULL;
			vala_ccode_function_call_add_argument (cvalueinit, VALA_CCODE_EXPRESSION ((__temp1178 = vala_ccode_identifier_new (vala_data_type_get_type_id (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)))))));
			(__temp1178 == NULL ? NULL : (__temp1178 = (g_object_unref (__temp1178), NULL)));
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cvalueinit));
			/* set GValue for current parameter*/
			ValaCCodeFunctionCall* cvalueset = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_code_generator_get_value_setter_function (self, vala_property_get_type_reference (prop))));
			vala_ccode_function_call_add_argument (cvalueset, VALA_CCODE_EXPRESSION (gvaluearg));
			vala_ccode_function_call_add_argument (cvalueset, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_right (a)))));
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cvalueset));
			/* move pointer to next parameter in array*/
			ValaCCodeUnaryExpression* __temp1179 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp1179 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, VALA_CCODE_EXPRESSION (cpointer)))));
			(__temp1179 == NULL ? NULL : (__temp1179 = (g_object_unref (__temp1179), NULL)));
			(vala_code_node_set_ccodenode (VALA_CODE_NODE (a), VALA_CCODE_NODE (ccomma)), vala_code_node_get_ccodenode (VALA_CODE_NODE (a)));
			(cpointer == NULL ? NULL : (cpointer = (g_object_unref (cpointer), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
			(cnamemember == NULL ? NULL : (cnamemember = (g_object_unref (cnamemember), NULL)));
			(cnameassign == NULL ? NULL : (cnameassign = (g_object_unref (cnameassign), NULL)));
			(gvaluearg == NULL ? NULL : (gvaluearg = (g_object_unref (gvaluearg), NULL)));
			(cvalueinit == NULL ? NULL : (cvalueinit = (g_object_unref (cvalueinit), NULL)));
			(cvalueset == NULL ? NULL : (cvalueset = (g_object_unref (cvalueset), NULL)));
		} else {
			ValaCCodeExpression* __temp1180 = NULL;
			ValaCCodeExpression* cexpr = (__temp1180 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_right (a)))), (__temp1180 == NULL ? NULL : g_object_ref (__temp1180)));
			if (!vala_property_get_no_accessor_method (prop) && vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_property_get_type_reference (prop))) && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_right (a))) != NULL && vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) != vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_right (a)))) {
				/* cast is necessary */
				ValaCCodeFunctionCall* ccast = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)), NULL))));
				vala_ccode_function_call_add_argument (ccast, cexpr);
				ValaCCodeExpression* __temp1182 = NULL;
				ValaCCodeFunctionCall* __temp1181 = NULL;
				cexpr = (__temp1182 = VALA_CCODE_EXPRESSION ((__temp1181 = ccast, (__temp1181 == NULL ? NULL : g_object_ref (__temp1181)))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), __temp1182);
				(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
			}
			if (vala_assignment_get_operator (a) != VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
				ValaCCodeBinaryOperator cop;
				if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_BITWISE_OR) {
					cop = VALA_CCODE_BINARY_OPERATOR_BITWISE_OR;
				} else {
					if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_BITWISE_AND) {
						cop = VALA_CCODE_BINARY_OPERATOR_BITWISE_AND;
					} else {
						if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR) {
							cop = VALA_CCODE_BINARY_OPERATOR_BITWISE_XOR;
						} else {
							if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_ADD) {
								cop = VALA_CCODE_BINARY_OPERATOR_PLUS;
							} else {
								if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SUB) {
									cop = VALA_CCODE_BINARY_OPERATOR_MINUS;
								} else {
									if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_MUL) {
										cop = VALA_CCODE_BINARY_OPERATOR_MUL;
									} else {
										if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_DIV) {
											cop = VALA_CCODE_BINARY_OPERATOR_DIV;
										} else {
											if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_PERCENT) {
												cop = VALA_CCODE_BINARY_OPERATOR_MOD;
											} else {
												if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT) {
													cop = VALA_CCODE_BINARY_OPERATOR_SHIFT_LEFT;
												} else {
													if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT) {
														cop = VALA_CCODE_BINARY_OPERATOR_SHIFT_RIGHT;
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
				ValaCCodeExpression* __temp1183 = NULL;
				cexpr = (__temp1183 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (cop, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_left (a)))), VALA_CCODE_EXPRESSION (vala_ccode_parenthesized_expression_new (cexpr)))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), __temp1183);
			}
			ValaCCodeFunctionCall* ccall = vala_code_generator_get_property_set_call (self, prop, ma, cexpr);
			/* assignments are expressions, so return the current property value*/
			ValaCCodeCommaExpression* ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
			/* update property*/
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (ma))));
			/* current property value*/
			(vala_code_node_set_ccodenode (VALA_CODE_NODE (a), VALA_CCODE_NODE (ccomma)), vala_code_node_get_ccodenode (VALA_CODE_NODE (a)));
			(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		}
		(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
	} else {
		if (vala_expression_get_symbol_reference (vala_assignment_get_left (a)) != NULL && VALA_IS_SIGNAL (vala_symbol_get_node (vala_expression_get_symbol_reference (vala_assignment_get_left (a))))) {
			ValaSignal* __temp1184 = NULL;
			ValaSignal* sig = (__temp1184 = VALA_SIGNAL (vala_symbol_get_node (vala_expression_get_symbol_reference (vala_assignment_get_left (a)))), (__temp1184 == NULL ? NULL : g_object_ref (__temp1184)));
			ValaMethod* __temp1185 = NULL;
			ValaMethod* m = (__temp1185 = VALA_METHOD (vala_symbol_get_node (vala_expression_get_symbol_reference (vala_assignment_get_right (a)))), (__temp1185 == NULL ? NULL : g_object_ref (__temp1185)));
			char* connect_func = NULL;
			gboolean disconnect = FALSE;
			if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_ADD) {
				char* __temp1186 = NULL;
				connect_func = (__temp1186 = g_strdup ("g_signal_connect_object"), (connect_func = (g_free (connect_func), NULL)), __temp1186);
				if (!vala_method_get_instance (m)) {
					char* __temp1187 = NULL;
					connect_func = (__temp1187 = g_strdup ("g_signal_connect"), (connect_func = (g_free (connect_func), NULL)), __temp1187);
				}
			} else {
				if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SUB) {
					char* __temp1188 = NULL;
					connect_func = (__temp1188 = g_strdup ("g_signal_handlers_disconnect_matched"), (connect_func = (g_free (connect_func), NULL)), __temp1188);
					disconnect = TRUE;
				} else {
					(vala_code_node_set_error (VALA_CODE_NODE (a), TRUE), vala_code_node_get_error (VALA_CODE_NODE (a)));
					vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (a)), "Specified compound assignment type for signals not supported.");
					(sig == NULL ? NULL : (sig = (g_object_unref (sig), NULL)));
					(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
					(connect_func = (g_free (connect_func), NULL));
					(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
					return;
				}
			}
			ValaCCodeFunctionCall* ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (connect_func)));
			if (vala_member_access_get_inner (ma) != NULL) {
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))));
			} else {
				ValaCCodeIdentifier* __temp1189 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1189 = vala_ccode_identifier_new ("self"))));
				(__temp1189 == NULL ? NULL : (__temp1189 = (g_object_unref (__temp1189), NULL)));
			}
			if (!disconnect) {
				ValaCCodeConstant* __temp1190 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1190 = vala_signal_get_canonical_cconstant (sig))));
				(__temp1190 = (g_object_unref (__temp1190), NULL));
			} else {
				ValaCCodeConstant* __temp1191 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1191 = vala_ccode_constant_new ("G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA"))));
				(__temp1191 == NULL ? NULL : (__temp1191 = (g_object_unref (__temp1191), NULL)));
				/* get signal id*/
				ValaCCodeCommaExpression* ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
				ValaVariableDeclarator* temp_decl = vala_code_generator_get_temp_variable_declarator (self, self->priv->uint_type, TRUE);
				ValaVariableDeclarator* __temp1192 = NULL;
				self->priv->temp_vars = g_list_prepend (self->priv->temp_vars, (__temp1192 = temp_decl, (__temp1192 == NULL ? NULL : g_object_ref (__temp1192))));
				ValaCCodeFunctionCall* parse_call = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_signal_parse_name")));
				ValaCCodeConstant* __temp1193 = NULL;
				vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((__temp1193 = vala_signal_get_canonical_cconstant (sig))));
				(__temp1193 = (g_object_unref (__temp1193), NULL));
				ValaDataType* __temp1194 = NULL;
				ValaDataType* decl_type = (__temp1194 = VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (sig))))), (__temp1194 == NULL ? NULL : g_object_ref (__temp1194)));
				ValaCCodeIdentifier* __temp1195 = NULL;
				vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((__temp1195 = vala_ccode_identifier_new (vala_data_type_get_type_id (decl_type)))));
				(__temp1195 == NULL ? NULL : (__temp1195 = (g_object_unref (__temp1195), NULL)));
				ValaCCodeUnaryExpression* __temp1196 = NULL;
				vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((__temp1196 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl)))))));
				(__temp1196 == NULL ? NULL : (__temp1196 = (g_object_unref (__temp1196), NULL)));
				ValaCCodeConstant* __temp1197 = NULL;
				vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((__temp1197 = vala_ccode_constant_new ("NULL"))));
				(__temp1197 == NULL ? NULL : (__temp1197 = (g_object_unref (__temp1197), NULL)));
				ValaCCodeConstant* __temp1198 = NULL;
				vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((__temp1198 = vala_ccode_constant_new ("FALSE"))));
				(__temp1198 == NULL ? NULL : (__temp1198 = (g_object_unref (__temp1198), NULL)));
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (parse_call));
				ValaCCodeIdentifier* __temp1199 = NULL;
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp1199 = vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl)))));
				(__temp1199 == NULL ? NULL : (__temp1199 = (g_object_unref (__temp1199), NULL)));
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccomma));
				ValaCCodeConstant* __temp1200 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1200 = vala_ccode_constant_new ("0"))));
				(__temp1200 == NULL ? NULL : (__temp1200 = (g_object_unref (__temp1200), NULL)));
				ValaCCodeConstant* __temp1201 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1201 = vala_ccode_constant_new ("NULL"))));
				(__temp1201 == NULL ? NULL : (__temp1201 = (g_object_unref (__temp1201), NULL)));
				(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
				(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
				(parse_call == NULL ? NULL : (parse_call = (g_object_unref (parse_call), NULL)));
				(decl_type == NULL ? NULL : (decl_type = (g_object_unref (decl_type), NULL)));
			}
			ValaCCodeCastExpression* __temp1202 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1202 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_method_get_cname (m))), "GCallback"))));
			(__temp1202 == NULL ? NULL : (__temp1202 = (g_object_unref (__temp1202), NULL)));
			if (vala_method_get_instance (m)) {
				if (VALA_IS_MEMBER_ACCESS (vala_assignment_get_right (a))) {
					ValaMemberAccess* __temp1203 = NULL;
					ValaMemberAccess* right_ma = (__temp1203 = VALA_MEMBER_ACCESS (vala_assignment_get_right (a)), (__temp1203 == NULL ? NULL : g_object_ref (__temp1203)));
					if (vala_member_access_get_inner (right_ma) != NULL) {
						vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (right_ma)))));
					} else {
						ValaCCodeIdentifier* __temp1204 = NULL;
						vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1204 = vala_ccode_identifier_new ("self"))));
						(__temp1204 == NULL ? NULL : (__temp1204 = (g_object_unref (__temp1204), NULL)));
					}
					(right_ma == NULL ? NULL : (right_ma = (g_object_unref (right_ma), NULL)));
				} else {
					if (VALA_IS_LAMBDA_EXPRESSION (vala_assignment_get_right (a))) {
						ValaCCodeIdentifier* __temp1205 = NULL;
						vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1205 = vala_ccode_identifier_new ("self"))));
						(__temp1205 == NULL ? NULL : (__temp1205 = (g_object_unref (__temp1205), NULL)));
					}
				}
				if (!disconnect) {
					ValaCCodeConstant* __temp1206 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1206 = vala_ccode_constant_new ("0"))));
					(__temp1206 == NULL ? NULL : (__temp1206 = (g_object_unref (__temp1206), NULL)));
				}
			} else {
				ValaCCodeConstant* __temp1207 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1207 = vala_ccode_constant_new ("NULL"))));
				(__temp1207 == NULL ? NULL : (__temp1207 = (g_object_unref (__temp1207), NULL)));
			}
			(vala_code_node_set_ccodenode (VALA_CODE_NODE (a), VALA_CCODE_NODE (ccall)), vala_code_node_get_ccodenode (VALA_CODE_NODE (a)));
			(sig == NULL ? NULL : (sig = (g_object_unref (sig), NULL)));
			(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
			(connect_func = (g_free (connect_func), NULL));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		} else {
			/* explicitly use strong reference as ccast gets
			 * unrefed at end of inner block
			 */
			ValaCCodeExpression* __temp1208 = NULL;
			ValaCCodeExpression* rhs = (__temp1208 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_right (a)))), (__temp1208 == NULL ? NULL : g_object_ref (__temp1208)));
			if (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_left (a))) != NULL && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_right (a))) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_left (a)))) && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_right (a))) != vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_left (a)))) {
				ValaCCodeFunctionCall* ccast = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_left (a))), NULL))));
				vala_ccode_function_call_add_argument (ccast, rhs);
				ValaCCodeExpression* __temp1210 = NULL;
				ValaCCodeFunctionCall* __temp1209 = NULL;
				rhs = (__temp1210 = VALA_CCODE_EXPRESSION ((__temp1209 = ccast, (__temp1209 == NULL ? NULL : g_object_ref (__temp1209)))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), __temp1210);
				(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
			}
			gboolean unref_old = (vala_code_generator_get_memory_management (self) && vala_type_reference_get_takes_ownership (vala_expression_get_static_type (vala_assignment_get_left (a))));
			gboolean array = FALSE;
			if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_left (a))))) {
				array = !(VALA_IS_CCODE_CONSTANT (vala_code_generator_get_array_length_cexpression (self, vala_assignment_get_left (a), 1)));
			}
			if (unref_old || array) {
				ValaCCodeCommaExpression* ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
				ValaVariableDeclarator* temp_decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (vala_assignment_get_left (a)), TRUE);
				ValaVariableDeclarator* __temp1211 = NULL;
				self->priv->temp_vars = g_list_prepend (self->priv->temp_vars, (__temp1211 = temp_decl, (__temp1211 == NULL ? NULL : g_object_ref (__temp1211))));
				ValaCCodeAssignment* __temp1212 = NULL;
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp1212 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl))), rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
				(__temp1212 == NULL ? NULL : (__temp1212 = (g_object_unref (__temp1212), NULL)));
				if (unref_old) {
					/* unref old value */
					ValaCCodeExpression* __temp1213 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (__temp1213 = vala_code_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_left (a)))), vala_expression_get_static_type (vala_assignment_get_left (a)))));
					(__temp1213 == NULL ? NULL : (__temp1213 = (g_object_unref (__temp1213), NULL)));
				}
				if (array) {
					ValaCCodeExpression* lhs_array_len = vala_code_generator_get_array_length_cexpression (self, vala_assignment_get_left (a), 1);
					ValaCCodeExpression* rhs_array_len = vala_code_generator_get_array_length_cexpression (self, vala_assignment_get_right (a), 1);
					ValaCCodeAssignment* __temp1214 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp1214 = vala_ccode_assignment_new (lhs_array_len, rhs_array_len, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
					(__temp1214 == NULL ? NULL : (__temp1214 = (g_object_unref (__temp1214), NULL)));
					(lhs_array_len = (g_object_unref (lhs_array_len), NULL));
					(rhs_array_len = (g_object_unref (rhs_array_len), NULL));
				}
				ValaCCodeIdentifier* __temp1215 = NULL;
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp1215 = vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl)))));
				(__temp1215 == NULL ? NULL : (__temp1215 = (g_object_unref (__temp1215), NULL)));
				ValaCCodeExpression* __temp1217 = NULL;
				ValaCCodeCommaExpression* __temp1216 = NULL;
				rhs = (__temp1217 = VALA_CCODE_EXPRESSION ((__temp1216 = ccomma, (__temp1216 == NULL ? NULL : g_object_ref (__temp1216)))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), __temp1217);
				(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
				(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
			}
			ValaCCodeAssignmentOperator cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE;
			if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_BITWISE_OR) {
				cop = VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_OR;
			} else {
				if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_BITWISE_AND) {
					cop = VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_AND;
				} else {
					if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR) {
						cop = VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_XOR;
					} else {
						if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_ADD) {
							cop = VALA_CCODE_ASSIGNMENT_OPERATOR_ADD;
						} else {
							if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SUB) {
								cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SUB;
							} else {
								if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_MUL) {
									cop = VALA_CCODE_ASSIGNMENT_OPERATOR_MUL;
								} else {
									if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_DIV) {
										cop = VALA_CCODE_ASSIGNMENT_OPERATOR_DIV;
									} else {
										if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_PERCENT) {
											cop = VALA_CCODE_ASSIGNMENT_OPERATOR_PERCENT;
										} else {
											if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT) {
												cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SHIFT_LEFT;
											} else {
												if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT) {
													cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SHIFT_RIGHT;
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
			ValaCCodeAssignment* __temp1218 = NULL;
			(vala_code_node_set_ccodenode (VALA_CODE_NODE (a), VALA_CCODE_NODE ((__temp1218 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_left (a)))), rhs, cop)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (a)));
			(__temp1218 == NULL ? NULL : (__temp1218 = (g_object_unref (__temp1218), NULL)));
			(rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL)));
		}
	}
	(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
}


static ValaCCodeFunctionCall* vala_code_generator_get_property_set_call (ValaCodeGenerator* self, ValaProperty* prop, ValaMemberAccess* ma, ValaCCodeExpression* cexpr)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_PROPERTY (prop), NULL);
	g_return_val_if_fail (VALA_IS_MEMBER_ACCESS (ma), NULL);
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (cexpr), NULL);
	ValaClass* __temp1219 = NULL;
	ValaClass* cl = (__temp1219 = VALA_CLASS (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (prop))))), (__temp1219 == NULL ? NULL : g_object_ref (__temp1219)));
	char* set_func = g_strdup ("g_object_set");
	if (!vala_property_get_no_accessor_method (prop)) {
		char* __temp1221 = NULL;
		char* __temp1220 = NULL;
		set_func = (__temp1221 = g_strdup_printf ("%s_set_%s", (__temp1220 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL)), vala_property_get_name (prop)), (set_func = (g_free (set_func), NULL)), __temp1221);
		(__temp1220 = (g_free (__temp1220), NULL));
	}
	ValaCCodeFunctionCall* ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (set_func)));
	/* target instance is first argument */
	ValaCCodeExpression* instance = NULL;
	gboolean req_cast = FALSE;
	if (vala_member_access_get_inner (ma) == NULL) {
		ValaCCodeExpression* __temp1222 = NULL;
		instance = (__temp1222 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), __temp1222);
		/* require casts for inherited properties */
		req_cast = (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (prop))) != self->priv->current_type_symbol);
	} else {
		ValaCCodeExpression* __temp1224 = NULL;
		ValaCCodeExpression* __temp1223 = NULL;
		instance = (__temp1224 = (__temp1223 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))), (__temp1223 == NULL ? NULL : g_object_ref (__temp1223))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), __temp1224);
		/* require casts if the type of the used instance is
		 * different than the type which declared the property */
		req_cast = vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (prop)))) != VALA_CODE_NODE (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_member_access_get_inner (ma))));
	}
	if (req_cast && vala_data_type_is_reference_type ((VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (prop)))))))) {
		ValaCCodeFunctionCall* ccast = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname ((VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (prop)))))), NULL))));
		vala_ccode_function_call_add_argument (ccast, instance);
		ValaCCodeExpression* __temp1226 = NULL;
		ValaCCodeFunctionCall* __temp1225 = NULL;
		instance = (__temp1226 = VALA_CCODE_EXPRESSION ((__temp1225 = ccast, (__temp1225 == NULL ? NULL : g_object_ref (__temp1225)))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), __temp1226);
		(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
	}
	vala_ccode_function_call_add_argument (ccall, instance);
	if (vala_property_get_no_accessor_method (prop)) {
		/* property name is second argument of g_object_set */
		ValaCCodeConstant* __temp1227 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1227 = vala_property_get_canonical_cconstant (prop))));
		(__temp1227 = (g_object_unref (__temp1227), NULL));
	}
	vala_ccode_function_call_add_argument (ccall, cexpr);
	if (vala_property_get_no_accessor_method (prop)) {
		ValaCCodeConstant* __temp1228 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1228 = vala_ccode_constant_new ("NULL"))));
		(__temp1228 == NULL ? NULL : (__temp1228 = (g_object_unref (__temp1228), NULL)));
	}
	ValaCCodeFunctionCall* __temp1229 = NULL;
	return (__temp1229 = ccall, (cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL))), (set_func = (g_free (set_func), NULL)), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), __temp1229);
	(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
	(set_func = (g_free (set_func), NULL));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
}


gboolean vala_code_generator_get_memory_management (ValaCodeGenerator* self)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), FALSE);
	return self->priv->_memory_management;
}


void vala_code_generator_set_memory_management (ValaCodeGenerator* self, gboolean value)
{
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	self->priv->_memory_management = value;
}


static GObject * vala_code_generator_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties)
{
	GObject * obj;
	ValaCodeGeneratorClass * klass;
	GObjectClass * parent_class;
	klass = VALA_CODE_GENERATOR_CLASS (g_type_class_peek (VALA_TYPE_CODE_GENERATOR));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (obj);
	{
		GHashTable* __temp1231 = NULL;
		self->priv->predefined_marshal_list = (__temp1231 = g_hash_table_new (g_str_hash, g_str_equal), (self->priv->predefined_marshal_list == NULL ? NULL : (self->priv->predefined_marshal_list = (g_hash_table_unref (self->priv->predefined_marshal_list), NULL))), __temp1231);
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:VOID"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:BOOLEAN"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:CHAR"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:UCHAR"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:INT"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:UINT"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:LONG"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:ULONG"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:ENUM"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:FLAGS"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:FLOAT"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:DOUBLE"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:STRING"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:POINTER"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:OBJECT"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("STRING:OBJECT,POINTER"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:UINT,POINTER"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("BOOLEAN:FLAGS"), GINT_TO_POINTER (TRUE));
	}
	return obj;
}


static void vala_code_generator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (object);
	switch (property_id) {
		case VALA_CODE_GENERATOR_MEMORY_MANAGEMENT:
		g_value_set_boolean (value, vala_code_generator_get_memory_management (self));
		break;
	}
}


static void vala_code_generator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (object);
	switch (property_id) {
		case VALA_CODE_GENERATOR_MEMORY_MANAGEMENT:
		vala_code_generator_set_memory_management (self, g_value_get_boolean (value));
		break;
	}
}


static void vala_code_generator_class_init (ValaCodeGeneratorClass * klass)
{
	vala_code_generator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCodeGeneratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_code_generator_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_code_generator_set_property;
	G_OBJECT_CLASS (klass)->constructor = vala_code_generator_constructor;
	G_OBJECT_CLASS (klass)->dispose = vala_code_generator_dispose;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_source_file = vala_code_generator_real_visit_begin_source_file;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_source_file = vala_code_generator_real_visit_end_source_file;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_class = vala_code_generator_real_visit_begin_class;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_class = vala_code_generator_real_visit_end_class;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_struct = vala_code_generator_real_visit_begin_struct;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_struct = vala_code_generator_real_visit_end_struct;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_interface = vala_code_generator_real_visit_begin_interface;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_interface = vala_code_generator_real_visit_end_interface;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_enum = vala_code_generator_real_visit_begin_enum;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum_value = vala_code_generator_real_visit_enum_value;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_flags = vala_code_generator_real_visit_begin_flags;
	VALA_CODE_VISITOR_CLASS (klass)->visit_flags_value = vala_code_generator_real_visit_flags_value;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_callback = vala_code_generator_real_visit_end_callback;
	VALA_CODE_VISITOR_CLASS (klass)->visit_member = vala_code_generator_real_visit_member;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constant = vala_code_generator_real_visit_constant;
	VALA_CODE_VISITOR_CLASS (klass)->visit_field = vala_code_generator_real_visit_field;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_method = vala_code_generator_real_visit_begin_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_method = vala_code_generator_real_visit_end_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_creation_method = vala_code_generator_real_visit_begin_creation_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_creation_method = vala_code_generator_real_visit_end_creation_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_formal_parameter = vala_code_generator_real_visit_formal_parameter;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_property = vala_code_generator_real_visit_end_property;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_property_accessor = vala_code_generator_real_visit_begin_property_accessor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_property_accessor = vala_code_generator_real_visit_end_property_accessor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_signal = vala_code_generator_real_visit_end_signal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_constructor = vala_code_generator_real_visit_end_constructor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_block = vala_code_generator_real_visit_begin_block;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_block = vala_code_generator_real_visit_end_block;
	VALA_CODE_VISITOR_CLASS (klass)->visit_empty_statement = vala_code_generator_real_visit_empty_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_declaration_statement = vala_code_generator_real_visit_declaration_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_variable_declarator = vala_code_generator_real_visit_variable_declarator;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_initializer_list = vala_code_generator_real_visit_end_initializer_list;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_full_expression = vala_code_generator_real_visit_end_full_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_expression_statement = vala_code_generator_real_visit_expression_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_if_statement = vala_code_generator_real_visit_if_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_switch_statement = vala_code_generator_real_visit_switch_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_while_statement = vala_code_generator_real_visit_while_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_do_statement = vala_code_generator_real_visit_do_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_for_statement = vala_code_generator_real_visit_for_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_foreach_statement = vala_code_generator_real_visit_end_foreach_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_break_statement = vala_code_generator_real_visit_break_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_continue_statement = vala_code_generator_real_visit_continue_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_return_statement = vala_code_generator_real_visit_begin_return_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_return_statement = vala_code_generator_real_visit_end_return_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_lock_statement = vala_code_generator_real_visit_lock_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_array_creation_expression = vala_code_generator_real_visit_end_array_creation_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_boolean_literal = vala_code_generator_real_visit_boolean_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_character_literal = vala_code_generator_real_visit_character_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_integer_literal = vala_code_generator_real_visit_integer_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_real_literal = vala_code_generator_real_visit_real_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_string_literal = vala_code_generator_real_visit_string_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_null_literal = vala_code_generator_real_visit_null_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_literal_expression = vala_code_generator_real_visit_literal_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_parenthesized_expression = vala_code_generator_real_visit_parenthesized_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_member_access = vala_code_generator_real_visit_member_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_invocation_expression = vala_code_generator_real_visit_end_invocation_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_element_access = vala_code_generator_real_visit_element_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_base_access = vala_code_generator_real_visit_base_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_postfix_expression = vala_code_generator_real_visit_postfix_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_object_creation_expression = vala_code_generator_real_visit_end_object_creation_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_typeof_expression = vala_code_generator_real_visit_typeof_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_unary_expression = vala_code_generator_real_visit_unary_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_cast_expression = vala_code_generator_real_visit_cast_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_pointer_indirection = vala_code_generator_real_visit_pointer_indirection;
	VALA_CODE_VISITOR_CLASS (klass)->visit_addressof_expression = vala_code_generator_real_visit_addressof_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_reference_transfer_expression = vala_code_generator_real_visit_reference_transfer_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_binary_expression = vala_code_generator_real_visit_binary_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_type_check = vala_code_generator_real_visit_type_check;
	VALA_CODE_VISITOR_CLASS (klass)->visit_conditional_expression = vala_code_generator_real_visit_conditional_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_lambda_expression = vala_code_generator_real_visit_end_lambda_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_assignment = vala_code_generator_real_visit_end_assignment;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CODE_GENERATOR_MEMORY_MANAGEMENT, g_param_spec_boolean ("memory-management", "foo", "bar", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_code_generator_init (ValaCodeGenerator * self)
{
	self->priv = VALA_CODE_GENERATOR_GET_PRIVATE (self);
	self->priv->next_temp_var_id = 0;
	self->priv->in_creation_method = FALSE;
	self->priv->in_plugin = FALSE;
}


static void vala_code_generator_dispose (GObject * obj)
{
	ValaCodeGenerator * self = VALA_CODE_GENERATOR (obj);
	(self->priv->context == NULL ? NULL : (self->priv->context = (g_object_unref (self->priv->context), NULL)));
	(self->priv->root_symbol == NULL ? NULL : (self->priv->root_symbol = (g_object_unref (self->priv->root_symbol), NULL)));
	(self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL)));
	(self->priv->current_type_symbol == NULL ? NULL : (self->priv->current_type_symbol = (g_object_unref (self->priv->current_type_symbol), NULL)));
	(self->priv->current_class == NULL ? NULL : (self->priv->current_class = (g_object_unref (self->priv->current_class), NULL)));
	(self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL)));
	(self->priv->header_begin == NULL ? NULL : (self->priv->header_begin = (g_object_unref (self->priv->header_begin), NULL)));
	(self->priv->header_type_declaration == NULL ? NULL : (self->priv->header_type_declaration = (g_object_unref (self->priv->header_type_declaration), NULL)));
	(self->priv->header_type_definition == NULL ? NULL : (self->priv->header_type_definition = (g_object_unref (self->priv->header_type_definition), NULL)));
	(self->priv->header_type_member_declaration == NULL ? NULL : (self->priv->header_type_member_declaration = (g_object_unref (self->priv->header_type_member_declaration), NULL)));
	(self->priv->source_begin == NULL ? NULL : (self->priv->source_begin = (g_object_unref (self->priv->source_begin), NULL)));
	(self->priv->source_include_directives == NULL ? NULL : (self->priv->source_include_directives = (g_object_unref (self->priv->source_include_directives), NULL)));
	(self->priv->source_type_member_declaration == NULL ? NULL : (self->priv->source_type_member_declaration = (g_object_unref (self->priv->source_type_member_declaration), NULL)));
	(self->priv->source_signal_marshaller_declaration == NULL ? NULL : (self->priv->source_signal_marshaller_declaration = (g_object_unref (self->priv->source_signal_marshaller_declaration), NULL)));
	(self->priv->source_type_member_definition == NULL ? NULL : (self->priv->source_type_member_definition = (g_object_unref (self->priv->source_type_member_definition), NULL)));
	(self->priv->instance_init_fragment == NULL ? NULL : (self->priv->instance_init_fragment = (g_object_unref (self->priv->instance_init_fragment), NULL)));
	(self->priv->instance_dispose_fragment == NULL ? NULL : (self->priv->instance_dispose_fragment = (g_object_unref (self->priv->instance_dispose_fragment), NULL)));
	(self->priv->source_signal_marshaller_definition == NULL ? NULL : (self->priv->source_signal_marshaller_definition = (g_object_unref (self->priv->source_signal_marshaller_definition), NULL)));
	(self->priv->module_init_fragment == NULL ? NULL : (self->priv->module_init_fragment = (g_object_unref (self->priv->module_init_fragment), NULL)));
	(self->priv->instance_struct == NULL ? NULL : (self->priv->instance_struct = (g_object_unref (self->priv->instance_struct), NULL)));
	(self->priv->type_struct == NULL ? NULL : (self->priv->type_struct = (g_object_unref (self->priv->type_struct), NULL)));
	(self->priv->instance_priv_struct == NULL ? NULL : (self->priv->instance_priv_struct = (g_object_unref (self->priv->instance_priv_struct), NULL)));
	(self->priv->prop_enum == NULL ? NULL : (self->priv->prop_enum = (g_object_unref (self->priv->prop_enum), NULL)));
	(self->priv->cenum == NULL ? NULL : (self->priv->cenum = (g_object_unref (self->priv->cenum), NULL)));
	(self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL)));
	(self->priv->block == NULL ? NULL : (self->priv->block = (g_object_unref (self->priv->block), NULL)));
	(self->priv->temp_vars == NULL ? NULL : (self->priv->temp_vars = (g_list_foreach (self->priv->temp_vars, (GFunc) g_object_unref, NULL), g_list_free (self->priv->temp_vars), NULL)));
	(self->priv->temp_ref_vars == NULL ? NULL : (self->priv->temp_ref_vars = (g_list_foreach (self->priv->temp_ref_vars, (GFunc) g_object_unref, NULL), g_list_free (self->priv->temp_ref_vars), NULL)));
	(self->priv->user_marshal_list == NULL ? NULL : (self->priv->user_marshal_list = (g_hash_table_unref (self->priv->user_marshal_list), NULL)));
	(self->priv->predefined_marshal_list == NULL ? NULL : (self->priv->predefined_marshal_list = (g_hash_table_unref (self->priv->predefined_marshal_list), NULL)));
	(self->priv->bool_type == NULL ? NULL : (self->priv->bool_type = (g_object_unref (self->priv->bool_type), NULL)));
	(self->priv->char_type == NULL ? NULL : (self->priv->char_type = (g_object_unref (self->priv->char_type), NULL)));
	(self->priv->unichar_type == NULL ? NULL : (self->priv->unichar_type = (g_object_unref (self->priv->unichar_type), NULL)));
	(self->priv->short_type == NULL ? NULL : (self->priv->short_type = (g_object_unref (self->priv->short_type), NULL)));
	(self->priv->ushort_type == NULL ? NULL : (self->priv->ushort_type = (g_object_unref (self->priv->ushort_type), NULL)));
	(self->priv->int_type == NULL ? NULL : (self->priv->int_type = (g_object_unref (self->priv->int_type), NULL)));
	(self->priv->uint_type == NULL ? NULL : (self->priv->uint_type = (g_object_unref (self->priv->uint_type), NULL)));
	(self->priv->long_type == NULL ? NULL : (self->priv->long_type = (g_object_unref (self->priv->long_type), NULL)));
	(self->priv->ulong_type == NULL ? NULL : (self->priv->ulong_type = (g_object_unref (self->priv->ulong_type), NULL)));
	(self->priv->int64_type == NULL ? NULL : (self->priv->int64_type = (g_object_unref (self->priv->int64_type), NULL)));
	(self->priv->uint64_type == NULL ? NULL : (self->priv->uint64_type = (g_object_unref (self->priv->uint64_type), NULL)));
	(self->priv->string_type == NULL ? NULL : (self->priv->string_type = (g_object_unref (self->priv->string_type), NULL)));
	(self->priv->float_type == NULL ? NULL : (self->priv->float_type = (g_object_unref (self->priv->float_type), NULL)));
	(self->priv->double_type == NULL ? NULL : (self->priv->double_type = (g_object_unref (self->priv->double_type), NULL)));
	(self->priv->list_type == NULL ? NULL : (self->priv->list_type = (g_object_unref (self->priv->list_type), NULL)));
	(self->priv->slist_type == NULL ? NULL : (self->priv->slist_type = (g_object_unref (self->priv->slist_type), NULL)));
	(self->priv->mutex_type == NULL ? NULL : (self->priv->mutex_type = (g_object_unref (self->priv->mutex_type), NULL)));
	(self->priv->type_module_type == NULL ? NULL : (self->priv->type_module_type = (g_object_unref (self->priv->type_module_type), NULL)));
	(self->priv->module_init_param_name = (g_free (self->priv->module_init_param_name), NULL));
	ValaCodeGeneratorClass * klass;
	GObjectClass * parent_class;
	klass = VALA_CODE_GENERATOR_CLASS (g_type_class_peek (VALA_TYPE_CODE_GENERATOR));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_code_generator_get_type ()
{
	static GType vala_code_generator_type_id = 0;
	if (G_UNLIKELY (vala_code_generator_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCodeGeneratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_code_generator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCodeGenerator), 0, (GInstanceInitFunc) vala_code_generator_init };
		vala_code_generator_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaCodeGenerator", &g_define_type_info, 0);
	}
	return vala_code_generator_type_id;
}




