/* valaccodeoncesection.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valaccodeoncesection.h"
#include <ccode/valaccodeoncesection.h>
#include <ccode/valaccodenode.h>

struct _ValaCCodeOnceSectionPrivate {
	char* _define;
};
#define VALA_CCODE_ONCE_SECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_ONCE_SECTION, ValaCCodeOnceSectionPrivate))
enum  {
	VALA_CCODE_ONCE_SECTION_DUMMY_PROPERTY,
	VALA_CCODE_ONCE_SECTION_DEFINE,
};
static void vala_ccode_once_section_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_once_section_parent_class = NULL;
static void vala_ccode_once_section_dispose (GObject * obj);


ValaCCodeOnceSection* vala_ccode_once_section_new (const char* def)
{
	g_return_val_if_fail (def != NULL, NULL);
	GParameter * __params = g_new0 (GParameter, 1);
	GParameter * __params_it = __params;
	(__params_it->name = "define", g_value_init (&__params_it->value, G_TYPE_STRING), g_value_set_string (&__params_it->value, def), __params_it++);
	ValaCCodeOnceSection * self = g_object_newv (VALA_TYPE_CCODE_ONCE_SECTION, __params_it - __params, __params);
	return self;
}


static void vala_ccode_once_section_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer)
{
	ValaCCodeOnceSection * self = VALA_CCODE_ONCE_SECTION (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	vala_ccode_writer_write_indent (writer);
	vala_ccode_writer_write_string (writer, "#ifndef ");
	vala_ccode_writer_write_string (writer, vala_ccode_once_section_get_define (self));
	vala_ccode_writer_write_newline (writer);
	vala_ccode_writer_write_string (writer, "#define ");
	vala_ccode_writer_write_string (writer, vala_ccode_once_section_get_define (self));
	vala_ccode_writer_write_newline (writer);
	{
		GList* __temp0 = NULL;
		__temp0 = vala_ccode_fragment_get_children (VALA_CCODE_FRAGMENT (self));
		GList* node_it;
		for (node_it = __temp0; node_it != NULL; node_it = node_it->next) {
			ValaCCodeNode* node = node_it->data;
			{
				vala_ccode_node_write (node, writer);
			}
		}
		(__temp0 == NULL ? NULL : (__temp0 = (g_list_free (__temp0), NULL)));
	}
	vala_ccode_writer_write_indent (writer);
	vala_ccode_writer_write_string (writer, "#endif");
	vala_ccode_writer_write_newline (writer);
}


char* vala_ccode_once_section_get_define (ValaCCodeOnceSection* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_ONCE_SECTION (self), NULL);
	return self->priv->_define;
}


void vala_ccode_once_section_set_define (ValaCCodeOnceSection* self, const char* value)
{
	g_return_if_fail (VALA_IS_CCODE_ONCE_SECTION (self));
	char* __temp2 = NULL;
	self->priv->_define = (__temp2 = g_strdup (value), (self->priv->_define = (g_free (self->priv->_define), NULL)), __temp2);
}


static void vala_ccode_once_section_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaCCodeOnceSection * self = VALA_CCODE_ONCE_SECTION (object);
	switch (property_id) {
		case VALA_CCODE_ONCE_SECTION_DEFINE:
		g_value_set_string (value, vala_ccode_once_section_get_define (self));
		break;
	}
}


static void vala_ccode_once_section_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaCCodeOnceSection * self = VALA_CCODE_ONCE_SECTION (object);
	switch (property_id) {
		case VALA_CCODE_ONCE_SECTION_DEFINE:
		vala_ccode_once_section_set_define (self, g_value_get_string (value));
		break;
	}
}


static void vala_ccode_once_section_class_init (ValaCCodeOnceSectionClass * klass)
{
	vala_ccode_once_section_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeOnceSectionPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_once_section_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_once_section_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_once_section_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_once_section_real_write;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_ONCE_SECTION_DEFINE, g_param_spec_string ("define", "foo", "bar", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_ccode_once_section_init (ValaCCodeOnceSection * self)
{
	self->priv = VALA_CCODE_ONCE_SECTION_GET_PRIVATE (self);
}


static void vala_ccode_once_section_dispose (GObject * obj)
{
	ValaCCodeOnceSection * self = VALA_CCODE_ONCE_SECTION (obj);
	(self->priv->_define = (g_free (self->priv->_define), NULL));
	ValaCCodeOnceSectionClass * klass;
	GObjectClass * parent_class;
	klass = VALA_CCODE_ONCE_SECTION_CLASS (g_type_class_peek (VALA_TYPE_CCODE_ONCE_SECTION));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_ccode_once_section_get_type ()
{
	static GType vala_ccode_once_section_type_id = 0;
	if (G_UNLIKELY (vala_ccode_once_section_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeOnceSectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_once_section_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeOnceSection), 0, (GInstanceInitFunc) vala_ccode_once_section_init };
		vala_ccode_once_section_type_id = g_type_register_static (VALA_TYPE_CCODE_FRAGMENT, "ValaCCodeOnceSection", &g_define_type_info, 0);
	}
	return vala_ccode_once_section_type_id;
}




