/* valaccodeinitializerlist.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valaccodeinitializerlist.h"
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodeinitializerlist.h>
#include <ccode/valaccodenode.h>

struct _ValaCCodeInitializerListPrivate {
	GList* initializers;
};
#define VALA_CCODE_INITIALIZER_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_INITIALIZER_LIST, ValaCCodeInitializerListPrivate))
enum  {
	VALA_CCODE_INITIALIZER_LIST_DUMMY_PROPERTY,
};
static void vala_ccode_initializer_list_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_initializer_list_parent_class = NULL;
static void vala_ccode_initializer_list_dispose (GObject * obj);


/**
 * Appends the specified expression to this initializer list.
 *
 * @param expr an expression
 */
void vala_ccode_initializer_list_append (ValaCCodeInitializerList* self, ValaCCodeExpression* expr)
{
	g_return_if_fail (VALA_IS_CCODE_INITIALIZER_LIST (self));
	g_return_if_fail (VALA_IS_CCODE_EXPRESSION (expr));
	self->priv->initializers = g_list_append (self->priv->initializers, g_object_ref (expr));
}


static void vala_ccode_initializer_list_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer)
{
	ValaCCodeInitializerList * self = VALA_CCODE_INITIALIZER_LIST (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	vala_ccode_writer_write_string (writer, "{");
	gboolean first = TRUE;
	{
		GList* __temp0 = NULL;
		__temp0 = self->priv->initializers;
		GList* expr_it;
		for (expr_it = __temp0; expr_it != NULL; expr_it = expr_it->next) {
			ValaCCodeExpression* expr = expr_it->data;
			{
				if (!first) {
					vala_ccode_writer_write_string (writer, ", ");
				} else {
					first = FALSE;
				}
				if (expr != NULL) {
					vala_ccode_node_write (VALA_CCODE_NODE (expr), writer);
				}
			}
		}
	}
	vala_ccode_writer_write_string (writer, "}");
}


static void vala_ccode_initializer_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaCCodeInitializerList * self = VALA_CCODE_INITIALIZER_LIST (object);
	switch (property_id) {
	}
}


static void vala_ccode_initializer_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaCCodeInitializerList * self = VALA_CCODE_INITIALIZER_LIST (object);
	switch (property_id) {
	}
}


static void vala_ccode_initializer_list_class_init (ValaCCodeInitializerListClass * klass)
{
	vala_ccode_initializer_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeInitializerListPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_initializer_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_initializer_list_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_initializer_list_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_initializer_list_real_write;
}


static void vala_ccode_initializer_list_init (ValaCCodeInitializerList * self)
{
	self->priv = VALA_CCODE_INITIALIZER_LIST_GET_PRIVATE (self);
}


static void vala_ccode_initializer_list_dispose (GObject * obj)
{
	ValaCCodeInitializerList * self = VALA_CCODE_INITIALIZER_LIST (obj);
	(self->priv->initializers == NULL ? NULL : (self->priv->initializers = (g_list_foreach (self->priv->initializers, (GFunc) g_object_unref, NULL), g_list_free (self->priv->initializers), NULL)));
	ValaCCodeInitializerListClass * klass;
	GObjectClass * parent_class;
	klass = VALA_CCODE_INITIALIZER_LIST_CLASS (g_type_class_peek (VALA_TYPE_CCODE_INITIALIZER_LIST));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_ccode_initializer_list_get_type ()
{
	static GType vala_ccode_initializer_list_type_id = 0;
	if (G_UNLIKELY (vala_ccode_initializer_list_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeInitializerListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_initializer_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeInitializerList), 0, (GInstanceInitFunc) vala_ccode_initializer_list_init };
		vala_ccode_initializer_list_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION, "ValaCCodeInitializerList", &g_define_type_info, 0);
	}
	return vala_ccode_initializer_list_type_id;
}




